# Modelica library for propulsion & power systems

## License
All library source cords and example models are licensed with GPL v3.

## Purpose & Usage
This is the library of thermo-fluid and thermodynamic calculation components mainly for modeling of aircraft's propulsion system. 
Those components can be used not only in aircraft propulsion but also in other thermo-fluid/thermodynamic system such as turbocharger of automotive engine, air conditioning system, and so on.  

Some models/components of this library are used in models of following other library by same author;  
 -. AircraftDynamics: https://github.com/zeta-plusplus/AircraftDynamics  

## Documentation
link to top-page of documentation (notice under development):  
https://zeta-plusplus.github.io/PropulsionSystem/  

Please also refer to example models in "Examples" package.

## Responsibility
Anybody can use components and example models without any charge for any purpose as long as GPL v3 is not violated. However, please use them with your own responsibility. The autheor cannot take any responsibilty for result of calculation of components and example models.

## Causion
### dependency
Many of models packed in this library depend on following libraries. Please download/clone and load it too.  
 -. FluidSystemComponents(by same author): https://github.com/zeta-plusplus/FluidSystemComponents  
 -. InteractiveSimulation (by same author): https://github.com/zeta-plusplus/InteractiveSimulation  
 -. Modelcia_DeviceDrivers (by Another author. This library is part of default OpenModelica 3rd party library): https://github.com/modelica-3rdparty/Modelica_DeviceDrivers  

### under very active development
many source codes are modified and old unorganized codes are deleted very often. Be causious if you use by cloning the repository. Download of branch named with "stable_" is recommended.


# 自作Modelicaライブラリ 推進・パワーシステム

## ライセンス
すべてのライブラリソースコードおよびExampleモデルはGPL v3ライセンスを付与しています。

## 用途
航空機の推進器モデリング向けに作成した、熱流体力学・熱サイクル計算用ライブラリです。コンポーネントモデルは航空用推進器に限定したものではないので、他の用途にも利用していただけます。例えば、「Compressor」コンポーネントを別途用意したモータモデルに繋いで高圧空気元要素として使う、「Turbine」コンポーネントを自動車過給機のタービンとして使う、と言った使い方が可能です。

## ドキュメンテーション
ドキュメントのトップページへのリンク（多くが工事中）：  
https://zeta-plusplus.github.io/PropulsionSystem/

## 免責
GPL v3が許す範囲内で、本ライブラリの収録物はどなた様でも如何なる目的にもご利用いただけます。しかしながら、ご利用はご自身の責任でお願いします。コンポーネントや例モデルの計算結果による如何なる事象に対しても作者は責任を負いかねますことご了承願います。

## 関連Webページ
http://virtuallabmodelica.blog.jp/
ライブラリ・モデル製作記，解説ページです。使い方Manualの記事は有りませんが，コンポーネント内部の機能やプログラム作成上の思想などを解説しており，参考になれば幸いです。

Copyright (C) zeta-plusplus
