within PropulsionSystem.Elements.BasicElements;

model EnginePerformance00
  import Modelica.Constants;
  import units=Modelica.Units.SI;
  import unitsNonSI=Modelica.Units.NonSI;
  import unitConversions=Modelica.Units.Conversions;
  
  
  /********************************************************
     Declaration
    ********************************************************/
  //********** Package **********
  //##### none #####
  //********** Parameters **********
  //##### none #####
  parameter Boolean use_u_FdScrub = false "" annotation(
    Evaluate = true,
    HideResult = true,
    choices(checkBox = true), Dialog(group = "switch"));
  //********** Internal variables **********
  units.Force Fg;
  units.Force Fram;
  units.Force FdScrub;
  units.MassFlowRate m_flow_fuel;
  units.Force Fn;
  Real TSFC "";
  Real TSFC_Bt "";
  //********** Interfaces **********
  Modelica.Blocks.Interfaces.RealInput u_Fg annotation(
    Placement(visible = true, transformation(origin = {-120, 60}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-110, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput u_Fram annotation(
    Placement(visible = true, transformation(origin = {-120, 20}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-110, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput u_m_flow_fuel annotation(
    Placement(visible = true, transformation(origin = {-120, -60}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-110, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput u_FdScrub if use_u_FdScrub annotation(
    Placement(visible = true, transformation(origin = {-120, -20}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-110, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput y_Fn annotation(
    Placement(visible = true, transformation(origin = {110, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput y_TSFC annotation(
    Placement(visible = true, transformation(origin = {110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput u_TSFC_Bt annotation(
    Placement(visible = true, transformation(origin = {110, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, -60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  //********** Initialization **********
  //##### none #####
  //********** Protected objects **********
  //##### none #####
  /********************************************************
      Model coding
    ********************************************************/
equation
//********** Geometries **********
//##### none #####
//********** Connections, interface <-> internal variables **********
  if (use_u_FdScrub == true) then
    FdScrub = u_FdScrub;
  else
    FdScrub = 0.0;
  end if;
  Fg = u_Fg;
  Fram = u_Fram;
  m_flow_fuel = u_m_flow_fuel;
  y_Fn = Fn;
  y_TSFC = TSFC;
  u_TSFC_Bt = TSFC_Bt;
//********** Eqns describing physics **********
  Fn = Fg - Fram - FdScrub;
  TSFC = m_flow_fuel / Fn;
  TSFC_Bt = TSFC * 2.0;
/********************************************************
  Graphics
********************************************************/

  annotation(
    defaultComponentName="Perf",
    Diagram(coordinateSystem(initialScale = 0.1)),
  Icon(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(origin = {-8, 4}, fillColor = {229, 229, 229}, pattern = LinePattern.None, fillPattern = FillPattern.Solid, extent = {{-92, 96}, {108, -104}}), Text(origin = {-26, 8}, fillColor = {232, 232, 232}, extent = {{-74, 32}, {126, -48}}, textString = "Perf."), Rectangle(origin = {-9, 4}, extent = {{-91, 96}, {109, -104}})}));


end EnginePerformance00;
