within PropulsionSystem.Elements.BasicElements;

model CombustFuel
  import Modelica.Constants;
  /********************************************************
        Declaration
        ********************************************************/
  //********** Package **********
  //##### none #####
  //********** Type definitions, only valid in this class **********
  type switchCausality_GeneratedHeat = enumeration(input_dmFuel "", input_dq "") annotation(
    Documentation(info = "<html>
    </html>"));
  type switch_Combustion_Subelement = enumeration(NoSubelement "", table_effBurn "") annotation(
    Documentation(info = "<html>
    </html>"));
  //********** Parameters **********
  parameter Modelica.SIunits.MassFlowRate dm_fuel_des = 0.30 "" annotation(
    Dialog(group = "Boundary Condition"));
  parameter Modelica.SIunits.SpecificEnthalpy LHV_fuel_des = 42.8 * 10.0 ^ 6.0 "" annotation(
    Dialog(group = "Boundary Condition"));
  parameter Real effBurnDes = 0.9999 "" annotation(
    Dialog(group = "Characteristics"));
  //----- switches -----
  parameter switchCausality_GeneratedHeat switchCausality_dq = switchCausality_GeneratedHeat.input_dq "" annotation(
    Dialog(group = "switch"),
    choicesAllMatching = true,
    Evaluate = true,
    HideResult = true);
  parameter switch_Combustion_Subelement switchSubelement_effBurn = switch_Combustion_Subelement.NoSubelement "" annotation(
    Dialog(group = "switch"),
    choicesAllMatching = true,
    Evaluate = true,
    HideResult = true);
  parameter PropulsionSystem.Types.switches.switch_parameter_input switchInput_dm_fuel = PropulsionSystem.Types.switches.switch_parameter_input.asCalculated "" annotation(
    Dialog(group = "switch"),
    choicesAllMatching = true,
    Evaluate = true,
    HideResult = true);
  parameter PropulsionSystem.Types.switches.switch_parameter_input switchInput_LHV_fuel = PropulsionSystem.Types.switches.switch_parameter_input.use_desValue "" annotation(
    Dialog(group = "switch"),
    choicesAllMatching = true,
    Evaluate = true,
    HideResult = true);
  parameter PropulsionSystem.Types.switches.switch_parameter_input switchInput_effBurn = PropulsionSystem.Types.switches.switch_parameter_input.use_desValue "" annotation(
    Dialog(group = "switch"),
    choicesAllMatching = true,
    Evaluate = true,
    HideResult = true);
  //********** Internal variables **********
  Modelica.SIunits.MassFlowRate dm_fuel(start = dm_fuel_des);
  Modelica.SIunits.SpecificEnthalpy LHV_fuel(start = LHV_fuel_des);
  Real effBurn(start = effBurnDes);
  Modelica.SIunits.HeatFlowRate dq;
  //********** Interfaces **********
  Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_b HeatPort_b annotation(
    Placement(visible = true, transformation(origin = {100, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {100, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  PropulsionSystem.Types.ElementBus elementBus1 annotation(
    Placement(visible = true, transformation(origin = {70, -90}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {70, -90}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput dm_fuel_in if switchInput_dm_fuel == PropulsionSystem.Types.switches.switch_parameter_input.use_inputSignal annotation(
    Placement(visible = true, transformation(origin = {-120, 40}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-110, 50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput LHV_fuel_in if switchInput_LHV_fuel == PropulsionSystem.Types.switches.switch_parameter_input.use_inputSignal annotation(
    Placement(visible = true, transformation(origin = {-120, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-110, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput effBurn_in if switchInput_effBurn == PropulsionSystem.Types.switches.switch_parameter_input.use_inputSignal annotation(
    Placement(visible = true, transformation(origin = {-120, -40}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-110, -31}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput dm_fuel_out annotation(
    Placement(visible = true, transformation(origin = {100, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  //********** Initialization **********
  //##### none #####
  //********** Protected objects **********
  //##### none #####
algorithm
//##### none #####
equation
//********** Geometries **********
//##### none #####
//********** Connections, interface <-> internal variables **********
//--- dm_fuel, dq ---
  if switchCausality_dq == switchCausality_GeneratedHeat.input_dq then
//--
  elseif switchCausality_dq == switchCausality_GeneratedHeat.input_dmFuel then
//--
    if switchInput_dm_fuel == PropulsionSystem.Types.switches.switch_parameter_input.use_desValue then
      dm_fuel = dm_fuel_des;
    elseif switchInput_dm_fuel == PropulsionSystem.Types.switches.switch_parameter_input.use_inputSignal then
      dm_fuel = dm_fuel_in;
    end if;
  end if;
//--- LHV_fuel ---
  if switchInput_LHV_fuel == PropulsionSystem.Types.switches.switch_parameter_input.use_desValue then
    LHV_fuel = LHV_fuel_des;
  elseif switchInput_LHV_fuel == PropulsionSystem.Types.switches.switch_parameter_input.use_inputSignal then
    LHV_fuel = LHV_fuel_in;
  end if;
//--- effBurn ---
  if switchInput_effBurn == PropulsionSystem.Types.switches.switch_parameter_input.use_desValue then
    effBurn = effBurnDes;
  elseif switchInput_effBurn == PropulsionSystem.Types.switches.switch_parameter_input.use_inputSignal then
    effBurn = effBurn_in;
  end if;
//--
  dm_fuel_out = dm_fuel;
  (-1)*HeatPort_b.Q_flow = dq;
//********** Eqns describing physics **********
  dq = dm_fuel * LHV_fuel * effBurn;
/********************************************************
  Graphics
********************************************************/
  annotation(
    Icon(graphics = {Rectangle(origin = {-9, -1}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-91, 61}, {69, -59}}), Line(origin = {59.5487, -15.3201}, points = {{31, 15}, {3, 15}}, thickness = 2, arrow = {Arrow.Open, Arrow.None}, arrowSize = 7), Text(origin = {-25, -76}, fillColor = {255, 255, 255}, extent = {{-75, 8}, {85, -24}}, textString = "%name"), Bitmap(origin = {-45, 51}, extent = {{125, -119}, {-55, 49}}, imageSource = "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"), Line(origin = {84.238, -40.119}, points = {{-18, 0}, {18, 0}, {18, 0}}), Line(origin = {70.48, -79.008}, points = {{0, 12}, {0, -12}}),
    
    Rectangle(lineColor = {255, 0, 0}, fillColor = {255, 0, 0}, lineThickness = 4, extent = {{-100, 100}, {100, -100}}), Line(points = {{-100, 100}, {100, -100}}, color = {255, 0, 0}, thickness = 4)}, 
    
    coordinateSystem(initialScale = 0.1)));
end CombustFuel;
