﻿within ClaRa_Obsolete.Basics.ControlVolumes.Fundamentals.Geometry;
model Condenser "Block shape || Shell with tubes || Hotwell || Vertical flow || Perpendicular tubes"
  //___________________________________________________________________________//
  // Component of the ClaRa library, version: 1.0.0                        //
  //                                                                           //
  // Licensed by the DYNCAP research team under Modelica License 2.            //
  // Copyright © 2013-2015, DYNCAP research team.                                   //
  //___________________________________________________________________________//
  // DYNCAP is a research project supported by the German Federal Ministry of  //
  // Economics and Technology (FKZ 03ET2009).                                  //
  // The DYNCAP research team consists of the following project partners:      //
  // Institute of Energy Systems (Hamburg University of Technology),           //
  // Institute of Thermo-Fluid Dynamics (Hamburg University of Technology),    //
  // TLK-Thermo GmbH (Braunschweig, Germany),                                  //
  // XRG Simulation GmbH (Hamburg, Germany).                                   //
  //___________________________________________________________________________//

  extends ClaRa.Basics.ControlVolumes.Fundamentals.Geometry.HollowBlockWithTubesAndHotwell(
    final N_passes=1,
    flowOrientation=ClaRa.Basics.Choices.GeometryOrientation.vertical,
    tubeOrientation=if ((false) == false and (ClaRa.Basics.Choices.GeometryOrientation.vertical) == ClaRa.Basics.Choices.GeometryOrientation.horizontal) then 1 elseif ((false) == false and (ClaRa.Basics.Choices.GeometryOrientation.vertical) == ClaRa.Basics.Choices.GeometryOrientation.vertical) then 0 elseif ((false) == true and (ClaRa.Basics.Choices.GeometryOrientation.vertical) == ClaRa.Basics.Choices.GeometryOrientation.vertical) then 2 elseif ((false) == true and (ClaRa.Basics.Choices.GeometryOrientation.vertical) == ClaRa.Basics.Choices.GeometryOrientation.horizontal) then 0 else 0);

  annotation (Icon(graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
            "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",
          fileName="modelica://ClaRa/figures/Components/CondenserGeometry2.png"),
                                          Polygon(
          points={{-100,-100},{100,100},{-100,-100}},
          lineColor={255,0,0},
          smooth=Smooth.None,
          fillColor={102,198,0},
          fillPattern=FillPattern.Solid),Polygon(
          points={{-100,100},{100,-100},{-100,100}},
          lineColor={255,0,0},
          smooth=Smooth.None,
          fillColor={102,198,0},
          fillPattern=FillPattern.Solid),
        Text(
          extent={{-80,-60},{80,-100}},
          lineColor={238,46,47},
          textString="Supported until ClaRa 1.3.0")}));

end Condenser;
