﻿within ClaRa.Components.TurboMachines.Compressors.BaseClasses;
partial model partialFan

//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//


  import ClaRa;
// ***************************** defintion of medium used in cell *************************************************
protected
  outer ClaRa.SimCenter simCenter;
public
  inner parameter TILMedia.Gas.Types.BaseGas medium=simCenter.flueGasModel "Medium to be used" annotation (choices(
        choice=simCenter.flueGasModel "Gas model as defined in simCenter"), Dialog(group="Media Definitions"));

/******************** Connectors *****************************/

public
 ClaRa.Basics.Interfaces.GasPortIn      gasPortIn(Medium = medium)
    annotation (Placement(transformation(extent={{-10,-110},{10,-90}}),
        iconTransformation(extent={{-10,-110},{10,-90}})));
  ClaRa.Basics.Interfaces.GasPortOut      gasPortOut(Medium = medium)
    annotation (Placement(transformation(extent={{-10,90},{10,110}}),
        iconTransformation(extent={{-10,90},{10,110}})));
/****************** Gas object *************************/
protected
  TILMedia.Gas.Gas_pT gas(
    p=(gasPortIn.p + gasPortOut.p)/2,
    T=noEvent(actualStream(gasPortIn.T_outflow)),
    xi=noEvent(actualStream(gasPortIn.xi_outflow)),
    final gasType=medium,
    computeTransportProperties=false) "Gas in fan"
    annotation (Placement(transformation(extent={{-10,-10},{10,10}}, rotation=0)));
/****************** Start Values ********************/

 parameter ClaRa.Basics.Units.MassFlowRate m_flow_start = 1e-3 "Mass flow rate at start"
                              annotation(Dialog(tab="Start Values"));
/****************** Additional variables **************/
public
  ClaRa.Basics.Units.Pressure Delta_p(final start=100) "pressure increase";
  ClaRa.Basics.Units.Power P_hyd "Hydraulic power";
  ClaRa.Basics.Units.Power P_drive "Drive power";
  ClaRa.Basics.Units.VolumeFlowRate V_flow;

equation
  Delta_p = gasPortOut.p - gasPortIn.p;

  annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2024.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under the 3-clause BSD License.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/pdf/CLA.pdf\">https://claralib.com/pdf/CLA.pdf</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under the 3-clause BSD License.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
revisions=
        "<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),Diagram(coordinateSystem(preserveAspectRatio=false,extent={{-100,-100},
            {100,100}}),
                       graphics),
                             Icon(coordinateSystem(preserveAspectRatio=false,
          extent={{-100,-100},{100,100}}),
                                       graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
              "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"
               +
              "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"
               +
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/Compressor.png",
          origin={0,0},
          rotation=90)}));
end partialFan;
