﻿within ClaRa.Basics.Icons;
model TubeWithWall_L4
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//

  annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-140,-60},{140,60}}), graphics={Bitmap(
          extent={{-140,-60},{140,60}},
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/TubeWithWall_L4.png")}),     Diagram(graphics,
                                                                                            coordinateSystem(preserveAspectRatio=false, extent={{-120,-60},{140,60}})));

end TubeWithWall_L4;
