﻿within ClaRa.Basics.Icons;
model RollerBowlMill

  annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
            -100},{100,100}}), graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/RollwerBowlMill.png")}));

end RollerBowlMill;
