﻿within ClaRa.Basics.Icons.PackageIcons;
model FuelPackage "Usable fuels below:"

  annotation (Icon(graphics={
        Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/Fuel.png")}));
end FuelPackage;
