﻿within ClaRa.Basics.Icons;
model Motor

  annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
            -100},{100,100}}), graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/Motor.png")}));

end Motor;
