﻿within ClaRa.Basics.Icons;
model HEX05
//___________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                            //
//                                                                           //
// Licensed by the DYNCAP/DYNSTART research team under the 3-clause BSD License.   //
// Copyright  2013-2021, DYNCAP/DYNSTART research team.                      //
//___________________________________________________________________________//
// DYNCAP and DYNSTART are research projects supported by the German Federal //
// Ministry of Economic Affairs and Energy (FKZ 03ET2009/FKZ 03ET7060).      //
// The research team consists of the following project partners:             //
// Institute of Energy Systems (Hamburg University of Technology),           //
// Institute of Thermo-Fluid Dynamics (Hamburg University of Technology),    //
// TLK-Thermo GmbH (Braunschweig, Germany),                                  //
// XRG Simulation GmbH (Hamburg, Germany).                                   //
//___________________________________________________________________________//

  annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
            -100},{100,100}}),
                   graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/HEX05.png")}));

end HEX05;
