﻿within ClaRa.Basics.Icons;
model FeedwaterTank
//___________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                            //
//                                                                           //
// Licensed by the DYNCAP/DYNSTART research team under the 3-clause BSD License.   //
// Copyright  2013-2021, DYNCAP/DYNSTART research team.                      //
//___________________________________________________________________________//
// DYNCAP and DYNSTART are research projects supported by the German Federal //
// Ministry of Economic Affairs and Energy (FKZ 03ET2009/FKZ 03ET7060).      //
// The research team consists of the following project partners:             //
// Institute of Energy Systems (Hamburg University of Technology),           //
// Institute of Thermo-Fluid Dynamics (Hamburg University of Technology),    //
// TLK-Thermo GmbH (Braunschweig, Germany),                                  //
// XRG Simulation GmbH (Hamburg, Germany).                                   //
//___________________________________________________________________________//

  annotation (Icon(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-300,-100},{300,100}},
        initialScale=0.1),
                   graphics={Bitmap(
          extent={{-300,-100},{300,100}},
          imageSource=
              "iVBORw0KGgoAAAANSUhEUgAABpAAAAIwCAYAAACBcCg8AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAACAASURBVHic7N17kN93Xe/x128vyeaym2RIWpr90ZCk323aH6Vpk7Z0em+BAIMISKecFsKpZ2CsyHAEe7hZLVZAEUQHFYQ5BwX1yMjxdhgROVAoOCoWKOgK7UoR3bRKcSApvSZNzh+7lH5LLrub3+f33cvjMbOTJcl+3u90hkx3nv18v61Dhw4FAABgvmpXnf4kT0iyIcn66R83TP/cUJJlSZYf4cfZ/lqSPJzkocf9eLifm8mvPZjkP5PcM/3x7ekf/3NyYvyR7v1TAgAA6K6WgAQAAPRSu+qsyA8i0PoZfL4uSauRZcs5lOQ7+eGwdMTPJyfGH2hmVQAAYCkSkAAAgK5rV50Tk5xymI+tmQpCzN53knw9yT8//mNyYvw/mlwMAABYfAQkAABg1tpVp5VkY44ciYab225JujdHiEtJ7pqcGPeNHwAAMCsCEgAAcFTtqrM2yc7pj3OSjCXZkmRlk3sxY/cnuTPJHUn+PsmtSW6dnBj/bqNbAQAA85qABAAAPKpddVYnOStToej7wWhrFt87iJa6Q5m6sfT9oPT3Sb40OTH+vUa3AgAA5g0BCQAAlqh21RlKcmZ+EIp2JjktSV+Te9GYg0m+mh8EpVuTfHlyYvzBRrcCAAAaISABAMAS0a46K5JcmmRXkouTPCXJYJM7Me/tT/KPSW5J8vEkn56cGH+g2ZUAAIBeEJAAAGARa1ed05I8a/rj4iRDzW7EAvdgpmLSXyb5y8mJ8a82vA8AAFCIgAQAAItIu+qMJLkiP4hGJze7EYvcv2Y6JiX55OTE+L6G9wEAALpEQAIAgAWsXXVaSc7KD4LR+UkGGl2KpepAkr/JD4LSlyYnxn3DCQAAC5SABAAAC1C76owleUmSa5JsaXgdOJw7k/x+kt+bnBi/o+llAACA2RGQAABggWhXnQ1Jrkry0iTnNrwOzMbnk3woyYcnJ8bvaXoZAADg2AQkAACYx9pVZ0WS52XqttGz4vF0LGwHMvV4u99L8ueTE+MPNLwPAABwBAISAADMM9PvNbo0UzeNfizJSKMLQRn7kvyfTN1M+rT3JQEAwPwiIAEAwDwxfdtod5LXJBlreB3opTuS/GqSD7qVBAAA84OABAAADZt+t9Erk/xkkg0NrwNNuifJbyX5Te9KAgCAZglIAADQkHbVOTVTt412JxlqeB2YTx5M8sEkvzo5MX5708sAAMBSJCABAECPtavOJUlem+S5SVoNrwPz2aEkH03yzsmJ8c80vQwAACwlAhIAAPRIu+o8O8kvJNnZ9C6wAN2a5OcmJ8Y/1vQiAACwFAhIAABQWLvqPDXJO5I8o+ldYBH4RJKfmZwY/0rTiwAAwGImIAEAQCHtqnNSkpuSXJukr+F1YDE5mOQDSW6YnBi/u+llAABgMRKQAACgy9pVZ2WS66c/VjW8zqLV12pl9fDqDK9enYGBgSwbHMzAwEAGBwenPqY/HxgcePTzqY+BDA5M/d5lywZrX5skBw4cyMP790/9+PDUj/sP7M/+/Qeyf//+qY8DB3Lg+//7wA9+/rFfe+/3vpfv3fu9HPQ9V0n3JXl7kndMTozf3/QyAACwmAhIAADQJe2q05fkZUl+McnGhtdZUFqtVlatWpk1I2uyds1I1oyMZM2a6Y/hx3w+MpK1a9ZkzchIhkeG09dqNb36UR08dCj37rs3e/fty3f37s3effuyd+++7N13b/bu2zv1+d5907++L3v37c19990f36fN2l1JfjbJ705OjB9sehkAAFgMBCQAAOiCdtU5NcnvJHlaw6vMS4ODg9l40hMzetJJGR09aerHjRtzwgnrs3ZkTUZGhtPf39/0mvPCI488kn377s139+3Nt7717ey5667sufvu7Nlzd/bcfXfuuvvfs3///qbXnK/+Nsl/nZwYv73pRQAAYKETkAAA4Di0q04ryauTvDXJiobXadTKFSsyOrrxcZFo6mPD+vVpzfPbQgvFoUOHcs+3v509d9099fGYuLRnz125/4EHml6xaQ8keWOSX5+cGPcNLwAAzJGABAAAc9SuOluSfCDJxU3v0ktDy5enOmVrtp1apdq6NU8aHc3o6ElZu2ZN06uR5Lt792bPnrvzb3v2ZOLrX8/Xbp/IxD9/PQ8+9FDTq/XaLUmunZwYv7PpRQAAYCESkAAAYA7aVecnkvxKktVN71LS4MBAtm7ZnFPHqmw7tcppY2N58qaT09fX1/RqzMLBgwfzL9/813z1jjvytdsn8rXb78id3/iX7D9woOnVSvtekusnJ8bf2/QiAACw0AhIAAAwC+2qM5qpW0fPaHqXbuvr68umk5+U004dy6ljVU4bq7J165YMDgw0vRoF7D9wIF//+p356h0Tuf2OiXz19jvyzX/9txw8eLDp1Ur4RKZuI+1pehEAAFgoBCQAAJihdtW5OMlHkmxoepdueeKJJ+bcnWfn3J07smP7U7Nq1aqmV6JB9913X75w21fy+Vu/kM/f+sX8+3/8R9MrddM9SV40OTF+S9OLAADAQiAgAQDADLSrznVJfj3JYNO7HI+hoaGcdeYZOXfHjpy78+w8qT3a9ErMY/82uSefv/WL+fwXvpAvffkf8uCDDza90vHan+TVkxPj72l6EQAAmO8EJAAAOIp21RlM8htJXtH0LnPRarVyypbNOWfH2Tl359k54ykdj6RjTvYfOJB/+MfxfP7WL+bvv/DF/POd38gC/n7yfUl+anJifH/TiwAAwHwlIAEAwBG0q86JmXpk3YVN7zJbndO3ZdcVl+eSCy/IunVrm16HReg73/luPvO5v87HP/mpjP/T15peZy4+l6lH2i2q5/QBAEC3CEgAAHAY7apzZpKPJmk3vctMjW48Kc+84vI884rLMrrxpKbXYQnZc9fd+atP3py/+uSnsueuu5teZzYmkzx3cmL8y00vAgAA842ABAAAj9OuOtuS3JJkQ9O7HMvI8HAuv/Ti7Lri8nRO39b0OpDxf/paPv7JT+VTn74l++69t+l1ZuKeJBdPTowvyGtUAABQioAEAACP0a46m5N8Nslo07scSX9/fy44/7zsevrledq553inEfPS/gMH8ref//t8/P99Kn/9N3+XRx55pOmVjmZPkosmJ8a/0fQiAAAwXwhIAAAwrV11RjMVjzY3vcvhrFq1Kj/ynF258gU/mg3r1ze9DszYPd/+dv7oT/4s//cvPp777ruv6XWO5BuZikh7ml4EAADmAwEJAACStKvOCZl6bN2pTe/yeCeesCFXvvD5ee6zd2XlihVNrwNzdv8DD+SjH/t4/uiP/zT/8a17ml7ncG7P1OPsvtX0IgAA0DQBCQCAJa9dddYluTnJmU3v8ljbxqpc9aIX5tKLLkh/f3/T60DXPPLII/n0Z/86H/7IH+drd0w0vc7jfTnJZZMT499pehEAAGiSgAQAwJLWrjrDST6R5Lymd/m+sVO25rqX/3h2nLW96VWguC986ba85/3/K3f889ebXuWx/i7JMyYnxu9tehEAAGiKgAQAwJLVrjorknwsySVN75IkJ2zYkJdfuzvPvOKytFqtpteBnjl06FD+6pM35/0f+GC+dc+8ebTdZ5I8e3Ji/IGmFwEAgCYISAAALEntqrM8yZ8l2dX0LqtWrsw1L74yV77g+Vm+fFnT60BjHnro4fzRn/xpfv8P/yj33X9/0+skyceT/OjkxPhDTS8CAAC9JiABALAktavOO5K8tskd+vv787znPCvX7r4ma9esaXIVmFe+u3dvPvDB38+f/8Vf5pFHHml6nXdOToz/TNNLAABArwlIAAAsOe2qc36SzyXpa2qHbWNV3nD9T2fzpk1NrQDz3je++c287Vfela/dMdHkGgeTXDg5Mf43TS4BAAC9JiABALCkTL/36LYkY03MHxwYyMtecnWuuepF6e/vb2IFWFAeeeSR/P6HP5Lf/b0/yP4DB5pa444k270PCQCApaSx/+ISAAAa8rY0FI+qrVvyvt/4tey++irxCGaov78/u6++Ku/7jV9LtXVLU2uMZervDgAAWDLcQAIAYMloV51LktycpNXLuX19fdl99VXZffWLMzAw0MvRsKgcOHAgH/yDP8wH/+DDOXjwYK/HH0py2eTE+Gd6PRgAAJogIAEAsCS0q87qJF9JsrmXc0eGh3Pjm16fnWdv7+VYWNRu/eJtufEtv5R9997b69HfSPLUyYnx7/V6MAAA9JpH2AEAsFS8LT2OR5s3bcpvv/td4hF02c6zt+e33/2ubN60qdejN8ej7AAAWCLcQAIAYNFrV51NSSaSDPZq5gXnn5cbXn99Vq5Y0auRsOTc/8ADuemXfiV//Td/18ux+5NUkxPj3+zlUAAA6DU3kAAAWApelx7Go11PvzxvufEG8QgKW7liRd5y4w3Z9fTLezl2MFN/pwAAwKLmBhIAAItau+psTHJnkuW9mHfpRRfmxje9Ln19/lst6JWDBw/mxrf8cj792c/1auRDSbZMTozf1auBAADQa76rBQBgsbs+PYpH5593Tn7uDdeLR9BjfX19+bk3XJ/zzzunVyOXZ+rvFgAAWLR8ZwsAwGL3il4M2XHW9tx0wxszMDDQi3HA4wwMDOSmG96YHWdt79XInvzdAgAATRGQAABY7FaWHnBG5/S87c03ZNmyZaVHAUexbNmyvO3NN+SMzum9GFf87xYAAGiSgAQAAMdh21iVt7/lzRkaGmp6FSDJ0NBQ3v6WN2fbWNX0KgAAsKC1Dh061PQOwALRrjrbk3yp0PFnTU6M31bobACWsHbVKfYvvCMjw/nQ+9+bdevWlhoBzNF3vvPdvPTlP5F9++4tNmNyYrxV7HAAAGiYG0gAADBHr33VK8UjmKfWrVub177qlU2vAQAAC5aABAAAc3DZxRfmsksuanoN4Cguu+SiXHbxhU2vAQAAC5KABAAAc3D29jObXgGYAf9fBQCAuRGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBGQAAAAAAAAqBloegEAAABYiNpVZ3vTOwDA5MT4bU3vACxOAhIAAADMzZeaXgAAkrSaXgBYnDzCDgAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgBoBCQAAAAAAgJqBphcAAACABeqsphcAAIBSBCQAAACYg8mJ8dua3gEAAErxCDsAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBCQAAAAAAABqBppeoJvaVWdjkuuTvCLJyobXAWbnS+2q0/QOAAAwY+2qc6jpHQAAmBfuT/K+JL8yOTF+V9PLdMuiuIHUrjqb2lXnt5LcmeS/RzwCAAAAAAB6Y2Wm2sSd7arzW+2qs6nphbphQQekdtVZ3a46704ykeS6JMsbXgkAAAAAAFialmeqVUy0q86721VnddMLHY8FG5DaVeeSJF9J8lNJBhteBwAAAAAAIJlqFj+V5CvTLWNBWnABqV11VrSrzq8luTnJ5qb3AQAAAAAAOIzNSW5uV51fa1edFU0vM1sLKiC1q875SW5L8uokrYbXAQAAAAAAOJpWpprGbdONY8FYEAGpXXWWt6vOO5J8LslY0/sAAAAAAADMwliSz7WrzjvaVWd508vMxLwPSNPXuv4syWuzAPYFAAAAAAA4jL5MtY4/WwiPtJvXQaZddYaTfCzJrqZ3AQAAAAAA6IJdST423UDmrXkbkNpVZ12STyS5pOldAAAAAAAAuuiSJJ+YbiHz0rwMSO2qc0KSm5Oc1/QuAAAAAAAABZyX5ObpJjLvzLuA1K46o0luSXJm07sAAAAAAAAUdGaSW6bbyLwyrwJSu+psTvLZJKc2vQsAAAAAAEAPnJrks9ONZN6YNwGpXXW2ZSoezat/QAAAAAAAAIVtzlRE2tb0It83LwJSu+qcmanH1s27K1oAAAAAAAA9MJqpx9nNi1f8NB6Q2lXnxCQfTbKh6V0AAAAAAAAatCHJR6fbSaMaDUjtqjOY5CNJ2k3uAQAAAAAAME+0k3xkuqE0pukbSL+R5MKGdwAAAAAAAJhPLsxUQ2lMYwGpXXWuS/KKpuYDAAAAAADMY6+YbimNaCQgtavOxUl+vYnZAAAAAAAAC8SvTzeVnut5QGpXndFMvfeo0Wf3AQAAAAAAzHODmXof0mivBzdxA+kDSTY0MBcAAAAAAGCh2ZCpttJTrUOHDvVsWLvq/ESS9/Rs4GNcdvGFOXv7mU2MhkXjW/d8Ox/63x8ucvZL/8tVOWHD+iJnA0AJZ57xlDx508lNrwEcw79881/z5X/4x6bXAABgkfjibV/Ozbd8rqnx101OjL+3V8N6FpDaVWdLki8nWd2TgdNGRobz2le9MpddclEvx8KiNPH1O/PfrntVkbP/53venWrrliJnAwAAAAB0y82f+Wze+e7fzL599/Z69PeSnDk5MX5nL4b15BF27arTytT1qp7Go21jVT70/veKRwAAAAAAQFdcdslF+dD735ttY1WvR69O8oHp5lJcr96B9OokF/doVpLkjM7pedfb35p169b2ciwAAAAAALDIrVu3Nu96+1tzRuf0Xo++OFPNpbjiAalddU5N8tbScx5rx1nb88633ZRVK1f2ciwAAAAAALBErFq5Mu98203Zcdb2Xo9+63R7KapoQGpXnb4kv5NkRck5j3X+eefkl2/6+QwNDfVqJAAAAAAAsAQNDQ3ll2/6+Zx/3jm9HLsiye9MN5hiSt9AelmSpxWe8ahLL7owb/n5n82yZct6NRIAAAAAAFjCli1blrf8/M/m0osu7OXYp2WqwRRTLCC1q87KJL9Y6vzH2/X0y3Pjm16XgYGBXo0EAAAAAADIwMBAbnzT67Lr6Zf3cuwvTreYIkreQLo+ycaC5z/qgvPPyxuuf036+oq/0gkAAAAAAOCH9PX15Q3XvyYXnH9er0ZuTPIzpQ4vUlzaVeekTAWk4jZv2pQbXn99+lqtXowDAAAAAAA4rL5WKze8/vps3rSpVyP/x3ST6bpSV3ZuSrKq0NmPGhkezlvffENWrlhRehQAAAAAAMAxrVyxIm998w0ZGR7uxbhVmWoyXdf1gNSuOk9Ncm23z328vr6+3Pim12d0Y5GwBgAAAAAAMCejG0/KjW96fa9evXPtdJvpqhKbv6PQuTW7r74qO8/eXnoMAAAAAADArO08e3t2X31VL0b1ZarNdP3QrmlXnWcneUY3zzycauuW7L76xaXHAAAAAAAAzNnuq1+cauuWXox6xnSj6Zpu3xT6hS6f90MGBwbyxutfk4GBgdKjAAAAAAAA5mxgumkM9qZpdLXRdC0gtavOJUl2duu8I3nZS67O1i2bS48BAAAAAAA4blu3bM7LXnJ1L0btnG41XdHNG0iv7eJZh7VtrMo1V72o9BgAAAAAAICuueaqF2XbWNWLUV1rNV0JSO2qc2qS53bjrCPp7+/PG67/6fT395ccAwAAAAAA0FU9bBzPnW42x61bN5Bek6TVpbMO63nPeVY2b9pUcgQAAAAAAEARmzdtyvOe86zSY1qZajbH7bgDUrvqbEiyuwu7HNGqlStz7e5rSo4AAAAAAAAo6trd12TVypWlx+yebjfHpRs3kF6ZZKgL5xzRNS++MmvXrCk5AgAAAAAAoKi1a9bkmhdfWXrMUKbazXE5roDUrjorkvzk8S5xNCds2JArX/D8kiMAAAAAAAB64soXPD8nbDjuC0LH8pPTDWfOjvcG0u4kRf+UL792d5YvX1ZyBAAAAAAAQE8sX74sL7+26JuBkql2c1xD5hyQ2lWnay9iOpKxU7bmmVdcVnIEAAAAAABATz3zissydsrW0mNeM91y5uR4biBdmmTsOL7+mK57+Y+n1Zrznw0AAAAAAGDeabVaue7lP156zFimWs6cHE9AeulxfO0xbRursuOs7SVHAAAAAAAANGLHWduzbawqPWbOLWdOAWn6xUs/NtehM3HVi15Y8ngAAAAAAIBG9aCF/Nh005m1ud5Ael6SkTl+7TGdeMKGXHrRBaWOBwAAAAAAaNylF12QE0/YUHLESKaazqzNNSC9ZI5fNyNXvvD56e/vLzkCAAAAAACgUf39/bnyhc8vPWZOTWfWAalddTYkedZchs3EqlWr8txn7yp1PAAAAAAAwLzx3GfvyqpVq0qOeNZ025mVudxAuirJwBy+bkZ+5Dm7snLFnB7HBwAAAAAAsKCsXLEiP/KcohdrBjLVdmZlLgHppXP4mhnp7+/PlS/40VLHAwAAAAAAzDtXvuBHS7/aZ9ZtZ1YBqV11xpKcO9shM3XB+edlw/r1pY4HAAAAAACYdzasX58Lzj+v5IhzpxvPjM32BtKcXrQ0U7uefnnJ4wEAAAAAAOalHjSSWTWeGQekdtVpJblm1uvM0MjwcJ527jmljgcAAAAAAJi3nnbuORkZHi454prp1jMjs7mBdFaSLbPfZ2Yuv/TiDA4MlDoeAAAAAABg3hocGMjll15ccsSWTLWeGZlNQHrW7HeZuV1XeHwdAAAAAACwdPWglcy49cyLgDS68aR0TUkyHQAAGsJJREFUTt9W6ngAAAAAAIB5r3P6toxuPKnkiO4GpHbVGUly/pzXOYZnun0EAAAAAABQupmcP918jmmmN5CuSFLsBUXPvOKyUkcDAAAAAAAsGIWbyUCmms8xzTQgFXt8XQ+uYwEAAAAAACwIPXjtz4yaT+MBqQcvhAIAAAAAAFgwCreT7gSkdtU5LcnJx73OYbRarVxy4QUljgYAAAAAAFiQLrnwgrRarVLHnzzdfo5qJjeQit0+OmXL5qxbt7bU8QAAAAAAAAvOunVrc8qWzSVHHLP9NBqQztlxdqmjAQAAAAAAFqxzdxZtKMcXkNpVZ0WSi7u2zuMU/sMDAAAAAAAsSIUv4Vw83YCO6Fg3kC5NMtS1dR5jaGgoZzylU+JoAAAAAACABe2Mp3QyNFQk0SRT7efSo/2GYwWkXV1b5XHOOvOMDA4MlDoeAAAAAABgwRocGMhZZ55RcsRRG9CxAlK5x9ft2FHqaAAAAAAAgAWvcEs5agM6YkBqV52hJE/p+jrTvP8IAAAAAADgyAq3lKdMt6DDOtoNpDOTDHZ/n+SJJ56YJ7VHSxwNAAAAAACwKDypPZonnnhiqeMHM9WCDutoAWln93eZ4vYRAAAAAADAsRVuKkdsQUcLSOcUWCRJcu5O7z8CAAAAAAA4lsJN5YgtqOc3kPr6+rJj+1NLHA0AAAAAALCo7Nj+1PT1HS3nHJfZ3UBqV53VSU4rscmmk5+UVatWlTgaAAAAAABgUVm1alU2nfykUsefNt2EfsiRktVZR/m149vk1LESxwIAAAAAACxKBdtKX6aa0GF/4XCKvf/o1LGq1NEAAAAAAACLTuG2ctgmdKSAVOT9R0lymoAEAAAAAAAwY4XbymGbUE9vIA0ODGTr1i0ljgYAAAAAAFiUtm7dksGBgVLHz+wGUrvqrE2ytcQGW7dsLvkHBAAAAAAAWHQGBwaydcvmUsdvnW5DNYe7gbQzSavEBt5/BAAAAAAAMHsFG0srh3mM3ZECUhHbThWQAAAAAAAAZqtwY5lRQCry/qMkOW1srNTRAAAAAAAAi1bhxvJDbehwAanIBkPLl+fJm04ucTQAAAAAAMCi9uRNJ2do+fJSx/9QG6oFpHbVaSXZUmJydcrW9PUdrlcBAAAAAABwNH19falO2Vrq+C3TjegH8x73GzYmWVlisvcfAQAAAAAAzF3B1rIyU43oUY8PSKeUmlxtLVbFAAAAAAAAFr3CraXWiHoWkJ40OlrqaAAAAAAAgEWvcGtpJiCNjp5U6mgAAAAAAIBFr3Br6X1AWrliRdauWVPiaAAAAAAAgCVh7Zo1WbliRanjex+QRkc3Hvs3AQAAAAAAcFQFm8tRA1KRty+NnuTxdQAAAAAAAMerYHOpNaJHA1K76pyYZLjERO8/AgAAAAAAOH4Fm8vwdCtKUr+BVOTxdYkbSAAAAAAAAN1QuLk82op6E5A2CkgAAAAAAADHq3BzEZAAAAAAAAAWmkUTkAYHB7Nh/foSRwMAAAAAACwpG9avz+DgYKnjexeQNp70xLRarRJHAwAAAAAALCmtVisbT3piqeO3fv+TvsP9ZDcVfpkTAAAAAADAklKwvdRvILWrzook60pMGh0VkAAAAAAAALqlYHtZN92MHr2BtKHUJDeQAAAAAAAAuqdwe9mQ9CIgbdxY6mgAAAAAAIAlp3B7qQWk9aWmnHBCsaMBAAAAAACWnMLtZX3SgxtIa0fWlDoaAAAAAABgySncXso/wq7VamVkZLjE0QAAAAAAAEvSyMhwWq1WqePLP8Ju1aqV6e/vL3E0AAAAAADAktTf359Vq1aWOr78I+zWeHwdAAAAAABA1xVsMOUfYbd2zUiJYwEAAAAAAJa0gg2m/CPs1owISAAAAAAAAN1WsMH04BF2biABAAAAAAB0XcEGU/4RdgISAAAAAABA9xUPSO2q059kXYkJBV/gBAAAAAAAsGQVbDDr2lWnvy/JE5K0SkxYMzJc4lgAAAAAAIAlrWCDaSV5Ql8KPb4u8Qg7AAAAAACAEgo3mA19SdaXOn3NiIAEAAAAAADQbYUbzPqiN5DWrvEOJAAAAAAAgG4r3GA2lH2EnRtIAAAAAAAAXVe4wWzoS/KEEif3tVoZLvcCJwAAAAAAgCVreGQ4fa1WqeOf0JdkqMTJq4dXl1wcAAAAAABgyeprtbJ6eHWp44f6kiwrcfLw6mJLAwAAAAAALHkFW8yyviTLS5w8MDBQ4lgAAAAAAABStMUsL3YDadngYIljAQAAAAAASNEW4wYSAAAAAADAQrQgbyANuoEEAAAAAABQTMEWU+4GkoAEAAAAAABQTumAVOYGkkfYAQAAAAAAFFOwxXiEHQAAAAAAwEK0IB9hNzDoBhIAAAAAAEApBVtMwRtIHmEHAAAAAABQTMEWU+4GkkfYAQAAAAAAlFOwxXgHEgAAAAAAwEK0IN+BNOgdSAAAAAAAAMUUbDEl34HkBhIAAAAAAEApBVvMsmIBaaDci5sAAAAAAACWvIItptwj7JYtcwMJAAAAAACglIItptwj7NxAAgAAAAAAKGdh3kAadAMJAAAAAACglIItxg0kAAAAAACAhaj0DSQAAAAAAAB4VF+Sh0scfODAgRLHAgAAAAAAkGT//mIt5uG+JA8VOXn//hLHAgAAAAAAkGT/gWIt5iE3kAAAAAAAABag/eUu8xS8gfSwG0gAAAAAAAClFAxIbiABAAAAAAAsRAVfJ/RwsYBU8Ll7AAAAAAAAS96B/cUu85R7hN3+cksDAAAAAAAseQVvIJV7hF3B5+4BAAAAAAAseQVbTMkbSAIS/7+9e4uR8zzrAP6PVVFAgMRFuYAVqCDDhREUkDhIHFTEQUhIIITEBVI5CCrEUUAPUNqSUkIahQYiKOXUhB4SEhKaHtI0ThonThrSOHbsHL7E8Rc72P52ncROvLv2em3vzg4XTozjrL0zu/POt+P5/e7i/eZ5Ho93vY7++7wvAAAAAABQysJisdPgCm4glRsaAAAAAABg7I3kBlLBi5sAAAAAAADG3sJpdyABAAAAAABwjtOFN5AcYQcAAAAAADBiFgvfgVTkCDsbSAAAAAAAAOWUvgPJEXYAAAAAAAAjpvQRdkU2kAquTQEAAAAAAIy9xYWyR9gV2UAqmHoBAAAAAACMPRtIAAAAAAAAvEbB64TKbSAdO368RFkAAAAAAABSNEA6vSHJyRKVjx87nqVut0RpAAAAAACAsXe83DLPqQ1JXipReanbzbHZYyVKAwAAAAAAjLW5EyeyUO46oSMbkhwuVX1mdrZUaQAAAAAAgLE1M1M0gykbIE3PzJQqDQAAAAAAMLYKL/Ec3pDkSKnqNpAAAAAAAAAGb3q66BLP4bJH2JVdnwIAAAAAABhLw9hAeilJt0T1mdljJcoCAAAAAACMtZly1wh1k7y0oamrTpKjJTrMzLoDCQAAAAAAYNCmywVIR5u66mx45T+KHGPnCDsAAAAAAIDBmy6XwRxOEgESAAAAAADAiCl4B9KR5P8DpCMlOhS+wAkAAAAAAGAsTU8XO8Ku/AZSwfUpAAAAAACAsVVwiWcIR9jNFku/AAAAAAAAxlbBa4TKH2E3N3cinU6nRGkAAAAAAICxtLS0lGPHj5cqX34DqdvtZnb2WInSAAAAAAAAY2lmdjbdbrdU+fIBUpJMO8YOAAAAAABgYAoeX5cM4wi7JHnxxWKlAQAAAAAAxs6Rl14qWX44G0iTU1OlSgMAAAAAAIydZrJo9jKkAOnQoVKlAQAAAAAAxs7kVNHs5f8DpKau5pMcLdFlclKABAAAAAAAMChNudPfpl/JjM5uICXJ3hKdbCABAAAAAAAMTsENpLNZ0bkB0rMlOk0dej7dbrdEaQAAAAAAgLHS7XYzdej5UuXPZkXFA6SFhYUcPnKkRGkAAAAAAICxcvjIkZw+fbpU+eEFSEnxy5wAAAAAAADGwuRUse2jRIAEAAAAAAAweianpkqWH3KAdEiABAAAAAAAsFZDD5CaunohybES3SYnBUgAAAAAAABr1ZQ79W2uqauz5+NtOO+De0t0tIEEAAAAAACwdpOTxTaQXnNS3fkBUpFj7Ar+ZgAAAAAAAMbG5KHnV35odYYfIJ2Yn8/0zEyJ0gAAAAAAAGPh5ZePZn5+vlT54QdIiXuQAAAAAAAA1qKZKnri22uuORpagHRwcrJUaQAAAAAAgEve5FTRZZ12NpDqvXtXfggAAAAAAIBlPbd/f8nyFw2QppKcKNF19zN1ibIAAAAAAABjoWDWcjJJc+4vvCZAauqqm2Rfic71s3uztLRUojQAAAAAAMAlbanbzZ662EFy+17JiM46fwMpSfaU6Hzy1Kn87/4DJUoDAAAAAABc0g4ebHJifr5U+ddlQ8sFSI+U6v70niLZFAAAAAAAwCVt956iVwW9LhtaLkDaXqq7e5AAAAAAAAD6t7vsks7rsqELBUjdZX59zZ4pm44BAAAAAABckgpvIK0cIDV1NZ1kb4nue/c9l4XFxRKlAQAAAAAALkmdTifP7t1Xqvy+pq5ePv8Xl9tASgrdg7SwuJi95X6DAAAAAAAAl5zn9h/IqVOnS5Vf9mqjCwVIxe5BetoxdgAAAAAAAD3b/cxw7z9KhryBlLgHCQAAAAAAoB/Dvv8ouXCAtDPJUokpni6bkgEAAAAAAFxSCm4gdZPsWO4DywZITV0dT/J0iUn2HziYubm5EqUBAAAAAAAuKadPn86+/91fqvyepq5ml/vAhTaQkkL3IC0tLWXHrsdLlAYAAAAAALik7Hr8ySwuLpYqf8Es6GIBUrF7kLZtX3YbCgAAAAAAgHMUzlRWFSAV2UBKkm3bHy1VGgAAAAAA4JLxcNkA6YLLRBcLkB5LsjD4WZLnX3ghB5vJEqUBAAAAAAAuCS+8eDj7DxwsVb6TZOeFPnjBAKmpq5NJniwxUWILCQAAAAAA4GIKH1/3VFNXJy70wYttICXJ/QMe5qxtO9yDBAAAAAAAcCHbdhRdxrloBrRSgLR5gIO8xs7HnsjC4mKp8gAAAAAAACOr0+lk+6O7Sra462IffMMKL74vyckkXz2oaV518uTJPPFkle9/y/cOujQwgg42TdsjAAAAAIycjd/x7W2PABTy1O5nMjc3V6r8QpItF3vgogFSU1fzExs33Z/kZwY51au2bX9UgAQkSS6/4qq2RwAAAAAYOfff9YW2RwAKefiRolcBPdjU1fGLPbDSEXZJcueAhnmdR8qe3QcAAAAAADCSCt9/tGL202qA9Oy+53L06HSp8gAAAAAAACNnZmY2e/bUJVtsXumBFQOkpq6eTnJgIOOcp9vtZuuXHyxRGgAAAAAAYCQ9tO2RLHW7pco/n+SxlR7qZQMpKbiFtPmei97RBAAAAAAAMFbu3nJfyfKbm7paMZ1qPUCqntqdyalDpcoDAAAAAACMjJdfPpodO3eVbLHi8XVJ7wHSPUkWVz/Lxd11z72lSgMAAAAAAIyMLVvvz9LSUqnyS0nu7uXBngKkpq5mkzy0loku5i7H2AEAAAAAAJReutnR1NWRXh7sdQMpKXiM3eTUoVRP7S5VHgAAAAAAYN072Exm9566ZIues551ESAlyWZbSAAAAAAAwBi7e0vxK396uv8o6S9A2plkX/+z9GbLffdnYbHYNUsAAAAAAADr2t1btpYs/3ySr/T6cM8BUlNX3SQ3rGaiXsweO5avbHukVHkAAAAAAIB166ndz2Ryaqpki/9s6qrT68P9bCAlyaf6fL4vm7/kGDsAAAAAAGD8DCEj+WQ/D/cVIDV1tSfJtr7G6cODDz2cw0eOlCoPAAAAAACw7szNzWXz3feUbPFUU1c7+3lBvxtISZ8JVT86nU5uue2zpcoDAAAAAACsO5+7486cmJ8v2aLvE+ZWEyDdnGRxFa/ryefv2Fz6TQIAAAAAAFgXFhcXc+ttnyvZopvkhn5f1HeA1NTV4SR39vu6Xs3NzeX2L24uVR4AAAAAAGDduPf+B0pf7/NAU1cH+n3RajaQklWsOvXjlk9/Jp1Op2QLAAAAAACA1t10622lW6zqaqLVBkifSzK7yteu6IUXD+e+Bx4sVR4AAAAAAKB1Ox97PPWze0u2OJXk1tW8cFUBUlNX80n+ezWv7dXNt366ZHkAAAAAAIBW/ectxbOQ25u6ml7NC1e7gZSscuWpV7v31Nmxc1fJFgAAAAAAAK3Yf+BgHn5ke+k2q76SaC0B0n1J9qzh9Sv66L9dl263W7IFAAAAAADA0H38xptKZyAvJblztS9+w2pf2NRVd2LjpmuS/PNqa6xkz7N7c9c99+Znf+onS7UA+vCtExP52Ef/oe0xAAAAAABG2u49de65d2vpNh9p6urkal982VrSrYmNm74myf4kb1p1kRV805velBuu+9e88Y1fVaoFAAAAAADA0PzhO/4sux5/omSLk0m+ramrF1dbYC1H2KWpq/kk/7SWGit58fDh3HLbZ0q2AAAAAAAAGIoHv/Jw6fAoST65lvAoWWOA9IqP5EySVcwNN92S6ZmZki0AAAAAAACK6nQ6+ei/XVe6TTfJNWstsuYAqamrw0k+sdY6FzN34kSu/8QNJVsAAAAAAAAUdfsXN+fAwaZ0my80dbV7rUUGsYGUnEmyVn+ZUg8+d8edeW7//pItAAAAAAAAijgxP5/rhrMs87eDKDKQAKmpq2eS3D6IWhfS6XRy5dV/l06nU7INAAAAAADAwP3zv1+fo9PTpdtsb+pq6yAKDWoDKUk+PMBay9q9p84NN99aug0AAAAAAMDA7Ni5K5+9/Y5htBpYVjOwAOmVRGv7oOpdyMc/dWP27nuudBsAAAAAAIA1OzE/n6uuuTbdbtGbgJJkf5KBbeEMcgMpSd4/4Hqvs7C4mL+5+posLi6WbgUAAAAAALAmH/mXf8/zL7w4jFZXNnU1sPBkoAFSU1dfTHL3IGsup967L5+48abSbQAAAAAAAFZt2/ZH8/k77hxGq91JPjbIgoPeQEqSdyRZKlD3NT5x483Z/uiu0m0AAAAAAAD6NjMzm6uuuXZY7d41yO2jpECA1NTV40muH3Td8y0tLeXyKz6UyalDpVsBAAAAAAD0rNPp5P1/fWUOHzkyjHb3NXX1+UEXLbGBlCTvSzJXqPZZs8eO5T1/+cGcmJ8v3QoAAAAAAKAnH/nXj2XnY48Po1U3Z06GG7giAVJTV4eSXF2i9vme278/H/zQ1VnqdofRDgAAAAAA4II2f2lLbr3ts8Nqd2NTVztKFC61gZScCZCmCtY/68GHHs6VV1+TpaXiVy8BAAAAAAAs67EnnszVf/8Pw2p3Msl7ShUvFiA1dXUiyXtL1T/f5i9tyeVXXJXFxYHeEQUAAAAAALCi7Y/uyjvf8/6cPn16WC2vberqQKniJTeQkuTjSb5SuMdZ9z3w5fzFB/56mH84AAAAAADAmPufh7fl3e+7PCdPnRpWy8NJrizZoGiA1NTVUpJfTzJfss+5Hnr4kbz7fR/IyZMnh9USAAAAAAAYU1sfeDDv/cAVWVhYGGbbP2jqaqZkg9IbSGnq6pkUPINvOTt27sqf/vn7MnfixDDbAgAAAAAAY+TuLffmL6/40LCv17mlqaubSzcpHiC94tok9w+pV5Lkieqp/PG73pOjR6eH2RYAAAAAABgDX7jzrlxx1YeztLQ0zLYvJvndYTS6rNvtDqNPJjZu+vYkjyX5uqE0fMU3fMPX50//4Pfy1p/4sWG2BQAAAAAALkGLi4u5/pM35lM3/VeGlbGc45eaurptGI2GFiAlycTGTb+T5KNDa3iOt/74j+YHvu8tvT182WW9PdZH/8t6rdnjc/00v6zHhwc+Yx8G3bv3t7GfN7KdGZM+5mzx/en9c7e992fQX1/9fC30PmOvBUv0HvDnT19/V7TTexRm7PfZQdYr8Tle5Otr0N+3S7w/ozBjz60LfH0N+PvSpTTjmWd7fnKgvUdjxl779vP7ae/9aevfNP3ULPE5PujvDQP/d1cfDw/87/s+avb+/7Etfn0N+P0p8u+pNv8MAYCRcOBgkw9+6Oo8Uz/bRvsbm7r61WE1G2qAlCQTGzfdleSnh9oUAAAA4BJQIqgc/A9MjsKMfbQe+A91jkDY3OoPng64XsbzB0/L/MDkKMw42N6jMOOZzu187o7CjP0822vFg5OTOXXqdM/9B+hQku9u6urlYTV8w7AaneM3kuxM8qYWegMAAACMrF5/ELivHxce/tE7AEB/ukl+a5jhUZJsGGazJGnqajLJLydZGHZvAAAAAACAEfM3TV3dMeymQw+QkqSpq/uT/FEbvQEAAAAAAEbEF5K8v43GQ78D6VwTGzf9S5K3tzYAAAAAAADA+rQnyQ82dTXTRvNWNpDO8ftJvtzyDAAAAAAAAOvJsSS/2FZ4lLQcIDV1tZAz9yE1bc4BAAAAAACwTnSTvK2pq6fbHKLtDaQ0dfVCkp9PcrjtWQAAAAAAAFr2F01dfabtIVoPkJKkqavHkvx4ksm2ZwEAAAAAAGjJe5u6urLtIZLksm632/YMZ01s3PTmJPckeXPbswAAAAAAAAzRO5q6+nDbQ7xqXQVISTKxcdO35EyI9F1tzwIAAAAAAFBYN8nvN3X1T20Pcq51FyAlycTGTd+U5K4k39v2LAAAAAAAAIUsJfntpq6ua3uQ863LAClJJjZu+sYkX0zyQ23PAgAAAAAAMGCdJG9r6urGtgdZzoa2B7iQpq6OJvnpJFvbngUAAAAAAGCAFpL8ynoNj5J1HCAlSVNXx5L8XJLNbc8CAAAAAAAwAKeS/FJTV//d9iAXs64DpCRp6mo+yS8k+XDOnAUIAAAAAAAwimaT/EJTV7e3PchK1u0dSMuZ2LjpR5L8R5LvbHkUAAAAAACAfmxN8mtNXe1ve5BerPsNpHM1dfVQkrckuTbJ6CRfAAAAAADAuDqZ5E+SvHVUwqNkxDaQzjWxcdNPJLk+yZvbngUAAAAAAGAZO5K8ramrp9oepF8jtYF0rqautib5niT/mGSh5XEAAAAAAABe1UnyV0l+eBTDo2SEN5DONbFx07cleXeS30zyxpbHAQAAAAAAxlM3yX8l+WBTV1Xbw6zFJREgvWpi46ZvTvLOJG9P8rUtjwMAAAAAAIyHbpJPJ7m8qasn2x5mEP4PeyqeahdFiAsAAAAASUVORK5CYII=",
          fileName="modelica://ClaRa/Resources/Images/Components/FeedwaterTank.png")}),
      Diagram(graphics,
              coordinateSystem(
        extent={{-300,-100},{300,100}},
        preserveAspectRatio=false,
        initialScale=0.1)));

end FeedwaterTank;
