﻿within ClaRa.Basics.Icons;
model CoolingTower

  annotation (Diagram(graphics,
                      coordinateSystem(extent={{-100,-100},{100,200}})), Icon(coordinateSystem(extent={{-100,-100},{100,200}}, preserveAspectRatio=false), graphics={Bitmap(
          extent={{-100,-100},{100,200}},
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/WetCoolingTower.png")}));

end CoolingTower;
