﻿within ClaRa.Basics.Icons;
model BurnerSlice
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//
  annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-300,-100},{300,100}}), graphics={Bitmap(
          extent={{-300,-100},{300,100}},
          imageSource=
              "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"
               +
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/BurnerSlice.png")}),     Diagram(graphics,
                                                                                        coordinateSystem(preserveAspectRatio=false, extent={{-300,-100},{300,100}})));

end BurnerSlice;
