﻿within ClaRa.Basics.ControlVolumes.Fundamentals.Geometry;
model HollowCylinder "Cylindric shape || No interior"
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//

  import Modelica.Constants.pi;
  extends ClaRa.Basics.ControlVolumes.Fundamentals.Geometry.GenericGeometry(
    final volume=pi/4*diameter^2*length,
    final N_heat=1,
    final A_heat={pi*diameter*length + 2*pi/4*diameter^2},
    final A_cross=if orientation == flowOrientation then volume/length else length*diameter,
    final A_front=A_cross,
    final A_hor=if orientation == ClaRa.Basics.Choices.GeometryOrientation.vertical then pi/4*diameter^2 else diameter*length,
    final shape=if orientation == ClaRa.Basics.Choices.GeometryOrientation.vertical then [0, 1; 1, 1] else [0.0005, 0.02981; 0.0245, 0.20716; 0.1245, 0.45248; 0.2245, 0.58733; 0.3245, 0.68065; 0.4245, 0.74791; 0.5245, 0.7954; 0.6245, 0.8261; 0.7245, 0.84114; 0.8245, 0.84015; 0.9245, 0.82031; 1, 0.7854],
    final height_fill=if orientation == ClaRa.Basics.Choices.GeometryOrientation.vertical then length else diameter);

  parameter ClaRa.Basics.Choices.GeometryOrientation orientation=ClaRa.Basics.Choices.GeometryOrientation.vertical "Orientation of the component" annotation(Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Choices.GeometryOrientation flowOrientation=ClaRa.Basics.Choices.GeometryOrientation.vertical "Orientation of the component" annotation(Dialog(group="Essential Geometry Definition"));

  parameter Units.Length diameter=1 "Diameter of the component" annotation (Dialog(group="Essential Geometry Definition"));
  parameter Units.Length length=1 "Length of the component" annotation (Dialog(group="Essential Geometry Definition"));

equation
   for i in 1:N_inlet loop
     assert(if integer(height_fill) <> -1 then z_in[i]<=height_fill else true, "Position of inlet flange no. " +String(i)+ "("+String(z_in[i], significantDigits=3)+" m) must be below max. fill height of "+ String(height_fill, significantDigits=3) + " m in component " +  getInstanceName() + ".");
   end for;
   for i in 1:N_outlet loop
     assert(if integer(height_fill) <> -1 then z_out[i]<=height_fill else true, "Position of outlet flange no. " +String(i)+ "("+String(z_out[i], significantDigits=3)+" m) must be below max. fill height of "+ String(height_fill, significantDigits=3) + " m in component " +  getInstanceName() + ".");
   end for;
  for i in 1:N_inlet loop
    assert(z_in[i]>=0, "Position of inlet flange no. " +String(i)+ "("+String(z_in[i], significantDigits=3)+" m) must be positive in component " +  getInstanceName() + ".");
  end for;
  for i in 1:N_outlet loop
    assert(z_out[i]>=0, "Position of outlet flange no. " +String(i)+ "("+String(z_out[i], significantDigits=3)+" m) must be positive in component " +  getInstanceName() + ".");
  end for;
  assert(A_cross>0, "The cross section of the shell side must be > 0 but is "+String(A_cross, significantDigits=3) + " in instance" + getInstanceName() + ".");
  assert(volume>0, "The volume of the shell side must be > 0 but is "+String(volume, significantDigits=3) + " in instance" + getInstanceName() + ".");
    annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2024.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under the 3-clause BSD License.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/pdf/CLA.pdf\">https://claralib.com/pdf/CLA.pdf</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under the 3-clause BSD License.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
revisions=
        "<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),
 Icon(graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
            "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"
             +
            "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",
          fileName="modelica://ClaRa/Resources/Images/Components/HollowCylinder.png")}));
end HollowCylinder;
