﻿within ClaRa.Basics.ControlVolumes.Fundamentals.Geometry;
model FlatTubeFinnedGeometry_N_cv "Discretized flatTubeFinned || Tube type"
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//

  //NOTE: this geometry can not be filled as the applying models assume good mixure of phases and no phase separation

  extends ClaRa.Basics.ControlVolumes.Fundamentals.Geometry.TubeType;
  extends ClaRa.Basics.ControlVolumes.Fundamentals.Geometry.GenericGeometry_N_cv(
    final volume={A_cross[i]*Delta_x[i] for i in 1:N_cv},
    final N_heat = 1,
    final A_heat = [{(A_f + A_ts)/(length*N_passes)*Delta_x[i] for i in 1:N_cv}],
    final A_cross=ones(N_cv)*heigth*width*(l_f-s_f)*(t_f-s_f)/((l_f+diameter_t)*t_f)/N_passes,
    Delta_x=ClaRa.Basics.Functions.GenerateGrid({0}, length*N_passes, N_cv),
    final z=cat(1,
               {(z_out - z_in)/(length*N_passes)*Delta_x[1]/2 + z_in},
               {((z_out - z_in)/(length*N_passes)*(sum(Delta_x[k] for k in 1:i - 1) + Delta_x[i]/2) + z_in) for i in 2:N_cv}),
    final Delta_z_in = {sum(Delta_x[1:i]) - Delta_x[i]/2 for i in 1:N_cv},
    final diameter_hyd={4*A_cross[i]*Delta_x[i]/A_heat[i,N_heat] for i in 1:N_cv});//fill(2*h_f*t_f/(h_f + t_f), N_cv));

  parameter ClaRa.Basics.Units.Length heigth=1 "Height of HX" annotation (Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Units.Length width=1 "Width of HX (length of flat tube)" annotation (Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Units.Length length=1 "Length of HX (width of flat tube)" annotation (Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Units.Length diameter_t=0.01 "Outer diameter of the flat tube" annotation (Dialog(group="Essential Geometry Definition"));
  parameter Integer N_tubes=1 "Number of tubes in parallel (one pass)"
                                                                      annotation(Dialog(group="Essential Geometry Definition"));
  parameter Integer N_passes=1 "Number of passes of the tubes" annotation(Dialog(group="Essential Geometry Definition"));
  parameter Integer flowOrientation=0 "Flow orientation" annotation (Dialog(group="Essential Geometry Definition"), choices(
    choice=0 "Lengthwise",
    choice=1 "Widthwise"));

  parameter ClaRa.Basics.Units.Length h_f=0.01 "Fin heigth" annotation (Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Units.Length s_f=0.002 "Fin thickness" annotation (Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Units.Length t_f=0.001 "Fin spacing" annotation (Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Units.Length l_l=0.8*h_f "Length of one louver" annotation (Dialog(group="Essential Geometry Definition"));
  parameter ClaRa.Basics.Units.Length t_l=0.001 "Louver spacing" annotation (Dialog(group="Essential Geometry Definition"));
  parameter Real Phi(min=0) = 45 "Louver angle" annotation (Dialog(group="Essential Geometry Definition"));

  final parameter ClaRa.Basics.Units.Length l_f=sqrt(h_f^2 + t_f^2) "Fin length" annotation (Dialog(group="Essential Geometry Definition"));
//   final parameter ClaRa.Basics.Units.Length length_plate=if flowOrientation==0 then length else width "Axial length (legth of plate or fin in flow direction)" annotation (Dialog(group="Essential Geometry Definition"));
//   final parameter ClaRa.Basics.Units.Length width_plate=if flowOrientation==0 then width else length "Width of plate (orthogonal to flow direction)" annotation (Dialog(group="Essential Geometry Definition"));
  final parameter Real N_f = (integer(width / t_f) + 1) "Number of fins between two tubes" annotation (Dialog(group="Essential Geometry Definition"));
  final parameter ClaRa.Basics.Units.Area A_f=2*(length + s_f)*h_f*N_f*(N_tubes+1)*N_passes + A_l "Finned heat transfer area" annotation (Dialog(group="Essential Geometry Definition"));
  final parameter ClaRa.Basics.Units.Area A_ts=2*((width - s_f*N_f)*length + width*diameter_t)*(N_tubes+1)*N_passes "Tube side heat transfer area" annotation (Dialog(group="Essential Geometry Definition"));
  final parameter ClaRa.Basics.Units.Area A_l=2*(l_l*N_f*N_l*s_f)*(N_tubes+1)*N_passes "Louver cutting heat transfer area" annotation (Dialog(group="Essential Geometry Definition"));
  final parameter Integer N_l = if t_l <= 0 then 0 else integer(length/t_l) - 1 "Number of louvers alongside one fin" annotation (Dialog(group="Essential Geometry Definition"));

    annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2024.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under the 3-clause BSD License.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/pdf/CLA.pdf\">https://claralib.com/pdf/CLA.pdf</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under the 3-clause BSD License.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
revisions=
        "<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),
 Icon(graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource="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",
          fileName="modelica://ClaRa/Resources/Images/Components/FlatTubeFinnedGeometry.png")}));
end FlatTubeFinnedGeometry_N_cv;
