﻿within ClaRa.Components.VolumesValvesFittings.Valves;
partial model ThreeWayValve_base
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//
  parameter TILMedia.VLEFluid.Types.BaseVLEFluid medium=simCenter.fluid1 "Medium in the component"
    annotation (Dialog(group="Fundamental Definitions"));

  outer ClaRa.SimCenter simCenter;

  parameter Boolean showExpertSummary=simCenter.showExpertSummary "|Summary and Visualisation||True, if expert summary should be applied";
  parameter Boolean showData=true "|Summary and Visualisation||True, if a data port containing p,T,h,s,m_flow shall be shown, else false";
  parameter Boolean splitRatio_input=false "= true, if split ratio is defined by input";
  parameter Real splitRatio_fixed = 0.5 annotation(Dialog(enable=not splitRatio_input));
  Real splitRatio;
protected
  TILMedia.VLEFluid.MixtureCompatible.VLEFluid_ph fluidIn(
    each vleFluidType=medium,
    h=noEvent(actualStream(inlet.h_outflow)),
    p=inlet.p) annotation (Placement(transformation(extent={{-90,-12},{-70,8}}, rotation=0)));
  TILMedia.VLEFluid.MixtureCompatible.VLEFluid_ph fluidOut2(
    each vleFluidType=medium,
    h=noEvent(actualStream(outlet2.h_outflow)),
    p=outlet2.p) annotation (Placement(transformation(extent={{-10,-70},{10,-50}}, rotation=0)));
protected
  TILMedia.VLEFluid.MixtureCompatible.VLEFluid_ph fluidOut1(
    each vleFluidType=medium,
    h=noEvent(actualStream(outlet1.h_outflow)),
    p=outlet1.p) annotation (Placement(transformation(extent={{70,-10},{90,10}}, rotation=0)));
public
  Modelica.Blocks.Interfaces.RealInput splitRatio_external(min=0,max=1)=splitRatio if splitRatio_input "Controls mass fraction m2/m1"
    annotation (Placement(transformation(
        extent={{20,-20},{-20,20}},
        rotation=90,
        origin={0,31}), iconTransformation(
        extent={{20,-20},{-20,20}},
        rotation=90,
        origin={0,90})));
  Basics.Interfaces.FluidPortIn       inlet(Medium=medium) "Inlet port"
    annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
  Basics.Interfaces.FluidPortOut       outlet1(each Medium=medium) "Outlet port"
    annotation (Placement(transformation(extent={{90,-10},{110,10}})));
  Basics.Interfaces.FluidPortOut       outlet2(each Medium=medium) "Outlet port"
    annotation (Placement(transformation(extent={{-10,-90},{10,-70}}),
        iconTransformation(extent={{-10,-110},{10,-90}})));
public
  Basics.Interfaces.EyeOut eye1
                               if showData
    annotation (Placement(transformation(extent={{90,-30},{110,-10}}),
        iconTransformation(extent={{-10,-10},{10,10}},
        rotation=0,
        origin={110,-40})));
protected
  Basics.Interfaces.EyeIn eye_int[2]
    annotation (Placement(transformation(extent={{45,-21},{47,-19}})));
public
  Basics.Interfaces.EyeOut eye2
                               if showData
    annotation (Placement(transformation(extent={{-10,-10},{10,10}},
        rotation=270,
        origin={20,-80}),
        iconTransformation(extent={{-10,-10},{10,10}},
        rotation=270,
        origin={40,-110})));
equation
 if (not splitRatio_input) then
    splitRatio = splitRatio_fixed;
  end if;
   eye_int[1].T= fluidOut1.T-273.15;
    eye_int[1].s=fluidOut1.s/1e3;
    eye_int[1].p=fluidOut1.p/1e5;
    eye_int[1].h=fluidOut1.h/1e3;
    eye_int[2].T= fluidOut2.T-273.15;
    eye_int[2].s=fluidOut2.s/1e3;
    eye_int[2].p=fluidOut2.p/1e5;
    eye_int[2].h=fluidOut2.h/1e3;
    eye_int[1].m_flow=-outlet1.m_flow;
    eye_int[2].m_flow=-outlet2.m_flow;
  connect(eye_int[1],eye1)  annotation (Line(
      points={{46,-20.5},{74,-20.5},{74,-20},{100,-20}},
      color={190,190,190},
      smooth=Smooth.None));
  connect(eye_int[2],eye2)  annotation (Line(
      points={{46,-19.5},{46,-60},{20,-60},{20,-80}},
      color={190,190,190},
      smooth=Smooth.None));

  annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2024.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under the 3-clause BSD License.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/pdf/CLA.pdf\">https://claralib.com/pdf/CLA.pdf</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under the 3-clause BSD License.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),
 Icon(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,80}},
        grid={2,2}), graphics={Bitmap(
          extent={{-100,-100},{100,70}},                                    visible = not splitRatio_input,
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/ThreeWayValve.png"),                                 Bitmap(
          extent={{-100,-100},{100,70}},
          imageSource="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"
               + "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",
          fileName="modelica://ClaRa/Resources/Images/Components/ThreeWayValveCtrl.png", visible = splitRatio_input)}),
      Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
            100,100}}), graphics));
end ThreeWayValve_base;
