﻿within ClaRa.Components.Mills.PhysicalMills.Check;
model TestMillBox_1_measurementInput
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//
 extends ClaRa.Basics.Icons.PackageIcons.ExecutableExampleb50;
  Modelica.Blocks.Sources.Constant pressure(k=simCenter.p_amb_start)
                                                       annotation (Placement(transformation(extent={{158,16},{138,36}})));
  ClaRa.Components.BoundaryConditions.BoundaryGas_pTxi boundaryGas_pTxi(xi_const={0,0,0,0,0.79,0.21,0,0,0}, p_const=simCenter.p_amb_start)
                                                                                                            annotation (Placement(transformation(extent={{80,-50},{60,-30}})));
  inner ClaRa.SimCenter simCenter(redeclare ClaRa.Basics.Media.FuelTypes.Fuel_verbandsformel_v1 fuelModel1)
                                  annotation (Placement(transformation(extent={{-738,240},{-698,260}})));
  ClaRa.Components.BoundaryConditions.BoundaryFuel_Txim_flow     fuelBoundary_m_flowTxi(
    variable_m_flow=true,
    variable_T=true,
    variable_xi=true)                                                                                                                                                                    annotation (Placement(transformation(extent={{-80,10},{-60,30}})));
  Modelica.Blocks.Sources.Constant temperature(k=273.15 + 20)
                                                         annotation (Placement(transformation(extent={{-260,-136},{-240,-116}})));
  Modelica.Blocks.Sources.Constant composition[6](k={0.761,0,0,0,0.004,0.125}) ""
                                                                                 annotation (Placement(transformation(extent={{-260,-100},{-240,-80}})));
  ClaRa.Components.BoundaryConditions.BoundaryGas_pTxi boundaryGas_pTxi2(
                                                                        xi_const={0,0,0,0,0.79,0.21,0,0,0},
    p_const=simCenter.p_amb_start + 3000,
    T_const=273.15 + 302)                                                                                   annotation (Placement(transformation(extent={{-80,-50},{-60,-30}})));
  Modelica.Blocks.Sources.Constant sourceTableSpeed(k=45)   "rpm"
                                                         annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=-90,
        origin={0,90})));
  Modelica.Blocks.Sources.Constant sourceClassifier(k=53) "either guide vane angle (rad) or rotation speed (rpm): 45/180*Modelica.Constants.pi"
                                                         annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=-90,
        origin={50,90})));
  ClaRa.Components.BoundaryConditions.BoundaryGas_Txim_flow
                                                       boundaryGas_pTxi1(
    T_const=273.15 + 302,
    variable_m_flow=true,
    variable_T=true,
    xi_const={0,0,0,0,0.757,0.231,0,0.005,0})                                                               annotation (Placement(transformation(extent={{-80,-74},{-60,-54}})));

  ClaRa.Components.BoundaryConditions.BoundaryFuel_pTxi boundaryFuel_pTxi(
    variable_p=true,
    variable_T=true,
    variable_xi=true) annotation (Placement(transformation(extent={{78,10},{58,30}})));
  Modelica.Blocks.Sources.TimeTable timeTableCoal_complete(table=[0,12.6843364031697; 5,12.684638413769; 10,12.6849409302486; 15,12.6852434467282; 20,12.6855459632078; 25,12.6858484796875; 30,12.6861504902867; 35,12.6864535126467; 40,12.6867555232459; 45,12.6870575338452; 50,12.6873600503248; 55,12.687965083284; 60,12.6885696103629; 65,12.6891746433221; 70,12.689779170401; 75,12.6903842033602; 80,12.6909892363195; 85,12.6915937633983; 90,12.6921982904772; 95,12.6928033234364; 100,12.6934083563957; 105,12.6940128834746; 110,12.6946179164338; 115,12.6952224435127; 120,12.6958274764719; 125,12.6964320035508; 130,12.69703703651; 135,12.6976415635889; 140,12.6982465965481; 145,12.698851123627; 150,12.6994561565862; 155,12.7000606836651; 160,12.7006657166243; 165,12.7012702437032; 170,12.7018752766624; 175,12.7024798037413; 180,12.7030848367005; 185,12.7036893637794; 190,12.7042943967386; 195,12.7048989238175; 200,12.7055039567767; 205,12.706108989736; 210,12.7067135168148; 215,
        12.7073180438937; 220,12.7079230768529; 225,12.7085281098122; 230,12.709132636891; 235,12.7097376698503; 240,12.7103421969291; 245,12.7109472298884; 250,12.7115517569672; 255,12.7121567899265; 260,12.7127613170053; 265,12.7133663499646; 270,12.7139708770434; 275,12.7145759100027; 280,12.7151804370816; 285,12.7156306706382; 290,12.7156306706382; 295,12.7156306706382; 300,12.7156306706382; 305,12.7156306706382; 310,12.7156306706382; 315,12.7156306706382; 320,12.7156306706382; 325,12.7156306706382; 330,12.7156306706382; 335,12.7155684473489; 340,12.7152714955537; 345,12.7149745437585; 350,12.7146780978436; 355,12.714380640168; 360,12.7140841942532; 365,12.713787242458; 370,12.7134902906628; 375,12.713193844748; 380,12.7128968929527; 385,12.7125999411575; 390,12.7123029893623; 395,12.7120060375671; 400,12.7117095916523; 405,12.711412639857; 410,12.7111156880618; 415,12.7108187362666; 420,12.7105217844714; 425,12.7102253385566; 430,12.7099283867614; 435,12.7096314349661; 440,
        12.7093349890513; 445,12.7090375313757; 450,12.7087410854609; 455,12.7084441336657; 460,12.7081471818704; 465,12.7078507359556; 470,12.70755327828; 475,12.7072568323652; 480,12.70695988057; 485,12.7066629287748; 490,12.7063664828599; 495,12.7060695310647; 500,12.7057725792695; 505,12.7054756274743; 510,12.7051786756791; 515,12.7048822297643; 520,12.704585277969; 525,12.7042883261738; 530,12.7039913743786; 535,12.7036944225834; 540,12.7033979766686; 545,12.7031010248733; 550,12.7028040730781; 555,12.7025076271633; 560,12.7022101694877; 565,12.7019137235729; 570,12.7016167717777; 575,12.7013198199824; 580,12.7010233740676; 585,12.700725916392; 590,12.7004294704772; 595,12.700132518682; 600,12.6998355668867; 605,12.6995391209719; 610,12.6992421691767; 615,12.6989452173815; 620,12.6986482655863; 625,12.6983513137911; 630,12.6980548678762; 635,12.697757916081; 640,12.6974609642858; 645,12.6971640124906; 650,12.6968670606954; 655,12.6965706147806; 660,12.6962736629853; 665,
        12.6959767111901; 670,12.6956802652753; 675,12.6953828075997; 680,12.6950863616849; 685,12.6947894098896; 690,12.6944924580944; 695,12.6941960121796; 700,12.693898554504; 705,12.6936021085892; 710,12.693305156794; 715,12.6930082049987; 720,12.6927117590839; 725,12.6924148072887; 730,12.6921178554935; 735,12.6918209036983; 740,12.691523951903; 745,12.6912275059882; 750,12.690930554193; 755,12.6906336023978; 760,12.6903366506026; 765,12.6900396988074; 770,12.6897432528925; 775,12.6894463010973; 780,12.6891493493021; 785,12.6888529033873; 790,12.6885554457117; 795,12.6882589997969; 800,12.6879620480016; 805,12.6876650962064; 810,12.6873686502916; 815,12.687071192616; 820,12.6867747467012; 825,12.6864777949059; 830,12.6861808431107; 835,12.6858843971959; 840,12.6855874454007; 845,12.6852904936055; 850,12.6849935418103; 855,12.684696590015; 860,12.6844001441002; 865,12.684103192305; 870,12.6838062405098; 875,12.6835092887146; 880,12.6832123369193; 885,12.6829158910045; 890,
        12.6826189392093; 895,12.6823219874141; 900,12.6820255414993; 905,12.6817280838237; 910,12.6814316379088; 915,12.6811346861136; 920,12.6808377343184; 925,12.6805412884036; 930,12.680243830728; 935,12.6799473848132; 940,12.6796504330179; 945,12.6793534812227; 950,12.6790570353079; 955,12.6787600835127; 960,12.6784631317175; 965,12.6781661799222; 970,12.677869228127; 975,12.6775727822122; 980,12.677275830417; 985,12.6769788786218; 990,12.6766819268266; 995,12.6763849750313; 1000,12.6760885291165; 1005,12.6757915773213; 1010,12.6754946255261; 1015,12.6751981796113; 1020,12.6749007219356; 1025,12.6746042760208; 1030,12.6743073242256; 1035,12.6740103724304; 1040,12.6737139265156; 1045,12.67341646884; 1050,12.6731200229251; 1055,12.6728230711299; 1060,12.6725261193347; 1065,12.6722296734199; 1070,12.6719327216247; 1075,12.6716357698295; 1080,12.6713388180342; 1085,12.671041866239; 1090,12.6707454203242; 1095,12.670448468529; 1100,12.6701515167338; 1105,12.6698545649385; 1110,
        12.6695576131433; 1115,12.6692611672285; 1120,12.6689642154333; 1125,12.6686672636381; 1130,12.6683708177233; 1135,12.6680733600476; 1140,12.6677769141328; 1145,12.6674799623376; 1150,12.6671830105424; 1155,12.6668865646276; 1160,12.6665891069519; 1165,12.6662926610371; 1170,12.6659957092419; 1175,12.6656987574467; 1180,12.6654023115319; 1185,12.6651053597367; 1190,12.6648084079414; 1195,12.6645114561462; 1200,12.664214504351; 1205,12.6639180584362; 1210,12.663621106641; 1215,12.6633241548458; 1220,12.6630272030505; 1225,12.6627302512553; 1230,12.6624338053405; 1235,12.6622557354394; 1240,12.6622557354394; 1245,12.6622557354394; 1250,12.6622557354394; 1255,12.6622557354394; 1260,12.6622557354394; 1265,12.6622557354394; 1270,12.6622557354394; 1275,12.6622557354394; 1280,12.6622557354394; 1285,12.7176309217426; 1290,12.7176309217426; 1295,12.7176309217426; 1300,12.7176309217426; 1305,12.7176309217426; 1310,12.7176309217426; 1315,12.7176309217426; 1320,12.7176309217426; 1325,
        12.7176309217426; 1330,12.7176309217426; 1335,12.7176309217426; 1340,12.7176309217426; 1345,12.7176309217426; 1350,12.7176309217426; 1355,12.7176309217426; 1360,12.7176309217426; 1365,12.662347299792; 1370,12.662347299792; 1375,12.662347299792; 1380,12.662347299792; 1385,12.662347299792; 1390,12.662347299792; 1395,12.662347299792; 1400,12.662347299792; 1405,12.662347299792; 1410,12.662347299792; 1415,12.6631137085991; 1420,12.6650289717962; 1425,12.6669447408736; 1430,12.6688605099511; 1435,12.6707757731482; 1440,12.6726910363453; 1445,12.6746068054228; 1450,12.6765225745003; 1455,12.6784378376974; 1460,12.6803536067749; 1465,12.682268869972; 1470,12.6841846390495; 1475,12.6860999022466; 1480,12.6880156713241; 1485,12.6899314404016; 1490,12.6918467035987; 1495,12.6937619667958; 1500,12.6956777358733; 1505,12.6956777358733; 1510,12.6956777358733; 1515,12.6956777358733; 1520,12.6956777358733; 1525,12.6956777358733; 1530,12.6956777358733; 1535,12.6956777358733; 1540,
        12.6956777358733; 1545,12.6956777358733; 1550,12.6808635342188; 1555,12.6659253918662; 1560,12.6659253918662; 1565,12.6659253918662; 1570,12.6659253918662; 1575,12.6659253918662; 1580,12.6659253918662; 1585,12.6659253918662; 1590,12.6659253918662; 1595,12.6659253918662; 1600,12.6659253918662; 1605,12.6665961892776; 1610,12.6672669866889; 1615,12.6679377841002; 1620,12.6686085815116; 1625,12.6692793789229; 1630,12.6699501763343; 1635,12.6706209737456; 1640,12.671291771157; 1645,12.6719625685683; 1650,12.6726333659797; 1655,12.673304163391; 1660,12.6739749608023; 1665,12.6746457582137; 1670,12.675316555625; 1675,12.6759873530364; 1680,12.6766581504477; 1685,12.6773289478591; 1690,12.6779997452704; 1695,12.6786705426818; 1700,12.6793413400931; 1705,12.6800121375044; 1710,12.6806829349158; 1715,12.6813537323271; 1720,12.6820245297385; 1725,12.6826953271498; 1730,12.6833661245612; 1735,12.6840369219725; 1740,12.6847077193839; 1745,12.6853785167952; 1750,12.6860493142065; 1755,
        12.6867201116179; 1760,12.6873909090292; 1765,12.6880617064406; 1770,12.6887325038519; 1775,12.6894033012633; 1780,12.6900740986746; 1785,12.690744896086; 1790,12.691605904528; 1795,12.6931604749994; 1800,12.6947150454707; 1805,12.6962691100617; 1810,12.6978241864135; 1815,12.6993782510045; 1820,12.7009328214759; 1825,12.7024873919473; 1830,12.7040414565383; 1835,12.7055960270097; 1840,12.7065283645882; 1845,12.7065283645882; 1850,12.7065283645882; 1855,12.7065283645882; 1860,12.7065283645882; 1865,12.7065283645882; 1870,12.7065283645882; 1875,12.7065283645882; 1880,12.7065283645882; 1885,12.7065283645882; 1890,12.7080829350596; 1895,12.7096375055309; 1900,12.7111915701219; 1905,12.7127466464737; 1910,12.7143007110647; 1915,12.7158547756557; 1920,12.7174098520075; 1925,12.7189639165985; 1930,12.7205184870699; 1935,12.7220730575413; 1940,12.7842103471607; 1945,12.7842103471607; 1950,12.7842103471607; 1955,12.7842103471607; 1960,12.7842103471607; 1965,12.7842103471607; 1970,
        12.7842103471607; 1975,12.7842103471607; 1980,12.7842103471607; 1985,12.7842103471607; 1990,12.7836862550656; 1995,12.7823760248277; 2000,12.7810657945899; 2005,12.7797545525913; 2010,12.7784443223534; 2015,12.7771340921156; 2020,12.7758238618777; 2025,12.7745136316399; 2030,12.773203401402; 2035,12.7718931711642; 2040,12.7705819291655; 2045,12.7692716989277; 2050,12.7679614686899; 2055,12.766651238452; 2060,12.7653410082142; 2065,12.7640307779763; 2070,12.7627205477385; 2075,12.7614093057398; 2080,12.760099075502; 2085,12.7587888452641; 2090,12.7574786150263; 2095,12.7561683847884; 2100,12.7548581545506; 2105,12.7535479243128; 2110,12.7522407293573; 2115,12.7521137533767; 2120,12.7521137533767; 2125,12.7521137533767; 2130,12.7521137533767; 2135,12.7521137533767; 2140,12.7521137533767; 2145,12.6769004671597; 2150,12.6769004671597; 2155,12.6769004671597; 2160,12.6769004671597; 2165,12.6769004671597; 2170,12.6769004671597; 2175,12.6769004671597; 2180,12.6769004671597; 2185,
        12.6769004671597; 2190,12.6769004671597; 2195,12.6770036667614; 2200,12.6771746543368; 2205,12.6773466536731; 2210,12.6775186530093; 2215,12.6776906523456; 2220,12.6778626516818; 2225,12.6780346510181; 2230,12.6782066503543; 2235,12.6783776379297; 2240,12.678549637266; 2245,12.6787216366022; 2250,12.6788936359385; 2255,12.6790656352747; 2260,12.679237634611; 2265,12.6794096339472; 2270,12.6795806215226; 2275,12.6797526208589; 2280,12.6799246201951; 2285,12.6800966195314; 2290,12.6802686188676; 2295,12.6804406182038; 2300,12.6806126175401; 2305,12.6807836051155; 2310,12.6809556044518; 2315,12.681127603788; 2320,12.6812996031243; 2325,12.6814716024605; 2330,12.6816436017967; 2335,12.681815601133; 2340,12.6819865887084; 2345,12.6821585880447; 2350,12.6823305873809; 2355,12.6825025867171; 2360,12.6826745860534; 2365,12.6828465853896; 2370,12.6830185847259; 2375,12.6831895723013; 2380,12.6833615716376; 2385,12.6835335709738; 2390,12.68370557031; 2395,12.6838775696463; 2400,
        12.6840495689825; 2405,12.6842215683188; 2410,12.6843925558942; 2415,12.6845645552305; 2420,12.6847365545667; 2425,12.6849085539029; 2430,12.6850805532392; 2435,12.6852525525754; 2440,12.6854240460313; 2445,12.6855955394871; 2450,12.6857675388233; 2455,12.6859395381596; 2460,12.6861115374958; 2465,12.6862835368321; 2470,12.6864555361683; 2475,12.6866270296242; 2480,12.68679852308; 2485,12.6869705224162; 2490,12.6871425217525; 2495,12.6873145210887; 2500,12.687486520425; 2505,12.6876585197612; 2510,12.6878295073366; 2515,12.6880015066729; 2520,12.6881735060091; 2525,12.6883455053454; 2530,12.6885175046816; 2535,12.6886895040179; 2540,12.6888615033541; 2545,12.6890324909295; 2550,12.6892044902658; 2555,12.689376489602; 2560,12.6895484889383; 2565,12.6897204882745; 2570,12.6898924876108; 2575,12.690064486947; 2580,12.6902354745224; 2585,12.6904074738587; 2590,12.6905794731949; 2595,12.6907514725312; 2600,12.6909234718674; 2605,12.6910954712036; 2610,12.6912674705399; 2615,
        12.6914384581153; 2620,12.6916104574516; 2625,12.6917824567878; 2630,12.6919544561241; 2635,12.6921264554603; 2640,12.6922984547965; 2645,12.6924704541328; 2650,12.6926414417082; 2655,12.6928134410445; 2660,12.6929854403807; 2665,12.6931574397169; 2670,12.6933294390532; 2675,12.6935014383894; 2680,12.6936734377257; 2685,12.6938444253011; 2690,12.6940164246374; 2695,12.6941884239736; 2700,12.6943604233098; 2705,12.6945324226461; 2710,12.6947044219823; 2715,12.6948764213186; 2720,12.695047408894; 2725,12.6952194082303; 2730,12.6953914075665; 2735,12.6955634069027; 2740,12.695735406239; 2745,12.6959074055752; 2750,12.6960450050442; 2755,12.6960450050442; 2760,12.6960450050442; 2765,12.6960450050442; 2770,12.6960450050442; 2775,12.6960450050442; 2780,12.6960450050442; 2785,12.6960450050442; 2790,12.6960450050442; 2795,12.6960450050442; 2800,12.6619289367006; 2805,12.6618909956705; 2810,12.6618525487601; 2815,12.66181460773; 2820,12.6617766667; 2825,12.6617382197895; 2830,
        12.6617002787595; 2835,12.6616623377294; 2840,12.661623890819; 2845,12.6615859497889; 2850,12.6615475028785; 2855,12.6615095618484; 2860,12.6614716208183; 2865,12.6614331739079; 2870,12.6613952328778; 2875,12.6613572918478; 2880,12.6613188449373; 2885,12.6612809039073; 2890,12.6612429628772; 2895,12.6612045159668; 2900,12.6611665749367; 2905,12.6611286339067; 2910,12.6610901869962; 2915,12.6610522459662; 2920,12.6610137990557; 2925,12.6609758580256; 2930,12.6609379169956; 2935,12.6608994700851; 2940,12.6608615290551; 2945,12.660823588025; 2950,12.6607851411146; 2955,12.6607472000845; 2960,12.6607092590545; 2965,12.660670812144; 2970,12.660632871114; 2975,12.6605949300839; 2980,12.6605564831735; 2985,12.6605185421434; 2990,12.6604806011133; 2995,12.6604421542029; 3000,12.6604042131728; 3005,12.6603662721428; 3010,12.6603278252323; 3015,12.6602898842023; 3020,12.6602514372918; 3025,12.6602134962618; 3030,12.6601755552317; 3035,12.6601371083213; 3040,12.6600991672912; 3045,
        12.6600612262612; 3050,12.6600227793507; 3055,12.6599848383207; 3060,12.6599468972906; 3065,12.6599084503801; 3070,12.6598705093501; 3075,12.6598320624396; 3080,12.6597941214096; 3085,12.6597561803795; 3090,12.6597177334691; 3095,12.659679792439; 3100,12.659641851409; 3105,12.6596034044985; 3110,12.6595654634685; 3115,12.6595275224384; 3120,12.659489075528; 3125,12.6594511344979; 3130,12.6594131934678; 3135,12.6593747465574; 3140,12.6593368055273; 3145,12.6592988644973; 3150,12.6222137840819; 3155,12.6222137840819; 3160,12.6222137840819; 3165,12.6222137840819; 3170,12.6222137840819; 3175,12.6222137840819; 3180,12.6222137840819; 3185,12.6222137840819; 3190,12.6222137840819; 3195,12.6222137840819; 3200,12.6241437178106; 3205,12.6273595995179; 3210,12.6305759871057; 3215,12.6327411552207; 3220,12.6327411552207; 3225,12.6327411552207; 3230,12.6327411552207; 3235,12.6327411552207; 3240,12.6327411552207; 3245,12.6327411552207; 3250,12.6327411552207; 3255,12.6327411552207; 3260,
        12.6327411552207; 3265,12.632680955453; 3270,12.6325296972132; 3275,12.6323789448538; 3280,12.6322271807336; 3285,12.6320764283742; 3290,12.631924664254; 3295,12.6317739118945; 3300,12.6316221477743; 3305,12.6314713954149; 3310,12.6313196312947; 3315,12.6311688789353; 3320,12.6310176206955; 3325,12.6308663624557; 3330,12.6307156100962; 3335,12.630563845976; 3340,12.6304130936166; 3345,12.6302613294964; 3350,12.630110577137; 3355,12.6299588130168; 3360,12.6298080606574; 3365,12.6296562965372; 3370,12.6295055441777; 3375,12.6293542859379; 3380,12.6292030276981; 3385,12.6290522753387; 3390,12.6289005112185; 3395,12.6287497588591; 3400,12.6285979947389; 3405,12.6284472423795; 3410,12.6282954782592; 3415,12.6281447258998; 3420,12.6279929617796; 3425,12.6278422094202; 3430,12.6276909511804; 3435,12.6275396929406; 3440,12.6273889405812; 3445,12.627237176461; 3450,12.6270864241015; 3455,12.6269346599813; 3460,12.6267839076219; 3465,12.6266321435017; 3470,12.6264813911423; 3475,
        12.6263296270221; 3480,12.6261788746627; 3485,12.6260276164229; 3490,12.625876358183; 3495,12.6257256058236; 3500,12.6255738417034; 3505,12.625423089344; 3510,12.6252713252238; 3515,12.6251205728644; 3520,12.6249688087442; 3525,12.6248180563847; 3530,12.6246662922645; 3535,12.6245155399051; 3540,12.6243642816653; 3545,12.6242130234255; 3550,12.6240622710661; 3555,12.6239105069459; 3560,12.6237597545865; 3565,12.6236079904662; 3570,12.6234572381068; 3575,12.6233054739866; 3580,12.6231547216272; 3585,12.623002957507; 3590,12.6228522051476; 3595,12.6227009469078; 3600,12.622549688668; 3605,12.6223989363085; 3610,12.6222471721883; 3615,12.6220964198289; 3620,12.6219446557087; 3625,12.6217939033493; 3630,12.6216421392291; 3635,12.6214913868697; 3640,12.6213401286299; 3645,12.62118887039; 3650,12.6210376121502; 3655,12.6208863539104; 3660,12.620735601551; 3665,12.6205838374308; 3670,12.6204330850714; 3675,12.6202813209512; 3680,12.6201305685917; 3685,12.6199788044715; 3690,
        12.6198280521121; 3695,12.6196767938723; 3700,12.6195255356325; 3705,12.6193742773927; 3710,12.6192230191529; 3715,12.6190722667935; 3720,12.6189205026732; 3725,12.6187697503138; 3730,12.6186179861936; 3735,12.6184672338342; 3740,12.618315469714; 3745,12.6181647173546; 3750,12.6180134591148; 3755,12.617862200875; 3760,12.6177109426351; 3765,12.6175596843953; 3770,12.6174089320359; 3775,12.6172571679157; 3780,12.6171064155563; 3785,12.6169546514361; 3790,12.6168038990767; 3795,12.6166521349565; 3800,12.616501382597; 3805,12.6163501243572; 3810,12.6161988661174; 3815,12.616048113758; 3820,12.6158963496378; 3825,12.6157455972784; 3830,12.6155938331582; 3835,12.6154430807988; 3840,12.6152913166785; 3845,12.6151405643191; 3850,12.6149888001989; 3855,12.6148380478395; 3860,12.6146867895997; 3865,12.6145355313599; 3870,12.6143847790005; 3875,12.6142330148802; 3880,12.563339423047; 3885,12.563339423047; 3890,12.563339423047; 3895,12.563339423047; 3900,12.563339423047; 3905,
        12.563339423047; 3910,12.563339423047; 3915,12.563339423047; 3920,12.563339423047; 3925,12.563339423047; 3930,12.5639439501259; 3935,12.5646992295641; 3940,12.5654545090024; 3945,12.566210294321; 3950,12.5669660796397; 3955,12.567721359078; 3960,12.5684766385162; 3965,12.5692324238349; 3970,12.5699882091536; 3975,12.5707434885918; 3980,12.5714987680301; 3985,12.5722545533488; 3990,12.573009832787; 3995,12.5737656181057; 4000,12.5745208975439; 4005,12.5752766828626; 4010,12.5760319623009; 4015,12.5767872417391; 4020,12.5775430270578; 4025,12.5782988123765; 4030,12.5790540918147; 4035,12.579809371253; 4040,12.5805651565717; 4045,12.5813209418903; 4050,12.5820762213286; 4055,12.5828315007668; 4060,12.5835872860855; 4065,12.5843425655238; 4070,12.5850983508424; 4075,12.5858536302807; 4080,12.5866094155994; 4085,12.5873646950376; 4090,12.6540513671007; 4095,12.6541925077325; 4100,12.6543331424839; 4105,12.6544737772353; 4110,12.6546144119867; 4115,12.6547555526185; 4120,
        12.6548966932503; 4125,12.6550373280017; 4130,12.6551779627531; 4135,12.6553191033849; 4140,12.6554602440167; 4145,12.6556008787681; 4150,12.6557415135195; 4155,12.6558821482709; 4160,12.6560237947831; 4165,12.6561644295345; 4170,12.6563050642859; 4175,12.6564456990373; 4180,12.6565868396691; 4185,12.6567279803009; 4190,12.6568686150523; 4195,12.6570092498037; 4200,12.6571503904355; 4205,12.6572915310673; 4210,12.6574321658187; 4215,12.6575728005701; 4220,12.6577134353215; 4225,12.6578550818337; 4230,12.6579957165851; 4235,12.6581363513364; 4240,12.6582769860878; 4245,12.6584181267196; 4250,12.6585592673514; 4255,12.6586999021028; 4260,12.6588405368542; 4265,12.658981677486; 4270,12.6591228181178; 4275,12.6592634528692; 4280,12.6594040876206; 4285,12.659544722372; 4290,12.6596863688842; 4295,12.6598270036356; 4300,12.659967638387; 4305,12.6601082731384; 4310,12.6602494137702; 4315,12.660390554402; 4320,12.6605311891534; 4325,12.6606718239048; 4330,12.6608124586562; 4335,
        12.6609541051684; 4340,12.6610947399198; 4345,12.6612353746712; 4350,12.6613760094226; 4355,12.6615171500544; 4360,12.6616582906862; 4365,12.6617989254376; 4370,12.661939560189; 4375,12.6620807008208; 4380,12.6622218414526; 4385,12.662362476204; 4390,12.6625031109554; 4395,12.6626437457068; 4400,12.662785392219; 4405,12.6629260269704; 4410,12.6630666617218; 4415,12.6632072964732; 4420,12.663348437105; 4425,12.6634895777368; 4430,12.6636302124882; 4435,12.6637708472396; 4440,12.6639119878714; 4445,12.6640531285032; 4450,12.6641937632546; 4455,12.664334398006; 4460,12.6644750327574; 4465,12.6646166792696; 4470,12.664757314021; 4475,12.6648979487724; 4480,12.6650385835238; 4485,12.6651797241556; 4490,12.6653208647874; 4495,12.6654614995388; 4500,12.6656021342902; 4505,12.665743274922; 4510,12.6658844155538; 4515,12.6660250503052; 4520,12.6661656850566; 4525,12.666306319808; 4530,12.6664474604397; 4535,12.6665886010715; 4540,12.6667292358229; 4545,12.6668698705743; 4550,
        12.6670110112061; 4555,12.6671521518379; 4560,12.6672927865893; 4565,12.6674334213407; 4570,12.6675740560921; 4575,12.6677157026043; 4580,12.6678563373557; 4585,12.6679969721071; 4590,12.6681376068585; 4595,12.6682787474903; 4600,12.6684198881221; 4605,12.6685605228735; 4610,12.6687011576249; 4615,12.6688422982567; 4620,12.6689834388885; 4625,12.6691240736399; 4630,12.6692647083913; 4635,12.6694053431427; 4640,12.6695469896549; 4645,12.6696876244063; 4650,12.6698282591577; 4655,12.6699688939091; 4660,12.6701100345409; 4665,12.6702511751727; 4670,12.6703918099241; 4675,12.6705324446755; 4680,12.6706735853073; 4685,12.6708147259391; 4690,12.6709553606905; 4695,12.6710959954419; 4700,12.6712366301933; 4705,12.6713782767055; 4710,12.6715189114569; 4715,12.6716595462083; 4720,12.6718001809597; 4725,12.6719413215915; 4730,12.6720824622233; 4735,12.6722230969747; 4740,12.6723637317261; 4745,12.6725048723579; 4750,12.6726460129897; 4755,12.6727866477411; 4760,12.6729272824925; 4765,
        12.6730679172439; 4770,12.6732090578757; 4775,12.6733501985075; 4780,12.6734908332589; 4785,12.6736314680103; 4790,12.6737726086421; 4795,12.6738004320641; 4800,12.6738004320641; 4805,12.6738004320641; 4810,12.6738004320641; 4815,12.6738004320641; 4820,12.6738004320641; 4825,12.6738004320641; 4830,12.6738004320641; 4835,12.6738004320641; 4840,12.6738004320641; 4845,12.6035852442061; 4850,12.6035852442061; 4855,12.6035852442061; 4860,12.6035852442061; 4865,12.6035852442061; 4870,12.6035852442061; 4875,12.6035852442061; 4880,12.6035852442061; 4885,12.6035852442061; 4890,12.6035852442061; 4895,12.6035852442061; 4900,12.6035852442061; 4905,12.6362985061985; 4910,12.6689758506825; 4915,12.6689758506825; 4920,12.6689758506825; 4925,12.6689758506825; 4930,12.6689758506825; 4935,12.6689758506825; 4940,12.6689758506825; 4945,12.6689758506825; 4950,12.6689758506825; 4955,12.6689758506825; 4960,12.668616675598; 4965,12.6682575005135; 4970,12.667898325429; 4975,12.6675386444641; 4980,
        12.6671789634992; 4985,12.6668197884147; 4990,12.6664606133302; 4995,12.6661014382457; 5000,12.6657422631612; 5005,12.6653830880767; 5010,12.6650229012313; 5015,12.6646637261468; 5020,12.6643045510623; 5025,12.6639453759778; 5030,12.6635862008933; 5035,12.6632270258088; 5040,12.6628668389635; 5045,12.662507663879; 5050,12.6621484887945; 5055,12.66178931371; 5060,12.6614301386255; 5065,12.661070963541; 5070,12.6607117884565; 5075,12.6603516016112; 5080,12.6599924265267; 5085,12.6596332514422; 5090,12.6592740763577; 5095,12.6589149012731; 5100,12.6585557261886; 5105,12.6581955393433; 5110,12.6578363642588; 5115,12.6574771891743; 5120,12.6571180140898; 5125,12.6567588390053; 5130,12.6563996639208; 5135,12.6560404888363; 5140,12.655680301991; 5145,12.6553211269065; 5150,12.654961951822; 5155,12.6546027767375; 5160,12.654243601653; 5165,12.6538844265685; 5170,12.6535242397232; 5175,12.6531650646387; 5180,12.6528058895541; 5185,12.6524467144696; 5190,12.6520875393851; 5195,
        12.6517283643006; 5200,12.6513686833357; 5205,12.6510090023708; 5210,12.6506498272863; 5215,12.6502906522018; 5220,12.6499314771173; 5225,12.6495723020328; 5230,12.6492131269483; 5235,12.648852940103; 5240,12.6484937650185; 5245,12.648134589934; 5250,12.6477754148495; 5255,12.647416239765; 5260,12.6470570646805; 5265,12.6466968778351; 5270,12.6463377027506; 5275,12.6459785276661; 5280,12.6456193525816; 5285,12.6452601774971; 5290,12.6449010024126; 5295,12.6445418273281; 5300,12.6441816404828; 5305,12.6438224653983; 5310,12.6434632903138; 5315,12.6431041152293; 5320,12.6427449401448; 5325,12.6423857650603; 5330,12.642025578215; 5335,12.6416664031305; 5340,12.641307228046; 5345,12.6409480529615; 5350,12.5812916008271; 5355,12.5812916008271; 5360,12.5812916008271; 5365,12.5812916008271; 5370,12.5812916008271; 5375,12.5812916008271; 5380,12.5812916008271; 5385,12.5812916008271; 5390,12.5812916008271; 5395,12.5812916008271; 5400,12.5816755640512; 5405,12.582634713291; 5410,
        12.5835943684111; 5415,12.5845540235313; 5420,12.585513172771; 5425,12.5864728278912; 5430,12.5874324830113; 5435,12.5883916322511; 5440,12.5893512873712; 5445,12.5903109424914; 5450,12.5912700917311; 5455,12.5922297468513; 5460,12.5931894019714; 5465,12.5941485512112; 5470,12.5951082063313; 5475,12.5960678614515; 5480,12.5970270106912; 5485,12.5979866658114; 5490,12.5989463209315; 5495,12.5999054701713; 5500,12.6008651252914; 5505,12.6018247804116; 5510,12.6027839296513; 5515,12.6037435847715; 5520,12.6047032398916; 5525,12.6056623891314; 5530,12.6066220442515; 5535,12.6075816993717; 5540,12.6085408486114; 5545,12.6095005037316; 5550,12.6104601588517; 5555,12.6114193080915; 5560,12.6123789632116; 5565,12.6133386183318; 5570,12.6142977675715; 5575,12.6152574226917; 5580,12.6162170778118; 5585,12.6171762270516; 5590,12.6181358821717; 5595,12.6190955372919; 5600,12.6200546865316; 5605,12.6210143416518; 5610,12.6219739967719; 5615,12.6229331460117; 5620,12.6238928011318; 5625,
        12.624852456252; 5630,12.6258116054917; 5635,12.6267712606119; 5640,12.627730915732; 5645,12.6286900649718; 5650,12.6296497200919; 5655,12.6306093752121; 5660,12.6315685244518; 5665,12.632528179572; 5670,12.6334878346922; 5675,12.6344469839319; 5680,12.6354066390521; 5685,12.6363662941722; 5690,12.637325443412; 5695,12.6382850985321; 5700,12.6392447536523; 5705,12.640203902892; 5710,12.6411635580122; 5715,12.6421232131323; 5720,12.6430823623721; 5725,12.6440420174922; 5730,12.6450016726124; 5735,12.6459608218521; 5740,12.6469204769723; 5745,12.6478801320924; 5750,12.6488392813322; 5755,12.6497989364523; 5760,12.6506589331335; 5765,12.6506589331335; 5770,12.6506589331335; 5775,12.6506589331335; 5780,12.6506589331335; 5785,12.6506589331335; 5790,12.6506589331335; 5795,12.6506589331335; 5800,12.6506589331335; 5805,12.6506589331335; 5810,12.6506483096451; 5815,12.6505764746282; 5820,12.6505046396113; 5825,12.650432298714; 5830,12.6503599578167; 5835,12.6502881227998; 5840,
        12.6502162877829; 5845,12.650144452766; 5850,12.6500721118687; 5855,12.6499997709714; 5860,12.6499279359545; 5865,12.6498561009376; 5870,12.6497837600403; 5875,12.6497119250234; 5880,12.6496395841261; 5885,12.6495677491092; 5890,12.6494959140923; 5895,12.649423573195; 5900,12.6493512322977; 5905,12.6492793972808; 5910,12.6492075622639; 5915,12.649135727247; 5920,12.6490633863497; 5925,12.6489910454524; 5930,12.6489192104355; 5935,12.6488473754186; 5940,12.6487755404017; 5945,12.6487031995044; 5950,12.6486308586071; 5955,12.6485590235902; 5960,12.6484871885733; 5965,12.6484153535564; 5970,12.6483430126591; 5975,12.6482706717618; 5980,12.6481988367449; 5985,12.648127001728; 5990,12.6480551667111; 5995,12.6479828258138; 6000,12.6479104849165; 6005,12.6478386498996; 6010,12.6477668148827; 6015,12.6476949798658; 6020,12.6476226389684; 6025,12.6475502980711; 6030,12.6474784630542; 6035,12.6474066280373; 6040,12.64733428714; 6045,12.6472624521231; 6050,12.6471901112258; 6055,
        12.6471182762089; 6060,12.647046441192; 6065,12.6469741002947; 6070,12.6469017593974; 6075,12.6468299243805; 6080,12.6467580893636; 6085,12.6466862543467; 6090,12.6466139134494; 6095,12.6465415725521; 6100,12.6464697375352; 6105,12.6463979025183; 6110,12.6463260675014; 6115,12.6462537266041; 6120,12.6461813857068; 6125,12.6461095506899; 6130,12.646037715673; 6135,12.6459658806561; 6140,12.6458935397588; 6145,12.6458211988615; 6150,12.6457493638446; 6155,12.6456775288277; 6160,12.6456056938108; 6165,12.6455333529135; 6170,12.6454610120162; 6175,12.6453891769993; 6180,12.6453173419824; 6185,12.6452455069655; 6190,12.6451731660682; 6195,12.6451008251709; 6200,12.645028990154; 6205,12.6449571551371; 6210,12.6448848142398; 6215,12.6448129792229; 6220,12.6447406383256; 6225,12.6446688033087; 6230,12.6445969682918; 6235,12.6445246273945; 6240,12.6444522864972; 6245,12.6443804514803; 6250,12.6443086164634; 6255,12.6442367814465; 6260,12.6441644405492; 6265,12.6440920996519; 6270,
        12.644020264635; 6275,12.6439484296181; 6280,12.6438765946012; 6285,12.6438042537039; 6290,12.6437319128066; 6295,12.6436600777897; 6300,12.6435882427728; 6305,12.6435164077559; 6310,12.6434440668586; 6315,12.6433717259613; 6320,12.6432998909444; 6325,12.6432280559275; 6330,12.6431562209106; 6335,12.6430838800133; 6340,12.643011539116; 6345,12.6429397040991; 6350,12.6428678690822; 6355,12.6427955281849; 6360,12.642723693168; 6365,12.6426513522707; 6370,12.6425795172537; 6375,12.6425076822368; 6380,12.6424353413395; 6385,12.6423630004422; 6390,12.6422911654253; 6395,12.6422193304084; 6400,12.6421474953915; 6405,12.6420751544942; 6410,12.6420028135969; 6415,12.64193097858; 6420,12.6418591435631; 6425,12.6417873085462; 6430,12.6417149676489; 6435,12.6416426267516; 6440,12.6415707917347; 6445,12.6414989567178; 6450,12.6414271217009; 6455,12.6413836159865; 6460,12.6413836159865; 6465,12.6413836159865; 6470,12.6413836159865; 6475,12.6413836159865; 6480,12.6413836159865; 6485,
        12.6413836159865; 6490,12.6413836159865; 6495,12.6413836159865; 6500,12.6413836159865; 6505,12.6416886618681; 6510,12.6425370233001; 6515,12.6433853847321; 6520,12.6442337461641; 6525,12.6450826134765; 6530,12.6459304690281; 6535,12.6467793363405; 6540,12.6476271918921; 6545,12.6484760592045; 6550,12.6493244206364; 6555,12.6501727820684; 6560,12.6510211435004; 6565,12.6518695049324; 6570,12.6527178663644; 6575,12.6535662277964; 6580,12.6544145892284; 6585,12.6552629506604; 6590,12.6561113120924; 6595,12.6569596735244; 6600,12.6578085408368; 6605,12.6586563963884; 6610,12.6595052637008; 6615,12.6603531192524; 6620,12.6612019865648; 6625,12.661371456499; 6630,12.661371456499; 6635,12.661371456499; 6640,12.661371456499; 6645,12.661371456499; 6650,12.661371456499; 6655,12.661371456499; 6660,12.661371456499; 6665,12.661371456499; 6670,12.661371456499; 6675,12.5983539349823; 6680,12.5983539349823; 6685,12.5983539349823; 6690,12.5983539349823; 6695,12.5983539349823; 6700,
        12.5983539349823; 6705,12.5983539349823; 6710,12.5983539349823; 6715,12.5983539349823; 6720,12.5983539349823; 6725,12.5987869686053; 6730,12.5993282606341; 6735,12.5998690467824; 6740,12.6004098329308; 6745,12.6009511249595; 6750,12.6014924169883; 6755,12.6020326972563; 6760,12.602573989285; 6765,12.6031152813138; 6770,12.6036565733426; 6775,12.6041968536105; 6780,12.6047381456393; 6785,12.605279437668; 6790,12.605819717936; 6795,12.6063610099648; 6800,12.6069023019935; 6805,12.6074435940223; 6810,12.6079838742902; 6815,12.608525166319; 6820,12.6090664583478; 6825,12.6096072444961; 6830,12.6101480306445; 6835,12.6106893226733; 6840,12.611230614702; 6845,12.61177089497; 6850,12.6123121869987; 6855,12.6128534790275; 6860,12.6133947710563; 6865,12.6139350513242; 6870,12.614476343353; 6875,12.6150176353818; 6880,12.6155579156497; 6885,12.6160992076785; 6890,12.6166404997072; 6895,12.617181791736; 6900,12.617722072004; 6905,12.6182633640327; 6910,12.6188046560615; 6915,
        12.6193454422098; 6920,12.6198862283582; 6925,12.620427520387; 6930,12.6209688124157; 6935,12.6215090926837; 6940,12.6220503847125; 6945,12.6771276074596; 6950,12.6771276074596; 6955,12.6771276074596; 6960,12.6771276074596; 6965,12.6771276074596; 6970,12.6771276074596; 6975,12.6771276074596; 6980,12.6771276074596; 6985,12.6771276074596; 6990,12.6771276074596; 6995,12.6768564555648; 7000,12.6765175156963; 7005,12.6761785758278; 7010,12.6758396359594; 7015,12.6755006960909; 7020,12.6751627679832; 7025,12.6748238281147; 7030,12.6744848882463; 7035,12.6741459483778; 7040,12.6738070085093; 7045,12.6734680686408; 7050,12.6731291287724; 7055,12.6727901889039; 7060,12.6724512490354; 7065,12.6721123091669; 7070,12.6717733692984; 7075,12.67143442943; 7080,12.6710954895615; 7085,12.670756549693; 7090,12.6704176098245; 7095,12.6700786699561; 7100,12.6697397300876; 7105,12.6694007902191; 7110,12.6690618503506; 7115,12.6687229104822; 7120,12.6683849823745; 7125,12.668046042506; 7130,
        12.6677071026375; 7135,12.667368162769; 7140,12.6670292229006; 7145,12.6666902830321; 7150,12.6663513431636; 7155,12.6660124032951; 7160,12.6656734634267; 7165,12.6653345235582; 7170,12.6649955836897; 7175,12.6646566438212; 7180,12.6643177039527; 7185,12.6639787640843; 7190,12.6636398242158; 7195,12.6633008843473; 7200,12.6629619444788; 7205,12.6626230046104; 7210,12.6622840647419; 7215,12.6619451248734; 7220,12.6616071967657; 7225,12.6612682568973; 7230,12.6609293170288; 7235,12.6605903771603; 7240,12.6602514372918; 7245,12.6599124974233; 7250,12.6595735575549; 7255,12.6592346176864; 7260,12.6588956778179; 7265,12.6585567379494; 7270,12.658217798081; 7275,12.6578788582125; 7280,12.657539918344; 7285,12.6572009784755; 7290,12.6568620386071; 7295,12.6565230987386; 7300,12.6561841588701; 7305,12.6558452190016; 7310,12.6555062791331; 7315,12.6551673392647; 7320,12.6548283993962; 7325,12.6544904712885; 7330,12.65415153142; 7335,12.6538125915516; 7340,12.6534736516831; 7345,
        12.6531347118146; 7350,12.6527957719461; 7355,12.6524568320777; 7360,12.6521178922092; 7365,12.6517789523407; 7370,12.6514400124722; 7375,12.6511010726037; 7380,12.6507621327353; 7385,12.6504231928668; 7390,12.6500842529983; 7395,12.6497453131298; 7400,12.6494063732614; 7405,12.6490674333929; 7410,12.6487284935244; 7415,12.6483895536559; 7420,12.6480506137875; 7425,12.6477126856798; 7430,12.6473737458113; 7435,12.6470348059428; 7440,12.6466958660743; 7445,12.6463569262059; 7450,12.6460179863374; 7455,12.6456790464689; 7460,12.6453401066004; 7465,12.645001166732; 7470,12.6446622268635; 7475,12.644323286995; 7480,12.6439843471265; 7485,12.643645407258; 7490,12.6433064673896; 7495,12.6429675275211; 7500,12.6426285876526; 7505,12.6422896477841; 7510,12.6419507079157; 7515,12.6416117680472; 7520,12.6412728281787; 7525,12.640934900071; 7530,12.6405959602026; 7535,12.6402570203341; 7540,12.6399180804656; 7545,12.6395791405971; 7550,12.6392402007286; 7555,12.6389012608602; 7560,
        12.6385623209917; 7565,12.6382233811232; 7570,12.6378844412547; 7575,12.6375455013863; 7580,12.6372065615178; 7585,12.6368676216493; 7590,12.6365286817808; 7595,12.6361897419124; 7600,12.6358508020439; 7605,12.6355118621754; 7610,12.6350292522731; 7615,12.6344869484836; 7620,12.6339441388136; 7625,12.6334013291436; 7630,12.6328590253541; 7635,12.6323167215645; 7640,12.6317739118945; 7645,12.6312311022246; 7650,12.630688798435; 7655,12.6301464946454; 7660,12.6296041908559; 7665,12.6290613811859; 7670,12.628518571516; 7675,12.6279762677264; 7680,12.6274339639368; 7685,12.6268911542669; 7690,12.6263483445969; 7695,12.6258060408073; 7700,12.6252637370178; 7705,12.6247214332282; 7710,12.6241786235582; 7715,12.6236358138883; 7720,12.6230935100987; 7725,12.6225512063092; 7730,12.6220083966392; 7735,12.6214655869692; 7740,12.6209232831797; 7745,12.6203809793901; 7750,12.6198386756005; 7755,12.6196211470282; 7760,12.6196211470282; 7765,12.6196211470282; 7770,12.6196211470282; 7775,
        12.6196211470282; 7780,12.6196211470282; 7785,12.6196211470282; 7790,12.6196211470282; 7795,12.6196211470282; 7800,12.6196211470282; 7805,12.6937614609154; 7810,12.6937614609154; 7815,12.6937614609154; 7820,12.6937614609154; 7825,12.6937614609154; 7830,12.6937614609154; 7835,12.6937614609154; 7840,12.6937614609154; 7845,12.6937614609154; 7850,12.6937614609154; 7855,12.6937614609154; 7860,12.6937614609154; 7865,12.6937614609154; 7870,12.6937614609154; 7875,12.6937614609154; 7880,12.6937614609154; 7885,12.6937614609154; 7890,12.6937614609154; 7895,12.5929779439639; 7900,12.5929779439639; 7905,12.5929779439639; 7910,12.5929779439639; 7915,12.5929779439639; 7920,12.5929779439639; 7925,12.5929779439639; 7930,12.5929779439639; 7935,12.5929779439639; 7940,12.5929779439639; 7945,12.5929779439639; 7950,12.5929779439639; 7955,12.5929779439639; 7960,12.5929779439639; 7965,12.5929779439639; 7970,12.5929779439639; 7975,12.5929779439639; 7980,12.5930275202432; 7985,12.594587655399; 7990,
        12.5962671783294; 7995,12.5979456894989; 8000,12.5996252124293; 8005,12.6013037235988; 8010,12.6029832465292; 8015,12.6046617576988; 8020,12.6063412806291; 8025,12.6080197917987; 8030,12.6096993147291; 8035,12.611378331779; 8040,12.613057348829; 8045,12.614736365879; 8050,12.6164153829289; 8055,12.6180949058593; 8060,12.6197734170288; 8065,12.6214529399592; 8070,12.6231314511288; 8075,12.6248109740591; 8080,12.6264894852287; 8085,12.6281690081591; 8090,12.6298475193286; 8095,12.631527042259; 8100,12.6332055534286; 8105,12.6348850763589; 8110,12.6365635875285; 8115,12.6382431104588; 8120,12.6399221275088; 8125,12.6416011445588; 8130,12.6432806674891; 8135,12.6449591786587; 8140,12.6466387015891; 8145,12.6483172127586; 8150,12.649996735689; 8155,12.6516752468586; 8160,12.6533547697889; 8165,12.6550332809585; 8170,12.6567128038888; 8175,12.6583913150584; 8180,12.6600708379888; 8185,12.661078551747; 8190,12.661078551747; 8195,12.661078551747; 8200,12.661078551747; 8205,
        12.661078551747; 8210,12.661078551747; 8215,12.661078551747; 8220,12.661078551747; 8225,12.661078551747; 8230,12.661078551747; 8235,12.6387226850787; 8240,12.6387226850787; 8245,12.6387226850787; 8250,12.6387226850787; 8255,12.6387226850787; 8260,12.6387226850787; 8265,12.6387226850787; 8270,12.6387226850787; 8275,12.6387226850787; 8280,12.6387226850787; 8285,12.639495670331; 8290,12.6414281334617; 8295,12.6433616083533; 8300,12.645294071484; 8305,12.6472265346147; 8310,12.6491600095062; 8315,12.6510924726369; 8320,12.6530249357677; 8325,12.6549584106592; 8330,12.6568908737899; 8335,12.6588233369206; 8340,12.6607568118121; 8345,12.6626892749429; 8350,12.664622243954; 8355,12.6665552129651; 8360,12.6684876760958; 8365,12.6704206451069; 8370,12.6723536141181; 8375,12.6742860772488; 8380,12.6762190462599; 8385,12.678152015271; 8390,12.6800844784017; 8395,12.6820179532933; 8400,12.683950416424; 8405,12.6858828795547; 8410,12.6878163544462; 8415,12.689748817577; 8420,
        12.6916812807077; 8425,12.6936147555992; 8430,12.6955472187299; 8435,12.6974796818606; 8440,12.6994131567522; 8445,12.7013456198829; 8450,12.7032780830136; 8455,12.7052115579051; 8460,12.7071440210358; 8465,12.7090764841666; 8470,12.7090764841666; 8475,12.7090764841666; 8480,12.7090764841666; 8485,12.7090764841666; 8490,12.7090764841666; 8495,12.7090764841666; 8500,12.7090764841666; 8505,12.7090764841666; 8510,12.7090764841666; 8515,12.3602805478424; 8520,10.8292178327947; 8525,10.558651747517; 8530,10.5585920536297; 8535,10.5585323597424; 8540,10.5584726658552; 8545,10.5584129719679; 8550,10.5583527722002; 8555,10.5582925724325; 8560,10.5582328785452; 8565,10.5581731846579; 8570,10.5581134907706; 8575,10.5580537968834; 8580,10.5579941029961; 8585,10.5579339032284; 8590,10.5578742093411; 8595,10.5578140095734; 8600,10.5577543156861; 8605,10.5576946217989; 8610,10.5576349279116; 8615,10.5575752340243; 8620,10.557515540137; 8625,10.5574553403693; 8630,10.5573951406016; 8635,
        10.5573354467144; 8640,10.5572757528271; 8645,10.5572160589398; 8650,10.5571563650525; 8655,10.5570966711652; 8660,10.5570364713975; 8665,10.5569762716298; 8670,10.5569165777426; 8675,10.5568568838553; 8680,10.556797189968; 8685,10.5567374960807; 8690,10.5566778021934; 8695,10.5566176024257; 8700,10.5565574026581; 8705,10.5564977087708; 8710,10.5564380148835; 8715,10.5563783209962; 8720,10.5563186271089; 8725,10.5562589332216; 8730,10.556198733454; 8735,10.5561385336863; 8740,10.556078839799; 8745,10.5560191459117; 8750,10.5559594520244; 8755,10.5558997581371; 8760,10.5558400642498; 8765,10.5557798644822; 8770,10.5557196647145; 8775,10.5556599708272; 8780,10.5556002769399; 8785,10.5555405830526; 8790,10.5554808891653; 8795,10.5554211952781; 8800,10.5553609955104; 8805,10.5553013016231; 8810,10.5552411018554; 8815,10.5551814079681; 8820,10.5551217140808; 8825,10.5550620201936; 8830,10.5550023263063; 8835,10.554942632419; 8840,10.5548824326513; 8845,10.5548222328836; 8850,
        10.5547625389963; 8855,10.554702845109; 8860,10.5546431512218; 8865,10.5545834573345; 8870,10.5545237634472; 8875,10.5544635636795; 8880,10.5544033639118; 8885,10.5543436700245; 8890,10.5542839761373; 8895,10.55422428225; 8900,10.5541645883627; 8905,10.5541048944754; 8910,10.5540446947077; 8915,10.55398449494; 8920,10.5539248010528; 8925,10.5538651071655; 8930,10.5538054132782; 8935,10.5537457193909; 8940,10.5536860255036; 8945,10.5536258257359; 8950,10.5535656259682; 8955,10.553505932081; 8960,10.5534462381937; 8965,10.5533865443064; 8970,10.5533268504191; 8975,10.5532671565318; 8980,10.5532069567641; 8985,10.5531467569965; 8990,10.5530870631092; 8995,10.5530273692219; 9000,10.5529676753346; 9005,10.5529079814473; 9010,10.55284828756; 9015,10.5527880877924; 9020,10.5527283939051; 9025,10.5526681941374; 9030,10.5526085002501; 9035,10.5525488063628; 9040,10.5524891124755; 9045,10.5524294185882; 9050,10.5523692188206; 9055,10.5523095249333; 9060,10.5522493251656; 9065,
        10.5521896312783; 9070,10.552129937391; 9075,10.5520702435037; 9080,10.5520105496165; 9085,10.5519508557292; 9090,10.5518906559615; 9095,10.5518304561938; 9100,10.5517707623065; 9105,10.5517110684192; 9110,10.551651374532; 9115,10.5515916806447; 9120,10.5515319867574; 9125,10.5514717869897; 9130,10.551411587222; 9135,10.5513518933347; 9140,10.5513281169559; 9145,10.5513281169559; 9150,10.5513281169559; 9155,10.5513281169559; 9160,10.5513281169559; 9165,10.5513281169559; 9170,10.5513281169559; 9175,10.5513281169559; 9180,10.5513281169559; 9185,10.5513281169559; 9190,11.5426791736134; 9195,11.9033860639724; 9200,11.9033860639724; 9205,11.9033860639724; 9210,11.9033860639724; 9215,12.4577095718567; 9220,12.6804993003303; 9225,12.6804993003303; 9230,12.6804993003303; 9235,12.6804993003303; 9240,12.6804993003303; 9245,12.6804993003303; 9250,12.6804993003303; 9255,12.6804993003303; 9260,12.6804993003303; 9265,12.6804993003303; 9270,12.6804993003303; 9275,12.6804993003303; 9280,
        12.6804993003303; 9285,12.6804993003303; 9290,12.6804993003303; 9295,12.6804993003303; 9300,12.6804993003303; 9305,12.6804993003303; 9310,12.6804993003303; 9315,12.6731276111312; 9320,12.6731276111312; 9325,12.6731276111312; 9330,12.6731276111312; 9335,12.6731276111312; 9340,12.6731276111312; 9345,12.6731276111312; 9350,12.6731276111312; 9355,12.6731276111312; 9360,12.6731276111312; 9365,12.6731392463804; 9370,12.6731979285069; 9375,12.6732566106333; 9380,12.6733152927598; 9385,12.6733739748863; 9390,12.6734326570128; 9395,12.6734913391393; 9400,12.6735500212657; 9405,12.6736087033922; 9410,12.6736673855187; 9415,12.6737260676452; 9420,12.6737847497717; 9425,12.6738434318982; 9430,12.6739021140246; 9435,12.6739607961511; 9440,12.6740194782776; 9445,12.6740786662845; 9450,12.674137348411; 9455,12.6741960305375; 9460,12.6742547126639; 9465,12.6743133947904; 9470,12.6743720769169; 9475,12.6744307590434; 9480,12.6744894411699; 9485,12.6745481232964; 9490,12.6746068054228; 9495,
        12.6746068054228; 9500,12.6746068054228; 9505,12.6746068054228; 9510,12.6746068054228; 9515,12.6746068054228; 9520,12.6746068054228; 9525,12.6746068054228; 9530,12.6746068054228; 9535,12.6746068054228; 9540,12.6656446282438; 9545,12.6158786438238; 9550,12.6158786438238; 9555,12.6158786438238; 9560,12.6158786438238; 9565,12.6158786438238; 9570,12.6158786438238; 9575,12.6158786438238; 9580,12.6158786438238; 9585,12.6158786438238; 9590,12.6158786438238; 9595,12.6160142197712; 9600,12.6161836897054; 9605,12.6163531596396; 9610,12.6165221236935; 9615,12.6166915936277; 9620,12.6168610635619; 9625,12.6170300276158; 9630,12.61719949755; 9635,12.6173689674843; 9640,12.6175379315381; 9645,12.6177074014723; 9650,12.6178768714066; 9655,12.6180463413408; 9660,12.6182153053947; 9665,12.6183847753289; 9670,12.6185542452631; 9675,12.618723209317; 9680,12.6188926792512; 9685,12.6190621491854; 9690,12.6192316191197; 9695,12.6194005831735; 9700,12.7070215979789; 9705,12.7070215979789; 9710,
        12.7070215979789; 9715,12.7070215979789; 9720,12.7070215979789; 9725,12.7070215979789; 9730,12.7070215979789; 9735,12.7070215979789; 9740,12.7070215979789; 9745,12.7070215979789; 9750,12.7070215979789; 9755,12.7070215979789; 9760,12.7070215979789; 9765,12.7070215979789; 9770,12.7070215979789; 9775,12.7070215979789; 9780,12.7070215979789; 9785,12.7070215979789; 9790,12.7070215979789; 9795,12.7070215979789; 9800,12.7070215979789; 9805,12.7070215979789; 9810,12.7070215979789; 9815,12.7070215979789; 9820,12.7070215979789; 9825,12.7070215979789; 9830,12.7070215979789; 9835,12.7070215979789; 9840,12.7070215979789; 9845,12.7070215979789; 9850,12.7070215979789; 9855,12.7070215979789; 9860,12.7070215979789; 9865,12.7070215979789; 9870,12.7070215979789; 9875,12.7070215979789; 9880,12.7070215979789; 9885,12.7070215979789; 9890,12.7070215979789; 9895,12.7070215979789; 9900,12.7070215979789; 9905,12.7070215979789; 9910,12.7070215979789; 9915,12.7070215979789; 9920,12.7070215979789; 9925,
        12.7070215979789; 9930,12.7070215979789; 9935,12.7070215979789; 9940,12.7070215979789; 9945,12.7070215979789; 9950,12.7070215979789; 9955,12.7070215979789; 9960,12.7070215979789; 9965,12.7070215979789; 9970,12.7070215979789; 9975,12.7070215979789; 9980,12.6506447684823; 9985,12.6506447684823; 9990,12.6506447684823; 9995,12.6506447684823; 10000,12.6506447684823; 10005,12.6506447684823; 10010,12.6506447684823; 10015,12.6506447684823; 10020,12.6506447684823; 10025,12.6506447684823; 10030,12.6515760943; 10035,12.6539041559041; 10040,12.6562322175082; 10045,12.6585607849926; 10050,12.6608893524771; 10055,12.6632174140812; 10060,12.6655454756853; 10065,12.6678735372894; 10070,12.6702021047738; 10075,12.6725301663779; 10080,12.672996082227; 10085,12.672996082227; 10090,12.672996082227; 10095,12.672996082227; 10100,12.672996082227; 10105,12.672996082227; 10110,12.672996082227; 10115,12.672996082227; 10120,12.672996082227; 10125,12.672996082227; 10130,10.8610437805643; 10135,
        10.6576060009395; 10140,10.5644516663112; 10145,10.5644516663112; 10150,10.5644516663112; 10155,10.5644516663112; 10160,10.5644516663112; 10165,10.5644516663112; 10170,10.5644516663112; 10175,10.5644516663112; 10180,10.5644516663112; 10185,10.5644516663112; 10190,10.5644977014276; 10195,10.5645437365441; 10200,10.564590277541; 10205,10.5646368185378; 10210,10.5646828536543; 10215,10.5647288887708; 10220,10.5647754297676; 10225,10.5648219707645; 10230,10.564868005881; 10235,10.5649140409974; 10240,10.5649605819943; 10245,10.5650071229912; 10250,10.565053663988; 10255,10.5650991932241; 10260,10.5651457342209; 10265,10.5651922752178; 10270,10.5652388162147; 10275,10.5652843454507; 10280,10.5653308864476; 10285,10.5653774274445; 10290,10.5654239684413; 10295,10.5654700035578; 10300,10.5655160386743; 10305,10.5655625796711; 10310,10.565609120668; 10315,10.5656551557845; 10320,10.5657011909009; 10325,10.5657477318978; 10330,10.5657942728947; 10335,10.5658403080111; 10340,
        10.5658863431276; 10345,10.5659328841245; 10350,10.5659794251213; 10355,10.5660254602378; 10360,10.5660714953543; 10365,10.5661180363511; 10370,10.566164577348; 10375,10.5662111183448; 10380,10.5662566475809; 10385,10.5663031885778; 10390,10.5663497295746; 10395,10.5663962705715; 10400,10.5664417998076; 10405,10.5664883408044; 10410,10.5665348818013; 10415,10.5665814227982; 10420,10.5666269520342; 10425,10.5666734930311; 10430,10.566720034028; 10435,10.5667665750248; 10440,10.5668126101413; 10445,10.5668586452578; 10450,10.5669051862546; 10455,10.5669517272515; 10460,10.566997762368; 10465,10.5670437974844; 10470,10.5670903384813; 10475,10.5671368794782; 10480,10.5671829145946; 10485,10.5672289497111; 10490,10.5672754907079; 10495,10.5673220317048; 10500,10.5673680668213; 10505,10.5674141019377; 10510,10.5674606429346; 10515,10.5675071839315; 10520,10.5675537249283; 10525,10.5675992541644; 10530,10.5676457951613; 10535,10.5676923361581; 10540,10.567738877155; 10545,
        10.5677844063911; 10550,10.5678309473879; 10555,10.5678774883848; 10560,10.5679240293817; 10565,10.5679700644981; 10570,10.5680160996146; 10575,10.5680626406115; 10580,10.5681091816083; 10585,10.5681552167248; 10590,10.5682012518412; 10595,10.5682477928381; 10600,10.568294333835; 10605,10.5683403689514; 10610,10.5683864040679; 10615,10.5684329450648; 10620,10.5684794860616; 10625,10.5685255211781; 10630,10.5685715562946; 10635,10.5686180972914; 10640,10.5686646382883; 10645,10.5687106734048; 10650,10.5687567085212; 10655,10.5688032495181; 10660,10.568849790515; 10665,10.5688963315118; 10670,10.5689418607479; 10675,10.5689884017448; 10680,10.5690349427416; 10685,10.5690814837385; 10690,10.5691270129746; 10695,10.5691735539714; 10700,10.5692200949683; 10705,10.5692666359651; 10710,11.3189090489232; 10715,11.6699849882134; 10720,11.9033860639724; 10725,11.9033860639724; 10730,11.9033860639724; 10735,11.9033860639724; 10740,11.9033860639724; 10745,11.9033860639724; 10750,
        12.3675313316258; 10755,12.3675313316258; 10760,12.3675313316258; 10765,12.3675313316258; 10770,12.6354132154973; 10775,12.6354132154973; 10780,12.6354132154973; 10785,12.6354132154973; 10790,12.6354132154973; 10795,12.8528972703282; 10800,12.8528972703282; 10805,12.8528972703282; 10810,12.8528972703282; 10815,12.8528972703282; 10820,12.8528972703282; 10825,12.8528972703282; 10830,12.8528972703282; 10835,12.8528972703282; 10840,12.8528972703282; 10845,12.8528972703282; 10850,12.7300983442181; 10855,12.7286945261062; 10860,12.7272902021138; 10865,12.7258863840018; 10870,12.7244825658898; 10875,12.7230782418975; 10880,12.7216744237855; 10885,12.7202706056735; 10890,12.7188662816811; 10895,12.7174624635692; 10900,12.7160586454572; 10905,12.7146548273452; 10910,12.7132505033528; 10915,12.7118466852409; 10920,12.7104428671289; 10925,12.7090385431365; 10930,12.7076347250245; 10935,12.7062309069126; 10940,12.7048265829202; 10945,12.7034227648082; 10950,12.7020189466962; 10955,
        12.7006146227038; 10960,12.6992108045919; 10965,12.6978069864799; 10970,12.6964026624875; 10975,12.6949988443755; 10980,12.6935950262636; 10985,12.6921912081516; 10990,12.6907868841592; 10995,12.6893830660472; 11000,12.6879792479353; 11005,12.6865749239429; 11010,12.6851711058309; 11015,12.6837672877189; 11020,12.6823629637266; 11025,12.6809591456146; 11030,12.6795553275026; 11035,12.6781510035102; 11040,12.6767471853982; 11045,12.6753433672863; 11050,12.6739390432939; 11055,12.6725352251819; 11060,12.6711314070699; 11065,12.6697270830776; 11070,12.6683232649656; 11075,12.6669194468536; 11080,12.6655151228612; 11085,12.6641113047493; 11090,12.6627074866373; 11095,12.6613031626449; 11100,12.6598993445329; 11105,12.658495526421; 11110,12.6570912024286; 11115,12.6556873843166; 11120,12.6542835662046; 11125,12.6528797480926; 11130,12.6514754241003; 11135,12.6500716059883; 11140,12.6486677878763; 11145,12.6472634638839; 11150,12.645859645772; 11155,12.64445582766; 11160,
        12.6430515036676; 11165,12.6416476855556; 11170,12.6402438674437; 11175,12.6388395434513; 11180,12.6374357253393; 11185,12.6360319072273; 11190,12.5810285430187; 11195,12.5810285430187; 11200,12.5810285430187; 11205,12.5810285430187; 11210,12.5810285430187; 11215,12.5810285430187; 11220,12.5810285430187; 11225,12.5810285430187; 11230,12.5810285430187; 11235,12.5810285430187; 11240,12.5812941302291; 11245,12.5819583511952; 11250,12.5826220662809; 11255,12.5832862872471; 11260,12.5839505082132; 11265,12.5846147291794; 11270,12.5852789501455; 11275,12.5859426652312; 11280,12.5866068861974; 11285,12.5872711071635; 11290,12.5879353281296; 11295,12.5885995490958; 11300,12.5892632641815; 11305,12.5899274851476; 11310,12.5905917061138; 11315,12.5912554211995; 11320,12.591920148046; 11325,12.5925838631318; 11330,12.6487952697373; 11335,12.6491311743234; 11340,12.6494670789094; 11345,12.6498029834955; 11350,12.6501383822012; 11355,12.6504742867873; 11360,12.6508101913733; 11365,
        12.6511460959594; 11370,12.6514820005455; 11375,12.6518179051316; 11380,12.6521538097176; 11385,12.6524897143037; 11390,12.6528256188898; 11395,12.6531615234758; 11400,12.6534969221815; 11405,12.6538328267676; 11410,12.6541687313537; 11415,12.6545046359397; 11420,12.6548405405258; 11425,12.6551764451119; 11430,12.6555118438176; 11435,12.6558477484036; 11440,12.6561836529897; 11445,12.6565195575758; 11450,12.6568554621618; 11455,12.6571913667479; 11460,12.657527271334; 11465,12.6578631759201; 11470,12.6581990805061; 11475,12.6585349850922; 11480,12.6588703837979; 11485,12.659206288384; 11490,12.65954219297; 11495,12.6598780975561; 11500,12.6602140021422; 11505,12.6605499067282; 11510,12.6608853054339; 11515,12.66122121002; 11520,12.6615571146061; 11525,12.6618930191921; 11530,12.6622289237782; 11535,12.6625648283643; 11540,12.6629007329504; 11545,12.6632366375364; 11550,12.6635725421225; 11555,12.6639084467086; 11560,12.6642438454142; 11565,12.6645797500003; 11570,
        12.6649156545864; 11575,12.6652515591725; 11580,12.6655874637585; 11585,12.6659233683446; 11590,12.6662587670503; 11595,12.6665946716364; 11600,12.6669305762224; 11605,12.6672664808085; 11610,12.6676023853946; 11615,12.6679382899806; 11620,12.6682741945667; 11625,12.6686100991528; 11630,12.6689460037389; 11635,12.6692819083249; 11640,12.6696173070306; 11645,12.6699532116167; 11650,12.6702891162028; 11655,12.6706250207888; 11660,12.6709609253749; 11665,12.671296829961; 11670,12.6716322286666; 11675,12.6719681332527; 11680,12.6723040378388; 11685,12.6726399424249; 11690,12.6729758470109; 11695,12.673311751597; 11700,12.6736476561831; 11705,12.6739835607692; 11710,12.6743194653552; 11715,12.6746553699413; 11720,12.674990768647; 11725,12.675326673233; 11730,12.6756625778191; 11735,12.6759984824052; 11740,12.6763343869913; 11745,12.6766702915773; 11750,12.677005690283; 11755,12.6773415948691; 11760,12.6776774994552; 11765,12.6780134040412; 11770,12.6783493086273; 11775,
        12.6786852132134; 11780,12.6790211177994; 11785,12.6793570223855; 11790,12.6796929269716; 11795,12.6800288315577; 11800,12.6803642302633; 11805,12.6807001348494; 11810,12.6810360394355; 11815,12.6813719440216; 11820,12.6817078486076; 11825,12.6820437531937; 11830,12.6823791518994; 11835,12.6827150564854; 11840,12.6830509610715; 11845,12.6833868656576; 11850,12.6837227702437; 11855,12.6840586748297; 11860,12.6843945794158; 11865,12.6847304840019; 11870,12.685066388588; 11875,12.685402293174; 11880,12.6857376918797; 11885,12.6860735964658; 11890,12.6864095010518; 11895,12.6867454056379; 11900,12.687081310224; 11905,12.6874172148101; 11910,12.6877526135157; 11915,12.6880885181018; 11920,12.6901565571799; 11925,12.7423067559285; 11930,12.7423067559285; 11935,12.7423067559285; 11940,12.7423067559285; 11945,12.7423067559285; 11950,12.7423067559285; 11955,12.7423067559285; 11960,12.7423067559285; 11965,12.7423067559285; 11970,12.7423067559285; 11975,12.7415201119054; 11980,
        12.7405371862868; 11985,12.7395537547879; 11990,12.7385708291693; 11995,12.7375879035507; 12000,12.7366044720517; 12005,12.7356215464331; 12010,12.7346386208145; 12015,12.7336551893156; 12020,12.732672263697; 12025,12.7316893380784; 12030,12.7307059065794; 12035,12.7297229809608; 12040,12.7287400553422; 12045,12.7277566238433; 12050,12.7267736982247; 12055,12.7257907726061; 12060,12.7248073411071; 12065,12.7238244154885; 12070,12.7228414898699; 12075,12.721858058371; 12080,12.7208751327524; 12085,12.7198922071338; 12090,12.7189087756348; 12095,12.7179258500162; 12100,12.7169429243976; 12105,12.7159594928986; 12110,12.7149765672801; 12115,12.7139936416615; 12120,12.7130102101625; 12125,12.7120272845439; 12130,12.7110443589253; 12135,12.7100609274263; 12140,12.7090780018078; 12145,12.7080950761892; 12150,12.7071116446902; 12155,12.7061287190716; 12160,12.705145793453; 12165,12.704162361954; 12170,12.7031794363355; 12175,12.7021965107169; 12180,12.7012130792179; 12185,
        12.7002301535993; 12190,12.6992472279807; 12195,12.6982637964817; 12200,12.6972808708632; 12205,12.6962979452446; 12210,12.6953145137456; 12215,12.694331588127; 12220,12.6933486625084; 12225,12.6923652310094; 12230,12.6913823053909; 12235,12.6903993797723; 12240,12.6894159482733; 12245,12.6884330226547; 12250,12.6874500970361; 12255,12.6864666655371; 12260,12.6854837399185; 12265,12.6845008143; 12270,12.683517382801; 12275,12.6825344571824; 12280,12.6815515315638; 12285,12.6805681000648; 12290,12.6795851744462; 12295,12.6786022488277; 12300,12.6776188173287; 12305,12.6766358917101; 12310,12.6756529660915; 12315,12.6746695345925; 12320,12.6736866089739; 12325,12.6727036833554; 12330,12.6717202518564; 12335,12.6707373262378; 12340,12.6697544006192; 12345,12.6687709691202; 12350,12.6677880435016; 12355,12.6668051178831; 12360,12.6658216863841; 12365,12.6648387607655; 12370,12.6638558351469; 12375,12.6628724036479; 12380,12.6618894780293; 12385,12.6609065524107; 12390,
        12.6599231209118; 12395,12.6589401952932; 12400,12.6579572696746; 12405,12.6569738381756; 12410,12.6559914184374; 12415,12.6550079869384; 12420,12.6540250613199; 12425,12.6530421357013; 12430,12.6520587042023; 12435,12.6510757785837; 12440,12.6500928529651; 12445,12.6491094214661; 12450,12.5680709224349; 12455,12.5651924629548; 12460,12.562312991714; 12465,12.5594340263535; 12470,12.5565550609931; 12475,12.5536755897522; 12480,12.5507971302721; 12485,12.5479176590313; 12490,12.5450386936708; 12495,12.5421597283104; 12500,12.5392802570695; 12505,12.5364017975895; 12510,12.5335223263486; 12515,12.5306428551078; 12520,12.5289157794197; 12525,12.5289157794197; 12530,12.5289157794197; 12535,12.5289157794197; 12540,12.5289157794197; 12545,12.5289157794197; 12550,12.5289157794197; 12555,12.5289157794197; 12560,12.5289157794197; 12565,12.5289157794197; 12570,12.5960633085279; 12575,12.5986761807975; 12580,12.6012895589476; 12585,12.6039024312173; 12590,12.6065158093674; 12595,
        12.6091286816371; 12600,12.6117420597871; 12605,12.6143549320568; 12610,12.6169683102069; 12615,12.6195811824766; 12620,12.6221940547463; 12625,12.6227171350806; 12630,12.6227171350806; 12635,12.6227171350806; 12640,12.6227171350806; 12645,12.6227171350806; 12650,12.6227171350806; 12655,12.6227171350806; 12660,12.6227171350806; 12665,12.6227171350806; 12670,12.6227171350806; 12675,12.5955528752036; 12680,12.5955528752036; 12685,12.5955528752036; 12690,12.5955528752036; 12695,12.5955528752036; 12700,12.5955528752036; 12705,12.5955528752036; 12710,12.5955528752036; 12715,12.5955528752036; 12720,12.5955528752036; 12725,12.5959717441753; 12730,12.5964953303901; 12735,12.5970194224852; 12740,12.5975430087; 12745,12.5980671007951; 12750,12.5985906870098; 12755,12.599114779105; 12760,12.5996383653197; 12765,12.6001624574148; 12770,12.6006860436296; 12775,12.6012101357247; 12780,12.6017337219395; 12785,12.6022578140346; 12790,12.6027814002493; 12795,12.6033054923445; 12800,
        12.6038290785592; 12805,12.6043531706543; 12810,12.6048767568691; 12815,12.6054008489642; 12820,12.605924435179; 12825,12.6064485272741; 12830,12.6069721134888; 12835,12.607496205584; 12840,12.6080197917987; 12845,12.6085438838938; 12850,12.6090674701086; 12855,12.6095915622037; 12860,12.6101151484185; 12865,12.6106392405136; 12870,12.6111628267283; 12875,12.6116869188235; 12880,12.6122105050382; 12885,12.6127345971333; 12890,12.6132581833481; 12895,12.6137822754432; 12900,12.6143058616579; 12905,12.6148299537531; 12910,12.6153535399678; 12915,12.615877632063; 12920,12.6164012182777; 12925,12.6169253103728; 12930,12.6174488965876; 12935,12.6179724828023; 12940,12.6184965748974; 12945,12.6190206669926; 12950,12.6195442532073; 12955,12.6200678394221; 12960,12.6205919315172; 12965,12.6211160236123; 12970,12.6216396098271; 12975,12.6221631960418; 12980,12.6226872881369; 12985,12.6232108743517; 12990,12.6237349664468; 12995,12.6242585526616; 13000,12.6247826447567; 13005,
        12.6253062309714; 13010,12.6258303230666; 13015,12.6263539092813; 13020,12.6268780013764; 13025,12.6274015875912; 13030,12.6279256796863; 13035,12.6284492659011; 13040,12.6289733579962; 13045,12.6294969442109; 13050,12.6300210363061; 13055,12.6305446225208; 13060,12.6310687146159; 13065,12.6315923008307; 13070,12.6321163929258; 13075,12.6326399791406; 13080,12.6331640712357; 13085,12.6336876574504; 13090,12.6342117495456; 13095,12.6347353357603; 13100,12.6352594278554; 13105,12.6357830140702; 13110,12.6363071061653; 13115,12.6368306923801; 13120,12.6373547844752; 13125,12.6378783706899; 13130,12.6384024627851; 13135,12.6389260489998; 13140,12.6394501410949; 13145,12.6399737273097; 13150,12.6404978194048; 13155,12.6410214056196; 13160,12.6415454977147; 13165,12.6420690839294; 13170,12.6425931760246; 13175,12.6431167622393; 13180,12.6436408543344; 13185,12.6441644405492; 13190,12.6446885326443; 13195,12.6452121188591; 13200,12.6457362109542; 13205,12.6462597971689; 13210,
        12.6467833833837; 13215,12.6473074754788; 13220,12.6478315675739; 13225,12.6483551537887; 13230,12.6619334896242; 13235,12.6619334896242; 13240,12.6619334896242; 13245,12.6619334896242; 13250,12.6619334896242; 13255,12.6619334896242; 13260,12.6619334896242; 13265,12.6619334896242; 13270,12.6619334896242; 13275,12.6619334896242; 13280,12.7151870135268; 13285,12.7151870135268; 13290,12.7151870135268; 13295,12.7151870135268; 13300,12.7151870135268; 13305,12.6808630283384; 13310,12.6808630283384; 13315,12.6808630283384; 13320,12.6816198254179; 13325,12.682566833528; 13330,12.6835138416382; 13335,12.6844608497483; 13340,12.6854038108152; 13345,12.6861646549379; 13350,12.687111663048; 13355,12.6880586711582; 13360,12.6890056792683; 13365,12.689952181498; 13370,12.689952181498; 13375,12.689952181498; 13380,12.689952181498; 13385,12.689952181498; 13390,12.689952181498; 13395,12.689952181498; 13400,12.689952181498; 13405,12.6907094844579; 13410,12.691656492568; 13415,12.6926035006782;
        13420,12.6935500029079; 13425,12.6944965051376; 13430,12.6954435132478; 13435,12.6963905213579; 13440,12.697337529468; 13445,12.6982845375782; 13450,12.6992310398079; 13455,12.7001775420376; 13460,12.7011245501478; 13465,12.7020715582579; 13470,12.703018566368; 13475,12.7039650685978; 13480,12.7049115708275; 13485,12.7058585789376; 13490,12.7068055870478; 13495,12.7077525951579; 13500,12.7086990973876; 13505,12.7096455996174; 13510,12.7105926077275; 13515,12.7115396158376; 13520,12.7124866239478; 13525,12.7134336320579; 13530,12.7143796284072; 13535,12.7153266365174; 13540,12.7162736446275; 13545,12.7172206527376; 13550,12.7181676608478; 13555,12.7191141630775; 13560,12.7198527484625; 13565,12.7198527484625; 13570,12.7198527484625; 13575,12.7198527484625; 13580,12.7198527484625; 13585,12.7198527484625; 13590,12.7198527484625; 13595,12.7198527484625; 13600,12.7198527484625; 13605,12.7198527484625; 13610,12.7194890204544; 13615,12.718023990814; 13620,12.7165589611735; 13625,
        12.7150944374134; 13630,12.713629407773; 13635,12.7121643781325; 13640,12.710699348492; 13645,12.709234824732; 13650,12.7077697950915; 13655,12.7063047654511; 13660,12.705718955947; 13665,12.705718955947; 13670,12.705718955947; 13675,12.705718955947; 13680,12.705718955947; 13685,12.705718955947; 13690,12.705718955947; 13695,12.705718955947; 13700,12.705718955947; 13705,12.705718955947; 13710,12.8422879465645; 13715,12.8422879465645; 13720,12.8422879465645; 13725,12.8422879465645; 13730,12.8422879465645; 13735,12.8422879465645; 13740,12.8422879465645; 13745,12.8422879465645; 13750,12.8422879465645; 13755,12.8422879465645; 13760,12.8422879465645; 13765,12.8422879465645; 13770,12.8422879465645; 13775,12.8422879465645; 13780,12.8422879465645; 13785,12.8422879465645; 13790,12.8422879465645; 13795,12.8422879465645; 13800,12.8422879465645; 13805,12.7308951058493; 13810,12.7308951058493; 13815,12.7308951058493; 13820,12.7308951058493; 13825,12.7308951058493; 13830,12.7308951058493;
        13835,12.7308951058493; 13840,12.7308951058493; 13845,12.7308951058493; 13850,12.7308951058493; 13855,12.7308951058493; 13860,12.7308951058493; 13865,12.7308951058493; 13870,12.6537473329799; 13875,12.6531493823462; 13880,12.6525509258322; 13885,12.6519529751985; 13890,12.6513545186845; 13895,12.6507565680509; 13900,12.6501586174172; 13905,12.6495606667836; 13910,12.6489622102695; 13915,12.6483637537555; 13920,12.6477658031219; 13925,12.6471678524882; 13930,12.6465699018546; 13935,12.6459714453405; 13940,12.6453729888265; 13945,12.6447750381928; 13950,12.6441770875592; 13955,12.6435791369256; 13960,12.6429811862919; 13965,12.6423827297779; 13970,12.6417842732638; 13975,12.6411863226302; 13980,12.6405883719965; 13985,12.6399904213629; 13990,12.6393919648489; 13995,12.6387935083348; 14000,12.6381955577012; 14005,12.6375976070675; 14010,12.6369996564339; 14015,12.6364011999199; 14020,12.6358032492862; 14025,12.6352047927722; 14030,12.6346068421385; 14035,12.6340088915049; 14040,
        12.6334109408712; 14045,12.6328124843572; 14050,12.6322140278432; 14055,12.6316160772095; 14060,12.6310181265759; 14065,12.6304201759422; 14070,12.6298217194282; 14075,12.6292232629141; 14080,12.6286253122805; 14085,12.6280273616469; 14090,12.6274294110132; 14095,12.6268309544992; 14100,12.6262330038655; 14105,12.6256345473515; 14110,12.6250365967179; 14115,12.6244386460842; 14120,12.6238406954506; 14125,12.6232422389365; 14130,12.6226437824225; 14135,12.6220458317888; 14140,12.6214478811552; 14145,12.6208499305216; 14150,12.6202514740075; 14155,12.6196530174935; 14160,12.6190550668598; 14165,12.6184571162262; 14170,12.6178591655926; 14175,12.6172612149589; 14180,12.6166627584449; 14185,12.6160643019308; 14190,12.6154663512972; 14195,12.6148684006635; 14200,12.6142704500299; 14205,12.6136719935159; 14210,12.6130735370018; 14215,12.6124755863682; 14220,12.6118776357345; 14225,12.6112796851009; 14230,12.6106812285868; 14235,12.6100832779532; 14240,12.6094848214392; 14245,
        12.6088868708055; 14250,12.6082889201719; 14255,12.6076909695382; 14260,12.6070925130242; 14265,12.6064940565102; 14270,12.6058961058765; 14275,12.6052981552429; 14280,12.6047002046092; 14285,12.6041017480952; 14290,12.6035032915811; 14295,12.6029053409475; 14300,12.6023073903139; 14305,12.6017094396802; 14310,12.6011109831662; 14315,12.6005130325325; 14320,12.5999145760185; 14325,12.5993166253848; 14330,12.5987186747512; 14335,12.5981207241176; 14340,12.5975222676035; 14345,12.5969238110895; 14350,12.5963258604558; 14355,12.5957279098222; 14360,12.5951299591886; 14365,12.5945315026745; 14370,12.5939330461605; 14375,12.5933350955268; 14380,12.5723658470369; 14385,12.5723658470369; 14390,12.5723658470369; 14395,12.5723658470369; 14400,12.5723658470369; 14405,12.5723658470369; 14410,12.5723658470369; 14415,12.5723658470369; 14420,12.5723658470369; 14425,12.5723658470369; 14430,12.572882350926; 14435,12.5741733577087; 14440,12.5754648703717; 14445,12.5767558771543; 14450,
        12.5780468839369; 14455,12.5793378907195; 14460,12.5806288975021; 14465,12.5819199042848; 14470,12.5832109110674; 14475,12.58450191785; 14480,12.5857929246326; 14485,12.5870839314152; 14490,12.5883754440782; 14495,12.5896664508609; 14500,12.5909579635239; 14505,12.5922489703065; 14510,12.5935399770891; 14515,12.5948309838717; 14520,12.5961219906544; 14525,12.597412997437; 14530,12.5987040042196; 14535,12.5999950110022; 14540,12.6012860177848; 14545,12.6025770245674; 14550,12.6038685372305; 14555,12.6051595440131; 14560,12.6064505507957; 14565,12.6077420634587; 14570,12.6090330702413; 14575,12.6103240770239; 14580,12.6116150838066; 14585,12.6129060905892; 14590,12.6141970973718; 14595,12.6154881041544; 14600,12.616779110937; 14605,12.6180701177196; 14610,12.6193611245023; 14615,12.6206526371653; 14620,12.6219436439479; 14625,12.6232351566109; 14630,12.6245261633935; 14635,12.6258171701762; 14640,12.6271081769588; 14645,12.6283991837414; 14650,12.629690190524; 14655,
        12.6309811973066; 14660,12.6322722040892; 14665,12.6335632108719; 14670,12.6348542176545; 14675,12.6361457303175; 14680,12.6374367371001; 14685,12.6387277438827; 14690,12.6400192565457; 14695,12.6413102633284; 14700,12.642601270111; 14705,12.642601270111; 14710,12.642601270111; 14715,12.642601270111; 14720,12.642601270111; 14725,12.642601270111; 14730,12.642601270111; 14735,12.642601270111; 14740,12.642601270111; 14745,12.642601270111; 14750,12.6425891289814; 14755,12.6343984194134; 14760,12.625453442168; 14765,12.6165094766835; 14770,12.6075644994381; 14775,12.5986205339535; 14780,12.5896755567081; 14785,12.5823686202002; 14790,12.5823686202002; 14795,12.5823686202002; 14800,12.5823686202002; 14805,12.5823686202002; 14810,12.5823686202002; 14815,12.5823686202002; 14820,12.5823686202002; 14825,12.5823686202002; 14830,12.5823686202002; 14835,12.5823686202002; 14840,12.5823686202002; 14845,12.5823686202002; 14850,12.5823686202002; 14855,12.5823686202002; 14860,12.5823686202002;
        14865,12.5823686202002; 14870,12.5823686202002; 14875,12.5823686202002; 14880,12.5823686202002; 14885,12.5823686202002; 14890,12.5823686202002; 14895,12.5823686202002; 14900,12.5823686202002; 14905,12.5823686202002; 14910,12.5823686202002; 14915,12.5823686202002; 14920,12.5823686202002; 14925,12.6221510549122; 14930,12.6619334896242; 14935,12.6619334896242; 14940,12.6619334896242; 14945,12.6619334896242; 14950,12.6619334896242; 14955,12.6619334896242; 14960,12.6619334896242; 14965,12.6619334896242; 14970,12.6619334896242; 14975,12.6619334896242; 14980,12.6619334896242; 14985,12.6619334896242; 14990,12.6619334896242; 14995,12.6619334896242; 15000,12.6433697024397; 15005,12.6433697024397; 15010,12.6433697024397; 15015,12.6433697024397; 15020,12.6433697024397; 15025,12.6433697024397; 15030,12.6433697024397; 15035,12.5792149617822; 15040,12.5792149617822; 15045,12.5792149617822; 15050,12.5792149617822; 15055,12.5792149617822; 15060,12.5792149617822; 15065,12.5792149617822; 15070,
        12.5792149617822; 15075,12.5792149617822; 15080,12.5792149617822; 15085,12.5796621600564; 15090,12.5804083336474; 15095,12.5811540013581; 15100,12.5819001749491; 15105,12.5826463485402; 15110,12.5833920162508; 15115,12.5841381898419; 15120,12.5848838575525; 15125,12.5856300311436; 15130,12.5863756988542; 15135,12.5871218724453; 15140,12.5878680460363; 15145,12.588613713747; 15150,12.589359887338; 15155,12.5901055550487; 15160,12.5908517286397; 15165,12.5915979022308; 15170,12.5923435699414; 15175,12.5930897435325; 15180,12.5938354112431; 15185,12.5945815848342; 15190,12.5953272525448; 15195,12.5960734261359; 15200,12.5968195997269; 15205,12.5975652674376; 15210,12.5983114410286; 15215,12.5990571087393; 15220,12.5998032823303; 15225,12.6005494559214; 15230,12.601295123632; 15235,12.6020412972231; 15240,12.6027869649337; 15245,12.6035331385248; 15250,12.6042788062354; 15255,12.6050249798265; 15260,12.6057711534175; 15265,12.6065168211282; 15270,12.6072629947192; 15275,
        12.6080086624299; 15280,12.6087548360209; 15285,12.6095005037316; 15290,12.6102466773226; 15295,12.6109928509137; 15300,12.6117385186243; 15305,12.6124846922154; 15310,12.613230359926; 15315,12.6139765335171; 15320,12.6147222012277; 15325,12.6154683748188; 15330,12.6162145484098; 15335,12.6169602161205; 15340,12.6177063897115; 15345,12.6184520574222; 15350,12.6191982310132; 15355,12.6199438987239; 15360,12.6206900723149; 15365,12.621436245906; 15370,12.6221819136166; 15375,12.6229280872077; 15380,12.6236737549183; 15385,12.6244199285094; 15390,12.62516559622; 15395,12.6259117698111; 15400,12.6266579434021; 15405,12.6274036111128; 15410,12.6281497847038; 15415,12.6288954524145; 15420,12.6296416260055; 15425,12.6303877995966; 15430,12.6311334673072; 15435,12.6318796408983; 15440,12.6326253086089; 15445,12.6332222474818; 15450,12.6332222474818; 15455,12.6332222474818; 15460,12.6332222474818; 15465,12.6332222474818; 15470,12.6332222474818; 15475,12.6332222474818; 15480,
        12.6332222474818; 15485,12.6332222474818; 15490,12.6332222474818; 15495,12.6049834976336; 15500,12.5878199873983; 15505,12.5878199873983; 15510,12.5878199873983; 15515,12.5878199873983; 15520,12.5878199873983; 15525,12.5878199873983; 15530,12.5878199873983; 15535,12.5878199873983; 15540,12.5878199873983; 15545,12.5878199873983; 15550,12.5886319254414; 15555,12.589444369365; 15560,12.5902563074081; 15565,12.5910687513316; 15570,12.5918806893748; 15575,12.5926931332983; 15580,12.5935050713415; 15585,12.594317515265; 15590,12.5951294533082; 15595,12.5959418972317; 15600,12.5967538352748; 15605,12.5975662791984; 15610,12.5983782172415; 15615,12.5991906611651; 15620,12.6000025992082; 15625,12.6008150431318; 15630,12.6016269811749; 15635,12.6024394250984; 15640,12.6032513631416; 15645,12.6040638070651; 15650,12.6048757451083; 15655,12.6056881890318; 15660,12.606500127075; 15665,12.6073125709985; 15670,12.6081245090416; 15675,12.6089369529652; 15680,12.6097488910083; 15685,
        12.6105608290515; 15690,12.611373272975; 15695,12.6121857168986; 15700,12.6129976549417; 15705,12.6138095929849; 15710,12.6146220369084; 15715,12.6154344808319; 15720,12.6162464188751; 15725,12.6170583569182; 15730,12.6178708008418; 15735,12.6186832447653; 15740,12.6194951828085; 15745,12.6203071208516; 15750,12.6211195647751; 15755,12.6219320086987; 15760,12.6227439467418; 15765,12.623555884785; 15770,12.6243683287085; 15775,12.6251802667517; 15780,12.6259927106752; 15785,12.6268046487183; 15790,12.6276170926419; 15795,12.628429030685; 15800,12.6292414746086; 15805,12.6300534126517; 15810,12.6308658565753; 15815,12.6316777946184; 15820,12.6324902385419; 15825,12.6333021765851; 15830,12.6341146205086; 15835,12.6349265585518; 15840,12.6357390024753; 15845,12.6365509405185; 15850,12.637363384442; 15855,12.6381753224852; 15860,12.6389877664087; 15865,12.6397997044518; 15870,12.6406121483754; 15875,12.6414240864185; 15880,12.6422365303421; 15885,12.6430484683852; 15890,
        12.6438609123088; 15895,12.6446728503519; 15900,12.6454852942754; 15905,12.6462972323186; 15910,12.6471096762421; 15915,12.6479216142853; 15920,12.6487340582088; 15925,12.649545996252; 15930,12.6503584401755; 15935,12.6511703782186; 15940,12.6519828221422; 15945,12.6527947601853; 15950,12.6536072041089; 15955,12.654419142152; 15960,12.6552315860756; 15965,12.6560435241187; 15970,12.6568559680422; 15975,12.6576679060854; 15980,12.6584803500089; 15985,12.6592922880521; 15990,12.6601047319756; 15995,12.6609166700188; 16000,12.6617291139423; 16005,12.6625410519855; 16010,12.663353495909; 16015,12.6641654339521; 16020,12.6649778778757; 16025,12.6657898159188; 16030,12.6666022598424; 16035,12.6674141978855; 16040,12.6682266418091; 16045,12.6690385798522; 16050,12.6698510237757; 16055,12.6706629618189; 16060,12.6714754057424; 16065,12.6722873437856; 16070,12.6730997877091; 16075,12.6739117257523; 16080,12.6747241696758; 16085,12.6755361077189; 16090,12.6763485516425; 16095,
        12.6771604896856; 16100,12.6779729336092; 16105,12.6787848716523; 16110,12.6795973155759; 16115,12.680409253619; 16120,12.6812216975425; 16125,12.6820336355857; 16130,12.6828460795092; 16135,12.6830084671179; 16140,12.6830084671179; 16145,12.6830084671179; 16150,12.6830084671179; 16155,12.6830084671179; 16160,12.6830084671179; 16165,12.6830084671179; 16170,12.6830084671179; 16175,12.6830084671179; 16180,12.6830084671179; 16185,12.6365878697877; 16190,12.6365878697877; 16195,12.635401580248; 16200,12.6334245996421; 16205,12.6318432175094; 16210,12.6298667427839; 16215,12.6278897621779; 16220,12.6259132874523; 16225,12.6239363068463; 16230,12.6219593262403; 16235,12.621168635174; 16240,12.621168635174; 16245,12.5662426706667; 16250,12.5657135197675; 16255,12.5651843688684; 16260,12.5646552179693; 16265,12.5641255611897; 16270,12.5635964102906; 16275,12.563066753511; 16280,12.5625376026119; 16285,12.5620084517127; 16290,12.5614787949332; 16295,12.560949644034; 16300,
        12.5604199872545; 16305,12.5598908363553; 16310,12.5593616854562; 16315,12.5588325345571; 16320,12.5583028777775; 16325,12.5577737268784; 16330,12.5572440700988; 16335,12.5567149191997; 16340,12.5561857683005; 16345,12.5556566174014; 16350,12.5551269606218; 16355,12.5545978097227; 16360,12.5540681529432; 16365,12.553539002044; 16370,12.5530098511449; 16375,12.5524801943653; 16380,12.5519510434662; 16385,12.5514213866866; 16390,12.5508922357875; 16395,12.5503630848883; 16400,12.5498339339892; 16405,12.5493042772096; 16410,12.5487751263105; 16415,12.548245469531; 16420,12.5477163186318; 16425,12.5471871677327; 16430,12.5466580168335; 16435,12.546128360054; 16440,12.5458106671623; 16445,12.5458106671623; 16450,12.5458106671623; 16455,12.5458106671623; 16460,12.5458106671623; 16465,12.5458106671623; 16470,12.5458106671623; 16475,12.5458106671623; 16480,12.5458106671623; 16485,12.5458106671623; 16490,12.5531894386871; 16495,12.5531894386871; 16500,12.5531894386871; 16505,
        12.6677096320395; 16510,12.6702177870663; 16515,12.672725942093; 16520,12.6752335912393; 16525,12.677741746266; 16530,12.6802499012928; 16535,12.6827580563195; 16540,12.6852662113462; 16545,12.6877738604926; 16550,12.6902820155193; 16555,12.692790170546; 16560,12.6952983255728; 16565,12.6978064805995; 16570,12.7003146356262; 16575,12.702822790653; 16580,12.7053309456797; 16585,12.7078391007064; 16590,12.7103472557331; 16595,12.7128554107599; 16600,12.7153635657866; 16605,12.7178717208133; 16610,12.7203798758401; 16615,12.7228880308668; 16620,12.7253961858935; 16625,12.7274025075628; 16630,12.7274025075628; 16635,12.7274025075628; 16640,12.7274025075628; 16645,12.7274025075628; 16650,12.7274025075628; 16655,12.7274025075628; 16660,12.7274025075628; 16665,12.7274025075628; 16670,12.7274025075628; 16675,12.685804973973; 16680,12.685804973973; 16685,12.685804973973; 16690,12.685804973973; 16695,12.685804973973; 16700,12.685804973973; 16705,12.685804973973; 16710,12.6289197346737;
        16715,12.6115417311485; 16720,12.6115417311485; 16725,12.6115417311485; 16730,12.6115417311485; 16735,12.6115417311485; 16740,12.6115417311485; 16745,12.6115417311485; 16750,12.6115417311485; 16755,12.6115417311485; 16760,12.6115417311485; 16765,12.6115417311485; 16770,12.6115417311485; 16775,12.6115417311485; 16780,12.6115417311485; 16785,12.6345011131348; 16790,12.6345011131348; 16795,12.6345011131348; 16800,12.6345011131348; 16805,12.6345011131348; 16810,12.6345011131348; 16815,12.6345011131348; 16820,12.6345011131348; 16825,12.6345011131348; 16830,12.6345011131348; 16835,12.6338105863878; 16840,12.6326592025958; 16845,12.6315078188038; 16850,12.6310469617587; 16855,12.6310469617587; 16860,12.6310469617587; 16865,12.6310469617587; 16870,12.6310469617587; 16875,12.6310469617587; 16880,12.6310469617587; 16885,12.6310469617587; 16890,12.6310469617587; 16895,12.6310469617587; 16900,12.6899385227272; 16905,12.6899385227272; 16910,12.6899385227272; 16915,12.6899385227272; 16920,
        12.6899385227272; 16925,12.6899385227272; 16930,12.6899385227272; 16935,12.6899385227272; 16940,12.6899385227272; 16945,12.6899385227272; 16950,12.6897852409658; 16955,12.6894027953829; 16960,12.6890203497999; 16965,12.688637904217; 16970,12.688255458634; 16975,12.6878730130511; 16980,12.6874905674682; 16985,12.6871081218852; 16990,12.6867256763023; 16995,12.6863432307194; 17000,12.6859607851364; 17005,12.6855778336731; 17010,12.6851953880901; 17015,12.6848129425072; 17020,12.6844304969243; 17025,12.6840480513413; 17030,12.6836656057584; 17035,12.6832831601754; 17040,12.6829007145925; 17045,12.6825182690096; 17050,12.6821353175462; 17055,12.6817528719633; 17060,12.6813704263804; 17065,12.6809879807974; 17070,12.6806055352145; 17075,12.6802230896315; 17080,12.6798406440486; 17085,12.6794581984657; 17090,12.6790757528827; 17095,12.6786933072998; 17100,12.6783108617168; 17105,12.6779284161339; 17110,12.677545970551; 17115,12.677163524968; 17120,12.6767805735047; 17125,
        12.6763981279218; 17130,12.6760156823388; 17135,12.6756332367559; 17140,12.6752507911729; 17145,12.67486834559; 17150,12.6744859000071; 17155,12.6741034544241; 17160,12.6737210088412; 17165,12.6733380573778; 17170,12.6729556117949; 17175,12.672573166212; 17180,12.672190720629; 17185,12.6718082750461; 17190,12.6714258294632; 17195,12.6710433838802; 17200,12.6706609382973; 17205,12.6702784927143; 17210,12.6698960471314; 17215,12.6695136015485; 17220,12.6691311559655; 17225,12.6687487103826; 17230,12.6683662647997; 17235,12.6679833133363; 17240,12.6676008677534; 17245,12.6672184221704; 17250,12.6668359765875; 17255,12.6664535310046; 17260,12.6660710854216; 17265,12.6656886398387; 17270,12.6653061942557; 17275,12.6649237486728; 17280,12.6645407972095; 17285,12.6641583516265; 17290,12.6637759060436; 17295,12.6633934604606; 17300,12.6630110148777; 17305,12.6626285692948; 17310,12.6622461237118; 17315,12.6618636781289; 17320,12.661481232546; 17325,12.661098786963; 17330,
        12.6607163413801; 17335,12.6603338957971; 17340,12.6599514502142; 17345,12.6595690046313; 17350,12.6591860531679; 17355,12.658803607585; 17360,12.6584211620021; 17365,12.6580387164191; 17370,12.6576562708362; 17375,12.6572738252532; 17380,12.6568913796703; 17385,12.6565089340874; 17390,12.6561264885044; 17395,12.6557435370411; 17400,12.6553610914581; 17405,12.6549786458752; 17410,12.6545962002923; 17415,12.6542137547093; 17420,12.6538313091264; 17425,12.6534488635435; 17430,12.6530664179605; 17435,12.6526839723776; 17440,12.6523015267946; 17445,12.6519190812117; 17450,12.6515366356288; 17455,12.6511541900458; 17460,12.6507717444629; 17465,12.6503887929995; 17470,12.6500063474166; 17475,12.6496239018337; 17480,12.6492414562507; 17485,12.6488590106678; 17490,12.6484765650849; 17495,12.6480941195019; 17500,12.6477880618595; 17505,12.6477880618595; 17510,12.6477880618595; 17515,12.6477880618595; 17520,12.6477880618595; 17525,12.6477880618595; 17530,12.6477880618595; 17535,
        12.6477880618595; 17540,12.6477880618595; 17545,12.6477880618595; 17550,12.6525984785899; 17555,12.6525984785899; 17560,12.6525984785899; 17565,12.6525984785899; 17570,12.6525984785899; 17575,12.6525984785899; 17580,12.6525984785899; 17585,12.6525984785899; 17590,12.6525984785899; 17595,12.6525984785899; 17600,12.6525711610482; 17605,12.6524330556988; 17610,12.6522949503494; 17615,12.6521573508804; 17620,12.652019245531; 17625,12.6518811401816; 17630,12.6517435407127; 17635,12.6516059412437; 17640,12.6514673300139; 17645,12.6513297305449; 17650,12.6511921310759; 17655,12.6510540257265; 17660,12.6509159203771; 17665,12.6507783209081; 17670,12.6506402155587; 17675,12.6505021102093; 17680,12.6503645107403; 17685,12.6502269112713; 17690,12.6500888059219; 17695,12.6499507005725; 17700,12.6498131011035; 17705,12.6496749957541; 17710,12.6495368904047; 17715,12.6493992909357; 17720,12.6492616914668; 17725,12.6491235861174; 17730,12.648985480768; 17735,12.648847881299; 17740,
        12.6487097759496; 17745,12.6485716706002; 17750,12.6484340711312; 17755,12.6482964716622; 17760,12.6481583663128; 17765,12.6480202609634; 17770,12.6478826614944; 17775,12.647744556145; 17780,12.6476064507956; 17785,12.6474688513266; 17790,12.6473312518576; 17795,12.6471931465082; 17800,12.6470550411588; 17805,12.6469174416899; 17810,12.6467793363405; 17815,12.6466412309911; 17820,12.6465036315221; 17825,12.6463660320531; 17830,12.6462279267037; 17835,12.6460898213543; 17840,12.6459522218853; 17845,12.6458141165359; 17850,12.6456760111865; 17855,12.6455384117175; 17860,12.6454008122485; 17865,12.6452622010187; 17870,12.6451246015497; 17875,12.6449870020807; 17880,12.6448488967313; 17885,12.644710791382; 17890,12.644573191913; 17895,12.6444350865636; 17900,12.6442969812142; 17905,12.6441593817452; 17910,12.6440217822762; 17915,12.6438836769268; 17920,12.6437455715774; 17925,12.6436079721084; 17930,12.643469866759; 17935,12.6433317614096; 17940,12.6431941619406; 17945,
        12.6430565624716; 17950,12.6429184571222; 17955,12.6427803517728; 17960,12.6426427523038; 17965,12.6425046469544; 17970,12.6423665416051; 17975,12.6422289421361; 17980,12.6420913426671; 17985,12.6419532373177; 17990,12.6418151319683; 17995,12.6416775324993; 18000,12.6415394271499; 18005,12.6414013218005; 18010,12.6412637223315; 18015,12.6411261228625; 18020,12.6409880175131; 18025,12.6408499121637; 18030,12.6407123126947; 18035,12.6405742073453; 18040,12.6404361019959; 18045,12.6402985025269; 18050,12.6401609030579; 18055,12.6400227977086; 18060,12.6398846923592; 18065,12.6397470928902; 18070,12.6396089875408; 18075,12.6394708821914; 18080,12.6393332827224; 18085,12.6391956832534; 18090,12.6390570720236; 18095,12.6389194725546; 18100,12.6387818730856; 18105,12.6386437677362; 18110,12.6385056623868; 18115,12.6383680629178; 18120,12.6382299575684; 18125,12.638091852219; 18130,12.63795425275; 18135,12.637816653281; 18140,12.6376785479317; 18145,12.6375404425823; 18150,
        12.6374028431133; 18155,12.6372647377639; 18160,12.6371266324145; 18165,12.6369890329455; 18170,12.6368514334765; 18175,12.6367133281271; 18180,12.6365752227777; 18185,12.6364376233087; 18190,12.6362995179593; 18195,12.6361614126099; 18200,12.6360238131409; 18205,12.6358862136719; 18210,12.6357481083225; 18215,12.6356100029731; 18220,12.6354724035041; 18225,12.6353342981548; 18230,12.6351961928054; 18235,12.6350585933364; 18240,12.6349209938674; 18245,12.634782888518; 18250,12.6346447831686; 18255,12.6345071836996; 18260,12.6343690783502; 18265,12.6342309730008; 18270,12.6340933735318; 18275,12.6339557740628; 18280,12.633817162833; 18285,12.633679563364; 18290,12.633541963895; 18295,12.6334038585456; 18300,12.6332657531962; 18305,12.6331281537272; 18310,12.6329905542583; 18315,12.6328519430285; 18320,12.5691064596151; 18325,12.5691064596151; 18330,12.5691064596151; 18335,12.5691064596151; 18340,12.5691064596151; 18345,12.5691064596151; 18350,12.5691064596151; 18355,
        12.5691064596151; 18360,12.5691064596151; 18365,12.5691064596151; 18370,12.5691064596151; 18375,12.5691064596151; 18380,12.5691064596151; 18385,12.5691064596151; 18390,12.5691064596151; 18395,12.5691064596151; 18400,12.5691064596151; 18405,12.5691064596151; 18410,12.5691064596151; 18415,12.5691064596151; 18420,12.5691064596151; 18425,12.5691064596151; 18430,12.5691064596151; 18435,12.6302102355759; 18440,12.6306943631194; 18445,12.6311789965433; 18450,12.6316626182064; 18455,12.6321472516303; 18460,12.6326313791737; 18465,12.6331155067172; 18470,12.6335996342607; 18475,12.6340837618042; 18480,12.6345683952281; 18485,12.6350520168912; 18490,12.635536650315; 18495,12.6360207778585; 18500,12.636504905402; 18505,12.6369895388259; 18510,12.637473160489; 18515,12.6379577939128; 18520,12.6384419214563; 18525,12.6389260489998; 18530,12.6394101765433; 18535,12.6398943040868; 18540,12.6403789375107; 18545,12.6408625591737; 18550,12.6413471925976; 18555,12.6418313201411; 18560,
        12.6423154476846; 18565,12.6428000811085; 18570,12.6432837027715; 18575,12.6437683361954; 18580,12.6442524637389; 18585,12.6447365912824; 18590,12.6452207188259; 18595,12.6457048463693; 18600,12.6461894797932; 18605,12.6466736073367; 18610,12.6471577348802; 18615,12.6476418624237; 18620,12.6481259899672; 18625,12.648610623391; 18630,12.6490942450541; 18635,12.649578878478; 18640,12.6500630060215; 18645,12.650547133565; 18650,12.6510312611084; 18655,12.6515153886519; 18660,12.6518062698823; 18665,12.6518062698823; 18670,12.6518062698823; 18675,12.6518062698823; 18680,12.6518062698823; 18685,12.6518062698823; 18690,12.6518062698823; 18695,12.6518062698823; 18700,12.6518062698823; 18705,12.6518062698823; 18710,12.5689713895481; 18715,12.5682884510072; 18720,12.5676055124662; 18725,12.566923585686; 18730,12.5662406471451; 18735,12.5655577086041; 18740,12.5648747700632; 18745,12.5641918315222; 18750,12.5635088929812; 18755,12.5628259544403; 18760,12.5621430158993; 18765,
        12.5614600773584; 18770,12.5607771388174; 18775,12.5600942002764; 18780,12.5594122734963; 18785,12.5587293349553; 18790,12.5580463964144; 18795,12.5573634578734; 18800,12.5566805193324; 18805,12.5559975807915; 18810,12.5553146422505; 18815,12.5546317037095; 18820,12.5539487651686; 18825,12.5532658266276; 18830,12.5525828880867; 18835,12.5519009613065; 18840,12.5512180227655; 18845,12.5505350842246; 18850,12.5498521456836; 18855,12.5491692071427; 18860,12.5484862686017; 18865,12.5478033300607; 18870,12.5471203915198; 18875,12.5464374529788; 18880,12.5457545144379; 18885,12.5450725876577; 18890,12.5443896491167; 18895,12.5441164737003; 18900,12.5441164737003; 18905,12.5441164737003; 18910,12.5441164737003; 18915,12.5441164737003; 18920,12.5441164737003; 18925,12.5441164737003; 18930,12.5441164737003; 18935,12.5441164737003; 18940,12.5441164737003; 18945,12.598281594085; 18950,12.598281594085; 18955,12.598281594085; 18960,12.598281594085; 18965,12.7023371454683; 18970,
        12.7033645885621; 18975,12.7043925375364; 18980,12.7054199806302; 18985,12.7064474237241; 18990,12.7074753726983; 18995,12.7085028157922; 19000,12.709530258886; 19005,12.7105582078602; 19010,12.7115856509541; 19015,12.7126130940479; 19020,12.7136410430222; 19025,12.714668486116; 19030,12.7156959292099; 19035,12.7167238781841; 19040,12.717751321278; 19045,12.7187787643718; 19050,12.7198067133461; 19055,12.7208341564399; 19060,12.7218615995338; 19065,12.722889548508; 19070,12.7239169916018; 19075,12.7249444346957; 19080,12.7259723836699; 19085,12.7269998267638; 19090,12.7280272698576; 19095,12.7290552188319; 19100,12.7300826619257; 19105,12.7311101050196; 19110,12.7321380539938; 19115,12.7331654970877; 19120,12.7341929401815; 19125,12.7352208891558; 19130,12.7362483322496; 19135,12.7372757753435; 19140,12.7383037243177; 19145,12.7393311674115; 19150,12.7403586105054; 19155,12.7413865594796; 19160,12.7424140025735; 19165,12.7434414456673; 19170,12.7444693946416; 19175,
        12.7444693946416; 19180,12.7444693946416; 19185,12.7444693946416; 19190,12.7444693946416; 19195,12.7444693946416; 19200,12.7444693946416; 19205,12.7444693946416; 19210,12.7452909444123; 19215,12.7463188933866; 19220,12.7473468423608; 19225,12.7483737795743; 19230,12.7494017285485; 19235,12.7504296775228; 19240,12.7514566147362; 19245,12.7524845637105; 19250,12.7535125126847; 19255,12.7545394498982; 19260,12.7839397011463; 19265,12.7839397011463; 19270,12.7839397011463; 19275,12.8443372680678; 19280,12.8530803990333; 19285,12.8530803990333; 19290,12.8530803990333; 19295,12.8530803990333; 19300,12.8530803990333; 19305,12.8530803990333; 19310,12.8530803990333; 19315,12.8530803990333; 19320,12.8530803990333; 19325,12.8530803990333; 19330,12.8493849427061; 19335,12.8456894863789; 19340,12.8419935241713; 19345,12.8382980678441; 19350,12.8346026115169; 19355,12.8309071551897; 19360,12.8272116988625; 19365,12.8235162425353; 19370,12.8198207862081; 19375,12.8161253298809; 19380,
        12.8124298735536; 19385,12.8087344172264; 19390,12.8050389608992; 19395,12.801343504572; 19400,12.7976480482448; 19405,12.7480864395067; 19410,12.7282402455063; 19415,12.7282402455063; 19420,12.7282402455063; 19425,12.7282402455063; 19430,12.7282402455063; 19435,12.7282402455063; 19440,12.7282402455063; 19445,12.7282402455063; 19450,12.7282402455063; 19455,12.7282402455063; 19460,12.7282402455063; 19465,12.7282402455063; 19470,12.7282402455063; 19475,12.7282402455063; 19480,12.6607633882573; 19485,12.6588607720703; 19490,12.6569576500028; 19495,12.6550555396961; 19500,12.6531524176286; 19505,12.6512498014416; 19510,12.6493471852545; 19515,12.647444063187; 19520,12.6455419528803; 19525,12.6436388308128; 19530,12.6417367205062; 19535,12.6398335984387; 19540,12.6379304763712; 19545,12.6360283660645; 19550,12.634125243997; 19555,12.6322231336904; 19560,12.6303200116229; 19565,12.6284173954358; 19570,12.6265147792487; 19575,12.6246116571813; 19580,12.6227095468746; 19585,
        12.6208064248071; 19590,12.61890380862; 19595,12.6170011924329; 19600,12.6150980703655; 19605,12.5425801149234; 19610,12.5425801149234; 19615,12.5425801149234; 19620,12.4311892977298; 19625,12.4311892977298; 19630,12.4311892977298; 19635,12.4311892977298; 19640,12.4311892977298; 19645,12.4311892977298; 19650,12.4311892977298; 19655,12.3857238025962; 19660,12.3728349817468; 19665,12.3728349817468; 19670,12.3728349817468; 19675,12.3728349817468; 19680,12.3728349817468; 19685,12.3728349817468; 19690,12.3728349817468; 19695,12.3728349817468; 19700,12.3728349817468; 19705,12.3728349817468; 19710,12.3728349817468; 19715,12.3145251832391; 19720,12.3019702434543; 19725,12.3019702434543; 19730,12.3019702434543; 19735,12.3019702434543; 19740,12.3019702434543; 19745,12.3019702434543; 19750,12.3019702434543; 19755,12.3019702434543; 19760,12.3019702434543; 19765,12.3019702434543; 19770,12.3028393459827; 19775,12.3037074367503; 19780,12.3045765392787; 19785,12.3054446300464; 19790,
        12.3063137325748; 19795,12.3071818233424; 19800,12.3080509258708; 19805,12.3089195225189; 19810,12.3097881191669; 19815,12.3106567158149; 19820,12.3115253124629; 19825,12.3123939091109; 19830,12.313262505759; 19835,12.314131102407; 19840,12.314999699055; 19845,12.315868295703; 19850,12.3167368923511; 19855,12.3176059948795; 19860,12.3184740856471; 19865,12.3193431881755; 19870,12.3202112789432; 19875,12.3210803814716; 19880,12.3219484722392; 19885,12.3228175747676; 19890,12.3236861714156; 19895,12.3245547680637; 19900,12.3258260455107; 19905,12.3277645792062; 19910,12.3297031129017; 19915,12.3316416465972; 19920,12.3335801802928; 19925,12.3355187139883; 19930,12.3374572476838; 19935,12.3393957813794; 19940,12.3413343150749; 19945,12.34327234289; 19950,12.3452108765855; 19955,12.3471489044007; 19960,12.3490874380962; 19965,12.3510259717917; 19970,12.3529645054873; 19975,12.3549030391828; 19980,12.3568415728783; 19985,12.3587801065738; 19990,12.3607186402694; 19995,
        12.3626571739649]) annotation (Placement(transformation(extent={{-440,80},{-420,100}})));
  Modelica.Blocks.Sources.TimeTable timeTableCoal_concat(table=[0,12.6584997177124; 4499,12.6584997177124; 4500,12.6169966395093; 4501,12.6170300276158; 4502,12.6170639216026; 4503,12.6170978155895; 4504,12.6171317095763; 4505,12.6171656035632; 4506,12.61719949755; 4507,12.6172333915369; 4508,12.6172672855237; 4509,12.6173011795106; 4510,12.6173350734974; 4511,12.6173689674843; 4512,12.6174028614711; 4513,12.617436755458; 4514,12.6174706494448; 4515,12.6175045434317; 4516,12.6175379315381; 4517,12.6175718255249; 4518,12.6176057195118; 4519,12.6176396134986; 4520,12.6176735074855; 4521,12.6177074014723; 4522,12.6177412954592; 4523,12.617775189446; 4524,12.6178090834329; 4525,12.6178429774197; 4526,12.6178768714066; 4527,12.6179107653934; 4528,12.6179446593803; 4529,12.6179785533671; 4530,12.618012447354; 4531,12.6180463413408; 4532,12.6180802353277; 4533,12.6181136234341; 4534,12.618147517421; 4535,12.6181814114078; 4536,12.6182153053947; 4537,12.6182491993815; 4538,12.6182830933683;
        4539,12.6183169873552; 4540,12.618350881342; 4541,12.6183847753289; 4542,12.6184186693157; 4543,12.6184525633026; 4544,12.6184864572894; 4545,12.6185203512763; 4546,12.6185542452631; 4547,12.61858813925; 4548,12.6186220332368; 4549,12.6186559272237; 4550,12.6186893153301; 4551,12.618723209317; 4552,12.6187571033038; 4553,12.6187909972907; 4554,12.6188248912775; 4555,12.6188587852644; 4556,12.6188926792512; 4557,12.6189265732381; 4558,12.6189604672249; 4559,12.6189943612117; 4560,12.6190282551986; 4561,12.6190621491854; 4562,12.6190960431723; 4563,12.6191299371591; 4564,12.619163831146; 4565,12.6191977251328; 4566,12.6192316191197; 4567,12.6192650072261; 4568,12.619298901213; 4569,12.6193327951998; 4570,12.6193666891867; 4571,12.6194005831735; 4572,12.6194344771604; 4573,12.6194683711472; 4574,12.6632533315897; 4575,12.7070215979789; 4576,12.7070215979789; 4577,12.7070215979789; 4578,12.7070215979789; 4579,12.7070215979789; 4580,12.7070215979789; 4581,12.7070215979789; 4582,
        12.7070215979789; 4583,12.7070215979789; 4584,12.7070215979789; 4585,12.7070215979789; 4586,12.7070215979789; 4587,12.7070215979789; 4588,12.7070215979789; 4589,12.7070215979789; 4590,12.7070215979789; 4591,12.7070215979789; 4592,12.7070215979789; 4593,12.7070215979789; 4594,12.7070215979789; 4595,12.7070215979789; 4596,12.7070215979789; 4597,12.7070215979789; 4598,12.7070215979789; 4599,12.7070215979789; 4600,12.7070215979789; 4601,12.7070215979789; 4602,12.7070215979789; 4603,12.7070215979789; 4604,12.7070215979789; 4605,12.7070215979789; 4606,12.7070215979789; 4607,12.7070215979789; 4608,12.7070215979789; 4609,12.7070215979789; 4610,12.7070215979789; 4611,12.7070215979789; 4612,12.7070215979789; 4613,12.7070215979789; 4614,12.7070215979789; 4615,12.7070215979789; 4616,12.7070215979789; 4617,12.7070215979789; 4618,12.7070215979789; 4619,12.7070215979789; 4620,12.7070215979789; 4621,12.7070215979789; 4622,12.7070215979789; 4623,12.7070215979789; 4624,12.7070215979789; 4625,
        12.7070215979789; 4626,12.7070215979789; 4627,12.7070215979789; 4628,12.7070215979789; 4629,12.7070215979789; 4630,12.7070215979789; 4631,12.7070215979789; 4632,12.7070215979789; 4633,12.7070215979789; 4634,12.7070215979789; 4635,12.7070215979789; 4636,12.7070215979789; 4637,12.7070215979789; 4638,12.7070215979789; 4639,12.7070215979789; 4640,12.7070215979789; 4641,12.7070215979789; 4642,12.7070215979789; 4643,12.7070215979789; 4644,12.7070215979789; 4645,12.7070215979789; 4646,12.7070215979789; 4647,12.7070215979789; 4648,12.7070215979789; 4649,12.7070215979789; 4650,12.7070215979789; 4651,12.7070215979789; 4652,12.7070215979789; 4653,12.7070215979789; 4654,12.7070215979789; 4655,12.7070215979789; 4656,12.7070215979789; 4657,12.7070215979789; 4658,12.7070215979789; 4659,12.7070215979789; 4660,12.7070215979789; 4661,12.7070215979789; 4662,12.7070215979789; 4663,12.7070215979789; 4664,12.7070215979789; 4665,12.7070215979789; 4666,12.7070215979789; 4667,12.7070215979789; 4668,
        12.7070215979789; 4669,12.7070215979789; 4670,12.7070215979789; 4671,12.7070215979789; 4672,12.7070215979789; 4673,12.7070215979789; 4674,12.7070215979789; 4675,12.7070215979789; 4676,12.7070215979789; 4677,12.7070215979789; 4678,12.7070215979789; 4679,12.7070215979789; 4680,12.7070215979789; 4681,12.7070215979789; 4682,12.7070215979789; 4683,12.7070215979789; 4684,12.7070215979789; 4685,12.7070215979789; 4686,12.7070215979789; 4687,12.7070215979789; 4688,12.7070215979789; 4689,12.7070215979789; 4690,12.7070215979789; 4691,12.7070215979789; 4692,12.7070215979789; 4693,12.7070215979789; 4694,12.7070215979789; 4695,12.7070215979789; 4696,12.7070215979789; 4697,12.7070215979789; 4698,12.7070215979789; 4699,12.7070215979789; 4700,12.7070215979789; 4701,12.7070215979789; 4702,12.7070215979789; 4703,12.7070215979789; 4704,12.7070215979789; 4705,12.7070215979789; 4706,12.7070215979789; 4707,12.7070215979789; 4708,12.7070215979789; 4709,12.7070215979789; 4710,12.7070215979789; 4711,
        12.7070215979789; 4712,12.7070215979789; 4713,12.7070215979789; 4714,12.7070215979789; 4715,12.7070215979789; 4716,12.7070215979789; 4717,12.7070215979789; 4718,12.7070215979789; 4719,12.7070215979789; 4720,12.7070215979789; 4721,12.7070215979789; 4722,12.7070215979789; 4723,12.7070215979789; 4724,12.7070215979789; 4725,12.7070215979789; 4726,12.7070215979789; 4727,12.7070215979789; 4728,12.7070215979789; 4729,12.7070215979789; 4730,12.7070215979789; 4731,12.7070215979789; 4732,12.7070215979789; 4733,12.7070215979789; 4734,12.7070215979789; 4735,12.7070215979789; 4736,12.7070215979789; 4737,12.7070215979789; 4738,12.7070215979789; 4739,12.7070215979789; 4740,12.7070215979789; 4741,12.7070215979789; 4742,12.7070215979789; 4743,12.7070215979789; 4744,12.7070215979789; 4745,12.7070215979789; 4746,12.7070215979789; 4747,12.7070215979789; 4748,12.7070215979789; 4749,12.7070215979789; 4750,12.7070215979789; 4751,12.7070215979789; 4752,12.7070215979789; 4753,12.7070215979789; 4754,
        12.7070215979789; 4755,12.7070215979789; 4756,12.7070215979789; 4757,12.7070215979789; 4758,12.7070215979789; 4759,12.7070215979789; 4760,12.7070215979789; 4761,12.7070215979789; 4762,12.7070215979789; 4763,12.7070215979789; 4764,12.7070215979789; 4765,12.7070215979789; 4766,12.7070215979789; 4767,12.7070215979789; 4768,12.7070215979789; 4769,12.7070215979789; 4770,12.7070215979789; 4771,12.7070215979789; 4772,12.7070215979789; 4773,12.7070215979789; 4774,12.7070215979789; 4775,12.7070215979789; 4776,12.7070215979789; 4777,12.7070215979789; 4778,12.7070215979789; 4779,12.7070215979789; 4780,12.7070215979789; 4781,12.7070215979789; 4782,12.7070215979789; 4783,12.7070215979789; 4784,12.7070215979789; 4785,12.7070215979789; 4786,12.7070215979789; 4787,12.7070215979789; 4788,12.7070215979789; 4789,12.7070215979789; 4790,12.7070215979789; 4791,12.7070215979789; 4792,12.7070215979789; 4793,12.7070215979789; 4794,12.7070215979789; 4795,12.7070215979789; 4796,12.7070215979789; 4797,
        12.7070215979789; 4798,12.7070215979789; 4799,12.7070215979789; 4800,12.7070215979789; 4801,12.7070215979789; 4802,12.7070215979789; 4803,12.7070215979789; 4804,12.7070215979789; 4805,12.7070215979789; 4806,12.7070215979789; 4807,12.7070215979789; 4808,12.7070215979789; 4809,12.7070215979789; 4810,12.7070215979789; 4811,12.7070215979789; 4812,12.7070215979789; 4813,12.7070215979789; 4814,12.7070215979789; 4815,12.7070215979789; 4816,12.7070215979789; 4817,12.7070215979789; 4818,12.7070215979789; 4819,12.7070215979789; 4820,12.7070215979789; 4821,12.7070215979789; 4822,12.7070215979789; 4823,12.7070215979789; 4824,12.7070215979789; 4825,12.7070215979789; 4826,12.7070215979789; 4827,12.7070215979789; 4828,12.7070215979789; 4829,12.7070215979789; 4830,12.7070215979789; 4831,12.7070215979789; 4832,12.7070215979789; 4833,12.7070215979789; 4834,12.7070215979789; 4835,12.7070215979789; 4836,12.7070215979789; 4837,12.7070215979789; 4838,12.7070215979789; 4839,12.7070215979789; 4840,
        12.7070215979789; 4841,12.7070215979789; 4842,12.7070215979789; 4843,12.7070215979789; 4844,12.7070215979789; 4845,12.7070215979789; 4846,12.7070215979789; 4847,12.7070215979789; 4848,12.7070215979789; 4849,12.7070215979789; 4850,12.7070215979789; 4851,12.7070215979789; 4852,12.7070215979789; 4853,12.6989735466839; 4854,12.6706685265033; 4855,12.6506447684823; 4856,12.6506447684823; 4857,12.6506447684823; 4858,12.6506447684823; 4859,12.6506447684823; 4860,12.6506447684823; 4861,12.6506447684823; 4862,12.6506447684823; 4863,12.6506447684823; 4864,12.6506447684823; 4865,12.6506447684823; 4866,12.6506447684823; 4867,12.6506447684823; 4868,12.6506447684823; 4869,12.6506447684823; 4870,12.6506447684823; 4871,12.6506447684823; 4872,12.6506447684823; 4873,12.6506447684823; 4874,12.6506447684823; 4875,12.6506447684823; 4876,12.6506447684823; 4877,12.6506447684823; 4878,12.6506447684823; 4879,12.6506447684823; 4880,12.6506447684823; 4881,12.6506447684823; 4882,12.6506447684823; 4883,
        12.6506447684823; 4884,12.6506447684823; 4885,12.6506447684823; 4886,12.6506447684823; 4887,12.6506447684823; 4888,12.6506447684823; 4889,12.6506447684823; 4890,12.6506447684823; 4891,12.6506447684823; 4892,12.6506447684823; 4893,12.6506447684823; 4894,12.6506447684823; 4895,12.6506447684823; 4896,12.6506447684823; 4897,12.6506447684823; 4898,12.6506447684823; 4899,12.6506447684823; 4900,12.6506447684823; 4901,12.6506447684823; 4902,12.6506447684823; 4903,12.6506447684823; 4904,12.6506447684823; 4905,12.6511106843314; 4906,12.6515760943; 4907,12.6520415042687; 4908,12.6525074201177; 4909,12.6529733359668; 4910,12.6534387459354; 4911,12.6539041559041; 4912,12.6543700717531; 4913,12.6548359876022; 4914,12.6553013975709; 4915,12.6557668075395; 4916,12.6562322175082; 4917,12.6566981333572; 4918,12.6571640492063; 4919,12.6576294591749; 4920,12.6580948691436; 4921,12.6585607849926; 4922,12.6590267008417; 4923,12.6594921108104; 4924,12.659957520779; 4925,12.6604234366281; 4926,
        12.6608893524771; 4927,12.6613547624458; 4928,12.6618201724144; 4929,12.6622860882635; 4930,12.6627520041125; 4931,12.6632174140812; 4932,12.6636828240499; 4933,12.6641482340185; 4934,12.6646141498676; 4935,12.6650800657166; 4936,12.6655454756853; 4937,12.6660108856539; 4938,12.666476801503; 4939,12.666942717352; 4940,12.6674081273207; 4941,12.6678735372894; 4942,12.6683394531384; 4943,12.6688053689875; 4944,12.6692707789561; 4945,12.6697361889248; 4946,12.6702021047738; 4947,12.6706680206229; 4948,12.6711334305915; 4949,12.6715988405602; 4950,12.6720642505289; 4951,12.6725301663779; 4952,12.672996082227; 4953,12.672996082227; 4954,12.672996082227; 4955,12.672996082227; 4956,12.672996082227; 4957,12.672996082227; 4958,12.672996082227; 4959,12.672996082227; 4960,12.672996082227; 4961,12.672996082227; 4962,12.672996082227; 4963,12.672996082227; 4964,12.672996082227; 4965,12.672996082227; 4966,12.672996082227; 4967,12.672996082227; 4968,12.672996082227; 4969,12.672996082227; 4970,
        12.672996082227; 4971,12.672996082227; 4972,12.672996082227; 4973,12.672996082227; 4974,12.672996082227; 4975,12.672996082227; 4976,12.672996082227; 4977,12.672996082227; 4978,12.672996082227; 4979,12.672996082227; 4980,12.672996082227; 4981,12.672996082227; 4982,12.672996082227; 4983,12.672996082227; 4984,12.672996082227; 4985,12.672996082227; 4986,12.672996082227; 4987,12.672996082227; 4988,12.672996082227; 4989,12.672996082227; 4990,12.672996082227; 4991,12.672996082227; 4992,12.672996082227; 4993,12.672996082227; 4994,12.672996082227; 4995,12.672996082227; 4996,12.672996082227; 4997,12.672996082227; 4998,12.672996082227; 4999,12.672996082227; 5000,12.672996082227; 5001,12.672996082227; 5002,12.618918985032; 5003,12.2538508997385; 5004,11.63233433351; 5005,11.09130991548; 5006,10.8610437805643; 5007,10.8610437805643; 5008,10.8610437805643; 5009,10.8610437805643; 5010,10.8059043345279; 5011,10.6576060009395; 5012,10.5644516663112; 5013,10.5644516663112; 5014,10.5644516663112;
        5015,10.5644516663112; 5016,10.5644516663112; 5017,10.5644516663112; 5018,10.5644516663112; 5019,10.5644516663112; 5020,10.5644516663112; 5021,10.5644516663112; 5022,10.5644516663112; 5023,10.5644516663112; 5024,10.5644516663112; 5025,10.5644516663112; 5026,10.5644516663112; 5027,10.5644516663112; 5028,10.5644516663112; 5029,10.5644516663112; 5030,10.5644516663112; 5031,10.5644516663112; 5032,10.5644516663112; 5033,10.5644516663112; 5034,10.5644516663112; 5035,10.5644516663112; 5036,10.5644516663112; 5037,10.5644516663112; 5038,10.5644516663112; 5039,10.5644516663112; 5040,10.5644516663112; 5041,10.5644516663112; 5042,10.5644516663112; 5043,10.5644516663112; 5044,10.5644516663112; 5045,10.5644516663112; 5046,10.5644516663112; 5047,10.5644516663112; 5048,10.5644516663112; 5049,10.5644516663112; 5050,10.5644516663112; 5051,10.5644516663112; 5052,10.5644516663112; 5053,10.5644516663112; 5054,10.5644516663112; 5055,10.5644516663112; 5056,10.5644516663112; 5057,10.5644516663112;
        5058,10.5644516663112; 5059,10.5644516663112; 5060,10.5644516663112; 5061,10.5644516663112; 5062,10.5644607721584; 5063,10.5644698780056; 5064,10.5644789838528; 5065,10.5644880897; 5066,10.5644977014276; 5067,10.5645073131552; 5068,10.5645164190025; 5069,10.5645255248497; 5070,10.5645346306969; 5071,10.5645437365441; 5072,10.5645528423913; 5073,10.5645624541189; 5074,10.5645720658465; 5075,10.5645811716938; 5076,10.564590277541; 5077,10.5645993833882; 5078,10.5646084892354; 5079,10.564618100963; 5080,10.5646277126906; 5081,10.5646368185378; 5082,10.564645924385; 5083,10.5646550302323; 5084,10.5646641360795; 5085,10.5646732419267; 5086,10.5646828536543; 5087,10.5646924653819; 5088,10.5647015712291; 5089,10.5647106770763; 5090,10.5647197829235; 5091,10.5647288887708; 5092,10.5647385004984; 5093,10.564748112226; 5094,10.5647572180732; 5095,10.5647663239204; 5096,10.5647754297676; 5097,10.5647845356148; 5098,10.5647936414621; 5099,10.5648032531897; 5100,10.5648128649173; 5101,
        10.5648219707645; 5102,10.5648310766117; 5103,10.5648401824589; 5104,10.5648492883061; 5105,10.5648583941533; 5106,10.564868005881; 5107,10.5648776176086; 5108,10.5648867234558; 5109,10.564895829303; 5110,10.5649049351502; 5111,10.5649140409974; 5112,10.564923652725; 5113,10.5649332644526; 5114,10.5649423702999; 5115,10.5649514761471; 5116,10.5649605819943; 5117,10.5649696878415; 5118,10.5649787936887; 5119,10.5649884054163; 5120,10.5649980171439; 5121,10.5650071229912; 5122,10.5650162288384; 5123,10.5650253346856; 5124,10.5650344405328; 5125,10.5650440522604; 5126,10.565053663988; 5127,10.5650627698352; 5128,10.5650718756824; 5129,10.5650809815297; 5130,10.5650900873769; 5131,10.5650991932241; 5132,10.5651088049517; 5133,10.5651184166793; 5134,10.5651275225265; 5135,10.5651366283737; 5136,10.5651457342209; 5137,10.5651548400682; 5138,10.5651644517958; 5139,10.5651740635234; 5140,10.5651831693706; 5141,10.5651922752178; 5142,10.565201381065; 5143,10.5652104869122; 5144,
        10.5652195927595; 5145,10.5652292044871; 5146,10.5652388162147; 5147,10.5652479220619; 5148,10.5652570279091; 5149,10.5652661337563; 5150,10.5652752396035; 5151,10.5652843454507; 5152,10.5652939571784; 5153,10.565303568906; 5154,10.5653126747532; 5155,10.5653217806004; 5156,10.5653308864476; 5157,10.5653399922948; 5158,10.5653496040224; 5159,10.56535921575; 5160,10.5653683215973; 5161,10.5653774274445; 5162,10.5653865332917; 5163,10.5653956391389; 5164,10.5654047449861; 5165,10.5654143567137; 5166,10.5654239684413; 5167,10.5654330742886; 5168,10.5654421801358; 5169,10.565451285983; 5170,10.5654603918302; 5171,10.5654700035578; 5172,10.5654796152854; 5173,10.5654887211326; 5174,10.5654978269798; 5175,10.5655069328271; 5176,10.5655160386743; 5177,10.5655251445215; 5178,10.5655347562491; 5179,10.5655443679767; 5180,10.5655534738239; 5181,10.5655625796711; 5182,10.5655716855183; 5183,10.5655807913656; 5184,10.5655898972128; 5185,10.5655995089404; 5186,10.565609120668; 5187,
        10.5656182265152; 5188,10.5656273323624; 5189,10.5656364382096; 5190,10.5656455440569; 5191,10.5656551557845; 5192,10.5656647675121; 5193,10.5656738733593; 5194,10.5656829792065; 5195,10.5656920850537; 5196,10.5657011909009; 5197,10.5657102967481; 5198,10.5657199084758; 5199,10.5657295202034; 5200,10.5657386260506; 5201,10.5657477318978; 5202,10.565756837745; 5203,10.5657659435922; 5204,10.5657755553198; 5205,10.5657851670474; 5206,10.5657942728947; 5207,10.5658033787419; 5208,10.5658124845891; 5209,10.5658215904363; 5210,10.5658306962835; 5211,10.5658403080111; 5212,10.5658499197387; 5213,10.565859025586; 5214,10.5658681314332; 5215,10.5658772372804; 5216,10.5658863431276; 5217,10.5658954489748; 5218,10.5659050607024; 5219,10.56591467243; 5220,10.5659237782772; 5221,10.5659328841245; 5222,10.5659419899717; 5223,10.5659510958189; 5224,10.5659607075465; 5225,10.5659703192741; 5226,10.5659794251213; 5227,10.5659885309685; 5228,10.5659976368157; 5229,10.566006742663; 5230,
        10.5660158485102; 5231,10.5660254602378; 5232,10.5660350719654; 5233,10.5660441778126; 5234,10.5660532836598; 5235,10.566062389507; 5236,10.5660714953543; 5237,10.5660811070819; 5238,10.5660907188095; 5239,10.5660998246567; 5240,10.5661089305039; 5241,10.5661180363511; 5242,10.5661271421983; 5243,10.5661362480455; 5244,10.5661458597732; 5245,10.5661554715008; 5246,10.566164577348; 5247,10.5661736831952; 5248,10.5661827890424; 5249,10.5661918948896; 5250,10.5662015066172; 5251,10.5662111183448; 5252,10.5662202241921; 5253,10.5662293300393; 5254,10.5662384358865; 5255,10.5662475417337; 5256,10.5662566475809; 5257,10.5662662593085; 5258,10.5662758710361; 5259,10.5662849768834; 5260,10.5662940827306; 5261,10.5663031885778; 5262,10.566312294425; 5263,10.5663214002722; 5264,10.5663310119998; 5265,10.5663406237274; 5266,10.5663497295746; 5267,10.5663588354219; 5268,10.5663679412691; 5269,10.5663770471163; 5270,10.5663866588439; 5271,10.5663962705715; 5272,10.5664053764187; 5273,
        10.5664144822659; 5274,10.5664235881131; 5275,10.5664326939604; 5276,10.5664417998076; 5277,10.5664514115352; 5278,10.5664610232628; 5279,10.56647012911; 5280,10.5664792349572; 5281,10.5664883408044; 5282,10.5664974466517; 5283,10.5665070583793; 5284,10.5665166701069; 5285,10.5665257759541; 5286,10.5665348818013; 5287,10.5665439876485; 5288,10.5665530934957; 5289,10.5665621993429; 5290,10.5665718110706; 5291,10.5665814227982; 5292,10.5665905286454; 5293,10.5665996344926; 5294,10.5666087403398; 5295,10.566617846187; 5296,10.5666269520342; 5297,10.5666365637618; 5298,10.5666461754895; 5299,10.5666552813367; 5300,10.5666643871839; 5301,10.5666734930311; 5302,10.5666825988783; 5303,10.5666922106059; 5304,10.5667018223335; 5305,10.5667109281808; 5306,10.566720034028; 5307,10.5667291398752; 5308,10.5667382457224; 5309,10.5667473515696; 5310,10.5667569632972; 5311,10.5667665750248; 5312,10.566775680872; 5313,10.5667847867193; 5314,10.5667938925665; 5315,10.5668029984137; 5316,
        10.5668126101413; 5317,10.5668222218689; 5318,10.5668313277161; 5319,10.5668404335633; 5320,10.5668495394105; 5321,10.5668586452578; 5322,10.566867751105; 5323,10.5668773628326; 5324,10.5668869745602; 5325,10.5668960804074; 5326,10.5669051862546; 5327,10.5669142921018; 5328,10.566923397949; 5329,10.5669325037963; 5330,10.5669421155239; 5331,10.5669517272515; 5332,10.5669608330987; 5333,10.5669699389459; 5334,10.5669790447931; 5335,10.5669881506403; 5336,10.566997762368; 5337,10.5670073740956; 5338,10.5670164799428; 5339,10.56702558579; 5340,10.5670346916372; 5341,10.5670437974844; 5342,10.5670529033316; 5343,10.5670625150592; 5344,10.5670721267869; 5345,10.5670812326341; 5346,10.5670903384813; 5347,10.5670994443285; 5348,10.5671085501757; 5349,10.5671181619033; 5350,10.5671277736309; 5351,10.5671368794782; 5352,10.5671459853254; 5353,10.5671550911726; 5354,10.5671641970198; 5355,10.567173302867; 5356,10.5671829145946; 5357,10.5671925263222; 5358,10.5672016321694; 5359,
        10.5672107380167; 5360,10.5672198438639; 5361,10.5672289497111; 5362,10.5672385614387; 5363,10.5672481731663; 5364,10.5672572790135; 5365,10.5672663848607; 5366,10.5672754907079; 5367,10.5672845965552; 5368,10.5672937024024; 5369,10.56730331413; 5370,10.5673129258576; 5371,10.5673220317048; 5372,10.567331137552; 5373,10.5673402433992; 5374,10.5673493492464; 5375,10.5673584550937; 5376,10.5673680668213; 5377,10.5673776785489; 5378,10.5673867843961; 5379,10.5673958902433; 5380,10.5674049960905; 5381,10.5674141019377; 5382,10.5674237136654; 5383,10.567433325393; 5384,10.5674424312402; 5385,10.5674515370874; 5386,10.5674606429346; 5387,10.5674697487818; 5388,10.567478854629; 5389,10.5674884663566; 5390,10.5674980780843; 5391,10.5675071839315; 5392,10.5675162897787; 5393,10.5675253956259; 5394,10.5675345014731; 5395,10.5675441132007; 5396,10.5675537249283; 5397,10.5675628307756; 5398,10.5675719366228; 5399,10.56758104247; 5400,10.5675901483172; 5401,10.5675992541644; 5402,
        10.567608865892; 5403,10.5676184776196; 5404,10.5676275834668; 5405,10.5676366893141; 5406,10.5676457951613; 5407,10.5676549010085; 5408,10.5676640068557; 5409,10.5676736185833; 5410,10.5676832303109; 5411,10.5676923361581; 5412,10.5677014420053; 5413,10.5677105478526; 5414,10.5677196536998; 5415,10.5677292654274; 5416,10.567738877155; 5417,10.5677479830022; 5418,10.5677570888494; 5419,10.5677661946966; 5420,10.5677753005438; 5421,10.5677844063911; 5422,10.5677940181187; 5423,10.5678036298463; 5424,10.5678127356935; 5425,10.5678218415407; 5426,10.5678309473879; 5427,10.5678400532351; 5428,10.5678496649628; 5429,10.5678592766904; 5430,10.5678683825376; 5431,10.5678774883848; 5432,10.567886594232; 5433,10.5678957000792; 5434,10.5679048059264; 5435,10.567914417654; 5436,10.5679240293817; 5437,10.5679331352289; 5438,10.5679422410761; 5439,10.5679513469233; 5440,10.5679604527705; 5441,10.5679700644981; 5442,10.5679796762257; 5443,10.567988782073; 5444,10.5679978879202; 5445,
        10.5680069937674; 5446,10.5680160996146; 5447,10.5680252054618; 5448,10.5680348171894; 5449,10.568044428917; 5450,10.5680535347642; 5451,10.5680626406115; 5452,10.5680717464587; 5453,10.5680808523059; 5454,10.5680899581531; 5455,10.5680995698807; 5456,10.5681091816083; 5457,10.5681182874555; 5458,10.5681273933027; 5459,10.56813649915; 5460,10.5681456049972; 5461,10.5681552167248; 5462,10.5681648284524; 5463,10.5681739342996; 5464,10.5681830401468; 5465,10.568192145994; 5466,10.5682012518412; 5467,10.5682103576885; 5468,10.5682199694161; 5469,10.5682295811437; 5470,10.5682386869909; 5471,10.5682477928381; 5472,10.5682568986853; 5473,10.5682660045325; 5474,10.5682756162602; 5475,10.5682852279878; 5476,10.568294333835; 5477,10.5683034396822; 5478,10.5683125455294; 5479,10.5683216513766; 5480,10.5683307572238; 5481,10.5683403689514; 5482,10.5683499806791; 5483,10.5683590865263; 5484,10.5683681923735; 5485,10.5683772982207; 5486,10.5683864040679; 5487,10.5683955099151; 5488,
        10.5684051216427; 5489,10.5684147333703; 5490,10.5684238392176; 5491,10.5684329450648; 5492,10.568442050912; 5493,10.5684511567592; 5494,10.5684607684868; 5495,10.5684703802144; 5496,10.5684794860616; 5497,10.5684885919089; 5498,10.5684976977561; 5499,10.5685068036033; 5500,10.5685159094505; 5501,10.5685255211781; 5502,10.5685351329057; 5503,10.5685442387529; 5504,10.5685533446001; 5505,10.5685624504474; 5506,10.5685715562946; 5507,10.5685811680222; 5508,10.5685907797498; 5509,10.568599885597; 5510,10.5686089914442; 5511,10.5686180972914; 5512,10.5686272031386; 5513,10.5686363089859; 5514,10.5686459207135; 5515,10.5686555324411; 5516,10.5686646382883; 5517,10.5686737441355; 5518,10.5686828499827; 5519,10.5686919558299; 5520,10.5687010616772; 5521,10.5687106734048; 5522,10.5687202851324; 5523,10.5687293909796; 5524,10.5687384968268; 5525,10.568747602674; 5526,10.5687567085212; 5527,10.5687663202488; 5528,10.5687759319765; 5529,10.5687850378237; 5530,10.5687941436709; 5531,
        10.5688032495181; 5532,10.5688123553653; 5533,10.5688214612125; 5534,10.5688310729401; 5535,10.5688406846677; 5536,10.568849790515; 5537,10.5688588963622; 5538,10.5688680022094; 5539,10.5688771080566; 5540,10.5688867197842; 5541,10.5688963315118; 5542,10.568905437359; 5543,10.5689145432063; 5544,10.5689236490535; 5545,10.5689327549007; 5546,10.5689418607479; 5547,10.5689514724755; 5548,10.5689610842031; 5549,10.5689701900503; 5550,10.5689792958975; 5551,10.5689884017448; 5552,10.568997507592; 5553,10.5690071193196; 5554,10.5690167310472; 5555,10.5690258368944; 5556,10.5690349427416; 5557,10.5690440485888; 5558,10.569053154436; 5559,10.5690622602833; 5560,10.5690718720109; 5561,10.5690814837385; 5562,10.5690905895857; 5563,10.5690996954329; 5564,10.5691088012801; 5565,10.5691179071273; 5566,10.5691270129746; 5567,10.5691366247022; 5568,10.5691462364298; 5569,10.569155342277; 5570,10.5691644481242; 5571,10.5691735539714; 5572,10.5691826598186; 5573,10.5691922715462; 5574,
        10.5692018832739; 5575,10.5692109891211; 5576,10.5692200949683; 5577,10.5692292008155; 5578,10.5692383066627; 5579,10.5692474125099; 5580,10.5692570242375; 5581,10.5692666359651; 5582,10.5692757418124; 5583,10.5692848476596; 5584,10.6706435506267; 5585,10.9730406424779; 5586,11.3189090489232; 5587,11.5668597508871; 5588,11.6699849882134; 5589,11.6699849882134; 5590,11.6699849882134; 5591,11.6699849882134; 5592,11.71611065727; 5593,11.8328111951494; 5594,11.9033860639724; 5595,11.9033860639724; 5596,11.9033860639724; 5597,11.9033860639724; 5598,11.9033860639724; 5599,11.9033860639724; 5600,11.9033860639724; 5601,11.9033860639724; 5602,11.9033860639724; 5603,11.9033860639724; 5604,11.9033860639724; 5605,11.9033860639724; 5606,11.9033860639724; 5607,11.9033860639724; 5608,11.9033860639724; 5609,11.9033860639724; 5610,11.9033860639724; 5611,11.9033860639724; 5612,11.9033860639724; 5613,11.9033860639724; 5614,11.9033860639724; 5615,11.9033860639724; 5616,11.9033860639724; 5617,
        11.9033860639724; 5618,11.9033860639724; 5619,11.9033860639724; 5620,11.9033860639724; 5621,11.9033860639724; 5622,11.9033860639724; 5623,11.9550713586327; 5624,12.1871439924594; 5625,12.3675313316258; 5626,12.3675313316258; 5627,12.3675313316258; 5628,12.3675313316258; 5629,12.3675313316258; 5630,12.3675313316258; 5631,12.3675313316258; 5632,12.3675313316258; 5633,12.3675313316258; 5634,12.3675313316258; 5635,12.3675313316258; 5636,12.3675313316258; 5637,12.3675313316258; 5638,12.3675313316258; 5639,12.3675313316258; 5640,12.3675313316258; 5641,12.3675313316258; 5642,12.3675313316258; 5643,12.3675313316258; 5644,12.3675313316258; 5645,12.5014722735615; 5646,12.6354132154973; 5647,12.6354132154973; 5648,12.6354132154973; 5649,12.6354132154973; 5650,12.6354132154973; 5651,12.6354132154973; 5652,12.6354132154973; 5653,12.6354132154973; 5654,12.6354132154973; 5655,12.6354132154973; 5656,12.6354132154973; 5657,12.6354132154973; 5658,12.6354132154973; 5659,12.6354132154973; 5660,
        12.6354132154973; 5661,12.6354132154973; 5662,12.6354132154973; 5663,12.6354132154973; 5664,12.6354132154973; 5665,12.6354132154973; 5666,12.6354132154973; 5667,12.6354132154973; 5668,12.6354132154973; 5669,12.6844699555955; 5670,12.793211983011; 5671,12.8528972703282; 5672,12.8528972703282; 5673,12.8528972703282; 5674,12.8528972703282; 5675,12.8528972703282; 5676,12.8528972703282; 5677,12.8528972703282; 5678,12.8528972703282; 5679,12.8528972703282; 5680,12.8528972703282; 5681,12.8528972703282; 5682,12.8528972703282; 5683,12.8528972703282; 5684,12.8528972703282; 5685,12.8528972703282; 5686,12.8528972703282; 5687,12.8528972703282; 5688,12.8528972703282; 5689,12.8528972703282; 5690,12.8528972703282; 5691,12.8528972703282; 5692,12.8528972703282; 5693,12.8528972703282; 5694,12.8528972703282; 5695,12.8528972703282; 5696,12.8528972703282; 5697,12.8528972703282; 5698,12.8528972703282; 5699,12.8528972703282; 5700,12.8528972703282; 5701,12.8528972703282; 5702,12.8528972703282; 5703,
        12.8528972703282; 5704,12.8528972703282; 5705,12.8528972703282; 5706,12.8528972703282; 5707,12.8528972703282; 5708,12.8528972703282; 5709,12.8528972703282; 5710,12.8528972703282; 5711,12.8528972703282; 5712,12.8528972703282; 5713,12.8528972703282; 5714,12.8528972703282; 5715,12.8528972703282; 5716,12.8528972703282; 5717,12.8528972703282; 5718,12.8528972703282; 5719,12.8528972703282; 5720,12.8528972703282; 5721,12.8528972703282; 5722,12.8528972703282; 5723,12.7918486353311; 5724,12.7306598714629; 5725,12.7303791078405; 5726,12.7300983442181; 5727,12.7298175805958; 5728,12.7295368169734; 5729,12.729256053351; 5730,12.7289752897286; 5731,12.7286945261062; 5732,12.7284137624838; 5733,12.7281329988614; 5734,12.727852235239; 5735,12.7275714716166; 5736,12.7272902021138; 5737,12.7270094384914; 5738,12.726728674869; 5739,12.7264479112466; 5740,12.7261671476242; 5741,12.7258863840018; 5742,12.7256056203794; 5743,12.725324856757; 5744,12.7250440931346; 5745,12.7247633295122; 5746,
        12.7244825658898; 5747,12.7242018022674; 5748,12.7239210386451; 5749,12.7236402750227; 5750,12.7233595114003; 5751,12.7230782418975; 5752,12.7227974782751; 5753,12.7225167146527; 5754,12.7222359510303; 5755,12.7219551874079; 5756,12.7216744237855; 5757,12.7213936601631; 5758,12.7211128965407; 5759,12.7208321329183; 5760,12.7205513692959; 5761,12.7202706056735; 5762,12.7199898420511; 5763,12.7197090784287; 5764,12.7194283148063; 5765,12.7191475511839; 5766,12.7188662816811; 5767,12.7185855180587; 5768,12.7183047544363; 5769,12.718023990814; 5770,12.7177432271916; 5771,12.7174624635692; 5772,12.7171816999468; 5773,12.7169009363244; 5774,12.716620172702; 5775,12.7163394090796; 5776,12.7160586454572; 5777,12.7157778818348; 5778,12.7154971182124; 5779,12.71521635459; 5780,12.7149355909676; 5781,12.7146548273452; 5782,12.7143740637228; 5783,12.71409279422; 5784,12.7138120305976; 5785,12.7135312669752; 5786,12.7132505033528; 5787,12.7129697397304; 5788,12.712688976108; 5789,
        12.7124082124856; 5790,12.7121274488633; 5791,12.7118466852409; 5792,12.7115659216185; 5793,12.7112851579961; 5794,12.7110043943737; 5795,12.7107236307513; 5796,12.7104428671289; 5797,12.7101621035065; 5798,12.7098808340037; 5799,12.7096000703813; 5800,12.7093193067589; 5801,12.7090385431365; 5802,12.7087577795141; 5803,12.7084770158917; 5804,12.7081962522693; 5805,12.7079154886469; 5806,12.7076347250245; 5807,12.7073539614021; 5808,12.7070731977797; 5809,12.7067924341573; 5810,12.7065116705349; 5811,12.7062309069126; 5812,12.7059501432902; 5813,12.7056688737874; 5814,12.705388110165; 5815,12.7051073465426; 5816,12.7048265829202; 5817,12.7045458192978; 5818,12.7042650556754; 5819,12.703984292053; 5820,12.7037035284306; 5821,12.7034227648082; 5822,12.7031420011858; 5823,12.7028612375634; 5824,12.702580473941; 5825,12.7022997103186; 5826,12.7020189466962; 5827,12.7017381830738; 5828,12.7014574194514; 5829,12.701176655829; 5830,12.7008953863262; 5831,12.7006146227038; 5832,
        12.7003338590815; 5833,12.7000530954591; 5834,12.6997723318367; 5835,12.6994915682143; 5836,12.6992108045919; 5837,12.6989300409695; 5838,12.6986492773471; 5839,12.6983685137247; 5840,12.6980877501023; 5841,12.6978069864799; 5842,12.6975262228575; 5843,12.6972454592351; 5844,12.6969646956127; 5845,12.6966834261099; 5846,12.6964026624875; 5847,12.6961218988651; 5848,12.6958411352427; 5849,12.6955603716203; 5850,12.6952796079979; 5851,12.6949988443755; 5852,12.6947180807531; 5853,12.6944373171307; 5854,12.6941565535084; 5855,12.693875789886; 5856,12.6935950262636; 5857,12.6933142626412; 5858,12.6930334990188; 5859,12.6927527353964; 5860,12.692471971774; 5861,12.6921912081516; 5862,12.6919099386488; 5863,12.6916291750264; 5864,12.691348411404; 5865,12.6910676477816; 5866,12.6907868841592; 5867,12.6905061205368; 5868,12.6902253569144; 5869,12.689944593292; 5870,12.6896638296696; 5871,12.6893830660472; 5872,12.6891023024248; 5873,12.6888215388024; 5874,12.68854077518; 5875,
        12.6882600115577; 5876,12.6879792479353; 5877,12.6876979784325; 5878,12.6874172148101; 5879,12.6871364511877; 5880,12.6868556875653; 5881,12.6865749239429; 5882,12.6862941603205; 5883,12.6860133966981; 5884,12.6857326330757; 5885,12.6854518694533; 5886,12.6851711058309; 5887,12.6848903422085; 5888,12.6846095785861; 5889,12.6843288149637; 5890,12.6840480513413; 5891,12.6837672877189; 5892,12.6834860182161; 5893,12.6832052545937; 5894,12.6829244909713; 5895,12.6826437273489; 5896,12.6823629637266; 5897,12.6820822001042; 5898,12.6818014364818; 5899,12.6815206728594; 5900,12.681239909237; 5901,12.6809591456146; 5902,12.6806783819922; 5903,12.6803976183698; 5904,12.6801168547474; 5905,12.679836091125; 5906,12.6795553275026; 5907,12.6792745638802; 5908,12.6789938002578; 5909,12.678712530755; 5910,12.6784317671326; 5911,12.6781510035102; 5912,12.6778702398878; 5913,12.6775894762654; 5914,12.677308712643; 5915,12.6770279490206; 5916,12.6767471853982; 5917,12.6764664217759; 5918,
        12.6761856581535; 5919,12.6759048945311; 5920,12.6756241309087; 5921,12.6753433672863; 5922,12.6750626036639; 5923,12.6747818400415; 5924,12.6745005705387; 5925,12.6742198069163; 5926,12.6739390432939; 5927,12.6736582796715; 5928,12.6733775160491; 5929,12.6730967524267; 5930,12.6728159888043; 5931,12.6725352251819; 5932,12.6722544615595; 5933,12.6719736979371; 5934,12.6716929343147; 5935,12.6714121706923; 5936,12.6711314070699; 5937,12.6708506434475; 5938,12.6705698798252; 5939,12.6702886103224; 5940,12.6700078467; 5941,12.6697270830776; 5942,12.6694463194552; 5943,12.6691655558328; 5944,12.6688847922104; 5945,12.668604028588; 5946,12.6683232649656; 5947,12.6680425013432; 5948,12.6677617377208; 5949,12.6674809740984; 5950,12.667200210476; 5951,12.6669194468536; 5952,12.6666386832312; 5953,12.6663579196088; 5954,12.6660771559864; 5955,12.665796392364; 5956,12.6655151228612; 5957,12.6652343592388; 5958,12.6649535956164; 5959,12.6646728319941; 5960,12.6643920683717; 5961,
        12.6641113047493; 5962,12.6638305411269; 5963,12.6635497775045; 5964,12.6632690138821; 5965,12.6629882502597; 5966,12.6627074866373; 5967,12.6624267230149; 5968,12.6621459593925; 5969,12.6618651957701; 5970,12.6615844321477; 5971,12.6613031626449; 5972,12.6610223990225; 5973,12.6607416354001; 5974,12.6604608717777; 5975,12.6601801081553; 5976,12.6598993445329; 5977,12.6596185809105; 5978,12.6593378172881; 5979,12.6590570536657; 5980,12.6587762900433; 5981,12.658495526421; 5982,12.6582147627986; 5983,12.6579339991762; 5984,12.6576532355538; 5985,12.6573724719314; 5986,12.6570912024286; 5987,12.6568104388062; 5988,12.6565296751838; 5989,12.6562489115614; 5990,12.655968147939; 5991,12.6556873843166; 5992,12.6554066206942; 5993,12.6551258570718; 5994,12.6548450934494; 5995,12.654564329827; 5996,12.6542835662046; 5997,12.6540028025822; 5998,12.6537220389598; 5999,12.6534412753374; 6000,12.653160511715; 6001,12.6528797480926; 6002,12.6525989844703; 6003,12.6523177149675; 6004,
        12.6520369513451; 6005,12.6517561877227; 6006,12.6514754241003; 6007,12.6511946604779; 6008,12.6509138968555; 6009,12.6506331332331; 6010,12.6503523696107; 6011,12.6500716059883; 6012,12.6497908423659; 6013,12.6495100787435; 6014,12.6492293151211; 6015,12.6489485514987; 6016,12.6486677878763; 6017,12.6483870242539; 6018,12.6481057547511; 6019,12.6478249911287; 6020,12.6475442275063; 6021,12.6472634638839; 6022,12.6469827002615; 6023,12.6467019366392; 6024,12.6464211730168; 6025,12.6461404093944; 6026,12.645859645772; 6027,12.6455788821496; 6028,12.6452981185272; 6029,12.6450173549048; 6030,12.6447365912824; 6031,12.64445582766; 6032,12.6441750640376; 6033,12.6438943004152; 6034,12.6436135367928; 6035,12.64333226729; 6036,12.6430515036676; 6037,12.6427707400452; 6038,12.6424899764228; 6039,12.6422092128004; 6040,12.641928449178; 6041,12.6416476855556; 6042,12.6413669219332; 6043,12.6410861583108; 6044,12.6408053946885; 6045,12.6405246310661; 6046,12.6402438674437; 6047,
        12.6399631038213; 6048,12.6396823401989; 6049,12.6394015765765; 6050,12.6391203070737; 6051,12.6388395434513; 6052,12.6385587798289; 6053,12.6382780162065; 6054,12.6379972525841; 6055,12.6377164889617; 6056,12.6374357253393; 6057,12.6371549617169; 6058,12.6368741980945; 6059,12.6365934344721; 6060,12.6363126708497; 6061,12.6360319072273; 6062,12.6357511436049; 6063,12.626306862404; 6064,12.5989827443204; 6065,12.5810285430187; 6066,12.5810285430187; 6067,12.5810285430187; 6068,12.5810285430187; 6069,12.5810285430187; 6070,12.5810285430187; 6071,12.5810285430187; 6072,12.5810285430187; 6073,12.5810285430187; 6074,12.5810285430187; 6075,12.5810285430187; 6076,12.5810285430187; 6077,12.5810285430187; 6078,12.5810285430187; 6079,12.5810285430187; 6080,12.5810285430187; 6081,12.5810285430187; 6082,12.5810285430187; 6083,12.5810285430187; 6084,12.5810285430187; 6085,12.5810285430187; 6086,12.5810285430187; 6087,12.5810285430187; 6088,12.5810285430187; 6089,12.5810285430187; 6090,
        12.5810285430187; 6091,12.5810285430187; 6092,12.5810285430187; 6093,12.5810285430187; 6094,12.5810285430187; 6095,12.5810285430187; 6096,12.5810285430187; 6097,12.5810285430187; 6098,12.5810285430187; 6099,12.5810285430187; 6100,12.5810285430187; 6101,12.5810285430187; 6102,12.5810285430187; 6103,12.5810285430187; 6104,12.5810285430187; 6105,12.5810285430187; 6106,12.5810285430187; 6107,12.5810285430187; 6108,12.5810285430187; 6109,12.5810285430187; 6110,12.5810285430187; 6111,12.5810285430187; 6112,12.5810285430187; 6113,12.5810285430187; 6114,12.5810285430187; 6115,12.5811610836837; 6116,12.5812941302291; 6117,12.5814271767745; 6118,12.5815597174395; 6119,12.5816922581044; 6120,12.5818253046498; 6121,12.5819583511952; 6122,12.5820908918602; 6123,12.5822239384056; 6124,12.582356984951; 6125,12.582489525616; 6126,12.5826220662809; 6127,12.5827551128263; 6128,12.5828881593717; 6129,12.5830207000367; 6130,12.5831532407017; 6131,12.5832862872471; 6132,12.5834193337925; 6133,
        12.5835518744575; 6134,12.5836849210028; 6135,12.5838179675482; 6136,12.5839505082132; 6137,12.5840830488782; 6138,12.5842160954236; 6139,12.584349141969; 6140,12.584481682634; 6141,12.5846147291794; 6142,12.5847477757247; 6143,12.5848803163897; 6144,12.5850128570547; 6145,12.5851459036001; 6146,12.5852789501455; 6147,12.5854114908105; 6148,12.5855440314755; 6149,12.5856770780208; 6150,12.5858101245662; 6151,12.5859426652312; 6152,12.5860757117766; 6153,12.586208758322; 6154,12.586341298987; 6155,12.586473839652; 6156,12.5866068861974; 6157,12.5867399327427; 6158,12.5868724734077; 6159,12.5870055199531; 6160,12.5871385664985; 6161,12.5872711071635; 6162,12.5874036478285; 6163,12.5875366943739; 6164,12.5876697409193; 6165,12.5878022815842; 6166,12.5879353281296; 6167,12.588068374675; 6168,12.58820091534; 6169,12.588333456005; 6170,12.5884665025504; 6171,12.5885995490958; 6172,12.5887320897607; 6173,12.5888646304257; 6174,12.5889976769711; 6175,12.5891307235165; 6176,
        12.5892632641815; 6177,12.5893963107269; 6178,12.5895293572723; 6179,12.5896618979373; 6180,12.5897944386022; 6181,12.5899274851476; 6182,12.590060531693; 6183,12.590193072358; 6184,12.5903261189034; 6185,12.5904591654488; 6186,12.5905917061138; 6187,12.5907242467788; 6188,12.5908572933241; 6189,12.5909903398695; 6190,12.5911228805345; 6191,12.5912554211995; 6192,12.5913884677449; 6193,12.5915215142903; 6194,12.5916540549553; 6195,12.5917871015006; 6196,12.591920148046; 6197,12.592052688711; 6198,12.592185229376; 6199,12.5923182759214; 6200,12.5924513224668; 6201,12.5925838631318; 6202,12.5927169096772; 6203,12.5928499562225; 6204,12.6208054130463; 6205,12.648727987644; 6206,12.6487952697373; 6207,12.6488625518306; 6208,12.6489293280435; 6209,12.6489966101368; 6210,12.6490638922301; 6211,12.6491311743234; 6212,12.6491984564167; 6213,12.6492652326296; 6214,12.6493325147229; 6215,12.6493997968162; 6216,12.6494670789094; 6217,12.6495343610027; 6218,12.6496011372156; 6219,
        12.6496684193089; 6220,12.6497357014022; 6221,12.6498029834955; 6222,12.6498702655888; 6223,12.6499370418017; 6224,12.650004323895; 6225,12.6500716059883; 6226,12.6501383822012; 6227,12.6502056642945; 6228,12.6502729463878; 6229,12.6503402284811; 6230,12.6504075105744; 6231,12.6504742867873; 6232,12.6505415688806; 6233,12.6506088509739; 6234,12.6506761330671; 6235,12.6507434151604; 6236,12.6508101913733; 6237,12.6508774734666; 6238,12.6509447555599; 6239,12.6510120376532; 6240,12.6510793197465; 6241,12.6511460959594; 6242,12.6512133780527; 6243,12.651280660146; 6244,12.6513474363589; 6245,12.6514147184522; 6246,12.6514820005455; 6247,12.6515492826388; 6248,12.6516165647321; 6249,12.651683340945; 6250,12.6517506230383; 6251,12.6518179051316; 6252,12.6518851872248; 6253,12.6519524693181; 6254,12.652019245531; 6255,12.6520865276243; 6256,12.6521538097176; 6257,12.6522205859305; 6258,12.6522878680238; 6259,12.6523551501171; 6260,12.6524224322104; 6261,12.6524897143037; 6262,
        12.6525564905166; 6263,12.6526237726099; 6264,12.6526910547032; 6265,12.6527583367965; 6266,12.6528256188898; 6267,12.6528923951027; 6268,12.652959677196; 6269,12.6530269592893; 6270,12.6530942413826; 6271,12.6531615234758; 6272,12.6532282996887; 6273,12.653295581782; 6274,12.6533628638753; 6275,12.6534296400882; 6276,12.6534969221815; 6277,12.6535642042748; 6278,12.6536314863681; 6279,12.6536987684614; 6280,12.6537655446743; 6281,12.6538328267676; 6282,12.6539001088609; 6283,12.6539673909542; 6284,12.6540346730475; 6285,12.6541014492604; 6286,12.6541687313537; 6287,12.654236013447; 6288,12.6543027896599; 6289,12.6543700717531; 6290,12.6544373538464; 6291,12.6545046359397; 6292,12.654571918033; 6293,12.6546386942459; 6294,12.6547059763392; 6295,12.6547732584325; 6296,12.6548405405258; 6297,12.6549078226191; 6298,12.654974598832; 6299,12.6550418809253; 6300,12.6584997177124; 9499,12.6584997177124; 9500,12.6997723318367; 9501,12.6994915682143; 9502,12.6992108045919; 9503,
        12.6989300409695; 9504,12.6986492773471; 9505,12.6983685137247; 9506,12.6980877501023; 9507,12.6978069864799; 9508,12.6975262228575; 9509,12.6972454592351; 9510,12.6969646956127; 9511,12.6966834261099; 9512,12.6964026624875; 9513,12.6961218988651; 9514,12.6958411352427; 9515,12.6955603716203; 9516,12.6952796079979; 9517,12.6949988443755; 9518,12.6947180807531; 9519,12.6944373171307; 9520,12.6941565535084; 9521,12.693875789886; 9522,12.6935950262636; 9523,12.6933142626412; 9524,12.6930334990188; 9525,12.6927527353964; 9526,12.692471971774; 9527,12.6921912081516; 9528,12.6919099386488; 9529,12.6916291750264; 9530,12.691348411404; 9531,12.6910676477816; 9532,12.6907868841592; 9533,12.6905061205368; 9534,12.6902253569144; 9535,12.689944593292; 9536,12.6896638296696; 9537,12.6893830660472; 9538,12.6891023024248; 9539,12.6888215388024; 9540,12.68854077518; 9541,12.6882600115577; 9542,12.6879792479353; 9543,12.6876979784325; 9544,12.6874172148101; 9545,12.6871364511877; 9546,
        12.6868556875653; 9547,12.6865749239429; 9548,12.6862941603205; 9549,12.6860133966981; 9550,12.6857326330757; 9551,12.6854518694533; 9552,12.6851711058309; 9553,12.6848903422085; 9554,12.6846095785861; 9555,12.6843288149637; 9556,12.6840480513413; 9557,12.6837672877189; 9558,12.6834860182161; 9559,12.6832052545937; 9560,12.6829244909713; 9561,12.6826437273489; 9562,12.6823629637266; 9563,12.6820822001042; 9564,12.6818014364818; 9565,12.6815206728594; 9566,12.681239909237; 9567,12.6809591456146; 9568,12.6806783819922; 9569,12.6803976183698; 9570,12.6801168547474; 9571,12.679836091125; 9572,12.6795553275026; 9573,12.6792745638802; 9574,12.6789938002578; 9575,12.678712530755; 9576,12.6784317671326; 9577,12.6781510035102; 9578,12.6778702398878; 9579,12.6775894762654; 9580,12.677308712643; 9581,12.6770279490206; 9582,12.6767471853982; 9583,12.6764664217759; 9584,12.6761856581535; 9585,12.6759048945311; 9586,12.6756241309087; 9587,12.6753433672863; 9588,12.6750626036639; 9589,
        12.6747818400415; 9590,12.6745005705387; 9591,12.6742198069163; 9592,12.6739390432939; 9593,12.6736582796715; 9594,12.6733775160491; 9595,12.6730967524267; 9596,12.6728159888043; 9597,12.6725352251819; 9598,12.6722544615595; 9599,12.6719736979371; 9600,12.6716929343147; 9601,12.6714121706923; 9602,12.6711314070699; 9603,12.6708506434475; 9604,12.6705698798252; 9605,12.6702886103224; 9606,12.6700078467; 9607,12.6697270830776; 9608,12.6694463194552; 9609,12.6691655558328; 9610,12.6688847922104; 9611,12.668604028588; 9612,12.6683232649656; 9613,12.6680425013432; 9614,12.6677617377208; 9615,12.6674809740984; 9616,12.667200210476; 9617,12.6669194468536; 9618,12.6666386832312; 9619,12.6663579196088; 9620,12.6660771559864; 9621,12.665796392364; 9622,12.6655151228612; 9623,12.6652343592388; 9624,12.6649535956164; 9625,12.6646728319941; 9626,12.6643920683717; 9627,12.6641113047493; 9628,12.6638305411269; 9629,12.6635497775045; 9630,12.6632690138821; 9631,12.6629882502597; 9632,
        12.6627074866373; 9633,12.6624267230149; 9634,12.6621459593925; 9635,12.6618651957701; 9636,12.6615844321477; 9637,12.6613031626449; 9638,12.6610223990225; 9639,12.6607416354001; 9640,12.6604608717777; 9641,12.6601801081553; 9642,12.6598993445329; 9643,12.6596185809105; 9644,12.6593378172881; 9645,12.6590570536657; 9646,12.6587762900433; 9647,12.658495526421; 9648,12.6582147627986; 9649,12.6579339991762; 9650,12.6576532355538; 9651,12.6573724719314; 9652,12.6570912024286; 9653,12.6568104388062; 9654,12.6565296751838; 9655,12.6562489115614; 9656,12.655968147939; 9657,12.6556873843166; 9658,12.6554066206942; 9659,12.6551258570718; 9660,12.6548450934494; 9661,12.654564329827; 9662,12.6542835662046; 9663,12.6540028025822; 9664,12.6537220389598; 9665,12.6534412753374; 9666,12.653160511715; 9667,12.6528797480926; 9668,12.6525989844703; 9669,12.6523177149675; 9670,12.6520369513451; 9671,12.6517561877227; 9672,12.6514754241003; 9673,12.6511946604779; 9674,12.6509138968555; 9675,
        12.6506331332331; 9676,12.6503523696107; 9677,12.6500716059883; 9678,12.6497908423659; 9679,12.6495100787435; 9680,12.6492293151211; 9681,12.6489485514987; 9682,12.6486677878763; 9683,12.6483870242539; 9684,12.6481057547511; 9685,12.6478249911287; 9686,12.6475442275063; 9687,12.6472634638839; 9688,12.6469827002615; 9689,12.6467019366392; 9690,12.6464211730168; 9691,12.6461404093944; 9692,12.645859645772; 9693,12.6455788821496; 9694,12.6452981185272; 9695,12.6450173549048; 9696,12.6447365912824; 9697,12.64445582766; 9698,12.6441750640376; 9699,12.6438943004152; 9700,12.6436135367928; 9701,12.64333226729; 9702,12.6430515036676; 9703,12.6427707400452; 9704,12.6424899764228; 9705,12.6422092128004; 9706,12.641928449178; 9707,12.6416476855556; 9708,12.6413669219332; 9709,12.6410861583108; 9710,12.6408053946885; 9711,12.6405246310661; 9712,12.6402438674437; 9713,12.6399631038213; 9714,12.6396823401989; 9715,12.6394015765765; 9716,12.6391203070737; 9717,12.6388395434513; 9718,
        12.6385587798289; 9719,12.6382780162065; 9720,12.6379972525841; 9721,12.6377164889617; 9722,12.6374357253393; 9723,12.6371549617169; 9724,12.6368741980945; 9725,12.6365934344721; 9726,12.6363126708497; 9727,12.6360319072273; 9728,12.6357511436049; 9729,12.626306862404; 9730,12.5989827443204; 9731,12.5810285430187; 9732,12.5810285430187; 9733,12.5810285430187; 9734,12.5810285430187; 9735,12.5810285430187; 9736,12.5810285430187; 9737,12.5810285430187; 9738,12.5810285430187; 9739,12.5810285430187; 9740,12.5810285430187; 9741,12.5810285430187; 9742,12.5810285430187; 9743,12.5810285430187; 9744,12.5810285430187; 9745,12.5810285430187; 9746,12.5810285430187; 9747,12.5810285430187; 9748,12.5810285430187; 9749,12.5810285430187; 9750,12.5810285430187; 9751,12.5810285430187; 9752,12.5810285430187; 9753,12.5810285430187; 9754,12.5810285430187; 9755,12.5810285430187; 9756,12.5810285430187; 9757,12.5810285430187; 9758,12.5810285430187; 9759,12.5810285430187; 9760,12.5810285430187; 9761,
        12.5810285430187; 9762,12.5810285430187; 9763,12.5810285430187; 9764,12.5810285430187; 9765,12.5810285430187; 9766,12.5810285430187; 9767,12.5810285430187; 9768,12.5810285430187; 9769,12.5810285430187; 9770,12.5810285430187; 9771,12.5810285430187; 9772,12.5810285430187; 9773,12.5810285430187; 9774,12.5810285430187; 9775,12.5810285430187; 9776,12.5810285430187; 9777,12.5810285430187; 9778,12.5810285430187; 9779,12.5810285430187; 9780,12.5810285430187; 9781,12.5811610836837; 9782,12.5812941302291; 9783,12.5814271767745; 9784,12.5815597174395; 9785,12.5816922581044; 9786,12.5818253046498; 9787,12.5819583511952; 9788,12.5820908918602; 9789,12.5822239384056; 9790,12.582356984951; 9791,12.582489525616; 9792,12.5826220662809; 9793,12.5827551128263; 9794,12.5828881593717; 9795,12.5830207000367; 9796,12.5831532407017; 9797,12.5832862872471; 9798,12.5834193337925; 9799,12.5835518744575; 9800,12.5836849210028; 9801,12.5838179675482; 9802,12.5839505082132; 9803,12.5840830488782; 9804,
        12.5842160954236; 9805,12.584349141969; 9806,12.584481682634; 9807,12.5846147291794; 9808,12.5847477757247; 9809,12.5848803163897; 9810,12.5850128570547; 9811,12.5851459036001; 9812,12.5852789501455; 9813,12.5854114908105; 9814,12.5855440314755; 9815,12.5856770780208; 9816,12.5858101245662; 9817,12.5859426652312; 9818,12.5860757117766; 9819,12.586208758322; 9820,12.586341298987; 9821,12.586473839652; 9822,12.5866068861974; 9823,12.5867399327427; 9824,12.5868724734077; 9825,12.5870055199531; 9826,12.5871385664985; 9827,12.5872711071635; 9828,12.5874036478285; 9829,12.5875366943739; 9830,12.5876697409193; 9831,12.5878022815842; 9832,12.5879353281296; 9833,12.588068374675; 9834,12.58820091534; 9835,12.588333456005; 9836,12.5884665025504; 9837,12.5885995490958; 9838,12.5887320897607; 9839,12.5888646304257; 9840,12.5889976769711; 9841,12.5891307235165; 9842,12.5892632641815; 9843,12.5893963107269; 9844,12.5895293572723; 9845,12.5896618979373; 9846,12.5897944386022; 9847,
        12.5899274851476; 9848,12.590060531693; 9849,12.590193072358; 9850,12.5903261189034; 9851,12.5904591654488; 9852,12.5905917061138; 9853,12.5907242467788; 9854,12.5908572933241; 9855,12.5909903398695; 9856,12.5911228805345; 9857,12.5912554211995; 9858,12.5913884677449; 9859,12.5915215142903; 9860,12.5916540549553; 9861,12.5917871015006; 9862,12.591920148046; 9863,12.592052688711; 9864,12.592185229376; 9865,12.5923182759214; 9866,12.5924513224668; 9867,12.5925838631318; 9868,12.5927169096772; 9869,12.5928499562225; 9870,12.6208054130463; 9871,12.648727987644; 9872,12.6487952697373; 9873,12.6488625518306; 9874,12.6489293280435; 9875,12.6489966101368; 9876,12.6490638922301; 9877,12.6491311743234; 9878,12.6491984564167; 9879,12.6492652326296; 9880,12.6493325147229; 9881,12.6493997968162; 9882,12.6494670789094; 9883,12.6495343610027; 9884,12.6496011372156; 9885,12.6496684193089; 9886,12.6497357014022; 9887,12.6498029834955; 9888,12.6498702655888; 9889,12.6499370418017; 9890,
        12.650004323895; 9891,12.6500716059883; 9892,12.6501383822012; 9893,12.6502056642945; 9894,12.6502729463878; 9895,12.6503402284811; 9896,12.6504075105744; 9897,12.6504742867873; 9898,12.6505415688806; 9899,12.6506088509739; 9900,12.6506761330671; 9901,12.6507434151604; 9902,12.6508101913733; 9903,12.6508774734666; 9904,12.6509447555599; 9905,12.6510120376532; 9906,12.6510793197465; 9907,12.6511460959594; 9908,12.6512133780527; 9909,12.651280660146; 9910,12.6513474363589; 9911,12.6514147184522; 9912,12.6514820005455; 9913,12.6515492826388; 9914,12.6516165647321; 9915,12.651683340945; 9916,12.6517506230383; 9917,12.6518179051316; 9918,12.6518851872248; 9919,12.6519524693181; 9920,12.652019245531; 9921,12.6520865276243; 9922,12.6521538097176; 9923,12.6522205859305; 9924,12.6522878680238; 9925,12.6523551501171; 9926,12.6524224322104; 9927,12.6524897143037; 9928,12.6525564905166; 9929,12.6526237726099; 9930,12.6526910547032; 9931,12.6527583367965; 9932,12.6528256188898; 9933,
        12.6528923951027; 9934,12.652959677196; 9935,12.6530269592893; 9936,12.6530942413826; 9937,12.6531615234758; 9938,12.6532282996887; 9939,12.653295581782; 9940,12.6533628638753; 9941,12.6534296400882; 9942,12.6534969221815; 9943,12.6535642042748; 9944,12.6536314863681; 9945,12.6536987684614; 9946,12.6537655446743; 9947,12.6538328267676; 9948,12.6539001088609; 9949,12.6539673909542; 9950,12.6540346730475; 9951,12.6541014492604; 9952,12.6541687313537; 9953,12.654236013447; 9954,12.6543027896599; 9955,12.6543700717531; 9956,12.6544373538464; 9957,12.6545046359397; 9958,12.654571918033; 9959,12.6546386942459; 9960,12.6547059763392; 9961,12.6547732584325; 9962,12.6548405405258; 9963,12.6549078226191; 9964,12.654974598832; 9965,12.6550418809253; 9966,12.6551091630186; 9967,12.6551764451119; 9968,12.6552437272052; 9969,12.6553105034181; 9970,12.6553777855114; 9971,12.6554450676047; 9972,12.6555118438176; 9973,12.6555791259109; 9974,12.6556464080041; 9975,12.6557136900974; 9976,
        12.6557809721907; 9977,12.6558477484036; 9978,12.6559150304969; 9979,12.6559823125902; 9980,12.6560495946835; 9981,12.6561168767768; 9982,12.6561836529897; 9983,12.656250935083; 9984,12.6563182171763; 9985,12.6563854992696; 9986,12.6564527813629; 9987,12.6565195575758; 9988,12.6565868396691; 9989,12.6566541217624; 9990,12.6567208979753; 9991,12.6567881800686; 9992,12.6568554621618; 9993,12.6569227442551; 9994,12.6569900263484; 9995,12.6570568025613; 9996,12.6571240846546; 9997,12.6571913667479; 9998,12.6572586488412; 9999,12.6573259309345; 10000,12.6573927071474; 10001,12.6574599892407; 10002,12.657527271334; 10003,12.6575940475469; 10004,12.6576613296402; 10005,12.6577286117335; 10006,12.6577958938268; 10007,12.6578631759201; 10008,12.657929952133; 10009,12.6579972342263; 10010,12.6580645163195; 10011,12.6581317984128; 10012,12.6581990805061; 10013,12.658265856719; 10014,12.6583331388123; 10015,12.6584004209056; 10016,12.6584677029989; 10017,12.6585349850922; 10018,
        12.6586017613051; 10019,12.6586690433984; 10020,12.6587363254917; 10021,12.6588031017046; 10022,12.6588703837979; 10023,12.6589376658912; 10024,12.6590049479845; 10025,12.6590722300778; 10026,12.6591390062907; 10027,12.659206288384; 10028,12.6592735704773; 10029,12.6593408525705; 10030,12.6594081346638; 10031,12.6594749108767; 10032,12.65954219297; 10033,12.6596094750633; 10034,12.6596762512762; 10035,12.6597435333695; 10036,12.6598108154628; 10037,12.6598780975561; 10038,12.6599453796494; 10039,12.6600121558623; 10040,12.6600794379556; 10041,12.6601467200489; 10042,12.6602140021422; 10043,12.6602812842355; 10044,12.6603480604484; 10045,12.6604153425417; 10046,12.660482624635; 10047,12.6605499067282; 10048,12.6606171888215; 10049,12.6606839650344; 10050,12.6607512471277; 10051,12.660818529221; 10052,12.6608853054339; 10053,12.6609525875272; 10054,12.6610198696205; 10055,12.6610871517138; 10056,12.6611544338071; 10057,12.66122121002; 10058,12.6612884921133; 10059,
        12.6613557742066; 10060,12.6614230562999; 10061,12.6614903383932; 10062,12.6615571146061; 10063,12.6616243966994; 10064,12.6616916787927; 10065,12.6617589608859; 10066,12.6618262429792; 10067,12.6618930191921; 10068,12.6619603012854; 10069,12.6620275833787; 10070,12.6620943595916; 10071,12.6621616416849; 10072,12.6622289237782; 10073,12.6622962058715; 10074,12.6623634879648; 10075,12.6624302641777; 10076,12.662497546271; 10077,12.6625648283643; 10078,12.6626321104576; 10079,12.6626993925509; 10080,12.6627661687638; 10081,12.6628334508571; 10082,12.6629007329504; 10083,12.6629675091632; 10084,12.6630347912565; 10085,12.6631020733498; 10086,12.6631693554431; 10087,12.6632366375364; 10088,12.6633034137493; 10089,12.6633706958426; 10090,12.6634379779359; 10091,12.6635052600292; 10092,12.6635725421225; 10093,12.6636393183354; 10094,12.6637066004287; 10095,12.663773882522; 10096,12.6638411646153; 10097,12.6639084467086; 10098,12.6639752229215; 10099,12.6640425050148; 10100,
        12.6641097871081; 10101,12.664176563321; 10102,12.6642438454142; 10103,12.6643111275075; 10104,12.6643784096008; 10105,12.6644456916941; 10106,12.664512467907; 10107,12.6645797500003; 10108,12.6646470320936; 10109,12.6647143141869; 10110,12.6647815962802; 10111,12.6648483724931; 10112,12.6649156545864; 10113,12.6649829366797; 10114,12.665050218773; 10115,12.6651175008663; 10116,12.6651842770792; 10117,12.6652515591725; 10118,12.6653188412658; 10119,12.6653856174787; 10120,12.6654528995719; 10121,12.6655201816652; 10122,12.6655874637585; 10123,12.6656547458518; 10124,12.6657215220647; 10125,12.665788804158; 10126,12.6658560862513; 10127,12.6659233683446; 10128,12.6659906504379; 10129,12.6660574266508; 10130,12.6661247087441; 10131,12.6661919908374; 10132,12.6662587670503; 10133,12.6663260491436; 10134,12.6663933312369; 10135,12.6664606133302; 10136,12.6665278954235; 10137,12.6665946716364; 10138,12.6666619537297; 10139,12.6667292358229; 10140,12.6667965179162; 10141,
        12.6668638000095; 10142,12.6669305762224; 10143,12.6669978583157; 10144,12.667065140409; 10145,12.6671324225023; 10146,12.6671997045956; 10147,12.6672664808085; 10148,12.6673337629018; 10149,12.6674010449951; 10150,12.667467821208; 10151,12.6675351033013; 10152,12.6676023853946; 10153,12.6676696674879; 10154,12.6677369495812; 10155,12.6678037257941; 10156,12.6678710078874; 10157,12.6679382899806; 10158,12.6680055720739; 10159,12.6680728541672; 10160,12.6681396303801; 10161,12.6682069124734; 10162,12.6682741945667; 10163,12.6683409707796; 10164,12.6684082528729; 10165,12.6684755349662; 10166,12.6685428170595; 10167,12.6686100991528; 10168,12.6686768753657; 10169,12.668744157459; 10170,12.6688114395523; 10171,12.6688787216456; 10172,12.6689460037389; 10173,12.6690127799518; 10174,12.6690800620451; 10175,12.6691473441383; 10176,12.6692146262316; 10177,12.6692819083249; 10178,12.6693486845378; 10179,12.6694159666311; 10180,12.6694832487244; 10181,12.6695500249373; 10182,
        12.6696173070306; 10183,12.6696845891239; 10184,12.6697518712172; 10185,12.6698191533105; 10186,12.6698859295234; 10187,12.6699532116167; 10188,12.67002049371; 10189,12.6700877758033; 10190,12.6701550578966; 10191,12.6702218341095; 10192,12.6702891162028; 10193,12.6703563982961; 10194,12.6704236803893; 10195,12.6704909624826; 10196,12.6705577386955; 10197,12.6706250207888; 10198,12.6706923028821; 10199,12.670759079095; 10200,12.6708263611883; 10201,12.6708936432816; 10202,12.6709609253749; 10203,12.6710282074682; 10204,12.6710949836811; 10205,12.6711622657744; 10206,12.6712295478677; 10207,12.671296829961; 10208,12.6713641120543; 10209,12.6714308882672; 10210,12.6714981703605; 10211,12.6715654524538; 10212,12.6716322286666; 10213,12.6716995107599; 10214,12.6717667928532; 10215,12.6718340749465; 10216,12.6719013570398; 10217,12.6719681332527; 10218,12.672035415346; 10219,12.6721026974393; 10220,12.6721699795326; 10221,12.6722372616259; 10222,12.6723040378388; 10223,
        12.6723713199321; 10224,12.6724386020254; 10225,12.6725058841187; 10226,12.672573166212; 10227,12.6726399424249; 10228,12.6727072245182; 10229,12.6727745066115; 10230,12.6728412828243; 10231,12.6729085649176; 10232,12.6729758470109; 10233,12.6730431291042; 10234,12.6731104111975; 10235,12.6731771874104; 10236,12.6732444695037; 10237,12.673311751597; 10238,12.6733790336903; 10239,12.6734463157836; 10240,12.6735130919965; 10241,12.6735803740898; 10242,12.6736476561831; 10243,12.673714432396; 10244,12.6737817144893; 10245,12.6738489965826; 10246,12.6739162786759; 10247,12.6739835607692; 10248,12.6740503369821; 10249,12.6741176190753; 10250,12.6741849011686; 10251,12.6742521832619; 10252,12.6743194653552; 10253,12.6743862415681; 10254,12.6744535236614; 10255,12.6745208057547; 10256,12.674588087848; 10257,12.6746553699413; 10258,12.6747221461542; 10259,12.6747894282475; 10260,12.6748567103408; 10261,12.6749234865537; 10262,12.674990768647; 10263,12.6750580507403; 10264,
        12.6751253328336; 10265,12.6751926149269; 10266,12.6752593911398; 10267,12.675326673233; 10268,12.6753939553263; 10269,12.6754612374196; 10270,12.6755285195129; 10271,12.6755952957258; 10272,12.6756625778191; 10273,12.6757298599124; 10274,12.6757971420057; 10275,12.675864424099; 10276,12.6759312003119; 10277,12.6759984824052; 10278,12.6760657644985; 10279,12.6761325407114; 10280,12.6761998228047; 10281,12.676267104898; 10282,12.6763343869913; 10283,12.6764016690846; 10284,12.6764684452975; 10285,12.6765357273908; 10286,12.676603009484; 10287,12.6766702915773; 10288,12.6767375736706; 10289,12.6768043498835; 10290,12.6768716319768; 10291,12.6769389140701; 10292,12.677005690283; 10293,12.6770729723763; 10294,12.6771402544696; 10295,12.6772075365629; 10296,12.6772748186562; 10297,12.6773415948691; 10298,12.6774088769624; 10299,12.6774761590557; 10300,12.677543441149; 10301,12.6776107232423; 10302,12.6776774994552; 10303,12.6777447815485; 10304,12.6778120636417; 10305,
        12.677879345735; 10306,12.6779466278283; 10307,12.6780134040412; 10308,12.6780806861345; 10309,12.6781479682278; 10310,12.6782147444407; 10311,12.678282026534; 10312,12.6783493086273; 10313,12.6784165907206; 10314,12.6784838728139; 10315,12.6785506490268; 10316,12.6786179311201; 10317,12.6786852132134; 10318,12.6787524953067; 10319,12.6788197774; 10320,12.6788865536129; 10321,12.6789538357062; 10322,12.6790211177994; 10323,12.6790883998927; 10324,12.679155681986; 10325,12.6792224581989; 10326,12.6792897402922; 10327,12.6793570223855; 10328,12.6794237985984; 10329,12.6794910806917; 10330,12.679558362785; 10331,12.6796256448783; 10332,12.6796929269716; 10333,12.6797597031845; 10334,12.6798269852778; 10335,12.6798942673711; 10336,12.6799615494644; 10337,12.6800288315577; 10338,12.6800956077706; 10339,12.6801628898639; 10340,12.6802301719572; 10341,12.68029694817; 10342,12.6803642302633; 10343,12.6804315123566; 10344,12.6804987944499; 10345,12.6805660765432; 10346,12.6806328527561;
        10347,12.6807001348494; 10348,12.6807674169427; 10349,12.680834699036; 10350,12.6809019811293; 10351,12.6809687573422; 10352,12.6810360394355; 10353,12.6811033215288; 10354,12.6811706036221; 10355,12.6812378857154; 10356,12.6813046619283; 10357,12.6813719440216; 10358,12.6814392261149; 10359,12.6815060023277; 10360,12.681573284421; 10361,12.6816405665143; 10362,12.6817078486076; 10363,12.6817751307009; 10364,12.6818419069138; 10365,12.6819091890071; 10366,12.6819764711004; 10367,12.6820437531937; 10368,12.682111035287; 10369,12.6821778114999; 10370,12.6822450935932; 10371,12.6823123756865; 10372,12.6823791518994; 10373,12.6824464339927; 10374,12.682513716086; 10375,12.6825809981793; 10376,12.6826482802726; 10377,12.6827150564854; 10378,12.6827823385787; 10379,12.682849620672; 10380,12.6829169027653; 10381,12.6829841848586; 10382,12.6830509610715; 10383,12.6831182431648; 10384,12.6831855252581; 10385,12.6832528073514; 10386,12.6833200894447; 10387,12.6833868656576; 10388,
        12.6834541477509; 10389,12.6835214298442; 10390,12.6835882060571; 10391,12.6836554881504; 10392,12.6837227702437; 10393,12.683790052337; 10394,12.6838573344303; 10395,12.6839241106431; 10396,12.6839913927364; 10397,12.6840586748297; 10398,12.684125956923; 10399,12.6841932390163; 10400,12.6842600152292; 10401,12.6843272973225; 10402,12.6843945794158; 10403,12.6844618615091; 10404,12.6845291436024; 10405,12.6845959198153; 10406,12.6846632019086; 10407,12.6847304840019; 10408,12.6847972602148; 10409,12.6848645423081; 10410,12.6849318244014; 10411,12.6849991064947; 10412,12.685066388588; 10413,12.6851331648009; 10414,12.6852004468941; 10415,12.6852677289874; 10416,12.6853350110807; 10417,12.685402293174; 10418,12.6854690693869; 10419,12.6855363514802; 10420,12.6856036335735; 10421,12.6856704097864; 10422,12.6857376918797; 10423,12.685804973973; 10424,12.6858722560663; 10425,12.6859395381596; 10426,12.6860063143725; 10427,12.6860735964658; 10428,12.6861408785591; 10429,
        12.6862081606524; 10430,12.6862754427457; 10431,12.6863422189586; 10432,12.6864095010518; 10433,12.6864767831451; 10434,12.6865440652384; 10435,12.6866113473317; 10436,12.6866781235446; 10437,12.6867454056379; 10438,12.6868126877312; 10439,12.6868794639441; 10440,12.6869467460374; 10441,12.6870140281307; 10442,12.687081310224; 10443,12.6871485923173; 10444,12.6872153685302; 10445,12.6872826506235; 10446,12.6873499327168; 10447,12.6874172148101; 10448,12.6874844969034; 10449,12.6875512731163; 10450,12.6876185552096; 10451,12.6876858373028; 10452,12.6877526135157; 10453,12.687819895609; 10454,12.6878871777023; 10455,12.6879544597956; 10456,12.6880217418889; 10457,12.6880885181018; 10458,12.6881558001951; 10459,12.6882230822884; 10460,12.6882903643817; 10461,12.688357646475; 10462,12.6901565571799; 10463,12.7171634882523; 10464,12.7423067559285; 10465,12.7423067559285; 10466,12.7423067559285; 10467,12.7423067559285; 10468,12.7423067559285; 10469,12.7423067559285; 10470,
        12.7423067559285; 10471,12.7423067559285; 10472,12.7423067559285; 10473,12.7423067559285; 10474,12.7423067559285; 10475,12.7423067559285; 10476,12.7423067559285; 10477,12.7423067559285; 10478,12.7423067559285; 10479,12.7423067559285; 10480,12.7423067559285; 10481,12.7423067559285; 10482,12.7423067559285; 10483,12.7423067559285; 10484,12.7423067559285; 10485,12.7423067559285; 10486,12.7423067559285; 10487,12.7423067559285; 10488,12.7423067559285; 10489,12.7423067559285; 10490,12.7423067559285; 10491,12.7423067559285; 10492,12.7423067559285; 10493,12.7423067559285; 10494,12.7423067559285; 10495,12.7423067559285; 10496,12.7423067559285; 10497,12.7423067559285; 10498,12.7423067559285; 10499,12.7423067559285; 10500,12.7423067559285; 10501,12.7423067559285; 10502,12.7423067559285; 10503,12.7423067559285; 10504,12.7423067559285; 10505,12.7423067559285; 10506,12.7423067559285; 10507,12.7423067559285; 10508,12.7423067559285; 10509,12.7423067559285; 10510,12.7423067559285; 10511,
        12.7423067559285; 10512,12.7423067559285; 10513,12.7423067559285; 10514,12.7421099684527; 10515,12.7419131809768; 10516,12.7417168993813; 10517,12.7415201119054; 10518,12.7413233244296; 10519,12.7411270428341; 10520,12.7409302553582; 10521,12.7407334678823; 10522,12.7405371862868; 10523,12.740340398811; 10524,12.7401436113351; 10525,12.7399473297396; 10526,12.7397505422637; 10527,12.7395537547879; 10528,12.7393574731924; 10529,12.7391606857165; 10530,12.7389638982406; 10531,12.7387676166452; 10532,12.7385708291693; 10533,12.7383740416934; 10534,12.7381777600979; 10535,12.737980972622; 10536,12.7377841851462; 10537,12.7375879035507; 10538,12.7373911160748; 10539,12.7371943285989; 10540,12.7369980470035; 10541,12.7368012595276; 10542,12.7366044720517; 10543,12.7364081904562; 10544,12.7362114029804; 10545,12.7360146155045; 10546,12.735818333909; 10547,12.7356215464331; 10548,12.7354247589572; 10549,12.7352284773618; 10550,12.7350316898859; 10551,12.73483490241; 10552,
        12.7346386208145; 10553,12.7344418333387; 10554,12.7342450458628; 10555,12.7340487642673; 10556,12.7338519767914; 10557,12.7336551893156; 10558,12.7334589077201; 10559,12.7332621202442; 10560,12.7330653327683; 10561,12.7328690511729; 10562,12.732672263697; 10563,12.7324754762211; 10564,12.7322791946256; 10565,12.7320824071497; 10566,12.7318856196739; 10567,12.7316893380784; 10568,12.7314925506025; 10569,12.7312957631266; 10570,12.7310994815312; 10571,12.7309026940553; 10572,12.7307059065794; 10573,12.7305096249839; 10574,12.7303128375081; 10575,12.7301160500322; 10576,12.7299197684367; 10577,12.7297229809608; 10578,12.7295261934849; 10579,12.7293299118895; 10580,12.7291331244136; 10581,12.7289363369377; 10582,12.7287400553422; 10583,12.7285432678664; 10584,12.7283464803905; 10585,12.728150198795; 10586,12.7279534113191; 10587,12.7277566238433; 10588,12.7275603422478; 10589,12.7273635547719; 10590,12.727166767296; 10591,12.7269704857005; 10592,12.7267736982247; 10593,
        12.7265769107488; 10594,12.7263806291533; 10595,12.7261838416774; 10596,12.7259870542016; 10597,12.7257907726061; 10598,12.7255939851302; 10599,12.7253971976543; 10600,12.7252009160589; 10601,12.725004128583; 10602,12.7248073411071; 10603,12.7246110595116; 10604,12.7244142720357; 10605,12.7242174845599; 10606,12.7240212029644; 10607,12.7238244154885; 10608,12.7236276280126; 10609,12.7234313464172; 10610,12.7232345589413; 10611,12.7230377714654; 10612,12.7228414898699; 10613,12.7226447023941; 10614,12.7224479149182; 10615,12.7222516333227; 10616,12.7220548458468; 10617,12.721858058371; 10618,12.7216617767755; 10619,12.7214649892996; 10620,12.7212682018237; 10621,12.7210719202282; 10622,12.7208751327524; 10623,12.7206783452765; 10624,12.720482063681; 10625,12.7202852762051; 10626,12.7200884887293; 10627,12.7198922071338; 10628,12.7196954196579; 10629,12.719498632182; 10630,12.7193023505866; 10631,12.7191055631107; 10632,12.7189087756348; 10633,12.7187124940393; 10634,
        12.7185157065634; 10635,12.7183189190876; 10636,12.7181226374921; 10637,12.7179258500162; 10638,12.7177290625403; 10639,12.7175327809449; 10640,12.717335993469; 10641,12.7171392059931; 10642,12.7169429243976; 10643,12.7167461369218; 10644,12.7165493494459; 10645,12.7163530678504; 10646,12.7161562803745; 10647,12.7159594928986; 10648,12.7157632113032; 10649,12.7155664238273; 10650,12.7153696363514; 10651,12.7151733547559; 10652,12.7149765672801; 10653,12.7147797798042; 10654,12.7145834982087; 10655,12.7143867107328; 10656,12.714189923257; 10657,12.7139936416615; 10658,12.7137968541856; 10659,12.7136000667097; 10660,12.7134037851142; 10661,12.7132069976384; 10662,12.7130102101625; 10663,12.712813928567; 10664,12.7126171410911; 10665,12.7124203536153; 10666,12.7122240720198; 10667,12.7120272845439; 10668,12.711830497068; 10669,12.7116342154726; 10670,12.7114374279967; 10671,12.7112406405208; 10672,12.7110443589253; 10673,12.7108475714495; 10674,12.7106507839736; 10675,
        12.7104545023781; 10676,12.7102577149022; 10677,12.7100609274263; 10678,12.7098646458309; 10679,12.709667858355; 10680,12.7094710708791; 10681,12.7092747892836; 10682,12.7090780018078; 10683,12.7088812143319; 10684,12.7086849327364; 10685,12.7084881452605; 10686,12.7082913577847; 10687,12.7080950761892; 10688,12.7078982887133; 10689,12.7077015012374; 10690,12.7075052196419; 10691,12.7073084321661; 10692,12.7071116446902; 10693,12.7069153630947; 10694,12.7067185756188; 10695,12.706521788143; 10696,12.7063255065475; 10697,12.7061287190716; 10698,12.7059319315957; 10699,12.7057356500003; 10700,12.7055388625244; 10701,12.7053420750485; 10702,12.705145793453; 10703,12.7049490059771; 10704,12.7047522185013; 10705,12.7045559369058; 10706,12.7043591494299; 10707,12.704162361954; 10708,12.7039660803586; 10709,12.7037692928827; 10710,12.7035725054068; 10711,12.7033762238113; 10712,12.7031794363355; 10713,12.7029826488596; 10714,12.7027863672641; 10715,12.7025895797882; 10716,
        12.7023927923123; 10717,12.7021965107169; 10718,12.701999723241; 10719,12.7018029357651; 10720,12.7016066541696; 10721,12.7014098666938; 10722,12.7012130792179; 10723,12.7010167976224; 10724,12.7008200101465; 10725,12.7006232226707; 10726,12.7004269410752; 10727,12.7002301535993; 10728,12.7000333661234; 10729,12.699837084528; 10730,12.6996402970521; 10731,12.6994435095762; 10732,12.6992472279807; 10733,12.6990504405048; 10734,12.698853653029; 10735,12.6986573714335; 10736,12.6984605839576; 10737,12.6982637964817; 10738,12.6980675148863; 10739,12.6978707274104; 10740,12.6976739399345; 10741,12.697477658339; 10742,12.6972808708632; 10743,12.6970840833873; 10744,12.6968878017918; 10745,12.6966910143159; 10746,12.69649422684; 10747,12.6962979452446; 10748,12.6961011577687; 10749,12.6959043702928; 10750,12.6957080886973; 10751,12.6955113012215; 10752,12.6953145137456; 10753,12.6951182321501; 10754,12.6949214446742; 10755,12.6947246571984; 10756,12.6945283756029; 10757,
        12.694331588127; 10758,12.6941348006511; 10759,12.6939385190556; 10760,12.6937417315798; 10761,12.6935449441039; 10762,12.6933486625084; 10763,12.6931518750325; 10764,12.6929550875567; 10765,12.6927588059612; 10766,12.6925620184853; 10767,12.6923652310094; 10768,12.692168949414; 10769,12.6919721619381; 10770,12.6917753744622; 10771,12.6915790928667; 10772,12.6913823053909; 10773,12.691185517915; 10774,12.6909892363195; 10775,12.6907924488436; 10776,12.6905956613677; 10777,12.6903993797723; 10778,12.6902025922964; 10779,12.6900058048205; 10780,12.689809523225; 10781,12.6896127357492; 10782,12.6894159482733; 10783,12.6892196666778; 10784,12.6890228792019; 10785,12.6888260917261; 10786,12.6886298101306; 10787,12.6884330226547; 10788,12.6882362351788; 10789,12.6880399535833; 10790,12.6878431661075; 10791,12.6876463786316; 10792,12.6874500970361; 10793,12.6872533095602; 10794,12.6870565220844; 10795,12.6868602404889; 10796,12.686663453013; 10797,12.6864666655371; 10798,
        12.6862703839417; 10799,12.6860735964658; 10800,12.6858768089899; 10801,12.6856805273944; 10802,12.6854837399185; 10803,12.6852869524427; 10804,12.6850906708472; 10805,12.6848938833713; 10806,12.6846970958954; 10807,12.6845008143; 10808,12.6843040268241; 10809,12.6841072393482; 10810,12.6839109577527; 10811,12.6837141702769; 10812,12.683517382801; 10813,12.6833211012055; 10814,12.6831243137296; 10815,12.6829275262537; 10816,12.6827312446583; 10817,12.6825344571824; 10818,12.6823376697065; 10819,12.682141388111; 10820,12.6819446006352; 10821,12.6817478131593; 10822,12.6815515315638; 10823,12.6813547440879; 10824,12.6811579566121; 10825,12.6809616750166; 10826,12.6807648875407; 10827,12.6805681000648; 10828,12.6803718184694; 10829,12.6801750309935; 10830,12.6799782435176; 10831,12.6797819619221; 10832,12.6795851744462; 10833,12.6793883869704; 10834,12.6791921053749; 10835,12.678995317899; 10836,12.6787985304231; 10837,12.6786022488277; 10838,12.6784054613518; 10839,
        12.6782086738759; 10840,12.6780123922804; 10841,12.6778156048046; 10842,12.6776188173287; 10843,12.6774225357332; 10844,12.6772257482573; 10845,12.6770289607814; 10846,12.676832679186; 10847,12.6766358917101; 10848,12.6764391042342; 10849,12.6762428226387; 10850,12.6760460351629; 10851,12.675849247687; 10852,12.6756529660915; 10853,12.6754561786156; 10854,12.6752593911398; 10855,12.6750631095443; 10856,12.6748663220684; 10857,12.6746695345925; 10858,12.674473252997; 10859,12.6742764655212; 10860,12.6740796780453; 10861,12.6738833964498; 10862,12.6736866089739; 10863,12.6734898214981; 10864,12.6732935399026; 10865,12.6730967524267; 10866,12.6728999649508; 10867,12.6727036833554; 10868,12.6725068958795; 10869,12.6723101084036; 10870,12.6721138268081; 10871,12.6719170393322; 10872,12.6717202518564; 10873,12.6715239702609; 10874,12.671327182785; 10875,12.6711303953091; 10876,12.6709341137137; 10877,12.6707373262378; 10878,12.6705405387619; 10879,12.6703442571664; 10880,
        12.6701474696906; 10881,12.6699506822147; 10882,12.6697544006192; 10883,12.6695576131433; 10884,12.6693608256674; 10885,12.669164544072; 10886,12.6689677565961; 10887,12.6687709691202; 10888,12.6685746875247; 10889,12.6683779000489; 10890,12.668181112573; 10891,12.6679848309775; 10892,12.6677880435016; 10893,12.6675912560258; 10894,12.6673949744303; 10895,12.6671981869544; 10896,12.6670013994785; 10897,12.6668051178831; 10898,12.6666083304072; 10899,12.6664115429313; 10900,12.6662152613358; 10901,12.6660184738599; 10902,12.6658216863841; 10903,12.6656254047886; 10904,12.6654286173127; 10905,12.6652318298368; 10906,12.6650355482414; 10907,12.6648387607655; 10908,12.6646419732896; 10909,12.6644456916941; 10910,12.6642489042183; 10911,12.6640521167424; 10912,12.6638558351469; 10913,12.663659047671; 10914,12.6634622601951; 10915,12.6632659785997; 10916,12.6630691911238; 10917,12.6628724036479; 10918,12.6626761220524; 10919,12.6624793345766; 10920,12.6622825471007; 10921,
        12.6620862655052; 10922,12.6618894780293; 10923,12.6616926905535; 10924,12.661496408958; 10925,12.6612996214821; 10926,12.6611028340062; 10927,12.6609065524107; 10928,12.6607097649349; 10929,12.660512977459; 10930,12.6603166958635; 10931,12.6601199083876; 10932,12.6599231209118; 10933,12.6597268393163; 10934,12.6595300518404; 10935,12.6593332643645; 10936,12.6591369827691; 10937,12.6589401952932; 10938,12.6587434078173; 10939,12.6585471262218; 10940,12.6583503387459; 10941,12.6581535512701; 10942,12.6579572696746; 10943,12.6577604821987; 10944,12.6575636947228; 10945,12.6573674131274; 10946,12.6571706256515; 10947,12.6569738381756; 10948,12.6567775565801; 10949,12.6565807691043; 10950,12.6563839816284; 10951,12.6561877000329; 10952,12.6559914184374; 10953,12.6557946309616; 10954,12.6555978434857; 10955,12.6554015618902; 10956,12.6552047744143; 10957,12.6550079869384; 10958,12.654811705343; 10959,12.6546149178671; 10960,12.6544181303912; 10961,12.6542218487957; 10962,
        12.6540250613199; 10963,12.653828273844; 10964,12.6536319922485; 10965,12.6534352047726; 10966,12.6532384172968; 10967,12.6530421357013; 10968,12.6528453482254; 10969,12.6526485607495; 10970,12.652452279154; 10971,12.6522554916782; 10972,12.6520587042023; 10973,12.6518624226068; 10974,12.6516656351309; 10975,12.6514688476551; 10976,12.6512725660596; 10977,12.6510757785837; 10978,12.6508789911078; 10979,12.6506827095124; 10980,12.6504859220365; 10981,12.6502891345606; 10982,12.6500928529651; 10983,12.6498960654892; 10984,12.6496992780134; 10985,12.6495029964179; 10986,12.649306208942; 10987,12.6491094214661; 10988,12.6489131398707; 10989,12.6373446668672; 10990,12.5974049033506; 10991,12.5686471202113; 10992,12.5680709224349; 10993,12.5674952305389; 10994,12.5669195386428; 10995,12.5663438467468; 10996,12.5657681548508; 10997,12.5651924629548; 10998,12.5646167710588; 10999,12.5640405732824; 11000,12.563464375506; 11001,12.56288868361; 11002,12.562312991714; 11003,
        12.5617372998179; 11004,12.5611616079219; 11005,12.5605859160259; 11006,12.5600102241299; 11007,12.5594340263535; 11008,12.5588578285771; 11009,12.5582821366811; 11010,12.5577064447851; 11011,12.5571307528891; 11012,12.5565550609931; 11013,12.555979369097; 11014,12.555403677201; 11015,12.554827985305; 11016,12.5542517875286; 11017,12.5536755897522; 11018,12.5530998978562; 11019,12.5525242059602; 11020,12.5519485140642; 11021,12.5513728221682; 11022,12.5507971302721; 11023,12.5502214383761; 11024,12.5496452405997; 11025,12.5490690428233; 11026,12.5484933509273; 11027,12.5479176590313; 11028,12.5473419671353; 11029,12.5467662752393; 11030,12.5461905833433; 11031,12.5456148914473; 11032,12.5450386936708; 11033,12.5444624958944; 11034,12.5438868039984; 11035,12.5433111121024; 11036,12.5427354202064; 11037,12.5421597283104; 11038,12.5415840364144; 11039,12.5410083445184; 11040,12.540432146742; 11041,12.5398559489655; 11042,12.5392802570695; 11043,12.5387045651735; 11044,
        12.5381288732775; 11045,12.5375531813815; 11046,12.5369774894855; 11047,12.5364017975895; 11048,12.5358255998131; 11049,12.5352494020367; 11050,12.5346737101407; 11051,12.5340980182446; 11052,12.5335223263486; 11053,12.5329466344526; 11054,12.5323709425566; 11055,12.5317952506606; 11056,12.5312190528842; 11057,12.5306428551078; 11058,12.5300671632118; 11059,12.5294914713158; 11060,12.5289157794197; 11061,12.5289157794197; 11062,12.5289157794197; 11063,12.5289157794197; 11064,12.5289157794197; 11065,12.5289157794197; 11066,12.5289157794197; 11067,12.5289157794197; 11068,12.5289157794197; 11069,12.5289157794197; 11070,12.5289157794197; 11071,12.5289157794197; 11072,12.5289157794197; 11073,12.5289157794197; 11074,12.5289157794197; 11075,12.5289157794197; 11076,12.5289157794197; 11077,12.5289157794197; 11078,12.5289157794197; 11079,12.5289157794197; 11080,12.5289157794197; 11081,12.5289157794197; 11082,12.5289157794197; 11083,12.5289157794197; 11084,12.5289157794197; 11085,
        12.5289157794197; 11086,12.5289157794197; 11087,12.5289157794197; 11088,12.5289157794197; 11089,12.5289157794197; 11090,12.5289157794197; 11091,12.5289157794197; 11092,12.5289157794197; 11093,12.5289157794197; 11094,12.5289157794197; 11095,12.5289157794197; 11096,12.5289157794197; 11097,12.5289157794197; 11098,12.5289157794197; 11099,12.5289157794197; 11100,12.5289157794197; 11101,12.5289157794197; 11102,12.5289157794197; 11103,12.5289157794197; 11104,12.5289157794197; 11105,12.5289157794197; 11106,12.5289157794197; 11107,12.5289157794197; 11108,12.5289157794197; 11109,12.5289157794197; 11110,12.5355918830679; 11111,12.5691788005124; 11112,12.5960633085279; 11113,12.5965858829818; 11114,12.5971084574357; 11115,12.5976310318897; 11116,12.5981536063436; 11117,12.5986761807975; 11118,12.5991987552515; 11119,12.5997213297054; 11120,12.6002439041594; 11121,12.6007669844937; 11122,12.6012895589476; 11123,12.6018121334016; 11124,12.6023347078555; 11125,12.6028572823094; 11126,
        12.6033798567634; 11127,12.6039024312173; 11128,12.6044250056712; 11129,12.6049475801252; 11130,12.6054706604595; 11131,12.6059932349134; 11132,12.6065158093674; 11133,12.6070383838213; 11134,12.6075609582753; 11135,12.6080835327292; 11136,12.6086061071831; 11137,12.6091286816371; 11138,12.609651256091; 11139,12.6101738305449; 11140,12.6106964049989; 11141,12.6112194853332; 11142,12.6117420597871; 11143,12.6122646342411; 11144,12.612787208695; 11145,12.6133097831489; 11146,12.6138323576029; 11147,12.6143549320568; 11148,12.6148775065108; 11149,12.6154000809647; 11150,12.6159226554186; 11151,12.6164452298726; 11152,12.6169683102069; 11153,12.6174908846608; 11154,12.6180134591148; 11155,12.6185360335687; 11156,12.6190586080226; 11157,12.6195811824766; 11158,12.6201037569305; 11159,12.6206263313844; 11160,12.6211489058384; 11161,12.6216714802923; 11162,12.6221940547463; 11163,12.6227171350806; 11164,12.6227171350806; 11165,12.6227171350806; 11166,12.6227171350806; 11167,
        12.6227171350806; 11168,12.6227171350806; 11169,12.6227171350806; 11170,12.6227171350806; 11171,12.6227171350806; 11172,12.6227171350806; 11173,12.6227171350806; 11174,12.6227171350806; 11175,12.6227171350806; 11176,12.6227171350806; 11177,12.6227171350806; 11178,12.6227171350806; 11179,12.6227171350806; 11180,12.6227171350806; 11181,12.6227171350806; 11182,12.6227171350806; 11183,12.6227171350806; 11184,12.6227171350806; 11185,12.6227171350806; 11186,12.6227171350806; 11187,12.6227171350806; 11188,12.6227171350806; 11189,12.6227171350806; 11190,12.6227171350806; 11191,12.6227171350806; 11192,12.6227171350806; 11193,12.6227171350806; 11194,12.6227171350806; 11195,12.6227171350806; 11196,12.6227171350806; 11197,12.6227171350806; 11198,12.6227171350806; 11199,12.6227171350806; 11200,12.6227171350806; 11201,12.6227171350806; 11202,12.6227171350806; 11203,12.6227171350806; 11204,12.6227171350806; 11205,12.6227171350806; 11206,12.6227171350806; 11207,12.6227171350806; 11208,
        12.6227171350806; 11209,12.6227171350806; 11210,12.6227171350806; 11211,12.6227171350806; 11212,12.6227171350806; 11213,12.6092394694448; 11214,12.5955528752036; 11215,12.5955528752036; 11216,12.5955528752036; 11217,12.5955528752036; 11218,12.5955528752036; 11219,12.5955528752036; 11220,12.5955528752036; 11221,12.5955528752036; 11222,12.5955528752036; 11223,12.5955528752036; 11224,12.5955528752036; 11225,12.5955528752036; 11226,12.5955528752036; 11227,12.5955528752036; 11228,12.5955528752036; 11229,12.5955528752036; 11230,12.5955528752036; 11231,12.5955528752036; 11232,12.5955528752036; 11233,12.5955528752036; 11234,12.5955528752036; 11235,12.5955528752036; 11236,12.5955528752036; 11237,12.5955528752036; 11238,12.5955528752036; 11239,12.5955528752036; 11240,12.5955528752036; 11241,12.5955528752036; 11242,12.5955528752036; 11243,12.5955528752036; 11244,12.5955528752036; 11245,12.5955528752036; 11246,12.5955528752036; 11247,12.5955528752036; 11248,12.5955528752036; 11249,
        12.5955528752036; 11250,12.5955528752036; 11251,12.5955528752036; 11252,12.5955528752036; 11253,12.5955528752036; 11254,12.5955528752036; 11255,12.5955528752036; 11256,12.5955528752036; 11257,12.5955528752036; 11258,12.5955528752036; 11259,12.5955528752036; 11260,12.5955528752036; 11261,12.5955528752036; 11262,12.5955528752036; 11263,12.5955528752036; 11264,12.5956575924465; 11265,12.5957623096894; 11266,12.5958670269324; 11267,12.5959717441753; 11268,12.5960764614183; 11269,12.5961811786612; 11270,12.5962858959042; 11271,12.5963906131471; 11272,12.5964953303901; 11273,12.596600047633; 11274,12.5967052707564; 11275,12.5968099879993; 11276,12.5969147052423; 11277,12.5970194224852; 11278,12.5971241397282; 11279,12.5972288569711; 11280,12.5973335742141; 11281,12.597438291457; 11282,12.5975430087; 11283,12.5976482318233; 11284,12.5977529490662; 11285,12.5978576663092; 11286,12.5979623835521; 11287,12.5980671007951; 11288,12.598171818038; 11289,12.598276535281; 11290,
        12.5983812525239; 11291,12.5984859697669; 11292,12.5985906870098; 11293,12.5986954042528; 11294,12.5988006273761; 11295,12.5989053446191; 11296,12.599010061862; 11297,12.599114779105; 11298,12.5992194963479; 11299,12.5993242135909; 11300,12.5994289308338; 11301,12.5995336480768; 11302,12.5996383653197; 11303,12.599743588443; 11304,12.599848305686; 11305,12.5999530229289; 11306,12.6000577401719; 11307,12.6001624574148; 11308,12.6002671746578; 11309,12.6003718919007; 11310,12.6004766091437; 11311,12.6005813263866; 11312,12.6006860436296; 11313,12.6007907608725; 11314,12.6008959839959; 11315,12.6010007012388; 11316,12.6011054184818; 11317,12.6012101357247; 11318,12.6013148529677; 11319,12.6014195702106; 11320,12.6015242874536; 11321,12.6016290046965; 11322,12.6017337219395; 11323,12.6018384391824; 11324,12.6019431564253; 11325,12.6020483795487; 11326,12.6021530967916; 11327,12.6022578140346; 11328,12.6023625312775; 11329,12.6024672485205; 11330,12.6025719657634; 11331,
        12.6026766830064; 11332,12.6027814002493; 11333,12.6028861174923; 11334,12.6029913406156; 11335,12.6030960578586; 11336,12.6032007751015; 11337,12.6033054923445; 11338,12.6034102095874; 11339,12.6035149268304; 11340,12.6036196440733; 11341,12.6037243613163; 11342,12.6038290785592; 11343,12.6039337958021; 11344,12.6040385130451; 11345,12.6041437361684; 11346,12.6042484534114; 11347,12.6043531706543; 11348,12.6044578878973; 11349,12.6045626051402; 11350,12.6046673223832; 11351,12.6047720396261; 11352,12.6048767568691; 11353,12.604981474112; 11354,12.6050866972354; 11355,12.6051914144783; 11356,12.6052961317213; 11357,12.6054008489642; 11358,12.6055055662072; 11359,12.6056102834501; 11360,12.6057150006931; 11361,12.605819717936; 11362,12.605924435179; 11363,12.6060291524219; 11364,12.6061338696648; 11365,12.6062390927882; 11366,12.6063438100311; 11367,12.6064485272741; 11368,12.606553244517; 11369,12.60665796176; 11370,12.6067626790029; 11371,12.6068673962459; 11372,
        12.6069721134888; 11373,12.6070768307318; 11374,12.6071815479747; 11375,12.6072862652177; 11376,12.607391488341; 11377,12.607496205584; 11378,12.6076009228269; 11379,12.6077056400699; 11380,12.6078103573128; 11381,12.6079150745558; 11382,12.6080197917987; 11383,12.6081245090416; 11384,12.6082292262846; 11385,12.6083344494079; 11386,12.6084391666509; 11387,12.6085438838938; 11388,12.6086486011368; 11389,12.6087533183797; 11390,12.6088580356227; 11391,12.6089627528656; 11392,12.6090674701086; 11393,12.6091721873515; 11394,12.6092769045945; 11395,12.6093816218374; 11396,12.6094868449608; 11397,12.6095915622037; 11398,12.6096962794467; 11399,12.6098009966896; 11400,12.6099057139326; 11401,12.6100104311755; 11402,12.6101151484185; 11403,12.6102198656614; 11404,12.6103245829043; 11405,12.6104298060277; 11406,12.6105345232706; 11407,12.6106392405136; 11408,12.6107439577565; 11409,12.6108486749995; 11410,12.6109533922424; 11411,12.6110581094854; 11412,12.6111628267283; 11413,
        12.6112675439713; 11414,12.6113722612142; 11415,12.6114769784572; 11416,12.6115822015805; 11417,12.6116869188235; 11418,12.6117916360664; 11419,12.6118963533094; 11420,12.6120010705523; 11421,12.6121057877953; 11422,12.6122105050382; 11423,12.6123152222811; 11424,12.6124199395241; 11425,12.612524656767; 11426,12.61262937401; 11427,12.6127345971333; 11428,12.6128393143763; 11429,12.6129440316192; 11430,12.6130487488622; 11431,12.6131534661051; 11432,12.6132581833481; 11433,12.613362900591; 11434,12.613467617834; 11435,12.6135723350769; 11436,12.6136775582003; 11437,12.6137822754432; 11438,12.6138869926862; 11439,12.6139917099291; 11440,12.6140964271721; 11441,12.614201144415; 11442,12.6143058616579; 11443,12.6144105789009; 11444,12.6145152961438; 11445,12.6146200133868; 11446,12.6147247306297; 11447,12.6148299537531; 11448,12.614934670996; 11449,12.615039388239; 11450,12.6151441054819; 11451,12.6152488227249; 11452,12.6153535399678; 11453,12.6154582572108; 11454,
        12.6155629744537; 11455,12.6156676916967; 11456,12.61577291482; 11457,12.615877632063; 11458,12.6159823493059; 11459,12.6160870665489; 11460,12.6161917837918; 11461,12.6162965010348; 11462,12.6164012182777; 11463,12.6165059355206; 11464,12.6166106527636; 11465,12.6167153700065; 11466,12.6168200872495; 11467,12.6169253103728; 11468,12.6170300276158; 11469,12.6171347448587; 11470,12.6172394621017; 11471,12.6173441793446; 11472,12.6174488965876; 11473,12.6175536138305; 11474,12.6176583310735; 11475,12.6177630483164; 11476,12.6178677655594; 11477,12.6179724828023; 11478,12.6180777059257; 11479,12.6181824231686; 11480,12.6182871404116; 11481,12.6183918576545; 11482,12.6184965748974; 11483,12.6186012921404; 11484,12.6187060093833; 11485,12.6188107266263; 11486,12.6189154438692; 11487,12.6190206669926; 11488,12.6191253842355; 11489,12.6192301014785; 11490,12.6193348187214; 11491,12.6194395359644; 11492,12.6195442532073; 11493,12.6196489704503; 11494,12.6197536876932; 11495,
        12.6198584049362; 11496,12.6199631221791; 11497,12.6200678394221; 11498,12.6201730625454; 11499,12.6202777797884; 11500,12.6584997177124; 14499,12.6584997177124; 14500,12.6023347078555; 14501,12.6028572823094; 14502,12.6033798567634; 14503,12.6039024312173; 14504,12.6044250056712; 14505,12.6049475801252; 14506,12.6054706604595; 14507,12.6059932349134; 14508,12.6065158093674; 14509,12.6070383838213; 14510,12.6075609582753; 14511,12.6080835327292; 14512,12.6086061071831; 14513,12.6091286816371; 14514,12.609651256091; 14515,12.6101738305449; 14516,12.6106964049989; 14517,12.6112194853332; 14518,12.6117420597871; 14519,12.6122646342411; 14520,12.612787208695; 14521,12.6133097831489; 14522,12.6138323576029; 14523,12.6143549320568; 14524,12.6148775065108; 14525,12.6154000809647; 14526,12.6159226554186; 14527,12.6164452298726; 14528,12.6169683102069; 14529,12.6174908846608; 14530,12.6180134591148; 14531,12.6185360335687; 14532,12.6190586080226; 14533,12.6195811824766; 14534,
        12.6201037569305; 14535,12.6206263313844; 14536,12.6211489058384; 14537,12.6216714802923; 14538,12.6221940547463; 14539,12.6227171350806; 14540,12.6227171350806; 14541,12.6227171350806; 14542,12.6227171350806; 14543,12.6227171350806; 14544,12.6227171350806; 14545,12.6227171350806; 14546,12.6227171350806; 14547,12.6227171350806; 14548,12.6227171350806; 14549,12.6227171350806; 14550,12.6227171350806; 14551,12.6227171350806; 14552,12.6227171350806; 14553,12.6227171350806; 14554,12.6227171350806; 14555,12.6227171350806; 14556,12.6227171350806; 14557,12.6227171350806; 14558,12.6227171350806; 14559,12.6227171350806; 14560,12.6227171350806; 14561,12.6227171350806; 14562,12.6227171350806; 14563,12.6227171350806; 14564,12.6227171350806; 14565,12.6227171350806; 14566,12.6227171350806; 14567,12.6227171350806; 14568,12.6227171350806; 14569,12.6227171350806; 14570,12.6227171350806; 14571,12.6227171350806; 14572,12.6227171350806; 14573,12.6227171350806; 14574,12.6227171350806; 14575,
        12.6227171350806; 14576,12.6227171350806; 14577,12.6227171350806; 14578,12.6227171350806; 14579,12.6227171350806; 14580,12.6227171350806; 14581,12.6227171350806; 14582,12.6227171350806; 14583,12.6227171350806; 14584,12.6227171350806; 14585,12.6227171350806; 14586,12.6227171350806; 14587,12.6227171350806; 14588,12.6227171350806; 14589,12.6092394694448; 14590,12.5955528752036; 14591,12.5955528752036; 14592,12.5955528752036; 14593,12.5955528752036; 14594,12.5955528752036; 14595,12.5955528752036; 14596,12.5955528752036; 14597,12.5955528752036; 14598,12.5955528752036; 14599,12.5955528752036; 14600,12.5955528752036; 14601,12.5955528752036; 14602,12.5955528752036; 14603,12.5955528752036; 14604,12.5955528752036; 14605,12.5955528752036; 14606,12.5955528752036; 14607,12.5955528752036; 14608,12.5955528752036; 14609,12.5955528752036; 14610,12.5955528752036; 14611,12.5955528752036; 14612,12.5955528752036; 14613,12.5955528752036; 14614,12.5955528752036; 14615,12.5955528752036; 14616,
        12.5955528752036; 14617,12.5955528752036; 14618,12.5955528752036; 14619,12.5955528752036; 14620,12.5955528752036; 14621,12.5955528752036; 14622,12.5955528752036; 14623,12.5955528752036; 14624,12.5955528752036; 14625,12.5955528752036; 14626,12.5955528752036; 14627,12.5955528752036; 14628,12.5955528752036; 14629,12.5955528752036; 14630,12.5955528752036; 14631,12.5955528752036; 14632,12.5955528752036; 14633,12.5955528752036; 14634,12.5955528752036; 14635,12.5955528752036; 14636,12.5955528752036; 14637,12.5955528752036; 14638,12.5955528752036; 14639,12.5955528752036; 14640,12.5956575924465; 14641,12.5957623096894; 14642,12.5958670269324; 14643,12.5959717441753; 14644,12.5960764614183; 14645,12.5961811786612; 14646,12.5962858959042; 14647,12.5963906131471; 14648,12.5964953303901; 14649,12.596600047633; 14650,12.5967052707564; 14651,12.5968099879993; 14652,12.5969147052423; 14653,12.5970194224852; 14654,12.5971241397282; 14655,12.5972288569711; 14656,12.5973335742141; 14657,
        12.597438291457; 14658,12.5975430087; 14659,12.5976482318233; 14660,12.5977529490662; 14661,12.5978576663092; 14662,12.5979623835521; 14663,12.5980671007951; 14664,12.598171818038; 14665,12.598276535281; 14666,12.5983812525239; 14667,12.5984859697669; 14668,12.5985906870098; 14669,12.5986954042528; 14670,12.5988006273761; 14671,12.5989053446191; 14672,12.599010061862; 14673,12.599114779105; 14674,12.5992194963479; 14675,12.5993242135909; 14676,12.5994289308338; 14677,12.5995336480768; 14678,12.5996383653197; 14679,12.599743588443; 14680,12.599848305686; 14681,12.5999530229289; 14682,12.6000577401719; 14683,12.6001624574148; 14684,12.6002671746578; 14685,12.6003718919007; 14686,12.6004766091437; 14687,12.6005813263866; 14688,12.6006860436296; 14689,12.6007907608725; 14690,12.6008959839959; 14691,12.6010007012388; 14692,12.6011054184818; 14693,12.6012101357247; 14694,12.6013148529677; 14695,12.6014195702106; 14696,12.6015242874536; 14697,12.6016290046965; 14698,12.6017337219395;
        14699,12.6018384391824; 14700,12.6019431564253; 14701,12.6020483795487; 14702,12.6021530967916; 14703,12.6022578140346; 14704,12.6023625312775; 14705,12.6024672485205; 14706,12.6025719657634; 14707,12.6026766830064; 14708,12.6027814002493; 14709,12.6028861174923; 14710,12.6029913406156; 14711,12.6030960578586; 14712,12.6032007751015; 14713,12.6033054923445; 14714,12.6034102095874; 14715,12.6035149268304; 14716,12.6036196440733; 14717,12.6037243613163; 14718,12.6038290785592; 14719,12.6039337958021; 14720,12.6040385130451; 14721,12.6041437361684; 14722,12.6042484534114; 14723,12.6043531706543; 14724,12.6044578878973; 14725,12.6045626051402; 14726,12.6046673223832; 14727,12.6047720396261; 14728,12.6048767568691; 14729,12.604981474112; 14730,12.6050866972354; 14731,12.6051914144783; 14732,12.6052961317213; 14733,12.6054008489642; 14734,12.6055055662072; 14735,12.6056102834501; 14736,12.6057150006931; 14737,12.605819717936; 14738,12.605924435179; 14739,12.6060291524219; 14740,
        12.6061338696648; 14741,12.6062390927882; 14742,12.6063438100311; 14743,12.6064485272741; 14744,12.606553244517; 14745,12.60665796176; 14746,12.6067626790029; 14747,12.6068673962459; 14748,12.6069721134888; 14749,12.6070768307318; 14750,12.6071815479747; 14751,12.6072862652177; 14752,12.607391488341; 14753,12.607496205584; 14754,12.6076009228269; 14755,12.6077056400699; 14756,12.6078103573128; 14757,12.6079150745558; 14758,12.6080197917987; 14759,12.6081245090416; 14760,12.6082292262846; 14761,12.6083344494079; 14762,12.6084391666509; 14763,12.6085438838938; 14764,12.6086486011368; 14765,12.6087533183797; 14766,12.6088580356227; 14767,12.6089627528656; 14768,12.6090674701086; 14769,12.6091721873515; 14770,12.6092769045945; 14771,12.6093816218374; 14772,12.6094868449608; 14773,12.6095915622037; 14774,12.6096962794467; 14775,12.6098009966896; 14776,12.6099057139326; 14777,12.6100104311755; 14778,12.6101151484185; 14779,12.6102198656614; 14780,12.6103245829043; 14781,
        12.6104298060277; 14782,12.6105345232706; 14783,12.6106392405136; 14784,12.6107439577565; 14785,12.6108486749995; 14786,12.6109533922424; 14787,12.6110581094854; 14788,12.6111628267283; 14789,12.6112675439713; 14790,12.6113722612142; 14791,12.6114769784572; 14792,12.6115822015805; 14793,12.6116869188235; 14794,12.6117916360664; 14795,12.6118963533094; 14796,12.6120010705523; 14797,12.6121057877953; 14798,12.6122105050382; 14799,12.6123152222811; 14800,12.6124199395241; 14801,12.612524656767; 14802,12.61262937401; 14803,12.6127345971333; 14804,12.6128393143763; 14805,12.6129440316192; 14806,12.6130487488622; 14807,12.6131534661051; 14808,12.6132581833481; 14809,12.613362900591; 14810,12.613467617834; 14811,12.6135723350769; 14812,12.6136775582003; 14813,12.6137822754432; 14814,12.6138869926862; 14815,12.6139917099291; 14816,12.6140964271721; 14817,12.614201144415; 14818,12.6143058616579; 14819,12.6144105789009; 14820,12.6145152961438; 14821,12.6146200133868; 14822,
        12.6147247306297; 14823,12.6148299537531; 14824,12.614934670996; 14825,12.615039388239; 14826,12.6151441054819; 14827,12.6152488227249; 14828,12.6153535399678; 14829,12.6154582572108; 14830,12.6155629744537; 14831,12.6156676916967; 14832,12.61577291482; 14833,12.615877632063; 14834,12.6159823493059; 14835,12.6160870665489; 14836,12.6161917837918; 14837,12.6162965010348; 14838,12.6164012182777; 14839,12.6165059355206; 14840,12.6166106527636; 14841,12.6167153700065; 14842,12.6168200872495; 14843,12.6169253103728; 14844,12.6170300276158; 14845,12.6171347448587; 14846,12.6172394621017; 14847,12.6173441793446; 14848,12.6174488965876; 14849,12.6175536138305; 14850,12.6176583310735; 14851,12.6177630483164; 14852,12.6178677655594; 14853,12.6179724828023; 14854,12.6180777059257; 14855,12.6181824231686; 14856,12.6182871404116; 14857,12.6183918576545; 14858,12.6184965748974; 14859,12.6186012921404; 14860,12.6187060093833; 14861,12.6188107266263; 14862,12.6189154438692; 14863,
        12.6190206669926; 14864,12.6191253842355; 14865,12.6192301014785; 14866,12.6193348187214; 14867,12.6194395359644; 14868,12.6195442532073; 14869,12.6196489704503; 14870,12.6197536876932; 14871,12.6198584049362; 14872,12.6199631221791; 14873,12.6200678394221; 14874,12.6201730625454; 14875,12.6202777797884; 14876,12.6203824970313; 14877,12.6204872142743; 14878,12.6205919315172; 14879,12.6206966487601; 14880,12.6208013660031; 14881,12.620906083246; 14882,12.621010800489; 14883,12.6211160236123; 14884,12.6212207408553; 14885,12.6213254580982; 14886,12.6214301753412; 14887,12.6215348925841; 14888,12.6216396098271; 14889,12.62174432707; 14890,12.621849044313; 14891,12.6219537615559; 14892,12.6220584787989; 14893,12.6221631960418; 14894,12.6222684191652; 14895,12.6223731364081; 14896,12.6224778536511; 14897,12.622582570894; 14898,12.6226872881369; 14899,12.6227920053799; 14900,12.6228967226228; 14901,12.6230014398658; 14902,12.6231061571087; 14903,12.6232108743517; 14904,
        12.6233155915946; 14905,12.623420814718; 14906,12.6235255319609; 14907,12.6236302492039; 14908,12.6237349664468; 14909,12.6238396836898; 14910,12.6239444009327; 14911,12.6240491181757; 14912,12.6241538354186; 14913,12.6242585526616; 14914,12.6243637757849; 14915,12.6244684930279; 14916,12.6245732102708; 14917,12.6246779275138; 14918,12.6247826447567; 14919,12.6248873619996; 14920,12.6249920792426; 14921,12.6250967964855; 14922,12.6252015137285; 14923,12.6253062309714; 14924,12.6254109482144; 14925,12.6255161713377; 14926,12.6256208885807; 14927,12.6257256058236; 14928,12.6258303230666; 14929,12.6259350403095; 14930,12.6260397575525; 14931,12.6261444747954; 14932,12.6262491920384; 14933,12.6263539092813; 14934,12.6264591324047; 14935,12.6265638496476; 14936,12.6266685668906; 14937,12.6267732841335; 14938,12.6268780013764; 14939,12.6269827186194; 14940,12.6270874358623; 14941,12.6271921531053; 14942,12.6272968703482; 14943,12.6274015875912; 14944,12.6275063048341; 14945,
        12.6276115279575; 14946,12.6277162452004; 14947,12.6278209624434; 14948,12.6279256796863; 14949,12.6280303969293; 14950,12.6281351141722; 14951,12.6282398314152; 14952,12.6283445486581; 14953,12.6284492659011; 14954,12.6285544890244; 14955,12.6286592062674; 14956,12.6287639235103; 14957,12.6288686407532; 14958,12.6289733579962; 14959,12.6290780752391; 14960,12.6291827924821; 14961,12.629287509725; 14962,12.629392226968; 14963,12.6294969442109; 14964,12.6296016614539; 14965,12.6297068845772; 14966,12.6298116018202; 14967,12.6299163190631; 14968,12.6300210363061; 14969,12.630125753549; 14970,12.630230470792; 14971,12.6303351880349; 14972,12.6304399052779; 14973,12.6305446225208; 14974,12.6306493397638; 14975,12.6307540570067; 14976,12.6308592801301; 14977,12.630963997373; 14978,12.6310687146159; 14979,12.6311734318589; 14980,12.6312781491018; 14981,12.6313828663448; 14982,12.6314875835877; 14983,12.6315923008307; 14984,12.6316970180736; 14985,12.631802241197; 14986,
        12.6319069584399; 14987,12.6320116756829; 14988,12.6321163929258; 14989,12.6322211101688; 14990,12.6323258274117; 14991,12.6324305446547; 14992,12.6325352618976; 14993,12.6326399791406; 14994,12.6327446963835; 14995,12.6328494136265; 14996,12.6329546367498; 14997,12.6330593539927; 14998,12.6331640712357; 14999,12.6332687884786; 15000,12.6333735057216; 15001,12.6334782229645; 15002,12.6335829402075; 15003,12.6336876574504; 15004,12.6337923746934; 15005,12.6338975978167; 15006,12.6340023150597; 15007,12.6341070323026; 15008,12.6342117495456; 15009,12.6343164667885; 15010,12.6344211840315; 15011,12.6345259012744; 15012,12.6346306185174; 15013,12.6347353357603; 15014,12.6348400530033; 15015,12.6349447702462; 15016,12.6350499933696; 15017,12.6351547106125; 15018,12.6352594278554; 15019,12.6353641450984; 15020,12.6354688623413; 15021,12.6355735795843; 15022,12.6356782968272; 15023,12.6357830140702; 15024,12.6358877313131; 15025,12.6359924485561; 15026,12.636097165799; 15027,
        12.6362023889224; 15028,12.6363071061653; 15029,12.6364118234083; 15030,12.6365165406512; 15031,12.6366212578942; 15032,12.6367259751371; 15033,12.6368306923801; 15034,12.636935409623; 15035,12.637040126866; 15036,12.6371453499893; 15037,12.6372500672322; 15038,12.6373547844752; 15039,12.6374595017181; 15040,12.6375642189611; 15041,12.637668936204; 15042,12.637773653447; 15043,12.6378783706899; 15044,12.6379830879329; 15045,12.6380878051758; 15046,12.6381925224188; 15047,12.6382977455421; 15048,12.6384024627851; 15049,12.638507180028; 15050,12.638611897271; 15051,12.6387166145139; 15052,12.6388213317569; 15053,12.6389260489998; 15054,12.6390307662428; 15055,12.6391354834857; 15056,12.6392407066091; 15057,12.639345423852; 15058,12.6394501410949; 15059,12.6395548583379; 15060,12.6396595755808; 15061,12.6397642928238; 15062,12.6398690100667; 15063,12.6399737273097; 15064,12.6400784445526; 15065,12.6401831617956; 15066,12.6402878790385; 15067,12.6403931021619; 15068,
        12.6404978194048; 15069,12.6406025366478; 15070,12.6407072538907; 15071,12.6408119711337; 15072,12.6409166883766; 15073,12.6410214056196; 15074,12.6411261228625; 15075,12.6412308401055; 15076,12.6413355573484; 15077,12.6414402745913; 15078,12.6415454977147; 15079,12.6416502149576; 15080,12.6417549322006; 15081,12.6418596494435; 15082,12.6419643666865; 15083,12.6420690839294; 15084,12.6421738011724; 15085,12.6422785184153; 15086,12.6423832356583; 15087,12.6424884587816; 15088,12.6425931760246; 15089,12.6426978932675; 15090,12.6428026105105; 15091,12.6429073277534; 15092,12.6430120449964; 15093,12.6431167622393; 15094,12.6432214794823; 15095,12.6433261967252; 15096,12.6434309139681; 15097,12.6435356312111; 15098,12.6436408543344; 15099,12.6437455715774; 15100,12.6438502888203; 15101,12.6439550060633; 15102,12.6440597233062; 15103,12.6441644405492; 15104,12.6442691577921; 15105,12.6443738750351; 15106,12.644478592278; 15107,12.6445838154014; 15108,12.6446885326443; 15109,
        12.6447932498873; 15110,12.6448979671302; 15111,12.6450026843732; 15112,12.6451074016161; 15113,12.6452121188591; 15114,12.645316836102; 15115,12.645421553345; 15116,12.6455262705879; 15117,12.6456309878308; 15118,12.6457362109542; 15119,12.6458409281971; 15120,12.6459456454401; 15121,12.646050362683; 15122,12.646155079926; 15123,12.6462597971689; 15124,12.6463645144119; 15125,12.6464692316548; 15126,12.6465739488978; 15127,12.6466786661407; 15128,12.6467833833837; 15129,12.646888606507; 15130,12.64699332375; 15131,12.6470980409929; 15132,12.6472027582359; 15133,12.6473074754788; 15134,12.6474121927218; 15135,12.6475169099647; 15136,12.6476216272076; 15137,12.6477263444506; 15138,12.6478315675739; 15139,12.6479362848169; 15140,12.6480410020598; 15141,12.6481457193028; 15142,12.6482504365457; 15143,12.6483551537887; 15144,12.6484598710316; 15145,12.6485645882746; 15146,12.65527509179; 15147,12.6619334896242; 15148,12.6619334896242; 15149,12.6619334896242; 15150,12.6619334896242;
        15151,12.6619334896242; 15152,12.6619334896242; 15153,12.6619334896242; 15154,12.6619334896242; 15155,12.6619334896242; 15156,12.6619334896242; 15157,12.6619334896242; 15158,12.6619334896242; 15159,12.6619334896242; 15160,12.6619334896242; 15161,12.6619334896242; 15162,12.6619334896242; 15163,12.6619334896242; 15164,12.6619334896242; 15165,12.6619334896242; 15166,12.6619334896242; 15167,12.6619334896242; 15168,12.6619334896242; 15169,12.6619334896242; 15170,12.6619334896242; 15171,12.6619334896242; 15172,12.6619334896242; 15173,12.6619334896242; 15174,12.6619334896242; 15175,12.6619334896242; 15176,12.6619334896242; 15177,12.6619334896242; 15178,12.6619334896242; 15179,12.6619334896242; 15180,12.6619334896242; 15181,12.6619334896242; 15182,12.6619334896242; 15183,12.6619334896242; 15184,12.6619334896242; 15185,12.6619334896242; 15186,12.6619334896242; 15187,12.6619334896242; 15188,12.6619334896242; 15189,12.6619334896242; 15190,12.6619334896242; 15191,12.6619334896242; 15192,
        12.6619334896242; 15193,12.6619334896242; 15194,12.6737139265156; 15195,12.6991187343589; 15196,12.7151870135268; 15197,12.7151870135268; 15198,12.7151870135268; 15199,12.7151870135268; 15200,12.7151870135268; 15201,12.7151870135268; 15202,12.7151870135268; 15203,12.7151870135268; 15204,12.7151870135268; 15205,12.7151870135268; 15206,12.7151870135268; 15207,12.7151870135268; 15208,12.7151870135268; 15209,12.7151870135268; 15210,12.7151870135268; 15211,12.7151870135268; 15212,12.7151870135268; 15213,12.7151870135268; 15214,12.7151870135268; 15215,12.7151870135268; 15216,12.7151870135268; 15217,12.7151870135268; 15218,12.7151870135268; 15219,12.7114121339766; 15220,12.6977877630247; 15221,12.6831313960552; 15222,12.6808630283384; 15223,12.6808630283384; 15224,12.6808630283384; 15225,12.6808630283384; 15226,12.6808630283384; 15227,12.6808630283384; 15228,12.6808630283384; 15229,12.6808630283384; 15230,12.6808630283384; 15231,12.6808630283384; 15232,12.6808630283384; 15233,
        12.6808630283384; 15234,12.6808630283384; 15235,12.6810522276083; 15236,12.6812414268782; 15237,12.681430626148; 15238,12.6816198254179; 15239,12.6818095305682; 15240,12.6819992357184; 15241,12.6821884349883; 15242,12.6823776342582; 15243,12.682566833528; 15244,12.6827560327979; 15245,12.6829457379482; 15246,12.6831354430984; 15247,12.6833246423683; 15248,12.6835138416382; 15249,12.683703040908; 15250,12.6838922401779; 15251,12.6840819453282; 15252,12.6842716504784; 15253,12.6844608497483; 15254,12.6846500490182; 15255,12.684839248288; 15256,12.6850284475579; 15257,12.6852181527082; 15258,12.6854038108152; 15259,12.6854984104502; 15260,12.6855970571283; 15261,12.6857862563982; 15262,12.685975455668; 15263,12.6861646549379; 15264,12.6863538542078; 15265,12.686543559358; 15266,12.6867332645083; 15267,12.6869224637782; 15268,12.687111663048; 15269,12.6873008623179; 15270,12.6874900615878; 15271,12.687679766738; 15272,12.6878694718883; 15273,12.6880586711582; 15274,12.688247870428;
        15275,12.6884370696979; 15276,12.6886262689678; 15277,12.688815974118; 15278,12.6890056792683; 15279,12.6891948785382; 15280,12.689384077808; 15281,12.6895732770779; 15282,12.6897624763478; 15283,12.689952181498; 15284,12.689952181498; 15285,12.689952181498; 15286,12.689952181498; 15287,12.689952181498; 15288,12.689952181498; 15289,12.689952181498; 15290,12.689952181498; 15291,12.689952181498; 15292,12.689952181498; 15293,12.689952181498; 15294,12.689952181498; 15295,12.689952181498; 15296,12.689952181498; 15297,12.689952181498; 15298,12.689952181498; 15299,12.689952181498; 15300,12.689952181498; 15301,12.689952181498; 15302,12.689952181498; 15303,12.689952181498; 15304,12.689952181498; 15305,12.689952181498; 15306,12.689952181498; 15307,12.689952181498; 15308,12.689952181498; 15309,12.689952181498; 15310,12.689952181498; 15311,12.689952181498; 15312,12.689952181498; 15313,12.689952181498; 15314,12.689952181498; 15315,12.689952181498; 15316,12.689952181498; 15317,
        12.689952181498; 15318,12.689952181498; 15319,12.689952181498; 15320,12.6901418866483; 15321,12.6903310859182; 15322,12.690520285188; 15323,12.6907094844579; 15324,12.6908986837278; 15325,12.691088388878; 15326,12.6912780940283; 15327,12.6914672932982; 15328,12.691656492568; 15329,12.6918456918379; 15330,12.6920348911078; 15331,12.692224596258; 15332,12.6924143014083; 15333,12.6926035006782; 15334,12.692792699948; 15335,12.6929818992179; 15336,12.6931710984878; 15337,12.6933602977576; 15338,12.6935500029079; 15339,12.6937397080582; 15340,12.693928907328; 15341,12.6941181065979; 15342,12.6943073058678; 15343,12.6944965051376; 15344,12.6946862102879; 15345,12.6948759154382; 15346,12.695065114708; 15347,12.6952543139779; 15348,12.6954435132478; 15349,12.6956327125176; 15350,12.6958224176679; 15351,12.6960121228182; 15352,12.696201322088; 15353,12.6963905213579; 15354,12.6965797206278; 15355,12.6967689198976; 15356,12.6969586250479; 15357,12.6971483301982; 15358,12.697337529468;
        15359,12.6975267287379; 15360,12.6977159280078; 15361,12.6979051272776; 15362,12.6980948324279; 15363,12.6982845375782; 15364,12.698473736848; 15365,12.6986629361179; 15366,12.6988521353878; 15367,12.6990413346576; 15368,12.6992310398079; 15369,12.6994207449582; 15370,12.699609944228; 15371,12.6997991434979; 15372,12.6999883427678; 15373,12.7001775420376; 15374,12.7003667413075; 15375,12.7005564464578; 15376,12.700746151608; 15377,12.7009353508779; 15378,12.7011245501478; 15379,12.7013137494176; 15380,12.7015029486875; 15381,12.7016926538378; 15382,12.701882358988; 15383,12.7020715582579; 15384,12.7022607575278; 15385,12.7024499567976; 15386,12.7026391560675; 15387,12.7028288612178; 15388,12.703018566368; 15389,12.7032077656379; 15390,12.7033969649078; 15391,12.7035861641776; 15392,12.7037753634475; 15393,12.7039650685978; 15394,12.704154773748; 15395,12.7043439730179; 15396,12.7045331722878; 15397,12.7047223715576; 15398,12.7049115708275; 15399,12.7051012759778; 15400,
        12.705290981128; 15401,12.7054801803979; 15402,12.7056693796678; 15403,12.7058585789376; 15404,12.7060477782075; 15405,12.7062374833578; 15406,12.706427188508; 15407,12.7066163877779; 15408,12.7068055870478; 15409,12.7069947863176; 15410,12.7071839855875; 15411,12.7073731848574; 15412,12.7075628900076; 15413,12.7077525951579; 15414,12.7079417944278; 15415,12.7081309936976; 15416,12.7083201929675; 15417,12.7085093922374; 15418,12.7086990973876; 15419,12.7088888025379; 15420,12.7090780018078; 15421,12.7092672010776; 15422,12.7094564003475; 15423,12.7096455996174; 15424,12.7098353047676; 15425,12.7100250099179; 15426,12.7102142091878; 15427,12.7104034084576; 15428,12.7105926077275; 15429,12.7107818069974; 15430,12.7109715121476; 15431,12.7111612172979; 15432,12.7113504165678; 15433,12.7115396158376; 15434,12.7117288151075; 15435,12.7119180143774; 15436,12.7121077195276; 15437,12.7122974246779; 15438,12.7124866239478; 15439,12.7126758232176; 15440,12.7128650224875; 15441,
        12.7130542217574; 15442,12.7132439269076; 15443,12.7134336320579; 15444,12.7136228313278; 15445,12.7138120305976; 15446,12.7140012298675; 15447,12.7141904291374; 15448,12.7143796284072; 15449,12.7145693335575; 15450,12.7147590387078; 15451,12.7149482379776; 15452,12.7151374372475; 15453,12.7153266365174; 15454,12.7155158357872; 15455,12.7157055409375; 15456,12.7158952460878; 15457,12.7160844453576; 15458,12.7162736446275; 15459,12.7164628438974; 15460,12.7166520431672; 15461,12.7168417483175; 15462,12.7170314534678; 15463,12.7172206527376; 15464,12.7174098520075; 15465,12.7175990512774; 15466,12.7177882505472; 15467,12.7179779556975; 15468,12.7181676608478; 15469,12.7183568601176; 15470,12.7185460593875; 15471,12.7187352586574; 15472,12.7189244579272; 15473,12.7191141630775; 15474,12.7193038682278; 15475,12.7194930674976; 15476,12.7196822667675; 15477,12.7198527484625; 15478,12.7198527484625; 15479,12.7198527484625; 15480,12.7198527484625; 15481,12.7198527484625; 15482,
        12.7198527484625; 15483,12.7198527484625; 15484,12.7198527484625; 15485,12.7198527484625; 15486,12.7198527484625; 15487,12.7198527484625; 15488,12.7198527484625; 15489,12.7198527484625; 15490,12.7198527484625; 15491,12.7198527484625; 15492,12.7198527484625; 15493,12.7198527484625; 15494,12.7198527484625; 15495,12.7198527484625; 15496,12.7198527484625; 15497,12.7198527484625; 15498,12.7198527484625; 15499,12.7198527484625; 15500,12.7198527484625; 15501,12.7198527484625; 15502,12.7198527484625; 15503,12.7198527484625; 15504,12.7198527484625; 15505,12.7198527484625; 15506,12.7198527484625; 15507,12.7198527484625; 15508,12.7198527484625; 15509,12.7198527484625; 15510,12.7198527484625; 15511,12.7198527484625; 15512,12.7198527484625; 15513,12.7198527484625; 15514,12.7198527484625; 15515,12.7198527484625; 15516,12.7198527484625; 15517,12.7198527484625; 15518,12.7198527484625; 15519,12.7198527484625; 15520,12.7198527484625; 15521,12.7198527484625; 15522,12.7198527484625; 15523,
        12.7198527484625; 15524,12.7198527484625; 15525,12.7198527484625; 15526,12.7198527484625; 15527,12.7197819252064; 15528,12.7194890204544; 15529,12.7191961157024; 15530,12.71890270507; 15531,12.718609800318; 15532,12.718316895566; 15533,12.718023990814; 15534,12.7177310860619; 15535,12.7174381813099; 15536,12.7171452765579; 15537,12.7168518659255; 15538,12.7165589611735; 15539,12.7162660564215; 15540,12.7159731516695; 15541,12.7156802469175; 15542,12.7153873421654; 15543,12.7150944374134; 15544,12.714801026781; 15545,12.714508122029; 15546,12.714215217277; 15547,12.713922312525; 15548,12.713629407773; 15549,12.713336503021; 15550,12.7130435982689; 15551,12.7127501876365; 15552,12.7124572828845; 15553,12.7121643781325; 15554,12.7118714733805; 15555,12.7115785686285; 15556,12.7112856638765; 15557,12.7109927591245; 15558,12.710699348492; 15559,12.71040644374; 15560,12.710113538988; 15561,12.709820634236; 15562,12.709527729484; 15563,12.709234824732; 15564,12.70894191998; 15565,
        12.7086485093476; 15566,12.7083556045955; 15567,12.7080626998435; 15568,12.7077697950915; 15569,12.7074768903395; 15570,12.7071839855875; 15571,12.7068910808355; 15572,12.7065976702031; 15573,12.7063047654511; 15574,12.706011860699; 15575,12.705718955947; 15576,12.705718955947; 15577,12.705718955947; 15578,12.705718955947; 15579,12.705718955947; 15580,12.705718955947; 15581,12.705718955947; 15582,12.705718955947; 15583,12.705718955947; 15584,12.705718955947; 15585,12.705718955947; 15586,12.705718955947; 15587,12.705718955947; 15588,12.705718955947; 15589,12.705718955947; 15590,12.705718955947; 15591,12.705718955947; 15592,12.705718955947; 15593,12.705718955947; 15594,12.705718955947; 15595,12.705718955947; 15596,12.705718955947; 15597,12.705718955947; 15598,12.705718955947; 15599,12.705718955947; 15600,12.705718955947; 15601,12.705718955947; 15602,12.705718955947; 15603,12.705718955947; 15604,12.705718955947; 15605,12.705718955947; 15606,12.705718955947; 15607,12.705718955947;
        15608,12.705718955947; 15609,12.705718955947; 15610,12.705718955947; 15611,12.705718955947; 15612,12.705718955947; 15613,12.705718955947; 15614,12.705718955947; 15615,12.705718955947; 15616,12.705718955947; 15617,12.705718955947; 15618,12.705718955947; 15619,12.705718955947; 15620,12.705718955947; 15621,12.705718955947; 15622,12.705718955947; 15623,12.705718955947; 15624,12.705718955947; 15625,12.7380229606953; 15626,12.8063805557219; 15627,12.8422879465645; 15628,12.8422879465645; 15629,12.8422879465645; 15630,12.8422879465645; 15631,12.8422879465645; 15632,12.8422879465645; 15633,12.8422879465645; 15634,12.8422879465645; 15635,12.8422879465645; 15636,12.8422879465645; 15637,12.8422879465645; 15638,12.8422879465645; 15639,12.8422879465645; 15640,12.8422879465645; 15641,12.8422879465645; 15642,12.8422879465645; 15643,12.8422879465645; 15644,12.8422879465645; 15645,12.8422879465645; 15646,12.8422879465645; 15647,12.8422879465645; 15648,12.8422879465645; 15649,12.8422879465645;
        15650,12.8422879465645; 15651,12.8422879465645; 15652,12.8422879465645; 15653,12.8422879465645; 15654,12.8422879465645; 15655,12.8422879465645; 15656,12.8422879465645; 15657,12.8422879465645; 15658,12.8422879465645; 15659,12.8422879465645; 15660,12.8422879465645; 15661,12.8422879465645; 15662,12.8422879465645; 15663,12.8422879465645; 15664,12.8422879465645; 15665,12.8422879465645; 15666,12.8422879465645; 15667,12.8422879465645; 15668,12.8422879465645; 15669,12.8422879465645; 15670,12.8422879465645; 15671,12.8422879465645; 15672,12.8422879465645; 15673,12.8422879465645; 15674,12.8422879465645; 15675,12.8422879465645; 15676,12.8422879465645; 15677,12.8422879465645; 15678,12.8422879465645; 15679,12.8422879465645; 15680,12.8422879465645; 15681,12.8422879465645; 15682,12.8422879465645; 15683,12.8422879465645; 15684,12.8422879465645; 15685,12.8422879465645; 15686,12.8422879465645; 15687,12.8422879465645; 15688,12.8422879465645; 15689,12.8422879465645; 15690,12.8422879465645; 15691,
        12.8422879465645; 15692,12.8422879465645; 15693,12.8422879465645; 15694,12.8422879465645; 15695,12.8422879465645; 15696,12.8422879465645; 15697,12.8422879465645; 15698,12.8422879465645; 15699,12.8422879465645; 15700,12.8422879465645; 15701,12.8422879465645; 15702,12.8422879465645; 15703,12.8422879465645; 15704,12.8422879465645; 15705,12.8422879465645; 15706,12.8422879465645; 15707,12.8422879465645; 15708,12.8422879465645; 15709,12.8422879465645; 15710,12.8422879465645; 15711,12.8422879465645; 15712,12.8422879465645; 15713,12.8422879465645; 15714,12.8422879465645; 15715,12.8422879465645; 15716,12.8422879465645; 15717,12.8422879465645; 15718,12.8422879465645; 15719,12.8422879465645; 15720,12.8266147599896; 15721,12.770918339632; 15722,12.7308951058493; 15723,12.7308951058493; 15724,12.7308951058493; 15725,12.7308951058493; 15726,12.7308951058493; 15727,12.7308951058493; 15728,12.7308951058493; 15729,12.7308951058493; 15730,12.7308951058493; 15731,12.7308951058493; 15732,
        12.7308951058493; 15733,12.7308951058493; 15734,12.7308951058493; 15735,12.7308951058493; 15736,12.7308951058493; 15737,12.7308951058493; 15738,12.7308951058493; 15739,12.7308951058493; 15740,12.7308951058493; 15741,12.7308951058493; 15742,12.7308951058493; 15743,12.7308951058493; 15744,12.7308951058493; 15745,12.7308951058493; 15746,12.7308951058493; 15747,12.7308951058493; 15748,12.7308951058493; 15749,12.7308951058493; 15750,12.7308951058493; 15751,12.7308951058493; 15752,12.7308951058493; 15753,12.7308951058493; 15754,12.7308951058493; 15755,12.7308951058493; 15756,12.7308951058493; 15757,12.7308951058493; 15758,12.7308951058493; 15759,12.7308951058493; 15760,12.7308951058493; 15761,12.7308951058493; 15762,12.7308951058493; 15763,12.7308951058493; 15764,12.7308951058493; 15765,12.7308951058493; 15766,12.7308951058493; 15767,12.7308951058493; 15768,12.7308951058493; 15769,12.7308951058493; 15770,12.7308951058493; 15771,12.7308951058493; 15772,12.7308951058493; 15773,
        12.7308951058493; 15774,12.7308951058493; 15775,12.7308951058493; 15776,12.7308951058493; 15777,12.7308951058493; 15778,12.7308951058493; 15779,12.7308951058493; 15780,12.7308951058493; 15781,12.7308951058493; 15782,12.7308951058493; 15783,12.7308951058493; 15784,12.7308951058493; 15785,12.7109760650712; 15786,12.6724917194675; 15787,12.6538667207544; 15788,12.6537473329799; 15789,12.6536279452053; 15790,12.6535080515503; 15791,12.6533881578954; 15792,12.6532687701208; 15793,12.6531493823462; 15794,12.6530294886913; 15795,12.6529095950363; 15796,12.6527902072617; 15797,12.6526708194872; 15798,12.6525509258322; 15799,12.6524310321772; 15800,12.6523116444027; 15801,12.6521922566281; 15802,12.6520728688535; 15803,12.6519529751985; 15804,12.6518330815436; 15805,12.651713693769; 15806,12.6515943059944; 15807,12.6514744123395; 15808,12.6513545186845; 15809,12.6512351309099; 15810,12.6511157431354; 15811,12.6509958494804; 15812,12.6508759558254; 15813,12.6507565680509; 15814,
        12.6506371802763; 15815,12.6505172866213; 15816,12.6503973929664; 15817,12.6502780051918; 15818,12.6501586174172; 15819,12.6500392296427; 15820,12.6499193359877; 15821,12.6497994423327; 15822,12.6496800545581; 15823,12.6495606667836; 15824,12.6494407731286; 15825,12.6493208794736; 15826,12.6492014916991; 15827,12.6490821039245; 15828,12.6489622102695; 15829,12.6488423166146; 15830,12.64872292884; 15831,12.6486035410654; 15832,12.6484836474105; 15833,12.6483637537555; 15834,12.6482443659809; 15835,12.6481249782064; 15836,12.6480050845514; 15837,12.6478851908964; 15838,12.6477658031219; 15839,12.6476464153473; 15840,12.6475270275727; 15841,12.6474071339177; 15842,12.6472872402628; 15843,12.6471678524882; 15844,12.6470484647136; 15845,12.6469285710587; 15846,12.6468086774037; 15847,12.6466892896291; 15848,12.6465699018546; 15849,12.6464500081996; 15850,12.6463301145446; 15851,12.6462107267701; 15852,12.6460913389955; 15853,12.6459714453405; 15854,12.6458515516856; 15855,
        12.645732163911; 15856,12.6456127761364; 15857,12.6454928824815; 15858,12.6453729888265; 15859,12.6452536010519; 15860,12.6451342132773; 15861,12.6450148255028; 15862,12.6448949318478; 15863,12.6447750381928; 15864,12.6446556504183; 15865,12.6445362626437; 15866,12.6444163689887; 15867,12.6442964753338; 15868,12.6441770875592; 15869,12.6440576997846; 15870,12.6439378061297; 15871,12.6438179124747; 15872,12.6436985247001; 15873,12.6435791369256; 15874,12.6434592432706; 15875,12.6433393496156; 15876,12.6432199618411; 15877,12.6431005740665; 15878,12.6429811862919; 15879,12.6428612926369; 15880,12.642741398982; 15881,12.6426220112074; 15882,12.6425026234328; 15883,12.6423827297779; 15884,12.6422628361229; 15885,12.6421434483483; 15886,12.6420240605738; 15887,12.6419041669188; 15888,12.6417842732638; 15889,12.6416648854893; 15890,12.6415454977147; 15891,12.6414256040597; 15892,12.6413057104048; 15893,12.6411863226302; 15894,12.6410669348556; 15895,12.6409470412007; 15896,
        12.6408271475457; 15897,12.6407077597711; 15898,12.6405883719965; 15899,12.640468984222; 15900,12.640349090567; 15901,12.640229196912; 15902,12.6401098091375; 15903,12.6399904213629; 15904,12.6398705277079; 15905,12.639750634053; 15906,12.6396312462784; 15907,12.6395118585038; 15908,12.6393919648489; 15909,12.6392720711939; 15910,12.6391526834193; 15911,12.6390332956448; 15912,12.6389134019898; 15913,12.6387935083348; 15914,12.6386741205603; 15915,12.6385547327857; 15916,12.6384348391307; 15917,12.6383149454757; 15918,12.6381955577012; 15919,12.6380761699266; 15920,12.637956782152; 15921,12.6378368884971; 15922,12.6377169948421; 15923,12.6375976070675; 15924,12.637478219293; 15925,12.637358325638; 15926,12.637238431983; 15927,12.6371190442085; 15928,12.6369996564339; 15929,12.6368797627789; 15930,12.636759869124; 15931,12.6366404813494; 15932,12.6365210935748; 15933,12.6364011999199; 15934,12.6362813062649; 15935,12.6361619184903; 15936,12.6360425307157; 15937,12.6359231429412;
        15938,12.6358032492862; 15939,12.6356833556312; 15940,12.6355639678567; 15941,12.6354445800821; 15942,12.6353246864271; 15943,12.6352047927722; 15944,12.6350854049976; 15945,12.634966017223; 15946,12.6348461235681; 15947,12.6347262299131; 15948,12.6346068421385; 15949,12.634487454364; 15950,12.634367560709; 15951,12.634247667054; 15952,12.6341282792795; 15953,12.6340088915049; 15954,12.6338889978499; 15955,12.6337691041949; 15956,12.6336497164204; 15957,12.6335303286458; 15958,12.6334109408712; 15959,12.6332910472163; 15960,12.6331711535613; 15961,12.6330517657867; 15962,12.6329323780122; 15963,12.6328124843572; 15964,12.6326925907022; 15965,12.6325732029277; 15966,12.6324538151531; 15967,12.6323339214981; 15968,12.6322140278432; 15969,12.6320946400686; 15970,12.631975252294; 15971,12.6318553586391; 15972,12.6317354649841; 15973,12.6316160772095; 15974,12.6314966894349; 15975,12.6313773016604; 15976,12.6312574080054; 15977,12.6311375143504; 15978,12.6310181265759; 15979,
        12.6308987388013; 15980,12.6307788451463; 15981,12.6306589514914; 15982,12.6305395637168; 15983,12.6304201759422; 15984,12.6303002822873; 15985,12.6301803886323; 15986,12.6300610008577; 15987,12.6299416130832; 15988,12.6298217194282; 15989,12.6297018257732; 15990,12.6295824379987; 15991,12.6294630502241; 15992,12.6293431565691; 15993,12.6292232629141; 15994,12.6291038751396; 15995,12.628984487365; 15996,12.6288650995904; 15997,12.6287452059355; 15998,12.6286253122805; 15999,12.6285059245059; 16000,12.6283865367314; 16001,12.6282666430764; 16002,12.6281467494214; 16003,12.6280273616469; 16004,12.6279079738723; 16005,12.6277880802173; 16006,12.6276681865624; 16007,12.6275487987878; 16008,12.6274294110132; 16009,12.6273095173583; 16010,12.6271896237033; 16011,12.6270702359287; 16012,12.6269508481541; 16013,12.6268309544992; 16014,12.6267110608442; 16015,12.6265916730696; 16016,12.6264722852951; 16017,12.6263528975205; 16018,12.6262330038655; 16019,12.6261131102106; 16020,
        12.625993722436; 16021,12.6258743346614; 16022,12.6257544410065; 16023,12.6256345473515; 16024,12.6255151595769; 16025,12.6253957718024; 16026,12.6252758781474; 16027,12.6251559844924; 16028,12.6250365967179; 16029,12.6249172089433; 16030,12.6247973152883; 16031,12.6246774216333; 16032,12.6245580338588; 16033,12.6244386460842; 16034,12.6243192583096; 16035,12.6241993646547; 16036,12.6240794709997; 16037,12.6239600832251; 16038,12.6238406954506; 16039,12.6237208017956; 16040,12.6236009081406; 16041,12.6234815203661; 16042,12.6233621325915; 16043,12.6232422389365; 16044,12.6231223452816; 16045,12.623002957507; 16046,12.6228835697324; 16047,12.6227636760775; 16048,12.6226437824225; 16049,12.6225243946479; 16050,12.6224050068733; 16051,12.6222851132184; 16052,12.6221652195634; 16053,12.6220458317888; 16054,12.6219264440143; 16055,12.6218070562397; 16056,12.6216871625847; 16057,12.6215672689298; 16058,12.6214478811552; 16059,12.6213284933806; 16060,12.6212085997257; 16061,
        12.6210887060707; 16062,12.6209693182961; 16063,12.6208499305216; 16064,12.6207300368666; 16065,12.6206101432116; 16066,12.6204907554371; 16067,12.6203713676625; 16068,12.6202514740075; 16069,12.6201315803525; 16070,12.620012192578; 16071,12.6198928048034; 16072,12.6197729111484; 16073,12.6196530174935; 16074,12.6195336297189; 16075,12.6194142419443; 16076,12.6192948541698; 16077,12.6191749605148; 16078,12.6190550668598; 16079,12.6189356790853; 16080,12.6188162913107; 16081,12.6186963976557; 16082,12.6185765040008; 16083,12.6184571162262; 16084,12.6183377284516; 16085,12.6182178347967; 16086,12.6180979411417; 16087,12.6179785533671; 16088,12.6178591655926; 16089,12.6177392719376; 16090,12.6176193782826; 16091,12.617499990508; 16092,12.6173806027335; 16093,12.6172612149589; 16094,12.6171413213039; 16095,12.617021427649; 16096,12.6169020398744; 16097,12.6167826520998; 16098,12.6166627584449; 16099,12.6165428647899; 16100,12.6164234770153; 16101,12.6163040892408; 16102,
        12.6161841955858; 16103,12.6160643019308; 16104,12.6159449141563; 16105,12.6158255263817; 16106,12.6157056327267; 16107,12.6155857390718; 16108,12.6154663512972; 16109,12.6153469635226; 16110,12.6152270698676; 16111,12.6151071762127; 16112,12.6149877884381; 16113,12.6148684006635; 16114,12.614749012889; 16115,12.614629119234; 16116,12.614509225579; 16117,12.6143898378045; 16118,12.6142704500299; 16119,12.6141505563749; 16120,12.61403066272; 16121,12.6139112749454; 16122,12.6137918871708; 16123,12.6136719935159; 16124,12.6135520998609; 16125,12.6134327120863; 16126,12.6133133243118; 16127,12.6131934306568; 16128,12.6130735370018; 16129,12.6129541492272; 16130,12.6128347614527; 16131,12.6127148677977; 16132,12.6125949741427; 16133,12.6124755863682; 16134,12.6123561985936; 16135,12.612236810819; 16136,12.6121169171641; 16137,12.6119970235091; 16138,12.6118776357345; 16139,12.61175824796; 16140,12.611638354305; 16141,12.61151846065; 16142,12.6113990728755; 16143,12.6112796851009;
        16144,12.6111597914459; 16145,12.611039897791; 16146,12.6109205100164; 16147,12.6108011222418; 16148,12.6106812285868; 16149,12.6105613349319; 16150,12.6104419471573; 16151,12.6103225593827; 16152,12.6102031716082; 16153,12.6100832779532; 16154,12.6099633842982; 16155,12.6098439965237; 16156,12.6097246087491; 16157,12.6096047150941; 16158,12.6094848214392; 16159,12.6093654336646; 16160,12.60924604589; 16161,12.6091261522351; 16162,12.6090062585801; 16163,12.6088868708055; 16164,12.608767483031; 16165,12.608647589376; 16166,12.608527695721; 16167,12.6084083079464; 16168,12.6082889201719; 16169,12.6081690265169; 16170,12.6080491328619; 16171,12.6079297450874; 16172,12.6078103573128; 16173,12.6076909695382; 16174,12.6075710758833; 16175,12.6074511822283; 16176,12.6073317944537; 16177,12.6072124066792; 16178,12.6070925130242; 16179,12.6069726193692; 16180,12.6068532315947; 16181,12.6067338438201; 16182,12.6066139501651; 16183,12.6064940565102; 16184,12.6063746687356; 16185,
        12.606255280961; 16186,12.606135387306; 16187,12.6060154936511; 16188,12.6058961058765; 16189,12.6057767181019; 16190,12.605656824447; 16191,12.605536930792; 16192,12.6054175430174; 16193,12.6052981552429; 16194,12.6051787674683; 16195,12.6050588738133; 16196,12.6049389801584; 16197,12.6048195923838; 16198,12.6047002046092; 16199,12.6045803109543; 16200,12.6044604172993; 16201,12.6043410295247; 16202,12.6042216417502; 16203,12.6041017480952; 16204,12.6039818544402; 16205,12.6038624666656; 16206,12.6037430788911; 16207,12.6036231852361; 16208,12.6035032915811; 16209,12.6033839038066; 16210,12.603264516032; 16211,12.6031451282574; 16212,12.6030252346025; 16213,12.6029053409475; 16214,12.6027859531729; 16215,12.6026665653984; 16216,12.6025466717434; 16217,12.6024267780884; 16218,12.6023073903139; 16219,12.6021880025393; 16220,12.6020681088843; 16221,12.6019482152294; 16222,12.6018288274548; 16223,12.6017094396802; 16224,12.6015895460252; 16225,12.6014696523703; 16226,
        12.6013502645957; 16227,12.6012308768211; 16228,12.6011109831662; 16229,12.6009910895112; 16230,12.6008717017366; 16231,12.6007523139621; 16232,12.6006329261875; 16233,12.6005130325325; 16234,12.6003931388776; 16235,12.600273751103; 16236,12.6001543633284; 16237,12.6000344696735; 16238,12.5999145760185; 16239,12.5997951882439; 16240,12.5996758004694; 16241,12.5995559068144; 16242,12.5994360131594; 16243,12.5993166253848; 16244,12.5991972376103; 16245,12.5990773439553; 16246,12.5989574503003; 16247,12.5988380625258; 16248,12.5987186747512; 16249,12.5985992869766; 16250,12.5984793933217; 16251,12.5983594996667; 16252,12.5982401118921; 16253,12.5981207241176; 16254,12.5980008304626; 16255,12.5978809368076; 16256,12.5977615490331; 16257,12.5976421612585; 16258,12.5975222676035; 16259,12.5974023739486; 16260,12.597282986174; 16261,12.5971635983994; 16262,12.5970437047444; 16263,12.5969238110895; 16264,12.5968044233149; 16265,12.5966850355403; 16266,12.5965651418854; 16267,
        12.5964452482304; 16268,12.5963258604558; 16269,12.5962064726813; 16270,12.5960870849067; 16271,12.5959671912517; 16272,12.5958472975968; 16273,12.5957279098222; 16274,12.5956085220476; 16275,12.5954886283927; 16276,12.5953687347377; 16277,12.5952493469631; 16278,12.5951299591886; 16279,12.5950100655336; 16280,12.5948901718786; 16281,12.594770784104; 16282,12.5946513963295; 16283,12.5945315026745; 16284,12.5944116090195; 16285,12.594292221245; 16286,12.5941728334704; 16287,12.5940529398154; 16288,12.5939330461605; 16289,12.5938136583859; 16290,12.5936942706113; 16291,12.5935748828368; 16292,12.5934549891818; 16293,12.5933350955268; 16294,12.5932157077523; 16295,12.5930963199777; 16296,12.5826367368126; 16297,12.5723658470369; 16298,12.5723658470369; 16299,12.5723658470369; 16300,12.5723658470369; 16301,12.5723658470369; 16302,12.5723658470369; 16303,12.5723658470369; 16304,12.5723658470369; 16305,12.5723658470369; 16306,12.5723658470369; 16307,12.5723658470369; 16308,
        12.5723658470369; 16309,12.5723658470369; 16310,12.5723658470369; 16311,12.5723658470369; 16312,12.5723658470369; 16313,12.5723658470369; 16314,12.5723658470369; 16315,12.5723658470369; 16316,12.5723658470369; 16317,12.5723658470369; 16318,12.5723658470369; 16319,12.5723658470369; 16320,12.5723658470369; 16321,12.5723658470369; 16322,12.5723658470369; 16323,12.5723658470369; 16324,12.5723658470369; 16325,12.5723658470369; 16326,12.5723658470369; 16327,12.5723658470369; 16328,12.5723658470369; 16329,12.5723658470369; 16330,12.5723658470369; 16331,12.5723658470369; 16332,12.5723658470369; 16333,12.5723658470369; 16334,12.5723658470369; 16335,12.5723658470369; 16336,12.5723658470369; 16337,12.5723658470369; 16338,12.5723658470369; 16339,12.5723658470369; 16340,12.5723658470369; 16341,12.5723658470369; 16342,12.5723658470369; 16343,12.5723658470369; 16344,12.5723658470369; 16345,12.5723658470369; 16346,12.5723658470369; 16347,12.5726238460413; 16348,12.572882350926; 16349,
        12.5731408558108; 16350,12.5733988548152; 16351,12.5736568538195; 16352,12.5739148528239; 16353,12.5741733577087; 16354,12.5744318625934; 16355,12.5746898615978; 16356,12.5749478606021; 16357,12.5752063654869; 16358,12.5754648703717; 16359,12.575722869376; 16360,12.5759808683804; 16361,12.5762388673848; 16362,12.5764973722695; 16363,12.5767558771543; 16364,12.5770138761587; 16365,12.577271875163; 16366,12.5775298741674; 16367,12.5777883790521; 16368,12.5780468839369; 16369,12.5783048829413; 16370,12.5785628819456; 16371,12.5788213868304; 16372,12.5790798917152; 16373,12.5793378907195; 16374,12.5795958897239; 16375,12.5798538887283; 16376,12.580112393613; 16377,12.5803708984978; 16378,12.5806288975021; 16379,12.5808868965065; 16380,12.5811454013913; 16381,12.581403906276; 16382,12.5816619052804; 16383,12.5819199042848; 16384,12.5821779032891; 16385,12.5824364081739; 16386,12.5826949130587; 16387,12.582952912063; 16388,12.5832109110674; 16389,12.5834689100717; 16390,
        12.5837274149565; 16391,12.5839859198413; 16392,12.5842439188456; 16393,12.58450191785; 16394,12.5847604227348; 16395,12.5850189276195; 16396,12.5852769266239; 16397,12.5855349256282; 16398,12.5857929246326; 16399,12.5860514295174; 16400,12.5863099344021; 16401,12.5865679334065; 16402,12.5868259324109; 16403,12.5870839314152; 16404,12.5873424363; 16405,12.5876009411848; 16406,12.5878589401891; 16407,12.5881169391935; 16408,12.5883754440782; 16409,12.588633948963; 16410,12.5888919479674; 16411,12.5891499469717; 16412,12.5894079459761; 16413,12.5896664508609; 16414,12.5899249557456; 16415,12.59018295475; 16416,12.5904409537544; 16417,12.5906994586391; 16418,12.5909579635239; 16419,12.5912159625282; 16420,12.5914739615326; 16421,12.591731960537; 16422,12.5919904654217; 16423,12.5922489703065; 16424,12.5925069693109; 16425,12.5927649683152; 16426,12.5930229673196; 16427,12.5932814722044; 16428,12.5935399770891; 16429,12.5937979760935; 16430,12.5940559750978; 16431,12.5943144799826;
        16432,12.5945729848674; 16433,12.5948309838717; 16434,12.5950889828761; 16435,12.5953469818805; 16436,12.5956054867652; 16437,12.59586399165; 16438,12.5961219906544; 16439,12.5963799896587; 16440,12.5966379886631; 16441,12.5968964935478; 16442,12.5971549984326; 16443,12.597412997437; 16444,12.5976709964413; 16445,12.5979295013261; 16446,12.5981880062109; 16447,12.5984460052152; 16448,12.5987040042196; 16449,12.598962003224; 16450,12.5992205081087; 16451,12.5994790129935; 16452,12.5997370119978; 16453,12.5999950110022; 16454,12.600253515887; 16455,12.6005120207717; 16456,12.6007700197761; 16457,12.6010280187805; 16458,12.6012860177848; 16459,12.6015445226696; 16460,12.6018030275543; 16461,12.6020610265587; 16462,12.6023190255631; 16463,12.6025770245674; 16464,12.6028355294522; 16465,12.603094034337; 16466,12.6033520333413; 16467,12.6036100323457; 16468,12.6038685372305; 16469,12.6041270421152; 16470,12.6043850411196; 16471,12.6046430401239; 16472,12.6049010391283; 16473,
        12.6051595440131; 16474,12.6054180488978; 16475,12.6056760479022; 16476,12.6059340469066; 16477,12.6061920459109; 16478,12.6064505507957; 16479,12.6067090556805; 16480,12.6069670546848; 16481,12.6072250536892; 16482,12.6074835585739; 16483,12.6077420634587; 16484,12.6080000624631; 16485,12.6082580614674; 16486,12.6085160604718; 16487,12.6087745653566; 16488,12.6090330702413; 16489,12.6092910692457; 16490,12.6095490682501; 16491,12.6098070672544; 16492,12.6100655721392; 16493,12.6103240770239; 16494,12.6105820760283; 16495,12.6108400750327; 16496,12.6110985799174; 16497,12.6113570848022; 16498,12.6116150838066; 16499,12.6118730828109; 16500,12.6584997177124; 20000,12.6584997177124]) annotation (Placement(transformation(extent={{-440,40},{-420,60}})));
  Modelica.Blocks.Sources.TimeTable timeTableGrindingPressure_complete(table=[0,9368474.1973877; 5,9367166.13769531; 10,9365414.81018066; 15,9363390.3503418; 20,9363739.77661133; 25,9363390.3503418; 30,9360945.89233398; 35,9361661.52954102; 40,9361661.52954102; 45,9361661.52954102; 50,9363390.3503418; 55,9363390.3503418; 60,9361553.19213867; 65,9359947.9675293; 70,9359172.82104492; 75,9358341.97998047; 80,9359797.66845703; 85,9359946.44165039; 90,9359947.9675293; 95,9359947.9675293; 100,9359947.9675293; 105,9361804.19921875; 110,9361804.19921875; 115,9361804.19921875; 120,9359866.33300781; 125,9359797.66845703; 130,9359866.33300781; 135,9367129.51660156; 140,9366631.31713867; 145,9368998.71826172; 150,9370476.53198242; 155,9370942.68798828; 160,9370942.68798828; 165,9371895.59936523; 170,9378485.10742188; 175,9381961.05957031; 180,9383055.11474609; 185,9383055.11474609; 190,9383086.39526367; 195,9383086.39526367; 200,9386713.40942383; 205,9385923.00415039; 210,9387772.36938477; 215,
        9389241.79077148; 220,9390181.73217773; 225,9391178.13110352; 230,9388832.85522461; 235,9388832.85522461; 240,9382334.89990234; 245,9378466.796875; 250,9378466.796875; 255,9378466.796875; 260,9378466.796875; 265,9376108.55102539; 270,9381192.01660156; 275,9377661.89575195; 280,9378466.796875; 285,9375724.79248047; 290,9377661.89575195; 295,9377661.89575195; 300,9377781.67724609; 305,9379515.83862305; 310,9379384.61303711; 315,9379515.83862305; 320,9381192.01660156; 325,9379384.61303711; 330,9377661.89575195; 335,9373829.65087891; 340,9377661.89575195; 345,9373158.26416016; 350,9375484.46655273; 355,9373829.65087891; 360,9373829.65087891; 365,9373829.65087891; 370,9370602.41699219; 375,9366871.64306641; 380,9366171.26464844; 385,9366871.64306641; 390,9366171.26464844; 395,9356371.30737305; 400,9353338.62304688; 405,9352303.31420898; 410,9345852.66113281; 415,9333304.59594727; 420,9332772.06420898; 425,9328784.94262695; 430,9321597.29003906; 435,9318482.20825195; 440,
        9315982.05566406; 445,9314762.11547852; 450,9321597.29003906; 455,9322524.26147461; 460,9322524.26147461; 465,9324758.91113281; 470,9326314.54467773; 475,9333592.98706055; 480,9341744.23217773; 485,9343793.48754883; 490,9347460.17456055; 495,9347460.17456055; 500,9349130.24902344; 505,9351358.79516602; 510,9351358.79516602; 515,9352969.36035156; 520,9352717.59033203; 525,9353676.60522461; 530,9350560.76049805; 535,9348496.24633789; 540,9347119.140625; 545,9346077.72827148; 550,9345052.33764648; 555,9338780.21240234; 560,9339830.7800293; 565,9338620.75805664; 570,9331922.91259766; 575,9330493.1640625; 580,9330493.1640625; 585,9323311.61499023; 590,9320689.39208984; 595,9322016.14379883; 600,9322016.14379883; 605,9323311.61499023; 610,9323311.61499023; 615,9327989.19677734; 620,9327989.19677734; 625,9330493.1640625; 630,9333462.52441406; 635,9327989.19677734; 640,9326754.76074219; 645,9326754.76074219; 650,9327989.19677734; 655,9315804.29077148; 660,9323554.99267578; 665,
        9319947.05200195; 670,9315804.29077148; 675,9314898.68164063; 680,9315718.84155273; 685,9315163.42163086; 690,9314898.68164063; 695,9315718.84155273; 700,9320674.13330078; 705,9328309.63134766; 710,9333436.58447266; 715,9335984.80224609; 720,9341702.27050781; 725,9341702.27050781; 730,9342256.92749023; 735,9342372.13134766; 740,9345870.97167969; 745,9347063.44604492; 750,9354106.14013672; 755,9359235.38208008; 760,9364662.93334961; 765,9365677.64282227; 770,9365998.84033203; 775,9366150.6652832; 780,9367096.71020508; 785,9368248.7487793; 790,9367820.73974609; 795,9369591.5222168; 800,9369429.77905273; 805,9367820.73974609; 810,9367096.71020508; 815,9369429.77905273; 820,9369773.10180664; 825,9370498.65722656; 830,9377535.24780273; 835,9380623.62670898; 840,9385800.93383789; 845,9383727.2644043; 850,9385800.93383789; 855,9389481.35375977; 860,9384176.63574219; 865,9384176.63574219; 870,9380306.24389648; 875,9379403.68652344; 880,9380306.24389648; 885,9380187.2253418; 890,
        9377143.85986328; 895,9373787.68920898; 900,9370070.64819336; 905,9367514.80102539; 910,9367514.80102539; 915,9365181.73217773; 920,9367514.80102539; 925,9364151.00097656; 930,9363389.58740234; 935,9367514.80102539; 940,9368591.30859375; 945,9370698.54736328; 950,9374122.61962891; 955,9374122.61962891; 960,9375984.95483398; 965,9378984.06982422; 970,9382505.03540039; 975,9383577.72827148; 980,9384387.9699707; 985,9382820.89233398; 990,9378067.01660156; 995,9380186.46240234; 1000,9384593.96362305; 1005,9386827.8503418; 1010,9382820.89233398; 1015,9380186.46240234; 1020,9377088.92822266; 1025,9378067.01660156; 1030,9378067.01660156; 1035,9380186.46240234; 1040,9377018.73779297; 1045,9377088.92822266; 1050,9376381.68334961; 1055,9375209.80834961; 1060,9377088.92822266; 1065,9380300.14038086; 1070,9383312.2253418; 1075,9381444.54956055; 1080,9380300.14038086; 1085,9383312.2253418; 1090,9384290.3137207; 1095,9387620.54443359; 1100,9387620.54443359; 1105,9387620.54443359; 1110,
        9388478.08837891; 1115,9388924.40795898; 1120,9388478.08837891; 1125,9387620.54443359; 1130,9387620.54443359; 1135,9387620.54443359; 1140,9387620.54443359; 1145,9387635.0402832; 1150,9388282.01293945; 1155,9389289.09301758; 1160,9388282.01293945; 1165,9385218.0480957; 1170,9384111.02294922; 1175,9380931.09130859; 1180,9375354.7668457; 1185,9373498.53515625; 1190,9373930.35888672; 1195,9373930.35888672; 1200,9373930.35888672; 1205,9375244.140625; 1210,9375244.140625; 1215,9373930.35888672; 1220,9373930.35888672; 1225,9373930.35888672; 1230,9372800.44555664; 1235,9371223.44970703; 1240,9373930.35888672; 1245,9373498.53515625; 1250,9373930.35888672; 1255,9375312.80517578; 1260,9375312.80517578; 1265,9376754.76074219; 1270,9376638.79394531; 1275,9375585.17456055; 1280,9376754.76074219; 1285,9381099.70092773; 1290,9391757.20214844; 1295,9383999.63378906; 1300,9391757.20214844; 1305,9392562.10327148; 1310,9392999.26757813; 1315,9392999.26757813; 1320,9392419.43359375; 1325,
        9387474.82299805; 1330,9389096.06933594; 1335,9389096.06933594; 1340,9383999.63378906; 1345,9383999.63378906; 1350,9385459.13696289; 1355,9383327.48413086; 1360,9381772.61352539; 1365,9366509.24682617; 1370,9365766.90673828; 1375,9370909.11865234; 1380,9365745.54443359; 1385,9355209.35058594; 1390,9355209.35058594; 1395,9361766.05224609; 1400,9355633.54492188; 1405,9355633.54492188; 1410,9358093.26171875; 1415,9364023.59008789; 1420,9370909.11865234; 1425,9370909.11865234; 1430,9370909.11865234; 1435,9376892.8527832; 1440,9382499.69482422; 1445,9382499.69482422; 1450,9382499.69482422; 1455,9386851.50146484; 1460,9392404.93774414; 1465,9387070.46508789; 1470,9391032.40966797; 1475,9397283.17260742; 1480,9400114.44091797; 1485,9400983.42895508; 1490,9391032.40966797; 1495,9389730.07202148; 1500,9389730.07202148; 1505,9393738.5559082; 1510,9397928.61938477; 1515,9392540.7409668; 1520,9388594.05517578; 1525,9378624.7253418; 1530,9372416.68701172; 1535,9372416.68701172; 1540,
        9372416.68701172; 1545,9372416.68701172; 1550,9372416.68701172; 1555,9375209.04541016; 1560,9376003.26538086; 1565,9378621.67358398; 1570,9391098.78540039; 1575,9393997.19238281; 1580,9391098.78540039; 1585,9382080.078125; 1590,9388764.95361328; 1595,9393997.19238281; 1600,9393997.19238281; 1605,9397003.17382813; 1610,9394946.2890625; 1615,9397003.17382813; 1620,9393447.87597656; 1625,9397003.17382813; 1630,9390575.40893555; 1635,9387061.30981445; 1640,9384036.25488281; 1645,9382832.33642578; 1650,9376747.89428711; 1655,9376747.89428711; 1660,9377090.45410156; 1665,9376747.89428711; 1670,9375988.0065918; 1675,9381889.34326172; 1680,9376747.89428711; 1685,9376747.89428711; 1690,9375988.0065918; 1695,9376747.89428711; 1700,9376747.89428711; 1705,9381889.34326172; 1710,9383615.87524414; 1715,9386199.95117188; 1720,9386199.95117188; 1725,9389080.81054688; 1730,9393152.6184082; 1735,9393141.17431641; 1740,9393152.6184082; 1745,9396826.171875; 1750,9403797.1496582; 1755,
        9412006.37817383; 1760,9408965.30151367; 1765,9412006.37817383; 1770,9417723.84643555; 1775,9428421.78344727; 1780,9428421.78344727; 1785,9428421.78344727; 1790,9430499.26757813; 1795,9430810.546875; 1800,9430499.26757813; 1805,9428421.78344727; 1810,9433654.0222168; 1815,9438536.8347168; 1820,9430810.546875; 1825,9430499.26757813; 1830,9428387.45117188; 1835,9432869.72045898; 1840,9433906.55517578; 1845,9430810.546875; 1850,9427499.38964844; 1855,9428365.32592773; 1860,9427499.38964844; 1865,9427499.38964844; 1870,9428829.95605469; 1875,9432869.72045898; 1880,9432321.92993164; 1885,9432321.92993164; 1890,9432321.92993164; 1895,9427056.12182617; 1900,9432321.92993164; 1905,9433906.55517578; 1910,9428829.95605469; 1915,9434042.35839844; 1920,9436840.8203125; 1925,9441358.18481445; 1930,9450012.20703125; 1935,9452058.41064453; 1940,9457897.94921875; 1945,9459387.20703125; 1950,9459387.20703125; 1955,9462117.00439453; 1960,9457978.82080078; 1965,9457978.82080078; 1970,
        9462117.00439453; 1975,9459387.20703125; 1980,9456604.00390625; 1985,9458466.33911133; 1990,9456604.00390625; 1995,9456604.00390625; 2000,9453302.00195313; 2005,9453242.49267578; 2010,9453302.00195313; 2015,9448117.82836914; 2020,9453242.49267578; 2025,9448117.82836914; 2030,9453242.49267578; 2035,9457559.20410156; 2040,9458042.90771484; 2045,9457559.20410156; 2050,9449407.95898438; 2055,9448031.61621094; 2060,9445743.56079102; 2065,9444584.65576172; 2070,9443761.4440918; 2075,9440013.88549805; 2080,9435977.93579102; 2085,9434910.58349609; 2090,9428912.35351563; 2095,9427667.99926758; 2100,9426771.54541016; 2105,9425094.60449219; 2110,9422644.04296875; 2115,9419409.1796875; 2120,9416161.34643555; 2125,9412566.37573242; 2130,9412919.61669922; 2135,9416161.34643555; 2140,9413331.60400391; 2145,9413331.60400391; 2150,9413331.60400391; 2155,9412919.61669922; 2160,9413331.60400391; 2165,9412566.37573242; 2170,9411000.06103516; 2175,9410547.63793945; 2180,9411000.06103516; 2185,
        9411000.06103516; 2190,9405801.39160156; 2195,9411000.06103516; 2200,9412117.76733398; 2205,9413572.69287109; 2210,9412117.76733398; 2215,9411000.06103516; 2220,9413572.69287109; 2225,9413572.69287109; 2230,9414333.34350586; 2235,9411000.06103516; 2240,9410246.27685547; 2245,9404616.54663086; 2250,9402292.63305664; 2255,9398186.49291992; 2260,9396381.37817383; 2265,9394428.25317383; 2270,9395514.67895508; 2275,9387797.54638672; 2280,9380763.24462891; 2285,9382061.00463867; 2290,9388991.54663086; 2295,9387797.54638672; 2300,9385005.18798828; 2305,9383403.77807617; 2310,9383403.77807617; 2315,9385005.18798828; 2320,9387797.54638672; 2325,9388733.6730957; 2330,9388991.54663086; 2335,9396457.67211914; 2340,9397682.18994141; 2345,9399996.94824219; 2350,9404738.61694336; 2355,9414878.08227539; 2360,9418905.63964844; 2365,9425152.58789063; 2370,9428158.56933594; 2375,9430208.58764648; 2380,9430208.58764648; 2385,9430208.58764648; 2390,9434778.5949707; 2395,9434778.5949707; 2400,
        9435316.46728516; 2405,9434778.5949707; 2410,9430332.18383789; 2415,9430332.18383789; 2420,9432604.2175293; 2425,9427703.85742188; 2430,9425228.88183594; 2435,9415499.87792969; 2440,9415499.87792969; 2445,9408102.41699219; 2450,9408102.41699219; 2455,9417200.4699707; 2460,9421250.15258789; 2465,9421250.15258789; 2470,9415499.87792969; 2475,9408102.41699219; 2480,9415499.87792969; 2485,9417200.4699707; 2490,9422144.31762695; 2495,9422144.31762695; 2500,9421250.15258789; 2505,9418628.69262695; 2510,9417200.4699707; 2515,9411392.97485352; 2520,9415951.53808594; 2525,9415951.53808594; 2530,9413317.1081543; 2535,9413714.59960938; 2540,9411392.97485352; 2545,9410694.88525391; 2550,9410694.88525391; 2555,9410694.88525391; 2560,9407038.11645508; 2565,9400034.33227539; 2570,9400034.33227539; 2575,9400034.33227539; 2580,9400937.65258789; 2585,9395468.90258789; 2590,9392710.11352539; 2595,9390897.36938477; 2600,9389473.72436523; 2605,9389473.72436523; 2610,9384292.60253906; 2615,
        9383066.55883789; 2620,9384011.84082031; 2625,9385308.07495117; 2630,9384011.84082031; 2635,9383066.55883789; 2640,9383066.55883789; 2645,9379241.18041992; 2650,9374445.34301758; 2655,9368015.28930664; 2660,9369495.3918457; 2665,9368015.28930664; 2670,9368015.28930664; 2675,9366575.62255859; 2680,9366575.62255859; 2685,9369873.80981445; 2690,9370619.96459961; 2695,9369873.80981445; 2700,9369495.3918457; 2705,9372129.05883789; 2710,9377978.515625; 2715,9382373.046875; 2720,9385337.82958984; 2725,9392064.66674805; 2730,9392697.14355469; 2735,9399801.63574219; 2740,9399976.34887695; 2745,9398763.27514648; 2750,9398273.46801758; 2755,9399976.34887695; 2760,9408197.78442383; 2765,9410289.00146484; 2770,9411476.13525391; 2775,9413933.56323242; 2780,9411476.13525391; 2785,9411476.13525391; 2790,9412382.50732422; 2795,9412382.50732422; 2800,9412382.50732422; 2805,9412382.50732422; 2810,9405219.26879883; 2815,9403472.90039063; 2820,9408274.84130859; 2825,9413933.56323242; 2830,
        9413933.56323242; 2835,9411476.13525391; 2840,9407907.10449219; 2845,9401434.32617188; 2850,9400498.96240234; 2855,9401434.32617188; 2860,9407907.10449219; 2865,9405219.26879883; 2870,9407924.65209961; 2875,9411430.35888672; 2880,9413926.69677734; 2885,9420532.2265625; 2890,9420532.2265625; 2895,9418586.73095703; 2900,9417572.78442383; 2905,9418359.375; 2910,9418359.375; 2915,9420526.12304688; 2920,9420532.2265625; 2925,9418845.36743164; 2930,9418359.375; 2935,9412263.48876953; 2940,9410432.43408203; 2945,9410432.43408203; 2950,9404998.77929688; 2955,9406232.45239258; 2960,9404125.9765625; 2965,9401977.5390625; 2970,9404125.9765625; 2975,9402923.58398438; 2980,9393971.25244141; 2985,9389596.55761719; 2990,9386696.62475586; 2995,9388304.13818359; 3000,9385697.17407227; 3005,9384822.08251953; 3010,9379758.45336914; 3015,9379748.53515625; 3020,9377925.10986328; 3025,9379417.41943359; 3030,9369574.73754883; 3035,9369574.73754883; 3040,9366549.68261719; 3045,9363901.51977539; 3050,
        9354919.43359375; 3055,9353852.84423828; 3060,9360356.14013672; 3065,9357778.16772461; 3070,9348556.51855469; 3075,9348271.17919922; 3080,9348136.13891602; 3085,9348452.75878906; 3090,9348271.17919922; 3095,9338732.91015625; 3100,9334952.54516602; 3105,9334952.54516602; 3110,9333292.38891602; 3115,9333000.18310547; 3120,9328271.484375; 3125,9328271.484375; 3130,9326744.07958984; 3135,9318596.64916992; 3140,9313032.53173828; 3145,9310682.67822266; 3150,9309440.61279297; 3155,9307453.15551758; 3160,9304917.14477539; 3165,9304917.14477539; 3170,9307398.22387695; 3175,9307453.15551758; 3180,9307453.15551758; 3185,9309284.21020508; 3190,9314800.26245117; 3195,9316323.08959961; 3200,9316323.08959961; 3205,9322211.45629883; 3210,9328814.69726563; 3215,9337464.90478516; 3220,9343866.72973633; 3225,9347834.77783203; 3230,9351911.92626953; 3235,9354396.05712891; 3240,9353473.66333008; 3245,9353700.25634766; 3250,9355110.93139648; 3255,9355110.93139648; 3260,9360573.57788086; 3265,
        9355288.69628906; 3270,9361499.0234375; 3275,9362678.52783203; 3280,9362689.97192383; 3285,9362689.97192383; 3290,9362678.52783203; 3295,9361499.0234375; 3300,9361499.0234375; 3305,9361846.16088867; 3310,9361499.0234375; 3315,9364607.23876953; 3320,9362678.52783203; 3325,9361927.0324707; 3330,9361499.0234375; 3335,9359037.78076172; 3340,9353999.32861328; 3345,9351916.50390625; 3350,9351916.50390625; 3355,9340501.40380859; 3360,9340501.40380859; 3365,9340150.45166016; 3370,9348634.33837891; 3375,9348634.33837891; 3380,9353121.94824219; 3385,9353121.94824219; 3390,9353121.94824219; 3395,9359978.48510742; 3400,9356812.28637695; 3405,9359988.40332031; 3410,9359988.40332031; 3415,9356812.28637695; 3420,9359978.48510742; 3425,9356812.28637695; 3430,9355406.9519043; 3435,9356812.28637695; 3440,9356812.28637695; 3445,9353840.63720703; 3450,9353999.32861328; 3455,9353636.16943359; 3460,9353095.24536133; 3465,9347999.57275391; 3470,9342026.51977539; 3475,9340029.90722656; 3480,
        9342026.51977539; 3485,9340467.0715332; 3490,9342026.51977539; 3495,9339302.82592773; 3500,9337952.4230957; 3505,9339302.82592773; 3510,9340243.53027344; 3515,9339302.82592773; 3520,9343380.73730469; 3525,9345095.06225586; 3530,9340710.44921875; 3535,9343380.73730469; 3540,9347999.57275391; 3545,9347999.57275391; 3550,9347999.57275391; 3555,9340710.44921875; 3560,9343361.66381836; 3565,9340710.44921875; 3570,9342218.78051758; 3575,9340522.00317383; 3580,9342980.95703125; 3585,9342599.48730469; 3590,9342599.48730469; 3595,9334419.25048828; 3600,9327758.7890625; 3605,9329622.65014648; 3610,9329622.65014648; 3615,9327279.66308594; 3620,9327758.7890625; 3625,9323228.45458984; 3630,9327279.66308594; 3635,9322807.31201172; 3640,9323140.71655273; 3645,9323193.359375; 3650,9324482.72705078; 3655,9323843.38378906; 3660,9324482.72705078; 3665,9325617.98095703; 3670,9325617.98095703; 3675,9328965.75927734; 3680,9332864.37988281; 3685,9339521.78955078; 3690,9341045.37963867; 3695,
        9341045.37963867; 3700,9345533.75244141; 3705,9338736.72485352; 3710,9340507.50732422; 3715,9338736.72485352; 3720,9339521.78955078; 3725,9336637.11547852; 3730,9314470.67260742; 3735,9310565.18554688; 3740,9310565.18554688; 3745,9312387.84790039; 3750,9326176.45263672; 3755,9312387.84790039; 3760,9310745.23925781; 3765,9309886.93237305; 3770,9310398.10180664; 3775,9310090.63720703; 3780,9311894.98901367; 3785,9314762.87841797; 3790,9317999.26757813; 3795,9317999.26757813; 3800,9317999.26757813; 3805,9323594.66552734; 3810,9327344.51293945; 3815,9330459.59472656; 3820,9330459.59472656; 3825,9329988.09814453; 3830,9330459.59472656; 3835,9337582.39746094; 3840,9337915.0390625; 3845,9339332.58056641; 3850,9341078.18603516; 3855,9341584.01489258; 3860,9339938.35449219; 3865,9341078.18603516; 3870,9339938.35449219; 3875,9341078.18603516; 3880,9335050.96435547; 3885,9331417.08374023; 3890,9331417.08374023; 3895,9331127.9296875; 3900,9330622.86376953; 3905,9330473.32763672; 3910,
        9326048.27880859; 3915,9330622.86376953; 3920,9327460.47973633; 3925,9327397.91870117; 3930,9327244.56787109; 3935,9327397.91870117; 3940,9327397.91870117; 3945,9327460.47973633; 3950,9327397.91870117; 3955,9327397.91870117; 3960,9325524.90234375; 3965,9325212.86010742; 3970,9325524.90234375; 3975,9325524.90234375; 3980,9324317.16918945; 3985,9325892.63916016; 3990,9323255.1574707; 3995,9323204.8034668; 4000,9321957.39746094; 4005,9322199.24926758; 4010,9318347.16796875; 4015,9313719.17724609; 4020,9313719.17724609; 4025,9312664.79492188; 4030,9313719.17724609; 4035,9315779.11376953; 4040,9316517.63916016; 4045,9316517.63916016; 4050,9322382.35473633; 4055,9318347.16796875; 4060,9313414.00146484; 4065,9320653.53393555; 4070,9324111.17553711; 4075,9327568.81713867; 4080,9331025.69580078; 4085,9334483.33740234; 4090,9338999.93896484; 4095,9338999.93896484; 4100,9352076.72119141; 4105,9352076.72119141; 4110,9354050.44555664; 4115,9366001.12915039; 4120,9369873.046875; 4125,
        9374275.20751953; 4130,9374842.0715332; 4135,9375155.63964844; 4140,9383384.70458984; 4145,9388581.08520508; 4150,9389137.26806641; 4155,9393384.55200195; 4160,9394277.19116211; 4165,9393384.55200195; 4170,9394328.30810547; 4175,9398155.9753418; 4180,9398336.79199219; 4185,9402925.87280273; 4190,9403289.79492188; 4195,9403647.61352539; 4200,9406390.38085938; 4205,9412070.46508789; 4210,9414754.48608398; 4215,9414086.9140625; 4220,9414754.48608398; 4225,9413031.76879883; 4230,9412960.05249023; 4235,9412847.13745117; 4240,9412847.13745117; 4245,9414754.48608398; 4250,9421345.52001953; 4255,9424091.33911133; 4260,9417839.05029297; 4265,9417839.05029297; 4270,9417984.00878906; 4275,9417839.05029297; 4280,9415233.61206055; 4285,9411901.0925293; 4290,9412847.13745117; 4295,9411901.0925293; 4300,9413677.21557617; 4305,9413677.21557617; 4310,9415045.16601563; 4315,9420909.11865234; 4320,9422156.5246582; 4325,9413677.21557617; 4330,9407519.53125; 4335,9408676.91040039; 4340,
        9407519.53125; 4345,9405525.97045898; 4350,9407445.52612305; 4355,9407881.92749023; 4360,9416129.30297852; 4365,9420376.58691406; 4370,9420376.58691406; 4375,9420376.58691406; 4380,9424890.8996582; 4385,9424890.8996582; 4390,9420670.31860352; 4395,9420376.58691406; 4400,9420376.58691406; 4405,9420376.58691406; 4410,9419916.53442383; 4415,9419916.53442383; 4420,9416129.30297852; 4425,9410517.12036133; 4430,9402521.51489258; 4435,9400630.95092773; 4440,9390075.68359375; 4445,9386274.71923828; 4450,9386274.71923828; 4455,9385329.43725586; 4460,9382783.50830078; 4465,9382783.50830078; 4470,9382783.50830078; 4475,9380001.83105469; 4480,9382987.97607422; 4485,9383499.14550781; 4490,9383999.63378906; 4495,9383999.63378906; 4500,9383999.63378906; 4505,9383995.8190918; 4510,9383999.63378906; 4515,9384277.34375; 4520,9385329.43725586; 4525,9387854.7668457; 4530,9391129.30297852; 4535,9395451.35498047; 4540,9391129.30297852; 4545,9395451.35498047; 4550,9401434.32617188; 4555,
        9401434.32617188; 4560,9397408.29467773; 4565,9390925.59814453; 4570,9390925.59814453; 4575,9397682.18994141; 4580,9400704.95605469; 4585,9400408.93554688; 4590,9403752.89916992; 4595,9403752.89916992; 4600,9403752.89916992; 4605,9405663.29956055; 4610,9405339.05029297; 4615,9409840.39306641; 4620,9412422.94311523; 4625,9412036.89575195; 4630,9410266.8762207; 4635,9412422.94311523; 4640,9417919.15893555; 4645,9423664.85595703; 4650,9417919.15893555; 4655,9421376.03759766; 4660,9419253.54003906; 4665,9419253.54003906; 4670,9424096.6796875; 4675,9424096.6796875; 4680,9423131.5612793; 4685,9426734.16137695; 4690,9424096.6796875; 4695,9421939.08691406; 4700,9426734.16137695; 4705,9428999.32861328; 4710,9430122.37548828; 4715,9428999.32861328; 4720,9424096.6796875; 4725,9427127.83813477; 4730,9427127.83813477; 4735,9430122.37548828; 4740,9430122.37548828; 4745,9427540.58837891; 4750,9431152.34375; 4755,9427127.83813477; 4760,9426433.56323242; 4765,9418599.70092773; 4770,
        9414847.56469727; 4775,9410198.97460938; 4780,9407261.65771484; 4785,9404566.95556641; 4790,9401016.23535156; 4795,9397875.21362305; 4800,9391678.61938477; 4805,9386090.08789063; 4810,9381417.08374023; 4815,9375160.98022461; 4820,9375206.7565918; 4825,9371097.56469727; 4830,9356597.90039063; 4835,9355351.25732422; 4840,9355351.25732422; 4845,9353330.99365234; 4850,9351081.84814453; 4855,9346544.6472168; 4860,9345549.01123047; 4865,9345407.86743164; 4870,9344088.74511719; 4875,9344088.74511719; 4880,9344075.77514648; 4885,9345549.01123047; 4890,9347985.0769043; 4895,9349895.47729492; 4900,9349895.47729492; 4905,9354834.74731445; 4910,9359634.39941406; 4915,9359916.68701172; 4920,9361702.72827148; 4925,9367763.51928711; 4930,9371167.75512695; 4935,9376198.57788086; 4940,9376520.53833008; 4945,9378108.21533203; 4950,9378754.42504883; 4955,9378200.53100586; 4960,9378754.42504883; 4965,9378108.21533203; 4970,9379270.93505859; 4975,9379270.93505859; 4980,9378754.42504883; 4985,
        9376520.53833008; 4990,9377286.52954102; 4995,9378754.42504883; 5000,9377286.52954102; 5005,9377286.52954102; 5010,9375387.57324219; 5015,9376152.03857422; 5020,9375534.82055664; 5025,9373909.75952148; 5030,9375387.57324219; 5035,9373909.75952148; 5040,9376367.1875; 5045,9375387.57324219; 5050,9376367.1875; 5055,9377998.35205078; 5060,9377998.35205078; 5065,9377998.35205078; 5070,9377998.35205078; 5075,9377998.35205078; 5080,9377998.35205078; 5085,9379090.88134766; 5090,9377998.35205078; 5095,9379090.88134766; 5100,9379093.93310547; 5105,9380197.90649414; 5110,9382588.95874023; 5115,9376826.47705078; 5120,9374710.08300781; 5125,9374349.21264648; 5130,9368593.59741211; 5135,9365952.30102539; 5140,9363412.47558594; 5145,9356134.79614258; 5150,9349978.63769531; 5155,9347999.57275391; 5160,9347999.57275391; 5165,9349978.63769531; 5170,9350163.26904297; 5175,9350818.6340332; 5180,9349978.63769531; 5185,9347999.57275391; 5190,9347999.57275391; 5195,9346430.20629883; 5200,
        9346430.20629883; 5205,9355567.16918945; 5210,9360137.93945313; 5215,9360137.93945313; 5220,9366238.40332031; 5225,9369075.01220703; 5230,9370499.42016602; 5235,9370664.97802734; 5240,9377033.23364258; 5245,9377033.23364258; 5250,9374642.18139648; 5255,9370664.97802734; 5260,9375004.57763672; 5265,9370499.42016602; 5270,9375751.49536133; 5275,9375004.57763672; 5280,9375004.57763672; 5285,9370499.42016602; 5290,9375004.57763672; 5295,9370499.42016602; 5300,9369032.28759766; 5305,9367722.32055664; 5310,9362629.69970703; 5315,9361423.49243164; 5320,9362629.69970703; 5325,9364208.984375; 5330,9361423.49243164; 5335,9361311.34033203; 5340,9362031.55517578; 5345,9361423.49243164; 5350,9358937.07275391; 5355,9353066.25366211; 5360,9350475.3112793; 5365,9349933.62426758; 5370,9349005.88989258; 5375,9348085.02197266; 5380,9345500.94604492; 5385,9347501.37329102; 5390,9341384.88769531; 5395,9335671.99707031; 5400,9326079.55932617; 5405,9325424.19433594; 5410,9317058.56323242; 5415,
        9310977.93579102; 5420,9306121.82617188; 5425,9302118.68286133; 5430,9307818.60351563; 5435,9307818.60351563; 5440,9305792.23632813; 5445,9297303.77197266; 5450,9297671.50878906; 5455,9297303.77197266; 5460,9297671.50878906; 5465,9297671.50878906; 5470,9301103.97338867; 5475,9302831.26831055; 5480,9305912.78076172; 5485,9302831.26831055; 5490,9301103.97338867; 5495,9305912.78076172; 5500,9306645.20263672; 5505,9306502.53295898; 5510,9305912.78076172; 5515,9306502.53295898; 5520,9307965.08789063; 5525,9310530.85327148; 5530,9321458.43505859; 5535,9317925.26245117; 5540,9321458.43505859; 5545,9324764.25170898; 5550,9324172.21069336; 5555,9324172.21069336; 5560,9325499.7253418; 5565,9327571.86889648; 5570,9331450.65307617; 5575,9334351.34887695; 5580,9331450.65307617; 5585,9333199.31030273; 5590,9333199.31030273; 5595,9331450.65307617; 5600,9334351.34887695; 5605,9334351.34887695; 5610,9340333.55712891; 5615,9341069.03076172; 5620,9340510.55908203; 5625,9340510.55908203; 5630,
        9343197.63183594; 5635,9343197.63183594; 5640,9346276.85546875; 5645,9343208.31298828; 5650,9343208.31298828; 5655,9348329.16259766; 5660,9354216.76635742; 5665,9355779.26635742; 5670,9365789.03198242; 5675,9368746.18530273; 5680,9370241.54663086; 5685,9365789.03198242; 5690,9368746.18530273; 5695,9377151.48925781; 5700,9377151.48925781; 5705,9381214.90478516; 5710,9383319.09179688; 5715,9383319.09179688; 5720,9386112.97607422; 5725,9383476.25732422; 5730,9383319.09179688; 5735,9382705.68847656; 5740,9381214.90478516; 5745,9376390.83862305; 5750,9374210.35766602; 5755,9373559.5703125; 5760,9373392.48657227; 5765,9369122.31445313; 5770,9366645.05004883; 5775,9363969.42138672; 5780,9354315.18554688; 5785,9350900.26855469; 5790,9352033.23364258; 5795,9350900.26855469; 5800,9353202.05688477; 5805,9352033.23364258; 5810,9352033.23364258; 5815,9354315.18554688; 5820,9350900.26855469; 5825,9350798.03466797; 5830,9354553.9855957; 5835,9355954.74243164; 5840,9355954.74243164; 5845,
        9354553.9855957; 5850,9353402.70996094; 5855,9353402.70996094; 5860,9354553.9855957; 5865,9353402.70996094; 5870,9354553.9855957; 5875,9353402.70996094; 5880,9354888.15307617; 5885,9358889.77050781; 5890,9350508.88061523; 5895,9351428.22265625; 5900,9354553.9855957; 5905,9354888.15307617; 5910,9358889.77050781; 5915,9354888.15307617; 5920,9359259.79614258; 5925,9359259.79614258; 5930,9361106.10961914; 5935,9360456.08520508; 5940,9359259.79614258; 5945,9356102.75268555; 5950,9350508.88061523; 5955,9350508.88061523; 5960,9350244.140625; 5965,9354342.65136719; 5970,9356667.32788086; 5975,9356102.75268555; 5980,9349601.74560547; 5985,9344454.95605469; 5990,9340108.48999023; 5995,9340108.48999023; 6000,9347231.29272461; 6005,9347231.29272461; 6010,9354342.65136719; 6015,9355862.42675781; 6020,9355862.42675781; 6025,9353403.47290039; 6030,9354297.63793945; 6035,9355191.80297852; 6040,9355862.42675781; 6045,9354297.63793945; 6050,9353403.47290039; 6055,9352508.54492188; 6060,
        9352000.42724609; 6065,9351614.37988281; 6070,9351614.37988281; 6075,9352000.42724609; 6080,9350642.39501953; 6085,9351614.37988281; 6090,9349499.51171875; 6095,9352508.54492188; 6100,9348780.82275391; 6105,9351937.86621094; 6110,9347020.72143555; 6115,9348780.82275391; 6120,9351937.86621094; 6125,9349208.83178711; 6130,9354550.93383789; 6135,9359280.39550781; 6140,9365016.93725586; 6145,9369161.22436523; 6150,9369161.22436523; 6155,9375158.69140625; 6160,9378427.12402344; 6165,9380999.75585938; 6170,9380999.75585938; 6175,9381147.76611328; 6180,9388037.109375; 6185,9393140.41137695; 6190,9395867.15698242; 6195,9395867.15698242; 6200,9395867.15698242; 6205,9398780.82275391; 6210,9398780.82275391; 6215,9396296.69189453; 6220,9397021.484375; 6225,9396296.69189453; 6230,9395026.39770508; 6235,9388172.91259766; 6240,9378874.20654297; 6245,9372255.70678711; 6250,9367484.28344727; 6255,9360475.15869141; 6260,9360108.18481445; 6265,9354016.11328125; 6270,9354016.11328125; 6275,
        9356473.54125977; 6280,9350855.25512695; 6285,9349499.51171875; 6290,9344398.49853516; 6295,9342574.31030273; 6300,9344398.49853516; 6305,9341229.24804688; 6310,9341229.24804688; 6315,9344398.49853516; 6320,9346222.68676758; 6325,9347135.16235352; 6330,9349580.38330078; 6335,9349580.38330078; 6340,9352826.69067383; 6345,9351994.32373047; 6350,9351097.86987305; 6355,9354035.94970703; 6360,9359222.41210938; 6365,9362436.67602539; 6370,9366059.11254883; 6375,9369446.5637207; 6380,9374743.65234375; 6385,9376731.10961914; 6390,9374743.65234375; 6395,9374743.65234375; 6400,9376746.3684082; 6405,9377037.8112793; 6410,9383117.67578125; 6415,9381520.08056641; 6420,9379524.99389648; 6425,9383290.10009766; 6430,9381520.08056641; 6435,9379524.99389648; 6440,9383290.10009766; 6445,9384046.1730957; 6450,9389650.72631836; 6455,9396132.65991211; 6460,9396132.65991211; 6465,9397324.37133789; 6470,9404328.91845703; 6475,9401667.78564453; 6480,9397682.18994141; 6485,9396633.14819336; 6490,
        9399008.94165039; 6495,9404429.62646484; 6500,9404429.62646484; 6505,9407192.23022461; 6510,9404429.62646484; 6515,9406926.72729492; 6520,9404659.27124023; 6525,9404659.27124023; 6530,9403646.08764648; 6535,9404659.27124023; 6540,9403646.08764648; 6545,9403646.08764648; 6550,9404659.27124023; 6555,9407192.23022461; 6560,9416877.74658203; 6565,9418225.8605957; 6570,9412872.31445313; 6575,9407028.19824219; 6580,9407028.19824219; 6585,9418225.8605957; 6590,9418225.8605957; 6595,9418436.43188477; 6600,9419528.19824219; 6605,9423323.82202148; 6610,9423831.93969727; 6615,9423831.93969727; 6620,9423323.82202148; 6625,9422543.33496094; 6630,9418225.8605957; 6635,9409638.21411133; 6640,9401449.58496094; 6645,9401449.58496094; 6650,9400142.66967773; 6655,9396469.11621094; 6660,9392999.26757813; 6665,9386154.17480469; 6670,9381113.43383789; 6675,9369853.21044922; 6680,9368867.49267578; 6685,9367848.20556641; 6690,9368356.32324219; 6695,9367515.56396484; 6700,9367287.44506836; 6705,
        9367287.44506836; 6710,9366777.80151367; 6715,9367287.44506836; 6720,9366777.80151367; 6725,9366777.80151367; 6730,9368864.44091797; 6735,9369608.30688477; 6740,9370786.28540039; 6745,9372159.57641602; 6750,9377041.62597656; 6755,9385321.80786133; 6760,9388110.3515625; 6765,9388117.21801758; 6770,9389589.69116211; 6775,9389589.69116211; 6780,9390421.29516602; 6785,9388117.21801758; 6790,9385321.80786133; 6795,9386965.94238281; 6800,9386965.94238281; 6805,9382859.80224609; 6810,9376616.66870117; 6815,9375373.84033203; 6820,9374568.93920898; 6825,9373064.42260742; 6830,9373117.06542969; 6835,9371998.59619141; 6840,9369277.95410156; 6845,9363386.53564453; 6850,9355333.7097168; 6855,9354354.09545898; 6860,9355333.7097168; 6865,9364498.90136719; 6870,9364474.48730469; 6875,9364498.90136719; 6880,9364498.90136719; 6885,9370676.42211914; 6890,9373538.20800781; 6895,9374621.58203125; 6900,9377464.29443359; 6905,9378623.96240234; 6910,9385294.34204102; 6915,9386012.26806641; 6920,
        9390148.1628418; 6925,9392270.66040039; 6930,9396258.54492188; 6935,9398716.73583984; 6940,9398791.50390625; 6945,9402359.00878906; 6950,9403152.46582031; 6955,9403445.43457031; 6960,9407958.22143555; 6965,9403445.43457031; 6970,9403152.46582031; 6975,9409841.91894531; 6980,9404974.36523438; 6985,9403152.46582031; 6990,9406349.18212891; 6995,9402644.34814453; 7000,9406349.18212891; 7005,9410851.2878418; 7010,9406018.06640625; 7015,9406349.18212891; 7020,9406349.18212891; 7025,9406349.18212891; 7030,9404974.36523438; 7035,9404974.36523438; 7040,9406349.18212891; 7045,9409365.84472656; 7050,9401815.79589844; 7055,9404574.58496094; 7060,9404574.58496094; 7065,9406018.06640625; 7070,9406018.06640625; 7075,9404574.58496094; 7080,9402650.45166016; 7085,9402872.46704102; 7090,9402650.45166016; 7095,9401815.79589844; 7100,9402650.45166016; 7105,9405397.79663086; 7110,9405710.60180664; 7115,9405710.60180664; 7120,9405207.82470703; 7125,9410652.92358398; 7130,9414567.56591797; 7135,
        9414567.56591797; 7140,9410477.44750977; 7145,9405397.79663086; 7150,9405644.98901367; 7155,9405397.79663086; 7160,9403262.32910156; 7165,9401326.75170898; 7170,9393856.04858398; 7175,9386750.03051758; 7180,9385890.19775391; 7185,9378990.9362793; 7190,9378846.74072266; 7195,9378990.9362793; 7200,9375951.38549805; 7205,9373236.08398438; 7210,9371499.63378906; 7215,9368518.8293457; 7220,9369022.36938477; 7225,9362932.58666992; 7230,9360616.30249023; 7235,9360241.69921875; 7240,9360298.91967773; 7245,9360298.91967773; 7250,9353096.00830078; 7255,9350299.83520508; 7260,9353004.45556641; 7265,9357189.1784668; 7270,9360298.91967773; 7275,9360298.91967773; 7280,9363971.71020508; 7285,9364607.23876953; 7290,9369339.75219727; 7295,9369071.96044922; 7300,9371357.72705078; 7305,9375035.09521484; 7310,9374050.90332031; 7315,9371755.98144531; 7320,9375035.09521484; 7325,9379191.58935547; 7330,9378750.61035156; 7335,9383274.07836914; 7340,9378364.56298828; 7345,9377471.16088867; 7350,
        9378750.61035156; 7355,9382339.47753906; 7360,9382339.47753906; 7365,9378750.61035156; 7370,9386433.41064453; 7375,9390803.52783203; 7380,9387923.43139648; 7385,9396482.84912109; 7390,9397779.08325195; 7395,9396482.84912109; 7400,9391316.98608398; 7405,9391316.98608398; 7410,9390803.52783203; 7415,9396480.56030273; 7420,9396837.6159668; 7425,9391316.98608398; 7430,9387923.43139648; 7435,9387923.43139648; 7440,9387923.43139648; 7445,9385499.57275391; 7450,9385499.57275391; 7455,9385499.57275391; 7460,9385499.57275391; 7465,9384971.61865234; 7470,9384960.9375; 7475,9379763.03100586; 7480,9381608.58154297; 7485,9380332.94677734; 7490,9375390.625; 7495,9380332.94677734; 7500,9377410.88867188; 7505,9378708.64868164; 7510,9375390.625; 7515,9375390.625; 7520,9370737.45727539; 7525,9374334.71679688; 7530,9368400.57373047; 7535,9366699.98168945; 7540,9361576.84326172; 7545,9356707.76367188; 7550,9362226.10473633; 7555,9366036.98730469; 7560,9366269.68383789; 7565,9366269.68383789; 7570,
        9364694.97680664; 7575,9356076.81274414; 7580,9356707.76367188; 7585,9355010.22338867; 7590,9354668.42651367; 7595,9356076.81274414; 7600,9356076.81274414; 7605,9356076.81274414; 7610,9352143.85986328; 7615,9357607.26928711; 7620,9367110.44311523; 7625,9367110.44311523; 7630,9358671.56982422; 7635,9355610.65673828; 7640,9349090.57617188; 7645,9338137.81738281; 7650,9341986.08398438; 7655,9332835.38818359; 7660,9341986.08398438; 7665,9346391.29638672; 7670,9339945.22094727; 7675,9334617.61474609; 7680,9337841.796875; 7685,9339208.984375; 7690,9337841.796875; 7695,9338138.58032227; 7700,9339208.984375; 7705,9339945.22094727; 7710,9341484.83276367; 7715,9346391.29638672; 7720,9352499.38964844; 7725,9352499.38964844; 7730,9356858.82568359; 7735,9352499.38964844; 7740,9352499.38964844; 7745,9356935.11962891; 7750,9358843.99414063; 7755,9364498.90136719; 7760,9367713.92822266; 7765,9368544.00634766; 7770,9374465.17944336; 7775,9373645.01953125; 7780,9373645.01953125; 7785,
        9380775.45166016; 7790,9384194.94628906; 7795,9384370.42236328; 7800,9384370.42236328; 7805,9384194.94628906; 7810,9389531.70776367; 7815,9398707.58056641; 7820,9405847.16796875; 7825,9406700.13427734; 7830,9407716.36962891; 7835,9407813.26293945; 7840,9415374.75585938; 7845,9421460.72387695; 7850,9424208.06884766; 7855,9426972.96142578; 7860,9426972.96142578; 7865,9426972.96142578; 7870,9426210.78491211; 7875,9417599.48730469; 7880,9424210.35766602; 7885,9423560.33325195; 7890,9417599.48730469; 7895,9405942.53540039; 7900,9401312.25585938; 7905,9399368.28613281; 7910,9390225.98266602; 7915,9380736.54174805; 7920,9373384.09423828; 7925,9362838.74511719; 7930,9356035.61401367; 7935,9356035.61401367; 7940,9348120.88012695; 7945,9340270.2331543; 7950,9338690.94848633; 7955,9335372.16186523; 7960,9335372.16186523; 7965,9335372.16186523; 7970,9335372.16186523; 7975,9333043.6706543; 7980,9335372.16186523; 7985,9335409.54589844; 7990,9340947.72338867; 7995,9340712.73803711; 8000,
        9335409.54589844; 8005,9336788.94042969; 8010,9336788.94042969; 8015,9345511.62719727; 8020,9348724.36523438; 8025,9351149.74975586; 8030,9351725.00610352; 8035,9354375.45776367; 8040,9357280.73120117; 8045,9359365.08178711; 8050,9361499.0234375; 8055,9376866.9128418; 8060,9380915.06958008; 8065,9396152.49633789; 8070,9401647.94921875; 8075,9405584.71679688; 8080,9408058.16650391; 8085,9409602.35595703; 8090,9410772.70507813; 8095,9412233.73413086; 8100,9412500; 8105,9416547.39379883; 8110,9419876.09863281; 8115,9420064.54467773; 8120,9420530.70068359; 8125,9421807.86132813; 8130,9421807.86132813; 8135,9424196.62475586; 8140,9424994.65942383; 8145,9426559.44824219; 8150,9427448.27270508; 8155,9431329.34570313; 8160,9431678.77197266; 8165,9431329.34570313; 8170,9428944.39697266; 8175,9426470.18432617; 8180,9426154.32739258; 8185,9426559.44824219; 8190,9426559.44824219; 8195,9426559.44824219; 8200,9420198.05908203; 8205,9419460.29663086; 8210,9417562.86621094; 8215,
        9414347.07641602; 8220,9412500; 8225,9412500; 8230,9412500; 8235,9412500; 8240,9412500; 8245,9412500; 8250,9412500; 8255,9417519.37866211; 8260,9412500; 8265,9417519.37866211; 8270,9418902.58789063; 8275,9418925.47607422; 8280,9423107.1472168; 8285,9419927.97851563; 8290,9418925.47607422; 8295,9423107.1472168; 8300,9423107.1472168; 8305,9423606.10961914; 8310,9428005.21850586; 8315,9431999.20654297; 8320,9431999.20654297; 8325,9431999.20654297; 8330,9437105.56030273; 8335,9440542.60253906; 8340,9440995.78857422; 8345,9440542.60253906; 8350,9443972.01538086; 8355,9443972.01538086; 8360,9441083.52661133; 8365,9446001.43432617; 8370,9451451.11083984; 8375,9444424.43847656; 8380,9444424.43847656; 8385,9451451.11083984; 8390,9450000; 8395,9447528.07617188; 8400,9443116.76025391; 8405,9441083.52661133; 8410,9443116.76025391; 8415,9441083.52661133; 8420,9429658.50830078; 8425,9428290.55786133; 8430,9420793.91479492; 8435,9408416.74804688; 8440,9400093.84155273; 8445,9400093.84155273;
        8450,9400277.70996094; 8455,9400277.70996094; 8460,9398089.59960938; 8465,9398089.59960938; 8470,9404853.82080078; 8475,9405958.55712891; 8480,9405761.71875; 8485,9398089.59960938; 8490,9394609.06982422; 8495,9394406.12792969; 8500,9386465.45410156; 8505,9377294.15893555; 8510,9377294.15893555; 8515,9358681.48803711; 8520,9252285.76660156; 8525,9070442.19970703; 8530,9018330.38330078; 8535,8998519.13452148; 8540,8993583.67919922; 8545,8985075.37841797; 8550,8984580.99365234; 8555,8984347.53417969; 8560,8976397.70507813; 8565,8972114.56298828; 8570,8970787.04833984; 8575,8970787.04833984; 8580,8970162.20092773; 8585,8972114.56298828; 8590,8970162.20092773; 8595,8972853.85131836; 8600,8977357.48291016; 8605,8981839.75219727; 8610,8973353.57666016; 8615,8972114.56298828; 8620,8973353.57666016; 8625,8970787.04833984; 8630,8973353.57666016; 8635,8992442.32177734; 8640,8992442.32177734; 8645,8986445.61767578; 8650,8992442.32177734; 8655,8992442.32177734; 8660,8992498.77929688; 8665,
        8992442.32177734; 8670,8984150.69580078; 8675,8981236.26708984; 8680,8982286.07177734; 8685,8984150.69580078; 8690,8985376.73950195; 8695,8986026.76391602; 8700,8986278.53393555; 8705,8986026.76391602; 8710,8986026.76391602; 8715,8990148.92578125; 8720,8995102.69165039; 8725,8986278.53393555; 8730,8989002.2277832; 8735,8989002.2277832; 8740,8989217.37670898; 8745,8990148.92578125; 8750,8989002.2277832; 8755,8986026.76391602; 8760,8982713.31787109; 8765,8979868.31665039; 8770,8976380.1574707; 8775,8970992.27905273; 8780,8968801.87988281; 8785,8964638.51928711; 8790,8964638.51928711; 8795,8963918.30444336; 8800,8955494.68994141; 8805,8951287.84179688; 8810,8948483.27636719; 8815,8948483.27636719; 8820,8947919.46411133; 8825,8948483.27636719; 8830,8946495.05615234; 8835,8946495.05615234; 8840,8946495.05615234; 8845,8947801.20849609; 8850,8946621.70410156; 8855,8947801.20849609; 8860,8946495.05615234; 8865,8946375.2746582; 8870,8947801.20849609; 8875,8951226.04370117; 8880,
        8958754.73022461; 8885,8959601.59301758; 8890,8961261.74926758; 8895,8962117.00439453; 8900,8964044.95239258; 8905,8966737.36572266; 8910,8967855.83496094; 8915,8968379.21142578; 8920,8969898.22387695; 8925,8971353.14941406; 8930,8977962.49389648; 8935,8978806.30493164; 8940,8984279.63256836; 8945,8984104.91943359; 8950,8984104.91943359; 8955,8980499.26757813; 8960,8980499.26757813; 8965,8979971.31347656; 8970,8979971.31347656; 8975,8978446.96044922; 8980,8978446.96044922; 8985,8977685.546875; 8990,8976734.16137695; 8995,8975456.23779297; 9000,8975035.09521484; 9005,8975456.23779297; 9010,8974169.15893555; 9015,8971123.50463867; 9020,8969859.31396484; 9025,8964370.72753906; 9030,8962113.95263672; 9035,8961238.09814453; 9040,8956928.25317383; 9045,8956928.25317383; 9050,8959616.08886719; 9055,8956928.25317383; 9060,8954138.18359375; 9065,8951280.9753418; 9070,8953372.19238281; 9075,8950944.51904297; 9080,8946981.81152344; 9085,8946881.10351563; 9090,8944079.58984375; 9095,
        8941847.22900391; 9100,8941847.22900391; 9105,8941847.22900391; 9110,8945741.27197266; 9115,8947035.21728516; 9120,8949695.5871582; 9125,8953372.19238281; 9130,8953782.65380859; 9135,8957225.03662109; 9140,8958153.53393555; 9145,8958075.71411133; 9150,8960404.20532227; 9155,8961579.13208008; 9160,8965242.00439453; 9165,8970639.80102539; 9170,8973732.75756836; 9175,8974848.17504883; 9180,8976289.36767578; 9185,8980044.55566406; 9190,8987092.59033203; 9195,8994360.3515625; 9200,9017977.90527344; 9205,9043540.95458984; 9210,9105345.15380859; 9215,9153348.54125977; 9220,9172484.58862305; 9225,9185282.89794922; 9230,9209999.08447266; 9235,9230543.51806641; 9240,9247499.08447266; 9245,9252573.39477539; 9250,9256498.71826172; 9255,9263158.41674805; 9260,9274951.171875; 9265,9290774.53613281; 9270,9299275.97045898; 9275,9312902.83203125; 9280,9319499.20654297; 9285,9325088.50097656; 9290,9330777.74047852; 9295,9335812.37792969; 9300,9341455.078125; 9305,9355004.11987305; 9310,
        9360494.23217773; 9315,9364498.90136719; 9320,9364498.90136719; 9325,9368331.14624023; 9330,9372248.84033203; 9335,9377012.63427734; 9340,9377012.63427734; 9345,9379298.40087891; 9350,9383583.83178711; 9355,9385671.23413086; 9360,9388694.00024414; 9365,9394872.28393555; 9370,9396765.13671875; 9375,9400370.78857422; 9380,9405427.55126953; 9385,9401618.95751953; 9390,9405973.05297852; 9395,9419090.27099609; 9400,9421759.79614258; 9405,9421759.79614258; 9410,9422999.57275391; 9415,9424901.58081055; 9420,9427248.38256836; 9425,9429061.12670898; 9430,9429669.95239258; 9435,9430279.54101563; 9440,9429911.04125977; 9445,9429669.95239258; 9450,9429365.53955078; 9455,9429053.49731445; 9460,9431925.96435547; 9465,9434983.82568359; 9470,9429911.04125977; 9475,9426669.31152344; 9480,9426669.31152344; 9485,9424710.08300781; 9490,9421530.15136719; 9495,9419448.85253906; 9500,9413359.83276367; 9505,9408712.00561523; 9510,9405093.38378906; 9515,9401396.17919922; 9520,9399921.41723633; 9525,
        9394837.1887207; 9530,9392756.65283203; 9535,9385819.24438477; 9540,9380405.42602539; 9545,9375556.94580078; 9550,9375325.01220703; 9555,9373423.00415039; 9560,9372898.10180664; 9565,9368556.21337891; 9570,9358409.8815918; 9575,9354080.20019531; 9580,9347953.03344727; 9585,9345649.71923828; 9590,9344994.35424805; 9595,9342369.8425293; 9600,9340930.9387207; 9605,9340930.9387207; 9610,9342369.8425293; 9615,9342549.89624023; 9620,9342549.89624023; 9625,9339038.84887695; 9630,9339089.96582031; 9635,9335890.96069336; 9640,9340930.9387207; 9645,9340930.9387207; 9650,9342549.89624023; 9655,9341252.13623047; 9660,9341425.32348633; 9665,9350511.16943359; 9670,9355293.27392578; 9675,9358950.04272461; 9680,9358715.8203125; 9685,9358950.04272461; 9690,9365743.25561523; 9695,9368319.70214844; 9700,9378989.41040039; 9705,9385861.20605469; 9710,9392490.38696289; 9715,9392490.38696289; 9720,9394376.37329102; 9725,9402758.02612305; 9730,9404789.73388672; 9735,9416259.00268555; 9740,
        9417074.58496094; 9745,9426377.86865234; 9750,9426789.09301758; 9755,9435914.61181641; 9760,9441312.40844727; 9765,9446800.23193359; 9770,9452242.27905273; 9775,9456030.2734375; 9780,9456030.2734375; 9785,9457377.62451172; 9790,9456537.62817383; 9795,9459896.08764648; 9800,9459896.08764648; 9805,9459896.08764648; 9810,9458055.87768555; 9815,9458055.87768555; 9820,9458216.85791016; 9825,9459056.85424805; 9830,9460264.58740234; 9835,9461730.95703125; 9840,9459918.97583008; 9845,9459918.97583008; 9850,9461218.26171875; 9855,9460260.00976563; 9860,9461218.26171875; 9865,9461218.26171875; 9870,9459799.19433594; 9875,9459799.19433594; 9880,9458271.02661133; 9885,9456079.86450195; 9890,9455999.75585938; 9895,9453307.3425293; 9900,9452815.24658203; 9905,9444879.91333008; 9910,9440010.07080078; 9915,9431211.09008789; 9920,9429367.82836914; 9925,9427967.83447266; 9930,9418825.53100586; 9935,9414668.27392578; 9940,9414668.27392578; 9945,9413490.29541016; 9950,9404948.42529297; 9955,
        9404948.42529297; 9960,9401786.04125977; 9965,9394791.41235352; 9970,9391776.27563477; 9975,9391118.62182617; 9980,9377608.48999023; 9985,9369784.54589844; 9990,9359478.75976563; 9995,9366033.93554688; 10000,9371314.23950195; 10005,9361147.30834961; 10010,9359642.79174805; 10015,9356111.14501953; 10020,9349455.26123047; 10025,9353999.32861328; 10030,9354916.38183594; 10035,9361147.30834961; 10040,9368980.40771484; 10045,9375244.140625; 10050,9375328.06396484; 10055,9375878.14331055; 10060,9378982.54394531; 10065,9385610.96191406; 10070,9386270.14160156; 10075,9386270.14160156; 10080,9393257.14111328; 10085,9394759.36889648; 10090,9398902.13012695; 10095,9398902.13012695; 10100,9400803.37524414; 10105,9400803.37524414; 10110,9399076.84326172; 10115,9396867.37060547; 10120,9394759.36889648; 10125,9379245.75805664; 10130,9394759.36889648; 10135,9382136.53564453; 10140,9378108.97827148; 10145,9371310.42480469; 10150,9371560.66894531; 10155,9364353.94287109; 10160,9361572.265625;
        10165,9360548.40087891; 10170,9356224.82299805; 10175,9361572.265625; 10180,9351391.6015625; 10185,9361572.265625; 10190,9367031.86035156; 10195,9374678.03955078; 10200,9379759.21630859; 10205,9385045.6237793; 10210,9388621.52099609; 10215,9393634.03320313; 10220,9399164.58129883; 10225,9393634.03320313; 10230,9398424.5300293; 10235,9400878.90625; 10240,9405723.57177734; 10245,9406754.30297852; 10250,9405723.57177734; 10255,9406754.30297852; 10260,9411147.30834961; 10265,9411147.30834961; 10270,9406754.30297852; 10275,9414966.58325195; 10280,9411147.30834961; 10285,9414966.58325195; 10290,9417271.42333984; 10295,9417311.09619141; 10300,9417271.42333984; 10305,9417271.42333984; 10310,9416658.78295898; 10315,9417271.42333984; 10320,9416658.78295898; 10325,9416420.74584961; 10330,9414966.58325195; 10335,9413695.52612305; 10340,9412579.34570313; 10345,9413695.52612305; 10350,9410298.91967773; 10355,9410298.91967773; 10360,9410166.16821289; 10365,9410595.703125; 10370,
        9410639.19067383; 10375,9411000.06103516; 10380,9410907.74536133; 10385,9411000.06103516; 10390,9411000.06103516; 10395,9411000.06103516; 10400,9416019.43969727; 10405,9417782.59277344; 10410,9417782.59277344; 10415,9420598.60229492; 10420,9418816.37573242; 10425,9420598.60229492; 10430,9419443.51196289; 10435,9421471.4050293; 10440,9422893.52416992; 10445,9421471.4050293; 10450,9421471.4050293; 10455,9420598.60229492; 10460,9417980.1940918; 10465,9416605.37719727; 10470,9418894.95849609; 10475,9416664.12353516; 10480,9412651.06201172; 10485,9411393.73779297; 10490,9406087.49389648; 10495,9408534.24072266; 10500,9403667.44995117; 10505,9398999.0234375; 10510,9398999.0234375; 10515,9398999.0234375; 10520,9403433.99047852; 10525,9403433.99047852; 10530,9405356.59790039; 10535,9415251.15966797; 10540,9417683.41064453; 10545,9414273.83422852; 10550,9415251.15966797; 10555,9415251.15966797; 10560,9417381.28662109; 10565,9421016.69311523; 10570,9414273.83422852; 10575,
        9414273.83422852; 10580,9415945.43457031; 10585,9421016.69311523; 10590,9415945.43457031; 10595,9412892.15087891; 10600,9410239.41040039; 10605,9412856.29272461; 10610,9412856.29272461; 10615,9412104.03442383; 10620,9412856.29272461; 10625,9412856.29272461; 10630,9418855.28564453; 10635,9419758.60595703; 10640,9417677.30712891; 10645,9417677.30712891; 10650,9419716.64428711; 10655,9418855.28564453; 10660,9417080.68847656; 10665,9417080.68847656; 10670,9419052.88696289; 10675,9419758.60595703; 10680,9419758.60595703; 10685,9419052.88696289; 10690,9420326.23291016; 10695,9420946.50268555; 10700,9420326.23291016; 10705,9421900.17700195; 10710,9424492.64526367; 10715,9424492.64526367; 10720,9427948.76098633; 10725,9428689.57519531; 10730,9428829.95605469; 10735,9428831.48193359; 10740,9434875.48828125; 10745,9437062.07275391; 10750,9431576.53808594; 10755,9429566.95556641; 10760,9436138.91601563; 10765,9441706.08520508; 10770,9442259.21630859; 10775,9445050.04882813; 10780,
        9443196.10595703; 10785,9444308.47167969; 10790,9445420.83740234; 10795,9446114.34936523; 10800,9446114.34936523; 10805,9455999.75585938; 10810,9456638.33618164; 10815,9458040.61889648; 10820,9458040.61889648; 10825,9455999.75585938; 10830,9456638.33618164; 10835,9456638.33618164; 10840,9455999.75585938; 10845,9450292.20581055; 10850,9443721.00830078; 10855,9445882.41577148; 10860,9442841.33911133; 10865,9441595.45898438; 10870,9434931.94580078; 10875,9432344.81811523; 10880,9427925.10986328; 10885,9425942.23022461; 10890,9424499.51171875; 10895,9419693.75610352; 10900,9414935.30273438; 10905,9412413.02490234; 10910,9408371.73461914; 10915,9406468.20068359; 10920,9406901.55029297; 10925,9406468.20068359; 10930,9399505.61523438; 10935,9394811.2487793; 10940,9393367.76733398; 10945,9392597.96142578; 10950,9391071.31958008; 10955,9386826.32446289; 10960,9387735.74829102; 10965,9386008.45336914; 10970,9383982.08618164; 10975,9381509.39941406; 10980,9378127.28881836; 10985,
        9370646.66748047; 10990,9372944.64111328; 10995,9376270.29418945; 11000,9372944.64111328; 11005,9378127.28881836; 11010,9378127.28881836; 11015,9376554.87060547; 11020,9376554.87060547; 11025,9377902.98461914; 11030,9377902.98461914; 11035,9379377.74658203; 11040,9376963.80615234; 11045,9379377.74658203; 11050,9379377.74658203; 11055,9379377.74658203; 11060,9382132.72094727; 11065,9382132.72094727; 11070,9382132.72094727; 11075,9386942.29125977; 11080,9378787.23144531; 11085,9381895.44677734; 11090,9386942.29125977; 11095,9386942.29125977; 11100,9379717.25463867; 11105,9379717.25463867; 11110,9378018.95141602; 11115,9378787.23144531; 11120,9376356.50634766; 11125,9377033.99658203; 11130,9376985.16845703; 11135,9369028.47290039; 11140,9359999.08447266; 11145,9357477.56958008; 11150,9347947.69287109; 11155,9345922.8515625; 11160,9343309.02099609; 11165,9337007.14111328; 11170,9326391.6015625; 11175,9316236.87744141; 11180,9313924.40795898; 11185,9313924.40795898; 11190,
        9309538.26904297; 11195,9309180.45043945; 11200,9306387.32910156; 11205,9305160.52246094; 11210,9304645.53833008; 11215,9304285.4309082; 11220,9302060.69946289; 11225,9304645.53833008; 11230,9304553.9855957; 11235,9304285.4309082; 11240,9302060.69946289; 11245,9300640.86914063; 11250,9295252.99072266; 11255,9295252.99072266; 11260,9291547.39379883; 11265,9291547.39379883; 11270,9291547.39379883; 11275,9295252.99072266; 11280,9301073.45581055; 11285,9305152.13012695; 11290,9306604.00390625; 11295,9310294.34204102; 11300,9310235.59570313; 11305,9311634.82666016; 11310,9314772.03369141; 11315,9328129.57763672; 11320,9337484.74121094; 11325,9339603.42407227; 11330,9341458.89282227; 11335,9343572.99804688; 11340,9343572.99804688; 11345,9343499.75585938; 11350,9345497.13134766; 11355,9343499.75585938; 11360,9343499.75585938; 11365,9343499.75585938; 11370,9343499.75585938; 11375,9345497.13134766; 11380,9347444.15283203; 11385,9348017.12036133; 11390,9352432.25097656; 11395,
        9353997.80273438; 11400,9353997.80273438; 11405,9360863.49487305; 11410,9363610.83984375; 11415,9367253.11279297; 11420,9370828.24707031; 11425,9368403.62548828; 11430,9368403.62548828; 11435,9368403.62548828; 11440,9363629.91333008; 11445,9363629.91333008; 11450,9352228.54614258; 11455,9347085.57128906; 11460,9318421.93603516; 11465,9261891.93725586; 11470,9106532.28759766; 11475,9053541.56494141; 11480,9007627.86865234; 11485,8877314.75830078; 11490,8817654.41894531; 11495,8724549.86572266; 11500,8682189.94140625; 11505,8624130.24902344; 11510,8612583.92333984; 11515,8603999.32861328; 11520,8603999.32861328; 11525,8599827.57568359; 11530,8591682.43408203; 11535,8584918.97583008; 11540,8580387.11547852; 11545,8571759.03320313; 11550,8569058.22753906; 11555,8571759.03320313; 11560,8562624.35913086; 11565,8561840.8203125; 11570,8561425.01831055; 11575,8560593.41430664; 11580,8560499.57275391; 11585,8561009.21630859; 11590,8561513.51928711; 11595,8561840.8203125; 11600,
        8561840.8203125; 11605,8561840.8203125; 11610,8561009.21630859; 11615,8561009.21630859; 11620,8559446.71630859; 11625,8561513.51928711; 11630,8557292.17529297; 11635,8555183.41064453; 11640,8554540.25268555; 11645,8555372.61962891; 11650,8559446.71630859; 11655,8567148.59008789; 11660,8568615.72265625; 11665,8555372.61962891; 11670,8555183.41064453; 11675,8562634.27734375; 11680,8562634.27734375; 11685,8569310.76049805; 11690,8558715.05737305; 11695,8555261.23046875; 11700,8553020.47729492; 11705,8558715.05737305; 11710,8562634.27734375; 11715,8565553.28369141; 11720,8563080.59692383; 11725,8555168.15185547; 11730,8555168.15185547; 11735,8551366.42456055; 11740,8551366.42456055; 11745,8549123.38256836; 11750,8547914.88647461; 11755,8549123.38256836; 11760,8548342.89550781; 11765,8548342.89550781; 11770,8554287.71972656; 11775,8550608.82568359; 11780,8547914.88647461; 11785,8548322.29614258; 11790,8545671.84448242; 11795,8547914.88647461; 11800,8546146.39282227; 11805,
        8539733.88671875; 11810,8539733.88671875; 11815,8547914.88647461; 11820,8539733.88671875; 11825,8546146.39282227; 11830,8546146.39282227; 11835,8545671.84448242; 11840,8550608.82568359; 11845,8542037.96386719; 11850,8557076.26342773; 11855,8557862.85400391; 11860,8557862.85400391; 11865,8557862.85400391; 11870,8556154.63256836; 11875,8556154.63256836; 11880,8553321.83837891; 11885,8555403.13720703; 11890,8556431.57958984; 11895,8560947.41821289; 11900,8556774.90234375; 11905,8556154.63256836; 11910,8555403.13720703; 11915,8552040.10009766; 11920,8552375.03051758; 11925,8548030.09033203; 11930,8548030.09033203; 11935,8551309.96704102; 11940,8552040.10009766; 11945,8550064.84985352; 11950,8551499.93896484; 11955,8551499.93896484; 11960,8552375.03051758; 11965,8546398.92578125; 11970,8544555.6640625; 11975,8544555.6640625; 11980,8522568.51196289; 11985,8518245.69702148; 11990,8515454.1015625; 11995,8513433.83789063; 12000,8518774.4140625; 12005,8518774.4140625; 12010,
        8513433.83789063; 12015,8506857.29980469; 12020,8506857.29980469; 12025,8509915.16113281; 12030,8509388.73291016; 12035,8505261.23046875; 12040,8509388.73291016; 12045,8513283.53881836; 12050,8516908.26416016; 12055,8521988.67797852; 12060,8527681.73217773; 12065,8528334.80834961; 12070,8527783.96606445; 12075,8527681.73217773; 12080,8526357.26928711; 12085,8531082.15332031; 12090,8539024.35302734; 12095,8531220.24536133; 12100,8527783.96606445; 12105,8521988.67797852; 12110,8527681.73217773; 12115,8531082.15332031; 12120,8527681.73217773; 12125,8527681.73217773; 12130,8531082.15332031; 12135,8543428.03955078; 12140,8556674.19433594; 12145,8555542.75512695; 12150,8555542.75512695; 12155,8558616.63818359; 12160,8558616.63818359; 12165,8562290.95458984; 12170,8563141.63208008; 12175,8570050.04882813; 12180,8575838.47045898; 12185,8580200.1953125; 12190,8589022.82714844; 12195,8597660.06469727; 12200,8627371.21582031; 12205,8665536.49902344; 12210,8797856.14013672; 12215,
        8857456.20727539; 12220,8932499.69482422; 12225,9041295.6237793; 12230,9064930.72509766; 12235,9114557.64770508; 12240,9142945.09887695; 12245,9165284.72900391; 12250,9180748.7487793; 12255,9195864.10522461; 12260,9200911.71264648; 12265,9212364.19677734; 12270,9212364.19677734; 12275,9213772.58300781; 12280,9216626.73950195; 12285,9231623.07739258; 12290,9223100.28076172; 12295,9238394.92797852; 12300,9253494.26269531; 12305,9253494.26269531; 12310,9264755.24902344; 12315,9267356.10961914; 12320,9248448.18115234; 12325,9271835.32714844; 12330,9271510.31494141; 12335,9272827.1484375; 12340,9272814.94140625; 12345,9284287.26196289; 12350,9300514.22119141; 12355,9292526.24511719; 12360,9289823.15063477; 12365,9300514.22119141; 12370,9307727.05078125; 12375,9313566.58935547; 12380,9317136.38305664; 12385,9317136.38305664; 12390,9325991.05834961; 12395,9331998.44360352; 12400,9334765.625; 12405,9337673.95019531; 12410,9328280.63964844; 12415,9334765.625; 12420,9327179.71801758;
        12425,9322071.07543945; 12430,9317809.2956543; 12435,9322071.07543945; 12440,9316432.95288086; 12445,9315810.39428711; 12450,9305950.16479492; 12455,9298149.87182617; 12460,9282695.00732422; 12465,9273498.53515625; 12470,9260676.57470703; 12475,9258200.83618164; 12480,9255481.7199707; 12485,9258200.83618164; 12490,9250759.12475586; 12495,9244276.42822266; 12500,9240689.84985352; 12505,9236300.65917969; 12510,9236300.65917969; 12515,9233076.47705078; 12520,9229847.71728516; 12525,9236300.65917969; 12530,9226485.44311523; 12535,9219515.99121094; 12540,9216197.9675293; 12545,9215830.99365234; 12550,9217133.33129883; 12555,9216197.9675293; 12560,9214271.54541016; 12565,9210923.00415039; 12570,9217133.33129883; 12575,9222829.43725586; 12580,9232232.66601563; 12585,9230447.38769531; 12590,9232232.66601563; 12595,9237705.23071289; 12600,9238209.53369141; 12605,9249382.01904297; 12610,9270510.10131836; 12615,9280242.91992188; 12620,9293727.11181641; 12625,9296020.5078125; 12630,
        9301706.69555664; 12635,9308239.74609375; 12640,9308239.74609375; 12645,9314309.69238281; 12650,9310368.34716797; 12655,9301706.69555664; 12660,9301706.69555664; 12665,9295986.17553711; 12670,9295986.17553711; 12675,9291638.18359375; 12680,9298699.95117188; 12685,9301766.96777344; 12690,9301706.69555664; 12695,9298699.95117188; 12700,9301706.69555664; 12705,9309806.82373047; 12710,9309806.82373047; 12715,9310368.34716797; 12720,9301766.96777344; 12725,9299684.14306641; 12730,9310314.1784668; 12735,9309806.82373047; 12740,9315772.24731445; 12745,9309806.82373047; 12750,9316859.43603516; 12755,9315772.24731445; 12760,9309806.82373047; 12765,9299684.14306641; 12770,9299684.14306641; 12775,9295452.11791992; 12780,9299684.14306641; 12785,9295355.98754883; 12790,9293719.48242188; 12795,9295452.11791992; 12800,9295791.62597656; 12805,9295452.11791992; 12810,9305856.32324219; 12815,9295791.62597656; 12820,9295452.11791992; 12825,9286479.94995117; 12830,9277725.21972656; 12835,
        9277867.8894043; 12840,9286479.94995117; 12845,9291738.12866211; 12850,9289895.62988281; 12855,9284955.59692383; 12860,9284955.59692383; 12865,9288961.79199219; 12870,9289895.62988281; 12875,9290998.84033203; 12880,9290998.84033203; 12885,9286479.94995117; 12890,9286479.94995117; 12895,9277960.96801758; 12900,9274481.96411133; 12905,9279358.6730957; 12910,9283219.90966797; 12915,9283467.86499023; 12920,9283219.90966797; 12925,9290998.84033203; 12930,9293874.35913086; 12935,9293998.71826172; 12940,9295661.92626953; 12945,9307617.1875; 12950,9306422.42431641; 12955,9304842.37670898; 12960,9308361.0534668; 12965,9311879.73022461; 12970,9312521.36230469; 12975,9320777.13012695; 12980,9321591.18652344; 12985,9321591.18652344; 12990,9316152.19116211; 12995,9316152.19116211; 13000,9312295.53222656; 13005,9307958.22143555; 13010,9307958.22143555; 13015,9307291.41235352; 13020,9307291.41235352; 13025,9316152.19116211; 13030,9322838.5925293; 13035,9324451.4465332; 13040,9326998.90136719;
        13045,9330363.46435547; 13050,9341263.58032227; 13055,9341473.38867188; 13060,9344928.74145508; 13065,9344928.74145508; 13070,9344928.74145508; 13075,9344928.74145508; 13080,9358026.12304688; 13085,9355352.78320313; 13090,9357664.48974609; 13095,9341473.38867188; 13100,9333078.76586914; 13105,9333078.76586914; 13110,9333531.9519043; 13115,9346881.86645508; 13120,9333078.76586914; 13125,9328250.12207031; 13130,9326767.73071289; 13135,9325284.57641602; 13140,9326767.73071289; 13145,9331413.26904297; 13150,9331413.26904297; 13155,9331413.26904297; 13160,9329732.51342773; 13165,9328250.12207031; 13170,9329975.89111328; 13175,9331525.42114258; 13180,9329975.89111328; 13185,9331525.42114258; 13190,9331525.42114258; 13195,9335863.49487305; 13200,9342881.77490234; 13205,9339715.57617188; 13210,9344628.90625; 13215,9375490.57006836; 13220,9375490.57006836; 13225,9379757.69042969; 13230,9378647.61352539; 13235,9375717.92602539; 13240,9375717.92602539; 13245,9375717.92602539; 13250,
        9380641.17431641; 13255,9383116.9128418; 13260,9383116.9128418; 13265,9381791.68701172; 13270,9379792.02270508; 13275,9379757.69042969; 13280,9383664.70336914; 13285,9383116.9128418; 13290,9375942.23022461; 13295,9383188.62915039; 13300,9384869.38476563; 13305,9394907.37915039; 13310,9403357.6965332; 13315,9405783.08105469; 13320,9414185.33325195; 13325,9407848.3581543; 13330,9405783.08105469; 13335,9401838.68408203; 13340,9406029.51049805; 13345,9407848.3581543; 13350,9408094.0246582; 13355,9412310.02807617; 13360,9427577.97241211; 13365,9429225.15869141; 13370,9427577.97241211; 13375,9426014.70947266; 13380,9420166.015625; 13385,9412867.73681641; 13390,9422227.47802734; 13395,9412867.73681641; 13400,9412867.73681641; 13405,9426014.70947266; 13410,9434758.75854492; 13415,9426014.70947266; 13420,9424280.5480957; 13425,9422227.47802734; 13430,9424280.5480957; 13435,9426014.70947266; 13440,9431997.68066406; 13445,9432698.82202148; 13450,9436499.0234375; 13455,9438285.82763672;
        13460,9443872.83325195; 13465,9443392.18139648; 13470,9444536.59057617; 13475,9457257.08007813; 13480,9451499.93896484; 13485,9451499.93896484; 13490,9460474.39575195; 13495,9465089.41650391; 13500,9458094.0246582; 13505,9455690.76538086; 13510,9451499.93896484; 13515,9454971.31347656; 13520,9451499.93896484; 13525,9450302.88696289; 13530,9440927.12402344; 13535,9434113.31176758; 13540,9433919.52514648; 13545,9434113.31176758; 13550,9430062.86621094; 13555,9416187.28637695; 13560,9414068.60351563; 13565,9411847.68676758; 13570,9410610.19897461; 13575,9402239.99023438; 13580,9400498.96240234; 13585,9395124.05395508; 13590,9388916.015625; 13595,9374998.47412109; 13600,9374998.47412109; 13605,9389681.24389648; 13610,9389681.24389648; 13615,9383313.7512207; 13620,9374998.47412109; 13625,9385861.96899414; 13630,9385861.96899414; 13635,9389845.27587891; 13640,9380759.42993164; 13645,9380759.42993164; 13650,9380281.82983398; 13655,9375868.22509766; 13660,9380281.82983398; 13665,
        9380759.42993164; 13670,9391811.37084961; 13675,9397045.13549805; 13680,9391811.37084961; 13685,9393635.55908203; 13690,9394396.97265625; 13695,9402337.64648438; 13700,9402337.64648438; 13705,9413314.81933594; 13710,9418729.40063477; 13715,9425227.35595703; 13720,9433118.4387207; 13725,9439382.93457031; 13730,9446071.62475586; 13735,9454639.43481445; 13740,9471686.55395508; 13745,9475099.94506836; 13750,9479151.91650391; 13755,9497919.46411133; 13760,9501171.875; 13765,9511836.24267578; 13770,9531489.56298828; 13775,9531489.56298828; 13780,9531489.56298828; 13785,9524941.25366211; 13790,9519187.92724609; 13795,9507264.70947266; 13800,9522292.32788086; 13805,9524075.31738281; 13810,9522292.32788086; 13815,9501794.43359375; 13820,9494510.65063477; 13825,9483045.95947266; 13830,9463265.22827148; 13835,9461795.80688477; 13840,9460326.38549805; 13845,9461795.80688477; 13850,9463265.22827148; 13855,9457064.81933594; 13860,9453281.40258789; 13865,9453281.40258789; 13870,
        9449310.30273438; 13875,9435771.94213867; 13880,9415499.87792969; 13885,9406498.71826172; 13890,9406498.71826172; 13895,9392704.77294922; 13900,9390933.22753906; 13905,9385085.29663086; 13910,9377465.8203125; 13915,9374998.47412109; 13920,9372492.21801758; 13925,9367149.35302734; 13930,9365579.22363281; 13935,9345024.87182617; 13940,9339796.44775391; 13945,9334500.12207031; 13950,9329428.10058594; 13955,9309616.85180664; 13960,9292498.77929688; 13965,9271757.50732422; 13970,9254940.03295898; 13975,9237778.47290039; 13980,9218870.54443359; 13985,9209403.22875977; 13990,9209403.22875977; 13995,9212403.86962891; 14000,9218870.54443359; 14005,9218870.54443359; 14010,9212730.40771484; 14015,9218870.54443359; 14020,9218985.74829102; 14025,9227617.64526367; 14030,9244709.77783203; 14035,9250840.75927734; 14040,9261685.18066406; 14045,9261685.18066406; 14050,9264201.35498047; 14055,9277685.546875; 14060,9286739.34936523; 14065,9292857.36083984; 14070,9296558.38012695; 14075,
        9293297.5769043; 14080,9296558.38012695; 14085,9293297.5769043; 14090,9306375.12207031; 14095,9308584.59472656; 14100,9304814.14794922; 14105,9292857.36083984; 14110,9303658.29467773; 14115,9304814.14794922; 14120,9312583.16040039; 14125,9306375.12207031; 14130,9313349.15161133; 14135,9306375.12207031; 14140,9300009.15527344; 14145,9300009.15527344; 14150,9304199.98168945; 14155,9301122.28393555; 14160,9303658.29467773; 14165,9302672.5769043; 14170,9304199.98168945; 14175,9314278.41186523; 14180,9320424.65209961; 14185,9322611.23657227; 14190,9322776.79443359; 14195,9332064.05639648; 14200,9335936.73706055; 14205,9332324.21875; 14210,9350528.71704102; 14215,9350528.71704102; 14220,9357998.65722656; 14225,9361417.38891602; 14230,9372003.17382813; 14235,9377046.20361328; 14240,9377046.20361328; 14245,9377239.22729492; 14250,9372003.17382813; 14255,9372003.17382813; 14260,9361417.38891602; 14265,9356527.70996094; 14270,9360206.60400391; 14275,9357138.06152344; 14280,
        9344240.57006836; 14285,9331610.10742188; 14290,9334448.2421875; 14295,9319651.79443359; 14300,9302411.65161133; 14305,9302411.65161133; 14310,9300006.86645508; 14315,9298096.46606445; 14320,9280593.10913086; 14325,9280593.10913086; 14330,9280593.10913086; 14335,9280361.17553711; 14340,9280361.17553711; 14345,9270369.72045898; 14350,9280593.10913086; 14355,9280593.10913086; 14360,9280593.10913086; 14365,9269190.97900391; 14370,9266104.88891602; 14375,9269190.97900391; 14380,9269190.97900391; 14385,9265989.68505859; 14390,9260612.48779297; 14395,9261628.72314453; 14400,9261628.72314453; 14405,9269190.97900391; 14410,9272999.57275391; 14415,9272999.57275391; 14420,9277499.38964844; 14425,9272999.57275391; 14430,9267786.4074707; 14435,9272999.57275391; 14440,9277499.38964844; 14445,9278851.31835938; 14450,9282962.03613281; 14455,9282962.03613281; 14460,9277383.42285156; 14465,9278851.31835938; 14470,9282962.03613281; 14475,9282962.03613281; 14480,9286428.83300781; 14485,
        9292155.45654297; 14490,9298393.24951172; 14495,9287319.18334961; 14500,9295123.29101563; 14505,9313961.02905273; 14510,9313961.02905273; 14515,9319799.04174805; 14520,9322710.41870117; 14525,9350936.12670898; 14530,9352499.38964844; 14535,9356581.87866211; 14540,9361403.65600586; 14545,9365256.50024414; 14550,9370498.65722656; 14555,9376176.45263672; 14560,9377407.83691406; 14565,9372263.33618164; 14570,9376176.45263672; 14575,9376176.45263672; 14580,9375451.66015625; 14585,9375451.66015625; 14590,9375593.56689453; 14595,9377407.83691406; 14600,9388800.04882813; 14605,9388800.04882813; 14610,9387557.22045898; 14615,9387557.22045898; 14620,9387557.22045898; 14625,9387557.22045898; 14630,9383071.89941406; 14635,9388713.07373047; 14640,9394457.24487305; 14645,9400901.79443359; 14650,9408596.80175781; 14655,9408596.80175781; 14660,9408596.80175781; 14665,9412843.32275391; 14670,9412843.32275391; 14675,9407200.62255859; 14680,9407200.62255859; 14685,9407200.62255859; 14690,
        9400901.79443359; 14695,9393530.2734375; 14700,9393530.2734375; 14705,9385304.26025391; 14710,9379865.26489258; 14715,9369800.56762695; 14720,9365699.00512695; 14725,9363910.67504883; 14730,9353752.89916992; 14735,9352666.47338867; 14740,9352666.47338867; 14745,9349897.76611328; 14750,9349897.76611328; 14755,9348870.84960938; 14760,9337538.90991211; 14765,9333618.1640625; 14770,9332573.69995117; 14775,9332573.69995117; 14780,9334869.38476563; 14785,9331230.16357422; 14790,9332573.69995117; 14795,9333618.1640625; 14800,9327753.44848633; 14805,9322986.6027832; 14810,9325769.04296875; 14815,9325650.78735352; 14820,9327476.50146484; 14825,9327476.50146484; 14830,9327476.50146484; 14835,9325769.04296875; 14840,9326190.18554688; 14845,9324031.06689453; 14850,9323619.07958984; 14855,9316297.91259766; 14860,9323619.07958984; 14865,9324031.06689453; 14870,9322091.67480469; 14875,9324031.06689453; 14880,9326190.18554688; 14885,9324904.63256836; 14890,9326539.61181641; 14895,
        9326539.61181641; 14900,9334175.10986328; 14905,9336339.5690918; 14910,9339916.9921875; 14915,9344142.91381836; 14920,9346789.55078125; 14925,9353299.71313477; 14930,9359280.39550781; 14935,9370374.2980957; 14940,9371998.59619141; 14945,9372434.99755859; 14950,9378032.68432617; 14955,9377333.06884766; 14960,9377333.06884766; 14965,9380281.82983398; 14970,9378773.49853516; 14975,9380422.21069336; 14980,9379144.28710938; 14985,9377333.06884766; 14990,9374063.87329102; 14995,9374063.87329102; 15000,9370459.74731445; 15005,9367221.83227539; 15010,9365602.11181641; 15015,9359686.27929688; 15020,9354261.77978516; 15025,9349045.56274414; 15030,9343639.3737793; 15035,9338520.05004883; 15040,9337735.74829102; 15045,9335887.90893555; 15050,9334671.02050781; 15055,9334364.31884766; 15060,9334442.90161133; 15065,9334442.90161133; 15070,9334671.02050781; 15075,9337181.85424805; 15080,9337411.49902344; 15085,9337735.74829102; 15090,9335887.90893555; 15095,9337735.74829102; 15100,
        9337181.85424805; 15105,9337181.85424805; 15110,9337181.85424805; 15115,9335844.42138672; 15120,9335844.42138672; 15125,9335844.42138672; 15130,9338019.56176758; 15135,9339602.66113281; 15140,9343074.03564453; 15145,9339602.66113281; 15150,9338742.06542969; 15155,9339602.66113281; 15160,9338344.57397461; 15165,9342011.26098633; 15170,9344376.37329102; 15175,9347238.15917969; 15180,9344376.37329102; 15185,9343486.02294922; 15190,9347238.15917969; 15195,9348258.20922852; 15200,9348258.20922852; 15205,9349989.31884766; 15210,9349989.31884766; 15215,9349989.31884766; 15220,9355495.45288086; 15225,9355495.45288086; 15230,9356786.34643555; 15235,9364099.8840332; 15240,9366834.2590332; 15245,9361289.97802734; 15250,9363228.60717773; 15255,9376194.76318359; 15260,9379513.54980469; 15265,9379513.54980469; 15270,9382290.64941406; 15275,9388681.79321289; 15280,9394620.51391602; 15285,9398762.51220703; 15290,9398762.51220703; 15295,9399474.3347168; 15300,9403849.02954102; 15305,
        9403849.02954102; 15310,9403849.02954102; 15315,9404472.35107422; 15320,9406888.58032227; 15325,9407968.90258789; 15330,9407369.99511719; 15335,9411464.69116211; 15340,9407369.99511719; 15345,9407968.90258789; 15350,9407313.53759766; 15355,9405247.49755859; 15360,9404472.35107422; 15365,9404472.35107422; 15370,9396899.4140625; 15375,9403795.6237793; 15380,9396899.4140625; 15385,9396899.4140625; 15390,9391726.68457031; 15395,9381820.67871094; 15400,9381501.00708008; 15405,9378139.49584961; 15410,9371788.02490234; 15415,9369970.703125; 15420,9369970.703125; 15425,9369037.62817383; 15430,9372298.43139648; 15435,9379823.30322266; 15440,9373734.28344727; 15445,9372298.43139648; 15450,9369037.62817383; 15455,9368685.91308594; 15460,9359090.42358398; 15465,9358698.27270508; 15470,9353925.32348633; 15475,9353240.20385742; 15480,9356303.40576172; 15485,9350521.85058594; 15490,9351767.73071289; 15495,9350521.85058594; 15500,9348831.93969727; 15505,9343499.75585938; 15510,
        9338327.02636719; 15515,9334238.43383789; 15520,9333415.22216797; 15525,9333689.88037109; 15530,9333963.77563477; 15535,9333953.85742188; 15540,9335314.94140625; 15545,9339128.87573242; 15550,9335314.94140625; 15555,9333953.85742188; 15560,9333963.77563477; 15565,9336389.16015625; 15570,9337949.37133789; 15575,9337949.37133789; 15580,9353556.82373047; 15585,9356999.20654297; 15590,9363346.86279297; 15595,9369712.06665039; 15600,9369712.06665039; 15605,9379837.79907227; 15610,9394814.30053711; 15615,9386038.20800781; 15620,9394814.30053711; 15625,9396732.33032227; 15630,9397480.01098633; 15635,9399867.24853516; 15640,9402543.64013672; 15645,9402543.64013672; 15650,9414531.70776367; 15655,9420001.22070313; 15660,9414531.70776367; 15665,9421739.9597168; 15670,9410147.85766602; 15675,9409104.15649414; 15680,9407591.24755859; 15685,9414916.22924805; 15690,9416727.44750977; 15695,9417026.51977539; 15700,9414916.22924805; 15705,9409104.15649414; 15710,9407119.75097656; 15715,
        9401988.9831543; 15720,9401114.65454102; 15725,9397795.10498047; 15730,9391748.80981445; 15735,9395399.47509766; 15740,9391748.80981445; 15745,9397795.10498047; 15750,9401114.65454102; 15755,9400892.63916016; 15760,9401114.65454102; 15765,9401248.16894531; 15770,9401114.65454102; 15775,9402971.64916992; 15780,9402971.64916992; 15785,9406309.50927734; 15790,9409605.40771484; 15795,9410939.02587891; 15800,9410591.12548828; 15805,9413250.73242188; 15810,9414643.85986328; 15815,9411280.05981445; 15820,9410591.12548828; 15825,9411280.05981445; 15830,9418811.7980957; 15835,9416287.99438477; 15840,9411280.05981445; 15845,9404764.55688477; 15850,9401038.3605957; 15855,9401099.39575195; 15860,9397937.01171875; 15865,9389426.42211914; 15870,9389426.42211914; 15875,9393225.09765625; 15880,9389426.42211914; 15885,9381442.26074219; 15890,9392787.17041016; 15895,9389426.42211914; 15900,9378718.56689453; 15905,9378718.56689453; 15910,9373526.00097656; 15915,9378718.56689453; 15920,
        9389426.42211914; 15925,9388687.89672852; 15930,9384282.68432617; 15935,9388687.89672852; 15940,9392218.78051758; 15945,9384282.68432617; 15950,9377358.24584961; 15955,9382499.69482422; 15960,9383524.32250977; 15965,9383524.32250977; 15970,9388566.58935547; 15975,9394050.59814453; 15980,9394050.59814453; 15985,9394813.53759766; 15990,9393920.8984375; 15995,9393920.8984375; 16000,9400286.86523438; 16005,9404657.74536133; 16010,9402149.96337891; 16015,9402131.65283203; 16020,9405233.00170898; 16025,9404657.74536133; 16030,9404657.74536133; 16035,9403219.60449219; 16040,9402131.65283203; 16045,9394813.53759766; 16050,9394813.53759766; 16055,9392087.55493164; 16060,9389540.86303711; 16065,9392087.55493164; 16070,9392794.79980469; 16075,9395970.15380859; 16080,9398114.01367188; 16085,9394034.57641602; 16090,9403219.60449219; 16095,9402443.69506836; 16100,9403219.60449219; 16105,9405509.18579102; 16110,9408431.24389648; 16115,9408431.24389648; 16120,9410227.96630859; 16125,
        9412221.52709961; 16130,9417363.73901367; 16135,9420507.04956055; 16140,9425157.16552734; 16145,9417363.73901367; 16150,9411002.34985352; 16155,9414924.62158203; 16160,9418004.6081543; 16165,9407418.06030273; 16170,9407418.06030273; 16175,9402476.50146484; 16180,9394889.06860352; 16185,9391223.14453125; 16190,9385778.80859375; 16195,9385778.80859375; 16200,9377466.58325195; 16205,9372465.51513672; 16210,9370458.22143555; 16215,9367684.93652344; 16220,9365439.60571289; 16225,9362639.61791992; 16230,9350405.12084961; 16235,9347264.86206055; 16240,9347264.86206055; 16245,9337687.68310547; 16250,9335231.78100586; 16255,9330757.90405273; 16260,9324287.41455078; 16265,9319806.67114258; 16270,9318772.88818359; 16275,9311818.69506836; 16280,9304325.86669922; 16285,9299632.26318359; 16290,9300626.37329102; 16295,9291110.22949219; 16300,9287315.36865234; 16305,9286982.72705078; 16310,9287995.91064453; 16315,9286982.72705078; 16320,9286982.72705078; 16325,9284418.48754883; 16330,
        9281621.55151367; 16335,9280432.12890625; 16340,9279489.13574219; 16345,9273536.68212891; 16350,9278240.20385742; 16355,9278240.20385742; 16360,9279489.13574219; 16365,9278240.20385742; 16370,9280007.17163086; 16375,9273332.21435547; 16380,9278240.20385742; 16385,9279489.13574219; 16390,9279489.13574219; 16395,9280007.17163086; 16400,9280432.12890625; 16405,9283145.14160156; 16410,9282672.11914063; 16415,9280020.14160156; 16420,9283145.14160156; 16425,9283145.14160156; 16430,9282672.11914063; 16435,9279599.76196289; 16440,9276574.70703125; 16445,9276574.70703125; 16450,9282151.03149414; 16455,9274533.84399414; 16460,9273995.97167969; 16465,9264098.3581543; 16470,9264098.3581543; 16475,9264098.3581543; 16480,9270704.65087891; 16485,9279419.70825195; 16490,9288969.42138672; 16495,9302968.59741211; 16500,9303795.6237793; 16505,9320085.90698242; 16510,9338032.53173828; 16515,9349460.60180664; 16520,9353890.99121094; 16525,9357482.91015625; 16530,9363870.23925781; 16535,
        9373192.59643555; 16540,9379460.14404297; 16545,9382468.41430664; 16550,9389421.08154297; 16555,9396844.48242188; 16560,9401346.58813477; 16565,9413442.23022461; 16570,9420963.28735352; 16575,9437326.04980469; 16580,9442467.4987793; 16585,9446649.93286133; 16590,9447552.49023438; 16595,9456578.8269043; 16600,9460261.53564453; 16605,9460499.57275391; 16610,9460499.57275391; 16615,9460499.57275391; 16620,9463677.21557617; 16625,9463677.21557617; 16630,9460934.44824219; 16635,9460499.57275391; 16640,9460499.57275391; 16645,9453720.85571289; 16650,9449490.35644531; 16655,9443740.84472656; 16660,9434240.72265625; 16665,9434240.72265625; 16670,9427974.70092773; 16675,9418165.58837891; 16680,9411573.79150391; 16685,9409500.12207031; 16690,9407552.33764648; 16695,9402018.73779297; 16700,9399541.47338867; 16705,9397097.01538086; 16710,9386064.91088867; 16715,9380612.94555664; 16720,9368479.15649414; 16725,9357122.80273438; 16730,9349292.75512695; 16735,9342901.61132813; 16740,
        9338777.92358398; 16745,9336904.14428711; 16750,9338774.87182617; 16755,9337087.24975586; 16760,9336904.14428711; 16765,9336904.14428711; 16770,9336904.14428711; 16775,9337087.24975586; 16780,9337087.24975586; 16785,9335922.24121094; 16790,9333915.71044922; 16795,9337402.34375; 16800,9337087.24975586; 16805,9340499.87792969; 16810,9337402.34375; 16815,9340499.87792969; 16820,9340522.00317383; 16825,9340499.87792969; 16830,9337500; 16835,9332385.25390625; 16840,9332385.25390625; 16845,9333000.18310547; 16850,9332385.25390625; 16855,9333000.18310547; 16860,9337402.34375; 16865,9340499.87792969; 16870,9338932.03735352; 16875,9340698.2421875; 16880,9340771.484375; 16885,9349499.51171875; 16890,9351821.13647461; 16895,9351436.61499023; 16900,9351931.76269531; 16905,9368534.08813477; 16910,9379745.48339844; 16915,9388981.62841797; 16920,9389987.18261719; 16925,9391010.28442383; 16930,9399723.05297852; 16935,9406777.19116211; 16940,9399723.05297852; 16945,9409102.63061523; 16950,
        9414835.35766602; 16955,9420988.46435547; 16960,9420988.46435547; 16965,9420480.34667969; 16970,9421495.8190918; 16975,9426496.12426758; 16980,9426895.90454102; 16985,9422207.64160156; 16990,9422207.64160156; 16995,9425768.2800293; 17000,9423338.31787109; 17005,9423338.31787109; 17010,9421064.75830078; 17015,9422207.64160156; 17020,9425768.2800293; 17025,9422207.64160156; 17030,9418350.21972656; 17035,9416999.81689453; 17040,9420699.31030273; 17045,9416999.81689453; 17050,9416999.81689453; 17055,9416681.67114258; 17060,9413635.25390625; 17065,9411710.35766602; 17070,9409850.3112793; 17075,9409635.16235352; 17080,9407151.79443359; 17085,9407494.35424805; 17090,9409635.16235352; 17095,9402688.59863281; 17100,9400498.96240234; 17105,9400378.41796875; 17110,9397553.25317383; 17115,9395825.95825195; 17120,9396736.90795898; 17125,9395512.39013672; 17130,9393497.46704102; 17135,9395512.39013672; 17140,9390645.59936523; 17145,9388419.34204102; 17150,9390645.59936523; 17155,
        9389273.07128906; 17160,9388242.34008789; 17165,9385402.67944336; 17170,9387619.78149414; 17175,9385402.67944336; 17180,9384813.69018555; 17185,9380006.40869141; 17190,9382191.46728516; 17195,9374308.77685547; 17200,9372429.65698242; 17205,9370739.74609375; 17210,9365359.49707031; 17215,9365359.49707031; 17220,9365359.49707031; 17225,9362514.49584961; 17230,9362514.49584961; 17235,9368040.46630859; 17240,9371881.86645508; 17245,9370359.80224609; 17250,9378227.99682617; 17255,9379927.82592773; 17260,9392401.12304688; 17265,9393496.70410156; 17270,9396760.55908203; 17275,9396760.55908203; 17280,9398920.44067383; 17285,9398920.44067383; 17290,9401708.984375; 17295,9398920.44067383; 17300,9396760.55908203; 17305,9396153.25927734; 17310,9398920.44067383; 17315,9403697.9675293; 17320,9407753.75366211; 17325,9408224.48730469; 17330,9407918.54858398; 17335,9407918.54858398; 17340,9405010.98632813; 17345,9405010.98632813; 17350,9401576.23291016; 17355,9405010.98632813; 17360,
        9405428.31420898; 17365,9402320.86181641; 17370,9401576.23291016; 17375,9397151.18408203; 17380,9397151.18408203; 17385,9397151.18408203; 17390,9394242.09594727; 17395,9393558.50219727; 17400,9389115.90576172; 17405,9384399.4140625; 17410,9381995.3918457; 17415,9382280.73120117; 17420,9379634.85717773; 17425,9379634.85717773; 17430,9379634.85717773; 17435,9379634.85717773; 17440,9377762.60375977; 17445,9377767.94433594; 17450,9372214.50805664; 17455,9377762.60375977; 17460,9369389.34326172; 17465,9362454.98657227; 17470,9362454.98657227; 17475,9369389.34326172; 17480,9372214.50805664; 17485,9367788.69628906; 17490,9363166.04614258; 17495,9363166.04614258; 17500,9362113.95263672; 17505,9363016.51000977; 17510,9362113.95263672; 17515,9356898.49853516; 17520,9360887.90893555; 17525,9362113.95263672; 17530,9355495.45288086; 17535,9357095.33691406; 17540,9362973.02246094; 17545,9363166.04614258; 17550,9363970.94726563; 17555,9364987.18261719; 17560,9367498.77929688; 17565,
        9369239.80712891; 17570,9374810.02807617; 17575,9375916.2902832; 17580,9375405.12084961; 17585,9379490.66162109; 17590,9379593.65844727; 17595,9379177.85644531; 17600,9378734.58862305; 17605,9378734.58862305; 17610,9378734.58862305; 17615,9375916.2902832; 17620,9376541.90063477; 17625,9375444.03076172; 17630,9375916.2902832; 17635,9376052.09350586; 17640,9376052.09350586; 17645,9376052.09350586; 17650,9375444.03076172; 17655,9375444.03076172; 17660,9371998.59619141; 17665,9372607.421875; 17670,9373879.24194336; 17675,9376052.09350586; 17680,9379502.86865234; 17685,9379216.76635742; 17690,9376185.60791016; 17695,9375595.09277344; 17700,9375595.09277344; 17705,9372286.22436523; 17710,9369029.9987793; 17715,9367138.671875; 17720,9364011.38305664; 17725,9367198.9440918; 17730,9363715.36254883; 17735,9361304.47387695; 17740,9364011.38305664; 17745,9366429.90112305; 17750,9367198.9440918; 17755,9358391.57104492; 17760,9359894.56176758; 17765,9359894.56176758; 17770,9361304.47387695;
        17775,9361304.47387695; 17780,9366815.18554688; 17785,9367198.9440918; 17790,9366815.18554688; 17795,9364630.12695313; 17800,9359894.56176758; 17805,9355734.25292969; 17810,9364838.40942383; 17815,9364838.40942383; 17820,9364630.12695313; 17825,9360769.65332031; 17830,9362134.55200195; 17835,9364630.12695313; 17840,9360769.65332031; 17845,9358184.05151367; 17850,9356990.05126953; 17855,9355480.1940918; 17860,9347513.58032227; 17865,9346016.69311523; 17870,9346016.69311523; 17875,9346016.69311523; 17880,9347127.53295898; 17885,9344273.37646484; 17890,9344273.37646484; 17895,9346016.69311523; 17900,9348088.83666992; 17905,9352223.20556641; 17910,9350250.24414063; 17915,9352290.34423828; 17920,9352290.34423828; 17925,9352464.29443359; 17930,9351419.83032227; 17935,9354496.00219727; 17940,9357933.80737305; 17945,9358867.64526367; 17950,9359326.93481445; 17955,9358867.64526367; 17960,9359249.11499023; 17965,9358867.64526367; 17970,9358587.64648438; 17975,9359249.11499023; 17980,
        9359249.11499023; 17985,9360975.64697266; 17990,9360762.78686523; 17995,9361330.41381836; 18000,9364137.26806641; 18005,9364137.26806641; 18010,9364369.20166016; 18015,9364369.20166016; 18020,9358369.44580078; 18025,9357665.25268555; 18030,9355313.11035156; 18035,9354298.40087891; 18040,9352499.38964844; 18045,9353144.07348633; 18050,9354298.40087891; 18055,9355452.72827148; 18060,9354298.40087891; 18065,9355452.72827148; 18070,9355796.81396484; 18075,9360044.09790039; 18080,9364369.20166016; 18085,9367189.78881836; 18090,9372552.49023438; 18095,9378904.72412109; 18100,9378904.72412109; 18105,9379718.78051758; 18110,9381867.21801758; 18115,9381867.21801758; 18120,9381835.17456055; 18125,9381867.21801758; 18130,9384790.80200195; 18135,9385543.82324219; 18140,9385543.82324219; 18145,9385543.82324219; 18150,9385767.36450195; 18155,9384730.52978516; 18160,9379718.78051758; 18165,9379718.78051758; 18170,9379718.78051758; 18175,9384790.80200195; 18180,9389125.06103516; 18185,
        9390433.50219727; 18190,9394269.56176758; 18195,9389125.06103516; 18200,9388787.84179688; 18205,9389125.06103516; 18210,9386604.30908203; 18215,9382288.3605957; 18220,9382288.3605957; 18225,9381087.49389648; 18230,9380673.98071289; 18235,9380673.98071289; 18240,9375962.82958984; 18245,9368969.7265625; 18250,9368432.6171875; 18255,9365723.41918945; 18260,9363558.95996094; 18265,9359059.90600586; 18270,9357130.43212891; 18275,9352191.16210938; 18280,9349355.31616211; 18285,9346807.86132813; 18290,9345220.94726563; 18295,9341297.1496582; 18300,9340680.69458008; 18305,9335639.95361328; 18310,9333562.46948242; 18315,9333174.89624023; 18320,9331043.2434082; 18325,9325246.42944336; 18330,9321406.55517578; 18335,9323526.76391602; 18340,9322802.734375; 18345,9323526.76391602; 18350,9322802.734375; 18355,9327346.03881836; 18360,9321406.55517578; 18365,9322802.734375; 18370,9326089.47753906; 18375,9326805.87768555; 18380,9327835.08300781; 18385,9328479.7668457; 18390,9329129.79125977;
        18395,9329026.79443359; 18400,9329512.02392578; 18405,9329772.94921875; 18410,9328479.7668457; 18415,9329026.79443359; 18420,9327208.7097168; 18425,9329772.94921875; 18430,9329772.94921875; 18435,9329813.38500977; 18440,9331059.26513672; 18445,9332345.58105469; 18450,9344089.50805664; 18455,9353999.32861328; 18460,9354959.10644531; 18465,9355501.55639648; 18470,9355501.55639648; 18475,9361781.31103516; 18480,9363403.3203125; 18485,9367535.40039063; 18490,9368970.48950195; 18495,9373420.71533203; 18500,9370442.96264648; 18505,9373458.86230469; 18510,9379103.85131836; 18515,9377947.23510742; 18520,9377947.23510742; 18525,9377998.35205078; 18530,9377947.23510742; 18535,9377448.27270508; 18540,9377175.14038086; 18545,9377998.35205078; 18550,9378001.40380859; 18555,9383955.38330078; 18560,9386185.45532227; 18565,9389152.52685547; 18570,9389152.52685547; 18575,9396494.29321289; 18580,9399922.18017578; 18585,9399922.18017578; 18590,9404497.52807617; 18595,9402610.77880859; 18600,
        9405300.14038086; 18605,9407989.50195313; 18610,9413906.09741211; 18615,9419710.54077148; 18620,9425226.59301758; 18625,9424570.46508789; 18630,9425226.59301758; 18635,9424703.97949219; 18640,9426208.49609375; 18645,9427252.96020508; 18650,9426208.49609375; 18655,9420560.45532227; 18660,9417169.18945313; 18665,9414450.83618164; 18670,9413715.36254883; 18675,9403797.1496582; 18680,9393430.32836914; 18685,9381654.35791016; 18690,9363232.421875; 18695,9324237.82348633; 18700,9318406.67724609; 18705,9313463.5925293; 18710,9307439.42260742; 18715,9298233.03222656; 18720,9293741.60766602; 18725,9292083.74023438; 18730,9289020.53833008; 18735,9289020.53833008; 18740,9289020.53833008; 18745,9288212.58544922; 18750,9287110.13793945; 18755,9285452.27050781; 18760,9282137.29858398; 18765,9281540.67993164; 18770,9281540.67993164; 18775,9282137.29858398; 18780,9282137.29858398; 18785,9279927.82592773; 18790,9279136.65771484; 18795,9272415.92407227; 18800,9273175.81176758; 18805,
        9273175.81176758; 18810,9274688.72070313; 18815,9274688.72070313; 18820,9275388.33618164; 18825,9275388.33618164; 18830,9277194.97680664; 18835,9278485.10742188; 18840,9279552.4597168; 18845,9281913.75732422; 18850,9283738.70849609; 18855,9279552.4597168; 18860,9276004.02832031; 18865,9272975.92163086; 18870,9276004.02832031; 18875,9272975.92163086; 18880,9276384.73510742; 18885,9276384.73510742; 18890,9276384.73510742; 18895,9276384.73510742; 18900,9283738.70849609; 18905,9286802.67333984; 18910,9292710.87646484; 18915,9293708.80126953; 18920,9295184.32617188; 18925,9298713.68408203; 18930,9305104.06494141; 18935,9316763.30566406; 18940,9326077.27050781; 18945,9331179.04663086; 18950,9338098.14453125; 18955,9344328.30810547; 18960,9353770.44677734; 18965,9358499.14550781; 18970,9360237.88452148; 18975,9370571.89941406; 18980,9377762.60375977; 18985,9385592.65136719; 18990,9389428.7109375; 18995,9392765.80810547; 19000,9402076.72119141; 19005,9408785.24780273; 19010,
        9409517.66967773; 19015,9412261.96289063; 19020,9422252.6550293; 19025,9430036.16333008; 19030,9437152.09960938; 19035,9440417.48046875; 19040,9446969.60449219; 19045,9450994.87304688; 19050,9455780.79223633; 19055,9457511.13891602; 19060,9466401.67236328; 19065,9473095.703125; 19070,9482740.78369141; 19075,9484614.56298828; 19080,9492179.87060547; 19085,9493074.79858398; 19090,9497216.796875; 19095,9497216.796875; 19100,9501310.72998047; 19105,9510545.34912109; 19110,9511087.79907227; 19115,9506265.25878906; 19120,9510545.34912109; 19125,9511087.79907227; 19130,9511926.26953125; 19135,9514898.68164063; 19140,9514730.07202148; 19145,9511926.26953125; 19150,9511926.26953125; 19155,9506213.37890625; 19160,9506213.37890625; 19165,9502165.22216797; 19170,9504180.14526367; 19175,9500999.45068359; 19180,9498386.38305664; 19185,9493641.66259766; 19190,9486862.18261719; 19195,9482676.69677734; 19200,9482486.72485352; 19205,9476748.65722656; 19210,9469827.27050781; 19215,
        9473266.6015625; 19220,9469280.24291992; 19225,9466967.7734375; 19230,9469785.30883789; 19235,9476380.1574707; 19240,9476748.65722656; 19245,9481171.41723633; 19250,9489707.18383789; 19255,9492911.52954102; 19260,9498107.1472168; 19265,9507647.70507813; 19270,9512418.36547852; 19275,9520114.89868164; 19280,9521958.92333984; 19285,9527764.89257813; 19290,9536976.62353516; 19295,9544497.68066406; 19300,9560433.95996094; 19305,9561460.87646484; 19310,9562498.47412109; 19315,9562498.47412109; 19320,9564726.25732422; 19325,9564726.25732422; 19330,9566633.60595703; 19335,9565547.18017578; 19340,9562844.08569336; 19345,9561460.87646484; 19350,9557233.42895508; 19355,9556193.54248047; 19360,9553028.10668945; 19365,9552448.27270508; 19370,9547499.08447266; 19375,9543482.20825195; 19380,9538339.99633789; 19385,9526305.3894043; 19390,9523472.59521484; 19395,9517565.1550293; 19400,9512998.96240234; 19405,9497566.98608398; 19410,9497566.98608398; 19415,9490794.37255859; 19420,
        9486721.80175781; 19425,9480966.18652344; 19430,9478498.84033203; 19435,9471904.75463867; 19440,9468403.62548828; 19445,9462823.48632813; 19450,9451201.62963867; 19455,9450727.84423828; 19460,9449203.49121094; 19465,9443998.71826172; 19470,9441890.71655273; 19475,9427812.19482422; 19480,9424499.51171875; 19485,9413463.5925293; 19490,9406477.35595703; 19495,9397499.08447266; 19500,9397499.08447266; 19505,9390524.29199219; 19510,9377887.72583008; 19515,9376112.36572266; 19520,9373706.0546875; 19525,9368074.03564453; 19530,9367829.13208008; 19535,9363096.61865234; 19540,9363096.61865234; 19545,9359665.67993164; 19550,9358499.14550781; 19555,9355156.70776367; 19560,9347937.7746582; 19565,9345698.54736328; 19570,9340831.7565918; 19575,9334467.31567383; 19580,9322859.95483398; 19585,9315015.41137695; 19590,9304947.66235352; 19595,9294310.76049805; 19600,9285881.04248047; 19605,9276036.8347168; 19610,9264202.11791992; 19615,9257717.13256836; 19620,9250172.42431641; 19625,
        9241973.11401367; 19630,9211149.59716797; 19635,9198181.15234375; 19640,9189107.51342773; 19645,9178707.12280273; 19650,9166135.40649414; 19655,9158740.99731445; 19660,9146005.24902344; 19665,9142613.9831543; 19670,9126563.26293945; 19675,9109757.99560547; 19680,9105374.90844727; 19685,9096162.41455078; 19690,9086579.89501953; 19695,9073686.21826172; 19700,9053718.56689453; 19705,9033054.35180664; 19710,9012482.45239258; 19715,9006313.32397461; 19720,9000655.36499023; 19725,8991910.55297852; 19730,8985548.40087891; 19735,8979219.05517578; 19740,8972326.66015625; 19745,8968140.41137695; 19750,8968140.41137695; 19755,8966279.60205078; 19760,8966965.48461914; 19765,8968768.31054688; 19770,8972326.66015625; 19775,8974363.70849609; 19780,8979277.80151367; 19785,8982785.79711914; 19790,8983587.64648438; 19795,8990417.48046875; 19800,9001712.03613281; 19805,9005998.22998047; 19810,9008976.74560547; 19815,9018653.10668945; 19820,9019125.36621094; 19825,9022274.01733398; 19830,
        9027445.98388672; 19835,9032488.25073242; 19840,9036445.61767578; 19845,9044046.02050781; 19850,9038192.74902344; 19855,9043546.29516602; 19860,9044958.49609375; 19865,9049499.51171875; 19870,9049499.51171875; 19875,9049499.51171875; 19880,9051803.58886719; 19885,9052264.40429688; 19890,9052155.30395508; 19895,9052264.40429688; 19900,9053918.45703125; 19905,9056655.88378906; 19910,9059606.1706543; 19915,9061919.40307617; 19920,9067551.42211914; 19925,9073612.97607422; 19930,9077408.59985352; 19935,9077408.59985352; 19940,9078493.49975586; 19945,9083672.33276367; 19950,9084384.91821289; 19955,9084064.48364258; 19960,9084064.48364258; 19965,9084384.91821289; 19970,9089910.88867188; 19975,9095845.03173828; 19980,9092387.39013672; 19985,9092387.39013672; 19990,9095845.03173828; 19995,9103482.81860352]) annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=-90,
        origin={-90,230})));
  Modelica.Blocks.Sources.TimeTable timeTableGrindingPressure_concat(table=[0,9400000; 4499,9400000; 4500,9339089.96582031; 4501,9339038.84887695; 4502,9339038.84887695; 4503,9339038.84887695; 4504,9339038.84887695; 4505,9339089.96582031; 4506,9339089.96582031; 4507,9339089.96582031; 4508,9339038.84887695; 4509,9338278.19824219; 4510,9335890.96069336; 4511,9335890.96069336; 4512,9338278.19824219; 4513,9339038.84887695; 4514,9339089.96582031; 4515,9339089.96582031; 4516,9340930.9387207; 4517,9341117.85888672; 4518,9342369.8425293; 4519,9342369.8425293; 4520,9341117.85888672; 4521,9340930.9387207; 4522,9340483.85620117; 4523,9340483.85620117; 4524,9340483.85620117; 4525,9341117.85888672; 4526,9342549.89624023; 4527,9341117.85888672; 4528,9340483.85620117; 4529,9341117.85888672; 4530,9341252.13623047; 4531,9341252.13623047; 4532,9341252.13623047; 4533,9341252.13623047; 4534,9341117.85888672; 4535,9341252.13623047; 4536,9341425.32348633; 4537,9342549.89624023; 4538,9343283.84399414; 4539,
        9343605.80444336; 4540,9348411.56005859; 4541,9350511.16943359; 4542,9352526.0925293; 4543,9353970.33691406; 4544,9355293.27392578; 4545,9355293.27392578; 4546,9355293.27392578; 4547,9355293.27392578; 4548,9355293.27392578; 4549,9355722.04589844; 4550,9356995.3918457; 4551,9358950.04272461; 4552,9358950.04272461; 4553,9358715.8203125; 4554,9358715.8203125; 4555,9358715.8203125; 4556,9358715.8203125; 4557,9358715.8203125; 4558,9358950.04272461; 4559,9360065.46020508; 4560,9360065.46020508; 4561,9358950.04272461; 4562,9358950.04272461; 4563,9358950.04272461; 4564,9358950.04272461; 4565,9360065.46020508; 4566,9365743.25561523; 4567,9366160.58349609; 4568,9367160.03417969; 4569,9368319.70214844; 4570,9368319.70214844; 4571,9368319.70214844; 4572,9368319.70214844; 4573,9368319.70214844; 4574,9368852.23388672; 4575,9372154.9987793; 4576,9378989.41040039; 4577,9379589.84375; 4578,9383872.98583984; 4579,9384395.59936523; 4580,9384407.04345703; 4581,9385861.20605469; 4582,
        9388737.48779297; 4583,9389126.58691406; 4584,9389549.25537109; 4585,9390713.50097656; 4586,9392490.38696289; 4587,9392490.38696289; 4588,9392490.38696289; 4589,9394376.37329102; 4590,9394376.37329102; 4591,9392490.38696289; 4592,9390713.50097656; 4593,9389549.25537109; 4594,9390713.50097656; 4595,9392490.38696289; 4596,9394376.37329102; 4597,9394464.87426758; 4598,9397175.59814453; 4599,9398726.65405273; 4600,9399263.76342773; 4601,9402758.02612305; 4602,9403407.28759766; 4603,9403774.26147461; 4604,9403972.62573242; 4605,9403987.12158203; 4606,9404789.73388672; 4607,9406722.25952148; 4608,9411791.9921875; 4609,9413611.6027832; 4610,9415400.69580078; 4611,9416259.00268555; 4612,9416259.00268555; 4613,9416561.88964844; 4614,9416719.81811523; 4615,9417950.43945313; 4616,9417074.58496094; 4617,9417074.58496094; 4618,9417950.43945313; 4619,9420037.07885742; 4620,9421103.66821289; 4621,9426377.86865234; 4622,9426479.33959961; 4623,9426479.33959961; 4624,9426789.09301758; 4625,
        9426789.09301758; 4626,9426789.09301758; 4627,9431220.24536133; 4628,9432074.73754883; 4629,9432074.73754883; 4630,9432074.73754883; 4631,9435914.61181641; 4632,9439053.34472656; 4633,9439053.34472656; 4634,9439053.34472656; 4635,9439053.34472656; 4636,9441312.40844727; 4637,9441790.00854492; 4638,9441803.74145508; 4639,9442331.69555664; 4640,9442331.69555664; 4641,9446800.23193359; 4642,9449354.55322266; 4643,9451534.27124023; 4644,9452242.27905273; 4645,9452242.27905273; 4646,9452242.27905273; 4647,9454219.81811523; 4648,9454456.3293457; 4649,9454550.17089844; 4650,9455220.79467773; 4651,9456030.2734375; 4652,9456240.84472656; 4653,9456030.2734375; 4654,9456030.2734375; 4655,9456030.2734375; 4656,9456030.2734375; 4657,9456240.84472656; 4658,9456240.84472656; 4659,9456240.84472656; 4660,9456537.62817383; 4661,9457377.62451172; 4662,9457377.62451172; 4663,9456537.62817383; 4664,9456537.62817383; 4665,9456537.62817383; 4666,9456537.62817383; 4667,9456537.62817383; 4668,
        9457377.62451172; 4669,9458216.85791016; 4670,9459056.85424805; 4671,9459896.08764648; 4672,9459896.08764648; 4673,9459896.08764648; 4674,9459896.08764648; 4675,9459896.08764648; 4676,9459896.08764648; 4677,9459896.08764648; 4678,9459918.97583008; 4679,9460260.00976563; 4680,9459918.97583008; 4681,9459896.08764648; 4682,9459896.08764648; 4683,9459056.85424805; 4684,9459056.85424805; 4685,9458216.85791016; 4686,9458055.87768555; 4687,9457377.62451172; 4688,9457377.62451172; 4689,9457377.62451172; 4690,9457377.62451172; 4691,9458055.87768555; 4692,9458216.85791016; 4693,9458216.85791016; 4694,9458216.85791016; 4695,9458216.85791016; 4696,9458216.85791016; 4697,9458216.85791016; 4698,9459056.85424805; 4699,9459896.08764648; 4700,9459896.08764648; 4701,9459056.85424805; 4702,9459056.85424805; 4703,9459896.08764648; 4704,9459918.97583008; 4705,9460260.00976563; 4706,9460264.58740234; 4707,9460264.58740234; 4708,9460260.00976563; 4709,9460264.58740234; 4710,9461730.95703125; 4711,
        9461730.95703125; 4712,9460264.58740234; 4713,9460260.00976563; 4714,9459918.97583008; 4715,9459918.97583008; 4716,9459918.97583008; 4717,9459896.08764648; 4718,9459799.19433594; 4719,9459799.19433594; 4720,9459896.08764648; 4721,9459918.97583008; 4722,9460260.00976563; 4723,9460260.00976563; 4724,9460260.00976563; 4725,9460260.00976563; 4726,9461218.26171875; 4727,9461218.26171875; 4728,9461218.26171875; 4729,9460260.00976563; 4730,9460260.00976563; 4731,9460260.00976563; 4732,9461218.26171875; 4733,9464354.70581055; 4734,9464354.70581055; 4735,9461218.26171875; 4736,9461218.26171875; 4737,9461218.26171875; 4738,9461218.26171875; 4739,9461218.26171875; 4740,9461218.26171875; 4741,9461218.26171875; 4742,9461218.26171875; 4743,9460260.00976563; 4744,9460260.00976563; 4745,9460179.13818359; 4746,9459799.19433594; 4747,9459799.19433594; 4748,9459799.19433594; 4749,9459799.19433594; 4750,9459799.19433594; 4751,9459799.19433594; 4752,9459799.19433594; 4753,9459799.19433594; 4754,
        9458271.02661133; 4755,9458271.02661133; 4756,9458271.02661133; 4757,9458055.87768555; 4758,9456079.86450195; 4759,9456079.86450195; 4760,9456079.86450195; 4761,9456079.86450195; 4762,9456079.86450195; 4763,9455999.75585938; 4764,9455999.75585938; 4765,9455999.75585938; 4766,9455999.75585938; 4767,9455999.75585938; 4768,9455157.47070313; 4769,9453575.8972168; 4770,9453392.02880859; 4771,9453307.3425293; 4772,9453307.3425293; 4773,9453260.0402832; 4774,9452815.24658203; 4775,9452815.24658203; 4776,9452815.24658203; 4777,9450955.20019531; 4778,9450901.79443359; 4779,9450267.79174805; 4780,9446972.65625; 4781,9444879.91333008; 4782,9444630.43212891; 4783,9444197.84545898; 4784,9442259.21630859; 4785,9440369.4152832; 4786,9440010.07080078; 4787,9439929.9621582; 4788,9439492.03491211; 4789,9434203.33862305; 4790,9433766.17431641; 4791,9431211.09008789; 4792,9431211.09008789; 4793,9431211.09008789; 4794,9430161.28540039; 4795,9429367.82836914; 4796,9429367.82836914; 4797,
        9429367.82836914; 4798,9429367.82836914; 4799,9429367.82836914; 4800,9428958.12988281; 4801,9427967.83447266; 4802,9418825.53100586; 4803,9418825.53100586; 4804,9418825.53100586; 4805,9418825.53100586; 4806,9418825.53100586; 4807,9418825.53100586; 4808,9417986.29760742; 4809,9415590.66772461; 4810,9415323.63891602; 4811,9414668.27392578; 4812,9414668.27392578; 4813,9414668.27392578; 4814,9414668.27392578; 4815,9414668.27392578; 4816,9414668.27392578; 4817,9414668.27392578; 4818,9414668.27392578; 4819,9414668.27392578; 4820,9414668.27392578; 4821,9413490.29541016; 4822,9412805.17578125; 4823,9407344.81811523; 4824,9407014.46533203; 4825,9406455.99365234; 4826,9404948.42529297; 4827,9404948.42529297; 4828,9404948.42529297; 4829,9404948.42529297; 4830,9404948.42529297; 4831,9404948.42529297; 4832,9404948.42529297; 4833,9404948.42529297; 4834,9404948.42529297; 4835,9404011.53564453; 4836,9401786.04125977; 4837,9401615.90576172; 4838,9399560.546875; 4839,9396196.74682617; 4840,
        9396042.63305664; 4841,9394791.41235352; 4842,9394519.04296875; 4843,9394519.04296875; 4844,9394791.41235352; 4845,9394519.04296875; 4846,9391776.27563477; 4847,9391118.62182617; 4848,9387961.57836914; 4849,9387961.57836914; 4850,9391118.62182617; 4851,9391118.62182617; 4852,9387961.57836914; 4853,9383992.00439453; 4854,9380768.58520508; 4855,9380451.96533203; 4856,9377608.48999023; 4857,9377608.48999023; 4858,9377608.48999023; 4859,9376866.14990234; 4860,9372029.11376953; 4861,9369784.54589844; 4862,9366033.93554688; 4863,9362645.72143555; 4864,9359478.75976563; 4865,9359478.75976563; 4866,9359478.75976563; 4867,9362645.72143555; 4868,9366033.93554688; 4869,9372029.11376953; 4870,9372029.11376953; 4871,9366033.93554688; 4872,9366033.93554688; 4873,9366033.93554688; 4874,9366033.93554688; 4875,9367300.41503906; 4876,9371314.23950195; 4877,9367300.41503906; 4878,9367300.41503906; 4879,9363286.59057617; 4880,9361147.30834961; 4881,9361147.30834961; 4882,9361147.30834961; 4883,
        9361147.30834961; 4884,9361147.30834961; 4885,9359642.79174805; 4886,9359642.79174805; 4887,9359642.79174805; 4888,9359642.79174805; 4889,9359642.79174805; 4890,9359478.75976563; 4891,9356111.14501953; 4892,9356111.14501953; 4893,9355466.46118164; 4894,9354916.38183594; 4895,9351388.54980469; 4896,9349455.26123047; 4897,9347048.95019531; 4898,9349455.26123047; 4899,9351388.54980469; 4900,9353999.32861328; 4901,9353999.32861328; 4902,9353999.32861328; 4903,9353999.32861328; 4904,9353999.32861328; 4905,9353999.32861328; 4906,9354916.38183594; 4907,9355466.46118164; 4908,9356111.14501953; 4909,9359642.79174805; 4910,9360165.40527344; 4911,9361147.30834961; 4912,9362641.90673828; 4913,9363286.59057617; 4914,9367300.41503906; 4915,9368373.87084961; 4916,9368980.40771484; 4917,9371314.23950195; 4918,9371314.23950195; 4919,9371314.23950195; 4920,9375167.84667969; 4921,9375244.140625; 4922,9375328.06396484; 4923,9375543.97583008; 4924,9375543.97583008; 4925,9375543.97583008; 4926,
        9375328.06396484; 4927,9375328.06396484; 4928,9375328.06396484; 4929,9375328.06396484; 4930,9375543.97583008; 4931,9375878.14331055; 4932,9375878.14331055; 4933,9377446.74682617; 4934,9378104.40063477; 4935,9378655.24291992; 4936,9378982.54394531; 4937,9382752.99072266; 4938,9383129.8828125; 4939,9385477.44750977; 4940,9385610.96191406; 4941,9385610.96191406; 4942,9385610.96191406; 4943,9385610.96191406; 4944,9385477.44750977; 4945,9385610.96191406; 4946,9386270.14160156; 4947,9388593.29223633; 4948,9390665.43579102; 4949,9390665.43579102; 4950,9388593.29223633; 4951,9386270.14160156; 4952,9388593.29223633; 4953,9390665.43579102; 4954,9391015.625; 4955,9391229.24804688; 4956,9393257.14111328; 4957,9393257.14111328; 4958,9393257.14111328; 4959,9393257.14111328; 4960,9393257.14111328; 4961,9394759.36889648; 4962,9394759.36889648; 4963,9394759.36889648; 4964,9396867.37060547; 4965,9397723.38867188; 4966,9398902.13012695; 4967,9398902.13012695; 4968,9398902.13012695; 4969,
        9398902.13012695; 4970,9398902.13012695; 4971,9398902.13012695; 4972,9398902.13012695; 4973,9398902.13012695; 4974,9398902.13012695; 4975,9399076.84326172; 4976,9400803.37524414; 4977,9401173.40087891; 4978,9401544.18945313; 4979,9401173.40087891; 4980,9400803.37524414; 4981,9400803.37524414; 4982,9400803.37524414; 4983,9400803.37524414; 4984,9399076.84326172; 4985,9399076.84326172; 4986,9399076.84326172; 4987,9399076.84326172; 4988,9399076.84326172; 4989,9399076.84326172; 4990,9397723.38867188; 4991,9396867.37060547; 4992,9396867.37060547; 4993,9396867.37060547; 4994,9396866.60766602; 4995,9395175.93383789; 4996,9394759.36889648; 4997,9384516.90673828; 4998,9382136.53564453; 4999,9379245.75805664; 5000,9378108.97827148; 5001,9379245.75805664; 5002,9382136.53564453; 5003,9384516.90673828; 5004,9394759.36889648; 5005,9394759.36889648; 5006,9394759.36889648; 5007,9395175.93383789; 5008,9396866.60766602; 5009,9395175.93383789; 5010,9384516.90673828; 5011,9382136.53564453; 5012,
        9382136.53564453; 5013,9382136.53564453; 5014,9379759.21630859; 5015,9379245.75805664; 5016,9378108.97827148; 5017,9377355.95703125; 5018,9371560.66894531; 5019,9371560.66894531; 5020,9371519.47021484; 5021,9371310.42480469; 5022,9371310.42480469; 5023,9371310.42480469; 5024,9371310.42480469; 5025,9371560.66894531; 5026,9371560.66894531; 5027,9368508.91113281; 5028,9366564.1784668; 5029,9366089.63012695; 5030,9364353.94287109; 5031,9364353.94287109; 5032,9364353.94287109; 5033,9364353.94287109; 5034,9364122.00927734; 5035,9361572.265625; 5036,9361572.265625; 5037,9361572.265625; 5038,9361572.265625; 5039,9361572.265625; 5040,9361572.265625; 5041,9360548.40087891; 5042,9356224.82299805; 5043,9353573.60839844; 5044,9353573.60839844; 5045,9351391.6015625; 5046,9356224.82299805; 5047,9360548.40087891; 5048,9361572.265625; 5049,9361572.265625; 5050,9361572.265625; 5051,9361572.265625; 5052,9360548.40087891; 5053,9356224.82299805; 5054,9351391.6015625; 5055,9351391.6015625; 5056,
        9351391.6015625; 5057,9351391.6015625; 5058,9351391.6015625; 5059,9356224.82299805; 5060,9360548.40087891; 5061,9361572.265625; 5062,9364353.94287109; 5063,9364353.94287109; 5064,9366089.63012695; 5065,9366089.63012695; 5066,9367031.86035156; 5067,9368997.19238281; 5068,9370810.69946289; 5069,9371560.66894531; 5070,9373628.23486328; 5071,9374678.03955078; 5072,9375476.07421875; 5073,9377355.95703125; 5074,9378618.62182617; 5075,9379759.21630859; 5076,9379759.21630859; 5077,9379759.21630859; 5078,9379759.21630859; 5079,9379759.21630859; 5080,9382990.26489258; 5081,9385045.6237793; 5082,9385045.6237793; 5083,9385045.6237793; 5084,9388621.52099609; 5085,9388621.52099609; 5086,9388621.52099609; 5087,9385749.81689453; 5088,9385749.81689453; 5089,9385749.81689453; 5090,9385749.81689453; 5091,9393634.03320313; 5092,9394990.53955078; 5093,9398611.45019531; 5094,9399164.58129883; 5095,9399164.58129883; 5096,9399164.58129883; 5097,9398611.45019531; 5098,9398424.5300293; 5099,
        9398424.5300293; 5100,9394990.53955078; 5101,9393634.03320313; 5102,9393634.03320313; 5103,9395900.72631836; 5104,9395900.72631836; 5105,9395900.72631836; 5106,9398424.5300293; 5107,9398424.5300293; 5108,9398611.45019531; 5109,9399164.58129883; 5110,9399621.58203125; 5111,9400878.90625; 5112,9401229.85839844; 5113,9401229.85839844; 5114,9401229.85839844; 5115,9405290.98510742; 5116,9405723.57177734; 5117,9406107.33032227; 5118,9406107.33032227; 5119,9406107.33032227; 5120,9406107.33032227; 5121,9406754.30297852; 5122,9406754.30297852; 5123,9406107.33032227; 5124,9405723.57177734; 5125,9405290.98510742; 5126,9405723.57177734; 5127,9406107.33032227; 5128,9406754.30297852; 5129,9406754.30297852; 5130,9406754.30297852; 5131,9406754.30297852; 5132,9411147.30834961; 5133,9412282.56225586; 5134,9414966.58325195; 5135,9412282.56225586; 5136,9411147.30834961; 5137,9411147.30834961; 5138,9412282.56225586; 5139,9414966.58325195; 5140,9412282.56225586; 5141,9411147.30834961; 5142,
        9406754.30297852; 5143,9406754.30297852; 5144,9406754.30297852; 5145,9406754.30297852; 5146,9406754.30297852; 5147,9406754.30297852; 5148,9406754.30297852; 5149,9411147.30834961; 5150,9414966.58325195; 5151,9414966.58325195; 5152,9414966.58325195; 5153,9414966.58325195; 5154,9414966.58325195; 5155,9414966.58325195; 5156,9411147.30834961; 5157,9411147.30834961; 5158,9411147.30834961; 5159,9413695.52612305; 5160,9414966.58325195; 5161,9414966.58325195; 5162,9415484.61914063; 5163,9415484.61914063; 5164,9415484.61914063; 5165,9415484.61914063; 5166,9417271.42333984; 5167,9417271.42333984; 5168,9415484.61914063; 5169,9417271.42333984; 5170,9417311.09619141; 5171,9417311.09619141; 5172,9417311.09619141; 5173,9417311.09619141; 5174,9417271.42333984; 5175,9417271.42333984; 5176,9417271.42333984; 5177,9417271.42333984; 5178,9417271.42333984; 5179,9417311.09619141; 5180,9417311.09619141; 5181,9417271.42333984; 5182,9417271.42333984; 5183,9417271.42333984; 5184,9417271.42333984; 5185,
        9417271.42333984; 5186,9416658.78295898; 5187,9416658.78295898; 5188,9416658.78295898; 5189,9417271.42333984; 5190,9417271.42333984; 5191,9417271.42333984; 5192,9416658.78295898; 5193,9416658.78295898; 5194,9416658.78295898; 5195,9416658.78295898; 5196,9416658.78295898; 5197,9416658.78295898; 5198,9416658.78295898; 5199,9416658.78295898; 5200,9416658.78295898; 5201,9416420.74584961; 5202,9415484.61914063; 5203,9414966.58325195; 5204,9414966.58325195; 5205,9414966.58325195; 5206,9414966.58325195; 5207,9414461.51733398; 5208,9414461.51733398; 5209,9413695.52612305; 5210,9413695.52612305; 5211,9413695.52612305; 5212,9413695.52612305; 5213,9412579.34570313; 5214,9410595.703125; 5215,9411196.89941406; 5216,9412579.34570313; 5217,9413695.52612305; 5218,9413695.52612305; 5219,9413695.52612305; 5220,9413695.52612305; 5221,9413695.52612305; 5222,9413013.45825195; 5223,9412579.34570313; 5224,9411196.89941406; 5225,9410595.703125; 5226,9410298.91967773; 5227,9410044.09790039; 5228,
        9410044.09790039; 5229,9410044.09790039; 5230,9410044.09790039; 5231,9410298.91967773; 5232,9410298.91967773; 5233,9410044.09790039; 5234,9410044.09790039; 5235,9410044.09790039; 5236,9410166.16821289; 5237,9410166.16821289; 5238,9410298.91967773; 5239,9410536.95678711; 5240,9410595.703125; 5241,9410595.703125; 5242,9410595.703125; 5243,9410639.19067383; 5244,9410639.19067383; 5245,9410639.19067383; 5246,9410639.19067383; 5247,9410639.19067383; 5248,9410639.19067383; 5249,9410639.19067383; 5250,9410907.74536133; 5251,9411000.06103516; 5252,9411000.06103516; 5253,9411000.06103516; 5254,9410907.74536133; 5255,9410907.74536133; 5256,9410907.74536133; 5257,9410907.74536133; 5258,9410907.74536133; 5259,9410907.74536133; 5260,9410907.74536133; 5261,9411000.06103516; 5262,9411000.06103516; 5263,9411000.06103516; 5264,9411000.06103516; 5265,9411000.06103516; 5266,9411000.06103516; 5267,9410907.74536133; 5268,9410907.74536133; 5269,9410907.74536133; 5270,9411000.06103516; 5271,
        9411000.06103516; 5272,9411000.06103516; 5273,9411196.89941406; 5274,9412830.3527832; 5275,9413013.45825195; 5276,9416019.43969727; 5277,9417044.06738281; 5278,9417044.06738281; 5279,9417044.06738281; 5280,9417044.06738281; 5281,9417782.59277344; 5282,9417782.59277344; 5283,9417401.88598633; 5284,9417401.88598633; 5285,9417782.59277344; 5286,9417782.59277344; 5287,9417980.1940918; 5288,9418816.37573242; 5289,9418964.38598633; 5290,9420598.60229492; 5291,9420598.60229492; 5292,9420598.60229492; 5293,9418964.38598633; 5294,9418816.37573242; 5295,9418816.37573242; 5296,9418816.37573242; 5297,9418964.38598633; 5298,9420598.60229492; 5299,9420598.60229492; 5300,9420598.60229492; 5301,9420598.60229492; 5302,9421031.18896484; 5303,9421471.4050293; 5304,9421031.18896484; 5305,9420598.60229492; 5306,9419443.51196289; 5307,9419443.51196289; 5308,9419443.51196289; 5309,9420598.60229492; 5310,9421031.18896484; 5311,9421471.4050293; 5312,9422893.52416992; 5313,9423175.04882813; 5314,
        9423230.7434082; 5315,9423175.04882813; 5316,9422893.52416992; 5317,9421471.4050293; 5318,9421031.18896484; 5319,9421031.18896484; 5320,9421031.18896484; 5321,9421471.4050293; 5322,9422893.52416992; 5323,9423175.04882813; 5324,9423175.04882813; 5325,9422893.52416992; 5326,9421471.4050293; 5327,9421471.4050293; 5328,9421471.4050293; 5329,9421471.4050293; 5330,9421031.18896484; 5331,9420598.60229492; 5332,9420598.60229492; 5333,9419443.51196289; 5334,9418894.95849609; 5335,9418816.37573242; 5336,9417980.1940918; 5337,9417401.88598633; 5338,9417401.88598633; 5339,9416841.12548828; 5340,9416664.12353516; 5341,9416605.37719727; 5342,9416664.12353516; 5343,9416841.12548828; 5344,9417401.88598633; 5345,9418894.95849609; 5346,9418894.95849609; 5347,9417401.88598633; 5348,9416841.12548828; 5349,9416841.12548828; 5350,9416841.12548828; 5351,9416664.12353516; 5352,9416605.37719727; 5353,9416605.37719727; 5354,9416605.37719727; 5355,9416605.37719727; 5356,9412651.06201172; 5357,
        9412167.35839844; 5358,9412167.35839844; 5359,9411531.06689453; 5360,9411393.73779297; 5361,9411393.73779297; 5362,9408534.24072266; 5363,9408534.24072266; 5364,9408534.24072266; 5365,9406087.49389648; 5366,9406087.49389648; 5367,9406087.49389648; 5368,9408534.24072266; 5369,9408534.24072266; 5370,9408534.24072266; 5371,9408534.24072266; 5372,9406087.49389648; 5373,9405356.59790039; 5374,9404982.75756836; 5375,9403667.44995117; 5376,9403667.44995117; 5377,9403667.44995117; 5378,9403667.44995117; 5379,9403433.99047852; 5380,9403343.96362305; 5381,9398999.0234375; 5382,9398999.0234375; 5383,9398999.0234375; 5384,9398999.0234375; 5385,9398999.0234375; 5386,9398999.0234375; 5387,9398999.0234375; 5388,9398999.0234375; 5389,9398999.0234375; 5390,9398999.0234375; 5391,9398999.0234375; 5392,9398999.0234375; 5393,9398999.0234375; 5394,9401273.34594727; 5395,9403433.99047852; 5396,9403433.99047852; 5397,9403433.99047852; 5398,9403433.99047852; 5399,9403433.99047852; 5400,
        9403433.99047852; 5401,9403433.99047852; 5402,9404965.20996094; 5403,9405356.59790039; 5404,9413420.10498047; 5405,9413420.10498047; 5406,9405356.59790039; 5407,9405356.59790039; 5408,9413420.10498047; 5409,9414273.83422852; 5410,9414273.83422852; 5411,9415251.15966797; 5412,9417381.28662109; 5413,9415251.15966797; 5414,9415251.15966797; 5415,9417381.28662109; 5416,9417683.41064453; 5417,9417683.41064453; 5418,9417381.28662109; 5419,9415251.15966797; 5420,9414273.83422852; 5421,9414273.83422852; 5422,9415251.15966797; 5423,9417381.28662109; 5424,9415945.43457031; 5425,9415251.15966797; 5426,9415251.15966797; 5427,9415251.15966797; 5428,9415251.15966797; 5429,9415251.15966797; 5430,9415251.15966797; 5431,9415251.15966797; 5432,9415251.15966797; 5433,9415945.43457031; 5434,9417381.28662109; 5435,9417381.28662109; 5436,9417381.28662109; 5437,9417683.41064453; 5438,9418085.47973633; 5439,9419413.75732422; 5440,9421016.69311523; 5441,9421016.69311523; 5442,9419413.75732422; 5443,
        9417683.41064453; 5444,9415945.43457031; 5445,9415251.15966797; 5446,9414273.83422852; 5447,9414273.83422852; 5448,9414273.83422852; 5449,9414273.83422852; 5450,9414273.83422852; 5451,9414273.83422852; 5452,9414273.83422852; 5453,9414273.83422852; 5454,9414273.83422852; 5455,9414273.83422852; 5456,9415945.43457031; 5457,9415945.43457031; 5458,9415945.43457031; 5459,9418855.28564453; 5460,9421016.69311523; 5461,9421016.69311523; 5462,9421016.69311523; 5463,9419716.64428711; 5464,9418855.28564453; 5465,9415945.43457031; 5466,9415945.43457031; 5467,9414273.83422852; 5468,9413449.09667969; 5469,9413420.10498047; 5470,9413077.54516602; 5471,9412892.15087891; 5472,9411595.91674805; 5473,9411595.91674805; 5474,9410239.41040039; 5475,9410239.41040039; 5476,9410239.41040039; 5477,9410239.41040039; 5478,9410239.41040039; 5479,9410239.41040039; 5480,9411595.91674805; 5481,9412856.29272461; 5482,9412856.29272461; 5483,9412856.29272461; 5484,9412856.29272461; 5485,9412856.29272461; 5486,
        9412856.29272461; 5487,9412856.29272461; 5488,9412892.15087891; 5489,9412892.15087891; 5490,9412856.29272461; 5491,9412104.03442383; 5492,9412104.03442383; 5493,9412856.29272461; 5494,9412892.15087891; 5495,9412892.15087891; 5496,9412856.29272461; 5497,9412856.29272461; 5498,9412856.29272461; 5499,9412104.03442383; 5500,9412104.03442383; 5501,9412856.29272461; 5502,9412892.15087891; 5503,9413449.09667969; 5504,9414014.43481445; 5505,9417677.30712891; 5506,9418855.28564453; 5507,9419716.64428711; 5508,9419716.64428711; 5509,9418855.28564453; 5510,9419716.64428711; 5511,9419758.60595703; 5512,9419758.60595703; 5513,9419758.60595703; 5514,9419716.64428711; 5515,9418855.28564453; 5516,9417677.30712891; 5517,9417677.30712891; 5518,9417677.30712891; 5519,9417677.30712891; 5520,9417677.30712891; 5521,9417677.30712891; 5522,9417677.30712891; 5523,9417677.30712891; 5524,9418855.28564453; 5525,9419716.64428711; 5526,9419716.64428711; 5527,9419716.64428711; 5528,9419716.64428711; 5529,
        9419716.64428711; 5530,9419716.64428711; 5531,9418855.28564453; 5532,9418855.28564453; 5533,9418855.28564453; 5534,9417677.30712891; 5535,9417080.68847656; 5536,9417080.68847656; 5537,9417080.68847656; 5538,9414941.40625; 5539,9414941.40625; 5540,9414941.40625; 5541,9417080.68847656; 5542,9417677.30712891; 5543,9417677.30712891; 5544,9417677.30712891; 5545,9417677.30712891; 5546,9419052.88696289; 5547,9419188.69018555; 5548,9419414.52026367; 5549,9419758.60595703; 5550,9419758.60595703; 5551,9419758.60595703; 5552,9419758.60595703; 5553,9419758.60595703; 5554,9419758.60595703; 5555,9419758.60595703; 5556,9419758.60595703; 5557,9419414.52026367; 5558,9419188.69018555; 5559,9419052.88696289; 5560,9419052.88696289; 5561,9419052.88696289; 5562,9419052.88696289; 5563,9419188.69018555; 5564,9419414.52026367; 5565,9419758.60595703; 5566,9420326.23291016; 5567,9420326.23291016; 5568,9420326.23291016; 5569,9420326.23291016; 5570,9420946.50268555; 5571,9420946.50268555; 5572,
        9420326.23291016; 5573,9420326.23291016; 5574,9420326.23291016; 5575,9420326.23291016; 5576,9420326.23291016; 5577,9420946.50268555; 5578,9421900.17700195; 5579,9421900.17700195; 5580,9421900.17700195; 5581,9421900.17700195; 5582,9421900.17700195; 5583,9421900.17700195; 5584,9424492.64526367; 5585,9426700.59204102; 5586,9424492.64526367; 5587,9421900.17700195; 5588,9419414.52026367; 5589,9419414.52026367; 5590,9421900.17700195; 5591,9424492.64526367; 5592,9426700.59204102; 5593,9426799.77416992; 5594,9427577.97241211; 5595,9427816.00952148; 5596,9427948.76098633; 5597,9428318.78662109; 5598,9428689.57519531; 5599,9428689.57519531; 5600,9428689.57519531; 5601,9428689.57519531; 5602,9428689.57519531; 5603,9428829.95605469; 5604,9428829.95605469; 5605,9428829.95605469; 5606,9428829.95605469; 5607,9428829.95605469; 5608,9428829.95605469; 5609,9428829.95605469; 5610,9428831.48193359; 5611,9428831.48193359; 5612,9429423.52294922; 5613,9430499.26757813; 5614,9430499.26757813; 5615,
        9431576.53808594; 5616,9434875.48828125; 5617,9436138.91601563; 5618,9437062.07275391; 5619,9437062.07275391; 5620,9437062.07275391; 5621,9437062.07275391; 5622,9436138.91601563; 5623,9434875.48828125; 5624,9431576.53808594; 5625,9431576.53808594; 5626,9431576.53808594; 5627,9431576.53808594; 5628,9431576.53808594; 5629,9430499.26757813; 5630,9430499.26757813; 5631,9429566.95556641; 5632,9430499.26757813; 5633,9430499.26757813; 5634,9434875.48828125; 5635,9436138.91601563; 5636,9436138.91601563; 5637,9436138.91601563; 5638,9441325.37841797; 5639,9441706.08520508; 5640,9441706.08520508; 5641,9441706.08520508; 5642,9441706.08520508; 5643,9441706.08520508; 5644,9441706.08520508; 5645,9441706.08520508; 5646,9442259.21630859; 5647,9443196.10595703; 5648,9444308.47167969; 5649,9444464.87426758; 5650,9444679.26025391; 5651,9445050.04882813; 5652,9445050.04882813; 5653,9444679.26025391; 5654,9444464.87426758; 5655,9444308.47167969; 5656,9443196.10595703; 5657,9443196.10595703; 5658,
        9443196.10595703; 5659,9443196.10595703; 5660,9443220.52001953; 5661,9444308.47167969; 5662,9444464.87426758; 5663,9444679.26025391; 5664,9445050.04882813; 5665,9445420.83740234; 5666,9445420.83740234; 5667,9445420.83740234; 5668,9445420.83740234; 5669,9445953.36914063; 5670,9446114.34936523; 5671,9446114.34936523; 5672,9446114.34936523; 5673,9446114.34936523; 5674,9446114.34936523; 5675,9446114.34936523; 5676,9446114.34936523; 5677,9447573.08959961; 5678,9449746.70410156; 5679,9449746.70410156; 5680,9449746.70410156; 5681,9455999.75585938; 5682,9455999.75585938; 5683,9457525.63476563; 5684,9457525.63476563; 5685,9456638.33618164; 5686,9456638.33618164; 5687,9457525.63476563; 5688,9458040.61889648; 5689,9458040.61889648; 5690,9458040.61889648; 5691,9458040.61889648; 5692,9458040.61889648; 5693,9458040.61889648; 5694,9458040.61889648; 5695,9458040.61889648; 5696,9458040.61889648; 5697,9458040.61889648; 5698,9458040.61889648; 5699,9458040.61889648; 5700,9456638.33618164; 5701,
        9455999.75585938; 5702,9455999.75585938; 5703,9455999.75585938; 5704,9455999.75585938; 5705,9456638.33618164; 5706,9456638.33618164; 5707,9458040.61889648; 5708,9458040.61889648; 5709,9456638.33618164; 5710,9456638.33618164; 5711,9456638.33618164; 5712,9456638.33618164; 5713,9456638.33618164; 5714,9455999.75585938; 5715,9455999.75585938; 5716,9455999.75585938; 5717,9455999.75585938; 5718,9455999.75585938; 5719,9455999.75585938; 5720,9454974.36523438; 5721,9450292.20581055; 5722,9450292.20581055; 5723,9448587.03613281; 5724,9446058.65478516; 5725,9443829.34570313; 5726,9443721.00830078; 5727,9443220.52001953; 5728,9443220.52001953; 5729,9443721.00830078; 5730,9443829.34570313; 5731,9445882.41577148; 5732,9446058.65478516; 5733,9445882.41577148; 5734,9443829.34570313; 5735,9443721.00830078; 5736,9442841.33911133; 5737,9442841.33911133; 5738,9442841.33911133; 5739,9441989.13574219; 5740,9441823.57788086; 5741,9441595.45898438; 5742,9434999.08447266; 5743,9434999.08447266; 5744,
        9434931.94580078; 5745,9434931.94580078; 5746,9434931.94580078; 5747,9434931.94580078; 5748,9434931.94580078; 5749,9434561.15722656; 5750,9432834.62524414; 5751,9432344.81811523; 5752,9430960.84594727; 5753,9427925.10986328; 5754,9427925.10986328; 5755,9427925.10986328; 5756,9427925.10986328; 5757,9427545.16601563; 5758,9427312.46948242; 5759,9426820.37353516; 5760,9426165.77148438; 5761,9425942.23022461; 5762,9424549.1027832; 5763,9424499.51171875; 5764,9424499.51171875; 5765,9424499.51171875; 5766,9424499.51171875; 5767,9424499.51171875; 5768,9421289.0625; 5769,9421085.35766602; 5770,9421085.35766602; 5771,9419693.75610352; 5772,9418630.98144531; 5773,9418156.43310547; 5774,9418156.43310547; 5775,9417698.66943359; 5776,9414935.30273438; 5777,9414935.30273438; 5778,9414935.30273438; 5779,9414935.30273438; 5780,9412847.13745117; 5781,9412413.02490234; 5782,9410301.97143555; 5783,9410301.97143555; 5784,9409816.74194336; 5785,9409816.74194336; 5786,9408371.73461914; 5787,
        9408293.15185547; 5788,9407538.60473633; 5789,9406901.55029297; 5790,9406901.55029297; 5791,9406468.20068359; 5792,9404470.82519531; 5793,9402003.47900391; 5794,9404470.82519531; 5795,9406468.20068359; 5796,9406901.55029297; 5797,9406901.55029297; 5798,9406468.20068359; 5799,9406468.20068359; 5800,9406468.20068359; 5801,9406468.20068359; 5802,9404470.82519531; 5803,9401998.90136719; 5804,9401998.90136719; 5805,9401998.90136719; 5806,9399505.61523438; 5807,9397481.53686523; 5808,9397431.94580078; 5809,9396895.59936523; 5810,9396134.18579102; 5811,9394811.2487793; 5812,9393566.89453125; 5813,9393367.76733398; 5814,9393367.76733398; 5815,9393367.76733398; 5816,9393367.76733398; 5817,9393367.76733398; 5818,9393367.76733398; 5819,9393367.76733398; 5820,9393164.0625; 5821,9392597.96142578; 5822,9391932.67822266; 5823,9391356.65893555; 5824,9391253.66210938; 5825,9391071.31958008; 5826,9391071.31958008; 5827,9391071.31958008; 5828,9390991.2109375; 5829,9387824.24926758; 5830,
        9387735.74829102; 5831,9386826.32446289; 5832,9386008.45336914; 5833,9386008.45336914; 5834,9386008.45336914; 5835,9387735.74829102; 5836,9387735.74829102; 5837,9386008.45336914; 5838,9385947.41821289; 5839,9385947.41821289; 5840,9385947.41821289; 5841,9386008.45336914; 5842,9386008.45336914; 5843,9385947.41821289; 5844,9385607.91015625; 5845,9384078.97949219; 5846,9383982.08618164; 5847,9383813.4765625; 5848,9383775.32958984; 5849,9383498.38256836; 5850,9383416.74804688; 5851,9381509.39941406; 5852,9381324.00512695; 5853,9381033.32519531; 5854,9378127.28881836; 5855,9378127.28881836; 5856,9378127.28881836; 5857,9376270.29418945; 5858,9372944.64111328; 5859,9370646.66748047; 5860,9370646.66748047; 5861,9370646.66748047; 5862,9370646.66748047; 5863,9370646.66748047; 5864,9370646.66748047; 5865,9370646.66748047; 5866,9372944.64111328; 5867,9376270.29418945; 5868,9376270.29418945; 5869,9376270.29418945; 5870,9376270.29418945; 5871,9376270.29418945; 5872,9374460.60180664; 5873,
        9372944.64111328; 5874,9370646.66748047; 5875,9370646.66748047; 5876,9372944.64111328; 5877,9374460.60180664; 5878,9376270.29418945; 5879,9376270.29418945; 5880,9376963.80615234; 5881,9378127.28881836; 5882,9378127.28881836; 5883,9376963.80615234; 5884,9376963.80615234; 5885,9377902.98461914; 5886,9378127.28881836; 5887,9378647.61352539; 5888,9378127.28881836; 5889,9377902.98461914; 5890,9376963.80615234; 5891,9376554.87060547; 5892,9376963.80615234; 5893,9376963.80615234; 5894,9376963.80615234; 5895,9376554.87060547; 5896,9376554.87060547; 5897,9376963.80615234; 5898,9377902.98461914; 5899,9377902.98461914; 5900,9377902.98461914; 5901,9377902.98461914; 5902,9377902.98461914; 5903,9377902.98461914; 5904,9377902.98461914; 5905,9377902.98461914; 5906,9377902.98461914; 5907,9378647.61352539; 5908,9378647.61352539; 5909,9378647.61352539; 5910,9378647.61352539; 5911,9379377.74658203; 5912,9380739.59350586; 5913,9379377.74658203; 5914,9378647.61352539; 5915,9377902.98461914; 5916,
        9376963.80615234; 5917,9376963.80615234; 5918,9377902.98461914; 5919,9378018.95141602; 5920,9378647.61352539; 5921,9379377.74658203; 5922,9379377.74658203; 5923,9379377.74658203; 5924,9379377.74658203; 5925,9379377.74658203; 5926,9379377.74658203; 5927,9379377.74658203; 5928,9379377.74658203; 5929,9379377.74658203; 5930,9379377.74658203; 5931,9379377.74658203; 5932,9380739.59350586; 5933,9381895.44677734; 5934,9382132.72094727; 5935,9382132.72094727; 5936,9382132.72094727; 5937,9382132.72094727; 5938,9382132.72094727; 5939,9382132.72094727; 5940,9382132.72094727; 5941,9382132.72094727; 5942,9382132.72094727; 5943,9382132.72094727; 5944,9382132.72094727; 5945,9382132.72094727; 5946,9382132.72094727; 5947,9385771.17919922; 5948,9386942.29125977; 5949,9386942.29125977; 5950,9386942.29125977; 5951,9386942.29125977; 5952,9385771.17919922; 5953,9382132.72094727; 5954,9381895.44677734; 5955,9380739.59350586; 5956,9378787.23144531; 5957,9378787.23144531; 5958,9380739.59350586; 5959,
        9380739.59350586; 5960,9380739.59350586; 5961,9381895.44677734; 5962,9382132.72094727; 5963,9382132.72094727; 5964,9382132.72094727; 5965,9385771.17919922; 5966,9386942.29125977; 5967,9387074.27978516; 5968,9387074.27978516; 5969,9386942.29125977; 5970,9386942.29125977; 5971,9386942.29125977; 5972,9385771.17919922; 5973,9385771.17919922; 5974,9385771.17919922; 5975,9381895.44677734; 5976,9379717.25463867; 5977,9378787.23144531; 5978,9378018.95141602; 5979,9378787.23144531; 5980,9379717.25463867; 5981,9379717.25463867; 5982,9379119.11010742; 5983,9378787.23144531; 5984,9378018.95141602; 5985,9378018.95141602; 5986,9378018.95141602; 5987,9378018.95141602; 5988,9378787.23144531; 5989,9378787.23144531; 5990,9378787.23144531; 5991,9378787.23144531; 5992,9378787.23144531; 5993,9377891.54052734; 5994,9377033.99658203; 5995,9376985.16845703; 5996,9376356.50634766; 5997,9376356.50634766; 5998,9376985.16845703; 5999,9377033.99658203; 6000,9377033.99658203; 6001,9377033.99658203; 6002,
        9377033.99658203; 6003,9377033.99658203; 6004,9377033.99658203; 6005,9377033.99658203; 6006,9376985.16845703; 6007,9376356.50634766; 6008,9372025.29907227; 6009,9372025.29907227; 6010,9372025.29907227; 6011,9369028.47290039; 6012,9363581.84814453; 6013,9361560.8215332; 6014,9361213.68408203; 6015,9359999.08447266; 6016,9359999.08447266; 6017,9359991.45507813; 6018,9358836.36474609; 6019,9358628.08227539; 6020,9358315.27709961; 6021,9357477.56958008; 6022,9355314.63623047; 6023,9348928.83300781; 6024,9348603.05786133; 6025,9348169.70825195; 6026,9347947.69287109; 6027,9345922.8515625; 6028,9345922.8515625; 6029,9345922.8515625; 6030,9345922.8515625; 6031,9345922.8515625; 6032,9345034.02709961; 6033,9344348.14453125; 6034,9343941.49780273; 6035,9343801.11694336; 6036,9343309.02099609; 6037,9342997.74169922; 6038,9340112.3046875; 6039,9339497.37548828; 6040,9337007.14111328; 6041,9337007.14111328; 6042,9335765.83862305; 6043,9332559.96704102; 6044,9331295.77636719; 6045,
        9328974.91455078; 6046,9326391.6015625; 6047,9323065.18554688; 6048,9320863.34228516; 6049,9318721.00830078; 6050,9317638.3972168; 6051,9316236.87744141; 6052,9316236.87744141; 6053,9316194.91577148; 6054,9315049.74365234; 6055,9313924.40795898; 6056,9313924.40795898; 6057,9313924.40795898; 6058,9313924.40795898; 6059,9313924.40795898; 6060,9313924.40795898; 6061,9313924.40795898; 6062,9312477.87475586; 6063,9309538.26904297; 6064,9309538.26904297; 6065,9309538.26904297; 6066,9309538.26904297; 6067,9309538.26904297; 6068,9309538.26904297; 6069,9309538.26904297; 6070,9309538.26904297; 6071,9309180.45043945; 6072,9307659.91210938; 6073,9307048.03466797; 6074,9306387.32910156; 6075,9305572.50976563; 6076,9306387.32910156; 6077,9307048.03466797; 6078,9306387.32910156; 6079,9305572.50976563; 6080,9305160.52246094; 6081,9305160.52246094; 6082,9305572.50976563; 6083,9305572.50976563; 6084,9305572.50976563; 6085,9305160.52246094; 6086,9304645.53833008; 6087,9304553.9855957; 6088,
        9304285.4309082; 6089,9304285.4309082; 6090,9304285.4309082; 6091,9304285.4309082; 6092,9302060.69946289; 6093,9300997.16186523; 6094,9300997.16186523; 6095,9302060.69946289; 6096,9302060.69946289; 6097,9302060.69946289; 6098,9304285.4309082; 6099,9304553.9855957; 6100,9304645.53833008; 6101,9304645.53833008; 6102,9304645.53833008; 6103,9304645.53833008; 6104,9304645.53833008; 6105,9304553.9855957; 6106,9304553.9855957; 6107,9304553.9855957; 6108,9304285.4309082; 6109,9304285.4309082; 6110,9304285.4309082; 6111,9304285.4309082; 6112,9304285.4309082; 6113,9304553.9855957; 6114,9304553.9855957; 6115,9304285.4309082; 6116,9302060.69946289; 6117,9301073.45581055; 6118,9300997.16186523; 6119,9300997.16186523; 6120,9300997.16186523; 6121,9300640.86914063; 6122,9297922.51586914; 6123,9297334.28955078; 6124,9295252.99072266; 6125,9295252.99072266; 6126,9295252.99072266; 6127,9295252.99072266; 6128,9295252.99072266; 6129,9297334.28955078; 6130,9297334.28955078; 6131,9295252.99072266;
        6132,9293945.3125; 6133,9293945.3125; 6134,9291547.39379883; 6135,9291547.39379883; 6136,9291547.39379883; 6137,9291547.39379883; 6138,9293945.3125; 6139,9293945.3125; 6140,9291547.39379883; 6141,9291547.39379883; 6142,9291547.39379883; 6143,9291547.39379883; 6144,9291547.39379883; 6145,9291547.39379883; 6146,9291547.39379883; 6147,9291547.39379883; 6148,9291547.39379883; 6149,9293945.3125; 6150,9295252.99072266; 6151,9295252.99072266; 6152,9295252.99072266; 6153,9297334.28955078; 6154,9300640.86914063; 6155,9301073.45581055; 6156,9301073.45581055; 6157,9301073.45581055; 6158,9301073.45581055; 6159,9301073.45581055; 6160,9301073.45581055; 6161,9305152.13012695; 6162,9305403.90014648; 6163,9305403.90014648; 6164,9305403.90014648; 6165,9306027.98461914; 6166,9306604.00390625; 6167,9308262.63427734; 6168,9308262.63427734; 6169,9309278.86962891; 6170,9310235.59570313; 6171,9310294.34204102; 6172,9310598.75488281; 6173,9310598.75488281; 6174,9310294.34204102; 6175,9310235.59570313;
        6176,9310235.59570313; 6177,9310235.59570313; 6178,9310235.59570313; 6179,9310294.34204102; 6180,9310598.75488281; 6181,9311634.82666016; 6182,9312813.56811523; 6183,9313561.2487793; 6184,9313793.18237305; 6185,9313927.4597168; 6186,9314772.03369141; 6187,9314837.64648438; 6188,9318830.10864258; 6189,9319366.45507813; 6190,9321121.21582031; 6191,9328129.57763672; 6192,9329350.28076172; 6193,9331145.47729492; 6194,9331599.42626953; 6195,9336461.6394043; 6196,9337484.74121094; 6197,9337484.74121094; 6198,9337484.74121094; 6199,9337484.74121094; 6200,9338949.58496094; 6201,9339603.42407227; 6202,9339603.42407227; 6203,9339603.42407227; 6204,9339603.42407227; 6205,9339603.42407227; 6206,9341458.89282227; 6207,9342003.6315918; 6208,9343499.75585938; 6209,9343499.75585938; 6210,9343499.75585938; 6211,9343572.99804688; 6212,9343572.99804688; 6213,9343572.99804688; 6214,9343572.99804688; 6215,9343572.99804688; 6216,9343572.99804688; 6217,9343499.75585938; 6218,9343499.75585938; 6219,
        9343499.75585938; 6220,9343499.75585938; 6221,9343499.75585938; 6222,9343499.75585938; 6223,9343499.75585938; 6224,9343499.75585938; 6225,9345497.13134766; 6226,9345497.13134766; 6227,9345497.13134766; 6228,9345497.13134766; 6229,9343499.75585938; 6230,9343499.75585938; 6231,9343499.75585938; 6232,9342003.6315918; 6233,9341458.89282227; 6234,9341458.89282227; 6235,9342003.6315918; 6236,9343499.75585938; 6237,9343499.75585938; 6238,9343499.75585938; 6239,9343499.75585938; 6240,9343499.75585938; 6241,9343499.75585938; 6242,9343499.75585938; 6243,9343499.75585938; 6244,9343499.75585938; 6245,9343499.75585938; 6246,9343499.75585938; 6247,9343499.75585938; 6248,9343499.75585938; 6249,9343499.75585938; 6250,9343586.73095703; 6251,9345497.13134766; 6252,9347444.15283203; 6253,9347444.15283203; 6254,9347444.15283203; 6255,9347444.15283203; 6256,9347444.15283203; 6257,9349383.54492188; 6258,9349383.54492188; 6259,9352432.25097656; 6260,9349383.54492188; 6261,9348017.12036133; 6262,
        9348017.12036133; 6263,9349383.54492188; 6264,9352432.25097656; 6265,9352432.25097656; 6266,9352432.25097656; 6267,9352432.25097656; 6268,9352432.25097656; 6269,9352432.25097656; 6270,9352432.25097656; 6271,9353997.80273438; 6272,9356098.17504883; 6273,9356098.17504883; 6274,9356098.17504883; 6275,9353997.80273438; 6276,9353997.80273438; 6277,9356098.17504883; 6278,9356098.17504883; 6279,9356098.17504883; 6280,9358220.67260742; 6281,9360863.49487305; 6282,9361228.17993164; 6283,9362247.46704102; 6284,9363610.83984375; 6285,9363610.83984375; 6286,9363610.83984375; 6287,9363629.91333008; 6288,9363629.91333008; 6289,9363629.91333008; 6290,9365534.97314453; 6291,9367253.11279297; 6292,9367913.81835938; 6293,9368199.15771484; 6294,9368403.62548828; 6295,9368893.43261719; 6296,9370828.24707031; 6297,9368893.43261719; 6298,9368403.62548828; 6299,9368403.62548828; 6300,9400000; 9499,9400000; 9500,9386008.45336914; 9501,9387735.74829102; 9502,9387735.74829102; 9503,9386008.45336914;
        9504,9385947.41821289; 9505,9385947.41821289; 9506,9385947.41821289; 9507,9386008.45336914; 9508,9386008.45336914; 9509,9385947.41821289; 9510,9385607.91015625; 9511,9384078.97949219; 9512,9383982.08618164; 9513,9383813.4765625; 9514,9383775.32958984; 9515,9383498.38256836; 9516,9383416.74804688; 9517,9381509.39941406; 9518,9381324.00512695; 9519,9381033.32519531; 9520,9378127.28881836; 9521,9378127.28881836; 9522,9378127.28881836; 9523,9376270.29418945; 9524,9372944.64111328; 9525,9370646.66748047; 9526,9370646.66748047; 9527,9370646.66748047; 9528,9370646.66748047; 9529,9370646.66748047; 9530,9370646.66748047; 9531,9370646.66748047; 9532,9372944.64111328; 9533,9376270.29418945; 9534,9376270.29418945; 9535,9376270.29418945; 9536,9376270.29418945; 9537,9376270.29418945; 9538,9374460.60180664; 9539,9372944.64111328; 9540,9370646.66748047; 9541,9370646.66748047; 9542,9372944.64111328; 9543,9374460.60180664; 9544,9376270.29418945; 9545,9376270.29418945; 9546,9376963.80615234;
        9547,9378127.28881836; 9548,9378127.28881836; 9549,9376963.80615234; 9550,9376963.80615234; 9551,9377902.98461914; 9552,9378127.28881836; 9553,9378647.61352539; 9554,9378127.28881836; 9555,9377902.98461914; 9556,9376963.80615234; 9557,9376554.87060547; 9558,9376963.80615234; 9559,9376963.80615234; 9560,9376963.80615234; 9561,9376554.87060547; 9562,9376554.87060547; 9563,9376963.80615234; 9564,9377902.98461914; 9565,9377902.98461914; 9566,9377902.98461914; 9567,9377902.98461914; 9568,9377902.98461914; 9569,9377902.98461914; 9570,9377902.98461914; 9571,9377902.98461914; 9572,9377902.98461914; 9573,9378647.61352539; 9574,9378647.61352539; 9575,9378647.61352539; 9576,9378647.61352539; 9577,9379377.74658203; 9578,9380739.59350586; 9579,9379377.74658203; 9580,9378647.61352539; 9581,9377902.98461914; 9582,9376963.80615234; 9583,9376963.80615234; 9584,9377902.98461914; 9585,9378018.95141602; 9586,9378647.61352539; 9587,9379377.74658203; 9588,9379377.74658203; 9589,9379377.74658203;
        9590,9379377.74658203; 9591,9379377.74658203; 9592,9379377.74658203; 9593,9379377.74658203; 9594,9379377.74658203; 9595,9379377.74658203; 9596,9379377.74658203; 9597,9379377.74658203; 9598,9380739.59350586; 9599,9381895.44677734; 9600,9382132.72094727; 9601,9382132.72094727; 9602,9382132.72094727; 9603,9382132.72094727; 9604,9382132.72094727; 9605,9382132.72094727; 9606,9382132.72094727; 9607,9382132.72094727; 9608,9382132.72094727; 9609,9382132.72094727; 9610,9382132.72094727; 9611,9382132.72094727; 9612,9382132.72094727; 9613,9385771.17919922; 9614,9386942.29125977; 9615,9386942.29125977; 9616,9386942.29125977; 9617,9386942.29125977; 9618,9385771.17919922; 9619,9382132.72094727; 9620,9381895.44677734; 9621,9380739.59350586; 9622,9378787.23144531; 9623,9378787.23144531; 9624,9380739.59350586; 9625,9380739.59350586; 9626,9380739.59350586; 9627,9381895.44677734; 9628,9382132.72094727; 9629,9382132.72094727; 9630,9382132.72094727; 9631,9385771.17919922; 9632,9386942.29125977;
        9633,9387074.27978516; 9634,9387074.27978516; 9635,9386942.29125977; 9636,9386942.29125977; 9637,9386942.29125977; 9638,9385771.17919922; 9639,9385771.17919922; 9640,9385771.17919922; 9641,9381895.44677734; 9642,9379717.25463867; 9643,9378787.23144531; 9644,9378018.95141602; 9645,9378787.23144531; 9646,9379717.25463867; 9647,9379717.25463867; 9648,9379119.11010742; 9649,9378787.23144531; 9650,9378018.95141602; 9651,9378018.95141602; 9652,9378018.95141602; 9653,9378018.95141602; 9654,9378787.23144531; 9655,9378787.23144531; 9656,9378787.23144531; 9657,9378787.23144531; 9658,9378787.23144531; 9659,9377891.54052734; 9660,9377033.99658203; 9661,9376985.16845703; 9662,9376356.50634766; 9663,9376356.50634766; 9664,9376985.16845703; 9665,9377033.99658203; 9666,9377033.99658203; 9667,9377033.99658203; 9668,9377033.99658203; 9669,9377033.99658203; 9670,9377033.99658203; 9671,9377033.99658203; 9672,9376985.16845703; 9673,9376356.50634766; 9674,9372025.29907227; 9675,9372025.29907227;
        9676,9372025.29907227; 9677,9369028.47290039; 9678,9363581.84814453; 9679,9361560.8215332; 9680,9361213.68408203; 9681,9359999.08447266; 9682,9359999.08447266; 9683,9359991.45507813; 9684,9358836.36474609; 9685,9358628.08227539; 9686,9358315.27709961; 9687,9357477.56958008; 9688,9355314.63623047; 9689,9348928.83300781; 9690,9348603.05786133; 9691,9348169.70825195; 9692,9347947.69287109; 9693,9345922.8515625; 9694,9345922.8515625; 9695,9345922.8515625; 9696,9345922.8515625; 9697,9345922.8515625; 9698,9345034.02709961; 9699,9344348.14453125; 9700,9343941.49780273; 9701,9343801.11694336; 9702,9343309.02099609; 9703,9342997.74169922; 9704,9340112.3046875; 9705,9339497.37548828; 9706,9337007.14111328; 9707,9337007.14111328; 9708,9335765.83862305; 9709,9332559.96704102; 9710,9331295.77636719; 9711,9328974.91455078; 9712,9326391.6015625; 9713,9323065.18554688; 9714,9320863.34228516; 9715,9318721.00830078; 9716,9317638.3972168; 9717,9316236.87744141; 9718,9316236.87744141; 9719,
        9316194.91577148; 9720,9315049.74365234; 9721,9313924.40795898; 9722,9313924.40795898; 9723,9313924.40795898; 9724,9313924.40795898; 9725,9313924.40795898; 9726,9313924.40795898; 9727,9313924.40795898; 9728,9312477.87475586; 9729,9309538.26904297; 9730,9309538.26904297; 9731,9309538.26904297; 9732,9309538.26904297; 9733,9309538.26904297; 9734,9309538.26904297; 9735,9309538.26904297; 9736,9309538.26904297; 9737,9309180.45043945; 9738,9307659.91210938; 9739,9307048.03466797; 9740,9306387.32910156; 9741,9305572.50976563; 9742,9306387.32910156; 9743,9307048.03466797; 9744,9306387.32910156; 9745,9305572.50976563; 9746,9305160.52246094; 9747,9305160.52246094; 9748,9305572.50976563; 9749,9305572.50976563; 9750,9305572.50976563; 9751,9305160.52246094; 9752,9304645.53833008; 9753,9304553.9855957; 9754,9304285.4309082; 9755,9304285.4309082; 9756,9304285.4309082; 9757,9304285.4309082; 9758,9302060.69946289; 9759,9300997.16186523; 9760,9300997.16186523; 9761,9302060.69946289; 9762,
        9302060.69946289; 9763,9302060.69946289; 9764,9304285.4309082; 9765,9304553.9855957; 9766,9304645.53833008; 9767,9304645.53833008; 9768,9304645.53833008; 9769,9304645.53833008; 9770,9304645.53833008; 9771,9304553.9855957; 9772,9304553.9855957; 9773,9304553.9855957; 9774,9304285.4309082; 9775,9304285.4309082; 9776,9304285.4309082; 9777,9304285.4309082; 9778,9304285.4309082; 9779,9304553.9855957; 9780,9304553.9855957; 9781,9304285.4309082; 9782,9302060.69946289; 9783,9301073.45581055; 9784,9300997.16186523; 9785,9300997.16186523; 9786,9300997.16186523; 9787,9300640.86914063; 9788,9297922.51586914; 9789,9297334.28955078; 9790,9295252.99072266; 9791,9295252.99072266; 9792,9295252.99072266; 9793,9295252.99072266; 9794,9295252.99072266; 9795,9297334.28955078; 9796,9297334.28955078; 9797,9295252.99072266; 9798,9293945.3125; 9799,9293945.3125; 9800,9291547.39379883; 9801,9291547.39379883; 9802,9291547.39379883; 9803,9291547.39379883; 9804,9293945.3125; 9805,9293945.3125; 9806,
        9291547.39379883; 9807,9291547.39379883; 9808,9291547.39379883; 9809,9291547.39379883; 9810,9291547.39379883; 9811,9291547.39379883; 9812,9291547.39379883; 9813,9291547.39379883; 9814,9291547.39379883; 9815,9293945.3125; 9816,9295252.99072266; 9817,9295252.99072266; 9818,9295252.99072266; 9819,9297334.28955078; 9820,9300640.86914063; 9821,9301073.45581055; 9822,9301073.45581055; 9823,9301073.45581055; 9824,9301073.45581055; 9825,9301073.45581055; 9826,9301073.45581055; 9827,9305152.13012695; 9828,9305403.90014648; 9829,9305403.90014648; 9830,9305403.90014648; 9831,9306027.98461914; 9832,9306604.00390625; 9833,9308262.63427734; 9834,9308262.63427734; 9835,9309278.86962891; 9836,9310235.59570313; 9837,9310294.34204102; 9838,9310598.75488281; 9839,9310598.75488281; 9840,9310294.34204102; 9841,9310235.59570313; 9842,9310235.59570313; 9843,9310235.59570313; 9844,9310235.59570313; 9845,9310294.34204102; 9846,9310598.75488281; 9847,9311634.82666016; 9848,9312813.56811523; 9849,
        9313561.2487793; 9850,9313793.18237305; 9851,9313927.4597168; 9852,9314772.03369141; 9853,9314837.64648438; 9854,9318830.10864258; 9855,9319366.45507813; 9856,9321121.21582031; 9857,9328129.57763672; 9858,9329350.28076172; 9859,9331145.47729492; 9860,9331599.42626953; 9861,9336461.6394043; 9862,9337484.74121094; 9863,9337484.74121094; 9864,9337484.74121094; 9865,9337484.74121094; 9866,9338949.58496094; 9867,9339603.42407227; 9868,9339603.42407227; 9869,9339603.42407227; 9870,9339603.42407227; 9871,9339603.42407227; 9872,9341458.89282227; 9873,9342003.6315918; 9874,9343499.75585938; 9875,9343499.75585938; 9876,9343499.75585938; 9877,9343572.99804688; 9878,9343572.99804688; 9879,9343572.99804688; 9880,9343572.99804688; 9881,9343572.99804688; 9882,9343572.99804688; 9883,9343499.75585938; 9884,9343499.75585938; 9885,9343499.75585938; 9886,9343499.75585938; 9887,9343499.75585938; 9888,9343499.75585938; 9889,9343499.75585938; 9890,9343499.75585938; 9891,9345497.13134766; 9892,
        9345497.13134766; 9893,9345497.13134766; 9894,9345497.13134766; 9895,9343499.75585938; 9896,9343499.75585938; 9897,9343499.75585938; 9898,9342003.6315918; 9899,9341458.89282227; 9900,9341458.89282227; 9901,9342003.6315918; 9902,9343499.75585938; 9903,9343499.75585938; 9904,9343499.75585938; 9905,9343499.75585938; 9906,9343499.75585938; 9907,9343499.75585938; 9908,9343499.75585938; 9909,9343499.75585938; 9910,9343499.75585938; 9911,9343499.75585938; 9912,9343499.75585938; 9913,9343499.75585938; 9914,9343499.75585938; 9915,9343499.75585938; 9916,9343586.73095703; 9917,9345497.13134766; 9918,9347444.15283203; 9919,9347444.15283203; 9920,9347444.15283203; 9921,9347444.15283203; 9922,9347444.15283203; 9923,9349383.54492188; 9924,9349383.54492188; 9925,9352432.25097656; 9926,9349383.54492188; 9927,9348017.12036133; 9928,9348017.12036133; 9929,9349383.54492188; 9930,9352432.25097656; 9931,9352432.25097656; 9932,9352432.25097656; 9933,9352432.25097656; 9934,9352432.25097656; 9935,
        9352432.25097656; 9936,9352432.25097656; 9937,9353997.80273438; 9938,9356098.17504883; 9939,9356098.17504883; 9940,9356098.17504883; 9941,9353997.80273438; 9942,9353997.80273438; 9943,9356098.17504883; 9944,9356098.17504883; 9945,9356098.17504883; 9946,9358220.67260742; 9947,9360863.49487305; 9948,9361228.17993164; 9949,9362247.46704102; 9950,9363610.83984375; 9951,9363610.83984375; 9952,9363610.83984375; 9953,9363629.91333008; 9954,9363629.91333008; 9955,9363629.91333008; 9956,9365534.97314453; 9957,9367253.11279297; 9958,9367913.81835938; 9959,9368199.15771484; 9960,9368403.62548828; 9961,9368893.43261719; 9962,9370828.24707031; 9963,9368893.43261719; 9964,9368403.62548828; 9965,9368403.62548828; 9966,9368403.62548828; 9967,9368403.62548828; 9968,9368403.62548828; 9969,9368403.62548828; 9970,9368403.62548828; 9971,9368403.62548828; 9972,9368403.62548828; 9973,9368403.62548828; 9974,9368403.62548828; 9975,9368403.62548828; 9976,9368403.62548828; 9977,9368403.62548828; 9978,
        9368199.15771484; 9979,9365534.97314453; 9980,9365534.97314453; 9981,9365534.97314453; 9982,9363629.91333008; 9983,9363629.91333008; 9984,9363629.91333008; 9985,9363629.91333008; 9986,9363629.91333008; 9987,9363629.91333008; 9988,9363610.83984375; 9989,9358220.67260742; 9990,9352432.25097656; 9991,9352277.37426758; 9992,9352228.54614258; 9993,9348017.12036133; 9994,9348017.12036133; 9995,9348017.12036133; 9996,9348017.12036133; 9997,9347085.57128906; 9998,9344750.9765625; 9999,9336589.05029297; 10000,9329927.82592773; 10001,9322116.85180664; 10002,9318421.93603516; 10003,9299822.23510742; 10004,9292004.39453125; 10005,9282611.84692383; 10006,9267821.50268555; 10007,9261891.93725586; 10008,9169763.18359375; 10009,9151751.70898438; 10010,9150282.28759766; 10011,9148812.86621094; 10012,9106532.28759766; 10013,9095999.14550781; 10014,9095999.14550781; 10015,9095999.14550781; 10016,9076498.41308594; 10017,9053541.56494141; 10018,9030584.71679688; 10019,9030194.85473633; 10020,
        9022981.26220703; 10021,9012561.7980957; 10022,9007627.86865234; 10023,8994927.97851563; 10024,8984671.02050781; 10025,8979920.1965332; 10026,8928617.09594727; 10027,8877314.75830078; 10028,8867999.26757813; 10029,8867999.26757813; 10030,8867999.26757813; 10031,8850791.16821289; 10032,8817654.41894531; 10033,8799063.87329102; 10034,8780472.56469727; 10035,8761882.01904297; 10036,8743291.47338867; 10037,8724549.86572266; 10038,8705782.31811523; 10039,8701498.41308594; 10040,8701498.41308594; 10041,8701498.41308594; 10042,8682189.94140625; 10043,8677755.73730469; 10044,8657500.45776367; 10045,8655780.02929688; 10046,8630442.04711914; 10047,8624130.24902344; 10048,8624130.24902344; 10049,8617498.77929688; 10050,8617498.77929688; 10051,8617498.77929688; 10052,8612583.92333984; 10053,8608940.88745117; 10054,8607772.06420898; 10055,8603999.32861328; 10056,8603999.32861328; 10057,8603999.32861328; 10058,8603999.32861328; 10059,8603999.32861328; 10060,8603999.32861328; 10061,
        8603999.32861328; 10062,8603999.32861328; 10063,8603999.32861328; 10064,8603383.63647461; 10065,8602581.78710938; 10066,8600392.91381836; 10067,8599827.57568359; 10068,8597415.16113281; 10069,8594531.25; 10070,8592742.91992188; 10071,8591716.76635742; 10072,8591682.43408203; 10073,8589624.78637695; 10074,8588201.90429688; 10075,8584918.97583008; 10076,8584918.97583008; 10077,8584918.97583008; 10078,8584670.25756836; 10079,8583827.97241211; 10080,8581430.05371094; 10081,8580785.36987305; 10082,8580387.11547852; 10083,8577793.88427734; 10084,8576911.92626953; 10085,8576911.92626953; 10086,8574251.55639648; 10087,8571759.03320313; 10088,8571759.03320313; 10089,8571759.03320313; 10090,8571759.03320313; 10091,8571759.03320313; 10092,8569058.22753906; 10093,8569058.22753906; 10094,8569058.22753906; 10095,8569058.22753906; 10096,8571759.03320313; 10097,8571759.03320313; 10098,8571759.03320313; 10099,8569058.22753906; 10100,8568264.77050781; 10101,8565724.94506836; 10102,
        8562624.35913086; 10103,8562624.35913086; 10104,8562624.35913086; 10105,8562624.35913086; 10106,8562624.35913086; 10107,8561840.8203125; 10108,8561840.8203125; 10109,8561425.01831055; 10110,8561009.21630859; 10111,8561009.21630859; 10112,8561425.01831055; 10113,8561840.8203125; 10114,8561425.01831055; 10115,8561009.21630859; 10116,8560593.41430664; 10117,8560593.41430664; 10118,8560593.41430664; 10119,8560593.41430664; 10120,8560593.41430664; 10121,8560499.57275391; 10122,8560499.57275391; 10123,8560499.57275391; 10124,8560499.57275391; 10125,8560593.41430664; 10126,8560593.41430664; 10127,8561009.21630859; 10128,8561425.01831055; 10129,8561513.51928711; 10130,8561513.51928711; 10131,8561513.51928711; 10132,8561513.51928711; 10133,8561513.51928711; 10134,8561513.51928711; 10135,8561513.51928711; 10136,8561513.51928711; 10137,8561840.8203125; 10138,8561840.8203125; 10139,8561840.8203125; 10140,8561840.8203125; 10141,8561840.8203125; 10142,8561840.8203125; 10143,8561840.8203125;
        10144,8561840.8203125; 10145,8561840.8203125; 10146,8561840.8203125; 10147,8561840.8203125; 10148,8561513.51928711; 10149,8561425.01831055; 10150,8561009.21630859; 10151,8561009.21630859; 10152,8561009.21630859; 10153,8561009.21630859; 10154,8561009.21630859; 10155,8561009.21630859; 10156,8561009.21630859; 10157,8561009.21630859; 10158,8561009.21630859; 10159,8560593.41430664; 10160,8560499.57275391; 10161,8560499.57275391; 10162,8559446.71630859; 10163,8559446.71630859; 10164,8559446.71630859; 10165,8559446.71630859; 10166,8559446.71630859; 10167,8561513.51928711; 10168,8561513.51928711; 10169,8561513.51928711; 10170,8559446.71630859; 10171,8557974.24316406; 10172,8557292.17529297; 10173,8555372.61962891; 10174,8555183.41064453; 10175,8555183.41064453; 10176,8555183.41064453; 10177,8555183.41064453; 10178,8555183.41064453; 10179,8554540.25268555; 10180,8553825.37841797; 10181,8553825.37841797; 10182,8554540.25268555; 10183,8555183.41064453; 10184,8555183.41064453; 10185,
        8555183.41064453; 10186,8555372.61962891; 10187,8555372.61962891; 10188,8555372.61962891; 10189,8557292.17529297; 10190,8558715.05737305; 10191,8559446.71630859; 10192,8559446.71630859; 10193,8566053.77197266; 10194,8567148.59008789; 10195,8568615.72265625; 10196,8568615.72265625; 10197,8567148.59008789; 10198,8567148.59008789; 10199,8567148.59008789; 10200,8568615.72265625; 10201,8569310.76049805; 10202,8568615.72265625; 10203,8567148.59008789; 10204,8565553.28369141; 10205,8562634.27734375; 10206,8558715.05737305; 10207,8555372.61962891; 10208,8555261.23046875; 10209,8555183.41064453; 10210,8555183.41064453; 10211,8555183.41064453; 10212,8555183.41064453; 10213,8555261.23046875; 10214,8555372.61962891; 10215,8558715.05737305; 10216,8562634.27734375; 10217,8562634.27734375; 10218,8562634.27734375; 10219,8562634.27734375; 10220,8562634.27734375; 10221,8562634.27734375; 10222,8562634.27734375; 10223,8562634.27734375; 10224,8565553.28369141; 10225,8567148.59008789; 10226,
        8569310.76049805; 10227,8569310.76049805; 10228,8569310.76049805; 10229,8565553.28369141; 10230,8562634.27734375; 10231,8561897.27783203; 10232,8558715.05737305; 10233,8555261.23046875; 10234,8555261.23046875; 10235,8555261.23046875; 10236,8555261.23046875; 10237,8555261.23046875; 10238,8555261.23046875; 10239,8555261.23046875; 10240,8555183.41064453; 10241,8553552.24609375; 10242,8553020.47729492; 10243,8553020.47729492; 10244,8553552.24609375; 10245,8555261.23046875; 10246,8558715.05737305; 10247,8558715.05737305; 10248,8558715.05737305; 10249,8558715.05737305; 10250,8558715.05737305; 10251,8561897.27783203; 10252,8562634.27734375; 10253,8563080.59692383; 10254,8563327.78930664; 10255,8565553.28369141; 10256,8568915.55786133; 10257,8565553.28369141; 10258,8563327.78930664; 10259,8563327.78930664; 10260,8563327.78930664; 10261,8563080.59692383; 10262,8563080.59692383; 10263,8562634.27734375; 10264,8561897.27783203; 10265,8555261.23046875; 10266,8555168.15185547; 10267,
        8555168.15185547; 10268,8555168.15185547; 10269,8555168.15185547; 10270,8555168.15185547; 10271,8555168.15185547; 10272,8555168.15185547; 10273,8555168.15185547; 10274,8555168.15185547; 10275,8553552.24609375; 10276,8553020.47729492; 10277,8551366.42456055; 10278,8551366.42456055; 10279,8551366.42456055; 10280,8551366.42456055; 10281,8551366.42456055; 10282,8551366.42456055; 10283,8551366.42456055; 10284,8549187.46948242; 10285,8549123.38256836; 10286,8549123.38256836; 10287,8549123.38256836; 10288,8549123.38256836; 10289,8548732.75756836; 10290,8548342.89550781; 10291,8548322.29614258; 10292,8547914.88647461; 10293,8547914.88647461; 10294,8548322.29614258; 10295,8548342.89550781; 10296,8548732.75756836; 10297,8549123.38256836; 10298,8549123.38256836; 10299,8549123.38256836; 10300,8549123.38256836; 10301,8548732.75756836; 10302,8548342.89550781; 10303,8548322.29614258; 10304,8548322.29614258; 10305,8548342.89550781; 10306,8548342.89550781; 10307,8548342.89550781; 10308,
        8548732.75756836; 10309,8549123.38256836; 10310,8551366.42456055; 10311,8554287.71972656; 10312,8554287.71972656; 10313,8551366.42456055; 10314,8550608.82568359; 10315,8550608.82568359; 10316,8550608.82568359; 10317,8550608.82568359; 10318,8548732.75756836; 10319,8548322.29614258; 10320,8547914.88647461; 10321,8546146.39282227; 10322,8547914.88647461; 10323,8548322.29614258; 10324,8548732.75756836; 10325,8550608.82568359; 10326,8548732.75756836; 10327,8548322.29614258; 10328,8547914.88647461; 10329,8546146.39282227; 10330,8541625.9765625; 10331,8541625.9765625; 10332,8545671.84448242; 10333,8546146.39282227; 10334,8547914.88647461; 10335,8547914.88647461; 10336,8547914.88647461; 10337,8547914.88647461; 10338,8548322.29614258; 10339,8548322.29614258; 10340,8548322.29614258; 10341,8547914.88647461; 10342,8546146.39282227; 10343,8545671.84448242; 10344,8539733.88671875; 10345,8539733.88671875; 10346,8539733.88671875; 10347,8539733.88671875; 10348,8537293.2434082; 10349,
        8536174.77416992; 10350,8536174.77416992; 10351,8537293.2434082; 10352,8539733.88671875; 10353,8545671.84448242; 10354,8546146.39282227; 10355,8547914.88647461; 10356,8547914.88647461; 10357,8547914.88647461; 10358,8547914.88647461; 10359,8547914.88647461; 10360,8546146.39282227; 10361,8545671.84448242; 10362,8539733.88671875; 10363,8539733.88671875; 10364,8539733.88671875; 10365,8545671.84448242; 10366,8546146.39282227; 10367,8546146.39282227; 10368,8546146.39282227; 10369,8546146.39282227; 10370,8546146.39282227; 10371,8546146.39282227; 10372,8546146.39282227; 10373,8546146.39282227; 10374,8546146.39282227; 10375,8546146.39282227; 10376,8545671.84448242; 10377,8545671.84448242; 10378,8545671.84448242; 10379,8545671.84448242; 10380,8545671.84448242; 10381,8550608.82568359; 10382,8550608.82568359; 10383,8545671.84448242; 10384,8542037.96386719; 10385,8542037.96386719; 10386,8542037.96386719; 10387,8542037.96386719; 10388,8545671.84448242; 10389,8551767.73071289; 10390,
        8552909.85107422; 10391,8556431.57958984; 10392,8557076.26342773; 10393,8557076.26342773; 10394,8557076.26342773; 10395,8557076.26342773; 10396,8557862.85400391; 10397,8557862.85400391; 10398,8557862.85400391; 10399,8557862.85400391; 10400,8557862.85400391; 10401,8557862.85400391; 10402,8557862.85400391; 10403,8557862.85400391; 10404,8557862.85400391; 10405,8557862.85400391; 10406,8557862.85400391; 10407,8557862.85400391; 10408,8556774.90234375; 10409,8556774.90234375; 10410,8556774.90234375; 10411,8556431.57958984; 10412,8556154.63256836; 10413,8556154.63256836; 10414,8556154.63256836; 10415,8556154.63256836; 10416,8556154.63256836; 10417,8556154.63256836; 10418,8556431.57958984; 10419,8556774.90234375; 10420,8556431.57958984; 10421,8556154.63256836; 10422,8553321.83837891; 10423,8556154.63256836; 10424,8556431.57958984; 10425,8556431.57958984; 10426,8556154.63256836; 10427,8555403.13720703; 10428,8555403.13720703; 10429,8555403.13720703; 10430,8555403.13720703; 10431,
        8556154.63256836; 10432,8556431.57958984; 10433,8556774.90234375; 10434,8560268.40209961; 10435,8560765.07568359; 10436,8560765.07568359; 10437,8560947.41821289; 10438,8560765.07568359; 10439,8560268.40209961; 10440,8559236.90795898; 10441,8556774.90234375; 10442,8556774.90234375; 10443,8559236.90795898; 10444,8559236.90795898; 10445,8556774.90234375; 10446,8556431.57958984; 10447,8556154.63256836; 10448,8556154.63256836; 10449,8556154.63256836; 10450,8555403.13720703; 10451,8555403.13720703; 10452,8555403.13720703; 10453,8555403.13720703; 10454,8553321.83837891; 10455,8552069.09179688; 10456,8552040.10009766; 10457,8552040.10009766; 10458,8552069.09179688; 10459,8553321.83837891; 10460,8553321.83837891; 10461,8553321.83837891; 10462,8552375.03051758; 10463,8552069.09179688; 10464,8552040.10009766; 10465,8551309.96704102; 10466,8550064.84985352; 10467,8548030.09033203; 10468,8548030.09033203; 10469,8550064.84985352; 10470,8551309.96704102; 10471,8550064.84985352; 10472,
        8548030.09033203; 10473,8548030.09033203; 10474,8548030.09033203; 10475,8550064.84985352; 10476,8551309.96704102; 10477,8551309.96704102; 10478,8551309.96704102; 10479,8552040.10009766; 10480,8552040.10009766; 10481,8552040.10009766; 10482,8552040.10009766; 10483,8552040.10009766; 10484,8551499.93896484; 10485,8551499.93896484; 10486,8551309.96704102; 10487,8550064.84985352; 10488,8550064.84985352; 10489,8550064.84985352; 10490,8550064.84985352; 10491,8551309.96704102; 10492,8551499.93896484; 10493,8551499.93896484; 10494,8551309.96704102; 10495,8551309.96704102; 10496,8551499.93896484; 10497,8551499.93896484; 10498,8551499.93896484; 10499,8551499.93896484; 10500,8551499.93896484; 10501,8552069.09179688; 10502,8552375.03051758; 10503,8552375.03051758; 10504,8551499.93896484; 10505,8551499.93896484; 10506,8550064.84985352; 10507,8546398.92578125; 10508,8546025.08544922; 10509,8545816.80297852; 10510,8545431.51855469; 10511,8544908.14208984; 10512,8544555.6640625; 10513,
        8544555.6640625; 10514,8544555.6640625; 10515,8544555.6640625; 10516,8544555.6640625; 10517,8544555.6640625; 10518,8541670.98999023; 10519,8531594.08569336; 10520,8530196.38061523; 10521,8528936.76757813; 10522,8522568.51196289; 10523,8520018.00537109; 10524,8518245.69702148; 10525,8518245.69702148; 10526,8518245.69702148; 10527,8518245.69702148; 10528,8518245.69702148; 10529,8518245.69702148; 10530,8518245.69702148; 10531,8515454.1015625; 10532,8515454.1015625; 10533,8515454.1015625; 10534,8515454.1015625; 10535,8515454.1015625; 10536,8514180.75561523; 10537,8513433.83789063; 10538,8513433.83789063; 10539,8514180.75561523; 10540,8515454.1015625; 10541,8518245.69702148; 10542,8518774.4140625; 10543,8518774.4140625; 10544,8518774.4140625; 10545,8518774.4140625; 10546,8518774.4140625; 10547,8518774.4140625; 10548,8518774.4140625; 10549,8518245.69702148; 10550,8515454.1015625; 10551,8514180.75561523; 10552,8513433.83789063; 10553,8511350.25024414; 10554,8509915.16113281; 10555,
        8509388.73291016; 10556,8506942.74902344; 10557,8506857.29980469; 10558,8506857.29980469; 10559,8506857.29980469; 10560,8506857.29980469; 10561,8506857.29980469; 10562,8506857.29980469; 10563,8506942.74902344; 10564,8509388.73291016; 10565,8509915.16113281; 10566,8509915.16113281; 10567,8509915.16113281; 10568,8509915.16113281; 10569,8509388.73291016; 10570,8509388.73291016; 10571,8509388.73291016; 10572,8509388.73291016; 10573,8506942.74902344; 10574,8506857.29980469; 10575,8506313.32397461; 10576,8505261.23046875; 10577,8505261.23046875; 10578,8505261.23046875; 10579,8506313.32397461; 10580,8506857.29980469; 10581,8506942.74902344; 10582,8509388.73291016; 10583,8509388.73291016; 10584,8509915.16113281; 10585,8511828.61328125; 10586,8512394.71435547; 10587,8513283.53881836; 10588,8514180.75561523; 10589,8515454.1015625; 10590,8516908.26416016; 10591,8516908.26416016; 10592,8516908.26416016; 10593,8516908.26416016; 10594,8516908.26416016; 10595,8518774.4140625; 10596,
        8521362.3046875; 10597,8521988.67797852; 10598,8521988.67797852; 10599,8521988.67797852; 10600,8521988.67797852; 10601,8521988.67797852; 10602,8527681.73217773; 10603,8527783.96606445; 10604,8528334.80834961; 10605,8528334.80834961; 10606,8528334.80834961; 10607,8528334.80834961; 10608,8527783.96606445; 10609,8527681.73217773; 10610,8526357.26928711; 10611,8527681.73217773; 10612,8527783.96606445; 10613,8528334.80834961; 10614,8531082.15332031; 10615,8530443.57299805; 10616,8527783.96606445; 10617,8527681.73217773; 10618,8526357.26928711; 10619,8526357.26928711; 10620,8526357.26928711; 10621,8526357.26928711; 10622,8526357.26928711; 10623,8526357.26928711; 10624,8527681.73217773; 10625,8527783.96606445; 10626,8530443.57299805; 10627,8531082.15332031; 10628,8531220.24536133; 10629,8539024.35302734; 10630,8539024.35302734; 10631,8539024.35302734; 10632,8539024.35302734; 10633,8531220.24536133; 10634,8531220.24536133; 10635,8531220.24536133; 10636,8531220.24536133; 10637,
        8531220.24536133; 10638,8531220.24536133; 10639,8531082.15332031; 10640,8530443.57299805; 10641,8530443.57299805; 10642,8527783.96606445; 10643,8527681.73217773; 10644,8527681.73217773; 10645,8526357.26928711; 10646,8525136.56616211; 10647,8521988.67797852; 10648,8521988.67797852; 10649,8521988.67797852; 10650,8525136.56616211; 10651,8526357.26928711; 10652,8527681.73217773; 10653,8530443.57299805; 10654,8531082.15332031; 10655,8531220.24536133; 10656,8531082.15332031; 10657,8531082.15332031; 10658,8531082.15332031; 10659,8531082.15332031; 10660,8530443.57299805; 10661,8527681.73217773; 10662,8527681.73217773; 10663,8527681.73217773; 10664,8527681.73217773; 10665,8527681.73217773; 10666,8527681.73217773; 10667,8527681.73217773; 10668,8530443.57299805; 10669,8531082.15332031; 10670,8531082.15332031; 10671,8531082.15332031; 10672,8531082.15332031; 10673,8533658.59985352; 10674,8536837.76855469; 10675,8537978.36303711; 10676,8541935.72998047; 10677,8543428.03955078; 10678,
        8547232.81860352; 10679,8554480.7434082; 10680,8555542.75512695; 10681,8556674.19433594; 10682,8556674.19433594; 10683,8556674.19433594; 10684,8556674.19433594; 10685,8556674.19433594; 10686,8555542.75512695; 10687,8555542.75512695; 10688,8555542.75512695; 10689,8555542.75512695; 10690,8555542.75512695; 10691,8555542.75512695; 10692,8555542.75512695; 10693,8557386.0168457; 10694,8557386.0168457; 10695,8557386.0168457; 10696,8557386.0168457; 10697,8558616.63818359; 10698,8558616.63818359; 10699,8558616.63818359; 10700,8558616.63818359; 10701,8558616.63818359; 10702,8558616.63818359; 10703,8558616.63818359; 10704,8558616.63818359; 10705,8560391.23535156; 10706,8562026.21459961; 10707,8562290.95458984; 10708,8562861.63330078; 10709,8562861.63330078; 10710,8562861.63330078; 10711,8562861.63330078; 10712,8563141.63208008; 10713,8565659.33227539; 10714,8567819.21386719; 10715,8568509.67407227; 10716,8569935.60791016; 10717,8570050.04882813; 10718,8570705.41381836; 10719,
        8573870.08666992; 10720,8574418.64013672; 10721,8574993.13354492; 10722,8575838.47045898; 10723,8577034.75952148; 10724,8579267.88330078; 10725,8580200.1953125; 10726,8580200.1953125; 10727,8580200.1953125; 10728,8581475.83007813; 10729,8583364.86816406; 10730,8587744.90356445; 10731,8587959.28955078; 10732,8589022.82714844; 10733,8590220.64208984; 10734,8590508.27026367; 10735,8591941.83349609; 10736,8597660.06469727; 10737,8597660.06469727; 10738,8603418.73168945; 10739,8615257.26318359; 10740,8619092.55981445; 10741,8621173.85864258; 10742,8627371.21582031; 10743,8630165.86303711; 10744,8655704.49829102; 10745,8656393.43261719; 10746,8660465.24047852; 10747,8665536.49902344; 10748,8671608.73413086; 10749,8676996.61254883; 10750,8682383.72802734; 10751,8704119.11010742; 10752,8797856.14013672; 10753,8826917.2668457; 10754,8833010.10131836; 10755,8842217.25463867; 10756,8849836.73095703; 10757,8857456.20727539; 10758,8858274.07836914; 10759,8868974.30419922; 10760,
        8920945.73974609; 10761,8932499.69482422; 10762,8932499.69482422; 10763,8932499.69482422; 10764,8955536.65161133; 10765,8983473.96850586; 10766,9011410.52246094; 10767,9041295.6237793; 10768,9046064.75830078; 10769,9052740.47851563; 10770,9058372.49755859; 10771,9058835.60180664; 10772,9064930.72509766; 10773,9086563.11035156; 10774,9091287.23144531; 10775,9100917.81616211; 10776,9105947.11303711; 10777,9114557.64770508; 10778,9114754.48608398; 10779,9124103.54614258; 10780,9140466.30859375; 10781,9141986.84692383; 10782,9142945.09887695; 10783,9146363.06762695; 10784,9156151.58081055; 10785,9156919.86083984; 10786,9162863.15917969; 10787,9165284.72900391; 10788,9165284.72900391; 10789,9165284.72900391; 10790,9169415.28320313; 10791,9179363.25073242; 10792,9180748.7487793; 10793,9182818.60351563; 10794,9183903.50341797; 10795,9193159.48486328; 10796,9195864.10522461; 10797,9195864.10522461; 10798,9196615.60058594; 10799,9198676.30004883; 10800,9199552.15454102; 10801,
        9199552.15454102; 10802,9200911.71264648; 10803,9201537.32299805; 10804,9206472.01538086; 10805,9212032.31811523; 10806,9212364.19677734; 10807,9212364.19677734; 10808,9212364.19677734; 10809,9212364.19677734; 10810,9212364.19677734; 10811,9212364.19677734; 10812,9212364.19677734; 10813,9212364.19677734; 10814,9212364.19677734; 10815,9212364.19677734; 10816,9212364.19677734; 10817,9213772.58300781; 10818,9215587.6159668; 10819,9215587.6159668; 10820,9215587.6159668; 10821,9215587.6159668; 10822,9216626.73950195; 10823,9219736.48071289; 10824,9223100.28076172; 10825,9228864.28833008; 10826,9231623.07739258; 10827,9231623.07739258; 10828,9231623.07739258; 10829,9228864.28833008; 10830,9223100.28076172; 10831,9223100.28076172; 10832,9223100.28076172; 10833,9223100.28076172; 10834,9223100.28076172; 10835,9228864.28833008; 10836,9235105.89599609; 10837,9238394.92797852; 10838,9240064.23950195; 10839,9240064.23950195; 10840,9240064.23950195; 10841,9248448.18115234; 10842,
        9253494.26269531; 10843,9253494.26269531; 10844,9253494.26269531; 10845,9253494.26269531; 10846,9253494.26269531; 10847,9253494.26269531; 10848,9255820.46508789; 10849,9264167.78564453; 10850,9264363.86108398; 10851,9264559.93652344; 10852,9264755.24902344; 10853,9264951.32446289; 10854,9265147.39990234; 10855,9265343.4753418; 10856,9267356.10961914; 10857,9267356.10961914; 10858,9267356.10961914; 10859,9267356.10961914; 10860,9267356.10961914; 10861,9253494.26269531; 10862,9248448.18115234; 10863,9253494.26269531; 10864,9267356.10961914; 10865,9270855.71289063; 10866,9271510.31494141; 10867,9271835.32714844; 10868,9271835.32714844; 10869,9271510.31494141; 10870,9270855.71289063; 10871,9270855.71289063; 10872,9271510.31494141; 10873,9271835.32714844; 10874,9271835.32714844; 10875,9272814.94140625; 10876,9272827.1484375; 10877,9272827.1484375; 10878,9272827.1484375; 10879,9272827.1484375; 10880,9272827.1484375; 10881,9272814.94140625; 10882,9272814.94140625; 10883,
        9273659.51538086; 10884,9276681.51855469; 10885,9278050.23193359; 10886,9283099.36523438; 10887,9284287.26196289; 10888,9289823.15063477; 10889,9291694.64111328; 10890,9292526.24511719; 10891,9295774.84130859; 10892,9300514.22119141; 10893,9300604.24804688; 10894,9300604.24804688; 10895,9300514.22119141; 10896,9295774.84130859; 10897,9292526.24511719; 10898,9291694.64111328; 10899,9289823.15063477; 10900,9284287.26196289; 10901,9284287.26196289; 10902,9289823.15063477; 10903,9291694.64111328; 10904,9292526.24511719; 10905,9295774.84130859; 10906,9300514.22119141; 10907,9300514.22119141; 10908,9300514.22119141; 10909,9300514.22119141; 10910,9300604.24804688; 10911,9304670.71533203; 10912,9307727.05078125; 10913,9307727.05078125; 10914,9310189.81933594; 10915,9310189.81933594; 10916,9310189.81933594; 10917,9313566.58935547; 10918,9317136.38305664; 10919,9317136.38305664; 10920,9317136.38305664; 10921,9317136.38305664; 10922,9317136.38305664; 10923,9317136.38305664; 10924,
        9317136.38305664; 10925,9317136.38305664; 10926,9317136.38305664; 10927,9317136.38305664; 10928,9317136.38305664; 10929,9317809.2956543; 10930,9322071.07543945; 10931,9322462.46337891; 10932,9325991.05834961; 10933,9326805.87768555; 10934,9327179.71801758; 10935,9328280.63964844; 10936,9330584.71679688; 10937,9331998.44360352; 10938,9331998.44360352; 10939,9334765.625; 10940,9334765.625; 10941,9334765.625; 10942,9334765.625; 10943,9334765.625; 10944,9334765.625; 10945,9334765.625; 10946,9334765.625; 10947,9337673.95019531; 10948,9334765.625; 10949,9330584.71679688; 10950,9328280.63964844; 10951,9328280.63964844; 10952,9328280.63964844; 10953,9328280.63964844; 10954,9334765.625; 10955,9334765.625; 10956,9334765.625; 10957,9334765.625; 10958,9334765.625; 10959,9334765.625; 10960,9334765.625; 10961,9328280.63964844; 10962,9327179.71801758; 10963,9326805.87768555; 10964,9326226.80664063; 10965,9325991.05834961; 10966,9323159.02709961; 10967,9322071.07543945; 10968,9320426.94091797;
        10969,9317809.2956543; 10970,9317809.2956543; 10971,9317809.2956543; 10972,9317809.2956543; 10973,9317809.2956543; 10974,9317809.2956543; 10975,9320426.94091797; 10976,9322071.07543945; 10977,9322071.07543945; 10978,9322071.07543945; 10979,9320426.94091797; 10980,9316432.95288086; 10981,9316432.95288086; 10982,9316432.95288086; 10983,9316432.95288086; 10984,9316432.95288086; 10985,9315810.39428711; 10986,9315810.39428711; 10987,9315810.39428711; 10988,9315810.39428711; 10989,9315554.04663086; 10990,9314009.85717773; 10991,9311876.6784668; 10992,9305950.16479492; 10993,9303136.4440918; 10994,9298735.04638672; 10995,9298263.54980469; 10996,9298263.54980469; 10997,9298149.87182617; 10998,9286470.79467773; 10999,9286470.79467773; 11000,9286470.79467773; 11001,9285401.15356445; 11002,9282695.00732422; 11003,9278472.90039063; 11004,9275446.31958008; 11005,9275446.31958008; 11006,9275446.31958008; 11007,9273498.53515625; 11008,9269649.50561523; 11009,9269178.0090332; 11010,
        9266293.33496094; 11011,9260676.57470703; 11012,9260676.57470703; 11013,9259479.52270508; 11014,9259041.59545898; 11015,9258649.44458008; 11016,9258200.83618164; 11017,9258200.83618164; 11018,9258200.83618164; 11019,9258200.83618164; 11020,9258200.83618164; 11021,9258200.83618164; 11022,9255481.7199707; 11023,9253218.07861328; 11024,9253218.07861328; 11025,9253218.07861328; 11026,9255481.7199707; 11027,9258200.83618164; 11028,9255481.7199707; 11029,9253218.07861328; 11030,9252282.71484375; 11031,9251065.06347656; 11032,9250759.12475586; 11033,9249848.93798828; 11034,9249819.94628906; 11035,9249229.43115234; 11036,9246957.39746094; 11037,9244276.42822266; 11038,9240695.95336914; 11039,9240695.95336914; 11040,9240689.84985352; 11041,9240689.84985352; 11042,9240689.84985352; 11043,9240689.84985352; 11044,9239627.07519531; 11045,9236300.65917969; 11046,9235029.60205078; 11047,9236300.65917969; 11048,9239627.07519531; 11049,9240695.95336914; 11050,9240695.95336914; 11051,
        9239627.07519531; 11052,9236300.65917969; 11053,9233076.47705078; 11054,9233076.47705078; 11055,9233076.47705078; 11056,9233076.47705078; 11057,9233076.47705078; 11058,9229847.71728516; 11059,9229847.71728516; 11060,9229847.71728516; 11061,9229847.71728516; 11062,9229847.71728516; 11063,9229847.71728516; 11064,9233076.47705078; 11065,9236300.65917969; 11066,9236300.65917969; 11067,9236300.65917969; 11068,9236300.65917969; 11069,9236300.65917969; 11070,9233076.47705078; 11071,9229847.71728516; 11072,9226485.44311523; 11073,9224788.66577148; 11074,9223809.05151367; 11075,9222829.43725586; 11076,9222522.7355957; 11077,9219515.99121094; 11078,9219515.99121094; 11079,9218442.53540039; 11080,9217133.33129883; 11081,9216197.9675293; 11082,9216197.9675293; 11083,9216197.9675293; 11084,9216197.9675293; 11085,9215830.99365234; 11086,9215830.99365234; 11087,9215830.99365234; 11088,9215830.99365234; 11089,9216197.9675293; 11090,9217133.33129883; 11091,9217133.33129883; 11092,
        9217133.33129883; 11093,9216197.9675293; 11094,9216197.9675293; 11095,9216197.9675293; 11096,9216197.9675293; 11097,9216197.9675293; 11098,9216197.9675293; 11099,9217133.33129883; 11100,9216197.9675293; 11101,9214928.4362793; 11102,9214271.54541016; 11103,9210923.00415039; 11104,9210923.00415039; 11105,9210923.00415039; 11106,9210923.00415039; 11107,9210923.00415039; 11108,9210923.00415039; 11109,9214271.54541016; 11110,9214928.4362793; 11111,9216197.9675293; 11112,9217133.33129883; 11113,9219515.99121094; 11114,9219515.99121094; 11115,9221746.06323242; 11116,9222522.7355957; 11117,9222829.43725586; 11118,9223809.05151367; 11119,9224788.66577148; 11120,9230447.38769531; 11121,9232232.66601563; 11122,9232232.66601563; 11123,9230447.38769531; 11124,9230339.05029297; 11125,9222522.7355957; 11126,9230339.05029297; 11127,9230447.38769531; 11128,9232232.66601563; 11129,9232232.66601563; 11130,9232232.66601563; 11131,9232232.66601563; 11132,9232232.66601563; 11133,9237705.23071289;
        11134,9237705.23071289; 11135,9237705.23071289; 11136,9237705.23071289; 11137,9237705.23071289; 11138,9237705.23071289; 11139,9237705.23071289; 11140,9237705.23071289; 11141,9238209.53369141; 11142,9238209.53369141; 11143,9238209.53369141; 11144,9246235.65673828; 11145,9246282.95898438; 11146,9248223.11401367; 11147,9249382.01904297; 11148,9249382.01904297; 11149,9256394.19555664; 11150,9267622.37548828; 11151,9269514.46533203; 11152,9270510.10131836; 11153,9270726.01318359; 11154,9273703.76586914; 11155,9277194.97680664; 11156,9278718.56689453; 11157,9280242.91992188; 11158,9280242.91992188; 11159,9282248.68774414; 11160,9291638.18359375; 11161,9293727.11181641; 11162,9293727.11181641; 11163,9293727.11181641; 11164,9293727.11181641; 11165,9293727.11181641; 11166,9293727.11181641; 11167,9296020.5078125; 11168,9301706.69555664; 11169,9301706.69555664; 11170,9301706.69555664; 11171,9301706.69555664; 11172,9301706.69555664; 11173,9301706.69555664; 11174,9303620.91064453; 11175,
        9305519.86694336; 11176,9308239.74609375; 11177,9308239.74609375; 11178,9308239.74609375; 11179,9308239.74609375; 11180,9308239.74609375; 11181,9308239.74609375; 11182,9308239.74609375; 11183,9309046.93603516; 11184,9310368.34716797; 11185,9311615.75317383; 11186,9313117.98095703; 11187,9314309.69238281; 11188,9314995.57495117; 11189,9314309.69238281; 11190,9313117.98095703; 11191,9311615.75317383; 11192,9310368.34716797; 11193,9309046.93603516; 11194,9308239.74609375; 11195,9305519.86694336; 11196,9303620.91064453; 11197,9301706.69555664; 11198,9301706.69555664; 11199,9301706.69555664; 11200,9303620.91064453; 11201,9301766.96777344; 11202,9301706.69555664; 11203,9298699.95117188; 11204,9297276.30615234; 11205,9296020.5078125; 11206,9295986.17553711; 11207,9295986.17553711; 11208,9295986.17553711; 11209,9295986.17553711; 11210,9295986.17553711; 11211,9295986.17553711; 11212,9295986.17553711; 11213,9294628.14331055; 11214,9291638.18359375; 11215,9289627.07519531; 11216,
        9289627.07519531; 11217,9291638.18359375; 11218,9294628.14331055; 11219,9295986.17553711; 11220,9296020.5078125; 11221,9297276.30615234; 11222,9298699.95117188; 11223,9301706.69555664; 11224,9301766.96777344; 11225,9301766.96777344; 11226,9301766.96777344; 11227,9301766.96777344; 11228,9301706.69555664; 11229,9301706.69555664; 11230,9301706.69555664; 11231,9301706.69555664; 11232,9301706.69555664; 11233,9301706.69555664; 11234,9298699.95117188; 11235,9297276.30615234; 11236,9297276.30615234; 11237,9298699.95117188; 11238,9301706.69555664; 11239,9301706.69555664; 11240,9301706.69555664; 11241,9301706.69555664; 11242,9301706.69555664; 11243,9298699.95117188; 11244,9301766.96777344; 11245,9305149.84130859; 11246,9309806.82373047; 11247,9309806.82373047; 11248,9309806.82373047; 11249,9305149.84130859; 11250,9305149.84130859; 11251,9305149.84130859; 11252,9309806.82373047; 11253,9310314.1784668; 11254,9310368.34716797; 11255,9310368.34716797; 11256,9310368.34716797; 11257,
        9310368.34716797; 11258,9310314.1784668; 11259,9309806.82373047; 11260,9305149.84130859; 11261,9303239.44091797; 11262,9301766.96777344; 11263,9299684.14306641; 11264,9299684.14306641; 11265,9299684.14306641; 11266,9299684.14306641; 11267,9299684.14306641; 11268,9301766.96777344; 11269,9303239.44091797; 11270,9305149.84130859; 11271,9309806.82373047; 11272,9310314.1784668; 11273,9310314.1784668; 11274,9310314.1784668; 11275,9309806.82373047; 11276,9309806.82373047; 11277,9309806.82373047; 11278,9310314.1784668; 11279,9315772.24731445; 11280,9316859.43603516; 11281,9316859.43603516; 11282,9315772.24731445; 11283,9310314.1784668; 11284,9309806.82373047; 11285,9309806.82373047; 11286,9309806.82373047; 11287,9309806.82373047; 11288,9310314.1784668; 11289,9311984.25292969; 11290,9315772.24731445; 11291,9316859.43603516; 11292,9316859.43603516; 11293,9316859.43603516; 11294,9316859.43603516; 11295,9316859.43603516; 11296,9316131.59179688; 11297,9315772.24731445; 11298,
        9315772.24731445; 11299,9315772.24731445; 11300,9311984.25292969; 11301,9310314.1784668; 11302,9309806.82373047; 11303,9309806.82373047; 11304,9305149.84130859; 11305,9303239.44091797; 11306,9301477.05078125; 11307,9299684.14306641; 11308,9295452.11791992; 11309,9295452.11791992; 11310,9299684.14306641; 11311,9299684.14306641; 11312,9299684.14306641; 11313,9299684.14306641; 11314,9299684.14306641; 11315,9299684.14306641; 11316,9299684.14306641; 11317,9295452.11791992; 11318,9299684.14306641; 11319,9299684.14306641; 11320,9299684.14306641; 11321,9299684.14306641; 11322,9299684.14306641; 11323,9299684.14306641; 11324,9295452.11791992; 11325,9295355.98754883; 11326,9295355.98754883; 11327,9295355.98754883; 11328,9295355.98754883; 11329,9295355.98754883; 11330,9295452.11791992; 11331,9295452.11791992; 11332,9293719.48242188; 11333,9293719.48242188; 11334,9293719.48242188; 11335,9293719.48242188; 11336,9293719.48242188; 11337,9295452.11791992; 11338,9295791.62597656; 11339,
        9295791.62597656; 11340,9295791.62597656; 11341,9295791.62597656; 11342,9295791.62597656; 11343,9295791.62597656; 11344,9295791.62597656; 11345,9295452.11791992; 11346,9295452.11791992; 11347,9295452.11791992; 11348,9295452.11791992; 11349,9295791.62597656; 11350,9300279.23583984; 11351,9305456.54296875; 11352,9305856.32324219; 11353,9305456.54296875; 11354,9300279.23583984; 11355,9295791.62597656; 11356,9295791.62597656; 11357,9295791.62597656; 11358,9295791.62597656; 11359,9295791.62597656; 11360,9295791.62597656; 11361,9295791.62597656; 11362,9295452.11791992; 11363,9293719.48242188; 11364,9292291.25976563; 11365,9286479.94995117; 11366,9286479.94995117; 11367,9286479.94995117; 11368,9286479.94995117; 11369,9284130.09643555; 11370,9281916.80908203; 11371,9277867.8894043; 11372,9277725.21972656; 11373,9276780.70068359; 11374,9276780.70068359; 11375,9276780.70068359; 11376,9277725.21972656; 11377,9277867.8894043; 11378,9281916.80908203; 11379,9284955.59692383; 11380,
        9284955.59692383; 11381,9284955.59692383; 11382,9286479.94995117; 11383,9291738.12866211; 11384,9292291.25976563; 11385,9292291.25976563; 11386,9292291.25976563; 11387,9291738.12866211; 11388,9289895.62988281; 11389,9289895.62988281; 11390,9289895.62988281; 11391,9289895.62988281; 11392,9289895.62988281; 11393,9289895.62988281; 11394,9289895.62988281; 11395,9286479.94995117; 11396,9284955.59692383; 11397,9284955.59692383; 11398,9284955.59692383; 11399,9286479.94995117; 11400,9286479.94995117; 11401,9286479.94995117; 11402,9284955.59692383; 11403,9284955.59692383; 11404,9284955.59692383; 11405,9284955.59692383; 11406,9286479.94995117; 11407,9288961.79199219; 11408,9289895.62988281; 11409,9290998.84033203; 11410,9290998.84033203; 11411,9290998.84033203; 11412,9289895.62988281; 11413,9289895.62988281; 11414,9289895.62988281; 11415,9289895.62988281; 11416,9290998.84033203; 11417,9290998.84033203; 11418,9290998.84033203; 11419,9289895.62988281; 11420,9290998.84033203; 11421,
        9290998.84033203; 11422,9290998.84033203; 11423,9290998.84033203; 11424,9290998.84033203; 11425,9289895.62988281; 11426,9288961.79199219; 11427,9286479.94995117; 11428,9286479.94995117; 11429,9286479.94995117; 11430,9286479.94995117; 11431,9286479.94995117; 11432,9286479.94995117; 11433,9286479.94995117; 11434,9286479.94995117; 11435,9284955.59692383; 11436,9279358.6730957; 11437,9277960.96801758; 11438,9277960.96801758; 11439,9277960.96801758; 11440,9277960.96801758; 11441,9277725.21972656; 11442,9274481.96411133; 11443,9273305.51147461; 11444,9273305.51147461; 11445,9274481.96411133; 11446,9277960.96801758; 11447,9279358.6730957; 11448,9283467.86499023; 11449,9283467.86499023; 11450,9283467.86499023; 11451,9283219.90966797; 11452,9283219.90966797; 11453,9283219.90966797; 11454,9283219.90966797; 11455,9283467.86499023; 11456,9285225.67749023; 11457,9283467.86499023; 11458,9283219.90966797; 11459,9283219.90966797; 11460,9283219.90966797; 11461,9283219.90966797; 11462,
        9283219.90966797; 11463,9283467.86499023; 11464,9285225.67749023; 11465,9288792.41943359; 11466,9288961.79199219; 11467,9290998.84033203; 11468,9290998.84033203; 11469,9290998.84033203; 11470,9290998.84033203; 11471,9293100.73852539; 11472,9293874.35913086; 11473,9293998.71826172; 11474,9293998.71826172; 11475,9293998.71826172; 11476,9293998.71826172; 11477,9293998.71826172; 11478,9294565.58227539; 11479,9294565.58227539; 11480,9294565.58227539; 11481,9294565.58227539; 11482,9295661.92626953; 11483,9301378.6315918; 11484,9301496.88720703; 11485,9302770.2331543; 11486,9306422.42431641; 11487,9307617.1875; 11488,9307617.1875; 11489,9307617.1875; 11490,9307617.1875; 11491,9307617.1875; 11492,9306422.42431641; 11493,9306422.42431641; 11494,9307617.1875; 11495,9307617.1875; 11496,9304842.37670898; 11497,9304842.37670898; 11498,9304842.37670898; 11499,9307617.1875; 11500,9400000; 14499,9400000; 14500,9230339.05029297; 14501,9222522.7355957; 14502,9230339.05029297; 14503,
        9230447.38769531; 14504,9232232.66601563; 14505,9232232.66601563; 14506,9232232.66601563; 14507,9232232.66601563; 14508,9232232.66601563; 14509,9237705.23071289; 14510,9237705.23071289; 14511,9237705.23071289; 14512,9237705.23071289; 14513,9237705.23071289; 14514,9237705.23071289; 14515,9237705.23071289; 14516,9237705.23071289; 14517,9238209.53369141; 14518,9238209.53369141; 14519,9238209.53369141; 14520,9246235.65673828; 14521,9246282.95898438; 14522,9248223.11401367; 14523,9249382.01904297; 14524,9249382.01904297; 14525,9256394.19555664; 14526,9267622.37548828; 14527,9269514.46533203; 14528,9270510.10131836; 14529,9270726.01318359; 14530,9273703.76586914; 14531,9277194.97680664; 14532,9278718.56689453; 14533,9280242.91992188; 14534,9280242.91992188; 14535,9282248.68774414; 14536,9291638.18359375; 14537,9293727.11181641; 14538,9293727.11181641; 14539,9293727.11181641; 14540,9293727.11181641; 14541,9293727.11181641; 14542,9293727.11181641; 14543,9296020.5078125; 14544,
        9301706.69555664; 14545,9301706.69555664; 14546,9301706.69555664; 14547,9301706.69555664; 14548,9301706.69555664; 14549,9301706.69555664; 14550,9303620.91064453; 14551,9305519.86694336; 14552,9308239.74609375; 14553,9308239.74609375; 14554,9308239.74609375; 14555,9308239.74609375; 14556,9308239.74609375; 14557,9308239.74609375; 14558,9308239.74609375; 14559,9309046.93603516; 14560,9310368.34716797; 14561,9311615.75317383; 14562,9313117.98095703; 14563,9314309.69238281; 14564,9314995.57495117; 14565,9314309.69238281; 14566,9313117.98095703; 14567,9311615.75317383; 14568,9310368.34716797; 14569,9309046.93603516; 14570,9308239.74609375; 14571,9305519.86694336; 14572,9303620.91064453; 14573,9301706.69555664; 14574,9301706.69555664; 14575,9301706.69555664; 14576,9303620.91064453; 14577,9301766.96777344; 14578,9301706.69555664; 14579,9298699.95117188; 14580,9297276.30615234; 14581,9296020.5078125; 14582,9295986.17553711; 14583,9295986.17553711; 14584,9295986.17553711; 14585,
        9295986.17553711; 14586,9295986.17553711; 14587,9295986.17553711; 14588,9295986.17553711; 14589,9294628.14331055; 14590,9291638.18359375; 14591,9289627.07519531; 14592,9289627.07519531; 14593,9291638.18359375; 14594,9294628.14331055; 14595,9295986.17553711; 14596,9296020.5078125; 14597,9297276.30615234; 14598,9298699.95117188; 14599,9301706.69555664; 14600,9301766.96777344; 14601,9301766.96777344; 14602,9301766.96777344; 14603,9301766.96777344; 14604,9301706.69555664; 14605,9301706.69555664; 14606,9301706.69555664; 14607,9301706.69555664; 14608,9301706.69555664; 14609,9301706.69555664; 14610,9298699.95117188; 14611,9297276.30615234; 14612,9297276.30615234; 14613,9298699.95117188; 14614,9301706.69555664; 14615,9301706.69555664; 14616,9301706.69555664; 14617,9301706.69555664; 14618,9301706.69555664; 14619,9298699.95117188; 14620,9301766.96777344; 14621,9305149.84130859; 14622,9309806.82373047; 14623,9309806.82373047; 14624,9309806.82373047; 14625,9305149.84130859; 14626,
        9305149.84130859; 14627,9305149.84130859; 14628,9309806.82373047; 14629,9310314.1784668; 14630,9310368.34716797; 14631,9310368.34716797; 14632,9310368.34716797; 14633,9310368.34716797; 14634,9310314.1784668; 14635,9309806.82373047; 14636,9305149.84130859; 14637,9303239.44091797; 14638,9301766.96777344; 14639,9299684.14306641; 14640,9299684.14306641; 14641,9299684.14306641; 14642,9299684.14306641; 14643,9299684.14306641; 14644,9301766.96777344; 14645,9303239.44091797; 14646,9305149.84130859; 14647,9309806.82373047; 14648,9310314.1784668; 14649,9310314.1784668; 14650,9310314.1784668; 14651,9309806.82373047; 14652,9309806.82373047; 14653,9309806.82373047; 14654,9310314.1784668; 14655,9315772.24731445; 14656,9316859.43603516; 14657,9316859.43603516; 14658,9315772.24731445; 14659,9310314.1784668; 14660,9309806.82373047; 14661,9309806.82373047; 14662,9309806.82373047; 14663,9309806.82373047; 14664,9310314.1784668; 14665,9311984.25292969; 14666,9315772.24731445; 14667,
        9316859.43603516; 14668,9316859.43603516; 14669,9316859.43603516; 14670,9316859.43603516; 14671,9316859.43603516; 14672,9316131.59179688; 14673,9315772.24731445; 14674,9315772.24731445; 14675,9315772.24731445; 14676,9311984.25292969; 14677,9310314.1784668; 14678,9309806.82373047; 14679,9309806.82373047; 14680,9305149.84130859; 14681,9303239.44091797; 14682,9301477.05078125; 14683,9299684.14306641; 14684,9295452.11791992; 14685,9295452.11791992; 14686,9299684.14306641; 14687,9299684.14306641; 14688,9299684.14306641; 14689,9299684.14306641; 14690,9299684.14306641; 14691,9299684.14306641; 14692,9299684.14306641; 14693,9295452.11791992; 14694,9299684.14306641; 14695,9299684.14306641; 14696,9299684.14306641; 14697,9299684.14306641; 14698,9299684.14306641; 14699,9299684.14306641; 14700,9295452.11791992; 14701,9295355.98754883; 14702,9295355.98754883; 14703,9295355.98754883; 14704,9295355.98754883; 14705,9295355.98754883; 14706,9295452.11791992; 14707,9295452.11791992; 14708,
        9293719.48242188; 14709,9293719.48242188; 14710,9293719.48242188; 14711,9293719.48242188; 14712,9293719.48242188; 14713,9295452.11791992; 14714,9295791.62597656; 14715,9295791.62597656; 14716,9295791.62597656; 14717,9295791.62597656; 14718,9295791.62597656; 14719,9295791.62597656; 14720,9295791.62597656; 14721,9295452.11791992; 14722,9295452.11791992; 14723,9295452.11791992; 14724,9295452.11791992; 14725,9295791.62597656; 14726,9300279.23583984; 14727,9305456.54296875; 14728,9305856.32324219; 14729,9305456.54296875; 14730,9300279.23583984; 14731,9295791.62597656; 14732,9295791.62597656; 14733,9295791.62597656; 14734,9295791.62597656; 14735,9295791.62597656; 14736,9295791.62597656; 14737,9295791.62597656; 14738,9295452.11791992; 14739,9293719.48242188; 14740,9292291.25976563; 14741,9286479.94995117; 14742,9286479.94995117; 14743,9286479.94995117; 14744,9286479.94995117; 14745,9284130.09643555; 14746,9281916.80908203; 14747,9277867.8894043; 14748,9277725.21972656; 14749,
        9276780.70068359; 14750,9276780.70068359; 14751,9276780.70068359; 14752,9277725.21972656; 14753,9277867.8894043; 14754,9281916.80908203; 14755,9284955.59692383; 14756,9284955.59692383; 14757,9284955.59692383; 14758,9286479.94995117; 14759,9291738.12866211; 14760,9292291.25976563; 14761,9292291.25976563; 14762,9292291.25976563; 14763,9291738.12866211; 14764,9289895.62988281; 14765,9289895.62988281; 14766,9289895.62988281; 14767,9289895.62988281; 14768,9289895.62988281; 14769,9289895.62988281; 14770,9289895.62988281; 14771,9286479.94995117; 14772,9284955.59692383; 14773,9284955.59692383; 14774,9284955.59692383; 14775,9286479.94995117; 14776,9286479.94995117; 14777,9286479.94995117; 14778,9284955.59692383; 14779,9284955.59692383; 14780,9284955.59692383; 14781,9284955.59692383; 14782,9286479.94995117; 14783,9288961.79199219; 14784,9289895.62988281; 14785,9290998.84033203; 14786,9290998.84033203; 14787,9290998.84033203; 14788,9289895.62988281; 14789,9289895.62988281; 14790,
        9289895.62988281; 14791,9289895.62988281; 14792,9290998.84033203; 14793,9290998.84033203; 14794,9290998.84033203; 14795,9289895.62988281; 14796,9290998.84033203; 14797,9290998.84033203; 14798,9290998.84033203; 14799,9290998.84033203; 14800,9290998.84033203; 14801,9289895.62988281; 14802,9288961.79199219; 14803,9286479.94995117; 14804,9286479.94995117; 14805,9286479.94995117; 14806,9286479.94995117; 14807,9286479.94995117; 14808,9286479.94995117; 14809,9286479.94995117; 14810,9286479.94995117; 14811,9284955.59692383; 14812,9279358.6730957; 14813,9277960.96801758; 14814,9277960.96801758; 14815,9277960.96801758; 14816,9277960.96801758; 14817,9277725.21972656; 14818,9274481.96411133; 14819,9273305.51147461; 14820,9273305.51147461; 14821,9274481.96411133; 14822,9277960.96801758; 14823,9279358.6730957; 14824,9283467.86499023; 14825,9283467.86499023; 14826,9283467.86499023; 14827,9283219.90966797; 14828,9283219.90966797; 14829,9283219.90966797; 14830,9283219.90966797; 14831,
        9283467.86499023; 14832,9285225.67749023; 14833,9283467.86499023; 14834,9283219.90966797; 14835,9283219.90966797; 14836,9283219.90966797; 14837,9283219.90966797; 14838,9283219.90966797; 14839,9283467.86499023; 14840,9285225.67749023; 14841,9288792.41943359; 14842,9288961.79199219; 14843,9290998.84033203; 14844,9290998.84033203; 14845,9290998.84033203; 14846,9290998.84033203; 14847,9293100.73852539; 14848,9293874.35913086; 14849,9293998.71826172; 14850,9293998.71826172; 14851,9293998.71826172; 14852,9293998.71826172; 14853,9293998.71826172; 14854,9294565.58227539; 14855,9294565.58227539; 14856,9294565.58227539; 14857,9294565.58227539; 14858,9295661.92626953; 14859,9301378.6315918; 14860,9301496.88720703; 14861,9302770.2331543; 14862,9306422.42431641; 14863,9307617.1875; 14864,9307617.1875; 14865,9307617.1875; 14866,9307617.1875; 14867,9307617.1875; 14868,9306422.42431641; 14869,9306422.42431641; 14870,9307617.1875; 14871,9307617.1875; 14872,9304842.37670898; 14873,
        9304842.37670898; 14874,9304842.37670898; 14875,9307617.1875; 14876,9308361.0534668; 14877,9308361.0534668; 14878,9308361.0534668; 14879,9308361.0534668; 14880,9308361.0534668; 14881,9308361.0534668; 14882,9310192.87109375; 14883,9311879.73022461; 14884,9312295.53222656; 14885,9312521.36230469; 14886,9312521.36230469; 14887,9312521.36230469; 14888,9312521.36230469; 14889,9314653.77807617; 14890,9316152.19116211; 14891,9320777.13012695; 14892,9320777.13012695; 14893,9320777.13012695; 14894,9320777.13012695; 14895,9321274.56665039; 14896,9321274.56665039; 14897,9321274.56665039; 14898,9321591.18652344; 14899,9321591.18652344; 14900,9321274.56665039; 14901,9321274.56665039; 14902,9321591.18652344; 14903,9321591.18652344; 14904,9321274.56665039; 14905,9320777.13012695; 14906,9316152.19116211; 14907,9314653.77807617; 14908,9316152.19116211; 14909,9320777.13012695; 14910,9320777.13012695; 14911,9320777.13012695; 14912,9320777.13012695; 14913,9316152.19116211; 14914,9316152.19116211;
        14915,9314653.77807617; 14916,9312521.36230469; 14917,9312295.53222656; 14918,9312295.53222656; 14919,9311879.73022461; 14920,9311058.04443359; 14921,9310192.87109375; 14922,9310192.87109375; 14923,9307958.22143555; 14924,9307958.22143555; 14925,9307958.22143555; 14926,9307958.22143555; 14927,9307958.22143555; 14928,9307958.22143555; 14929,9307958.22143555; 14930,9307958.22143555; 14931,9307291.41235352; 14932,9307291.41235352; 14933,9307291.41235352; 14934,9307291.41235352; 14935,9307291.41235352; 14936,9307291.41235352; 14937,9307291.41235352; 14938,9307291.41235352; 14939,9307958.22143555; 14940,9310192.87109375; 14941,9311058.04443359; 14942,9312521.36230469; 14943,9316152.19116211; 14944,9320777.13012695; 14945,9321591.18652344; 14946,9322299.95727539; 14947,9322838.5925293; 14948,9322838.5925293; 14949,9322838.5925293; 14950,9324451.4465332; 14951,9324451.4465332; 14952,9324451.4465332; 14953,9324451.4465332; 14954,9326998.90136719; 14955,9326998.90136719; 14956,
        9326998.90136719; 14957,9326998.90136719; 14958,9326998.90136719; 14959,9326998.90136719; 14960,9326998.90136719; 14961,9326998.90136719; 14962,9329788.20800781; 14963,9330363.46435547; 14964,9330565.64331055; 14965,9331379.69970703; 14966,9332910.15625; 14967,9334267.42553711; 14968,9341263.58032227; 14969,9341473.38867188; 14970,9341473.38867188; 14971,9341263.58032227; 14972,9341263.58032227; 14973,9341473.38867188; 14974,9344928.74145508; 14975,9344928.74145508; 14976,9341473.38867188; 14977,9341473.38867188; 14978,9344928.74145508; 14979,9344928.74145508; 14980,9344928.74145508; 14981,9344928.74145508; 14982,9344928.74145508; 14983,9344928.74145508; 14984,9344928.74145508; 14985,9344928.74145508; 14986,9344928.74145508; 14987,9344928.74145508; 14988,9344928.74145508; 14989,9344928.74145508; 14990,9344928.74145508; 14991,9344928.74145508; 14992,9344928.74145508; 14993,9344928.74145508; 14994,9346207.42797852; 14995,9347309.87548828; 14996,9349707.03125; 14997,
        9355352.78320313; 14998,9358026.12304688; 14999,9358368.68286133; 15000,9358026.12304688; 15001,9355352.78320313; 15002,9355352.78320313; 15003,9355352.78320313; 15004,9357664.48974609; 15005,9357664.48974609; 15006,9357664.48974609; 15007,9357664.48974609; 15008,9357664.48974609; 15009,9355352.78320313; 15010,9349707.03125; 15011,9346207.42797852; 15012,9344928.74145508; 15013,9341473.38867188; 15014,9341473.38867188; 15015,9341263.58032227; 15016,9333961.48681641; 15017,9333531.9519043; 15018,9333078.76586914; 15019,9333078.76586914; 15020,9333078.76586914; 15021,9333078.76586914; 15022,9333078.76586914; 15023,9333078.76586914; 15024,9332910.15625; 15025,9331413.26904297; 15026,9331413.26904297; 15027,9333078.76586914; 15028,9333531.9519043; 15029,9333531.9519043; 15030,9333531.9519043; 15031,9333961.48681641; 15032,9344928.74145508; 15033,9346881.86645508; 15034,9346881.86645508; 15035,9344928.74145508; 15036,9333961.48681641; 15037,9333531.9519043; 15038,9333078.76586914;
        15039,9331413.26904297; 15040,9329732.51342773; 15041,9328250.12207031; 15042,9328250.12207031; 15043,9328250.12207031; 15044,9328250.12207031; 15045,9328250.12207031; 15046,9329732.51342773; 15047,9328250.12207031; 15048,9326767.73071289; 15049,9326767.73071289; 15050,9326767.73071289; 15051,9328250.12207031; 15052,9326767.73071289; 15053,9325284.57641602; 15054,9324202.72827148; 15055,9324202.72827148; 15056,9325284.57641602; 15057,9326767.73071289; 15058,9326767.73071289; 15059,9326767.73071289; 15060,9328250.12207031; 15061,9329732.51342773; 15062,9331413.26904297; 15063,9331413.26904297; 15064,9331413.26904297; 15065,9332462.31079102; 15066,9332462.31079102; 15067,9332462.31079102; 15068,9331413.26904297; 15069,9331413.26904297; 15070,9331413.26904297; 15071,9331413.26904297; 15072,9331413.26904297; 15073,9331413.26904297; 15074,9331413.26904297; 15075,9332462.31079102; 15076,9332462.31079102; 15077,9329732.51342773; 15078,9329732.51342773; 15079,9328250.12207031; 15080,
        9328250.12207031; 15081,9328250.12207031; 15082,9328250.12207031; 15083,9328250.12207031; 15084,9328250.12207031; 15085,9328250.12207031; 15086,9329732.51342773; 15087,9329975.89111328; 15088,9329975.89111328; 15089,9329975.89111328; 15090,9329975.89111328; 15091,9329975.89111328; 15092,9331525.42114258; 15093,9331525.42114258; 15094,9331342.31567383; 15095,9330447.38769531; 15096,9329975.89111328; 15097,9329975.89111328; 15098,9329975.89111328; 15099,9330447.38769531; 15100,9331342.31567383; 15101,9331525.42114258; 15102,9331525.42114258; 15103,9331525.42114258; 15104,9331525.42114258; 15105,9331525.42114258; 15106,9331525.42114258; 15107,9331525.42114258; 15108,9331525.42114258; 15109,9332237.24365234; 15110,9332462.31079102; 15111,9332669.06738281; 15112,9335534.66796875; 15113,9335863.49487305; 15114,9339715.57617188; 15115,9340921.02050781; 15116,9342881.77490234; 15117,9342881.77490234; 15118,9342881.77490234; 15119,9340921.02050781; 15120,9339715.57617188; 15121,
        9339715.57617188; 15122,9339715.57617188; 15123,9339715.57617188; 15124,9339715.57617188; 15125,9339715.57617188; 15126,9340921.02050781; 15127,9342881.77490234; 15128,9344628.90625; 15129,9348051.45263672; 15130,9367713.1652832; 15131,9369168.09082031; 15132,9372116.85180664; 15133,9375490.57006836; 15134,9375717.92602539; 15135,9375717.92602539; 15136,9375490.57006836; 15137,9375490.57006836; 15138,9375490.57006836; 15139,9375490.57006836; 15140,9375717.92602539; 15141,9378647.61352539; 15142,9379369.35424805; 15143,9379757.69042969; 15144,9379792.02270508; 15145,9379757.69042969; 15146,9379369.35424805; 15147,9378647.61352539; 15148,9378647.61352539; 15149,9379369.35424805; 15150,9377249.14550781; 15151,9377249.14550781; 15152,9377249.14550781; 15153,9375717.92602539; 15154,9375717.92602539; 15155,9375717.92602539; 15156,9375717.92602539; 15157,9375717.92602539; 15158,9375717.92602539; 15159,9375717.92602539; 15160,9375717.92602539; 15161,9375717.92602539; 15162,
        9375717.92602539; 15163,9375717.92602539; 15164,9375717.92602539; 15165,9377249.14550781; 15166,9379757.69042969; 15167,9379792.02270508; 15168,9380641.17431641; 15169,9381791.68701172; 15170,9382904.81567383; 15171,9383116.9128418; 15172,9383116.9128418; 15173,9383116.9128418; 15174,9383116.9128418; 15175,9383116.9128418; 15176,9383116.9128418; 15177,9383188.62915039; 15178,9383116.9128418; 15179,9382904.81567383; 15180,9381791.68701172; 15181,9381791.68701172; 15182,9381791.68701172; 15183,9381791.68701172; 15184,9381791.68701172; 15185,9381791.68701172; 15186,9381791.68701172; 15187,9380641.17431641; 15188,9379792.02270508; 15189,9379757.69042969; 15190,9379757.69042969; 15191,9379757.69042969; 15192,9379757.69042969; 15193,9379757.69042969; 15194,9379792.02270508; 15195,9382904.81567383; 15196,9383116.9128418; 15197,9383188.62915039; 15198,9383664.70336914; 15199,9384869.38476563; 15200,9384869.38476563; 15201,9383664.70336914; 15202,9383188.62915039; 15203,9383116.9128418;
        15204,9382904.81567383; 15205,9379792.02270508; 15206,9379792.02270508; 15207,9377249.14550781; 15208,9375942.23022461; 15209,9375942.23022461; 15210,9377249.14550781; 15211,9382904.81567383; 15212,9383116.9128418; 15213,9383188.62915039; 15214,9383664.70336914; 15215,9384869.38476563; 15216,9384869.38476563; 15217,9384869.38476563; 15218,9384869.38476563; 15219,9384869.38476563; 15220,9388160.70556641; 15221,9390832.51953125; 15222,9392046.35620117; 15223,9394907.37915039; 15224,9394945.52612305; 15225,9399687.19482422; 15226,9399687.19482422; 15227,9402854.15649414; 15228,9403357.6965332; 15229,9403357.6965332; 15230,9403357.6965332; 15231,9403357.6965332; 15232,9403357.6965332; 15233,9405783.08105469; 15234,9406029.51049805; 15235,9406029.51049805; 15236,9407848.3581543; 15237,9411878.96728516; 15238,9414185.33325195; 15239,9414185.33325195; 15240,9411878.96728516; 15241,9408094.0246582; 15242,9407848.3581543; 15243,9407848.3581543; 15244,9407848.3581543; 15245,
        9407848.3581543; 15246,9407848.3581543; 15247,9406029.51049805; 15248,9405783.08105469; 15249,9403357.6965332; 15250,9402854.15649414; 15251,9401838.68408203; 15252,9401838.68408203; 15253,9401838.68408203; 15254,9402854.15649414; 15255,9403357.6965332; 15256,9405783.08105469; 15257,9406029.51049805; 15258,9406029.51049805; 15259,9406029.51049805; 15260,9406029.51049805; 15261,9406029.51049805; 15262,9406029.51049805; 15263,9407848.3581543; 15264,9408094.0246582; 15265,9408094.0246582; 15266,9408094.0246582; 15267,9408094.0246582; 15268,9408094.0246582; 15269,9408094.0246582; 15270,9408094.0246582; 15271,9408094.0246582; 15272,9412310.02807617; 15273,9412310.02807617; 15274,9414185.33325195; 15275,9421383.66699219; 15276,9422087.09716797; 15277,9424280.5480957; 15278,9427577.97241211; 15279,9429225.15869141; 15280,9429225.15869141; 15281,9429225.15869141; 15282,9429225.15869141; 15283,9429225.15869141; 15284,9429956.0546875; 15285,9432394.40917969; 15286,9429225.15869141;
        15287,9427577.97241211; 15288,9427577.97241211; 15289,9426014.70947266; 15290,9424280.5480957; 15291,9424280.5480957; 15292,9426014.70947266; 15293,9426014.70947266; 15294,9424280.5480957; 15295,9422227.47802734; 15296,9422227.47802734; 15297,9421383.66699219; 15298,9420166.015625; 15299,9415348.05297852; 15300,9415348.05297852; 15301,9415348.05297852; 15302,9412867.73681641; 15303,9412867.73681641; 15304,9415348.05297852; 15305,9420166.015625; 15306,9421383.66699219; 15307,9422227.47802734; 15308,9422227.47802734; 15309,9422227.47802734; 15310,9422227.47802734; 15311,9420166.015625; 15312,9415348.05297852; 15313,9412867.73681641; 15314,9412867.73681641; 15315,9412867.73681641; 15316,9412867.73681641; 15317,9412867.73681641; 15318,9412867.73681641; 15319,9415348.05297852; 15320,9420166.015625; 15321,9422227.47802734; 15322,9424280.5480957; 15323,9426014.70947266; 15324,9431997.68066406; 15325,9431997.68066406; 15326,9431997.68066406; 15327,9433235.16845703; 15328,
        9434758.75854492; 15329,9434758.75854492; 15330,9433235.16845703; 15331,9432698.82202148; 15332,9431997.68066406; 15333,9426014.70947266; 15334,9424280.5480957; 15335,9424280.5480957; 15336,9426014.70947266; 15337,9426014.70947266; 15338,9424280.5480957; 15339,9422227.47802734; 15340,9422227.47802734; 15341,9422227.47802734; 15342,9422227.47802734; 15343,9422227.47802734; 15344,9422227.47802734; 15345,9422227.47802734; 15346,9422227.47802734; 15347,9422227.47802734; 15348,9424280.5480957; 15349,9426014.70947266; 15350,9426014.70947266; 15351,9426014.70947266; 15352,9426014.70947266; 15353,9426014.70947266; 15354,9426014.70947266; 15355,9431997.68066406; 15356,9431997.68066406; 15357,9431997.68066406; 15358,9431997.68066406; 15359,9420166.015625; 15360,9420166.015625; 15361,9426310.72998047; 15362,9431997.68066406; 15363,9432698.82202148; 15364,9435699.46289063; 15365,9435978.69873047; 15366,9435978.69873047; 15367,9435978.69873047; 15368,9436499.0234375; 15369,9436499.0234375;
        15370,9436603.54614258; 15371,9437363.43383789; 15372,9438285.82763672; 15373,9438285.82763672; 15374,9438352.96630859; 15375,9439924.62158203; 15376,9443392.18139648; 15377,9443872.83325195; 15378,9443872.83325195; 15379,9443872.83325195; 15380,9443872.83325195; 15381,9443392.18139648; 15382,9443392.18139648; 15383,9443392.18139648; 15384,9443392.18139648; 15385,9443392.18139648; 15386,9443392.18139648; 15387,9443872.83325195; 15388,9444536.59057617; 15389,9451499.93896484; 15390,9451499.93896484; 15391,9457257.08007813; 15392,9457257.08007813; 15393,9457257.08007813; 15394,9457257.08007813; 15395,9457257.08007813; 15396,9457257.08007813; 15397,9454971.31347656; 15398,9451499.93896484; 15399,9451499.93896484; 15400,9451499.93896484; 15401,9451499.93896484; 15402,9451499.93896484; 15403,9451499.93896484; 15404,9451499.93896484; 15405,9454971.31347656; 15406,9457257.08007813; 15407,9458094.0246582; 15408,9460474.39575195; 15409,9460474.39575195; 15410,9458094.0246582; 15411,
        9458094.0246582; 15412,9460474.39575195; 15413,9465089.41650391; 15414,9465089.41650391; 15415,9465089.41650391; 15416,9460474.39575195; 15417,9458143.61572266; 15418,9458094.0246582; 15419,9458094.0246582; 15420,9458094.0246582; 15421,9457257.08007813; 15422,9455690.76538086; 15423,9455690.76538086; 15424,9455690.76538086; 15425,9455690.76538086; 15426,9454971.31347656; 15427,9451499.93896484; 15428,9451499.93896484; 15429,9450749.20654297; 15430,9451499.93896484; 15431,9451499.93896484; 15432,9454971.31347656; 15433,9454971.31347656; 15434,9454971.31347656; 15435,9454971.31347656; 15436,9454971.31347656; 15437,9451499.93896484; 15438,9451499.93896484; 15439,9450749.20654297; 15440,9450749.20654297; 15441,9450749.20654297; 15442,9450749.20654297; 15443,9450302.88696289; 15444,9446430.96923828; 15445,9446122.74169922; 15446,9444915.00854492; 15447,9440927.12402344; 15448,9440927.12402344; 15449,9440927.12402344; 15450,9440017.70019531; 15451,9437921.14257813; 15452,
        9434113.31176758; 15453,9434113.31176758; 15454,9434113.31176758; 15455,9433919.52514648; 15456,9433919.52514648; 15457,9433919.52514648; 15458,9433919.52514648; 15459,9434113.31176758; 15460,9437921.14257813; 15461,9437998.96240234; 15462,9437921.14257813; 15463,9434113.31176758; 15464,9433919.52514648; 15465,9432644.65332031; 15466,9430906.67724609; 15467,9430062.86621094; 15468,9430062.86621094; 15469,9429834.74731445; 15470,9429270.93505859; 15471,9427386.47460938; 15472,9420870.97167969; 15473,9416187.28637695; 15474,9414068.60351563; 15475,9414068.60351563; 15476,9414068.60351563; 15477,9414068.60351563; 15478,9414068.60351563; 15479,9411847.68676758; 15480,9411847.68676758; 15481,9411847.68676758; 15482,9411847.68676758; 15483,9411847.68676758; 15484,9411847.68676758; 15485,9411847.68676758; 15486,9411553.95507813; 15487,9411076.35498047; 15488,9410610.19897461; 15489,9408567.81005859; 15490,9408567.81005859; 15491,9403527.0690918; 15492,9402239.99023438; 15493,
        9402239.99023438; 15494,9402239.99023438; 15495,9402239.99023438; 15496,9402239.99023438; 15497,9400498.96240234; 15498,9400498.96240234; 15499,9400498.96240234; 15500,9400498.96240234; 15501,9398088.07373047; 15502,9396269.98901367; 15503,9395124.05395508; 15504,9395124.05395508; 15505,9391728.21044922; 15506,9389775.84838867; 15507,9389681.24389648; 15508,9388916.015625; 15509,9388916.015625; 15510,9387069.70214844; 15511,9383313.7512207; 15512,9377518.46313477; 15513,9374998.47412109; 15514,9374998.47412109; 15515,9374998.47412109; 15516,9374998.47412109; 15517,9374998.47412109; 15518,9374998.47412109; 15519,9377518.46313477; 15520,9383313.7512207; 15521,9387069.70214844; 15522,9388916.015625; 15523,9389681.24389648; 15524,9389775.84838867; 15525,9389681.24389648; 15526,9389681.24389648; 15527,9389681.24389648; 15528,9389681.24389648; 15529,9388916.015625; 15530,9387069.70214844; 15531,9385861.96899414; 15532,9383313.7512207; 15533,9383313.7512207; 15534,9374998.47412109;
        15535,9374998.47412109; 15536,9374998.47412109; 15537,9374998.47412109; 15538,9374998.47412109; 15539,9374998.47412109; 15540,9374998.47412109; 15541,9380281.82983398; 15542,9383313.7512207; 15543,9385861.96899414; 15544,9385861.96899414; 15545,9383313.7512207; 15546,9385861.96899414; 15547,9385861.96899414; 15548,9385861.96899414; 15549,9385861.96899414; 15550,9387069.70214844; 15551,9387069.70214844; 15552,9388916.015625; 15553,9389845.27587891; 15554,9390457.15332031; 15555,9389845.27587891; 15556,9385861.96899414; 15557,9383313.7512207; 15558,9380759.42993164; 15559,9380281.82983398; 15560,9380281.82983398; 15561,9380281.82983398; 15562,9380759.42993164; 15563,9380759.42993164; 15564,9380759.42993164; 15565,9380759.42993164; 15566,9380281.82983398; 15567,9380281.82983398; 15568,9380281.82983398; 15569,9375868.22509766; 15570,9373950.95825195; 15571,9373950.95825195; 15572,9373950.95825195; 15573,9375868.22509766; 15574,9380281.82983398; 15575,9380281.82983398; 15576,
        9380281.82983398; 15577,9380281.82983398; 15578,9380281.82983398; 15579,9380281.82983398; 15580,9380281.82983398; 15581,9380281.82983398; 15582,9380281.82983398; 15583,9380759.42993164; 15584,9381034.85107422; 15585,9385861.96899414; 15586,9389845.27587891; 15587,9390457.15332031; 15588,9391811.37084961; 15589,9397045.13549805; 15590,9397045.13549805; 15591,9397045.13549805; 15592,9397045.13549805; 15593,9397045.13549805; 15594,9393635.55908203; 15595,9393635.55908203; 15596,9393635.55908203; 15597,9391811.37084961; 15598,9391811.37084961; 15599,9391811.37084961; 15600,9393635.55908203; 15601,9393635.55908203; 15602,9393635.55908203; 15603,9393635.55908203; 15604,9393725.5859375; 15605,9394396.97265625; 15606,9394396.97265625; 15607,9394396.97265625; 15608,9394396.97265625; 15609,9394396.97265625; 15610,9394396.97265625; 15611,9397045.13549805; 15612,9397045.13549805; 15613,9402337.64648438; 15614,9402416.9921875; 15615,9403311.15722656; 15616,9403311.15722656; 15617,
        9402416.9921875; 15618,9402337.64648438; 15619,9402337.64648438; 15620,9402416.9921875; 15621,9402416.9921875; 15622,9403311.15722656; 15623,9413314.81933594; 15624,9414072.41821289; 15625,9414072.41821289; 15626,9418729.40063477; 15627,9419660.18676758; 15628,9418729.40063477; 15629,9414521.78955078; 15630,9418729.40063477; 15631,9419660.18676758; 15632,9423508.45336914; 15633,9425227.35595703; 15634,9425247.19238281; 15635,9425247.19238281; 15636,9425247.19238281; 15637,9425247.19238281; 15638,9433118.4387207; 15639,9439382.93457031; 15640,9439382.93457031; 15641,9439382.93457031; 15642,9439382.93457031; 15643,9439382.93457031; 15644,9440296.93603516; 15645,9444666.2902832; 15646,9445271.30126953; 15647,9445685.57739258; 15648,9446071.62475586; 15649,9447113.80004883; 15650,9449307.25097656; 15651,9451073.45581055; 15652,9454535.67504883; 15653,9454639.43481445; 15654,9457277.67944336; 15655,9457952.11791992; 15656,9459353.63769531; 15657,9470243.07250977; 15658,
        9471686.55395508; 15659,9475099.94506836; 15660,9475099.94506836; 15661,9475099.94506836; 15662,9475099.94506836; 15663,9475099.94506836; 15664,9475099.94506836; 15665,9475099.94506836; 15666,9475099.94506836; 15667,9478311.15722656; 15668,9479151.91650391; 15669,9486987.3046875; 15670,9490847.01538086; 15671,9495607.75756836; 15672,9497919.46411133; 15673,9497919.46411133; 15674,9497919.46411133; 15675,9497919.46411133; 15676,9497919.46411133; 15677,9497919.46411133; 15678,9501171.875; 15679,9505585.47973633; 15680,9506209.56420898; 15681,9507264.70947266; 15682,9510239.41040039; 15683,9511836.24267578; 15684,9519187.92724609; 15685,9524075.31738281; 15686,9524941.25366211; 15687,9531489.56298828; 15688,9531489.56298828; 15689,9531489.56298828; 15690,9531489.56298828; 15691,9531489.56298828; 15692,9531489.56298828; 15693,9531489.56298828; 15694,9531489.56298828; 15695,9531489.56298828; 15696,9531489.56298828; 15697,9531489.56298828; 15698,9531489.56298828; 15699,
        9531489.56298828; 15700,9524941.25366211; 15701,9524941.25366211; 15702,9524941.25366211; 15703,9524941.25366211; 15704,9524941.25366211; 15705,9524941.25366211; 15706,9524941.25366211; 15707,9524075.31738281; 15708,9519187.92724609; 15709,9519187.92724609; 15710,9519187.92724609; 15711,9511836.24267578; 15712,9507264.70947266; 15713,9507264.70947266; 15714,9511836.24267578; 15715,9522292.32788086; 15716,9522292.32788086; 15717,9522292.32788086; 15718,9522292.32788086; 15719,9522292.32788086; 15720,9524075.31738281; 15721,9524075.31738281; 15722,9524075.31738281; 15723,9524075.31738281; 15724,9524075.31738281; 15725,9522292.32788086; 15726,9515505.98144531; 15727,9515505.98144531; 15728,9522292.32788086; 15729,9515505.98144531; 15730,9511836.24267578; 15731,9506209.56420898; 15732,9502328.49121094; 15733,9501794.43359375; 15734,9494510.65063477; 15735,9494510.65063477; 15736,9501794.43359375; 15737,9501794.43359375; 15738,9494510.65063477; 15739,9492345.4284668; 15740,
        9490801.23901367; 15741,9490402.98461914; 15742,9487911.98730469; 15743,9483045.95947266; 15744,9478179.16870117; 15745,9473406.98242188; 15746,9470995.33081055; 15747,9470680.99975586; 15748,9463265.22827148; 15749,9463265.22827148; 15750,9463265.22827148; 15751,9463265.22827148; 15752,9461795.80688477; 15753,9461795.80688477; 15754,9461795.80688477; 15755,9461795.80688477; 15756,9460326.38549805; 15757,9460326.38549805; 15758,9460326.38549805; 15759,9460326.38549805; 15760,9460326.38549805; 15761,9460326.38549805; 15762,9460326.38549805; 15763,9461795.80688477; 15764,9463265.22827148; 15765,9463265.22827148; 15766,9463265.22827148; 15767,9463265.22827148; 15768,9463265.22827148; 15769,9463265.22827148; 15770,9463265.22827148; 15771,9461795.80688477; 15772,9460326.38549805; 15773,9457064.81933594; 15774,9457064.81933594; 15775,9457064.81933594; 15776,9453281.40258789; 15777,9453281.40258789; 15778,9453281.40258789; 15779,9453281.40258789; 15780,9453281.40258789; 15781,
        9453281.40258789; 15782,9453281.40258789; 15783,9453281.40258789; 15784,9449310.30273438; 15785,9449310.30273438; 15786,9449310.30273438; 15787,9453281.40258789; 15788,9449310.30273438; 15789,9448667.90771484; 15790,9438140.10620117; 15791,9438140.10620117; 15792,9438140.10620117; 15793,9435771.94213867; 15794,9421880.34057617; 15795,9419586.94458008; 15796,9417383.57543945; 15797,9415499.87792969; 15798,9415499.87792969; 15799,9415173.33984375; 15800,9412986.75537109; 15801,9409442.90161133; 15802,9408701.32446289; 15803,9406498.71826172; 15804,9406498.71826172; 15805,9406498.71826172; 15806,9406498.71826172; 15807,9406498.71826172; 15808,9406498.71826172; 15809,9405192.56591797; 15810,9403733.82568359; 15811,9398031.61621094; 15812,9395917.51098633; 15813,9392704.77294922; 15814,9390933.22753906; 15815,9392704.77294922; 15816,9392704.77294922; 15817,9392704.77294922; 15818,9390933.22753906; 15819,9390046.69189453; 15820,9388894.65332031; 15821,9386010.7421875; 15822,
        9385085.29663086; 15823,9385085.29663086; 15824,9385085.29663086; 15825,9381275.17700195; 15826,9381275.17700195; 15827,9378067.77954102; 15828,9377465.8203125; 15829,9377136.23046875; 15830,9376137.54272461; 15831,9375520.32470703; 15832,9374998.47412109; 15833,9374998.47412109; 15834,9374998.47412109; 15835,9373698.42529297; 15836,9373698.42529297; 15837,9373655.70068359; 15838,9372492.21801758; 15839,9370847.32055664; 15840,9367149.35302734; 15841,9367149.35302734; 15842,9367149.35302734; 15843,9367149.35302734; 15844,9367149.35302734; 15845,9367149.35302734; 15846,9367149.35302734; 15847,9367149.35302734; 15848,9365579.22363281; 15849,9360540.77148438; 15850,9350769.8059082; 15851,9350769.8059082; 15852,9345024.87182617; 15853,9345024.87182617; 15854,9345024.87182617; 15855,9345024.87182617; 15856,9343646.24023438; 15857,9342816.92504883; 15858,9339796.44775391; 15859,9338706.97021484; 15860,9335768.12744141; 15861,9335411.07177734; 15862,9334500.12207031; 15863,
        9334500.12207031; 15864,9334357.45239258; 15865,9333037.56713867; 15866,9332899.47509766; 15867,9332176.20849609; 15868,9329428.10058594; 15869,9327911.37695313; 15870,9324562.07275391; 15871,9314850.61645508; 15872,9314833.83178711; 15873,9309616.85180664; 15874,9302021.78955078; 15875,9298329.92553711; 15876,9295867.15698242; 15877,9292498.77929688; 15878,9292498.77929688; 15879,9292498.77929688; 15880,9290076.4465332; 15881,9282945.25146484; 15882,9278995.51391602; 15883,9271757.50732422; 15884,9269159.69848633; 15885,9268785.8581543; 15886,9264947.50976563; 15887,9264324.18823242; 15888,9254940.03295898; 15889,9252052.30712891; 15890,9251976.01318359; 15891,9244709.77783203; 15892,9241061.40136719; 15893,9237778.47290039; 15894,9225446.31958008; 15895,9221851.34887695; 15896,9218870.54443359; 15897,9218870.54443359; 15898,9218870.54443359; 15899,9218743.89648438; 15900,9216683.95996094; 15901,9216655.73120117; 15902,9212403.86962891; 15903,9209403.22875977; 15904,
        9209403.22875977; 15905,9209403.22875977; 15906,9209403.22875977; 15907,9209403.22875977; 15908,9209403.22875977; 15909,9212403.86962891; 15910,9212403.86962891; 15911,9212403.86962891; 15912,9212403.86962891; 15913,9212403.86962891; 15914,9212403.86962891; 15915,9212730.40771484; 15916,9212730.40771484; 15917,9218870.54443359; 15918,9218870.54443359; 15919,9218870.54443359; 15920,9218870.54443359; 15921,9218870.54443359; 15922,9218870.54443359; 15923,9218870.54443359; 15924,9218870.54443359; 15925,9218870.54443359; 15926,9218870.54443359; 15927,9218870.54443359; 15928,9212730.40771484; 15929,9212730.40771484; 15930,9212730.40771484; 15931,9218870.54443359; 15932,9218870.54443359; 15933,9218870.54443359; 15934,9218870.54443359; 15935,9218870.54443359; 15936,9218870.54443359; 15937,9218870.54443359; 15938,9218985.74829102; 15939,9221851.34887695; 15940,9222529.60205078; 15941,9225446.31958008; 15942,9227617.64526367; 15943,9227617.64526367; 15944,9233169.55566406; 15945,
        9239446.25854492; 15946,9241061.40136719; 15947,9244664.7644043; 15948,9244709.77783203; 15949,9250840.75927734; 15950,9257987.97607422; 15951,9257987.97607422; 15952,9257987.97607422; 15953,9250840.75927734; 15954,9244709.77783203; 15955,9244709.77783203; 15956,9250840.75927734; 15957,9257987.97607422; 15958,9261685.18066406; 15959,9261685.18066406; 15960,9261685.18066406; 15961,9261685.18066406; 15962,9261685.18066406; 15963,9261685.18066406; 15964,9261685.18066406; 15965,9262449.64599609; 15966,9264201.35498047; 15967,9264201.35498047; 15968,9264201.35498047; 15969,9264201.35498047; 15970,9267790.22216797; 15971,9268269.34814453; 15972,9271412.65869141; 15973,9277685.546875; 15974,9277685.546875; 15975,9277685.546875; 15976,9277685.546875; 15977,9278428.64990234; 15978,9286739.34936523; 15979,9288587.1887207; 15980,9291241.45507813; 15981,9291241.45507813; 15982,9291593.93310547; 15983,9292857.36083984; 15984,9292857.36083984; 15985,9293297.5769043; 15986,9296133.42285156;
        15987,9296558.38012695; 15988,9296558.38012695; 15989,9296558.38012695; 15990,9296558.38012695; 15991,9296133.42285156; 15992,9293297.5769043; 15993,9293297.5769043; 15994,9296133.42285156; 15995,9296558.38012695; 15996,9296558.38012695; 15997,9296558.38012695; 15998,9296558.38012695; 15999,9296558.38012695; 16000,9296133.42285156; 16001,9293297.5769043; 16002,9293297.5769043; 16003,9293297.5769043; 16004,9296133.42285156; 16005,9301295.47119141; 16006,9304814.14794922; 16007,9304814.14794922; 16008,9306375.12207031; 16009,9308584.59472656; 16010,9308584.59472656; 16011,9308584.59472656; 16012,9308584.59472656; 16013,9308584.59472656; 16014,9308584.59472656; 16015,9308584.59472656; 16016,9306375.12207031; 16017,9306375.12207031; 16018,9304814.14794922; 16019,9301295.47119141; 16020,9300009.15527344; 16021,9293297.5769043; 16022,9292857.36083984; 16023,9292857.36083984; 16024,9288419.34204102; 16025,9288419.34204102; 16026,9292857.36083984; 16027,9300009.15527344; 16028,
        9303658.29467773; 16029,9304814.14794922; 16030,9304814.14794922; 16031,9304814.14794922; 16032,9304814.14794922; 16033,9304814.14794922; 16034,9304814.14794922; 16035,9304814.14794922; 16036,9306375.12207031; 16037,9312583.16040039; 16038,9312583.16040039; 16039,9312583.16040039; 16040,9306375.12207031; 16041,9306375.12207031; 16042,9306375.12207031; 16043,9306375.12207031; 16044,9312583.16040039; 16045,9312583.16040039; 16046,9312583.16040039; 16047,9312583.16040039; 16048,9313349.15161133; 16049,9315998.07739258; 16050,9315998.07739258; 16051,9315998.07739258; 16052,9313349.15161133; 16053,9306375.12207031; 16054,9304814.14794922; 16055,9304199.98168945; 16056,9303658.29467773; 16057,9301122.28393555; 16058,9300009.15527344; 16059,9301122.28393555; 16060,9301122.28393555; 16061,9301122.28393555; 16062,9301122.28393555; 16063,9300009.15527344; 16064,9289656.82983398; 16065,9300009.15527344; 16066,9301122.28393555; 16067,9303658.29467773; 16068,9304199.98168945; 16069,
        9304199.98168945; 16070,9303658.29467773; 16071,9303658.29467773; 16072,9302672.5769043; 16073,9301122.28393555; 16074,9300009.15527344; 16075,9300009.15527344; 16076,9301122.28393555; 16077,9302672.5769043; 16078,9303658.29467773; 16079,9303658.29467773; 16080,9303658.29467773; 16081,9303658.29467773; 16082,9303658.29467773; 16083,9302672.5769043; 16084,9301122.28393555; 16085,9301122.28393555; 16086,9302672.5769043; 16087,9303658.29467773; 16088,9304199.98168945; 16089,9307217.40722656; 16090,9310906.98242188; 16091,9313349.15161133; 16092,9313605.49926758; 16093,9314278.41186523; 16094,9316998.29101563; 16095,9316998.29101563; 16096,9316998.29101563; 16097,9316998.29101563; 16098,9320424.65209961; 16099,9320718.38378906; 16100,9322611.23657227; 16101,9322611.23657227; 16102,9322611.23657227; 16103,9322611.23657227; 16104,9322611.23657227; 16105,9322776.79443359; 16106,9322776.79443359; 16107,9322776.79443359; 16108,9322776.79443359; 16109,9322776.79443359; 16110,
        9326984.40551758; 16111,9331248.47412109; 16112,9331248.47412109; 16113,9332064.05639648; 16114,9332064.05639648; 16115,9332064.05639648; 16116,9332064.05639648; 16117,9332324.21875; 16118,9335936.73706055; 16119,9335936.73706055; 16120,9332324.21875; 16121,9332324.21875; 16122,9332324.21875; 16123,9332324.21875; 16124,9335936.73706055; 16125,9337143.70727539; 16126,9342964.17236328; 16127,9346739.19677734; 16128,9350528.71704102; 16129,9350528.71704102; 16130,9350528.71704102; 16131,9350528.71704102; 16132,9350528.71704102; 16133,9350528.71704102; 16134,9356076.04980469; 16135,9356076.04980469; 16136,9356076.04980469; 16137,9356527.70996094; 16138,9357998.65722656; 16139,9360147.09472656; 16140,9360206.60400391; 16141,9360206.60400391; 16142,9361405.94482422; 16143,9361417.38891602; 16144,9362147.52197266; 16145,9363619.99511719; 16146,9368564.60571289; 16147,9372003.17382813; 16148,9372003.17382813; 16149,9372003.17382813; 16150,9372395.32470703; 16151,9377046.20361328;
        16152,9377239.22729492; 16153,9377046.20361328; 16154,9372395.32470703; 16155,9372003.17382813; 16156,9372003.17382813; 16157,9372395.32470703; 16158,9377046.20361328; 16159,9377239.22729492; 16160,9377754.21142578; 16161,9379173.27880859; 16162,9377754.21142578; 16163,9377239.22729492; 16164,9377110.29052734; 16165,9377046.20361328; 16166,9372395.32470703; 16167,9372003.17382813; 16168,9372003.17382813; 16169,9372003.17382813; 16170,9372003.17382813; 16171,9372003.17382813; 16172,9372003.17382813; 16173,9372003.17382813; 16174,9368564.60571289; 16175,9363619.99511719; 16176,9363619.99511719; 16177,9363619.99511719; 16178,9361417.38891602; 16179,9361417.38891602; 16180,9361405.94482422; 16181,9360206.60400391; 16182,9357138.06152344; 16183,9356527.70996094; 16184,9356527.70996094; 16185,9357138.06152344; 16186,9357138.06152344; 16187,9357138.06152344; 16188,9360206.60400391; 16189,9360206.60400391; 16190,9360206.60400391; 16191,9360206.60400391; 16192,9360206.60400391; 16193,
        9357138.06152344; 16194,9357138.06152344; 16195,9357138.06152344; 16196,9355950.92773438; 16197,9354924.01123047; 16198,9344240.57006836; 16199,9341285.70556641; 16200,9340125.2746582; 16201,9336797.33276367; 16202,9334448.2421875; 16203,9331610.10742188; 16204,9331610.10742188; 16205,9331610.10742188; 16206,9331610.10742188; 16207,9334448.2421875; 16208,9334448.2421875; 16209,9334448.2421875; 16210,9331610.10742188; 16211,9322537.23144531; 16212,9321720.12329102; 16213,9319651.79443359; 16214,9315912.62817383; 16215,9311037.44506836; 16216,9308367.91992188; 16217,9303239.44091797; 16218,9302411.65161133; 16219,9302411.65161133; 16220,9302411.65161133; 16221,9302411.65161133; 16222,9302411.65161133; 16223,9302411.65161133; 16224,9302411.65161133; 16225,9302411.65161133; 16226,9302411.65161133; 16227,9302411.65161133; 16228,9300006.86645508; 16229,9300006.86645508; 16230,9300006.86645508; 16231,9298096.46606445; 16232,9298096.46606445; 16233,9298096.46606445; 16234,
        9298096.46606445; 16235,9296485.13793945; 16236,9295572.66235352; 16237,9293178.55834961; 16238,9280593.10913086; 16239,9280361.17553711; 16240,9280361.17553711; 16241,9280361.17553711; 16242,9280361.17553711; 16243,9280593.10913086; 16244,9280593.10913086; 16245,9280593.10913086; 16246,9280593.10913086; 16247,9280593.10913086; 16248,9280593.10913086; 16249,9280593.10913086; 16250,9292678.07006836; 16251,9292678.07006836; 16252,9280593.10913086; 16253,9280361.17553711; 16254,9278946.68579102; 16255,9276930.23681641; 16256,9276930.23681641; 16257,9278946.68579102; 16258,9280361.17553711; 16259,9280361.17553711; 16260,9278946.68579102; 16261,9276930.23681641; 16262,9270369.72045898; 16263,9270369.72045898; 16264,9270369.72045898; 16265,9276930.23681641; 16266,9278946.68579102; 16267,9280361.17553711; 16268,9280593.10913086; 16269,9280593.10913086; 16270,9278946.68579102; 16271,9278946.68579102; 16272,9280593.10913086; 16273,9280593.10913086; 16274,9280593.10913086; 16275,
        9280593.10913086; 16276,9280593.10913086; 16277,9280593.10913086; 16278,9280593.10913086; 16279,9280593.10913086; 16280,9280593.10913086; 16281,9276930.23681641; 16282,9270369.72045898; 16283,9269190.97900391; 16284,9269190.97900391; 16285,9269190.97900391; 16286,9269190.97900391; 16287,9266318.51196289; 16288,9266104.88891602; 16289,9266104.88891602; 16290,9266104.88891602; 16291,9266104.88891602; 16292,9266318.51196289; 16293,9269190.97900391; 16294,9269190.97900391; 16295,9269190.97900391; 16296,9269190.97900391; 16297,9269190.97900391; 16298,9269190.97900391; 16299,9269190.97900391; 16300,9269190.97900391; 16301,9266318.51196289; 16302,9266104.88891602; 16303,9265989.68505859; 16304,9265989.68505859; 16305,9265989.68505859; 16306,9265067.29125977; 16307,9261628.72314453; 16308,9260612.48779297; 16309,9259597.01538086; 16310,9260612.48779297; 16311,9260612.48779297; 16312,9260612.48779297; 16313,9261628.72314453; 16314,9261628.72314453; 16315,9261628.72314453; 16316,
        9261628.72314453; 16317,9261628.72314453; 16318,9261628.72314453; 16319,9261628.72314453; 16320,9265989.68505859; 16321,9266318.51196289; 16322,9267786.4074707; 16323,9269190.97900391; 16324,9271675.87280273; 16325,9271675.87280273; 16326,9271675.87280273; 16327,9271675.87280273; 16328,9272999.57275391; 16329,9272999.57275391; 16330,9272999.57275391; 16331,9272999.57275391; 16332,9272999.57275391; 16333,9272999.57275391; 16334,9272999.57275391; 16335,9277383.42285156; 16336,9277499.38964844; 16337,9277499.38964844; 16338,9277499.38964844; 16339,9277499.38964844; 16340,9277383.42285156; 16341,9272999.57275391; 16342,9272999.57275391; 16343,9272999.57275391; 16344,9272999.57275391; 16345,9272999.57275391; 16346,9271675.87280273; 16347,9267786.4074707; 16348,9267786.4074707; 16349,9271675.87280273; 16350,9272999.57275391; 16351,9272999.57275391; 16352,9272999.57275391; 16353,9272999.57275391; 16354,9272999.57275391; 16355,9272999.57275391; 16356,9275553.13110352; 16357,
        9277383.42285156; 16358,9277499.38964844; 16359,9277499.38964844; 16360,9277499.38964844; 16361,9277499.38964844; 16362,9277499.38964844; 16363,9278851.31835938; 16364,9279531.86035156; 16365,9282962.03613281; 16366,9282962.03613281; 16367,9284304.04663086; 16368,9282962.03613281; 16369,9279531.86035156; 16370,9278851.31835938; 16371,9277499.38964844; 16372,9278851.31835938; 16373,9282962.03613281; 16374,9278851.31835938; 16375,9277383.42285156; 16376,9277383.42285156; 16377,9277383.42285156; 16378,9277383.42285156; 16379,9277383.42285156; 16380,9277383.42285156; 16381,9277383.42285156; 16382,9277757.26318359; 16383,9278851.31835938; 16384,9282962.03613281; 16385,9282962.03613281; 16386,9282962.03613281; 16387,9282962.03613281; 16388,9282962.03613281; 16389,9282962.03613281; 16390,9282962.03613281; 16391,9282962.03613281; 16392,9282962.03613281; 16393,9282962.03613281; 16394,9282962.03613281; 16395,9282962.03613281; 16396,9282962.03613281; 16397,9282962.03613281; 16398,
        9286428.83300781; 16399,9287319.18334961; 16400,9289664.45922852; 16401,9292155.45654297; 16402,9292155.45654297; 16403,9292155.45654297; 16404,9293295.28808594; 16405,9293295.28808594; 16406,9293295.28808594; 16407,9293295.28808594; 16408,9298393.24951172; 16409,9293295.28808594; 16410,9292155.45654297; 16411,9289664.45922852; 16412,9289321.89941406; 16413,9287319.18334961; 16414,9289321.89941406; 16415,9289664.45922852; 16416,9292155.45654297; 16417,9293295.28808594; 16418,9295123.29101563; 16419,9298393.24951172; 16420,9299068.45092773; 16421,9299871.06323242; 16422,9303627.77709961; 16423,9313961.02905273; 16424,9314350.89111328; 16425,9313961.02905273; 16426,9313961.02905273; 16427,9313961.02905273; 16428,9313961.02905273; 16429,9316094.20776367; 16430,9318475.34179688; 16431,9319799.04174805; 16432,9319799.04174805; 16433,9319799.04174805; 16434,9319799.04174805; 16435,9318475.34179688; 16436,9318475.34179688; 16437,9319799.04174805; 16438,9322710.41870117; 16439,
        9326206.97021484; 16440,9332162.47558594; 16441,9339682.00683594; 16442,9350738.52539063; 16443,9350936.12670898; 16444,9351580.04760742; 16445,9352499.38964844; 16446,9352499.38964844; 16447,9352499.38964844; 16448,9352499.38964844; 16449,9352499.38964844; 16450,9352499.38964844; 16451,9355010.98632813; 16452,9356581.87866211; 16453,9356581.87866211; 16454,9358515.16723633; 16455,9359149.93286133; 16456,9360834.50317383; 16457,9361015.31982422; 16458,9361403.65600586; 16459,9362998.96240234; 16460,9362998.96240234; 16461,9362998.96240234; 16462,9363175.96435547; 16463,9365256.50024414; 16464,9366744.23217773; 16465,9368112.18261719; 16466,9368112.18261719; 16467,9368217.46826172; 16468,9370498.65722656; 16469,9370498.65722656; 16470,9371156.31103516; 16471,9372263.33618164; 16472,9374712.37182617; 16473,9376176.45263672; 16474,9376176.45263672; 16475,9376176.45263672; 16476,9377407.83691406; 16477,9377407.83691406; 16478,9377407.83691406; 16479,9376176.45263672; 16480,
        9372263.33618164; 16481,9371156.31103516; 16482,9371156.31103516; 16483,9372263.33618164; 16484,9376176.45263672; 16485,9376176.45263672; 16486,9376176.45263672; 16487,9376176.45263672; 16488,9376176.45263672; 16489,9376176.45263672; 16490,9376176.45263672; 16491,9376176.45263672; 16492,9375593.56689453; 16493,9376176.45263672; 16494,9377407.83691406; 16495,9376176.45263672; 16496,9375593.56689453; 16497,9375451.66015625; 16498,9375451.66015625; 16499,9375451.66015625; 16500,9400000; 20000,9400000]) annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=-90,
        origin={-50,230})));
  Modelica.Blocks.Sources.TimeTable timeTablePrimAir_concat(table=[0,20.8299999237061; 4499,20.8299999237061; 4500,20.9424165137173; 4501,20.9419852184549; 4502,20.9415558035507; 4503,20.9411285767232; 4504,20.940703845691; 4505,20.9402819181725; 4506,20.9398631018864; 4507,20.939447704551; 4508,20.9386210872089; 4509,20.9377757049867; 4510,20.9369116136774; 4511,20.936028869074; 4512,20.9351275269693; 4513,20.9342076431564; 4514,20.933269273428; 4515,20.9323124735772; 4516,20.9313372993968; 4517,20.9303438066798; 4518,20.9293320512191; 4519,20.9283020888076; 4520,20.9272539752383; 4521,20.926187766304; 4522,20.9251035177978; 4523,20.9240012855124; 4524,20.9232960719171; 4525,20.9225957853966; 4526,20.9219007336692; 4527,20.9212112244536; 4528,20.9205275654683; 4529,20.9198500644318; 4530,20.9191790290627; 4531,20.9185147670795; 4532,20.9178575862007; 4533,20.9172077941449; 4534,20.9165656986306; 4535,20.9158733439682; 4536,20.9151926117052; 4537,20.9145237721545; 4538,
        20.9138670956285; 4539,20.9132228524399; 4540,20.9125913129015; 4541,20.9119727473258; 4542,20.9113674260254; 4543,20.9107756193131; 4544,20.9101975975015; 4545,20.9096336309032; 4546,20.9090839898309; 4547,20.9085489445972; 4548,20.9080287655148; 4549,20.9075237228963; 4550,20.9070340870544; 4551,20.9065601283017; 4552,20.9061021169509; 4553,20.9056603233147; 4554,20.9052350177056; 4555,20.9048264704363; 4556,20.9044349518195; 4557,20.9040607321678; 4558,20.9037040817939; 4559,20.9033652710104; 4560,20.90304457013; 4561,20.9027489394132; 4562,20.9024723268044; 4563,20.9022150066778; 4564,20.9019772534077; 4565,20.9017593413684; 4566,20.9015615449343; 4567,20.9013841384796; 4568,20.9012273963787; 4569,20.9010915930058; 4570,20.9009770027352; 4571,20.9008838999413; 4572,20.9008125589983; 4573,20.9007632542805; 4574,20.9007362601623; 4575,20.900731851018; 4576,20.9007503012218; 4577,20.900791885148; 4578,20.900856877171; 4579,20.9009455516651; 4580,20.9010581830045; 4581,
        20.9011950455635; 4582,20.9013564137165; 4583,20.9015425618378; 4584,20.9017537643017; 4585,20.9019902954824; 4586,20.9022524297543; 4587,20.9025404414916; 4588,20.9028546050687; 4589,20.9031951948599; 4590,20.9035624852395; 4591,20.9039567505817; 4592,20.9043782652609; 4593,20.9048273036514; 4594,20.9053041401275; 4595,20.9058090490635; 4596,20.9063423048336; 4597,20.9069041818122; 4598,20.9069814212263; 4599,20.9070596144905; 4600,20.9071387241989; 4601,20.9072187129457; 4602,20.9072995433248; 4603,20.9073811779306; 4604,20.907463579357; 4605,20.9075467101981; 4606,20.9076305330482; 4607,20.9077150105012; 4608,20.9078001051514; 4609,20.9078857795928; 4610,20.9079719964196; 4611,20.9080587182258; 4612,20.9081459076056; 4613,20.9082335271531; 4614,20.9083215394624; 4615,20.9084099071276; 4616,20.9084985927429; 4617,20.9085875589022; 4618,20.9086767681999; 4619,20.9087661832299; 4620,20.9088557665864; 4621,20.9089454808635; 4622,20.9090352886554; 4623,20.909125152556; 4624,
        20.9092150351596; 4625,20.9093048990603; 4626,20.9093947068521; 4627,20.9094844211292; 4628,20.9095740044857; 4629,20.9096634195157; 4630,20.9097526288134; 4631,20.9098415949728; 4632,20.909930280588; 4633,20.9100186482532; 4634,20.9101066605625; 4635,20.91019428011; 4636,20.9102814694898; 4637,20.910368191296; 4638,20.9104544081228; 4639,20.9105400825642; 4640,20.9106251772144; 4641,20.9107096546674; 4642,20.9107934775175; 4643,20.9108766083587; 4644,20.910959009785; 4645,20.9110406443908; 4646,20.9107653469682; 4647,20.9105094424475; 4648,20.9102726647838; 4649,20.9100547479324; 4650,20.9098554258488; 4651,20.9096744324881; 4652,20.9095115018057; 4653,20.909366367757; 4654,20.9092387642971; 4655,20.9091284253815; 4656,20.9090350849654; 4657,20.9089584770042; 4658,20.9088983354531; 4659,20.9088543942675; 4660,20.9088263874027; 4661,20.9088140488139; 4662,20.9088171124565; 4663,20.9088353122859; 4664,20.9088683822573; 4665,20.9089160563259; 4666,20.9089780684473; 4667,
        20.9090541525765; 4668,20.909144042669; 4669,20.9092474726801; 4670,20.909364176565; 4671,20.9094938882792; 4672,20.9096363417778; 4673,20.9097912710162; 4674,20.9099584099497; 4675,20.9101374925336; 4676,20.9103282527233; 4677,20.910530424474; 4678,20.9107437417411; 4679,20.9109679384798; 4680,20.9112027486455; 4681,20.9114479061934; 4682,20.911703145079; 4683,20.9119681992574; 4684,20.9122428026841; 4685,20.9125266893142; 4686,20.9128195931032; 4687,20.9131212480063; 4688,20.9134313879789; 4689,20.9137497469762; 4690,20.9140760589536; 4691,20.9144100578663; 4692,20.9147514776697; 4693,20.9151000523192; 4694,20.9154555157699; 4695,20.9158176019772; 4696,20.9161860448965; 4697,20.916560578483; 4698,20.916940936692; 4699,20.9173268534788; 4700,20.9177180627989; 4701,20.9181142986074; 4702,20.9185152948596; 4703,20.918920785511; 4704,20.9193305045168; 4705,20.9197441858322; 4706,20.9201615634127; 4707,20.9205823712135; 4708,20.9210063431899; 4709,20.9214332132973; 4710,
        20.921862715491; 4711,20.9222945837262; 4712,20.9227285519582; 4713,20.9231643541425; 4714,20.9236633354692; 4715,20.9241670038913; 4716,20.9246751307702; 4717,20.9251874874669; 4718,20.9257038453427; 4719,20.9262239757587; 4720,20.9267476500763; 4721,20.9272746396565; 4722,20.9278047158605; 4723,20.9283376500497; 4724,20.928873213585; 4725,20.9294111778278; 4726,20.9299513141393; 4727,20.9304933938806; 4728,20.9310371884129; 4729,20.9315824690975; 4730,20.9321290072954; 4731,20.932676574368; 4732,20.9332249416765; 4733,20.9337738805819; 4734,20.9343231624455; 4735,20.9348725586285; 4736,20.9354218404922; 4737,20.9359707793976; 4738,20.936519146706; 4739,20.9370667137786; 4740,20.9376132519766; 4741,20.9381585326611; 4742,20.9387023271935; 4743,20.9392444069347; 4744,20.9397845432462; 4745,20.940322507489; 4746,20.9413265883579; 4747,20.9426384275017; 4748,20.9439019409743; 4749,20.9451174172948; 4750,20.9462851449825; 4751,20.9474054125564; 4752,20.9484785085358; 4753,
        20.9495047214398; 4754,20.9504843397876; 4755,20.9514176520983; 4756,20.9523049468912; 4757,20.9531465126853; 4758,20.9539426379999; 4759,20.9546936113541; 4760,20.9553997212672; 4761,20.9560612562581; 4762,20.9566785048462; 4763,20.9572517555506; 4764,20.9577812968905; 4765,20.958267417385; 4766,20.9587104055533; 4767,20.9591105499145; 4768,20.9594681389879; 4769,20.9597834612927; 4770,20.9600568053478; 4771,20.9602884596726; 4772,20.9604787127863; 4773,20.9606278532079; 4774,20.9607361694566; 4775,20.9608039500517; 4776,20.9608314835122; 4777,20.9608190583574; 4778,20.9607669631064; 4779,20.9606754862783; 4780,20.9605449163925; 4781,20.9603755419679; 4782,20.9601676515239; 4783,20.9599215335795; 4784,20.9596374766539; 4785,20.9593157692663; 4786,20.9589566999359; 4787,20.9585605571818; 4788,20.9581276295232; 4789,20.9576582054792; 4790,20.9571525735691; 4791,20.956611022312; 4792,20.9560338402271; 4793,20.9554213158335; 4794,20.9547737376504; 4795,20.9540913941969; 4796,
        20.9533745739923; 4797,20.9526235655557; 4798,20.9518386574063; 4799,20.9510201380633; 4800,20.9501682960457; 4801,20.9492834198728; 4802,20.9479352393106; 4803,20.9465790651968; 4804,20.9452149096263; 4805,20.9438427846938; 4806,20.9424627024938; 4807,20.9410746751212; 4808,20.9396787146707; 4809,20.9382748332369; 4810,20.9368630429145; 4811,20.9354433557982; 4812,20.9340157839828; 4813,20.9325803395629; 4814,20.9311370346332; 4815,20.9296858812885; 4816,20.9282268916234; 4817,20.9267600777326; 4818,20.9252854517108; 4819,20.9238030256528; 4820,20.9223128116531; 4821,20.9208148218066; 4822,20.9193090682079; 4823,20.9177955629517; 4824,20.9162743181328; 4825,20.9151219368204; 4826,20.9139825319465; 4827,20.9128563442444; 4828,20.9117436144478; 4829,20.9106445832901; 4830,20.9095594915048; 4831,20.9084885798254; 4832,20.9074320889855; 4833,20.9063902597185; 4834,20.9053633327579; 4835,20.9043515488373; 4836,20.9033551486901; 4837,20.9023743730498; 4838,20.90140946265; 4839,
        20.9004606582242; 4840,20.8995282005058; 4841,20.8986123302283; 4842,20.8977132881253; 4843,20.8968313149303; 4844,20.8959666513768; 4845,20.8951195381982; 4846,20.894290216128; 4847,20.8934789258999; 4848,20.8926859082472; 4849,20.8919114039035; 4850,20.8911556536023; 4851,20.8904188980771; 4852,20.8897013780614; 4853,20.8890033342887; 4854,20.8883250074924; 4855,20.8876666384062; 4856,20.8870284677635; 4857,20.8864107362977; 4858,20.8858136847425; 4859,20.8852375538313; 4860,20.8846825842976; 4861,20.8841490168749; 4862,20.8836370922968; 4863,20.8831470512967; 4864,20.8826791346081; 4865,20.8822335829645; 4866,20.8818106370995; 4867,20.8814105377465; 4868,20.881033525639; 4869,20.8806798415106; 4870,20.8803497260948; 4871,20.8800434201249; 4872,20.8797611643347; 4873,20.8795031994575; 4874,20.8792697662268; 4875,20.8790611053762; 4876,20.8788774576392; 4877,20.8787190637493; 4878,20.8785861644399; 4879,20.8784790004446; 4880,20.8783978124969; 4881,20.8783428413302; 4882,
        20.8783143276782; 4883,20.8783125122742; 4884,20.8783376358518; 4885,20.8783899391445; 4886,20.8784696628859; 4887,20.8785770478093; 4888,20.8787123346483; 4889,20.8788757641364; 4890,20.8790675770071; 4891,20.879288013994; 4892,20.8795373158305; 4893,20.87981572325; 4894,20.8801234769862; 4895,20.8804608177726; 4896,20.8808279863425; 4897,20.8812252234296; 4898,20.8816527697673; 4899,20.8821108660892; 4900,20.8825997531287; 4901,20.8831196716193; 4902,20.8836708622946; 4903,20.8842535658881; 4904,20.8848680231332; 4905,20.8855144747634; 4906,20.8861931615123; 4907,20.8869043241134; 4908,20.8876482033001; 4909,20.8884250398061; 4910,20.8892350743646; 4911,20.8900785477094; 4912,20.8909557005738; 4913,20.8918667736915; 4914,20.8928120077958; 4915,20.8937916436203; 4916,20.8948059218984; 4917,20.8958550833638; 4918,20.8969393687499; 4919,20.8980590187902; 4920,20.8992142742181; 4921,20.9004053757673; 4922,20.9016325641712; 4923,20.9029102393163; 4924,20.9065166074985; 4925,
        20.909533270829; 4926,20.9120737952969; 4927,20.9144763935833; 4928,20.9167422704453; 4929,20.91887263064; 4930,20.9208686789245; 4931,20.9227316200558; 4932,20.924462658791; 4933,20.9260629998872; 4934,20.9275338481015; 4935,20.9288764081908; 4936,20.9300918849124; 4937,20.9311814830232; 4938,20.9321464072803; 4939,20.9329878624408; 4940,20.9337070532618; 4941,20.9343051845004; 4942,20.9347834609135; 4943,20.9351430872583; 4944,20.9353852682919; 4945,20.9355112087713; 4946,20.9355221134535; 4947,20.9354191870958; 4948,20.935203634455; 4949,20.9348766602884; 4950,20.9344394693529; 4951,20.9338932664057; 4952,20.9332392562037; 4953,20.9324786435042; 4954,20.9316126330641; 4955,20.9306424296405; 4956,20.9295692379905; 4957,20.9283942628711; 4958,20.9297013485804; 4959,20.9307623194515; 4960,20.9315800383306; 4961,20.9321573680637; 4962,20.932497171497; 4963,20.9326023114767; 4964,20.9324756508489; 4965,20.9321200524598; 4966,20.9315383791554; 4967,20.930733493782; 4968,
        20.9297082591857; 4969,20.9284655382126; 4970,20.9270081937089; 4971,20.9253390885208; 4972,20.9234610854942; 4973,20.9213770474755; 4974,20.9190898373107; 4975,20.916602317846; 4976,20.9139173519276; 4977,20.9110378024015; 4978,20.907966532114; 4979,20.9047064039111; 4980,20.901260280639; 4981,20.8980863238872; 4982,20.8947571141729; 4983,20.8912757907667; 4984,20.8876454929394; 4985,20.8838693599614; 4986,20.8799505311035; 4987,20.8758921456362; 4988,20.8716973428301; 4989,20.8673692619559; 4990,20.8629110422842; 4991,20.8583258230855; 4992,20.8536167436305; 4993,20.8487869431898; 4994,20.843839561034; 4995,20.8387777364338; 4996,20.8336046086597; 4997,20.8283233169823; 4998,20.8229370006724; 4999,20.8174487990004; 5000,20.811861851237; 5001,20.8061792966527; 5002,20.8004042745184; 5003,20.7945399241044; 5004,20.7885893846815; 5005,20.7825557955202; 5006,20.7764422958913; 5007,20.7702520250652; 5008,20.7639881223126; 5009,20.7576537269041; 5010,20.7512519781103; 5011,
        20.7447860152018; 5012,20.7382589774493; 5013,20.7316740041234; 5014,20.7250342344946; 5015,20.7183428078337; 5016,20.7116028634111; 5017,20.7048421633649; 5018,20.6987034759739; 5019,20.6924864843407; 5020,20.6861947709011; 5021,20.6798319180906; 5022,20.6734015083447; 5023,20.6669071240991; 5024,20.6603523477894; 5025,20.6537407618512; 5026,20.6470759487199; 5027,20.6403614908313; 5028,20.633600970621; 5029,20.6267979705244; 5030,20.6199560729773; 5031,20.6130788604151; 5032,20.6061699152735; 5033,20.5992328199881; 5034,20.5922711569945; 5035,20.5852885087283; 5036,20.5782884576249; 5037,20.5712745861202; 5038,20.5642504766495; 5039,20.5572197116486; 5040,20.550185873553; 5041,20.5431525447983; 5042,20.5361233078201; 5043,20.5291017450539; 5044,20.5220914389355; 5045,20.5150959719003; 5046,20.508118926384; 5047,20.5011638848221; 5048,20.4942344296502; 5049,20.487334143304; 5050,20.480466608219; 5051,20.4736354068308; 5052,20.466844121575; 5053,20.4600963348872; 5054,
        20.453395629203; 5055,20.446745586958; 5056,20.4401497905877; 5057,20.4336118225278; 5058,20.4271352652138; 5059,20.4207237010813; 5060,20.414380712566; 5061,20.4081098821034; 5062,20.4019147921291; 5063,20.3957990250787; 5064,20.3897661633878; 5065,20.383819789492; 5066,20.3779634858268; 5067,20.3722008348279; 5068,20.3665354189309; 5069,20.3609708205712; 5070,20.3555106221847; 5071,20.3501584062067; 5072,20.344917755073; 5073,20.339792251219; 5074,20.3347854770805; 5075,20.329901015093; 5076,20.325142447692; 5077,20.3205133573132; 5078,20.3160173263921; 5079,20.3116579373644; 5080,20.3074387726657; 5081,20.3033634147314; 5082,20.2994354459973; 5083,20.2956584488989; 5084,20.2920360058718; 5085,20.2885716993516; 5086,20.2852691117739; 5087,20.2821318255743; 5088,20.2791634231883; 5089,20.2763674870516; 5090,20.2737475995997; 5091,20.2713073432682; 5092,20.2690503004928; 5093,20.266980053709; 5094,20.2651001853524; 5095,20.2634142778586; 5096,20.2626746818057; 5097,
        20.2629686834111; 5098,20.263375613467; 5099,20.2639000968999; 5100,20.2645467586362; 5101,20.2653202236023; 5102,20.2662101439841; 5103,20.2648106133977; 5104,20.2634177048006; 5105,20.2620345619379; 5106,20.2606643285543; 5107,20.2593101483948; 5108,20.2579751652042; 5109,20.2566625227274; 5110,20.2553753647093; 5111,20.2541168348947; 5112,20.2528900770285; 5113,20.2504581039379; 5114,20.2481346522694; 5115,20.2459220695873; 5116,20.2438227034559; 5117,20.2418389014394; 5118,20.2399730111022; 5119,20.2382273800085; 5120,20.2366043557225; 5121,20.2351062858086; 5122,20.2337355178309; 5123,20.2324943993539; 5124,20.2313852779416; 5125,20.2304105011585; 5126,20.2295724165687; 5127,20.2288733717366; 5128,20.2283157142264; 5129,20.2279017916024; 5130,20.2276339514287; 5131,20.2275145412699; 5132,20.2275459086899; 5133,20.2277304012533; 5134,20.2280703665241; 5135,20.2285681520667; 5136,20.2292261054454; 5137,20.2273155357114; 5138,20.2254197718809; 5139,20.2235395034289; 5140,
        20.2216754198308; 5141,20.2198282105617; 5142,20.2179985650968; 5143,20.2161871729114; 5144,20.2143947234805; 5145,20.2126219062794; 5146,20.2108694107833; 5147,20.2091379264674; 5148,20.2074281428068; 5149,20.2057407492769; 5150,20.2040764353527; 5151,20.2024358905094; 5152,20.2008198042223; 5153,20.1992288659666; 5154,20.1976637652174; 5155,20.1961251914499; 5156,20.1946138341394; 5157,20.193130382761; 5158,20.1916755267899; 5159,20.1902499557014; 5160,20.1888543589705; 5161,20.1874894260726; 5162,20.1861558464827; 5163,20.1848543096761; 5164,20.1835855051281; 5165,20.1823501223137; 5166,20.1811488507082; 5167,20.1799823797867; 5168,20.1788513990246; 5169,20.1777565978968; 5170,20.1766986658788; 5171,20.1756782924455; 5172,20.1746961670724; 5173,20.1737529792344; 5174,20.1728494184069; 5175,20.171986174065; 5176,20.171163935684; 5177,20.1703833927389; 5178,20.1696452347051; 5179,20.1689501510577; 5180,20.1682988312718; 5181,20.1676919648228; 5182,20.1671302411858; 5183,
        20.1666143498359; 5184,20.1661449802484; 5185,20.1657228218985; 5186,20.1653485642613; 5187,20.1650228968121; 5188,20.1647465090261; 5189,20.1645200903784; 5190,20.1643443303442; 5191,20.1642199183988; 5192,20.1641475440173; 5193,20.1641278966749; 5194,20.1641616658469; 5195,20.1642495410083; 5196,20.1643661739323; 5197,20.1638329618205; 5198,20.163315801885; 5199,20.1628149404361; 5200,20.162330623784; 5201,20.161863098239; 5202,20.1614126101113; 5203,20.160979405711; 5204,20.1605637313484; 5205,20.1601658333338; 5206,20.1597859579772; 5207,20.159424351589; 5208,20.1590812604794; 5209,20.1587569309585; 5210,20.1584516093367; 5211,20.158165541924; 5212,20.1578989750308; 5213,20.1576521549672; 5214,20.1574253280435; 5215,20.1572187405698; 5216,20.1570326388565; 5217,20.1568672692136; 5218,20.1567228779515; 5219,20.1565997113803; 5220,20.1564980158103; 5221,20.1564180375516; 5222,20.1563600229146; 5223,20.1563242182093; 5224,20.1563108697461; 5225,20.1563202238352; 5226,
        20.1559096967675; 5227,20.155547525669; 5228,20.1552336725472; 5229,20.1549680994095; 5230,20.1547507682633; 5231,20.154581641116; 5232,20.1544606799751; 5233,20.154387846848; 5234,20.1543631037422; 5235,20.154386412665; 5236,20.1544577356239; 5237,20.1545770346263; 5238,20.1547442716797; 5239,20.1549594087914; 5240,20.155222407969; 5241,20.1555332312199; 5242,20.1558918405514; 5243,20.156298197971; 5244,20.1567522654862; 5245,20.1572540051043; 5246,20.1578033788328; 5247,20.1584003486792; 5248,20.1590448766508; 5249,20.1597369247552; 5250,20.1604764549996; 5251,20.1612634293917; 5252,20.1620978099387; 5253,20.1629795586481; 5254,20.1639086375274; 5255,20.1651512006595; 5256,20.1664258934265; 5257,20.1677328487348; 5258,20.1690721994907; 5259,20.1704440786005; 5260,20.1718486189704; 5261,20.1732859535067; 5262,20.1747562151158; 5263,20.176259536704; 5264,20.1777960511775; 5265,20.1793658914426; 5266,20.1809691904057; 5267,20.1826060809731; 5268,20.184276696051; 5269,
        20.1859811685457; 5270,20.1877196313635; 5271,20.1894922174108; 5272,20.1912990595938; 5273,20.1931402908188; 5274,20.1950160439922; 5275,20.1961346595141; 5276,20.1963192635801; 5277,20.1964439621744; 5278,20.1965078457125; 5279,20.1965100046097; 5280,20.1964495292817; 5281,20.1963255101439; 5282,20.1961370376117; 5283,20.1958832021006; 5284,20.1955630940261; 5285,20.1951758038037; 5286,20.1947204218488; 5287,20.1941960385769; 5288,20.1936017444034; 5289,20.192936629744; 5290,20.1921997850139; 5291,20.1913903006287; 5292,20.1918186560863; 5293,20.1922446070649; 5294,20.1926680401606; 5295,20.1930888419695; 5296,20.1935068990877; 5297,20.1939220981112; 5298,20.1943343256361; 5299,20.1947434682586; 5300,20.1951494125746; 5301,20.1955520451803; 5302,20.1959512526718; 5303,20.1963469216451; 5304,20.1967389386963; 5305,20.1971271904215; 5306,20.1975115634167; 5307,20.1978919442782; 5308,20.1982682196019; 5309,20.1986402759839; 5310,20.1990080000203; 5311,20.1993712783071; 5312,
        20.1997299974406; 5313,20.2000840440167; 5314,20.2004333046315; 5315,20.2007776658812; 5316,20.2011170143617; 5317,20.2014512366692; 5318,20.2017802193998; 5319,20.2021038491495; 5320,20.2024220125144; 5321,20.2027345960906; 5322,20.2030414864742; 5323,20.2033425702613; 5324,20.2036377340479; 5325,20.2039268644301; 5326,20.204209848004; 5327,20.2044865713657; 5328,20.2047569211113; 5329,20.2050207838369; 5330,20.2052780461384; 5331,20.2055285946121; 5332,20.205772315854; 5333,20.2060090964601; 5334,20.2062388230266; 5335,20.2064613821496; 5336,20.2066766604251; 5337,20.2068845444491; 5338,20.2070849208179; 5339,20.2072776761274; 5340,20.2074626969738; 5341,20.2076398699531; 5342,20.2078090816614; 5343,20.2079702186947; 5344,20.2081231676493; 5345,20.2082678151211; 5346,20.2084040477063; 5347,20.2085317520008; 5348,20.2086508146009; 5349,20.2087611221025; 5350,20.2088625611018; 5351,20.2089550181948; 5352,20.2090383799777; 5353,20.2091125330465; 5354,20.2091773639972; 5355,
        20.209232759426; 5356,20.209278605929; 5357,20.2093147901022; 5358,20.2093411985417; 5359,20.2093577178436; 5360,20.209364234604; 5361,20.2093606354189; 5362,20.2093468068845; 5363,20.2093226355968; 5364,20.2092880081518; 5365,20.2092428111458; 5366,20.2091869311747; 5367,20.2091202548347; 5368,20.2090426687218; 5369,20.2089540594321; 5370,20.2088543135617; 5371,20.2087433177066; 5372,20.208620958463; 5373,20.208487122427; 5374,20.2080304057105; 5375,20.2075796723531; 5376,20.2071346090981; 5377,20.206694902689; 5378,20.2062602398692; 5379,20.2058303073822; 5380,20.2054047919713; 5381,20.2049833803801; 5382,20.2045657593519; 5383,20.2041516156302; 5384,20.2037406359584; 5385,20.2033325070799; 5386,20.2029269157382; 5387,20.2025235486768; 5388,20.202122092639; 5389,20.2017222343683; 5390,20.2013236606081; 5391,20.2009260581019; 5392,20.200529113593; 5393,20.200132513825; 5394,20.1997359455412; 5395,20.1993390954852; 5396,20.1989416504002; 5397,20.1985432970298; 5398,
        20.1981437221174; 5399,20.1977426124064; 5400,20.1973396546403; 5401,20.1969345355624; 5402,20.1965269419163; 5403,20.1961165604453; 5404,20.195703077893; 5405,20.1957544561211; 5406,20.1958278361568; 5407,20.1959231890463; 5408,20.1960404858358; 5409,20.1961796975716; 5410,20.1963407952998; 5411,20.1965237500666; 5412,20.1967285329184; 5413,20.1969551149013; 5414,20.1971113923994; 5415,20.1972946426361; 5416,20.1975047775442; 5417,20.1977417090568; 5418,20.1980053491071; 5419,20.198295609628; 5420,20.1986124025527; 5421,20.1989556398141; 5422,20.1993252333454; 5423,20.1997210950796; 5424,20.2001431369497; 5425,20.2005912708888; 5426,20.20106540883; 5427,20.2015654627063; 5428,20.2020913444507; 5429,20.2026429659964; 5430,20.2032202392764; 5431,20.2038230762238; 5432,20.2044513887716; 5433,20.2051050888528; 5434,20.2055026008763; 5435,20.205909857952; 5436,20.206326601114; 5437,20.2067525713964; 5438,20.2071875098335; 5439,20.2076311574594; 5440,20.2080832553084; 5441,
        20.2085435444146; 5442,20.2090117658123; 5443,20.2094876605355; 5444,20.2099709696186; 5445,20.2104614340956; 5446,20.2109587950009; 5447,20.2114627933685; 5448,20.2119731702326; 5449,20.2124896666275; 5450,20.2130120235874; 5451,20.2135399821464; 5452,20.2140732833387; 5453,20.2146116681985; 5454,20.21515487776; 5455,20.2154613348981; 5456,20.2157858100653; 5457,20.2161278893663; 5458,20.216487158906; 5459,20.2168632047888; 5460,20.2172556131196; 5461,20.2176639700031; 5462,20.218087861544; 5463,20.218526873847; 5464,20.2189805930168; 5465,20.2194486051581; 5466,20.2199304963756; 5467,20.2204258527741; 5468,20.2209342604582; 5469,20.2214553055326; 5470,20.2219885741021; 5471,20.2225336522714; 5472,20.2230901261451; 5473,20.2236575818281; 5474,20.2242356054249; 5475,20.2248237830403; 5476,20.225421700779; 5477,20.2260289447458; 5478,20.2266451010453; 5479,20.2272697557822; 5480,20.2279024950613; 5481,20.2285429049872; 5482,20.2291905716647; 5483,20.2298450811984; 5484,
        20.2306264829548; 5485,20.2314070552733; 5486,20.2321864615977; 5487,20.2329643653719; 5488,20.2337404300393; 5489,20.234514319044; 5490,20.2352856958294; 5491,20.2360542238395; 5492,20.2368195665178; 5493,20.2375813873082; 5494,20.2383393496544; 5495,20.2390931170001; 5496,20.239842352789; 5497,20.2405867204649; 5498,20.2413258834715; 5499,20.2420595052525; 5500,20.2427872492517; 5501,20.2435087789128; 5502,20.2442237576795; 5503,20.2449318489956; 5504,20.2456327163048; 5505,20.2462055597892; 5506,20.2467773506576; 5507,20.2473476750149; 5508,20.2479161189655; 5509,20.2484822686144; 5510,20.2490457100662; 5511,20.2496060294255; 5512,20.2501628127972; 5513,20.2507156462859; 5514,20.2512641159963; 5515,20.2518078080331; 5516,20.2523463085011; 5517,20.252879203505; 5518,20.2534060791494; 5519,20.253926521539; 5520,20.2544401167787; 5521,20.254946450973; 5522,20.2554451102268; 5523,20.2559356806446; 5524,20.2564177483312; 5525,20.2568908993914; 5526,20.2573547199298; 5527,
        20.2567932132321; 5528,20.2562792517913; 5529,20.2558117696943; 5530,20.2553897010283; 5531,20.2550119798801; 5532,20.2546775403367; 5533,20.2543853164851; 5534,20.2541342424123; 5535,20.2539232522053; 5536,20.253751279951; 5537,20.2536172597364; 5538,20.2535201256485; 5539,20.2534588117742; 5540,20.2534322522006; 5541,20.2534393810146; 5542,20.2534791323033; 5543,20.2535504401535; 5544,20.2536522386522; 5545,20.2537834618865; 5546,20.2539430439433; 5547,20.2541299189095; 5548,20.2543430208722; 5549,20.2545812839184; 5550,20.2542370077875; 5551,20.2530664365394; 5552,20.252002122497; 5553,20.2513712201693; 5554,20.2508606161382; 5555,20.2504684874695; 5556,20.2501930112292; 5557,20.250032364483; 5558,20.2499847242969; 5559,20.2500482677367; 5560,20.2502211718682; 5561,20.2505016137573; 5562,20.2508877704698; 5563,20.2513778190717; 5564,20.2519699366287; 5565,20.2526623002068; 5566,20.2534530868717; 5567,20.2543404736894; 5568,20.2545684368868; 5569,20.2545952991844; 5570,
        20.2547748034175; 5571,20.2551044261459; 5572,20.2555816439293; 5573,20.2562039333274; 5574,20.2569687708999; 5575,20.2578736332066; 5576,20.2589159968072; 5577,20.2600933382614; 5578,20.2607080904322; 5579,20.2614922646951; 5580,20.2624428913827; 5581,20.2635570008273; 5582,20.2648316233613; 5583,20.2662637893171; 5584,20.2678505290271; 5585,20.2695888728237; 5586,20.2714758510393; 5587,20.2735084940062; 5588,20.275683832057; 5589,20.2779988955239; 5590,20.2804507147394; 5591,20.2830363200358; 5592,20.2857527417456; 5593,20.287933275831; 5594,20.2902872810347; 5595,20.2928113581661; 5596,20.2955021080344; 5597,20.2983561314493; 5598,20.30137002922; 5599,20.3045404021559; 5600,20.3078638510666; 5601,20.3113369767613; 5602,20.3149563800496; 5603,20.3187186617407; 5604,20.3226204226442; 5605,20.3266582635694; 5606,20.3308287853258; 5607,20.3351285887228; 5608,20.3395542745697; 5609,20.344102443676; 5610,20.3487696968511; 5611,20.3535526349044; 5612,20.3584478586453; 5613,
        20.3634519688832; 5614,20.3685615664276; 5615,20.3737732520878; 5616,20.3790836266733; 5617,20.3844892909935; 5618,20.3899868458577; 5619,20.3955728920754; 5620,20.4012440304561; 5621,20.406996861809; 5622,20.4128279869437; 5623,20.4187340066695; 5624,20.4247115217958; 5625,20.4307571331322; 5626,20.4368674414878; 5627,20.4430390476723; 5628,20.4492685524949; 5629,20.4555525567652; 5630,20.4618876612925; 5631,20.4682704668861; 5632,20.4746975743557; 5633,20.4811655845104; 5634,20.4879262825077; 5635,20.4947351059271; 5636,20.5015888105074; 5637,20.5084841519876; 5638,20.5154178861066; 5639,20.5223867686032; 5640,20.5293875552164; 5641,20.5364170016849; 5642,20.5434718637478; 5643,20.550548897144; 5644,20.5576448576122; 5645,20.5647565008914; 5646,20.5718805827205; 5647,20.5790138588384; 5648,20.586153084984; 5649,20.5932950168961; 5650,20.6004364103137; 5651,20.6075740209757; 5652,20.6147046046209; 5653,20.6218249169882; 5654,20.6289317138165; 5655,20.6360217508448; 5656,
        20.6430917838119; 5657,20.6501385684566; 5658,20.657158860518; 5659,20.6641494157348; 5660,20.6711069898461; 5661,20.6780283385905; 5662,20.6849102177072; 5663,20.6916219978308; 5664,20.6982808206227; 5665,20.704883364483; 5666,20.7114263078114; 5667,20.7179063290077; 5668,20.724320106472; 5669,20.730664318604; 5670,20.7369356438036; 5671,20.7432880776978; 5672,20.7500044530223; 5673,20.7566034340189; 5674,20.7630820905407; 5675,20.7694374924404; 5676,20.775666709571; 5677,20.7817668117855; 5678,20.7877348689367; 5679,20.7935679508776; 5680,20.7992631274611; 5681,20.80481746854; 5682,20.8102280439674; 5683,20.8154919235962; 5684,20.8207335623833; 5685,20.8258296442591; 5686,20.8307773164156; 5687,20.8355737260446; 5688,20.8402160203382; 5689,20.8447013464883; 5690,20.8490268516869; 5691,20.8527372730839; 5692,20.8561405741015; 5693,20.859238497801; 5694,20.8622094798199; 5695,20.8650501591149; 5696,20.8677571746427; 5697,20.8703271653601; 5698,20.8727567702236; 5699,
        20.8750426281901; 5700,20.8771813782162; 5701,20.8791696592588; 5702,20.8810041102743; 5703,20.8826813702197; 5704,20.8841980780515; 5705,20.8855508727265; 5706,20.8878103316076; 5707,20.88995816285; 5708,20.8919916574281; 5709,20.8939081063165; 5710,20.8957048004896; 5711,20.8973790309218; 5712,20.8989280885876; 5713,20.9003492644613; 5714,20.9016398495175; 5715,20.9027971347305; 5716,20.9038184110749; 5717,20.9047009695251; 5718,20.9054421010554; 5719,20.9060390966404; 5720,20.9064892472545; 5721,20.9067898438721; 5722,20.9069381774677; 5723,20.9069315390157; 5724,20.9067672194906; 5725,20.9064425098668; 5726,20.9059547011186; 5727,20.9053010842207; 5728,20.9044789501474; 5729,20.9041270815487; 5730,20.9045710996283; 5731,20.9049254599993; 5732,20.9051884105099; 5733,20.9053581990083; 5734,20.9054330733428; 5735,20.9054112813614; 5736,20.9052910709126; 5737,20.9050706898444; 5738,20.904748386005; 5739,20.9043224072428; 5740,20.9037910014058; 5741,20.9031524163424; 5742,
        20.9024048999006; 5743,20.9015466999288; 5744,20.9005760642751; 5745,20.8994912407878; 5746,20.898290477315; 5747,20.8977695590711; 5748,20.8975292835483; 5749,20.8972316915962; 5750,20.8968757315691; 5751,20.8964603518214; 5752,20.8959845007074; 5753,20.8954471265814; 5754,20.8948471777979; 5755,20.894183602711; 5756,20.8934553496752; 5757,20.8933963480882; 5758,20.8933109488347; 5759,20.8931985464964; 5760,20.8932305342166; 5761,20.8932245353698; 5762,20.893180054963; 5763,20.8930965980034; 5764,20.8929736694979; 5765,20.8928107744537; 5766,20.8926074178776; 5767,20.8923631047769; 5768,20.8920773401585; 5769,20.8917496290295; 5770,20.8913794763969; 5771,20.8909663872678; 5772,20.8913146992444; 5773,20.8916633063097; 5774,20.8920122021069; 5775,20.8923613802792; 5776,20.8927108344698; 5777,20.8930605583219; 5778,20.8934105454787; 5779,20.8937607895834; 5780,20.8941112842791; 5781,20.8944620232091; 5782,20.8948130000166; 5783,20.8951642083447; 5784,20.8955156418366; 5785,
        20.8958672941356; 5786,20.8962191588847; 5787,20.8965712297273; 5788,20.8969235003065; 5789,20.8972759642655; 5790,20.8976286152475; 5791,20.8979814468956; 5792,20.8983344528531; 5793,20.8986876267632; 5794,20.899040962269; 5795,20.8993944530137; 5796,20.8997480926406; 5797,20.9001018747928; 5798,20.9004557931135; 5799,20.900809841246; 5800,20.9011640128333; 5801,20.9015183015187; 5802,20.9018727009454; 5803,20.9022272047565; 5804,20.9025818065954; 5805,20.902936500105; 5806,20.9032912789288; 5807,20.9036461367097; 5808,20.9040010670911; 5809,20.9043560637161; 5810,20.9047111202279; 5811,20.9050662302698; 5812,20.9054213874848; 5813,20.9057765855162; 5814,20.9061318180071; 5815,20.9064870786009; 5816,20.9068423609406; 5817,20.9071976586694; 5818,20.9075529654306; 5819,20.9079082748673; 5820,20.9082635806228; 5821,20.9086188763402; 5822,20.9089741556626; 5823,20.9093294122334; 5824,20.9096846396957; 5825,20.9100398316926; 5826,20.9103949818674; 5827,20.9107500838633; 5828,
        20.9111051313234; 5829,20.911460117891; 5830,20.9118150372092; 5831,20.9121698829213; 5832,20.9125246486703; 5833,20.9128793280996; 5834,20.9132339148523; 5835,20.9135884025716; 5836,20.9139427849007; 5837,20.9142970554827; 5838,20.9146512079609; 5839,20.9150052359785; 5840,20.9153591331786; 5841,20.9157128932045; 5842,20.9160665096993; 5843,20.9164199763062; 5844,20.9167732866685; 5845,20.9171264344292; 5846,20.9174794132317; 5847,20.917832216719; 5848,20.9181848385344; 5849,20.9185372723212; 5850,20.9187231550167; 5851,20.9184212908804; 5852,20.9180836921443; 5853,20.9177099609986; 5854,20.9172996996333; 5855,20.9168525102385; 5856,20.9163679950046; 5857,20.9158457561214; 5858,20.9151964240807; 5859,20.9145136279812; 5860,20.9137969128922; 5861,20.9130458238827; 5862,20.9122599060219; 5863,20.911438704379; 5864,20.910581764023; 5865,20.909688630023; 5866,20.9087588474483; 5867,20.9077919613678; 5868,20.9067875168508; 5869,20.9057450589663; 5870,20.9051425383946; 5871,
        20.9047042925732; 5872,20.9044447621855; 5873,20.90419208231; 5874,20.903946306251; 5875,20.9037074873129; 5876,20.9034756788; 5877,20.9032509340167; 5878,20.9030333062674; 5879,20.9028228488563; 5880,20.9026196150879; 5881,20.9024236582665; 5882,20.9022350316965; 5883,20.9020537886821; 5884,20.9018799825278; 5885,20.901713666538; 5886,20.9015548940169; 5887,20.901403718269; 5888,20.9012601925985; 5889,20.9011243703099; 5890,20.9009963047075; 5891,20.9008760490957; 5892,20.9007636567787; 5893,20.900659181061; 5894,20.9005626752469; 5895,20.9004741926408; 5896,20.900393786547; 5897,20.9003215102699; 5898,20.9002574171138; 5899,20.9002015603832; 5900,20.9001539933822; 5901,20.9001147694154; 5902,20.900083941787; 5903,20.9000615638014; 5904,20.9006212449191; 5905,20.9011568938704; 5906,20.9016689321903; 5907,20.9021577814139; 5908,20.9026238630762; 5909,20.9030675987123; 5910,20.9034894098574; 5911,20.9038897180464; 5912,20.9042689448144; 5913,20.9046275116965; 5914,
        20.9049658402277; 5915,20.9052843519431; 5916,20.9055834683779; 5917,20.905863611067; 5918,20.9061252015454; 5919,20.9063686613484; 5920,20.9065944120109; 5921,20.9068028750681; 5922,20.9069944720549; 5923,20.9071696245064; 5924,20.9073287539578; 5925,20.907472281944; 5926,20.9076006300002; 5927,20.9077142196614; 5928,20.9078134724626; 5929,20.907898809939; 5930,20.9079706536257; 5931,20.9080294250575; 5932,20.9080755457698; 5933,20.9081094372974; 5934,20.9081315211755; 5935,20.9081422189391; 5936,20.9081419521234; 5937,20.9081311422633; 5938,20.9081102108939; 5939,20.9078976979179; 5940,20.9076659130064; 5941,20.9074151672692; 5942,20.907145771816; 5943,20.9068580377564; 5944,20.9065522762002; 5945,20.906228798257; 5946,20.9058879150366; 5947,20.9055299376486; 5948,20.9051551772027; 5949,20.9047639448086; 5950,20.904356551576; 5951,20.9039333086147; 5952,20.9034945270342; 5953,20.9030405179443; 5954,20.9025715924546; 5955,20.902088061675; 5956,20.901590236715; 5957,
        20.9010784286843; 5958,20.9005529486928; 5959,20.9000141078499; 5960,20.8994622172655; 5961,20.8988975880492; 5962,20.8983205313107; 5963,20.8977313581597; 5964,20.897130379706; 5965,20.8965179070591; 5966,20.8958942513288; 5967,20.8952597236248; 5968,20.8946146350568; 5969,20.8939592967345; 5970,20.8932940197675; 5971,20.8926191152656; 5972,20.8919348943384; 5973,20.8912416680956; 5974,20.890539747647; 5975,20.8898294441022; 5976,20.8891110685709; 5977,20.8883849321629; 5978,20.8876513459877; 5979,20.8869106211551; 5980,20.8861630687748; 5981,20.8854089999565; 5982,20.8846487258099; 5983,20.8838825574446; 5984,20.8831108059704; 5985,20.882333782497; 5986,20.881551798134; 5987,20.8807651639911; 5988,20.8799741911781; 5989,20.8791791908046; 5990,20.8783804739803; 5991,20.8775783518149; 5992,20.8767731354181; 5993,20.8759651358996; 5994,20.8751546643691; 5995,20.8743420319363; 5996,20.8735275497108; 5997,20.8727115288024; 5998,20.8718942803208; 5999,20.8710761153756; 6000,
        20.8702573450766; 6001,20.8694382805334; 6002,20.8686192328557; 6003,20.8678005131532; 6004,20.8669824325357; 6005,20.8661653021128; 6006,20.8653494329941; 6007,20.8645351362895; 6008,20.8637227231085; 6009,20.862912504561; 6010,20.8621047917564; 6011,20.8612998958047; 6012,20.8604981278154; 6013,20.8596997988983; 6014,20.858905220163; 6015,20.8581147027192; 6016,20.8573285576767; 6017,20.8565470961451; 6018,20.8557706292341; 6019,20.8549994680534; 6020,20.8542339237127; 6021,20.8534743073217; 6022,20.8521375728883; 6023,20.8504150563886; 6024,20.8487563467939; 6025,20.8471611075285; 6026,20.8456290020169; 6027,20.8441596936834; 6028,20.8427528459525; 6029,20.8414081222486; 6030,20.8399618435974; 6031,20.83858629664; 6032,20.8372810399328; 6033,20.8360456320323; 6034,20.8348796314947; 6035,20.8337825968765; 6036,20.832754086734; 6037,20.8318877436536; 6038,20.8310942116139; 6039,20.8303731062923; 6040,20.8297240433663; 6041,20.8291466385133; 6042,20.8286405074106; 6043,
        20.8282052657357; 6044,20.827840529166; 6045,20.8275459133788; 6046,20.8273210340517; 6047,20.8271655068619; 6048,20.827078947487; 6049,20.8270609716043; 6050,20.8271111948912; 6051,20.8284983148919; 6052,20.8298807584928; 6053,20.8312589561388; 6054,20.8326333382748; 6055,20.8340043353457; 6056,20.8353723777965; 6057,20.8367378960721; 6058,20.8381013206174; 6059,20.8394630818772; 6060,20.8408236102965; 6061,20.8421833363203; 6062,20.8435426903934; 6063,20.8449021029607; 6064,20.8462620044672; 6065,20.8476228253578; 6066,20.8489849960773; 6067,20.8503489470707; 6068,20.851715108783; 6069,20.853083911659; 6070,20.8544557861436; 6071,20.8558311626818; 6072,20.8572104717184; 6073,20.8585941436984; 6074,20.8599826090667; 6075,20.8613762982682; 6076,20.8627756417479; 6077,20.8641810699505; 6078,20.8655930133212; 6079,20.8670119023046; 6080,20.8684381673459; 6081,20.8698722388898; 6082,20.8713145473813; 6083,20.8721590104606; 6084,20.8729792464979; 6085,20.8737753177074; 6086,
        20.8745472863033; 6087,20.8752952145; 6088,20.8760191645114; 6089,20.8767191985519; 6090,20.8773953788357; 6091,20.8780477675769; 6092,20.8786764269898; 6093,20.8792814192886; 6094,20.8798628066874; 6095,20.8804206514004; 6096,20.880955015642; 6097,20.8814659616262; 6098,20.8819535515673; 6099,20.8824178476794; 6100,20.8828589121769; 6101,20.8832768072738; 6102,20.8836715951844; 6103,20.8840433381228; 6104,20.8843920983034; 6105,20.8847179379402; 6106,20.8850209192475; 6107,20.8853011044396; 6108,20.8855585557305; 6109,20.8857933353345; 6110,20.8860055054658; 6111,20.8861951283385; 6112,20.886362266167; 6113,20.8865069811654; 6114,20.8866293355479; 6115,20.8867293915288; 6116,20.8868072113221; 6117,20.8868628571421; 6118,20.886896391203; 6119,20.8869078757191; 6120,20.8868973729045; 6121,20.8868649449734; 6122,20.88681065414; 6123,20.8867345626185; 6124,20.8866367326232; 6125,20.8865172263682; 6126,20.8863761060677; 6127,20.8862134339359; 6128,20.8860292721871; 6129,
        20.8858236830354; 6130,20.8855967286951; 6131,20.8853484713802; 6132,20.8850789733052; 6133,20.8847882966841; 6134,20.8844765037311; 6135,20.8841436566605; 6136,20.8837898176864; 6137,20.883415049023; 6138,20.8830194128847; 6139,20.8826029714855; 6140,20.8821657870396; 6141,20.8817079217613; 6142,20.8812294378648; 6143,20.8807303975642; 6144,20.8802108630738; 6145,20.8796708966077; 6146,20.8791105603803; 6147,20.8785299166056; 6148,20.8779290274979; 6149,20.8773079552713; 6150,20.8766667621401; 6151,20.8760055103186; 6152,20.8749100917339; 6153,20.8736139577254; 6154,20.8723328268941; 6155,20.8710663643793; 6156,20.8698142353204; 6157,20.8685761048567; 6158,20.8673516381276; 6159,20.8661405002722; 6160,20.8649423564299; 6161,20.8637568717401; 6162,20.8625837113419; 6163,20.8614225403749; 6164,20.8602730239782; 6165,20.8591348272911; 6166,20.858007615453; 6167,20.8568910536033; 6168,20.8557848068811; 6169,20.8544539001649; 6170,20.8527700803237; 6171,20.851130109626; 6172,
        20.8495332612422; 6173,20.8479788083428; 6174,20.8464660240983; 6175,20.8449941816792; 6176,20.843562554256; 6177,20.8421704149992; 6178,20.8408170370792; 6179,20.8395016936666; 6180,20.8382236579319; 6181,20.8369822030455; 6182,20.8357766021781; 6183,20.8346061285; 6184,20.8334700551817; 6185,20.8323676553938; 6186,20.8312982023067; 6187,20.830260969091; 6188,20.8292552289171; 6189,20.8282802549556; 6190,20.8273353203769; 6191,20.8264196983515; 6192,20.82553266205; 6193,20.8246734846428; 6194,20.8238414393004; 6195,20.8230357991933; 6196,20.822255837492; 6197,20.821500827367; 6198,20.8207700419888; 6199,20.8200627545279; 6200,20.8193782381548; 6201,20.8193326429547; 6202,20.8197921850663; 6203,20.82033130782; 6204,20.8209499320718; 6205,20.8216479786774; 6206,20.8224253684926; 6207,20.8232820223731; 6208,20.8246920220857; 6209,20.8263269146991; 6210,20.8280236879561; 6211,20.8297826719983; 6212,20.831604196967; 6213,20.8334885930037; 6214,20.8354361902499; 6215,
        20.8374473188469; 6216,20.8395223089363; 6217,20.8416614906593; 6218,20.8438651941576; 6219,20.8461337495725; 6220,20.8484674870454; 6221,20.8508667367178; 6222,20.8533318287311; 6223,20.8558630932268; 6224,20.8584608603463; 6225,20.861125460231; 6226,20.8638572230224; 6227,20.8666564788619; 6228,20.8695235578909; 6229,20.8724587902509; 6230,20.8741205025248; 6231,20.8757772919533; 6232,20.8774286739103; 6233,20.8790741637698; 6234,20.8807132769056; 6235,20.8823455286918; 6236,20.8839704345022; 6237,20.8855875097108; 6238,20.8871962696915; 6239,20.8887962298182; 6240,20.8903869054649; 6241,20.8919678120055; 6242,20.8935384648139; 6243,20.8950983792641; 6244,20.89664707073; 6245,20.8981840545854; 6246,20.8997088462045; 6247,20.901220960961; 6248,20.9027199142289; 6249,20.9042052213822; 6250,20.9056763977947; 6251,20.9071329588404; 6252,20.9085744198933; 6253,20.9100002963272; 6254,20.9114101035162; 6255,20.912803356834; 6256,20.9141795716547; 6257,20.9155382633522; 6258,
        20.9168789473004; 6259,20.9182011388733; 6260,20.9195043534447; 6261,20.9207881063887; 6262,20.9220519130791; 6263,20.9232952888898; 6264,20.9245177491949; 6265,20.9257188093682; 6266,20.9268979847836; 6267,20.9280547908152; 6268,20.9291887428367; 6269,20.9302993562223; 6270,20.9313861463457; 6271,20.9324486285809; 6272,20.9334863183018; 6273,20.9344987308825; 6274,20.9354853816967; 6275,20.9364457861185; 6276,20.9373794595218; 6277,20.9382859172804; 6278,20.9391646747684; 6279,20.9400152473596; 6280,20.9408371504281; 6281,20.9416298993476; 6282,20.9423930094922; 6283,20.9431259962358; 6284,20.9437767593167; 6285,20.944399362451; 6286,20.9449932878748; 6287,20.9455580178239; 6288,20.9460930345345; 6289,20.9465978202425; 6290,20.9470718571839; 6291,20.9475146275947; 6292,20.947925613711; 6293,20.9483042977687; 6294,20.9486501620039; 6295,20.9489626886525; 6296,20.9492413599506; 6297,20.9494856581341; 6298,20.949695065439; 6299,20.9498690641014; 6300,20.8299999237061; 9499,
        20.8299999237061; 9500,20.9132339148523; 9501,20.9135884025716; 9502,20.9139427849007; 9503,20.9142970554827; 9504,20.9146512079609; 9505,20.9150052359785; 9506,20.9153591331786; 9507,20.9157128932045; 9508,20.9160665096993; 9509,20.9164199763062; 9510,20.9167732866685; 9511,20.9171264344292; 9512,20.9174794132317; 9513,20.917832216719; 9514,20.9181848385344; 9515,20.9185372723212; 9516,20.9187231550167; 9517,20.9184212908804; 9518,20.9180836921443; 9519,20.9177099609986; 9520,20.9172996996333; 9521,20.9168525102385; 9522,20.9163679950046; 9523,20.9158457561214; 9524,20.9151964240807; 9525,20.9145136279812; 9526,20.9137969128922; 9527,20.9130458238827; 9528,20.9122599060219; 9529,20.911438704379; 9530,20.910581764023; 9531,20.909688630023; 9532,20.9087588474483; 9533,20.9077919613678; 9534,20.9067875168508; 9535,20.9057450589663; 9536,20.9051425383946; 9537,20.9047042925732; 9538,20.9044447621855; 9539,20.90419208231; 9540,20.903946306251; 9541,20.9037074873129; 9542,
        20.9034756788; 9543,20.9032509340167; 9544,20.9030333062674; 9545,20.9028228488563; 9546,20.9026196150879; 9547,20.9024236582665; 9548,20.9022350316965; 9549,20.9020537886821; 9550,20.9018799825278; 9551,20.901713666538; 9552,20.9015548940169; 9553,20.901403718269; 9554,20.9012601925985; 9555,20.9011243703099; 9556,20.9009963047075; 9557,20.9008760490957; 9558,20.9007636567787; 9559,20.900659181061; 9560,20.9005626752469; 9561,20.9004741926408; 9562,20.900393786547; 9563,20.9003215102699; 9564,20.9002574171138; 9565,20.9002015603832; 9566,20.9001539933822; 9567,20.9001147694154; 9568,20.900083941787; 9569,20.9000615638014; 9570,20.9006212449191; 9571,20.9011568938704; 9572,20.9016689321903; 9573,20.9021577814139; 9574,20.9026238630762; 9575,20.9030675987123; 9576,20.9034894098574; 9577,20.9038897180464; 9578,20.9042689448144; 9579,20.9046275116965; 9580,20.9049658402277; 9581,20.9052843519431; 9582,20.9055834683779; 9583,20.905863611067; 9584,20.9061252015454; 9585,
        20.9063686613484; 9586,20.9065944120109; 9587,20.9068028750681; 9588,20.9069944720549; 9589,20.9071696245064; 9590,20.9073287539578; 9591,20.907472281944; 9592,20.9076006300002; 9593,20.9077142196614; 9594,20.9078134724626; 9595,20.907898809939; 9596,20.9079706536257; 9597,20.9080294250575; 9598,20.9080755457698; 9599,20.9081094372974; 9600,20.9081315211755; 9601,20.9081422189391; 9602,20.9081419521234; 9603,20.9081311422633; 9604,20.9081102108939; 9605,20.9078976979179; 9606,20.9076659130064; 9607,20.9074151672692; 9608,20.907145771816; 9609,20.9068580377564; 9610,20.9065522762002; 9611,20.906228798257; 9612,20.9058879150366; 9613,20.9055299376486; 9614,20.9051551772027; 9615,20.9047639448086; 9616,20.904356551576; 9617,20.9039333086147; 9618,20.9034945270342; 9619,20.9030405179443; 9620,20.9025715924546; 9621,20.902088061675; 9622,20.901590236715; 9623,20.9010784286843; 9624,20.9005529486928; 9625,20.9000141078499; 9626,20.8994622172655; 9627,20.8988975880492; 9628,
        20.8983205313107; 9629,20.8977313581597; 9630,20.897130379706; 9631,20.8965179070591; 9632,20.8958942513288; 9633,20.8952597236248; 9634,20.8946146350568; 9635,20.8939592967345; 9636,20.8932940197675; 9637,20.8926191152656; 9638,20.8919348943384; 9639,20.8912416680956; 9640,20.890539747647; 9641,20.8898294441022; 9642,20.8891110685709; 9643,20.8883849321629; 9644,20.8876513459877; 9645,20.8869106211551; 9646,20.8861630687748; 9647,20.8854089999565; 9648,20.8846487258099; 9649,20.8838825574446; 9650,20.8831108059704; 9651,20.882333782497; 9652,20.881551798134; 9653,20.8807651639911; 9654,20.8799741911781; 9655,20.8791791908046; 9656,20.8783804739803; 9657,20.8775783518149; 9658,20.8767731354181; 9659,20.8759651358996; 9660,20.8751546643691; 9661,20.8743420319363; 9662,20.8735275497108; 9663,20.8727115288024; 9664,20.8718942803208; 9665,20.8710761153756; 9666,20.8702573450766; 9667,20.8694382805334; 9668,20.8686192328557; 9669,20.8678005131532; 9670,20.8669824325357; 9671,
        20.8661653021128; 9672,20.8653494329941; 9673,20.8645351362895; 9674,20.8637227231085; 9675,20.862912504561; 9676,20.8621047917564; 9677,20.8612998958047; 9678,20.8604981278154; 9679,20.8596997988983; 9680,20.858905220163; 9681,20.8581147027192; 9682,20.8573285576767; 9683,20.8565470961451; 9684,20.8557706292341; 9685,20.8549994680534; 9686,20.8542339237127; 9687,20.8534743073217; 9688,20.8521375728883; 9689,20.8504150563886; 9690,20.8487563467939; 9691,20.8471611075285; 9692,20.8456290020169; 9693,20.8441596936834; 9694,20.8427528459525; 9695,20.8414081222486; 9696,20.8399618435974; 9697,20.83858629664; 9698,20.8372810399328; 9699,20.8360456320323; 9700,20.8348796314947; 9701,20.8337825968765; 9702,20.832754086734; 9703,20.8318877436536; 9704,20.8310942116139; 9705,20.8303731062923; 9706,20.8297240433663; 9707,20.8291466385133; 9708,20.8286405074106; 9709,20.8282052657357; 9710,20.827840529166; 9711,20.8275459133788; 9712,20.8273210340517; 9713,20.8271655068619; 9714,
        20.827078947487; 9715,20.8270609716043; 9716,20.8271111948912; 9717,20.8284983148919; 9718,20.8298807584928; 9719,20.8312589561388; 9720,20.8326333382748; 9721,20.8340043353457; 9722,20.8353723777965; 9723,20.8367378960721; 9724,20.8381013206174; 9725,20.8394630818772; 9726,20.8408236102965; 9727,20.8421833363203; 9728,20.8435426903934; 9729,20.8449021029607; 9730,20.8462620044672; 9731,20.8476228253578; 9732,20.8489849960773; 9733,20.8503489470707; 9734,20.851715108783; 9735,20.853083911659; 9736,20.8544557861436; 9737,20.8558311626818; 9738,20.8572104717184; 9739,20.8585941436984; 9740,20.8599826090667; 9741,20.8613762982682; 9742,20.8627756417479; 9743,20.8641810699505; 9744,20.8655930133212; 9745,20.8670119023046; 9746,20.8684381673459; 9747,20.8698722388898; 9748,20.8713145473813; 9749,20.8721590104606; 9750,20.8729792464979; 9751,20.8737753177074; 9752,20.8745472863033; 9753,20.8752952145; 9754,20.8760191645114; 9755,20.8767191985519; 9756,20.8773953788357; 9757,
        20.8780477675769; 9758,20.8786764269898; 9759,20.8792814192886; 9760,20.8798628066874; 9761,20.8804206514004; 9762,20.880955015642; 9763,20.8814659616262; 9764,20.8819535515673; 9765,20.8824178476794; 9766,20.8828589121769; 9767,20.8832768072738; 9768,20.8836715951844; 9769,20.8840433381228; 9770,20.8843920983034; 9771,20.8847179379402; 9772,20.8850209192475; 9773,20.8853011044396; 9774,20.8855585557305; 9775,20.8857933353345; 9776,20.8860055054658; 9777,20.8861951283385; 9778,20.886362266167; 9779,20.8865069811654; 9780,20.8866293355479; 9781,20.8867293915288; 9782,20.8868072113221; 9783,20.8868628571421; 9784,20.886896391203; 9785,20.8869078757191; 9786,20.8868973729045; 9787,20.8868649449734; 9788,20.88681065414; 9789,20.8867345626185; 9790,20.8866367326232; 9791,20.8865172263682; 9792,20.8863761060677; 9793,20.8862134339359; 9794,20.8860292721871; 9795,20.8858236830354; 9796,20.8855967286951; 9797,20.8853484713802; 9798,20.8850789733052; 9799,20.8847882966841; 9800,
        20.8844765037311; 9801,20.8841436566605; 9802,20.8837898176864; 9803,20.883415049023; 9804,20.8830194128847; 9805,20.8826029714855; 9806,20.8821657870396; 9807,20.8817079217613; 9808,20.8812294378648; 9809,20.8807303975642; 9810,20.8802108630738; 9811,20.8796708966077; 9812,20.8791105603803; 9813,20.8785299166056; 9814,20.8779290274979; 9815,20.8773079552713; 9816,20.8766667621401; 9817,20.8760055103186; 9818,20.8749100917339; 9819,20.8736139577254; 9820,20.8723328268941; 9821,20.8710663643793; 9822,20.8698142353204; 9823,20.8685761048567; 9824,20.8673516381276; 9825,20.8661405002722; 9826,20.8649423564299; 9827,20.8637568717401; 9828,20.8625837113419; 9829,20.8614225403749; 9830,20.8602730239782; 9831,20.8591348272911; 9832,20.858007615453; 9833,20.8568910536033; 9834,20.8557848068811; 9835,20.8544539001649; 9836,20.8527700803237; 9837,20.851130109626; 9838,20.8495332612422; 9839,20.8479788083428; 9840,20.8464660240983; 9841,20.8449941816792; 9842,20.843562554256; 9843,
        20.8421704149992; 9844,20.8408170370792; 9845,20.8395016936666; 9846,20.8382236579319; 9847,20.8369822030455; 9848,20.8357766021781; 9849,20.8346061285; 9850,20.8334700551817; 9851,20.8323676553938; 9852,20.8312982023067; 9853,20.830260969091; 9854,20.8292552289171; 9855,20.8282802549556; 9856,20.8273353203769; 9857,20.8264196983515; 9858,20.82553266205; 9859,20.8246734846428; 9860,20.8238414393004; 9861,20.8230357991933; 9862,20.822255837492; 9863,20.821500827367; 9864,20.8207700419888; 9865,20.8200627545279; 9866,20.8193782381548; 9867,20.8193326429547; 9868,20.8197921850663; 9869,20.82033130782; 9870,20.8209499320718; 9871,20.8216479786774; 9872,20.8224253684926; 9873,20.8232820223731; 9874,20.8246920220857; 9875,20.8263269146991; 9876,20.8280236879561; 9877,20.8297826719983; 9878,20.831604196967; 9879,20.8334885930037; 9880,20.8354361902499; 9881,20.8374473188469; 9882,20.8395223089363; 9883,20.8416614906593; 9884,20.8438651941576; 9885,20.8461337495725; 9886,
        20.8484674870454; 9887,20.8508667367178; 9888,20.8533318287311; 9889,20.8558630932268; 9890,20.8584608603463; 9891,20.861125460231; 9892,20.8638572230224; 9893,20.8666564788619; 9894,20.8695235578909; 9895,20.8724587902509; 9896,20.8741205025248; 9897,20.8757772919533; 9898,20.8774286739103; 9899,20.8790741637698; 9900,20.8807132769056; 9901,20.8823455286918; 9902,20.8839704345022; 9903,20.8855875097108; 9904,20.8871962696915; 9905,20.8887962298182; 9906,20.8903869054649; 9907,20.8919678120055; 9908,20.8935384648139; 9909,20.8950983792641; 9910,20.89664707073; 9911,20.8981840545854; 9912,20.8997088462045; 9913,20.901220960961; 9914,20.9027199142289; 9915,20.9042052213822; 9916,20.9056763977947; 9917,20.9071329588404; 9918,20.9085744198933; 9919,20.9100002963272; 9920,20.9114101035162; 9921,20.912803356834; 9922,20.9141795716547; 9923,20.9155382633522; 9924,20.9168789473004; 9925,20.9182011388733; 9926,20.9195043534447; 9927,20.9207881063887; 9928,20.9220519130791; 9929,
        20.9232952888898; 9930,20.9245177491949; 9931,20.9257188093682; 9932,20.9268979847836; 9933,20.9280547908152; 9934,20.9291887428367; 9935,20.9302993562223; 9936,20.9313861463457; 9937,20.9324486285809; 9938,20.9334863183018; 9939,20.9344987308825; 9940,20.9354853816967; 9941,20.9364457861185; 9942,20.9373794595218; 9943,20.9382859172804; 9944,20.9391646747684; 9945,20.9400152473596; 9946,20.9408371504281; 9947,20.9416298993476; 9948,20.9423930094922; 9949,20.9431259962358; 9950,20.9437767593167; 9951,20.944399362451; 9952,20.9449932878748; 9953,20.9455580178239; 9954,20.9460930345345; 9955,20.9465978202425; 9956,20.9470718571839; 9957,20.9475146275947; 9958,20.947925613711; 9959,20.9483042977687; 9960,20.9486501620039; 9961,20.9489626886525; 9962,20.9492413599506; 9963,20.9494856581341; 9964,20.949695065439; 9965,20.9498690641014; 9966,20.9500071363573; 9967,20.9501087644427; 9968,20.9501734305935; 9969,20.9502006170458; 9970,20.9501898060355; 9971,20.9501404797987; 9972,
        20.9500521205714; 9973,20.9499242105896; 9974,20.9497562320893; 9975,20.9495476673065; 9976,20.9492979984772; 9977,20.9490067078373; 9978,20.948673277623; 9979,20.9482971900701; 9980,20.9478779274148; 9981,20.947414971893; 9982,20.9469078057407; 9983,20.9463559111939; 9984,20.9457587704886; 9985,20.9451158658609; 9986,20.9444266795467; 9987,20.943690693782; 9988,20.9429073908028; 9989,20.9420762528452; 9990,20.9411967621451; 9991,20.9402684009386; 9992,20.9392906514616; 9993,20.9382629959502; 9994,20.9371849166403; 9995,20.9360558957679; 9996,20.9348754155692; 9997,20.9340809268723; 9998,20.9334740609913; 9999,20.9328503836723; 10000,20.9322097742264; 10001,20.9315521119645; 10002,20.9308772761973; 10003,20.9301851462358; 10004,20.929475601391; 10005,20.9287485209736; 10006,20.9280037842947; 10007,20.927241270665; 10008,20.9264608593955; 10009,20.9256624297971; 10010,20.9248458611806; 10011,20.9240110328571; 10012,20.9231578241373; 10013,20.9222861143321; 10014,
        20.9216439054887; 10015,20.9213940763968; 10016,20.9211610079722; 10017,20.9209449714945; 10018,20.9207462382435; 10019,20.9205650794987; 10020,20.9204017665401; 10021,20.9202565706472; 10022,20.9201297630997; 10023,20.9200216151775; 10024,20.9199323981601; 10025,20.9198623833273; 10026,20.9198118419589; 10027,20.9197810453344; 10028,20.9197702647337; 10029,20.9197797714364; 10030,20.9198098367223; 10031,20.919860731871; 10032,20.9199327281623; 10033,20.9200260968758; 10034,20.9201411092914; 10035,20.9202780366886; 10036,20.9204371503472; 10037,20.920618721547; 10038,20.9208230215675; 10039,20.9210503216886; 10040,20.9213008931899; 10041,20.9215750073512; 10042,20.9218729354521; 10043,20.9218919027313; 10044,20.9219524450347; 10045,20.9220546390823; 10046,20.9221985615943; 10047,20.9223842892907; 10048,20.9226118988916; 10049,20.9228814671172; 10050,20.9231930706876; 10051,20.9235467863228; 10052,20.923942690743; 10053,20.923879454379; 10054,20.9238310104441; 10055,
        20.9237971312407; 10056,20.9237775890713; 10057,20.9237721562383; 10058,20.9237806050443; 10059,20.9238027077917; 10060,20.9238382367829; 10061,20.9238869643205; 10062,20.9239486627069; 10063,20.9240231042445; 10064,20.9241100612359; 10065,20.9242093059835; 10066,20.9243206107897; 10067,20.9244437479571; 10068,20.9245784897881; 10069,20.9247246085852; 10070,20.9248818766508; 10071,20.9250500662874; 10072,20.9252289497975; 10073,20.9254182994836; 10074,20.925617887648; 10075,20.9258274865934; 10076,20.9260468686221; 10077,20.9262758060365; 10078,20.9265140711393; 10079,20.9267614362328; 10080,20.9270176736196; 10081,20.927282555602; 10082,20.9275558544826; 10083,20.9278373425638; 10084,20.928126792148; 10085,20.9284239755379; 10086,20.9287286650357; 10087,20.9290406329441; 10088,20.9293596515654; 10089,20.9296854932021; 10090,20.9300179301567; 10091,20.9303567347316; 10092,20.9307016792294; 10093,20.9310525359525; 10094,20.9314090772034; 10095,20.9317710752844; 10096,
        20.9321383024982; 10097,20.9325105311472; 10098,20.9328875335337; 10099,20.9332690819604; 10100,20.9336549487296; 10101,20.9340449061439; 10102,20.9344387265056; 10103,20.9348361821174; 10104,20.9352370452815; 10105,20.9356410883006; 10106,20.9360480834771; 10107,20.9364578031133; 10108,20.9368700195119; 10109,20.9372845049753; 10110,20.9377010318059; 10111,20.9385497101365; 10112,20.9394066333949; 10113,20.9402389725856; 10114,20.9410467962668; 10115,20.9418301729965; 10116,20.9425891713329; 10117,20.9433238598342; 10118,20.9440343070583; 10119,20.9447205815635; 10120,20.9453827519078; 10121,20.9460208866494; 10122,20.9466350543464; 10123,20.9472253235569; 10124,20.9477917628389; 10125,20.9483344407508; 10126,20.9488534258504; 10127,20.9493487866961; 10128,20.9498205918458; 10129,20.9503234913378; 10130,20.9508059712326; 10131,20.9512681332261; 10132,20.9517100790145; 10133,20.9521319102937; 10134,20.9525337287598; 10135,20.9529156361089; 10136,20.953277734037; 10137,
        20.9536201242402; 10138,20.9539429084144; 10139,20.9542461882558; 10140,20.9545300654603; 10141,20.9547946417241; 10142,20.9550400187431; 10143,20.9552662982135; 10144,20.9554735818312; 10145,20.9556619712923; 10146,20.9558315682928; 10147,20.9559824745288; 10148,20.9561147916963; 10149,20.9562286214915; 10150,20.9563240656102; 10151,20.9564012257486; 10152,20.9564602036027; 10153,20.9565011008685; 10154,20.9565240192421; 10155,20.9565290604196; 10156,20.9565163260969; 10157,20.9564859179702; 10158,20.9564379377355; 10159,20.9563724870887; 10160,20.956289667726; 10161,20.9561895813434; 10162,20.9560723296369; 10163,20.9559380143027; 10164,20.9557867370366; 10165,20.9556185995349; 10166,20.9554337034934; 10167,20.9552321506083; 10168,20.9550140425756; 10169,20.9547794810914; 10170,20.9545285678517; 10171,20.9542614045525; 10172,20.9539780928899; 10173,20.9536787345599; 10174,20.9533634312585; 10175,20.9530322846819; 10176,20.9526853965261; 10177,20.952322868487; 10178,
        20.9519448022608; 10179,20.9515512995435; 10180,20.9511424620311; 10181,20.9507183914197; 10182,20.9502791894053; 10183,20.9498249576839; 10184,20.9493557979517; 10185,20.9488718119046; 10186,20.9483731012388; 10187,20.9478597676501; 10188,20.9473319128348; 10189,20.9467896384888; 10190,20.9462330463081; 10191,20.9456622379889; 10192,20.9450773152271; 10193,20.9444783797188; 10194,20.9438655331601; 10195,20.9432388772469; 10196,20.9425985136754; 10197,20.9419445441416; 10198,20.9412770703415; 10199,20.9405961939711; 10200,20.9399020167266; 10201,20.9391946403039; 10202,20.9384741663992; 10203,20.9377406967083; 10204,20.9369943329275; 10205,20.9362351767526; 10206,20.9354633298799; 10207,20.9346788940053; 10208,20.9338819708248; 10209,20.9330726620345; 10210,20.9322510693305; 10211,20.9314172944088; 10212,20.9305714389654; 10213,20.9297136046964; 10214,20.9288438932978; 10215,20.9278974551172; 10216,20.9269430336167; 10217,20.9259806887926; 10218,20.9250104806414; 10219,
        20.9240324691595; 10220,20.9230467143432; 10221,20.922053276189; 10222,20.9213726738191; 10223,20.9207021157483; 10224,20.9200418565327; 10225,20.9193921507283; 10226,20.9187532528912; 10227,20.9181254175773; 10228,20.9175088993426; 10229,20.9169039527433; 10230,20.9163108323352; 10231,20.9157297926745; 10232,20.9151610883171; 10233,20.914604973819; 10234,20.9140617037363; 10235,20.9135315326249; 10236,20.913014715041; 10237,20.9125115055404; 10238,20.9120221586793; 10239,20.9115469290136; 10240,20.9110860710994; 10241,20.9106398394926; 10242,20.9102084887494; 10243,20.9097922734256; 10244,20.9093914480773; 10245,20.9090062672606; 10246,20.9086369855315; 10247,20.9082838574459; 10248,20.9079471375599; 10249,20.9076270804294; 10250,20.9073239406106; 10251,20.9070379726595; 10252,20.906769431132; 10253,20.9065185705841; 10254,20.9062856455719; 10255,20.9060709106515; 10256,20.9058746203787; 10257,20.9056970293096; 10258,20.9055383920003; 10259,20.9053989630068; 10260,
        20.905278996885; 10261,20.9051787481911; 10262,20.9050984714809; 10263,20.9050384213105; 10264,20.904998852236; 10265,20.9049800188134; 10266,20.9049821755986; 10267,20.9050055771477; 10268,20.9050504780167; 10269,20.9051171327617; 10270,20.9052057959385; 10271,20.9053167221034; 10272,20.9054501658121; 10273,20.9056063816209; 10274,20.9057856240857; 10275,20.9059881477625; 10276,20.9062142072073; 10277,20.9064640569762; 10278,20.9067379516251; 10279,20.9070361457101; 10280,20.9073588937872; 10281,20.9077064504124; 10282,20.9080790701418; 10283,20.9084770075312; 10284,20.9089005171369; 10285,20.9093498535147; 10286,20.9098252712207; 10287,20.9103270248109; 10288,20.9108553688414; 10289,20.9114105578681; 10290,20.911537781321; 10291,20.9116344577503; 10292,20.911731655425; 10293,20.9118293326454; 10294,20.9119274477121; 10295,20.9120259589252; 10296,20.9121248245852; 10297,20.9122240029925; 10298,20.9123234524473; 10299,20.9124231312502; 10300,20.9125229977014; 10301,
        20.9126230101013; 10302,20.9127231267503; 10303,20.9128233059488; 10304,20.912923505997; 10305,20.9130236851955; 10306,20.9131238018445; 10307,20.9132238142444; 10308,20.9133236806956; 10309,20.9134233594985; 10310,20.9135228089534; 10311,20.9136219873606; 10312,20.9137208530206; 10313,20.9138193642338; 10314,20.9139174793004; 10315,20.9140151565208; 10316,20.9141123541955; 10317,20.9142090306248; 10318,20.914305144109; 10319,20.9144006529486; 10320,20.9144955154438; 10321,20.9145896898951; 10322,20.9146831346028; 10323,20.9147758078673; 10324,20.914867667989; 10325,20.9149586732682; 10326,20.9150487820053; 10327,20.9151379525006; 10328,20.9152261430545; 10329,20.9153133119675; 10330,20.9153994175398; 10331,20.9154844180718; 10332,20.9155682718639; 10333,20.9156509372165; 10334,20.9157323724299; 10335,20.9158125358045; 10336,20.9158913856406; 10337,20.9159688802387; 10338,20.916044977899; 10339,20.9161196369221; 10340,20.9161928156081; 10341,20.9162644722575; 10342,
        20.9163345651708; 10343,20.9164030526481; 10344,20.9164698929899; 10345,20.9165350444966; 10346,20.9165984654685; 10347,20.916660114206; 10348,20.9167199490095; 10349,20.9167779281793; 10350,20.9168340100158; 10351,20.9168881528193; 10352,20.9169403148903; 10353,20.9169904545291; 10354,20.9170385300361; 10355,20.9173907591774; 10356,20.9178164281613; 10357,20.918542377576; 10358,20.9192254009643; 10359,20.919865921576; 10360,20.9204643626613; 10361,20.92102114747; 10362,20.9215366992522; 10363,20.9220114412578; 10364,20.9224457967368; 10365,20.9228401889393; 10366,20.9231950411152; 10367,20.9235107765145; 10368,20.9237878183871; 10369,20.9240265899831; 10370,20.9242275145525; 10371,20.9243910153452; 10372,20.9245175156112; 10373,20.9246074386005; 10374,20.9246612075631; 10375,20.924679245749; 10376,20.9246619764081; 10377,20.9246098227905; 10378,20.9245232081462; 10379,20.9244025557251; 10380,20.9242482887771; 10381,20.9240608305524; 10382,20.9238406043009; 10383,
        20.9235880332725; 10384,20.9233035407173; 10385,20.9229875498852; 10386,20.9226404840262; 10387,20.9222627663904; 10388,20.9218548202276; 10389,20.921417068788; 10390,20.9209499353214; 10391,20.9204538430778; 10392,20.9199292153073; 10393,20.9193764752599; 10394,20.918864729651; 10395,20.9173471882933; 10396,20.9158624326402; 10397,20.9144102969893; 10398,20.912990615638; 10399,20.9116032228838; 10400,20.9102479530242; 10401,20.9089246403566; 10402,20.9076331191784; 10403,20.9063732237873; 10404,20.9051447884805; 10405,20.9049299513444; 10406,20.9046904301723; 10407,20.904426689914; 10408,20.904139195519; 10409,20.903828411937; 10410,20.9034948041175; 10411,20.9031388370103; 10412,20.9027609755649; 10413,20.9023616847309; 10414,20.9019414294579; 10415,20.9015006746957; 10416,20.9010398853937; 10417,20.9005595265017; 10418,20.9000600629692; 10419,20.8995419597458; 10420,20.8990056817813; 10421,20.8984516940251; 10422,20.8978804614269; 10423,20.8972924489363; 10424,
        20.896688121503; 10425,20.8960679440766; 10426,20.8954323816067; 10427,20.8947818990428; 10428,20.8941169613347; 10429,20.893438033432; 10430,20.8927455802842; 10431,20.892040066841; 10432,20.8913219580519; 10433,20.8905917188667; 10434,20.889849814235; 10435,20.8890967091063; 10436,20.8883328684303; 10437,20.8875587571566; 10438,20.8867748402348; 10439,20.8859815826145; 10440,20.8851794492454; 10441,20.8843689050771; 10442,20.8835504150592; 10443,20.8827244441412; 10444,20.8818914572729; 10445,20.8810519194039; 10446,20.8802062954837; 10447,20.8793550504621; 10448,20.8784986492885; 10449,20.8776375569127; 10450,20.8769155369456; 10451,20.8761816137062; 10452,20.8754363441435; 10453,20.874680285207; 10454,20.8739139938459; 10455,20.8731380270094; 10456,20.8723529416469; 10457,20.8715592947076; 10458,20.8707576431407; 10459,20.8699485438956; 10460,20.8691325539216; 10461,20.8683102301678; 10462,20.8674821295836; 10463,20.8666488091182; 10464,20.865810825721; 10465,
        20.8649687363411; 10466,20.864123097928; 10467,20.8632744674307; 10468,20.8624234017987; 10469,20.8615704579812; 10470,20.8607161929274; 10471,20.8598611635867; 10472,20.8590059269082; 10473,20.8581510398414; 10474,20.8572970593354; 10475,20.8564445423395; 10476,20.855594045803; 10477,20.8547461266752; 10478,20.8539013419054; 10479,20.8530602484428; 10480,20.8522234032366; 10481,20.8513913632363; 10482,20.8505646853909; 10483,20.8497439266499; 10484,20.8489296439625; 10485,20.8481223942779; 10486,20.8473227345455; 10487,20.8465312217145; 10488,20.8457484127341; 10489,20.8449748645537; 10490,20.8442111341226; 10491,20.8434577783899; 10492,20.8427153543051; 10493,20.8419844188172; 10494,20.8412655288757; 10495,20.8405592414298; 10496,20.8398661134287; 10497,20.8391867018218; 10498,20.8385215635584; 10499,20.8378712555876; 10500,20.8372363348587; 10501,20.8366173583211; 10502,20.836014882924; 10503,20.8354294656167; 10504,20.8348616633485; 10505,20.8343120330685; 10506,
        20.8337811317262; 10507,20.8332695162708; 10508,20.8327777436515; 10509,20.8323063708176; 10510,20.8308773865361; 10511,20.8295255164034; 10512,20.8282506891151; 10513,20.8270528333664; 10514,20.825931877853; 10515,20.8248877512702; 10516,20.8239203823134; 10517,20.8230296996781; 10518,20.8222156320597; 10519,20.8214781081536; 10520,20.8208170566553; 10521,20.8202324062602; 10522,20.8197240856637; 10523,20.8192920235613; 10524,20.8189361486485; 10525,20.8186563896205; 10526,20.8184526751729; 10527,20.8183249340011; 10528,20.8182730948006; 10529,20.8182970862667; 10530,20.8183968370949; 10531,20.8185722759806; 10532,20.8188233316193; 10533,20.8191499327064; 10534,20.8192281507428; 10535,20.8192656456513; 10536,20.8191051600773; 10537,20.819039601419; 10538,20.8189971350155; 10539,20.8189773281269; 10540,20.8189797480131; 10541,20.819003961934; 10542,20.8190495371495; 10543,20.8191160409196; 10544,20.8192030405042; 10545,20.8193101031632; 10546,20.8194367961566; 10547,
        20.8195826867442; 10548,20.8197473421861; 10549,20.8199303297421; 10550,20.8201312166722; 10551,20.8203495702363; 10552,20.8205849576943; 10553,20.8208369463062; 10554,20.8211051033319; 10555,20.8213889960313; 10556,20.8216881916644; 10557,20.8220022574911; 10558,20.8223307607713; 10559,20.8226732687649; 10560,20.823029348732; 10561,20.8233985679323; 10562,20.8237804936259; 10563,20.8241746930726; 10564,20.8245807335325; 10565,20.8249981822654; 10566,20.8254266065313; 10567,20.82586557359; 10568,20.8263146507016; 10569,20.8267734051259; 10570,20.8272414041229; 10571,20.8277182149526; 10572,20.8282034048748; 10573,20.8286965411494; 10574,20.8302359381926; 10575,20.8318394901277; 10576,20.8335073948667; 10577,20.8352398503218; 10578,20.8370370544051; 10579,20.8388992050286; 10580,20.8408265001043; 10581,20.8428191375445; 10582,20.8448773152611; 10583,20.8470012311663; 10584,20.8481523360161; 10585,20.8493125008589; 10586,20.8504812929548; 10587,20.8516582795638; 10588,
        20.8528430279456; 10589,20.8540351053604; 10590,20.8552340790679; 10591,20.8564395163281; 10592,20.857650984401; 10593,20.8588680505465; 10594,20.8600902820245; 10595,20.861317246095; 10596,20.8625485100178; 10597,20.8637836410529; 10598,20.8650222064603; 10599,20.8662637734998; 10600,20.8675079094314; 10601,20.8687541815151; 10602,20.8700021570107; 10603,20.8712514031782; 10604,20.8725014872775; 10605,20.8737519765686; 10606,20.8750024383113; 10607,20.8762524397657; 10608,20.8775015481916; 10609,20.878749330849; 10610,20.8799953549978; 10611,20.8812391878979; 10612,20.8824803968092; 10613,20.8837185489918; 10614,20.8849532117055; 10615,20.8861839522103; 10616,20.887410337766; 10617,20.8886319356326; 10618,20.8898483130701; 10619,20.8910590373384; 10620,20.8922636756974; 10621,20.893461795407; 10622,20.8946529637271; 10623,20.8958367479178; 10624,20.8970127152389; 10625,20.8981804329504; 10626,20.8993394683121; 10627,20.9004893885841; 10628,20.9016297610262; 10629,
        20.9026086202679; 10630,20.9035687402309; 10631,20.9045095961754; 10632,20.9054306633618; 10633,20.9063314170504; 10634,20.907090387226; 10635,20.907834866315; 10636,20.9085642519291; 10637,20.90927794168; 10638,20.9099753331797; 10639,20.9106558240399; 10640,20.9113188118724; 10641,20.911963694289; 10642,20.9125898689015; 10643,20.9131967333216; 10644,20.9137836851613; 10645,20.9143501220321; 10646,20.9148954415461; 10647,20.9154190413149; 10648,20.9159203189504; 10649,20.9163986720643; 10650,20.9168534982684; 10651,20.9172841951746; 10652,20.9176901603946; 10653,20.9180707915402; 10654,20.9184254862233; 10655,20.9187536420555; 10656,20.9190546566488; 10657,20.9193279276148; 10658,20.9195728525655; 10659,20.9197888291125; 10660,20.9199752548677; 10661,20.9201315274429; 10662,20.9202570444499; 10663,20.9203512035004; 10664,20.9204134022063; 10665,20.9204430381794; 10666,20.9204395090314; 10667,20.9204022123741; 10668,20.9203305458194; 10669,20.920223906979; 10670,
        20.9200816934648; 10671,20.9199033028884; 10672,20.9201714922011; 10673,20.9203748360764; 10674,20.9205130424493; 10675,20.9205858192548; 10676,20.9205928744278; 10677,20.9205339159034; 10678,20.9204086516163; 10679,20.9202167895016; 10680,20.9199580374941; 10681,20.919632103529; 10682,20.919238695541; 10683,20.9187775214651; 10684,20.9182482892364; 10685,20.9176507067896; 10686,20.9169844820599; 10687,20.916249322982; 10688,20.915444937491; 10689,20.915605830423; 10690,20.9157537697843; 10691,20.9158890917637; 10692,20.91601213255; 10693,20.916123228332; 10694,20.9162227152985; 10695,20.9163109296382; 10696,20.91638820754; 10697,20.9164548851927; 10698,20.916511298785; 10699,20.9165577845057; 10700,20.9165946785436; 10701,20.9166223170874; 10702,20.9166410363261; 10703,20.9166511724482; 10704,20.9166530616428; 10705,20.9166470400984; 10706,20.916633444004; 10707,20.9166126095482; 10708,20.91658487292; 10709,20.916550570308; 10710,20.916510037901; 10711,20.9164636118879; 10712,
        20.9164116284574; 10713,20.9163544237984; 10714,20.9162923340995; 10715,20.9161265993682; 10716,20.915879805209; 10717,20.9156197063846; 10718,20.9153465355699; 10719,20.9150605254394; 10720,20.9147619086679; 10721,20.91445091793; 10722,20.9141277859004; 10723,20.9137927452537; 10724,20.9134460286646; 10725,20.9130878688078; 10726,20.912718498358; 10727,20.9123381499898; 10728,20.9119470563778; 10729,20.9115454501969; 10730,20.9111335641215; 10731,20.9107116308265; 10732,20.9102798829864; 10733,20.9098385532759; 10734,20.9093878743698; 10735,20.9089280789426; 10736,20.9080405498324; 10737,20.9069631111676; 10738,20.9059124343319; 10739,20.9048883514436; 10740,20.9038906946211; 10741,20.9029192959827; 10742,20.9019739876469; 10743,20.9010546017319; 10744,20.9001609703562; 10745,20.899292925638; 10746,20.8984502996958; 10747,20.8976329246479; 10748,20.8968406326127; 10749,20.8960732557086; 10750,20.8953306260538; 10751,20.8946125757667; 10752,20.8939189369658; 10753,
        20.8932495417694; 10754,20.8926042222958; 10755,20.8919828106633; 10756,20.8913851389905; 10757,20.8908110393955; 10758,20.8902603439969; 10759,20.8897328849128; 10760,20.8892284942618; 10761,20.8887470041621; 10762,20.8882882467322; 10763,20.8878520540903; 10764,20.8874382583549; 10765,20.8870466916442; 10766,20.8866771860767; 10767,20.8863295737708; 10768,20.8860036868447; 10769,20.8856993574169; 10770,20.8854164176056; 10771,20.8851546995294; 10772,20.8849140353064; 10773,20.8846942570551; 10774,20.8844951968939; 10775,20.8843166869411; 10776,20.884158559315; 10777,20.8840206461341; 10778,20.8839027795167; 10779,20.8838047915811; 10780,20.8837265144457; 10781,20.8836677802288; 10782,20.8836284210489; 10783,20.8836082690243; 10784,20.8836071562733; 10785,20.8836249149144; 10786,20.8836613770658; 10787,20.8837163748459; 10788,20.8837897403731; 10789,20.8838813057658; 10790,20.8839909031423; 10791,20.884118364621; 10792,20.8842635223201; 10793,20.8844262083582; 10794,
        20.8846062548535; 10795,20.8848034939245; 10796,20.8850177576894; 10797,20.8852488782667; 10798,20.8854966877746; 10799,20.8857610183316; 10800,20.886041702056; 10801,20.8863385710662; 10802,20.8866514574805; 10803,20.8869801934173; 10804,20.887324610995; 10805,20.8876845423319; 10806,20.8880598195463; 10807,20.8884502747567; 10808,20.8888557400814; 10809,20.8892760476388; 10810,20.8897110295472; 10811,20.8893825076169; 10812,20.8891125294055; 10813,20.8890283223528; 10814,20.8890083514572; 10815,20.8890520269927; 10816,20.8891587592331; 10817,20.8893279584521; 10818,20.8895590349237; 10819,20.8898513989216; 10820,20.8902044607197; 10821,20.8906176305919; 10822,20.8910903188119; 10823,20.8916219356537; 10824,20.892211891391; 10825,20.8928595962976; 10826,20.8935644606475; 10827,20.8943258947144; 10828,20.8951433087722; 10829,20.8960161130948; 10830,20.8969437179558; 10831,20.8979255336293; 10832,20.898960970389; 10833,20.9000494385087; 10834,20.9011903482623; 10835,
        20.9023831099237; 10836,20.9036271337666; 10837,20.9049218300649; 10838,20.9062666090924; 10839,20.907660881123; 10840,20.9091040564305; 10841,20.9105124380903; 10842,20.9119732655746; 10843,20.9134858958012; 10844,20.9150496856881; 10845,20.9166639921533; 10846,20.9183281721145; 10847,20.9200415824897; 10848,20.9218035801969; 10849,20.9236135221538; 10850,20.9254707652785; 10851,20.9268635332276; 10852,20.9282742319351; 10853,20.9297019079957; 10854,20.9311456080043; 10855,20.9326043785555; 10856,20.9340772662441; 10857,20.9355633176649; 10858,20.9370615794126; 10859,20.938571098082; 10860,20.9400909202678; 10861,20.9416200925648; 10862,20.9431576615678; 10863,20.9447026738714; 10864,20.9462541760705; 10865,20.9478112147597; 10866,20.949372836534; 10867,20.9509380879879; 10868,20.9525060157162; 10869,20.9540756663138; 10870,20.9556460863754; 10871,20.9572163224956; 10872,20.9588506136246; 10873,20.9604791098908; 10874,20.9621008997432; 10875,20.9637150716309; 10876,
        20.9653207140032; 10877,20.966916915309; 10878,20.9685027639975; 10879,20.9700773485179; 10880,20.9716397573191; 10881,20.9731890788505; 10882,20.974724401561; 10883,20.9762448138997; 10884,20.9777494043159; 10885,20.9792372612586; 10886,20.980707473177; 10887,20.98215912852; 10888,20.983591315737; 10889,20.9850031232769; 10890,20.9863936395889; 10891,20.9877619531222; 10892,20.9891071523257; 10893,20.9904283256487; 10894,20.9917245615403; 10895,20.9929949484496; 10896,20.9942385748256; 10897,20.9954545291175; 10898,20.9966418997745; 10899,20.9977997752456; 10900,20.99892724398; 10901,21.0000233944267; 10902,21.001087315035; 10903,21.0021180942538; 10904,21.0031148205323; 10905,21.0040765823197; 10906,21.0050024680651; 10907,21.0058915662175; 10908,21.0067429652261; 10909,21.00755575354; 10910,21.0083290196083; 10911,21.0090618518801; 10912,21.0103510558984; 10913,21.0115640418199; 10914,21.0127002818361; 10915,21.0142021651686; 10916,21.0158674223445; 10917,21.0174908694427;
        10918,21.0190723792109; 10919,21.0206118243969; 10920,21.0221090777485; 10921,21.0235640120134; 10922,21.0249764999394; 10923,21.0263464142744; 10924,21.027673627766; 10925,21.0289580131622; 10926,21.0301994432105; 10927,21.0313977906589; 10928,21.0325529282551; 10929,21.033664728747; 10930,21.0347330648821; 10931,21.0357578094085; 10932,21.0367388350737; 10933,21.0376760146257; 10934,21.0385692208122; 10935,21.0394183263809; 10936,21.0402232040797; 10937,21.0409837266564; 10938,21.0416997668586; 10939,21.0423711974343; 10940,21.0429978911311; 10941,21.0435797206969; 10942,21.0441165588794; 10943,21.0446082784265; 10944,21.0450547520858; 10945,21.0454558526052; 10946,21.0458114527325; 10947,21.0461214252154; 10948,21.0463856428017; 10949,21.0466039782392; 10950,21.0467763042757; 10951,21.0469024936589; 10952,21.0469824191367; 10953,21.0470159534569; 10954,21.0470029693671; 10955,21.0469433396152; 10956,21.0468369369489; 10957,21.0466836341161; 10958,21.0464833038645; 10959,
        21.0462358189419; 10960,21.0459410520961; 10961,21.0455988760749; 10962,21.045209163626; 10963,21.0447717874972; 10964,21.0442866204363; 10965,21.0437535351911; 10966,21.0431724045094; 10967,21.0425431011389; 10968,21.0418654978274; 10969,21.0411394673227; 10970,21.0403648823726; 10971,21.0395416157249; 10972,21.0386695401273; 10973,21.0377485283277; 10974,21.0367784530737; 10975,21.0357591871133; 10976,21.0346906031941; 10977,21.0335725740639; 10978,21.0324049724706; 10979,21.0311876711619; 10980,21.0299205428856; 10981,21.0286034603894; 10982,21.027277086832; 10983,21.0258981869134; 10984,21.0244666595693; 10985,21.0229824037355; 10986,21.0214453183477; 10987,21.0198553023417; 10988,21.0182122546534; 10989,21.0165160742184; 10990,21.0155893749047; 10991,21.014654544833; 10992,21.0137119824322; 10993,21.012762086131; 10994,21.0118052543582; 10995,21.0108418855425; 10996,21.0098723781127; 10997,21.0088971304977; 10998,21.0079165411261; 10999,21.0069310084268; 11000,
        21.0059409308285; 11001,21.00494670676; 11002,21.0039487346501; 11003,21.0029474129276; 11004,21.0019431400212; 11005,21.0009363143597; 11006,20.9999273343719; 11007,20.9989165984866; 11008,20.9979045051325; 11009,20.9968914527384; 11010,20.9958778397331; 11011,20.9948640645454; 11012,20.9938505256041; 11013,20.9928376213378; 11014,20.9918257501755; 11015,20.9908153105458; 11016,20.9898067008775; 11017,20.9888003195995; 11018,20.9877965651405; 11019,20.9864628046182; 11020,20.9852392725604; 11021,20.9840430997427; 11022,20.9828745241393; 11023,20.9817337837244; 11024,20.980621116472; 11025,20.9795367603565; 11026,20.9784809533518; 11027,20.9774539334323; 11028,20.976455938572; 11029,20.9754872067451; 11030,20.9745479759257; 11031,20.9736384840881; 11032,20.9727589692064; 11033,20.9719096692547; 11034,20.9710908222072; 11035,20.970302666038; 11036,20.9695454387213; 11037,20.9688193782314; 11038,20.9681247225422; 11039,20.967461709628; 11040,20.966830577463; 11041,
        20.9662315640213; 11042,20.965664907277; 11043,20.9651308452044; 11044,20.9646296157775; 11045,20.9641614569706; 11046,20.9637266067578; 11047,20.9633253031132; 11048,20.962957784011; 11049,20.9626242874254; 11050,20.9623250513305; 11051,20.9619913753797; 11052,20.9616886480482; 11053,20.9614170654557; 11054,20.9611768237219; 11055,20.9609681189668; 11056,20.9607911473101; 11057,20.9606461048716; 11058,20.9605331877711; 11059,20.9604525921284; 11060,20.9604045140632; 11061,20.9603891496954; 11062,20.9604066951449; 11063,20.9604573465312; 11064,20.9605412999744; 11065,20.9606587515941; 11066,20.9608098975102; 11067,20.9609949338424; 11068,20.9612140567105; 11069,20.9614674622345; 11070,20.9617553465339; 11071,20.9620779057287; 11072,20.9624353359386; 11073,20.9628278332835; 11074,20.963255593883; 11075,20.9637188138571; 11076,20.9642176893255; 11077,20.964752416408; 11078,20.9653231912244; 11079,20.9659302098945; 11080,20.9665736685381; 11081,20.967253763275; 11082,
        20.967970690225; 11083,20.9687246455079; 11084,20.9695158252434; 11085,20.9703444255514; 11086,20.9712106425517; 11087,20.972114672364; 11088,20.9730567111082; 11089,20.9740369549041; 11090,20.9750555998714; 11091,20.9754807800954; 11092,20.9759100250471; 11093,20.9763431471042; 11094,20.9767799586439; 11095,20.9772202720438; 11096,20.9776638996812; 11097,20.9781106539337; 11098,20.9785603471786; 11099,20.9790127917935; 11100,20.9794678001556; 11101,20.9799251846426; 11102,20.9803847576317; 11103,20.9808463315006; 11104,20.9813097186265; 11105,20.9817747313869; 11106,20.9825237024496; 11107,20.9832578716124; 11108,20.9839772326347; 11109,20.9846817792757; 11110,20.9853715052946; 11111,20.9860464044506; 11112,20.986706470503; 11113,20.9873516972111; 11114,20.987982078334; 11115,20.988597607631; 11116,20.9891982788613; 11117,20.9897840857843; 11118,20.9903550221591; 11119,20.9909110817449; 11120,20.991452258301; 11121,20.9919785455867; 11122,20.9924899373611; 11123,
        20.9929864273835; 11124,20.9934680094132; 11125,20.9939346772094; 11126,20.9943864245314; 11127,20.9948232451383; 11128,20.9952451327893; 11129,20.9956520812439; 11130,20.9960440842611; 11131,20.9964211356003; 11132,20.9967832290206; 11133,20.9971303582813; 11134,20.9974625171416; 11135,20.9977796993609; 11136,20.9980818986982; 11137,20.9983691089129; 11138,20.998651928066; 11139,20.9989191430977; 11140,20.9991707545755; 11141,20.9994067630667; 11142,20.9996271691386; 11143,20.9998319733585; 11144,21.0000211762938; 11145,21.0001947785118; 11146,21.00035278058; 11147,21.0004951830655; 11148,21.0006219865358; 11149,21.0007331915582; 11150,21.0008287987001; 11151,21.0009088085287; 11152,21.0009732216115; 11153,21.0010220385158; 11154,21.0010552598088; 11155,21.001072886058; 11156,21.0010749178308; 11157,21.0010613556943; 11158,21.0010322002161; 11159,21.0009874519633; 11160,21.0009271115034; 11161,21.0008080451679; 11162,21.000671017747; 11163,21.0005160036201; 11164,
        21.0003429771664; 11165,21.0001519127654; 11166,20.9999427847964; 11167,20.9997155676388; 11168,20.9994702356719; 11169,20.999206763275; 11170,20.9989251248276; 11171,20.9986252947089; 11172,20.9983072472984; 11173,20.9979709569753; 11174,20.9976163981191; 11175,20.9972435451091; 11176,20.9968523723246; 11177,20.996442854145; 11178,20.9960149649496; 11179,20.9955686791179; 11180,20.9951039710291; 11181,20.9946208150626; 11182,20.9941191855977; 11183,20.9935990570139; 11184,20.9930604036905; 11185,20.9925032000067; 11186,20.9919274203421; 11187,20.9913330390759; 11188,20.9907200305874; 11189,20.9905003503974; 11190,20.9902385837244; 11191,20.9899349694452; 11192,20.9895897464367; 11193,20.9892031535755; 11194,20.9887754297384; 11195,20.9883068138022; 11196,20.9877975446435; 11197,20.9872478611392; 11198,20.9870101695211; 11199,20.9867518911656; 11200,20.9864734787598; 11201,20.9861753849912; 11202,20.9858580625469; 11203,20.9855219641144; 11204,20.9851675423809; 11205,
        20.9847952500336; 11206,20.9844055397599; 11207,20.9839988642472; 11208,20.9835756761826; 11209,20.9831364282534; 11210,20.9826815731471; 11211,20.9822115635508; 11212,20.9817268521519; 11213,20.9812278916377; 11214,20.9807151346954; 11215,20.9801890340124; 11216,20.9796500422759; 11217,20.9790986121733; 11218,20.9785351963918; 11219,20.9783653198967; 11220,20.9782040460088; 11221,20.9780069630511; 11222,20.9777748111854; 11223,20.9775083305739; 11224,20.9772082613787; 11225,20.9768753437617; 11226,20.9765103178849; 11227,20.9761139239105; 11228,20.9756869020005; 11229,20.9752299923169; 11230,20.9747439350217; 11231,20.974229470277; 11232,20.9736873382448; 11233,20.9731182790872; 11234,20.9725230329662; 11235,20.9719023400439; 11236,20.9712569404822; 11237,20.9705875744433; 11238,20.9698949820891; 11239,20.969865146333; 11240,20.9697746303386; 11241,20.9696246142028; 11242,20.9694162780226; 11243,20.9691508018952; 11244,20.9688293659176; 11245,20.9684531501867; 11246,
        20.9680233347997; 11247,20.9675410998535; 11248,20.9670076254453; 11249,20.966424091672; 11250,20.9657916786307; 11251,20.9651115664183; 11252,20.9643849351321; 11253,20.9636129648689; 11254,20.9627968357258; 11255,20.9619377278; 11256,20.9610368211883; 11257,20.9600952959878; 11258,20.9591143322956; 11259,20.9580951102087; 11260,20.9570388098242; 11261,20.9559466112391; 11262,20.9548196945503; 11263,20.953659239855; 11264,20.9524664272502; 11265,20.951242436833; 11266,20.9499884487003; 11267,20.9487056429492; 11268,20.9473951996767; 11269,20.94605829898; 11270,20.9446961209559; 11271,20.9433098457016; 11272,20.941900653314; 11273,20.9404697238903; 11274,20.9390182375274; 11275,20.9375473743225; 11276,20.9360583143724; 11277,20.9345522377744; 11278,20.9330303246253; 11279,20.9314937550223; 11280,20.9299437090623; 11281,20.9283813668425; 11282,20.9268079084598; 11283,20.9252245140113; 11284,20.9236323635941; 11285,20.9217338833438; 11286,20.919812592266; 11287,20.917869489076;
        11288,20.9159055724889; 11289,20.91392184122; 11290,20.9119192939845; 11291,20.9098989294977; 11292,20.9078617464748; 11293,20.9058087436311; 11294,20.9037409196817; 11295,20.9016592733419; 11296,20.899564803327; 11297,20.8974585083522; 11298,20.8953413871328; 11299,20.8929701176808; 11300,20.8896978761548; 11301,20.8864830082308; 11302,20.8833257740865; 11303,20.8802264338999; 11304,20.8771852478487; 11305,20.8742024761109; 11306,20.8712783788642; 11307,20.8684132162866; 11308,20.865607248556; 11309,20.8628607358501; 11310,20.8601739383468; 11311,20.857547116224; 11312,20.8549805296596; 11313,20.8524744388314; 11314,20.8500291039172; 11315,20.847644785095; 11316,20.8453217425426; 11317,20.8430490228107; 11318,20.840837483571; 11319,20.8386873781933; 11320,20.8365989600472; 11321,20.8345724825025; 11322,20.8326081989289; 11323,20.8307063626963; 11324,20.8288672271744; 11325,20.8270910457329; 11326,20.8253780717416; 11327,20.8237285585703; 11328,20.8221427595887; 11329,
        20.8206209281665; 11330,20.8191633176736; 11331,20.8177701814796; 11332,20.8164417729543; 11333,20.8151783454676; 11334,20.813980152389; 11335,20.8128474470885; 11336,20.8117804829357; 11337,20.8107795133005; 11338,20.8098447915524; 11339,20.8089765710614; 11340,20.8081751051972; 11341,20.8074406473295; 11342,20.8067734508281; 11343,20.8061737690627; 11344,20.8056418554031; 11345,20.8051779632191; 11346,20.8047823458804; 11347,20.8044552567567; 11348,20.8041969492179; 11349,20.8040076766336; 11350,20.8038876923737; 11351,20.8038372498078; 11352,20.8038566023058; 11353,20.8039460032373; 11354,20.8041057059723; 11355,20.8043359638803; 11356,20.8046370303312; 11357,20.805609928542; 11358,20.806656700679; 11359,20.8083181664003; 11360,20.8099831342267; 11361,20.8116526384871; 11362,20.8133277135103; 11363,20.8150093936251; 11364,20.8166987131604; 11365,20.8183967064451; 11366,20.8201044078079; 11367,20.8218228515777; 11368,20.8231174184253; 11369,20.8244008593234; 11370,
        20.8256739441035; 11371,20.826937442597; 11372,20.8281921246353; 11373,20.8294387600499; 11374,20.8306781186722; 11375,20.8319109703337; 11376,20.8331380848658; 11377,20.8343602321; 11378,20.8355781818677; 11379,20.8367927040003; 11380,20.8380045683293; 11381,20.8392145446862; 11382,20.8404234029023; 11383,20.8416319128092; 11384,20.8428408442382; 11385,20.8440509670208; 11386,20.8452630509886; 11387,20.8464778659728; 11388,20.8476961818049; 11389,20.8489187683165; 11390,20.8501463953389; 11391,20.8513798327036; 11392,20.852619850242; 11393,20.8537823432035; 11394,20.8545657606813; 11395,20.8553851094912; 11396,20.8562408532934; 11397,20.8571334557481; 11398,20.8576350327054; 11399,20.8581057082025; 11400,20.8585883568067; 11401,20.8590831547034; 11402,20.8595902780781; 11403,20.8601099031163; 11404,20.8606422060034; 11405,20.8611873629249; 11406,20.8617455500662; 11407,20.8623169436129; 11408,20.8629017197503; 11409,20.8635000546639; 11410,20.8641121245393; 11411,
        20.8647381055618; 11412,20.8653781739169; 11413,20.8660325057901; 11414,20.8667012773669; 11415,20.8673846648327; 11416,20.8680828443729; 11417,20.8687959921731; 11418,20.8687996674851; 11419,20.8687788493108; 11420,20.8687332739006; 11421,20.8686626775049; 11422,20.8685667963743; 11423,20.8684453667592; 11424,20.86829812491; 11425,20.8681248070773; 11426,20.8679251495114; 11427,20.8676988884629; 11428,20.8674457601823; 11429,20.8671655009199; 11430,20.8668578469263; 11431,20.8665225344519; 11432,20.8661592997472; 11433,20.8657678790626; 11434,20.8653480086487; 11435,20.8648994247558; 11436,20.8644218636345; 11437,20.8639150615352; 11438,20.8633787547084; 11439,20.8628126794045; 11440,20.8622165718741; 11441,20.8615901683675; 11442,20.8609332051353; 11443,20.8602454184278; 11444,20.8595265444957; 11445,20.8587763195893; 11446,20.8579944799591; 11447,20.8571807618555; 11448,20.8563349015291; 11449,20.8554566352303; 11450,20.8545456992096; 11451,20.8536018297174; 11452,
        20.8526247630042; 11453,20.8516142353205; 11454,20.8505699829167; 11455,20.8494917420433; 11456,20.8483792489507; 11457,20.8472322398895; 11458,20.8460504511101; 11459,20.8448336188629; 11460,20.8435814793985; 11461,20.8422937689673; 11462,20.8409702238197; 11463,20.8396105802062; 11464,20.8382145743773; 11465,20.8367819425835; 11466,20.8353124210752; 11467,20.8338057461028; 11468,20.832261653917; 11469,20.830679880768; 11470,20.8290601629064; 11471,20.8274022365827; 11472,20.8257058380473; 11473,20.8239707035506; 11474,20.8221965693432; 11475,20.8203831716755; 11476,20.818530246798; 11477,20.8166375309611; 11478,20.8149631198337; 11479,20.8142206713183; 11480,20.8135046350849; 11481,20.8128154859212; 11482,20.8121536986153; 11483,20.8115197479548; 11484,20.8109141087276; 11485,20.8103372557216; 11486,20.8097896637247; 11487,20.8092718075246; 11488,20.8087841619092; 11489,20.8083272016664; 11490,20.8079014015839; 11491,20.8075072364498; 11492,20.8071451810517; 11493,
        20.8068157101775; 11494,20.8065192986152; 11495,20.8062564211524; 11496,20.8060275525771; 11497,20.8058331676771; 11498,20.8052788715861; 11499,20.8041872580001; 11500,20.8299999237061; 14499,20.8299999237061; 14500,20.9934680094132; 14501,20.9939346772094; 14502,20.9943864245314; 14503,20.9948232451383; 14504,20.9952451327893; 14505,20.9956520812439; 14506,20.9960440842611; 14507,20.9964211356003; 14508,20.9967832290206; 14509,20.9971303582813; 14510,20.9974625171416; 14511,20.9977796993609; 14512,20.9980818986982; 14513,20.9983691089129; 14514,20.998651928066; 14515,20.9989191430977; 14516,20.9991707545755; 14517,20.9994067630667; 14518,20.9996271691386; 14519,20.9998319733585; 14520,21.0000211762938; 14521,21.0001947785118; 14522,21.00035278058; 14523,21.0004951830655; 14524,21.0006219865358; 14525,21.0007331915582; 14526,21.0008287987001; 14527,21.0009088085287; 14528,21.0009732216115; 14529,21.0010220385158; 14530,21.0010552598088; 14531,21.001072886058; 14532,
        21.0010749178308; 14533,21.0010613556943; 14534,21.0010322002161; 14535,21.0009874519633; 14536,21.0009271115034; 14537,21.0008080451679; 14538,21.000671017747; 14539,21.0005160036201; 14540,21.0003429771664; 14541,21.0001519127654; 14542,20.9999427847964; 14543,20.9997155676388; 14544,20.9994702356719; 14545,20.999206763275; 14546,20.9989251248276; 14547,20.9986252947089; 14548,20.9983072472984; 14549,20.9979709569753; 14550,20.9976163981191; 14551,20.9972435451091; 14552,20.9968523723246; 14553,20.996442854145; 14554,20.9960149649496; 14555,20.9955686791179; 14556,20.9951039710291; 14557,20.9946208150626; 14558,20.9941191855977; 14559,20.9935990570139; 14560,20.9930604036905; 14561,20.9925032000067; 14562,20.9919274203421; 14563,20.9913330390759; 14564,20.9907200305874; 14565,20.9905003503974; 14566,20.9902385837244; 14567,20.9899349694452; 14568,20.9895897464367; 14569,20.9892031535755; 14570,20.9887754297384; 14571,20.9883068138022; 14572,20.9877975446435; 14573,
        20.9872478611392; 14574,20.9870101695211; 14575,20.9867518911656; 14576,20.9864734787598; 14577,20.9861753849912; 14578,20.9858580625469; 14579,20.9855219641144; 14580,20.9851675423809; 14581,20.9847952500336; 14582,20.9844055397599; 14583,20.9839988642472; 14584,20.9835756761826; 14585,20.9831364282534; 14586,20.9826815731471; 14587,20.9822115635508; 14588,20.9817268521519; 14589,20.9812278916377; 14590,20.9807151346954; 14591,20.9801890340124; 14592,20.9796500422759; 14593,20.9790986121733; 14594,20.9785351963918; 14595,20.9783653198967; 14596,20.9782040460088; 14597,20.9780069630511; 14598,20.9777748111854; 14599,20.9775083305739; 14600,20.9772082613787; 14601,20.9768753437617; 14602,20.9765103178849; 14603,20.9761139239105; 14604,20.9756869020005; 14605,20.9752299923169; 14606,20.9747439350217; 14607,20.974229470277; 14608,20.9736873382448; 14609,20.9731182790872; 14610,20.9725230329662; 14611,20.9719023400439; 14612,20.9712569404822; 14613,20.9705875744433; 14614,
        20.9698949820891; 14615,20.969865146333; 14616,20.9697746303386; 14617,20.9696246142028; 14618,20.9694162780226; 14619,20.9691508018952; 14620,20.9688293659176; 14621,20.9684531501867; 14622,20.9680233347997; 14623,20.9675410998535; 14624,20.9670076254453; 14625,20.966424091672; 14626,20.9657916786307; 14627,20.9651115664183; 14628,20.9643849351321; 14629,20.9636129648689; 14630,20.9627968357258; 14631,20.9619377278; 14632,20.9610368211883; 14633,20.9600952959878; 14634,20.9591143322956; 14635,20.9580951102087; 14636,20.9570388098242; 14637,20.9559466112391; 14638,20.9548196945503; 14639,20.953659239855; 14640,20.9524664272502; 14641,20.951242436833; 14642,20.9499884487003; 14643,20.9487056429492; 14644,20.9473951996767; 14645,20.94605829898; 14646,20.9446961209559; 14647,20.9433098457016; 14648,20.941900653314; 14649,20.9404697238903; 14650,20.9390182375274; 14651,20.9375473743225; 14652,20.9360583143724; 14653,20.9345522377744; 14654,20.9330303246253; 14655,20.9314937550223;
        14656,20.9299437090623; 14657,20.9283813668425; 14658,20.9268079084598; 14659,20.9252245140113; 14660,20.9236323635941; 14661,20.9217338833438; 14662,20.919812592266; 14663,20.917869489076; 14664,20.9159055724889; 14665,20.91392184122; 14666,20.9119192939845; 14667,20.9098989294977; 14668,20.9078617464748; 14669,20.9058087436311; 14670,20.9037409196817; 14671,20.9016592733419; 14672,20.899564803327; 14673,20.8974585083522; 14674,20.8953413871328; 14675,20.8929701176808; 14676,20.8896978761548; 14677,20.8864830082308; 14678,20.8833257740865; 14679,20.8802264338999; 14680,20.8771852478487; 14681,20.8742024761109; 14682,20.8712783788642; 14683,20.8684132162866; 14684,20.865607248556; 14685,20.8628607358501; 14686,20.8601739383468; 14687,20.857547116224; 14688,20.8549805296596; 14689,20.8524744388314; 14690,20.8500291039172; 14691,20.847644785095; 14692,20.8453217425426; 14693,20.8430490228107; 14694,20.840837483571; 14695,20.8386873781933; 14696,20.8365989600472; 14697,
        20.8345724825025; 14698,20.8326081989289; 14699,20.8307063626963; 14700,20.8288672271744; 14701,20.8270910457329; 14702,20.8253780717416; 14703,20.8237285585703; 14704,20.8221427595887; 14705,20.8206209281665; 14706,20.8191633176736; 14707,20.8177701814796; 14708,20.8164417729543; 14709,20.8151783454676; 14710,20.813980152389; 14711,20.8128474470885; 14712,20.8117804829357; 14713,20.8107795133005; 14714,20.8098447915524; 14715,20.8089765710614; 14716,20.8081751051972; 14717,20.8074406473295; 14718,20.8067734508281; 14719,20.8061737690627; 14720,20.8056418554031; 14721,20.8051779632191; 14722,20.8047823458804; 14723,20.8044552567567; 14724,20.8041969492179; 14725,20.8040076766336; 14726,20.8038876923737; 14727,20.8038372498078; 14728,20.8038566023058; 14729,20.8039460032373; 14730,20.8041057059723; 14731,20.8043359638803; 14732,20.8046370303312; 14733,20.805609928542; 14734,20.806656700679; 14735,20.8083181664003; 14736,20.8099831342267; 14737,20.8116526384871; 14738,
        20.8133277135103; 14739,20.8150093936251; 14740,20.8166987131604; 14741,20.8183967064451; 14742,20.8201044078079; 14743,20.8218228515777; 14744,20.8231174184253; 14745,20.8244008593234; 14746,20.8256739441035; 14747,20.826937442597; 14748,20.8281921246353; 14749,20.8294387600499; 14750,20.8306781186722; 14751,20.8319109703337; 14752,20.8331380848658; 14753,20.8343602321; 14754,20.8355781818677; 14755,20.8367927040003; 14756,20.8380045683293; 14757,20.8392145446862; 14758,20.8404234029023; 14759,20.8416319128092; 14760,20.8428408442382; 14761,20.8440509670208; 14762,20.8452630509886; 14763,20.8464778659728; 14764,20.8476961818049; 14765,20.8489187683165; 14766,20.8501463953389; 14767,20.8513798327036; 14768,20.852619850242; 14769,20.8537823432035; 14770,20.8545657606813; 14771,20.8553851094912; 14772,20.8562408532934; 14773,20.8571334557481; 14774,20.8576350327054; 14775,20.8581057082025; 14776,20.8585883568067; 14777,20.8590831547034; 14778,20.8595902780781; 14779,
        20.8601099031163; 14780,20.8606422060034; 14781,20.8611873629249; 14782,20.8617455500662; 14783,20.8623169436129; 14784,20.8629017197503; 14785,20.8635000546639; 14786,20.8641121245393; 14787,20.8647381055618; 14788,20.8653781739169; 14789,20.8660325057901; 14790,20.8667012773669; 14791,20.8673846648327; 14792,20.8680828443729; 14793,20.8687959921731; 14794,20.8687996674851; 14795,20.8687788493108; 14796,20.8687332739006; 14797,20.8686626775049; 14798,20.8685667963743; 14799,20.8684453667592; 14800,20.86829812491; 14801,20.8681248070773; 14802,20.8679251495114; 14803,20.8676988884629; 14804,20.8674457601823; 14805,20.8671655009199; 14806,20.8668578469263; 14807,20.8665225344519; 14808,20.8661592997472; 14809,20.8657678790626; 14810,20.8653480086487; 14811,20.8648994247558; 14812,20.8644218636345; 14813,20.8639150615352; 14814,20.8633787547084; 14815,20.8628126794045; 14816,20.8622165718741; 14817,20.8615901683675; 14818,20.8609332051353; 14819,20.8602454184278; 14820,
        20.8595265444957; 14821,20.8587763195893; 14822,20.8579944799591; 14823,20.8571807618555; 14824,20.8563349015291; 14825,20.8554566352303; 14826,20.8545456992096; 14827,20.8536018297174; 14828,20.8526247630042; 14829,20.8516142353205; 14830,20.8505699829167; 14831,20.8494917420433; 14832,20.8483792489507; 14833,20.8472322398895; 14834,20.8460504511101; 14835,20.8448336188629; 14836,20.8435814793985; 14837,20.8422937689673; 14838,20.8409702238197; 14839,20.8396105802062; 14840,20.8382145743773; 14841,20.8367819425835; 14842,20.8353124210752; 14843,20.8338057461028; 14844,20.832261653917; 14845,20.830679880768; 14846,20.8290601629064; 14847,20.8274022365827; 14848,20.8257058380473; 14849,20.8239707035506; 14850,20.8221965693432; 14851,20.8203831716755; 14852,20.818530246798; 14853,20.8166375309611; 14854,20.8149631198337; 14855,20.8142206713183; 14856,20.8135046350849; 14857,20.8128154859212; 14858,20.8121536986153; 14859,20.8115197479548; 14860,20.8109141087276; 14861,
        20.8103372557216; 14862,20.8097896637247; 14863,20.8092718075246; 14864,20.8087841619092; 14865,20.8083272016664; 14866,20.8079014015839; 14867,20.8075072364498; 14868,20.8071451810517; 14869,20.8068157101775; 14870,20.8065192986152; 14871,20.8062564211524; 14872,20.8060275525771; 14873,20.8058331676771; 14874,20.8052788715861; 14875,20.8041872580001; 14876,20.8031875521332; 14877,20.8022795931439; 14878,20.8014632201908; 14879,20.8007382724325; 14880,20.8001045890274; 14881,20.7995620091342; 14882,20.7991103719115; 14883,20.7987495165177; 14884,20.7984792821114; 14885,20.7982995078512; 14886,20.7982100328957; 14887,20.7982106964034; 14888,20.7983013375329; 14889,20.7984817954427; 14890,20.7987519092914; 14891,20.7991115182375; 14892,20.7995604614396; 14893,20.8000985780563; 14894,20.8007257072461; 14895,20.8014416881675; 14896,20.8022463599792; 14897,20.8031395618397; 14898,20.8041211329076; 14899,20.8051909123413; 14900,20.8063487392995; 14901,20.8075944529408; 14902,
        20.8089278924236; 14903,20.8103488969066; 14904,20.8136087023912; 14905,20.8168562400088; 14906,20.8200924733381; 14907,20.8233183659578; 14908,20.8265348814468; 14909,20.8297429833835; 14910,20.8329436353469; 14911,20.8361378009156; 14912,20.8386911534684; 14913,20.8411662390309; 14914,20.8429880794082; 14915,20.8447358159466; 14916,20.8464096312656; 14917,20.848009707985; 14918,20.8495362287243; 14919,20.8529372236619; 14920,20.856154354702; 14921,20.8591890550084; 14922,20.8620427577448; 14923,20.864716896075; 14924,20.8672129031628; 14925,20.869532212172; 14926,20.8716762562663; 14927,20.8736464686096; 14928,20.8754442823656; 14929,20.8784716717644; 14930,20.8812499527065; 14931,20.8837814575218; 14932,20.8860685185401; 14933,20.8881134680913; 14934,20.8899186385052; 14935,20.8914863621117; 14936,20.8928189712405; 14937,20.8939187982217; 14938,20.894788175385; 14939,20.8954294350602; 14940,20.8958449095772; 14941,20.8960369312659; 14942,20.896007832456; 14943,
        20.8957599454776; 14944,20.8952956026603; 14945,20.894617136334; 14946,20.8937268788287; 14947,20.892627162474; 14948,20.8914100710921; 14949,20.8904076600769; 14950,20.8892305501898; 14951,20.8878813799317; 14952,20.8863627878038; 14953,20.8846774123072; 14954,20.882827891943; 14955,20.8808168652122; 14956,20.878646970616; 14957,20.8763208466553; 14958,20.8738411318314; 14959,20.8712104646453; 14960,20.8684314835981; 14961,20.8655068271908; 14962,20.8632164915058; 14963,20.8607415894184; 14964,20.8580852585039; 14965,20.8552506363372; 14966,20.8522408604934; 14967,20.8490590685474; 14968,20.8457083980744; 14969,20.8421919866494; 14970,20.8385129718473; 14971,20.8346744912433; 14972,20.8306796824124; 14973,20.8265316829295; 14974,20.8222336303698; 14975,20.8177886623083; 14976,20.8131999163199; 14977,20.8084705299798; 14978,20.803603640863; 14979,20.7986023865445; 14980,20.7934699045993; 14981,20.7884997056995; 14982,20.7838561212974; 14983,20.7790478153181; 14984,
        20.7740784122643; 14985,20.7689515366388; 14986,20.7636708129443; 14987,20.7582398656834; 14988,20.7526623193588; 14989,20.7469417984733; 14990,20.7410819275296; 14991,20.7350863310304; 14992,20.7289586334784; 14993,20.7227024593763; 14994,20.7163214332267; 14995,20.7098191795325; 14996,20.7031993227963; 14997,20.6964654875208; 14998,20.6896212982088; 14999,20.6826703793629; 15000,20.6756163554858; 15001,20.6684628510803; 15002,20.661213490649; 15003,20.6538718986947; 15004,20.6464416997201; 15005,20.6389265182278; 15006,20.6313299787206; 15007,20.6236557057012; 15008,20.6159073236724; 15009,20.6080884571367; 15010,20.6002027305969; 15011,20.5922537685557; 15012,20.5842451955158; 15013,20.57618063598; 15014,20.5680637144509; 15015,20.5598980554313; 15016,20.5516872834238; 15017,20.5434350229311; 15018,20.5351448984561; 15019,20.5268205345012; 15020,20.5190397744944; 15021,20.5116130360013; 15022,20.5041071719549; 15023,20.4965264410752; 15024,20.4888751020822; 15025,
        20.4811574136962; 15026,20.4733776346371; 15027,20.4655400236251; 15028,20.4576488393802; 15029,20.4492947025592; 15030,20.4403447931831; 15031,20.4314099494113; 15032,20.4224937957464; 15033,20.4135999566911; 15034,20.4047320567481; 15035,20.3958937204202; 15036,20.38708857221; 15037,20.3783202366203; 15038,20.3695923381537; 15039,20.3609085013129; 15040,20.3522723506008; 15041,20.3436875105199; 15042,20.335157605573; 15043,20.3266862602627; 15044,20.3182770990919; 15045,20.3099337465632; 15046,20.3016598271793; 15047,20.2934589654429; 15048,20.2853347858567; 15049,20.2773023607492; 15050,20.2693532163527; 15051,20.2614909845196; 15052,20.2537192971022; 15053,20.2464593448945; 15054,20.2399495296617; 15055,20.2335989323636; 15056,20.227411820482; 15057,20.2213924614985; 15058,20.2155451228947; 15059,20.2098740721522; 15060,20.2043835767529; 15061,20.1990779041781; 15062,20.1939613219098; 15063,20.1890380974294; 15064,20.1843124982186; 15065,20.1797887917591; 15066,
        20.1754712455326; 15067,20.1713641270206; 15068,20.1674717037049; 15069,20.163798243067; 15070,20.1603480125887; 15071,20.1571252797515; 15072,20.1546970831364; 15073,20.1528865815585; 15074,20.1513171370034; 15075,20.1501631305246; 15076,20.1491879726598; 15077,20.1483967403523; 15078,20.1477945105453; 15079,20.147386360182; 15080,20.1471773662056; 15081,20.1471726055594; 15082,20.1473771551866; 15083,20.145944059583; 15084,20.1446286681146; 15085,20.1432063985506; 15086,20.1418668496738; 15087,20.1404039920157; 15088,20.1391057562857; 15089,20.1379757397862; 15090,20.1370175398199; 15091,20.1362347536893; 15092,20.1356309786968; 15093,20.1352098121451; 15094,20.1349748513366; 15095,20.1349296935738; 15096,20.1350779361594; 15097,20.1354231763958; 15098,20.1339092403259; 15099,20.1324863222669; 15100,20.1311567689771; 15101,20.129922927215; 15102,20.1287871437388; 15103,20.127751765307; 15104,20.126819138678; 15105,20.1259916106102; 15106,20.1252715278619; 15107,
        20.1246612371915; 15108,20.1226820689282; 15109,20.1207360117305; 15110,20.1188245131907; 15111,20.1169490209011; 15112,20.1151109824541; 15113,20.113311845442; 15114,20.1115530574571; 15115,20.1098360660917; 15116,20.1081623189381; 15117,20.1065332635887; 15118,20.1049503476358; 15119,20.1034150186716; 15120,20.1019287242886; 15121,20.100492912079; 15122,20.0991090296351; 15123,20.0977785245492; 15124,20.0965028444138; 15125,20.095283436821; 15126,20.0941217493632; 15127,20.0930192296328; 15128,20.091977325222; 15129,20.0909974837231; 15130,20.0900811527286; 15131,20.0892297798306; 15132,20.0884448126215; 15133,20.0877276986937; 15134,20.0870798856394; 15135,20.086502821051; 15136,20.0859979525207; 15137,20.085566727641; 15138,20.0852105940041; 15139,20.0849309992023; 15140,20.0847293908279; 15141,20.0837851917739; 15142,20.0828767081396; 15143,20.0820048884436; 15144,20.0811706812041; 15145,20.0803750349395; 15146,20.0796188981682; 15147,20.0789032194085; 15148,
        20.0782289471789; 15149,20.0775970299976; 15150,20.0770084163831; 15151,20.0764640548538; 15152,20.0759648939279; 15153,20.0755118821239; 15154,20.0751059679602; 15155,20.0747480999551; 15156,20.0744392266269; 15157,20.0741802964941; 15158,20.073972258075; 15159,20.073816059888; 15160,20.0734055924596; 15161,20.0725370304042; 15162,20.0716789007583; 15163,20.0708316651125; 15164,20.0699957850575; 15165,20.0691717221841; 15166,20.0683599380828; 15167,20.0677827612419; 15168,20.0678911418576; 15169,20.0679618041139; 15170,20.0679957917976; 15171,20.0679941486954; 15172,20.0679579185939; 15173,20.0678881452799; 15174,20.06778587254; 15175,20.067652144161; 15176,20.0674880039294; 15177,20.067294495632; 15178,20.0670726630556; 15179,20.0668235499867; 15180,20.066548200212; 15181,20.0662476575183; 15182,20.0659229656923; 15183,20.0655751685205; 15184,20.0652053097898; 15185,20.0648144332867; 15186,20.064403582798; 15187,20.0639738021104; 15188,20.0635261350105; 15189,
        20.0630616252851; 15190,20.0625813167208; 15191,20.0620862531043; 15192,20.0615774782224; 15193,20.0610560358616; 15194,20.0605229698086; 15195,20.0599793238503; 15196,20.0594261417732; 15197,20.058864467364; 15198,20.0582953444094; 15199,20.0571126030397; 15200,20.055453731523; 15201,20.053732777492; 15202,20.051950150516; 15203,20.0501062601644; 15204,20.0482015160065; 15205,20.0462363276116; 15206,20.0442111045489; 15207,20.0421262563878; 15208,20.0404195984848; 15209,20.0392853815635; 15210,20.0381504304857; 15211,20.0370157890379; 15212,20.0358825010069; 15213,20.0347516101794; 15214,20.033624160342; 15215,20.0325011952815; 15216,20.0313837587845; 15217,20.0302728946377; 15218,20.0291696466278; 15219,20.0280750585415; 15220,20.0269901741655; 15221,20.0259160372864; 15222,20.024853691691; 15223,20.0238041811659; 15224,20.0227685494978; 15225,20.0217478404735; 15226,20.0207430978795; 15227,20.0197553655026; 15228,20.0187735815094; 15229,20.0178102301627; 15230,
        20.0168663478995; 15231,20.0159429711569; 15232,20.0150411363718; 15233,20.0141618799814; 15234,20.0133062384226; 15235,20.0124752481325; 15236,20.0116699455481; 15237,20.0108913671064; 15238,20.0101405492445; 15239,20.0094185283994; 15240,20.0087263410081; 15241,20.0080650235076; 15242,20.0074356123351; 15243,20.0068391439274; 15244,20.0062766547217; 15245,20.005749181155; 15246,20.0052577596643; 15247,20.0048034266866; 15248,20.004387218659; 15249,20.0040101720185; 15250,20.0036733232021; 15251,20.0027826006104; 15252,20.0014640446859; 15253,20.0000726191401; 15254,19.9984229046888; 15255,19.9967436630612; 15256,19.9950351212329; 15257,19.9932975061793; 15258,19.9915310448758; 15259,19.989735964298; 15260,19.9879124914213; 15261,19.9860608532212; 15262,19.9841812766731; 15263,19.9822739887524; 15264,19.9805808828401; 15265,19.9789328818014; 15266,19.9775588551889; 15267,19.9761905018799; 15268,19.9748284040702; 15269,19.973473143956; 15270,19.9721253037331; 15271,
        19.9707854655976; 15272,19.9694542117454; 15273,19.9681321243727; 15274,19.9668197856752; 15275,19.9655177778492; 15276,19.9642266830904; 15277,19.9629470835949; 15278,19.9616795615588; 15279,19.9604246991779; 15280,19.9591830786484; 15281,19.9579552821661; 15282,19.9567418919271; 15283,19.9555434901273; 15284,19.9543606589628; 15285,19.9531939806295; 15286,19.9520440373235; 15287,19.9509114112406; 15288,19.949796684577; 15289,19.9487004395286; 15290,19.9476232582913; 15291,19.9465657230613; 15292,19.9455284160344; 15293,19.9445119194066; 15294,19.943516815374; 15295,19.9425436861326; 15296,19.9415931138782; 15297,19.940665680807; 15298,19.9397619691149; 15299,19.9388825609979; 15300,19.938028038652; 15301,19.9371989842731; 15302,19.9363959800573; 15303,19.9356196082006; 15304,19.9348704508989; 15305,19.9341490903483; 15306,19.9334561087447; 15307,19.9327920882841; 15308,19.9321576111625; 15309,19.9315532595759; 15310,19.9309796157203; 15311,19.9304372617917; 15312,
        19.929926779986; 15313,19.9294487524993; 15314,19.9290037615275; 15315,19.9285923892667; 15316,19.9282152179128; 15317,19.9278728296619; 15318,19.9275658067098; 15319,19.9272947312526; 15320,19.9270601854863; 15321,19.9268627516069; 15322,19.9267030118104; 15323,19.9265815482927; 15324,19.9264989432499; 15325,19.9264557788779; 15326,19.9264526373727; 15327,19.9264901009304; 15328,19.9265687517468; 15329,19.9266891720181; 15330,19.9268519439401; 15331,19.927057649709; 15332,19.9273068715205; 15333,19.9276001915709; 15334,19.927938192056; 15335,19.9283214551718; 15336,19.9287505631144; 15337,19.9292260980797; 15338,19.9297486422636; 15339,19.9303187778623; 15340,19.9309370870717; 15341,19.9316041520878; 15342,19.9323205551065; 15343,19.9330868783239; 15344,19.9339037039359; 15345,19.9347716141385; 15346,19.9354565757152; 15347,19.9354565757152; 15348,19.9354565757152; 15349,19.9354565757152; 15350,19.9354565757152; 15351,19.9354565757152; 15352,19.9354565757152; 15353,
        19.9354565757152; 15354,19.9354565757152; 15355,19.9354565757152; 15356,19.9354565757152; 15357,19.9354565757152; 15358,19.9354565757152; 15359,19.9354565757152; 15360,19.9354565757152; 15361,19.9354565757152; 15362,19.9354565757152; 15363,19.9354565757152; 15364,19.9354565757152; 15365,19.9354565757152; 15366,19.9354565757152; 15367,19.9354565757152; 15368,19.9354565757152; 15369,19.9354565757152; 15370,19.9354565757152; 15371,19.9354565757152; 15372,19.9354565757152; 15373,19.9354565757152; 15374,19.9354565757152; 15375,19.9354565757152; 15376,19.9354565757152; 15377,19.9354565757152; 15378,19.9354565757152; 15379,19.9354565757152; 15380,19.9354565757152; 15381,19.9354565757152; 15382,19.9354565757152; 15383,19.9354565757152; 15384,19.9354565757152; 15385,19.9354565757152; 15386,19.9354565757152; 15387,19.9354565757152; 15388,19.9354565757152; 15389,19.9354565757152; 15390,19.9354565757152; 15391,19.9354565757152; 15392,19.9354565757152; 15393,19.9354565757152; 15394,
        19.9354565757152; 15395,19.9354565757152; 15396,19.9354565757152; 15397,19.9354138070397; 15398,19.9353734684026; 15399,19.9353355323458; 15400,19.9352999714113; 15401,19.9352667581409; 15402,19.9352358650767; 15403,19.9352072647606; 15404,19.9351809297345; 15405,19.9351568325404; 15406,19.9351349457201; 15407,19.9351152418157; 15408,19.935097693369; 15409,19.9350822729221; 15410,19.9350689530168; 15411,19.9350577061951; 15412,19.9350485049989; 15413,19.9350413219702; 15414,19.9350361296509; 15415,19.935032900583; 15416,19.9350316073083; 15417,19.9350322223689; 15418,19.9350347183066; 15419,19.9350390676635; 15420,19.9350452429813; 15421,19.9350532168022; 15422,19.935062961668; 15423,19.9350744501206; 15424,19.935087654702; 15425,19.9351025479542; 15426,19.935119102419; 15427,19.9351372906385; 15428,19.9351570851545; 15429,19.9351784585091; 15430,19.935201383244; 15431,19.9352258319013; 15432,19.935251777023; 15433,19.9352791911509; 15434,19.935308046827; 15435,
        19.9353383165932; 15436,19.9353699729915; 15437,19.9354029885637; 15438,19.935437335852; 15439,19.9354729873981; 15440,19.9355099157441; 15441,19.9355480934318; 15442,19.9355874930032; 15443,19.9356280870003; 15444,19.9356698479649; 15445,19.9357127484391; 15446,19.9357567609648; 15447,19.9358018580838; 15448,19.9358480123382; 15449,19.9358951962698; 15450,19.9359433824207; 15451,19.9359925433328; 15452,19.9360426515479; 15453,19.9360936796081; 15454,19.9361456000552; 15455,19.9361983854313; 15456,19.9362520082782; 15457,19.9363064411379; 15458,19.9363616565523; 15459,19.9364176270635; 15460,19.9364743252132; 15461,19.9365317235434; 15462,19.9365897945962; 15463,19.9366485109134; 15464,19.936707845037; 15465,19.9367677695088; 15466,19.9368282568709; 15467,19.9368892796652; 15468,19.9369508104337; 15469,19.9370128217181; 15470,19.9370752860606; 15471,19.9371381760031; 15472,19.9372014640874; 15473,19.9372651228555; 15474,19.9373291248494; 15475,19.937393442611; 15476,
        19.9374580486822; 15477,19.937522915605; 15478,19.9375880159214; 15479,19.9376533221731; 15480,19.9377188069023; 15481,19.9377844426508; 15482,19.9378502019606; 15483,19.9379160573736; 15484,19.9379819814318; 15485,19.938047946677; 15486,19.9381139256513; 15487,19.9381798908965; 15488,19.9382458149547; 15489,19.9383116703677; 15490,19.9383774296774; 15491,19.938443065426; 15492,19.9385085501551; 15493,19.9385738564069; 15494,19.9386389567232; 15495,19.9388407557097; 15496,19.9390377270384; 15497,19.9392297586246; 15498,19.939416719792; 15499,19.9395984925464; 15500,19.9397749709986; 15501,19.9399460306679; 15502,19.9401115597558; 15503,19.9402714585686; 15504,19.9404256088214; 15505,19.9405739049111; 15506,19.94071625334; 15507,19.9408525420185; 15508,19.9409826715393; 15509,19.9411065546002; 15510,19.9412240853074; 15511,19.9413351704491; 15512,19.9414397289188; 15513,19.9415376610183; 15514,19.9416288797315; 15515,19.9417133101474; 15516,19.9417908587635; 15517,
        19.9418614548014; 15518,19.9419250088911; 15519,19.9419814443447; 15520,19.9420306965795; 15521,19.942072682421; 15522,19.9421073313773; 15523,19.9421345850608; 15524,19.9421543664932; 15525,19.9421666113777; 15526,19.9421712675227; 15527,19.9421682641453; 15528,19.9421575431445; 15529,19.9421390585244; 15530,19.9421127456975; 15531,19.9420785527584; 15532,19.942036439907; 15533,19.9419831353267; 15534,19.9419187758887; 15535,19.9418434984642; 15536,19.9417574399246; 15537,19.941660737141; 15538,19.9415535269847; 15539,19.9414359463269; 15540,19.9413081320389; 15541,19.941170220992; 15542,19.9410223500573; 15543,19.9408646561062; 15544,19.9406972760098; 15545,19.9405203466393; 15546,19.9403340048662; 15547,19.9401383875616; 15548,19.9399336315967; 15549,19.9397198738427; 15550,19.939497251171; 15551,19.9392659004528; 15552,19.9390259585593; 15553,19.9387807757866; 15554,19.9385303064248; 15555,19.9382745168695; 15556,19.9380133549243; 15557,19.9377467810754; 15558,
        19.9374747679135; 15559,19.9371972694383; 15560,19.9369142523312; 15561,19.9366256953789; 15562,19.9363315587765; 15563,19.9360318154012; 15564,19.9357264502352; 15565,19.9354154296692; 15566,19.9350987428182; 15567,19.9347763602054; 15568,19.9344482650362; 15569,19.934114452621; 15570,19.9337748996788; 15571,19.9334295956106; 15572,19.9330785419225; 15573,19.9327217215291; 15574,19.9323591300271; 15575,19.931990775118; 15576,19.9316618720842; 15577,19.9313296815004; 15578,19.9309910212553; 15579,19.9306461073063; 15580,19.9302951556108; 15581,19.9299383821262; 15582,19.9295760028101; 15583,19.9292082336197; 15584,19.9288352905125; 15585,19.928457389446; 15586,19.9280747463775; 15587,19.9276875772646; 15588,19.9272960980645; 15589,19.9269005247347; 15590,19.9265010732327; 15591,19.9260979595159; 15592,19.9256913995417; 15593,19.9252816092674; 15594,19.9248688046507; 15595,19.9244532016487; 15596,19.9240350162191; 15597,19.9236144643192; 15598,19.9231917619064; 15599,
        19.9227671249381; 15600,19.9223407693718; 15601,19.921912911165; 15602,19.9214837662749; 15603,19.9210535506591; 15604,19.9206224802749; 15605,19.9201907710799; 15606,19.9197586390313; 15607,19.9193263000867; 15608,19.9188939702034; 15609,19.9184618653389; 15610,19.9180302014506; 15611,19.9175991944959; 15612,19.9171690604323; 15613,19.9167400152171; 15614,19.9163122748078; 15615,19.9142574613554; 15616,19.9122969183628; 15617,19.9104298162083; 15618,19.9086553252705; 15619,19.9069726159277; 15620,19.9053808585585; 15621,19.9025581243608; 15622,19.899791402722; 15623,19.8967388046643; 15624,19.8938791282698; 15625,19.8912103342666; 15626,19.8887303833827; 15627,19.8864372363461; 15628,19.884328853885; 15629,19.8824031967273; 15630,19.8806582256012; 15631,19.8790919012347; 15632,19.8777021843558; 15633,19.8764870356927; 15634,19.8754444159733; 15635,19.8745722859257; 15636,19.873868606278; 15637,19.8733313377582; 15638,19.8729584410944; 15639,19.8727478770147; 15640,
        19.8726976062471; 15641,19.8728055895196; 15642,19.8730697875604; 15643,19.8734881610974; 15644,19.8740586708587; 15645,19.8747792775724; 15646,19.8756479419666; 15647,19.8766626247693; 15648,19.8778212867085; 15649,19.8791218885123; 15650,19.8805623909088; 15651,19.882140754626; 15652,19.883854940392; 15653,19.8837960727099; 15654,19.8839772915; 15655,19.8843953332761; 15656,19.8850469345519; 15657,19.885928831841; 15658,19.8870377616574; 15659,19.8883704605146; 15660,19.8899236649265; 15661,19.8916941114068; 15662,19.8936785364691; 15663,19.8958736766273; 15664,19.898276268395; 15665,19.9008830482861; 15666,19.9036907528142; 15667,19.9066961184931; 15668,19.9098958818366; 15669,19.9132867793583; 15670,19.916865547572; 15671,19.9206289229914; 15672,19.9245736421302; 15673,19.9286964415023; 15674,19.9328492574147; 15675,19.9371622724635; 15676,19.9416319379244; 15677,19.9462547236643; 15678,19.951027087445; 15679,19.9559454743463; 15680,19.9610063480395; 15681,19.9662061600909;
        15682,19.9715413493847; 15683,19.9770083733965; 15684,19.9826036774968; 15685,19.9883236943744; 15686,19.9941648753092; 15687,20.0001236594762; 15688,20.0061964733682; 15689,20.0123797620698; 15690,20.0186699585602; 15691,20.0250634831368; 15692,20.0315567746882; 15693,20.0381462599983; 15694,20.0448283531686; 15695,20.0515994868923; 15696,20.0584560711386; 15697,20.0653945344678; 15698,20.0724112933357; 15699,20.0795027515155; 15700,20.0862521954066; 15701,20.0925383491775; 15702,20.0989431349321; 15703,20.1054623477355; 15704,20.1120917705481; 15705,20.1188271736479; 15706,20.1256643459045; 15707,20.1325990640826; 15708,20.1396270922647; 15709,20.1467442131247; 15710,20.1539461972315; 15711,20.1612288024722; 15712,20.1685912033938; 15713,20.1760293510766; 15714,20.1835391966012; 15715,20.1911166910478; 15716,20.1987577854969; 15717,20.2064584310289; 15718,20.2142145787241; 15719,20.222022179663; 15720,20.2298771849258; 15721,20.2377755455931; 15722,20.2457132127452; 15723,
        20.2536861374625; 15724,20.2616902708253; 15725,20.2697215639141; 15726,20.2777759678092; 15727,20.2858494335911; 15728,20.2939379123401; 15729,20.3020373551366; 15730,20.310143713061; 15731,20.3182529371937; 15732,20.3263575805463; 15733,20.3344534074921; 15734,20.3425361697223; 15735,20.3506016375197; 15736,20.358645569062; 15737,20.3666637098448; 15738,20.3746518239551; 15739,20.382605663375; 15740,20.3905209674046; 15741,20.3983934939352; 15742,20.4062189887533; 15743,20.4139931849632; 15744,20.4217118342608; 15745,20.4293706656179; 15746,20.4369654265977; 15747,20.4444918526584; 15748,20.4519456665762; 15749,20.4593226097187; 15750,20.4666184113485; 15751,20.4738287880462; 15752,20.4809494749836; 15753,20.4879761952278; 15754,20.4949046591636; 15755,20.5017305957675; 15756,20.5084497219107; 15757,20.5150611504702; 15758,20.5215607808984; 15759,20.5279445126475; 15760,20.5342082451698; 15761,20.5403478779176; 15762,20.5463593103431; 15763,20.5522384418986; 15764,
        20.5579811720363; 15765,20.5635834002086; 15766,20.5690410258678; 15767,20.574349948466; 15768,20.5795060674555; 15769,20.5845052822887; 15770,20.5893434924178; 15771,20.594016597295; 15772,20.5985204963727; 15773,20.6028510891031; 15774,20.6070042749385; 15775,20.6109759533311; 15776,20.6147620237333; 15777,20.6183583855972; 15778,20.6217609383752; 15779,20.6249655815196; 15780,20.6279682144826; 15781,20.6307647367164; 15782,20.6333510476734; 15783,20.6357230468058; 15784,20.6378766335659; 15785,20.6398077074059; 15786,20.6415121677782; 15787,20.642985914135; 15788,20.6442248459286; 15789,20.6452248626112; 15790,20.6459818636351; 15791,20.6464917484526; 15792,20.646750416516; 15793,20.6467537672775; 15794,20.6482198733138; 15795,20.6495170858497; 15796,20.6506423499165; 15797,20.6515926105454; 15798,20.6523648127676; 15799,20.6529559016144; 15800,20.6547598319143; 15801,20.6565678656946; 15802,20.6587503604365; 15803,20.6608507611726; 15804,20.6628672225848; 15805,
        20.6647978993544; 15806,20.6666409461633; 15807,20.668394517693; 15808,20.6700567686253; 15809,20.6716258536416; 15810,20.6730999274237; 15811,20.6744771446531; 15812,20.6757556600116; 15813,20.6769336281808; 15814,20.6772796359129; 15815,20.677166482595; 15816,20.6770107518243; 15817,20.6768098754113; 15818,20.6765612851667; 15819,20.6762624129011; 15820,20.6759106904252; 15821,20.6755035495495; 15822,20.6750384220848; 15823,20.6745127398416; 15824,20.6739239346306; 15825,20.6732694382624; 15826,20.6725466825476; 15827,20.6717530992969; 15828,20.6708861203209; 15829,20.6699431774303; 15830,20.6689217024357; 15831,20.6678191271476; 15832,20.6675283237152; 15833,20.6673257660901; 15834,20.667209390624; 15835,20.6671771336684; 15836,20.6672269315753; 15837,20.6673567206961; 15838,20.6675644373827; 15839,20.6678480179866; 15840,20.6682053988597; 15841,20.6686345163536; 15842,20.6689499206844; 15843,20.6693433540061; 15844,20.6698126349342; 15845,20.6703555820839; 15846,
        20.6709700140707; 15847,20.6716537495098; 15848,20.6724046070167; 15849,20.6732204052066; 15850,20.674098962695; 15851,20.675038098097; 15852,20.6760356300282; 15853,20.6770893771039; 15854,20.6781971579393; 15855,20.6793567911499; 15856,20.680566095351; 15857,20.6818228891579; 15858,20.6831249911859; 15859,20.6844702200505; 15860,20.685856394367; 15861,20.6872813327506; 15862,20.6887428538168; 15863,20.690238776181; 15864,20.6917669184584; 15865,20.6933250992643; 15866,20.6949111372143; 15867,20.6965228509235; 15868,20.6981580590073; 15869,20.6998145800812; 15870,20.7014902327603; 15871,20.7031828356601; 15872,20.704890207396; 15873,20.7066101665832; 15874,20.7083405318371; 15875,20.7100791217731; 15876,20.7118237550064; 15877,20.7135722501525; 15878,20.7153224258267; 15879,20.7175089754834; 15880,20.7203029926408; 15881,20.72345630675; 15882,20.7266421899812; 15883,20.7298592795918; 15884,20.7331062128394; 15885,20.7363816269814; 15886,20.7396841592755; 15887,
        20.7430124469792; 15888,20.7463651273501; 15889,20.7497408376456; 15890,20.7531382151232; 15891,20.7565558970407; 15892,20.7599925206554; 15893,20.7634467232249; 15894,20.7669171420068; 15895,20.7704024142586; 15896,20.7739011772378; 15897,20.777412068202; 15898,20.7809337244087; 15899,20.7844647831155; 15900,20.7880038815798; 15901,20.7915496570593; 15902,20.7951007468115; 15903,20.7986557880938; 15904,20.8022134181639; 15905,20.8057722742793; 15906,20.8093309936976; 15907,20.8128882136762; 15908,20.8164425714727; 15909,20.8199927043446; 15910,20.8235372495495; 15911,20.827074844345; 15912,20.8306041259885; 15913,20.8341237317376; 15914,20.8376322988498; 15915,20.8411284645827; 15916,20.8446108661939; 15917,20.8480781409408; 15918,20.8515289260809; 15919,20.854961858872; 15920,20.8583755765713; 15921,20.8617687164367; 15922,20.8651399157254; 15923,20.8684878116952; 15924,20.8718110416034; 15925,20.8751082427078; 15926,20.8783780522657; 15927,20.8816191075348; 15928,
        20.8848300457726; 15929,20.8880095042366; 15930,20.8911561201844; 15931,20.8942685308734; 15932,20.8973453735613; 15933,20.9003852855056; 15934,20.9033869039638; 15935,20.9063488661935; 15936,20.9092698094522; 15937,20.9121483709974; 15938,20.9149831880866; 15939,20.9177728979775; 15940,20.9205161379276; 15941,20.9232115451943; 15942,20.9258577570353; 15943,20.928453410708; 15944,20.93099714347; 15945,20.9334875925789; 15946,20.9355700591533; 15947,20.9368345051658; 15948,20.9379254514313; 15949,20.9390314707474; 15950,20.9401503555865; 15951,20.9412798984212; 15952,20.9424178917239; 15953,20.9435621279671; 15954,20.9447103996233; 15955,20.945860499165; 15956,20.9470102190647; 15957,20.9481573517948; 15958,20.9492996898279; 15959,20.9504350256365; 15960,20.951561151693; 15961,20.9526758604698; 15962,20.9537769444396; 15963,20.9548621960748; 15964,20.9559294078478; 15965,20.9569763722312; 15966,20.9580008816975; 15967,20.9590007287191; 15968,20.9599737057685; 15969,
        20.9609176053182; 15970,20.9618302198407; 15971,20.9627093418085; 15972,20.963552763694; 15973,20.9643582779699; 15974,20.9651236771084; 15975,20.9658467535822; 15976,20.9665252998637; 15977,20.9671571084254; 15978,20.9677399717398; 15979,20.9682716822793; 15980,20.9687500325165; 15981,20.9691728149239; 15982,20.9695378219739; 15983,20.969842846139; 15984,20.9700856798918; 15985,20.9702641157046; 15986,20.97037594605; 15987,20.9704189634005; 15988,20.9703909602286; 15989,20.9702897290066; 15990,20.9701130622073; 15991,20.9698587523029; 15992,20.969524591766; 15993,20.9698798621142; 15994,20.9706124080692; 15995,20.9713243690274; 15996,20.9720142603323; 15997,20.9726805973275; 15998,20.9733218953563; 15999,20.9739366697623; 16000,20.974523435889; 16001,20.9750807090798; 16002,20.9756070046783; 16003,20.976100838028; 16004,20.9765607244723; 16005,20.9769851793547; 16006,20.9773727180188; 16007,20.9777218558079; 16008,20.9780311080657; 16009,20.9782989901356; 16010,
        20.978524017361; 16011,20.9798900789104; 16012,20.9812754467322; 16013,20.9826793558433; 16014,20.9841010412604; 16015,20.9855397380002; 16016,20.9869946810795; 16017,20.9884651055151; 16018,20.9899502463237; 16019,20.9914493385221; 16020,20.992961617127; 16021,20.9946802406939; 16022,20.9964211758403; 16023,20.9981837753193; 16024,20.999967391884; 16025,21.0017713782875; 16026,21.0035950872829; 16027,21.0054378716233; 16028,21.0072990840618; 16029,21.0091780773514; 16030,21.0110742042454; 16031,21.0129868174967; 16032,21.0149152698585; 16033,21.0168589140839; 16034,21.018817102926; 16035,21.0207891891378; 16036,21.0227745254725; 16037,21.0247724646832; 16038,21.026782359523; 16039,21.0288035627449; 16040,21.0308354271021; 16041,21.0328773053476; 16042,21.0349285502347; 16043,21.0369885145162; 16044,21.0390565509455; 16045,21.0411320122755; 16046,21.0432142512594; 16047,21.0453026206502; 16048,21.047396473201; 16049,21.049495161665; 16050,21.0515980387953; 16051,
        21.0537044573449; 16052,21.055813770067; 16053,21.0579253297146; 16054,21.0600384890408; 16055,21.0621526007988; 16056,21.0642670177416; 16057,21.0663810926224; 16058,21.0684941781941; 16059,21.0706056272101; 16060,21.0723894273357; 16061,21.074152419209; 16062,21.075893758045; 16063,21.0776125990586; 16064,21.0793080974648; 16065,21.0809794084784; 16066,21.0826256873146; 16067,21.0842460891881; 16068,21.085839769314; 16069,21.0874058829072; 16070,21.0889435851826; 16071,21.0904520313552; 16072,21.09193037664; 16073,21.0933777762519; 16074,21.0947933854057; 16075,21.0961763593166; 16076,21.0975258531994; 16077,21.0988410222691; 16078,21.1001210217407; 16079,21.101365006829; 16080,21.102572132749; 16081,21.1037415547157; 16082,21.104872427944; 16083,21.1059639076489; 16084,21.1070151490453; 16085,21.1080253073481; 16086,21.1089935377724; 16087,21.109918995533; 16088,21.110800835845; 16089,21.1116382139232; 16090,21.1124302849826; 16091,21.1131762042381; 16092,21.1138751269047;
        16093,21.1145262081974; 16094,21.1151286033311; 16095,21.1156814675207; 16096,21.1161839559812; 16097,21.1166352239276; 16098,21.1170344265747; 16099,21.1173807191376; 16100,21.1176732568311; 16101,21.1179111948703; 16102,21.11809368847; 16103,21.1182198928453; 16104,21.118288963211; 16105,21.1183000547822; 16106,21.1182523227737; 16107,21.1190489391279; 16108,21.1197336777456; 16109,21.1203062742325; 16110,21.1207664641944; 16111,21.1211139832371; 16112,21.1213485669663; 16113,21.1214782255566; 16114,21.1215022043839; 16115,21.1214197954454; 16116,21.1212302748128; 16117,21.1209329037862; 16118,21.1205269902871; 16119,21.1200118062276; 16120,21.119386670141; 16121,21.1186508645513; 16122,21.1178037186035; 16123,21.1168445254336; 16124,21.1157726247986; 16125,21.1149609794324; 16126,21.1148828153347; 16127,21.1149469101284; 16128,21.1149730145525; 16129,21.1149613396855; 16130,21.1149120605961; 16131,21.1148253989746; 16132,21.1146932860166; 16133,21.1145164029452; 16134,
        21.1142954309833; 16135,21.1140310513538; 16136,21.1137239452797; 16137,21.1133747939839; 16138,21.1129842786894; 16139,21.1125530806191; 16140,21.112081880996; 16141,21.1115713610431; 16142,21.1110222019832; 16143,21.1104350850393; 16144,21.1098106914344; 16145,21.1091414278226; 16146,21.1084284656568; 16147,21.1076729297683; 16148,21.106884235483; 16149,21.1060630480997; 16150,21.105210032917; 16151,21.1043258552336; 16152,21.1034111803482; 16153,21.1024666735595; 16154,21.1014930001662; 16155,21.100490825467; 16156,21.0994608147605; 16157,21.0984036333455; 16158,21.0973199465207; 16159,21.0962104195846; 16160,21.0950757178362; 16161,21.0939165065739; 16162,21.0927334510966; 16163,21.0915272167028; 16164,21.0902984686914; 16165,21.089047872361; 16166,21.0878991069277; 16167,21.0868187952433; 16168,21.08607703733; 16169,21.0852828036844; 16170,21.0844371382283; 16171,21.083541084884; 16172,21.0825956875735; 16173,21.0816019902188; 16174,21.0805610367421; 16175,
        21.0794738710654; 16176,21.0783415371108; 16177,21.0771650788004; 16178,21.0759455400562; 16179,21.0746839648003; 16180,21.0733813969549; 16181,21.0720388804419; 16182,21.0706574591834; 16183,21.0692381771016; 16184,21.0677820781185; 16185,21.0662902061562; 16186,21.0647636051367; 16187,21.0632033189821; 16188,21.0616103916146; 16189,21.0599858669561; 16190,21.0583307889287; 16191,21.0566462014546; 16192,21.0549331484558; 16193,21.0531926738544; 16194,21.0514258215724; 16195,21.049633635532; 16196,21.0478171596551; 16197,21.045977437864; 16198,21.0441155140806; 16199,21.042232432227; 16200,21.0403292362253; 16201,21.0384069699976; 16202,21.0365710736036; 16203,21.0347122632291; 16204,21.0328316498197; 16205,21.0309303443213; 16206,21.0290094576797; 16207,21.0270701008406; 16208,21.0251133847499; 16209,21.0231404203533; 16210,21.0211523185967; 16211,21.0191501904258; 16212,21.0171351467864; 16213,21.0151082986242; 16214,21.0130707568852; 16215,21.0110236325151; 16216,
        21.0089680364596; 16217,21.0069050796646; 16218,21.0048358730758; 16219,21.0027615276391; 16220,21.0006831543002; 16221,20.9986018640049; 16222,20.996518767699; 16223,20.9944349763283; 16224,20.9923516008386; 16225,20.9902697521757; 16226,20.9881905412854; 16227,20.9861150791134; 16228,20.9840444766055; 16229,20.9819798447076; 16230,20.9799222943655; 16231,20.9778729365248; 16232,20.9758328821315; 16233,20.9738032421312; 16234,20.9717851274698; 16235,20.9697796490931; 16236,20.9677879179469; 16237,20.9658110449769; 16238,20.963850141129; 16239,20.9619063173489; 16240,20.9599806845825; 16241,20.9580743537754; 16242,20.9561884358736; 16243,20.9543240418227; 16244,20.9525457477082; 16245,20.9509212517494; 16246,20.9493104530242; 16247,20.9477145890341; 16248,20.9461348972809; 16249,20.9445726152664; 16250,20.9430289804922; 16251,20.9415052304601; 16252,20.9400026026719; 16253,20.9385223346291; 16254,20.9370656638337; 16255,20.9356338277872; 16256,20.9342280639915; 16257,
        20.9328496099482; 16258,20.931499703159; 16259,20.9301795811258; 16260,20.9288904813502; 16261,20.927633641334; 16262,20.9269990180831; 16263,20.9263656796233; 16264,20.9257352414219; 16265,20.9251093189465; 16266,20.9244895276646; 16267,20.9238774830437; 16268,20.9232748005514; 16269,20.922683095655; 16270,20.9221039838222; 16271,20.9215390805204; 16272,20.9209900012172; 16273,20.9204583613801; 16274,20.9199457764765; 16275,20.919453861974; 16276,20.9189842333401; 16277,20.9185385060423; 16278,20.9181182955481; 16279,20.9177252173251; 16280,20.9173608868407; 16281,20.9170269195624; 16282,20.9167249309578; 16283,20.9164565364943; 16284,20.9162233516395; 16285,20.9160269918609; 16286,20.914913110921; 16287,20.9137867606239; 16288,20.9126489760464; 16289,20.911500792265; 16290,20.9103432443565; 16291,20.9091773673975; 16292,20.9079954464378; 16293,20.906798057021; 16294,20.9055857280699; 16295,20.9043590032785; 16296,20.9031184422665; 16297,20.9018645580321; 16298,
        20.9005978995833; 16299,20.8993189693063; 16300,20.8980283055972; 16301,20.8967264002305; 16302,20.8954137809902; 16303,20.8940909290391; 16304,20.8927583403113; 16305,20.8914165266666; 16306,20.8900659533435; 16307,20.8887071215899; 16308,20.8873404860324; 16309,20.885966537307; 16310,20.8845857194283; 16311,20.8832072412098; 16312,20.881832036896; 16313,20.8804610407315; 16314,20.8790951869608; 16315,20.8777354098286; 16316,20.8763826435793; 16317,20.8750378224576; 16318,20.873701880708; 16319,20.872375752575; 16320,20.8710603723032; 16321,20.8697566741372; 16322,20.8684655923216; 16323,20.8658171136685; 16324,20.8632697646224; 16325,20.8608240587943; 16326,20.8584805564162; 16327,20.8562310529215; 16328,20.8540756183126; 16329,20.8520143225917; 16330,20.8500472357609; 16331,20.8481744278227; 16332,20.8463959687793; 16333,20.8447119286328; 16334,20.8431223773857; 16335,20.84162738504; 16336,20.8402270215982; 16337,20.8389213570624; 16338,20.837710461435; 16339,
        20.8365944047181; 16340,20.8355732569141; 16341,20.8346470880251; 16342,20.8338159680536; 16343,20.8330799670016; 16344,20.8324391548715; 16345,20.8317635193443; 16346,20.8310745905337; 16347,20.8300761853291; 16348,20.8291387640779; 16349,20.8282620181588; 16350,20.8274456389507; 16351,20.8266893178326; 16352,20.8259927461833; 16353,20.8253556153816; 16354,20.8247776168065; 16355,20.8242584418369; 16356,20.8237977818515; 16357,20.8233953282293; 16358,20.8230507723491; 16359,20.8227638055899; 16360,20.8225341193304; 16361,20.8223614049496; 16362,20.8222453538264; 16363,20.8221856573396; 16364,20.8221820068681; 16365,20.8222340937908; 16366,20.8223416094865; 16367,20.8225042453342; 16368,20.8227216927127; 16369,20.8229936430008; 16370,20.8233197875775; 16371,20.8236998178216; 16372,20.824133425112; 16373,20.8246203008276; 16374,20.8251601363473; 16375,20.8257526230498; 16376,20.8263974523142; 16377,20.8270943155193; 16378,20.8278429040439; 16379,20.8286429092669; 16380,
        20.8294940225673; 16381,20.8302855405637; 16382,20.831121483749; 16383,20.8320014764784; 16384,20.8329251431069; 16385,20.8338921079899; 16386,20.8349019954824; 16387,20.8359544299396; 16388,20.8370490357167; 16389,20.8381854371687; 16390,20.839363258651; 16391,20.8405821245186; 16392,20.8418416591267; 16393,20.8431414868305; 16394,20.8444812319851; 16395,20.8458605189457; 16396,20.8472789720674; 16397,20.8487362157055; 16398,20.850231874215; 16399,20.8517655719511; 16400,20.8533369332691; 16401,20.8549455825239; 16402,20.8565911440709; 16403,20.8582732422652; 16404,20.8599915014619; 16405,20.8617455460162; 16406,20.8635350002833; 16407,20.8653594886182; 16408,20.8672186353763; 16409,20.8691120649126; 16410,20.8710394015823; 16411,20.8730002697405; 16412,20.8749942937425; 16413,20.8770210979433; 16414,20.8790803066982; 16415,20.8811715443623; 16416,20.8832944352908; 16417,20.8854486038388; 16418,20.8876336743614; 16419,20.889849271214; 16420,20.8920950187515; 16421,
        20.8943705413292; 16422,20.8966754633022; 16423,20.8989422971669; 16424,20.9010927532484; 16425,20.903259987733; 16426,20.9054434984199; 16427,20.9076427831084; 16428,20.9098573395976; 16429,20.9120866656868; 16430,20.9143302591753; 16431,20.9165876178621; 16432,20.9188582395467; 16433,20.9211416220281; 16434,20.9234372631057; 16435,20.9257446605786; 16436,20.9280633122461; 16437,20.9303927159073; 16438,20.9327323693616; 16439,20.9350817704081; 16440,20.937775175373; 16441,20.9402334973683; 16442,20.9426244500413; 16443,20.9449476235001; 16444,20.9472026078532; 16445,20.9493889932089; 16446,20.9515063696755; 16447,20.9535543273614; 16448,20.9555324563749; 16449,20.9574403468243; 16450,20.9592775888179; 16451,20.9610437724642; 16452,20.9627384878715; 16453,20.964361325148; 16454,20.9659118744021; 16455,20.9673897257422; 16456,20.9687944692766; 16457,20.9701256951137; 16458,20.9713829933617; 16459,20.972565954129; 16460,20.973674167524; 16461,20.974707223655; 16462,
        20.9756647126303; 16463,20.9765462245583; 16464,20.9773513495472; 16465,20.9780796777056; 16466,20.9787307991416; 16467,20.9793043039636; 16468,20.9797997822799; 16469,20.980216824199; 16470,20.9805550198291; 16471,20.9808139592786; 16472,20.9809932326557; 16473,20.981092430069; 16474,20.9811111416265; 16475,20.9810489574369; 16476,20.9809054676082; 16477,20.980680262249; 16478,20.9803729314675; 16479,20.9799830653721; 16480,20.9795102540711; 16481,20.9789540876728; 16482,20.9783141562857; 16483,20.9775900500179; 16484,20.9767813589779; 16485,20.975887673274; 16486,20.9749085830146; 16487,20.9738436783079; 16488,20.9726925492624; 16489,20.9714547859862; 16490,20.9701299785879; 16491,20.9687177171757; 16492,20.967217591858; 16493,20.9656291927431; 16494,20.9639521099393; 16495,20.962185933555; 16496,20.9603302536985; 16497,20.9583846604782; 16498,20.9563487440023; 16499,20.9542220943793; 16500,20.8299999237061; 20000,20.8299999237061])
    annotation (Placement(transformation(extent={{-440,-80},{-420,-60}})));
  Modelica.Blocks.Sources.TimeTable timeTablePrimAir_complete(table=[0,20.8360806466205; 5,20.8337455065569; 10,20.8323471265822; 15,20.831789526269; 20,20.8319767251897; 25,20.8328127429165; 30,20.8342015990221; 35,20.8360473130787; 40,20.8382539046588; 45,20.8407253933349; 50,20.8433657986792; 55,20.8460791402644; 60,20.8487694376627; 65,20.8513407104465; 70,20.8536969781884; 75,20.8557422604607; 80,20.8573805768359; 85,20.8585159468863; 90,20.8586270357088; 95,20.8561231082354; 100,20.8502817569613; 105,20.8441992510295; 110,20.8379132622674; 115,20.8314614625026; 120,20.8248815235628; 125,20.8182111172755; 130,20.8114879154684; 135,20.8047495899689; 140,20.7980338126048; 145,20.7913782552035; 150,20.7848205895927; 155,20.7783984876001; 160,20.772149621053; 165,20.7661116617793; 170,20.7603222816063; 175,20.7548191523618; 180,20.7504219264558; 185,20.7511713174379; 190,20.7538954161243; 195,20.7585685760002; 200,20.7653039705015; 205,20.7663234887254; 210,20.7623120052105; 215,
        20.7572076449408; 220,20.7552177573452; 225,20.7609165211982; 230,20.768688428921; 235,20.778627849465; 240,20.7802955737429; 245,20.7815832324622; 250,20.7824673226421; 255,20.7828979359208; 260,20.7828251639364; 265,20.7821990983271; 270,20.780969830731; 275,20.7796380036456; 280,20.7802657970884; 285,20.7803324824104; 290,20.7803500012141; 295,20.7806519021025; 300,20.781214321255; 305,20.782013394851; 310,20.7830252590699; 315,20.784226050091; 320,20.7855919040937; 325,20.7870989572575; 330,20.7887233457616; 335,20.7904412057856; 340,20.7922286735087; 345,20.7940618851103; 350,20.7959169767699; 355,20.7977004939363; 360,20.7992382173156; 365,20.800819494988; 370,20.8025859713209; 375,20.80450817511; 380,20.8062689986437; 385,20.807674966355; 390,20.8087037182483; 395,20.8096205308356; 400,20.8108334384046; 405,20.8121143243441; 410,20.8136059788326; 415,20.8152865828584; 420,20.8167096144; 425,20.8178762827429; 430,20.8187596932084; 435,20.8193492645471; 440,
        20.8196344155091; 445,20.8196045648448; 450,20.8192491313046; 455,20.8185575336388; 460,20.8175191905978; 465,20.8171015456897; 470,20.8167457708353; 475,20.8163225201658; 480,20.8158369497235; 485,20.8152942155507; 490,20.8146994736897; 495,20.8140578801827; 500,20.8133745910721; 505,20.8126547624002; 510,20.8119035502092; 515,20.8111261105414; 520,20.8103275994392; 525,20.8095131729448; 530,20.8086879871004; 535,20.8080084201785; 540,20.8076275621374; 545,20.8073591989783; 550,20.8069193464109; 555,20.8063116566527; 560,20.8057108974921; 565,20.8054154688625; 570,20.8054361341897; 575,20.8056125413283; 580,20.8059554310928; 585,20.8064755442978; 590,20.8067356180856; 595,20.8067356180856; 600,20.8067356180856; 605,20.8067356180856; 610,20.8067356180856; 615,20.8067356180856; 620,20.8067356180856; 625,20.8067356180856; 630,20.8067356180856; 635,20.8067356180856; 640,20.8067356180856; 645,20.8067356180856; 650,20.8067356180856; 655,20.8067356180856; 660,20.8067356180856; 665,
        20.8067356180856; 670,20.8067356180856; 675,20.8067356180856; 680,20.8067356180856; 685,20.8067356180856; 690,20.8067356180856; 695,20.8067356180856; 700,20.8067356180856; 705,20.805269086214; 710,20.8037970713152; 715,20.8028821434959; 720,20.802489828674; 725,20.8025856527674; 730,20.8031351416941; 735,20.804103821372; 740,20.8054572177189; 745,20.8071608566529; 750,20.8091802640919; 755,20.8114809659537; 760,20.8140284881564; 765,20.8167883566178; 770,20.8197260972558; 775,20.8228072359885; 780,20.8259972987337; 785,20.8292618114093; 790,20.8325662999332; 795,20.8358762902235; 800,20.8391573081979; 805,20.8423748797745; 810,20.8454945308712; 815,20.8484817874059; 820,20.8513021752964; 825,20.8539212204609; 830,20.8563044488171; 835,20.8584173862829; 840,20.8602255587764; 845,20.8616944922155; 850,20.862789712518; 855,20.8634767456019; 860,20.8637211173851; 865,20.8634883537856; 870,20.8619966993099; 875,20.8596511186629; 880,20.8571009630523; 885,20.8566468129315; 890,
        20.8566506468221; 895,20.856961473308; 900,20.8575562956994; 905,20.8584121173061; 910,20.8595059414381; 915,20.8608147714054; 920,20.8623156105179; 925,20.8639854620857; 930,20.8658013294187; 935,20.8677402158268; 940,20.8697791246201; 945,20.8718950591085; 950,20.874065022602; 955,20.8762660184105; 960,20.8796764861522; 965,20.8842732703585; 970,20.8880133957871; 975,20.8909234839918; 980,20.8930301565262; 985,20.8943600349442; 990,20.8949397407995; 995,20.8947958956459; 1000,20.8939551210371; 1005,20.8924440385271; 1010,20.8902892696694; 1015,20.8875174360179; 1020,20.8841551591264; 1025,20.8802290605487; 1030,20.8757657618384; 1035,20.8707918845494; 1040,20.8653340502354; 1045,20.8594188804503; 1050,20.8542993236829; 1055,20.8495570104134; 1060,20.8448891245095; 1065,20.8403452842152; 1070,20.8359751077741; 1075,20.8318282134302; 1080,20.8279542194272; 1085,20.8244027440089; 1090,20.8212234054191; 1095,20.8184658219016; 1100,20.8161796117002; 1105,20.8144143930587; 1110,
        20.813219784221; 1115,20.8125904538669; 1120,20.8124572979965; 1125,20.8131172502246; 1130,20.814615519001; 1135,20.816997312775; 1140,20.8182382432001; 1145,20.8183337417038; 1150,20.8184808347997; 1155,20.8186751126939; 1160,20.8189121655919; 1165,20.8191875836997; 1170,20.8194969572229; 1175,20.8198358763674; 1180,20.820199931339; 1185,20.8205847123434; 1190,20.8209858095864; 1195,20.8213988132738; 1200,20.8218193136114; 1205,20.8222429008049; 1210,20.8226651650602; 1215,20.8230816965829; 1220,20.823488085579; 1225,20.8238799222542; 1230,20.8242527968142; 1235,20.8246022994648; 1240,20.8249240204119; 1245,20.8252135498611; 1250,20.8254664780184; 1255,20.8256783950894; 1260,20.8258448912799; 1265,20.8259615567958; 1270,20.8260239818427; 1275,20.8219242385014; 1280,20.8190154032844; 1285,20.8172188670967; 1290,20.8164560208435; 1295,20.8167676620737; 1300,20.8181919918497; 1305,20.8204992933039; 1310,20.8225467522755; 1315,20.8250325111389; 1320,20.8289881119389; 1325,
        20.8403403165021; 1330,20.8505801785182; 1335,20.8597252501288; 1340,20.8677930834752; 1345,20.874801230699; 1350,20.8807672439415; 1355,20.8857086753443; 1360,20.8896430770488; 1365,20.8925880011965; 1370,20.8945609999289; 1375,20.8911905854211; 1380,20.8872305507303; 1385,20.8868401519227; 1390,20.8877827032926; 1395,20.8878624444152; 1400,20.8870826197773; 1405,20.8854464738656; 1410,20.8829572511669; 1415,20.8796181961679; 1420,20.8754325533555; 1425,20.8704035672163; 1430,20.8645344822371; 1435,20.8578285429046; 1440,20.8502889937057; 1445,20.8419190791271; 1450,20.8336997530007; 1455,20.8293850641429; 1460,20.8256669500087; 1465,20.8226228543856; 1470,20.8203302210611; 1475,20.8188664938225; 1480,20.8183091164574; 1485,20.8187355327531; 1490,20.821952876961; 1495,20.8272531125856; 1500,20.832406118742; 1505,20.8319591675819; 1510,20.8312044948243; 1515,20.8301277928143; 1520,20.8287147538974; 1525,20.8269510704187; 1530,20.8248224347237; 1535,20.8221975504115; 1540,
        20.8181499110583; 1545,20.8140526982683; 1550,20.8098702919934; 1555,20.8126100039275; 1560,20.8170503437985; 1565,20.8184802202962; 1570,20.8191641685936; 1575,20.8200785442732; 1580,20.8212020349412; 1585,20.8225133282041; 1590,20.8239911116682; 1595,20.8256140729399; 1600,20.8273608996255; 1605,20.8292102793315; 1610,20.8311408996642; 1615,20.83313144823; 1620,20.8351606126352; 1625,20.8372070804863; 1630,20.8375979170214; 1635,20.8384681410611; 1640,20.8397665757831; 1645,20.841442044365; 1650,20.8434433699843; 1655,20.8457193758187; 1660,20.8482188850458; 1665,20.8508907208432; 1670,20.8536837063886; 1675,20.8565466648595; 1680,20.8594284194335; 1685,20.8622777932883; 1690,20.8650436096015; 1695,20.8676746915507; 1700,20.8701198623135; 1705,20.8723279450675; 1710,20.8742477629903; 1715,20.8762394766547; 1720,20.8791033559151; 1725,20.8819343843039; 1730,20.8836587230182; 1735,20.8856095035375; 1740,20.8877379844191; 1745,20.8899954242205; 1750,20.8923330814989; 1755,
        20.8951418247759; 1760,20.8980551843903; 1765,20.9006993510499; 1770,20.9030380487174; 1775,20.9050350013552; 1780,20.906653932926; 1785,20.9078585673923; 1790,20.9086126287165; 1795,20.9096840052488; 1800,20.9101631114549; 1805,20.9101925768089; 1810,20.9112634087638; 1815,20.912024190118; 1820,20.9124861339338; 1825,20.9126604532733; 1830,20.912558361199; 1835,20.912191070773; 1840,20.9115697950577; 1845,20.9107057471152; 1850,20.909610140008; 1855,20.9082941867983; 1860,20.9067691005482; 1865,20.9050460943202; 1870,20.9031363811765; 1875,20.9010511741794; 1880,20.8988016863911; 1885,20.8963991308739; 1890,20.8938547206901; 1895,20.8911796689019; 1900,20.8883851885718; 1905,20.8857312313979; 1910,20.8841832510436; 1915,20.8820277664402; 1920,20.8773886726888; 1925,20.87426693594; 1930,20.872621842962; 1935,20.8717011153079; 1940,20.8717871729643; 1945,20.8758682671685; 1950,20.8838908378648; 1955,20.8909492960247; 1960,20.8971096563964; 1965,20.9024379337284; 1970,
        20.9070001427691; 1975,20.9095721018529; 1980,20.9111769158608; 1985,20.9118629748701; 1990,20.9116786689584; 1995,20.9106723882031; 2000,20.9088925226816; 2005,20.9063874624713; 2010,20.9032055976496; 2015,20.899395318294; 2020,20.895005014482; 2025,20.8900830762908; 2030,20.8846778937981; 2035,20.8788378570811; 2040,20.8726113562174; 2045,20.8659477475492; 2050,20.8586814520808; 2055,20.8513065879944; 2060,20.843863597745; 2065,20.8363929237875; 2070,20.8289350085766; 2075,20.8215302945674; 2080,20.8141878531552; 2085,20.8033748520463; 2090,20.7930947546809; 2095,20.7862188467841; 2100,20.7845839792936; 2105,20.7857253340187; 2110,20.7896750705441; 2115,20.7964653484546; 2120,20.806128327335; 2125,20.8137245629932; 2130,20.8191666402098; 2135,20.825253626138; 2140,20.8320003856358; 2145,20.8393198714361; 2150,20.8469537272112; 2155,20.8548191274841; 2160,20.8628332467776; 2165,20.8709132596146; 2170,20.8789763405181; 2175,20.8896947524036; 2180,20.9029853056896; 2185,
        20.9141330363277; 2190,20.9191561958845; 2195,20.9209859256377; 2200,20.9226203621094; 2205,20.9239766798226; 2210,20.9249720533; 2215,20.9255236570647; 2220,20.9255486656396; 2225,20.9251794560918; 2230,20.9240209004241; 2235,20.9220957090187; 2240,20.9197156052725; 2245,20.916790886299; 2250,20.9132318492119; 2255,20.9089487911246; 2260,20.9039363624745; 2265,20.9037488533051; 2270,20.9040641959039; 2275,20.9048717735624; 2280,20.906160969572; 2285,20.9079211672244; 2290,20.9133942950812; 2295,20.9190375249644; 2300,20.9239722142238; 2305,20.928259031377; 2310,20.9319586449416; 2315,20.9351317234353; 2320,20.937663404525; 2325,20.9396101349384; 2330,20.9411302735282; 2335,20.9422802804888; 2340,20.9431166160142; 2345,20.9436957402989; 2350,20.9440741135371; 2355,20.9395622746681; 2360,20.9301025370978; 2365,20.9183926667295; 2370,20.9108704207701; 2375,20.9045289564873; 2380,20.8955053360972; 2385,20.8841492525978; 2390,20.8743413040791; 2395,20.8660398843906; 2400,
        20.8592033873818; 2405,20.853790206902; 2410,20.8506049970606; 2415,20.8492218513005; 2420,20.8494292567459; 2425,20.8512004322779; 2430,20.854508596778; 2435,20.8593269691274; 2440,20.8656287682073; 2445,20.8795027349153; 2450,20.8929377623759; 2455,20.9060176495734; 2460,20.9188261954921; 2465,20.9314471991162; 2470,20.9387460957356; 2475,20.9446100593668; 2480,20.9491005324346; 2485,20.952280087633; 2490,20.9541593191057; 2495,20.9547488209965; 2500,20.9540591874492; 2505,20.9521010126076; 2510,20.9488848906155; 2515,20.9444214156166; 2520,20.9387211817547; 2525,20.9317947831737; 2530,20.9236528140173; 2535,20.9143058684294; 2540,20.9037645405536; 2545,20.8920394245338; 2550,20.8791411145138; 2555,20.8665760950826; 2560,20.8576668546482; 2565,20.8509425716098; 2570,20.8443171214726; 2575,20.8367826028908; 2580,20.8263601021424; 2585,20.8179378821177; 2590,20.8115828762723; 2595,20.8073620180617; 2600,20.8053422409415; 2605,20.8055904783671; 2610,20.8081736637941; 2615,
        20.813158730678; 2620,20.8191555205733; 2625,20.8206410984969; 2630,20.8226172782769; 2635,20.8250404132658; 2640,20.8309928424183; 2645,20.8365818641582; 2650,20.8415190723772; 2655,20.8459309764173; 2660,20.8470433518741; 2665,20.8468324740124; 2670,20.8473443077514; 2675,20.8485199704111; 2680,20.8503005793118; 2685,20.8526272517734; 2690,20.8554411051162; 2695,20.8586832566601; 2700,20.8622948237254; 2705,20.866216923632; 2710,20.8703906737001; 2715,20.8747571912497; 2720,20.8792575936011; 2725,20.8838329980742; 2730,20.8884245219892; 2735,20.8905338658068; 2740,20.891066329182; 2745,20.8933283282657; 2750,20.8936015515789; 2755,20.894277373701; 2760,20.8974074537095; 2765,20.900057246364; 2770,20.902259659109; 2775,20.9040475993893; 2780,20.9054539746494; 2785,20.9065116923341; 2790,20.9072536598879; 2795,20.9077127847556; 2800,20.9079219743818; 2805,20.9079141362111; 2810,20.9077221776882; 2815,20.9068861163784; 2820,20.9018516668588; 2825,20.8955794090547; 2830,
        20.8880416721523; 2835,20.8792107853375; 2840,20.8734963778696; 2845,20.8688557295433; 2850,20.8643702768005; 2855,20.8600900827327; 2860,20.8560652104314; 2865,20.852345722988; 2870,20.8489816834941; 2875,20.8460231550409; 2880,20.8435202007201; 2885,20.8415228836231; 2890,20.8400812668413; 2895,20.8392454134662; 2900,20.837385795412; 2905,20.8345526977402; 2910,20.8336200853438; 2915,20.8345686557024; 2920,20.8367194349522; 2925,20.8375224112741; 2930,20.8391924577431; 2935,20.8416602087476; 2940,20.8448562986757; 2945,20.8487113619157; 2950,20.8556282847025; 2955,20.8637508807432; 2960,20.8711816875757; 2965,20.8779214417776; 2970,20.8839708799262; 2975,20.8893307385991; 2980,20.8940017543738; 2985,20.8979846638276; 2990,20.9012802035381; 2995,20.9038891100827; 3000,20.905812120039; 3005,20.9070499699843; 3010,20.9076033964962; 3015,20.9074731361521; 3020,20.9066599255295; 3025,20.9051645012058; 3030,20.9029875997586; 3035,20.8988693321793; 3040,20.8936988786101; 3045,
        20.8884386933039; 3050,20.8830533609067; 3055,20.8775074660645; 3060,20.8711236826099; 3065,20.863866680022; 3070,20.8577152138881; 3075,20.8519316417107; 3080,20.8486559791167; 3085,20.8479223983338; 3090,20.8480852584427; 3095,20.8497293710448; 3100,20.8540788595359; 3105,20.858688373735; 3110,20.8636360714425; 3115,20.8690001104585; 3120,20.8748313429053; 3125,20.8811996264606; 3130,20.8842216404956; 3135,20.8858131433397; 3140,20.8868541404321; 3145,20.8873397445758; 3150,20.8872489002361; 3155,20.8865991912636; 3160,20.8854095666009; 3165,20.8836980320206; 3170,20.8814818637671; 3175,20.8787775695568; 3180,20.8756008673405; 3185,20.8719666853033; 3190,20.8678891618642; 3195,20.8633816456766; 3200,20.8584566956283; 3205,20.853126080841; 3210,20.8474008542112; 3215,20.8433348723912; 3220,20.840035262576; 3225,20.8370810763905; 3230,20.8345182558935; 3235,20.8324215433112; 3240,20.8319385315154; 3245,20.8331189121534; 3250,20.8338313212666; 3255,20.8348253589245; 3260,
        20.8364913820173; 3265,20.8388897523368; 3270,20.8420473058017; 3275,20.8447938441824; 3280,20.8459901392907; 3285,20.8471885349619; 3290,20.8483494228833; 3295,20.8494579092433; 3300,20.8505385293812; 3305,20.8515983587474; 3310,20.8525944701304; 3315,20.8535001046566; 3320,20.8542998667284; 3325,20.8550003238191; 3330,20.8556278387227; 3335,20.8561822583216; 3340,20.8566641012757; 3345,20.8570748815242; 3350,20.8583377787332; 3355,20.8592534002312; 3360,20.859842192893; 3365,20.8601253933592; 3370,20.8601250280361; 3375,20.8598639130959; 3380,20.8593656544765; 3385,20.8586546478816; 3390,20.8577559607928; 3395,20.8566956559709; 3400,20.855500496805; 3405,20.8541980364502; 3410,20.8528102595178; 3415,20.8513206042365; 3420,20.8497382736483; 3425,20.8480912102311; 3430,20.8464402627807; 3435,20.8448174799251; 3440,20.8432202059627; 3445,20.8409564128354; 3450,20.838542213998; 3455,20.8365052514584; 3460,20.8348322586188; 3465,20.8335102023377; 3470,20.8325501385854; 3475,
        20.8319491403933; 3480,20.8317042807927; 3485,20.8318126328149; 3490,20.8322712694913; 3495,20.8330772638532; 3500,20.8342276889318; 3505,20.8357196177586; 3510,20.8375501233648; 3515,20.8397162787817; 3520,20.8422151570408; 3525,20.8448244008805; 3530,20.8466992788677; 3535,20.8485800307781; 3540,20.8504470768676; 3545,20.8522808373919; 3550,20.8540617326069; 3555,20.8557701827682; 3560,20.8573866081317; 3565,20.8588914289532; 3570,20.8602650654884; 3575,20.8614879379932; 3580,20.8625404667233; 3585,20.8634030719345; 3590,20.8640561738826; 3595,20.8641501941819; 3600,20.8629384850648; 3605,20.8619051023202; 3610,20.861003728603; 3615,20.8601880465679; 3620,20.8594117388698; 3625,20.8597461626185; 3630,20.8607206344979; 3635,20.8683693669653; 3640,20.8742942470464; 3645,20.8785859688642; 3650,20.881335226542; 3655,20.878769930607; 3660,20.8751756955868; 3665,20.8716740994476; 3670,20.8682711766446; 3675,20.8649729616332; 3680,20.8617854888685; 3685,20.8587147928058; 3690,
        20.8557669079003; 3695,20.8529478686073; 3700,20.8502637093821; 3705,20.8477204646798; 3710,20.8453241689558; 3715,20.8430808566652; 3720,20.8409965622634; 3725,20.8390773202055; 3730,20.8373291649469; 3735,20.8357581309427; 3740,20.8343702526482; 3745,20.8331715645187; 3750,20.8321681010094; 3755,20.8313658965756; 3760,20.8305279086473; 3765,20.8299775290776; 3770,20.8297163970333; 3775,20.8304666017798; 3780,20.832944156956; 3785,20.8362318619256; 3790,20.8403580934567; 3795,20.845351228317; 3800,20.8512396432746; 3805,20.8580517150973; 3810,20.8641752572719; 3815,20.8638637713734; 3820,20.8623167886254; 3825,20.8594452540718; 3830,20.8551601127565; 3835,20.8555697360465; 3840,20.8559877103843; 3845,20.8568071030613; 3850,20.8575045981306; 3855,20.8580829871723; 3860,20.8585450617668; 3865,20.8588936134944; 3870,20.8591314339351; 3875,20.8592613146695; 3880,20.8592860472776; 3885,20.8592084233397; 3890,20.8590312344362; 3895,20.8587572721472; 3900,20.858389328053; 3905,
        20.8579301937339; 3910,20.8571125751867; 3915,20.8562918833225; 3920,20.8554660260676; 3925,20.8546329113488; 3930,20.8537904470927; 3935,20.8529944570607; 3940,20.8524650327622; 3945,20.8502811891397; 3950,20.8476903427848; 3955,20.8459686728341; 3960,20.8450696330714; 3965,20.8449466772806; 3970,20.8455532592457; 3975,20.846901658508; 3980,20.8499085323991; 3985,20.8531709664369; 3990,20.8566622536441; 3995,20.8603556870433; 4000,20.8642245596571; 4005,20.8682421645079; 4010,20.8723817946184; 4015,20.8766167430113; 4020,20.8808256027791; 4025,20.8846183678633; 4030,20.8882890611077; 4035,20.8918037886664; 4040,20.8951286566933; 4045,20.8982297713424; 4050,20.9010732387679; 4055,20.9036251651236; 4060,20.9058516565635; 4065,20.9065606313187; 4070,20.9069759688639; 4075,20.9073728677959; 4080,20.9076920505518; 4085,20.9079385904967; 4090,20.9083000807152; 4095,20.9086308662973; 4100,20.9087047823332; 4105,20.9084698138817; 4110,20.9078739460016; 4115,20.9068651637518; 4120,
        20.9053914521911; 4125,20.9061892782177; 4130,20.9083547957295; 4135,20.9112760814525; 4140,20.9142531314089; 4145,20.9172998970528; 4150,20.9204303298384; 4155,20.9233313397364; 4160,20.9251275883204; 4165,20.9266694847769; 4170,20.930591975212; 4175,20.933989245123; 4180,20.9361921867403; 4185,20.9372522315456; 4190,20.9372208110204; 4195,20.9361493566462; 4200,20.9340892999046; 4205,20.9310920722772; 4210,20.9272091052456; 4215,20.9224918302912; 4220,20.9169916788956; 4225,20.9107600825404; 4230,20.9038484727072; 4235,20.8962721298641; 4240,20.8881086136473; 4245,20.8812942768666; 4250,20.8735205822837; 4255,20.8648634495939; 4260,20.8570471971288; 4265,20.8501071209714; 4270,20.8440471700204; 4275,20.8387823825781; 4280,20.8344542214057; 4285,20.8310956036183; 4290,20.8287394463312; 4295,20.8274186666597; 4300,20.827166181719; 4305,20.8289954149036; 4310,20.8322251983158; 4315,20.8352227491153; 4320,20.8339396601291; 4325,20.8343323732121; 4330,20.8363754675771; 4335,
        20.8400435224365; 4340,20.8453111170028; 4345,20.8521180852353; 4350,20.8563027409566; 4355,20.8609268125248; 4360,20.8659075598863; 4365,20.8718441102144; 4370,20.8781609037359; 4375,20.8842709963734; 4380,20.890110982829; 4385,20.895617457805; 4390,20.9007270160035; 4395,20.9053762521269; 4400,20.9095017608772; 4405,20.9130401369566; 4410,20.9159279750674; 4415,20.9181603849722; 4420,20.9196473887422; 4425,20.9203138327999; 4430,20.9217863591794; 4435,20.9240432112789; 4440,20.9260819966366; 4445,20.9276944467228; 4450,20.9289933832459; 4455,20.9300947397126; 4460,20.9309713449566; 4465,20.9315960278118; 4470,20.9319416171118; 4475,20.9319809416903; 4480,20.931686830381; 4485,20.9293430897695; 4490,20.9248819250773; 4495,20.9219710199416; 4500,20.9245540784194; 4505,20.9262497737989; 4510,20.9229995955269; 4515,20.9195787932584; 4520,20.9169164378803; 4525,20.9150065303962; 4530,20.9167354047232; 4535,20.9203001109232; 4540,20.9231732347047; 4545,20.9243323709721; 4550,
        20.9256999874406; 4555,20.9261237641328; 4560,20.925308042603; 4565,20.9233441407282; 4570,20.920323376385; 4575,20.9163370674505; 4580,20.9114765318014; 4585,20.9058330873146; 4590,20.899498051867; 4595,20.8925627433355; 4600,20.8851184795968; 4605,20.8772565785279; 4610,20.8690683580056; 4615,20.8606451359068; 4620,20.8520782301083; 4625,20.8432653279093; 4630,20.8345187363096; 4635,20.8262354612868; 4640,20.8184980607647; 4645,20.8044014822548; 4650,20.7930436383771; 4655,20.7845203043305; 4660,20.7787858107; 4665,20.7761937880518; 4670,20.7769996774941; 4675,20.7771838379561; 4680,20.7768424040297; 4685,20.7777026175168; 4690,20.7855250718443; 4695,20.795799073849; 4700,20.8084685440902; 4705,20.8235297819511; 4710,20.8362479528353; 4715,20.8484424255156; 4720,20.8613013868129; 4725,20.874733852486; 4730,20.8864989828883; 4735,20.8981005938981; 4740,20.9094183332698; 4745,20.9203318487576; 4750,20.9320896488763; 4755,20.9445712004754; 4760,20.9553546815115; 4765,
        20.9643762724627; 4770,20.971572153807; 4775,20.9768785060225; 4780,20.9802315095874; 4785,20.9815673449798; 4790,20.9808221926777; 4795,20.9779322331593; 4800,20.9728336469027; 4805,20.9662643443169; 4810,20.9577964274128; 4815,20.9472051104579; 4820,20.9359888002499; 4825,20.9308228375339; 4830,20.9258311463074; 4835,20.9210921793238; 4840,20.9166843893367; 4845,20.9119356134492; 4850,20.9066172409276; 4855,20.9014402002155; 4860,20.8964610240365; 4865,20.8917362451145; 4870,20.8873223961733; 4875,20.8819166189063; 4880,20.8773156849288; 4885,20.8735963922772; 4890,20.8707900898173; 4895,20.8689281264154; 4900,20.8684962980102; 4905,20.8702717448212; 4910,20.8725484583889; 4915,20.8753900051878; 4920,20.8788599516923; 4925,20.883021864377; 4930,20.8855813071947; 4935,20.8865451329914; 4940,20.8872892362782; 4945,20.8878206508058; 4950,20.888146410325; 4955,20.8882735485863; 4960,20.8876156241543; 4965,20.8869545022992; 4970,20.8862864856276; 4975,20.8856078767464; 4980,
        20.8849149782622; 4985,20.8842040927819; 4990,20.8834715229122; 4995,20.8827135712598; 5000,20.8819265404314; 5005,20.8811067330339; 5010,20.8802504516739; 5015,20.8793539989582; 5020,20.8784136774936; 5025,20.8774257898868; 5030,20.8763866387446; 5035,20.8752925266737; 5040,20.8741397562808; 5045,20.8729246301727; 5050,20.8719298444421; 5055,20.8725028921464; 5060,20.8734828138016; 5065,20.8748910958723; 5070,20.8767492248227; 5075,20.8790786871175; 5080,20.8809608031475; 5085,20.8816818930979; 5090,20.8823160607822; 5095,20.881506114181; 5100,20.880552361534; 5105,20.8800001161378; 5110,20.87980645664; 5115,20.8799284616881; 5120,20.8803232099299; 5125,20.880947780013; 5130,20.8817592505849; 5135,20.8828561024313; 5140,20.8847378778202; 5145,20.8868827544908; 5150,20.8892585422347; 5155,20.8918330508436; 5160,20.894574090109; 5165,20.8974494698227; 5170,20.9062441797302; 5175,20.9133312143945; 5180,20.9187835691265; 5185,20.922674239237; 5190,20.9250762200368; 5195,
        20.9260625068368; 5200,20.9257060949476; 5205,20.9240799796802; 5210,20.9212571563454; 5215,20.917310620254; 5220,20.9123133667167; 5225,20.905624181166; 5230,20.8978322542927; 5235,20.8895387010776; 5240,20.8807962649804; 5245,20.8716576894609; 5250,20.8621757179789; 5255,20.8524030939944; 5260,20.8399774913834; 5265,20.8266971457911; 5270,20.8144006143292; 5275,20.8052383384184; 5280,20.7977815108343; 5285,20.7918995100578; 5290,20.7876087890053; 5295,20.7849258005933; 5300,20.7838669977383; 5305,20.7844488333566; 5310,20.7866877603647; 5315,20.790600231679; 5320,20.796202700216; 5325,20.8035116188922; 5330,20.8125434406239; 5335,20.8233146183277; 5340,20.83584160492; 5345,20.8487548447677; 5350,20.8567536207173; 5355,20.8647008029887; 5360,20.872507638854; 5365,20.879829363347; 5370,20.8865835329792; 5375,20.8926877042623; 5380,20.898059433708; 5385,20.9026162778279; 5390,20.9062757931336; 5395,20.9089555361369; 5400,20.9105730633494; 5405,20.9122019717444; 5410,
        20.9131762765841; 5415,20.9130548990484; 5420,20.9120392336191; 5425,20.9100623887468; 5430,20.9070574728817; 5435,20.9029575944743; 5440,20.9016332830528; 5445,20.9012427312163; 5450,20.9009058962862; 5455,20.9005998333709; 5460,20.9003276644627; 5465,20.9000940379309; 5470,20.899926658661; 5475,20.8998281994615; 5480,20.8997918652122; 5485,20.899811520137; 5490,20.8998816194483; 5495,20.8999883995503; 5500,20.9001061082598; 5505,20.9002396749825; 5510,20.9004044767818; 5515,20.900628538653; 5520,20.9009097771759; 5525,20.9012451260298; 5530,20.9016321135766; 5535,20.9018065434589; 5540,20.9017608839776; 5545,20.9016405003425; 5550,20.9014178575624; 5555,20.9010807775599; 5560,20.9006342068477; 5565,20.9000830919384; 5570,20.8994323793445; 5575,20.8987014370705; 5580,20.8979105932697; 5585,20.8970401557933; 5590,20.896197518365; 5595,20.8952887710554; 5600,20.8943213544677; 5605,20.8934722077228; 5610,20.892745837321; 5615,20.8921467497625; 5620,20.8916311085569; 5625,
        20.8911941204526; 5630,20.8908540974025; 5635,20.891783679761; 5640,20.8964817854882; 5645,20.899747028173; 5650,20.9015761056712; 5655,20.9019813357876; 5660,20.9011540380567; 5665,20.8992861471538; 5670,20.8964544703074; 5675,20.8927522750403; 5680,20.8882876932411; 5685,20.883108766919; 5690,20.8771913218889; 5695,20.8706276092408; 5700,20.8627183675701; 5705,20.8547937059411; 5710,20.8469039612677; 5715,20.8390988169543; 5720,20.8314272947014; 5725,20.8239395016441; 5730,20.8167155363448; 5735,20.8098229830376; 5740,20.8033205567786; 5745,20.797266972624; 5750,20.7917209456298; 5755,20.7867151475528; 5760,20.7822824266213; 5765,20.7784956513657; 5770,20.7754267301678; 5775,20.7728087639305; 5780,20.7712812083376; 5785,20.7710121499912; 5790,20.7720503674046; 5795,20.7744446390911; 5800,20.778243743564; 5805,20.7834964593364; 5810,20.7902515649216; 5815,20.796047506172; 5820,20.7984773159002; 5825,20.8007665705294; 5830,20.8029858302485; 5835,20.805204413914; 5840,
        20.8073165212813; 5845,20.8092202120386; 5850,20.8108769488397; 5855,20.8122481943381; 5860,20.8132954111874; 5865,20.8140550514184; 5870,20.8143147652019; 5875,20.8116241175266; 5880,20.8107112656115; 5885,20.8107103662327; 5890,20.8170668253168; 5895,20.8237075481896; 5900,20.8290824354412; 5905,20.8332360588732; 5910,20.8308987221688; 5915,20.8290532188718; 5920,20.8276480288535; 5925,20.8266316319851; 5930,20.8259525081379; 5935,20.8255591371831; 5940,20.8253999989921; 5945,20.8254235734361; 5950,20.8255783403864; 5955,20.8269164374423; 5960,20.828567631983; 5965,20.8304954803474; 5970,20.8326635388743; 5975,20.8350353639023; 5980,20.8375745117704; 5985,20.8402445388172; 5990,20.8430090013816; 5995,20.8458314558023; 6000,20.8483634549555; 6005,20.8498944506264; 6010,20.8517922551079; 6015,20.8539953859402; 6020,20.8564423606634; 6025,20.8590716968176; 6030,20.8618219119429; 6035,20.8646315235794; 6040,20.8674390492672; 6045,20.8701830065463; 6050,20.8739635320403; 6055,
        20.8812106767137; 6060,20.8893871049305; 6065,20.8984927070906; 6070,20.8996681428716; 6075,20.8994852340588; 6080,20.897822849923; 6085,20.8958260438838; 6090,20.8984235722567; 6095,20.9012059650895; 6100,20.9038246983061; 6105,20.9062626791187; 6110,20.9085028147392; 6115,20.9105280123798; 6120,20.9123211792526; 6125,20.9138652225697; 6130,20.9161984279726; 6135,20.9181575787971; 6140,20.9194439271886; 6145,20.9200635108259; 6150,20.9200223673878; 6155,20.9193265345531; 6160,20.9179820500005; 6165,20.9159949514089; 6170,20.913371276457; 6175,20.9101170628235; 6180,20.9069163387626; 6185,20.9044383896835; 6190,20.9018312637737; 6195,20.8991260375109; 6200,20.8963537873724; 6205,20.8935455898358; 6210,20.8907325213784; 6215,20.8879456584777; 6220,20.8852160776112; 6225,20.8825748552564; 6230,20.8800530678908; 6235,20.8776817919917; 6240,20.8754921040367; 6245,20.8735150805032; 6250,20.8717817978687; 6255,20.8703233326106; 6260,20.8691707612065; 6265,20.8683551601337; 6270,
        20.8675761745816; 6275,20.8673829182021; 6280,20.8676107501238; 6285,20.8678938458251; 6290,20.8682702510636; 6295,20.8687780115969; 6300,20.8694551731824; 6305,20.8703397815776; 6310,20.8697766398571; 6315,20.8690598706411; 6320,20.8682043892203; 6325,20.8672251108858; 6330,20.8661369509281; 6335,20.8649548246383; 6340,20.863693647307; 6345,20.8623683342252; 6350,20.8609938006837; 6355,20.8595849619733; 6360,20.8581567333847; 6365,20.8555317100609; 6370,20.8510454455485; 6375,20.8476047023066; 6380,20.8451628648131; 6385,20.843673317546; 6390,20.8430894449832; 6395,20.8433646316025; 6400,20.8440951677706; 6405,20.8452344851578; 6410,20.8473363516677; 6415,20.850339404111; 6420,20.8541822792987; 6425,20.8588036140415; 6430,20.8641420451504; 6435,20.8701362094361; 6440,20.8767247437096; 6445,20.8850943318268; 6450,20.8943812197568; 6455,20.9026199038998; 6460,20.9101728349932; 6465,20.9171867648046; 6470,20.9236225886456; 6475,20.929441201828; 6480,20.9346034996633; 6485,
        20.9390703774631; 6490,20.9428027305391; 6495,20.945761454203; 6500,20.9479074437664; 6505,20.9492015945409; 6510,20.9496048018382; 6515,20.94907796097; 6520,20.9475819672478; 6525,20.9450777159832; 6530,20.9415261024881; 6535,20.9368880220739; 6540,20.9311243700524; 6545,20.9264132528547; 6550,20.9256464655258; 6555,20.9243607166149; 6560,20.9200963667005; 6565,20.9129209043539; 6570,20.9066624161645; 6575,20.9012957134394; 6580,20.8974107385781; 6585,20.8951119678683; 6590,20.8939071190822; 6595,20.8937550951271; 6600,20.894647972557; 6605,20.8965778279258; 6610,20.8995367377874; 6615,20.9035167786959; 6620,20.9085100272052; 6625,20.9124740993359; 6630,20.9162113811435; 6635,20.9202069153933; 6640,20.9254900093162; 6645,20.9320154236842; 6650,20.9379316617291; 6655,20.9432379981557; 6660,20.9479337076691; 6665,20.9520180649741; 6670,20.9554903447755; 6675,20.9583498217783; 6680,20.959201150345; 6685,20.9595581402782; 6690,20.95979225684; 6695,20.961562606219; 6700,
        20.9626309427913; 6705,20.9619186044424; 6710,20.9602039450006; 6715,20.9582833152889; 6720,20.9561254244645; 6725,20.9533990383998; 6730,20.9473114190924; 6735,20.9400420205471; 6740,20.9353680603787; 6745,20.9339198675042; 6750,20.9326756248723; 6755,20.9316627534732; 6760,20.930908674297; 6765,20.9302565114159; 6770,20.9298704004782; 6775,20.9321733172288; 6780,20.9371898481557; 6785,20.9409130102922; 6790,20.9434667452889; 6795,20.9406790652082; 6800,20.9376925219513; 6805,20.9353190867617; 6810,20.9335947181587; 6815,20.9325553746618; 6820,20.9303862433171; 6825,20.9270787687113; 6830,20.9236989418897; 6835,20.9202383494291; 6840,20.9166885779062; 6845,20.913041213898; 6850,20.9092878439813; 6855,20.9054200547328; 6860,20.9036669530583; 6865,20.9005673788456; 6870,20.8976878049806; 6875,20.8939837687985; 6880,20.8908021823419; 6885,20.8898401165637; 6890,20.8911929612841; 6895,20.8944625789541; 6900,20.8980590847088; 6905,20.9020039682363; 6910,20.9063187192246; 6915,
        20.9110248273615; 6920,20.9159975591871; 6925,20.9206974458394; 6930,20.9256412057167; 6935,20.9308392314919; 6940,20.9363019158381; 6945,20.9420396514281; 6950,20.9480628309349; 6955,20.9502509224142; 6960,20.9485149633763; 6965,20.9451643805885; 6970,20.9404938518821; 6975,20.9397467793674; 6980,20.9373666695287; 6985,20.9353766698147; 6990,20.9337400319402; 6995,20.93242000762; 7000,20.931379848569; 7005,20.930582806502; 7010,20.93027196244; 7015,20.9302083213923; 7020,20.9301482164; 7025,20.9300628339063; 7030,20.9299233603545; 7035,20.9297009821878; 7040,20.9293668858495; 7045,20.931768799948; 7050,20.9347440419338; 7055,20.9383030931272; 7060,20.9424564348481; 7065,20.9472145484168; 7070,20.9509765406005; 7075,20.9537141366548; 7080,20.9563346159242; 7085,20.9588577274015; 7090,20.9613588113958; 7095,20.9635941293742; 7100,20.9655393742801; 7105,20.967170239057; 7110,20.9684624166485; 7115,20.969391599998; 7120,20.969933482049; 7125,20.9700637557449; 7130,
        20.9697581140294; 7135,20.9689922498458; 7140,20.9677418561377; 7145,20.9659826258485; 7150,20.9636902519217; 7155,20.9642096217862; 7160,20.9693428658728; 7165,20.9726696970704; 7170,20.9743164811272; 7175,20.9744095837909; 7180,20.9723701176293; 7185,20.9692452154347; 7190,20.9646955509666; 7195,20.9590404248769; 7200,20.9524843889494; 7205,20.945133121904; 7210,20.9370923024606; 7215,20.9284676093389; 7220,20.919364721259; 7225,20.9098893169406; 7230,20.9001470751036; 7235,20.890243674468; 7240,20.8802847937535; 7245,20.8687593122565; 7250,20.8561835386925; 7255,20.84484654692; 7260,20.8347945946489; 7265,20.8259698515607; 7270,20.8183167507215; 7275,20.8120132720772; 7280,20.8071018292737; 7285,20.8036248359567; 7290,20.801624705772; 7295,20.8011438523654; 7300,20.8022246893826; 7305,20.8049096304696; 7310,20.8092410892719; 7315,20.8160518586; 7320,20.8243524459592; 7325,20.8341995565322; 7330,20.845649895502; 7335,20.8546760900462; 7340,20.8618238679239; 7345,
        20.8679233510026; 7350,20.8729520228988; 7355,20.8770554017313; 7360,20.8808556049649; 7365,20.8797463841086; 7370,20.8782424423255; 7375,20.8771917820974; 7380,20.8764995267663; 7385,20.8760707996739; 7390,20.8758107241622; 7395,20.8758496645664; 7400,20.8765793926074; 7405,20.8768912736273; 7410,20.8767085069337; 7415,20.875954291834; 7420,20.8745518276358; 7425,20.875150363226; 7430,20.8772990783453; 7435,20.8803847698101; 7440,20.8843899715473; 7445,20.8881982413197; 7450,20.8918191965402; 7455,20.895262454622; 7460,20.898537632978; 7465,20.9016543490214; 7470,20.9046222201652; 7475,20.9074508638223; 7480,20.910149897406; 7485,20.9127289383292; 7490,20.9150092872796; 7495,20.9162781187565; 7500,20.9171828414545; 7505,20.9177187812498; 7510,20.9178812640182; 7515,20.9168964529611; 7520,20.913496694437; 7525,20.9090296158174; 7530,20.9034551775893; 7535,20.8967333402396; 7540,20.8890026964841; 7545,20.8861358573311; 7550,20.883578625632; 7555,20.881424796299; 7560,
        20.8797185736511; 7565,20.8765630628751; 7570,20.8741104704995; 7575,20.8739339035446; 7580,20.8744718536064; 7585,20.8752359721175; 7590,20.8738996121917; 7595,20.8735606471441; 7600,20.8742026627406; 7605,20.8758092447471; 7610,20.8783639789297; 7615,20.8807243914039; 7620,20.8828469844494; 7625,20.8850827503533; 7630,20.8873883120533; 7635,20.8901562087643; 7640,20.8933323205774; 7645,20.896862527584; 7650,20.9006927098753; 7655,20.9094454000567; 7660,20.9171383126793; 7665,20.9235714383194; 7670,20.9287783210697; 7675,20.9327925050226; 7680,20.9356475342709; 7685,20.9373769529071; 7690,20.9380143050236; 7695,20.9375931347132; 7700,20.9361469860685; 7705,20.9336443714978; 7710,20.9298437127375; 7715,20.925064038625; 7720,20.9194543641425; 7725,20.9132112861055; 7730,20.9063783552018; 7735,20.8988548167665; 7740,20.8905648717881; 7745,20.8847371069727; 7750,20.8792985621431; 7755,20.8719627190531; 7760,20.8638881038687; 7765,20.8560721167804; 7770,20.8505241654848; 7775,
        20.8453627559201; 7780,20.8407076144892; 7785,20.8361219659738; 7790,20.8326555680384; 7795,20.83034048195; 7800,20.8292087689757; 7805,20.8297391495059; 7810,20.8319744276542; 7815,20.8356980800129; 7820,20.840952876428; 7825,20.847781586746; 7830,20.8553054033168; 7835,20.8587341196444; 7840,20.8621942219087; 7845,20.8656408159547; 7850,20.8690290076273; 7855,20.8723139027715; 7860,20.8754506072323; 7865,20.8783942268545; 7870,20.8810998674833; 7875,20.8835226349635; 7880,20.8856176351401; 7885,20.8874915470973; 7890,20.8894423736461; 7895,20.8913210262547; 7900,20.8921597438672; 7905,20.8899429532975; 7910,20.8885849645109; 7915,20.8881487813024; 7920,20.8886957674968; 7925,20.891611916177; 7930,20.8955818413013; 7935,20.8993133575905; 7940,20.9027541936444; 7945,20.9059383066217; 7950,20.9090375412169; 7955,20.9121007110568; 7960,20.9153052624129; 7965,20.9191025890166; 7970,20.9228413325679; 7975,20.9264929889692; 7980,20.9300290541231; 7985,20.933421023932; 7990,
        20.9366403942985; 7995,20.939658661125; 8000,20.9424473203141; 8005,20.9449778677682; 8010,20.9472217993899; 8015,20.9491506110816; 8020,20.9507357987458; 8025,20.9519488582851; 8030,20.9533379851174; 8035,20.9553496905348; 8040,20.9563659232673; 8045,20.956390561226; 8050,20.9554274823221; 8055,20.9534805644666; 8060,20.9505536855708; 8065,20.9466507235457; 8070,20.9417755563026; 8075,20.9359320617525; 8080,20.9310293869763; 8085,20.9289352491466; 8090,20.9272424293461; 8095,20.9260251687816; 8100,20.9253577086596; 8105,20.9229248332167; 8110,20.9198858745333; 8115,20.916794813712; 8120,20.9136840327617; 8125,20.9105859136909; 8130,20.9075328385083; 8135,20.9045571892225; 8140,20.9016913478422; 8145,20.898967696376; 8150,20.8964186168326; 8155,20.8940764912206; 8160,20.8919737015487; 8165,20.8884009058842; 8170,20.8846041390601; 8175,20.8819625795623; 8180,20.8804584125315; 8185,20.8800738231082; 8190,20.8807909964329; 8195,20.8825921176461; 8200,20.8858256616894; 8205,
        20.8911301190151; 8210,20.8959229019991; 8215,20.8997309608621; 8220,20.9035101773178; 8225,20.9072373145227; 8230,20.9108891356337; 8235,20.9144424038075; 8240,20.9178738822007; 8245,20.92116033397; 8250,20.9242785222721; 8255,20.9272052102639; 8260,20.9299171611018; 8265,20.9323911379428; 8270,20.9346039039434; 8275,20.9365322222603; 8280,20.9381528560504; 8285,20.9394425684702; 8290,20.9403781226764; 8295,20.9409362818259; 8300,20.9410938090752; 8305,20.9408274675811; 8310,20.9401140205004; 8315,20.9389302309896; 8320,20.9372528622055; 8325,20.9350586773048; 8330,20.9323244394442; 8335,20.9290269117804; 8340,20.9251428574701; 8345,20.9234747441852; 8350,20.9227676350489; 8355,20.922392650628; 8360,20.9223767509473; 8365,20.9227468960317; 8370,20.9235300459059; 8375,20.9247531605947; 8380,20.9256754047256; 8385,20.9256754047256; 8390,20.9256754047256; 8395,20.9256754047256; 8400,20.9256754047256; 8405,20.9256754047256; 8410,20.9256754047256; 8415,20.9256754047256; 8420,
        20.9256754047256; 8425,20.9256754047256; 8430,20.9256754047256; 8435,20.9256754047256; 8440,20.9256754047256; 8445,20.9341841652862; 8450,20.9450519774443; 8455,20.9519870718559; 8460,20.9552307195482; 8465,20.9550241915488; 8470,20.9516087588849; 8475,20.9512307852786; 8480,20.9532012734616; 8485,20.9488765865816; 8490,20.9387293519094; 8495,20.9232321967158; 8500,20.9028577482714; 8505,20.8780786338471; 8510,20.8493674807136; 8515,20.8171556352605; 8520,20.7818847935856; 8525,20.7441267093115; 8530,20.7043613068489; 8535,20.6629885914982; 8540,20.6204799988819; 8545,20.5773339436406; 8550,20.5341078126364; 8555,20.4913149913809; 8560,20.4494200305807; 8565,20.4088874809428; 8570,20.3701818931741; 8575,20.334687771745; 8580,20.3018706124792; 8585,20.271949452596; 8590,20.2454090052005; 8595,20.2227339833972; 8600,20.2044091002911; 8605,20.1909190689869; 8610,20.1827486025895; 8615,20.1803824142036; 8620,20.184305216934; 8625,20.1812292015744; 8630,20.1778934053103; 8635,
        20.1775477002371; 8640,20.1804355284323; 8645,20.1868003319733; 8650,20.199190724033; 8655,20.2073330337654; 8660,20.2087425920814; 8665,20.2086946241161; 8670,20.2039140357404; 8675,20.1949359482151; 8680,20.1869766875547; 8685,20.1800063973893; 8690,20.1739952213488; 8695,20.1689878350238; 8700,20.1649993549451; 8705,20.1619322365021; 8710,20.1597688469725; 8715,20.1585833651735; 8720,20.158394452208; 8725,20.1592050289649; 8730,20.1609321130534; 8735,20.1653471585375; 8740,20.172388385175; 8745,20.1790283844451; 8750,20.1838613501884; 8755,20.1870477415671; 8760,20.1905225781421; 8765,20.1961523969417; 8770,20.2008322729729; 8775,20.2046128358631; 8780,20.20754471524; 8785,20.2096785407309; 8790,20.2110649419635; 8795,20.2117545485653; 8800,20.2117979901638; 8805,20.2098918399204; 8810,20.2077780210985; 8815,20.2055819999891; 8820,20.2033285857142; 8825,20.2010425873957; 8830,20.1947605120191; 8835,20.1848452145645; 8840,20.173217316146; 8845,20.1598117980871; 8850,
        20.150348843131; 8855,20.1443868981654; 8860,20.1390253853651; 8865,20.1343310560561; 8870,20.1303706615642; 8875,20.1272109532153; 8880,20.1249186823352; 8885,20.1235606002498; 8890,20.1222439678724; 8895,20.1210356633324; 8900,20.1216156321314; 8905,20.1240109995002; 8910,20.12824889067; 8915,20.131229597414; 8920,20.1329476256806; 8925,20.135138630649; 8930,20.1400952219863; 8935,20.1460343748693; 8940,20.1518357117434; 8945,20.1557181658431; 8950,20.1595731097415; 8955,20.1633350968377; 8960,20.1669386805314; 8965,20.1703184142219; 8970,20.1734088513087; 8975,20.1756229146018; 8980,20.1771348009071; 8985,20.1802343697751; 8990,20.1836084140832; 8995,20.1871957648602; 9000,20.1921759901685; 9005,20.1971405007193; 9010,20.2016970047306; 9015,20.2058115261563; 9020,20.2094500889502; 9025,20.2125787170662; 9030,20.2151634344583; 9035,20.2171702650804; 9040,20.2185652328862; 9045,20.2193143618298; 9050,20.2194171367518; 9055,20.2188032436251; 9060,20.2174297764995; 9065,
        20.2152634926827; 9070,20.2139239697534; 9075,20.2134177179177; 9080,20.212791630166; 9085,20.2120520899008; 9090,20.2112054805251; 9095,20.2102581854416; 9100,20.209216588053; 9105,20.2080870717622; 9110,20.206876019972; 9115,20.205589816085; 9120,20.2042348435042; 9125,20.2028174856322; 9130,20.2013441258719; 9135,20.1914854401473; 9140,20.1792724466634; 9145,20.1708753347498; 9150,20.1660641238063; 9155,20.1622881867006; 9160,20.1630392467763; 9165,20.1681815410919; 9170,20.1774396412502; 9175,20.1905381188539; 9180,20.2052109146142; 9185,20.2158050831103; 9190,20.2309667368273; 9195,20.2502693176275; 9200,20.2732862673734; 9205,20.2995910279272; 9210,20.3287570411513; 9215,20.360357748908; 9220,20.3939665930597; 9225,20.4291570154688; 9230,20.4654487735559; 9235,20.5024551332358; 9240,20.5397488030166; 9245,20.5769024914069; 9250,20.6134889069151; 9255,20.6490807580496; 9260,20.6832507533188; 9265,20.7155716012311; 9270,20.7456160102949; 9275,20.7729566890186; 9280,
        20.7971663459107; 9285,20.8178176894796; 9290,20.8344834282336; 9295,20.8467362706812; 9300,20.8541489253308; 9305,20.8562941006908; 9310,20.8527445052696; 9315,20.856565261237; 9320,20.8612019548676; 9325,20.8635183741032; 9330,20.8635450181134; 9335,20.8656142671806; 9340,20.8660599439682; 9345,20.8647581116609; 9350,20.8615848334436; 9355,20.8564161725009; 9360,20.8504347585188; 9365,20.8471658067174; 9370,20.8445782799898; 9375,20.8430525939949; 9380,20.8425220634892; 9385,20.8429200032293; 9390,20.8441797279717; 9395,20.8462345524731; 9400,20.84901779149; 9405,20.8524627597789; 9410,20.8565027720965; 9415,20.8610711431993; 9420,20.8661011878438; 9425,20.8715262207867; 9430,20.8772795567845; 9435,20.8832945105938; 9440,20.8890820651248; 9445,20.8951269247015; 9450,20.9013547675288; 9455,20.9088018354891; 9460,20.9165911465937; 9465,20.9238271771286; 9470,20.9297045927494; 9475,20.9341806631327; 9480,20.9384945562419; 9485,20.9425719502819; 9490,20.9463385234578; 9495,
        20.9497199539746; 9500,20.9526419200373; 9505,20.955030099851; 9510,20.9567820934165; 9515,20.957860237384; 9520,20.9581897022521; 9525,20.9576956585191; 9530,20.9563032766836; 9535,20.9539377272441; 9540,20.9513200359509; 9545,20.9532589043266; 9550,20.9556533171266; 9555,20.9574788202145; 9560,20.9587662418558; 9565,20.9595464103158; 9570,20.95985015386; 9575,20.9597083007535; 9580,20.9591516792619; 9585,20.9582111176505; 9590,20.9569174441846; 9595,20.9553014871296; 9600,20.9533940747509; 9605,20.9512260353139; 9610,20.9488281970838; 9615,20.9463320136384; 9620,20.9441543439779; 9625,20.9419852184549; 9630,20.9398631018864; 9635,20.936028869074; 9640,20.9313372993968; 9645,20.926187766304; 9650,20.9219007336692; 9655,20.9185147670795; 9660,20.9151926117052; 9665,20.9119727473258; 9670,20.9090839898309; 9675,20.9065601283017; 9680,20.9044349518195; 9685,20.9027489394132; 9690,20.9015615449343; 9695,20.9008838999413; 9700,20.9007503012218; 9705,20.9011950455635; 9710,
        20.9022524297543; 9715,20.9039567505817; 9720,20.9063423048336; 9725,20.9072187129457; 9730,20.9076305330482; 9735,20.9080587182258; 9740,20.9084985927429; 9745,20.9089454808635; 9750,20.9093947068521; 9755,20.9098415949728; 9760,20.9102814694898; 9765,20.9107096546674; 9770,20.9107653469682; 9775,20.9096744324881; 9780,20.9090350849654; 9785,20.9088140488139; 9790,20.9089780684473; 9795,20.9094938882792; 9800,20.9103282527233; 9805,20.9114479061934; 9810,20.9128195931032; 9815,20.9144100578663; 9820,20.9161860448965; 9825,20.9181142986074; 9830,20.9201615634127; 9835,20.9222945837262; 9840,20.9246751307702; 9845,20.9272746396565; 9850,20.9299513141393; 9855,20.932676574368; 9860,20.9354218404922; 9865,20.9381585326611; 9870,20.9413265883579; 9875,20.9474054125564; 9880,20.9523049468912; 9885,20.9560612562581; 9890,20.9587104055533; 9895,20.9602884596726; 9900,20.9608314835122; 9905,20.9603755419679; 9910,20.9589566999359; 9915,20.956611022312; 9920,20.9533745739923; 9925,
        20.9492834198728; 9930,20.9424627024938; 9935,20.9354433557982; 9940,20.9282268916234; 9945,20.9208148218066; 9950,20.9139825319465; 9955,20.9084885798254; 9960,20.9033551486901; 9965,20.8986123302283; 9970,20.894290216128; 9975,20.8904188980771; 9980,20.8870284677635; 9985,20.8841490168749; 9990,20.8818106370995; 9995,20.8800434201249; 10000,20.8788774576392; 10005,20.8783428413302; 10010,20.8784696628859; 10015,20.879288013994; 10020,20.8808279863425; 10025,20.8831196716193; 10030,20.8861931615123; 10035,20.8900785477094; 10040,20.8948059218984; 10045,20.9004053757673; 10050,20.9120737952969; 10055,20.9227316200558; 10060,20.9300918849124; 10065,20.9343051845004; 10070,20.9355221134535; 10075,20.9338932664057; 10080,20.9295692379905; 10085,20.9321573680637; 10090,20.9315383791554; 10095,20.9253390885208; 10100,20.9139173519276; 10105,20.8980863238872; 10110,20.8799505311035; 10115,20.8583258230855; 10120,20.8336046086597; 10125,20.8061792966527; 10130,20.7764422958913; 10135,
        20.7447860152018; 10140,20.7116028634111; 10145,20.6798319180906; 10150,20.6470759487199; 10155,20.6130788604151; 10160,20.5782884576249; 10165,20.5431525447983; 10170,20.508118926384; 10175,20.4736354068308; 10180,20.4401497905877; 10185,20.4081098821034; 10190,20.3779634858268; 10195,20.3501584062067; 10200,20.325142447692; 10205,20.3033634147314; 10210,20.2852691117739; 10215,20.2713073432682; 10220,20.2626746818057; 10225,20.2653202236023; 10230,20.2606643285543; 10235,20.2541168348947; 10240,20.2438227034559; 10245,20.2351062858086; 10250,20.2295724165687; 10255,20.2275145412699; 10260,20.2292261054454; 10265,20.2198282105617; 10270,20.2108694107833; 10275,20.2024358905094; 10280,20.1946138341394; 10285,20.1874894260726; 10290,20.1811488507082; 10295,20.1756782924455; 10300,20.171163935684; 10305,20.1676919648228; 10310,20.1653485642613; 10315,20.1642199183988; 10320,20.1643661739323; 10325,20.161863098239; 10330,20.1597859579772; 10335,20.158165541924; 10340,
        20.1570326388565; 10345,20.1564180375516; 10350,20.1559096967675; 10355,20.154581641116; 10360,20.1544577356239; 10365,20.1555332312199; 10370,20.1578033788328; 10375,20.1612634293917; 10380,20.1664258934265; 10385,20.1732859535067; 10390,20.1809691904057; 10395,20.1894922174108; 10400,20.1963192635801; 10405,20.1963255101439; 10410,20.1947204218488; 10415,20.1913903006287; 10420,20.1935068990877; 10425,20.1955520451803; 10430,20.1975115634167; 10435,20.1993712783071; 10440,20.2011170143617; 10445,20.2027345960906; 10450,20.204209848004; 10455,20.2055285946121; 10460,20.2066766604251; 10465,20.2076398699531; 10470,20.2084040477063; 10475,20.2089550181948; 10480,20.209278605929; 10485,20.2093606354189; 10490,20.2091869311747; 10495,20.2087433177066; 10500,20.2071346090981; 10505,20.2049833803801; 10510,20.2029269157382; 10515,20.2009260581019; 10520,20.1989416504002; 10525,20.1969345355624; 10530,20.1958278361568; 10535,20.1965237500666; 10540,20.1975047775442; 10545,
        20.1989556398141; 10550,20.20106540883; 10555,20.2038230762238; 10560,20.206326601114; 10565,20.2085435444146; 10570,20.2109587950009; 10575,20.2135399821464; 10580,20.2157858100653; 10585,20.2176639700031; 10590,20.2199304963756; 10595,20.2225336522714; 10600,20.225421700779; 10605,20.2285429049872; 10610,20.2321864615977; 10615,20.2360542238395; 10620,20.239842352789; 10625,20.2435087789128; 10630,20.2467773506576; 10635,20.2496060294255; 10640,20.2523463085011; 10645,20.254946450973; 10650,20.2573547199298; 10655,20.2550119798801; 10660,20.253751279951; 10665,20.2534393810146; 10670,20.2539430439433; 10675,20.2530664365394; 10680,20.2501930112292; 10685,20.2505016137573; 10690,20.2534530868717; 10695,20.2551044261459; 10700,20.2589159968072; 10705,20.2635570008273; 10710,20.2714758510393; 10715,20.2830363200358; 10720,20.2955021080344; 10725,20.3113369767613; 10730,20.3308287853258; 10735,20.3535526349044; 10740,20.3790836266733; 10745,20.406996861809; 10750,
        20.4368674414878; 10755,20.4682704668861; 10760,20.5015888105074; 10765,20.5364170016849; 10770,20.5718805827205; 10775,20.6075740209757; 10780,20.6430917838119; 10785,20.6780283385905; 10790,20.7114263078114; 10795,20.7432880776978; 10800,20.775666709571; 10805,20.80481746854; 10810,20.8307773164156; 10815,20.8527372730839; 10820,20.8677571746427; 10825,20.8791696592588; 10830,20.8878103316076; 10835,20.8973790309218; 10840,20.9038184110749; 10845,20.9067898438721; 10850,20.9059547011186; 10855,20.9049254599993; 10860,20.9052910709126; 10865,20.9031524163424; 10870,20.898290477315; 10875,20.8964603518214; 10880,20.8934553496752; 10885,20.8932245353698; 10890,20.8926074178776; 10895,20.8909663872678; 10900,20.8927108344698; 10905,20.8944620232091; 10910,20.8962191588847; 10915,20.8979814468956; 10920,20.8997480926406; 10925,20.9015183015187; 10930,20.9032912789288; 10935,20.9050662302698; 10940,20.9068423609406; 10945,20.9086188763402; 10950,20.9103949818674; 10955,
        20.9121698829213; 10960,20.9139427849007; 10965,20.9157128932045; 10970,20.9174794132317; 10975,20.9184212908804; 10980,20.9163679950046; 10985,20.9130458238827; 10990,20.9087588474483; 10995,20.9047042925732; 11000,20.9034756788; 11005,20.9024236582665; 11010,20.9015548940169; 11015,20.9008760490957; 11020,20.900393786547; 11025,20.9001147694154; 11030,20.9016689321903; 11035,20.9038897180464; 11040,20.9055834683779; 11045,20.9068028750681; 11050,20.9076006300002; 11055,20.9080294250575; 11060,20.9081419521234; 11065,20.9074151672692; 11070,20.9058879150366; 11075,20.9039333086147; 11080,20.901590236715; 11085,20.8988975880492; 11090,20.8958942513288; 11095,20.8926191152656; 11100,20.8891110685709; 11105,20.8854089999565; 11110,20.881551798134; 11115,20.8775783518149; 11120,20.8735275497108; 11125,20.8694382805334; 11130,20.8653494329941; 11135,20.8612998958047; 11140,20.8573285576767; 11145,20.8534743073217; 11150,20.8456290020169; 11155,20.83858629664; 11160,20.832754086734;
        11165,20.8291466385133; 11170,20.8273210340517; 11175,20.8284983148919; 11180,20.8353723777965; 11185,20.8421833363203; 11190,20.8489849960773; 11195,20.8558311626818; 11200,20.8627756417479; 11205,20.8698722388898; 11210,20.8745472863033; 11215,20.8780477675769; 11220,20.880955015642; 11225,20.8832768072738; 11230,20.8850209192475; 11235,20.8861951283385; 11240,20.8868072113221; 11245,20.8868649449734; 11250,20.8863761060677; 11255,20.8853484713802; 11260,20.8837898176864; 11265,20.8817079217613; 11270,20.8791105603803; 11275,20.8760055103186; 11280,20.8698142353204; 11285,20.8637568717401; 11290,20.858007615453; 11295,20.851130109626; 11300,20.843562554256; 11305,20.8369822030455; 11310,20.8312982023067; 11315,20.8264196983515; 11320,20.822255837492; 11325,20.8193326429547; 11330,20.8224253684926; 11335,20.8297826719983; 11340,20.8395223089363; 11345,20.8508667367178; 11350,20.8638572230224; 11355,20.8757772919533; 11360,20.8839704345022; 11365,20.8919678120055; 11370,
        20.8997088462045; 11375,20.9071329588404; 11380,20.9141795716547; 11385,20.9207881063887; 11390,20.9268979847836; 11395,20.9324486285809; 11400,20.9373794595218; 11405,20.9416298993476; 11410,20.9449932878748; 11415,20.9475146275947; 11420,20.9492413599506; 11425,20.9501087644427; 11430,20.9500521205714; 11435,20.9490067078373; 11440,20.9469078057407; 11445,20.943690693782; 11450,20.9392906514616; 11455,20.9340809268723; 11460,20.9308772761973; 11465,20.927241270665; 11470,20.9231578241373; 11475,20.9209449714945; 11480,20.9201297630997; 11485,20.9197810453344; 11490,20.9199327281623; 11495,20.920618721547; 11500,20.9218729354521; 11505,20.9223842892907; 11510,20.923942690743; 11515,20.9237721562383; 11520,20.9239486627069; 11525,20.9244437479571; 11530,20.9252289497975; 11535,20.9262758060365; 11540,20.9275558544826; 11545,20.9290406329441; 11550,20.9307016792294; 11555,20.9325105311472; 11560,20.9344387265056; 11565,20.9364578031133; 11570,20.9394066333949; 11575,
        20.9433238598342; 11580,20.9466350543464; 11585,20.9493487866961; 11590,20.9517100790145; 11595,20.9536201242402; 11600,20.9550400187431; 11605,20.9559824745288; 11610,20.9564602036027; 11615,20.9564859179702; 11620,20.9560723296369; 11625,20.9552321506083; 11630,20.9539780928899; 11635,20.952322868487; 11640,20.9502791894053; 11645,20.9478597676501; 11650,20.9450773152271; 11655,20.9419445441416; 11660,20.9384741663992; 11665,20.9346788940053; 11670,20.9305714389654; 11675,20.9259806887926; 11680,20.9213726738191; 11685,20.9181254175773; 11690,20.9151610883171; 11695,20.9125115055404; 11700,20.9102084887494; 11705,20.9082838574459; 11710,20.906769431132; 11715,20.9056970293096; 11720,20.9050984714809; 11725,20.9050055771477; 11730,20.9054501658121; 11735,20.9064640569762; 11740,20.9080790701418; 11745,20.9103270248109; 11750,20.911731655425; 11755,20.9122240029925; 11760,20.9127231267503; 11765,20.9132238142444; 11770,20.9137208530206; 11775,20.9142090306248; 11780,
        20.9146831346028; 11785,20.9151379525006; 11790,20.9155682718639; 11795,20.9159688802387; 11800,20.9163345651708; 11805,20.916660114206; 11810,20.9169403148903; 11815,20.918542377576; 11820,20.9215366992522; 11825,20.9235107765145; 11830,20.9245175156112; 11835,20.9246098227905; 11840,20.9238406043009; 11845,20.9222627663904; 11850,20.9199292153073; 11855,20.9144102969893; 11860,20.9076331191784; 11865,20.904426689914; 11870,20.9027609755649; 11875,20.9005595265017; 11880,20.8978804614269; 11885,20.8947818990428; 11890,20.8913219580519; 11895,20.8875587571566; 11900,20.8835504150592; 11905,20.8793550504621; 11910,20.8754363441435; 11915,20.8715592947076; 11920,20.8674821295836; 11925,20.8632744674307; 11930,20.8590059269082; 11935,20.8547461266752; 11940,20.8505646853909; 11945,20.8465312217145; 11950,20.8427153543051; 11955,20.8391867018218; 11960,20.836014882924; 11965,20.8332695162708; 11970,20.8282506891151; 11975,20.8230296996781; 11980,20.8197240856637; 11985,
        20.8183249340011; 11990,20.8188233316193; 11995,20.819039601419; 12000,20.8190495371495; 12005,20.8195826867442; 12010,20.8205849576943; 12015,20.8220022574911; 12020,20.8237804936259; 12025,20.82586557359; 12030,20.8282034048748; 12035,20.8352398503218; 12040,20.8448773152611; 12045,20.8516582795638; 12050,20.857650984401; 12055,20.8637836410529; 12060,20.8700021570107; 12065,20.8762524397657; 12070,20.8824803968092; 12075,20.8886319356326; 12080,20.8946529637271; 12085,20.9004893885841; 12090,20.9054306633618; 12095,20.90927794168; 12100,20.9125898689015; 12105,20.9154190413149; 12110,20.9176901603946; 12115,20.9193279276148; 12120,20.9202570444499; 12125,20.9204022123741; 12130,20.9201714922011; 12135,20.9205339159034; 12140,20.919238695541; 12145,20.916249322982; 12150,20.91601213255; 12155,20.9164548851927; 12160,20.9166410363261; 12165,20.9166126095482; 12170,20.9164116284574; 12175,20.9156197063846; 12180,20.9141277859004; 12185,20.9123381499898; 12190,20.9102798829864;
        12195,20.9069631111676; 12200,20.9019739876469; 12205,20.8976329246479; 12210,20.8939189369658; 12215,20.8908110393955; 12220,20.8882882467322; 12225,20.8863295737708; 12230,20.8849140353064; 12235,20.8840206461341; 12240,20.8836284210489; 12245,20.8837163748459; 12250,20.8842635223201; 12255,20.8852488782667; 12260,20.8866514574805; 12265,20.8884502747567; 12270,20.8891125294055; 12275,20.8893279584521; 12280,20.8910903188119; 12285,20.8943258947144; 12290,20.898960970389; 12295,20.9049218300649; 12300,20.9119732655746; 12305,20.9200415824897; 12310,20.9282742319351; 12315,20.9355633176649; 12320,20.9431576615678; 12325,20.9509380879879; 12330,20.9588506136246; 12335,20.966916915309; 12340,20.974724401561; 12345,20.98215912852; 12350,20.9891071523257; 12355,20.9954545291175; 12360,21.001087315035; 12365,21.0058915662175; 12370,21.0103510558984; 12375,21.0174908694427; 12380,21.0249764999394; 12385,21.0313977906589; 12390,21.0367388350737; 12395,21.0409837266564; 12400,
        21.0441165588794; 12405,21.0461214252154; 12410,21.0469824191367; 12415,21.0466836341161; 12420,21.045209163626; 12425,21.0425431011389; 12430,21.0386695401273; 12435,21.0335725740639; 12440,21.027277086832; 12445,21.0198553023417; 12450,21.0137119824322; 12455,21.0088971304977; 12460,21.0039487346501; 12465,20.9989165984866; 12470,20.9938505256041; 12475,20.9888003195995; 12480,20.9828745241393; 12485,20.9774539334323; 12490,20.9727589692064; 12495,20.9688193782314; 12500,20.965664907277; 12505,20.9633253031132; 12510,20.9616886480482; 12515,20.9606461048716; 12520,20.9604066951449; 12525,20.9609949338424; 12530,20.9624353359386; 12535,20.964752416408; 12540,20.967970690225; 12545,20.972114672364; 12550,20.9759100250471; 12555,20.9781106539337; 12560,20.9803847576317; 12565,20.9832578716124; 12570,20.986706470503; 12575,20.9897840857843; 12580,20.9924899373611; 12585,20.9948232451383; 12590,20.9967832290206; 12595,20.9983691089129; 12600,20.9996271691386; 12605,
        21.0004951830655; 12610,21.0009732216115; 12615,21.0010613556943; 12620,21.000671017747; 12625,20.9997155676388; 12630,20.9983072472984; 12635,20.996442854145; 12640,20.9941191855977; 12645,20.9913330390759; 12650,20.9895897464367; 12655,20.9872478611392; 12660,20.9858580625469; 12665,20.9839988642472; 12670,20.9817268521519; 12675,20.9790986121733; 12680,20.9777748111854; 12685,20.9761139239105; 12690,20.9736873382448; 12695,20.9705875744433; 12700,20.9694162780226; 12705,20.9675410998535; 12710,20.9643849351321; 12715,20.9600952959878; 12720,20.9548196945503; 12725,20.9487056429492; 12730,20.941900653314; 12735,20.9345522377744; 12740,20.9268079084598; 12745,20.917869489076; 12750,20.9078617464748; 12755,20.8974585083522; 12760,20.8833257740865; 12765,20.8684132162866; 12770,20.8549805296596; 12775,20.8430490228107; 12780,20.8326081989289; 12785,20.8237285585703; 12790,20.8164417729543; 12795,20.8107795133005; 12800,20.8067734508281; 12805,20.8044552567567; 12810,
        20.8038566023058; 12815,20.805609928542; 12820,20.8133277135103; 12825,20.8218228515777; 12830,20.8281921246353; 12835,20.8343602321; 12840,20.8404234029023; 12845,20.8464778659728; 12850,20.852619850242; 12855,20.8571334557481; 12860,20.8595902780781; 12865,20.8623169436129; 12870,20.8653781739169; 12875,20.8687959921731; 12880,20.8685667963743; 12885,20.8676988884629; 12890,20.8661592997472; 12895,20.8639150615352; 12900,20.8609332051353; 12905,20.8571807618555; 12910,20.8526247630042; 12915,20.8472322398895; 12920,20.8409702238197; 12925,20.8338057461028; 12930,20.8257058380473; 12935,20.8166375309611; 12940,20.8121536986153; 12945,20.8092718075246; 12950,20.8071451810517; 12955,20.8058331676771; 12960,20.8014632201908; 12965,20.7987495165177; 12970,20.7983013375329; 12975,20.8000985780563; 12980,20.8041211329076; 12985,20.8103488969066; 12990,20.8265348814468; 12995,20.8411662390309; 13000,20.8495362287243; 13005,20.864716896075; 13010,20.8754442823656; 13015,
        20.8881134680913; 13020,20.894788175385; 13025,20.8957599454776; 13030,20.8914100710921; 13035,20.8846774123072; 13040,20.8738411318314; 13045,20.8607415894184; 13050,20.8457083980744; 13055,20.8265316829295; 13060,20.803603640863; 13065,20.7790478153181; 13070,20.7526623193588; 13075,20.7227024593763; 13080,20.6896212982088; 13085,20.6538718986947; 13090,20.6159073236724; 13095,20.57618063598; 13100,20.5351448984561; 13105,20.4965264410752; 13110,20.4576488393802; 13115,20.4135999566911; 13120,20.3695923381537; 13125,20.3266862602627; 13130,20.2853347858567; 13135,20.2464593448945; 13140,20.2155451228947; 13145,20.1890380974294; 13150,20.1674717037049; 13155,20.1528865815585; 13160,20.1477945105453; 13165,20.145944059583; 13170,20.1391057562857; 13175,20.1352098121451; 13180,20.1339092403259; 13185,20.127751765307; 13190,20.1226820689282; 13195,20.113311845442; 13200,20.1049503476358; 13205,20.0977785245492; 13210,20.091977325222; 13215,20.0877276986937; 13220,
        20.0852105940041; 13225,20.0820048884436; 13230,20.0782289471789; 13235,20.0755118821239; 13240,20.073972258075; 13245,20.0708316651125; 13250,20.0678911418576; 13255,20.0678881452799; 13260,20.0670726630556; 13265,20.0655751685205; 13270,20.0635261350105; 13275,20.0610560358616; 13280,20.0582953444094; 13285,20.0501062601644; 13290,20.0404195984848; 13295,20.0347516101794; 13300,20.0291696466278; 13305,20.0238041811659; 13310,20.0187735815094; 13315,20.0141618799814; 13320,20.0101405492445; 13325,20.0068391439274; 13330,20.004387218659; 13335,20.0000726191401; 13340,19.9915310448758; 13345,19.9822739887524; 13350,19.9748284040702; 13355,19.9681321243727; 13360,19.9616795615588; 13365,19.9555434901273; 13370,19.949796684577; 13375,19.9445119194066; 13380,19.9397619691149; 13385,19.9356196082006; 13390,19.9321576111625; 13395,19.9294487524993; 13400,19.9275658067098; 13405,19.9265815482927; 13410,19.9265687517468; 13415,19.9276001915709; 13420,19.9297486422636; 13425,
        19.9330868783239; 13430,19.9354565757152; 13435,19.9354565757152; 13440,19.9354565757152; 13445,19.9354565757152; 13450,19.9354565757152; 13455,19.9354565757152; 13460,19.9354565757152; 13465,19.9354565757152; 13470,19.9354565757152; 13475,19.9354565757152; 13480,19.9353734684026; 13485,19.9352072647606; 13490,19.935097693369; 13495,19.9350413219702; 13500,19.9350347183066; 13505,19.9350744501206; 13510,19.9351570851545; 13515,19.9352791911509; 13520,19.935437335852; 13525,19.9356280870003; 13530,19.9358480123382; 13535,19.9360936796081; 13540,19.9363616565523; 13545,19.9366485109134; 13550,19.9369508104337; 13555,19.9372651228555; 13560,19.9375880159214; 13565,19.9379160573736; 13570,19.9382458149547; 13575,19.9385738564069; 13580,19.939416719792; 13585,19.9402714585686; 13590,19.9409826715393; 13595,19.9415376610183; 13600,19.9419250088911; 13605,19.9421345850608; 13610,19.9421575431445; 13615,19.9419831353267; 13620,19.9415535269847; 13625,19.9408646561062; 13630,
        19.9399336315967; 13635,19.9387807757866; 13640,19.9374747679135; 13645,19.9360318154012; 13650,19.9344482650362; 13655,19.9327217215291; 13660,19.9309910212553; 13665,19.9292082336197; 13670,19.9272960980645; 13675,19.9252816092674; 13680,19.9231917619064; 13685,19.9210535506591; 13690,19.9188939702034; 13695,19.9167400152171; 13700,19.9086553252705; 13705,19.8967388046643; 13710,19.884328853885; 13715,19.8764870356927; 13720,19.8729584410944; 13725,19.8734881610974; 13730,19.8778212867085; 13735,19.8837960727099; 13740,19.8870377616574; 13745,19.8958736766273; 13750,19.9098958818366; 13755,19.9286964415023; 13760,19.951027087445; 13765,19.9770083733965; 13770,20.0061964733682; 13775,20.0381462599983; 13780,20.0724112933357; 13785,20.1054623477355; 13790,20.1396270922647; 13795,20.1760293510766; 13800,20.2142145787241; 13805,20.2536861374625; 13810,20.2939379123401; 13815,20.3344534074921; 13820,20.3746518239551; 13825,20.4139931849632; 13830,20.4519456665762; 13835,
        20.4879761952278; 13840,20.5215607808984; 13845,20.5522384418986; 13850,20.5795060674555; 13855,20.6028510891031; 13860,20.6217609383752; 13865,20.6357230468058; 13870,20.6442248459286; 13875,20.6467537672775; 13880,20.6523648127676; 13885,20.6608507611726; 13890,20.6700567686253; 13895,20.6769336281808; 13900,20.6765612851667; 13905,20.6745127398416; 13910,20.6708861203209; 13915,20.6673257660901; 13920,20.6675644373827; 13925,20.6693433540061; 13930,20.6724046070167; 13935,20.6770893771039; 13940,20.6831249911859; 13945,20.690238776181; 13950,20.6981580590073; 13955,20.7066101665832; 13960,20.7153224258267; 13965,20.7298592795918; 13970,20.7463651273501; 13975,20.7634467232249; 13980,20.7809337244087; 13985,20.7986557880938; 13990,20.8164425714727; 13995,20.8341237317376; 14000,20.8515289260809; 14005,20.8684878116952; 14010,20.8848300457726; 14015,20.9003852855056; 14020,20.9149831880866; 14025,20.928453410708; 14030,20.9379254514313; 14035,20.9435621279671; 14040,
        20.9492996898279; 14045,20.9548621960748; 14050,20.9599737057685; 14055,20.9643582779699; 14060,20.9677399717398; 14065,20.969842846139; 14070,20.9703909602286; 14075,20.9698798621142; 14080,20.9733218953563; 14085,20.976100838028; 14090,20.9780311080657; 14095,20.9826793558433; 14100,20.9899502463237; 14105,20.9981837753193; 14110,21.0072990840618; 14115,21.0168589140839; 14120,21.026782359523; 14125,21.0369885145162; 14130,21.047396473201; 14135,21.0579253297146; 14140,21.0684941781941; 14145,21.0776125990586; 14150,21.085839769314; 14155,21.0933777762519; 14160,21.1001210217407; 14165,21.1059639076489; 14170,21.110800835845; 14175,21.1145262081974; 14180,21.1170344265747; 14185,21.1182198928453; 14190,21.1197336777456; 14195,21.1214782255566; 14200,21.1205269902871; 14205,21.1168445254336; 14210,21.1149730145525; 14215,21.1145164029452; 14220,21.1129842786894; 14225,21.1104350850393; 14230,21.106884235483; 14235,21.1024666735595; 14240,21.0973199465207; 14245,
        21.0915272167028; 14250,21.08607703733; 14255,21.0816019902188; 14260,21.0759455400562; 14265,21.0692381771016; 14270,21.0616103916146; 14275,21.0531926738544; 14280,21.0441155140806; 14285,21.0347122632291; 14290,21.0251133847499; 14295,21.0151082986242; 14300,21.0048358730758; 14305,20.9944349763283; 14310,20.9840444766055; 14315,20.9738032421312; 14320,20.963850141129; 14325,20.9543240418227; 14330,20.9461348972809; 14335,20.9385223346291; 14340,20.931499703159; 14345,20.9263656796233; 14350,20.9232748005514; 14355,20.9204583613801; 14360,20.9181182955481; 14365,20.9164565364943; 14370,20.9126489760464; 14375,20.906798057021; 14380,20.9005978995833; 14385,20.8940909290391; 14390,20.8873404860324; 14395,20.8804610407315; 14400,20.873701880708; 14405,20.8658171136685; 14410,20.8540756183126; 14415,20.8447119286328; 14420,20.837710461435; 14425,20.8330799670016; 14430,20.8291387640779; 14435,20.8253556153816; 14440,20.8230507723491; 14445,20.8221856573396; 14450,
        20.8227216927127; 14455,20.8246203008276; 14460,20.8278429040439; 14465,20.8320014764784; 14470,20.8370490357167; 14475,20.8431414868305; 14480,20.850231874215; 14485,20.8582732422652; 14490,20.8672186353763; 14495,20.8770210979433; 14500,20.8876336743614; 14505,20.8989422971669; 14510,20.9098573395976; 14515,20.9211416220281; 14520,20.9327323693616; 14525,20.9449476235001; 14530,20.9555324563749; 14535,20.964361325148; 14540,20.9713829933617; 14545,20.9765462245583; 14550,20.9797997822799; 14555,20.981092430069; 14560,20.9803729314675; 14565,20.9775900500179; 14570,20.9726925492624; 14575,20.9656291927431; 14580,20.9563487440023; 14585,20.9477790663348; 14590,20.9427832427765; 14595,20.9375400194472; 14600,20.932108180709; 14605,20.926546510924; 14610,20.9209137944544; 14615,20.9152688156623; 14620,20.9096703589097; 14625,20.9041772085589; 14630,20.898848148972; 14635,20.893741964511; 14640,20.888917439538; 14645,20.8844333584153; 14650,20.880348505505; 14655,20.876721665169;
        14660,20.8736116217697; 14665,20.871077159669; 14670,20.8691770632292; 14675,20.8679701168123; 14680,20.8675151047805; 14685,20.8678708114958; 14690,20.8690960213204; 14695,20.8712495186165; 14700,20.8743900877461; 14705,20.8736715144227; 14710,20.8705074202594; 14715,20.8682136206539; 14720,20.8669559078414; 14725,20.8666681558615; 14730,20.8677813566745; 14735,20.8695803552745; 14740,20.8721153228291; 14745,20.8755609690401; 14750,20.8793771867316; 14755,20.8835154504377; 14760,20.8901161650077; 14765,20.896753662116; 14770,20.9027952435522; 14775,20.908240358092; 14780,20.913088454511; 14785,20.917338981585; 14790,20.9209913880898; 14795,20.9240451228009; 14800,20.9264996344943; 14805,20.9283543719455; 14810,20.9296087839303; 14815,20.9302623192245; 14820,20.9303144266037; 14825,20.9297645548437; 14830,20.9286121527202; 14835,20.926856669009; 14840,20.923454388303; 14845,20.9174104942328; 14850,20.9117758935367; 14855,20.9064890263902; 14860,20.9014883329685; 14865,
        20.8965811776029; 14870,20.8918007355698; 14875,20.8871823705591; 14880,20.8826608060114; 14885,20.8801789166071; 14890,20.8810308315487; 14895,20.8830620390942; 14900,20.8862733886445; 14905,20.8939215727153; 14910,20.901147637947; 14915,20.9084145932212; 14920,20.9155421291816; 14925,20.9223550070231; 14930,20.9292011917052; 14935,20.9361249455701; 14940,20.9396586245805; 14945,20.9424516842929; 14950,20.9445004128082; 14955,20.9433905190998; 14960,20.9408605379754; 14965,20.9386892507378; 14970,20.9368045920656; 14975,20.9351344966375; 14980,20.9336068991322; 14985,20.9353019703788; 14990,20.9367243676656; 14995,20.936960769816; 15000,20.9360081982848; 15005,20.9338636745267; 15010,20.9305242199965; 15015,20.925986856149; 15020,20.9222528550233; 15025,20.9203217178356; 15030,20.9183660166758; 15035,20.9164437815991; 15040,20.9146130426606; 15045,20.9131439930119; 15050,20.9119983160308; 15055,20.9111914450225; 15060,20.9107851267766; 15065,20.9108411080827; 15070,
        20.9114211357305; 15075,20.9125869565096; 15080,20.9135963553698; 15085,20.911426825519; 15090,20.9088629725461; 15095,20.9048520160209; 15100,20.8986981605856; 15105,20.8930824879771; 15110,20.8879496630144; 15115,20.8832443505165; 15120,20.8789112153025; 15125,20.8748949221914; 15130,20.8711401360022; 15135,20.8714933536221; 15140,20.8741273551193; 15145,20.8782034204123; 15150,20.8837345677421; 15155,20.89073381535; 15160,20.8992141814771; 15165,20.9041312560069; 15170,20.9108496069527; 15175,20.9182471945024; 15180,20.9249672044373; 15185,20.9310005512275; 15190,20.936338149343; 15195,20.9409709132538; 15200,20.94488975743; 15205,20.9480855963415; 15210,20.9505493444584; 15215,20.9522719162508; 15220,20.9532442261886; 15225,20.9534571887418; 15230,20.9529017183806; 15235,20.9515687295749; 15240,20.9494491367947; 15245,20.9465338545101; 15250,20.9428137971911; 15255,20.9382798793076; 15260,20.9329230153299; 15265,20.9267341197277; 15270,20.9197041069713; 15275,
        20.9137839043757; 15280,20.9096801220562; 15285,20.9057961273619; 15290,20.9021789032979; 15295,20.8988754328691; 15300,20.8959326990803; 15305,20.8933976849366; 15310,20.8913173734429; 15315,20.889738747604; 15320,20.888708790425; 15325,20.8882744849107; 15330,20.8884828140661; 15335,20.8893807608961; 15340,20.8910153084057; 15345,20.8934334395997; 15350,20.8940795591325; 15355,20.8940795591325; 15360,20.8940795591325; 15365,20.8940795591325; 15370,20.8940795591325; 15375,20.8940795591325; 15380,20.8940795591325; 15385,20.8940795591325; 15390,20.8940795591325; 15395,20.8940795591325; 15400,20.8940795591325; 15405,20.8940795591325; 15410,20.8940795591325; 15415,20.8922324469788; 15420,20.8898732234729; 15425,20.8883677283913; 15430,20.8876635857571; 15435,20.8877084195934; 15440,20.8884498539231; 15445,20.8898355127695; 15450,20.8918130201554; 15455,20.8943300001039; 15460,20.8973340766382; 15465,20.9007728737811; 15470,20.9045940155559; 15475,20.9087451259854; 15480,
        20.9129708575602; 15485,20.9174392580994; 15490,20.9221521198362; 15495,20.927052618317; 15500,20.9320839290882; 15505,20.9371892276964; 15510,20.9423116896878; 15515,20.9473944906089; 15520,20.9534058807526; 15525,20.9602889001943; 15530,20.966263263163; 15535,20.9713144798743; 15540,20.9754280605439; 15545,20.9785895153873; 15550,20.9807843546202; 15555,20.9819980884583; 15560,20.9822162271171; 15565,20.9814242808124; 15570,20.9796077597596; 15575,20.9767521741746; 15580,20.9728430342728; 15585,20.9678658502699; 15590,20.9618061323816; 15595,20.9576391791913; 15600,20.9539927898894; 15605,20.9502522040951; 15610,20.9464553080008; 15615,20.9426399877991; 15620,20.9388441296827; 15625,20.935105619844; 15630,20.9314623444758; 15635,20.9270413092849; 15640,20.9225387395778; 15645,20.9186660685194; 15650,20.9154353537381; 15655,20.9128586528619; 15660,20.9112736698018; 15665,20.9104508921113; 15670,20.9104068258952; 15675,20.9111579772581; 15680,20.9127208523048; 15685,
        20.9151119571402; 15690,20.9183477978689; 15695,20.9224448805956; 15700,20.9256539154386; 15705,20.9279489383623; 15710,20.9303291955487; 15715,20.9327688584334; 15720,20.9366330417738; 15725,20.9403853750923; 15730,20.9436288205756; 15735,20.9463680346182; 15740,20.9486076736147; 15745,20.9503523939595; 15750,20.9516068520474; 15755,20.9523757042727; 15760,20.9526636070301; 15765,20.9524752167141; 15770,20.9518151897193; 15775,20.9506881824403; 15780,20.9490988512715; 15785,20.9470518526076; 15790,20.944551842843; 15795,20.9416034783724; 15800,20.9382114155904; 15805,20.9343803108913; 15810,20.9301148206699; 15815,20.9268939784314; 15820,20.9240529021911; 15825,20.921300232332; 15830,20.918666453813; 15835,20.9161820515931; 15840,20.9138775106315; 15845,20.911783315887; 15850,20.9099299523188; 15855,20.9083479048858; 15860,20.907067658547; 15865,20.9061196982615; 15870,20.9055345089883; 15875,20.9053425756863; 15880,20.9055743833147; 15885,20.9062604168323; 15890,
        20.9074311611983; 15895,20.9091171013717; 15900,20.9091171013717; 15905,20.9091171013717; 15910,20.9091171013717; 15915,20.9091171013717; 15920,20.9091171013717; 15925,20.9091171013717; 15930,20.9091171013717; 15935,20.9084583263755; 15940,20.9078561953562; 15945,20.907486519483; 15950,20.907334860548; 15955,20.9073867803433; 15960,20.9076278406612; 15965,20.9080436032938; 15970,20.9086196300333; 15975,20.9093414826719; 15980,20.9101947230016; 15985,20.9111649128148; 15990,20.9122376139036; 15995,20.9133983880601; 16000,20.9146327970765; 16005,20.915926402745; 16010,20.9172647668578; 16015,20.918633451207; 16020,20.9200180175848; 16025,20.9214040277835; 16030,20.922777043595; 16035,20.9241226268117; 16040,20.9254263392257; 16045,20.9266737426292; 16050,20.9278503988143; 16055,20.9289418695732; 16060,20.9299337166982; 16065,20.9308115019812; 16070,20.9315607872147; 16075,20.9321671341906; 16080,20.9326161047012; 16085,20.9328932605387; 16090,20.9329841634951; 16095,
        20.9328743753628; 16100,20.9325494579339; 16105,20.9319949730005; 16110,20.9311964823548; 16115,20.9311964823548; 16120,20.9311964823548; 16125,20.9311964823548; 16130,20.9311964823548; 16135,20.9311964823548; 16140,20.9301505665082; 16145,20.9281924480462; 16150,20.9269065571; 16155,20.9256307003941; 16160,20.9247731812939; 16165,20.9247526777236; 16170,20.9255107647451; 16175,20.9266425412939; 16180,20.9285419360092; 16185,20.9311442590147; 16190,20.9343848204346; 16195,20.9381989303927; 16200,20.9428195223998; 16205,20.9502749361291; 16210,20.9572678585061; 16215,20.9637837030404; 16220,20.9698078832416; 16225,20.9753258126194; 16230,20.9803229046834; 16235,20.9847845729432; 16240,20.9927877817443; 16245,21.0010375290758; 16250,21.0069142934474; 16255,21.0099376096778; 16260,21.0067824046733; 16265,21.0029784309366; 16270,20.9985358071404; 16275,20.9934646519571; 16280,20.9877750840594; 16285,20.9814772221198; 16290,20.9745811848108; 16295,20.967097090805; 16300,
        20.959035058775; 16305,20.9504052073932; 16310,20.9412176553324; 16315,20.9314825212649; 16320,20.9229937018318; 16325,20.9156589021958; 16330,20.9086036327427; 16335,20.9028846138512; 16340,20.898096020868; 16345,20.8940868401554; 16350,20.8908893473286; 16355,20.8890439103461; 16360,20.8883373376961; 16365,20.8888422894419; 16370,20.8906314256468; 16375,20.893777406374; 16380,20.8973606719343; 16385,20.8995005118102; 16390,20.9022836229817; 16395,20.9057268855171; 16400,20.9098427119814; 16405,20.9146441529284; 16410,20.9201449158438; 16415,20.9263593039454; 16420,20.9266922488193; 16425,20.9245718682848; 16430,20.9210353406944; 16435,20.9177550498692; 16440,20.9178264422198; 16445,20.9178227252662; 16450,20.9177528012442; 16455,20.917646381011; 16460,20.9175020833713; 16465,20.9173140159838; 16470,20.9170548681857; 16475,20.9167132449863; 16480,20.9162955483237; 16485,20.9160119131988; 16490,20.9188030684539; 16495,20.92050212302; 16500,20.9211769290597; 16505,
        20.9206183616033; 16510,20.9151976896723; 16515,20.9098733070331; 16520,20.9051551342601; 16525,20.9004623028079; 16530,20.8965286835904; 16535,20.8933989284367; 16540,20.8910448169202; 16545,20.8894381286145; 16550,20.8885506430928; 16555,20.8883541399289; 16560,20.888820398696; 16565,20.8899107411859; 16570,20.8915599024311; 16575,20.8936954422264; 16580,20.8962105975916; 16585,20.8992006316223; 16590,20.9026207585501; 16595,20.9064255968747; 16600,20.9105691081637; 16605,20.9150046159962; 16610,20.9196847858783; 16615,20.92457212318; 16620,20.9296550677934; 16625,20.9348981831923; 16630,20.9402539895944; 16635,20.9456484134684; 16640,20.9510306197122; 16645,20.9563523973389; 16650,20.9615967432832; 16655,20.9667336619017; 16660,20.9717239405177; 16665,20.9759619912485; 16670,20.9761851685485; 16675,20.9748007568165; 16680,20.9717184245769; 16685,20.9677557564937; 16690,20.9674952488479; 16695,20.9668931789534; 16700,20.9659418556131; 16705,20.9655856462328; 16710,
        20.965115153715; 16715,20.9645382676588; 16720,20.963862877663; 16725,20.9630968733266; 16730,20.9622481442486; 16735,20.9613245800278; 16740,20.9603340702632; 16745,20.9592845045538; 16750,20.9577864418812; 16755,20.955913943165; 16760,20.9544076122533; 16765,20.9531752567311; 16770,20.9522107986253; 16775,20.951508159963; 16780,20.9510612627713; 16785,20.9508640290772; 16790,20.9509103809078; 16795,20.9511942402901; 16800,20.9517095292511; 16805,20.9524501698179; 16810,20.9534100840176; 16815,20.9545831938771; 16820,20.95590039813; 16825,20.957219452721; 16830,20.9588179330523; 16835,20.9606847034265; 16840,20.9628086281461; 16845,20.9644222698206; 16850,20.9660755304982; 16855,20.9677469430558; 16860,20.96941504037; 16865,20.9710583553177; 16870,20.9726554207756; 16875,20.9741847696204; 16880,20.9756249347288; 16885,20.9769544489778; 16890,20.9781518452439; 16895,20.9791956564039; 16900,20.9800644153347; 16905,20.9807366549128; 16910,20.9814579436148; 16915,20.9827837627656;
        16920,20.9834907793155; 16925,20.983578956194; 16930,20.9837326989154; 16935,20.9839684323179; 16940,20.9839051981124; 16945,20.9835593686269; 16950,20.9829473161896; 16955,20.9820854131285; 16960,20.9809900317718; 16965,20.9796775444475; 16970,20.9781643234838; 16975,20.9764667412088; 16980,20.9746011699505; 16985,20.972583982037; 16990,20.9704315497965; 16995,20.968160245557; 17000,20.9659233926879; 17005,20.9638713365703; 17010,20.961847139521; 17015,20.9598722315927; 17020,20.957968042838; 17025,20.9561560033096; 17030,20.95445754306; 17035,20.9528940921418; 17040,20.9514870806077; 17045,20.9502579385102; 17050,20.949228095902; 17055,20.9484189828357; 17060,20.9478520293639; 17065,20.9475486655391; 17070,20.9475303214141; 17075,20.9478184270414; 17080,20.9484344124736; 17085,20.9493997077633; 17090,20.9501554685707; 17095,20.9501554685707; 17100,20.9501554685707; 17105,20.9501554685707; 17110,20.9501554685707; 17115,20.9501554685707; 17120,20.9501554685707; 17125,
        20.9501554685707; 17130,20.9501554685707; 17135,20.9501554685707; 17140,20.9501554685707; 17145,20.9501554685707; 17150,20.9501554685707; 17155,20.9501554685707; 17160,20.9501554685707; 17165,20.9501554685707; 17170,20.9501554685707; 17175,20.9501554685707; 17180,20.9501554685707; 17185,20.9501554685707; 17190,20.9501554685707; 17195,20.9501554685707; 17200,20.9501554685707; 17205,20.9479312816775; 17210,20.9455413171995; 17215,20.9440436454088; 17220,20.9433831906188; 17225,20.9435048771431; 17230,20.9443536292952; 17235,20.9471460321649; 17240,20.9504460070647; 17245,20.9538591026955; 17250,20.9573581140441; 17255,20.9609158360971; 17260,20.9645050638411; 17265,20.9680985922627; 17270,20.974073398096; 17275,20.980026869426; 17280,20.9849838012426; 17285,20.9889738548919; 17290,20.9907768999023; 17295,20.9910646802944; 17300,20.9911317490352; 17305,20.9909676280281; 17310,20.9905618391767; 17315,20.9899039043843; 17320,20.9889833455543; 17325,20.9877896845902; 17330,
        20.9863124433954; 17335,20.9845411438734; 17340,20.9824653079275; 17345,20.9800744574612; 17350,20.9773581143779; 17355,20.9743058005811; 17360,20.9709070379741; 17365,20.9671513484605; 17370,20.9630282539436; 17375,20.9585272763268; 17380,20.9536379375137; 17385,20.951932222415; 17390,20.9511998371506; 17395,20.9511380884268; 17400,20.9502594991132; 17405,20.9497254838063; 17410,20.9507011546197; 17415,20.9511475900596; 17420,20.9525796024192; 17425,20.954970644286; 17430,20.9588262511401; 17435,20.9662474894735; 17440,20.9735361512764; 17445,20.980726073983; 17450,20.9839846118206; 17455,20.9859119109787; 17460,20.9867140195511; 17465,20.9863679086124; 17470,20.9869235879812; 17475,20.9876987319126; 17480,20.9880444070166; 17485,20.9879777238105; 17490,20.9875157928115; 17495,20.9866757245371; 17500,20.9854746295045; 17505,20.9839296182311; 17510,20.9820578012342; 17515,20.9798762890312; 17520,20.9774021921395; 17525,20.9747807376749; 17530,20.9726170500729; 17535,
        20.9699451907437; 17540,20.9667981880145; 17545,20.9641084457473; 17550,20.9610126004219; 17555,20.957199167625; 17560,20.954219716791; 17565,20.9503317195574; 17570,20.9454110054129; 17575,20.9395415780364; 17580,20.9352869282394; 17585,20.931593000176; 17590,20.9280549889619; 17595,20.924800172605; 17600,20.9195957963006; 17605,20.9137100195927; 17610,20.9083628118805; 17615,20.9015793303655; 17620,20.8960961550517; 17625,20.8928407645319; 17630,20.8898496626825; 17635,20.8871474853604; 17640,20.8847588684226; 17645,20.8827084477262; 17650,20.8810208591279; 17655,20.8797207384849; 17660,20.878832721654; 17665,20.8783814444922; 17670,20.8783915428565; 17675,20.8788876526038; 17680,20.8798944095911; 17685,20.8814364496754; 17690,20.8835384087136; 17695,20.8862249225626; 17700,20.8895206270795; 17705,20.8930926582159; 17710,20.8964172535834; 17715,20.900118824626; 17720,20.9042060893908; 17725,20.9072416658782; 17730,20.9102040463704; 17735,20.9129739153592; 17740,
        20.9136725253199; 17745,20.9137720254087; 17750,20.9132301583214; 17755,20.9120046667534; 17760,20.9100532934005; 17765,20.9073337809581; 17770,20.903803872122; 17775,20.8994213095876; 17780,20.8975827354712; 17785,20.8974253742338; 17790,20.8980272757633; 17795,20.8994093801349; 17800,20.9006495506081; 17805,20.9008461575634; 17810,20.9012135942411; 17815,20.9017379720459; 17820,20.9024054023825; 17825,20.9032019966555; 17830,20.9041138662696; 17835,20.9051271226296; 17840,20.90622787714; 17845,20.9074022412056; 17850,20.9086363262311; 17855,20.9099162436212; 17860,20.9112281047804; 17865,20.9125580211136; 17870,20.9138921040254; 17875,20.9152164649204; 17880,20.9165172152034; 17885,20.9177804662791; 17890,20.9188555983275; 17895,20.9168990514865; 17900,20.9155325845159; 17905,20.9150597844251; 17910,20.9154049287936; 17915,20.916492295201; 17920,20.918246161227; 17925,20.9206697163957; 17930,20.923687227858; 17935,20.9270902982988; 17940,20.9308064642903; 17945,
        20.9347632624049; 17950,20.9388882292147; 17955,20.943108901292; 17960,20.9481456206733; 17965,20.9535658982076; 17970,20.9597122412244; 17975,20.9660855743164; 17980,20.972235997146; 17985,20.9781207624315; 17990,20.9836971228915; 17995,20.9889223312443; 18000,20.9937536402086; 18005,20.9981483025026; 18010,21.002063570845; 18015,21.0054566979542; 18020,21.0082849365485; 18025,21.0105055393466; 18030,21.0120757590668; 18035,21.0133233763891; 18040,21.0181135406774; 18045,21.020775920722; 18050,21.02122785112; 18055,21.0180273164107; 18060,21.0110348647019; 18065,21.0030360400899; 18070,20.9945989722777; 18075,20.9892176051623; 18080,20.9839477334723; 18085,20.9788313260059; 18090,20.9739103515611; 18095,20.9692267789361; 18100,20.964822576929; 18105,20.9606037804507; 18110,20.9566090888777; 18115,20.9529561239602; 18120,20.9496835955037; 18125,20.9468302133135; 18130,20.9444512965846; 18135,20.94262144083; 18140,20.9413046008067; 18145,20.9405408192516; 18150,20.9394418119274;
        18155,20.9385016414402; 18160,20.9379225467089; 18165,20.9377287429192; 18170,20.937944445257; 18175,20.9385938689081; 18180,20.9397012290582; 18185,20.9412907408931; 18190,20.9433866195987; 18195,20.9460130803608; 18200,20.9491943383651; 18205,20.9531213984482; 18210,20.9576373449374; 18215,20.9612815737121; 18220,20.9601491762848; 18225,20.9579636394097; 18230,20.9546652181114; 18235,20.9527939411751; 18240,20.9525296629167; 18245,20.9522341958407; 18250,20.9519125283656; 18255,20.95156964891; 18260,20.9512105458923; 18265,20.9508402077312; 18270,20.9504636228451; 18275,20.9500857796526; 18280,20.9497116665723; 18285,20.9493462720226; 18290,20.948994584422; 18295,20.9486615921892; 18300,20.9483522837427; 18305,20.9480716475009; 18310,20.9477885793041; 18315,20.9474727598222; 18320,20.9471748522281; 18325,20.9464621156863; 18330,20.9453382633572; 18335,20.9445406652048; 18340,20.9440549539392; 18345,20.9438667622703; 18350,20.9439617229079; 18355,20.9443254685621; 18360,
        20.9449436319427; 18365,20.9458018457596; 18370,20.9468857427227; 18375,20.948180955542; 18380,20.9496731169274; 18385,20.9510802632955; 18390,20.9568557008789; 18395,20.9629001895107; 18400,20.9673334073512; 18405,20.9702408038342; 18410,20.9717078283932; 18415,20.9718199304619; 18420,20.9706625594739; 18425,20.9683211648626; 18430,20.9648811960618; 18435,20.9604281025051; 18440,20.955047333626; 18445,20.9456577147172; 18450,20.9346333736543; 18455,20.9244013075676; 18460,20.9149571743572; 18465,20.9062966319231; 18470,20.8984153381652; 18475,20.8928634445574; 18480,20.888513098355; 18485,20.8842104933326; 18490,20.8799953659913; 18495,20.875907452832; 18500,20.8719864903558; 18505,20.8690239523179; 18510,20.8670776556696; 18515,20.8657689633665; 18520,20.8651556346871; 18525,20.8652954289096; 18530,20.8662461053124; 18535,20.868065423174; 18540,20.8708111417726; 18545,20.8745410203868; 18550,20.8793128182948; 18555,20.8820462899807; 18560,20.8859159960004; 18565,
        20.892196516695; 18570,20.8939624695183; 18575,20.8956479342655; 18580,20.8976448682906; 18585,20.8998335672784; 18590,20.9043826957399; 18595,20.909746469169; 18600,20.9138160937125; 18605,20.9165408341722; 18610,20.9178699553498; 18615,20.9177527220472; 18620,20.9161383990659; 18625,20.9181018392792; 18630,20.9212646954379; 18635,20.9245471495353; 18640,20.9279882579069; 18645,20.9316270768879; 18650,20.9355026628138; 18655,20.9371379244238; 18660,20.9377145411795; 18665,20.9377767454467; 18670,20.9373195149595; 18675,20.9363378274525; 18680,20.9348266606599; 18685,20.9327809923161; 18690,20.9301958001555; 18695,20.9270660619125; 18700,20.9233867553213; 18705,20.9191528581164; 18710,20.9143593480321; 18715,20.9090012028028; 18720,20.9030734001628; 18725,20.8965709178466; 18730,20.8897264922147; 18735,20.8869007974862; 18740,20.8853756903412; 18745,20.8847238866907; 18750,20.8821488466488; 18755,20.8799242018682; 18760,20.8800639762466; 18765,20.8825582541941; 18770,
        20.8836603185875; 18775,20.8852267726723; 18780,20.8876307138899; 18785,20.8908010198028; 18790,20.8946665679733; 18795,20.8991562359635; 18800,20.904198901336; 18805,20.9097234416529; 18810,20.9166993152587; 18815,20.9237468654702; 18820,20.9307488640869; 18825,20.9376538780156; 18830,20.9444104741628; 18835,20.9509672194353; 18840,20.9572726807398; 18845,20.9632754249829; 18850,20.9689240190714; 18855,20.9741670299118; 18860,20.9789530244108; 18865,20.9832305694753; 18870,20.9869482320117; 18875,20.9900545789268; 18880,20.9924981771274; 18885,20.9942275935199; 18890,20.9951913950112; 18895,20.9955703891239; 18900,20.9950609332182; 18905,20.9935496147776; 18910,20.9909900906689; 18915,20.9873360177583; 18920,20.9825410529126; 18925,20.9765588529982; 18930,20.9739760332153; 18935,20.9724725553954; 18940,20.9711984542467; 18945,20.9701862713428; 18950,20.9693662663865; 18955,20.9683785951304; 18960,20.9676022074951; 18965,20.9670618827849; 18970,20.9667824003039; 18975,
        20.9667885393564; 18980,20.9673519706895; 18985,20.9702848392167; 18990,20.9715023566195; 18995,20.9720022897744; 19000,20.9718357171861; 19005,20.9710537173592; 19010,20.9697073687982; 19015,20.9678477500078; 19020,20.9655259394926; 19025,20.9627930157571; 19030,20.959700057306; 19035,20.9562981426439; 19040,20.9526383502754; 19045,20.9487717587051; 19050,20.9447494464376; 19055,20.9397678816562; 19060,20.9320316995461; 19065,20.9254383834633; 19070,20.9199704280076; 19075,20.915237722358; 19080,20.9114991662939; 19085,20.9087321644552; 19090,20.9069141214819; 19095,20.9060224420139; 19100,20.9060345306911; 19105,20.9069277921535; 19110,20.9086796310409; 19115,20.9112674519933; 19120,20.9146233101934; 19125,20.9186266297157; 19130,20.9234589226958; 19135,20.9265857512793; 19140,20.9310842201293; 19145,20.9371050627675; 19150,20.9459332991722; 19155,20.9570584106993; 19160,20.9678238129292; 19165,20.9777222036453; 19170,20.986760647418; 19175,20.9948923514309; 19180,
        21.0020705228675; 19185,21.0082483689115; 19190,21.0133790967463; 19195,21.0174159135554; 19200,21.0203120265226; 19205,21.0220206428313; 19210,21.0224949696651; 19215,21.0216882142076; 19220,21.0195535836423; 19225,21.0160442851528; 19230,21.0111135259227; 19235,21.0065716006769; 19240,21.0041884219373; 19245,21.001567073371; 19250,20.9997478807502; 19255,20.9976465229978; 19260,20.9950129688432; 19265,20.9918913323463; 19270,20.9883257275669; 19275,20.9843602685649; 19280,20.9800390694002; 19285,20.9754029302884; 19290,20.9704429598231; 19295,20.9652041894641; 19300,20.9598506634104; 19305,20.9545429291989; 19310,20.9496308212875; 19315,20.9480106728456; 19320,20.9474233489599; 19325,20.947989424648; 19330,20.9475920551008; 19335,20.9467362448796; 19340,20.9460215721519; 19345,20.9442343504915; 19350,20.9425538482611; 19355,20.9410120908381; 19360,20.9396397189919; 19365,20.9384972995078; 19370,20.937645973667; 19375,20.9370905493701; 19380,20.9367899542965; 19385,
        20.9367350788044; 19390,20.9329274358714; 19395,20.930684345837; 19400,20.9299816744494; 19405,20.9307473322108; 19410,20.9329092296233; 19415,20.9363952771891; 19420,20.9411787348677; 19425,20.9508966182005; 19430,20.9589239742005; 19435,20.9664698752825; 19440,20.9735088442472; 19445,20.9800154038953; 19450,20.9859640770275; 19455,20.9913293864446; 19460,20.9960858549473; 19465,21.0002186894154; 19470,21.0037791984932; 19475,21.0067766983841; 19480,21.009212118059; 19485,21.0110877074479; 19490,21.0124070702821; 19495,21.0131750971513; 19500,21.0133980245746; 19505,21.0130616334233; 19510,21.0120977823411; 19515,21.0104987548408; 19520,21.0091900691666; 19525,21.0099171714137; 19530,21.0089855015605; 19535,21.0064745524723; 19540,21.0024651495138; 19545,20.996983134061; 19550,20.9900562277734; 19555,20.9817468659424; 19560,20.9721406481525; 19565,20.960638452851; 19570,20.9532899902349; 19575,20.9467580058537; 19580,20.9411471033789; 19585,20.9365618864819; 19590,
        20.9331069588338; 19595,20.9308869241063; 19600,20.929047449555; 19605,20.9242960024347; 19610,20.9197758677177; 19615,20.9155227138053; 19620,20.911572209099; 19625,20.9079600219999; 19630,20.9075107894121; 19635,20.9070378328058; 19640,20.9060836959266; 19645,20.9047417919482; 19650,20.9031055340445; 19655,20.9012683353893; 19660,20.8993236091564; 19665,20.8973647685197; 19670,20.8954852266529; 19675,20.8937783967299; 19680,20.8923376919245; 19685,20.8912565254105; 19690,20.8906283103618; 19695,20.8905464599521; 19700,20.8892000334641; 19705,20.8850777026346; 19710,20.8804900095736; 19715,20.8754634742936; 19720,20.870024616807; 19725,20.8641999571263; 19730,20.8580160152639; 19735,20.8514993112324; 19740,20.8448130745974; 19745,20.8398296232906; 19750,20.8353039460167; 19755,20.8312867135034; 19760,20.8278285964782; 19765,20.8249802656686; 19770,20.823835636064; 19775,20.8233124320253; 19780,20.8231829075301; 19785,20.8235205978313; 19790,20.8243990381816; 19795,
        20.8258917638337; 19800,20.8280723100403; 19805,20.8326459335406; 19810,20.836809477746; 19815,20.8392301310523; 19820,20.8400175870905; 19825,20.8377406036744; 19830,20.8324506218463; 19835,20.8269254316521; 19840,20.8212099530349; 19845,20.816718708226; 19850,20.8131124160354; 19855,20.8086333179028; 19860,20.8033760567802; 19865,20.7974352756194; 19870,20.7909056173725; 19875,20.7838817249914; 19880,20.776458241428; 19885,20.7687298096344; 19890,20.7607910725624; 19895,20.7527366731641; 19900,20.7446612543914; 19905,20.7366594591962; 19910,20.7288259305306; 19915,20.7212553113464; 19920,20.714560092978; 19925,20.7084507694435; 19930,20.7030290577397; 19935,20.6983770328045; 19940,20.6945539736396; 19945,20.69175000164; 19950,20.6883914827957; 19955,20.6858201929691; 19960,20.6841134083239; 19965,20.6833484050237; 19970,20.6836024592322; 19975,20.6849528471131; 19980,20.6866277313366; 19985,20.6831277132552; 19990,20.6777953762692; 19995,20.6732193463918])
    annotation (Placement(transformation(extent={{-440,-40},{-420,-20}})));
  Modelica.Blocks.Sources.TimeTable timeTableTempAir_concat(table=[0,575.15; 4499,575.15; 4500,575.760260009766; 4501,575.761419677734; 4502,575.762609863281; 4503,575.763800048828; 4504,575.764990234375; 4505,575.766149902344; 4506,575.767340087891; 4507,575.768530273438; 4508,575.769720458984; 4509,575.770880126953; 4510,575.7720703125; 4511,575.773260498047; 4512,575.774450683594; 4513,575.775610351563; 4514,575.776800537109; 4515,575.777990722656; 4516,575.779150390625; 4517,575.780340576172; 4518,575.781530761719; 4519,575.782720947266; 4520,575.783880615234; 4521,575.785070800781; 4522,575.786260986328; 4523,575.787451171875; 4524,575.788610839844; 4525,575.789801025391; 4526,575.790991210938; 4527,575.792181396484; 4528,575.793341064453; 4529,575.79453125; 4530,575.795721435547; 4531,575.796911621094; 4532,575.798071289063; 4533,575.799261474609; 4534,575.800451660156; 4535,575.801641845703; 4536,575.802801513672; 4537,575.803991699219; 4538,575.805181884766; 4539,
        575.806372070313; 4540,575.807531738281; 4541,575.808721923828; 4542,575.809912109375; 4543,575.811071777344; 4544,575.812261962891; 4545,575.813452148438; 4546,575.814642333984; 4547,575.815802001953; 4548,575.8169921875; 4549,575.818182373047; 4550,575.819372558594; 4551,575.820532226563; 4552,575.821722412109; 4553,575.822912597656; 4554,575.824102783203; 4555,575.825262451172; 4556,575.826452636719; 4557,575.827642822266; 4558,575.828833007813; 4559,575.829992675781; 4560,575.831182861328; 4561,575.832373046875; 4562,575.833563232422; 4563,575.834722900391; 4564,575.835913085938; 4565,575.837103271484; 4566,575.838293457031; 4567,575.839453125; 4568,575.840643310547; 4569,575.841833496094; 4570,575.843023681641; 4571,575.844183349609; 4572,575.845373535156; 4573,575.846563720703; 4574,575.847723388672; 4575,575.848913574219; 4576,575.850103759766; 4577,575.851293945313; 4578,575.852453613281; 4579,575.853643798828; 4580,575.854833984375; 4581,575.856024169922; 4582,
        575.857183837891; 4583,575.858374023438; 4584,575.859564208984; 4585,575.860754394531; 4586,575.8619140625; 4587,575.863104248047; 4588,575.864294433594; 4589,575.865484619141; 4590,575.866644287109; 4591,575.867834472656; 4592,575.869024658203; 4593,575.87021484375; 4594,575.871374511719; 4595,575.872564697266; 4596,575.873754882813; 4597,575.874945068359; 4598,575.876104736328; 4599,575.877294921875; 4600,575.878485107422; 4601,575.879675292969; 4602,575.880834960938; 4603,575.882025146484; 4604,575.883215332031; 4605,575.884375; 4606,575.885565185547; 4607,575.886755371094; 4608,575.887945556641; 4609,575.889105224609; 4610,575.890295410156; 4611,575.891485595703; 4612,575.89267578125; 4613,575.893835449219; 4614,575.895025634766; 4615,575.896215820313; 4616,575.897406005859; 4617,575.898565673828; 4618,575.899755859375; 4619,575.900946044922; 4620,575.902136230469; 4621,575.903295898438; 4622,575.904486083984; 4623,575.905676269531; 4624,575.906866455078; 4625,
        575.908026123047; 4626,575.909216308594; 4627,575.910406494141; 4628,575.911596679688; 4629,575.912756347656; 4630,575.913946533203; 4631,575.91513671875; 4632,575.916296386719; 4633,575.917486572266; 4634,575.918676757813; 4635,575.919866943359; 4636,575.921026611328; 4637,575.922216796875; 4638,575.923406982422; 4639,575.924597167969; 4640,575.925756835938; 4641,575.926947021484; 4642,575.928137207031; 4643,575.929327392578; 4644,575.930487060547; 4645,575.931677246094; 4646,575.932867431641; 4647,575.934057617188; 4648,575.935217285156; 4649,575.936407470703; 4650,575.93759765625; 4651,575.938787841797; 4652,575.939947509766; 4653,575.941137695313; 4654,575.942327880859; 4655,575.943518066406; 4656,575.944677734375; 4657,575.945867919922; 4658,575.947058105469; 4659,575.948248291016; 4660,575.949407958984; 4661,575.950598144531; 4662,575.951788330078; 4663,575.952947998047; 4664,575.954138183594; 4665,575.955328369141; 4666,575.956518554688; 4667,575.957678222656; 4668,
        575.958868408203; 4669,575.96005859375; 4670,575.961248779297; 4671,575.962408447266; 4672,575.963598632813; 4673,575.964788818359; 4674,575.965979003906; 4675,575.967138671875; 4676,575.968328857422; 4677,575.969519042969; 4678,575.970709228516; 4679,575.971868896484; 4680,575.973059082031; 4681,575.974249267578; 4682,575.975439453125; 4683,575.976599121094; 4684,575.977789306641; 4685,575.978979492188; 4686,575.980169677734; 4687,575.981329345703; 4688,575.98251953125; 4689,575.983709716797; 4690,575.984899902344; 4691,575.986059570313; 4692,575.987249755859; 4693,575.988439941406; 4694,575.989599609375; 4695,575.990789794922; 4696,575.991979980469; 4697,575.993170166016; 4698,575.994329833984; 4699,575.995520019531; 4700,575.996710205078; 4701,575.997900390625; 4702,575.999060058594; 4703,576.000250244141; 4704,576.001440429688; 4705,576.002630615234; 4706,576.003790283203; 4707,576.00498046875; 4708,576.006170654297; 4709,576.007360839844; 4710,576.008520507813; 4711,
        576.009710693359; 4712,576.010900878906; 4713,576.012091064453; 4714,576.013250732422; 4715,576.014440917969; 4716,576.015631103516; 4717,576.016821289063; 4718,576.017980957031; 4719,576.019171142578; 4720,576.020361328125; 4721,576.021520996094; 4722,576.022711181641; 4723,576.023901367188; 4724,576.025091552734; 4725,576.026251220703; 4726,576.02744140625; 4727,576.028631591797; 4728,576.029821777344; 4729,576.030981445313; 4730,576.032171630859; 4731,576.033361816406; 4732,576.034552001953; 4733,576.035711669922; 4734,576.036901855469; 4735,576.038092041016; 4736,576.039282226563; 4737,576.040441894531; 4738,576.041632080078; 4739,576.042822265625; 4740,576.044012451172; 4741,576.045172119141; 4742,576.046362304688; 4743,576.047552490234; 4744,576.048742675781; 4745,576.04990234375; 4746,576.051092529297; 4747,576.052282714844; 4748,576.053472900391; 4749,576.054632568359; 4750,576.055822753906; 4751,576.057012939453; 4752,576.058172607422; 4753,576.059362792969; 4754,
        576.060552978516; 4755,576.061743164063; 4756,576.062902832031; 4757,576.064093017578; 4758,576.065283203125; 4759,576.066473388672; 4760,576.067633056641; 4761,576.068823242188; 4762,576.070013427734; 4763,576.071203613281; 4764,576.07236328125; 4765,576.073553466797; 4766,576.074743652344; 4767,576.075933837891; 4768,576.077093505859; 4769,576.078283691406; 4770,576.079473876953; 4771,576.0806640625; 4772,576.081823730469; 4773,576.083013916016; 4774,576.084204101563; 4775,576.085394287109; 4776,576.086553955078; 4777,576.087744140625; 4778,576.088934326172; 4779,576.090093994141; 4780,576.091284179688; 4781,576.092474365234; 4782,576.093664550781; 4783,576.09482421875; 4784,576.096014404297; 4785,576.097204589844; 4786,576.098394775391; 4787,576.099554443359; 4788,576.100744628906; 4789,576.101934814453; 4790,576.103125; 4791,576.104284667969; 4792,576.105474853516; 4793,576.106665039063; 4794,576.107855224609; 4795,576.109014892578; 4796,576.110205078125; 4797,
        576.111395263672; 4798,576.112585449219; 4799,576.113745117188; 4800,576.114935302734; 4801,576.116125488281; 4802,576.117315673828; 4803,576.118475341797; 4804,576.119665527344; 4805,576.120855712891; 4806,576.122045898438; 4807,576.123205566406; 4808,576.124395751953; 4809,576.1255859375; 4810,576.126745605469; 4811,576.127935791016; 4812,576.129125976563; 4813,576.130316162109; 4814,576.131475830078; 4815,576.132666015625; 4816,576.133856201172; 4817,576.135046386719; 4818,576.136206054688; 4819,576.137396240234; 4820,576.138586425781; 4821,576.139776611328; 4822,576.140936279297; 4823,576.142126464844; 4824,576.143316650391; 4825,576.144506835938; 4826,576.145666503906; 4827,576.146856689453; 4828,576.148046875; 4829,576.149237060547; 4830,576.150396728516; 4831,576.151586914063; 4832,576.152777099609; 4833,576.153967285156; 4834,576.155126953125; 4835,576.156317138672; 4836,576.157507324219; 4837,576.158697509766; 4838,576.159857177734; 4839,576.161047363281; 4840,
        576.162237548828; 4841,576.163397216797; 4842,576.164587402344; 4843,576.165777587891; 4844,576.166967773438; 4845,576.168127441406; 4846,576.169317626953; 4847,576.1705078125; 4848,576.171697998047; 4849,576.172857666016; 4850,576.174047851563; 4851,576.175238037109; 4852,576.176428222656; 4853,576.177587890625; 4854,576.178778076172; 4855,576.179968261719; 4856,576.181158447266; 4857,576.182318115234; 4858,576.183508300781; 4859,576.184698486328; 4860,576.185888671875; 4861,576.187048339844; 4862,576.188238525391; 4863,576.189428710938; 4864,576.190618896484; 4865,576.191778564453; 4866,576.19296875; 4867,576.194158935547; 4868,576.195318603516; 4869,576.196508789063; 4870,576.197698974609; 4871,576.198889160156; 4872,576.200048828125; 4873,576.201239013672; 4874,576.202429199219; 4875,576.203619384766; 4876,576.204779052734; 4877,576.205969238281; 4878,576.207159423828; 4879,576.208349609375; 4880,576.209509277344; 4881,576.210699462891; 4882,576.211889648438; 4883,
        576.213079833984; 4884,576.214239501953; 4885,576.2154296875; 4886,576.216619873047; 4887,576.217810058594; 4888,576.218969726563; 4889,576.220159912109; 4890,576.221350097656; 4891,576.222540283203; 4892,576.223699951172; 4893,576.224890136719; 4894,576.226080322266; 4895,576.227270507813; 4896,576.228430175781; 4897,576.229620361328; 4898,576.230810546875; 4899,576.231970214844; 4900,576.233160400391; 4901,576.234350585938; 4902,576.235540771484; 4903,576.236700439453; 4904,576.237890625; 4905,576.239080810547; 4906,576.240270996094; 4907,576.241430664063; 4908,576.242620849609; 4909,576.243811035156; 4910,576.245001220703; 4911,576.246160888672; 4912,576.247351074219; 4913,576.248541259766; 4914,576.249731445313; 4915,576.250891113281; 4916,576.252081298828; 4917,576.253271484375; 4918,576.254461669922; 4919,576.255621337891; 4920,576.256811523438; 4921,576.258001708984; 4922,576.259191894531; 4923,576.2603515625; 4924,576.261541748047; 4925,576.262731933594; 4926,
        576.263922119141; 4927,576.265081787109; 4928,576.266271972656; 4929,576.267462158203; 4930,576.268621826172; 4931,576.269812011719; 4932,576.271002197266; 4933,576.272192382813; 4934,576.273352050781; 4935,576.274542236328; 4936,576.275732421875; 4937,576.276922607422; 4938,576.278082275391; 4939,576.279272460938; 4940,576.280462646484; 4941,576.281652832031; 4942,576.2828125; 4943,576.284002685547; 4944,576.285192871094; 4945,576.286383056641; 4946,576.287542724609; 4947,576.288732910156; 4948,576.289923095703; 4949,576.29111328125; 4950,576.292272949219; 4951,576.293463134766; 4952,576.294653320313; 4953,576.295843505859; 4954,576.297003173828; 4955,576.298193359375; 4956,576.299383544922; 4957,576.300543212891; 4958,576.301733398438; 4959,576.302923583984; 4960,576.304113769531; 4961,576.3052734375; 4962,576.306463623047; 4963,576.307653808594; 4964,576.308843994141; 4965,576.310003662109; 4966,576.311193847656; 4967,576.312384033203; 4968,576.31357421875; 4969,
        576.314733886719; 4970,576.315924072266; 4971,576.317114257813; 4972,576.318304443359; 4973,576.319464111328; 4974,576.320654296875; 4975,576.321844482422; 4976,576.323034667969; 4977,576.324194335938; 4978,576.325384521484; 4979,576.326574707031; 4980,576.327764892578; 4981,576.328924560547; 4982,576.330114746094; 4983,576.331304931641; 4984,576.332495117188; 4985,576.333654785156; 4986,576.334844970703; 4987,576.33603515625; 4988,576.337194824219; 4989,576.338385009766; 4990,576.339575195313; 4991,576.340765380859; 4992,576.341925048828; 4993,576.343115234375; 4994,576.344305419922; 4995,576.345495605469; 4996,576.346655273438; 4997,576.347845458984; 4998,576.349035644531; 4999,576.342687988281; 5000,576.31650390625; 5001,576.290319824219; 5002,576.264135742188; 5003,576.237951660156; 5004,576.211767578125; 5005,576.185583496094; 5006,576.159399414063; 5007,576.133215332031; 5008,576.10703125; 5009,576.080816650391; 5010,576.054632568359; 5011,576.028448486328; 5012,
        576.002264404297; 5013,575.976080322266; 5014,575.949896240234; 5015,575.923712158203; 5016,575.897528076172; 5017,575.871343994141; 5018,575.845129394531; 5019,575.8189453125; 5020,575.792761230469; 5021,575.766577148438; 5022,575.740393066406; 5023,575.714208984375; 5024,575.688024902344; 5025,575.661840820313; 5026,575.635656738281; 5027,575.609442138672; 5028,575.583258056641; 5029,575.557073974609; 5030,575.530889892578; 5031,575.504705810547; 5032,575.478521728516; 5033,575.452337646484; 5034,575.426153564453; 5035,575.399969482422; 5036,575.373785400391; 5037,575.347570800781; 5038,575.32138671875; 5039,575.295202636719; 5040,575.269018554688; 5041,575.242834472656; 5042,575.216650390625; 5043,575.190466308594; 5044,575.164282226563; 5045,575.138098144531; 5046,575.111883544922; 5047,575.085699462891; 5048,575.059515380859; 5049,575.033331298828; 5050,575.007147216797; 5051,574.980963134766; 5052,574.954779052734; 5053,574.928594970703; 5054,574.902410888672; 5055,
        574.876196289063; 5056,574.850012207031; 5057,574.823828125; 5058,574.797644042969; 5059,574.771459960938; 5060,574.745275878906; 5061,574.719091796875; 5062,574.692907714844; 5063,574.666723632813; 5064,574.640539550781; 5065,574.614324951172; 5066,574.588140869141; 5067,574.561956787109; 5068,574.535772705078; 5069,574.509588623047; 5070,574.483404541016; 5071,574.457220458984; 5072,574.431036376953; 5073,574.404852294922; 5074,574.378637695313; 5075,574.352453613281; 5076,574.32626953125; 5077,574.300085449219; 5078,574.273901367188; 5079,574.247717285156; 5080,574.221533203125; 5081,574.195349121094; 5082,574.169165039063; 5083,574.142950439453; 5084,574.116766357422; 5085,574.090582275391; 5086,574.064398193359; 5087,574.016668701172; 5088,573.942449951172; 5089,573.868231201172; 5090,573.794012451172; 5091,573.719793701172; 5092,573.645574951172; 5093,573.571356201172; 5094,573.497137451172; 5095,573.422918701172; 5096,573.348699951172; 5097,573.274481201172; 5098,
        573.200262451172; 5099,573.126043701172; 5100,573.05185546875; 5101,572.97763671875; 5102,572.90341796875; 5103,572.82919921875; 5104,572.75498046875; 5105,572.68076171875; 5106,572.60654296875; 5107,572.53232421875; 5108,572.45810546875; 5109,572.38388671875; 5110,572.30966796875; 5111,572.23544921875; 5112,572.16123046875; 5113,572.08701171875; 5114,572.01279296875; 5115,571.93857421875; 5116,571.86435546875; 5117,571.79013671875; 5118,571.71591796875; 5119,571.64169921875; 5120,571.56748046875; 5121,571.49326171875; 5122,571.41904296875; 5123,571.34482421875; 5124,571.27060546875; 5125,571.19638671875; 5126,571.122198486328; 5127,571.047979736328; 5128,570.973760986328; 5129,570.899542236328; 5130,570.825323486328; 5131,570.751104736328; 5132,570.676885986328; 5133,570.602667236328; 5134,570.528448486328; 5135,570.454229736328; 5136,570.380010986328; 5137,570.305792236328; 5138,570.231573486328; 5139,570.157354736328; 5140,570.083135986328; 5141,570.008917236328; 5142,
        569.934698486328; 5143,569.860479736328; 5144,569.786260986328; 5145,569.712042236328; 5146,569.637823486328; 5147,569.563604736328; 5148,569.489385986328; 5149,569.415167236328; 5150,569.340948486328; 5151,569.266760253906; 5152,569.192541503906; 5153,569.118322753906; 5154,569.044104003906; 5155,568.969885253906; 5156,568.895666503906; 5157,568.821447753906; 5158,568.747229003906; 5159,568.673010253906; 5160,568.598791503906; 5161,568.524572753906; 5162,568.450354003906; 5163,568.376135253906; 5164,568.301916503906; 5165,568.227697753906; 5166,568.153479003906; 5167,568.079260253906; 5168,568.005041503906; 5169,567.930822753906; 5170,567.856604003906; 5171,567.782385253906; 5172,567.708166503906; 5173,567.633947753906; 5174,567.559729003906; 5175,567.485510253906; 5176,567.411322021484; 5177,567.337103271484; 5178,567.262884521484; 5179,567.188665771484; 5180,567.114447021484; 5181,567.040228271484; 5182,566.966009521484; 5183,566.891790771484; 5184,566.817572021484; 5185,
        566.743353271484; 5186,566.669134521484; 5187,566.594915771484; 5188,566.520697021484; 5189,566.446478271484; 5190,566.372259521484; 5191,566.298040771484; 5192,566.223822021484; 5193,566.149603271484; 5194,566.075384521484; 5195,566.001165771484; 5196,565.926947021484; 5197,565.852728271484; 5198,565.778509521484; 5199,565.704290771484; 5200,565.630072021484; 5201,565.555853271484; 5202,565.481665039063; 5203,565.407446289063; 5204,565.333227539063; 5205,565.259008789063; 5206,565.184790039063; 5207,565.110571289063; 5208,565.036352539063; 5209,564.962133789063; 5210,564.887915039063; 5211,564.813696289063; 5212,564.739477539063; 5213,564.665258789063; 5214,564.591040039063; 5215,564.516821289063; 5216,564.442602539063; 5217,564.368383789063; 5218,564.294165039063; 5219,564.219946289063; 5220,564.145727539063; 5221,564.071508789063; 5222,563.997290039063; 5223,563.923071289063; 5224,563.848852539063; 5225,563.774633789063; 5226,563.700415039063; 5227,563.626226806641; 5228,
        563.552008056641; 5229,563.477789306641; 5230,563.403570556641; 5231,563.329351806641; 5232,563.255133056641; 5233,563.180914306641; 5234,563.106695556641; 5235,563.032476806641; 5236,562.958258056641; 5237,562.884039306641; 5238,562.809820556641; 5239,562.735601806641; 5240,562.661383056641; 5241,562.587164306641; 5242,562.512945556641; 5243,562.438726806641; 5244,562.364508056641; 5245,562.290289306641; 5246,562.216070556641; 5247,562.141851806641; 5248,562.067633056641; 5249,561.993414306641; 5250,561.919195556641; 5251,561.844976806641; 5252,561.770788574219; 5253,561.696569824219; 5254,561.622351074219; 5255,561.548132324219; 5256,561.473913574219; 5257,561.399694824219; 5258,561.325476074219; 5259,561.251257324219; 5260,561.177038574219; 5261,561.102819824219; 5262,561.028601074219; 5263,560.954382324219; 5264,560.896765136719; 5265,560.885015869141; 5266,560.873297119141; 5267,560.861578369141; 5268,560.849829101563; 5269,560.838110351563; 5270,560.826361083984; 5271,
        560.814642333984; 5272,560.802893066406; 5273,560.791174316406; 5274,560.779455566406; 5275,560.767706298828; 5276,560.755987548828; 5277,560.74423828125; 5278,560.73251953125; 5279,560.72080078125; 5280,560.709051513672; 5281,560.697332763672; 5282,560.685583496094; 5283,560.673864746094; 5284,560.662115478516; 5285,560.650396728516; 5286,560.638677978516; 5287,560.626928710938; 5288,560.615209960938; 5289,560.603460693359; 5290,560.591741943359; 5291,560.579992675781; 5292,560.568273925781; 5293,560.556555175781; 5294,560.544805908203; 5295,560.533087158203; 5296,560.521337890625; 5297,560.509619140625; 5298,560.497869873047; 5299,560.486151123047; 5300,560.474432373047; 5301,560.462683105469; 5302,560.450964355469; 5303,560.439215087891; 5304,560.427496337891; 5305,560.415777587891; 5306,560.404028320313; 5307,560.392309570313; 5308,560.380560302734; 5309,560.368841552734; 5310,560.357092285156; 5311,560.345373535156; 5312,560.333654785156; 5313,560.321905517578; 5314,
        560.310186767578; 5315,560.2984375; 5316,560.28671875; 5317,560.274969482422; 5318,560.263250732422; 5319,560.251531982422; 5320,560.239782714844; 5321,560.228063964844; 5322,560.216314697266; 5323,560.204595947266; 5324,560.192846679688; 5325,560.181127929688; 5326,560.169409179688; 5327,560.157659912109; 5328,560.145941162109; 5329,560.134191894531; 5330,560.122473144531; 5331,560.110754394531; 5332,560.099005126953; 5333,560.087286376953; 5334,560.075537109375; 5335,560.063818359375; 5336,560.052069091797; 5337,560.040350341797; 5338,560.028631591797; 5339,560.016882324219; 5340,560.005163574219; 5341,559.993414306641; 5342,559.981695556641; 5343,559.969946289063; 5344,559.958227539063; 5345,559.946508789063; 5346,559.934759521484; 5347,559.923040771484; 5348,559.911291503906; 5349,559.899572753906; 5350,559.887823486328; 5351,559.876104736328; 5352,559.864385986328; 5353,559.85263671875; 5354,559.84091796875; 5355,559.829168701172; 5356,559.817449951172; 5357,
        559.805700683594; 5358,559.793981933594; 5359,559.782263183594; 5360,559.770513916016; 5361,559.758795166016; 5362,559.747045898438; 5363,559.735327148438; 5364,559.723608398438; 5365,559.711859130859; 5366,559.700140380859; 5367,559.688391113281; 5368,559.676672363281; 5369,559.664923095703; 5370,559.653204345703; 5371,559.641485595703; 5372,559.629736328125; 5373,559.618017578125; 5374,559.606268310547; 5375,559.594549560547; 5376,559.582800292969; 5377,559.571081542969; 5378,559.559362792969; 5379,559.547613525391; 5380,559.535894775391; 5381,559.524145507813; 5382,559.512426757813; 5383,559.500677490234; 5384,559.488958740234; 5385,559.477239990234; 5386,559.465490722656; 5387,559.453771972656; 5388,559.442022705078; 5389,559.430303955078; 5390,559.418585205078; 5391,559.4068359375; 5392,559.3951171875; 5393,559.383367919922; 5394,559.371649169922; 5395,559.359899902344; 5396,559.348181152344; 5397,559.336462402344; 5398,559.324713134766; 5399,559.312994384766; 5400,
        559.301245117188; 5401,559.289526367188; 5402,559.277777099609; 5403,559.266058349609; 5404,559.254339599609; 5405,559.242590332031; 5406,559.230871582031; 5407,559.219122314453; 5408,559.207403564453; 5409,559.195654296875; 5410,559.183935546875; 5411,559.172216796875; 5412,559.160467529297; 5413,559.148748779297; 5414,559.136999511719; 5415,559.125280761719; 5416,559.113562011719; 5417,559.101812744141; 5418,559.090093994141; 5419,559.078344726563; 5420,559.066625976563; 5421,559.054876708984; 5422,559.043157958984; 5423,559.031439208984; 5424,559.019689941406; 5425,559.007971191406; 5426,558.996221923828; 5427,558.984503173828; 5428,558.97275390625; 5429,558.96103515625; 5430,558.94931640625; 5431,558.937567138672; 5432,558.925848388672; 5433,558.914099121094; 5434,558.902380371094; 5435,558.890631103516; 5436,558.878912353516; 5437,558.867193603516; 5438,558.855444335938; 5439,558.843725585938; 5440,558.831976318359; 5441,558.820257568359; 5442,558.808538818359; 5443,
        558.796789550781; 5444,558.785070800781; 5445,558.773321533203; 5446,558.761602783203; 5447,558.749853515625; 5448,558.738134765625; 5449,558.726416015625; 5450,558.714666748047; 5451,558.702947998047; 5452,558.691198730469; 5453,558.679479980469; 5454,558.667730712891; 5455,558.656011962891; 5456,558.644293212891; 5457,558.632543945313; 5458,558.620825195313; 5459,558.609075927734; 5460,558.597357177734; 5461,558.585607910156; 5462,558.573889160156; 5463,558.562170410156; 5464,558.550421142578; 5465,558.538702392578; 5466,558.526953125; 5467,558.515234375; 5468,558.503485107422; 5469,558.491766357422; 5470,558.480047607422; 5471,558.468298339844; 5472,558.456579589844; 5473,558.444830322266; 5474,558.433111572266; 5475,558.421392822266; 5476,558.409643554688; 5477,558.397924804688; 5478,558.386175537109; 5479,558.374456787109; 5480,558.362707519531; 5481,558.350988769531; 5482,558.339270019531; 5483,558.327520751953; 5484,558.315802001953; 5485,558.304052734375; 5486,
        558.292333984375; 5487,558.280584716797; 5488,558.268865966797; 5489,558.257147216797; 5490,558.245397949219; 5491,558.233679199219; 5492,558.221929931641; 5493,558.210211181641; 5494,558.198461914063; 5495,558.186743164063; 5496,558.175024414063; 5497,558.163275146484; 5498,558.151556396484; 5499,558.139807128906; 5500,558.128088378906; 5501,558.116369628906; 5502,558.104620361328; 5503,558.092901611328; 5504,558.08115234375; 5505,558.06943359375; 5506,558.057684326172; 5507,558.045965576172; 5508,558.034246826172; 5509,558.022497558594; 5510,558.010778808594; 5511,557.999029541016; 5512,557.987310791016; 5513,557.975561523438; 5514,557.963842773438; 5515,557.952124023438; 5516,557.940374755859; 5517,557.928656005859; 5518,557.916906738281; 5519,557.905187988281; 5520,557.893438720703; 5521,557.881719970703; 5522,557.870001220703; 5523,557.858251953125; 5524,557.853216552734; 5525,557.864813232422; 5526,557.876409912109; 5527,557.887976074219; 5528,557.899572753906; 5529,
        557.911169433594; 5530,557.922766113281; 5531,557.934362792969; 5532,557.945959472656; 5533,557.957556152344; 5534,557.969122314453; 5535,557.980718994141; 5536,557.992315673828; 5537,558.003912353516; 5538,558.015509033203; 5539,558.027105712891; 5540,558.038671875; 5541,558.050268554688; 5542,558.061865234375; 5543,558.073461914063; 5544,558.08505859375; 5545,558.096655273438; 5546,558.108251953125; 5547,558.119818115234; 5548,558.131414794922; 5549,558.143011474609; 5550,558.154608154297; 5551,558.166204833984; 5552,558.177801513672; 5553,558.189398193359; 5554,558.200964355469; 5555,558.212561035156; 5556,558.224157714844; 5557,558.235754394531; 5558,558.247351074219; 5559,558.258947753906; 5560,558.270513916016; 5561,558.282110595703; 5562,558.293707275391; 5563,558.305303955078; 5564,558.316900634766; 5565,558.328497314453; 5566,558.340093994141; 5567,558.35166015625; 5568,558.363256835938; 5569,558.374853515625; 5570,558.386450195313; 5571,558.398046875; 5572,
        558.409643554688; 5573,558.421240234375; 5574,558.432806396484; 5575,558.444403076172; 5576,558.455999755859; 5577,558.467596435547; 5578,558.479193115234; 5579,558.490789794922; 5580,558.502355957031; 5581,558.513952636719; 5582,558.525549316406; 5583,558.537145996094; 5584,558.548742675781; 5585,558.560339355469; 5586,558.571936035156; 5587,558.583502197266; 5588,558.595098876953; 5589,558.606695556641; 5590,558.618292236328; 5591,558.629888916016; 5592,558.641485595703; 5593,558.653051757813; 5594,558.6646484375; 5595,558.676245117188; 5596,558.687841796875; 5597,558.699438476563; 5598,558.71103515625; 5599,558.722631835938; 5600,558.734197998047; 5601,558.745794677734; 5602,558.757391357422; 5603,558.768988037109; 5604,558.780584716797; 5605,558.792181396484; 5606,558.803778076172; 5607,558.815344238281; 5608,558.826940917969; 5609,558.838537597656; 5610,558.850134277344; 5611,558.861730957031; 5612,558.873327636719; 5613,558.884893798828; 5614,558.896490478516; 5615,
        558.908087158203; 5616,558.919683837891; 5617,558.931280517578; 5618,558.942877197266; 5619,558.954473876953; 5620,558.966040039063; 5621,558.97763671875; 5622,558.989233398438; 5623,559.000830078125; 5624,559.012426757813; 5625,559.0240234375; 5626,559.035589599609; 5627,559.047186279297; 5628,559.058782958984; 5629,559.070379638672; 5630,559.081976318359; 5631,559.093572998047; 5632,559.105169677734; 5633,559.116735839844; 5634,559.128332519531; 5635,559.139929199219; 5636,559.151525878906; 5637,559.163122558594; 5638,559.174719238281; 5639,559.186315917969; 5640,559.197882080078; 5641,559.209478759766; 5642,559.221075439453; 5643,559.232672119141; 5644,559.244268798828; 5645,559.255865478516; 5646,559.267431640625; 5647,559.279028320313; 5648,559.290625; 5649,559.302221679688; 5650,559.313818359375; 5651,559.325415039063; 5652,559.33701171875; 5653,559.348577880859; 5654,559.360174560547; 5655,559.371771240234; 5656,559.383367919922; 5657,559.394964599609; 5658,
        559.406561279297; 5659,559.418127441406; 5660,559.429724121094; 5661,559.441320800781; 5662,559.470343017578; 5663,559.5494140625; 5664,559.628515625; 5665,559.7076171875; 5666,559.786688232422; 5667,559.865789794922; 5668,559.944860839844; 5669,560.023962402344; 5670,560.103033447266; 5671,560.182135009766; 5672,560.261206054688; 5673,560.340307617188; 5674,560.419409179688; 5675,560.498480224609; 5676,560.577581787109; 5677,560.656652832031; 5678,560.735754394531; 5679,560.814825439453; 5680,560.893927001953; 5681,560.972998046875; 5682,561.052099609375; 5683,561.131201171875; 5684,561.210272216797; 5685,561.289373779297; 5686,561.368444824219; 5687,561.447546386719; 5688,561.526617431641; 5689,561.605718994141; 5690,561.684790039063; 5691,561.763891601563; 5692,561.842962646484; 5693,561.922064208984; 5694,562.001165771484; 5695,562.080236816406; 5696,562.159338378906; 5697,562.238409423828; 5698,562.317510986328; 5699,562.39658203125; 5700,562.47568359375; 5701,
        562.554754638672; 5702,562.633856201172; 5703,562.712957763672; 5704,562.792028808594; 5705,562.871130371094; 5706,562.950201416016; 5707,563.029302978516; 5708,563.108374023438; 5709,563.187475585938; 5710,563.266546630859; 5711,563.345648193359; 5712,563.424749755859; 5713,563.503820800781; 5714,563.582922363281; 5715,563.661993408203; 5716,563.741094970703; 5717,563.820166015625; 5718,563.899267578125; 5719,563.978338623047; 5720,564.057440185547; 5721,564.136541748047; 5722,564.215612792969; 5723,564.294714355469; 5724,564.373785400391; 5725,564.452886962891; 5726,564.531958007813; 5727,564.611059570313; 5728,564.690130615234; 5729,564.769232177734; 5730,564.848303222656; 5731,564.927404785156; 5732,565.006506347656; 5733,565.085577392578; 5734,565.164678955078; 5735,565.24375; 5736,565.3228515625; 5737,565.401922607422; 5738,565.481024169922; 5739,565.560095214844; 5740,565.639196777344; 5741,565.718298339844; 5742,565.797369384766; 5743,565.876470947266; 5744,
        565.955541992188; 5745,566.034643554688; 5746,566.113714599609; 5747,566.192816162109; 5748,566.271887207031; 5749,566.350988769531; 5750,566.430090332031; 5751,566.509161376953; 5752,566.588262939453; 5753,566.667333984375; 5754,566.746435546875; 5755,566.825506591797; 5756,566.904608154297; 5757,566.983679199219; 5758,567.062780761719; 5759,567.141882324219; 5760,567.220953369141; 5761,567.300054931641; 5762,567.379125976563; 5763,567.458227539063; 5764,567.537298583984; 5765,567.616400146484; 5766,567.695471191406; 5767,567.774572753906; 5768,567.853643798828; 5769,567.932745361328; 5770,568.011846923828; 5771,568.09091796875; 5772,568.17001953125; 5773,568.249090576172; 5774,568.328192138672; 5775,568.407263183594; 5776,568.486364746094; 5777,568.565435791016; 5778,568.644537353516; 5779,568.723638916016; 5780,568.802709960938; 5781,568.881811523438; 5782,568.960882568359; 5783,569.039984130859; 5784,569.119055175781; 5785,569.198156738281; 5786,569.277227783203; 5787,
        569.356329345703; 5788,569.435430908203; 5789,569.514501953125; 5790,569.593603515625; 5791,569.672674560547; 5792,569.751776123047; 5793,569.830847167969; 5794,569.909948730469; 5795,569.989019775391; 5796,570.068121337891; 5797,570.147222900391; 5798,570.226293945313; 5799,570.305395507813; 5800,570.384466552734; 5801,570.463568115234; 5802,570.542639160156; 5803,570.621740722656; 5804,570.700811767578; 5805,570.779913330078; 5806,570.858984375; 5807,570.9380859375; 5808,571.0171875; 5809,571.096258544922; 5810,571.175360107422; 5811,571.254431152344; 5812,571.333532714844; 5813,571.412603759766; 5814,571.491705322266; 5815,571.570776367188; 5816,571.649877929688; 5817,571.728979492188; 5818,571.808050537109; 5819,571.887152099609; 5820,571.966223144531; 5821,572.045324707031; 5822,572.124395751953; 5823,572.203497314453; 5824,572.282568359375; 5825,572.361669921875; 5826,572.440771484375; 5827,572.519842529297; 5828,572.598944091797; 5829,572.661901855469; 5830,
        572.695532226563; 5831,572.729193115234; 5832,572.762823486328; 5833,572.796484375; 5834,572.830145263672; 5835,572.863775634766; 5836,572.897436523438; 5837,572.931097412109; 5838,572.964727783203; 5839,572.998388671875; 5840,573.032019042969; 5841,573.065679931641; 5842,573.099340820313; 5843,573.132971191406; 5844,573.166632080078; 5845,573.20029296875; 5846,573.233923339844; 5847,573.267584228516; 5848,573.301214599609; 5849,573.334875488281; 5850,573.368536376953; 5851,573.402166748047; 5852,573.435827636719; 5853,573.469488525391; 5854,573.503118896484; 5855,573.536779785156; 5856,573.57041015625; 5857,573.604071044922; 5858,573.637731933594; 5859,573.671362304688; 5860,573.705023193359; 5861,573.738684082031; 5862,573.772314453125; 5863,573.805975341797; 5864,573.839605712891; 5865,573.873266601563; 5866,573.906927490234; 5867,573.940557861328; 5868,573.97421875; 5869,574.007879638672; 5870,574.041510009766; 5871,574.075170898438; 5872,574.108801269531; 5873,
        574.142462158203; 5874,574.176123046875; 5875,574.209753417969; 5876,574.243414306641; 5877,574.277044677734; 5878,574.310705566406; 5879,574.344366455078; 5880,574.377996826172; 5881,574.411657714844; 5882,574.445318603516; 5883,574.478948974609; 5884,574.512609863281; 5885,574.546240234375; 5886,574.579901123047; 5887,574.613562011719; 5888,574.647192382813; 5889,574.680853271484; 5890,574.714514160156; 5891,574.74814453125; 5892,574.781805419922; 5893,574.815435791016; 5894,574.849096679688; 5895,574.882757568359; 5896,574.916387939453; 5897,574.950048828125; 5898,574.983709716797; 5899,575.017340087891; 5900,575.051000976563; 5901,575.084631347656; 5902,575.118292236328; 5903,575.151953125; 5904,575.185583496094; 5905,575.219244384766; 5906,575.252905273438; 5907,575.286535644531; 5908,575.320196533203; 5909,575.353826904297; 5910,575.387487792969; 5911,575.421148681641; 5912,575.454779052734; 5913,575.488439941406; 5914,575.522100830078; 5915,575.555731201172; 5916,
        575.589392089844; 5917,575.623022460938; 5918,575.656683349609; 5919,575.690344238281; 5920,575.723974609375; 5921,575.757635498047; 5922,575.791296386719; 5923,575.824926757813; 5924,575.858587646484; 5925,575.892218017578; 5926,575.92587890625; 5927,575.959539794922; 5928,575.993170166016; 5929,576.026831054688; 5930,576.060491943359; 5931,576.094122314453; 5932,576.127783203125; 5933,576.149481201172; 5934,576.148138427734; 5935,576.146765136719; 5936,576.145422363281; 5937,576.144049072266; 5938,576.142706298828; 5939,576.141363525391; 5940,576.139990234375; 5941,576.138647460938; 5942,576.1373046875; 5943,576.135931396484; 5944,576.134588623047; 5945,576.133245849609; 5946,576.131872558594; 5947,576.130529785156; 5948,576.129187011719; 5949,576.127813720703; 5950,576.126470947266; 5951,576.125128173828; 5952,576.123754882813; 5953,576.122412109375; 5954,576.121038818359; 5955,576.119696044922; 5956,576.118353271484; 5957,576.116979980469; 5958,576.115637207031; 5959,
        576.114294433594; 5960,576.112921142578; 5961,576.111578369141; 5962,576.110235595703; 5963,576.108862304688; 5964,576.10751953125; 5965,576.106176757813; 5966,576.104803466797; 5967,576.103460693359; 5968,576.102117919922; 5969,576.100744628906; 5970,576.099401855469; 5971,576.098059082031; 5972,576.096685791016; 5973,576.095343017578; 5974,576.093969726563; 5975,576.092626953125; 5976,576.091284179688; 5977,576.089910888672; 5978,576.088568115234; 5979,576.087225341797; 5980,576.085852050781; 5981,576.084509277344; 5982,576.083166503906; 5983,576.081793212891; 5984,576.080450439453; 5985,576.079107666016; 5986,576.077734375; 5987,576.076391601563; 5988,576.075048828125; 5989,576.073675537109; 5990,576.072332763672; 5991,576.070989990234; 5992,576.069616699219; 5993,576.068273925781; 5994,576.066900634766; 5995,576.065557861328; 5996,576.064215087891; 5997,576.062841796875; 5998,576.061499023438; 5999,576.06015625; 6000,576.058782958984; 6001,576.057440185547; 6002,
        576.056097412109; 6003,576.054724121094; 6004,576.053381347656; 6005,576.052038574219; 6006,576.050665283203; 6007,576.049322509766; 6008,576.047979736328; 6009,576.046606445313; 6010,576.045263671875; 6011,576.043920898438; 6012,576.042547607422; 6013,576.041204833984; 6014,576.039831542969; 6015,576.038488769531; 6016,576.037145996094; 6017,576.035772705078; 6018,576.034429931641; 6019,576.033087158203; 6020,576.031713867188; 6021,576.03037109375; 6022,576.029028320313; 6023,576.027655029297; 6024,576.026312255859; 6025,576.024969482422; 6026,576.023596191406; 6027,576.022253417969; 6028,576.020910644531; 6029,576.019537353516; 6030,576.018194580078; 6031,576.016851806641; 6032,576.015478515625; 6033,576.014135742188; 6034,576.012762451172; 6035,576.011419677734; 6036,576.010076904297; 6037,576.008703613281; 6038,576.007360839844; 6039,576.006018066406; 6040,576.004644775391; 6041,576.003302001953; 6042,576.001959228516; 6043,576.0005859375; 6044,575.999243164063; 6045,
        575.997900390625; 6046,575.996527099609; 6047,575.995184326172; 6048,575.993841552734; 6049,575.992468261719; 6050,575.991125488281; 6051,575.989782714844; 6052,575.988409423828; 6053,575.987066650391; 6054,575.985693359375; 6055,575.984350585938; 6056,575.9830078125; 6057,575.981634521484; 6058,575.980291748047; 6059,575.978948974609; 6060,575.977575683594; 6061,575.976232910156; 6062,575.974890136719; 6063,575.973516845703; 6064,575.972174072266; 6065,575.970831298828; 6066,575.969458007813; 6067,575.968115234375; 6068,575.966772460938; 6069,575.965399169922; 6070,575.964056396484; 6071,575.962713623047; 6072,575.961340332031; 6073,575.959997558594; 6074,575.958624267578; 6075,575.957281494141; 6076,575.955938720703; 6077,575.954565429688; 6078,575.95322265625; 6079,575.951879882813; 6080,575.950506591797; 6081,575.949163818359; 6082,575.947821044922; 6083,575.946447753906; 6084,575.945104980469; 6085,575.943762207031; 6086,575.942388916016; 6087,575.941046142578; 6088,
        575.939703369141; 6089,575.938330078125; 6090,575.936987304688; 6091,575.935614013672; 6092,575.934271240234; 6093,575.932928466797; 6094,575.931555175781; 6095,575.930212402344; 6096,575.928869628906; 6097,575.927496337891; 6098,575.926153564453; 6099,575.924810791016; 6100,575.9234375; 6101,575.922094726563; 6102,575.920751953125; 6103,575.919378662109; 6104,575.918035888672; 6105,575.916693115234; 6106,575.915319824219; 6107,575.913977050781; 6108,575.912634277344; 6109,575.911260986328; 6110,575.909918212891; 6111,575.908544921875; 6112,575.907202148438; 6113,575.905859375; 6114,575.904486083984; 6115,575.903143310547; 6116,575.901800537109; 6117,575.900427246094; 6118,575.899084472656; 6119,575.897741699219; 6120,575.896368408203; 6121,575.895025634766; 6122,575.893682861328; 6123,575.892309570313; 6124,575.890966796875; 6125,575.889624023438; 6126,575.888250732422; 6127,575.886907958984; 6128,575.885565185547; 6129,575.884191894531; 6130,575.882849121094; 6131,
        575.881475830078; 6132,575.880133056641; 6133,575.878790283203; 6134,575.877416992188; 6135,575.87607421875; 6136,575.874731445313; 6137,575.873358154297; 6138,575.872015380859; 6139,575.870672607422; 6140,575.869299316406; 6141,575.867956542969; 6142,575.866613769531; 6143,575.865240478516; 6144,575.863897705078; 6145,575.862554931641; 6146,575.861181640625; 6147,575.859838867188; 6148,575.85849609375; 6149,575.857122802734; 6150,575.855780029297; 6151,575.854406738281; 6152,575.853063964844; 6153,575.851721191406; 6154,575.850347900391; 6155,575.849005126953; 6156,575.847662353516; 6157,575.8462890625; 6158,575.844946289063; 6159,575.843603515625; 6160,575.842230224609; 6161,575.840887451172; 6162,575.839544677734; 6163,575.838171386719; 6164,575.836828613281; 6165,575.835485839844; 6166,575.834112548828; 6167,575.832769775391; 6168,575.831427001953; 6169,575.830053710938; 6170,575.8287109375; 6171,575.827337646484; 6172,575.825994873047; 6173,575.824652099609; 6174,
        575.823278808594; 6175,575.821936035156; 6176,575.820593261719; 6177,575.819219970703; 6178,575.817877197266; 6179,575.816534423828; 6180,575.815161132813; 6181,575.813818359375; 6182,575.812475585938; 6183,575.811102294922; 6184,575.809759521484; 6185,575.808416748047; 6186,575.807043457031; 6187,575.805700683594; 6188,575.804357910156; 6189,575.802984619141; 6190,575.801641845703; 6191,575.800268554688; 6192,575.79892578125; 6193,575.797583007813; 6194,575.796209716797; 6195,575.794866943359; 6196,575.793524169922; 6197,575.792150878906; 6198,575.790808105469; 6199,575.789465332031; 6200,575.788092041016; 6201,575.786749267578; 6202,575.785406494141; 6203,575.784033203125; 6204,575.782690429688; 6205,575.78134765625; 6206,575.779974365234; 6207,575.778631591797; 6208,575.777288818359; 6209,575.775915527344; 6210,575.774572753906; 6211,575.773199462891; 6212,575.771856689453; 6213,575.770513916016; 6214,575.769140625; 6215,575.767797851563; 6216,575.766455078125; 6217,
        575.765081787109; 6218,575.763739013672; 6219,575.762396240234; 6220,575.761022949219; 6221,575.759680175781; 6222,575.758337402344; 6223,575.756964111328; 6224,575.755621337891; 6225,575.754278564453; 6226,575.752905273438; 6227,575.7515625; 6228,575.750189208984; 6229,575.748846435547; 6230,575.747503662109; 6231,575.746130371094; 6232,575.744787597656; 6233,575.743444824219; 6234,575.742071533203; 6235,575.740728759766; 6236,575.739385986328; 6237,575.738012695313; 6238,575.736669921875; 6239,575.735327148438; 6240,575.733953857422; 6241,575.732611083984; 6242,575.731268310547; 6243,575.729895019531; 6244,575.728552246094; 6245,575.727209472656; 6246,575.725836181641; 6247,575.724493408203; 6248,575.723120117188; 6249,575.72177734375; 6250,575.720434570313; 6251,575.719061279297; 6252,575.717718505859; 6253,575.716375732422; 6254,575.715002441406; 6255,575.713659667969; 6256,575.712316894531; 6257,575.710943603516; 6258,575.709600830078; 6259,575.708258056641; 6260,
        575.706884765625; 6261,575.705541992188; 6262,575.70419921875; 6263,575.702825927734; 6264,575.701483154297; 6265,575.700140380859; 6266,575.698767089844; 6267,575.697424316406; 6268,575.696051025391; 6269,575.694708251953; 6270,575.693365478516; 6271,575.6919921875; 6272,575.690649414063; 6273,575.689306640625; 6274,575.687933349609; 6275,575.686590576172; 6276,575.685247802734; 6277,575.683874511719; 6278,575.682531738281; 6279,575.681188964844; 6280,575.679815673828; 6281,575.678472900391; 6282,575.677130126953; 6283,575.675756835938; 6284,575.6744140625; 6285,575.673071289063; 6286,575.671697998047; 6287,575.670355224609; 6288,575.668981933594; 6289,575.667639160156; 6290,575.666296386719; 6291,575.664923095703; 6292,575.663580322266; 6293,575.662237548828; 6294,575.660864257813; 6295,575.659521484375; 6296,575.658178710938; 6297,575.656805419922; 6298,575.655462646484; 6299,575.654119873047; 6300,575.15; 9499,575.15; 9500,572.830145263672; 9501,572.863775634766; 9502,
        572.897436523438; 9503,572.931097412109; 9504,572.964727783203; 9505,572.998388671875; 9506,573.032019042969; 9507,573.065679931641; 9508,573.099340820313; 9509,573.132971191406; 9510,573.166632080078; 9511,573.20029296875; 9512,573.233923339844; 9513,573.267584228516; 9514,573.301214599609; 9515,573.334875488281; 9516,573.368536376953; 9517,573.402166748047; 9518,573.435827636719; 9519,573.469488525391; 9520,573.503118896484; 9521,573.536779785156; 9522,573.57041015625; 9523,573.604071044922; 9524,573.637731933594; 9525,573.671362304688; 9526,573.705023193359; 9527,573.738684082031; 9528,573.772314453125; 9529,573.805975341797; 9530,573.839605712891; 9531,573.873266601563; 9532,573.906927490234; 9533,573.940557861328; 9534,573.97421875; 9535,574.007879638672; 9536,574.041510009766; 9537,574.075170898438; 9538,574.108801269531; 9539,574.142462158203; 9540,574.176123046875; 9541,574.209753417969; 9542,574.243414306641; 9543,574.277044677734; 9544,574.310705566406; 9545,
        574.344366455078; 9546,574.377996826172; 9547,574.411657714844; 9548,574.445318603516; 9549,574.478948974609; 9550,574.512609863281; 9551,574.546240234375; 9552,574.579901123047; 9553,574.613562011719; 9554,574.647192382813; 9555,574.680853271484; 9556,574.714514160156; 9557,574.74814453125; 9558,574.781805419922; 9559,574.815435791016; 9560,574.849096679688; 9561,574.882757568359; 9562,574.916387939453; 9563,574.950048828125; 9564,574.983709716797; 9565,575.017340087891; 9566,575.051000976563; 9567,575.084631347656; 9568,575.118292236328; 9569,575.151953125; 9570,575.185583496094; 9571,575.219244384766; 9572,575.252905273438; 9573,575.286535644531; 9574,575.320196533203; 9575,575.353826904297; 9576,575.387487792969; 9577,575.421148681641; 9578,575.454779052734; 9579,575.488439941406; 9580,575.522100830078; 9581,575.555731201172; 9582,575.589392089844; 9583,575.623022460938; 9584,575.656683349609; 9585,575.690344238281; 9586,575.723974609375; 9587,575.757635498047; 9588,
        575.791296386719; 9589,575.824926757813; 9590,575.858587646484; 9591,575.892218017578; 9592,575.92587890625; 9593,575.959539794922; 9594,575.993170166016; 9595,576.026831054688; 9596,576.060491943359; 9597,576.094122314453; 9598,576.127783203125; 9599,576.149481201172; 9600,576.148138427734; 9601,576.146765136719; 9602,576.145422363281; 9603,576.144049072266; 9604,576.142706298828; 9605,576.141363525391; 9606,576.139990234375; 9607,576.138647460938; 9608,576.1373046875; 9609,576.135931396484; 9610,576.134588623047; 9611,576.133245849609; 9612,576.131872558594; 9613,576.130529785156; 9614,576.129187011719; 9615,576.127813720703; 9616,576.126470947266; 9617,576.125128173828; 9618,576.123754882813; 9619,576.122412109375; 9620,576.121038818359; 9621,576.119696044922; 9622,576.118353271484; 9623,576.116979980469; 9624,576.115637207031; 9625,576.114294433594; 9626,576.112921142578; 9627,576.111578369141; 9628,576.110235595703; 9629,576.108862304688; 9630,576.10751953125; 9631,
        576.106176757813; 9632,576.104803466797; 9633,576.103460693359; 9634,576.102117919922; 9635,576.100744628906; 9636,576.099401855469; 9637,576.098059082031; 9638,576.096685791016; 9639,576.095343017578; 9640,576.093969726563; 9641,576.092626953125; 9642,576.091284179688; 9643,576.089910888672; 9644,576.088568115234; 9645,576.087225341797; 9646,576.085852050781; 9647,576.084509277344; 9648,576.083166503906; 9649,576.081793212891; 9650,576.080450439453; 9651,576.079107666016; 9652,576.077734375; 9653,576.076391601563; 9654,576.075048828125; 9655,576.073675537109; 9656,576.072332763672; 9657,576.070989990234; 9658,576.069616699219; 9659,576.068273925781; 9660,576.066900634766; 9661,576.065557861328; 9662,576.064215087891; 9663,576.062841796875; 9664,576.061499023438; 9665,576.06015625; 9666,576.058782958984; 9667,576.057440185547; 9668,576.056097412109; 9669,576.054724121094; 9670,576.053381347656; 9671,576.052038574219; 9672,576.050665283203; 9673,576.049322509766; 9674,
        576.047979736328; 9675,576.046606445313; 9676,576.045263671875; 9677,576.043920898438; 9678,576.042547607422; 9679,576.041204833984; 9680,576.039831542969; 9681,576.038488769531; 9682,576.037145996094; 9683,576.035772705078; 9684,576.034429931641; 9685,576.033087158203; 9686,576.031713867188; 9687,576.03037109375; 9688,576.029028320313; 9689,576.027655029297; 9690,576.026312255859; 9691,576.024969482422; 9692,576.023596191406; 9693,576.022253417969; 9694,576.020910644531; 9695,576.019537353516; 9696,576.018194580078; 9697,576.016851806641; 9698,576.015478515625; 9699,576.014135742188; 9700,576.012762451172; 9701,576.011419677734; 9702,576.010076904297; 9703,576.008703613281; 9704,576.007360839844; 9705,576.006018066406; 9706,576.004644775391; 9707,576.003302001953; 9708,576.001959228516; 9709,576.0005859375; 9710,575.999243164063; 9711,575.997900390625; 9712,575.996527099609; 9713,575.995184326172; 9714,575.993841552734; 9715,575.992468261719; 9716,575.991125488281; 9717,
        575.989782714844; 9718,575.988409423828; 9719,575.987066650391; 9720,575.985693359375; 9721,575.984350585938; 9722,575.9830078125; 9723,575.981634521484; 9724,575.980291748047; 9725,575.978948974609; 9726,575.977575683594; 9727,575.976232910156; 9728,575.974890136719; 9729,575.973516845703; 9730,575.972174072266; 9731,575.970831298828; 9732,575.969458007813; 9733,575.968115234375; 9734,575.966772460938; 9735,575.965399169922; 9736,575.964056396484; 9737,575.962713623047; 9738,575.961340332031; 9739,575.959997558594; 9740,575.958624267578; 9741,575.957281494141; 9742,575.955938720703; 9743,575.954565429688; 9744,575.95322265625; 9745,575.951879882813; 9746,575.950506591797; 9747,575.949163818359; 9748,575.947821044922; 9749,575.946447753906; 9750,575.945104980469; 9751,575.943762207031; 9752,575.942388916016; 9753,575.941046142578; 9754,575.939703369141; 9755,575.938330078125; 9756,575.936987304688; 9757,575.935614013672; 9758,575.934271240234; 9759,575.932928466797; 9760,
        575.931555175781; 9761,575.930212402344; 9762,575.928869628906; 9763,575.927496337891; 9764,575.926153564453; 9765,575.924810791016; 9766,575.9234375; 9767,575.922094726563; 9768,575.920751953125; 9769,575.919378662109; 9770,575.918035888672; 9771,575.916693115234; 9772,575.915319824219; 9773,575.913977050781; 9774,575.912634277344; 9775,575.911260986328; 9776,575.909918212891; 9777,575.908544921875; 9778,575.907202148438; 9779,575.905859375; 9780,575.904486083984; 9781,575.903143310547; 9782,575.901800537109; 9783,575.900427246094; 9784,575.899084472656; 9785,575.897741699219; 9786,575.896368408203; 9787,575.895025634766; 9788,575.893682861328; 9789,575.892309570313; 9790,575.890966796875; 9791,575.889624023438; 9792,575.888250732422; 9793,575.886907958984; 9794,575.885565185547; 9795,575.884191894531; 9796,575.882849121094; 9797,575.881475830078; 9798,575.880133056641; 9799,575.878790283203; 9800,575.877416992188; 9801,575.87607421875; 9802,575.874731445313; 9803,
        575.873358154297; 9804,575.872015380859; 9805,575.870672607422; 9806,575.869299316406; 9807,575.867956542969; 9808,575.866613769531; 9809,575.865240478516; 9810,575.863897705078; 9811,575.862554931641; 9812,575.861181640625; 9813,575.859838867188; 9814,575.85849609375; 9815,575.857122802734; 9816,575.855780029297; 9817,575.854406738281; 9818,575.853063964844; 9819,575.851721191406; 9820,575.850347900391; 9821,575.849005126953; 9822,575.847662353516; 9823,575.8462890625; 9824,575.844946289063; 9825,575.843603515625; 9826,575.842230224609; 9827,575.840887451172; 9828,575.839544677734; 9829,575.838171386719; 9830,575.836828613281; 9831,575.835485839844; 9832,575.834112548828; 9833,575.832769775391; 9834,575.831427001953; 9835,575.830053710938; 9836,575.8287109375; 9837,575.827337646484; 9838,575.825994873047; 9839,575.824652099609; 9840,575.823278808594; 9841,575.821936035156; 9842,575.820593261719; 9843,575.819219970703; 9844,575.817877197266; 9845,575.816534423828; 9846,
        575.815161132813; 9847,575.813818359375; 9848,575.812475585938; 9849,575.811102294922; 9850,575.809759521484; 9851,575.808416748047; 9852,575.807043457031; 9853,575.805700683594; 9854,575.804357910156; 9855,575.802984619141; 9856,575.801641845703; 9857,575.800268554688; 9858,575.79892578125; 9859,575.797583007813; 9860,575.796209716797; 9861,575.794866943359; 9862,575.793524169922; 9863,575.792150878906; 9864,575.790808105469; 9865,575.789465332031; 9866,575.788092041016; 9867,575.786749267578; 9868,575.785406494141; 9869,575.784033203125; 9870,575.782690429688; 9871,575.78134765625; 9872,575.779974365234; 9873,575.778631591797; 9874,575.777288818359; 9875,575.775915527344; 9876,575.774572753906; 9877,575.773199462891; 9878,575.771856689453; 9879,575.770513916016; 9880,575.769140625; 9881,575.767797851563; 9882,575.766455078125; 9883,575.765081787109; 9884,575.763739013672; 9885,575.762396240234; 9886,575.761022949219; 9887,575.759680175781; 9888,575.758337402344; 9889,
        575.756964111328; 9890,575.755621337891; 9891,575.754278564453; 9892,575.752905273438; 9893,575.7515625; 9894,575.750189208984; 9895,575.748846435547; 9896,575.747503662109; 9897,575.746130371094; 9898,575.744787597656; 9899,575.743444824219; 9900,575.742071533203; 9901,575.740728759766; 9902,575.739385986328; 9903,575.738012695313; 9904,575.736669921875; 9905,575.735327148438; 9906,575.733953857422; 9907,575.732611083984; 9908,575.731268310547; 9909,575.729895019531; 9910,575.728552246094; 9911,575.727209472656; 9912,575.725836181641; 9913,575.724493408203; 9914,575.723120117188; 9915,575.72177734375; 9916,575.720434570313; 9917,575.719061279297; 9918,575.717718505859; 9919,575.716375732422; 9920,575.715002441406; 9921,575.713659667969; 9922,575.712316894531; 9923,575.710943603516; 9924,575.709600830078; 9925,575.708258056641; 9926,575.706884765625; 9927,575.705541992188; 9928,575.70419921875; 9929,575.702825927734; 9930,575.701483154297; 9931,575.700140380859; 9932,
        575.698767089844; 9933,575.697424316406; 9934,575.696051025391; 9935,575.694708251953; 9936,575.693365478516; 9937,575.6919921875; 9938,575.690649414063; 9939,575.689306640625; 9940,575.687933349609; 9941,575.686590576172; 9942,575.685247802734; 9943,575.683874511719; 9944,575.682531738281; 9945,575.681188964844; 9946,575.679815673828; 9947,575.678472900391; 9948,575.677130126953; 9949,575.675756835938; 9950,575.6744140625; 9951,575.673071289063; 9952,575.671697998047; 9953,575.670355224609; 9954,575.668981933594; 9955,575.667639160156; 9956,575.666296386719; 9957,575.664923095703; 9958,575.663580322266; 9959,575.662237548828; 9960,575.660864257813; 9961,575.659521484375; 9962,575.658178710938; 9963,575.656805419922; 9964,575.655462646484; 9965,575.654119873047; 9966,575.652746582031; 9967,575.651403808594; 9968,575.650061035156; 9969,575.648687744141; 9970,575.647344970703; 9971,575.646002197266; 9972,575.64462890625; 9973,575.643286132813; 9974,575.641912841797; 9975,
        575.640570068359; 9976,575.639227294922; 9977,575.637854003906; 9978,575.636511230469; 9979,575.635168457031; 9980,575.633795166016; 9981,575.632452392578; 9982,575.631109619141; 9983,575.629736328125; 9984,575.628393554688; 9985,575.62705078125; 9986,575.625677490234; 9987,575.624334716797; 9988,575.622991943359; 9989,575.621618652344; 9990,575.620275878906; 9991,575.618933105469; 9992,575.617559814453; 9993,575.616217041016; 9994,575.61484375; 9995,575.613500976563; 9996,575.612158203125; 9997,575.610784912109; 9998,575.609442138672; 9999,575.608099365234; 10000,575.606726074219; 10001,575.605383300781; 10002,575.604040527344; 10003,575.602667236328; 10004,575.601324462891; 10005,575.599981689453; 10006,575.598608398438; 10007,575.597265625; 10008,575.595922851563; 10009,575.594549560547; 10010,575.593206787109; 10011,575.591864013672; 10012,575.590490722656; 10013,575.589147949219; 10014,575.587774658203; 10015,575.586431884766; 10016,575.585089111328; 10017,
        575.583715820313; 10018,575.582373046875; 10019,575.581030273438; 10020,575.579656982422; 10021,575.578314208984; 10022,575.576971435547; 10023,575.575598144531; 10024,575.574255371094; 10025,575.572912597656; 10026,575.571539306641; 10027,575.570196533203; 10028,575.568853759766; 10029,575.56748046875; 10030,575.566137695313; 10031,575.564764404297; 10032,575.563421630859; 10033,575.562078857422; 10034,575.560705566406; 10035,575.559362792969; 10036,575.558020019531; 10037,575.556646728516; 10038,575.555303955078; 10039,575.553961181641; 10040,575.552587890625; 10041,575.551245117188; 10042,575.54990234375; 10043,575.548529052734; 10044,575.547186279297; 10045,575.545843505859; 10046,575.544470214844; 10047,575.543127441406; 10048,575.541784667969; 10049,575.540411376953; 10050,575.539068603516; 10051,575.5376953125; 10052,575.536352539063; 10053,575.535009765625; 10054,575.533636474609; 10055,575.532293701172; 10056,575.530950927734; 10057,575.529577636719; 10058,
        575.528234863281; 10059,575.526892089844; 10060,575.525518798828; 10061,575.524176025391; 10062,575.522833251953; 10063,575.521459960938; 10064,575.5201171875; 10065,575.518774414063; 10066,575.517401123047; 10067,575.516058349609; 10068,575.514715576172; 10069,575.513342285156; 10070,575.511999511719; 10071,575.510626220703; 10072,575.509283447266; 10073,575.507940673828; 10074,575.506567382813; 10075,575.505224609375; 10076,575.503881835938; 10077,575.502508544922; 10078,575.501165771484; 10079,575.499822998047; 10080,575.498449707031; 10081,575.497106933594; 10082,575.495764160156; 10083,575.494390869141; 10084,575.493048095703; 10085,575.491705322266; 10086,575.49033203125; 10087,575.488989257813; 10088,575.487646484375; 10089,575.486273193359; 10090,575.484930419922; 10091,575.483557128906; 10092,575.482214355469; 10093,575.480871582031; 10094,575.479498291016; 10095,575.478155517578; 10096,575.476812744141; 10097,575.475439453125; 10098,575.474096679688; 10099,
        575.47275390625; 10100,575.471380615234; 10101,575.470037841797; 10102,575.468695068359; 10103,575.467321777344; 10104,575.465979003906; 10105,575.464636230469; 10106,575.463262939453; 10107,575.461920166016; 10108,575.460577392578; 10109,575.459204101563; 10110,575.457861328125; 10111,575.456488037109; 10112,575.455145263672; 10113,575.453802490234; 10114,575.452429199219; 10115,575.451086425781; 10116,575.449743652344; 10117,575.448370361328; 10118,575.447027587891; 10119,575.445684814453; 10120,575.444311523438; 10121,575.44296875; 10122,575.441625976563; 10123,575.440252685547; 10124,575.438909912109; 10125,575.437567138672; 10126,575.436193847656; 10127,575.434851074219; 10128,575.433508300781; 10129,575.432135009766; 10130,575.430792236328; 10131,575.429418945313; 10132,575.428076171875; 10133,575.426733398438; 10134,575.425360107422; 10135,575.424017333984; 10136,575.422674560547; 10137,575.421301269531; 10138,575.419958496094; 10139,575.418615722656; 10140,
        575.417242431641; 10141,575.415899658203; 10142,575.414556884766; 10143,575.41318359375; 10144,575.411840820313; 10145,575.410498046875; 10146,575.409124755859; 10147,575.407781982422; 10148,575.406439208984; 10149,575.405065917969; 10150,575.403723144531; 10151,575.402349853516; 10152,575.401007080078; 10153,575.399664306641; 10154,575.398291015625; 10155,575.396948242188; 10156,575.39560546875; 10157,575.394232177734; 10158,575.392889404297; 10159,575.391546630859; 10160,575.390173339844; 10161,575.388830566406; 10162,575.387487792969; 10163,575.386114501953; 10164,575.384771728516; 10165,575.383428955078; 10166,575.382055664063; 10167,575.380712890625; 10168,575.379339599609; 10169,575.377996826172; 10170,575.376654052734; 10171,575.375280761719; 10172,575.373937988281; 10173,575.372595214844; 10174,575.371221923828; 10175,575.369879150391; 10176,575.368536376953; 10177,575.367163085938; 10178,575.3658203125; 10179,575.364477539063; 10180,575.363104248047; 10181,
        575.361761474609; 10182,575.360418701172; 10183,575.359045410156; 10184,575.357702636719; 10185,575.356359863281; 10186,575.354986572266; 10187,575.353643798828; 10188,575.352270507813; 10189,575.350927734375; 10190,575.347998046875; 10191,575.340826416016; 10192,575.333685302734; 10193,575.326544189453; 10194,575.319403076172; 10195,575.312261962891; 10196,575.305120849609; 10197,575.297979736328; 10198,575.290838623047; 10199,575.283697509766; 10200,575.276556396484; 10201,575.269415283203; 10202,575.262274169922; 10203,575.255133056641; 10204,575.247991943359; 10205,575.240850830078; 10206,575.233709716797; 10207,575.226538085938; 10208,575.219396972656; 10209,575.212255859375; 10210,575.205114746094; 10211,575.197973632813; 10212,575.190832519531; 10213,575.18369140625; 10214,575.176550292969; 10215,575.169409179688; 10216,575.162268066406; 10217,575.155126953125; 10218,575.147985839844; 10219,575.140844726563; 10220,575.133703613281; 10221,575.1265625; 10222,
        575.119421386719; 10223,575.112249755859; 10224,575.105108642578; 10225,575.097967529297; 10226,575.090826416016; 10227,575.083685302734; 10228,575.076544189453; 10229,575.069403076172; 10230,575.062261962891; 10231,575.055120849609; 10232,575.047979736328; 10233,575.040838623047; 10234,575.033697509766; 10235,575.026556396484; 10236,575.019415283203; 10237,575.012274169922; 10238,575.005102539063; 10239,574.997961425781; 10240,574.9908203125; 10241,574.983679199219; 10242,574.976538085938; 10243,574.969396972656; 10244,574.962255859375; 10245,574.955114746094; 10246,574.947973632813; 10247,574.940832519531; 10248,574.93369140625; 10249,574.926550292969; 10250,574.919409179688; 10251,574.912268066406; 10252,574.905126953125; 10253,574.897985839844; 10254,574.890814208984; 10255,574.883673095703; 10256,574.876531982422; 10257,574.869390869141; 10258,574.862249755859; 10259,574.855108642578; 10260,574.847967529297; 10261,574.840826416016; 10262,574.833685302734; 10263,
        574.826544189453; 10264,574.819403076172; 10265,574.812261962891; 10266,574.805120849609; 10267,574.797979736328; 10268,574.790838623047; 10269,574.783697509766; 10270,574.776525878906; 10271,574.769384765625; 10272,574.762243652344; 10273,574.755102539063; 10274,574.747961425781; 10275,574.7408203125; 10276,574.733679199219; 10277,574.726538085938; 10278,574.719396972656; 10279,574.712255859375; 10280,574.705114746094; 10281,574.697973632813; 10282,574.690832519531; 10283,574.68369140625; 10284,574.676550292969; 10285,574.669409179688; 10286,574.662237548828; 10287,574.655096435547; 10288,574.647955322266; 10289,574.640814208984; 10290,574.633673095703; 10291,574.626531982422; 10292,574.619390869141; 10293,574.612249755859; 10294,574.605108642578; 10295,574.597967529297; 10296,574.590826416016; 10297,574.583685302734; 10298,574.576544189453; 10299,574.569403076172; 10300,574.562261962891; 10301,574.555090332031; 10302,574.54794921875; 10303,574.540808105469; 10304,
        574.533666992188; 10305,574.526525878906; 10306,574.519384765625; 10307,574.512243652344; 10308,574.505102539063; 10309,574.497961425781; 10310,574.4908203125; 10311,574.483679199219; 10312,574.476538085938; 10313,574.469396972656; 10314,574.462255859375; 10315,574.455114746094; 10316,574.447973632813; 10317,574.440802001953; 10318,574.433660888672; 10319,574.426519775391; 10320,574.419378662109; 10321,574.412237548828; 10322,574.405096435547; 10323,574.397955322266; 10324,574.390814208984; 10325,574.383673095703; 10326,574.376531982422; 10327,574.369390869141; 10328,574.362249755859; 10329,574.355108642578; 10330,574.347967529297; 10331,574.340826416016; 10332,574.333685302734; 10333,574.326513671875; 10334,574.319372558594; 10335,574.312231445313; 10336,574.305090332031; 10337,574.299780273438; 10338,574.299078369141; 10339,574.298406982422; 10340,574.297735595703; 10341,574.297033691406; 10342,574.296362304688; 10343,574.295690917969; 10344,574.294989013672; 10345,
        574.294317626953; 10346,574.293646240234; 10347,574.292944335938; 10348,574.292272949219; 10349,574.291571044922; 10350,574.290899658203; 10351,574.290228271484; 10352,574.289526367188; 10353,574.288854980469; 10354,574.28818359375; 10355,574.287481689453; 10356,574.286810302734; 10357,574.286138916016; 10358,574.285437011719; 10359,574.284765625; 10360,574.284094238281; 10361,574.283392333984; 10362,574.282720947266; 10363,574.282049560547; 10364,574.28134765625; 10365,574.280676269531; 10366,574.279974365234; 10367,574.279302978516; 10368,574.278631591797; 10369,574.2779296875; 10370,574.277258300781; 10371,574.276586914063; 10372,574.275885009766; 10373,574.275213623047; 10374,574.274542236328; 10375,574.273840332031; 10376,574.273168945313; 10377,574.272497558594; 10378,574.271795654297; 10379,574.271124267578; 10380,574.270452880859; 10381,574.269750976563; 10382,574.269079589844; 10383,574.268377685547; 10384,574.267706298828; 10385,574.267034912109; 10386,
        574.266333007813; 10387,574.265661621094; 10388,574.264990234375; 10389,574.264288330078; 10390,574.263616943359; 10391,574.262945556641; 10392,574.262243652344; 10393,574.261572265625; 10394,574.260900878906; 10395,574.260198974609; 10396,574.259527587891; 10397,574.258856201172; 10398,574.258154296875; 10399,574.257482910156; 10400,574.256781005859; 10401,574.256109619141; 10402,574.255438232422; 10403,574.254736328125; 10404,574.254064941406; 10405,574.253393554688; 10406,574.252691650391; 10407,574.252020263672; 10408,574.251348876953; 10409,574.250646972656; 10410,574.249975585938; 10411,574.249304199219; 10412,574.248602294922; 10413,574.247930908203; 10414,574.247259521484; 10415,574.246557617188; 10416,574.245886230469; 10417,574.245184326172; 10418,574.244512939453; 10419,574.243841552734; 10420,574.243139648438; 10421,574.242468261719; 10422,574.241796875; 10423,574.241094970703; 10424,574.240423583984; 10425,574.239752197266; 10426,574.239050292969; 10427,
        574.23837890625; 10428,574.237707519531; 10429,574.237005615234; 10430,574.236334228516; 10431,574.235662841797; 10432,574.2349609375; 10433,574.234289550781; 10434,574.233587646484; 10435,574.232916259766; 10436,574.232244873047; 10437,574.23154296875; 10438,574.230871582031; 10439,574.230200195313; 10440,574.229498291016; 10441,574.228826904297; 10442,574.228155517578; 10443,574.227453613281; 10444,574.226782226563; 10445,574.226110839844; 10446,574.225408935547; 10447,574.224737548828; 10448,574.224035644531; 10449,574.223364257813; 10450,574.222692871094; 10451,574.221990966797; 10452,574.221319580078; 10453,574.220648193359; 10454,574.219946289063; 10455,574.219274902344; 10456,574.218603515625; 10457,574.217901611328; 10458,574.217230224609; 10459,574.216558837891; 10460,574.215856933594; 10461,574.215185546875; 10462,574.214514160156; 10463,574.213812255859; 10464,574.213140869141; 10465,574.212438964844; 10466,574.211767578125; 10467,574.211096191406; 10468,
        574.210394287109; 10469,574.209722900391; 10470,574.209051513672; 10471,574.208349609375; 10472,574.207678222656; 10473,574.207006835938; 10474,574.206304931641; 10475,574.205633544922; 10476,574.204962158203; 10477,574.204260253906; 10478,574.203588867188; 10479,574.202917480469; 10480,574.202215576172; 10481,574.201544189453; 10482,574.200842285156; 10483,574.200170898438; 10484,574.199499511719; 10485,574.198797607422; 10486,574.198126220703; 10487,574.197454833984; 10488,574.196752929688; 10489,574.196081542969; 10490,574.19541015625; 10491,574.194708251953; 10492,574.194036865234; 10493,574.193365478516; 10494,574.192663574219; 10495,574.1919921875; 10496,574.191320800781; 10497,574.190618896484; 10498,574.189947509766; 10499,574.189245605469; 10500,574.18857421875; 10501,574.187902832031; 10502,574.187200927734; 10503,574.186529541016; 10504,574.185858154297; 10505,574.18515625; 10506,574.184484863281; 10507,574.183813476563; 10508,574.183111572266; 10509,
        574.182440185547; 10510,574.181768798828; 10511,574.181066894531; 10512,574.180395507813; 10513,574.179724121094; 10514,574.179022216797; 10515,574.178350830078; 10516,574.177648925781; 10517,574.176977539063; 10518,574.176306152344; 10519,574.175604248047; 10520,574.174932861328; 10521,574.174261474609; 10522,574.173559570313; 10523,574.172888183594; 10524,574.172216796875; 10525,574.171514892578; 10526,574.170843505859; 10527,574.170172119141; 10528,574.169470214844; 10529,574.168798828125; 10530,574.168127441406; 10531,574.167425537109; 10532,574.166754150391; 10533,574.166052246094; 10534,574.165380859375; 10535,574.164709472656; 10536,574.164007568359; 10537,574.163336181641; 10538,574.162664794922; 10539,574.161962890625; 10540,574.161291503906; 10541,574.160620117188; 10542,574.159918212891; 10543,574.159246826172; 10544,574.158575439453; 10545,574.157873535156; 10546,574.157202148438; 10547,574.156530761719; 10548,574.155828857422; 10549,574.155157470703; 10550,
        574.154455566406; 10551,574.153784179688; 10552,574.153112792969; 10553,574.152410888672; 10554,574.151739501953; 10555,574.151068115234; 10556,574.150366210938; 10557,574.149694824219; 10558,574.1490234375; 10559,574.148321533203; 10560,574.147650146484; 10561,574.146978759766; 10562,574.146276855469; 10563,574.14560546875; 10564,574.144934082031; 10565,574.144232177734; 10566,574.143560791016; 10567,574.142858886719; 10568,574.1421875; 10569,574.141516113281; 10570,574.140814208984; 10571,574.140142822266; 10572,574.139471435547; 10573,574.13876953125; 10574,574.138098144531; 10575,574.137426757813; 10576,574.136724853516; 10577,574.136053466797; 10578,574.135382080078; 10579,574.134680175781; 10580,574.134008789063; 10581,574.133306884766; 10582,574.132635498047; 10583,574.131964111328; 10584,574.131262207031; 10585,574.130590820313; 10586,574.129919433594; 10587,574.129217529297; 10588,574.128546142578; 10589,574.127874755859; 10590,574.127172851563; 10591,574.126501464844;
        10592,574.125830078125; 10593,574.125128173828; 10594,574.124456787109; 10595,574.123785400391; 10596,574.123083496094; 10597,574.122412109375; 10598,574.121710205078; 10599,574.121038818359; 10600,574.120367431641; 10601,574.119665527344; 10602,574.118994140625; 10603,574.118322753906; 10604,574.117620849609; 10605,574.116949462891; 10606,574.116278076172; 10607,574.115576171875; 10608,574.114904785156; 10609,574.114233398438; 10610,574.113531494141; 10611,574.112860107422; 10612,574.112188720703; 10613,574.111486816406; 10614,574.110815429688; 10615,574.110113525391; 10616,574.109442138672; 10617,574.108770751953; 10618,574.108068847656; 10619,574.107397460938; 10620,574.106726074219; 10621,574.106024169922; 10622,574.105352783203; 10623,574.104681396484; 10624,574.103979492188; 10625,574.103308105469; 10626,574.10263671875; 10627,574.101934814453; 10628,574.101263427734; 10629,574.100592041016; 10630,574.099890136719; 10631,574.09921875; 10632,574.098516845703; 10633,
        574.097845458984; 10634,574.097174072266; 10635,574.096472167969; 10636,574.09580078125; 10637,574.095129394531; 10638,574.094427490234; 10639,574.093756103516; 10640,574.093084716797; 10641,574.0923828125; 10642,574.091711425781; 10643,574.091040039063; 10644,574.090338134766; 10645,574.089666748047; 10646,574.088995361328; 10647,574.088293457031; 10648,574.087622070313; 10649,574.086920166016; 10650,574.086248779297; 10651,574.085577392578; 10652,574.084875488281; 10653,574.084204101563; 10654,574.083532714844; 10655,574.082830810547; 10656,574.082159423828; 10657,574.081488037109; 10658,574.080786132813; 10659,574.080114746094; 10660,574.079443359375; 10661,574.078741455078; 10662,574.078070068359; 10663,574.077398681641; 10664,574.076696777344; 10665,574.076025390625; 10666,574.075323486328; 10667,574.074652099609; 10668,574.073980712891; 10669,574.073278808594; 10670,574.072607421875; 10671,574.071936035156; 10672,574.071234130859; 10673,574.070562744141; 10674,
        574.069891357422; 10675,574.069189453125; 10676,574.068518066406; 10677,574.067846679688; 10678,574.067144775391; 10679,574.066473388672; 10680,574.065802001953; 10681,574.065100097656; 10682,574.064428710938; 10683,574.063726806641; 10684,574.063055419922; 10685,574.062384033203; 10686,574.061682128906; 10687,574.061010742188; 10688,574.060339355469; 10689,574.059637451172; 10690,574.058966064453; 10691,574.058294677734; 10692,574.057592773438; 10693,574.056921386719; 10694,574.05625; 10695,574.055548095703; 10696,574.054876708984; 10697,574.054205322266; 10698,574.053503417969; 10699,574.05283203125; 10700,574.052130126953; 10701,574.051458740234; 10702,574.050787353516; 10703,574.050085449219; 10704,574.0494140625; 10705,574.048742675781; 10706,574.048040771484; 10707,574.047369384766; 10708,574.046697998047; 10709,574.04599609375; 10710,574.045324707031; 10711,574.044653320313; 10712,574.043951416016; 10713,574.043280029297; 10714,574.042608642578; 10715,574.041906738281;
        10716,574.041235351563; 10717,574.040533447266; 10718,574.039862060547; 10719,574.039190673828; 10720,574.038488769531; 10721,574.037817382813; 10722,574.037145996094; 10723,574.036444091797; 10724,574.035772705078; 10725,574.035101318359; 10726,574.034399414063; 10727,574.033728027344; 10728,574.033056640625; 10729,574.032354736328; 10730,574.031683349609; 10731,574.030981445313; 10732,574.030310058594; 10733,574.029638671875; 10734,574.028936767578; 10735,574.028265380859; 10736,574.027593994141; 10737,574.026892089844; 10738,574.026220703125; 10739,574.025549316406; 10740,574.024847412109; 10741,574.024176025391; 10742,574.023504638672; 10743,574.022802734375; 10744,574.022131347656; 10745,574.021459960938; 10746,574.020758056641; 10747,574.020086669922; 10748,574.019384765625; 10749,574.018713378906; 10750,574.018041992188; 10751,574.017340087891; 10752,574.016668701172; 10753,574.015997314453; 10754,574.015295410156; 10755,574.014624023438; 10756,574.013952636719; 10757,
        574.013250732422; 10758,574.012579345703; 10759,574.011907958984; 10760,574.011206054688; 10761,574.010534667969; 10762,574.00986328125; 10763,574.009161376953; 10764,574.008489990234; 10765,574.007788085938; 10766,574.007116699219; 10767,574.0064453125; 10768,574.005743408203; 10769,574.005072021484; 10770,574.004400634766; 10771,574.003698730469; 10772,574.00302734375; 10773,574.002355957031; 10774,574.001654052734; 10775,574.000982666016; 10776,574.000311279297; 10777,573.999609375; 10778,573.998937988281; 10779,573.998266601563; 10780,573.997564697266; 10781,573.996893310547; 10782,573.99619140625; 10783,573.995520019531; 10784,573.994848632813; 10785,573.994146728516; 10786,573.993475341797; 10787,573.992803955078; 10788,573.992102050781; 10789,573.991430664063; 10790,573.990759277344; 10791,573.990057373047; 10792,573.989385986328; 10793,573.988714599609; 10794,573.988012695313; 10795,573.987341308594; 10796,573.986669921875; 10797,573.985968017578; 10798,
        573.985296630859; 10799,573.984594726563; 10800,573.983923339844; 10801,573.983251953125; 10802,573.982550048828; 10803,573.981878662109; 10804,573.981207275391; 10805,573.980505371094; 10806,573.979833984375; 10807,573.979162597656; 10808,573.978460693359; 10809,573.977789306641; 10810,573.977117919922; 10811,573.976416015625; 10812,573.975744628906; 10813,573.975073242188; 10814,573.974371337891; 10815,573.973699951172; 10816,573.972998046875; 10817,573.972326660156; 10818,573.971655273438; 10819,573.970953369141; 10820,573.970281982422; 10821,573.969610595703; 10822,573.968908691406; 10823,573.968237304688; 10824,573.967565917969; 10825,573.966864013672; 10826,573.966192626953; 10827,573.965521240234; 10828,573.964819335938; 10829,573.964147949219; 10830,573.9634765625; 10831,573.962774658203; 10832,573.962103271484; 10833,573.961401367188; 10834,573.960729980469; 10835,573.96005859375; 10836,573.959356689453; 10837,573.958685302734; 10838,573.958013916016; 10839,
        573.957312011719; 10840,573.956640625; 10841,573.955969238281; 10842,573.955267333984; 10843,573.954595947266; 10844,573.953924560547; 10845,573.95322265625; 10846,573.952551269531; 10847,573.951879882813; 10848,573.951177978516; 10849,573.950506591797; 10850,573.9498046875; 10851,573.949133300781; 10852,573.948461914063; 10853,573.947760009766; 10854,573.947088623047; 10855,573.946417236328; 10856,573.945715332031; 10857,573.945043945313; 10858,573.944372558594; 10859,573.943670654297; 10860,573.942999267578; 10861,573.942327880859; 10862,573.941625976563; 10863,573.940954589844; 10864,573.940252685547; 10865,573.939581298828; 10866,573.938909912109; 10867,573.938208007813; 10868,573.937536621094; 10869,573.936865234375; 10870,573.936163330078; 10871,573.935491943359; 10872,573.934820556641; 10873,573.934118652344; 10874,573.933447265625; 10875,573.932775878906; 10876,573.932073974609; 10877,573.931402587891; 10878,573.930731201172; 10879,573.930029296875; 10880,
        573.929357910156; 10881,573.928656005859; 10882,573.927984619141; 10883,573.927313232422; 10884,573.926611328125; 10885,573.925939941406; 10886,573.925268554688; 10887,573.924566650391; 10888,573.923895263672; 10889,573.923223876953; 10890,573.922521972656; 10891,573.921850585938; 10892,573.921179199219; 10893,573.920477294922; 10894,573.919805908203; 10895,573.919134521484; 10896,573.918432617188; 10897,573.917761230469; 10898,573.917059326172; 10899,573.916387939453; 10900,573.915716552734; 10901,573.915014648438; 10902,573.914343261719; 10903,573.913671875; 10904,573.912969970703; 10905,573.912298583984; 10906,573.911627197266; 10907,573.910925292969; 10908,573.91025390625; 10909,573.909582519531; 10910,573.908880615234; 10911,573.908209228516; 10912,573.907537841797; 10913,573.9068359375; 10914,573.906164550781; 10915,573.905462646484; 10916,573.904791259766; 10917,573.904119873047; 10918,573.90341796875; 10919,573.902746582031; 10920,573.902075195313; 10921,
        573.901373291016; 10922,573.900701904297; 10923,573.900030517578; 10924,573.899328613281; 10925,573.898657226563; 10926,573.897985839844; 10927,573.897283935547; 10928,573.896612548828; 10929,573.895941162109; 10930,573.895239257813; 10931,573.894567871094; 10932,573.893865966797; 10933,573.893194580078; 10934,573.892523193359; 10935,573.891821289063; 10936,573.891149902344; 10937,573.890478515625; 10938,573.889776611328; 10939,573.889105224609; 10940,573.888433837891; 10941,573.887731933594; 10942,573.887060546875; 10943,573.886389160156; 10944,573.885687255859; 10945,573.885015869141; 10946,573.884344482422; 10947,573.883642578125; 10948,573.882971191406; 10949,573.882269287109; 10950,573.881597900391; 10951,573.880926513672; 10952,573.880224609375; 10953,573.879553222656; 10954,573.878881835938; 10955,573.878179931641; 10956,573.877508544922; 10957,573.876837158203; 10958,573.876135253906; 10959,573.875463867188; 10960,573.874792480469; 10961,573.874090576172; 10962,
        573.873419189453; 10963,573.872747802734; 10964,573.872045898438; 10965,573.871374511719; 10966,573.870672607422; 10967,573.870001220703; 10968,573.869329833984; 10969,573.868627929688; 10970,573.867956542969; 10971,573.86728515625; 10972,573.866583251953; 10973,573.865911865234; 10974,573.865240478516; 10975,573.864538574219; 10976,573.8638671875; 10977,573.863195800781; 10978,573.862493896484; 10979,573.861822509766; 10980,573.861151123047; 10981,573.86044921875; 10982,573.859777832031; 10983,573.859075927734; 10984,573.858404541016; 10985,573.857733154297; 10986,573.85703125; 10987,573.856359863281; 10988,573.855688476563; 10989,573.854986572266; 10990,573.854315185547; 10991,573.853643798828; 10992,573.852941894531; 10993,573.852270507813; 10994,573.851599121094; 10995,573.850897216797; 10996,573.850225830078; 10997,573.849554443359; 10998,573.848852539063; 10999,573.848181152344; 11000,573.847479248047; 11001,573.846807861328; 11002,573.846136474609; 11003,
        573.845434570313; 11004,573.844763183594; 11005,573.844091796875; 11006,573.843389892578; 11007,573.842718505859; 11008,573.842047119141; 11009,573.841345214844; 11010,573.840673828125; 11011,573.840002441406; 11012,573.839300537109; 11013,573.838629150391; 11014,573.837927246094; 11015,573.837255859375; 11016,573.836584472656; 11017,573.835882568359; 11018,573.835211181641; 11019,573.834539794922; 11020,573.833837890625; 11021,573.833166503906; 11022,573.832495117188; 11023,573.831793212891; 11024,573.831121826172; 11025,573.830450439453; 11026,573.829748535156; 11027,573.829077148438; 11028,573.828405761719; 11029,573.827703857422; 11030,573.827032470703; 11031,573.826330566406; 11032,573.825659179688; 11033,573.824987792969; 11034,573.824285888672; 11035,573.823614501953; 11036,573.822943115234; 11037,573.822241210938; 11038,573.821569824219; 11039,573.8208984375; 11040,573.820196533203; 11041,573.819525146484; 11042,573.818853759766; 11043,573.818151855469; 11044,
        573.81748046875; 11045,573.816809082031; 11046,573.816107177734; 11047,573.815435791016; 11048,573.814733886719; 11049,573.8140625; 11050,573.813391113281; 11051,573.812689208984; 11052,573.812017822266; 11053,573.811346435547; 11054,573.81064453125; 11055,573.809973144531; 11056,573.809301757813; 11057,573.808599853516; 11058,573.807928466797; 11059,573.807257080078; 11060,573.806555175781; 11061,573.805883789063; 11062,573.805212402344; 11063,573.804510498047; 11064,573.803839111328; 11065,573.803137207031; 11066,573.802465820313; 11067,573.801794433594; 11068,573.801092529297; 11069,573.800421142578; 11070,573.798101806641; 11071,573.790502929688; 11072,573.782934570313; 11073,573.775335693359; 11074,573.767736816406; 11075,573.760168457031; 11076,573.752569580078; 11077,573.744970703125; 11078,573.737371826172; 11079,573.729803466797; 11080,573.722204589844; 11081,573.714605712891; 11082,573.707006835938; 11083,573.699438476563; 11084,573.691839599609; 11085,
        573.684240722656; 11086,573.676672363281; 11087,573.669073486328; 11088,573.661474609375; 11089,573.653875732422; 11090,573.646307373047; 11091,573.638708496094; 11092,573.631109619141; 11093,573.623541259766; 11094,573.615942382813; 11095,573.608343505859; 11096,573.600744628906; 11097,573.593176269531; 11098,573.585577392578; 11099,573.577978515625; 11100,573.570379638672; 11101,573.562811279297; 11102,573.555212402344; 11103,573.547613525391; 11104,573.540045166016; 11105,573.532446289063; 11106,573.524847412109; 11107,573.517248535156; 11108,573.509680175781; 11109,573.502081298828; 11110,573.494482421875; 11111,573.4869140625; 11112,573.479315185547; 11113,573.471716308594; 11114,573.464117431641; 11115,573.456549072266; 11116,573.448950195313; 11117,573.441351318359; 11118,573.433752441406; 11119,573.426184082031; 11120,573.418585205078; 11121,573.410986328125; 11122,573.40341796875; 11123,573.395819091797; 11124,573.388220214844; 11125,573.380621337891; 11126,
        573.373052978516; 11127,573.365454101563; 11128,573.357855224609; 11129,573.350286865234; 11130,573.342687988281; 11131,573.335089111328; 11132,573.327490234375; 11133,573.319921875; 11134,573.312322998047; 11135,573.304724121094; 11136,573.297125244141; 11137,573.289556884766; 11138,573.281958007813; 11139,573.274359130859; 11140,573.266790771484; 11141,573.259191894531; 11142,573.251593017578; 11143,573.243994140625; 11144,573.23642578125; 11145,573.228826904297; 11146,573.221228027344; 11147,573.213659667969; 11148,573.206060791016; 11149,573.198461914063; 11150,573.190863037109; 11151,573.183294677734; 11152,573.175695800781; 11153,573.168096923828; 11154,573.160498046875; 11155,573.1529296875; 11156,573.145330810547; 11157,573.137731933594; 11158,573.130163574219; 11159,573.122564697266; 11160,573.114965820313; 11161,573.107366943359; 11162,573.099798583984; 11163,573.092199707031; 11164,573.084600830078; 11165,573.077032470703; 11166,573.06943359375; 11167,
        573.061834716797; 11168,573.054235839844; 11169,573.046667480469; 11170,573.039068603516; 11171,573.031469726563; 11172,573.023870849609; 11173,573.016302490234; 11174,573.008703613281; 11175,573.001104736328; 11176,572.993536376953; 11177,572.9859375; 11178,572.978338623047; 11179,572.970739746094; 11180,572.963171386719; 11181,572.955572509766; 11182,572.947973632813; 11183,572.940405273438; 11184,572.932806396484; 11185,572.925207519531; 11186,572.917608642578; 11187,572.910040283203; 11188,572.90244140625; 11189,572.894842529297; 11190,572.887243652344; 11191,572.879675292969; 11192,572.872076416016; 11193,572.864477539063; 11194,572.856909179688; 11195,572.849310302734; 11196,572.841711425781; 11197,572.834112548828; 11198,572.826544189453; 11199,572.8189453125; 11200,572.811346435547; 11201,572.803778076172; 11202,572.796179199219; 11203,572.788580322266; 11204,572.780981445313; 11205,572.773413085938; 11206,572.765814208984; 11207,572.758215332031; 11208,
        572.750616455078; 11209,572.743048095703; 11210,572.73544921875; 11211,572.727850341797; 11212,572.720281982422; 11213,572.712683105469; 11214,572.705084228516; 11215,572.697485351563; 11216,572.689916992188; 11217,572.682318115234; 11218,572.674719238281; 11219,572.667150878906; 11220,572.659552001953; 11221,572.651953125; 11222,572.644354248047; 11223,572.636785888672; 11224,572.629187011719; 11225,572.621588134766; 11226,572.613989257813; 11227,572.606420898438; 11228,572.598822021484; 11229,572.591223144531; 11230,572.583654785156; 11231,572.576055908203; 11232,572.56845703125; 11233,572.560858154297; 11234,572.553289794922; 11235,572.545690917969; 11236,572.538092041016; 11237,572.530523681641; 11238,572.522924804688; 11239,572.515325927734; 11240,572.507727050781; 11241,572.500158691406; 11242,572.492559814453; 11243,572.4849609375; 11244,572.477362060547; 11245,572.469793701172; 11246,572.462194824219; 11247,572.454595947266; 11248,572.447027587891; 11249,
        572.439428710938; 11250,572.431829833984; 11251,572.424230957031; 11252,572.416662597656; 11253,572.409063720703; 11254,572.40146484375; 11255,572.393896484375; 11256,572.386297607422; 11257,572.378698730469; 11258,572.371099853516; 11259,572.363531494141; 11260,572.355932617188; 11261,572.348333740234; 11262,572.340734863281; 11263,572.333166503906; 11264,572.325567626953; 11265,572.31796875; 11266,572.310400390625; 11267,572.302801513672; 11268,572.295202636719; 11269,572.287603759766; 11270,572.280035400391; 11271,572.272436523438; 11272,572.264837646484; 11273,572.257269287109; 11274,572.249670410156; 11275,572.242071533203; 11276,572.23447265625; 11277,572.226904296875; 11278,572.219305419922; 11279,572.211706542969; 11280,572.204107666016; 11281,572.196539306641; 11282,572.188940429688; 11283,572.181341552734; 11284,572.173773193359; 11285,572.166174316406; 11286,572.158575439453; 11287,572.1509765625; 11288,572.143408203125; 11289,572.135809326172; 11290,
        572.128210449219; 11291,572.120642089844; 11292,572.113043212891; 11293,572.105444335938; 11294,572.097845458984; 11295,572.090277099609; 11296,572.082678222656; 11297,572.075079345703; 11298,572.06748046875; 11299,572.059912109375; 11300,572.052313232422; 11301,572.044714355469; 11302,572.037145996094; 11303,572.029547119141; 11304,572.021948242188; 11305,572.014349365234; 11306,572.006781005859; 11307,571.999182128906; 11308,571.991583251953; 11309,571.984014892578; 11310,571.976416015625; 11311,571.968817138672; 11312,571.961218261719; 11313,571.953649902344; 11314,571.946051025391; 11315,571.938452148438; 11316,571.930853271484; 11317,571.923284912109; 11318,571.915686035156; 11319,571.908087158203; 11320,571.900518798828; 11321,571.892919921875; 11322,571.885321044922; 11323,571.877722167969; 11324,571.870153808594; 11325,571.862554931641; 11326,571.854956054688; 11327,571.847387695313; 11328,571.839788818359; 11329,571.832189941406; 11330,571.824591064453; 11331,
        571.817022705078; 11332,571.809423828125; 11333,571.801824951172; 11334,571.794226074219; 11335,571.786657714844; 11336,571.779058837891; 11337,571.771459960938; 11338,571.763891601563; 11339,571.756292724609; 11340,571.748693847656; 11341,571.741094970703; 11342,571.733526611328; 11343,571.725927734375; 11344,571.718328857422; 11345,571.710760498047; 11346,571.703161621094; 11347,571.695562744141; 11348,571.687963867188; 11349,571.680395507813; 11350,571.672796630859; 11351,571.665197753906; 11352,571.657598876953; 11353,571.650030517578; 11354,571.642431640625; 11355,571.634832763672; 11356,571.627264404297; 11357,571.619665527344; 11358,571.612066650391; 11359,571.604467773438; 11360,571.53232421875; 11361,571.364630126953; 11362,571.196936035156; 11363,571.029241943359; 11364,570.861517333984; 11365,570.693823242188; 11366,570.526129150391; 11367,570.358435058594; 11368,570.190740966797; 11369,570.023046875; 11370,569.855352783203; 11371,569.687658691406; 11372,
        569.519964599609; 11373,569.352270507813; 11374,569.184576416016; 11375,569.016882324219; 11376,568.849188232422; 11377,568.681494140625; 11378,568.513800048828; 11379,568.346075439453; 11380,568.178381347656; 11381,568.010687255859; 11382,567.842993164063; 11383,567.675299072266; 11384,567.507604980469; 11385,567.396307373047; 11386,567.386328125; 11387,567.376318359375; 11388,567.366339111328; 11389,567.356329345703; 11390,567.346350097656; 11391,567.336340332031; 11392,567.326361083984; 11393,567.316381835938; 11394,567.306372070313; 11395,567.296392822266; 11396,567.286383056641; 11397,567.276403808594; 11398,567.266424560547; 11399,567.256414794922; 11400,567.246435546875; 11401,567.23642578125; 11402,567.226446533203; 11403,567.216467285156; 11404,567.206457519531; 11405,567.196478271484; 11406,567.186468505859; 11407,567.176489257813; 11408,567.166510009766; 11409,567.156500244141; 11410,567.146520996094; 11411,567.136511230469; 11412,567.126531982422; 11413,
        567.116522216797; 11414,567.10654296875; 11415,567.096563720703; 11416,567.086553955078; 11417,567.076574707031; 11418,567.066564941406; 11419,567.056585693359; 11420,567.046606445313; 11421,567.036596679688; 11422,567.026617431641; 11423,567.016607666016; 11424,567.006628417969; 11425,567.012426757813; 11426,567.050634765625; 11427,567.088812255859; 11428,567.126989746094; 11429,567.165167236328; 11430,567.203344726563; 11431,567.241522216797; 11432,567.279699707031; 11433,567.317877197266; 11434,567.3560546875; 11435,567.394232177734; 11436,567.432409667969; 11437,567.470587158203; 11438,567.508764648438; 11439,567.546942138672; 11440,567.585150146484; 11441,567.623327636719; 11442,567.661505126953; 11443,567.699682617188; 11444,567.737860107422; 11445,567.776037597656; 11446,567.814215087891; 11447,567.852392578125; 11448,567.890570068359; 11449,567.928747558594; 11450,567.966925048828; 11451,568.005102539063; 11452,568.043280029297; 11453,568.081488037109; 11454,
        568.119665527344; 11455,568.157843017578; 11456,568.196020507813; 11457,568.234197998047; 11458,568.272375488281; 11459,568.310552978516; 11460,568.34873046875; 11461,568.386907958984; 11462,568.425085449219; 11463,568.463262939453; 11464,568.501440429688; 11465,568.539617919922; 11466,568.577795410156; 11467,568.616003417969; 11468,568.654180908203; 11469,568.692358398438; 11470,568.730535888672; 11471,568.768713378906; 11472,568.806890869141; 11473,568.845068359375; 11474,568.883245849609; 11475,568.921423339844; 11476,568.959600830078; 11477,568.997778320313; 11478,569.035955810547; 11479,569.074133300781; 11480,569.112310791016; 11481,569.150518798828; 11482,569.188696289063; 11483,569.226873779297; 11484,569.265051269531; 11485,569.303228759766; 11486,569.34140625; 11487,569.379583740234; 11488,569.417761230469; 11489,569.455938720703; 11490,569.494116210938; 11491,569.532293701172; 11492,569.570471191406; 11493,569.608648681641; 11494,569.646826171875; 11495,
        569.685034179688; 11496,569.723211669922; 11497,569.761389160156; 11498,569.799566650391; 11499,569.837744140625; 11500,575.15; 14499,575.15; 14500,573.388220214844; 14501,573.380621337891; 14502,573.373052978516; 14503,573.365454101563; 14504,573.357855224609; 14505,573.350286865234; 14506,573.342687988281; 14507,573.335089111328; 14508,573.327490234375; 14509,573.319921875; 14510,573.312322998047; 14511,573.304724121094; 14512,573.297125244141; 14513,573.289556884766; 14514,573.281958007813; 14515,573.274359130859; 14516,573.266790771484; 14517,573.259191894531; 14518,573.251593017578; 14519,573.243994140625; 14520,573.23642578125; 14521,573.228826904297; 14522,573.221228027344; 14523,573.213659667969; 14524,573.206060791016; 14525,573.198461914063; 14526,573.190863037109; 14527,573.183294677734; 14528,573.175695800781; 14529,573.168096923828; 14530,573.160498046875; 14531,573.1529296875; 14532,573.145330810547; 14533,573.137731933594; 14534,573.130163574219; 14535,
        573.122564697266; 14536,573.114965820313; 14537,573.107366943359; 14538,573.099798583984; 14539,573.092199707031; 14540,573.084600830078; 14541,573.077032470703; 14542,573.06943359375; 14543,573.061834716797; 14544,573.054235839844; 14545,573.046667480469; 14546,573.039068603516; 14547,573.031469726563; 14548,573.023870849609; 14549,573.016302490234; 14550,573.008703613281; 14551,573.001104736328; 14552,572.993536376953; 14553,572.9859375; 14554,572.978338623047; 14555,572.970739746094; 14556,572.963171386719; 14557,572.955572509766; 14558,572.947973632813; 14559,572.940405273438; 14560,572.932806396484; 14561,572.925207519531; 14562,572.917608642578; 14563,572.910040283203; 14564,572.90244140625; 14565,572.894842529297; 14566,572.887243652344; 14567,572.879675292969; 14568,572.872076416016; 14569,572.864477539063; 14570,572.856909179688; 14571,572.849310302734; 14572,572.841711425781; 14573,572.834112548828; 14574,572.826544189453; 14575,572.8189453125; 14576,572.811346435547;
        14577,572.803778076172; 14578,572.796179199219; 14579,572.788580322266; 14580,572.780981445313; 14581,572.773413085938; 14582,572.765814208984; 14583,572.758215332031; 14584,572.750616455078; 14585,572.743048095703; 14586,572.73544921875; 14587,572.727850341797; 14588,572.720281982422; 14589,572.712683105469; 14590,572.705084228516; 14591,572.697485351563; 14592,572.689916992188; 14593,572.682318115234; 14594,572.674719238281; 14595,572.667150878906; 14596,572.659552001953; 14597,572.651953125; 14598,572.644354248047; 14599,572.636785888672; 14600,572.629187011719; 14601,572.621588134766; 14602,572.613989257813; 14603,572.606420898438; 14604,572.598822021484; 14605,572.591223144531; 14606,572.583654785156; 14607,572.576055908203; 14608,572.56845703125; 14609,572.560858154297; 14610,572.553289794922; 14611,572.545690917969; 14612,572.538092041016; 14613,572.530523681641; 14614,572.522924804688; 14615,572.515325927734; 14616,572.507727050781; 14617,572.500158691406; 14618,
        572.492559814453; 14619,572.4849609375; 14620,572.477362060547; 14621,572.469793701172; 14622,572.462194824219; 14623,572.454595947266; 14624,572.447027587891; 14625,572.439428710938; 14626,572.431829833984; 14627,572.424230957031; 14628,572.416662597656; 14629,572.409063720703; 14630,572.40146484375; 14631,572.393896484375; 14632,572.386297607422; 14633,572.378698730469; 14634,572.371099853516; 14635,572.363531494141; 14636,572.355932617188; 14637,572.348333740234; 14638,572.340734863281; 14639,572.333166503906; 14640,572.325567626953; 14641,572.31796875; 14642,572.310400390625; 14643,572.302801513672; 14644,572.295202636719; 14645,572.287603759766; 14646,572.280035400391; 14647,572.272436523438; 14648,572.264837646484; 14649,572.257269287109; 14650,572.249670410156; 14651,572.242071533203; 14652,572.23447265625; 14653,572.226904296875; 14654,572.219305419922; 14655,572.211706542969; 14656,572.204107666016; 14657,572.196539306641; 14658,572.188940429688; 14659,
        572.181341552734; 14660,572.173773193359; 14661,572.166174316406; 14662,572.158575439453; 14663,572.1509765625; 14664,572.143408203125; 14665,572.135809326172; 14666,572.128210449219; 14667,572.120642089844; 14668,572.113043212891; 14669,572.105444335938; 14670,572.097845458984; 14671,572.090277099609; 14672,572.082678222656; 14673,572.075079345703; 14674,572.06748046875; 14675,572.059912109375; 14676,572.052313232422; 14677,572.044714355469; 14678,572.037145996094; 14679,572.029547119141; 14680,572.021948242188; 14681,572.014349365234; 14682,572.006781005859; 14683,571.999182128906; 14684,571.991583251953; 14685,571.984014892578; 14686,571.976416015625; 14687,571.968817138672; 14688,571.961218261719; 14689,571.953649902344; 14690,571.946051025391; 14691,571.938452148438; 14692,571.930853271484; 14693,571.923284912109; 14694,571.915686035156; 14695,571.908087158203; 14696,571.900518798828; 14697,571.892919921875; 14698,571.885321044922; 14699,571.877722167969; 14700,
        571.870153808594; 14701,571.862554931641; 14702,571.854956054688; 14703,571.847387695313; 14704,571.839788818359; 14705,571.832189941406; 14706,571.824591064453; 14707,571.817022705078; 14708,571.809423828125; 14709,571.801824951172; 14710,571.794226074219; 14711,571.786657714844; 14712,571.779058837891; 14713,571.771459960938; 14714,571.763891601563; 14715,571.756292724609; 14716,571.748693847656; 14717,571.741094970703; 14718,571.733526611328; 14719,571.725927734375; 14720,571.718328857422; 14721,571.710760498047; 14722,571.703161621094; 14723,571.695562744141; 14724,571.687963867188; 14725,571.680395507813; 14726,571.672796630859; 14727,571.665197753906; 14728,571.657598876953; 14729,571.650030517578; 14730,571.642431640625; 14731,571.634832763672; 14732,571.627264404297; 14733,571.619665527344; 14734,571.612066650391; 14735,571.604467773438; 14736,571.53232421875; 14737,571.364630126953; 14738,571.196936035156; 14739,571.029241943359; 14740,570.861517333984; 14741,
        570.693823242188; 14742,570.526129150391; 14743,570.358435058594; 14744,570.190740966797; 14745,570.023046875; 14746,569.855352783203; 14747,569.687658691406; 14748,569.519964599609; 14749,569.352270507813; 14750,569.184576416016; 14751,569.016882324219; 14752,568.849188232422; 14753,568.681494140625; 14754,568.513800048828; 14755,568.346075439453; 14756,568.178381347656; 14757,568.010687255859; 14758,567.842993164063; 14759,567.675299072266; 14760,567.507604980469; 14761,567.396307373047; 14762,567.386328125; 14763,567.376318359375; 14764,567.366339111328; 14765,567.356329345703; 14766,567.346350097656; 14767,567.336340332031; 14768,567.326361083984; 14769,567.316381835938; 14770,567.306372070313; 14771,567.296392822266; 14772,567.286383056641; 14773,567.276403808594; 14774,567.266424560547; 14775,567.256414794922; 14776,567.246435546875; 14777,567.23642578125; 14778,567.226446533203; 14779,567.216467285156; 14780,567.206457519531; 14781,567.196478271484; 14782,
        567.186468505859; 14783,567.176489257813; 14784,567.166510009766; 14785,567.156500244141; 14786,567.146520996094; 14787,567.136511230469; 14788,567.126531982422; 14789,567.116522216797; 14790,567.10654296875; 14791,567.096563720703; 14792,567.086553955078; 14793,567.076574707031; 14794,567.066564941406; 14795,567.056585693359; 14796,567.046606445313; 14797,567.036596679688; 14798,567.026617431641; 14799,567.016607666016; 14800,567.006628417969; 14801,567.012426757813; 14802,567.050634765625; 14803,567.088812255859; 14804,567.126989746094; 14805,567.165167236328; 14806,567.203344726563; 14807,567.241522216797; 14808,567.279699707031; 14809,567.317877197266; 14810,567.3560546875; 14811,567.394232177734; 14812,567.432409667969; 14813,567.470587158203; 14814,567.508764648438; 14815,567.546942138672; 14816,567.585150146484; 14817,567.623327636719; 14818,567.661505126953; 14819,567.699682617188; 14820,567.737860107422; 14821,567.776037597656; 14822,567.814215087891; 14823,
        567.852392578125; 14824,567.890570068359; 14825,567.928747558594; 14826,567.966925048828; 14827,568.005102539063; 14828,568.043280029297; 14829,568.081488037109; 14830,568.119665527344; 14831,568.157843017578; 14832,568.196020507813; 14833,568.234197998047; 14834,568.272375488281; 14835,568.310552978516; 14836,568.34873046875; 14837,568.386907958984; 14838,568.425085449219; 14839,568.463262939453; 14840,568.501440429688; 14841,568.539617919922; 14842,568.577795410156; 14843,568.616003417969; 14844,568.654180908203; 14845,568.692358398438; 14846,568.730535888672; 14847,568.768713378906; 14848,568.806890869141; 14849,568.845068359375; 14850,568.883245849609; 14851,568.921423339844; 14852,568.959600830078; 14853,568.997778320313; 14854,569.035955810547; 14855,569.074133300781; 14856,569.112310791016; 14857,569.150518798828; 14858,569.188696289063; 14859,569.226873779297; 14860,569.265051269531; 14861,569.303228759766; 14862,569.34140625; 14863,569.379583740234; 14864,
        569.417761230469; 14865,569.455938720703; 14866,569.494116210938; 14867,569.532293701172; 14868,569.570471191406; 14869,569.608648681641; 14870,569.646826171875; 14871,569.685034179688; 14872,569.723211669922; 14873,569.761389160156; 14874,569.799566650391; 14875,569.837744140625; 14876,569.875921630859; 14877,569.914099121094; 14878,569.952276611328; 14879,569.990454101563; 14880,570.028631591797; 14881,570.066809082031; 14882,570.104986572266; 14883,570.1431640625; 14884,570.181341552734; 14885,570.219549560547; 14886,570.257727050781; 14887,570.295904541016; 14888,570.33408203125; 14889,570.372259521484; 14890,570.410437011719; 14891,570.448614501953; 14892,570.486791992188; 14893,570.524969482422; 14894,570.549261474609; 14895,570.547369384766; 14896,570.545477294922; 14897,570.543585205078; 14898,570.541693115234; 14899,570.539801025391; 14900,570.537908935547; 14901,570.536016845703; 14902,570.534124755859; 14903,570.532232666016; 14904,570.53037109375; 14905,
        570.528479003906; 14906,570.526586914063; 14907,570.524694824219; 14908,570.522802734375; 14909,570.520910644531; 14910,570.519018554688; 14911,570.517126464844; 14912,570.515234375; 14913,570.513372802734; 14914,570.511480712891; 14915,570.509588623047; 14916,570.507696533203; 14917,570.505804443359; 14918,570.503912353516; 14919,570.502020263672; 14920,570.500128173828; 14921,570.498236083984; 14922,570.496374511719; 14923,570.494482421875; 14924,570.492590332031; 14925,570.490698242188; 14926,570.488806152344; 14927,570.4869140625; 14928,570.485021972656; 14929,570.483129882813; 14930,570.481237792969; 14931,570.479376220703; 14932,570.477484130859; 14933,570.475592041016; 14934,570.473699951172; 14935,570.471807861328; 14936,570.469915771484; 14937,570.468023681641; 14938,570.466131591797; 14939,570.464239501953; 14940,570.462347412109; 14941,570.460485839844; 14942,570.45859375; 14943,570.456701660156; 14944,570.454809570313; 14945,570.452917480469; 14946,570.451025390625;
        14947,570.449133300781; 14948,570.447241210938; 14949,570.445349121094; 14950,570.443487548828; 14951,570.441595458984; 14952,570.439703369141; 14953,570.437811279297; 14954,570.435919189453; 14955,570.434027099609; 14956,570.432135009766; 14957,570.430242919922; 14958,570.428350830078; 14959,570.426489257813; 14960,570.424597167969; 14961,570.422705078125; 14962,570.420812988281; 14963,570.418920898438; 14964,570.417028808594; 14965,570.41513671875; 14966,570.413244628906; 14967,570.411352539063; 14968,570.409490966797; 14969,570.407598876953; 14970,570.405706787109; 14971,570.403814697266; 14972,570.401922607422; 14973,570.400030517578; 14974,570.398138427734; 14975,570.396246337891; 14976,570.394354248047; 14977,570.392462158203; 14978,570.390600585938; 14979,570.388708496094; 14980,570.38681640625; 14981,570.384924316406; 14982,570.383032226563; 14983,570.381140136719; 14984,570.379248046875; 14985,570.377355957031; 14986,570.375463867188; 14987,570.373602294922; 14988,
        570.371710205078; 14989,570.369818115234; 14990,570.367926025391; 14991,570.366033935547; 14992,570.364141845703; 14993,570.362249755859; 14994,570.360357666016; 14995,570.358465576172; 14996,570.356604003906; 14997,570.354711914063; 14998,570.352819824219; 14999,570.350927734375; 15000,570.349035644531; 15001,570.347143554688; 15002,570.345251464844; 15003,570.343359375; 15004,570.341467285156; 15005,570.339575195313; 15006,570.337713623047; 15007,570.335821533203; 15008,570.333929443359; 15009,570.332037353516; 15010,570.330145263672; 15011,570.328253173828; 15012,570.326361083984; 15013,570.324468994141; 15014,570.322576904297; 15015,570.320715332031; 15016,570.318823242188; 15017,570.316931152344; 15018,570.3150390625; 15019,570.313146972656; 15020,570.311254882813; 15021,570.309362792969; 15022,570.307470703125; 15023,570.305578613281; 15024,570.303717041016; 15025,570.301824951172; 15026,570.299932861328; 15027,570.298040771484; 15028,570.296148681641; 15029,
        570.294256591797; 15030,570.292364501953; 15031,570.290472412109; 15032,570.288580322266; 15033,570.28671875; 15034,570.284826660156; 15035,570.282934570313; 15036,570.281042480469; 15037,570.279150390625; 15038,570.277258300781; 15039,570.275366210938; 15040,570.273474121094; 15041,570.27158203125; 15042,570.269689941406; 15043,570.267828369141; 15044,570.265936279297; 15045,570.264044189453; 15046,570.262152099609; 15047,570.260260009766; 15048,570.258367919922; 15049,570.256475830078; 15050,570.254583740234; 15051,570.252691650391; 15052,570.250830078125; 15053,570.248937988281; 15054,570.247045898438; 15055,570.245153808594; 15056,570.24326171875; 15057,570.241369628906; 15058,570.239477539063; 15059,570.237585449219; 15060,570.235693359375; 15061,570.233831787109; 15062,570.231939697266; 15063,570.230047607422; 15064,570.228155517578; 15065,570.226263427734; 15066,570.224371337891; 15067,570.222479248047; 15068,570.220587158203; 15069,570.218695068359; 15070,
        570.216833496094; 15071,570.21494140625; 15072,570.213049316406; 15073,570.211157226563; 15074,570.209265136719; 15075,570.207373046875; 15076,570.205480957031; 15077,570.203588867188; 15078,570.201696777344; 15079,570.1998046875; 15080,570.197943115234; 15081,570.196051025391; 15082,570.194158935547; 15083,570.192266845703; 15084,570.190374755859; 15085,570.188482666016; 15086,570.186590576172; 15087,570.184698486328; 15088,570.182806396484; 15089,570.180944824219; 15090,570.179052734375; 15091,570.177160644531; 15092,570.175268554688; 15093,570.173376464844; 15094,570.171484375; 15095,570.169592285156; 15096,570.167700195313; 15097,570.165808105469; 15098,570.163946533203; 15099,570.162054443359; 15100,570.160162353516; 15101,570.158270263672; 15102,570.156378173828; 15103,570.154486083984; 15104,570.152593994141; 15105,570.150701904297; 15106,570.148809814453; 15107,570.146948242188; 15108,570.145056152344; 15109,570.1431640625; 15110,570.141271972656; 15111,
        570.139379882813; 15112,570.137487792969; 15113,570.135595703125; 15114,570.133703613281; 15115,570.131811523438; 15116,570.129919433594; 15117,570.128057861328; 15118,570.126165771484; 15119,570.124273681641; 15120,570.122381591797; 15121,570.120489501953; 15122,570.118597412109; 15123,570.116705322266; 15124,570.114813232422; 15125,570.112921142578; 15126,570.111059570313; 15127,570.109167480469; 15128,570.107275390625; 15129,570.105383300781; 15130,570.103491210938; 15131,570.101599121094; 15132,570.09970703125; 15133,570.097814941406; 15134,570.095922851563; 15135,570.094061279297; 15136,570.092169189453; 15137,570.090277099609; 15138,570.088385009766; 15139,570.086492919922; 15140,570.084600830078; 15141,570.082708740234; 15142,570.080816650391; 15143,570.078924560547; 15144,570.077062988281; 15145,570.075170898438; 15146,570.073278808594; 15147,570.07138671875; 15148,570.069494628906; 15149,570.067602539063; 15150,570.065710449219; 15151,570.063818359375; 15152,
        570.061926269531; 15153,570.060034179688; 15154,570.058172607422; 15155,570.056280517578; 15156,570.054388427734; 15157,570.052496337891; 15158,570.050604248047; 15159,570.048712158203; 15160,570.046820068359; 15161,570.044927978516; 15162,570.043035888672; 15163,570.041174316406; 15164,570.039282226563; 15165,570.037390136719; 15166,570.035498046875; 15167,570.033605957031; 15168,570.031713867188; 15169,570.029821777344; 15170,570.0279296875; 15171,570.026037597656; 15172,570.024176025391; 15173,570.022283935547; 15174,570.020391845703; 15175,570.018499755859; 15176,570.016607666016; 15177,570.014715576172; 15178,570.012823486328; 15179,570.010931396484; 15180,570.009039306641; 15181,570.007147216797; 15182,570.005285644531; 15183,570.003393554688; 15184,570.001501464844; 15185,569.999609375; 15186,569.997717285156; 15187,569.995825195313; 15188,569.993933105469; 15189,569.992041015625; 15190,569.990148925781; 15191,569.988287353516; 15192,569.986395263672; 15193,
        569.984503173828; 15194,569.982611083984; 15195,569.980718994141; 15196,569.978826904297; 15197,569.976934814453; 15198,569.975042724609; 15199,569.973150634766; 15200,569.9712890625; 15201,569.969396972656; 15202,569.967504882813; 15203,569.965612792969; 15204,569.963720703125; 15205,569.961828613281; 15206,569.959936523438; 15207,569.958044433594; 15208,569.95615234375; 15209,569.954290771484; 15210,569.952398681641; 15211,569.950506591797; 15212,569.948614501953; 15213,569.946722412109; 15214,569.944830322266; 15215,569.942938232422; 15216,569.941046142578; 15217,569.939154052734; 15218,569.937261962891; 15219,569.935400390625; 15220,569.933508300781; 15221,569.931616210938; 15222,569.929724121094; 15223,569.92783203125; 15224,569.925939941406; 15225,569.924047851563; 15226,569.922155761719; 15227,569.920263671875; 15228,569.918402099609; 15229,569.916510009766; 15230,569.914617919922; 15231,569.912725830078; 15232,569.910833740234; 15233,569.908941650391; 15234,
        569.907049560547; 15235,569.905157470703; 15236,569.903265380859; 15237,569.901403808594; 15238,569.89951171875; 15239,569.897619628906; 15240,569.895727539063; 15241,569.893835449219; 15242,569.891943359375; 15243,569.890051269531; 15244,569.888159179688; 15245,569.886267089844; 15246,569.884405517578; 15247,569.882513427734; 15248,569.880621337891; 15249,569.878729248047; 15250,569.876837158203; 15251,569.874945068359; 15252,569.873052978516; 15253,569.871160888672; 15254,569.869268798828; 15255,569.867376708984; 15256,569.865515136719; 15257,569.863623046875; 15258,569.861730957031; 15259,569.859838867188; 15260,569.857946777344; 15261,569.8560546875; 15262,569.854162597656; 15263,569.852270507813; 15264,569.850378417969; 15265,569.848516845703; 15266,569.846624755859; 15267,569.844732666016; 15268,569.842840576172; 15269,569.840948486328; 15270,569.839056396484; 15271,569.837164306641; 15272,569.835272216797; 15273,569.833380126953; 15274,569.831518554688; 15275,
        569.829626464844; 15276,569.827734375; 15277,569.825842285156; 15278,569.823950195313; 15279,569.822058105469; 15280,569.820166015625; 15281,569.818273925781; 15282,569.816381835938; 15283,569.814520263672; 15284,569.812628173828; 15285,569.810736083984; 15286,569.808843994141; 15287,569.806951904297; 15288,569.805059814453; 15289,569.803167724609; 15290,569.801275634766; 15291,569.799383544922; 15292,569.797491455078; 15293,569.795629882813; 15294,569.793737792969; 15295,569.791845703125; 15296,569.789953613281; 15297,569.788061523438; 15298,569.786169433594; 15299,569.78427734375; 15300,569.782385253906; 15301,569.780493164063; 15302,569.778631591797; 15303,569.776739501953; 15304,569.774847412109; 15305,569.772955322266; 15306,569.771063232422; 15307,569.769171142578; 15308,569.767279052734; 15309,569.765386962891; 15310,569.763494873047; 15311,569.761633300781; 15312,569.759741210938; 15313,569.757849121094; 15314,569.75595703125; 15315,569.754064941406; 15316,
        569.752172851563; 15317,569.750280761719; 15318,569.748388671875; 15319,569.746496582031; 15320,569.744604492188; 15321,569.742742919922; 15322,569.740850830078; 15323,569.738958740234; 15324,569.737066650391; 15325,569.735174560547; 15326,569.733282470703; 15327,569.731390380859; 15328,569.729498291016; 15329,569.727606201172; 15330,569.725744628906; 15331,569.723852539063; 15332,569.721960449219; 15333,569.720068359375; 15334,569.718176269531; 15335,569.716284179688; 15336,569.714392089844; 15337,569.7125; 15338,569.710607910156; 15339,569.708746337891; 15340,569.706854248047; 15341,569.704962158203; 15342,569.703070068359; 15343,569.701177978516; 15344,569.699285888672; 15345,569.697393798828; 15346,569.695501708984; 15347,569.693609619141; 15348,569.691748046875; 15349,569.689855957031; 15350,569.687963867188; 15351,569.686071777344; 15352,569.6841796875; 15353,569.682287597656; 15354,569.680395507813; 15355,569.678503417969; 15356,569.676611328125; 15357,569.674719238281;
        15358,569.672857666016; 15359,569.670965576172; 15360,569.669073486328; 15361,569.667181396484; 15362,569.665289306641; 15363,569.663397216797; 15364,569.661505126953; 15365,569.659613037109; 15366,569.657720947266; 15367,569.655859375; 15368,569.653967285156; 15369,569.652075195313; 15370,569.650183105469; 15371,569.648291015625; 15372,569.646398925781; 15373,569.644506835938; 15374,569.642614746094; 15375,569.64072265625; 15376,569.638861083984; 15377,569.636968994141; 15378,569.635076904297; 15379,569.633184814453; 15380,569.631292724609; 15381,569.629400634766; 15382,569.627508544922; 15383,569.625616455078; 15384,569.623724365234; 15385,569.621862792969; 15386,569.619970703125; 15387,569.618078613281; 15388,569.616186523438; 15389,569.614294433594; 15390,569.61240234375; 15391,569.610510253906; 15392,569.608618164063; 15393,569.606726074219; 15394,569.604833984375; 15395,569.602972412109; 15396,569.601080322266; 15397,569.599188232422; 15398,569.597296142578; 15399,
        569.595404052734; 15400,569.593511962891; 15401,569.591619873047; 15402,569.589727783203; 15403,569.587835693359; 15404,569.585974121094; 15405,569.58408203125; 15406,569.582189941406; 15407,569.580297851563; 15408,569.578405761719; 15409,569.576513671875; 15410,569.574621582031; 15411,569.572729492188; 15412,569.570837402344; 15413,569.568975830078; 15414,569.567083740234; 15415,569.565191650391; 15416,569.563299560547; 15417,569.561407470703; 15418,569.559515380859; 15419,569.557623291016; 15420,569.555731201172; 15421,569.553839111328; 15422,569.551977539063; 15423,569.550085449219; 15424,569.548193359375; 15425,569.546301269531; 15426,569.544409179688; 15427,569.542517089844; 15428,569.540625; 15429,569.538732910156; 15430,569.536840820313; 15431,569.534948730469; 15432,569.533087158203; 15433,569.531195068359; 15434,569.529302978516; 15435,569.527410888672; 15436,569.525518798828; 15437,569.523626708984; 15438,569.521734619141; 15439,569.519842529297; 15440,
        569.517950439453; 15441,569.516088867188; 15442,569.514196777344; 15443,569.5123046875; 15444,569.510412597656; 15445,569.508520507813; 15446,569.506628417969; 15447,569.504736328125; 15448,569.502844238281; 15449,569.500952148438; 15450,569.499090576172; 15451,569.497198486328; 15452,569.495306396484; 15453,569.493414306641; 15454,569.491522216797; 15455,569.489630126953; 15456,569.487738037109; 15457,569.485845947266; 15458,569.483953857422; 15459,569.482061767578; 15460,569.480200195313; 15461,569.478308105469; 15462,569.476416015625; 15463,569.474523925781; 15464,569.472631835938; 15465,569.470739746094; 15466,569.46884765625; 15467,569.466955566406; 15468,569.465063476563; 15469,569.463201904297; 15470,569.461309814453; 15471,569.459417724609; 15472,569.457525634766; 15473,569.455633544922; 15474,569.453741455078; 15475,569.451849365234; 15476,569.449957275391; 15477,569.448065185547; 15478,569.446203613281; 15479,569.444311523438; 15480,569.442419433594; 15481,
        569.44052734375; 15482,569.438635253906; 15483,569.436743164063; 15484,569.434851074219; 15485,569.432958984375; 15486,569.431066894531; 15487,569.429205322266; 15488,569.427313232422; 15489,569.425421142578; 15490,569.423529052734; 15491,569.421636962891; 15492,569.419744873047; 15493,569.417852783203; 15494,569.415960693359; 15495,569.414068603516; 15496,569.412176513672; 15497,569.410314941406; 15498,569.408422851563; 15499,569.406530761719; 15500,569.404638671875; 15501,569.402746582031; 15502,569.400854492188; 15503,569.398962402344; 15504,569.3970703125; 15505,569.395178222656; 15506,569.393316650391; 15507,569.391424560547; 15508,569.389532470703; 15509,569.387640380859; 15510,569.385748291016; 15511,569.383856201172; 15512,569.381964111328; 15513,569.380072021484; 15514,569.378179931641; 15515,569.376318359375; 15516,569.374426269531; 15517,569.372534179688; 15518,569.370642089844; 15519,569.36875; 15520,569.366857910156; 15521,569.364965820313; 15522,569.363073730469;
        15523,569.361181640625; 15524,569.359320068359; 15525,569.357427978516; 15526,569.355535888672; 15527,569.353643798828; 15528,569.351751708984; 15529,569.349859619141; 15530,569.347967529297; 15531,569.346075439453; 15532,569.344183349609; 15533,569.342291259766; 15534,569.3404296875; 15535,569.338537597656; 15536,569.336645507813; 15537,569.334753417969; 15538,569.332861328125; 15539,569.330969238281; 15540,569.329077148438; 15541,569.327185058594; 15542,569.32529296875; 15543,569.323431396484; 15544,569.321539306641; 15545,569.319647216797; 15546,569.317755126953; 15547,569.315863037109; 15548,569.313970947266; 15549,569.312078857422; 15550,569.310186767578; 15551,569.308294677734; 15552,569.306433105469; 15553,569.304541015625; 15554,569.302648925781; 15555,569.300756835938; 15556,569.298864746094; 15557,569.29697265625; 15558,569.295080566406; 15559,569.293188476563; 15560,569.291296386719; 15561,569.289434814453; 15562,569.287542724609; 15563,569.285650634766; 15564,
        569.283758544922; 15565,569.281866455078; 15566,569.279974365234; 15567,569.278082275391; 15568,569.276190185547; 15569,569.274298095703; 15570,569.272406005859; 15571,569.270544433594; 15572,569.26865234375; 15573,569.266760253906; 15574,569.264868164063; 15575,569.262976074219; 15576,569.261083984375; 15577,569.259191894531; 15578,569.257299804688; 15579,569.255407714844; 15580,569.253546142578; 15581,569.251654052734; 15582,569.249761962891; 15583,569.247869873047; 15584,569.245977783203; 15585,569.244085693359; 15586,569.242193603516; 15587,569.240301513672; 15588,569.238409423828; 15589,569.236547851563; 15590,569.234655761719; 15591,569.232763671875; 15592,569.230871582031; 15593,569.228979492188; 15594,569.227087402344; 15595,569.2251953125; 15596,569.223303222656; 15597,569.221411132813; 15598,569.219519042969; 15599,569.217657470703; 15600,569.215765380859; 15601,569.213873291016; 15602,569.211981201172; 15603,569.210089111328; 15604,569.208197021484; 15605,
        569.206304931641; 15606,569.204412841797; 15607,569.202520751953; 15608,569.200659179688; 15609,569.198767089844; 15610,569.196875; 15611,569.194982910156; 15612,569.193090820313; 15613,569.191198730469; 15614,569.189306640625; 15615,569.187414550781; 15616,569.185522460938; 15617,569.183660888672; 15618,569.181768798828; 15619,569.179876708984; 15620,569.177984619141; 15621,569.176092529297; 15622,569.174200439453; 15623,569.172308349609; 15624,569.170416259766; 15625,569.168524169922; 15626,569.166662597656; 15627,569.164770507813; 15628,569.162878417969; 15629,569.160986328125; 15630,569.159094238281; 15631,569.157202148438; 15632,569.155310058594; 15633,569.15341796875; 15634,569.151525878906; 15635,569.149633789063; 15636,569.147772216797; 15637,569.145880126953; 15638,569.143988037109; 15639,569.142095947266; 15640,569.140203857422; 15641,569.138311767578; 15642,569.136419677734; 15643,569.134527587891; 15644,569.132635498047; 15645,569.130773925781; 15646,
        569.128881835938; 15647,569.126989746094; 15648,569.12509765625; 15649,569.123205566406; 15650,569.121313476563; 15651,569.119421386719; 15652,569.117529296875; 15653,569.115637207031; 15654,569.113775634766; 15655,569.111883544922; 15656,569.109991455078; 15657,569.108099365234; 15658,569.106207275391; 15659,569.104315185547; 15660,569.102423095703; 15661,569.100531005859; 15662,569.098638916016; 15663,569.09677734375; 15664,569.094885253906; 15665,569.092993164063; 15666,569.091101074219; 15667,569.089208984375; 15668,569.087316894531; 15669,569.085424804688; 15670,569.083532714844; 15671,569.081640625; 15672,569.079748535156; 15673,569.077886962891; 15674,569.075994873047; 15675,569.074102783203; 15676,569.072210693359; 15677,569.070318603516; 15678,569.068426513672; 15679,569.066534423828; 15680,569.064642333984; 15681,569.062750244141; 15682,569.060888671875; 15683,569.058996582031; 15684,569.057104492188; 15685,569.055212402344; 15686,569.0533203125; 15687,
        569.051428222656; 15688,569.049536132813; 15689,569.047644042969; 15690,569.045751953125; 15691,569.043890380859; 15692,569.041998291016; 15693,569.040106201172; 15694,569.038214111328; 15695,569.036322021484; 15696,569.034429931641; 15697,569.032537841797; 15698,569.030645751953; 15699,569.028753662109; 15700,569.026892089844; 15701,569.025; 15702,569.023107910156; 15703,569.021215820313; 15704,569.019323730469; 15705,569.017431640625; 15706,569.015539550781; 15707,569.013647460938; 15708,569.011755371094; 15709,569.00986328125; 15710,569.008001708984; 15711,569.006109619141; 15712,569.004217529297; 15713,569.002325439453; 15714,569.000433349609; 15715,568.998541259766; 15716,568.996649169922; 15717,568.994757080078; 15718,568.992864990234; 15719,568.991003417969; 15720,568.989111328125; 15721,568.987219238281; 15722,568.985327148438; 15723,568.983435058594; 15724,568.98154296875; 15725,568.979650878906; 15726,568.977758789063; 15727,568.975866699219; 15728,568.974005126953;
        15729,568.972113037109; 15730,568.970220947266; 15731,568.968328857422; 15732,568.966436767578; 15733,568.964544677734; 15734,568.962652587891; 15735,568.960760498047; 15736,568.958868408203; 15737,568.956976318359; 15738,568.955114746094; 15739,568.95322265625; 15740,568.951330566406; 15741,568.949438476563; 15742,568.947546386719; 15743,568.945654296875; 15744,568.943762207031; 15745,568.941870117188; 15746,568.939978027344; 15747,568.938116455078; 15748,568.936224365234; 15749,568.934332275391; 15750,568.932440185547; 15751,568.930548095703; 15752,568.928656005859; 15753,568.926763916016; 15754,568.924871826172; 15755,568.922979736328; 15756,568.921118164063; 15757,568.919226074219; 15758,568.917333984375; 15759,568.915441894531; 15760,568.913549804688; 15761,568.911657714844; 15762,568.909765625; 15763,568.907873535156; 15764,568.905981445313; 15765,568.904119873047; 15766,568.902227783203; 15767,568.900335693359; 15768,568.906439208984; 15769,568.914617919922; 15770,
        568.922827148438; 15771,568.931005859375; 15772,568.939184570313; 15773,568.947393798828; 15774,568.955572509766; 15775,568.963751220703; 15776,568.971960449219; 15777,568.980139160156; 15778,568.988317871094; 15779,568.996527099609; 15780,569.004705810547; 15781,569.012884521484; 15782,569.02109375; 15783,569.029272460938; 15784,569.037451171875; 15785,569.045660400391; 15786,569.053839111328; 15787,569.062017822266; 15788,569.070227050781; 15789,569.078405761719; 15790,569.086584472656; 15791,569.094793701172; 15792,569.102972412109; 15793,569.111151123047; 15794,569.119360351563; 15795,569.1275390625; 15796,569.135717773438; 15797,569.143927001953; 15798,569.152105712891; 15799,569.160284423828; 15800,569.168493652344; 15801,569.176672363281; 15802,569.184851074219; 15803,569.193060302734; 15804,569.201239013672; 15805,569.209417724609; 15806,569.217626953125; 15807,569.225805664063; 15808,569.233984375; 15809,569.242193603516; 15810,569.250372314453; 15811,569.258551025391;
        15812,569.266760253906; 15813,569.274938964844; 15814,569.283117675781; 15815,569.291326904297; 15816,569.299505615234; 15817,569.307684326172; 15818,569.315893554688; 15819,569.324072265625; 15820,569.332250976563; 15821,569.340460205078; 15822,569.348638916016; 15823,569.356817626953; 15824,569.365026855469; 15825,569.373205566406; 15826,569.381384277344; 15827,569.389593505859; 15828,569.397772216797; 15829,569.405950927734; 15830,569.41416015625; 15831,569.422338867188; 15832,569.430517578125; 15833,569.438726806641; 15834,569.446905517578; 15835,569.455084228516; 15836,569.463293457031; 15837,569.471472167969; 15838,569.479650878906; 15839,569.487860107422; 15840,569.496038818359; 15841,569.504217529297; 15842,569.512426757813; 15843,569.52060546875; 15844,569.528784179688; 15845,569.536993408203; 15846,569.545172119141; 15847,569.553350830078; 15848,569.561560058594; 15849,569.569738769531; 15850,569.577917480469; 15851,569.586126708984; 15852,569.594305419922; 15853,
        569.602484130859; 15854,569.610693359375; 15855,569.618872070313; 15856,569.62705078125; 15857,569.635260009766; 15858,569.643438720703; 15859,569.651617431641; 15860,569.659826660156; 15861,569.668005371094; 15862,569.676184082031; 15863,569.684393310547; 15864,569.692572021484; 15865,569.700750732422; 15866,569.708959960938; 15867,569.717138671875; 15868,569.725317382813; 15869,569.733526611328; 15870,569.741705322266; 15871,569.749884033203; 15872,569.758093261719; 15873,569.766271972656; 15874,569.774450683594; 15875,569.782659912109; 15876,569.790838623047; 15877,569.799017333984; 15878,569.8072265625; 15879,569.815405273438; 15880,569.823583984375; 15881,569.831793212891; 15882,569.839971923828; 15883,569.848150634766; 15884,569.856359863281; 15885,569.864538574219; 15886,569.872717285156; 15887,569.880926513672; 15888,569.889105224609; 15889,569.897283935547; 15890,569.905493164063; 15891,569.913671875; 15892,569.921850585938; 15893,569.930059814453; 15894,
        569.938238525391; 15895,569.946417236328; 15896,569.954626464844; 15897,569.962805175781; 15898,569.970983886719; 15899,569.979193115234; 15900,569.987371826172; 15901,569.995550537109; 15902,570.003759765625; 15903,570.011938476563; 15904,570.0201171875; 15905,570.028326416016; 15906,570.036505126953; 15907,570.044683837891; 15908,570.052893066406; 15909,570.061071777344; 15910,570.069250488281; 15911,570.077459716797; 15912,570.085638427734; 15913,570.093817138672; 15914,570.102026367188; 15915,570.110205078125; 15916,570.118383789063; 15917,570.126593017578; 15918,570.134771728516; 15919,570.142950439453; 15920,570.151159667969; 15921,570.159338378906; 15922,570.167517089844; 15923,570.175726318359; 15924,570.183905029297; 15925,570.192083740234; 15926,570.20029296875; 15927,570.208471679688; 15928,570.216650390625; 15929,570.224859619141; 15930,570.233038330078; 15931,570.241217041016; 15932,570.249426269531; 15933,570.257604980469; 15934,570.265783691406; 15935,
        570.273992919922; 15936,570.282171630859; 15937,570.290350341797; 15938,570.298559570313; 15939,570.30673828125; 15940,570.314916992188; 15941,570.323126220703; 15942,570.331304931641; 15943,570.339483642578; 15944,570.347692871094; 15945,570.355871582031; 15946,570.364050292969; 15947,570.372259521484; 15948,570.380438232422; 15949,570.388616943359; 15950,570.396826171875; 15951,570.405004882813; 15952,570.41318359375; 15953,570.421392822266; 15954,570.429571533203; 15955,570.437750244141; 15956,570.445959472656; 15957,570.454138183594; 15958,570.462316894531; 15959,570.470526123047; 15960,570.478704833984; 15961,570.486883544922; 15962,570.495092773438; 15963,570.503271484375; 15964,570.511450195313; 15965,570.519659423828; 15966,570.527838134766; 15967,570.536016845703; 15968,570.544226074219; 15969,570.552404785156; 15970,570.560583496094; 15971,570.568792724609; 15972,570.576971435547; 15973,570.585150146484; 15974,570.593359375; 15975,570.601538085938; 15976,
        570.609716796875; 15977,570.617926025391; 15978,570.626104736328; 15979,570.634283447266; 15980,570.642492675781; 15981,570.650671386719; 15982,570.658850097656; 15983,570.667059326172; 15984,570.675238037109; 15985,570.683416748047; 15986,570.691625976563; 15987,570.6998046875; 15988,570.707983398438; 15989,570.716192626953; 15990,570.724371337891; 15991,570.732550048828; 15992,570.740759277344; 15993,570.748937988281; 15994,570.757116699219; 15995,570.765325927734; 15996,570.773504638672; 15997,570.781683349609; 15998,570.789892578125; 15999,570.798071289063; 16000,570.80625; 16001,570.814459228516; 16002,570.822637939453; 16003,570.830816650391; 16004,570.839025878906; 16005,570.847204589844; 16006,570.855383300781; 16007,570.863592529297; 16008,570.871771240234; 16009,570.879949951172; 16010,570.888159179688; 16011,570.896337890625; 16012,570.904516601563; 16013,570.912725830078; 16014,570.920904541016; 16015,570.929083251953; 16016,570.937292480469; 16017,570.945471191406;
        16018,570.953649902344; 16019,570.961859130859; 16020,570.970037841797; 16021,570.978216552734; 16022,570.98642578125; 16023,570.994604492188; 16024,571.002783203125; 16025,571.010992431641; 16026,571.019171142578; 16027,571.027349853516; 16028,571.035559082031; 16029,571.043737792969; 16030,571.051916503906; 16031,571.060125732422; 16032,571.068304443359; 16033,571.076483154297; 16034,571.084692382813; 16035,571.09287109375; 16036,571.101049804688; 16037,571.109259033203; 16038,571.117437744141; 16039,571.125616455078; 16040,571.133825683594; 16041,571.142004394531; 16042,571.150183105469; 16043,571.158392333984; 16044,571.166571044922; 16045,571.174749755859; 16046,571.182958984375; 16047,571.191137695313; 16048,571.19931640625; 16049,571.207525634766; 16050,571.215704345703; 16051,571.223883056641; 16052,571.232092285156; 16053,571.240270996094; 16054,571.248449707031; 16055,571.256658935547; 16056,571.264837646484; 16057,571.273016357422; 16058,571.281225585938; 16059,
        571.289404296875; 16060,571.297583007813; 16061,571.305792236328; 16062,571.313970947266; 16063,571.322149658203; 16064,571.330358886719; 16065,571.338537597656; 16066,571.346716308594; 16067,571.354925537109; 16068,571.363104248047; 16069,571.371282958984; 16070,571.3794921875; 16071,571.387670898438; 16072,571.395849609375; 16073,571.404058837891; 16074,571.412237548828; 16075,571.420416259766; 16076,571.428625488281; 16077,571.436804199219; 16078,571.444982910156; 16079,571.449591064453; 16080,571.448767089844; 16081,571.447912597656; 16082,571.447088623047; 16083,571.446234130859; 16084,571.44541015625; 16085,571.444586181641; 16086,571.443731689453; 16087,571.442907714844; 16088,571.442053222656; 16089,571.441229248047; 16090,571.440374755859; 16091,571.43955078125; 16092,571.438726806641; 16093,571.437872314453; 16094,571.437048339844; 16095,571.436193847656; 16096,571.435369873047; 16097,571.434515380859; 16098,571.43369140625; 16099,571.432867431641; 16100,
        571.432012939453; 16101,571.431188964844; 16102,571.430334472656; 16103,571.429510498047; 16104,571.428656005859; 16105,571.42783203125; 16106,571.427008056641; 16107,571.426153564453; 16108,571.425329589844; 16109,571.424475097656; 16110,571.423651123047; 16111,571.422796630859; 16112,571.42197265625; 16113,571.421148681641; 16114,571.420294189453; 16115,571.419470214844; 16116,571.418615722656; 16117,571.417791748047; 16118,571.416937255859; 16119,571.41611328125; 16120,571.415289306641; 16121,571.414434814453; 16122,571.413610839844; 16123,571.412756347656; 16124,571.411932373047; 16125,571.411077880859; 16126,571.41025390625; 16127,571.409429931641; 16128,571.408575439453; 16129,571.407751464844; 16130,571.406896972656; 16131,571.406072998047; 16132,571.405218505859; 16133,571.40439453125; 16134,571.403570556641; 16135,571.402716064453; 16136,571.401892089844; 16137,571.401037597656; 16138,571.400213623047; 16139,571.399359130859; 16140,571.39853515625; 16141,
        571.397711181641; 16142,571.396856689453; 16143,571.396032714844; 16144,571.395178222656; 16145,571.394354248047; 16146,571.393499755859; 16147,571.39267578125; 16148,571.391851806641; 16149,571.390997314453; 16150,571.390173339844; 16151,571.389318847656; 16152,571.388494873047; 16153,571.387640380859; 16154,571.38681640625; 16155,571.385992431641; 16156,571.385137939453; 16157,571.384313964844; 16158,571.383459472656; 16159,571.382635498047; 16160,571.381781005859; 16161,571.38095703125; 16162,571.380133056641; 16163,571.379278564453; 16164,571.378454589844; 16165,571.377600097656; 16166,571.376776123047; 16167,571.375921630859; 16168,571.37509765625; 16169,571.374273681641; 16170,571.373419189453; 16171,571.372595214844; 16172,571.371740722656; 16173,571.370916748047; 16174,571.370062255859; 16175,571.36923828125; 16176,571.368414306641; 16177,571.367559814453; 16178,571.366735839844; 16179,571.365881347656; 16180,571.365057373047; 16181,571.364202880859; 16182,
        571.36337890625; 16183,571.362554931641; 16184,571.361700439453; 16185,571.360876464844; 16186,571.360021972656; 16187,571.359197998047; 16188,571.358343505859; 16189,571.35751953125; 16190,571.356695556641; 16191,571.355841064453; 16192,571.355017089844; 16193,571.354162597656; 16194,571.353338623047; 16195,571.352514648438; 16196,571.35166015625; 16197,571.350836181641; 16198,571.349981689453; 16199,571.349157714844; 16200,571.348303222656; 16201,571.347479248047; 16202,571.346655273438; 16203,571.34580078125; 16204,571.344976806641; 16205,571.344122314453; 16206,571.343298339844; 16207,571.342443847656; 16208,571.341619873047; 16209,571.340795898438; 16210,571.33994140625; 16211,571.339117431641; 16212,571.338262939453; 16213,571.337438964844; 16214,571.336584472656; 16215,571.335760498047; 16216,571.334936523438; 16217,571.33408203125; 16218,571.333258056641; 16219,571.332403564453; 16220,571.331579589844; 16221,571.330725097656; 16222,571.329901123047; 16223,
        571.329077148438; 16224,571.32822265625; 16225,571.327398681641; 16226,571.326544189453; 16227,571.325720214844; 16228,571.324865722656; 16229,571.324041748047; 16230,571.323217773438; 16231,571.32236328125; 16232,571.321539306641; 16233,571.320684814453; 16234,571.319860839844; 16235,571.319006347656; 16236,571.318182373047; 16237,571.317358398438; 16238,571.31650390625; 16239,571.315679931641; 16240,571.314825439453; 16241,571.314001464844; 16242,571.313146972656; 16243,571.312322998047; 16244,571.311499023438; 16245,571.31064453125; 16246,571.309820556641; 16247,571.308966064453; 16248,571.308142089844; 16249,571.307287597656; 16250,571.306463623047; 16251,571.305639648438; 16252,571.30478515625; 16253,571.303961181641; 16254,571.303106689453; 16255,571.302282714844; 16256,571.301428222656; 16257,571.300604248047; 16258,571.299780273438; 16259,571.29892578125; 16260,571.298101806641; 16261,571.297247314453; 16262,571.296423339844; 16263,571.295568847656; 16264,
        571.294744873047; 16265,571.293920898438; 16266,571.29306640625; 16267,571.292242431641; 16268,571.291387939453; 16269,571.290563964844; 16270,571.289709472656; 16271,571.288885498047; 16272,571.288061523438; 16273,571.28720703125; 16274,571.286383056641; 16275,571.285528564453; 16276,571.284704589844; 16277,571.283850097656; 16278,571.283026123047; 16279,571.282202148438; 16280,571.28134765625; 16281,571.280523681641; 16282,571.279669189453; 16283,571.278845214844; 16284,571.277990722656; 16285,571.277166748047; 16286,571.276342773438; 16287,571.27548828125; 16288,571.274664306641; 16289,571.273809814453; 16290,571.272985839844; 16291,571.272131347656; 16292,571.271307373047; 16293,571.270483398438; 16294,571.26962890625; 16295,571.268804931641; 16296,571.267950439453; 16297,571.267126464844; 16298,571.266271972656; 16299,571.265447998047; 16300,571.264624023438; 16301,571.26376953125; 16302,571.262945556641; 16303,571.262091064453; 16304,571.261267089844; 16305,
        571.260412597656; 16306,571.259588623047; 16307,571.258764648438; 16308,571.25791015625; 16309,571.257086181641; 16310,571.256231689453; 16311,571.255407714844; 16312,571.254583740234; 16313,571.253729248047; 16314,571.252905273438; 16315,571.25205078125; 16316,571.251226806641; 16317,571.250372314453; 16318,571.249548339844; 16319,571.248724365234; 16320,571.247869873047; 16321,571.247045898438; 16322,571.24619140625; 16323,571.245367431641; 16324,571.244512939453; 16325,571.243688964844; 16326,571.242864990234; 16327,571.242010498047; 16328,571.241186523438; 16329,571.24033203125; 16330,571.239508056641; 16331,571.238653564453; 16332,571.237829589844; 16333,571.237005615234; 16334,571.236151123047; 16335,571.235327148438; 16336,571.23447265625; 16337,571.233648681641; 16338,571.232794189453; 16339,571.231970214844; 16340,571.231146240234; 16341,571.230291748047; 16342,571.229467773438; 16343,571.22861328125; 16344,571.227789306641; 16345,571.226934814453; 16346,
        571.226110839844; 16347,571.225286865234; 16348,571.224432373047; 16349,571.223608398438; 16350,571.22275390625; 16351,571.221929931641; 16352,571.221075439453; 16353,571.220251464844; 16354,571.219427490234; 16355,571.218572998047; 16356,571.217749023438; 16357,571.21689453125; 16358,571.216070556641; 16359,571.215216064453; 16360,571.214392089844; 16361,571.213568115234; 16362,571.212713623047; 16363,571.211889648438; 16364,571.21103515625; 16365,571.210211181641; 16366,571.209356689453; 16367,571.208532714844; 16368,571.207708740234; 16369,571.206854248047; 16370,571.206030273438; 16371,571.20517578125; 16372,571.204351806641; 16373,571.203497314453; 16374,571.202673339844; 16375,571.201849365234; 16376,571.200994873047; 16377,571.200170898438; 16378,571.19931640625; 16379,571.198492431641; 16380,571.197637939453; 16381,571.196813964844; 16382,571.195989990234; 16383,571.195135498047; 16384,571.194311523438; 16385,571.19345703125; 16386,571.192633056641; 16387,
        571.191778564453; 16388,571.190954589844; 16389,571.190130615234; 16390,571.189276123047; 16391,571.188452148438; 16392,571.18759765625; 16393,571.186773681641; 16394,571.185919189453; 16395,571.185095214844; 16396,571.184271240234; 16397,571.183416748047; 16398,571.182592773438; 16399,571.18173828125; 16400,571.180914306641; 16401,571.180059814453; 16402,571.179235839844; 16403,571.178411865234; 16404,571.177557373047; 16405,571.176733398438; 16406,571.17587890625; 16407,571.175054931641; 16408,571.174200439453; 16409,571.173376464844; 16410,571.172552490234; 16411,571.171697998047; 16412,571.170874023438; 16413,571.17001953125; 16414,571.169195556641; 16415,571.168341064453; 16416,571.167517089844; 16417,571.166693115234; 16418,571.165838623047; 16419,571.165014648438; 16420,571.16416015625; 16421,571.163336181641; 16422,571.162481689453; 16423,571.161657714844; 16424,571.160833740234; 16425,571.159979248047; 16426,571.159155273438; 16427,571.15830078125; 16428,
        571.157476806641; 16429,571.156622314453; 16430,571.155798339844; 16431,571.154974365234; 16432,571.154119873047; 16433,571.153295898438; 16434,571.15244140625; 16435,571.151617431641; 16436,571.150793457031; 16437,571.149938964844; 16438,571.149114990234; 16439,571.148260498047; 16440,571.147436523438; 16441,571.14658203125; 16442,571.145758056641; 16443,571.144934082031; 16444,571.144079589844; 16445,571.143255615234; 16446,571.142401123047; 16447,571.141577148438; 16448,571.14072265625; 16449,571.139898681641; 16450,571.139074707031; 16451,571.138220214844; 16452,571.137396240234; 16453,571.136541748047; 16454,571.135717773438; 16455,571.13486328125; 16456,571.134039306641; 16457,571.133215332031; 16458,571.132360839844; 16459,571.131536865234; 16460,571.130682373047; 16461,571.129858398438; 16462,571.12900390625; 16463,571.128179931641; 16464,571.127355957031; 16465,571.126501464844; 16466,571.125677490234; 16467,571.124822998047; 16468,571.123999023438; 16469,
        571.12314453125; 16470,571.122320556641; 16471,571.121496582031; 16472,571.120642089844; 16473,571.119818115234; 16474,571.118963623047; 16475,571.118139648438; 16476,571.11728515625; 16477,571.116461181641; 16478,571.115637207031; 16479,571.114782714844; 16480,571.113958740234; 16481,571.113104248047; 16482,571.112280273438; 16483,571.11142578125; 16484,571.110601806641; 16485,571.109777832031; 16486,571.108923339844; 16487,571.108099365234; 16488,571.107244873047; 16489,571.106420898438; 16490,571.10556640625; 16491,571.104742431641; 16492,571.103918457031; 16493,571.103063964844; 16494,571.102239990234; 16495,571.101385498047; 16496,571.100561523438; 16497,571.09970703125; 16498,571.098883056641; 16499,571.098059082031; 16500,575.15; 20000,575.15]) annotation (Placement(transformation(extent={{-440,-180},{-420,-160}})));
  Modelica.Blocks.Sources.TimeTable timeTableTempAir_complete(table=[0,575.280584716797; 5,575.276007080078; 10,575.271429443359; 15,575.266851806641; 20,575.262274169922; 25,575.257727050781; 30,575.253149414063; 35,575.248571777344; 40,575.243994140625; 45,575.239416503906; 50,575.234838867188; 55,575.230261230469; 60,575.22568359375; 65,575.221105957031; 70,575.216528320313; 75,575.211950683594; 80,575.207373046875; 85,575.202795410156; 90,575.198248291016; 95,575.193670654297; 100,575.189093017578; 105,575.184515380859; 110,575.179937744141; 115,575.175360107422; 120,575.170782470703; 125,575.166204833984; 130,575.161627197266; 135,575.157049560547; 140,575.152471923828; 145,575.147894287109; 150,575.143316650391; 155,575.138739013672; 160,575.134191894531; 165,575.129614257813; 170,575.125036621094; 175,575.120458984375; 180,575.115881347656; 185,575.111303710938; 190,575.106726074219; 195,575.1021484375; 200,575.097570800781; 205,575.092993164063; 210,575.088415527344; 215,
        575.083837890625; 220,575.079260253906; 225,575.074713134766; 230,575.070135498047; 235,575.065557861328; 240,575.060980224609; 245,575.056402587891; 250,575.051824951172; 255,575.047247314453; 260,575.042669677734; 265,575.038092041016; 270,575.033514404297; 275,575.028936767578; 280,575.024359130859; 285,575.019781494141; 290,575.015234375; 295,575.010656738281; 300,575.006079101563; 305,575.001501464844; 310,574.996923828125; 315,574.992346191406; 320,574.987768554688; 325,574.983190917969; 330,574.97861328125; 335,574.974035644531; 340,574.969458007813; 345,574.964880371094; 350,574.960302734375; 355,574.955755615234; 360,574.951177978516; 365,574.946600341797; 370,574.942022705078; 375,574.937445068359; 380,574.932867431641; 385,574.928289794922; 390,574.923712158203; 395,574.919134521484; 400,574.914556884766; 405,574.909979248047; 410,574.905401611328; 415,574.900823974609; 420,574.896246337891; 425,574.89169921875; 430,574.887121582031; 435,574.882543945313; 440,
        574.877966308594; 445,574.873388671875; 450,574.868811035156; 455,574.864233398438; 460,574.859655761719; 465,574.855078125; 470,574.850500488281; 475,574.845922851563; 480,574.841345214844; 485,574.836767578125; 490,574.832220458984; 495,574.827642822266; 500,574.823065185547; 505,574.818487548828; 510,574.813909912109; 515,574.809332275391; 520,574.804754638672; 525,574.800177001953; 530,574.795599365234; 535,574.791021728516; 540,574.786444091797; 545,574.781866455078; 550,574.777288818359; 555,574.772741699219; 560,574.7681640625; 565,574.763586425781; 570,574.759008789063; 575,574.754431152344; 580,574.749853515625; 585,574.745275878906; 590,574.740698242188; 595,574.736120605469; 600,574.73154296875; 605,574.726965332031; 610,574.722387695313; 615,574.717810058594; 620,574.713262939453; 625,574.708685302734; 630,574.704107666016; 635,574.699530029297; 640,574.694952392578; 645,574.690374755859; 650,574.685797119141; 655,574.681219482422; 660,574.676641845703; 665,
        574.672064208984; 670,574.667486572266; 675,574.662908935547; 680,574.658331298828; 685,574.653784179688; 690,574.649206542969; 695,574.64462890625; 700,574.640051269531; 705,574.635473632813; 710,574.630895996094; 715,574.626318359375; 720,574.621740722656; 725,574.617163085938; 730,574.612585449219; 735,574.6080078125; 740,574.603430175781; 745,574.598852539063; 750,574.594274902344; 755,574.589727783203; 760,574.585150146484; 765,574.580572509766; 770,574.575994873047; 775,574.571417236328; 780,574.566839599609; 785,574.562261962891; 790,574.557684326172; 795,574.553106689453; 800,574.548529052734; 805,574.543951416016; 810,574.539373779297; 815,574.534796142578; 820,574.530249023438; 825,574.525671386719; 830,574.52109375; 835,574.516516113281; 840,574.511938476563; 845,574.507360839844; 850,574.502783203125; 855,574.498205566406; 860,574.493627929688; 865,574.489050292969; 870,574.48447265625; 875,574.479895019531; 880,574.475317382813; 885,574.470770263672; 890,
        574.466192626953; 895,574.461614990234; 900,574.457037353516; 905,574.452459716797; 910,574.447882080078; 915,574.443304443359; 920,574.438726806641; 925,574.434149169922; 930,574.429571533203; 935,574.424993896484; 940,574.420416259766; 945,574.415838623047; 950,574.411291503906; 955,574.406713867188; 960,574.402136230469; 965,574.39755859375; 970,574.392980957031; 975,574.388403320313; 980,574.383825683594; 985,574.379248046875; 990,574.374670410156; 995,574.370092773438; 1000,574.365515136719; 1005,574.3609375; 1010,574.356359863281; 1015,574.351812744141; 1020,574.350225830078; 1025,574.35068359375; 1030,574.351141357422; 1035,574.351629638672; 1040,574.352087402344; 1045,574.352545166016; 1050,574.353002929688; 1055,574.353460693359; 1060,574.353948974609; 1065,574.354406738281; 1070,574.354864501953; 1075,574.355322265625; 1080,574.355780029297; 1085,574.356268310547; 1090,574.356726074219; 1095,574.357183837891; 1100,574.357641601563; 1105,574.358099365234; 1110,
        574.358587646484; 1115,574.359045410156; 1120,574.359503173828; 1125,574.3599609375; 1130,574.360418701172; 1135,574.360876464844; 1140,574.361364746094; 1145,574.361822509766; 1150,574.362280273438; 1155,574.362738037109; 1160,574.363195800781; 1165,574.363684082031; 1170,574.364141845703; 1175,574.364599609375; 1180,574.365057373047; 1185,574.365515136719; 1190,574.366003417969; 1195,574.366461181641; 1200,574.366918945313; 1205,574.367376708984; 1210,574.367834472656; 1215,574.368322753906; 1220,574.368780517578; 1225,574.36923828125; 1230,574.369696044922; 1235,574.370153808594; 1240,574.370642089844; 1245,574.371099853516; 1250,574.371557617188; 1255,574.372015380859; 1260,574.372473144531; 1265,574.372961425781; 1270,574.373419189453; 1275,574.373876953125; 1280,574.374334716797; 1285,574.374792480469; 1290,574.375250244141; 1295,574.375738525391; 1300,574.376196289063; 1305,574.376654052734; 1310,574.377111816406; 1315,574.377569580078; 1320,574.378057861328; 1325,
        574.378515625; 1330,574.378973388672; 1335,574.379431152344; 1340,574.379888916016; 1345,574.380377197266; 1350,574.380834960938; 1355,574.381292724609; 1360,574.381750488281; 1365,574.382208251953; 1370,574.382696533203; 1375,574.383154296875; 1380,574.383612060547; 1385,574.384069824219; 1390,574.384527587891; 1395,574.385015869141; 1400,574.385473632813; 1405,574.385931396484; 1410,574.386389160156; 1415,574.386846923828; 1420,574.3873046875; 1425,574.38779296875; 1430,574.388250732422; 1435,574.388708496094; 1440,574.389166259766; 1445,574.389624023438; 1450,574.390112304688; 1455,574.390570068359; 1460,574.391027832031; 1465,574.391485595703; 1470,574.391943359375; 1475,574.392431640625; 1480,574.392889404297; 1485,574.393347167969; 1490,574.393804931641; 1495,574.394262695313; 1500,574.394750976563; 1505,574.395208740234; 1510,574.395666503906; 1515,574.396124267578; 1520,574.39658203125; 1525,574.3970703125; 1530,574.397528076172; 1535,574.397985839844; 1540,
        574.398443603516; 1545,574.398901367188; 1550,574.399389648438; 1555,574.399847412109; 1560,574.400305175781; 1565,574.400762939453; 1570,574.401220703125; 1575,574.401678466797; 1580,574.402166748047; 1585,574.402624511719; 1590,574.403082275391; 1595,574.403540039063; 1600,574.403997802734; 1605,574.404486083984; 1610,574.404943847656; 1615,574.405401611328; 1620,574.405859375; 1625,574.406317138672; 1630,574.406805419922; 1635,574.407263183594; 1640,574.407720947266; 1645,574.408178710938; 1650,574.408636474609; 1655,574.409124755859; 1660,574.409582519531; 1665,574.410040283203; 1670,574.410498046875; 1675,574.410955810547; 1680,574.411444091797; 1685,574.411901855469; 1690,574.412359619141; 1695,574.412817382813; 1700,574.413275146484; 1705,574.413732910156; 1710,574.414221191406; 1715,574.414678955078; 1720,574.41513671875; 1725,574.415594482422; 1730,574.416052246094; 1735,574.416540527344; 1740,574.416998291016; 1745,574.417456054688; 1750,574.417913818359; 1755,
        574.418371582031; 1760,574.418859863281; 1765,574.419317626953; 1770,574.419775390625; 1775,574.420233154297; 1780,574.420690917969; 1785,574.421179199219; 1790,574.421636962891; 1795,574.422094726563; 1800,574.422552490234; 1805,574.423010253906; 1810,574.423498535156; 1815,574.423956298828; 1820,574.4244140625; 1825,574.424871826172; 1830,574.425329589844; 1835,574.425817871094; 1840,574.426275634766; 1845,574.426733398438; 1850,574.427191162109; 1855,574.427648925781; 1860,574.428106689453; 1865,574.428594970703; 1870,574.429052734375; 1875,574.429510498047; 1880,574.429968261719; 1885,574.430426025391; 1890,574.430914306641; 1895,574.431372070313; 1900,574.431829833984; 1905,574.432287597656; 1910,574.432745361328; 1915,574.433233642578; 1920,574.43369140625; 1925,574.434149169922; 1930,574.434606933594; 1935,574.435064697266; 1940,574.435552978516; 1945,574.436010742188; 1950,574.436468505859; 1955,574.436926269531; 1960,574.437384033203; 1965,574.437872314453; 1970,
        574.438330078125; 1975,574.438787841797; 1980,574.439245605469; 1985,574.439703369141; 1990,574.440161132813; 1995,574.440649414063; 2000,574.441107177734; 2005,574.441564941406; 2010,574.442022705078; 2015,574.44248046875; 2020,574.44296875; 2025,574.443426513672; 2030,574.443884277344; 2035,574.444342041016; 2040,574.444799804688; 2045,574.445288085938; 2050,574.445745849609; 2055,574.446203613281; 2060,574.446661376953; 2065,574.447119140625; 2070,574.447607421875; 2075,574.448065185547; 2080,574.448522949219; 2085,574.448980712891; 2090,574.449438476563; 2095,574.449926757813; 2100,574.450384521484; 2105,574.450842285156; 2110,574.451300048828; 2115,574.4517578125; 2120,574.45224609375; 2125,574.452703857422; 2130,574.453161621094; 2135,574.453619384766; 2140,574.454077148438; 2145,574.454534912109; 2150,574.455023193359; 2155,574.455480957031; 2160,574.455938720703; 2165,574.456396484375; 2170,574.456854248047; 2175,574.457342529297; 2180,574.457800292969; 2185,
        574.458258056641; 2190,574.458715820313; 2195,574.459173583984; 2200,574.459661865234; 2205,574.460119628906; 2210,574.460577392578; 2215,574.46103515625; 2220,574.461492919922; 2225,574.461981201172; 2230,574.462438964844; 2235,574.462896728516; 2240,574.463354492188; 2245,574.463812255859; 2250,574.464300537109; 2255,574.464758300781; 2260,574.465216064453; 2265,574.465673828125; 2270,574.466131591797; 2275,574.466589355469; 2280,574.467077636719; 2285,574.467535400391; 2290,574.467993164063; 2295,574.468450927734; 2300,574.468908691406; 2305,574.469396972656; 2310,574.469854736328; 2315,574.4703125; 2320,574.470770263672; 2325,574.471228027344; 2330,574.471716308594; 2335,574.472174072266; 2340,574.472631835938; 2345,574.473089599609; 2350,574.473547363281; 2355,574.474035644531; 2360,574.474493408203; 2365,574.474951171875; 2370,574.475408935547; 2375,574.475866699219; 2380,574.476354980469; 2385,574.476812744141; 2390,574.477270507813; 2395,574.477728271484; 2400,
        574.478186035156; 2405,574.478674316406; 2410,574.479132080078; 2415,574.47958984375; 2420,574.480047607422; 2425,574.480505371094; 2430,574.480963134766; 2435,574.481451416016; 2440,574.481909179688; 2445,574.482366943359; 2450,574.482824707031; 2455,574.483282470703; 2460,574.483770751953; 2465,574.484228515625; 2470,574.484686279297; 2475,574.485144042969; 2480,574.485601806641; 2485,574.486090087891; 2490,574.486547851563; 2495,574.487005615234; 2500,574.487463378906; 2505,574.487921142578; 2510,574.488409423828; 2515,574.4888671875; 2520,574.489324951172; 2525,574.489782714844; 2530,574.490240478516; 2535,574.490728759766; 2540,574.491186523438; 2545,574.491644287109; 2550,574.492102050781; 2555,574.492559814453; 2560,574.493017578125; 2565,574.493505859375; 2570,574.493963623047; 2575,574.494421386719; 2580,574.494879150391; 2585,574.495336914063; 2590,574.495825195313; 2595,574.496282958984; 2600,574.496740722656; 2605,574.497198486328; 2610,574.49765625; 2615,
        574.49814453125; 2620,574.498602294922; 2625,574.499060058594; 2630,574.499517822266; 2635,574.499975585938; 2640,574.500463867188; 2645,574.500921630859; 2650,574.501379394531; 2655,574.501837158203; 2660,574.502294921875; 2665,574.502783203125; 2670,574.503240966797; 2675,574.503698730469; 2680,574.504156494141; 2685,574.504614257813; 2690,574.505102539063; 2695,574.505560302734; 2700,574.506018066406; 2705,574.506475830078; 2710,574.50693359375; 2715,574.507391357422; 2720,574.507879638672; 2725,574.508337402344; 2730,574.508795166016; 2735,574.509252929688; 2740,574.509710693359; 2745,574.510198974609; 2750,574.510656738281; 2755,574.511114501953; 2760,574.511572265625; 2765,574.512030029297; 2770,574.512518310547; 2775,574.512976074219; 2780,574.513433837891; 2785,574.513891601563; 2790,574.514349365234; 2795,574.514837646484; 2800,574.515295410156; 2805,574.515753173828; 2810,574.5162109375; 2815,574.516668701172; 2820,574.517156982422; 2825,574.517614746094; 2830,
        574.518072509766; 2835,574.518530273438; 2840,574.518988037109; 2845,574.519445800781; 2850,574.519934082031; 2855,574.520391845703; 2860,574.520849609375; 2865,574.521307373047; 2870,574.521765136719; 2875,574.522253417969; 2880,574.522711181641; 2885,574.523168945313; 2890,574.523626708984; 2895,574.524084472656; 2900,574.524572753906; 2905,574.525030517578; 2910,574.52548828125; 2915,574.525946044922; 2920,574.526403808594; 2925,574.526892089844; 2930,574.527349853516; 2935,574.527807617188; 2940,574.528265380859; 2945,574.528723144531; 2950,574.529211425781; 2955,574.529669189453; 2960,574.530126953125; 2965,574.530584716797; 2970,574.531042480469; 2975,574.531530761719; 2980,574.531988525391; 2985,574.532446289063; 2990,574.532904052734; 2995,574.533361816406; 3000,574.533819580078; 3005,574.534307861328; 3010,574.534765625; 3015,574.535223388672; 3020,574.535681152344; 3025,574.536138916016; 3030,574.536627197266; 3035,574.537084960938; 3040,574.537542724609; 3045,
        574.538000488281; 3050,574.538458251953; 3055,574.538946533203; 3060,574.539404296875; 3065,574.539862060547; 3070,574.540319824219; 3075,574.540777587891; 3080,574.541265869141; 3085,574.541723632813; 3090,574.542181396484; 3095,574.542639160156; 3100,574.543096923828; 3105,574.543585205078; 3110,574.54404296875; 3115,574.544500732422; 3120,574.544958496094; 3125,574.545416259766; 3130,574.545874023438; 3135,574.546362304688; 3140,574.546820068359; 3145,574.547277832031; 3150,574.547735595703; 3155,574.548193359375; 3160,574.548681640625; 3165,574.549139404297; 3170,574.549597167969; 3175,574.549200439453; 3180,574.545690917969; 3185,574.542181396484; 3190,574.538641357422; 3195,574.535131835938; 3200,574.531591796875; 3205,574.528082275391; 3210,574.524572753906; 3215,574.521032714844; 3220,574.517523193359; 3225,574.513983154297; 3230,574.510473632813; 3235,574.506964111328; 3240,574.503424072266; 3245,574.499914550781; 3250,574.496374511719; 3255,574.492864990234; 3260,
        574.48935546875; 3265,574.485815429688; 3270,574.482305908203; 3275,574.478765869141; 3280,574.475256347656; 3285,574.471716308594; 3290,574.468206787109; 3295,574.464697265625; 3300,574.461157226563; 3305,574.457647705078; 3310,574.454107666016; 3315,574.450598144531; 3320,574.447088623047; 3325,574.443548583984; 3330,574.4400390625; 3335,574.436499023438; 3340,574.432989501953; 3345,574.429479980469; 3350,574.425939941406; 3355,574.422430419922; 3360,574.418890380859; 3365,574.415380859375; 3370,574.411871337891; 3375,574.408331298828; 3380,574.404821777344; 3385,574.401281738281; 3390,574.397772216797; 3395,574.394232177734; 3400,574.39072265625; 3405,574.387213134766; 3410,574.383673095703; 3415,574.380163574219; 3420,574.376623535156; 3425,574.373114013672; 3430,574.369604492188; 3435,574.366064453125; 3440,574.362554931641; 3445,574.359014892578; 3450,574.355505371094; 3455,574.351995849609; 3460,574.348455810547; 3465,574.344946289063; 3470,574.34140625; 3475,
        574.337896728516; 3480,574.334356689453; 3485,574.330847167969; 3490,574.327337646484; 3495,574.323797607422; 3500,574.320288085938; 3505,574.316748046875; 3510,574.313238525391; 3515,574.309729003906; 3520,574.306188964844; 3525,574.302679443359; 3530,574.299139404297; 3535,574.295629882813; 3540,574.292120361328; 3545,574.288580322266; 3550,574.285070800781; 3555,574.281530761719; 3560,574.278021240234; 3565,574.27451171875; 3570,574.270971679688; 3575,574.267462158203; 3580,574.263922119141; 3585,574.260412597656; 3590,574.256872558594; 3595,574.253363037109; 3600,574.249853515625; 3605,574.246313476563; 3610,574.242803955078; 3615,574.239263916016; 3620,574.235754394531; 3625,574.232244873047; 3630,574.228704833984; 3635,574.2251953125; 3640,574.221655273438; 3645,574.218145751953; 3650,574.214636230469; 3655,574.211096191406; 3660,574.207586669922; 3665,574.204046630859; 3670,574.200537109375; 3675,574.197027587891; 3680,574.193487548828; 3685,574.189978027344; 3690,
        574.186437988281; 3695,574.182928466797; 3700,574.179388427734; 3705,574.17587890625; 3710,574.172369384766; 3715,574.168829345703; 3720,574.165319824219; 3725,574.161779785156; 3730,574.158270263672; 3735,574.154760742188; 3740,574.151220703125; 3745,574.147711181641; 3750,574.144171142578; 3755,574.140661621094; 3760,574.137152099609; 3765,574.133612060547; 3770,574.130102539063; 3775,574.1265625; 3780,574.123052978516; 3785,574.119543457031; 3790,574.116003417969; 3795,574.112493896484; 3800,574.108953857422; 3805,574.105444335938; 3810,574.101904296875; 3815,574.098394775391; 3820,574.094885253906; 3825,574.091345214844; 3830,574.087835693359; 3835,574.084295654297; 3840,574.080786132813; 3845,574.077276611328; 3850,574.073736572266; 3855,574.070227050781; 3860,574.066687011719; 3865,574.063177490234; 3870,574.05966796875; 3875,574.056127929688; 3880,574.052618408203; 3885,574.049078369141; 3890,574.045568847656; 3895,574.042028808594; 3900,574.038519287109; 3905,
        574.035009765625; 3910,574.031469726563; 3915,574.027960205078; 3920,574.024420166016; 3925,574.020910644531; 3930,574.017401123047; 3935,574.013861083984; 3940,574.0103515625; 3945,574.006811523438; 3950,574.003302001953; 3955,573.999792480469; 3960,573.996252441406; 3965,573.992742919922; 3970,573.989202880859; 3975,573.985693359375; 3980,573.982183837891; 3985,573.978643798828; 3990,573.975134277344; 3995,573.971594238281; 4000,573.968084716797; 4005,573.964544677734; 4010,573.96103515625; 4015,573.957525634766; 4020,573.953985595703; 4025,573.950476074219; 4030,573.946936035156; 4035,573.943426513672; 4040,573.939916992188; 4045,573.936376953125; 4050,573.932867431641; 4055,573.929327392578; 4060,573.925817871094; 4065,573.922308349609; 4070,573.918768310547; 4075,573.915258789063; 4080,573.91171875; 4085,573.908209228516; 4090,573.904699707031; 4095,573.901159667969; 4100,573.897650146484; 4105,573.894110107422; 4110,573.890600585938; 4115,573.887060546875; 4120,
        573.883551025391; 4125,573.880041503906; 4130,573.876501464844; 4135,573.872991943359; 4140,573.869451904297; 4145,573.865942382813; 4150,573.862432861328; 4155,573.858892822266; 4160,573.855383300781; 4165,573.851843261719; 4170,573.848333740234; 4175,573.84482421875; 4180,573.841284179688; 4185,573.837774658203; 4190,573.834234619141; 4195,573.830725097656; 4200,573.827185058594; 4205,573.823675537109; 4210,573.820166015625; 4215,573.816625976563; 4220,573.813116455078; 4225,573.809576416016; 4230,573.806066894531; 4235,573.802557373047; 4240,573.799017333984; 4245,573.7955078125; 4250,573.791967773438; 4255,573.788458251953; 4260,573.784948730469; 4265,573.781408691406; 4270,573.777899169922; 4275,573.774359130859; 4280,573.770849609375; 4285,573.767340087891; 4290,573.763800048828; 4295,573.760290527344; 4300,573.756750488281; 4305,573.753240966797; 4310,573.749700927734; 4315,573.74619140625; 4320,573.742681884766; 4325,573.739141845703; 4330,573.735632324219; 4335,
        573.732092285156; 4340,573.728582763672; 4345,573.725073242188; 4350,573.721533203125; 4355,573.718023681641; 4360,573.714483642578; 4365,573.710974121094; 4370,573.707464599609; 4375,573.703924560547; 4380,573.700415039063; 4385,573.696875; 4390,573.693365478516; 4395,573.689855957031; 4400,573.686315917969; 4405,573.682806396484; 4410,573.679266357422; 4415,573.675756835938; 4420,573.672216796875; 4425,573.668707275391; 4430,573.665197753906; 4435,573.661657714844; 4440,573.658148193359; 4445,573.654608154297; 4450,573.651098632813; 4455,573.647589111328; 4460,573.644049072266; 4465,573.640539550781; 4470,573.636999511719; 4475,573.633489990234; 4480,573.62998046875; 4485,573.626440429688; 4490,573.622930908203; 4495,573.619390869141; 4500,573.615881347656; 4505,573.612341308594; 4510,573.608831787109; 4515,573.605322265625; 4520,573.601782226563; 4525,573.598272705078; 4530,573.594732666016; 4535,573.591223144531; 4540,573.587713623047; 4545,573.584173583984; 4550,
        573.5806640625; 4555,573.577124023438; 4560,573.573614501953; 4565,573.570104980469; 4570,573.566564941406; 4575,573.563055419922; 4580,573.559515380859; 4585,573.556005859375; 4590,573.552496337891; 4595,573.548956298828; 4600,573.545446777344; 4605,573.541906738281; 4610,573.538397216797; 4615,573.534857177734; 4620,573.53134765625; 4625,573.527838134766; 4630,573.524298095703; 4635,573.520788574219; 4640,573.517248535156; 4645,573.513739013672; 4650,573.510229492188; 4655,573.506689453125; 4660,573.503179931641; 4665,573.499639892578; 4670,573.496130371094; 4675,573.492620849609; 4680,573.489080810547; 4685,573.485571289063; 4690,573.48203125; 4695,573.478521728516; 4700,573.475012207031; 4705,573.471472167969; 4710,573.467962646484; 4715,573.464422607422; 4720,573.460913085938; 4725,573.457373046875; 4730,573.453863525391; 4735,573.450354003906; 4740,573.446813964844; 4745,573.443304443359; 4750,573.439764404297; 4755,573.436254882813; 4760,573.432745361328; 4765,
        573.429205322266; 4770,573.425695800781; 4775,573.422155761719; 4780,573.418646240234; 4785,573.41513671875; 4790,573.411596679688; 4795,573.408087158203; 4800,573.404547119141; 4805,573.401037597656; 4810,573.397497558594; 4815,573.393988037109; 4820,573.390478515625; 4825,573.386938476563; 4830,573.383428955078; 4835,573.379888916016; 4840,573.376379394531; 4845,573.372869873047; 4850,573.369329833984; 4855,573.3658203125; 4860,573.362280273438; 4865,573.358770751953; 4870,573.355261230469; 4875,573.351721191406; 4880,573.348211669922; 4885,573.344671630859; 4890,573.341162109375; 4895,573.337652587891; 4900,573.334112548828; 4905,573.330603027344; 4910,573.327062988281; 4915,573.323553466797; 4920,573.320013427734; 4925,573.31650390625; 4930,573.312994384766; 4935,573.309454345703; 4940,573.305944824219; 4945,573.302404785156; 4950,573.298895263672; 4955,573.295385742188; 4960,573.291845703125; 4965,573.288336181641; 4970,573.284796142578; 4975,573.281286621094; 4980,
        573.277777099609; 4985,573.274237060547; 4990,573.270727539063; 4995,573.2671875; 5000,573.263677978516; 5005,573.260168457031; 5010,573.256628417969; 5015,573.253118896484; 5020,573.249578857422; 5025,573.246069335938; 5030,573.242529296875; 5035,573.239019775391; 5040,573.235510253906; 5045,573.231970214844; 5050,573.228460693359; 5055,573.224920654297; 5060,573.221411132813; 5065,573.217901611328; 5070,573.214361572266; 5075,573.210852050781; 5080,573.207312011719; 5085,573.203802490234; 5090,573.20029296875; 5095,573.196752929688; 5100,573.193243408203; 5105,573.189703369141; 5110,573.186193847656; 5115,573.182653808594; 5120,573.179144287109; 5125,573.175634765625; 5130,573.172094726563; 5135,573.168585205078; 5140,573.165045166016; 5145,573.161535644531; 5150,573.158026123047; 5155,573.154486083984; 5160,573.1509765625; 5165,573.147436523438; 5170,573.143927001953; 5175,573.140417480469; 5180,573.136877441406; 5185,573.133367919922; 5190,573.129827880859; 5195,
        573.126318359375; 5200,573.122808837891; 5205,573.119268798828; 5210,573.115759277344; 5215,573.112219238281; 5220,573.108709716797; 5225,573.105169677734; 5230,573.10166015625; 5235,573.098150634766; 5240,573.094610595703; 5245,573.091101074219; 5250,573.087561035156; 5255,573.084051513672; 5260,573.080541992188; 5265,573.077001953125; 5270,573.073492431641; 5275,573.069952392578; 5280,573.066442871094; 5285,573.062933349609; 5290,573.059393310547; 5295,573.055883789063; 5300,573.05234375; 5305,573.048834228516; 5310,573.045324707031; 5315,573.041784667969; 5320,573.038275146484; 5325,573.034735107422; 5330,573.031225585938; 5335,573.027685546875; 5340,573.024176025391; 5345,573.020666503906; 5350,573.017126464844; 5355,573.013616943359; 5360,573.010076904297; 5365,573.006567382813; 5370,573.003057861328; 5375,572.999517822266; 5380,572.996008300781; 5385,572.992468261719; 5390,572.988958740234; 5395,572.98544921875; 5400,572.981909179688; 5405,572.978399658203; 5410,
        572.974859619141; 5415,572.971350097656; 5420,572.967810058594; 5425,572.964300537109; 5430,572.960791015625; 5435,572.957250976563; 5440,572.953741455078; 5445,572.950201416016; 5450,572.946691894531; 5455,572.943182373047; 5460,572.939642333984; 5465,572.9361328125; 5470,572.932592773438; 5475,572.929083251953; 5480,572.925573730469; 5485,572.922033691406; 5490,572.918524169922; 5495,572.914984130859; 5500,572.911474609375; 5505,572.907965087891; 5510,572.904425048828; 5515,572.900915527344; 5520,572.897375488281; 5525,572.893865966797; 5530,572.890325927734; 5535,572.88681640625; 5540,572.883306884766; 5545,572.879766845703; 5550,572.876257324219; 5555,572.872717285156; 5560,572.869207763672; 5565,572.865698242188; 5570,572.862158203125; 5575,572.858648681641; 5580,572.855108642578; 5585,572.851599121094; 5590,572.848089599609; 5595,572.844549560547; 5600,572.841040039063; 5605,572.8375; 5610,572.833990478516; 5615,572.830480957031; 5620,572.826940917969; 5625,
        572.823431396484; 5630,572.819891357422; 5635,572.816381835938; 5640,572.812841796875; 5645,572.809332275391; 5650,572.805822753906; 5655,572.802282714844; 5660,572.798773193359; 5665,572.795233154297; 5670,572.791723632813; 5675,572.788214111328; 5680,572.784674072266; 5685,572.781164550781; 5690,572.777624511719; 5695,572.774114990234; 5700,572.77060546875; 5705,572.767065429688; 5710,572.763555908203; 5715,572.760015869141; 5720,572.756506347656; 5725,572.752966308594; 5730,572.749456787109; 5735,572.745947265625; 5740,572.742407226563; 5745,572.738897705078; 5750,572.735357666016; 5755,572.731848144531; 5760,572.728338623047; 5765,572.724798583984; 5770,572.7212890625; 5775,572.717749023438; 5780,572.714239501953; 5785,572.710729980469; 5790,572.707189941406; 5795,572.703680419922; 5800,572.700140380859; 5805,572.696630859375; 5810,572.693121337891; 5815,572.689581298828; 5820,572.686071777344; 5825,572.682531738281; 5830,572.679022216797; 5835,572.675482177734; 5840,
        572.67197265625; 5845,572.668463134766; 5850,572.664923095703; 5855,572.661413574219; 5860,572.657873535156; 5865,572.654364013672; 5870,572.650854492188; 5875,572.647314453125; 5880,572.643804931641; 5885,572.640264892578; 5890,572.636755371094; 5895,572.633245849609; 5900,572.629705810547; 5905,572.626196289063; 5910,572.62265625; 5915,572.619146728516; 5920,572.615637207031; 5925,572.612097167969; 5930,572.608587646484; 5935,572.605047607422; 5940,572.601538085938; 5945,572.597998046875; 5950,572.594488525391; 5955,572.590979003906; 5960,572.587438964844; 5965,572.583929443359; 5970,572.580389404297; 5975,572.576879882813; 5980,572.573370361328; 5985,572.569830322266; 5990,572.566320800781; 5995,572.562780761719; 6000,572.559271240234; 6005,572.55576171875; 6010,572.552221679688; 6015,572.548712158203; 6020,572.545172119141; 6025,572.541662597656; 6030,572.538153076172; 6035,572.534613037109; 6040,572.531103515625; 6045,572.527563476563; 6050,572.524053955078; 6055,
        572.520513916016; 6060,572.517004394531; 6065,572.513494873047; 6070,572.509954833984; 6075,572.5064453125; 6080,572.502905273438; 6085,572.499395751953; 6090,572.495886230469; 6095,572.492346191406; 6100,572.488836669922; 6105,572.485296630859; 6110,572.481787109375; 6115,572.478277587891; 6120,572.474737548828; 6125,572.471228027344; 6130,572.467687988281; 6135,572.464178466797; 6140,572.460638427734; 6145,572.45712890625; 6150,572.453619384766; 6155,572.450079345703; 6160,572.446569824219; 6165,572.443029785156; 6170,572.439520263672; 6175,572.436010742188; 6180,572.432470703125; 6185,572.428961181641; 6190,572.425421142578; 6195,572.421911621094; 6200,572.418402099609; 6205,572.414862060547; 6210,572.411352539063; 6215,572.4078125; 6220,572.404302978516; 6225,572.400793457031; 6230,572.397253417969; 6235,572.393743896484; 6240,572.390203857422; 6245,572.386694335938; 6250,572.383154296875; 6255,572.379644775391; 6260,572.376135253906; 6265,572.372595214844; 6270,
        572.369085693359; 6275,572.365545654297; 6280,572.362036132813; 6285,572.358526611328; 6290,572.354986572266; 6295,572.351477050781; 6300,572.347937011719; 6305,572.344427490234; 6310,572.34091796875; 6315,572.337377929688; 6320,572.333868408203; 6325,572.330328369141; 6330,572.326818847656; 6335,572.323309326172; 6340,572.319769287109; 6345,572.316259765625; 6350,572.312719726563; 6355,572.309210205078; 6360,572.305670166016; 6365,572.302160644531; 6370,572.298651123047; 6375,572.295111083984; 6380,572.2916015625; 6385,572.288061523438; 6390,572.284552001953; 6395,572.281042480469; 6400,572.277502441406; 6405,572.273992919922; 6410,572.270452880859; 6415,572.266943359375; 6420,572.263433837891; 6425,572.259893798828; 6430,572.256384277344; 6435,572.252844238281; 6440,572.249334716797; 6445,572.245794677734; 6450,572.24228515625; 6455,572.238775634766; 6460,572.235235595703; 6465,572.231726074219; 6470,572.228186035156; 6475,572.224676513672; 6480,572.221166992188; 6485,
        572.217626953125; 6490,572.214117431641; 6495,572.210577392578; 6500,572.207067871094; 6505,572.203558349609; 6510,572.200018310547; 6515,572.196508789063; 6520,572.19296875; 6525,572.189459228516; 6530,572.185949707031; 6535,572.182409667969; 6540,572.178900146484; 6545,572.175360107422; 6550,572.171850585938; 6555,572.168310546875; 6560,572.164801025391; 6565,572.161291503906; 6570,572.157751464844; 6575,572.154241943359; 6580,572.150701904297; 6585,572.147192382813; 6590,572.143682861328; 6595,572.140142822266; 6600,572.136633300781; 6605,572.133093261719; 6610,572.129583740234; 6615,572.12607421875; 6620,572.122534179688; 6625,572.119024658203; 6630,572.115484619141; 6635,572.111975097656; 6640,572.108465576172; 6645,572.104925537109; 6650,572.101416015625; 6655,572.097875976563; 6660,572.094366455078; 6665,572.090826416016; 6670,572.087316894531; 6675,572.083807373047; 6680,572.080267333984; 6685,572.0767578125; 6690,572.073217773438; 6695,572.069708251953; 6700,
        572.066198730469; 6705,572.062658691406; 6710,572.059149169922; 6715,572.055609130859; 6720,572.052099609375; 6725,572.048590087891; 6730,572.045050048828; 6735,572.041540527344; 6740,572.038000488281; 6745,572.034490966797; 6750,572.030950927734; 6755,572.02744140625; 6760,572.023931884766; 6765,572.020391845703; 6770,572.016882324219; 6775,572.013342285156; 6780,572.009832763672; 6785,572.006323242188; 6790,572.002783203125; 6795,571.999273681641; 6800,571.995733642578; 6805,571.992224121094; 6810,571.988714599609; 6815,571.985174560547; 6820,571.981665039063; 6825,571.978125; 6830,571.974615478516; 6835,571.971105957031; 6840,571.967565917969; 6845,571.964056396484; 6850,571.960516357422; 6855,571.957006835938; 6860,571.953466796875; 6865,571.949957275391; 6870,571.946447753906; 6875,571.942907714844; 6880,571.939398193359; 6885,571.935858154297; 6890,571.932348632813; 6895,571.928839111328; 6900,571.925299072266; 6905,571.921789550781; 6910,571.918249511719; 6915,
        571.914739990234; 6920,571.91123046875; 6925,571.907690429688; 6930,571.904180908203; 6935,571.900640869141; 6940,571.897131347656; 6945,571.893621826172; 6950,571.890081787109; 6955,571.886572265625; 6960,571.883032226563; 6965,571.879522705078; 6970,571.875982666016; 6975,571.872473144531; 6980,571.868963623047; 6985,571.865423583984; 6990,571.8619140625; 6995,571.858374023438; 7000,571.854864501953; 7005,571.851354980469; 7010,571.847814941406; 7015,571.844305419922; 7020,571.840765380859; 7025,571.837255859375; 7030,571.833746337891; 7035,571.830206298828; 7040,571.826696777344; 7045,571.823156738281; 7050,571.819647216797; 7055,571.816107177734; 7060,571.81259765625; 7065,571.809088134766; 7070,571.805548095703; 7075,571.802038574219; 7080,571.798498535156; 7085,571.794989013672; 7090,571.791479492188; 7095,571.787939453125; 7100,571.784429931641; 7105,571.780889892578; 7110,571.777380371094; 7115,571.773870849609; 7120,571.770330810547; 7125,571.766821289063; 7130,
        571.76328125; 7135,571.759771728516; 7140,571.756262207031; 7145,571.752722167969; 7150,571.749212646484; 7155,571.745672607422; 7160,571.742163085938; 7165,571.738623046875; 7170,571.735113525391; 7175,571.731604003906; 7180,571.728063964844; 7185,571.724554443359; 7190,571.721014404297; 7195,571.717504882813; 7200,571.713995361328; 7205,571.710455322266; 7210,571.706945800781; 7215,571.703405761719; 7220,571.699896240234; 7225,571.69638671875; 7230,571.692846679688; 7235,571.689337158203; 7240,571.685797119141; 7245,571.682287597656; 7250,571.678778076172; 7255,571.675238037109; 7260,571.671728515625; 7265,571.668188476563; 7270,571.664678955078; 7275,571.661138916016; 7280,571.657629394531; 7285,571.654119873047; 7290,571.650579833984; 7295,571.6470703125; 7300,571.643530273438; 7305,571.640020751953; 7310,571.636511230469; 7315,571.632971191406; 7320,571.629461669922; 7325,571.625921630859; 7330,571.622412109375; 7335,571.618902587891; 7340,571.615362548828; 7345,
        571.611853027344; 7350,571.608312988281; 7355,571.604803466797; 7360,571.601263427734; 7365,571.59775390625; 7370,571.594244384766; 7375,571.590704345703; 7380,571.587194824219; 7385,571.583654785156; 7390,571.580145263672; 7395,571.576635742188; 7400,571.573095703125; 7405,571.569586181641; 7410,571.566046142578; 7415,571.562536621094; 7420,571.559027099609; 7425,571.555487060547; 7430,571.551977539063; 7435,571.5484375; 7440,571.544927978516; 7445,571.541418457031; 7450,571.537878417969; 7455,571.534368896484; 7460,571.530828857422; 7465,571.527319335938; 7470,571.523779296875; 7475,571.520269775391; 7480,571.516760253906; 7485,571.513220214844; 7490,571.509710693359; 7495,571.506170654297; 7500,571.502661132813; 7505,571.499151611328; 7510,571.495611572266; 7515,571.492102050781; 7520,571.488562011719; 7525,571.485052490234; 7530,571.48154296875; 7535,571.478002929688; 7540,571.474493408203; 7545,571.470953369141; 7550,571.467443847656; 7555,571.463934326172; 7560,
        571.460394287109; 7565,571.456884765625; 7570,571.453344726563; 7575,571.449835205078; 7580,571.446295166016; 7585,571.442785644531; 7590,571.439276123047; 7595,571.435736083984; 7600,571.4322265625; 7605,571.428686523438; 7610,571.425177001953; 7615,571.421667480469; 7620,571.418127441406; 7625,571.414617919922; 7630,571.411077880859; 7635,571.407568359375; 7640,571.404058837891; 7645,571.400518798828; 7650,571.397009277344; 7655,571.393469238281; 7660,571.389959716797; 7665,571.386419677734; 7670,571.38291015625; 7675,571.379400634766; 7680,571.375860595703; 7685,571.372351074219; 7690,571.368811035156; 7695,571.365301513672; 7700,571.361791992188; 7705,571.358251953125; 7710,571.354742431641; 7715,571.351202392578; 7720,571.347692871094; 7725,571.344183349609; 7730,571.340643310547; 7735,571.337133789063; 7740,571.33359375; 7745,571.330084228516; 7750,571.326574707031; 7755,571.323034667969; 7760,571.319525146484; 7765,571.315985107422; 7770,571.312475585938; 7775,
        571.308935546875; 7780,571.305426025391; 7785,571.301916503906; 7790,571.298376464844; 7795,571.294866943359; 7800,571.291326904297; 7805,571.287817382813; 7810,571.284307861328; 7815,571.280767822266; 7820,571.277258300781; 7825,571.273718261719; 7830,571.270208740234; 7835,571.26669921875; 7840,571.263159179688; 7845,571.259649658203; 7850,571.256109619141; 7855,571.252600097656; 7860,571.249090576172; 7865,571.245550537109; 7870,571.242041015625; 7875,571.238500976563; 7880,571.234991455078; 7885,571.231451416016; 7890,571.227941894531; 7895,571.224432373047; 7900,571.220892333984; 7905,571.2173828125; 7910,571.213842773438; 7915,571.210333251953; 7920,571.206823730469; 7925,571.203283691406; 7930,571.199774169922; 7935,571.196234130859; 7940,571.192724609375; 7945,571.189215087891; 7950,571.185675048828; 7955,571.182165527344; 7960,571.178625488281; 7965,571.175115966797; 7970,571.171606445313; 7975,571.16806640625; 7980,571.164556884766; 7985,571.161016845703; 7990,
        571.157507324219; 7995,571.153967285156; 8000,571.150457763672; 8005,571.146948242188; 8010,571.143408203125; 8015,571.139898681641; 8020,571.136358642578; 8025,571.132849121094; 8030,571.129339599609; 8035,571.125799560547; 8040,571.122290039063; 8045,571.11875; 8050,571.115240478516; 8055,571.111730957031; 8060,571.108190917969; 8065,571.104681396484; 8070,571.101141357422; 8075,571.097631835938; 8080,571.094091796875; 8085,571.090582275391; 8090,571.087072753906; 8095,571.083532714844; 8100,571.080023193359; 8105,571.076483154297; 8110,571.072973632813; 8115,571.069464111328; 8120,571.065924072266; 8125,571.062414550781; 8130,571.058874511719; 8135,571.055364990234; 8140,571.05185546875; 8145,571.048315429688; 8150,571.044805908203; 8155,571.041265869141; 8160,571.037756347656; 8165,571.034246826172; 8170,571.030706787109; 8175,571.027197265625; 8180,571.023657226563; 8185,571.020147705078; 8190,571.016607666016; 8195,571.013098144531; 8200,571.009588623047; 8205,
        571.006048583984; 8210,571.0025390625; 8215,570.998999023438; 8220,570.995489501953; 8225,570.991979980469; 8230,570.988439941406; 8235,570.984930419922; 8240,570.981390380859; 8245,570.977880859375; 8250,570.974371337891; 8255,570.970831298828; 8260,570.967321777344; 8265,570.963781738281; 8270,570.960272216797; 8275,570.956762695313; 8280,570.95322265625; 8285,570.949713134766; 8290,570.946173095703; 8295,570.942663574219; 8300,570.939123535156; 8305,570.935614013672; 8310,570.932104492188; 8315,570.928564453125; 8320,570.925054931641; 8325,570.921514892578; 8330,570.918005371094; 8335,570.914495849609; 8340,570.910955810547; 8345,570.907446289063; 8350,570.90390625; 8355,570.900396728516; 8360,570.896887207031; 8365,570.893347167969; 8370,570.889837646484; 8375,570.886297607422; 8380,570.882788085938; 8385,570.879248046875; 8390,570.875738525391; 8395,570.872229003906; 8400,570.868688964844; 8405,570.865179443359; 8410,570.861639404297; 8415,570.858129882813; 8420,
        570.854620361328; 8425,570.851080322266; 8430,570.847570800781; 8435,570.844030761719; 8440,570.840521240234; 8445,570.83701171875; 8450,570.833471679688; 8455,570.829962158203; 8460,570.826422119141; 8465,570.822912597656; 8470,570.819403076172; 8475,570.815863037109; 8480,570.812353515625; 8485,570.808813476563; 8490,570.805303955078; 8495,570.801763916016; 8500,570.798254394531; 8505,570.794744873047; 8510,570.791204833984; 8515,570.7876953125; 8520,570.784155273438; 8525,570.780645751953; 8530,570.777136230469; 8535,570.773596191406; 8540,570.770086669922; 8545,570.766546630859; 8550,570.763037109375; 8555,570.759527587891; 8560,570.755987548828; 8565,570.752478027344; 8570,570.667822265625; 8575,570.386236572266; 8580,570.104681396484; 8585,569.823095703125; 8590,569.541540527344; 8595,569.259985351563; 8600,568.978399658203; 8605,568.696844482422; 8610,568.415258789063; 8615,568.133703613281; 8620,567.852117919922; 8625,567.570562744141; 8630,567.289007568359; 8635,
        567.007421875; 8640,566.725866699219; 8645,566.444281005859; 8650,566.162725830078; 8655,565.881140136719; 8660,565.599584960938; 8665,565.318029785156; 8670,565.036444091797; 8675,564.754888916016; 8680,564.473303222656; 8685,564.191748046875; 8690,563.910162353516; 8695,563.628607177734; 8700,563.347052001953; 8705,563.065466308594; 8710,562.783911132813; 8715,562.502325439453; 8720,562.220770263672; 8725,561.939184570313; 8730,561.657629394531; 8735,561.376043701172; 8740,561.094488525391; 8745,560.812933349609; 8750,560.568182373047; 8755,560.437902832031; 8760,560.307653808594; 8765,560.177374267578; 8770,560.047125244141; 8775,559.916845703125; 8780,559.786566162109; 8785,559.656317138672; 8790,559.526037597656; 8795,559.395758056641; 8800,559.265509033203; 8805,559.135229492188; 8810,559.00498046875; 8815,558.874700927734; 8820,558.744421386719; 8825,558.614172363281; 8830,558.483892822266; 8835,558.353643798828; 8840,558.223364257813; 8845,558.093084716797; 8850,
        557.962835693359; 8855,557.832556152344; 8860,557.702307128906; 8865,557.572027587891; 8870,557.441748046875; 8875,557.311499023438; 8880,557.181219482422; 8885,557.050970458984; 8890,556.920690917969; 8895,556.852575683594; 8900,556.858312988281; 8905,556.864019775391; 8910,556.869757080078; 8915,556.875494384766; 8920,556.881231689453; 8925,556.886938476563; 8930,556.89267578125; 8935,556.898413085938; 8940,556.904150390625; 8945,556.909857177734; 8950,556.915594482422; 8955,556.921331787109; 8960,556.927069091797; 8965,556.932775878906; 8970,556.938513183594; 8975,556.944250488281; 8980,556.949987792969; 8985,556.955725097656; 8990,556.961431884766; 8995,556.967169189453; 9000,556.972906494141; 9005,556.978643798828; 9010,556.984350585938; 9015,556.990087890625; 9020,556.995825195313; 9025,557.0015625; 9030,557.007269287109; 9035,557.013006591797; 9040,557.018743896484; 9045,557.024481201172; 9050,557.030187988281; 9055,557.035925292969; 9060,557.041662597656; 9065,
        557.047399902344; 9070,557.053106689453; 9075,557.058843994141; 9080,557.064581298828; 9085,557.070318603516; 9090,557.076025390625; 9095,557.081762695313; 9100,557.0875; 9105,557.093237304688; 9110,557.098974609375; 9115,557.104681396484; 9120,557.110418701172; 9125,557.116156005859; 9130,557.121893310547; 9135,557.127600097656; 9140,557.133337402344; 9145,557.139074707031; 9150,557.144812011719; 9155,557.150518798828; 9160,557.156256103516; 9165,557.161993408203; 9170,557.167730712891; 9175,557.1734375; 9180,557.179174804688; 9185,557.184912109375; 9190,557.190649414063; 9195,557.196356201172; 9200,557.202093505859; 9205,557.207830810547; 9210,557.213568115234; 9215,557.219305419922; 9220,557.225012207031; 9225,557.230749511719; 9230,557.236486816406; 9235,557.242224121094; 9240,557.247930908203; 9245,557.476934814453; 9250,557.823217773438; 9255,558.169500732422; 9260,558.515783691406; 9265,558.862066650391; 9270,559.208319091797; 9275,559.554602050781; 9280,
        559.900885009766; 9285,560.24716796875; 9290,560.593420410156; 9295,560.939703369141; 9300,561.285986328125; 9305,561.632269287109; 9310,561.978521728516; 9315,562.3248046875; 9320,562.671087646484; 9325,563.017370605469; 9330,563.363653564453; 9335,563.709906005859; 9340,564.056188964844; 9345,564.402471923828; 9350,564.748754882813; 9355,565.095007324219; 9360,565.441290283203; 9365,565.787573242188; 9370,566.133856201172; 9375,566.480139160156; 9380,566.826391601563; 9385,567.172674560547; 9390,567.518957519531; 9395,567.865240478516; 9400,568.211492919922; 9405,568.557775878906; 9410,568.904058837891; 9415,569.250341796875; 9420,569.596594238281; 9425,569.942877197266; 9430,570.28916015625; 9435,570.635443115234; 9440,570.981726074219; 9445,571.327978515625; 9450,571.674261474609; 9455,572.020544433594; 9460,572.366827392578; 9465,572.713079833984; 9470,573.059362792969; 9475,573.405645751953; 9480,573.751928710938; 9485,574.098211669922; 9490,574.291845703125; 9495,
        574.458685302734; 9500,574.625524902344; 9505,574.792395019531; 9510,574.959234619141; 9515,575.12607421875; 9520,575.292913818359; 9525,575.459753417969; 9530,575.626593017578; 9535,575.655035400391; 9540,575.660925292969; 9545,575.666845703125; 9550,575.672766113281; 9555,575.678656005859; 9560,575.684576416016; 9565,575.690496826172; 9570,575.696417236328; 9575,575.702307128906; 9580,575.708227539063; 9585,575.714147949219; 9590,575.720037841797; 9595,575.725958251953; 9600,575.731878662109; 9605,575.737799072266; 9610,575.743688964844; 9615,575.749609375; 9620,575.755529785156; 9625,575.761419677734; 9630,575.767340087891; 9635,575.773260498047; 9640,575.779150390625; 9645,575.785070800781; 9650,575.790991210938; 9655,575.796911621094; 9660,575.802801513672; 9665,575.808721923828; 9670,575.814642333984; 9675,575.820532226563; 9680,575.826452636719; 9685,575.832373046875; 9690,575.838293457031; 9695,575.844183349609; 9700,575.850103759766; 9705,575.856024169922; 9710,
        575.8619140625; 9715,575.867834472656; 9720,575.873754882813; 9725,575.879675292969; 9730,575.885565185547; 9735,575.891485595703; 9740,575.897406005859; 9745,575.903295898438; 9750,575.909216308594; 9755,575.91513671875; 9760,575.921026611328; 9765,575.926947021484; 9770,575.932867431641; 9775,575.938787841797; 9780,575.944677734375; 9785,575.950598144531; 9790,575.956518554688; 9795,575.962408447266; 9800,575.968328857422; 9805,575.974249267578; 9810,575.980169677734; 9815,575.986059570313; 9820,575.991979980469; 9825,575.997900390625; 9830,576.003790283203; 9835,576.009710693359; 9840,576.015631103516; 9845,576.021520996094; 9850,576.02744140625; 9855,576.033361816406; 9860,576.039282226563; 9865,576.045172119141; 9870,576.051092529297; 9875,576.057012939453; 9880,576.062902832031; 9885,576.068823242188; 9890,576.074743652344; 9895,576.0806640625; 9900,576.086553955078; 9905,576.092474365234; 9910,576.098394775391; 9915,576.104284667969; 9920,576.110205078125; 9925,
        576.116125488281; 9930,576.122045898438; 9935,576.127935791016; 9940,576.133856201172; 9945,576.139776611328; 9950,576.145666503906; 9955,576.151586914063; 9960,576.157507324219; 9965,576.163397216797; 9970,576.169317626953; 9975,576.175238037109; 9980,576.181158447266; 9985,576.187048339844; 9990,576.19296875; 9995,576.198889160156; 10000,576.204779052734; 10005,576.210699462891; 10010,576.216619873047; 10015,576.222540283203; 10020,576.228430175781; 10025,576.234350585938; 10030,576.240270996094; 10035,576.246160888672; 10040,576.252081298828; 10045,576.258001708984; 10050,576.263922119141; 10055,576.269812011719; 10060,576.275732421875; 10065,576.281652832031; 10070,576.287542724609; 10075,576.293463134766; 10080,576.299383544922; 10085,576.3052734375; 10090,576.311193847656; 10095,576.317114257813; 10100,576.323034667969; 10105,576.328924560547; 10110,576.334844970703; 10115,576.340765380859; 10120,576.346655273438; 10125,576.290319824219; 10130,576.159399414063; 10135,
        576.028448486328; 10140,575.897528076172; 10145,575.766577148438; 10150,575.635656738281; 10155,575.504705810547; 10160,575.373785400391; 10165,575.242834472656; 10170,575.111883544922; 10175,574.980963134766; 10180,574.850012207031; 10185,574.719091796875; 10190,574.588140869141; 10195,574.457220458984; 10200,574.32626953125; 10205,574.195349121094; 10210,574.064398193359; 10215,573.719793701172; 10220,573.348699951172; 10225,572.97763671875; 10230,572.60654296875; 10235,572.23544921875; 10240,571.86435546875; 10245,571.49326171875; 10250,571.122198486328; 10255,570.751104736328; 10260,570.380010986328; 10265,570.008917236328; 10270,569.637823486328; 10275,569.266760253906; 10280,568.895666503906; 10285,568.524572753906; 10290,568.153479003906; 10295,567.782385253906; 10300,567.411322021484; 10305,567.040228271484; 10310,566.669134521484; 10315,566.298040771484; 10320,565.926947021484; 10325,565.555853271484; 10330,565.184790039063; 10335,564.813696289063; 10340,
        564.442602539063; 10345,564.071508789063; 10350,563.700415039063; 10355,563.329351806641; 10360,562.958258056641; 10365,562.587164306641; 10370,562.216070556641; 10375,561.844976806641; 10380,561.473913574219; 10385,561.102819824219; 10390,560.873297119141; 10395,560.814642333984; 10400,560.755987548828; 10405,560.697332763672; 10410,560.638677978516; 10415,560.579992675781; 10420,560.521337890625; 10425,560.462683105469; 10430,560.404028320313; 10435,560.345373535156; 10440,560.28671875; 10445,560.228063964844; 10450,560.169409179688; 10455,560.110754394531; 10460,560.052069091797; 10465,559.993414306641; 10470,559.934759521484; 10475,559.876104736328; 10480,559.817449951172; 10485,559.758795166016; 10490,559.700140380859; 10495,559.641485595703; 10500,559.582800292969; 10505,559.524145507813; 10510,559.465490722656; 10515,559.4068359375; 10520,559.348181152344; 10525,559.289526367188; 10530,559.230871582031; 10535,559.172216796875; 10540,559.113562011719; 10545,
        559.054876708984; 10550,558.996221923828; 10555,558.937567138672; 10560,558.878912353516; 10565,558.820257568359; 10570,558.761602783203; 10575,558.702947998047; 10580,558.644293212891; 10585,558.585607910156; 10590,558.526953125; 10595,558.468298339844; 10600,558.409643554688; 10605,558.350988769531; 10610,558.292333984375; 10615,558.233679199219; 10620,558.175024414063; 10625,558.116369628906; 10630,558.057684326172; 10635,557.999029541016; 10640,557.940374755859; 10645,557.881719970703; 10650,557.876409912109; 10655,557.934362792969; 10660,557.992315673828; 10665,558.050268554688; 10670,558.108251953125; 10675,558.166204833984; 10680,558.224157714844; 10685,558.282110595703; 10690,558.340093994141; 10695,558.398046875; 10700,558.455999755859; 10705,558.513952636719; 10710,558.571936035156; 10715,558.629888916016; 10720,558.687841796875; 10725,558.745794677734; 10730,558.803778076172; 10735,558.861730957031; 10740,558.919683837891; 10745,558.97763671875; 10750,
        559.035589599609; 10755,559.093572998047; 10760,559.151525878906; 10765,559.209478759766; 10770,559.267431640625; 10775,559.325415039063; 10780,559.383367919922; 10785,559.441320800781; 10790,559.786688232422; 10795,560.182135009766; 10800,560.577581787109; 10805,560.972998046875; 10810,561.368444824219; 10815,561.763891601563; 10820,562.159338378906; 10825,562.554754638672; 10830,562.950201416016; 10835,563.345648193359; 10840,563.741094970703; 10845,564.136541748047; 10850,564.531958007813; 10855,564.927404785156; 10860,565.3228515625; 10865,565.718298339844; 10870,566.113714599609; 10875,566.509161376953; 10880,566.904608154297; 10885,567.300054931641; 10890,567.695471191406; 10895,568.09091796875; 10900,568.486364746094; 10905,568.881811523438; 10910,569.277227783203; 10915,569.672674560547; 10920,570.068121337891; 10925,570.463568115234; 10930,570.858984375; 10935,571.254431152344; 10940,571.649877929688; 10945,572.045324707031; 10950,572.440771484375; 10955,
        572.729193115234; 10960,572.897436523438; 10965,573.065679931641; 10970,573.233923339844; 10975,573.402166748047; 10980,573.57041015625; 10985,573.738684082031; 10990,573.906927490234; 10995,574.075170898438; 11000,574.243414306641; 11005,574.411657714844; 11010,574.579901123047; 11015,574.74814453125; 11020,574.916387939453; 11025,575.084631347656; 11030,575.252905273438; 11035,575.421148681641; 11040,575.589392089844; 11045,575.757635498047; 11050,575.92587890625; 11055,576.094122314453; 11060,576.145422363281; 11065,576.138647460938; 11070,576.131872558594; 11075,576.125128173828; 11080,576.118353271484; 11085,576.111578369141; 11090,576.104803466797; 11095,576.098059082031; 11100,576.091284179688; 11105,576.084509277344; 11110,576.077734375; 11115,576.070989990234; 11120,576.064215087891; 11125,576.057440185547; 11130,576.050665283203; 11135,576.043920898438; 11140,576.037145996094; 11145,576.03037109375; 11150,576.023596191406; 11155,576.016851806641; 11160,
        576.010076904297; 11165,576.003302001953; 11170,575.996527099609; 11175,575.989782714844; 11180,575.9830078125; 11185,575.976232910156; 11190,575.969458007813; 11195,575.962713623047; 11200,575.955938720703; 11205,575.949163818359; 11210,575.942388916016; 11215,575.935614013672; 11220,575.928869628906; 11225,575.922094726563; 11230,575.915319824219; 11235,575.908544921875; 11240,575.901800537109; 11245,575.895025634766; 11250,575.888250732422; 11255,575.881475830078; 11260,575.874731445313; 11265,575.867956542969; 11270,575.861181640625; 11275,575.854406738281; 11280,575.847662353516; 11285,575.840887451172; 11290,575.834112548828; 11295,575.827337646484; 11300,575.820593261719; 11305,575.813818359375; 11310,575.807043457031; 11315,575.800268554688; 11320,575.793524169922; 11325,575.786749267578; 11330,575.779974365234; 11335,575.773199462891; 11340,575.766455078125; 11345,575.759680175781; 11350,575.752905273438; 11355,575.746130371094; 11360,575.739385986328; 11365,
        575.732611083984; 11370,575.725836181641; 11375,575.719061279297; 11380,575.712316894531; 11385,575.705541992188; 11390,575.698767089844; 11395,575.6919921875; 11400,575.685247802734; 11405,575.678472900391; 11410,575.671697998047; 11415,575.664923095703; 11420,575.658178710938; 11425,575.651403808594; 11430,575.64462890625; 11435,575.637854003906; 11440,575.631109619141; 11445,575.624334716797; 11450,575.617559814453; 11455,575.610784912109; 11460,575.604040527344; 11465,575.597265625; 11470,575.590490722656; 11475,575.583715820313; 11480,575.576971435547; 11485,575.570196533203; 11490,575.563421630859; 11495,575.556646728516; 11500,575.54990234375; 11505,575.543127441406; 11510,575.536352539063; 11515,575.529577636719; 11520,575.522833251953; 11525,575.516058349609; 11530,575.509283447266; 11535,575.502508544922; 11540,575.495764160156; 11545,575.488989257813; 11550,575.482214355469; 11555,575.475439453125; 11560,575.468695068359; 11565,575.461920166016; 11570,
        575.455145263672; 11575,575.448370361328; 11580,575.441625976563; 11585,575.434851074219; 11590,575.428076171875; 11595,575.421301269531; 11600,575.414556884766; 11605,575.407781982422; 11610,575.401007080078; 11615,575.394232177734; 11620,575.387487792969; 11625,575.380712890625; 11630,575.373937988281; 11635,575.367163085938; 11640,575.360418701172; 11645,575.353643798828; 11650,575.333685302734; 11655,575.297979736328; 11660,575.262274169922; 11665,575.226538085938; 11670,575.190832519531; 11675,575.155126953125; 11680,575.119421386719; 11685,575.083685302734; 11690,575.047979736328; 11695,575.012274169922; 11700,574.976538085938; 11705,574.940832519531; 11710,574.905126953125; 11715,574.869390869141; 11720,574.833685302734; 11725,574.797979736328; 11730,574.762243652344; 11735,574.726538085938; 11740,574.690832519531; 11745,574.655096435547; 11750,574.619390869141; 11755,574.583685302734; 11760,574.54794921875; 11765,574.512243652344; 11770,574.476538085938; 11775,
        574.440802001953; 11780,574.405096435547; 11785,574.369390869141; 11790,574.333685302734; 11795,574.299780273438; 11800,574.296362304688; 11805,574.292944335938; 11810,574.289526367188; 11815,574.286138916016; 11820,574.282720947266; 11825,574.279302978516; 11830,574.275885009766; 11835,574.272497558594; 11840,574.269079589844; 11845,574.265661621094; 11850,574.262243652344; 11855,574.258856201172; 11860,574.255438232422; 11865,574.252020263672; 11870,574.248602294922; 11875,574.245184326172; 11880,574.241796875; 11885,574.23837890625; 11890,574.2349609375; 11895,574.23154296875; 11900,574.228155517578; 11905,574.224737548828; 11910,574.221319580078; 11915,574.217901611328; 11920,574.214514160156; 11925,574.211096191406; 11930,574.207678222656; 11935,574.204260253906; 11940,574.200842285156; 11945,574.197454833984; 11950,574.194036865234; 11955,574.190618896484; 11960,574.187200927734; 11965,574.183813476563; 11970,574.180395507813; 11975,574.176977539063; 11980,
        574.173559570313; 11985,574.170172119141; 11990,574.166754150391; 11995,574.163336181641; 12000,574.159918212891; 12005,574.156530761719; 12010,574.153112792969; 12015,574.149694824219; 12020,574.146276855469; 12025,574.142858886719; 12030,574.139471435547; 12035,574.136053466797; 12040,574.132635498047; 12045,574.129217529297; 12050,574.125830078125; 12055,574.122412109375; 12060,574.118994140625; 12065,574.115576171875; 12070,574.112188720703; 12075,574.108770751953; 12080,574.105352783203; 12085,574.101934814453; 12090,574.098516845703; 12095,574.095129394531; 12100,574.091711425781; 12105,574.088293457031; 12110,574.084875488281; 12115,574.081488037109; 12120,574.078070068359; 12125,574.074652099609; 12130,574.071234130859; 12135,574.067846679688; 12140,574.064428710938; 12145,574.061010742188; 12150,574.057592773438; 12155,574.054205322266; 12160,574.050787353516; 12165,574.047369384766; 12170,574.043951416016; 12175,574.040533447266; 12180,574.037145996094; 12185,
        574.033728027344; 12190,574.030310058594; 12195,574.026892089844; 12200,574.023504638672; 12205,574.020086669922; 12210,574.016668701172; 12215,574.013250732422; 12220,574.00986328125; 12225,574.0064453125; 12230,574.00302734375; 12235,573.999609375; 12240,573.99619140625; 12245,573.992803955078; 12250,573.989385986328; 12255,573.985968017578; 12260,573.982550048828; 12265,573.979162597656; 12270,573.975744628906; 12275,573.972326660156; 12280,573.968908691406; 12285,573.965521240234; 12290,573.962103271484; 12295,573.958685302734; 12300,573.955267333984; 12305,573.951879882813; 12310,573.948461914063; 12315,573.945043945313; 12320,573.941625976563; 12325,573.938208007813; 12330,573.934820556641; 12335,573.931402587891; 12340,573.927984619141; 12345,573.924566650391; 12350,573.921179199219; 12355,573.917761230469; 12360,573.914343261719; 12365,573.910925292969; 12370,573.907537841797; 12375,573.904119873047; 12380,573.900701904297; 12385,573.897283935547; 12390,
        573.893865966797; 12395,573.890478515625; 12400,573.887060546875; 12405,573.883642578125; 12410,573.880224609375; 12415,573.876837158203; 12420,573.873419189453; 12425,573.870001220703; 12430,573.866583251953; 12435,573.863195800781; 12440,573.859777832031; 12445,573.856359863281; 12450,573.852941894531; 12455,573.849554443359; 12460,573.846136474609; 12465,573.842718505859; 12470,573.839300537109; 12475,573.835882568359; 12480,573.832495117188; 12485,573.829077148438; 12490,573.825659179688; 12495,573.822241210938; 12500,573.818853759766; 12505,573.815435791016; 12510,573.812017822266; 12515,573.808599853516; 12520,573.805212402344; 12525,573.801794433594; 12530,573.782934570313; 12535,573.744970703125; 12540,573.707006835938; 12545,573.669073486328; 12550,573.631109619141; 12555,573.593176269531; 12560,573.555212402344; 12565,573.517248535156; 12570,573.479315185547; 12575,573.441351318359; 12580,573.40341796875; 12585,573.365454101563; 12590,573.327490234375; 12595,
        573.289556884766; 12600,573.251593017578; 12605,573.213659667969; 12610,573.175695800781; 12615,573.137731933594; 12620,573.099798583984; 12625,573.061834716797; 12630,573.023870849609; 12635,572.9859375; 12640,572.947973632813; 12645,572.910040283203; 12650,572.872076416016; 12655,572.834112548828; 12660,572.796179199219; 12665,572.758215332031; 12670,572.720281982422; 12675,572.682318115234; 12680,572.644354248047; 12685,572.606420898438; 12690,572.56845703125; 12695,572.530523681641; 12700,572.492559814453; 12705,572.454595947266; 12710,572.416662597656; 12715,572.378698730469; 12720,572.340734863281; 12725,572.302801513672; 12730,572.264837646484; 12735,572.226904296875; 12740,572.188940429688; 12745,572.1509765625; 12750,572.113043212891; 12755,572.075079345703; 12760,572.037145996094; 12765,571.999182128906; 12770,571.961218261719; 12775,571.923284912109; 12780,571.885321044922; 12785,571.847387695313; 12790,571.809423828125; 12795,571.771459960938; 12800,
        571.733526611328; 12805,571.695562744141; 12810,571.657598876953; 12815,571.619665527344; 12820,571.196936035156; 12825,570.358435058594; 12830,569.519964599609; 12835,568.681494140625; 12840,567.842993164063; 12845,567.376318359375; 12850,567.326361083984; 12855,567.276403808594; 12860,567.226446533203; 12865,567.176489257813; 12870,567.126531982422; 12875,567.076574707031; 12880,567.026617431641; 12885,567.088812255859; 12890,567.279699707031; 12895,567.470587158203; 12900,567.661505126953; 12905,567.852392578125; 12910,568.043280029297; 12915,568.234197998047; 12920,568.425085449219; 12925,568.616003417969; 12930,568.806890869141; 12935,568.997778320313; 12940,569.188696289063; 12945,569.379583740234; 12950,569.570471191406; 12955,569.761389160156; 12960,569.952276611328; 12965,570.1431640625; 12970,570.33408203125; 12975,570.524969482422; 12980,570.541693115234; 12985,570.532232666016; 12990,570.522802734375; 12995,570.513372802734; 13000,570.503912353516; 13005,
        570.494482421875; 13010,570.485021972656; 13015,570.475592041016; 13020,570.466131591797; 13025,570.456701660156; 13030,570.447241210938; 13035,570.437811279297; 13040,570.428350830078; 13045,570.418920898438; 13050,570.409490966797; 13055,570.400030517578; 13060,570.390600585938; 13065,570.381140136719; 13070,570.371710205078; 13075,570.362249755859; 13080,570.352819824219; 13085,570.343359375; 13090,570.333929443359; 13095,570.324468994141; 13100,570.3150390625; 13105,570.305578613281; 13110,570.296148681641; 13115,570.28671875; 13120,570.277258300781; 13125,570.267828369141; 13130,570.258367919922; 13135,570.248937988281; 13140,570.239477539063; 13145,570.230047607422; 13150,570.220587158203; 13155,570.211157226563; 13160,570.201696777344; 13165,570.192266845703; 13170,570.182806396484; 13175,570.173376464844; 13180,570.163946533203; 13185,570.154486083984; 13190,570.145056152344; 13195,570.135595703125; 13200,570.126165771484; 13205,570.116705322266; 13210,570.107275390625;
        13215,570.097814941406; 13220,570.088385009766; 13225,570.078924560547; 13230,570.069494628906; 13235,570.060034179688; 13240,570.050604248047; 13245,570.041174316406; 13250,570.031713867188; 13255,570.022283935547; 13260,570.012823486328; 13265,570.003393554688; 13270,569.993933105469; 13275,569.984503173828; 13280,569.975042724609; 13285,569.965612792969; 13290,569.95615234375; 13295,569.946722412109; 13300,569.937261962891; 13305,569.92783203125; 13310,569.918402099609; 13315,569.908941650391; 13320,569.89951171875; 13325,569.890051269531; 13330,569.880621337891; 13335,569.871160888672; 13340,569.861730957031; 13345,569.852270507813; 13350,569.842840576172; 13355,569.833380126953; 13360,569.823950195313; 13365,569.814520263672; 13370,569.805059814453; 13375,569.795629882813; 13380,569.786169433594; 13385,569.776739501953; 13390,569.767279052734; 13395,569.757849121094; 13400,569.748388671875; 13405,569.738958740234; 13410,569.729498291016; 13415,569.720068359375; 13420,
        569.710607910156; 13425,569.701177978516; 13430,569.691748046875; 13435,569.682287597656; 13440,569.672857666016; 13445,569.663397216797; 13450,569.653967285156; 13455,569.644506835938; 13460,569.635076904297; 13465,569.625616455078; 13470,569.616186523438; 13475,569.606726074219; 13480,569.597296142578; 13485,569.587835693359; 13490,569.578405761719; 13495,569.568975830078; 13500,569.559515380859; 13505,569.550085449219; 13510,569.540625; 13515,569.531195068359; 13520,569.521734619141; 13525,569.5123046875; 13530,569.502844238281; 13535,569.493414306641; 13540,569.483953857422; 13545,569.474523925781; 13550,569.465063476563; 13555,569.455633544922; 13560,569.446203613281; 13565,569.436743164063; 13570,569.427313232422; 13575,569.417852783203; 13580,569.408422851563; 13585,569.398962402344; 13590,569.389532470703; 13595,569.380072021484; 13600,569.370642089844; 13605,569.361181640625; 13610,569.351751708984; 13615,569.342291259766; 13620,569.332861328125; 13625,
        569.323431396484; 13630,569.313970947266; 13635,569.304541015625; 13640,569.295080566406; 13645,569.285650634766; 13650,569.276190185547; 13655,569.266760253906; 13660,569.257299804688; 13665,569.247869873047; 13670,569.238409423828; 13675,569.228979492188; 13680,569.219519042969; 13685,569.210089111328; 13690,569.200659179688; 13695,569.191198730469; 13700,569.181768798828; 13705,569.172308349609; 13710,569.162878417969; 13715,569.15341796875; 13720,569.143988037109; 13725,569.134527587891; 13730,569.12509765625; 13735,569.115637207031; 13740,569.106207275391; 13745,569.09677734375; 13750,569.087316894531; 13755,569.077886962891; 13760,569.068426513672; 13765,569.058996582031; 13770,569.049536132813; 13775,569.040106201172; 13780,569.030645751953; 13785,569.021215820313; 13790,569.011755371094; 13795,569.002325439453; 13800,568.992864990234; 13805,568.983435058594; 13810,568.974005126953; 13815,568.964544677734; 13820,568.955114746094; 13825,568.945654296875; 13830,
        568.936224365234; 13835,568.926763916016; 13840,568.917333984375; 13845,568.907873535156; 13850,568.906439208984; 13855,568.947393798828; 13860,568.988317871094; 13865,569.029272460938; 13870,569.070227050781; 13875,569.111151123047; 13880,569.152105712891; 13885,569.193060302734; 13890,569.233984375; 13895,569.274938964844; 13900,569.315893554688; 13905,569.356817626953; 13910,569.397772216797; 13915,569.438726806641; 13920,569.479650878906; 13925,569.52060546875; 13930,569.561560058594; 13935,569.602484130859; 13940,569.643438720703; 13945,569.684393310547; 13950,569.725317382813; 13955,569.766271972656; 13960,569.8072265625; 13965,569.848150634766; 13970,569.889105224609; 13975,569.930059814453; 13980,569.970983886719; 13985,570.011938476563; 13990,570.052893066406; 13995,570.093817138672; 14000,570.134771728516; 14005,570.175726318359; 14010,570.216650390625; 14015,570.257604980469; 14020,570.298559570313; 14025,570.339483642578; 14030,570.380438232422; 14035,
        570.421392822266; 14040,570.462316894531; 14045,570.503271484375; 14050,570.544226074219; 14055,570.585150146484; 14060,570.626104736328; 14065,570.667059326172; 14070,570.707983398438; 14075,570.748937988281; 14080,570.789892578125; 14085,570.830816650391; 14090,570.871771240234; 14095,570.912725830078; 14100,570.953649902344; 14105,570.994604492188; 14110,571.035559082031; 14115,571.076483154297; 14120,571.117437744141; 14125,571.158392333984; 14130,571.19931640625; 14135,571.240270996094; 14140,571.281225585938; 14145,571.322149658203; 14150,571.363104248047; 14155,571.404058837891; 14160,571.444982910156; 14165,571.446234130859; 14170,571.442053222656; 14175,571.437872314453; 14180,571.43369140625; 14185,571.429510498047; 14190,571.425329589844; 14195,571.421148681641; 14200,571.416937255859; 14205,571.412756347656; 14210,571.408575439453; 14215,571.40439453125; 14220,571.400213623047; 14225,571.396032714844; 14230,571.391851806641; 14235,571.387640380859; 14240,
        571.383459472656; 14245,571.379278564453; 14250,571.37509765625; 14255,571.370916748047; 14260,571.366735839844; 14265,571.362554931641; 14270,571.358343505859; 14275,571.354162597656; 14280,571.349981689453; 14285,571.34580078125; 14290,571.341619873047; 14295,571.337438964844; 14300,571.333258056641; 14305,571.329077148438; 14310,571.324865722656; 14315,571.320684814453; 14320,571.31650390625; 14325,571.312322998047; 14330,571.308142089844; 14335,571.303961181641; 14340,571.299780273438; 14345,571.295568847656; 14350,571.291387939453; 14355,571.28720703125; 14360,571.283026123047; 14365,571.278845214844; 14370,571.274664306641; 14375,571.270483398438; 14380,571.266271972656; 14385,571.262091064453; 14390,571.25791015625; 14395,571.253729248047; 14400,571.249548339844; 14405,571.245367431641; 14410,571.241186523438; 14415,571.237005615234; 14420,571.232794189453; 14425,571.22861328125; 14430,571.224432373047; 14435,571.220251464844; 14440,571.216070556641; 14445,
        571.211889648438; 14450,571.207708740234; 14455,571.203497314453; 14460,571.19931640625; 14465,571.195135498047; 14470,571.190954589844; 14475,571.186773681641; 14480,571.182592773438; 14485,571.178411865234; 14490,571.174200439453; 14495,571.17001953125; 14500,571.165838623047; 14505,571.161657714844; 14510,571.157476806641; 14515,571.153295898438; 14520,571.149114990234; 14525,571.144934082031; 14530,571.14072265625; 14535,571.136541748047; 14540,571.132360839844; 14545,571.128179931641; 14550,571.123999023438; 14555,571.119818115234; 14560,571.115637207031; 14565,571.11142578125; 14570,571.107244873047; 14575,571.103063964844; 14580,571.098883056641; 14585,571.094702148438; 14590,571.090521240234; 14595,571.086340332031; 14600,571.08212890625; 14605,571.077947998047; 14610,571.073767089844; 14615,571.069586181641; 14620,571.065405273438; 14625,571.061224365234; 14630,571.057043457031; 14635,571.052862548828; 14640,571.048651123047; 14645,571.044470214844; 14650,
        571.040289306641; 14655,571.036108398438; 14660,571.031927490234; 14665,571.027746582031; 14670,571.023565673828; 14675,571.019354248047; 14680,571.015173339844; 14685,571.010992431641; 14690,571.006811523438; 14695,571.002630615234; 14700,570.998449707031; 14705,570.994268798828; 14710,570.990057373047; 14715,570.985876464844; 14720,570.981695556641; 14725,570.977514648438; 14730,570.973333740234; 14735,570.969152832031; 14740,570.964971923828; 14745,570.960760498047; 14750,570.956579589844; 14755,570.952398681641; 14760,570.948217773438; 14765,570.944036865234; 14770,570.939855957031; 14775,570.935675048828; 14780,570.931494140625; 14785,570.927282714844; 14790,570.923101806641; 14795,570.918920898438; 14800,570.914739990234; 14805,570.910559082031; 14810,570.906378173828; 14815,570.902197265625; 14820,570.897985839844; 14825,570.893804931641; 14830,570.889624023438; 14835,570.885443115234; 14840,570.881262207031; 14845,570.877081298828; 14850,570.872900390625; 14855,
        570.868688964844; 14860,570.864508056641; 14865,570.860327148438; 14870,570.856146240234; 14875,570.851965332031; 14880,570.847784423828; 14885,570.843603515625; 14890,570.839422607422; 14895,570.835211181641; 14900,570.831030273438; 14905,570.826849365234; 14910,570.822668457031; 14915,570.818487548828; 14920,570.814306640625; 14925,570.810125732422; 14930,570.805914306641; 14935,570.801733398438; 14940,570.797552490234; 14945,570.793371582031; 14950,570.789190673828; 14955,570.785009765625; 14960,570.780828857422; 14965,570.776617431641; 14970,570.772436523438; 14975,570.768255615234; 14980,570.764074707031; 14985,570.759893798828; 14990,570.755712890625; 14995,570.751531982422; 15000,570.747351074219; 15005,570.743139648438; 15010,570.738958740234; 15015,570.734777832031; 15020,570.730596923828; 15025,570.726416015625; 15030,570.722235107422; 15035,570.718054199219; 15040,570.713842773438; 15045,570.709661865234; 15050,570.705480957031; 15055,570.701300048828; 15060,
        570.697119140625; 15065,570.692938232422; 15070,570.688757324219; 15075,570.684545898438; 15080,570.680364990234; 15085,570.676184082031; 15090,570.672003173828; 15095,570.667822265625; 15100,570.663641357422; 15105,570.659460449219; 15110,570.655249023438; 15115,570.651068115234; 15120,570.646887207031; 15125,570.642706298828; 15130,570.638525390625; 15135,570.634344482422; 15140,570.630163574219; 15145,570.625982666016; 15150,570.621771240234; 15155,570.617590332031; 15160,570.613409423828; 15165,570.609228515625; 15170,570.605047607422; 15175,570.600866699219; 15180,570.596685791016; 15185,570.592474365234; 15190,570.588293457031; 15195,570.584112548828; 15200,570.579931640625; 15205,570.575750732422; 15210,570.571569824219; 15215,570.567388916016; 15220,570.563177490234; 15225,570.558996582031; 15230,570.554815673828; 15235,570.550634765625; 15240,570.546453857422; 15245,570.542272949219; 15250,570.538092041016; 15255,570.533911132813; 15260,570.529699707031; 15265,
        570.525518798828; 15270,570.521337890625; 15275,570.517156982422; 15280,570.512976074219; 15285,570.508795166016; 15290,570.504614257813; 15295,570.500402832031; 15300,570.496221923828; 15305,570.492041015625; 15310,570.487860107422; 15315,570.483679199219; 15320,570.479498291016; 15325,570.475317382813; 15330,570.471105957031; 15335,570.466925048828; 15340,570.462744140625; 15345,570.458563232422; 15350,570.454382324219; 15355,570.450201416016; 15360,570.446020507813; 15365,570.441839599609; 15370,570.437628173828; 15375,570.433447265625; 15380,570.429266357422; 15385,570.425085449219; 15390,570.420904541016; 15395,570.416723632813; 15400,570.412542724609; 15405,570.408331298828; 15410,570.404150390625; 15415,570.399969482422; 15420,570.395788574219; 15425,570.391607666016; 15430,570.387426757813; 15435,570.383245849609; 15440,570.379034423828; 15445,570.374853515625; 15450,570.370672607422; 15455,570.366491699219; 15460,570.362310791016; 15465,570.358129882813; 15470,
        570.353948974609; 15475,570.349768066406; 15480,570.345556640625; 15485,570.341375732422; 15490,570.337194824219; 15495,570.333013916016; 15500,570.328833007813; 15505,570.324652099609; 15510,570.320471191406; 15515,570.316259765625; 15520,570.312078857422; 15525,570.307897949219; 15530,570.303717041016; 15535,570.299536132813; 15540,570.295355224609; 15545,570.291174316406; 15550,570.286962890625; 15555,570.282781982422; 15560,570.278601074219; 15565,570.274420166016; 15570,570.270239257813; 15575,570.266058349609; 15580,570.261877441406; 15585,570.257666015625; 15590,570.253485107422; 15595,570.249304199219; 15600,570.245123291016; 15605,570.240942382813; 15610,570.236761474609; 15615,570.232580566406; 15620,570.228399658203; 15625,570.224188232422; 15630,570.220007324219; 15635,570.215826416016; 15640,570.211645507813; 15645,570.207464599609; 15650,570.203283691406; 15655,570.199102783203; 15660,570.194891357422; 15665,570.190710449219; 15670,570.186529541016; 15675,
        570.182348632813; 15680,570.178167724609; 15685,570.173986816406; 15690,570.169805908203; 15695,570.165594482422; 15700,570.161413574219; 15705,570.157232666016; 15710,570.153051757813; 15715,570.148870849609; 15720,570.144689941406; 15725,570.140509033203; 15730,570.136328125; 15735,570.132116699219; 15740,570.127935791016; 15745,570.123754882813; 15750,570.119573974609; 15755,570.115393066406; 15760,570.111212158203; 15765,570.10703125; 15770,570.102819824219; 15775,570.098638916016; 15780,570.094458007813; 15785,570.090277099609; 15790,570.086096191406; 15795,570.081915283203; 15800,570.077734375; 15805,570.073522949219; 15810,570.069342041016; 15815,570.065161132813; 15820,570.060980224609; 15825,570.056799316406; 15830,570.052618408203; 15835,570.0484375; 15840,570.044256591797; 15845,570.040045166016; 15850,570.035864257813; 15855,570.031683349609; 15860,570.027502441406; 15865,570.023321533203; 15870,570.019140625; 15875,570.014959716797; 15880,570.010748291016; 15885,
        570.006567382813; 15890,570.002386474609; 15895,569.998205566406; 15900,569.994024658203; 15905,569.98984375; 15910,569.985662841797; 15915,569.981451416016; 15920,569.977270507813; 15925,569.973089599609; 15930,569.968908691406; 15935,569.964727783203; 15940,569.960546875; 15945,569.956365966797; 15950,569.952154541016; 15955,569.947973632813; 15960,569.943792724609; 15965,569.939611816406; 15970,569.935430908203; 15975,569.93125; 15980,569.927069091797; 15985,569.922888183594; 15990,569.918676757813; 15995,569.914495849609; 16000,569.910314941406; 16005,569.906134033203; 16010,569.901953125; 16015,569.897772216797; 16020,569.893591308594; 16025,569.889379882813; 16030,569.885198974609; 16035,569.881018066406; 16040,569.876837158203; 16045,569.87265625; 16050,569.868475341797; 16055,569.864294433594; 16060,569.860083007813; 16065,569.855902099609; 16070,569.851721191406; 16075,569.847540283203; 16080,569.843359375; 16085,569.839178466797; 16090,569.834997558594; 16095,
        569.830816650391; 16100,569.826605224609; 16105,569.822424316406; 16110,569.818243408203; 16115,569.8140625; 16120,569.809881591797; 16125,569.805700683594; 16130,569.801519775391; 16135,569.797308349609; 16140,569.793127441406; 16145,569.788946533203; 16150,569.784765625; 16155,569.780584716797; 16160,569.776403808594; 16165,569.772222900391; 16170,569.768011474609; 16175,569.763830566406; 16180,569.759649658203; 16185,569.75546875; 16190,569.751287841797; 16195,569.747106933594; 16200,569.742926025391; 16205,569.738745117188; 16210,569.734533691406; 16215,569.730352783203; 16220,569.726171875; 16225,569.721990966797; 16230,569.717810058594; 16235,569.713629150391; 16240,569.709448242188; 16245,569.705236816406; 16250,569.701055908203; 16255,569.696875; 16260,569.692694091797; 16265,569.688513183594; 16270,569.684332275391; 16275,569.680151367188; 16280,569.675939941406; 16285,569.671759033203; 16290,569.667578125; 16295,569.663397216797; 16300,569.659216308594; 16305,
        569.655035400391; 16310,569.650854492188; 16315,569.646643066406; 16320,569.642462158203; 16325,569.63828125; 16330,569.634100341797; 16335,569.629919433594; 16340,569.625738525391; 16345,569.621557617188; 16350,569.617376708984; 16355,569.613165283203; 16360,569.608984375; 16365,569.604803466797; 16370,569.600622558594; 16375,569.596441650391; 16380,569.592260742188; 16385,569.588079833984; 16390,569.583868408203; 16395,569.5796875; 16400,569.575506591797; 16405,569.571325683594; 16410,569.567144775391; 16415,569.562963867188; 16420,569.558782958984; 16425,569.554571533203; 16430,569.550390625; 16435,569.546209716797; 16440,569.542028808594; 16445,569.537847900391; 16450,569.533666992188; 16455,569.529486083984; 16460,569.525305175781; 16465,569.52109375; 16470,569.516912841797; 16475,569.512731933594; 16480,569.508551025391; 16485,569.504370117188; 16490,569.500189208984; 16495,569.496008300781; 16500,569.491796875; 16505,569.487615966797; 16510,569.483435058594; 16515,
        569.479254150391; 16520,569.475073242188; 16525,569.470892333984; 16530,569.466711425781; 16535,569.4625; 16540,569.458319091797; 16545,569.454138183594; 16550,569.449957275391; 16555,569.445776367188; 16560,569.441595458984; 16565,569.437414550781; 16570,569.433233642578; 16575,569.429022216797; 16580,569.424841308594; 16585,569.420660400391; 16590,569.416479492188; 16595,569.412298583984; 16600,569.408117675781; 16605,569.403936767578; 16610,569.399725341797; 16615,569.395544433594; 16620,569.391363525391; 16625,569.387182617188; 16630,569.383001708984; 16635,569.378820800781; 16640,569.374639892578; 16645,569.370428466797; 16650,569.366247558594; 16655,569.362066650391; 16660,569.357885742188; 16665,569.353704833984; 16670,569.349401855469; 16675,569.344213867188; 16680,569.339025878906; 16685,569.333837890625; 16690,569.328649902344; 16695,569.323461914063; 16700,569.318273925781; 16705,569.3130859375; 16710,569.307897949219; 16715,569.302709960938; 16720,569.297521972656;
        16725,569.292333984375; 16730,569.287145996094; 16735,569.281958007813; 16740,569.276770019531; 16745,569.27158203125; 16750,569.266363525391; 16755,569.261175537109; 16760,569.255987548828; 16765,569.250799560547; 16770,569.245611572266; 16775,569.240423583984; 16780,569.235235595703; 16785,569.230047607422; 16790,569.224859619141; 16795,569.219671630859; 16800,569.214483642578; 16805,569.209295654297; 16810,569.204107666016; 16815,569.198919677734; 16820,569.193731689453; 16825,569.188543701172; 16830,569.183355712891; 16835,569.178167724609; 16840,569.172979736328; 16845,569.167761230469; 16850,569.162573242188; 16855,569.157385253906; 16860,569.152197265625; 16865,569.147009277344; 16870,569.141821289063; 16875,569.136633300781; 16880,569.1314453125; 16885,569.126257324219; 16890,569.121069335938; 16895,569.115881347656; 16900,569.110693359375; 16905,569.105505371094; 16910,569.100317382813; 16915,569.095129394531; 16920,569.08994140625; 16925,569.084753417969; 16930,
        569.079565429688; 16935,569.074346923828; 16940,569.069158935547; 16945,569.063970947266; 16950,569.058782958984; 16955,569.053594970703; 16960,569.048406982422; 16965,569.043218994141; 16970,569.038031005859; 16975,569.032843017578; 16980,569.027655029297; 16985,569.022467041016; 16990,569.017279052734; 16995,569.012091064453; 17000,569.006903076172; 17005,569.001715087891; 17010,568.996527099609; 17015,568.991339111328; 17020,568.986151123047; 17025,568.980932617188; 17030,568.975744628906; 17035,568.970556640625; 17040,568.965368652344; 17045,568.960180664063; 17050,568.954992675781; 17055,568.9498046875; 17060,568.944616699219; 17065,568.939428710938; 17070,568.934240722656; 17075,568.929052734375; 17080,568.923864746094; 17085,568.918676757813; 17090,568.913488769531; 17095,568.90830078125; 17100,568.903112792969; 17105,568.897924804688; 17110,568.892736816406; 17115,568.887548828125; 17120,568.882330322266; 17125,568.877142333984; 17130,568.871954345703; 17135,
        568.866766357422; 17140,568.861578369141; 17145,568.856390380859; 17150,568.851202392578; 17155,568.846014404297; 17160,568.840826416016; 17165,568.835638427734; 17170,568.830450439453; 17175,568.825262451172; 17180,568.820074462891; 17185,568.814886474609; 17190,568.809698486328; 17195,568.804510498047; 17200,568.799322509766; 17205,568.794134521484; 17210,568.788916015625; 17215,568.783728027344; 17220,568.778540039063; 17225,568.773352050781; 17230,568.7681640625; 17235,568.762976074219; 17240,568.757788085938; 17245,568.752600097656; 17250,568.747412109375; 17255,568.742224121094; 17260,568.737036132813; 17265,568.731848144531; 17270,568.72666015625; 17275,568.721472167969; 17280,568.716284179688; 17285,568.711096191406; 17290,568.705908203125; 17295,568.700720214844; 17300,568.695501708984; 17305,568.690313720703; 17310,568.685125732422; 17315,568.679937744141; 17320,568.674749755859; 17325,568.669561767578; 17330,568.664373779297; 17335,568.659185791016; 17340,
        568.653997802734; 17345,568.648809814453; 17350,568.643621826172; 17355,568.638433837891; 17360,568.633245849609; 17365,568.628057861328; 17370,568.622869873047; 17375,568.617681884766; 17380,568.612493896484; 17385,568.607305908203; 17390,568.602087402344; 17395,568.596899414063; 17400,568.591711425781; 17405,568.5865234375; 17410,568.581335449219; 17415,568.576147460938; 17420,568.570959472656; 17425,568.565771484375; 17430,568.560583496094; 17435,568.555395507813; 17440,568.550207519531; 17445,568.54501953125; 17450,568.539831542969; 17455,568.534643554688; 17460,568.529455566406; 17465,568.524267578125; 17470,568.519079589844; 17475,568.513891601563; 17480,568.508703613281; 17485,568.503485107422; 17490,568.498297119141; 17495,568.493109130859; 17500,568.487921142578; 17505,568.482733154297; 17510,568.477545166016; 17515,568.472357177734; 17520,568.467169189453; 17525,568.461981201172; 17530,568.456793212891; 17535,568.451605224609; 17540,568.446417236328; 17545,
        568.441229248047; 17550,568.436041259766; 17555,568.430853271484; 17560,568.425665283203; 17565,568.420477294922; 17570,568.415289306641; 17575,568.410070800781; 17580,568.4048828125; 17585,568.399694824219; 17590,568.394506835938; 17595,568.389318847656; 17600,568.384130859375; 17605,568.378942871094; 17610,568.373754882813; 17615,568.368566894531; 17620,568.36337890625; 17625,568.358190917969; 17630,568.353002929688; 17635,568.347814941406; 17640,568.342626953125; 17645,568.337438964844; 17650,568.332250976563; 17655,568.327062988281; 17660,568.321875; 17665,568.316656494141; 17670,568.311468505859; 17675,568.306280517578; 17680,568.301092529297; 17685,568.295904541016; 17690,568.290716552734; 17695,568.285528564453; 17700,568.280340576172; 17705,568.275152587891; 17710,568.269964599609; 17715,568.264776611328; 17720,568.259588623047; 17725,568.254400634766; 17730,568.249212646484; 17735,568.244024658203; 17740,568.238836669922; 17745,568.233648681641; 17750,568.228460693359;
        17755,568.223272705078; 17760,568.218054199219; 17765,568.212866210938; 17770,568.207678222656; 17775,568.202490234375; 17780,568.197302246094; 17785,568.192114257813; 17790,568.186926269531; 17795,568.18173828125; 17800,568.176550292969; 17805,568.171362304688; 17810,568.166174316406; 17815,568.160986328125; 17820,568.155798339844; 17825,568.150610351563; 17830,568.145422363281; 17835,568.140234375; 17840,568.135046386719; 17845,568.129858398438; 17850,568.124639892578; 17855,568.119451904297; 17860,568.114263916016; 17865,568.109075927734; 17870,568.103887939453; 17875,568.098699951172; 17880,568.093511962891; 17885,568.088323974609; 17890,568.083135986328; 17895,568.077947998047; 17900,568.072760009766; 17905,568.067572021484; 17910,568.062384033203; 17915,568.057196044922; 17920,568.052008056641; 17925,568.046820068359; 17930,568.041632080078; 17935,568.036444091797; 17940,568.031225585938; 17945,568.026037597656; 17950,568.020849609375; 17955,568.015661621094; 17960,
        568.010473632813; 17965,568.005285644531; 17970,568.00009765625; 17975,567.994909667969; 17980,567.989721679688; 17985,567.984533691406; 17990,567.979345703125; 17995,567.974157714844; 18000,567.968969726563; 18005,567.963781738281; 18010,567.95859375; 18015,567.953405761719; 18020,567.948217773438; 18025,567.943029785156; 18030,567.937841796875; 18035,567.932623291016; 18040,567.927435302734; 18045,567.922247314453; 18050,567.917059326172; 18055,567.911871337891; 18060,567.906683349609; 18065,567.901495361328; 18070,567.896307373047; 18075,567.891119384766; 18080,567.885931396484; 18085,567.880743408203; 18090,567.875555419922; 18095,567.870367431641; 18100,567.865179443359; 18105,567.859991455078; 18110,567.854803466797; 18115,567.849615478516; 18120,567.844427490234; 18125,567.839208984375; 18130,567.834020996094; 18135,567.828833007813; 18140,567.823645019531; 18145,567.81845703125; 18150,567.813269042969; 18155,567.808081054688; 18160,567.802893066406; 18165,
        567.797705078125; 18170,567.792517089844; 18175,567.787329101563; 18180,567.782141113281; 18185,567.776953125; 18190,567.771765136719; 18195,567.766577148438; 18200,567.761389160156; 18205,567.756201171875; 18210,567.751013183594; 18215,567.745794677734; 18220,567.740606689453; 18225,567.735418701172; 18230,567.730230712891; 18235,567.725042724609; 18240,567.719854736328; 18245,567.714666748047; 18250,567.709478759766; 18255,567.704290771484; 18260,567.699102783203; 18265,567.693914794922; 18270,567.688726806641; 18275,567.683538818359; 18280,567.678350830078; 18285,567.673162841797; 18290,567.667974853516; 18295,567.662786865234; 18300,567.657598876953; 18305,567.652380371094; 18310,567.647192382813; 18315,567.642004394531; 18320,567.63681640625; 18325,567.631628417969; 18330,567.626440429688; 18335,567.621252441406; 18340,567.616064453125; 18345,567.610876464844; 18350,567.605688476563; 18355,567.600500488281; 18360,567.5953125; 18365,567.590124511719; 18370,567.584936523438;
        18375,567.579748535156; 18380,567.574560546875; 18385,567.569372558594; 18390,567.564184570313; 18395,567.558996582031; 18400,567.553778076172; 18405,567.548590087891; 18410,567.543402099609; 18415,567.538214111328; 18420,567.533026123047; 18425,567.527838134766; 18430,567.522650146484; 18435,567.517462158203; 18440,567.512274169922; 18445,567.507086181641; 18450,567.501898193359; 18455,567.496710205078; 18460,567.491522216797; 18465,567.486334228516; 18470,567.481146240234; 18475,567.475958251953; 18480,567.470770263672; 18485,567.465582275391; 18490,567.460363769531; 18495,567.45517578125; 18500,567.449987792969; 18505,567.444799804688; 18510,567.439611816406; 18515,567.434423828125; 18520,567.429235839844; 18525,567.424047851563; 18530,567.418859863281; 18535,567.413671875; 18540,567.408483886719; 18545,567.403295898438; 18550,567.398107910156; 18555,567.392919921875; 18560,567.387731933594; 18565,567.382543945313; 18570,567.377355957031; 18575,567.37216796875; 18580,
        567.366949462891; 18585,567.361761474609; 18590,567.356573486328; 18595,567.351385498047; 18600,567.346197509766; 18605,567.341009521484; 18610,567.335821533203; 18615,567.330633544922; 18620,567.325445556641; 18625,567.320257568359; 18630,567.315069580078; 18635,567.309881591797; 18640,567.304693603516; 18645,567.299505615234; 18650,567.294317626953; 18655,567.289129638672; 18660,567.283941650391; 18665,567.278753662109; 18670,567.273565673828; 18675,567.268347167969; 18680,567.263159179688; 18685,567.257971191406; 18690,567.252783203125; 18695,567.247595214844; 18700,567.242407226563; 18705,567.237219238281; 18710,567.23203125; 18715,567.226843261719; 18720,567.221655273438; 18725,567.216467285156; 18730,567.211279296875; 18735,567.206091308594; 18740,567.200903320313; 18745,567.195715332031; 18750,567.19052734375; 18755,567.185339355469; 18760,567.180151367188; 18765,567.174932861328; 18770,567.169744873047; 18775,567.164556884766; 18780,567.159368896484; 18785,
        567.154180908203; 18790,567.148992919922; 18795,567.143804931641; 18800,567.138616943359; 18805,567.133428955078; 18810,567.128240966797; 18815,567.123052978516; 18820,567.117864990234; 18825,567.112677001953; 18830,567.107489013672; 18835,567.102301025391; 18840,567.097113037109; 18845,567.091925048828; 18850,567.086737060547; 18855,567.081518554688; 18860,567.076330566406; 18865,567.071142578125; 18870,567.065954589844; 18875,567.060766601563; 18880,567.055578613281; 18885,567.050390625; 18890,567.057043457031; 18895,567.064978027344; 18900,567.072882080078; 18905,567.080786132813; 18910,567.088690185547; 18915,567.096594238281; 18920,567.104498291016; 18925,567.11240234375; 18930,567.120306396484; 18935,567.128240966797; 18940,567.136145019531; 18945,567.144049072266; 18950,567.151953125; 18955,567.159857177734; 18960,567.167761230469; 18965,567.175665283203; 18970,567.183569335938; 18975,567.191473388672; 18980,567.199407958984; 18985,567.207312011719; 18990,
        567.215216064453; 18995,567.223120117188; 19000,567.231024169922; 19005,567.238928222656; 19010,567.246832275391; 19015,567.254736328125; 19020,567.262640380859; 19025,567.270574951172; 19030,567.278479003906; 19035,567.286383056641; 19040,567.294287109375; 19045,567.302191162109; 19050,567.310095214844; 19055,567.317999267578; 19060,567.325903320313; 19065,567.333807373047; 19070,567.341741943359; 19075,567.349645996094; 19080,567.357550048828; 19085,567.365454101563; 19090,567.373358154297; 19095,567.381262207031; 19100,567.389166259766; 19105,567.3970703125; 19110,567.404974365234; 19115,567.412908935547; 19120,567.420812988281; 19125,567.428717041016; 19130,567.43662109375; 19135,567.444525146484; 19140,567.452429199219; 19145,567.460333251953; 19150,567.468237304688; 19155,567.476141357422; 19160,567.484075927734; 19165,567.491979980469; 19170,567.499884033203; 19175,567.507788085938; 19180,567.515692138672; 19185,567.523596191406; 19190,567.531500244141; 19195,
        567.539404296875; 19200,567.547338867188; 19205,567.555242919922; 19210,567.563146972656; 19215,567.571051025391; 19220,567.578955078125; 19225,567.586859130859; 19230,567.594763183594; 19235,567.602667236328; 19240,567.610571289063; 19245,567.618505859375; 19250,567.626409912109; 19255,567.634313964844; 19260,567.642218017578; 19265,567.650122070313; 19270,567.658026123047; 19275,567.665930175781; 19280,567.673834228516; 19285,567.68173828125; 19290,567.689672851563; 19295,567.697576904297; 19300,567.709844970703; 19305,567.723974609375; 19310,567.738104248047; 19315,567.752233886719; 19320,567.766363525391; 19325,567.780493164063; 19330,567.794622802734; 19335,567.808752441406; 19340,567.822882080078; 19345,567.83701171875; 19350,567.851141357422; 19355,567.865270996094; 19360,567.879400634766; 19365,567.893530273438; 19370,567.907659912109; 19375,567.921789550781; 19380,567.935919189453; 19385,567.950079345703; 19390,567.964208984375; 19395,567.978338623047; 19400,
        567.992468261719; 19405,568.006597900391; 19410,568.020727539063; 19415,568.034857177734; 19420,568.048986816406; 19425,568.063116455078; 19430,568.07724609375; 19435,568.091375732422; 19440,568.105505371094; 19445,568.119635009766; 19450,568.133764648438; 19455,568.147894287109; 19460,568.162023925781; 19465,568.176153564453; 19470,568.190283203125; 19475,568.204412841797; 19480,568.218542480469; 19485,568.232672119141; 19490,568.246801757813; 19495,568.260931396484; 19500,568.275061035156; 19505,568.289221191406; 19510,568.303350830078; 19515,568.31748046875; 19520,568.331610107422; 19525,568.345739746094; 19530,568.359869384766; 19535,568.373999023438; 19540,568.388128662109; 19545,568.402258300781; 19550,568.416387939453; 19555,568.430517578125; 19560,568.444647216797; 19565,568.458776855469; 19570,568.472906494141; 19575,568.487036132813; 19580,568.501165771484; 19585,568.515295410156; 19590,568.529425048828; 19595,568.5435546875; 19600,568.557684326172; 19605,
        568.571813964844; 19610,568.585943603516; 19615,568.600073242188; 19620,568.614202880859; 19625,568.628363037109; 19630,568.642492675781; 19635,568.656622314453; 19640,568.670751953125; 19645,568.684881591797; 19650,568.699011230469; 19655,568.634130859375; 19660,568.563757324219; 19665,568.493383789063; 19670,568.422979736328; 19675,568.352606201172; 19680,568.282202148438; 19685,568.211828613281; 19690,568.141455078125; 19695,568.071051025391; 19700,568.000677490234; 19705,567.9302734375; 19710,567.859899902344; 19715,567.789526367188; 19720,567.719122314453; 19725,567.648748779297; 19730,567.578344726563; 19735,567.507971191406; 19740,567.437567138672; 19745,567.367193603516; 19750,567.296820068359; 19755,567.226416015625; 19760,567.156042480469; 19765,567.085638427734; 19770,567.015264892578; 19775,566.944891357422; 19780,566.874487304688; 19785,566.804113769531; 19790,566.733709716797; 19795,566.663336181641; 19800,566.592962646484; 19805,566.52255859375; 19810,
        566.452185058594; 19815,566.381781005859; 19820,566.311407470703; 19825,566.241003417969; 19830,566.170629882813; 19835,566.100256347656; 19840,566.029852294922; 19845,565.959478759766; 19850,565.889074707031; 19855,565.818701171875; 19860,565.748327636719; 19865,565.677923583984; 19870,565.607550048828; 19875,565.537145996094; 19880,565.466772460938; 19885,565.396398925781; 19890,565.325994873047; 19895,565.255621337891; 19900,565.185217285156; 19905,565.11484375; 19910,565.044470214844; 19915,564.974066162109; 19920,564.903692626953; 19925,564.833288574219; 19930,564.762915039063; 19935,564.701483154297; 19940,564.716192626953; 19945,564.730932617188; 19950,564.745672607422; 19955,564.760412597656; 19960,564.775122070313; 19965,564.789862060547; 19970,564.804602050781; 19975,564.819311523438; 19980,564.834051513672; 19985,564.848791503906; 19990,564.863531494141; 19995,564.878240966797]) annotation (Placement(transformation(extent={{-440,-140},{-420,-120}})));
  Mill_L4_advancedInit millBox_advancedInit(
    m_flow_gas_nom=20.83,
    m_flow_fuel_nom=0.97*13.06,
    classification=Volumes.Fundamentals.Records.FuelClassification_example_21classes(),
    classFraction={0.0297,0.1049,0.1155,0.13,0.111,0.0875,0.0728,0.0541,0.0501,0.0484,0.0432,0.0415,0.0399,0.0363,0.0344,0,0,0,0,0},
    T_grinder_start=273.15 + 20,
    xi_transport_fuel_start={0.761,0,0,0,0.004,0.125},
    xi_classifier_fuel_start={0.761,0,0,0,0.004,0.125},
    p_classifier_start=simCenter.p_amb_start,
    xi_grinder_start={0.761,0,0,0,0.004,0.111},
    redeclare model Drying = Volumes.Fundamentals.Drying.Drying_ideal,
    mass_transport_start=133,
    mass_classifier_start=90,
    xi_dryer_gas_out_start={0,0,0,0,0.73,0.21,0,0.06,0},
    xi_transport_gas_start={0,0,0,0,0.73,0.21,0,0.06,0},
    xi_classifier_gas_start={0,0,0,0,0.73,0.21,0,0.06,0},
    T_dryer_start=273.15 + 100,
    T_transport_start=273.15 + 100,
    T_classifier_start=273.15 + 100,
    xi_dryer_gas_in_start={0,0,0,0,0.757,0.231,0,0.005,0},
    redeclare model Classifying_centrifugal = Volumes.Fundamentals.Classifying.Classifying_centrifugal (slip_w_gas_t=22/55, w_prtcl_r_rel_start=cat(
            2,
            10*ones(millBox_advancedInit.centrifugalClassifier.n, 14),
            0.01*ones(millBox_advancedInit.centrifugalClassifier.n, 7))),
    redeclare model Classifying_flow = Volumes.Fundamentals.Classifying.Classifying_flow (w_prtcl_rel_start=cat(
            2,
            10*ones(millBox_advancedInit.flowClassifier.n, 7),
            0.01*ones(millBox_advancedInit.flowClassifier.n, 14))),
    p_dryer_start=simCenter.p_amb_start + millBox_advancedInit.flowClassifier.pressureLoss.Delta_p_nom + millBox_advancedInit.centrifugalClassifier.pressureLoss.Delta_p_nom,
    p_transport_start=simCenter.p_amb_start + millBox_advancedInit.centrifugalClassifier.pressureLoss.Delta_p_nom) "s0 = 375e-10" annotation (Placement(transformation(extent={{-14,-14},{14,14}})));
  Modelica.Blocks.Sources.TimeTable timeTableCoalDust_complete(table=[0,11.1389498551045; 5,11.1671667525748; 10,11.1923562239811; 15,11.2147218742702; 20,11.2344596744357; 25,11.2517580892483; 30,11.2667982049874; 35,11.279753857172; 40,11.2907917582911; 45,11.3000716255355; 50,11.307746308528; 55,11.3139619170548; 60,11.3188579487963; 65,11.3225674170582; 70,11.3252169785022; 75,11.3269270608771; 80,11.32781199075; 85,11.3279801212369; 90,11.3275339597337; 95,11.3265702956474; 100,11.3251803281268; 105,11.3234497937937; 110,11.3214590944735; 115,11.3192834249267; 120,11.3169929005793; 125,11.3146526852542; 130,11.3123231189017; 135,11.310059845331; 140,11.3079139399408; 145,11.3059320374503; 150,11.3041564596301; 155,11.3026253430336; 160,11.3013727667273; 165,11.3004288800223; 170,11.2998200302048; 175,11.2995688902676; 180,11.2996945866404; 185,11.3002128269216; 190,11.3011360276083; 195,11.302473441828; 200,11.3042312870693; 205,11.3064128729128; 210,11.3090187287621; 215,
        11.3120467315747; 220,11.3154922335934; 225,11.3193481900764; 230,11.323605287029; 235,11.3282520689344; 240,11.3332750664845; 245,11.3386589243108; 250,11.3443865287157; 255,11.3504391354031; 260,11.3567964972096; 265,11.3634369918352; 270,11.3703377495748; 275,11.3774747810485; 280,11.3848231049327; 285,11.3923568756917; 290,11.4000495113077; 295,11.4078738210124; 300,11.4151780662771; 305,11.4202994147703; 310,11.4256826519463; 315,11.4324953990295; 320,11.4402352243121; 325,11.4473290607563; 330,11.4545620589969; 335,11.4619151304381; 340,11.4693631942257; 345,11.4770791171994; 350,11.487115053351; 355,11.497460188046; 360,11.5068908144055; 365,11.5141063883915; 370,11.5202205822708; 375,11.5264166047177; 380,11.5329119238828; 385,11.5379406081863; 390,11.5400048398256; 395,11.5401103848282; 400,11.5399243470698; 405,11.539496264392; 410,11.5390072823332; 415,11.5387259976301; 420,11.5414762411256; 425,11.5449594568045; 430,11.5489160369659; 435,11.5532653553038; 440,
        11.5577373820787; 445,11.5628671213766; 450,11.5682826770416; 455,11.5731926104617; 460,11.5782087327492; 465,11.5842030485764; 470,11.588031722647; 475,11.5933424284231; 480,11.5966246085945; 485,11.6008833828761; 490,11.6060617952838; 495,11.6071946475811; 500,11.6077976940236; 505,11.6082602413247; 510,11.6084751108344; 515,11.6085427991767; 520,11.610386989385; 525,11.6125429817683; 530,11.6136796231392; 535,11.6151001715781; 540,11.6163265018887; 545,11.6167810204632; 550,11.6165983823908; 555,11.6162985458295; 560,11.6165100113696; 565,11.6176923191948; 570,11.619870414286; 575,11.6230620792678; 580,11.6268307236795; 585,11.6308352052739; 590,11.6356966533811; 595,11.6414498794489; 600,11.647584960264; 605,11.6527933865837; 610,11.6578872638013; 615,11.6633383109476; 620,11.6691265740524; 625,11.675175236741; 630,11.6806776392694; 635,11.6843516654122; 640,11.6870044184562; 645,11.6875606063707; 650,11.6877838619526; 655,11.6890452697644; 660,11.6896365846494; 665,
        11.69005254267; 670,11.689615010216; 675,11.689000706899; 680,11.6890325506647; 685,11.6912343423139; 690,11.6923967060345; 695,11.6920911498802; 700,11.6907656824047; 705,11.6894153310449; 710,11.6876480174729; 715,11.6834237284092; 720,11.6779828051088; 725,11.6733554893162; 730,11.6696545025333; 735,11.6673115673618; 740,11.6643448481406; 745,11.6625560269685; 750,11.6594860546258; 755,11.6545434918292; 760,11.6493438629911; 765,11.6436033306325; 770,11.6388198390267; 775,11.6361256608671; 780,11.6300700666025; 785,11.6263633715706; 790,11.6257764979051; 795,11.6269803341001; 800,11.6241121572117; 805,11.6213687779645; 810,11.6185571261096; 815,11.6146552428767; 820,11.6100680637662; 825,11.6062070319201; 830,11.6022969217833; 835,11.5976337088949; 840,11.5918766974896; 845,11.5849640448141; 850,11.5765472440575; 855,11.5682652143802; 860,11.5582705177184; 865,11.5480149234504; 870,11.5379023443958; 875,11.5284992382953; 880,11.5193400772169; 885,11.5106916155339; 890,
        11.5029695465529; 895,11.4944446989437; 900,11.485525368106; 905,11.4762230535497; 910,11.466500686571; 915,11.4574630385242; 920,11.4513644414532; 925,11.4457937222459; 930,11.4404997973564; 935,11.4355744010947; 940,11.4302981470368; 945,11.4245912775015; 950,11.4163393821401; 955,11.4077245133394; 960,11.4001140235998; 965,11.3941712846885; 970,11.390279329441; 975,11.3874534610477; 980,11.3845389730703; 985,11.381707007922; 990,11.3801496015096; 995,11.3800293713672; 1000,11.3802476726958; 1005,11.3813317928678; 1010,11.3835701498434; 1015,11.3866547141845; 1020,11.3904283284741; 1025,11.394661409417; 1030,11.4004360547754; 1035,11.4067669306086; 1040,11.4130355445486; 1045,11.4192924240368; 1050,11.4257524025674; 1055,11.432514753288; 1060,11.4386026983328; 1065,11.4456050914272; 1070,11.454411270008; 1075,11.461436537333; 1080,11.470355046552; 1085,11.4759699203734; 1090,11.482667244694; 1095,11.4916728971772; 1100,11.4998914665376; 1105,11.507179799488; 1110,
        11.5136796444193; 1115,11.5202011966519; 1120,11.5252055747779; 1125,11.5304787907696; 1130,11.5364033899384; 1135,11.5420425098376; 1140,11.5471705739718; 1145,11.5526798019086; 1150,11.5590205855506; 1155,11.5658687797051; 1160,11.5725255162203; 1165,11.578722742048; 1170,11.5848204039142; 1175,11.5906899691349; 1180,11.5961500535595; 1185,11.601664702325; 1190,11.6068215346377; 1195,11.6105725818456; 1200,11.6135463001192; 1205,11.6163781527248; 1210,11.6190825947225; 1215,11.6225360267972; 1220,11.6259943415229; 1225,11.6291361298728; 1230,11.6320883813583; 1235,11.6357032690111; 1240,11.639143139702; 1245,11.6423999620962; 1250,11.645594047911; 1255,11.6476886302214; 1260,11.6496338184065; 1265,11.6526229290076; 1270,11.6570585637786; 1275,11.6608221107957; 1280,11.6628461051892; 1285,11.6608571801762; 1290,11.6580606058566; 1295,11.654278932784; 1300,11.6497301502973; 1305,11.6429839901488; 1310,11.6348902885594; 1315,11.6264868187697; 1320,11.6184704856539; 1325,
        11.6101585497708; 1330,11.6031268002712; 1335,11.5960453448025; 1340,11.5892393665246; 1345,11.5807918253587; 1350,11.5736378467482; 1355,11.5689606994651; 1360,11.5654398079423; 1365,11.5628473419586; 1370,11.5610377602258; 1375,11.5589576917759; 1380,11.557868247716; 1385,11.5569631121346; 1390,11.5553014457492; 1395,11.5528897639424; 1400,11.5515090418087; 1405,11.5497916385935; 1410,11.5482221512242; 1415,11.5473357420005; 1420,11.5473088863913; 1425,11.5457217111483; 1430,11.5433973350818; 1435,11.5404609613162; 1440,11.5374040074392; 1445,11.5344725100336; 1450,11.5320693665793; 1455,11.5295929046804; 1460,11.5291158363409; 1465,11.5292540497015; 1470,11.5297991355538; 1475,11.5309214350223; 1480,11.5326953568889; 1485,11.5338808355461; 1490,11.5339109723899; 1495,11.5342127656837; 1500,11.5347684454535; 1505,11.5371011243571; 1510,11.5413779473078; 1515,11.5460842415357; 1520,11.5490319902217; 1525,11.5521432827202; 1530,11.5563017365101; 1535,11.5607604401688; 1540,
        11.5659632690967; 1545,11.5710591424603; 1550,11.5766887940155; 1555,11.5829364571655; 1560,11.5898117273444; 1565,11.5977134788471; 1570,11.6039606339978; 1575,11.610763061825; 1580,11.6174540934328; 1585,11.6244010258005; 1590,11.6320050494846; 1595,11.6397273396264; 1600,11.6481961071495; 1605,11.6567938689046; 1610,11.6638192636306; 1615,11.6699453974837; 1620,11.6755318854874; 1625,11.6805866540817; 1630,11.6840512499833; 1635,11.6869077779532; 1640,11.6897964725492; 1645,11.6923305216254; 1650,11.6937539658507; 1655,11.6936422869486; 1660,11.6902820054709; 1665,11.6877637940098; 1670,11.68630472156; 1675,11.6857140029625; 1680,11.6852711504195; 1685,11.6866532735531; 1690,11.686933182176; 1695,11.6855587884244; 1700,11.6853783973884; 1705,11.6877378264016; 1710,11.6914178776394; 1715,11.695663586585; 1720,11.6998346143716; 1725,11.704148203881; 1730,11.7079778340804; 1735,11.7119462946288; 1740,11.7158537370405; 1745,11.7200717362036; 1750,11.7234387606227; 1755,
        11.7270715780384; 1760,11.7302359328366; 1765,11.73373058696; 1770,11.7371798833413; 1775,11.7399285003028; 1780,11.7419616024672; 1785,11.7443333011648; 1790,11.7475215543254; 1795,11.7533867242868; 1800,11.7575009920959; 1805,11.7611378941056; 1810,11.7634278210407; 1815,11.7642740231686; 1820,11.765541182158; 1825,11.767093829014; 1830,11.7699080767209; 1835,11.7745815724606; 1840,11.778793555899; 1845,11.7824362024146; 1850,11.786259026564; 1855,11.7902857634276; 1860,11.7946595866635; 1865,11.7976060583008; 1870,11.7988902866273; 1875,11.7995225384432; 1880,11.7997002447056; 1885,11.800190031515; 1890,11.8012798642113; 1895,11.8018096405093; 1900,11.8022006625516; 1905,11.8019087046365; 1910,11.8025028605464; 1915,11.8041793368736; 1920,11.8061067014645; 1925,11.8080991154212; 1930,11.8087404868306; 1935,11.8079938918374; 1940,11.807131761737; 1945,11.8061515353323; 1950,11.8040874137027; 1955,11.8021543563575; 1960,11.800994477769; 1965,11.7999676312913; 1970,
        11.7994932810825; 1975,11.7981707621554; 1980,11.794695199993; 1985,11.7898174148423; 1990,11.7845008255318; 1995,11.7790907939092; 2000,11.773533144748; 2005,11.7666008273993; 2010,11.7596456939237; 2015,11.7527615470317; 2020,11.7458454458551; 2025,11.7392156836996; 2030,11.7327819988524; 2035,11.7265165194056; 2040,11.7205289564546; 2045,11.7147089226825; 2050,11.7091874594762; 2055,11.7043285455965; 2060,11.6997596175922; 2065,11.6954596474574; 2070,11.6907194891796; 2075,11.685586571384; 2080,11.6805124624302; 2085,11.6760252780683; 2090,11.6722161801502; 2095,11.6711475030392; 2100,11.6709656991589; 2105,11.6708787459294; 2110,11.6708435012136; 2115,11.6710577231748; 2120,11.6715911317192; 2125,11.6722073289821; 2130,11.6721188398182; 2135,11.6719035911401; 2140,11.672560828019; 2145,11.6745276604664; 2150,11.677105755381; 2155,11.6809524484798; 2160,11.684988620434; 2165,11.6888928854838; 2170,11.6935910672185; 2175,11.6975132487834; 2180,11.7020200161354; 2185,
        11.705619335782; 2190,11.7079514163069; 2195,11.7102298417061; 2200,11.7117547029657; 2205,11.7124543969847; 2210,11.7116035742772; 2215,11.7106562733071; 2220,11.7104930070973; 2225,11.7096169156002; 2230,11.7068615392332; 2235,11.7034345834556; 2240,11.6992624932821; 2245,11.6943781823686; 2250,11.6904093935027; 2255,11.6881623374549; 2260,11.6888819269235; 2265,11.69051628275; 2270,11.6923417052206; 2275,11.6943049153841; 2280,11.6974179297612; 2285,11.6994124954707; 2290,11.7018463354956; 2295,11.7058701233687; 2300,11.7094810862629; 2305,11.7118031035027; 2310,11.7140668228738; 2315,11.7160288843149; 2320,11.7174574161648; 2325,11.7186254683607; 2330,11.7198596397751; 2335,11.7189998427094; 2340,11.7171208011499; 2345,11.7156112528495; 2350,11.7137778544605; 2355,11.7100725560136; 2360,11.707053594366; 2365,11.7045218030209; 2370,11.7014456651445; 2375,11.6979513097298; 2380,11.6953839275373; 2385,11.6924447291949; 2390,11.6887610244761; 2395,11.6838233836144; 2400,
        11.6802352738995; 2405,11.6766200880755; 2410,11.6763722199163; 2415,11.6760961192597; 2420,11.6767451515611; 2425,11.6783568143333; 2430,11.6791025243631; 2435,11.677674909555; 2440,11.6761162736961; 2445,11.674826906783; 2450,11.6735318035199; 2455,11.6721630726833; 2460,11.6701427246178; 2465,11.6677892535977; 2470,11.6653500183126; 2475,11.6633417808481; 2480,11.6612768868725; 2485,11.6591636996407; 2490,11.6570655203868; 2495,11.6549861025738; 2500,11.6528982898477; 2505,11.6508845486388; 2510,11.6495413570219; 2515,11.6477984825538; 2520,11.6463511121623; 2525,11.6450434274696; 2530,11.6439049273292; 2535,11.6433121736942; 2540,11.6432453978397; 2545,11.6428948408802; 2550,11.6420610691666; 2555,11.6409445007152; 2560,11.638799367813; 2565,11.6355708278925; 2570,11.6291802167784; 2575,11.6226355831965; 2580,11.6176376556204; 2585,11.6137983769697; 2590,11.6120512582213; 2595,11.6097379786098; 2600,11.6085236325571; 2605,11.607895726339; 2610,11.6067880713206; 2615,
        11.6050199314516; 2620,11.6033921639173; 2625,11.6024048554277; 2630,11.6024621473334; 2635,11.6020323194445; 2640,11.6007201718999; 2645,11.5990012442515; 2650,11.5967776034981; 2655,11.5938915469079; 2660,11.5909458922444; 2665,11.5869090785483; 2670,11.583126262385; 2675,11.5791476598467; 2680,11.5763563155936; 2685,11.5752710823304; 2690,11.5737850617565; 2695,11.5708066674449; 2700,11.5675383304336; 2705,11.5649804434565; 2710,11.5631053627254; 2715,11.5617822571322; 2720,11.5608608046865; 2725,11.5601031889529; 2730,11.5600856675568; 2735,11.5614961206559; 2740,11.5631523705466; 2745,11.565354831927; 2750,11.5677153599305; 2755,11.5682671493382; 2760,11.5683573232417; 2765,11.5693183212285; 2770,11.5708547695945; 2775,11.5719534516584; 2780,11.5709176323028; 2785,11.5687596532158; 2790,11.5663692734672; 2795,11.5639839045589; 2800,11.5612607137141; 2805,11.5585066340196; 2810,11.55683960231; 2815,11.5551338331299; 2820,11.5517816157984; 2825,11.5484907234277; 2830,
        11.5464361716923; 2835,11.5447891283037; 2840,11.5435886468647; 2845,11.5424319514552; 2850,11.5417488903676; 2855,11.5395951987424; 2860,11.5384464172236; 2865,11.5390985082088; 2870,11.5382733840266; 2875,11.5367740245923; 2880,11.5349948304502; 2885,11.532763333523; 2890,11.5319437811189; 2895,11.532155317578; 2900,11.5328360625521; 2905,11.5330902582819; 2910,11.5331245627207; 2915,11.5326822213527; 2920,11.5318986507538; 2925,11.5307156811999; 2930,11.529454193384; 2935,11.5294687694015; 2940,11.529483385833; 2945,11.5287055309983; 2950,11.5285698275297; 2955,11.5299457867047; 2960,11.5313305860968; 2965,11.5325798886674; 2970,11.535150833212; 2975,11.5378070940904; 2980,11.540290614904; 2985,11.543497760457; 2990,11.5469237128934; 2995,11.549114936638; 3000,11.5495929046961; 3005,11.5496996973676; 3010,11.5486193269974; 3015,11.5487104322832; 3020,11.5477495284683; 3025,11.5458498094138; 3030,11.5435763923023; 3035,11.5409894684563; 3040,11.5385008759601; 3045,
        11.5357220556701; 3050,11.5325695931276; 3055,11.528868667656; 3060,11.5248018943269; 3065,11.5206927687848; 3070,11.5169384584604; 3075,11.5136740853093; 3080,11.5105770066315; 3085,11.5071259719737; 3090,11.5035081026011; 3095,11.4994263650206; 3100,11.4941171905081; 3105,11.4888455616421; 3110,11.4833594849256; 3115,11.4781016007971; 3120,11.4730356385219; 3125,11.4677151975034; 3130,11.4629022030928; 3135,11.4586392232389; 3140,11.4561187742677; 3145,11.4538716094032; 3150,11.4527373128264; 3155,11.4510400312306; 3160,11.449278841011; 3165,11.4477352486347; 3170,11.4480147069714; 3175,11.4490666538042; 3180,11.4501169862613; 3185,11.4502821616147; 3190,11.4487692420537; 3195,11.4466987458706; 3200,11.4432854129183; 3205,11.4394028291054; 3210,11.4348385370918; 3215,11.4300612300306; 3220,11.4248990487325; 3225,11.4186630485191; 3230,11.4109451410858; 3235,11.4025937871165; 3240,11.393446996106; 3245,11.3836025220088; 3250,11.3743560850846; 3255,11.3655788848066; 3260,
        11.3567491360139; 3265,11.3493462294232; 3270,11.3432828882944; 3275,11.338658124395; 3280,11.3347980195729; 3285,11.3306677907383; 3290,11.3277349962108; 3295,11.325929122484; 3300,11.3253519880495; 3305,11.3254937840236; 3310,11.3265642027546; 3315,11.3289643383012; 3320,11.3325911241571; 3325,11.3374748720087; 3330,11.3430091732197; 3335,11.3482299014768; 3340,11.3536391947083; 3345,11.358995877257; 3350,11.3639793500217; 3355,11.3696063220717; 3360,11.3746816028428; 3365,11.3787926334082; 3370,11.3810706658673; 3375,11.382142271019; 3380,11.3841384999338; 3385,11.3862355695945; 3390,11.388981724356; 3395,11.3919095868746; 3400,11.3951876178733; 3405,11.3983424544756; 3410,11.4012912781017; 3415,11.404673564733; 3420,11.4081605621824; 3425,11.4123658299544; 3430,11.4167667601762; 3435,11.4215807803283; 3440,11.4261484968505; 3445,11.4306663627117; 3450,11.4350121715144; 3455,11.4414883060984; 3460,11.4467130487209; 3465,11.4496317497031; 3470,11.4543779585203; 3475,
        11.4599057410769; 3480,11.4655369009559; 3485,11.471532689703; 3490,11.4775072293042; 3495,11.484230289295; 3500,11.4904684786883; 3505,11.4950639622427; 3510,11.4964307206149; 3515,11.498345619815; 3520,11.5003847605012; 3525,11.5035319588582; 3530,11.5054503787249; 3535,11.5097891846732; 3540,11.512642984868; 3545,11.513471285615; 3550,11.5139769411989; 3555,11.5154340061508; 3560,11.5173618729702; 3565,11.5191715133163; 3570,11.518419745271; 3575,11.5185476572929; 3580,11.5194779782377; 3585,11.5189006886387; 3590,11.5161452018579; 3595,11.5126482434954; 3600,11.5095587700365; 3605,11.5059963289818; 3610,11.5014770015452; 3615,11.4969572379522; 3620,11.4922742545951; 3625,11.4876242581141; 3630,11.4830377114622; 3635,11.4786593942367; 3640,11.4740410207146; 3645,11.4694195594589; 3650,11.4645661649621; 3655,11.4598345729763; 3660,11.4559838973251; 3665,11.4533519813072; 3670,11.450947341855; 3675,11.4476417428143; 3680,11.4444908588013; 3685,11.4415621542171; 3690,
        11.4382699488497; 3695,11.4356040238583; 3700,11.4352218333411; 3705,11.434310713189; 3710,11.4329767301874; 3715,11.4351915054673; 3720,11.4396593402333; 3725,11.4446159970806; 3730,11.4488420213023; 3735,11.4533318240076; 3740,11.4566400574979; 3745,11.4601973042383; 3750,11.4640709881609; 3755,11.4684489533341; 3760,11.4729907332893; 3765,11.4782067942629; 3770,11.4833538687601; 3775,11.4888758910585; 3780,11.4944299245745; 3785,11.4995609738891; 3790,11.5039974533542; 3795,11.5076291942648; 3800,11.5105499122961; 3805,11.5130814615426; 3810,11.5155518059834; 3815,11.5180834069528; 3820,11.5202525283459; 3825,11.5218379571053; 3830,11.5225067088814; 3835,11.522825939414; 3840,11.5239684015971; 3845,11.5251930900982; 3850,11.5256543683635; 3855,11.5261055491526; 3860,11.5258580955639; 3865,11.5253424210716; 3870,11.5245384306448; 3875,11.5231927215016; 3880,11.5195380127658; 3885,11.5160031399655; 3890,11.5130452424794; 3895,11.5101183229494; 3900,11.5072335156521; 3905,
        11.5030172359168; 3910,11.4997876719994; 3915,11.4963373335404; 3920,11.4923149715649; 3925,11.4877285956302; 3930,11.482399743606; 3935,11.4767627768695; 3940,11.4705602869903; 3945,11.4632925984848; 3950,11.4552279682897; 3955,11.4465164494601; 3960,11.4375989146837; 3965,11.428398621571; 3970,11.4187076000757; 3975,11.4086390869884; 3980,11.398612738726; 3985,11.3886275468857; 3990,11.3795131910632; 3995,11.3710578624188; 4000,11.3634011616401; 4005,11.3565916457277; 4010,11.3511911510383; 4015,11.3447627250892; 4020,11.3368781481977; 4025,11.3297939936674; 4030,11.3262397062972; 4035,11.3215272732587; 4040,11.3149627666985; 4045,11.3118062406018; 4050,11.3090936266527; 4055,11.3058822281576; 4060,11.3027078830436; 4065,11.2992428866712; 4070,11.29534143189; 4075,11.2916057641138; 4080,11.2882773906993; 4085,11.2855160007059; 4090,11.2835664084907; 4095,11.2801797559866; 4100,11.2752764600184; 4105,11.2704465887759; 4110,11.2675409662355; 4115,11.2646570413985; 4120,
        11.2613204580835; 4125,11.2577585751889; 4130,11.2550639904019; 4135,11.2500714970333; 4140,11.2460791478343; 4145,11.243192237334; 4150,11.2403872024078; 4155,11.2366655300351; 4160,11.2322489674149; 4165,11.2278650291121; 4170,11.224089314845; 4175,11.220437050888; 4180,11.2163337357081; 4185,11.2120155574805; 4190,11.207731811365; 4195,11.2035402554716; 4200,11.2004697303357; 4205,11.198062805897; 4210,11.1968524711968; 4215,11.1962384345061; 4220,11.1966354379635; 4225,11.1979451982597; 4230,11.1996656187864; 4235,11.2010288376059; 4240,11.2021037067879; 4245,11.202993832161; 4250,11.2040538675895; 4255,11.2060141692824; 4260,11.2088521318236; 4265,11.2121766469297; 4270,11.2162378068497; 4275,11.220136926889; 4280,11.2231727707466; 4285,11.2255708910466; 4290,11.2281356101904; 4295,11.2312150600281; 4300,11.2347939115226; 4305,11.2411854906897; 4310,11.2499986641275; 4315,11.2567547222833; 4320,11.2631047908512; 4325,11.2714579431969; 4330,11.2811348432225; 4335,
        11.2919699929304; 4340,11.3032664186402; 4345,11.3153897170756; 4350,11.328367758229; 4355,11.3426414936581; 4360,11.3582733162168; 4365,11.3743852560665; 4370,11.3908539014705; 4375,11.406742918696; 4380,11.4225038628145; 4385,11.4383573007743; 4390,11.4545485968647; 4395,11.4701378311349; 4400,11.4853562887204; 4405,11.4998985892905; 4410,11.514943761392; 4415,11.5305134427099; 4420,11.5452403203438; 4425,11.5588107788935; 4430,11.5720397079046; 4435,11.5845130031451; 4440,11.5956444437335; 4445,11.6056905116742; 4450,11.6137618064024; 4455,11.6205095730816; 4460,11.6264816834595; 4465,11.6312815672121; 4470,11.6352804687198; 4475,11.6394564092624; 4480,11.6448352925842; 4485,11.6490044109932; 4490,11.6514413305089; 4495,11.6522138568815; 4500,11.65167966562; 4505,11.6527249531938; 4510,11.6529345520563; 4515,11.6536481232294; 4520,11.6546430237916; 4525,11.6549504513167; 4530,11.6543427018874; 4535,11.6534552775893; 4540,11.6519397293906; 4545,11.6496886214775; 4550,
        11.6473635490031; 4555,11.6448251510518; 4560,11.6420958026644; 4565,11.6390942329072; 4570,11.6365632882079; 4575,11.6334869553656; 4580,11.6309552803897; 4585,11.6303373920126; 4590,11.6286231320364; 4595,11.6263809263512; 4600,11.6229830246349; 4605,11.61880054954; 4610,11.6119111349554; 4615,11.6091559866814; 4620,11.6080478501294; 4625,11.6059836387055; 4630,11.6012642485689; 4635,11.5979431014788; 4640,11.5963025716171; 4645,11.5927296016339; 4650,11.5893612124068; 4655,11.5861035746391; 4660,11.5837193806719; 4665,11.5825198204639; 4670,11.5822014335363; 4675,11.5831596904141; 4680,11.5852907466043; 4685,11.5881106362341; 4690,11.5891696999041; 4695,11.5903443876465; 4700,11.5918357950771; 4705,11.5941509256894; 4710,11.5969436506848; 4715,11.600174058756; 4720,11.604166958524; 4725,11.6082128615682; 4730,11.6113164537714; 4735,11.6138113389777; 4740,11.6161470876021; 4745,11.6188620884925; 4750,11.6216997979883; 4755,11.6249653924569; 4760,11.6300075834871; 4765,
        11.6346620386455; 4770,11.6391263108519; 4775,11.6407802934798; 4780,11.6439256234275; 4785,11.6459586982023; 4790,11.6495978986564; 4795,11.6528893083933; 4800,11.6550772077559; 4805,11.6569148442296; 4810,11.6600028935711; 4815,11.6633904347557; 4820,11.6650770406034; 4825,11.6648104496931; 4830,11.6633082706732; 4835,11.6606274932453; 4840,11.6558409272664; 4845,11.6502670961599; 4850,11.64534347125; 4855,11.6400009676414; 4860,11.6342566086821; 4865,11.6274286509355; 4870,11.6197633910649; 4875,11.6124808845887; 4880,11.6043265688742; 4885,11.5969227270237; 4890,11.5900312831622; 4895,11.5837270180325; 4900,11.5779395722506; 4905,11.5725284612456; 4910,11.5673852281818; 4915,11.561862552364; 4920,11.556675217166; 4925,11.5519769137748; 4930,11.5488412121204; 4935,11.5462170541959; 4940,11.5450970580887; 4945,11.54352057868; 4950,11.5415925790395; 4955,11.5396224007397; 4960,11.5376555805153; 4965,11.5372206041983; 4970,11.536926180458; 4975,11.5364532790239; 4980,
        11.5358874696159; 4985,11.5350550435478; 4990,11.5340473957272; 4995,11.5332056016782; 5000,11.5319240600431; 5005,11.5312283791317; 5010,11.5296369594763; 5015,11.5270513547112; 5020,11.5243755553394; 5025,11.5227487414236; 5030,11.5206650460917; 5035,11.5178649232025; 5040,11.5146243447394; 5045,11.5112413678506; 5050,11.5076569827142; 5055,11.5038763084109; 5060,11.5001820938196; 5065,11.4968671930761; 5070,11.4932879749487; 5075,11.4886671539963; 5080,11.4834232923109; 5085,11.4763631498119; 5090,11.4698886492985; 5095,11.4650440775817; 5100,11.4619594579542; 5105,11.4592554634526; 5110,11.4567153474699; 5115,11.4539982391551; 5120,11.4510701750735; 5125,11.4478539614145; 5130,11.4450361566057; 5135,11.4424644258483; 5140,11.4410106750334; 5145,11.4410355403644; 5150,11.441714302716; 5155,11.4434722792133; 5160,11.4472342361158; 5165,11.4518454047932; 5170,11.4563263463817; 5175,11.4613827217018; 5180,11.4650162607793; 5185,11.467693569081; 5190,11.4695901986846; 5195,
        11.4706479554099; 5200,11.4710924124287; 5205,11.4717795795624; 5210,11.4727360472009; 5215,11.4711033776802; 5220,11.4689592904853; 5225,11.4670479854858; 5230,11.4649319491233; 5235,11.4634641112408; 5240,11.4618862897109; 5245,11.4592648922138; 5250,11.4560409088613; 5255,11.4533843670959; 5260,11.4512669830121; 5265,11.4489758216809; 5270,11.4467116016305; 5275,11.4442756899327; 5280,11.4416320976371; 5285,11.4390410465723; 5290,11.4360927588886; 5295,11.4337106489527; 5300,11.4314570974411; 5305,11.42858005435; 5310,11.4261914189543; 5315,11.4240044825176; 5320,11.422579628415; 5325,11.4214794145529; 5330,11.4202680111211; 5335,11.4192730891984; 5340,11.4182867096249; 5345,11.4171292723415; 5350,11.4166233932523; 5355,11.415846249; 5360,11.4132225509902; 5365,11.4106400183859; 5370,11.4080494468271; 5375,11.4074572068932; 5380,11.4054310413063; 5385,11.4049632833323; 5390,11.4031023410216; 5395,11.400937643759; 5400,11.3996597311922; 5405,11.3980849829722; 5410,
        11.3946441522297; 5415,11.3909664951866; 5420,11.3867254824563; 5425,11.3815061910648; 5430,11.3756696423543; 5435,11.369862950431; 5440,11.3645602422191; 5445,11.3597263697087; 5450,11.3562627040157; 5455,11.3529614398681; 5460,11.349185960797; 5465,11.3447534089112; 5470,11.3396037067865; 5475,11.3347274578834; 5480,11.3318195418778; 5485,11.3300386580119; 5490,11.3296140611883; 5495,11.3310562642631; 5500,11.3349778112187; 5505,11.3395767826722; 5510,11.3444394696581; 5515,11.3503375231931; 5520,11.3561617170019; 5525,11.361605806529; 5530,11.3668635363386; 5535,11.371690104169; 5540,11.374942394002; 5545,11.3801055692862; 5550,11.3854114637446; 5555,11.3909163219281; 5560,11.3961649299705; 5565,11.3996728155629; 5570,11.4047762502883; 5575,11.4086565831284; 5580,11.4094704938468; 5585,11.4085000481787; 5590,11.4082046947513; 5595,11.4091383721221; 5600,11.4114402697234; 5605,11.4144475836175; 5610,11.418697119263; 5615,11.424202124368; 5620,11.4287595571148; 5625,
        11.4325332553149; 5630,11.4357490448535; 5635,11.4384799721088; 5640,11.4412322799963; 5645,11.4434812665748; 5650,11.4460846105594; 5655,11.4490778422242; 5660,11.4510643949891; 5665,11.4516125421536; 5670,11.4508263961845; 5675,11.4487889517485; 5680,11.4455046757222; 5685,11.4431416191483; 5690,11.4404274086207; 5695,11.4370258842838; 5700,11.4327802642083; 5705,11.4283607865009; 5710,11.4230931345919; 5715,11.4168828122931; 5720,11.4099916603689; 5725,11.4044073582395; 5730,11.3997972193668; 5735,11.3956784439018; 5740,11.3921072095745; 5745,11.3891383184904; 5750,11.3866635109529; 5755,11.384534822064; 5760,11.3824153604604; 5765,11.3796634581533; 5770,11.3761031340779; 5775,11.3728977872341; 5780,11.3690261306961; 5785,11.3650079341047; 5790,11.3613598663931; 5795,11.3581302952137; 5800,11.354273389686; 5805,11.3498508055997; 5810,11.344694060165; 5815,11.3391329448674; 5820,11.3327596349844; 5825,11.3258400746891; 5830,11.3184778436073; 5835,11.3109949765794; 5840,
        11.3033481322047; 5845,11.2967835120352; 5850,11.2906452728969; 5855,11.2856097984667; 5860,11.2802933188673; 5865,11.2748925196441; 5870,11.2693709349282; 5875,11.2635699992093; 5880,11.2587516896378; 5885,11.2555884093908; 5890,11.2541601259936; 5895,11.2528856975679; 5900,11.251838571072; 5905,11.2526748175787; 5910,11.2533690598789; 5915,11.2564274614805; 5920,11.2597146092454; 5925,11.2642831752737; 5930,11.2670754120649; 5935,11.269797504768; 5940,11.2738607951721; 5945,11.2785341443241; 5950,11.2844716321296; 5955,11.2920123584129; 5960,11.2996259254888; 5965,11.3073119479431; 5970,11.3156439406076; 5975,11.3260007095301; 5980,11.33661050603; 5985,11.3476347980697; 5990,11.3571459175079; 5995,11.365724527602; 6000,11.3741438706175; 6005,11.3845264787587; 6010,11.3951238593358; 6015,11.4038880400081; 6020,11.4115799691839; 6025,11.4184126140307; 6030,11.4240424519088; 6035,11.4285131017764; 6040,11.4327411732425; 6045,11.4350875703335; 6050,11.4347180145525; 6055,
        11.4342794092078; 6060,11.4331681997583; 6065,11.4325840777378; 6070,11.4328636964369; 6075,11.4333275871104; 6080,11.434533823214; 6085,11.436225680193; 6090,11.43855589727; 6095,11.4401595042143; 6100,11.4399221416687; 6105,11.4388613670223; 6110,11.4366228415438; 6115,11.4343009848532; 6120,11.4323724349214; 6125,11.4312229058778; 6130,11.429716121593; 6135,11.4285090119661; 6140,11.4276384215242; 6145,11.4260073888315; 6150,11.4242068841575; 6155,11.4220083822315; 6160,11.4199332183786; 6165,11.4170672588162; 6170,11.4114334165528; 6175,11.4060109486852; 6180,11.4031977278286; 6185,11.4020493658796; 6190,11.401095626208; 6195,11.400430580226; 6200,11.3998296210637; 6205,11.3993490882697; 6210,11.3981796502107; 6215,11.396066284921; 6220,11.3942967094003; 6225,11.391428291435; 6230,11.3893455211816; 6235,11.3879547502022; 6240,11.3868485293786; 6245,11.3861019088479; 6250,11.3848773920008; 6255,11.3834869915478; 6260,11.3822881865932; 6265,11.3811868345113; 6270,
        11.3801454976799; 6275,11.3794534503541; 6280,11.3789742400505; 6285,11.3778619198401; 6290,11.376619407577; 6295,11.3759334345158; 6300,11.3755687492958; 6305,11.3770651455606; 6310,11.378083385; 6315,11.3787991734025; 6320,11.3791851291749; 6325,11.3792527617758; 6330,11.379263079201; 6335,11.379555405444; 6340,11.3800545920124; 6345,11.3819326253305; 6350,11.3822903113837; 6355,11.3815936304068; 6360,11.3794016969389; 6365,11.376507882366; 6370,11.3732539658252; 6375,11.3688855950595; 6380,11.3639606409599; 6385,11.3569875808475; 6390,11.348808978251; 6395,11.339975943148; 6400,11.3311221777101; 6405,11.3206058409332; 6410,11.3091748082578; 6415,11.2972544281076; 6420,11.2860192394786; 6425,11.2750315915914; 6430,11.2640504901486; 6435,11.2534695020761; 6440,11.2432711491093; 6445,11.2318786229061; 6450,11.2206415627882; 6455,11.2084233589685; 6460,11.1971364782185; 6465,11.1859185355321; 6470,11.175601685636; 6475,11.167556939871; 6480,11.1599013657075; 6485,
        11.1515351494817; 6490,11.1425560543296; 6495,11.1337291045588; 6500,11.1257145760361; 6505,11.1179519820854; 6510,11.112008161902; 6515,11.1051878091375; 6520,11.0985527784531; 6525,11.0907651225633; 6530,11.0867791108248; 6535,11.0843338186265; 6540,11.0831042286617; 6545,11.0832235509533; 6550,11.0832657301218; 6555,11.0839285022517; 6560,11.0857607679776; 6565,11.0892755096685; 6570,11.0942253589815; 6575,11.0982486609507; 6580,11.1028254528706; 6585,11.1060407564802; 6590,11.1114825689386; 6595,11.1185440722748; 6600,11.1266071870185; 6605,11.132662127441; 6610,11.1381096758676; 6615,11.143376263224; 6620,11.1484281650603; 6625,11.153141288692; 6630,11.157131649518; 6635,11.1607017927117; 6640,11.1641365773674; 6645,11.1679534458415; 6650,11.172552951475; 6655,11.1752744360117; 6660,11.1788354341063; 6665,11.183399578647; 6670,11.1868372664068; 6675,11.1902631849926; 6680,11.1934861790892; 6685,11.1962819567563; 6690,11.1984971229132; 6695,11.2003605385314; 6700,
        11.2032174038423; 6705,11.2062058491045; 6710,11.2112726400452; 6715,11.2169713024902; 6720,11.2229646520469; 6725,11.2285406043034; 6730,11.2345723320182; 6735,11.2422213477154; 6740,11.249448057308; 6745,11.2562702969503; 6750,11.2627461505551; 6755,11.2684949868606; 6760,11.2742980071247; 6765,11.2807938755525; 6770,11.2863797397175; 6775,11.2908599398406; 6780,11.2942651966026; 6785,11.2950094604659; 6790,11.2947519712739; 6795,11.2946686883136; 6800,11.2942291403984; 6805,11.2922082843736; 6810,11.2893784167262; 6815,11.2865165713246; 6820,11.2848564216217; 6825,11.2840044307805; 6830,11.2838284025513; 6835,11.2850308279734; 6840,11.2862001466069; 6845,11.2865799882809; 6850,11.2884141396996; 6855,11.2903418374316; 6860,11.292520405863; 6865,11.2946220646425; 6870,11.2962806010997; 6875,11.2977246119851; 6880,11.2997698525421; 6885,11.302703213207; 6890,11.3056533576936; 6895,11.3077860321465; 6900,11.3089830637128; 6905,11.3078178742762; 6910,11.3065355470852; 6915,
        11.3053189210357; 6920,11.304155874973; 6925,11.3030347282819; 6930,11.3016364303837; 6935,11.2995784022953; 6940,11.2965308013352; 6945,11.2916227999737; 6950,11.2889008111041; 6955,11.2860438724289; 6960,11.2828704276447; 6965,11.279140626865; 6970,11.274665133584; 6975,11.2694451956191; 6980,11.2638791664061; 6985,11.2591412792917; 6990,11.2537272760437; 6995,11.2480768150007; 7000,11.2424196283314; 7005,11.2378691631785; 7010,11.2337994663644; 7015,11.2299985664656; 7020,11.2262462110622; 7025,11.2231433658183; 7030,11.2203040676398; 7035,11.2172268395793; 7040,11.2149001828393; 7045,11.2138518547054; 7050,11.2136214224952; 7055,11.2145004659689; 7060,11.2157472513099; 7065,11.2182286027691; 7070,11.2210249248729; 7075,11.2224847456538; 7080,11.2242579015244; 7085,11.2275168821807; 7090,11.2310736081653; 7095,11.2346108830305; 7100,11.238763682582; 7105,11.24293643036; 7110,11.2460426283332; 7115,11.2485669029572; 7120,11.2511604728441; 7125,11.2537096089684; 7130,
        11.2565315293514; 7135,11.2592329361893; 7140,11.2618672452728; 7145,11.2651315092817; 7150,11.2681371823824; 7155,11.2709157257743; 7160,11.2729530760644; 7165,11.2744211566753; 7170,11.2759315787038; 7175,11.2779215528939; 7180,11.2798464207476; 7185,11.2819635764707; 7190,11.2843882513681; 7195,11.2871110640342; 7200,11.2889471166901; 7205,11.2894686086461; 7210,11.2889705976471; 7215,11.2882185512167; 7220,11.2872274416034; 7225,11.2857458314174; 7230,11.2827959012822; 7235,11.2806313281996; 7240,11.2788458018855; 7245,11.2770708735022; 7250,11.2749376276031; 7255,11.2735548412653; 7260,11.2713459019085; 7265,11.2682554543664; 7270,11.2659383929713; 7275,11.2637397905556; 7280,11.2615611453093; 7285,11.2602258794772; 7290,11.2598201318666; 7295,11.2603806849818; 7300,11.2615245743948; 7305,11.2655087523598; 7310,11.2667985196955; 7315,11.268393019028; 7320,11.2706344209365; 7325,11.2736320783572; 7330,11.2774260447013; 7335,11.2808739322604; 7340,11.2852051932921; 7345,
        11.2879792021589; 7350,11.2917897897598; 7355,11.2968028225898; 7360,11.3000986152925; 7365,11.3008261511696; 7370,11.3004360562833; 7375,11.3002559732062; 7380,11.2999571599795; 7385,11.3019408289578; 7390,11.3048203095543; 7395,11.3074534589712; 7400,11.3096979527287; 7405,11.3123379103863; 7410,11.3159144417344; 7415,11.31942351225; 7420,11.3232920894844; 7425,11.3278549537899; 7430,11.332615797852; 7435,11.3366356606022; 7440,11.3404236448703; 7445,11.3450534375885; 7450,11.3490284026565; 7455,11.3529108333638; 7460,11.3564279590316; 7465,11.358939448632; 7470,11.3606108139152; 7475,11.3627005064317; 7480,11.364702089055; 7485,11.3669301205102; 7490,11.3693290937914; 7495,11.3724264270031; 7500,11.3759066262851; 7505,11.3803819850277; 7510,11.3853373527654; 7515,11.3908581808314; 7520,11.3967484338082; 7525,11.4029352893176; 7530,11.4104233415046; 7535,11.4181827267353; 7540,11.4260072533335; 7545,11.4336895638618; 7550,11.4397550739346; 7555,11.4454375837772; 7560,
        11.450902155029; 7565,11.4554485850571; 7570,11.4591198056896; 7575,11.4627950009838; 7580,11.4667597265175; 7585,11.4702675704929; 7590,11.4733199116849; 7595,11.4749062874019; 7600,11.4750593412751; 7605,11.4736375328238; 7610,11.471920181655; 7615,11.4709252731977; 7620,11.4697140908047; 7625,11.4691592892782; 7630,11.4686281693784; 7635,11.4679218093112; 7640,11.4670857010502; 7645,11.46692869213; 7650,11.4665884067572; 7655,11.465080968198; 7660,11.4629424988254; 7665,11.4614879069983; 7670,11.4603182614768; 7675,11.4601109310249; 7680,11.4608119868433; 7685,11.4599459109127; 7690,11.4584250461839; 7695,11.4564645080798; 7700,11.4537711697811; 7705,11.4512092310225; 7710,11.4502555748524; 7715,11.4505726025453; 7720,11.450847053592; 7725,11.4514821806059; 7730,11.4507053713292; 7735,11.4504402649275; 7740,11.450650160257; 7745,11.4524043075832; 7750,11.4542549620787; 7755,11.4562572413895; 7760,11.4597616990588; 7765,11.4635589627217; 7770,11.4669888784736; 7775,
        11.4696137343568; 7780,11.4716077202115; 7785,11.4730954566137; 7790,11.4730481289922; 7795,11.4716507005472; 7800,11.4696009925453; 7805,11.4680134244158; 7810,11.4669842278061; 7815,11.4648271799929; 7820,11.4621250578064; 7825,11.4594966756966; 7830,11.4577885780837; 7835,11.4539832608274; 7840,11.4489834598299; 7845,11.4441136671306; 7850,11.4393975318757; 7855,11.4349635967166; 7860,11.4315612296623; 7865,11.428809443031; 7870,11.4263228216182; 7875,11.423948345188; 7880,11.4206327536838; 7885,11.416720229824; 7890,11.4128762736622; 7895,11.4078350414969; 7900,11.4021647564317; 7905,11.3956760520939; 7910,11.3921824282442; 7915,11.3888869936751; 7920,11.3856387463759; 7925,11.3825916294133; 7930,11.3791874099082; 7935,11.3747333519551; 7940,11.3698913616782; 7945,11.3657811702762; 7950,11.3606671324139; 7955,11.3547553463618; 7960,11.349324351958; 7965,11.3445776752231; 7970,11.3408926290281; 7975,11.3371407081843; 7980,11.3337802109019; 7985,11.3301433207977; 7990,
        11.3251298844374; 7995,11.3189930439831; 8000,11.3128723130628; 8005,11.3066009630076; 8010,11.2996735114277; 8015,11.2935853258419; 8020,11.2872350536678; 8025,11.2802687271292; 8030,11.2718896807876; 8035,11.263037024585; 8040,11.2543409230378; 8045,11.2463638443445; 8050,11.2382067022691; 8055,11.2293306543841; 8060,11.220578107875; 8065,11.2132426554088; 8070,11.2074505811921; 8075,11.2023019964659; 8080,11.1978878371898; 8085,11.1946696018063; 8090,11.1936001601861; 8095,11.1931052282813; 8100,11.1931738179829; 8105,11.1936253484421; 8110,11.1942937593843; 8115,11.1950271920232; 8120,11.1961021962237; 8125,11.1973622337774; 8130,11.1978886799861; 8135,11.1975683904902; 8140,11.19584648304; 8145,11.1969588613299; 8150,11.1997813043217; 8155,11.2029789033807; 8160,11.2058073187035; 8165,11.2092387063122; 8170,11.2122841044449; 8175,11.2142293238574; 8180,11.2141314480309; 8185,11.216053682582; 8190,11.2191747301443; 8195,11.222280747218; 8200,11.2259181908309; 8205,
        11.2307105428959; 8210,11.2365288650963; 8215,11.2417582689874; 8220,11.2458878626162; 8225,11.248084406485; 8230,11.2487815817773; 8235,11.2482167059325; 8240,11.2476440129356; 8245,11.2473930546028; 8250,11.2476191275603; 8255,11.2488797404608; 8260,11.250125797518; 8265,11.2507622160876; 8270,11.2527087292984; 8275,11.254634443898; 8280,11.2567346103454; 8285,11.2598443323166; 8290,11.2638626566884; 8295,11.2687657577857; 8300,11.2748482684723; 8305,11.2821730519217; 8310,11.2904141898392; 8315,11.29873582172; 8320,11.3077320607861; 8325,11.3169902131723; 8330,11.3275973365652; 8335,11.3387552407623; 8340,11.349665469215; 8345,11.3593270013829; 8350,11.3684309835899; 8355,11.3770629837824; 8360,11.3847825315822; 8365,11.3916103326766; 8370,11.3979155432236; 8375,11.4033905663638; 8380,11.4082263172113; 8385,11.4122580555615; 8390,11.4152372947289; 8395,11.4167966226068; 8400,11.4180325365221; 8405,11.4179418599527; 8410,11.4147472599684; 8415,11.4118927361339; 8420,
        11.4085694035371; 8425,11.4038973236961; 8430,11.3977750016922; 8435,11.391588851875; 8440,11.3845581354639; 8445,11.3754570161046; 8450,11.366066746265; 8455,11.3546930687953; 8460,11.3416168929182; 8465,11.3272238574435; 8470,11.3111713554965; 8475,11.2937155668802; 8480,11.2760634380353; 8485,11.2582849080604; 8490,11.2392849845553; 8495,11.2208086425551; 8500,11.2022274274676; 8505,11.1825068164261; 8510,11.1622722636747; 8515,11.1419821500845; 8520,11.1210595404208; 8525,11.099574506939; 8530,11.0776102931881; 8535,11.0545269282301; 8540,11.0311151021144; 8545,11.0078572949136; 8550,10.9844146967942; 8555,10.9614512923586; 8560,10.9385894036649; 8565,10.9161682198381; 8570,10.8939402295566; 8575,10.8707230250904; 8580,10.8467236957672; 8585,10.8223776783557; 8590,10.7977363951904; 8595,10.7728219031959; 8600,10.7482710817511; 8605,10.7248512008137; 8610,10.7017164993805; 8615,10.6783237873068; 8620,10.6550744200532; 8625,10.6326377702787; 8630,10.6108887985894; 8635,
        10.5888409144898; 8640,10.5675038293278; 8645,10.5459694401633; 8650,10.5255693068894; 8655,10.5060048446834; 8660,10.4879695142891; 8665,10.4705881367012; 8670,10.4545315163643; 8675,10.4382353957117; 8680,10.4234806712331; 8685,10.4092422860302; 8690,10.3937411530091; 8695,10.3787955332306; 8700,10.3642559768528; 8705,10.3524078410251; 8710,10.3424716011413; 8715,10.3334105606935; 8720,10.3256720907843; 8725,10.3185480197334; 8730,10.3122674381985; 8735,10.308814156092; 8740,10.3084348582973; 8745,10.3063092611485; 8750,10.3036084828863; 8755,10.3023413277802; 8760,10.3017420301556; 8765,10.3015749674453; 8770,10.3028463407128; 8775,10.3053272290009; 8780,10.3091236306255; 8785,10.3104843760557; 8790,10.3114427665136; 8795,10.3125339337288; 8800,10.3133449659436; 8805,10.3132801341855; 8810,10.3112213179312; 8815,10.307940604694; 8820,10.3049785004903; 8825,10.3022800682772; 8830,10.2987966264665; 8835,10.2963839927924; 8840,10.2935290923582; 8845,10.29021105912; 8850,
        10.2863578760706; 8855,10.283204619033; 8860,10.2803381687641; 8865,10.2779464977335; 8870,10.2751741788663; 8875,10.2720294288078; 8880,10.268697394653; 8885,10.2647530004102; 8890,10.2615530540178; 8895,10.2597387458069; 8900,10.2579535655266; 8905,10.2554822416562; 8910,10.2518590435081; 8915,10.2474013896917; 8920,10.2425513491357; 8925,10.2378636790598; 8930,10.2344633756989; 8935,10.2309952351063; 8940,10.2267450437379; 8945,10.2215357755622; 8950,10.2159335410381; 8955,10.2094083269647; 8960,10.2023529980531; 8965,10.1955622114648; 8970,10.1885142683994; 8975,10.1810761923811; 8980,10.1727513037141; 8985,10.1636514721208; 8990,10.1545966826944; 8995,10.1456012681142; 9000,10.1352956691232; 9005,10.1249618199556; 9010,10.1153698583889; 9015,10.1048703804384; 9020,10.0934857559675; 9025,10.0818853102225; 9030,10.0706319674551; 9035,10.0594235519899; 9040,10.0490147100604; 9045,10.0391625709911; 9050,10.0293283259829; 9055,10.0214101550578; 9060,10.0140134509393; 9065,
        10.0072217663677; 9070,10.0012155610059; 9075,9.99617476292929; 9080,9.9927186342484; 9085,9.99086360457917; 9090,9.98991681155072; 9095,9.99036830282785; 9100,9.99270006666025; 9105,9.99548534905515; 9110,9.99827362972722; 9115,10.0012638130029; 9120,10.0056333607002; 9125,10.011138099324; 9130,10.0180784671744; 9135,10.0261264507219; 9140,10.035727420886; 9145,10.0473141614522; 9150,10.060366159332; 9155,10.0735678707328; 9160,10.0871424349935; 9165,10.1009572951807; 9170,10.1154684451798; 9175,10.1302260314374; 9180,10.1459985646535; 9185,10.1634540582048; 9190,10.1818598028038; 9195,10.2011345758259; 9200,10.2206391131676; 9205,10.2399089656192; 9210,10.2594488124469; 9215,10.278726596852; 9220,10.2973775508875; 9225,10.3153488580082; 9230,10.333838078522; 9235,10.353333637727; 9240,10.3727442216387; 9245,10.3924368439544; 9250,10.4127439188966; 9255,10.4328316344823; 9260,10.4517154468132; 9265,10.4711047395498; 9270,10.4906704046324; 9275,10.511472941092; 9280,
        10.532038197773; 9285,10.553257719702; 9290,10.5761374150445; 9295,10.6004466633387; 9300,10.6261008386328; 9305,10.6509600406613; 9310,10.6754439219173; 9315,10.7002361048195; 9320,10.7242702186687; 9325,10.7482706983228; 9330,10.7723504902704; 9335,10.7964034815987; 9340,10.8204754786745; 9345,10.8450941207082; 9350,10.8710762170215; 9355,10.8957435283601; 9360,10.9197084944324; 9365,10.9428414424134; 9370,10.965303770735; 9375,10.9870521470371; 9380,11.0084980751748; 9385,11.0295586063873; 9390,11.0499845496181; 9395,11.0701983676866; 9400,11.0896996969603; 9405,11.1084901929646; 9410,11.1264837969802; 9415,11.1427200436718; 9420,11.1579002758336; 9425,11.1720431770845; 9430,11.1861450395822; 9435,11.2008678908249; 9440,11.2157614276407; 9445,11.229662318407; 9450,11.242012181532; 9455,11.2540616539531; 9460,11.265706375746; 9465,11.2769661128591; 9470,11.2880135995744; 9475,11.2989504351321; 9480,11.309176598279; 9485,11.3201681484204; 9490,11.3303272488987; 9495,
        11.3398959529993; 9500,11.3495888880802; 9505,11.3580038730563; 9510,11.3653314747595; 9515,11.3716731473769; 9520,11.3764646434686; 9525,11.3801302802922; 9530,11.3810588654101; 9535,11.3785452346209; 9540,11.3754334085332; 9545,11.3719016063136; 9550,11.3680337042499; 9555,11.3642896848786; 9560,11.3601471762964; 9565,11.3549548092528; 9570,11.3488425021075; 9575,11.342293352449; 9580,11.3356318101116; 9585,11.328941301543; 9590,11.3213781774766; 9595,11.3142167620184; 9600,11.307517204777; 9605,11.3019012285712; 9610,11.2974149392334; 9615,11.2928708838629; 9620,11.2885607474832; 9625,11.284356994873; 9630,11.2797887083934; 9635,11.2753866469563; 9640,11.2709554788829; 9645,11.2674450903935; 9650,11.2648987553527; 9655,11.2626494060681; 9660,11.2613157010768; 9665,11.2609247295252; 9670,11.2617515542967; 9675,11.2638182309863; 9680,11.266002690488; 9685,11.2681219067948; 9690,11.2720276707853; 9695,11.2761670069621; 9700,11.2805114615388; 9705,11.2859844883654; 9710,
        11.2932353239364; 9715,11.3015889105809; 9720,11.3105979443192; 9725,11.3197625032824; 9730,11.3293358616045; 9735,11.3388136239102; 9740,11.3483304511841; 9745,11.3573667728697; 9750,11.3661278313119; 9755,11.3755511207983; 9760,11.3854641082282; 9765,11.3956567561372; 9770,11.4060572738996; 9775,11.4171746457503; 9780,11.4282253415942; 9785,11.4385010889879; 9790,11.4481100632003; 9795,11.4574950845435; 9800,11.4666469297152; 9805,11.4756274655446; 9810,11.4846130510681; 9815,11.494420825444; 9820,11.5049652955775; 9825,11.5162017178963; 9830,11.5264992979357; 9835,11.5365358434959; 9840,11.5465481643062; 9845,11.5561103398077; 9850,11.5645104333422; 9855,11.5725869821921; 9860,11.5805829870541; 9865,11.5884519790768; 9870,11.5958423002506; 9875,11.603019762369; 9880,11.6099416231175; 9885,11.6165233379169; 9890,11.6223302529063; 9895,11.6277138952828; 9900,11.6332243562804; 9905,11.6390430561491; 9910,11.6451960260617; 9915,11.6515272442608; 9920,11.6585964263403; 9925,
        11.6658874158439; 9930,11.6733733790292; 9935,11.6807860285971; 9940,11.6879559713461; 9945,11.6945087513894; 9950,11.699970016384; 9955,11.705179601109; 9960,11.7098107779391; 9965,11.712843814978; 9970,11.7156527446812; 9975,11.7180558868361; 9980,11.7179648291257; 9985,11.717161011902; 9990,11.7161934991125; 9995,11.7141093365626; 10000,11.7119323155399; 10005,11.7104958966268; 10010,11.7090312547842; 10015,11.7094684338844; 10020,11.7101119972115; 10025,11.7123181831062; 10030,11.7150084179188; 10035,11.7174483849971; 10040,11.7192817716215; 10045,11.7213164639906; 10050,11.7245121639202; 10055,11.7267975755587; 10060,11.7286247796462; 10065,11.7297879101389; 10070,11.7300672311099; 10075,11.729432390178; 10080,11.7277289490639; 10085,11.7235435847957; 10090,11.7181597592008; 10095,11.7103176966722; 10100,11.6997764592262; 10105,11.6876615521452; 10110,11.6738572632942; 10115,11.658761770467; 10120,11.6422588128746; 10125,11.6235482707721; 10130,11.6042227049838; 10135,
        11.5850214391353; 10140,11.5648047525435; 10145,11.5438122529888; 10150,11.5220214986007; 10155,11.4993941120796; 10160,11.4758731634742; 10165,11.4512653412097; 10170,11.425538886087; 10175,11.3988444812107; 10180,11.3711999389499; 10185,11.3438322577741; 10190,11.3162344844661; 10195,11.2878042619731; 10200,11.2589221574637; 10205,11.2292172176151; 10210,11.198120869745; 10215,11.1664293459575; 10220,11.1346365519501; 10225,11.1030839861611; 10230,11.0720208301184; 10235,11.0414869645481; 10240,11.0109713937562; 10245,10.9805424647324; 10250,10.9505904826403; 10255,10.9212035197359; 10260,10.8921902778511; 10265,10.8635511698169; 10270,10.8354574716889; 10275,10.8079233733346; 10280,10.7800428667464; 10285,10.7522434972744; 10290,10.7262078770161; 10295,10.7014389279962; 10300,10.6767305006154; 10305,10.6523677019091; 10310,10.6266468393203; 10315,10.6039874457888; 10320,10.5833770239991; 10325,10.5629326793711; 10330,10.540413668242; 10335,10.5215749816741; 10340,
        10.5052465562637; 10345,10.4895346805703; 10350,10.4746278849931; 10355,10.4604930897519; 10360,10.4470924896019; 10365,10.4340792054307; 10370,10.4215800350406; 10375,10.4098422664999; 10380,10.3984876658325; 10385,10.388441394707; 10390,10.3803924817008; 10395,10.3724397229048; 10400,10.3657807788163; 10405,10.3600418071673; 10410,10.354014517483; 10415,10.3480502328383; 10420,10.3423723534903; 10425,10.3366399790647; 10430,10.3312761729376; 10435,10.3259655428355; 10440,10.3214659647776; 10445,10.3178250015513; 10450,10.3137342468653; 10455,10.3096245247728; 10460,10.3052424073143; 10465,10.2996188699268; 10470,10.2946763504415; 10475,10.2897291733114; 10480,10.2848422656614; 10485,10.280752095536; 10490,10.2770565774301; 10495,10.2733157514672; 10500,10.2694143791775; 10505,10.2647604124109; 10510,10.2593368507246; 10515,10.2531735348926; 10520,10.2457752141734; 10525,10.2379792770429; 10530,10.2295374084633; 10535,10.2201469283343; 10540,10.2114033390544; 10545,
        10.2013671691883; 10550,10.190129740255; 10555,10.1787342787637; 10560,10.1661044524794; 10565,10.1531042649645; 10570,10.1386602493677; 10575,10.1234745413774; 10580,10.1097932566869; 10585,10.0975441416781; 10590,10.0854802962452; 10595,10.075566778225; 10600,10.0667893293406; 10605,10.0588363041336; 10610,10.0525761700011; 10615,10.0486383121591; 10620,10.0458466095113; 10625,10.0437686506873; 10630,10.0425159154636; 10635,10.0427762115533; 10640,10.0443237530982; 10645,10.0467197540847; 10650,10.0499812585551; 10655,10.0544356438297; 10660,10.0600641470911; 10665,10.0665998521948; 10670,10.0744049030212; 10675,10.0835060072566; 10680,10.0942021777433; 10685,10.106786252964; 10690,10.1210612487772; 10695,10.1367298774014; 10700,10.1538389454885; 10705,10.1724829344459; 10710,10.1924636390682; 10715,10.213716704302; 10720,10.2361831260045; 10725,10.2605229304133; 10730,10.2866717436116; 10735,10.3134484254994; 10740,10.3414031378365; 10745,10.369197246001; 10750,
        10.3972029231312; 10755,10.4251511430114; 10760,10.4531083013546; 10765,10.4803063060075; 10770,10.507009035176; 10775,10.5342551111959; 10780,10.5619899787779; 10785,10.5898339449424; 10790,10.6185574792188; 10795,10.647950456406; 10800,10.6776591760621; 10805,10.7073560480867; 10810,10.7381711018172; 10815,10.7698146266928; 10820,10.8021829870211; 10825,10.8354568758764; 10830,10.8676434538228; 10835,10.8980805395811; 10840,10.9272795247106; 10845,10.9552149797806; 10850,10.981451722402; 10855,11.0059045937506; 10860,11.0286223961239; 10865,11.0495583573124; 10870,11.0683933144138; 10875,11.0850574054117; 10880,11.1015360054838; 10885,11.117517332599; 10890,11.1313411139918; 10895,11.1416062491398; 10900,11.1505809426038; 10905,11.1619614583896; 10910,11.1752662180514; 10915,11.1859044187508; 10920,11.1943418898348; 10925,11.2037960825171; 10930,11.2167010072887; 10935,11.22765939717; 10940,11.2367405733546; 10945,11.2448031199847; 10950,11.2518022572441; 10955,
        11.2578530327068; 10960,11.2624768442138; 10965,11.2660701846014; 10970,11.270321060759; 10975,11.2741419240548; 10980,11.2774711218827; 10985,11.2796369237593; 10990,11.2805611761923; 10995,11.2817714848727; 11000,11.2821887720054; 11005,11.2825261974739; 11010,11.2836094738992; 11015,11.2842675235582; 11020,11.2842034208664; 11025,11.2846692975767; 11030,11.2859443005837; 11035,11.2874682208085; 11040,11.288599151948; 11045,11.2890996772778; 11050,11.2888367647895; 11055,11.2883165196256; 11060,11.288998222817; 11065,11.2908371539154; 11070,11.2920304919435; 11075,11.293702227522; 11080,11.2957284796515; 11085,11.2975825561114; 11090,11.3001317414524; 11095,11.3036925064955; 11100,11.3079783705028; 11105,11.3138085673214; 11110,11.3204064512094; 11115,11.32641410752; 11120,11.3321021475627; 11125,11.3386614800755; 11130,11.3453410184556; 11135,11.352045063403; 11140,11.3573056140422; 11145,11.3626540459642; 11150,11.367887591409; 11155,11.371874220977; 11160,11.3748769129042;
        11165,11.3772661511645; 11170,11.3793666737442; 11175,11.3811873833071; 11180,11.3827389540472; 11185,11.3840358842168; 11190,11.3850599101406; 11195,11.3860277906378; 11200,11.3870144469905; 11205,11.3876661100819; 11210,11.3877157866905; 11215,11.3864980968391; 11220,11.384510029484; 11225,11.3818828888369; 11230,11.3786784517595; 11235,11.3744208135303; 11240,11.3691511808284; 11245,11.3627554079327; 11250,11.3546150050777; 11255,11.346307472491; 11260,11.3380658980258; 11265,11.3294286311926; 11270,11.3203179357444; 11275,11.3111124178502; 11280,11.3026096155981; 11285,11.2943957090898; 11290,11.2862404509944; 11295,11.2787100043339; 11300,11.2721628328819; 11305,11.2667507440575; 11310,11.262260327977; 11315,11.2586426786955; 11320,11.2547356894705; 11325,11.2499074110714; 11330,11.2441971106025; 11335,11.2381453520786; 11340,11.2309886551659; 11345,11.2240123220458; 11350,11.2161210814376; 11355,11.2077532458833; 11360,11.2002978632928; 11365,11.1945722880627; 11370,
        11.186836376493; 11375,11.1797048760726; 11380,11.1731102425434; 11385,11.1661426196755; 11390,11.1596576366968; 11395,11.1541138893731; 11400,11.1494809145995; 11405,11.1459198970996; 11410,11.1420087685031; 11415,11.1386001155202; 11420,11.1347479488607; 11425,11.1293285633694; 11430,11.1233269646778; 11435,11.1170252426185; 11440,11.1108802297652; 11445,11.1046972504762; 11450,11.098988301707; 11455,11.0924012877914; 11460,11.0854028826702; 11465,11.0782116068102; 11470,11.0708904677781; 11475,11.0635707782629; 11480,11.0561545164622; 11485,11.0486308040322; 11490,11.0409760935647; 11495,11.0367504605696; 11500,11.0334791694687; 11505,11.0295274330659; 11510,11.0264631842322; 11515,11.0243190151882; 11520,11.0241268336481; 11525,11.0229143162069; 11530,11.0202327206556; 11535,11.0180481563751; 11540,11.0176096392693; 11545,11.0185764073998; 11550,11.0201466545546; 11555,11.0215960364646; 11560,11.0238111612409; 11565,11.0273879105937; 11570,11.0297504921488; 11575,
        11.0320451508391; 11580,11.0338831379392; 11585,11.0351461795078; 11590,11.0359435967653; 11595,11.0363736137662; 11600,11.0369930876749; 11605,11.0368482218149; 11610,11.0358827341814; 11615,11.034683153853; 11620,11.0329825625283; 11625,11.0300521335231; 11630,11.0275315336022; 11635,11.0244660754997; 11640,11.0199512241774; 11645,11.0148211885849; 11650,11.0100895611334; 11655,11.0063759934522; 11660,11.004086758111; 11665,11.0031205660438; 11670,11.0028255709421; 11675,11.0021482841983; 11680,11.0025958585021; 11685,11.0046830334091; 11690,11.0072261239357; 11695,11.01037050508; 11700,11.01418894641; 11705,11.0171324484649; 11710,11.0194935721544; 11715,11.0239184228455; 11720,11.0292508494733; 11725,11.0335160303921; 11730,11.0374237313174; 11735,11.0410736780646; 11740,11.0442926566066; 11745,11.0473405907123; 11750,11.0497986311906; 11755,11.0518685120694; 11760,11.0542837422462; 11765,11.0569413784962; 11770,11.0593005573161; 11775,11.0599540510321; 11780,
        11.060813978938; 11785,11.0620055885313; 11790,11.0623010024307; 11795,11.0624368788136; 11800,11.062808665426; 11805,11.0628991842178; 11810,11.06390391805; 11815,11.0649726001795; 11820,11.0662623929869; 11825,11.067414526477; 11830,11.0681978166814; 11835,11.0694328237235; 11840,11.0711690336235; 11845,11.073053353819; 11850,11.075666275581; 11855,11.076634420368; 11860,11.0783353090837; 11865,11.0824874870409; 11870,11.0862674943496; 11875,11.0887682568265; 11880,11.0919002553826; 11885,11.0962513732049; 11890,11.1012080881903; 11895,11.1065987726634; 11900,11.1126907765538; 11905,11.1184705815711; 11910,11.1236927056754; 11915,11.128465160241; 11920,11.1338862965215; 11925,11.1398414231287; 11930,11.1466313223964; 11935,11.1528499516168; 11940,11.1582184262383; 11945,11.1634132687093; 11950,11.1680789658806; 11955,11.1723815400519; 11960,11.1739317575243; 11965,11.1741602638544; 11970,11.1762783246219; 11975,11.1774867327306; 11980,11.1776642133512; 11985,11.1782887881296;
        11990,11.1798484678717; 11995,11.1817911231178; 12000,11.183223684225; 12005,11.1845333753293; 12010,11.1850470509708; 12015,11.1848709725576; 12020,11.1841244385159; 12025,11.1827944731295; 12030,11.1804526363784; 12035,11.177653933255; 12040,11.1748481727739; 12045,11.1719453600221; 12050,11.1685432450843; 12055,11.1655876878693; 12060,11.1628375918065; 12065,11.1603251707659; 12070,11.1576301186515; 12075,11.1553972482687; 12080,11.1533996845947; 12085,11.1515549194055; 12090,11.1502918650297; 12095,11.149895687317; 12100,11.1520468067946; 12105,11.1548094206595; 12110,11.1576807157096; 12115,11.1607267409386; 12120,11.1639186050151; 12125,11.1689386188089; 12130,11.1755089913695; 12135,11.1832392121079; 12140,11.1898350586839; 12145,11.1959754599036; 12150,11.2022527261325; 12155,11.2084242074155; 12160,11.2150461068253; 12165,11.2196923401389; 12170,11.2238387340403; 12175,11.2288480829613; 12180,11.2348836228218; 12185,11.2420016489153; 12190,11.2499515362083; 12195,
        11.2580168353917; 12200,11.2657007531559; 12205,11.2737017808447; 12210,11.2821655491255; 12215,11.2910887513966; 12220,11.3010262893539; 12225,11.3124213381859; 12230,11.3230421092102; 12235,11.3340637852518; 12240,11.345878446299; 12245,11.358522060249; 12250,11.3727182070131; 12255,11.3870154118688; 12260,11.4008253441463; 12265,11.4142139919498; 12270,11.4276477396836; 12275,11.4422732499822; 12280,11.457182939765; 12285,11.4715860186764; 12290,11.485379909651; 12295,11.49794912339; 12300,11.5089540863671; 12305,11.5187574163015; 12310,11.5289155864707; 12315,11.5370802078103; 12320,11.5443411020526; 12325,11.5507023128671; 12330,11.5559162928403; 12335,11.5598876631561; 12340,11.5621800368673; 12345,11.5642525235466; 12350,11.5658178893189; 12355,11.5647693315834; 12360,11.5626698443918; 12365,11.559150165185; 12370,11.5548623852037; 12375,11.5521923397905; 12380,11.5482307720693; 12385,11.5433321035877; 12390,11.5393120196947; 12395,11.5355941152291; 12400,
        11.5318311311145; 12405,11.5284368351606; 12410,11.5241354363947; 12415,11.5201140590686; 12420,11.5153943748927; 12425,11.5092703657965; 12430,11.5024614209614; 12435,11.4943258616205; 12440,11.4845029730193; 12445,11.4735994797782; 12450,11.461791664637; 12455,11.450948556299; 12460,11.4373899869621; 12465,11.4212305306382; 12470,11.4056875221875; 12475,11.3921710552482; 12480,11.3787776688262; 12485,11.3664496727394; 12490,11.3548528274471; 12495,11.3437877311811; 12500,11.3329191629596; 12505,11.3230691820965; 12510,11.3127642076288; 12515,11.3024178446639; 12520,11.292368297522; 12525,11.2820332666905; 12530,11.271862270498; 12535,11.2617087582672; 12540,11.2515042621572; 12545,11.2410541026994; 12550,11.2303709341205; 12555,11.2191261822773; 12560,11.207902293411; 12565,11.1973253905673; 12570,11.1864461922573; 12575,11.1764831037654; 12580,11.1679887943221; 12585,11.1608278174927; 12590,11.1524365763292; 12595,11.142869961617; 12600,11.1340962203695; 12605,
        11.1260708916886; 12610,11.1198156392665; 12615,11.1157143386519; 12620,11.1129094249719; 12625,11.1113178733195; 12630,11.1124254082431; 12635,11.1156149207216; 12640,11.1202569693964; 12645,11.1264139307276; 12650,11.1346056809941; 12655,11.1439398111285; 12660,11.1539485292046; 12665,11.1647419898014; 12670,11.1774918633844; 12675,11.1910976090188; 12680,11.2051881323665; 12685,11.2186566312048; 12690,11.2316249153552; 12695,11.2449480459041; 12700,11.2577539571366; 12705,11.2709077341827; 12710,11.2843915529135; 12715,11.2980116851343; 12720,11.3119525849553; 12725,11.326089578942; 12730,11.3399213992674; 12735,11.3537909594678; 12740,11.3677017712735; 12745,11.3807512450719; 12750,11.393167288792; 12755,11.4060086441296; 12760,11.417689870952; 12765,11.4307069288701; 12770,11.4439000955441; 12775,11.4560927767096; 12780,11.4672839721341; 12785,11.4770066461695; 12790,11.4854187027388; 12795,11.4922698967403; 12800,11.49827799603; 12805,11.5041085254296; 12810,
        11.5091568935593; 12815,11.5138604029069; 12820,11.5184253814909; 12825,11.522194053188; 12830,11.5253271660413; 12835,11.5274463809734; 12840,11.5299499204643; 12845,11.5325797321317; 12850,11.533925060295; 12855,11.5352733469254; 12860,11.5364739538667; 12865,11.5377267953674; 12870,11.5390506353818; 12875,11.5404297066242; 12880,11.5410094344639; 12885,11.5397933793718; 12890,11.5386683601781; 12895,11.5386087614648; 12900,11.5394107411615; 12905,11.5400613808625; 12910,11.5400569991318; 12915,11.5402137992171; 12920,11.5397888226872; 12925,11.5381360714988; 12930,11.5355356575137; 12935,11.5322630674272; 12940,11.5279918685699; 12945,11.5216717896737; 12950,11.5144659666948; 12955,11.5079694924172; 12960,11.5013261060831; 12965,11.4946252772986; 12970,11.487844649928; 12975,11.4796122664012; 12980,11.4719976458976; 12985,11.4641998412539; 12990,11.4564138019539; 12995,11.4461668276717; 13000,11.4350630181506; 13005,11.4246107658277; 13010,11.4142779603041; 13015,
        11.4045872243312; 13020,11.395438655118; 13025,11.3865517818231; 13030,11.3772314198157; 13035,11.3664993804304; 13040,11.3552802749971; 13045,11.3435892257447; 13050,11.3321360852118; 13055,11.3206553358848; 13060,11.3101214741327; 13065,11.3002350757206; 13070,11.2907346216386; 13075,11.2812340681872; 13080,11.2715451985349; 13085,11.2616036261578; 13090,11.2513086159739; 13095,11.2407902189505; 13100,11.2290152014043; 13105,11.2152044697998; 13110,11.2032583546715; 13115,11.1915336032222; 13120,11.1796522323462; 13125,11.1665646057608; 13130,11.1505718262629; 13135,11.1342016830457; 13140,11.1180579813227; 13145,11.1018140628304; 13150,11.085407730651; 13155,11.0682345017994; 13160,11.05091698832; 13165,11.0334404458485; 13170,11.0157183766555; 13175,10.9982354554154; 13180,10.9804833549291; 13185,10.9623174144345; 13190,10.9452088407603; 13195,10.9295986707035; 13200,10.9153095814184; 13205,10.9031309624859; 13210,10.8917222016323; 13215,10.8800275419515; 13220,
        10.8693111522939; 13225,10.8596577491694; 13230,10.8498899645599; 13235,10.8425435922957; 13240,10.8364919166146; 13245,10.8306445811626; 13250,10.8257882207902; 13255,10.8223666767722; 13260,10.820012537766; 13265,10.8182714299419; 13270,10.8164596678928; 13275,10.8154232730803; 13280,10.8152830792019; 13285,10.8182180638797; 13290,10.8241985451433; 13295,10.8305677329397; 13300,10.8375349881751; 13305,10.8458132421611; 13310,10.8560165108888; 13315,10.8670875802643; 13320,10.8785958608365; 13325,10.8902833167258; 13330,10.902061723737; 13335,10.9134144216382; 13340,10.9254531613495; 13345,10.9387258083936; 13350,10.9510345663402; 13355,10.9619164622426; 13360,10.9718255159988; 13365,10.9811244949509; 13370,10.9898754122426; 13375,10.9979854293459; 13380,11.0052292281014; 13385,11.0121651712439; 13390,11.0189935202375; 13395,11.0268204749681; 13400,11.035128822624; 13405,11.0437493810951; 13410,11.0524168061398; 13415,11.060729193578; 13420,11.0672664312143; 13425,
        11.0720078145197; 13430,11.0767694008812; 13435,11.082337897708; 13440,11.0869263529668; 13445,11.0903095971522; 13450,11.0937111079191; 13455,11.0973109584684; 13460,11.1008527081579; 13465,11.1041806182351; 13470,11.1074810056841; 13475,11.1109359352868; 13480,11.1140464959054; 13485,11.1181939449623; 13490,11.1223960639265; 13495,11.1253869150946; 13500,11.1285928297747; 13505,11.1319484385257; 13510,11.134504123828; 13515,11.1353915099307; 13520,11.135206756433; 13525,11.1340439896608; 13530,11.1318813033605; 13535,11.1291879709726; 13540,11.1271655799505; 13545,11.1253958698109; 13550,11.1231739236833; 13555,11.1206488270496; 13560,11.1180070240184; 13565,11.1143642730656; 13570,11.1103858740185; 13575,11.1075525863917; 13580,11.1046229568827; 13585,11.1008676128688; 13590,11.0968305903928; 13595,11.0942276170883; 13600,11.0920422718184; 13605,11.0894062802426; 13610,11.0872019622793; 13615,11.0828804343724; 13620,11.0780197710421; 13625,11.072976272003; 13630,
        11.0686812825565; 13635,11.0646152840544; 13640,11.0613446563545; 13645,11.0587877186608; 13650,11.0565108800067; 13655,11.0548762231843; 13660,11.0536380323508; 13665,11.0532706410764; 13670,11.0530137754694; 13675,11.0548238901357; 13680,11.057830184978; 13685,11.0606429734173; 13690,11.0651887665915; 13695,11.0713508868519; 13700,11.0790550503432; 13705,11.0877167001897; 13710,11.0964737976295; 13715,11.1058140967948; 13720,11.1152222389552; 13725,11.1256501387672; 13730,11.1370072727624; 13735,11.148473038199; 13740,11.1598088995848; 13745,11.1709356404617; 13750,11.1823752342822; 13755,11.1940938923683; 13760,11.2067735591672; 13765,11.2194332632188; 13770,11.2317895411922; 13775,11.2445536834824; 13780,11.2574576627875; 13785,11.2707651561698; 13790,11.2845971052231; 13795,11.2994056430413; 13800,11.3148462487789; 13805,11.3304297977983; 13810,11.3471767442136; 13815,11.3644198785172; 13820,11.3804138646027; 13825,11.3969684828096; 13830,11.4155322360042; 13835,
        11.4333375774339; 13840,11.4516259258608; 13845,11.4715839042051; 13850,11.4919427979484; 13855,11.5123546129723; 13860,11.5328241787491; 13865,11.5537152967579; 13870,11.5743006593252; 13875,11.594721456156; 13880,11.6149181208557; 13885,11.6338830696326; 13890,11.6514936625087; 13895,11.6698998799222; 13900,11.6880182698981; 13905,11.7052628368138; 13910,11.720922310909; 13915,11.7356010663545; 13920,11.7500848048482; 13925,11.7640079009193; 13930,11.7771153575867; 13935,11.7888404613965; 13940,11.7991530245986; 13945,11.8083880732631; 13950,11.8166377977388; 13955,11.8240036073311; 13960,11.8313762308617; 13965,11.8387849358566; 13970,11.8456442298257; 13975,11.8518875741279; 13980,11.8577205638374; 13985,11.8630928031655; 13990,11.8678566476256; 13995,11.8707533896874; 14000,11.8717089574021; 14005,11.8710820811234; 14010,11.8694457143309; 14015,11.8662300120797; 14020,11.8627915167232; 14025,11.8606272674296; 14030,11.8576037455012; 14035,11.8531990446217; 14040,
        11.8481598416415; 14045,11.843347856735; 14050,11.8384830487513; 14055,11.8334703658678; 14060,11.8288837712072; 14065,11.8247056539994; 14070,11.820690323