﻿within ClaRa.Basics.Media.Slag;
record PartialSlag "Base class for solid type media definition"
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//

constant ClaRa.Basics.Units.HeatCapacityMassSpecific cp;
    annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2024.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under the 3-clause BSD License.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/pdf/CLA.pdf\">https://claralib.com/pdf/CLA.pdf</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under the 3-clause BSD License.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),
 Icon(graphics={
        Line(
          points={{-72,34},{-38,6},{-4,48},{38,6},{66,36}},
          color={255,255,255},
          smooth=Smooth.Bezier),
        Line(
          points={{-74,-8},{-40,-38},{-6,4},{36,-38},{66,-8}},
          color={255,255,255},
          smooth=Smooth.Bezier),
        Line(
          points={{-76,-48},{-42,-78},{-8,-36},{34,-78},{64,-48}},
          color={255,255,255},
          smooth=Smooth.Bezier),
                         Bitmap(extent={{-100,-100},{100,100}},
          imageSource=
              "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",
          fileName="modelica://ClaRa/Resources/Images/Components/Slag.png")}));

end PartialSlag;
