﻿within ClaRa.Basics.Icons;
model Ambience
//__________________________________________________________________________//
// Component of the ClaRa library, version: 1.9.0                           //
//                                                                          //
// Licensed by the ClaRa development team under the 3-clause BSD License.   //
// Copyright  2013-2024, ClaRa development team.                            //
//                                                                          //
// The ClaRa development team consists of the following partners:           //
// TLK-Thermo GmbH (Braunschweig, Germany),                                 //
// XRG Simulation GmbH (Hamburg, Germany).                                  //
//__________________________________________________________________________//
// Contents published in ClaRa have been contributed by different authors   //
// and institutions. Please see model documentation for detailed information//
// on original authorship and copyrights.                                   //
//__________________________________________________________________________//
  annotation (Icon(coordinateSystem(preserveAspectRatio=false), graphics={Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
              "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"
               + "f/rM/O79+7Xug4iIiCjvGD1D3tKdXbu17oOIiIgo7/DWHhEREVGWGKSIiIiIssQgRURERJQlBikiIiKiLDFIEREREWWJQYqIiIgoSwxSRERERFlikCIiIiLKEoMUERERUZYYpIiIiIiyxCBFRERElCUGKSIiIqIsMUgRERERZYlBioiIiChLDFJEREREWWKQIiIiIsoSgxQRERFRlhikiIiIiLLEIEVERESUJQYpIiIioiwxSBERERFliUGKiIiIKEv/D6mQkFgCtpe1AAAAAElFTkSuQmCC",
          fileName="modelica://ClaRa/Resources/Images/Components/Ambience.png")}),     Diagram(graphics,
                                                                                          coordinateSystem(preserveAspectRatio=false)));
end Ambience;
