within ModelicaTableAdditions.Blocks;
package Test "Test models"
  extends Modelica.Icons.ExamplesPackage;
  model TestTables "Test and compare the table blocks"
    extends Modelica.Icons.Example;
    ModelicaTableAdditions.Blocks.Sources.CombiTimeTable combiTimeTableCsv(
      tableOnFile=true,
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.csv"),
      nHeaderLines=1,
      columns={2})
      annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
    Sources.CombiTimeTable combiTimeTableJson(
      tableOnFile=true,
      tableName="tab1",
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.json"),
      columns={2})
      annotation (Placement(transformation(extent={{40,60},{60,80}})));
    Modelica.Blocks.Sources.CombiTimeTable combiTimeTableTxt(
      tableOnFile=true,
      tableName="tab1",
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.txt"),
      columns={2})
      annotation (Placement(transformation(extent={{120,60},{140,80}})));
    Modelica.Blocks.Sources.ContinuousClock clock11
      annotation (Placement(transformation(extent={{-80,20},{-60,40}})));
    ModelicaTableAdditions.Blocks.Tables.CombiTable1Ds combiTable1DsCsv(
      tableOnFile=true,
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.csv"),
      nHeaderLines=1,
      columns={2})
      annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
    Modelica.Blocks.Sources.ContinuousClock clock12
      annotation (Placement(transformation(extent={{-80,-20},{-60,0}})));
    ModelicaTableAdditions.Blocks.Tables.CombiTable1Dv combiTable1DvCsv(
      tableOnFile=true,
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.csv"),
      nHeaderLines=1,
      columns={2})
      annotation (Placement(transformation(extent={{-40,-20},{-20,0}})));
    Modelica.Blocks.Sources.ContinuousClock clock21
      annotation (Placement(transformation(extent={{0,20},{20,40}})));
    Tables.CombiTable1Ds combiTable1DsJson(
      tableOnFile=true,
      tableName="tab1",
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.json"),
      columns={2})
      annotation (Placement(transformation(extent={{40,20},{60,40}})));
    Modelica.Blocks.Sources.ContinuousClock clock22
      annotation (Placement(transformation(extent={{0,-20},{20,0}})));
    Tables.CombiTable1Dv combiTable1DvJson(
      tableOnFile=true,
      tableName="tab1",
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.json"),
      columns={2})
      annotation (Placement(transformation(extent={{40,-20},{60,0}})));
    Modelica.Blocks.Sources.ContinuousClock clock31
      annotation (Placement(transformation(extent={{80,20},{100,40}})));
    Modelica.Blocks.Tables.CombiTable1Ds combiTable1DsTxt(
      tableOnFile=true,
      tableName="tab1",
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.txt"),
      columns={2})
      annotation (Placement(transformation(extent={{120,20},{140,40}})));
    Modelica.Blocks.Sources.ContinuousClock clock32
      annotation (Placement(transformation(extent={{80,-20},{100,0}})));
    Modelica.Blocks.Tables.CombiTable1Dv combiTable1DvTxt(
      tableOnFile=true,
      tableName="tab1",
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.txt"),
      columns={2})
      annotation (Placement(transformation(extent={{120,-20},{140,0}})));
    Sources.TimeTable timeTable(table=[0,0.98; 1,0.98; 2,0.98; 3,0.98; 4,0.98;
          5,0.98; 6,0.98; 7,0.98; 8,0.98; 9,0.98; 10,0.98; 11,0.98; 12,0.98; 13,
          0.98; 14,0.98; 15,0.98; 16,0.98; 17,0.98; 18,0.98; 19,0.98; 20,0.98;
          21,0.98; 22,0.92; 23,0.88; 24,0.84; 25,0.8; 26,0.76; 27,0.72; 28,0.68;
          29,0.64; 30,0.6; 31,0.56; 32,0.52; 33,0.48; 34,0.44; 35,0.4; 36,0.36;
          37,0.32; 38,0.28; 39,0.24; 40,0.2; 41,0.16; 42,0.12; 43,0.08; 44,0.04;
          45,0; 46,0])
      annotation (Placement(transformation(extent={{160,20},{180,40}})));
    Sources.CombiTimeTable combiTimeTable(table=[0,0.98; 1,0.98; 2,0.98; 3,0.98;
          4,0.98; 5,0.98; 6,0.98; 7,0.98; 8,0.98; 9,0.98; 10,0.98; 11,0.98; 12,
          0.98; 13,0.98; 14,0.98; 15,0.98; 16,0.98; 17,0.98; 18,0.98; 19,0.98;
          20,0.98; 21,0.98; 22,0.92; 23,0.88; 24,0.84; 25,0.8; 26,0.76; 27,0.72;
          28,0.68; 29,0.64; 30,0.6; 31,0.56; 32,0.52; 33,0.48; 34,0.44; 35,0.4;
          36,0.36; 37,0.32; 38,0.28; 39,0.24; 40,0.2; 41,0.16; 42,0.12; 43,0.08;
          44,0.04; 45,0; 46,0])
      annotation (Placement(transformation(extent={{160,60},{180,80}})));
  equation
    connect(clock12.y, combiTable1DvCsv.u[1])
      annotation (Line(points={{-59,-10},{-42,-10}}, color={0,0,127}));
    connect(clock32.y,combiTable1DvTxt. u[1])
      annotation (Line(points={{101,-10},{118,-10}}, color={0,0,127}));
    connect(clock11.y, combiTable1DsCsv.u)
      annotation (Line(points={{-59,30},{-42,30}}, color={0,0,127}));
    connect(clock31.y, combiTable1DsTxt.u)
      annotation (Line(points={{101,30},{118,30}}, color={0,0,127}));
    connect(clock22.y, combiTable1DvJson.u[1])
      annotation (Line(points={{21,-10},{38,-10}}, color={0,0,127}));
    connect(clock21.y, combiTable1DsJson.u)
      annotation (Line(points={{21,30},{38,30}}, color={0,0,127}));
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,100}})), Diagram(
          coordinateSystem(preserveAspectRatio=false, extent={{-100,-40},{200,100}})),
      experiment(StopTime=45));
  end TestTables;

  model TestFileUpdateTimeTable "Update table source file on events"
    extends Modelica.Icons.Example;
    ModelicaTableAdditions.Blocks.Sources.FileUpdateTimeTable fileUpdateTimeTable(
      tableName="tab1",
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Tables/test.txt"),
      forceRead=true)
      annotation (Placement(transformation(extent={{-60,20},{-40,40}})));
    Modelica.Blocks.Sources.BooleanExpression booleanExpression(y=sample(0, 10))
      annotation (Placement(transformation(extent={{-80,50},{-60,70}})));
  equation
    connect(fileUpdateTimeTable.updateTrigger, booleanExpression.y)
      annotation (Line(points={{-50,42},{-50,60},{-59,60}}, color={255,0,255}));
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,100}})), Diagram(
          coordinateSystem(preserveAspectRatio=false, extent={{-100,0},{0,100}})),
      experiment(StopTime=45));
  end TestFileUpdateTimeTable;

  model TestWeatherEPWFile "Weather data from EPW file"
    extends Modelica.Icons.Example;
    constant Modelica.Units.SI.EnergyFluence unitEnergyFluence = 1 annotation(HideResult=true);
    record EPWCols "Column indices of EPW file"
      constant Integer 'dry bulb temperature' = 2 "EPW index for dry bulb temperature in degC";
      constant Integer 'dew point temperature' = 3 "EPW index for dew point temperature in degC";
      constant Integer 'relative humidity' = 4 "EPW index for relative humidity in %";
      constant Integer 'atmospheric pressure' = 5 "EPW index for atmospheric_pressure in Pa";
      constant Integer 'global solar' = 9 "EPW index for global horizontal radiation in W.h/m2";
      constant Integer 'normal solar' = 10 "EPW index for direct normal radiation in W.h/m2";
      constant Integer 'diffuse solar' = 11 "EPW index for diffuse horizontal radiation in W.h/m2";
      constant Integer 'wind speed' = 17 "EPW index for wind speed in m/s";
    end EPWCols;
    ModelicaTableAdditions.Blocks.Sources.CombiTimeTable weatherDataSource(
      tableOnFile=true,
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Weather/weather.epw"),
      columns={EPWCols.'dry bulb temperature', EPWCols.'normal solar'},
      smoothness=ModelicaTableAdditions.Blocks.Types.Smoothness.ModifiedContinuousDerivative,
      extrapolation=Modelica.Blocks.Types.Extrapolation.HoldLastPoint,
      shiftTime=1800)
      annotation (Placement(transformation(extent={{-80,40},{-60,60}})));
    Modelica.Blocks.Math.UnitConversions.From_degC 'dry bulb temperature'(
      y(displayUnit="degC"))
      annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
    Modelica.Blocks.Math.Gain 'normal solar'(
      k=3600*unitEnergyFluence,
      y(unit="J/m2", quantity="EnergyFluence", displayUnit="kW.h/m2"))
      annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
  equation
    connect(weatherDataSource.y[1], 'dry bulb temperature'.u)
      annotation (Line(points={{-59,50},{-52,50},{-52,70},{-42,70}}, color={0,0,127}));
    connect(weatherDataSource.y[2], 'normal solar'.u)
      annotation (Line(points={{-59,50},{-52,50},{-52,30},{-42,30}}, color={0,0,127}));
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,100}})), Diagram(
          coordinateSystem(preserveAspectRatio=false, extent={{-100,0},{0,100}})),
      experiment(StopTime=31536000, Interval=1800));
  end TestWeatherEPWFile;

  model TestWeatherCSVFile "Weather data from CSV file"
    extends Modelica.Icons.Example;
    ModelicaTableAdditions.Blocks.Sources.CombiTimeTable weatherDataSource(
      tableOnFile=true,
      fileName=Modelica.Utilities.Files.loadResource("modelica://ModelicaTableAdditions/Resources/Data/Weather/weather.csv"),
      columns={7},
      nHeaderLines=1,
      smoothness=ModelicaTableAdditions.Blocks.Types.Smoothness.ModifiedContinuousDerivative,
      extrapolation=Modelica.Blocks.Types.Extrapolation.HoldLastPoint,
      timeScale=3600,
      shiftTime=1800)
      annotation (Placement(transformation(extent={{-80,40},{-60,60}})));
    Modelica.Blocks.Math.UnitConversions.From_degC 'temperature'(
      y(displayUnit="degC"))
      annotation (Placement(transformation(extent={{-40,40},{-20,60}})));
  equation
    connect(weatherDataSource.y[1], 'temperature'.u)
      annotation (Line(points={{-59,50},{-42,50}}, color={0,0,127}));
    annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,100}})), Diagram(
          coordinateSystem(preserveAspectRatio=false, extent={{-100,0},{0,100}})),
      experiment(StopTime=31536000, Interval=1800));
  end TestWeatherCSVFile;
end Test;
