﻿within Physiomodel;
package CardioVascular2 "Blood and Cardio-Vascular System"
  extends Physiolibrary.Icons.CardioVascularLib;
  class References "References"
    extends Modelica.Icons.References;

    annotation (Documentation(info="<html>
<table>

        <tr>
                <td>[Alfie1999]</td>
                <td>J. Alfie, G. D. Waisman, C. R. Galarza, and M. I. Cámera, \"Contribution of Stroke Volume to the Change in Pulse Pressure Pattern With Age,\" Hypertension, vol. 34, pp. 808-812, October 1, 1999 1999. </td>
        </tr>
        <tr>
                <td>[Alsberge1988]</td>
                <td>M. Alsberge, M. Magno, and M. Lipschutz, Carotid body control of bronchial circulation in sheep vol. 65, 1988. </td>
        </tr>
        <tr>
                <td>[Archer2002]</td>
                <td>S. Archer and E. Michelakis, The Mechanism(s) of Hypoxic Pulmonary Vasoconstriction: Potassium Channels, Redox O2 Sensors, and Controversies vol. 17, 2002. </td>
        </tr>
        <tr>
                <td>[Archer1996]</td>
                <td>S. L. Archer, J. M. C. Huang, H. L. Reeve, V. Hampl, S. Tolarová, E. Michelakis, et al., \"Differential Distribution of Electrophysiologically Distinct Myocytes in Conduit and Resistance Arteries Determines Their Response to Nitric Oxide and Hypoxia,\" Circulation Research, vol. 78, pp. 431-442, March 1, 1996 1996. </td>
        </tr>
        <tr>
                <td>[Armstrong1985]</td>
                <td>R. Armstrong, C. Vandenakker, and M. Laughlin, \"Muscle blood flow patterns during exercise in partially curarized rats,\" Journal of Applied Physiology, vol. 58, pp. 698-701, 1985. </td>
        </tr>
        <tr>
                <td>[Ashley1992]</td>
                <td>K. D. Ashley, D. N. Herndon, L. D. Traber, D. L. Traber, K. Deubel-Ashley, J. Stothert, et al., \"Systemic blood flow to sheep lung: comparison of flow probes and microspheres,\" Journal of Applied Physiology, vol. 73, pp. 1996-1996, 1992. </td>
        </tr>
        <tr>
                <td>[Aukland1989]</td>
                <td>K. Aukland, \"Myogenic mechanisms in the kidney,\" Journal of hypertension. Supplement: official journal of the International Society of Hypertension, vol. 7, pp. S71-6; discussion S77, 1989. </td>
        </tr>
        <tr>
                <td>[Bangsbo1997]</td>
                <td>J. Bangsbo, C. Juel, Y. Hellsten, and B. Saltin, \"Dissociation between lactate and proton exchange in muscle during intense exercise in man,\" The Journal of Physiology, vol. 504, pp. 489-499, October 15, 1997 1997. </td>
        </tr>
        <tr>
                <td>[Bazett1997]</td>
                <td>H. C. Bazett, \"AN ANALYSIS OF THE TIME-RELATIONS OF ELECTROCARDIOGRAMS,\" Annals of Noninvasive Electrocardiology, vol. 2, pp. 177-194, 1997. </td>
        </tr>
        <tr>
                <td>[Begg1966]</td>
                <td>T. Begg and J. Hearns, \"Components in blood viscosity. The relative contribution of haematocrit, plasma fibrinogen and other proteins,\" Clinical science, vol. 31, pp. 87-93, 1966. </td>
        </tr>
        <tr>
                <td>[Berg1997]</td>
                <td>B. R. Berg, K. D. Cohen, and I. H. Sarelius, \"Direct coupling between blood flow and metabolism at the capillary level in striated muscle,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 41, p. H2693, 1997. </td>
        </tr>
        <tr>
                <td>[Bevegärd1962]</td>
                <td>S. Bevegärd and A. Lodin, \"Postural Circulatory Changes at Rest and during Exercise in five Patients with Congenital Absence of Valves in the Deep Veins of the Legs,\" Acta Medica Scandinavica, vol. 172, pp. 21-29, 1962. </td>
        </tr>
        <tr>
                <td>[Bock1930]</td>
                <td>A. V. Bock, D. B. Dill, and H. T. Edwards, \"ON THE RELATION OF CHANGES IN BLOOD VELOCITY AND VOLUME FLOW OF BLOOD TO CHANGE OF POSTURE,\" The Journal of Clinical Investigation, vol. 8, pp. 533-544, 1930. </td>
        </tr>
        <tr>
                <td>[Bootsma1994]</td>
                <td>M. Bootsma, C. A. Swenne, H. H. Van Bolhuis, P. C. Chang, V. M. Cats, and A. Bruschke, \"Heart rate and heart rate variability as indexes of sympathovagal balance,\" American Journal of Physiology, vol. 266, pp. H1565-H1565, 1994. </td>
        </tr>
        <tr>
                <td>[Borgström1975]</td>
                <td>L. Borgström, H. Jóhannsson, and B. K. Siesjö, \"The Relationship between Arterial PO2 and Cerebral Blood Flow in Hypoxic Hypoxia,\" Acta Physiologica Scandinavica, vol. 93, pp. 423-432, 1975. </td>
        </tr>
        <tr>
                <td>[BRADLEY1952]</td>
                <td>S. E. BRADLEY, F. J. INGELFINGER, and G. P. BRADLEY, \"Hepatic Circulation in Cirrhosis of the Liver,\" Circulation, vol. 5, pp. 419-429, March 1, 1952 1952. </td>
        </tr>
        <tr>
                <td>[Bradley1953]</td>
                <td>S. E. Bradley, P. A. Marks, P. C. Reynell, and J. Meltzer, \"The circulating splanchnic blood volume in dog and man,\" Trans Assoc Am Physicians, vol. 66, pp. 294-302, 1953. </td>
        </tr>
        <tr>
                <td>[Braunwald1976]</td>
                <td>E. Braunwald, J. Ross, and E. H. Sonnenblick, Mechanisms of contraction of the normal and failing heart: Little, Brown Boston, 1976. </td>
        </tr>
        <tr>
                <td>[Breslow1993]</td>
                <td>M. J. Breslow, J. R. Tobin, D. S. Bredt, C. D. Ferris, S. H. Snyder, and R. J. Traystman, Nitric oxide as a regulator of adrenal blood flow vol. 264, 1993. </td>
        </tr>
        <tr>
                <td>[Brezis1995]</td>
                <td>M. Brezis and S. Rosen, \"Hypoxia of the Renal Medulla — Its Implications for Disease,\" New England Journal of Medicine, vol. 332, pp. 647-655, 1995. </td>
        </tr>
        <tr>
                <td>[Burattini1994]</td>
                <td>R. Burattini, P. Borgdorff, and N. Westerhof, \"Relationship between strength of short-term systemic autoregulation and initial resistance,\" American Journal of Physiology-Regulatory Integrative and Comparative Physiology, vol. 36, p. R1182, 1994. </td>
        </tr>
        <tr>
                <td>[Carter1998]</td>
                <td>Y. M. Carter, C. X. Jia, P. F. Soto, J. P. Starr, D. G. Rabkin, D. T. Hsu, et al., \"Diastolic properties, myocardial water content, and histologic condition of the rat left ventricle: effect of varied osmolarity of a coronary perfusate,\" The Journal of heart and lung transplantation : the official publication of the International Society for Heart Transplantation, vol. 17, pp. 140-149, 1998/02// 1998. </td>
        </tr>
        <tr>
                <td>[Coleman1972]</td>
                <td>T. G. Coleman, R. D. Manning, Jr., R. A. Norman, Jr., and A. C. Guyton, \"Dynamics of water-isotope distribution,\" Am J Physiol, vol. 223, pp. 1371-5, Dec 1972. </td>
        </tr>
        <tr>
                <td>[Collins-Nakai1994]</td>
                <td>R. L. Collins-Nakai, D. Noseworthy, and G. D. Lopaschuk, \"Epinephrine increases ATP production in hearts by preferentially increasing glucose metabolism,\" Am J Physiol, vol. 267, pp. H1862-71, Nov 1994. </td>
        </tr>
        <tr>
                <td>[Davidson1986]</td>
                <td>D. Davidson, S. A. Stalcup, and R. B. Mellins, Systemic hemodynamics affecting cardiac output during hypocapnic and hypercapnic hypoxia vol. 60, 1986. </td>
        </tr>
        <tr>
                <td>[Drummond2008]</td>
                <td>H. A. Drummond, S. C. Grifoni, and N. L. Jernigan, \"A new trick for an old dogma: ENaC proteins as mechanotransducers in vascular smooth muscle,\" Physiology, vol. 23, pp. 23-31, 2008. </td>
        </tr>
        <tr>
                <td>[Drury1927]</td>
                <td>A. Drury and N. Jones, \"Observations upon the rate at which oedema forms when the veins of the human limb are congested,\" Heart, vol. 14, p. 8, 1927. </td>
        </tr>
        <tr>
                <td>[Dunbar2001]</td>
                <td>S. L. Dunbar, L. Tamhidi, D. E. Berkowitz, and A. A. Shoukas, Hindlimb unweighting affects rat vascular capacitance function vol. 281, 2001. </td>
        </tr>
        <tr>
                <td>[ECHT1974]</td>
                <td>M. ECHT, J. DÜWELING, O. H. GAUER, and L. LANGE, \"Effective Compliance of the Total Vascular Bed and the Intrathoracic Compartment Derived from Changes in Central Venous Pressure Induced by Volume Changes in Man,\" Circulation Research, vol. 34, pp. 61-68, January 1, 1974 1974. </td>
        </tr>
        <tr>
                <td>[Fan1980]</td>
                <td>F. C. Fan, R. Y. Chen, G. B. Schuessler, and S. Chien, Effects of hematocrit variations on regional hemodynamics and oxygen transport in the dog vol. 238, 1980. </td>
        </tr>
        <tr>
                <td>[Fatema2002]</td>
                <td>K. Fatema, O. Hirono, Y. Takeishi, J. Nitobe, K. Kaneko, M. Ito, et al., \"Hemodialysis improves myocardial interstitial edema and left ventricular diastolic function in patients with end-stage renal disease: noninvasive assessment by ultrasonic tissue characterization,\" Heart and vessels, vol. 16, pp. 227-231, 2002. </td>
        </tr>
        <tr>
                <td>[Ferguson1985]</td>
                <td>D. W. Ferguson, F. M. Abboud, and A. L. Mark, \"Relative contribution of aortic and carotid baroreflexes to heart rate control in man during steady state and dynamic increases in arterial pressure,\" The Journal of Clinical Investigation, vol. 76, pp. 2265-2274, 1985. </td>
        </tr>
        <tr>
                <td>[Fitzgerald1980]</td>
                <td>G. A. Fitzgerald, P. Barnes, C. A. Hamilton, and C. T. Dollery, \"Circulating adrenaline and blood pressure: the metabolic effects and kinetics of infused adrenaline in man,\" European Journal of Clinical Investigation, vol. 10, pp. 401-406, 1980. </td>
        </tr>
        <tr>
                <td>[Frisbee2000]</td>
                <td>J. C. Frisbee and J. H. Lombard, \"Increased Intravascular Pressure Does Not Enhance Skeletal Muscle Arteriolar Constriction to Oxygen or Angiotensin II,\" Microvascular Research, vol. 59, pp. 176-180, 1// 2000. </td>
        </tr>
        <tr>
                <td>[Frisbee2000]</td>
                <td>J. C. Frisbee and J. H. Lombard, \"Short-term angiotensin converting enzyme inhibition reduces basal tone and dilator reactivity in skeletal muscle arterioles*,\" American Journal of Hypertension, vol. 13, pp. 389-395, April 1, 2000 2000. </td>
        </tr>
        <tr>
                <td>[Gaasch1975]</td>
                <td>W. H. Gaasch, J. S. Cole, M. A. Quinones, and J. Alexander, \"Dynamic determinants of letf ventricular diastolic pressure-volume relations in man,\" Circulation, vol. 51, pp. 317-323, 1975. </td>
        </tr>
        <tr>
                <td>[GAUER1956]</td>
                <td>O. H. GAUER, J. P. HENRY, and H. O. SIEKER, \"Changes in Central Venous Pressure after Moderate Hemorrhage and Transfusion in Man,\" Circulation Research, vol. 4, pp. 79-84, January 1, 1956 1956. </td>
        </tr>
        <tr>
                <td>[Gibbs1942]</td>
                <td>E. L. Gibbs, F. A. Gibbs, W. G. Lennox, and L. F. Nims, \"REgulation of cerebral carbon dioxide,\" Archives of Neurology & Psychiatry, vol. 47, pp. 879-889, 1942. </td>
        </tr>
        <tr>
                <td>[Goodman1978]</td>
                <td>A. H. Goodman, R. Einstein, and H. J. Granger, \"Effect of changing metabolic rate on local blood flow control in the canine hindlimb,\" Circulation Research, vol. 43, pp. 769-76, November 1, 1978 1978. </td>
        </tr>
        <tr>
                <td>[Granger1969]</td>
                <td>H. J. Granger and A. C. Guyton, \"Autoregulation of the Total Systemic Circulation Following Destruction of the Central Nervous System in the Dog,\" Circulation Research, vol. 25, pp. 379-388, October 1, 1969 1969. </td>
        </tr>
        <tr>
                <td>[Granger1976]</td>
                <td>H. J. Granger, A. H. Goodman, and D. N. Granger, \"Role of resistance and exchange vessels in local microvascular control of skeletal muscle oxygenation in the dog,\" Circulation Research, vol. 38, pp. 379-85, May 1, 1976 1976. </td>
        </tr>
        <tr>
                <td>[Greenway1973]</td>
                <td>C. Greenway and G. Oshiro, \"Effects of histamine on hepatic volume (outflow block) in anaesthetized dogs,\" British journal of pharmacology, vol. 47, pp. 282-290, 1973. </td>
        </tr>
        <tr>
                <td>[Greenway1974]</td>
                <td>C. V. Greenway and G. E. Lister, \"Capacitance effects and blood reservoir function in the splanchnic vascular bed during non-hypotensive haemorrhage and blood volume expansion in anaesthetized cats,\" The Journal of Physiology, vol. 237, pp. 279-294, March 1, 1974 1974. </td>
        </tr>
        <tr>
                <td>[Greenway1985]</td>
                <td>C. V. Greenway, K. L. Seaman, and I. R. Innes, Norepinephrine on venous compliance and unstressed volume in cat liver vol. 248, 1985. </td>
        </tr>
        <tr>
                <td>[Gutsche1980]</td>
                <td>H. U. Gutsche, R. Müller-Suur, U. Hegel, and K. Hierholzer, \"Electrical conductivity of tubular fluid of the rat nephron,\" Pflügers Archiv, vol. 383, pp. 113-121, 1980/01/01 1980. </td>
        </tr>
        <tr>
                <td>[Guyton1961]</td>
                <td>A. C. Guyton and K. Sagawa, \"Compensations of cardiac output and other circulatory functions in areflex dogs with large AV fistulas,\" The American journal of physiology, vol. 200, p. 1157, 1961. </td>
        </tr>
        <tr>
                <td>[Harder1996]</td>
                <td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
        </tr>
        <tr>
                <td>[Harder1996]</td>
                <td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
        </tr>
        <tr>
                <td>[Hennessy1993]</td>
                <td>E. Hennessy, S. White, T. Van der Touw, A. Quail, W. Porges, and P. Glenfield, \"Control of resting bronchial hemodynamics in the awake dog,\" American Journal of Physiology, vol. 265, pp. H649-H649, 1993. </td>
        </tr>
        <tr>
                <td>[Henry1950]</td>
                <td>J. P. Henry and O. H. Gauer, \"THE INFLUENCE OF TEMPERATURE UPON VENOUS PRESSURE IN THE FOOT,\" The Journal of Clinical Investigation, vol. 29, pp. 855-861, 1950. </td>
        </tr>
        <tr>
                <td>[Heyeraas1987]</td>
                <td>K. J. Heyeraas and K. Aukland, \"Interlobular arterial resistance: Influence of renal arterial pressure and angiotensin II,\" Kidney Int, vol. 31, pp. 1291-1298, 06//print 1987. </td>
        </tr>
        <tr>
                <td>[Hogan1990]</td>
                <td>M. C. Hogan, D. E. Bebout, A. T. Gray, P. D. Wagner, J. B. West, and P. E. Haab, Muscle maximal O2 uptake at constant O2 delivery with and without CO in the blood vol. 69, 1990. </td>
        </tr>
        <tr>
                <td>[Charan1984]</td>
                <td>N. B. Charan, G. M. Turk, and R. Dhand, \"Gross and subgross anatomy of bronchial circulation in sheep,\" J Appl Physiol, vol. 57, pp. 658-664, 1984. </td>
        </tr>
        <tr>
                <td>[Charles1994]</td>
                <td>J. B. Charles and C. M. Lathers, \"Summary of Lower Body Negative Pressure Experiments During Space Flight,\" The Journal of Clinical Pharmacology, vol. 34, pp. 571-583, 1994. </td>
        </tr>
        <tr>
                <td>[Ito1990]</td>
                <td>S. Ito and O. A. Carretero, \"An in vitro approach to the study of macula densa-mediated glomerular hemodynamics,\" Kidney Int, vol. 38, pp. 1206-10, Dec 1990. </td>
        </tr>
        <tr>
                <td>[Ito1992]</td>
                <td>S. Ito, O. A. Carretero, K. Abe, L. A. Juncos, and K. Yoshinaga, \"Macula Densa Control of Renin Release and Glomerular Hemodynamics,\" The Tohoku Journal of Experimental Medicine, vol. 166, pp. 27-39, 1992. </td>
        </tr>
        <tr>
                <td>[Itoh1985]</td>
                <td>S. Itoh and O. A. Carretero, \"Role of the macula densa in renin release,\" Hypertension, vol. 7, p. I49, 1985. </td>
        </tr>
        <tr>
                <td>[Jan1977]</td>
                <td>K. M. Jan and S. Chien, Effect of hematocrit variations on coronary hemodynamics and oxygen utilization vol. 233, 1977. </td>
        </tr>
        <tr>
                <td>[Joseph1952]</td>
                <td>J. Joseph and A. Nightingale, \"Electromyography of muscles of posture: leg muscles in males,\" The Journal of Physiology, vol. 117, pp. 484-491, August 28, 1952 1952. </td>
        </tr>
        <tr>
                <td>[Katkov1980]</td>
                <td>V. E. Katkov and V. V. Chestukhin, \"Blood pressure and oxygenation in different cardiovascular compartments of a normal man during postural exposures,\" Aviat Space Environ Med, vol. 51, pp. 1234-42, Nov 1980. </td>
        </tr>
        <tr>
                <td>[Kety1948]</td>
                <td>S. S. Kety and C. F. Schmidt, \"THE EFFECTS OF ALTERED ARTERIAL TENSIONS OF CARBON DIOXIDE AND OXYGEN ON CEREBRAL BLOOD FLOW AND CEREBRAL OXYGEN CONSUMPTION OF NORMAL YOUNG MEN 1,\" The Journal of Clinical Investigation, vol. 27, pp. 484-492, 1948. </td>
        </tr>
        <tr>
                <td>[Kumagai1994]</td>
                <td>K. Kumagai and I. A. Reid, \"Angiotensin II exerts differential actions on renal nerve activity and heart rate,\" Hypertension, vol. 24, pp. 451-456, 1994. </td>
        </tr>
        <tr>
                <td>[Kunert1996]</td>
                <td>M. P. Kunert, J. F. Liard, D. J. Abraham, and J. H. Lombard, \"Low-Affinity Hemoglobin Increases Tissue PO2and Decreases Arteriolar Diameter and Flow in the Rat Cremaster Muscle,\" Microvascular Research, vol. 52, pp. 58-68, 7// 1996. </td>
        </tr>
        <tr>
                <td>[Kuwahira1993]</td>
                <td>I. Kuwahira, N. Heisler, J. Piiper, and N. C. Gonzalez, \"Effect of chronic hypoxia on hemodynamics, organ blood flow and O2 supply in rats,\" Respiration Physiology, vol. 92, pp. 227-238, 5// 1993. </td>
        </tr>
        <tr>
                <td>[Laine1979]</td>
                <td>G. A. Laine, J. T. Hall, S. H. Laine, and J. Granger, \"Transsinusoidal fluid dynamics in canine liver during venous hypertension,\" Circulation Research, vol. 45, pp. 317-23, September 1, 1979 1979. </td>
        </tr>
        <tr>
                <td>[Landis1933]</td>
                <td>E. M. Landis and J. H. Gibbon, Jr., \"THE EFFECTS OF TEMPERATURE AND OF TISSUE PRESSURE ON THE MOVEMENT OF FLUID THROUGH THE HUMAN CAPILLARY WALL,\" The Journal of Clinical Investigation, vol. 12, pp. 105-138, 1933. </td>
        </tr>
        <tr>
                <td>[Langer1997]</td>
                <td>G. A. Langer, The myocardium: Academic Press, 1997. </td>
        </tr>
        <tr>
                <td>[Lash1987]</td>
                <td>J. M. Lash and H. G. Bohlen, Perivascular and tissue PO2 in contracting rat spinotrapezius muscle vol. 252, 1987. </td>
        </tr>
        <tr>
                <td>[Lassen1959]</td>
                <td>N. A. Lassen, Cerebral blood flow and oxygen consumption in man: Am Physiological Soc, 1959. </td>
        </tr>
        <tr>
                <td>[LAUGHLIN1987]</td>
                <td>M. H. LAUGHLIN, \"Skeletal muscle blood flow capacity: role of muscle pump in exercise hyperemia,\" Am J Physiol, vol. 253, p. 1004, 1987. </td>
        </tr>
        <tr>
                <td>[Laughlin1983]</td>
                <td>M. H. Laughlin and R. Armstrong, \"Rat muscle blood flows as a function of time during prolonged slow treadmill exercise,\" Am J Physiol Heart Circ Physiol, vol. 244, pp. H814-H824, 1983. </td>
        </tr>
        <tr>
                <td>[Lautt1987]</td>
                <td>W. W. Lautt, C. V. Greenway, and D. J. Legare, \"Effect of hepatic nerves, norepinephrine, angiotensin, and elevated central venous pressure on postsinusoidal resistance sites and intrahepatic pressures in cats,\" Microvascular Research, vol. 33, pp. 50-61, 1// 1987. </td>
        </tr>
        <tr>
                <td>[Little1993]</td>
                <td>W. C. Little and C. P. Cheng, \"Effect of exercise on left ventricular-arterial coupling assessed in the pressure-volume plane,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 264, pp. H1629-H1629, 1993. </td>
        </tr>
        <tr>
                <td>[Maass-Moreno1992]</td>
                <td>R. Maass-Moreno and C. F. Rothe, \"Contribution of the large hepatic veins to postsinusoidal vascular resistance,\" Am J Physiol Gastrointest Liver Physiol, vol. 262, pp. G14-G22, 1992. </td>
        </tr>
        <tr>
                <td>[Malo1984]</td>
                <td>J. Malo, H. Goldberg, R. Graham, H. Unruh, and C. Skoog, Effect of hypoxic hypoxia on systemic vasculature vol. 56, 1984. </td>
        </tr>
        <tr>
                <td>[Manning1987]</td>
                <td>R. D. Manning, Renal hemodynamic, fluid volume, and arterial pressure changes during hyperproteinemia vol. 252, 1987. </td>
        </tr>
        <tr>
                <td>[Manning1990]</td>
                <td>R. D. Manning, Effects of hypoproteinemia on blood volume and arterial pressure of volume-loaded dogs vol. 259, 1990. </td>
        </tr>
        <tr>
                <td>[Manning1983]</td>
                <td>R. D. Manning and A. C. Guyton, Effects of hypoproteinemia on fluid volumes and arterial pressure vol. 245, 1983. </td>
        </tr>
        <tr>
                <td>[Marshall1995]</td>
                <td>J. Marshall, Skeletal Muscle Vasculature and Systemic Hypoxia vol. 10, 1995. </td>
        </tr>
        <tr>
                <td>[Marshall1988]</td>
                <td>J. M. Marshall and J. D. Metcalfe, \"Analysis of the cardiovascular changes induced in the rat by graded levels of systemic hypoxia,\" The Journal of Physiology, vol. 407, pp. 385-403, December 1, 1988 1988. </td>
        </tr>
        <tr>
                <td>[Mayerson1939]</td>
                <td>H. S. Mayerson, H. M. Sweeney, and L. A. Toth, THE INFLUENCE OF POSTURE ON CIRCULATION TIME vol. 125, 1939. </td>
        </tr>
        <tr>
                <td>[McKeever1958]</td>
                <td>W. McKeever, D. Gregg, and P. Canney, \"Oxygen uptake of the nonworking left ventricle,\" Circulation research, vol. 6, pp. 612-623, 1958. </td>
        </tr>
        <tr>
                <td>[MCKEEVER1958]</td>
                <td>W. P. MCKEEVER, D. E. GREGG, and P. C. CANNEY, \"Oxygen Uptake of the Nonworking Left Ventricle,\" Circulation Research, vol. 6, pp. 612-623, September 1, 1958 1958. </td>
        </tr>
        <tr>
                <td>[Mellander1992]</td>
                <td>S. Mellander and J. Bjornberg, Regulation of Vascular Smooth Muscle Tone and Capillary Pressure vol. 7, 1992. </td>
        </tr>
        <tr>
                <td>[Metting1988]</td>
                <td>P. J. Metting, J. R. Strader, and S. L. Britton, Evaluation of whole body autoregulation in conscious dogs vol. 255, 1988. </td>
        </tr>
        <tr>
                <td>[Metting1989]</td>
                <td>P. J. Metting, P. M. Stein, B. A. Stoos, K. A. Kostrzewski, and S. L. Britton, Systemic vascular autoregulation amplifies pressor responses to vasoconstrictor agents vol. 256, 1989. </td>
        </tr>
        <tr>
                <td>[Mitzner1974]</td>
                <td>W. Mitzner, Hepatic outflow resistance, sinusoid pressure, and the vascular waterfall vol. 227, 1974. </td>
        </tr>
        <tr>
                <td>[Monos2001]</td>
                <td>E. Monos, M. Lóránt, and E. Fehér, Influence of long-term experimental orthostatic body position on innervation density in extremity vessels vol. 281, 2001. </td>
        </tr>
        <tr>
                <td>[Monos2003]</td>
                <td>E. Monos, M. Lóránt, G. Dörnyei, V. Bérczi, and G. Nádasy, Long-Term Adaptation Mechanisms in Extremity Veins Supporting Orthostatic Tolerance vol. 18, 2003. </td>
        </tr>
        <tr>
                <td>[MONROE1960]</td>
                <td>R. G. MONROE and G. FRENCH, \"Ventricular Pressure-Volume Relationships and Oxygen Consumption in Fibrillation and Arrest,\" Circulation Research, vol. 8, pp. 260-266, January 1, 1960 1960. </td>
        </tr>
        <tr>
                <td>[MONROE1961]</td>
                <td>R. G. MONROE and G. N. FRENCH, \"Left ventricular pressure-volume relationships and myocardial oxygen consumption in the isolated heart,\" Circulation research, vol. 9, pp. 362-373, 1961. </td>
        </tr>
        <tr>
                <td>[Moore1990]</td>
                <td>L. C. Moore and D. Casellas, \"Tubuloglomerular feedback dependence of autoregulation in rat juxtamedullary afferent arterioles,\" Kidney Int, vol. 37, pp. 1402-1408, 06//print 1990. </td>
        </tr>
        <tr>
                <td>[Murphy2008]</td>
                <td>E. Murphy and C. Steenbergen, \"Ion transport and energetics during cell death and protection,\" Physiology (Bethesda), vol. 23, pp. 115-23, Apr 2008. </td>
        </tr>
        <tr>
                <td>[NODA1993]</td>
                <td>T. NODA, C.-P. CHENG, P. P. DE TOMBE, and W. C. LITTLE, \"Curvilinearity of LV end-systolic pressure-volume and dP/dt,-end-diastolic volume relations,\" 1993. </td>
        </tr>
        <tr>
                <td>[O’ROURKE1990]</td>
                <td>S. T. O’ROURKE and P. M. VANHOUTTE, \"Adrenergic and cholinergic responsiveness of isolated canine bronchial arteries,\" Organ, vol. 6, p. 2, 1990. </td>
        </tr>
        <tr>
                <td>[OCHSNER1951]</td>
                <td>A. OCHSNER, R. COLP, and G. E. BURCH, \"Normal Blood Pressure in the Superficial Venous System of Man at Rest in the Supine Position,\" Circulation, vol. 3, pp. 674-680, May 1, 1951 1951. </td>
        </tr>
        <tr>
                <td>[Pogátsa1982]</td>
                <td>G. Pogátsa, M. Z. Koltai, and G. Grósz, \"The role of the myocardial water content in heart function,\" Acta physiologica Academiae Scientiarum Hungaricae, vol. 59, pp. 305-309, 1982 1982. </td>
        </tr>
        <tr>
                <td>[POHOST1976]</td>
                <td>G. M. POHOST, J. B. NEWELL, N. P. HAMLIN, and W. J. POWELL, \"Observations on autoregulation in skeletal muscle: the effects of arterial hypoxia,\" Cardiovascular Research, vol. 10, pp. 405-412, July 1, 1976 1976. </td>
        </tr>
        <tr>
                <td>[Pollack1949]</td>
                <td>A. A. Pollack and E. H. Wood, Venous Pressure in the Saphenous Vein at the Ankle in Man during Exercise and Changes in Posture vol. 1, 1949. </td>
        </tr>
        <tr>
                <td>[Prabhu1993]</td>
                <td>S. D. Prabhu and G. L. Freeman, \"Left ventricular energetics in closed-chest dogs,\" Am J Physiol, vol. 265, pp. H1048-55, Oct 1993. </td>
        </tr>
        <tr>
                <td>[Prewitt1976]</td>
                <td>R. L. Prewitt and P. C. Johnson, \"The effect of oxygen on arteriolar red cell velocity and capillary density in the rat cremaster muscle,\" Microvascular Research, vol. 12, pp. 59-70, 7// 1976. </td>
        </tr>
        <tr>
                <td>[Pruett2013]</td>
                <td>W. A. Pruett, L. D. Husband, G. Husband, M. Dakhlalla, K. Bellamy, T. G. Coleman, et al., \"A Population Model of Integrative Cardiovascular Physiology,\" PloS one, vol. 8, p. e74329, 2013. </td>
        </tr>
        <tr>
                <td>[Raeder1995]</td>
                <td>E. A. Raeder, P. Albrecht, M. Perrott, and R. J. Cohen, \"Kinetics of Cycle Length Dependence of Ventricular Repolarization,\" Journal of Cardiovascular Electrophysiology, vol. 6, pp. 163-169, 1995. </td>
        </tr>
        <tr>
                <td>[Raven1984]</td>
                <td>P. B. Raven, D. Rohm-Young, and C. G. Blomqvist, Physical fitness and cardiovascular response to lower body negative pressure vol. 56, 1984. </td>
        </tr>
        <tr>
                <td>[Reivich1964]</td>
                <td>M. Reivich, Arterial Pco2 and cerebral hemodynamics vol. 206, 1964. </td>
        </tr>
        <tr>
                <td>[Roach1957]</td>
                <td>M. R. Roach and A. C. Burton, \"THE REASON FOR THE SHAPE OF THE DISTENSIBILITY CURVES OF ARTERIES,\" Canadian Journal of Biochemistry and Physiology, vol. 35, pp. 681-690, 1957/08/01 1957. </td>
        </tr>
        <tr>
                <td>[ROSS1965]</td>
                <td>J. ROSS, J. W. LINHART, and E. BRAUNWALD, \"Effects of Changing Heart Rate in Man by Electrical Stimulation of the Right Atrium: Studies at Rest, during Exercise, and with Isoproterenol,\" Circulation, vol. 32, pp. 549-558, October 1, 1965 1965. </td>
        </tr>
        <tr>
                <td>[Sagawa1988]</td>
                <td>K. Sagawa, L. Maughan, H. Suga, and K. Sunagawa, Cardiac contraction and the pressure-volume relationship vol. 480: Oxford University Press New York, 1988. </td>
        </tr>
        <tr>
                <td>[Sage1981]</td>
                <td>J. I. Sage, R. L. Van Uitert, and T. E. Duffy, \"Simultaneous Measurement of Cerebral Blood Flow and Unidirectional Movement of Substances Across the Blood-Brain Barrier: Theory, Method, and Application to Leucine,\" Journal of Neurochemistry, vol. 36, pp. 1731-1738, 1981. </td>
        </tr>
        <tr>
                <td>[Shigemi1994]</td>
                <td>K. Shigemi, M. J. Brunner, and A. A. Shoukas, \"-and -Adrenergic mechanisms in the control of vascular capacitance by the carotid sinus baroreflex system,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 267, pp. H201-H201, 1994. </td>
        </tr>
        <tr>
                <td>[Schrier1970]</td>
                <td>R. W. Schrier, K. M. McDonald, R. Wells, and D. P. Lauler, \"Influence of hematocrit and colloid on whole blood viscosity during volume expansion,\" Am. J. Physiol, vol. 218, p. 77, 1970. </td>
        </tr>
        <tr>
                <td>[Skarlatos1993]</td>
                <td>S. Skarlatos, N. DiPaola, R. A. Frankel, R. W. Pomerantz, P. H. Brand, P. J. Metting, et al., \"Spontaneous pressure-flow relationships in renal circulation of conscious dogs,\" Am J Physiol, vol. 264, pp. H1517-27, May 1993. </td>
        </tr>
        <tr>
                <td>[Skov1996]</td>
                <td>K. Skov, J. Fenger-Gron, and M. J. Mulvany, \"Effects of an angiotensin-converting enzyme inhibitor, a calcium antagonist, and an endothelin receptor antagonist on renal afferent arteriolar structure,\" Hypertension, vol. 28, pp. 464-471, 1996. </td>
        </tr>
        <tr>
                <td>[Stainsby1973]</td>
                <td>W. N. Stainsby, \"Local Control of Regional Blood Flow,\" Annual Review of Physiology, vol. 35, pp. 151-168, 1973. </td>
        </tr>
        <tr>
		<td>[Stevens]</td>
		<td>StevensP. M. Stevens and L. E. Lamb, \"Effects of lower body negative pressure on the cardiovascular system,\" American Journal of Cardiology, vol. 16, pp. 506-515. </td>
        <tr>
                <td>[Stick1992]</td>
                <td>C. Stick, H. Jaeger, and E. Witzleb, Measurements of volume changes and venous pressure in the human lower leg during walking and running vol. 72, 1992. </td>
        </tr>
        <tr>
                <td>[Stone1968]</td>
                <td>H. Stone, Thompson HK, and K. Schmidt-Nielsen, Influence of erythrocytes on blood viscosity vol. 214, 1968. </td>
        </tr>
        <tr>
                <td>[Stonestreet1998]</td>
                <td>B. S. Stonestreet, S. S. Ocampo, and W. Oh, Reductions in cardiac output in hypoxic young pigs: systemic and regional perfusion and oxygen metabolism vol. 85, 1998. </td>
        </tr>
        <tr>
                <td>[Stothert1992]</td>
                <td>J. C. Stothert, J. O. Basadre, G. B. Gbaanador, J. T. Flynn, L. Traber, and D. Traber, \"Bronchial blood flow during changes in inhaled oxygen and carbon dioxide concentrations in conscious sheep,\" Circulatory shock, vol. 36, pp. 120-126, 1992/02// 1992. </td>
        </tr>
        <tr>
                <td>[Suga1979]</td>
                <td>H. Suga, Total mechanical energy of a ventricle model and cardiac oxygen consumption vol. 236, 1979. </td>
        </tr>
        <tr>
                <td>[SUGA1974]</td>
                <td>H. SUGA and K. SAGAWA, \"Instantaneous Pressure-Volume Relationships and Their Ratio in the Excised, Supported Canine Left Ventricle,\" Circulation Research, vol. 35, pp. 117-126, July 1, 1974 1974. </td>
        </tr>
        <tr>
                <td>[SUGA1976]</td>
                <td>H. SUGA, K. SAGAWA, and D. P. KOSTIUK, \"Controls of ventricular contractility assessed by pressure-volume ratio, Emax,\" Cardiovascular Research, vol. 10, pp. 582-592, September 1, 1976 1976. </td>
        </tr>
        <tr>
                <td>[Sugimoto1966]</td>
                <td>T. Sugimoto, K. Sagawa, and A. Guyton, Effect of tachycardia on cardiac output during normal and increased venous return vol. 211, 1966. </td>
        </tr>
        <tr>
		<td>[Schumacker]</td>   
		<td>SchumackerS. P. T. and C. S. M., \"The concept of a critical oxygen delivery,\" Intensive Care Medicine, vol. 13, pp. 223-229, January 1, 0001.</td>
        <tr>
                <td>[Takeshita1979]</td>
                <td>A. Takeshita, A. L. Mark, D. L. Eckberg, and F. M. Abboud, Effect of central venous pressure on arterial baroreflex control of heart rate vol. 236, 1979. </td>
        </tr>
        <tr>
                <td>[Thompson1928]</td>
                <td>W. O. Thompson, P. K. Thompson, and M. E. Dailey, \"THE EFFECT OF POSTURE UPON THE COMPOSITION AND VOLUME OF THE BLOOD IN MAN 1,\" The Journal of Clinical Investigation, vol. 5, pp. 573-604, 1928. </td>
        </tr>
        <tr>
                <td>[Wagner1988]</td>
                <td>E. M. Wagner and W. A. Mitzner, \"Effect of hypoxia on bronchial circulation,\" J. Appl. Physiol, vol. 65, pp. 1627-1633, 1988. </td>
        </tr>
        <tr>
                <td>[Wagner1990]</td>
                <td>E. M. Wagner and W. A. Mitzner, \"Effect of left atrial pressure on bronchial vascular hemodynamics,\" J Appl Physiol, vol. 69, pp. 837-842, 1990. </td>
        </tr>
        <tr>
                <td>[Warner1962]</td>
                <td>H. R. Warner and A. Cox, A mathematical model of heart rate control by sympathetic and vagus efferent information vol. 17, 1962. </td>
        </tr>
        <tr>
                <td>[Weber1977]</td>
                <td>K. T. Weber and J. S. Janicki, Myocardial oxygen consumption: the role of wall force and shortening vol. 233, 1977. </td>
        </tr>
        <tr>
                <td>[Weber2000]</td>
                <td>D. S. Weber and J. H. Lombard, Elevated salt intake impairs dilation of rat skeletal muscle resistance arteries via ANG II suppression vol. 278, 2000. </td>
        </tr>
        <tr>
                <td>[Wells1938]</td>
                <td>H. S. Wells, J. B. Youmans, and D. G. Miller, Jr., \"TISSUE PRESSURE (INTRACUTANEOUS, SUBCUTANEOUS, AND INTRAMUSCULAR) AS RELATED TO VENOUS PRESSURE, CAPILLARY FILTRATION, AND OTHER FACTORS 12,\" The Journal of Clinical Investigation, vol. 17, pp. 489-499, 1938. </td>
        </t"
    + "r>
        <tr>
                <td>[Whalen1974]</td>
                <td>W. Whalen, P. Nair, D. Buerk, and C. Thuning, \"Tissue PO2 in normal and denervated cat skeletal muscle,\" Am J Physiol, vol. 227, pp. 1221-1225, 1974. </td>
        </tr>
        <tr>
                <td>[Whittaker1933]</td>
                <td>S. R. F. Whittaker and F. R. Winton, \"The apparent viscosity of blood flowing in the isolated hindlimb of the dog, and its variation with corpuscular concentration,\" The Journal of Physiology, vol. 78, pp. 339-369, July 10, 1933 1933. </td>
        </tr>
        <tr>
                <td>[L.1989]</td>
                <td>L. R. Williams and R. W. Leggett, \"Reference values for resting blood flow to organs of man,\" Clinical Physics and Physiological Measurement, vol. 10, p. 187, 1989. </td>
        </tr>
        <tr>
                <td>[Woo1972]</td>
                <td>S. L. Y. Woo, A. S. Kobayashi, C. Lawrence, and W. A. Schlegel, \"Mathematical model of the corneo-scleral shell as applied to intraocular pressure-volume relations and applanation tonometry,\" Annals of Biomedical Engineering, vol. 1, pp. 87-98, 1972/09/01 1972. </td>
        </tr>
        <tr>
                <td>[Xenopoulos1994]</td>
                <td>N. P. Xenopoulos and R. J. Applegate, \"The effect of vagal stimulation on left ventricular systolic and diastolic performance,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 35, p. H2167, 1994.  </td>
        </tr>

</table>
</html>"));
  end References;

  package Heart "Heart Components"

    class References "References"
      extends Modelica.Icons.References;

      annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Bazett1997]</td>
		<td>H. C. Bazett, \"AN ANALYSIS OF THE TIME-RELATIONS OF ELECTROCARDIOGRAMS,\" Annals of Noninvasive Electrocardiology, vol. 2, pp. 177-194, 1997. </td>
	</tr>
	<tr>
		<td>[Bootsma1994]</td>
		<td>M. Bootsma, C. A. Swenne, H. H. Van Bolhuis, P. C. Chang, V. M. Cats, and A. Bruschke, \"Heart rate and heart rate variability as indexes of sympathovagal balance,\" American Journal of Physiology, vol. 266, pp. H1565-H1565, 1994. </td>
	</tr>
	<tr>
		<td>[Braunwald1976]</td>
		<td>E. Braunwald, J. Ross, and E. H. Sonnenblick, Mechanisms of contraction of the normal and failing heart: Little, Brown Boston, 1976. </td>
	</tr>
	<tr>
		<td>[Carter1998]</td>
		<td>Y. M. Carter, C. X. Jia, P. F. Soto, J. P. Starr, D. G. Rabkin, D. T. Hsu, et al., \"Diastolic properties, myocardial water content, and histologic condition of the rat left ventricle: effect of varied osmolarity of a coronary perfusate,\" The Journal of heart and lung transplantation : the official publication of the International Society for Heart Transplantation, vol. 17, pp. 140-149, 1998/02// 1998. </td>
	</tr>
	<tr>
		<td>[Collins-Nakai1994]</td>
		<td>R. L. Collins-Nakai, D. Noseworthy, and G. D. Lopaschuk, \"Epinephrine increases ATP production in hearts by preferentially increasing glucose metabolism,\" Am J Physiol, vol. 267, pp. H1862-71, Nov 1994. </td>
	</tr>
	<tr>
		<td>[Fatema2002]</td>
		<td>K. Fatema, O. Hirono, Y. Takeishi, J. Nitobe, K. Kaneko, M. Ito, et al., \"Hemodialysis improves myocardial interstitial edema and left ventricular diastolic function in patients with end-stage renal disease: noninvasive assessment by ultrasonic tissue characterization,\" Heart and vessels, vol. 16, pp. 227-231, 2002. </td>
	</tr>
	<tr>
		<td>[Ferguson1985]</td>
		<td>D. W. Ferguson, F. M. Abboud, and A. L. Mark, \"Relative contribution of aortic and carotid baroreflexes to heart rate control in man during steady state and dynamic increases in arterial pressure,\" The Journal of Clinical Investigation, vol. 76, pp. 2265-2274, 1985. </td>
	</tr>
	<tr>
		<td>[Gaasch1975]</td>
		<td>W. H. Gaasch, J. S. Cole, M. A. Quinones, and J. Alexander, \"Dynamic determinants of letf ventricular diastolic pressure-volume relations in man,\" Circulation, vol. 51, pp. 317-323, 1975. </td>
	</tr>
	<tr>
		<td>[Guyton1961]</td>
		<td>A. C. Guyton and K. Sagawa, \"Compensations of cardiac output and other circulatory functions in areflex dogs with large AV fistulas,\" The American journal of physiology, vol. 200, p. 1157, 1961. </td>
	</tr>
	<tr>
		<td>[Kumagai1994]</td>
		<td>K. Kumagai and I. A. Reid, \"Angiotensin II exerts differential actions on renal nerve activity and heart rate,\" Hypertension, vol. 24, pp. 451-456, 1994. </td>
	</tr>
	<tr>
		<td>[Langer1997]</td>
		<td>G. A. Langer, The myocardium: Academic Press, 1997. </td>
	</tr>
	<tr>
		<td>[Little1993]</td>
		<td>W. C. Little and C. P. Cheng, \"Effect of exercise on left ventricular-arterial coupling assessed in the pressure-volume plane,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 264, pp. H1629-H1629, 1993. </td>
	</tr>
	<tr>
		<td>[McKeever1958]</td>
		<td>W. McKeever, D. Gregg, and P. Canney, \"Oxygen uptake of the nonworking left ventricle,\" Circulation research, vol. 6, pp. 612-623, 1958. </td>
	</tr>
	<tr>
		<td>[MCKEEVER1958]</td>
		<td>W. P. MCKEEVER, D. E. GREGG, and P. C. CANNEY, \"Oxygen Uptake of the Nonworking Left Ventricle,\" Circulation Research, vol. 6, pp. 612-623, September 1, 1958 1958. </td>
	</tr>
	<tr>
		<td>[MONROE1960]</td>
		<td>R. G. MONROE and G. FRENCH, \"Ventricular Pressure-Volume Relationships and Oxygen Consumption in Fibrillation and Arrest,\" Circulation Research, vol. 8, pp. 260-266, January 1, 1960 1960. </td>
	</tr>
	<tr>
		<td>[MONROE1961]</td>
		<td>R. G. MONROE and G. N. FRENCH, \"Left ventricular pressure-volume relationships and myocardial oxygen consumption in the isolated heart,\" Circulation research, vol. 9, pp. 362-373, 1961. </td>
	</tr>
	<tr>
		<td>[Murphy2008]</td>
		<td>E. Murphy and C. Steenbergen, \"Ion transport and energetics during cell death and protection,\" Physiology (Bethesda), vol. 23, pp. 115-23, Apr 2008. </td>
	</tr>
	<tr>
		<td>[NODA1993]</td>
		<td>T. NODA, C.-P. CHENG, P. P. DE TOMBE, and W. C. LITTLE, \"Curvilinearity of LV end-systolic pressure-volume and dP/dt,-end-diastolic volume relations,\" 1993. </td>
	</tr>
	<tr>
		<td>[Pogátsa1982]</td>
		<td>G. Pogátsa, M. Z. Koltai, and G. Grósz, \"The role of the myocardial water content in heart function,\" Acta physiologica Academiae Scientiarum Hungaricae, vol. 59, pp. 305-309, 1982 1982. </td>
	</tr>
	<tr>
		<td>[Prabhu1993]</td>
		<td>S. D. Prabhu and G. L. Freeman, \"Left ventricular energetics in closed-chest dogs,\" Am J Physiol, vol. 265, pp. H1048-55, Oct 1993. </td>
	</tr>
	<tr>
		<td>[Raeder1995]</td>
		<td>E. A. Raeder, P. Albrecht, M. Perrott, and R. J. Cohen, \"Kinetics of Cycle Length Dependence of Ventricular Repolarization,\" Journal of Cardiovascular Electrophysiology, vol. 6, pp. 163-169, 1995. </td>
	</tr>
	<tr>
		<td>[ROSS1965]</td>
		<td>J. ROSS, J. W. LINHART, and E. BRAUNWALD, \"Effects of Changing Heart Rate in Man by Electrical Stimulation of the Right Atrium: Studies at Rest, during Exercise, and with Isoproterenol,\" Circulation, vol. 32, pp. 549-558, October 1, 1965 1965. </td>
	</tr>
	<tr>
		<td>[Sagawa1988]</td>
		<td>K. Sagawa, L. Maughan, H. Suga, and K. Sunagawa, Cardiac contraction and the pressure-volume relationship vol. 480: Oxford University Press New York, 1988. </td>
	</tr>
	<tr>
		<td>[Suga1979]</td>
		<td>H. Suga, Total mechanical energy of a ventricle model and cardiac oxygen consumption vol. 236, 1979. </td>
	</tr>
	<tr>
		<td>[SUGA1974]</td>
		<td>H. SUGA and K. SAGAWA, \"Instantaneous Pressure-Volume Relationships and Their Ratio in the Excised, Supported Canine Left Ventricle,\" Circulation Research, vol. 35, pp. 117-126, July 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[SUGA1976]</td>
		<td>H. SUGA, K. SAGAWA, and D. P. KOSTIUK, \"Controls of ventricular contractility assessed by pressure-volume ratio, Emax,\" Cardiovascular Research, vol. 10, pp. 582-592, September 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Sugimoto1966]</td>
		<td>T. Sugimoto, K. Sagawa, and A. Guyton, Effect of tachycardia on cardiac output during normal and increased venous return vol. 211, 1966. </td>
	</tr>
	<tr>
		<td>[Takeshita1979]</td>
		<td>A. Takeshita, A. L. Mark, D. L. Eckberg, and F. M. Abboud, Effect of central venous pressure on arterial baroreflex control of heart rate vol. 236, 1979. </td>
	</tr>
	<tr>
		<td>[Warner1962]</td>
		<td>H. R. Warner and A. Cox, A mathematical model of heart rate control by sympathetic and vagus efferent information vol. 17, 1962. </td>
	</tr>
	<tr>
		<td>[Weber1977]</td>
		<td>K. T. Weber and J. S. Janicki, Myocardial oxygen consumption: the role of wall force and shortening vol. 233, 1977. </td>
	</tr>
	<tr>
		<td>[Woo1972]</td>
		<td>S. L. Y. Woo, A. S. Kobayashi, C. Lawrence, and W. A. Schlegel, \"Mathematical model of the corneo-scleral shell as applied to intraocular pressure-volume relations and applanation tonometry,\" Annals of Biomedical Engineering, vol. 1, pp. 87-98, 1972/09/01 1972. </td>
	</tr>
	<tr>
		<td>[Xenopoulos1994]</td>
		<td>N. P. Xenopoulos and R. J. Applegate, \"The effect of vagal stimulation on left ventricular systolic and diastolic performance,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 35, p. H2167, 1994.  </td>
	</tr>

</table>
</html>"));
    end References;

    package Interfaces
      partial model IVentricle
        extends Physiolibrary.Icons.HeartVentricle;
        parameter Physiolibrary.Types.Volume initialVol = 90e-6
        "Initial blood volume in ventricle";
      //  parameter Physiolibrary.Types.Volume initialESV = 50e-6;

      parameter Physiolibrary.Types.Volume NormalEndDiastolicVolume = 70e-6
        "Typical value of blood volume in ventricle after filling"
          annotation (Dialog(group="Diastole"));
      parameter Physiolibrary.Types.Pressure NormalFillingPressure = (0.00051*101325/760)*(NormalEndDiastolicVolume^(1/n_Diastole))
        "Typical value of filling pressure relative to pericardium pressure"
          annotation (Dialog(group="Diastole"));
      parameter Physiolibrary.Types.Fraction stiffnes = 1
        "Relative stiffnes (1 if normal)"
          annotation (Dialog(group="Diastole"));
      parameter Physiolibrary.Types.Fraction n_Diastole(displayUnit="1") = 2
        "Exponent of P-V characteristic of EDV curve on filling pressure"
          annotation (Dialog(group="Diastole"));
      //parameter Real Abasic_Diastole = 0.00051
      //    "parametrization of end diastolic volume curve"
      //    annotation (Dialog(group="Diastole"));

      parameter Physiolibrary.Types.Pressure NormalSystolicPressure = 15998.684210526315789473684210526
        "Typical value of systolic pressure relative to pericardium pressure"
          annotation (Dialog(group="Systole"));
      parameter Physiolibrary.Types.Volume NormalEndSystolicVolume = (NormalSystolicPressure/(17.39*101325/760))^(n_Systole)
        "Typical value of blood volume in ventricle after ejection"
          annotation (Dialog(group="Systole"));
      //parameter Real Abasic_Systole = 17.39
      //    "parametrization of end systolic volume curve";
      parameter Physiolibrary.Types.Pressure additionalPressure_Systolic
        "Pressure difference between mean and systolic pressure"
          annotation (Dialog(group="Systole"));     //= 24
      parameter Physiolibrary.Types.Fraction contractilityBasic
        "Relative contractility (1 if normal)"
           annotation (Dialog(group="Systole"));       //= 1
      parameter Physiolibrary.Types.Fraction n_Systole(displayUnit="1")=0.5
        "Exponent of P-V characteristic of ESV curve on systolic pressure"
          annotation (Dialog(group="Systole"));

      parameter Physiolibrary.Types.Frequency K
        "time adaptation coeficient of average ventricle blood volume";
                                                    // = 1
      parameter Physiolibrary.Types.HydraulicCompliance BasicCompliance; //(final quantity="Compliance", final displayUnit="ml/mmHg") = 1;

      parameter Physiolibrary.Types.Pressure NormalExternalPressure = -446
        "Typical value of pericardium cavity pressure (relative to environment ambient pressure)";
                                                                               //-446 Pa = -3.34522 mmHg

      //parameter Physiolibrary.Types.HydraulicCompliance MaxContractionCompliance; //=1;
      //parameter Physiolibrary.Types.HydraulicConductance Cond1;//=1;
      //parameter Physiolibrary.Types.HydraulicConductance Cond2;//=1;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
          extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                           iconTransformation(extent={{10,70},{30,90}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out annotation (
          extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                             iconTransformation(extent={{-30,90},{-10,110}})));

      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{12,-8},{32,12}}), iconTransformation(
              extent={{-10,-64},{10,-44}})));

        Physiolibrary.Types.RealIO.VolumeOutput Vol
                                            annotation (Placement(transformation(
                extent={{70,30},{76,36}}),    iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={40,-40})));

       annotation (
          Documentation(info="<html>
<pre>Heart ventricle interface.</pre>
</html>",
       revisions="<html>
<ul>
<li><i>january 2009 </i><br>by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center </li>
<li><i>2014</i><br>Marek Matejak - update to Physiolibrary 2.3.0</li>
</ul>
</html>"),Icon(coordinateSystem(preserveAspectRatio=false,extent={{-100,-100},
                {100,100}}),   graphics={Text(
                extent={{-100,-126},{100,-92}},
                textString="%name",
                lineColor={0,0,255})}));
      end IVentricle;
    end Interfaces;

    model Heart
    import Physiomodel;
       extends Physiolibrary.Icons.Heart;
    Physiolibrary.Hydraulic.Components.ElasticVessel RightAtrium(
      stateName="RightAtrium.Vol",
      useExternalPressureInput=true,
      useV0Input=true,
      useComplianceInput=false,
      volume_start=5.16454e-05,
      Compliance=9.3757696980707e-08) "right atrium"
      annotation (Placement(transformation(extent={{-75,-1},{-55,19}})));
    Physiolibrary.Types.Constants.VolumeConst RightAtriumV0(k=0)
      annotation (Placement(transformation(extent={{-84,20},{-76,28}})));
    Physiomodel.CardioVascular.Heart.Ventricle rightVentricle(
      n_Diastole=2.0,
      n_Systole=0.5,
      stateName="RightVentricle.Vol",
      BasicCompliance(displayUnit="ml/mmHg") = 2.1901798014693e-07,
      additionalPressure_Systolic(displayUnit="mmHg") = 1199.901486735,
      initialVol=8.75e-05,
      NormalEndDiastolicVolume=0.000125,
      NormalFillingPressure=95.9921189388,
      stiffnes=1,
      NormalSystolicPressure=1666.5298426875,
      NormalEndSystolicVolume=5.122e-05,
      contractilityBasic=1,
      K=1) annotation (Placement(transformation(extent={{-6,-46},{-50,-2}})));
    //    Abasic_Diastole=0.00026,
    //    Abasic_Systole=3.53,
    //    MaxContractionCompliance(displayUnit="ml/mmHg") = 1.5001231516913e-08,
    //    Cond1=60000000,
    //    Cond2=60000000,
    Physiolibrary.Hydraulic.Components.ElasticVessel LeftAtrium(
      stateName="LeftAtrium.Vol",
      useExternalPressureInput=true,
      useV0Input=true,
      volume_start=5.05035e-05,
      useComplianceInput=false,
      Compliance=4.6878848490354e-08) "left atrium"
      annotation (Placement(transformation(extent={{68,-8},{88,12}})));
    Physiolibrary.Types.Constants.VolumeConst LeftAtriumV0(k=0)
      annotation (Placement(transformation(extent={{60,12},{68,20}})));
    Physiomodel.CardioVascular.Heart.Ventricle leftVentricle(
      n_Diastole=2,
      n_Systole=0.5,
      stateName="LeftVentricle.Vol",
      BasicCompliance(displayUnit="ml/mmHg") = 1.0950899007347e-07,
      initialVol=8.75e-05,
      NormalEndDiastolicVolume=0.000125,
      NormalFillingPressure=615.9494298573,
      stiffnes=1,
      NormalSystolicPressure=12665.626804425,
      NormalEndSystolicVolume=5.087e-05,
      additionalPressure_Systolic=3199.73729796,
      contractilityBasic=1,
      K=0.016666666666667)
      annotation (Placement(transformation(extent={{26,-46},{70,-2}})));
     //   MaxContractionCompliance(displayUnit="ml/mmHg") = 3.0002463033826e-09,
       // Abasic_Diastole=0.00051,
    //    Cond1(displayUnit="ml/(mmHg.min)") = 0.0075006157584566,
    //    Cond2(displayUnit="ml/(mmHg.min)") = 0.0075006157584566,
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{-4,32},{16,52}}), iconTransformation(extent=
             {{-108,-38},{-92,-22}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a rightAtrium
      "blood inflow to right atrium" annotation (Placement(transformation(
            extent={{-102,-24},{-82,-4}}), iconTransformation(extent={{-66,30},
              {-46,50}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b fromRightVentricle
      "blood outflow to pulmonary circulation" annotation (Placement(
          transformation(extent={{-20,-12},{0,8}}), iconTransformation(extent=
             {{-48,-38},{-28,-18}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b fromLeftVentricle
      "blood outflow to aorta" annotation (Placement(transformation(extent={{2,0},{
              22,20}}),        iconTransformation(extent={{14,-38},{34,-18}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a leftAtrium
      "blood inflow to left atrium" annotation (Placement(transformation(
            extent={{84,-38},{104,-18}}),
                                        iconTransformation(extent={{34,32},{
              54,52}})));
      Modelica.Blocks.Math.Sum sum1(nin=2)
        annotation (Placement(transformation(extent={{-18,-70},{-10,-62}})));
      Modelica.Blocks.Math.Sum sum3(nin=2)
        annotation (Placement(transformation(extent={{-60,-78},{-52,-70}})));
      Modelica.Blocks.Math.Sum sum2(nin=2)
        annotation (Placement(transformation(extent={{-4,-4},{4,4}},
            rotation=180,
            origin={66,-74})));
    Physiomodel.Nerves.SA_Node SA_node
      annotation (Placement(transformation(extent={{-58,76},{-38,96}})));
      Hormones.ANP atriopeptin
        annotation (Placement(transformation(extent={{72,76},{92,96}})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
      annotation (Placement(transformation(extent={{-98,-90},{-78,-70}})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure1
      annotation (Placement(transformation(extent={{100,-88},{80,-68}})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure
      annotation (Placement(transformation(extent={{40,0},{20,20}})));
      Modelica.Blocks.Math.Add avePressure(k1=0.5, k2=0.5)
        annotation (Placement(transformation(extent={{-68,48},{-56,60}})));
      Physiomodel.Nerves.BaroReceptorAdaptation
                                   lowPressureReceptors(
        PressureChangeOnNA={{-4.0,0.0,0},{0.0,1.0,0.3},{12.0,4.0,0}},
      AdaptivePressure(displayUnit="mmHg") = 799.93432449,
      Tau(displayUnit="d") = 2592000)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={-40,54})));
      Modelica.Blocks.Math.Feedback rightAtrium_TMP
        annotation (Placement(transformation(extent={{-38,-100},{-22,-84}})));
      Modelica.Blocks.Math.Feedback leftAtrium_TMP
      annotation (Placement(transformation(extent={{52,-98},{36,-82}})));
    equation
    connect(RightAtrium.zeroPressureVolume, RightAtriumV0.y) annotation (Line(
        points={{-73,17},{-73,24},{-75,24}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(RightAtrium.q_in, rightVentricle.q_in) annotation (Line(
        points={{-65,9},{-66,8},{-32,8},{-32,-6.4},{-32.4,-6.4}},
        color={0,0,0},
        smooth=Smooth.None,
        thickness=1));
      connect(busConnector.Pericardium_Pressure,RightAtrium.externalPressure)
        annotation (Line(
          points={{6,42},{6,24},{-57,24},{-57,17}},
          color={0,0,255},
          thickness=0.1,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{110,10},{110,10}}));
      connect(busConnector,rightVentricle. busConnector)          annotation (
          Line(
          points={{6,42},{6,-37},{-28,-37},{-28,-35.88}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
    connect(LeftAtrium.zeroPressureVolume, LeftAtriumV0.y) annotation (Line(
        points={{70,10},{70,16},{69,16}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(LeftAtrium.q_in, leftVentricle.q_in) annotation (Line(
        points={{78,2},{52,2},{52,-6.4},{52.4,-6.4}},
        color={0,0,0},
        smooth=Smooth.None,
        thickness=1));
      connect(busConnector,leftVentricle. busConnector)          annotation (
          Line(
          points={{6,42},{6,-37},{48,-37},{48,-35.88}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector.Pericardium_Pressure,LeftAtrium.externalPressure)
        annotation (Line(
          points={{6,42},{6,24},{86,24},{86,10}},
          color={0,0,255},
          thickness=0.1,
          smooth=Smooth.None));
    connect(rightAtrium, RightAtrium.q_in) annotation (Line(
        points={{-92,-14},{-92,9},{-65,9}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(rightVentricle.q_out, fromRightVentricle) annotation (Line(
          points={{-23.6,-2},{-10,-2}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(LeftAtrium.q_in, leftAtrium) annotation (Line(
        points={{78,2},{94,2},{94,-28}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(RightAtriumV0.y, sum1.u[1])
                                   annotation (Line(
          points={{-75,24},{-72,24},{-72,-66},{-38,-66},{-38,-66.4},{-18.8,
            -66.4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(LeftAtriumV0.y, sum1.u[2])
                                   annotation (Line(
          points={{69,16},{70,16},{70,-58},{-28,-58},{-28,-65.6},{-18.8,-65.6}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(RightAtrium.volume, sum3.u[1]) annotation (Line(
        points={{-59,-1},{-59,-74.4},{-60.8,-74.4}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(rightVentricle.Vol, sum3.u[2]) annotation (Line(
          points={{-36.8,-32.8},{-66,-32.8},{-66,-73.6},{-60.8,-73.6}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(LeftAtrium.volume, sum2.u[1]) annotation (Line(
        points={{84,-8},{84,-73.6},{70.8,-73.6}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(leftVentricle.Vol, sum2.u[2]) annotation (Line(
          points={{56.8,-32.8},{56.8,-32},{76,-32},{76,-74.4},{70.8,-74.4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(sum3.y, busConnector.Heart_DeoxygenatedBloodVolume) annotation (
         Line(
          points={{-51.6,-74},{6,-74},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(busConnector.Heart_OxygenatedBloodVolume, sum2.y) annotation (
          Line(
          points={{6,42},{6,-74},{61.6,-74}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(sum1.y, busConnector.Heart_V0) annotation (Line(
          points={{-9.6,-66},{6,-66},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(SA_node.Rate, busConnector.HeartVentricleRate) annotation (Line(
          points={{-38.2,86},{6,86},{6,44},{6,44},{6,42},{6,42}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(busConnector.BetaPool_Effect,SA_node. BetaPool_Effect)
        annotation (Line(
          points={{6,42},{6,76},{-96,76},{-96,92},{-58,92}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.BetaBlocade_Effect,SA_node. BetaBlockade_Effect)
        annotation (Line(
          points={{6,42},{6,76},{-96,76},{-96,88},{-58,88}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.VagusNerve_NA_Hz, SA_node.VagusNerve_NA_Hz)
        annotation (Line(
          points={{6,42},{6,76},{-96,76},{-96,80},{-58,80}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.GangliaGeneral_NA, SA_node.GangliaGeneral_NA)
        annotation (Line(
          points={{6,42},{6,76},{-96,76},{-96,84},{-58,84}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector,atriopeptin. busConnector)
                                              annotation (Line(
          points={{6,42},{6,76},{74,76},{74,80}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
    connect(RightAtrium.q_in, pressureMeasure.q_in) annotation (Line(
        points={{-65,9},{-92,9},{-92,-86}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pressureMeasure.pressure, busConnector.RightAtrium_Pressure)
      annotation (Line(
        points={{-82,-84},{6,-84},{6,42}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(LeftAtrium.q_in, pressureMeasure1.q_in) annotation (Line(
        points={{78,2},{94,2},{94,-84}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pressureMeasure1.pressure, busConnector.LeftAtrium_Pressure)
      annotation (Line(
        points={{84,-82},{6,-82},{6,42}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(flowMeasure.q_out, fromLeftVentricle) annotation (Line(
        points={{20,10},{12,10}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(leftVentricle.q_out, flowMeasure.q_in) annotation (Line(
        points={{43.6,-2},{43.6,10},{40,10}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(flowMeasure.volumeFlow, busConnector.CardiacOutput) annotation (
        Line(
        points={{30,22},{30,2},{6,2},{6,42}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
      connect(avePressure.y,lowPressureReceptors. pressure) annotation (Line(
          points={{-55.4,54},{-50,54}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.rightAtrium_TMP,avePressure. u1) annotation (Line(
          points={{6,42},{-98,42},{-98,57.6},{-69.2,57.6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.leftAtrium_TMP,avePressure. u2) annotation (Line(
          points={{6,42},{-98,42},{-98,50.4},{-69.2,50.4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
    connect(lowPressureReceptors.NA, busConnector.AtrialLowPressureReceptors_NA)
      annotation (Line(
        points={{-30,54},{6,54},{6,42}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(rightAtrium_TMP.y, busConnector.rightAtrium_TMP) annotation (Line(
        points={{-22.8,-92},{6,-92},{6,42},{6,42}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(RightAtrium.externalPressure, rightAtrium_TMP.u2) annotation (
        Line(
        points={{-57,17},{-57,-98.4},{-30,-98.4}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(pressureMeasure.pressure, rightAtrium_TMP.u1) annotation (Line(
        points={{-82,-84},{-64,-84},{-64,-92},{-36.4,-92}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(pressureMeasure1.pressure, leftAtrium_TMP.u1) annotation (Line(
        points={{84,-82},{68,-82},{68,-90},{50.4,-90}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(LeftAtrium.externalPressure, leftAtrium_TMP.u2) annotation (Line(
        points={{86,10},{86,-98},{44,-98},{44,-96.4}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(busConnector.leftAtrium_TMP, leftAtrium_TMP.y) annotation (Line(
        points={{6,42},{6,-90},{36.8,-90}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      annotation ( Icon(coordinateSystem(
              preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
            graphics={                Text(
              extent={{-164,-60},{156,-88}},
              lineColor={0,0,255},
              textString="%name")}),
        Documentation(info="<html>
<p>Calculates hearth pumping (left and right atria and ventricles, as wel as coronary circulation). By pressure-flow connectors communicate with pulmonary and systemic circulation.</p>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>right/left atrium and</li>
<li>right/left ventricle.</li>
</ul></p>
<p>Generate average blood flow throught ventricles.</p>
<p>On the contrary of Tom Coleman models: coronary circulation outflows to right atrium, average blood volume in the hearth are calculated more simple (with the same results in steady state).</p>
</html>",
        revisions="<html>

<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td><p>Marek Matejak</p></td>
</tr>
<tr>
<td><p>Design:</p></td>
<td><p>Zuzana Rubaninska</p></td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>january 2009, August 2010</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td><p>Tom Coleman: QHP 2008 beta 3,, Physiomodel 2010, University of Mississippi Medical Center</p></td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
    end Heart;

    model Ventricle
      import Physiomodel;
     extends Physiomodel.CardioVascular.Heart.Interfaces.IVentricle;

     parameter String stateName;

    Physiolibrary.Types.Constants.FractionConst
      basicContractility(k=contractilityBasic)
      annotation (Placement(transformation(extent={{60,6},{68,14}})));

      Physiomodel.Nerves.BetaReceptorsActivityFactor betaReceptorsActivityFactor
        annotation (Placement(transformation(extent={{64,-20},{84,0}})));

      Modelica.Blocks.Math.Add Vol_SteadyState(k1=0.5, k2=0.5)
                                                 annotation (Placement(
            transformation(
            extent={{10,-10},{-10,10}},
            rotation=270,
            origin={-34,18})));

    Physiomodel.CardioVascular.Heart.Diastole diastole(
      stiffnes=stiffnes,
      n_Diastole=n_Diastole,
      NormalFillingPressure=NormalFillingPressure,
      NormalEndDiastolicVolume=NormalEndDiastolicVolume,
      NormalExternalPressure(displayUnit="Pa") = NormalExternalPressure)
      annotation (Placement(transformation(extent={{-76,-44},{-56,-24}})));
    //    ,Abasic_Diastole=Abasic_Diastole

      Systole systole(
        n_Systole=n_Systole,
        additionalPressure_Systolic=additionalPressure_Systolic,
        NormalSystolicPressure=NormalSystolicPressure,
        NormalEndSystolicVolume=NormalEndSystolicVolume,
      NormalExternalPressure=NormalExternalPressure)
        annotation (Placement(transformation(extent={{52,-44},{72,-24}})));
     //   Abasic_Systole=Abasic_Systole,

      Modelica.Blocks.Math.Feedback StrokeVolume
        annotation (Placement(transformation(extent={{-10,-10},{10,10}},
            origin={-8,-6})));

      VentricleVolumeAndPumping2 ventricle(
        initialVolume=initialVol,
        K=K,
        BasicCompliance=BasicCompliance,
        stateName=stateName)
               annotation (Placement(transformation(extent={{-8,70},{12,90}})));

      Modelica.Blocks.Math.Product BloodFlow     annotation (Placement(
            transformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={16,40})));

    equation
      connect(basicContractility.y, betaReceptorsActivityFactor.yBase)
                                                             annotation (Line(
          points={{69,10},{74,10},{74,-3}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.BetaPool_Effect, betaReceptorsActivityFactor.BetaPool_Effect)
        annotation (Line(
          points={{22,2},{22,-4},{64.2,-4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.BetaBlocade_Effect, betaReceptorsActivityFactor.BetaBlockade_Effect)
        annotation (Line(
          points={{22,2},{22,-10},{64.2,-10}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.GangliaGeneral_NA, betaReceptorsActivityFactor.GangliaGeneral_NA)
        annotation (Line(
          points={{22,2},{22,-16},{64.2,-16}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(diastole.externalPressure, busConnector.Pericardium_Pressure)
        annotation (Line(
          points={{-56,-40},{22,-40},{22,2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(busConnector.Pericardium_Pressure, systole.externalPressure)
        annotation (Line(
          points={{22,2},{22,-40},{52,-40}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(betaReceptorsActivityFactor.y, systole.contractility)
        annotation (Line(
          points={{74,-17},{74,-24},{70,-24}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(diastole.EDV,StrokeVolume. u1) annotation (Line(
          points={{-56,-26},{-40,-26},{-40,-6},{-16,-6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Vol_SteadyState.u2, diastole.EDV) annotation (Line(
          points={{-40,6},{-40,-26},{-56,-26}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(systole.outflow, q_out) annotation (Line(
          points={{72,-30},{86,-30},{86,-100},{0,-100}},
          color={0,0,0},
          smooth=Smooth.None));
      connect(q_in, diastole.inflow) annotation (Line(
          points={{0,-100},{-82,-100},{-82,-30},{-76,-30}},
          color={0,0,0},
          smooth=Smooth.None));
      connect(systole.ESV, Vol_SteadyState.u1) annotation (Line(
          points={{52,-26},{-28,-26},{-28,6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(systole.ESV,StrokeVolume. u2) annotation (Line(
          points={{52,-26},{-8,-26},{-8,-14}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Vol_SteadyState.y, ventricle.VentricleSteadyStateVolume)
        annotation (Line(
          points={{-34,29},{-34,58},{-6,58},{-6,70}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(q_in, ventricle.q_in)                 annotation (Line(
          points={{0,-100},{-4,-100},{-4,80},{-8,80}},
          color={0,0,0},
          smooth=Smooth.None));
      connect(ventricle.q_out, q_out)                 annotation (Line(
          points={{12,80},{6,80},{6,-100},{0,-100}},
          color={0,0,0},
          smooth=Smooth.None));
      connect(StrokeVolume.y, BloodFlow.u1)     annotation (Line(
          points={{1,-6},{10,-6},{10,28}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(BloodFlow.y, ventricle.BloodFlow)                 annotation (Line(
          points={{16,51},{16,58},{10,58},{10,70}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(ventricle.Volume, Vol)                 annotation (Line(
          points={{12.4,75},{62,75},{62,33},{73,33}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(BloodFlow.u2, busConnector.HeartVentricleRate)
        annotation (Line(
          points={{22,28},{22,2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));

     annotation (
        Documentation(info="<HTML>
<PRE>
Heart ventricle.

like
QHP 2008 / VascularCompartments/LeftVentricle/*



The pressure-volume characteristics of both ventricles in diastole
and systole will be described using a power function.

  P = A * (V ^ n)

P = Pressure
V = Volume
A = Scale Factor
n = curvature

The function is invertable.

  V = (P/A) ^ (1/n)

Some typical values

                                 Right                 Left
                           ---------------------- ------------------------
Nominal Vol                     87.5                  87.5
Nominal TMP                      3.0                   6.0
Compliance                      29.2                  14.6
Pericardial P                   -3.0                  -3.0

DIASTOLE
  EDP                            1.0                   5.0
  EDV                          125.0                 125.0
  TMP                            4.0                   8.0
  n                              2.0                   2.0
  V^n                        15625.0               15625.0
  A                              0.00026               0.00051

SYSTOLE
  ESP                           22.0                 120.0
  ESV                           50.0                  50.0
  TMP                           25.0                 123.0
  n                              0.5                   0.5
  V^n                            7.07                  7.07
  A                              3.53                 17.39
</PRE>
</HTML>
",   revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague. </p><br/>

</html>"),                                      Diagram(coordinateSystem(preserveAspectRatio=false,
                       extent={{-100,-100},{100,100}}), graphics={Text(
              extent={{-32,62},{-8,60}},
              lineColor={0,0,0},
              textString="Volume_SteadyState"), Text(
              extent={{8,62},{32,60}},
              lineColor={0,0,0},
              textString="Blood_Inflow")}));
    end Ventricle;

    model Systole

    //  Real iconPoint[20,2](each final displayUnit="mm");
    //  Real iconActualPoint[2,2](each final displayUnit="mm");

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b outflow annotation (
        Placement(transformation(extent={{80,20},{120,60}}),
          iconTransformation(extent={{80,20},{120,60}})));

      Physiolibrary.Types.RealIO.FractionInput contractility
      "heart muscle contractility"   annotation ( extent = [70,90;90,110], rotation = -90,
      Placement(transformation(
          origin={80,100},
          extent={{-10,-10},{10,10}},
          rotation=270)));

    parameter Physiolibrary.Types.Fraction n_Systole(displayUnit="1")
      "parametrization of end diastolic volume curve";
    //parameter Real Abasic_Systole "parametrization of end systolic volume curve";
    parameter Physiolibrary.Types.Pressure NormalSystolicPressure
      "Typical value of mean arterial pressure (relative to environment ambient pressure)";
        parameter Physiolibrary.Types.Pressure NormalExternalPressure = -446
      "Typical value of pericardium cavity pressure (relative to environment ambient pressure)";
                                                                             //-446 Pa = -3.34522 mmHg
    parameter Physiolibrary.Types.Volume NormalEndSystolicVolume
      "= 2.64 ml for left ventricle, parametrization of end systolic volume curve";
    parameter Physiolibrary.Types.Pressure additionalPressure_Systolic
      "parametrization of end systolic volume curve";

      Physiolibrary.Types.RealIO.VolumeOutput
                                          ESV   annotation (Placement(transformation(extent={{-74,-74},
                {-34,-34}}), iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={-100,80})));

      Physiolibrary.Types.RealIO.PressureInput externalPressure
      "pressure around ventricle"                                             annotation (
    Placement(transformation(extent={{-110,-70},{-90,-50}}), iconTransformation(
              extent={{-110,-70},{-90,-50}})));
    equation
      outflow.q = 0;
    //  P=outflow.pressure;
    //  ESV = ((outflow.pressure+additionalPressure_Systolic-externalPressure)/(contractility*Abasic_Systole))^(1/n_Systole);
      ESV = NormalEndSystolicVolume*((outflow.pressure+additionalPressure_Systolic-externalPressure)/(contractility*(NormalSystolicPressure+additionalPressure_Systolic-NormalExternalPressure)))^(1/n_Systole);

    // drawing icon
    /*  for i in 1:size(iconPoint,1) loop
    iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
    (iconPoint[i,1]+90)*200/180= ((((iconPoint[i,2]+40)*200/130)+additionalPressure_Systolic-externalPressure)/(contractility*Abasic_Systole))^(1/n_Systole);
  end for;
  iconActualPoint[1,1]=ESV*180/200-90 -2;
  iconActualPoint[1,2]=outflow.pressure*130/200-40 -2;
  iconActualPoint[2,1]=iconActualPoint[1,1]+4;
  iconActualPoint[2,2]=iconActualPoint[1,2]+4;*/
                                 /*,
        Line(
          points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
          color={0,0,255},
          smooth=Smooth.None),
        Ellipse(
          extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
          lineColor={0,0,0},
          fillColor={255,0,0},
          fillPattern=FillPattern.Solid)*/
      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,100},{100,-60}},
              lineColor={255,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={255,255,255}),
            Text(
              extent={{-100,-60},{100,-100}},
              lineColor={0,0,255},
              textString="%name")}));
    end Systole;

    model Diastole
    /*  Real iconPoint[20,2](final displayUnit="mm");
  Real iconActualPoint[2,2](final displayUnit="mm");
*/
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a inflow annotation (
        Placement(transformation(extent={{-122,-24},{-82,16}}),
          iconTransformation(extent={{-120,20},{-80,60}})));

      Physiolibrary.Types.RealIO.PressureInput externalPressure
      "pericardium pressure around ventricle"
                                     annotation ( Placement(transformation(extent={{94,-58},
                {114,-38}}), iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=180,
            origin={100,-60})));

    parameter Physiolibrary.Types.Fraction stiffnes
      "parametrization of end diastolic volume curve";
    parameter Physiolibrary.Types.Fraction n_Diastole(displayUnit="1")
      "parametrization of end systolic volume curve";
    //parameter Real Abasic_Diastole "parametrization of end diastolic volume curve";
    parameter Physiolibrary.Types.Pressure NormalFillingPressure
      "Typicall value of mean arterial filling pressure (relative to environment ambient pressure)";
    parameter Physiolibrary.Types.Pressure NormalExternalPressure = -446
      "Typical value of pericardium cavity pressure (relative to environment ambient pressure)";
    parameter Physiolibrary.Types.Volume NormalEndDiastolicVolume
      "= (NormalDiastolicPressure/Abasic_Diastole)^n_Diastole";
    //Abasic_Diastole "parametrization of end diastolic volume curve";

      Physiolibrary.Types.RealIO.VolumeOutput
                                          EDV   annotation (Placement(transformation(extent={{-74,-74},
                {-34,-34}}), iconTransformation(
            extent={{-10,-10},{10,10}},
            origin={100,80})));

    equation
      inflow.q = 0;
    //  P = inflow.pressure;
    //  EDV = ((inflow.pressure-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
      EDV = NormalEndDiastolicVolume*((inflow.pressure-externalPressure)/(stiffnes*(NormalFillingPressure-NormalExternalPressure)))^(1/n_Diastole);

      //  Stiffness = stiffnes;

    // drawing icon
    /*  for i in 1:size(iconPoint,1) loop
    iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
    (iconPoint[i,1]+90)*200/180 = ( ( ( (iconPoint[i,2]+40)*200/130)-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
  end for;
  iconActualPoint[1,1]=EDV*180/200-90 -2;
  iconActualPoint[1,2]=inflow.pressure*130/200-40 -2;
  iconActualPoint[2,1]=iconActualPoint[1,1]+4;
  iconActualPoint[2,2]=iconActualPoint[1,2]+4;*/
                                 /*,
        Line(
          points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
          color={0,0,255},
          smooth=Smooth.None),
        Ellipse(
          extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
          lineColor={0,0,0},
          fillColor={255,0,0},
          fillPattern=FillPattern.Solid)*/
      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}), graphics={
            Rectangle(
              extent={{-100,100},{100,-60}},
              lineColor={255,0,0},
              fillPattern=FillPattern.HorizontalCylinder,
              fillColor={255,255,255}),
            Text(
              extent={{-100,-60},{100,-100}},
              lineColor={0,0,255},
              textString="%name")}));
    end Diastole;

      model VentricleVolumeAndPumping2
      "Multiple PressureFlow connector with pressures from multiple inputs"
                 extends Physiolibrary.SteadyStates.Interfaces.SteadyState(state_start=initialVolume, state(nominal=1e-4));

                  Physiolibrary.Types.RealIO.VolumeFlowRateInput BloodFlow( displayUnit=
                       "ml/min") "heart cardiac output"
                    annotation (Placement(transformation(extent={{-140,-20},{-100,20}}), iconTransformation(extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={80,-100})));
                  Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
                  Placement(transformation(extent={{100,-20},{140,20}}),
                    iconTransformation(extent={{-110,-10},{-90,10}})));

                  parameter Physiolibrary.Types.Volume initialVolume(displayUnit="ml");

                  Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out annotation (
                  extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,10}})));

                  Physiolibrary.Types.VolumeFlowRate delta(displayUnit="ml/min");

                   Physiolibrary.Types.RealIO.VolumeInput VentricleSteadyStateVolume(
                                                                           displayUnit="ml")
      "heart ventricle steady state volume"
                    annotation (Placement(transformation(extent={{-140,-20},{-100,20}}), iconTransformation(extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={-80,-100})));

                  parameter Physiolibrary.Types.Frequency K( displayUnit="1/min") = 0.01666666666666666666666666666667;
                  parameter Physiolibrary.Types.Volume V0( displayUnit="ml") = 0;
                  parameter Physiolibrary.Types.HydraulicCompliance BasicCompliance(displayUnit="ml/mmHg");
                  Physiolibrary.Types.RealIO.VolumeOutput Volume(
                                                        start=initialVolume, displayUnit="ml") annotation (Placement(transformation(
                          extent={{84,-70},{124,-30}}), iconTransformation(extent={{84,-70},{
                            124,-30}})));

                //  Real Compliance(final quantity="Compliance", final displayUnit="ml/mmHg");
                //  Real StressedVol(final quantity="Volume", final displayUnit="ml");
                //  Real Pressure(final quantity="Pressure", final displayUnit="mmHg");
                //initial equation
                //  Volume = initialVolume;
                  //der(Volume) = 0;
      equation

                  delta = (VentricleSteadyStateVolume - Volume)*K;
                /*  if STEADY then
    der(Volume) = 0;
  else
    der(Volume) = delta / Library.SecPerMin;
  end if;
*/
                  q_in.q + q_out.q = delta;

                if Simulation == Physiolibrary.Types.SimulationType.SteadyState then //Physiolibrary.SimulationType.STEADY then
                  q_in.q = BloodFlow;
                else
                  q_in.q = if (delta<0) then BloodFlow else BloodFlow+delta;
                end if;

                  //increase (delta>0) average ventricle volume means flow delta from q_in (veins)
                  //decrease (delta<0) average ventricle volume means flow delta to q_to (atrys)

                 // StressedVol  =  max( Volume - V0,  0.0);
                 // Compliance  =  BasicCompliance / VentricleDiastole_Stiffness;
                 // Pressure  =  ( StressedVol / Compliance)  + ExternalPressure;

                  state = Volume;
                  change = delta;
                  annotation (Documentation(info="<HTML>
<p>
Model has a vector of continuous Real input signals as pressures for
vector of pressure-flow connectors.
</p>
</HTML>
"));
      end VentricleVolumeAndPumping2;

    package develop
    extends Modelica.Icons.UnderConstruction;
      model Ventricle4
       extends Physiomodel.CardioVascular2.Heart.Interfaces.IVentricle;

       parameter String stateName;

      Physiolibrary.Types.Constants.DeprecatedUntypedConstant
        basicContractility(k=contractilityBasic)
        annotation (Placement(transformation(extent={{60,2},{68,10}})));

        Physiomodel.Nerves.BetaReceptorsActivityFactor betaReceptorsActivityFactor
          annotation (Placement(transformation(extent={{64,-20},{84,0}})));

        Modelica.Blocks.Math.Add Vol_SteadyState(k1=0.5, k2=0.5)
                                                   annotation (Placement(
              transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-34,18})));

      Diastole4 diastole(
        stiffnes=stiffnes,
        n_Diastole=n_Diastole,
        Abasic_Diastole=Abasic_Diastole) annotation (Placement(
            transformation(extent={{-76,-44},{-56,-24}})));

        Systole systole(
          n_Systole=n_Systole,
          Abasic_Systole=Abasic_Systole,
          additionalPressure_Systolic=additionalPressure_Systolic)
          annotation (Placement(transformation(extent={{56,-44},{76,-24}})));

        Modelica.Blocks.Math.Feedback StrokeVolume
          annotation (Placement(transformation(extent={{-10,-10},{10,10}},
              origin={-8,-6})));

        VentricleVolumeAndPumping2 ventricle(
          initialVolume=initialVol,
          K=K,
          BasicCompliance=BasicCompliance,
          stateName=stateName)
                 annotation (Placement(transformation(extent={{-8,66},{12,86}})));

        Modelica.Blocks.Math.Product BloodFlow     annotation (Placement(
              transformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={16,40})));

      equation
        connect(basicContractility.y, betaReceptorsActivityFactor.yBase)
                                                               annotation (Line(
            points={{69,6},{74,6},{74,-3}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.BetaPool_Effect, betaReceptorsActivityFactor.BetaPool_Effect)
          annotation (Line(
            points={{22,2},{22,-4},{64.2,-4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.BetaBlocade_Effect, betaReceptorsActivityFactor.BetaBlockade_Effect)
          annotation (Line(
            points={{22,2},{22,-10},{64.2,-10}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, betaReceptorsActivityFactor.GangliaGeneral_NA)
          annotation (Line(
            points={{22,2},{22,-16},{64.2,-16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(diastole.externalPressure, busConnector.Pericardium_Pressure)
          annotation (Line(
            points={{-56,-40},{22,-40},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.Pericardium_Pressure, systole.externalPressure)
          annotation (Line(
            points={{22,2},{22,-40},{56,-40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(betaReceptorsActivityFactor.y, systole.contractility)
          annotation (Line(
            points={{74,-17},{74,-24}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(diastole.EDV,StrokeVolume. u1) annotation (Line(
            points={{-56,-26},{-40,-26},{-40,-6},{-16,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vol_SteadyState.u2, diastole.EDV) annotation (Line(
            points={{-40,6},{-40,-26},{-56,-26}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systole.outflow, q_out) annotation (Line(
            points={{76,-30},{86,-30},{86,80},{80,80}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(q_in, diastole.inflow) annotation (Line(
            points={{-80,80},{-82,80},{-82,-30},{-76,-30}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(systole.ESV, Vol_SteadyState.u1) annotation (Line(
            points={{56,-26},{-28,-26},{-28,6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systole.ESV,StrokeVolume. u2) annotation (Line(
            points={{56,-26},{-8,-26},{-8,-14}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vol_SteadyState.y, ventricle.VentricleSteadyStateVolume)
          annotation (Line(
            points={{-34,29},{-34,58},{-6,58},{-6,66}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(q_in, ventricle.q_in)                 annotation (Line(
            points={{-80,80},{-54,80},{-54,76},{-8,76}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(ventricle.q_out, q_out)                 annotation (Line(
            points={{12,76},{56,76},{56,80},{80,80}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(StrokeVolume.y, BloodFlow.u1)     annotation (Line(
            points={{1,-6},{10,-6},{10,28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BloodFlow.y, ventricle.BloodFlow)                 annotation (Line(
            points={{16,51},{16,58},{10,58},{10,66}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ventricle.Volume, Vol)                 annotation (Line(
            points={{12.4,71},{14.7,71},{14.7,33},{73,33}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BloodFlow.u2, busConnector.HeartVentricleRate)
          annotation (Line(
            points={{22,28},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(BloodFlow.y, CO) annotation (Line(
            points={{16,51},{16,59},{77,59}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(diastole.HR, busConnector.HeartVentricleRate) annotation (
            Line(
            points={{-56,-33.2},{22,-33.2},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(systole.ESV, diastole.preESV) annotation (Line(
            points={{56,-26},{-28,-26},{-28,-29.2},{-56,-29.2}},
            color={0,0,127},
            smooth=Smooth.None));
       annotation (
          Documentation(info="<HTML>
<PRE>
Heart ventricle.

like
QHP 2008 / VascularCompartments/LeftVentricle/*


The pressure-volume characteristics of both ventricles in diastole
and systole will be described using a power function.

  P = A * (V ^ n)

P = Pressure
V = Volume
A = Scale Factor
n = curvature

The function is invertable.

  V = (P/A) ^ (1/n)

Some typical values

                                 Right                 Left
                           ---------------------- ------------------------
Nominal Vol                     87.5                  87.5
Nominal TMP                      3.0                   6.0
Compliance                      29.2                  14.6
Pericardial P                   -3.0                  -3.0

DIASTOLE
  EDP                            1.0                   5.0
  EDV                          125.0                 125.0
  TMP                            4.0                   8.0
  n                              2.0                   2.0
  V^n                        15625.0               15625.0
  A                              0.00026               0.00051

SYSTOLE
  ESP                           22.0                 120.0
  ESV                           50.0                  50.0
  TMP                           25.0                 123.0
  n                              0.5                   0.5
  V^n                            7.07                  7.07
  A                              3.53                 17.39
</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={Text(
                extent={{-82,6},{76,-8}},
                lineColor={0,0,255},
                textString="(initial %initialVol ml)")}),
                                        Diagram(coordinateSystem(preserveAspectRatio=true,
                         extent={{-100,-100},{100,100}}), graphics={Text(
                extent={{-32,62},{-8,60}},
                lineColor={0,0,0},
                textString="Volume_SteadyState"), Text(
                extent={{8,62},{32,60}},
                lineColor={0,0,0},
                textString="Blood_Inflow")}));
      end Ventricle4;

      model Diastole4
        Real iconPoint[20,2](final displayUnit="mm");
        Real iconActualPoint[2,2](final displayUnit="mm");

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a inflow annotation (
          Placement(transformation(extent={{-122,-24},{-82,16}}),
            iconTransformation(extent={{-120,20},{-80,60}})));

        Modelica.Blocks.Interfaces.RealInput externalPressure(final quantity=
              "Pressure", final displayUnit="mmHg")
        "pericardium pressure around ventricle"
                                       annotation ( Placement(transformation(extent={{94,-58},
                  {114,-38}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={100,-60})));

      parameter Real stiffnes "parametrization of end diastolic volume curve";
      parameter Real n_Diastole
        "parametrization of end systolic volume curve";
      parameter Real Abasic_Diastole
        "parametrization of end diastolic volume curve";

        Modelica.Blocks.Interfaces.RealOutput
                                            EDV( final quantity="Volume",
            final displayUnit="ml")   annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              origin={100,80})));

        Modelica.Blocks.Interfaces.RealOutput P(final quantity="Pressure",
            final displayUnit="mmHg") annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=270,
              origin={60,-60})));
        Modelica.Blocks.Interfaces.RealOutput Stiffness
                               annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={-68,100})));
        Modelica.Blocks.Interfaces.RealInput HR(final quantity="Frequency", final displayUnit=
                 "1/min") "heart rate" annotation ( Placement(transformation(extent={{94,-58},
                  {114,-38}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={100,8})));
        Real HR_effect;
        Real EDV_withoutHReffect;

        Modelica.Blocks.Interfaces.RealInput preESV(final quantity="Volume", final displayUnit=
                 "ml") "previous end systolic volume"
                                       annotation ( Placement(transformation(extent={{94,-58},
                  {114,-38}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={100,48})));
      equation
        inflow.q = 0;
        P = inflow.pressure;
        //linearna zavislost na HR - vid. mathematica/Efect_EDVonHR.nb
        HR_effect = -0.00247654 * HR + 1.18574; //  1 = a*75+b;

        EDV_withoutHReffect = (((inflow.pressure-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole));
        EDV = HR_effect * (EDV_withoutHReffect-preESV) + preESV;
        Stiffness = stiffnes;

      // drawing icon
        for i in 1:size(iconPoint,1) loop
          iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
          (iconPoint[i,1]+90)*200/180 = ( ( ( (iconPoint[i,2]+40)*200/130)-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
        end for;
        iconActualPoint[1,1]=EDV*180/200-90 -2;
        iconActualPoint[1,2]=inflow.pressure*130/200-40 -2;
        iconActualPoint[2,1]=iconActualPoint[1,1]+4;
        iconActualPoint[2,2]=iconActualPoint[1,2]+4;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-60}},
                lineColor={255,0,0},
                fillPattern=FillPattern.HorizontalCylinder,
                fillColor={255,255,255}),
              Text(
                extent={{-100,-60},{100,-100}},
                lineColor={0,0,255},
                textString="%name"),
              Line(
                points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
                color={0,0,255},
                smooth=Smooth.None),
              Ellipse(
                extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
                lineColor={0,0,0},
                fillColor={255,0,0},
                fillPattern=FillPattern.Solid)}),
          Documentation(info="<html>
<p>The relationship heart rate(HR)-end diastolic volume(EDV) is represented by linear function -0.00247654 HR + 1.18574.</p>
<p>The coeficients was choosen to solve normal state and critical zero state: (Solve[{a*75 + b == 1, a*HR + b == 0, diastoleTime[HR] == 0}, {a, b}]).</p>
<p>It means the next ventricle filling model:</p>
<p>cardiac cycle time (T) = (60/HR) [s]</p>
<p>systolic contraction time (Ts) = (0.3*T^0.5) [s]</p>
<p>diastolic filling time (Tdf) = T - Ts - 0.18*Ts [s]</p>
<p>steady-state filling curve:</p>
<p><img src=\"C:/Users/oto/Desktop/Physiomodel/mathematicaGUI/Effect_EDVonHR.png\"/></p>
<p>axes x .. filling time = Tdf [s]</p>
<p>axes y .. entered volume part = stroke volume (SV)/normal_SV [x 100 &percnt;]</p>
<p><br/>EDV = SV + pre(ESV) = effect(HR) * ((EDV_without_HR_effect - pre(ESV)) + pre(ESV)</p>
</html>"));
      end Diastole4;

      model Ventricle2
       extends Physiomodel.CardioVascular2.Heart.Interfaces.IVentricle;

       extends Physiolibrary.SteadyStates.Interfaces.SteadyState;

      type VentriclePhase = enumeration(
            ISOVOLUMIC_CONTRACTION,
            EJECTION,
            ISOVOLUMIC_RELAXATION,
            FILLING);
        VentriclePhase state(start=VentriclePhase.ISOVOLUMIC_CONTRACTION);
      //  Real Power;
        Real P(start=80,fixed=true);
        Real V(start=126,fixed=true);
        Boolean b(start=false); //b[VentriclePhase](start={false,false,false,false});
        Boolean c;
      /*  Library.PressureFlow.PositivePressureFlow q_in annotation (Placement(transformation(
          extent={{-106,-30},{-86,-10}}), iconTransformation(extent={{-27,58},{-7,
            78}})));
  Library.PressureFlow.NegativePressureFlow q_out annotation (Placement(transformation(
          extent={{86,-30},{106,-10}}), iconTransformation(extent={{10,72},{30,92}})));
*/
          Modelica.Blocks.Interfaces.RealInput
                                             PrevCirculationPower
                                           annotation (Placement(transformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-10,80}), iconTransformation(extent={{-100,50},{-80,70}})));
        //Library.Interfaces.RealInput
        Modelica.Blocks.Interfaces.RealOutput
                                            HeartMusclePower
                         annotation (Placement(transformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-10,80}), iconTransformation(extent={{-100,70},{-80,90}})));
        Modelica.Blocks.Interfaces.RealInput
                                           NextCirculationPower
                                           annotation (Placement(transformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-10,80}), iconTransformation(extent={{-100,30},{-80,50}})));
        Modelica.Blocks.Interfaces.RealInput
                                           Power     annotation (Placement(transformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-10,80}), iconTransformation(extent={{-100,10},{-80,30}})));
      equation
      /*
  b[VentriclePhase.ISOVOLUMIC_CONTRACTION]= P>=q_out.pressure; //reach true when ventricle outflow valve open
  b[VentriclePhase.EJECTION]= q_out.q>=0; //reach true when ventricle outflow valve close
  b[VentriclePhase.ISOVOLUMIC_RELAXATION]= P<=q_in.pressure; //reach true when atrium-ventricle valve open
  b[VentriclePhase.FILLING]= q_in.q<=0; //reach true when atrium-ventricle valve close

  when edge(b[pre(state)]) then
    */
        c = pre(b);
        when edge(c) then
          state=mod(pre(state)+1,4);
        end when;

        Power=der(P)*V + der(V)*P;  //=der(V*P)

      //  der(V)= q_out.q + q_in.q;
      state = V;
        changePerMin = q_out.q + q_in.q;

        if state==VentriclePhase.ISOVOLUMIC_CONTRACTION then
          Power=HeartMusclePower;
          q_in.q=0;
          q_out.q=0;
          b = P>=q_out.pressure; //reach true when ventricle outflow valve open
        elseif state==VentriclePhase.EJECTION then
          Power=HeartMusclePower;//-NextCirculationPower;
          q_in.q=0;
          P=q_out.pressure;
          b = q_out.q>=0; //reach true when ventricle outflow valve close
        elseif state==VentriclePhase.ISOVOLUMIC_RELAXATION then
          Power=HeartMusclePower;
          q_in.q=0;
          q_out.q=0;
          b = P<=q_in.pressure; //reach true when atrium-ventricle valve open
        else //filling
          Power=HeartMusclePower; //-PrevCirculationPower;
          P=q_in.pressure;
          q_out.q=0;
          b = q_in.q<=0; //reach true when atrium-ventricle valve close
        end if;

        CO=-q_out.q;
        Vol = V;

      end Ventricle2;

      model Diastole3
      /*  Real iconPoint[20,2](each final displayUnit="mm");
  Real iconActualPoint[2,2](each final displayUnit="mm");
  */

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a inflow annotation (
          Placement(transformation(extent={{-122,-24},{-82,16}}),
            iconTransformation(extent={{-120,20},{-80,60}})));

        Physiolibrary.Types.RealIO.PressureInput externalPressure
        "pericardium pressure around ventricle"
                                       annotation ( Placement(transformation(extent={{94,-58},
                  {114,-38}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={100,-60})));

      parameter Physiolibrary.Types.Fraction stiffnes
        "parametrization of end diastolic volume curve";
      parameter Physiolibrary.Types.Fraction n_Diastole
        "parametrization of end systolic volume curve";
      parameter Real Abasic_Diastole
        "parametrization of end diastolic volume curve";

        Physiolibrary.Types.RealIO.VolumeOutput
                                            EDV   annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              origin={100,80})));

        Physiolibrary.Types.RealIO.PressureOutput P annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=270,
              origin={60,-60})));
        Physiolibrary.Types.RealIO.FractionOutput Stiffness
                               annotation (Placement(transformation(extent={{-74,-74},
                  {-34,-34}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={-68,100})));
        Physiolibrary.Types.RealIO.FrequencyInput HR "heart rate" annotation ( Placement(transformation(extent={{94,-58},
                  {114,-38}}), iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={100,8})));
        Physiolibrary.Types.Fraction HR_effect;
        Physiolibrary.Types.Time a;
        Physiolibrary.Types.Fraction  b;
      equation
        inflow.q = 0;
        P = inflow.pressure;
        //linearna zavislost na HR - vid. mathematica/Efect_EDVonHR.nb
        HR_effect = a*HR+b;
        1 = a*75+b;
        0.52 = a*200+b;

        EDV = (((inflow.pressure-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole))*HR_effect;
        Stiffness = stiffnes;

      // drawing icon
      /*  for i in 1:size(iconPoint,1) loop
    iconPoint[i,1]=((i-1)/(size(iconPoint,1)))*180 - 90;
    (iconPoint[i,1]+90)*200/180 = ( ( ( (iconPoint[i,2]+40)*200/130)-externalPressure)/(stiffnes*Abasic_Diastole))^(1/n_Diastole);
  end for;
  iconActualPoint[1,1]=EDV*180/200-90 -2;
  iconActualPoint[1,2]=inflow.pressure*130/200-40 -2;
  iconActualPoint[2,1]=iconActualPoint[1,1]+4;
  iconActualPoint[2,2]=iconActualPoint[1,2]+4;*/
                                   /*,
        Line(
          points=DynamicSelect({{-100,0},{100,0}}, iconPoint),
          color={0,0,255},
          smooth=Smooth.None),
        Ellipse(
          extent=DynamicSelect({{0,0},{0,0}}, iconActualPoint),
          lineColor={0,0,0},
          fillColor={255,0,0},
          fillPattern=FillPattern.Solid)*/
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-60}},
                lineColor={255,0,0},
                fillPattern=FillPattern.HorizontalCylinder,
                fillColor={255,255,255}),
              Text(
                extent={{-100,-60},{100,-100}},
                lineColor={0,0,255},
                textString="%name")}),            Documentation(info="<html>
<p>The relationship heart rate(HR)-end diastolic volume(EDV) is represented by linear function -0.00247654 HR + 1.18574.</p>
<p>The coeficients was choosen to solve normal state and critical zero state: (Solve[{a*75 + b == 1, a*HR + b == 0, diastoleTime[HR] == 0}, {a, b}]).</p>
<p>It means the next ventricle filling model:</p>
<p>cardiac cycle time (T) = (60/HR) [s]</p>
<p>systolic contraction time (Ts) = (0.3*T^0.5) [s]</p>
<p>diastolic filling time (Tdf) = T - Ts - 0.18*Ts [s]</p>
<p>steady-state filling curve:</p>
<p><img src=\"C:/Users/oto/Desktop/Physiomodel/mathematicaGUI/Effect_EDVonHR.png\"/></p>
<p>axes x .. filling time = Tdf [s]</p>
<p>axes y .. entered volume part = stroke volume (SV)/normal_SV [x 100 &percnt;]</p>
<p><br/>EDV = SV + pre(ESV) = effect(HR) * ((EDV_without_HR_effect - pre(ESV)) + pre(ESV)</p>
</html>"));
      end Diastole3;

      model Ventricle3
       extends Physiomodel.CardioVascular2.Heart.Interfaces.IVentricle;

       parameter String stateName;

      Physiolibrary.Types.Constants.FractionConst
        basicContractility(k=contractilityBasic)
        annotation (Placement(transformation(extent={{60,2},{68,10}})));

        Physiomodel.Nerves.BetaReceptorsActivityFactor betaReceptorsActivityFactor
          annotation (Placement(transformation(extent={{64,-20},{84,0}})));

        Modelica.Blocks.Math.Add Vol_SteadyState(k1=0.5, k2=0.5)
                                                   annotation (Placement(
              transformation(
              extent={{10,-10},{-10,10}},
              rotation=270,
              origin={-34,18})));

      develop.Diastole3 diastole(
        stiffnes=stiffnes,
        n_Diastole=n_Diastole,
        Abasic_Diastole=Abasic_Diastole) annotation (Placement(
            transformation(extent={{-76,-44},{-56,-24}})));

        Systole systole(
          n_Systole=n_Systole,
          Abasic_Systole=Abasic_Systole,
          additionalPressure_Systolic=additionalPressure_Systolic,
        NormalSystolicPressure=NormalSystolicPressure,
        NormalEndSystolicVolume=NormalEndSystolicVolume)
          annotation (Placement(transformation(extent={{56,-44},{76,-24}})));

        Modelica.Blocks.Math.Feedback StrokeVolume
          annotation (Placement(transformation(extent={{-10,-10},{10,10}},
              origin={-8,-6})));

        VentricleVolumeAndPumping2 ventricle(
          initialVolume=initialVol,
          K=K,
          BasicCompliance=BasicCompliance,
          stateName=stateName)
                 annotation (Placement(transformation(extent={{-8,66},{12,86}})));

        Modelica.Blocks.Math.Product BloodFlow     annotation (Placement(
              transformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={16,40})));

      equation
        connect(basicContractility.y, betaReceptorsActivityFactor.yBase)
                                                               annotation (Line(
            points={{69,6},{74,6},{74,-3}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.BetaPool_Effect, betaReceptorsActivityFactor.BetaPool_Effect)
          annotation (Line(
            points={{22,2},{22,-4},{64.2,-4}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.BetaBlocade_Effect, betaReceptorsActivityFactor.BetaBlockade_Effect)
          annotation (Line(
            points={{22,2},{22,-10},{64.2,-10}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, betaReceptorsActivityFactor.GangliaGeneral_NA)
          annotation (Line(
            points={{22,2},{22,-16},{64.2,-16}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(diastole.externalPressure, busConnector.Pericardium_Pressure)
          annotation (Line(
            points={{-56,-40},{22,-40},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(busConnector.Pericardium_Pressure, systole.externalPressure)
          annotation (Line(
            points={{22,2},{22,-40},{56,-40}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(betaReceptorsActivityFactor.y, systole.contractility)
          annotation (Line(
            points={{74,-17},{74,-24}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(diastole.EDV,StrokeVolume. u1) annotation (Line(
            points={{-56,-26},{-40,-26},{-40,-6},{-16,-6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vol_SteadyState.u2, diastole.EDV) annotation (Line(
            points={{-40,6},{-40,-26},{-56,-26}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systole.outflow, q_out) annotation (Line(
            points={{76,-30},{86,-30},{86,80},{80,80}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(q_in, diastole.inflow) annotation (Line(
            points={{-80,80},{-82,80},{-82,-30},{-76,-30}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(systole.ESV, Vol_SteadyState.u1) annotation (Line(
            points={{56,-26},{-28,-26},{-28,6}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systole.ESV,StrokeVolume. u2) annotation (Line(
            points={{56,-26},{-8,-26},{-8,-14}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vol_SteadyState.y, ventricle.VentricleSteadyStateVolume)
          annotation (Line(
            points={{-34,29},{-34,58},{-6,58},{-6,66}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(q_in, ventricle.q_in)                 annotation (Line(
            points={{-80,80},{-54,80},{-54,76},{-8,76}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(ventricle.q_out, q_out)                 annotation (Line(
            points={{12,76},{56,76},{56,80},{80,80}},
            color={0,0,0},
            smooth=Smooth.None));
        connect(StrokeVolume.y, BloodFlow.u1)     annotation (Line(
            points={{1,-6},{10,-6},{10,28}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BloodFlow.y, ventricle.BloodFlow)                 annotation (Line(
            points={{16,51},{16,58},{10,58},{10,66}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ventricle.Volume, Vol)                 annotation (Line(
            points={{12.4,71},{14.7,71},{14.7,33},{73,33}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(BloodFlow.u2, busConnector.HeartVentricleRate)
          annotation (Line(
            points={{22,28},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(BloodFlow.y, CO) annotation (Line(
            points={{16,51},{16,59},{77,59}},
            color={0,0,127},
            smooth=Smooth.None));

        connect(diastole.HR, busConnector.HeartVentricleRate) annotation (
            Line(
            points={{-56,-33.2},{22,-33.2},{22,2}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
       annotation (
          Documentation(info="<HTML>
<PRE>
Heart ventricle.

like
QHP 2008 / VascularCompartments/LeftVentricle/*



The pressure-volume characteristics of both ventricles in diastole
and systole will be described using a power function.

  P = A * (V ^ n)

P = Pressure
V = Volume
A = Scale Factor
n = curvature

The function is invertable.

  V = (P/A) ^ (1/n)

Some typical values

                                 Right                 Left
                           ---------------------- ------------------------
Nominal Vol                     87.5                  87.5
Nominal TMP                      3.0                   6.0
Compliance                      29.2                  14.6
Pericardial P                   -3.0                  -3.0

DIASTOLE
  EDP                            1.0                   5.0
  EDV                          125.0                 125.0
  TMP                            4.0                   8.0
  n                              2.0                   2.0
  V^n                        15625.0               15625.0
  A                              0.00026               0.00051

SYSTOLE
  ESP                           22.0                 120.0
  ESV                           50.0                  50.0
  TMP                           25.0                 123.0
  n                              0.5                   0.5
  V^n                            7.07                  7.07
  A                              3.53                 17.39
</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={Text(
                extent={{-78,26},{80,12}},
                lineColor={0,0,0},
                textString="contractilityBasic = %contractilityBasic")}),
                                        Diagram(coordinateSystem(preserveAspectRatio=true,
                         extent={{-100,-100},{100,100}}), graphics={Text(
                extent={{-32,62},{-8,60}},
                lineColor={0,0,0},
                textString="Volume_SteadyState"), Text(
                extent={{8,62},{32,60}},
                lineColor={0,0,0},
                textString="Blood_Inflow")}));
      end Ventricle3;
    end develop;
  end Heart;

  package Circulation "Blood Cardio-Vascular Distribution"
    class References "References"
      extends Modelica.Icons.References;

      annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Alfie1999]</td>
		<td>J. Alfie, G. D. Waisman, C. R. Galarza, and M. I. Cámera, \"Contribution of Stroke Volume to the Change in Pulse Pressure Pattern With Age,\" Hypertension, vol. 34, pp. 808-812, October 1, 1999 1999. </td>
	</tr>
	<tr>
		<td>[Alsberge1988]</td>
		<td>M. Alsberge, M. Magno, and M. Lipschutz, Carotid body control of bronchial circulation in sheep vol. 65, 1988. </td>
	</tr>
	<tr>
		<td>[Archer2002]</td>
		<td>S. Archer and E. Michelakis, The Mechanism(s) of Hypoxic Pulmonary Vasoconstriction: Potassium Channels, Redox O2 Sensors, and Controversies vol. 17, 2002. </td>
	</tr>
	<tr>
		<td>[Archer1996]</td>
		<td>S. L. Archer, J. M. C. Huang, H. L. Reeve, V. Hampl, S. Tolarová, E. Michelakis, et al., \"Differential Distribution of Electrophysiologically Distinct Myocytes in Conduit and Resistance Arteries Determines Their Response to Nitric Oxide and Hypoxia,\" Circulation Research, vol. 78, pp. 431-442, March 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Armstrong1985]</td>
		<td>R. Armstrong, C. Vandenakker, and M. Laughlin, \"Muscle blood flow patterns during exercise in partially curarized rats,\" Journal of Applied Physiology, vol. 58, pp. 698-701, 1985. </td>
	</tr>
	<tr>
		<td>[Ashley1992]</td>
		<td>K. D. Ashley, D. N. Herndon, L. D. Traber, D. L. Traber, K. Deubel-Ashley, J. Stothert, et al., \"Systemic blood flow to sheep lung: comparison of flow probes and microspheres,\" Journal of Applied Physiology, vol. 73, pp. 1996-1996, 1992. </td>
	</tr>
	<tr>
		<td>[Bangsbo1997]</td>
		<td>J. Bangsbo, C. Juel, Y. Hellsten, and B. Saltin, \"Dissociation between lactate and proton exchange in muscle during intense exercise in man,\" The Journal of Physiology, vol. 504, pp. 489-499, October 15, 1997 1997. </td>
	</tr>
	<tr>
		<td>[Berg1997]</td>
		<td>B. R. Berg, K. D. Cohen, and I. H. Sarelius, \"Direct coupling between blood flow and metabolism at the capillary level in striated muscle,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 41, p. H2693, 1997. </td>
	</tr>
	<tr>
		<td>[Bevegärd1962]</td>
		<td>S. Bevegärd and A. Lodin, \"Postural Circulatory Changes at Rest and during Exercise in five Patients with Congenital Absence of Valves in the Deep Veins of the Legs,\" Acta Medica Scandinavica, vol. 172, pp. 21-29, 1962. </td>
	</tr>
	<tr>
		<td>[Bock1930]</td>
		<td>A. V. Bock, D. B. Dill, and H. T. Edwards, \"ON THE RELATION OF CHANGES IN BLOOD VELOCITY AND VOLUME FLOW OF BLOOD TO CHANGE OF POSTURE,\" The Journal of Clinical Investigation, vol. 8, pp. 533-544, 1930. </td>
	</tr>
	<tr>
		<td>[Borgström1975]</td>
		<td>L. Borgström, H. Jóhannsson, and B. K. Siesjö, \"The Relationship between Arterial PO2 and Cerebral Blood Flow in Hypoxic Hypoxia,\" Acta Physiologica Scandinavica, vol. 93, pp. 423-432, 1975. </td>
	</tr>
	<tr>
		<td>[Burattini1994]</td>
		<td>R. Burattini, P. Borgdorff, and N. Westerhof, \"Relationship between strength of short-term systemic autoregulation and initial resistance,\" American Journal of Physiology-Regulatory Integrative and Comparative Physiology, vol. 36, p. R1182, 1994. </td>
	</tr>
	<tr>
		<td>[Davidson1986]</td>
		<td>D. Davidson, S. A. Stalcup, and R. B. Mellins, Systemic hemodynamics affecting cardiac output during hypocapnic and hypercapnic hypoxia vol. 60, 1986. </td>
	</tr>
	<tr>
		<td>[Drury1927]</td>
		<td>A. Drury and N. Jones, \"Observations upon the rate at which oedema forms when the veins of the human limb are congested,\" Heart, vol. 14, p. 8, 1927. </td>
	</tr>
	<tr>
		<td>[Dunbar2001]</td>
		<td>S. L. Dunbar, L. Tamhidi, D. E. Berkowitz, and A. A. Shoukas, Hindlimb unweighting affects rat vascular capacitance function vol. 281, 2001. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Increased Intravascular Pressure Does Not Enhance Skeletal Muscle Arteriolar Constriction to Oxygen or Angiotensin II,\" Microvascular Research, vol. 59, pp. 176-180, 1// 2000. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Short-term angiotensin converting enzyme inhibition reduces basal tone and dilator reactivity in skeletal muscle arterioles*,\" American Journal of Hypertension, vol. 13, pp. 389-395, April 1, 2000 2000. </td>
	</tr>
	<tr>
		<td>[Goodman1978]</td>
		<td>A. H. Goodman, R. Einstein, and H. J. Granger, \"Effect of changing metabolic rate on local blood flow control in the canine hindlimb,\" Circulation Research, vol. 43, pp. 769-76, November 1, 1978 1978. </td>
	</tr>
	<tr>
		<td>[Granger1969]</td>
		<td>H. J. Granger and A. C. Guyton, \"Autoregulation of the Total Systemic Circulation Following Destruction of the Central Nervous System in the Dog,\" Circulation Research, vol. 25, pp. 379-388, October 1, 1969 1969. </td>
	</tr>
	<tr>
		<td>[Granger1976]</td>
		<td>H. J. Granger, A. H. Goodman, and D. N. Granger, \"Role of resistance and exchange vessels in local microvascular control of skeletal muscle oxygenation in the dog,\" Circulation Research, vol. 38, pp. 379-85, May 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Hennessy1993]</td>
		<td>E. Hennessy, S. White, T. Van der Touw, A. Quail, W. Porges, and P. Glenfield, \"Control of resting bronchial hemodynamics in the awake dog,\" American Journal of Physiology, vol. 265, pp. H649-H649, 1993. </td>
	</tr>
	<tr>
		<td>[Henry1950]</td>
		<td>J. P. Henry and O. H. Gauer, \"THE INFLUENCE OF TEMPERATURE UPON VENOUS PRESSURE IN THE FOOT,\" The Journal of Clinical Investigation, vol. 29, pp. 855-861, 1950. </td>
	</tr>
	<tr>
		<td>[Hogan1990]</td>
		<td>M. C. Hogan, D. E. Bebout, A. T. Gray, P. D. Wagner, J. B. West, and P. E. Haab, Muscle maximal O2 uptake at constant O2 delivery with and without CO in the blood vol. 69, 1990. </td>
	</tr>
	<tr>
		<td>[Charan1984]</td>
		<td>N. B. Charan, G. M. Turk, and R. Dhand, \"Gross and subgross anatomy of bronchial circulation in sheep,\" J Appl Physiol, vol. 57, pp. 658-664, 1984. </td>
	</tr>
	<tr>
		<td>[Charles1994]</td>
		<td>J. B. Charles and C. M. Lathers, \"Summary of Lower Body Negative Pressure Experiments During Space Flight,\" The Journal of Clinical Pharmacology, vol. 34, pp. 571-583, 1994. </td>
	</tr>
	<tr>
		<td>[Joseph1952]</td>
		<td>J. Joseph and A. Nightingale, \"Electromyography of muscles of posture: leg muscles in males,\" The Journal of Physiology, vol. 117, pp. 484-491, August 28, 1952 1952. </td>
	</tr>
	<tr>
		<td>[Katkov1980]</td>
		<td>V. E. Katkov and V. V. Chestukhin, \"Blood pressure and oxygenation in different cardiovascular compartments of a normal man during postural exposures,\" Aviat Space Environ Med, vol. 51, pp. 1234-42, Nov 1980. </td>
	</tr>
	<tr>
		<td>[Kunert1996]</td>
		<td>M. P. Kunert, J. F. Liard, D. J. Abraham, and J. H. Lombard, \"Low-Affinity Hemoglobin Increases Tissue PO2and Decreases Arteriolar Diameter and Flow in the Rat Cremaster Muscle,\" Microvascular Research, vol. 52, pp. 58-68, 7// 1996. </td>
	</tr>
	<tr>
		<td>[Kuwahira1993]</td>
		<td>I. Kuwahira, N. Heisler, J. Piiper, and N. C. Gonzalez, \"Effect of chronic hypoxia on hemodynamics, organ blood flow and O2 supply in rats,\" Respiration Physiology, vol. 92, pp. 227-238, 5// 1993. </td>
	</tr>
	<tr>
		<td>[Landis1933]</td>
		<td>E. M. Landis and J. H. Gibbon, Jr., \"THE EFFECTS OF TEMPERATURE AND OF TISSUE PRESSURE ON THE MOVEMENT OF FLUID THROUGH THE HUMAN CAPILLARY WALL,\" The Journal of Clinical Investigation, vol. 12, pp. 105-138, 1933. </td>
	</tr>
	<tr>
		<td>[Lash1987]</td>
		<td>J. M. Lash and H. G. Bohlen, Perivascular and tissue PO2 in contracting rat spinotrapezius muscle vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[LAUGHLIN1987]</td>
		<td>M. H. LAUGHLIN, \"Skeletal muscle blood flow capacity: role of muscle pump in exercise hyperemia,\" Am J Physiol, vol. 253, p. 1004, 1987. </td>
	</tr>
	<tr>
		<td>[Laughlin1983]</td>
		<td>M. H. Laughlin and R. Armstrong, \"Rat muscle blood flows as a function of time during prolonged slow treadmill exercise,\" Am J Physiol Heart Circ Physiol, vol. 244, pp. H814-H824, 1983. </td>
	</tr>
	<tr>
		<td>[Malo1984]</td>
		<td>J. Malo, H. Goldberg, R. Graham, H. Unruh, and C. Skoog, Effect of hypoxic hypoxia on systemic vasculature vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Marshall1995]</td>
		<td>J. Marshall, Skeletal Muscle Vasculature and Systemic Hypoxia vol. 10, 1995. </td>
	</tr>
	<tr>
		<td>[Marshall1988]</td>
		<td>J. M. Marshall and J. D. Metcalfe, \"Analysis of the cardiovascular changes induced in the rat by graded levels of systemic hypoxia,\" The Journal of Physiology, vol. 407, pp. 385-403, December 1, 1988 1988. </td>
	</tr>
	<tr>
		<td>[Mayerson1939]</td>
		<td>H. S. Mayerson, H. M. Sweeney, and L. A. Toth, THE INFLUENCE OF POSTURE ON CIRCULATION TIME vol. 125, 1939. </td>
	</tr>
	<tr>
		<td>[Metting1988]</td>
		<td>P. J. Metting, J. R. Strader, and S. L. Britton, Evaluation of whole body autoregulation in conscious dogs vol. 255, 1988. </td>
	</tr>
	<tr>
		<td>[Metting1989]</td>
		<td>P. J. Metting, P. M. Stein, B. A. Stoos, K. A. Kostrzewski, and S. L. Britton, Systemic vascular autoregulation amplifies pressor responses to vasoconstrictor agents vol. 256, 1989. </td>
	</tr>
	<tr>
		<td>[Monos2001]</td>
		<td>E. Monos, M. Lóránt, and E. Fehér, Influence of long-term experimental orthostatic body position on innervation density in extremity vessels vol. 281, 2001. </td>
	</tr>
	<tr>
		<td>[Monos2003]</td>
		<td>E. Monos, M. Lóránt, G. Dörnyei, V. Bérczi, and G. Nádasy, Long-Term Adaptation Mechanisms in Extremity Veins Supporting Orthostatic Tolerance vol. 18, 2003. </td>
	</tr>
	<tr>
		<td>[O’ROURKE1990]</td>
		<td>S. T. O’ROURKE and P. M. VANHOUTTE, \"Adrenergic and cholinergic responsiveness of isolated canine bronchial arteries,\" Organ, vol. 6, p. 2, 1990. </td>
	</tr>
	<tr>
		<td>[OCHSNER1951]</td>
		<td>A. OCHSNER, R. COLP, and G. E. BURCH, \"Normal Blood Pressure in the Superficial Venous System of Man at Rest in the Supine Position,\" Circulation, vol. 3, pp. 674-680, May 1, 1951 1951. </td>
	</tr>
	<tr>
		<td>[POHOST1976]</td>
		<td>G. M. POHOST, J. B. NEWELL, N. P. HAMLIN, and W. J. POWELL, \"Observations on autoregulation in skeletal muscle: the effects of arterial hypoxia,\" Cardiovascular Research, vol. 10, pp. 405-412, July 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Pollack1949]</td>
		<td>A. A. Pollack and E. H. Wood, Venous Pressure in the Saphenous Vein at the Ankle in Man during Exercise and Changes in Posture vol. 1, 1949. </td>
	</tr>
	<tr>
		<td>[Prewitt1976]</td>
		<td>R. L. Prewitt and P. C. Johnson, \"The effect of oxygen on arteriolar red cell velocity and capillary density in the rat cremaster muscle,\" Microvascular Research, vol. 12, pp. 59-70, 7// 1976. </td>
	</tr>
	<tr>
		<td>[Raven1984]</td>
		<td>P. B. Raven, D. Rohm-Young, and C. G. Blomqvist, Physical fitness and cardiovascular response to lower body negative pressure vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Roach1957]</td>
		<td>M. R. Roach and A. C. Burton, \"THE REASON FOR THE SHAPE OF THE DISTENSIBILITY CURVES OF ARTERIES,\" Canadian Journal of Biochemistry and Physiology, vol. 35, pp. 681-690, 1957/08/01 1957. </td>
	</tr>
	<tr>
		<td>[Stevens]</td>
		<td>StevensP. M. Stevens and L. E. Lamb, \"Effects of lower body negative pressure on the cardiovascular system,\" American Journal of Cardiology, vol. 16, pp. 506-515.</td>
	<tr>
		<td>[Stick1992]</td>
		<td>C. Stick, H. Jaeger, and E. Witzleb, Measurements of volume changes and venous pressure in the human lower leg during walking and running vol. 72, 1992. </td>
	</tr>
	<tr>
		<td>[Stonestreet1998]</td>
		<td>B. S. Stonestreet, S. S. Ocampo, and W. Oh, Reductions in cardiac output in hypoxic young pigs: systemic and regional perfusion and oxygen metabolism vol. 85, 1998. </td>
	</tr>
	<tr>
		<td>[Stothert1992]</td>
		<td>J. C. Stothert, J. O. Basadre, G. B. Gbaanador, J. T. Flynn, L. Traber, and D. Traber, \"Bronchial blood flow during changes in inhaled oxygen and carbon dioxide concentrations in conscious sheep,\" Circulatory shock, vol. 36, pp. 120-126, 1992/02// 1992. </td>
	</tr>
	<tr>
		<td>[Schumacker]</td>
		<td>SchumackerS. P. T. and C. S. M., \"The concept of a critical oxygen delivery,\" Intensive Care Medicine, vol. 13, pp. 223-229, January 1, 0001.</td>
	<tr>
		<td>[Thompson1928]</td>
		<td>W. O. Thompson, P. K. Thompson, and M. E. Dailey, \"THE EFFECT OF POSTURE UPON THE COMPOSITION AND VOLUME OF THE BLOOD IN MAN 1,\" The Journal of Clinical Investigation, vol. 5, pp. 573-604, 1928. </td>
	</tr>
	<tr>
		<td>[Wagner1988]</td>
		<td>E. M. Wagner and W. A. Mitzner, \"Effect of hypoxia on bronchial circulation,\" J. Appl. Physiol, vol. 65, pp. 1627-1633, 1988. </td>
	</tr>
	<tr>
		<td>[Wagner1990]</td>
		<td>E. M. Wagner and W. A. Mitzner, \"Effect of left atrial pressure on bronchial vascular hemodynamics,\" J Appl Physiol, vol. 69, pp. 837-842, 1990. </td>
	</tr>
	<tr>
		<td>[Weber2000]</td>
		<td>D. S. Weber and J. H. Lombard, Elevated salt intake impairs dilation of rat skeletal muscle resistance arteries via ANG II suppression vol. 278, 2000. </td>
	</tr>
	<tr>
		<td>[Wells1938]</td>
		<td>H. S. Wells, J. B. Youmans, and D. G. Miller, Jr., \"TISSUE PRESSURE (INTRACUTANEOUS, SUBCUTANEOUS, AND INTRAMUSCULAR) AS RELATED TO VENOUS PRESSURE, CAPILLARY FILTRATION, AND OTHER FACTORS 12,\" The Journal of Clinical Investigation, vol. 17, pp. 489-499, 1938. </td>
	</tr>
	<tr>
		<td>[Whalen1974]</td>
		<td>W. Whalen, P. Nair, D. Buerk, and C. Thuning, \"Tissue PO2 in normal and denervated cat skeletal muscle,\" Am J Physiol, vol. 227, pp. 1221-1225, 1974.  </td>
	</tr>


</table>
</html>"));
    end References;

    package Interfaces "Abstract Interfaces"

      partial model IVascularElasticBloodCompartment
        extends Physiolibrary.Icons.ElasticBalloon;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(
              extent={{-10,-110},{10,-90}}, rotation=0),
                                             iconTransformation(extent={{-10,
                -10},{10,10}})));
        Modelica.Blocks.Interfaces.RealInput V0(
                                             final quantity="Volume", final displayUnit="ml")
        "maximal nonstressed volume"                                                                                annotation (extent = [-70,90;-50,110], rotation = -90,
        Placement(transformation(
            origin={-60,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));
        Modelica.Blocks.Interfaces.RealInput ExternalPressure(
                                                          final quantity="Pressure", final displayUnit="mmHg")
        "external pressure around the compartment"                              annotation (extent = [-10,90;10,110], rotation = -90,
        Placement(transformation(
            origin={0,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));
        Modelica.Blocks.Interfaces.RealInput Compliance(
                                                      final quantity="Compliance", final displayUnit="ml/mmHg")
        "elasticity of the stressed walls"                               annotation (extent = [50,90;70,110], rotation = -90,
        Placement(transformation(
            origin={60,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));

        Modelica.Blocks.Interfaces.RealOutput Pressure(  final quantity="Pressure", final displayUnit="mmHg")
        "blod pressure in compartment"
          annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
       // Real Vol "blood volume in compartment";

        parameter Real initialVol = 0;
        Modelica.Blocks.Interfaces.RealOutput Vol(start=initialVol, final
            quantity =                                                             "Volume", final displayUnit=
             "ml") "blood volume in compartment"
          annotation (Placement(transformation(extent={{-10,-10},{10,10}},
              rotation=270,
              origin={-40,-100})));

       // parameter Real initialVol = 0;
       annotation (
          preferredView = text,
          Documentation(info="<HTML>

</HTML>
"));
      end IVascularElasticBloodCompartment;

      model ISequesteredBlood
       extends Physiolibrary.Icons.BloodSequesteredCompartment;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(
              extent={{-10,-110},{10,-90}}, rotation=0),
                                             iconTransformation(extent={{-10,
                -10},{10,10}})));
        Physiolibrary.Types.RealIO.PressureInput ExternalPressure
        "external pressure around the compartment"                              annotation (extent = [-100,90;-80,110], rotation = -90,
        Placement(transformation(
            origin={-90,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));

        Physiolibrary.Types.RealIO.PressureOutput Pressure
        "blod pressure in compartment"
          annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
        Physiolibrary.Types.RealIO.VolumeOutput Vol
        "blood volume in compartment"
          annotation (Placement(transformation(extent={{-50,-110},{-30,-90}}, rotation=-90)));

       annotation (
          Documentation(info="<HTML>
</HTML>
"));
      end ISequesteredBlood;

    end Interfaces;

    model PulmonaryCirculation

       extends Physiolibrary.Icons.PulmonaryCirculation;

      //Can not be one port, because for example whole periferal resistance is taken as ResistorBases, but blood can accumulate inside

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-112,-10},{
              -92,10}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,
              10}})));

    Physiolibrary.Hydraulic.Components.ElasticVessel pulmCapys(
      stateName="PulmCapys.Vol",
      useComplianceInput=true,
      useExternalPressureInput=true,
      useV0Input=true,
      volume_start=0.000200141) "pulmonary capilaries"
      annotation (Placement(transformation(extent={{-22,-10},{-2,10}})));
    Physiolibrary.Hydraulic.Components.ElasticVessel pulmArty(
      stateName="PulmArty.Vol",
      useComplianceInput=true,
      useExternalPressureInput=true,
      useV0Input=true,
      volume_start=0.000200488)
      annotation (Placement(transformation(extent={{-86,-10},{-66,10}})));
    Physiolibrary.Hydraulic.Components.ElasticVessel pulmVeins(
      stateName="PulmVeins.Vol",
      useComplianceInput=true,
      useExternalPressureInput=true,
      useV0Input=true,
      volume_start=0.000210463) "pulmonary veins"
      annotation (Placement(transformation(extent={{38,-10},{58,10}})));
    Physiolibrary.Hydraulic.Components.Conductor pulmArtyConductance(
        Conductance=1.6876385456527e-07)
      annotation (Placement(transformation(extent={{-61,-11},{-39,11}})));
    Physiolibrary.Types.Constants.VolumeConst ArtysV0(k=0.00011)
      annotation (Placement(transformation(extent={{-94,16},{-86,24}})));
    Physiolibrary.Types.Constants.HydraulicComplianceConst ArtysCompliance(k=
          3.975326351982e-08)
      annotation (Placement(transformation(extent={{-54,16},{-62,24}})));
    Physiolibrary.Types.Constants.VolumeConst               CapysV0(k=0.00014)
      annotation (Placement(transformation(extent={{-28,16},{-20,24}})));
    Physiolibrary.Types.Constants.HydraulicComplianceConst CapysCompliance(k=
          3.450283248890036e-008)
      annotation (Placement(transformation(extent={{4,16},{-4,24}})));
    Physiolibrary.Hydraulic.Components.Conductor pulmCapysConductance(
        Conductance=2.250184727537e-07)
      annotation (Placement(transformation(extent={{2,-11},{24,11}})));
    Physiolibrary.Types.Constants.VolumeConst               VeinsV0(k=0.00015)
      annotation (Placement(transformation(extent={{30,16},{38,24}})));
    Physiolibrary.Types.Constants.HydraulicComplianceConst VeinsCompliance(k=
          4.50036945507396e-008)
      annotation (Placement(transformation(extent={{66,14},{58,22}})));
    Physiolibrary.Hydraulic.Components.Conductor pulmVeinsConductance(
        Conductance=6.7505541826109e-07)
      annotation (Placement(transformation(extent={{62,-11},{84,11}})));
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{18,66},{38,86}}), iconTransformation(extent=
             {{-108,42},{-92,58}})));
      LungBloodFlow lungBloodFlow
        annotation (Placement(transformation(extent={{-26,74},{-6,94}})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure
      annotation (Placement(transformation(extent={{-42,-10},{-22,10}})));
      Modelica.Blocks.Math.Sum sum1(nin=3)
        annotation (Placement(transformation(extent={{-28,28},{-20,36}})));
      Modelica.Blocks.Math.Sum sum2(nin=2)
        annotation (Placement(transformation(extent={{50,-38},{42,-30}})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
      annotation (Placement(transformation(extent={{-8,-26},{12,-6}})));
    equation
    connect(pulmArty.q_in, pulmArtyConductance.q_in) annotation (Line(
        points={{-76,0},{-61,0}},
        color={0,0,0},
        smooth=Smooth.None,
        thickness=1));
      connect(pulmArty.externalPressure,busConnector. Thorax_AvePressure) annotation (Line(
          points={{-68,8},{-68,14},{28,14},{28,76}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pulmCapys.externalPressure,busConnector. Thorax_AvePressure) annotation (Line(
          points={{-4,8},{-4,14},{28,14},{28,76}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pulmVeins.externalPressure,busConnector. Thorax_AvePressure) annotation (Line(
          points={{56,8},{56,14},{28,14},{28,76}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(pulmArty.zeroPressureVolume, ArtysV0.y) annotation (Line(
        points={{-84,8},{-84,20},{-85,20}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(pulmArty.compliance, ArtysCompliance.y)
                                              annotation (Line(
          points={{-76,8},{-76,20},{-63,20}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(CapysV0.y, pulmCapys.zeroPressureVolume) annotation (Line(
        points={{-19,20},{-20,20},{-20,8}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(CapysCompliance.y,pulmCapys.compliance)
                                               annotation (Line(
          points={{-5,20},{-12,20},{-12,8}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(pulmCapys.q_in, pulmCapysConductance.q_in) annotation (Line(
        points={{-12,0},{2,0}},
        color={0,0,0},
        smooth=Smooth.None,
        thickness=1));
    connect(pulmCapysConductance.q_out, pulmVeins.q_in) annotation (Line(
        points={{24,0},{48,0}},
        color={0,0,0},
        smooth=Smooth.None,
        thickness=1));
    connect(pulmVeins.zeroPressureVolume, VeinsV0.y) annotation (Line(
        points={{40,8},{40,20},{39,20}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(VeinsCompliance.y,pulmVeins.compliance)
                                               annotation (Line(
          points={{57,18},{48,18},{48,8}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(pulmVeins.q_in, pulmVeinsConductance.q_in) annotation (Line(
        points={{48,0},{62,0}},
        color={0,0,0},
        smooth=Smooth.None,
        thickness=1));
      connect(lungBloodFlow.AlveolarVentilated, busConnector.AlveolarVentilated_BloodFlow)
        annotation (Line(
          points={{-6,90},{28,90},{28,76}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));

      connect(pulmArtyConductance.q_out, flowMeasure.q_in) annotation (Line(
          points={{-39,0},{-42,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(flowMeasure.q_out, pulmCapys.q_in) annotation (Line(
        points={{-22,0},{-12,0}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(flowMeasure.volumeFlow, lungBloodFlow.CardiacOutput)
        annotation (Line(
          points={{-32,12},{-32,90},{-26,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(ArtysV0.y, sum1.u[1]) annotation (Line(
          points={{-85,20},{-82,20},{-82,32},{-28,32},{-28,31.4667},{-28.8,
            31.4667}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(CapysV0.y, sum1.u[2]) annotation (Line(
          points={{-19,20},{-18,20},{-18,26},{-80,26},{-80,32},{-28.8,32}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(VeinsV0.y, sum1.u[3]) annotation (Line(
          points={{39,20},{42,20},{42,26},{-78,26},{-78,32.5333},{-28.8,
            32.5333}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(pulmCapys.volume, sum2.u[1]) annotation (Line(
        points={{-6,-10},{-6,-42},{54,-42},{54,-34.4},{50.8,-34.4}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(pulmVeins.volume, sum2.u[2]) annotation (Line(
        points={{54,-10},{54,-33.6},{50.8,-33.6}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(sum1.y, busConnector.PulmonaryCirculation_V0) annotation (Line(
          points={{-19.6,32},{28,32},{28,76}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(pulmArty.volume, busConnector.PulmonaryCirculation_DeoxygenatedBloodVolume)
      annotation (Line(
        points={{-70,-10},{-70,-28},{28,-28},{28,76}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,-16},{6,-16}}));
      connect(busConnector.PulmonaryCirculation_OxygenatedBloodVolume, sum2.y)
        annotation (Line(
          points={{28,76},{28,-34},{41.6,-34}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
    connect(q_in, pulmArty.q_in) annotation (Line(
        points={{0,-100},{-38,-100},{-38,0},{-76,0}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(pulmVeinsConductance.q_out, q_out) annotation (Line(
          points={{84,0},{42,0},{42,-100},{0,-100}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(pulmCapys.q_in, pressureMeasure.q_in) annotation (Line(
        points={{-12,0},{-8,0},{-8,-22},{-2,-22}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pressureMeasure.pressure, busConnector.PulmCapys_Pressure)
      annotation (Line(
        points={{8,-20},{28,-20},{28,76}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
      annotation ( Icon(coordinateSystem(
              preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
            graphics={
            Text(
              extent={{-108,-48},{106,-70}},
              lineColor={0,0,255},
              textString="%name")}),
      Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>",
        info="<html>
<p>Blood volume (and pressures) distribution between </p>
<p><ul>
<li>pulmonary arteries, </li>
<li>pulmonary veins and </li>
<li>pulmonary capilaries.</li>
</ul></p>
<p>Blood flow through ventilated alveoli.</p>
</html>"));
    end PulmonaryCirculation;

    model SystemicCirculationFullDynamic
      extends Physiolibrary.Icons.SystemicCirculation;

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,
              10}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-110,-10},{
              -90,10}})));

      /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

    Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
      stateName="SystemicArtys.Vol",
      useV0Input=true,
      useComplianceInput=false,
      volume_start=0.00100036,
      Compliance=1.1625954425608e-08,
      useExternalPressureInput=false,
      ExternalPressure=0)
      annotation (Placement(transformation(extent={{65,-10},{86,11}})));
    Physiolibrary.Types.Constants.VolumeConst               V0_artys(k=0.00085)
      annotation (Placement(transformation(extent={{98,18},{88,28}})));
    Physiolibrary.Types.Constants.HydraulicComplianceConst
      SystemicVeinsCompliance(k=6.645545561992547e-007)
      annotation (Placement(transformation(extent={{-27,10},{-35,18}})));
    PeripheralCirculation peripheral
      annotation (Placement(transformation(extent={{-2,0},{26,28}})));
    Physiolibrary.Hydraulic.Sources.UnlimitedPump volumeCorrections(
        useSolutionFlowInput=true)
      annotation (Placement(transformation(extent={{-28,24},{-42,38}})));
    SystemicVeins veins(BaseConductance(displayUnit="ml/(mmHg.min)")=
        1.2000985213531e-07) "scaled to coronary vessels reorganisation"
      annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
      SystemicVeinsElacticBloodCompartment
        systemicVeinsElacticBloodCompartment
        annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
    Physiolibrary.Types.Constants.PressureConst SystemicVeinsExternalPressure(
        k=0)
      annotation (Placement(transformation(extent={{-36,16},{-43,23}})));
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{36,40},{56,60}}), iconTransformation(extent=
             {{-110,32},{-94,48}})));
    CollapsingVeins collapsedVeins annotation (Placement(transformation(
          extent={{10,10.5},{-10,-10.5}},
          rotation=180,
          origin={-84.5,0})));
    Physiolibrary.Hydraulic.Components.HydrostaticColumn
      gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
      annotation (Placement(transformation(
          extent={{-10,-10},{10,10}},
          origin={61,35})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
      annotation (Placement(transformation(
          extent={{8.5,-8.5},{-8.5,8.5}},
          origin={78.5,45.5})));
      Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
            extent={{4,-4},{-4,4}},
            rotation=90,
            origin={34,26})));
    Microcirculation.LeftHeart leftCororaryCirculation(
        BasicLargeVeselsConductance(displayUnit="ml/(mmHg.min)")=
        5.0004105056377e-09, BasicSmallVeselsConductance(displayUnit=
            "ml/(mmHg.min)") = 3.1252565660236e-10)
      "scaled to normal pressure gradient 94 mmHg"
      annotation (Placement(transformation(extent={{-10,76},{10,96}})));
    Microcirculation.RightHeart rightCororaryCirculation(
        BasicLargeVeselsConductance(displayUnit="ml/(mmHg.min)")=
        1.2501026264094e-09, BasicSmallVeselsConductance(displayUnit=
            "ml/(mmHg.min)") = 6.2505131320471e-11)
      "scaled to normal pressure gradient 94 mmHg"
      annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
    SplanchnicCirculation splanchnicCirculation
      annotation (Placement(transformation(extent={{-6,-44},{32,-6}})));
    Physiolibrary.Hydraulic.Components.Conductor legsArtys(Conductance=
          5.0004105056377e-09)
      annotation (Placement(transformation(extent={{80,-86},{64,-70}})));
    Physiolibrary.Types.Constants.PressureConst const8(k=0)
      annotation (Placement(transformation(extent={{93,-68},{86,-61}})));
    Physiolibrary.Hydraulic.Components.HydrostaticColumn
      hydrostaticDifference(useExternalG=true, useHeightInput=true)
      annotation (Placement(transformation(
          extent={{-10,-10},{10,10}},
          origin={54,-72})));
      SequesteredBlood sequesteredBlood(data={{0,0,10^(-10)},{50,97,1.0},{200,150,0.5}},
        pressureControledCompartment(stateName="BVSeqArtys.Vol"),
      initialVol=5.00044e-05)
        annotation (Placement(transformation(extent={{80,-88},{100,-68}})));
      SequesteredBlood sequesteredBlood1(                data={{0,-100,2.00},{150,11,
            0.11},{600,50,0.15}},
        pressureControledCompartment(stateName="BVSeqVeins.Vol"),
      initialVol=0.000120691)
        annotation (Placement(transformation(extent={{-62,-82},{-44,-64}})));
    Physiolibrary.Hydraulic.Components.Conductor legsVeins(Conductance=
          1.2501026264094e-08)
      annotation (Placement(transformation(extent={{-42,-80},{-28,-66}})));
    Physiolibrary.Hydraulic.Components.HydrostaticColumn
      hydrostaticDifference1(
      useExternalG=true,
      useHeightInput=true,
      usePumpEffect=true)
      annotation (Placement(transformation(extent={{-5,-78},{-25,-58}})));
    Physiolibrary.Types.Constants.PressureConst             const12(k=0)
      annotation (Placement(transformation(extent={{-52,-60},{-59,-53}})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure1
      annotation (Placement(transformation(extent={{76,-38},{96,-18}})));
    equation
    connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
        points={{67.1,8.9},{67.1,23},{86.75,23}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(busConnector, peripheral.busConnector)          annotation (
          Line(
          points={{46,50},{46,16.66},{21.66,16.66}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(veins.busConnector,busConnector)           annotation (
         Line(
          points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(SystemicVeinsCompliance.y, systemicVeinsElacticBloodCompartment.Compliance)
        annotation (Line(
          points={{-36,14},{-38.2,14},{-38.2,10},{-38,10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
        annotation (Line(
          points={{46,50},{-26,50},{-26,6.1},{-34.2,6.1}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(systemicVeinsElacticBloodCompartment.referencePoint,volumeCorrections. q_out)
        annotation (Line(
          points={{-44,0},{-46,0},{-46,31},{-42,31}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(systemicVeinsElacticBloodCompartment.ExternalPressure,
        SystemicVeinsExternalPressure.y)
        annotation (Line(
          points={{-44,10},{-44,19.5},{-43.875,19.5}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(busConnector.BloodVolume_change, volumeCorrections.solutionFlow)
      annotation (Line(
        points={{46,50},{-35,50},{-35,35.9}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None));
      connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
        annotation (Line(
          points={{-78.5,2.1},{-80,2.1},{-80,50},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
      annotation (Line(
        points={{73.4,42.1},{46,42.1},{46,50}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
        annotation (Line(
          points={{55,35},{46,35},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
      annotation (Line(
        points={{69,29},{69,0.5},{75.5,0.5}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));

      connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
        annotation (Line(
          points={{69,39},{80,39},{80,40.4},{81.9,40.4}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
      annotation (Line(
        points={{73.4,42.1},{46,42.1},{46,50}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
        annotation (Line(
          points={{-40,-10},{-40,-28},{46,-28},{46,50}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
        annotation (Line(
          points={{-50.8,10},{-50.8,50},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
          points={{86.75,23},{70,23},{70,22},{46,22},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(q_in, systemicArtys.q_in) annotation (Line(
        points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(collapsedVeins.q_out, q_out) annotation (Line(
          points={{-94.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
            -100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(busConnector.Gravity_Gz, G.u) annotation (Line(
          points={{46,50},{46,38},{34,38},{34,30.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
          points={{34,21.6},{34,16},{61,16},{61,25}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(rightCororaryCirculation.busConnector, busConnector)
                                                              annotation (
          Line(
          points={{-25.1,73.9},{46,73.9},{46,50}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(leftCororaryCirculation.busConnector, busConnector)
                                                             annotation (Line(
          points={{6.9,87.9},{46,87.9},{46,50}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
        annotation (Line(
          points={{7,81},{46,81},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
        annotation (Line(
          points={{-25,67},{22,67},{22,50},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
        annotation (Line(
          points={{7,81},{46,81},{46,50}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
        annotation (Line(
          points={{-25,67},{22,67},{22,50},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(splanchnicCirculation.busConnector, busConnector) annotation (
          Line(
          points={{-6,-15.5},{-6,50},{46,50}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
    connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
        points={{32,-25},{62,-25},{62,0.5},{75.5,0.5}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
        points={{26,14},{52,14},{52,0.5},{75.5,0.5}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
        annotation (Line(
          points={{-2,14},{-24,14},{-24,0},{-44,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
          points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
          points={{-10,86},{-100,86},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
          points={{10,86},{100,86},{100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
        annotation (Line(
          points={{-44,0},{-56,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
          points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-74.5,
            1.22465e-015}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));

      connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
          points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(legsArtys.q_in,sequesteredBlood. referencePoint) annotation (Line(
          points={{80,-78},{90,-78}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(sequesteredBlood.ExternalPressure,const8. y) annotation (Line(
          points={{81,-68},{81,-64.5},{85.125,-64.5}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(legsArtys.q_out,hydrostaticDifference. q_down) annotation (Line(
          points={{64,-78},{62,-78}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(hydrostaticDifference.q_up, systemicArtys.q_in) annotation (Line(
        points={{62,-68},{62,0},{75.5,0},{75.5,0.5}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(sequesteredBlood1.ExternalPressure,const12. y) annotation (Line(
          points={{-61.1,-64},{-61.1,-56.5},{-59.875,-56.5}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(sequesteredBlood1.referencePoint,legsVeins. q_in) annotation (
          Line(
          points={{-53,-73},{-42,-73}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(legsVeins.q_out,hydrostaticDifference1. q_down) annotation (
          Line(
          points={{-28,-73},{-28,-74},{-23,-74}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(hydrostaticDifference1.q_up,
        systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
          points={{-23,-64},{-23,0},{-44,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(hydrostaticDifference1.height, busConnector.LowerTorsoVeinHeight)
        annotation (Line(
          points={{-9,-68},{46,-68},{46,50}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(hydrostaticDifference1.pumpEffect, busConnector.Exercise_MusclePump_Effect)
        annotation (Line(
          points={{-15,-58},{46,-58},{46,50}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(hydrostaticDifference.height, busConnector.LowerTorsoArtyHeight)
        annotation (Line(
          points={{48,-72},{46,-72},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(sequesteredBlood1.Vol, busConnector.LegVeins_DeoxygenatedBloodVolume)
        annotation (Line(
          points={{-56.6,-82},{-58,-82},{-58,-90},{46,-90},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(sequesteredBlood.Vol, busConnector.LegArtys_OxygenatedBloodVolume)
        annotation (Line(
          points={{86,-88},{86,-90},{46,-90},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(G.y,hydrostaticDifference1. G) annotation (Line(
          points={{34,21.6},{34,-90},{-15,-90},{-15,-78}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(G.y,hydrostaticDifference. G) annotation (Line(
          points={{34,21.6},{34,-90},{54,-90},{54,-82}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
      annotation (Line(
        points={{81.8,-10},{72,-10},{72,-28},{46,-28},{46,50}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(systemicVeinsElacticBloodCompartment.Vol, busConnector.SystemicVeins_DeoxygenatedBloodVolume)
      annotation (Line(
        points={{-48,-10},{-48,-28},{46,-28},{46,50}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(systemicArtys.q_in, pressureMeasure1.q_in) annotation (Line(
        points={{75.5,0.5},{82,0.5},{82,-34}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pressureMeasure1.pressure, busConnector.SystemicArtys_Pressure)
      annotation (Line(
        points={{92,-32},{98,-32},{98,-42},{46,-42},{46,50}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(splanchnicCirculation.q_out, veins.q_out) annotation (Line(
        points={{-6,-25},{-72,-25},{-72,0}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
     annotation (Diagram(coordinateSystem(preserveAspectRatio=false,extent={{-100,
              -100},{100,100}}),   graphics={Text(
              extent={{42,46},{74,46}},
              lineColor={0,0,255},
              textString="Carotid Artery Pressure")}),
                                     Icon(coordinateSystem(
              preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
            graphics={
            Text(
              extent={{-104,-54},{110,-76}},
              lineColor={0,0,255},
              textString="%name")}),
      Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>",
        info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
    end SystemicCirculationFullDynamic;

    model PeripheralCirculation
      import QHP = Physiomodel;
      extends Physiomodel.CardioVascular2.Microcirculation.Interfaces.BaseDO;
      extends Physiolibrary.Icons.PeripheralCirculation;

      QHP.CardioVascular.Microcirculation.TissueBloodFlow
                                                       bone(Cond=
          4.536109889163e-10)
        annotation (Placement(transformation(extent={{-38,62},{-12,88}})));
      QHP.CardioVascular.Microcirculation.TissueBloodFlow
                                                        brain(
      onAnesthesia=false,
      onAngiotensinII=false,
      onVasopressin=false,
      onCatecholamines=false,
      onOxygenAndCarbonDioxide=true,
        VasculatureConductanceOnPO2={{27,1.2,0},{37,1.0,-0.03},{47,0.8,0}},
        onOxygenOnly=false,
      Cond=1.1375933900326e-09)
        annotation (Placement(transformation(extent={{12,44},{38,70}})));
      QHP.CardioVascular.Microcirculation.TissueBloodFlow
                                                      fat(Cond=
          3.3752770913055e-10)
        annotation (Placement(transformation(extent={{-38,26},{-12,52}})));
      Physiomodel.CardioVascular2.Microcirculation.Kidney kidney
        annotation (Placement(transformation(extent={{18,8},{44,34}})));
      Physiomodel.CardioVascular2.Microcirculation.Skin skin
        annotation (Placement(transformation(extent={{22,-34},{46,-10}})));
      QHP.CardioVascular.Microcirculation.TissueBloodFlow     otherTissue(Cond=
          5.2504310309196e-10)
        annotation (Placement(transformation(extent={{-36,-98},{-10,-72}})));
      QHP.CardioVascular.Microcirculation.TissueBloodFlow        skeletalMuscle(
      Cond=9.0007389101479e-10,
      onOxygenNeed=true,
      onExercise=true)
        annotation (Placement(transformation(extent={{-34,-54},{-8,-28}})));
      QHP.CardioVascular.Microcirculation.TissueBloodFlow
        respiratoryMuscle(Cond=1.3751128890504e-10, onOxygenNeed=true)
        annotation (Placement(transformation(extent={{20,-78},{46,-52}})));
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{-100,80},{-80,100}}), iconTransformation(
            extent={{60,10},{78,28}})));
    equation

      connect(bone.q_in, flowMeasure.q_out) annotation (Line(
          points={{-12,75},{68,75},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(brain.q_in, flowMeasure.q_out) annotation (Line(
          points={{38,57},{68,57},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(fat.q_in, flowMeasure.q_out) annotation (Line(
          points={{-12,39},{68,39},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(skin.q_in, flowMeasure.q_out) annotation (Line(
          points={{46,-22},{68,-22},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(otherTissue.q_in, flowMeasure.q_out)  annotation (Line(
          points={{-10,-85},{68,-85},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(skeletalMuscle.q_in, flowMeasure.q_out)  annotation (Line(
          points={{-8,-41},{68,-41},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(respiratoryMuscle.q_in, flowMeasure.q_out) annotation (Line(
          points={{46,-65},{68,-65},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(respiratoryMuscle.q_out,q_out) annotation (Line(
          points={{20,-65},{-84,-65},{-84,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(skeletalMuscle.q_out,q_out)  annotation (Line(
          points={{-34,-41},{-84,-41},{-84,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(otherTissue.q_out,q_out)  annotation (Line(
          points={{-36,-85},{-84,-85},{-84,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(skin.q_out,q_out) annotation (Line(
          points={{22,-22},{-84,-22},{-84,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(fat.q_out,q_out) annotation (Line(
          points={{-38,39},{-84,39},{-84,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(brain.q_out,q_out) annotation (Line(
          points={{12,57},{-84,57},{-84,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(bone.q_out,q_out) annotation (Line(
          points={{-38,75},{-84,75},{-84,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));
      connect(busConnector, otherTissue.busConnector)  annotation (Line(
          points={{-90,90},{52,90},{52,-77.2},{-12.6,-77.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, skin.busConnector) annotation (Line(
          points={{-90,90},{52,90},{52,-19.72},{42.28,-19.72}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, kidney.busConnector) annotation (Line(
          points={{-90,90},{52,90},{52,23.47},{39.97,23.47}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, fat.busConnector) annotation (Line(
          points={{-90,90},{52,90},{52,46.8},{-14.6,46.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, brain.busConnector) annotation (Line(
          points={{-90,90},{52,90},{52,64.8},{35.4,64.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, bone.busConnector) annotation (Line(
          points={{-90,90},{52,90},{52,82.8},{-14.6,82.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, skeletalMuscle.busConnector)  annotation (Line(
          points={{-90,90},{-48,90},{-48,-33.2},{-10.6,-33.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(busConnector, respiratoryMuscle.busConnector) annotation (
          Line(
          points={{-90,90},{52,90},{52,-57.2},{43.4,-57.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(bone.BloodFlow, busConnector.bone_BloodFlow)
        annotation (Line(
          points={{-15.9,68.5},{52,68.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(brain.BloodFlow, busConnector.brain_BloodFlow)
        annotation (Line(
          points={{34.1,50.5},{52,50.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(fat.BloodFlow, busConnector.fat_BloodFlow) annotation (
         Line(
          points={{-15.9,32.5},{52,32.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(kidney.BloodFlow, busConnector.kidney_BloodFlow)
        annotation (Line(
          points={{40.1,14.5},{52,14.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(skin.BloodFlow, busConnector.skin_BloodFlow)
        annotation (Line(
          points={{42.4,-28},{52,-28},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(skeletalMuscle.BloodFlow, busConnector.skeletalMuscle_BloodFlow)
        annotation (Line(
          points={{-11.9,-47.5},{52,-47.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(respiratoryMuscle.BloodFlow, busConnector.respiratoryMuscle_BloodFlow)
        annotation (Line(
          points={{42.1,-71.5},{52,-71.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(otherTissue.BloodFlow, busConnector.otherTissue_BloodFlow)
        annotation (Line(
          points={{-13.9,-91.5},{52,-91.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));

        connect(bone.BloodFlow, busConnector.Bone_BloodFlow)
        annotation (Line(
          points={{-15.9,68.5},{52,68.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(brain.BloodFlow, busConnector.Brain_BloodFlow)
        annotation (Line(
          points={{34.1,50.5},{52,50.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(fat.BloodFlow, busConnector.Fat_BloodFlow) annotation (
         Line(
          points={{-15.9,32.5},{52,32.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(kidney.BloodFlow, busConnector.Kidney_BloodFlow)
        annotation (Line(
          points={{40.1,14.5},{52,14.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(skin.BloodFlow, busConnector.Skin_BloodFlow)
        annotation (Line(
          points={{42.4,-28},{52,-28},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(skeletalMuscle.BloodFlow, busConnector.SkeletalMuscle_BloodFlow)
        annotation (Line(
          points={{-11.9,-47.5},{52,-47.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(respiratoryMuscle.BloodFlow, busConnector.RespiratoryMuscle_BloodFlow)
        annotation (Line(
          points={{42.1,-71.5},{52,-71.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(otherTissue.BloodFlow, busConnector.OtherTissue_BloodFlow)
        annotation (Line(
          points={{-13.9,-91.5},{52,-91.5},{52,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(kidney.q_out,q_out) annotation (Line(
          points={{18,21},{-84,21},{-84,0},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(kidney.q_in, flowMeasure.q_out) annotation (Line(
          points={{44,21},{68,21},{68,0},{78,0}},
          color={0,0,0},
          smooth=Smooth.None,
          thickness=1));

    connect(bone.tissueConnector, busConnector.bone) annotation (Line(
        points={{-25,85.4},{-24.5,85.4},{-24.5,90},{-90,90}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None));
    connect(fat.tissueConnector, busConnector.fat) annotation (Line(
        points={{-25,49.4},{-48,49.4},{-48,90},{-90,90}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None));
    connect(skeletalMuscle.tissueConnector, busConnector.skeletalMuscle)
      annotation (Line(
        points={{-21,-30.6},{-48,-30.6},{-48,90},{-90,90}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None));
    connect(otherTissue.tissueConnector, busConnector.otherTissue)
      annotation (Line(
        points={{-23,-74.6},{-48,-74.6},{-48,90},{-90,90}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None));
    connect(brain.tissueConnector, busConnector.brain) annotation (Line(
        points={{25,67.4},{25,90},{-90,90}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None));
    connect(respiratoryMuscle.tissueConnector, busConnector.respiratoryMuscle)
      annotation (Line(
        points={{33,-54.6},{34,-54.6},{34,-54},{52,-54},{52,90},{-90,90}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None));
      annotation (
        Documentation(info="<HTML>
<PRE>
Blood resistance in peripheral organs except hepatic artery, gastro interstitional tract, vena porte, liver and liver veins.
</PRE>
</HTML>
",   revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"),
         Icon(graphics={Text(
              extent={{-100,-128},{100,-100}},
              lineColor={0,0,255},
              textString="%name")}));
    end PeripheralCirculation;

    model SplanchnicCirculation
      extends Physiolibrary.Icons.PerfusionDO;
      extends Physiolibrary.Icons.GITract;

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,
              10}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-110,-10},{
              -90,10}})));

    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{56,-56},{76,-36}}), iconTransformation(
            extent={{-108,42},{-92,58}})));

    Physiolibrary.Hydraulic.Components.ElasticVessel portalVein(
      stateName="SplanchnicVeins.Vol",
      useExternalPressureInput=true,
      useV0Input=true,
      useComplianceInput=false,
      volume_start=0.00100999,
      Compliance=4.6878848490354e-07)
      annotation (Placement(transformation(extent={{-16,-10},{5,11}})));
    Microcirculation.TissueBloodFlow GITract(Cond=1.4001149415786e-09)
      annotation (Placement(transformation(extent={{34,-12},{58,12}})));
    Physiolibrary.Types.Constants.PressureConst ExternalPressure(k=0)
      annotation (Placement(transformation(extent={{24,20},{16,28}})));
    Physiolibrary.Types.Constants.HydraulicComplianceConst Compliance(k=
          4.6878848490354e-07)
      annotation (Placement(transformation(extent={{10,32},{2,40}})));
    Physiolibrary.Types.Constants.VolumeConst               V0(k(displayUnit=
            "ml") = 0.0005)
      annotation (Placement(transformation(extent={{-27,11},{-19,19}})));
    Microcirculation.Liver liver
      annotation (Placement(transformation(extent={{-56,34},{-32,58}})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
      annotation (Placement(transformation(extent={{6,-42},{26,-22}})));
    equation

      connect(GITract.busConnector,busConnector)           annotation (Line(
          points={{55.6,7.2},{66,7.2},{66,-46}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(portalVein.externalPressure, ExternalPressure.y)
                                                         annotation (Line(
          points={{2.9,8.9},{2.9,24},{15,24}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(portalVein.zeroPressureVolume, V0.y) annotation (Line(
        points={{-13.9,8.9},{-13.9,15},{-18,15}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(GITract.BloodFlow, busConnector.GITract_BloodFlow) annotation (
          Line(
          points={{54.4,-6},{66,-6},{66,-46}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(V0.y, busConnector.PortalVein_V0)      annotation (Line(
          points={{-18,15},{-14,15},{-14,-46},{66,-46}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(portalVein.volume, busConnector.SplanchnicCirculation_DeoxygenatedBloodVolume)
      annotation (Line(
        points={{0.8,-10},{0.8,-46},{66,-46}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(portalVein.q_in, liver.portalVein) annotation (Line(
        points={{-5.5,0.5},{-41.36,0.5},{-41.36,40.24}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(busConnector, liver.busConnector) annotation (Line(
          points={{66,-46},{66,48.28},{-35.72,48.28}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
    connect(GITract.q_out, portalVein.q_in) annotation (Line(
        points={{34,0},{14.25,0},{14.25,0.5},{-5.5,0.5}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(GITract.q_in, q_in) annotation (Line(
          points={{58,0},{100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(liver.q_in, q_in) annotation (Line(
          points={{-32,46},{82,46},{82,0},{100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(liver.q_out, q_out) annotation (Line(
          points={{-56,46},{-82,46},{-82,0},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(portalVein.q_in, pressureMeasure.q_in) annotation (Line(
        points={{-5.5,0.5},{4,0.5},{4,-38},{12,-38}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pressureMeasure.pressure, busConnector.SplanchnicVeins_Pressure)
      annotation (Line(
        points={{22,-36},{44,-36},{44,-46},{66,-46}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(GITract.tissueConnector, busConnector.GITract) annotation (
        Line(
        points={{46,9.6},{66,9.6},{66,-46}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
      annotation (       Icon(coordinateSystem(
              preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
            graphics={
            Text(
              extent={{-104,-76},{110,-98}},
              lineColor={0,0,255},
              textString="%name")}),
      Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>",
        info="<html>
<p>Blood volume (and pressures) distribution between </p>
<p><ul>
<li>pulmonary arteries, </li>
<li>pulmonary veins and </li>
<li>pulmonary capilaries.</li>
</ul></p>
<p>Blood flow through ventilated alveoli.</p>
</html>"));
    end SplanchnicCirculation;

    model LungBloodFlow
        extends Physiolibrary.Icons.LungShunt;
      Physiolibrary.Types.RealIO.VolumeFlowRateInput CardiacOutput
        annotation (Placement(transformation(extent={{-120,40},{-80,80}})));

      parameter Physiolibrary.Types.Fraction BasicRLShuntFraction(displayUnit="%") =  0.02
      "basic percentage of total blood flow not exposed to lung air";                                                            //
    //  parameter Real BasicRLShunt(final displayUnit="ml/min") =  110; // 220.0;
      parameter Physiolibrary.Types.Pressure RightHemithorax_Pressure( displayUnit="mmHg") =   -533.28954966;
      parameter Physiolibrary.Types.Pressure LeftHemithorax_Pressure( displayUnit="mmHg") =   -533.28954966;

      Physiolibrary.Types.Pressure PressureGradientRightLeft(displayUnit="mmHg")
      "difference between right and left hemithorax pressure";
      Physiolibrary.Types.Fraction Thorax_RightLungFlowFract(displayUnit="1")
      "fraction of blood flow to right lung";
      Physiolibrary.Types.Fraction Thorax_LeftLungFlowFract(displayUnit="1")
      "fraction of blood flow to left lung";
      Physiolibrary.Types.Fraction RightHemithorax_LungInflation(displayUnit="1")
      "dammage effect of right hemithorax inflation";
      Physiolibrary.Types.Fraction LeftHemithorax_LungInflation(displayUnit="1")
      "dammage effect of left hemithorax inflation";
      Physiolibrary.Types.VolumeFlowRate Total(displayUnit="ml/min")
      "cardiac output";

      Physiolibrary.Types.VolumeFlowRate RightLeftShunt(displayUnit="ml/min")
      "blood flow not exposed to lung air without dammage effect";
      Physiolibrary.Types.VolumeFlowRate Alveolar(displayUnit="ml/min")
      "blood flow exposed to lung air without dammage effect";

    //  Real RightLungTotal(final displayUnit="ml/min") "right lung blood flow exposed to lung air without dammage effect";
    //  Real RightLungVentilated(final displayUnit="ml/min") "right lung blood flow exposed to lung air";
    //  Real RightLungShunt(final displayUnit="ml/min");
    //  Real LeftLungTotal(final displayUnit="ml/min");
    //  Real LeftLungVentilated(final displayUnit="ml/min");
    //  Real LeftLungShunt(final displayUnit="ml/min");
    //  Real AlveolarShunt(final displayUnit="ml/min");
    //  Real TotalShunt(final displayUnit="ml/min");

      parameter Real[:,3] PressureOnInflation =   {{ -4.0,  1.0,  0}, {  4.0,  0.0,  0}};
      parameter Real[:,3] PressureGradientOnFlowDist =   {{ -25,  0.0,  0}, {   0,  0.5,  0.03}, {  25,  1.0,  0}};

      Physiolibrary.Types.RealIO.VolumeFlowRateOutput AlveolarVentilated(
                                                        final displayUnit="ml/min") annotation (Placement(transformation(extent={{80,40},{120,80}}),
            iconTransformation(extent={{80,40},{120,80}})));
    Physiolibrary.Blocks.Interpolation.Curve
      Thorax_PressureGradientOnFlowDist(
      x=PressureGradientOnFlowDist[:, 1],
      y=PressureGradientOnFlowDist[:, 2],
      slope=PressureGradientOnFlowDist[:, 3],
        Xscale=101325/760)
      annotation (Placement(transformation(extent={{-40,52},{-20,72}})));
    Physiolibrary.Blocks.Interpolation.Curve Thorax_PressureOnInflationR(
      x=PressureOnInflation[:, 1],
      y=PressureOnInflation[:, 2],
      slope=PressureOnInflation[:, 3],
        Xscale=101325/760)
      annotation (Placement(transformation(extent={{52,46},{72,66}})));
    Physiolibrary.Blocks.Interpolation.Curve Thorax_PressureOnInflationL(
      x=PressureOnInflation[:, 1],
      y=PressureOnInflation[:, 2],
      slope=PressureOnInflation[:, 3],
        Xscale=101325/760)
      annotation (Placement(transformation(extent={{-2,-24},{18,-4}})));
    equation
           PressureGradientRightLeft  =  RightHemithorax_Pressure - LeftHemithorax_Pressure;

    //division between left and rigth lung blood flow by hemithorax pressure
           Thorax_PressureGradientOnFlowDist.u = PressureGradientRightLeft;
           Thorax_LeftLungFlowFract  =  Thorax_PressureGradientOnFlowDist.val;
           Thorax_RightLungFlowFract  =  1.0 - Thorax_LeftLungFlowFract;

    //damage effect of hemithorax pressure
           Thorax_PressureOnInflationR.u = RightHemithorax_Pressure;
           RightHemithorax_LungInflation = Thorax_PressureOnInflationR.val;
           Thorax_PressureOnInflationL.u = LeftHemithorax_Pressure;
           LeftHemithorax_LungInflation = Thorax_PressureOnInflationL.val;

           Total  =  CardiacOutput;
           RightLeftShunt  = BasicRLShuntFraction*Total; //min(BasicRLShunt,Total);
           Alveolar  =  Total - RightLeftShunt;
    //       RightLungTotal  =  Alveolar * Thorax_RightLungFlowFract;
    //       RightLungVentilated  =  RightLungTotal * RightHemithorax_LungInflation;
    //       RightLungShunt  =  RightLungTotal - RightLungVentilated;
    //       LeftLungTotal  =  Alveolar * Thorax_LeftLungFlowFract;
    //       LeftLungVentilated  =  LeftLungTotal * LeftHemithorax_LungInflation;
    //       LeftLungShunt  =  LeftLungTotal - LeftLungVentilated;
    //       AlveolarVentilated  =  RightLungVentilated + LeftLungVentilated;
    //       AlveolarShunt  =  RightLungShunt + LeftLungShunt;
    //       TotalShunt  =  RightLeftShunt + AlveolarShunt;
           AlveolarVentilated  = Alveolar * ( Thorax_RightLungFlowFract * RightHemithorax_LungInflation + Thorax_LeftLungFlowFract * LeftHemithorax_LungInflation);
      annotation ( Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>",
        info="<html>
<p>Calculation of blood flow fraction through ventilated alveoli.</p>
</html>"),
        Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                {100,100}}), graphics={                             Text(
              extent={{-102,-92},{112,-114}},
              lineColor={0,0,255},
              textString="%name")}));
    end LungBloodFlow;

    model SystemicVeinsElacticBloodCompartment
     extends Physiolibrary.Icons.ElasticBalloon;

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(
          extent={{-10,-10},{10,10}})));
      Physiolibrary.Types.RealIO.PressureInput ExternalPressure
      "external pressure around the compartment"                              annotation (extent = [-10,90;10,110], rotation = -90,
      Placement(transformation(
          origin={0,100},
          extent={{-10,-10},{10,10}},
          rotation=270)));
      Physiolibrary.Types.RealIO.HydraulicComplianceInput Compliance( displayUnit="ml/mmHg")
      "elasticity of the stressed walls"                               annotation (extent = [50,90;70,110], rotation = -90,
      Placement(transformation(
          origin={60,100},
          extent={{-10,-10},{10,10}},
          rotation=270)));

      Physiolibrary.Types.RealIO.PressureOutput Pressure( displayUnit="mmHg")
      "blod pressure in compartment"
        annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
      Physiolibrary.Types.RealIO.VolumeOutput Vol
      "blood volume in compartment"
        annotation (Placement(transformation(extent={{-50,-110},{-30,-90}}, rotation=-90),
            iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={-40,-100})));
    Physiolibrary.Types.BusConnector busConnector annotation (Placement(
          transformation(extent={{-88,72},{-68,92}}), iconTransformation(
            extent={{88,51},{108,71}})));
      Physiolibrary.Hydraulic.Components.ElasticVessel systemicVeins(
        stateName="SystemicVeins.Vol",
        useComplianceInput=true,
        useExternalPressureInput=true,
        useV0Input=true,
      volume_start=initialSystemisVeinsVol) "systemic veins"
        annotation (Placement(transformation(extent={{-14,-10},{6,10}})));
    Physiolibrary.Blocks.Factors.Spline V0_A2_Effect(
      data={{0.0,1.05,0.0},{1.3,1.00,-0.10},{3.0,0.85,0.0}},
      Xscale=1e-9/Substances.AngiotensinII.mw,
      UsePositiveLog10=true)
      annotation (Placement(transformation(extent={{-30,7},{-10,27}})));
    Physiolibrary.Types.Constants.VolumeConst               const4(k=0.0017)
      annotation (Placement(transformation(extent={{-32,48},{-23,39}})));
      Physiomodel.Nerves.AplhaReceptorsActivityFactor AplhaReceptors(
        data={{0.0,1.2,0.0},{1.0,1.0,-0.30},{3.0,0.6,0.0}},
      NEURALK=0.333,
      HUMORALK=0.5)
        annotation (Placement(transformation(extent={{-30,20},{-10,40}})));
      Physiolibrary.Types.RealIO.VolumeOutput V0(displayUnit="ml")
      "maximal zero pressure blood volume in compartment"
        annotation (Placement(transformation(extent={{-4.5,-4.5},{4.5,4.5}},rotation=180,
            origin={-27.5,5.5}),
            iconTransformation(
            extent={{-10,-10},{10,10}},
            rotation=90,
            origin={-68,100})));

      parameter Physiolibrary.Types.Volume initialSystemisVeinsVol = 2329.57e-6; // = 2200;// = 2980;

      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(extent={{16,-20},{36,0}})));
    equation
      connect(V0_A2_Effect.y, systemicVeins.zeroPressureVolume) annotation (Line(
          points={{-20,13},{-20,12},{-12,12},{-12,8}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AplhaReceptors.y,V0_A2_Effect. yBase) annotation (Line(
          points={{-20,23},{-20,19}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AplhaReceptors.yBase,const4. y) annotation (Line(
          points={{-20,37},{-20,43.5},{-21.875,43.5}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(systemicVeins.q_in, referencePoint) annotation (Line(
          points={{-4,0},{-100,0}},
          color={0,0,0},
          smooth=Smooth.None));
      connect(systemicVeins.volume, Vol) annotation (Line(
          points={{2,-10},{2,-67},{-40,-67},{-40,-100}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(systemicVeins.externalPressure, ExternalPressure) annotation (Line(
          points={{4,8},{4,67},{0,67},{0,100}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(systemicVeins.compliance, Compliance) annotation (Line(
          points={{-4,8},{-4,50},{60,50},{60,100}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.GangliaGeneral_NA, AplhaReceptors.GangliaGeneral_NA)
        annotation (Line(
          points={{-78,82},{-78,24},{-29.8,24}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.AlphaPool_Effect, AplhaReceptors.AlphaPool_Effect)
        annotation (Line(
          points={{-78,82},{-78,36},{-29.8,36}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.AlphaBlocade_Effect, AplhaReceptors.AlphaBlockade_Effect)
        annotation (Line(
          points={{-78,82},{-78,30},{-29.8,30}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(V0_A2_Effect.y, V0) annotation (Line(
          points={{-20,13},{-20,5.5},{-27.5,5.5}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(systemicVeins.q_in, pressureMeasure.q_in) annotation (Line(
          points={{-4,0},{10,0},{10,-16},{22,-16}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(pressureMeasure.pressure, Pressure) annotation (Line(
        points={{32,-14},{40,-14},{40,-100}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(busConnector.Angiotensin2, V0_A2_Effect.u) annotation (Line(
        points={{-78,82},{-78,17},{-28,17}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
     annotation (
        Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.

</PRE>
</HTML>
",   revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
    end SystemicVeinsElacticBloodCompartment;

    model SequesteredBlood
     extends Interfaces.ISequesteredBlood;

    parameter Physiolibrary.Types.Volume initialVol
      "initial compartment blood volume";
     parameter Real[:,3] data;

    Physiolibrary.Blocks.Interpolation.Curve curve(
      x=data[:, 1],
      y=data[:, 2],
      slope=data[:, 3],
      Xscale=1e-6,
      Yscale=101325/760)
      annotation (Placement(transformation(extent={{-60,50},{-40,70}})));

      Modelica.Blocks.Math.Add add annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={-6,40})));
      Physiolibrary.Hydraulic.Components.ElasticVessel pressureControledCompartment(
      ZeroPressureVolume(displayUnit="l") = 0.002,
      useExternalPressureInput=true,
      volume_start=initialVol)
      annotation (Placement(transformation(extent={{-24,-10},{-4,10}})));
    equation
      connect(curve.val, add.u2) annotation (Line(
          points={{-40,60},{-12,60},{-12,52}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(ExternalPressure, add.u1) annotation (Line(
          points={{-90,100},{-90,52},{1.77636e-015,52}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(add.y, Pressure) annotation (Line(
          points={{-6,29},{-6,20},{40,20},{40,-100}},
          color={0,0,127},
          smooth=Smooth.None));

    connect(referencePoint, pressureControledCompartment.q_in) annotation (
        Line(
        points={{-100,0},{-18,0},{-18,2.22045e-016},{-14,2.22045e-016}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pressureControledCompartment.volume, Vol) annotation (Line(
        points={{-8,-10},{-8,-42},{-40,-42},{-40,-100}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(pressureControledCompartment.volume, curve.u) annotation (Line(
        points={{-8,-10},{-8,-42},{-70,-42},{-70,60},{-60,60}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(add.y, pressureControledCompartment.externalPressure) annotation (
       Line(
        points={{-6,29},{-6,8}},
        color={0,0,127},
        smooth=Smooth.None));
     annotation (
        Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.

</PRE>
</HTML>
",   revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),
         Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                {100,100}}), graphics={Text(
              extent={{-100,-16},{100,-32}},
              lineColor={0,0,255},
              textString="(initial %initialVol ml)")}));
    end SequesteredBlood;

    model CollapsingVeins
    extends Physiolibrary.Icons.CollapsingVessel;

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,
              10}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-110,-10},{
              -90,10}})));

    Modelica.Blocks.Interfaces.RealInput ExternalPressure
                                                     annotation (Placement(
            transformation(extent={{40,0},{80,40}}), iconTransformation(
            extent={{-20,-20},{20,20}},
            rotation=270,
            origin={60,20})));

      parameter Real PR1LL( final quantity="Pressure", final displayUnit="mmHg") = 0
      "start-collapsing sucking pressure, when external pressure is zero";
    equation
       q_in.q + q_out.q = 0;

       q_in.pressure = if (q_out.pressure > (PR1LL+ExternalPressure)) then q_out.pressure else (PR1LL+ExternalPressure);

      annotation (Icon(graphics={
            Text(
              extent={{-62,-32},{58,-58}},
              lineColor={0,0,255},
              textString="%name")}));
    end CollapsingVeins;

    model SystemicVeins
      //extends QHP.Blood.OrganFlow.BaseBadDirection;
    extends Physiolibrary.Icons.Resistor;

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,
              10}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-110,-10},{
              -90,10}})));

    Physiolibrary.Hydraulic.Components.Conductor systemicVeinsConductance(
        useConductanceInput=true)
      annotation (Placement(transformation(extent={{0,-10},{-20,10}})));
    Physiolibrary.Blocks.Factors.Normalization ViscosityEffect
      annotation (Placement(transformation(extent={{-20,0},{0,20}})));
    Physiolibrary.Blocks.Factors.Normalization ExerciseEffect
      annotation (Placement(transformation(extent={{-20,7},{0,27}})));
    Physiolibrary.Blocks.Factors.Normalization CollapseEffect
      annotation (Placement(transformation(extent={{-20,14},{0,34}})));
    Physiolibrary.Types.Constants.HydraulicConductanceConst const12(k=
          BaseConductance)
      annotation (Placement(transformation(extent={{-27,45},{-15,57}})));
      parameter Physiolibrary.Types.HydraulicConductance BaseConductance( displayUnit="ml/(mmHg.min)");

    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
        Placement(transformation(
          extent={{10,-10},{-10,10}},
          origin={80,0})));
      Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                               annotation (Placement(transformation(
              extent={{76,6},{88,18}}),    iconTransformation(extent={{60,-30},{80,-10}})));
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{-96,77},{-76,97}}), iconTransformation(
            extent={{60,10},{78,28}})));
    equation
      connect(systemicVeinsConductance.cond,ViscosityEffect. y) annotation (Line(
          points={{-10,6},{-10,6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(ViscosityEffect.yBase,ExerciseEffect. y) annotation (Line(
          points={{-10,12},{-10,13}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(ExerciseEffect.yBase,CollapseEffect. y) annotation (Line(
          points={{-10,19},{-10,19.5},{-10.2,19.5},{-10.2,20},{-10,20},{-10,20}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.Viscosity_ConductanceEffect,
        ViscosityEffect.u) annotation (Line(
          points={{-86,87},{-86,10},{-18,10}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Exercise_MusclePump_Effect,
        ExerciseEffect.u) annotation (Line(
          points={{-86,87},{-86,17},{-18,17}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.BloodVol_CollapsedEffect, CollapseEffect.u)
        annotation (Line(
          points={{-86,87},{-86,24},{-18,24}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(const12.y, CollapseEffect.yBase) annotation (Line(
          points={{-13.5,51},{-10,51},{-10,26}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(flowMeasure.volumeFlow,BloodFlow)  annotation (Line(
          points={{80,12},{80,12},{82,12}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(flowMeasure.q_in, q_in) annotation (Line(
          points={{90,0},{100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.q_out, systemicVeinsConductance.q_in) annotation (
          Line(
          points={{70,0},{0,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(systemicVeinsConductance.q_out, q_out) annotation (Line(
          points={{-20,0},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      annotation ( Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Text(
              extent={{-70,-30},{70,30}},
              lineColor={0,0,0},
              textString="%BaseConductance ml/min/mmHg"), Text(
              extent={{-101,-58},{99,-30}},
              lineColor={0,0,255},
              textString="%name")}));
    end SystemicVeins;

    package develop
      extends Modelica.Icons.UnderConstruction;
      model SystemicCirculation_Simplified
        extends SystemicCirculationBase2_Simplified;
      Physiolibrary.Hydraulic.Components.Conductor legsArtys(Conductance=
            5.0004105056376e-009)
        annotation (Placement(transformation(extent={{80,-80},{64,-64}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant const8(k=0)
        annotation (Placement(transformation(extent={{93,-62},{86,-55}})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        hydrostaticDifference(useExternalG=true, useHeightInput=true)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={54,-66})));
        SequesteredBlood sequesteredBlood(data={{0,0,10^(-10)},{50,97,1.0},{200,150,0.5}},
            initialVol=50.0044,
          pressureControledCompartment(stateName="BVSeqArtys.Vol"))
          annotation (Placement(transformation(extent={{80,-82},{100,-62}})));
        SequesteredBlood sequesteredBlood1(                data={{0,-100,2.00},{150,11,
              0.11},{600,50,0.15}}, initialVol=120.691,
          pressureControledCompartment(stateName="BVSeqVeins.Vol"))
          annotation (Placement(transformation(extent={{-62,-76},{-44,-58}})));
      Physiolibrary.Hydraulic.Components.Conductor legsVeins(Conductance=
            1.2501026264094e-008)
        annotation (Placement(transformation(extent={{-42,-74},{-28,-60}})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        hydrostaticDifference1(
        useExternalG=true,
        useHeightInput=true,
        usePumpEffect=true)
        annotation (Placement(transformation(extent={{-5,-72},{-25,-52}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant const12(k=0)
        annotation (Placement(transformation(extent={{-52,-54},{-59,-47}})));
      equation
        connect(legsArtys.q_in,sequesteredBlood. referencePoint) annotation (Line(
            points={{76.8,-72},{90,-72}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(sequesteredBlood.ExternalPressure,const8. y) annotation (Line(
            points={{81,-62},{81,-58.5},{85.65,-58.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(legsArtys.q_out,hydrostaticDifference. q_down) annotation (Line(
            points={{67.2,-72},{63.5,-72},{63.5,-71.6},{61,-71.6}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(hydrostaticDifference.q_up, systemicArtys.q_in) annotation (Line(
          points={{61.2,-61.2},{62,-56},{62,0},{75.5,0},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(sequesteredBlood1.ExternalPressure,const12. y) annotation (Line(
            points={{-61.1,-58},{-61.1,-50.5},{-59.35,-50.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood1.referencePoint,legsVeins. q_in) annotation (
            Line(
            points={{-53,-67},{-39.2,-67}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(legsVeins.q_out,hydrostaticDifference1. q_down) annotation (
            Line(
            points={{-30.8,-67},{-30.8,-67.4},{-22,-67.4}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference1.q_up,
          systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
            points={{-22.2,-57.2},{-22.2,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference1.height, busConnector.LowerTorsoVeinHeight)
          annotation (Line(
            points={{-8.9,-62.3},{46,-62.3},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(hydrostaticDifference1.pumpEffect, busConnector.Exercise_MusclePump_Effect)
          annotation (Line(
            points={{-13.5,-52.5},{46,-52.5},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(hydrostaticDifference.height, busConnector.LowerTorsoArtyHeight)
          annotation (Line(
            points={{47.9,-66.5},{46,-66.5},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood1.Vol, busConnector.LegVeins_DeoxygenatedBloodVolume)
          annotation (Line(
            points={{-56.6,-76},{-58,-76},{-58,-84},{46,-84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood.Vol, busConnector.LegArtys_OxygenatedBloodVolume)
          annotation (Line(
            points={{86,-82},{86,-84},{46,-84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(G.y,hydrostaticDifference1. G) annotation (Line(
            points={{34,21.6},{34,-84},{-16.5,-84},{-16.5,-70.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(G.y,hydrostaticDifference. G) annotation (Line(
            points={{34,21.6},{34,-84},{55.5,-84},{55.5,-74.5}},
            color={0,0,127},
            smooth=Smooth.None));
      end SystemicCirculation_Simplified;

      model SystemicCirculationBase2_Simplified

        extends Physiolibrary.Icons.SystemicCirculation;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
        "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

        /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

      Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
        stateName="SystemicArtys.Vol",
        useComplianceInput=true,
        useExternalPressureInput=true,
        useV0Input=true,
        volume_start=0.00100036)
        annotation (Placement(transformation(extent={{65,-10},{86,11}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant V0_artys(
        units="ml",
        k=850,
        varName="SystemicArtys.V0")
        annotation (Placement(transformation(extent={{98,18},{88,28}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst const7(k=
            6.645545561992547e-007)
        annotation (Placement(transformation(extent={{-27,10},{-35,18}})));
      PeripheralCirculation peripheral
        annotation (Placement(transformation(extent={{-2,-14},{26,14}})));
      SystemicVeins veins(BaseConductance=856)
        "scaled to coronary vessels reorganisation"
        annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
        SystemicVeinsElacticBloodCompartment
          systemicVeinsElacticBloodCompartment
          annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant const4(k=0)
        annotation (Placement(transformation(extent={{86,14},{79,21}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant const6(k=0)
        annotation (Placement(transformation(extent={{-36,16},{-43,23}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{36,40},{56,60}}), iconTransformation(
              extent={{-110,32},{-94,48}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst const5(k=
            1.162595442560773e-008)
        annotation (Placement(transformation(extent={{96,8},{89,15}})));
      CollapsingVeins collapsedVeins annotation (Placement(transformation(
            extent={{-10,10.5},{10,-10.5}},
            rotation=180,
            origin={-84.5,0})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={61,35})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(
            extent={{8.5,-8.5},{-8.5,8.5}},
            origin={78.5,45.5})));
        Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
              extent={{4,-4},{-4,4}},
              rotation=90,
              origin={34,26})));
      Microcirculation.LeftHeart_Simplified leftCororaryCirculation(
          BasicLargeVeselsConductance=50*0.93677109469950528615290800207779,
          BasicSmallVeselsConductance=2.2*0.93677109469950528615290800207779)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-10,76},{10,96}})));
      Microcirculation.RightHeart_Simplified rightCororaryCirculation(
          BasicLargeVeselsConductance=10*0.93677109469950528615290800207779,
          BasicSmallVeselsConductance=0.4*0.93677109469950528615290800207779)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
      SplanchnicCirculation splanchnicCirculation
        annotation (Placement(transformation(extent={{-8,-44},{30,-6}})));
      equation
        connect(systemicArtys.compliance, const5.y) annotation (Line(
            points={{81.8,11},{81.8,11.5},{88.65,11.5}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
          points={{69.2,11},{69.2,23},{87.5,23}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(busConnector, peripheral.busConnector)          annotation (
            Line(
            points={{46,50},{46,2.66},{21.66,2.66}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(veins.busConnector,busConnector)           annotation (
           Line(
            points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(const7.y,systemicVeinsElacticBloodCompartment. Compliance)
          annotation (Line(
            points={{-35.4,14},{-38.2,14},{-38.2,10},{-38,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
          annotation (Line(
            points={{46,50},{-26,50},{-26,6.1},{-34.2,6.1}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(systemicArtys.externalPressure,const4. y) annotation (Line(
            points={{75.5,11},{75.5,17.5},{78.65,17.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.ExternalPressure,const6. y)
          annotation (Line(
            points={{-44,10},{-44,19.5},{-43.35,19.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicArtys.compliance,const5. y) annotation (Line(
            points={{81.8,11},{81.8,11.5},{88.65,11.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
          annotation (Line(
            points={{-90.5,2.1},{-90,2.1},{-90,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
        annotation (Line(
          points={{74.08,43.8},{46,43.8},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
          annotation (Line(
            points={{54.9,34.5},{46,32},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
        annotation (Line(
          points={{68,29.4},{68,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(systemicArtys.Pressure, busConnector.SystemicArtys_Pressure)
          annotation (Line(
            points={{79.7,-10},{80,-10},{80,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{3,-3},{3,-3}}));

        connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
          annotation (Line(
            points={{68.2,39.8},{80,39.8},{80,42.1},{80.2,42.1}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
        annotation (Line(
          points={{74.08,43.8},{46,43.8},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
          annotation (Line(
            points={{-40,-10},{-40,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
          annotation (Line(
            points={{-50.8,10},{-50.8,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
            points={{87.5,23},{70,23},{70,22},{46,22},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
        annotation (Line(
          points={{71.3,-10},{72,-10},{72,-28},{46,-28},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(q_in, systemicArtys.q_in) annotation (Line(
          points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(collapsedVeins.q_out, q_out) annotation (Line(
            points={{-74.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
              -100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.Gravity_Gz, G.u) annotation (Line(
            points={{46,50},{46,38},{34,38},{34,30.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
            points={{34,21.6},{34,16},{62.5,16},{62.5,26.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.busConnector, busConnector)
                                                                annotation (
            Line(
            points={{-25.1,73.9},{46,73.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.busConnector, busConnector)
                                                               annotation (Line(
            points={{6.9,87.9},{46,87.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
          annotation (Line(
            points={{7,84},{46,84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
          annotation (Line(
            points={{-25,70},{22,70},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
          annotation (Line(
            points={{7,84},{46,84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
          annotation (Line(
            points={{-25,70},{22,70},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(splanchnicCirculation.busConnector, busConnector) annotation (
            Line(
            points={{-8,-15.5},{-8,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
          points={{30,-25},{62,-25},{62,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(splanchnicCirculation.q_out,
          systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
            points={{-8,-25},{-22,-25},{-22,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
          points={{26,1.77636e-015},{52,1.77636e-015},{52,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
          annotation (Line(
            points={{-2,1.77636e-015},{-24,1.77636e-015},{-24,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-10,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
            points={{10,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
          annotation (Line(
            points={{-44,0},{-56,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
            points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-94.5,
              1.22465e-015}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));

        connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
            points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
       annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{42,46},{74,46}},
                lineColor={0,0,255},
                textString="Carotid Artery Pressure")}),
                                       Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-104,-54},{110,-76}},
                lineColor={0,0,255},
                textString="%name")}),
        Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>", info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
      end SystemicCirculationBase2_Simplified;

      model SystemicCirculationBase2

         extends Physiolibrary.Icons.SystemicCirculation;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
        "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

        /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

      Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
        stateName="SystemicArtys.Vol",
        useComplianceInput=true,
        useExternalPressureInput=true,
        useV0Input=true,
        volume_start=0.00100036)
        annotation (Placement(transformation(extent={{65,-10},{86,11}})));
      Physiolibrary.Types.Constants.VolumeConst V0_artys(k=0.00085)
        annotation (Placement(transformation(extent={{98,18},{88,28}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst const7(k=
            6.645545561992547e-007)
        annotation (Placement(transformation(extent={{-25,10},{-33,18}})));
      PeripheralCirculation peripheral
        annotation (Placement(transformation(extent={{-2,-14},{26,14}})));
      SystemicVeins veins(BaseConductance=856)
        "scaled to coronary vessels reorganisation"
        annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
      SystemicVeinsElacticBloodCompartment2
        systemicVeinsElacticBloodCompartment
        annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant const4(k=0)
        annotation (Placement(transformation(extent={{86,14},{78,22}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant const6(k=0)
        annotation (Placement(transformation(extent={{-34,16},{-43,25}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{36,40},{56,60}}), iconTransformation(
              extent={{-110,32},{-94,48}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst const5(k=
            1.162595442560773e-008)
        annotation (Placement(transformation(extent={{98,6},{89,15}})));
      CollapsingVeins collapsedVeins annotation (Placement(transformation(
            extent={{-10,10.5},{10,-10.5}},
            rotation=180,
            origin={-84.5,0})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={61,35})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(
            extent={{8.5,-8.5},{-8.5,8.5}},
            origin={78.5,45.5})));
        Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
              extent={{4,-4},{-4,4}},
              rotation=90,
              origin={34,26})));
      Microcirculation.LeftHeart leftCororaryCirculation(
          BasicLargeVeselsConductance=50*0.93677109469950528615290800207779,
          BasicSmallVeselsConductance=2.2*0.93677109469950528615290800207779)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-10,76},{10,96}})));
      Microcirculation.RightHeart rightCororaryCirculation(
          BasicLargeVeselsConductance=10*0.93677109469950528615290800207779,
          BasicSmallVeselsConductance=0.4*0.93677109469950528615290800207779)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
      SplanchnicCirculation splanchnicCirculation
        annotation (Placement(transformation(extent={{-8,-44},{30,-6}})));
      equation
        connect(systemicArtys.compliance, const5.y) annotation (Line(
            points={{81.8,11},{81.8,10.5},{88.55,10.5}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
          points={{69.2,11},{69.2,23},{87.5,23}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(busConnector, peripheral.busConnector)          annotation (
            Line(
            points={{46,50},{46,2.66},{21.66,2.66}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(veins.busConnector,busConnector)           annotation (
           Line(
            points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(const7.y,systemicVeinsElacticBloodCompartment. Compliance)
          annotation (Line(
            points={{-33.4,14},{-38.2,14},{-38.2,10},{-38,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
          annotation (Line(
            points={{46,50},{-24,50},{-24,6},{-30,6},{-30,6.1},{-34.2,6.1}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(systemicArtys.externalPressure,const4. y) annotation (Line(
            points={{75.5,11},{75.5,18},{77.6,18}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.ExternalPressure,const6. y)
          annotation (Line(
            points={{-44,10},{-44,20.5},{-43.45,20.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicArtys.compliance,const5. y) annotation (Line(
            points={{81.8,11},{81.8,10.5},{88.55,10.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
          annotation (Line(
            points={{-90.5,2.1},{-90,2.1},{-90,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
        annotation (Line(
          points={{74.08,43.8},{46,43.8},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
          annotation (Line(
            points={{54.9,34.5},{46,32},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
        annotation (Line(
          points={{68,29.4},{68,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(systemicArtys.Pressure, busConnector.SystemicArtys_Pressure)
          annotation (Line(
            points={{79.7,-10},{80,-10},{80,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{3,-3},{3,-3}}));

        connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
          annotation (Line(
            points={{68.2,39.8},{80,39.8},{80,42.1},{80.2,42.1}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
        annotation (Line(
          points={{74.08,43.8},{46,43.8},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
          annotation (Line(
            points={{-40,-10},{-40,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
          annotation (Line(
            points={{-50.8,10},{-50.8,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
            points={{87.5,23},{70,23},{70,22},{46,22},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
        annotation (Line(
          points={{71.3,-10},{72,-10},{72,-28},{46,-28},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(q_in, systemicArtys.q_in) annotation (Line(
          points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(collapsedVeins.q_out, q_out) annotation (Line(
            points={{-74.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
              -100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.Gravity_Gz, G.u) annotation (Line(
            points={{46,50},{46,38},{34,38},{34,30.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
            points={{34,21.6},{34,16},{62.5,16},{62.5,26.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.busConnector, busConnector)
                                                                annotation (
            Line(
            points={{-25.1,73.9},{46,73.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.busConnector, busConnector)
                                                               annotation (Line(
            points={{6.9,87.9},{46,87.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
          annotation (Line(
            points={{7,84},{46,84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
          annotation (Line(
            points={{-25,70},{22,70},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
          annotation (Line(
            points={{7,84},{46,84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
          annotation (Line(
            points={{-25,70},{22,70},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(splanchnicCirculation.busConnector, busConnector) annotation (
            Line(
            points={{-8,-15.5},{-8,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
          points={{30,-25},{62,-25},{62,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(splanchnicCirculation.q_out,
          systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
            points={{-8,-25},{-22,-25},{-22,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
          points={{26,1.77636e-015},{52,1.77636e-015},{52,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
          annotation (Line(
            points={{-2,1.77636e-015},{-24,1.77636e-015},{-24,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-10,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
            points={{10,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
          annotation (Line(
            points={{-44,0},{-56,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
            points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-94.5,
              1.22465e-015}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));

        connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
            points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.SystemicVeins_DeoxygenatedBloodVolume,
          systemicVeinsElacticBloodCompartment.BloodVolume) annotation (Line(
            points={{46,50},{46,-28},{-48,-28},{-48,-10}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
       annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{42,46},{74,46}},
                lineColor={0,0,255},
                textString="Carotid Artery Pressure")}),
                                       Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-104,-54},{110,-76}},
                lineColor={0,0,255},
                textString="%name")}),
        Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>", info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
      end SystemicCirculationBase2;

      model SystemicCirculation
        extends develop.SystemicCirculationBase2;
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant const8(k=0)
        annotation (Placement(transformation(extent={{93,-62},{86,-55}})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        hydrostaticDifference(useExternalG=true, useHeightInput=true)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={54,-66})));
        SequesteredBlood sequesteredBlood(data={{0,0,10^(-10)},{50,97,1.0},{200,150,0.5}},
            initialVol=50.0044,
          pressureControledCompartment(stateName="BVSeqArtys.Vol"))
          annotation (Placement(transformation(extent={{80,-82},{100,-62}})));
        SequesteredBlood sequesteredBlood1(                data={{0,-100,2.00},{150,11,
              0.11},{600,50,0.15}}, initialVol=120.691,
          pressureControledCompartment(stateName="BVSeqVeins.Vol"))
          annotation (Placement(transformation(extent={{-62,-76},{-44,-58}})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        hydrostaticDifference1(
        useExternalG=true,
        useHeightInput=true,
        usePumpEffect=true)
        annotation (Placement(transformation(extent={{-5,-72},{-25,-52}})));
      Physiolibrary.Types.Constants.PressureConst const12(k=0)
        annotation (Placement(transformation(extent={{-52,-54},{-59,-47}})));
        Physiolibrary.Hydraulic.OneWayResistorWithCondParam
          oneWayResistorWithCondParam(cond=40)
          annotation (Placement(transformation(extent={{64,-88},{84,-68}})));
        Physiolibrary.Hydraulic.OneWayResistorWithCondParam
          oneWayResistorWithCondParam1(cond=40)
          annotation (Placement(transformation(extent={{84,-78},{64,-58}})));
        Physiolibrary.Hydraulic.OneWayResistorWithCondParam
          oneWayResistorWithCondParam2(cond=100)
          annotation (Placement(transformation(extent={{-46,-82},{-26,-62}})));
        Physiolibrary.Hydraulic.OneWayResistorWithCondParam
          oneWayResistorWithCondParam3(cond=100)
          annotation (Placement(transformation(extent={{-26,-72},{-46,-52}})));
      equation
        connect(sequesteredBlood.ExternalPressure,const8. y) annotation (Line(
            points={{81,-62},{81,-58.5},{85.65,-58.5}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(hydrostaticDifference.q_up, systemicArtys.q_in) annotation (Line(
          points={{61.2,-61.2},{62,-56},{62,0},{75.5,0},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(sequesteredBlood1.ExternalPressure,const12. y) annotation (Line(
            points={{-61.1,-58},{-61.1,-50.5},{-59.35,-50.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(hydrostaticDifference1.q_up,
          systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
            points={{-22.2,-57.2},{-22.2,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference1.height, busConnector.LowerTorsoVeinHeight)
          annotation (Line(
            points={{-8.9,-62.3},{46,-62.3},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(hydrostaticDifference1.pumpEffect, busConnector.Exercise_MusclePump_Effect)
          annotation (Line(
            points={{-13.5,-52.5},{46,-52.5},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(hydrostaticDifference.height, busConnector.LowerTorsoArtyHeight)
          annotation (Line(
            points={{47.9,-66.5},{46,-66.5},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood1.Vol, busConnector.LegVeins_DeoxygenatedBloodVolume)
          annotation (Line(
            points={{-56.6,-76},{-58,-76},{-58,-84},{46,-84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(sequesteredBlood.Vol, busConnector.LegArtys_OxygenatedBloodVolume)
          annotation (Line(
            points={{86,-82},{86,-84},{46,-84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(G.y,hydrostaticDifference1. G) annotation (Line(
            points={{34,21.6},{34,-84},{-16.5,-84},{-16.5,-70.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(G.y,hydrostaticDifference. G) annotation (Line(
            points={{34,21.6},{34,-84},{55.5,-84},{55.5,-74.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(hydrostaticDifference.q_down, oneWayResistorWithCondParam1.q_out)
          annotation (Line(
            points={{61,-71.6},{61,-72.8},{64,-72.8},{64,-68}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference.q_down, oneWayResistorWithCondParam.q_in)
          annotation (Line(
            points={{61,-71.6},{61,-72.8},{64,-72.8},{64,-78}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(oneWayResistorWithCondParam1.q_in, sequesteredBlood.referencePoint)
          annotation (Line(
            points={{84,-68},{84,-72},{90,-72}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(oneWayResistorWithCondParam.q_out, sequesteredBlood.referencePoint)
          annotation (Line(
            points={{84,-78},{84,-72},{90,-72}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference1.q_down, oneWayResistorWithCondParam3.q_in)
          annotation (Line(
            points={{-22,-67.4},{-24,-67.4},{-24,-62},{-26,-62}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(hydrostaticDifference1.q_down, oneWayResistorWithCondParam2.q_out)
          annotation (Line(
            points={{-22,-67.4},{-24,-67.4},{-24,-72},{-26,-72}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(sequesteredBlood1.referencePoint, oneWayResistorWithCondParam3.q_out)
          annotation (Line(
            points={{-53,-67},{-50.5,-67},{-50.5,-62},{-46,-62}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(sequesteredBlood1.referencePoint, oneWayResistorWithCondParam2.q_in)
          annotation (Line(
            points={{-53,-67},{-49.5,-67},{-49.5,-72},{-46,-72}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      end SystemicCirculation;

      model SystemicCirculationBase

        extends Physiolibrary.Icons.SystemicCirculation;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
        "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));
        /*
  Library.PressureFlow.NegativePressureFlow fromSystemicVeins annotation (
      Placement(transformation(extent={{-110,-10},{-90,10}}),iconTransformation(
          extent={{-112,44},{-92,64}})));
  Library.PressureFlow.PositivePressureFlow systemicArteries
    annotation (Placement(transformation(extent={{88,-10},{108,10}}),
        iconTransformation(extent={{90,46},{110,66}})));
*/

      Physiolibrary.Hydraulic.Components.ElasticVessel systemicArtys(
        stateName="SystemicArtys.Vol",
        useComplianceInput=true,
        useExternalPressureInput=true,
        useV0Input=true,
        volume_start=0.00100036)
        annotation (Placement(transformation(extent={{65,-10},{86,11}})));
      Physiolibrary.Types.Constants.DeprecatedUntypedConstant V0_artys(k=850)
        annotation (Placement(transformation(extent={{98,18},{88,28}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst
        SystemicVeinsCompliance(k=6.645545561992547e-007)
        annotation (Placement(transformation(extent={{-27,10},{-35,18}})));
      PeripheralCirculation peripheral
        annotation (Placement(transformation(extent={{-2,-14},{26,14}})));
      Physiolibrary.Hydraulic.Sources.UnlimitedPump volumeCorrections(
          useSolutionFlowInput=true)
        annotation (Placement(transformation(extent={{-28,24},{-42,38}})));
      SystemicVeins veins(BaseConductance=856)
        "scaled to coronary vessels reorganisation"
        annotation (Placement(transformation(extent={{-72,-8},{-56,8}})));
        SystemicVeinsElacticBloodCompartment
          systemicVeinsElacticBloodCompartment
          annotation (Placement(transformation(extent={{-54,-10},{-34,10}})));
      Physiolibrary.Types.Constants.PressureConst SystemicArtysExternalPressure(
          k=0) annotation (Placement(transformation(extent={{86,14},{79,21}})));
      Physiolibrary.Types.Constants.PressureConst SystemicVeinsExternalPressure(
          k=0)
        annotation (Placement(transformation(extent={{-36,16},{-43,23}})));
      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{36,40},{56,60}}), iconTransformation(
              extent={{-110,32},{-94,48}})));
      Physiolibrary.Types.Constants.HydraulicComplianceConst
        SystemicArtysCompliance(k=1.162595442560773e-008)
        annotation (Placement(transformation(extent={{96,8},{89,15}})));
      CollapsingVeins collapsedVeins annotation (Placement(transformation(
            extent={{-10,10.5},{10,-10.5}},
            rotation=180,
            origin={-84.5,0})));
      Physiolibrary.Hydraulic.Components.HydrostaticColumn
        gravityHydrostaticDifference(useExternalG=true, useHeightInput=true)
        annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={61,35})));
      Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
        annotation (Placement(transformation(
            extent={{8.5,-8.5},{-8.5,8.5}},
            origin={78.5,45.5})));
        Modelica.Blocks.Math.Gain G(k=9.81) annotation (Placement(transformation(
              extent={{4,-4},{-4,4}},
              rotation=90,
              origin={34,26})));
      Microcirculation.LeftHeart leftCororaryCirculation(
          BasicLargeVeselsConductance=50*0.93677109469950528615290800207779,
          BasicSmallVeselsConductance=2.2*0.93677109469950528615290800207779)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-10,76},{10,96}})));
      Microcirculation.RightHeart rightCororaryCirculation(
          BasicLargeVeselsConductance=10*0.93677109469950528615290800207779,
          BasicSmallVeselsConductance=0.4*0.93677109469950528615290800207779)
        "scaled to normal pressure gradient 94 mmHg"
        annotation (Placement(transformation(extent={{-42,62},{-22,82}})));
      SplanchnicCirculation splanchnicCirculation
        annotation (Placement(transformation(extent={{-8,-44},{30,-6}})));
      equation
        connect(systemicArtys.compliance, SystemicArtysCompliance.y)
                                                    annotation (Line(
            points={{81.8,11},{81.8,11.5},{88.65,11.5}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(systemicArtys.zeroPressureVolume, V0_artys.y) annotation (Line(
          points={{69.2,11},{69.2,23},{87.5,23}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(busConnector, peripheral.busConnector)          annotation (
            Line(
            points={{46,50},{46,2.66},{21.66,2.66}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(veins.busConnector,busConnector)           annotation (
           Line(
            points={{-58.48,1.52},{-60,1.52},{-60,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(SystemicVeinsCompliance.y, systemicVeinsElacticBloodCompartment.Compliance)
          annotation (Line(
            points={{-35.4,14},{-38.2,14},{-38.2,10},{-38,10}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector,systemicVeinsElacticBloodCompartment. busConnector)
          annotation (Line(
            points={{46,50},{-26,50},{-26,6.1},{-34.2,6.1}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.referencePoint,volumeCorrections. q_out)
          annotation (Line(
            points={{-44,0},{-46,0},{-46,31.7},{-42,31.7}},
            color={0,0,0},
            smooth=Smooth.None,
            thickness=1));
        connect(systemicArtys.externalPressure, SystemicArtysExternalPressure.y)
                                                          annotation (Line(
            points={{75.5,11},{75.5,17.5},{78.65,17.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.ExternalPressure,
          SystemicVeinsExternalPressure.y)
          annotation (Line(
            points={{-44,10},{-44,19.5},{-43.35,19.5}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(busConnector.BloodVolume_change, volumeCorrections.solutionFlow)
        annotation (Line(
          points={{46,50},{-35,50},{-35,35.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
        connect(systemicArtys.compliance, SystemicArtysCompliance.y)
                                                    annotation (Line(
            points={{81.8,11},{81.8,11.5},{88.65,11.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(collapsedVeins.ExternalPressure, busConnector.Thorax_AvePressure)
          annotation (Line(
            points={{-90.5,2.1},{-90,2.1},{-90,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinus_Pressure)
        annotation (Line(
          points={{74.08,43.8},{46,43.8},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(gravityHydrostaticDifference.height, busConnector.CarotidSinusHeight)
          annotation (Line(
            points={{54.9,34.5},{46,32},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(gravityHydrostaticDifference.q_down, systemicArtys.q_in)
        annotation (Line(
          points={{68,29.4},{68,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(systemicArtys.Pressure, busConnector.SystemicArtys_Pressure)
          annotation (Line(
            points={{79.7,-10},{80,-10},{80,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{3,-3},{3,-3}}));

        connect(gravityHydrostaticDifference.q_up, pressureMeasure.q_in)
          annotation (Line(
            points={{68.2,39.8},{80,39.8},{80,42.1},{80.2,42.1}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(pressureMeasure.pressure, busConnector.CarotidSinusArteryPressure)
        annotation (Line(
          points={{74.08,43.8},{46,43.8},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.Pressure, busConnector.SystemicVeins_Pressure)
          annotation (Line(
            points={{-40,-10},{-40,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(systemicVeinsElacticBloodCompartment.V0, busConnector.SystemicVeins_V0)
          annotation (Line(
            points={{-50.8,10},{-50.8,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(V0_artys.y, busConnector.SystemicArtys_V0) annotation (Line(
            points={{87.5,23},{70,23},{70,22},{46,22},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.Vol, busConnector.SystemicVeins_DeoxygenatedBloodVolume)
          annotation (Line(
            points={{-48,-10},{-48,-28},{46,-28},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(systemicArtys.volume, busConnector.SystemicArtys_OxygenatedBloodVolume)
        annotation (Line(
          points={{71.3,-10},{72,-10},{72,-28},{46,-28},{46,50}},
          color={0,0,127},
          smooth=Smooth.None));
        connect(q_in, systemicArtys.q_in) annotation (Line(
          points={{100,0},{99.75,0},{99.75,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(collapsedVeins.q_out, q_out) annotation (Line(
            points={{-74.5,-1.22465e-015},{-96.25,-1.22465e-015},{-96.25,0},{
              -100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(busConnector.Gravity_Gz, G.u) annotation (Line(
            points={{46,50},{46,38},{34,38},{34,30.8}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(G.y, gravityHydrostaticDifference.G) annotation (Line(
            points={{34,21.6},{34,16},{62.5,16},{62.5,26.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.busConnector, busConnector)
                                                                annotation (
            Line(
            points={{-25.1,73.9},{46,73.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.busConnector, busConnector)
                                                               annotation (Line(
            points={{6.9,87.9},{46,87.9},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.leftHeart_BloodFlow)
          annotation (Line(
            points={{7,84},{46,84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(rightCororaryCirculation.BloodFlow, busConnector.rightHeart_BloodFlow)
          annotation (Line(
            points={{-25,70},{22,70},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(leftCororaryCirculation.BloodFlow, busConnector.LeftHeart_BloodFlow)
          annotation (Line(
            points={{7,84},{46,84},{46,50}},
            color={0,0,127},
            smooth=Smooth.None), Text(
            string="%second",
            index=1,
            extent={{6,3},{6,3}}));
        connect(rightCororaryCirculation.BloodFlow, busConnector.RightHeart_BloodFlow)
          annotation (Line(
            points={{-25,70},{22,70},{22,50},{46,50}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(splanchnicCirculation.busConnector, busConnector) annotation (
            Line(
            points={{-8,-15.5},{-8,50},{46,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None));
      connect(splanchnicCirculation.q_in, systemicArtys.q_in) annotation (Line(
          points={{30,-25},{62,-25},{62,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(splanchnicCirculation.q_out,
          systemicVeinsElacticBloodCompartment.referencePoint) annotation (Line(
            points={{-8,-25},{-22,-25},{-22,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
      connect(peripheral.q_in, systemicArtys.q_in) annotation (Line(
          points={{26,1.77636e-015},{52,1.77636e-015},{52,0.5},{75.5,0.5}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
        connect(peripheral.q_out, systemicVeinsElacticBloodCompartment.referencePoint)
          annotation (Line(
            points={{-2,1.77636e-015},{-24,1.77636e-015},{-24,0},{-44,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(rightCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-42,72},{-60,72},{-60,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_out, q_out) annotation (Line(
            points={{-10,86},{-100,86},{-100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(leftCororaryCirculation.q_in, q_in) annotation (Line(
            points={{10,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(systemicVeinsElacticBloodCompartment.referencePoint, veins.q_in)
          annotation (Line(
            points={{-44,0},{-56,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(veins.q_out, collapsedVeins.q_in) annotation (Line(
            points={{-72,0},{-73.25,0},{-73.25,1.22465e-015},{-94.5,
              1.22465e-015}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));

        connect(rightCororaryCirculation.q_in, q_in) annotation (Line(
            points={{-22,72},{36,72},{36,86},{100,86},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
       annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{42,46},{74,46}},
                lineColor={0,0,255},
                textString="Carotid Artery Pressure")}),
                                       Icon(coordinateSystem(
                preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={
              Text(
                extent={{-104,-54},{110,-76}},
                lineColor={0,0,255},
                textString="%name")}),
        Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>", info="<html>
<p>Blood volume (and pressure) distributions between </p>
<p><ul>
<li>systemic arteries, </li>
<li>systemic veins and</li>
<li>portal (splanchnic) vein.</li>
</ul></p>
<p>Blood flow throught: </p>
<p><ul>
<li>GIT, hepatic artery, liver</li>
<li>Kidney</li>
<li>CNS</li>
<li>Skeletal muscle</li>
<li>Respiratory muscle</li>
<li>Skin</li>
<li>Bones</li>
<li>Adipose tissue</li>
<li>Other tissue</li>
</ul></p>
</html>"));
      end SystemicCirculationBase;

      model GuytonOutputPump

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
          extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                            iconTransformation(extent={{-110,-10},{-90,10}})));
        Modelica.Blocks.Interfaces.RealInput inputPressure
                                                    annotation (Placement(
              transformation(extent={{-96,54},{-56,94}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-80,60})));

      equation
        q_in.pressure = inputPressure;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Text(
                extent={{-104,-54},{110,-76}},
                lineColor={0,0,255},
                textString="%name"),
              Rectangle(
                extent={{-100,-50},{100,50}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-80,25},{80,0},{-80,-25},{-80,25}},
                lineColor={0,0,127},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid)}));
      end GuytonOutputPump;

      model GuytonPump

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out annotation (
          extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                            iconTransformation(extent={{90,-10},{110,10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in annotation (
          extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                            iconTransformation(extent={{-110,-10},{-90,10}})));
        Modelica.Blocks.Interfaces.RealInput inputPressure
                                                    annotation (Placement(
              transformation(extent={{-96,54},{-56,94}}), iconTransformation(
              extent={{-20,-20},{20,20}},
              rotation=270,
              origin={-80,60})));

      equation
        q_in.pressure = inputPressure;
        q_in.q + q_out.q = 0;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Text(
                extent={{-104,-54},{110,-76}},
                lineColor={0,0,255},
                textString="%name"),
              Rectangle(
                extent={{-100,-50},{100,50}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-80,25},{80,0},{-80,-25},{-80,25}},
                lineColor={0,0,127},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid)}));
      end GuytonPump;

      model SystemicVeinsElacticBloodCompartment2
       extends Physiolibrary.Icons.ElasticBalloon;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a referencePoint
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(
            extent={{-10,-10},{10,10}})));
        Modelica.Blocks.Interfaces.RealInput ExternalPressure(
                                                            final quantity="Pressure", final displayUnit="mmHg")
        "external pressure around the compartment"                              annotation (extent = [-10,90;10,110], rotation = -90,
        Placement(transformation(
            origin={0,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));
        Modelica.Blocks.Interfaces.RealInput Compliance(
                                                      final quantity="Compliance", final displayUnit="ml/mmHg")
        "elasticity of the stressed walls"                               annotation (extent = [50,90;70,110], rotation = -90,
        Placement(transformation(
            origin={60,100},
            extent={{-10,-10},{10,10}},
            rotation=270)));

        Modelica.Blocks.Interfaces.RealOutput Pressure(  final quantity="Pressure", final displayUnit="mmHg")
        "blod pressure in compartment"
          annotation (Placement(transformation(extent={{30,-110},{50,-90}}, rotation=-90)));
      Physiolibrary.Types.BusConnector busConnector annotation (Placement(
            transformation(extent={{-88,72},{-68,92}}), iconTransformation(
              extent={{88,51},{108,71}})));
      Physiolibrary.Blocks.Factors.Spline V0_A2_Effect(data={{0.0,1.05,0.0},{
            1.3,1.00,-0.10},{3.0,0.85,0.0}})
        annotation (Placement(transformation(extent={{-30,7},{-10,27}})));
      Physiolibrary.Types.Constants.VolumeConst V0_Base(k=0.0018298)
        annotation (Placement(transformation(extent={{-32,48},{-23,39}})));
        Physiomodel.Nerves.AplhaReceptorsActivityFactor AplhaReceptors(
          NEURALK=0.333,
          HUMORALK=0.5,
          data={{0.0,1.2,0.0},{1.0,1.0,-0.30},{3.0,0.6,0.0}})
          annotation (Placement(transformation(extent={{-30,20},{-10,40}})));
        Modelica.Blocks.Interfaces.RealOutput V0(final quantity="Volume", final displayUnit="ml")
        "maximal zero pressure blood volume in compartment"
          annotation (Placement(transformation(extent={{-4.5,-4.5},{4.5,4.5}},rotation=180,
              origin={-27.5,5.5}),
              iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=90,
              origin={-68,100})));

        parameter Real initialSystemisVeinsVol(final quantity="Volume", final unit =   "ml")= 2329.57; // = 2200;// = 2980;

        Modelica.Blocks.Interfaces.RealOutput NormalizedVolume(final quantity=
              "NormalizedVolume", final displayUnit="1")
        "maximal zero pressure blood volume in compartment"
          annotation (Placement(transformation(extent={{-4.5,-4.5},{4.5,4.5}},origin={22.5,9.5}),
              iconTransformation(
              extent={{-10,-10},{10,10}},
              rotation=180,
              origin={-100,56})));
        Modelica.Blocks.Interfaces.RealInput BloodVolume
                                                  annotation (Placement(
              transformation(
              extent={{-20,-20},{20,20}},
              rotation=90,
              origin={-40,-100})));

        Real StressedVolume(   final quantity="Volume", final displayUnit="ml");

      equation
        StressedVolume = max(BloodVolume-V0,0);
        Pressure = (StressedVolume/Compliance) + ExternalPressure;
        referencePoint.pressure = Pressure;

        NormalizedVolume = if initialSystemisVeinsVol==0 then 0 else BloodVolume/initialSystemisVeinsVol;

        connect(AplhaReceptors.y,V0_A2_Effect. yBase) annotation (Line(
            points={{-20,23},{-20,19}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(AplhaReceptors.yBase, V0_Base.y)
                                                annotation (Line(
            points={{-20,37},{-20,43.5},{-21.875,43.5}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.A2Pool_Log10Conc, V0_A2_Effect.u) annotation (
            Line(
            points={{-78,82},{-78,17},{-28,17}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, AplhaReceptors.GangliaGeneral_NA)
          annotation (Line(
            points={{-78,82},{-78,24},{-29.8,24}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaPool_Effect, AplhaReceptors.AlphaPool_Effect)
          annotation (Line(
            points={{-78,82},{-78,36},{-29.8,36}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaBlocade_Effect, AplhaReceptors.AlphaBlockade_Effect)
          annotation (Line(
            points={{-78,82},{-78,30},{-29.8,30}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(V0_A2_Effect.y, V0) annotation (Line(
            points={{-20,13},{-20,5.5},{-27.5,5.5}},
            color={0,0,127},
            smooth=Smooth.None));

       annotation (
          Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.
</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end SystemicVeinsElacticBloodCompartment2;

      model VascularElasticBloodCompartment
        extends Physiolibrary.SteadyStates.Interfaces.SteadyState;
        extends
          Physiomodel.CardioVascular2.Circulation.Interfaces.IVascularElasticBloodCompartment;

        Real StressedVolume(   final quantity="Volume", final displayUnit="ml");

        Modelica.Blocks.Interfaces.RealOutput NormalizedVolume(final quantity="NormalizedVolume",
            final displayUnit="1")
        "actual volume divided by standard compartement volume"
          annotation (Placement(transformation(extent={{-10,-10},{10,10}},
              rotation=270,
              origin={-40,-100}), iconTransformation(
              extent={{-10,-10},{10,10}},
              origin={100,60})));
      //initial equation
      //  Vol = initialVol;
       // der(Vol) = 0;
      equation

        StressedVolume = max(Vol-V0,0);
        Pressure = (StressedVolume/Compliance) + ExternalPressure;
        referencePoint.pressure = Pressure;

        NormalizedVolume = if initialVol==0 then 0 else Vol/initialVol;

      state = Vol;
        change = referencePoint.q/60;

       annotation (
          preferredView = text,
          Documentation(info="<HTML>
<PRE>
  Elastic blood flow compartment.
</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>

<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>january 2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"), Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},
                  {100,100}}), graphics={Text(
                extent={{-100,-16},{100,-32}},
                lineColor={0,0,255},
                textString="(initial %initialVol ml)")}));
      end VascularElasticBloodCompartment;
    end develop;
  annotation (Documentation(revisions="<html>
</html>"));
  end Circulation;

  package Microcirculation
  "Tissue vessels hydraulic conductance (=1/resistance)"
    class References "References"
      extends Modelica.Icons.References;

      annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Archer1996]</td>
		<td>S. L. Archer, J. M. C. Huang, H. L. Reeve, V. Hampl, S. Tolarová, E. Michelakis, et al., \"Differential Distribution of Electrophysiologically Distinct Myocytes in Conduit and Resistance Arteries Determines Their Response to Nitric Oxide and Hypoxia,\" Circulation Research, vol. 78, pp. 431-442, March 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Aukland1989]</td>
		<td>K. Aukland, \"Myogenic mechanisms in the kidney,\" Journal of hypertension. Supplement: official journal of the International Society of Hypertension, vol. 7, pp. S71-6; discussion S77, 1989. </td>
	</tr>
	<tr>
		<td>[Berg1997]</td>
		<td>B. R. Berg, K. D. Cohen, and I. H. Sarelius, \"Direct coupling between blood flow and metabolism at the capillary level in striated muscle,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 41, p. H2693, 1997. </td>
	</tr>
	<tr>
		<td>[Borgström1975]</td>
		<td>L. Borgström, H. Jóhannsson, and B. K. Siesjö, \"The Relationship between Arterial PO2 and Cerebral Blood Flow in Hypoxic Hypoxia,\" Acta Physiologica Scandinavica, vol. 93, pp. 423-432, 1975. </td>
	</tr>
	<tr>
		<td>[BRADLEY1952]</td>
		<td>S. E. BRADLEY, F. J. INGELFINGER, and G. P. BRADLEY, \"Hepatic Circulation in Cirrhosis of the Liver,\" Circulation, vol. 5, pp. 419-429, March 1, 1952 1952. </td>
	</tr>
	<tr>
		<td>[Bradley1953]</td>
		<td>S. E. Bradley, P. A. Marks, P. C. Reynell, and J. Meltzer, \"The circulating splanchnic blood volume in dog and man,\" Trans Assoc Am Physicians, vol. 66, pp. 294-302, 1953. </td>
	</tr>
	<tr>
		<td>[Breslow1993]</td>
		<td>M. J. Breslow, J. R. Tobin, D. S. Bredt, C. D. Ferris, S. H. Snyder, and R. J. Traystman, Nitric oxide as a regulator of adrenal blood flow vol. 264, 1993. </td>
	</tr>
	<tr>
		<td>[Burattini1994]</td>
		<td>R. Burattini, P. Borgdorff, and N. Westerhof, \"Relationship between strength of short-term systemic autoregulation and initial resistance,\" American Journal of Physiology-Regulatory Integrative and Comparative Physiology, vol. 36, p. R1182, 1994. </td>
	</tr>
	<tr>
		<td>[Coleman1972]</td>
		<td>T. G. Coleman, R. D. Manning, Jr., R. A. Norman, Jr., and A. C. Guyton, \"Dynamics of water-isotope distribution,\" Am J Physiol, vol. 223, pp. 1371-5, Dec 1972. </td>
	</tr>
	<tr>
		<td>[Davidson1986]</td>
		<td>D. Davidson, S. A. Stalcup, and R. B. Mellins, Systemic hemodynamics affecting cardiac output during hypocapnic and hypercapnic hypoxia vol. 60, 1986. </td>
	</tr>
	<tr>
		<td>[Drummond2008]</td>
		<td>H. A. Drummond, S. C. Grifoni, and N. L. Jernigan, \"A new trick for an old dogma: ENaC proteins as mechanotransducers in vascular smooth muscle,\" Physiology, vol. 23, pp. 23-31, 2008. </td>
	</tr>
	<tr>
		<td>[Fitzgerald1980]</td>
		<td>G. A. Fitzgerald, P. Barnes, C. A. Hamilton, and C. T. Dollery, \"Circulating adrenaline and blood pressure: the metabolic effects and kinetics of infused adrenaline in man,\" European Journal of Clinical Investigation, vol. 10, pp. 401-406, 1980. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Increased Intravascular Pressure Does Not Enhance Skeletal Muscle Arteriolar Constriction to Oxygen or Angiotensin II,\" Microvascular Research, vol. 59, pp. 176-180, 1// 2000. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Short-term angiotensin converting enzyme inhibition reduces basal tone and dilator reactivity in skeletal muscle arterioles*,\" American Journal of Hypertension, vol. 13, pp. 389-395, April 1, 2000 2000. </td>
	</tr>
	<tr>
		<td>[Gibbs1942]</td>
		<td>E. L. Gibbs, F. A. Gibbs, W. G. Lennox, and L. F. Nims, \"REgulation of cerebral carbon dioxide,\" Archives of Neurology & Psychiatry, vol. 47, pp. 879-889, 1942. </td>
	</tr>
	<tr>
		<td>[Goodman1978]</td>
		<td>A. H. Goodman, R. Einstein, and H. J. Granger, \"Effect of changing metabolic rate on local blood flow control in the canine hindlimb,\" Circulation Research, vol. 43, pp. 769-76, November 1, 1978 1978. </td>
	</tr>
	<tr>
		<td>[Granger1969]</td>
		<td>H. J. Granger and A. C. Guyton, \"Autoregulation of the Total Systemic Circulation Following Destruction of the Central Nervous System in the Dog,\" Circulation Research, vol. 25, pp. 379-388, October 1, 1969 1969. </td>
	</tr>
	<tr>
		<td>[Granger1976]</td>
		<td>H. J. Granger, A. H. Goodman, and D. N. Granger, \"Role of resistance and exchange vessels in local microvascular control of skeletal muscle oxygenation in the dog,\" Circulation Research, vol. 38, pp. 379-85, May 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Greenway1973]</td>
		<td>C. Greenway and G. Oshiro, \"Effects of histamine on hepatic volume (outflow block) in anaesthetized dogs,\" British journal of pharmacology, vol. 47, pp. 282-290, 1973. </td>
	</tr>
	<tr>
		<td>[Greenway1974]</td>
		<td>C. V. Greenway and G. E. Lister, \"Capacitance effects and blood reservoir function in the splanchnic vascular bed during non-hypotensive haemorrhage and blood volume expansion in anaesthetized cats,\" The Journal of Physiology, vol. 237, pp. 279-294, March 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[Greenway1985]</td>
		<td>C. V. Greenway, K. L. Seaman, and I. R. Innes, Norepinephrine on venous compliance and unstressed volume in cat liver vol. 248, 1985. </td>
	</tr>
	<tr>
		<td>[Gutsche1980]</td>
		<td>H. U. Gutsche, R. Müller-Suur, U. Hegel, and K. Hierholzer, \"Electrical conductivity of tubular fluid of the rat nephron,\" Pflügers Archiv, vol. 383, pp. 113-121, 1980/01/01 1980. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Heyeraas1987]</td>
		<td>K. J. Heyeraas and K. Aukland, \"Interlobular arterial resistance: Influence of renal arterial pressure and angiotensin II,\" Kidney Int, vol. 31, pp. 1291-1298, 06//print 1987. </td>
	</tr>
	<tr>
		<td>[Hogan1990]</td>
		<td>M. C. Hogan, D. E. Bebout, A. T. Gray, P. D. Wagner, J. B. West, and P. E. Haab, Muscle maximal O2 uptake at constant O2 delivery with and without CO in the blood vol. 69, 1990. </td>
	</tr>
	<tr>
		<td>[Ito1990]</td>
		<td>S. Ito and O. A. Carretero, \"An in vitro approach to the study of macula densa-mediated glomerular hemodynamics,\" Kidney Int, vol. 38, pp. 1206-10, Dec 1990. </td>
	</tr>
	<tr>
		<td>[Ito1992]</td>
		<td>S. Ito, O. A. Carretero, K. Abe, L. A. Juncos, and K. Yoshinaga, \"Macula Densa Control of Renin Release and Glomerular Hemodynamics,\" The Tohoku Journal of Experimental Medicine, vol. 166, pp. 27-39, 1992. </td>
	</tr>
	<tr>
		<td>[Itoh1985]</td>
		<td>S. Itoh and O. A. Carretero, \"Role of the macula densa in renin release,\" Hypertension, vol. 7, p. I49, 1985. </td>
	</tr>
	<tr>
		<td>[Kety1948]</td>
		<td>S. S. Kety and C. F. Schmidt, \"THE EFFECTS OF ALTERED ARTERIAL TENSIONS OF CARBON DIOXIDE AND OXYGEN ON CEREBRAL BLOOD FLOW AND CEREBRAL OXYGEN CONSUMPTION OF NORMAL YOUNG MEN 1,\" The Journal of Clinical Investigation, vol. 27, pp. 484-492, 1948. </td>
	</tr>
	<tr>
		<td>[Kunert1996]</td>
		<td>M. P. Kunert, J. F. Liard, D. J. Abraham, and J. H. Lombard, \"Low-Affinity Hemoglobin Increases Tissue PO2and Decreases Arteriolar Diameter and Flow in the Rat Cremaster Muscle,\" Microvascular Research, vol. 52, pp. 58-68, 7// 1996. </td>
	</tr>
	<tr>
		<td>[Kuwahira1993]</td>
		<td>I. Kuwahira, N. Heisler, J. Piiper, and N. C. Gonzalez, \"Effect of chronic hypoxia on hemodynamics, organ blood flow and O2 supply in rats,\" Respiration Physiology, vol. 92, pp. 227-238, 5// 1993. </td>
	</tr>
	<tr>
		<td>[Laine1979]</td>
		<td>G. A. Laine, J. T. Hall, S. H. Laine, and J. Granger, \"Transsinusoidal fluid dynamics in canine liver during venous hypertension,\" Circulation Research, vol. 45, pp. 317-23, September 1, 1979 1979. </td>
	</tr>
	<tr>
		<td>[Lash1987]</td>
		<td>J. M. Lash and H. G. Bohlen, Perivascular and tissue PO2 in contracting rat spinotrapezius muscle vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[Lassen1959]</td>
		<td>N. A. Lassen, Cerebral blood flow and oxygen consumption in man: Am Physiological Soc, 1959. </td>
	</tr>
	<tr>
		<td>[Lautt1987]</td>
		<td>W. W. Lautt, C. V. Greenway, and D. J. Legare, \"Effect of hepatic nerves, norepinephrine, angiotensin, and elevated central venous pressure on postsinusoidal resistance sites and intrahepatic pressures in cats,\" Microvascular Research, vol. 33, pp. 50-61, 1// 1987. </td>
	</tr>
	<tr>
		<td>[Maass-Moreno1992]</td>
		<td>R. Maass-Moreno and C. F. Rothe, \"Contribution of the large hepatic veins to postsinusoidal vascular resistance,\" Am J Physiol Gastrointest Liver Physiol, vol. 262, pp. G14-G22, 1992. </td>
	</tr>
	<tr>
		<td>[Malo1984]</td>
		<td>J. Malo, H. Goldberg, R. Graham, H. Unruh, and C. Skoog, Effect of hypoxic hypoxia on systemic vasculature vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Manning1987]</td>
		<td>R. D. Manning, Renal hemodynamic, fluid volume, and arterial pressure changes during hyperproteinemia vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[Manning1990]</td>
		<td>R. D. Manning, Effects of hypoproteinemia on blood volume and arterial pressure of volume-loaded dogs vol. 259, 1990. </td>
	</tr>
	<tr>
		<td>[Manning1983]</td>
		<td>R. D. Manning and A. C. Guyton, Effects of hypoproteinemia on fluid volumes and arterial pressure vol. 245, 1983. </td>
	</tr>
	<tr>
		<td>[Marshall1995]</td>
		<td>J. Marshall, Skeletal Muscle Vasculature and Systemic Hypoxia vol. 10, 1995. </td>
	</tr>
	<tr>
		<td>[Marshall1988]</td>
		<td>J. M. Marshall and J. D. Metcalfe, \"Analysis of the cardiovascular changes induced in the rat by graded levels of systemic hypoxia,\" The Journal of Physiology, vol. 407, pp. 385-403, December 1, 1988 1988. </td>
	</tr>
	<tr>
		<td>[Metting1988]</td>
		<td>P. J. Metting, J. R. Strader, and S. L. Britton, Evaluation of whole body autoregulation in conscious dogs vol. 255, 1988. </td>
	</tr>
	<tr>
		<td>[Metting1989]</td>
		<td>P. J. Metting, P. M. Stein, B. A. Stoos, K. A. Kostrzewski, and S. L. Britton, Systemic vascular autoregulation amplifies pressor responses to vasoconstrictor agents vol. 256, 1989. </td>
	</tr>
	<tr>
		<td>[Mitzner1974]</td>
		<td>W. Mitzner, Hepatic outflow resistance, sinusoid pressure, and the vascular waterfall vol. 227, 1974. </td>
	</tr>
	<tr>
		<td>[Moore1990]</td>
		<td>L. C. Moore and D. Casellas, \"Tubuloglomerular feedback dependence of autoregulation in rat juxtamedullary afferent arterioles,\" Kidney Int, vol. 37, pp. 1402-1408, 06//print 1990. </td>
	</tr>
	<tr>
		<td>[POHOST1976]</td>
		<td>G. M. POHOST, J. B. NEWELL, N. P. HAMLIN, and W. J. POWELL, \"Observations on autoregulation in skeletal muscle: the effects of arterial hypoxia,\" Cardiovascular Research, vol. 10, pp. 405-412, July 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Prewitt1976]</td>
		<td>R. L. Prewitt and P. C. Johnson, \"The effect of oxygen on arteriolar red cell velocity and capillary density in the rat cremaster muscle,\" Microvascular Research, vol. 12, pp. 59-70, 7// 1976. </td>
	</tr>
	<tr>
		<td>[Reivich1964]</td>
		<td>M. Reivich, Arterial Pco2 and cerebral hemodynamics vol. 206, 1964. </td>
	</tr>
	<tr>
		<td>[Sage1981]</td>
		<td>J. I. Sage, R. L. Van Uitert, and T. E. Duffy, \"Simultaneous Measurement of Cerebral Blood Flow and Unidirectional Movement of Substances Across the Blood-Brain Barrier: Theory, Method, and Application to Leucine,\" Journal of Neurochemistry, vol. 36, pp. 1731-1738, 1981. </td>
	</tr>
	<tr>
		<td>[Skarlatos1993]</td>
		<td>S. Skarlatos, N. DiPaola, R. A. Frankel, R. W. Pomerantz, P. H. Brand, P. J. Metting, et al., \"Spontaneous pressure-flow relationships in renal circulation of conscious dogs,\" Am J Physiol, vol. 264, pp. H1517-27, May 1993. </td>
	</tr>
	<tr>
		<td>[Skov1996]</td>
		<td>K. Skov, J. Fenger-Gron, and M. J. Mulvany, \"Effects of an angiotensin-converting enzyme inhibitor, a calcium antagonist, and an endothelin receptor antagonist on renal afferent arteriolar structure,\" Hypertension, vol. 28, pp. 464-471, 1996. </td>
	</tr>
	<tr>
		<td>[Stainsby1973]</td>
		<td>W. N. Stainsby, \"Local Control of Regional Blood Flow,\" Annual Review of Physiology, vol. 35, pp. 151-168, 1973. </td>
	</tr>
[SchumackerS. P. T. and C. S. M., \"The concept of a critical oxygen delivery,\" Intensive Care Medicine, vol. 13, pp. 223-229, January 1, 0001.
	<tr>
		<td>[Weber2000]</td>
		<td>D. S. Weber and J. H. Lombard, Elevated salt intake impairs dilation of rat skeletal muscle resistance arteries via ANG II suppression vol. 278, 2000. </td>
	</tr>
	<tr>
		<td>[Whalen1974]</td>
		<td>W. Whalen, P. Nair, D. Buerk, and C. Thuning, \"Tissue PO2 in normal and denervated cat skeletal muscle,\" Am J Physiol, vol. 227, pp. 1221-1225, 1974. </td>
	</tr>
	<tr>
		<td>[Williams1989]</td>
		<td>L. R. Williams and R. W. Leggett, \"Reference values for resting blood flow to organs of man,\" Clinical Physics and Physiological Measurement, vol. 10, p. 187, 1989.  </td>
	</tr>


</table>
</html>"));
    end References;

    model TissueBloodFlow
      extends Physiolibrary.Icons.Microcirculation;
      parameter Physiolibrary.Types.HydraulicConductance Cond;

      parameter Boolean onViscosity=true, onAnesthesia=true, onAngiogenesis=true, onAngiotensinII=true, onVasopressin=true, onCatecholamines=true, onOxygenOnly=true, onOxygenAndCarbonDioxide=false, onOxygenNeed=false, onExercise=false;

      parameter Real[:,3] VasculatureConductanceOnPO2 = {{41,1.2,0},{51,1.0,-0.03},{61,0.8,0}};
      parameter Real[:,3] PO2OnConductance = {{10,2.0,0},{30,1.0,0}};
      parameter Real[:,3] Angiotensin2Effect = {{0.0,1.05,0},{1.3,1.00,-0.08},{3.5,0.50,0}};
      parameter Real[:,3] AlphaReceptorsEffect = {{0.0,1.3,0},{1.0,1.0,-0.3},{5.0,0.1,0}};
      parameter Real[:,3] VasopressinEffect = {{0.8,1.0,0},{3.0,0.1,0}};
      parameter Physiolibrary.Types.Time VasculatureHalfTime=30*86400*Modelica.Math.log(2);

    Physiolibrary.Blocks.Factors.Spline A2Effect(
      Xscale=1e-9/Substances.AngiotensinII.mw,
      UsePositiveLog10=true,
        data=Angiotensin2Effect,
        enabled=onAngiotensinII)
      annotation (Placement(transformation(extent={{-8,40},{12,60}})));
    Physiolibrary.Blocks.Factors.Spline ADHEffect(
      Xscale=1e-9/Substances.Vasopressin.mw,
      UsePositiveLog10=true,
        data=VasopressinEffect,
        enabled=onVasopressin) "0.8 pg/ml = 0.8e-9 kg/m3"
      annotation (Placement(transformation(extent={{-8,30},{12,50}})));
    Physiolibrary.Types.Constants.HydraulicConductanceConst BasicConductance(k=Cond)
      annotation (Placement(transformation(extent={{-18,76},{-6,88}})));
    Physiolibrary.Blocks.Factors.Normalization Anesthesia(enabled=onAnesthesia)
      annotation (Placement(transformation(extent={{-8,50},{12,70}})));
    Physiolibrary.Blocks.Factors.Normalization Viscosity(enabled=onViscosity)
      annotation (Placement(transformation(extent={{-8,58},{12,78}})));
      Physiolibrary.Blocks.Factors.SplineLagOrZero              Vasculature(
        stateName="GITract-Vasculature.Effect",
      Xscale=101325/760,
        data=VasculatureConductanceOnPO2,
        HalfTime=VasculatureHalfTime,
        enabled=onAngiogenesis)
        annotation (Placement(transformation(extent={{-8,-18},{12,2}})));
      Physiomodel.Nerves.AplhaReceptorsActivityFactor AplhaReceptors(data=
            AlphaReceptorsEffect,
        Switch=not onCatecholamines,
        Setting=1)
        annotation (Placement(transformation(extent={{-8,16},{12,36}})));
    Physiolibrary.Hydraulic.Components.Conductor resistor(useConductanceInput=true)
        annotation (Placement(transformation(extent={{12,-100},{-8,-80}})));
    Physiolibrary.Blocks.Factors.Spline pO2OnConductance(
                   Xscale=101325/760, data=PO2OnConductance,
      enabled=onOxygenOnly)
      annotation (Placement(transformation(extent={{-8,-28},{12,-8}})));

    Physiolibrary.Types.TissueBusConnector tissueConnector annotation (
        Placement(transformation(extent={{-94,0},{-74,20}}),
          iconTransformation(extent={{-20,60},{20,100}})));
    Physiolibrary.Blocks.Factors.Spline TensionEffect(data={{0.0,2.2,0},{1.0,
          1.0,-0.5},{2.0,0.6,0}}, enabled=onOxygenAndCarbonDioxide)
      annotation (Placement(transformation(extent={{-8,-72},{12,-52}})));
    Physiolibrary.Blocks.Factors.Spline PO2OnTension(data={{22,0.0,0},{36,1.0,
          0.02},{60,1.2,0}}, Xscale=101325/760,
      enabled=onOxygenAndCarbonDioxide)
      annotation (Placement(transformation(extent={{-28,-48},{-8,-28}})));
    Physiolibrary.Blocks.Factors.Spline PCO2OnTension(
                                  Xscale=101325/760,
      enabled=onOxygenAndCarbonDioxide,
      data={{20,1.8,0},{55,1.0,-0.05},{75,0.0,0}})
      "FIX: normal venous pCO2 in brain to 55mmHg (because of RQ close to 1)"
      annotation (Placement(transformation(extent={{-28,-56},{-8,-36}})));
      Physiolibrary.Types.Constants.OneConst one
        annotation (Placement(transformation(extent={{-30,-30},{-22,-22}})));
    MetabolicVasodilation metabolicVasolidation(
      data={{50,1.0,0},{1000,3.5,0.003},{3000,5.5,0}},
      stateName="SkeletalMuscle-MetabolicVasodilation.Effect",
      Xscale=1/1362657.193569,
      OnTau(displayUnit="min") = 12,
      OffTau(displayUnit="min") = 60,
      enabled=onOxygenNeed)
      annotation (Placement(transformation(extent={{-8,-82},{12,-62}})));
    Physiolibrary.Blocks.Factors.Normalization MusclePumping_SkeletalMuscle(enabled=
            onExercise)
      annotation (Placement(transformation(extent={{12,-2},{-8,18}})));
    Physiolibrary.Blocks.Math.Add add(k=1)
      annotation (Placement(transformation(extent={{4,-4},{-4,4}},
            rotation=90,
            origin={32,18})));
    Physiolibrary.Blocks.Factors.Spline RateEffect(data={{0,0.0,0.04},{60,1.0,
          0.0}}, Xscale=1/60,
        enabled=onExercise)
      annotation (Placement(transformation(extent={{42,20},{22,40}})));
    Physiolibrary.Blocks.Factors.Spline IntensityEffect(data={{0,0.0,0.007},{
          300,1.0,0.0}}, enabled=onExercise)
      annotation (Placement(transformation(extent={{42,30},{22,50}})));
      Physiolibrary.Types.Constants.OneConst one1
        annotation (Placement(transformation(extent={{20,52},{28,60}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,
              10}})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
        Placement(transformation(
          extent={{10,-10},{-10,10}},
          origin={58,-90})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-110,-10},{
              -90,10}})));
      Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                               annotation (Placement(transformation(
              extent={{78,-68},{90,-56}}), iconTransformation(extent={{60,-60},{80,
                -40}})));
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{-100,80},{-80,100}}), iconTransformation(
            extent={{60,40},{100,80}})));
    equation
      connect(Vasculature.y,pO2OnConductance. yBase) annotation (Line(
          points={{2,-14},{2,-16}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Viscosity.y, Anesthesia.yBase) annotation (Line(
          points={{2,64},{2,62}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(BasicConductance.y, Viscosity.yBase)         annotation (Line(
          points={{-4.5,82},{2,82},{2,70}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.AlphaBlocade_Effect, AplhaReceptors.AlphaBlockade_Effect)
        annotation (Line(
          points={{-90,90},{-60,90},{-60,26},{-7.8,26}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.AlphaPool_Effect, AplhaReceptors.AlphaPool_Effect)
        annotation (Line(
          points={{-90,90},{-60,90},{-60,32},{-7.8,32}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.GangliaGeneral_NA, AplhaReceptors.GangliaGeneral_NA)
        annotation (Line(
          points={{-90,90},{-60,90},{-60,20},{-7.8,20}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Anesthesia_VascularConductance, Anesthesia.u)
        annotation (Line(
          points={{-90,90},{-60,90},{-60,60},{-6,60}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Viscosity_ConductanceEffect, Viscosity.u) annotation (
          Line(
          points={{-90,90},{-60,90},{-60,68},{-6,68}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Vasopressin, ADHEffect.u) annotation (Line(
          points={{-90,90},{-60,90},{-60,40},{-6,40}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Angiotensin2, A2Effect.u) annotation (Line(
          points={{-90,90},{-60,90},{-60,50},{-6,50}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
    connect(tissueConnector.pO2, Vasculature.u) annotation (Line(
        points={{-84,10},{-60,10},{-60,-10},{-8,-10}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(tissueConnector.pO2, pO2OnConductance.u) annotation (Line(
        points={{-84,10},{-60,10},{-60,-18},{-6,-18}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      connect(PO2OnTension.y,PCO2OnTension. yBase) annotation (Line(
          points={{-18,-42},{-18,-44}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(TensionEffect.u,PCO2OnTension. y) annotation (Line(
          points={{-6,-62},{-18,-62},{-18,-50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(one.y, PO2OnTension.yBase) annotation (Line(
          points={{-21,-26},{-18,-26},{-18,-36}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(MusclePumping_SkeletalMuscle.u,add. y) annotation (Line(
          points={{10,8},{32,8},{32,13.6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(add.u,RateEffect. y) annotation (Line(
          points={{32,22.8},{32,26}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(RateEffect.u, busConnector.Exercise_Metabolism_ContractionRate)
        annotation (Line(
          points={{40,30},{98,30},{98,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(TensionEffect.y, metabolicVasolidation.yBase) annotation (Line(
          points={{2,-66},{2,-70}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(tissueConnector.O2Need, metabolicVasolidation.O2Need) annotation (
       Line(
        points={{-84,10},{-60,10},{-60,-72},{-7.8,-72}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      connect(one1.y, IntensityEffect.yBase) annotation (Line(
          points={{29,56},{32,56},{32,42}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(tissueConnector.pO2, PO2OnTension.u) annotation (Line(
        points={{-84,10},{-60,10},{-60,-38},{-26,-38}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(tissueConnector.pCO2, PCO2OnTension.u) annotation (Line(
        points={{-84,10},{-60,10},{-60,-46},{-26,-46}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      connect(flowMeasure.volumeFlow,BloodFlow)  annotation (Line(
          points={{58,-78},{58,-62},{84,-62}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(q_in, flowMeasure.q_in) annotation (Line(
          points={{90,-90},{68,-90}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.q_out, resistor.q_in) annotation (Line(
          points={{48,-90},{12,-90}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(resistor.q_out, q_out) annotation (Line(
          points={{-8,-90},{-84,-90}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(A2Effect.y, ADHEffect.yBase) annotation (Line(
          points={{2,46},{2,42}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AplhaReceptors.yBase, ADHEffect.y) annotation (Line(
          points={{2,33},{2,36}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Anesthesia.y, A2Effect.yBase) annotation (Line(
          points={{2,56},{2,52}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pO2OnConductance.y, TensionEffect.yBase) annotation (Line(
          points={{2,-22},{2,-60}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(resistor.cond, metabolicVasolidation.y) annotation (Line(
          points={{2,-84},{2,-76}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AplhaReceptors.y, MusclePumping_SkeletalMuscle.yBase) annotation (
          Line(
          points={{2,19},{2,10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Vasculature.yBase, MusclePumping_SkeletalMuscle.y) annotation (Line(
          points={{2,-2},{2,4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(IntensityEffect.y, RateEffect.yBase) annotation (Line(
          points={{32,36},{32,32}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(tissueConnector.Function_Failed, Vasculature.Failed) annotation (
        Line(
        points={{-84,10},{-60,10},{-60,-4},{-8,-4}},
        color={127,0,0},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(IntensityEffect.u, busConnector.Exercise_Metabolism_MotionWatts)
      annotation (Line(
        points={{40,40},{98,40},{98,90},{-90,90}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
      annotation (
        Documentation(info="<HTML>
<PRE>
Blood resistance in gastro interstitial tract.

</PRE>
</HTML>
",   revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"),
         Icon(coordinateSystem(
              preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
            graphics={Text(
              extent={{-120,-106},{80,-86}},
              lineColor={0,0,255},
              textString="%name")}));
    end TissueBloodFlow;

    model Liver
      extends Interfaces.BaseDO;
      extends Physiolibrary.Icons.Liver;
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a portalVein annotation (
       extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,-110},
              {10,-90}}, rotation=0),
                        iconTransformation(extent={{12,-58},{32,-38}})));
    Physiolibrary.Hydraulic.Components.Conductor liverPortalConductance(
        Conductance=2.2251826750088e-08)
      "corrected to flow 1250ml/min in pressure gradient 1 mmHg"
      annotation (Placement(transformation(extent={{-52,-8},{-68,8}})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure1 annotation (
        Placement(transformation(
          extent={{-10,10},{10,-10}},
          rotation=180,
          origin={-84,0})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure2 annotation (
        Placement(transformation(
          extent={{-10,10},{10,-10}},
          rotation=180,
          origin={-24,-16})));
    Physiolibrary.Hydraulic.Components.Conductor HepaticArtyConductance(
        Conductance=3.5002873539464e-10)
      annotation (Placement(transformation(extent={{0,36},{-20,56}})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure3 annotation (
        Placement(transformation(
          extent={{-10,10},{10,-10}},
          rotation=180,
          origin={12,46})));
    equation
      connect(flowMeasure1.volumeFlow, busConnector.Liver_BloodFlow)
        annotation (Line(
          points={{-84,12},{-84,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(flowMeasure2.volumeFlow, busConnector.PortalVein_BloodFlow)
        annotation (Line(
          points={{-24,-4},{-24,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(flowMeasure3.volumeFlow, busConnector.HepaticArty_BloodFlow)
        annotation (Line(
          points={{12,58},{12,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(portalVein, flowMeasure2.q_in) annotation (Line(
          points={{-4,-12},{-4,-16},{-14,-16}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.q_out, flowMeasure3.q_in) annotation (Line(
          points={{78,0},{32,0},{32,46},{22,46}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure3.q_out, HepaticArtyConductance.q_in) annotation (
          Line(
          points={{2,46},{0,46}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(liverPortalConductance.q_out, flowMeasure1.q_in) annotation (Line(
        points={{-68,0},{-67,0},{-67,-7.34788e-016},{-74,-7.34788e-016}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
      connect(flowMeasure1.q_out, q_out) annotation (Line(
          points={{-94,7.34788e-016},{-94,0},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(flowMeasure2.q_out, liverPortalConductance.q_in) annotation (Line(
        points={{-34,-16},{-50,-16},{-50,0},{-52,0}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(liverPortalConductance.q_in, HepaticArtyConductance.q_out)
      annotation (Line(
        points={{-52,2.22045e-016},{-50,2.22045e-016},{-50,46},{-20,46}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    end Liver;

    model Kidney
      extends Physiomodel.CardioVascular2.Microcirculation.Interfaces.BaseDO;
      extends Physiolibrary.Icons.Kidney;

    Physiolibrary.Blocks.Factors.Normalization
      NephronCountEffect_AfferentArtery
      annotation (Placement(transformation(extent={{20,34},{40,54}})));
    Physiolibrary.Types.Constants.HydraulicConductanceConst
      Afferent_BasicConductance(k=4.2503489297921e-09)
      annotation (Placement(transformation(extent={{16,48},{28,60}})));
      VariableResistorWithMyogenicResponse AfferentArtery(
          PressureChangeOnMyogenicCondEffect={{-20.0,1.2,0.0},{0.0,1.0,-0.02},
            {20.0,0.8,0.0}}, pressureChange(start=0),
      InitialPressureChange(displayUnit="mmHg") = 9.33256711905,
      K_PressureChange(displayUnit="Hz"))
        annotation (Placement(transformation(extent={{20,-12},{44,12}})));
    Physiolibrary.Blocks.Factors.Spline A2Effect2(
      data={{0.0,1.2,0.0},{1.3,1.0,-0.4},{3.0,0.6,0.0}},
      Xscale=1e-9/Substances.AngiotensinII.mw,
      UsePositiveLog10=true)
      annotation (Placement(transformation(extent={{-56,18},{-36,38}})));
    Physiolibrary.Types.Constants.HydraulicConductanceConst
      Efferent_BasicConductance(k=2.87523604074162e-009)
      annotation (Placement(transformation(extent={{-60,48},{-48,60}})));
    Physiolibrary.Blocks.Factors.Normalization
      NephronCountEffect_KidneyEfferentArtery
      annotation (Placement(transformation(extent={{-56,34},{-36,54}})));
    Physiolibrary.Hydraulic.Components.Conductor EfferentArtery(
        useConductanceInput=true)
      annotation (Placement(transformation(extent={{-34,-12},{-58,12}})));
    Physiolibrary.Hydraulic.Components.Conductor ArcuateArtery(Conductance=
          7.500615758456399e-008)
      annotation (Placement(transformation(extent={{78,-8},{62,8}})));
      Physiomodel.Nerves.AplhaReceptorsActivityFactor
        AplhaReceptors_KidneyAfferentArtery(data={{1.5,1.0,0.0},{7.0,0.9,0.0}})
        annotation (Placement(transformation(extent={{20,14},{40,34}})));
      Physiomodel.Nerves.AplhaReceptorsActivityFactor
        AplhaReceptors_KidneyEfferentArtery(data={{1.5,1.0,0.0},{7.0,0.9,0.0}})
        annotation (Placement(transformation(extent={{-56,6},{-36,26}})));
    Physiolibrary.Blocks.Factors.Normalization
      Anesthesia_KidneyEfferentArtery
      annotation (Placement(transformation(extent={{-56,26},{-36,46}})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure
      annotation (Placement(transformation(
          extent={{-10,-10},{10,10}},
          origin={-20,8})));
      Modelica.Blocks.Math.Product KidneyPlasmaFlow annotation (Placement(
            transformation(
            extent={{-5,-5},{5,5}},
            rotation=90,
            origin={83,67})));
    Physiolibrary.Hydraulic.Sensors.PressureMeasure pressureMeasure1
      annotation (Placement(transformation(
          extent={{10,-10},{-10,10}},
          origin={52,-20})));
      Modelica.Blocks.Math.Gain IFP(k=0.042)
        annotation (Placement(transformation(extent={{42,-84},{34,-76}})));
      Physiolibrary.Blocks.Factors.LagSpline     TGFEffect(
                                                 data={{0.0,1.2,0.0},{1.3,1.0,
            -0.4},{3.0,0.6,0.0}},
        initialValue=1.01309,
        HalfTime=60*Modelica.Math.log(2),
      integrator(stateName="TGF-Vascular.Signal"))
      "Macula Densa TGF vascular signal delay and effect to afferent arteriole"
        annotation (Placement(transformation(extent={{20,26},{40,46}})));
    Physiolibrary.Blocks.Factors.Spline FurosemideEffect(data={{0.0,1.0,0.0},
          {1.3,0.2,0.0}}, Xscale=1e-3/Substances.Furosemide.mw)
      "furosemide outflow on Macula Densa Na sensibility"
      annotation (Placement(transformation(extent={{-10,-52},{10,-32}})));
    Physiolibrary.Blocks.Factors.Spline NaEffect_MaculaDensa(data={{0,0.0,0.0},
          {48,1.0,0.03},{100,3.0,0.0}})
      annotation (Placement(transformation(extent={{-10,-48},{10,-28}})));
    Physiolibrary.Blocks.Factors.Spline ANP_Effect(data={{0.0,1.2,0.0},{1.3,
          1.0,-0.3},{2.7,0.8,0.0}},
      UsePositiveLog10=true,
      Xscale=1e-9)
      annotation (Placement(transformation(extent={{-10,-56},{10,-36}})));
    Physiolibrary.Blocks.Factors.Spline A2Effect3(
      data={{0.0,0.0,0.0},{0.2,0.6,0.05},{1.3,1.0,0.1},{3.0,8.0,0.0}},
      Xscale=1e-9/Substances.AngiotensinII.mw,
      UsePositiveLog10=true)
      annotation (Placement(transformation(extent={{-10,-60},{10,-40}})));
    Physiolibrary.Types.Constants.FractionConst
      MedulaDensa_BaseTGFSignal(k=1)
      annotation (Placement(transformation(extent={{-10,-34},{-2,-26}})));
      VasaRecta vasaRecta
        annotation (Placement(transformation(extent={{70,-90},{90,-70}})));
    equation
      connect(Afferent_BasicConductance.y, NephronCountEffect_AfferentArtery.yBase)
                                                                 annotation (Line(
          points={{29.5,54},{30,54},{30,46}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.Kidney_NephronCount_Total_xNormal,
        NephronCountEffect_AfferentArtery.u) annotation (Line(
          points={{-90,90},{-14,90},{-14,66},{-14,44},{22,44}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.AlphaPool_Effect, AplhaReceptors_KidneyAfferentArtery.AlphaPool_Effect)
        annotation (Line(
          points={{-90,90},{-90,90},{-14,90},{-14,62},{-14,30},{20.2,30}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.AlphaBlocade_Effect, AplhaReceptors_KidneyAfferentArtery.AlphaBlockade_Effect)
        annotation (Line(
          points={{-90,90},{-90,90},{-14,90},{-14,54},{-14,24},{20.2,24}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.GangliaGeneral_NA,
        AplhaReceptors_KidneyAfferentArtery.GangliaGeneral_NA) annotation (
          Line(
          points={{-90,90},{-14,90},{-14,90},{-14,18},{20.2,18}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.AlphaPool_Effect, AplhaReceptors_KidneyEfferentArtery.AlphaPool_Effect)
        annotation (Line(
          points={{-90,90},{-92,90},{-92,22},{-55.8,22}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.GangliaGeneral_NA,
        AplhaReceptors_KidneyEfferentArtery.GangliaGeneral_NA) annotation (
          Line(
          points={{-90,90},{-92,90},{-92,10},{-55.8,10}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.AlphaBlocade_Effect, AplhaReceptors_KidneyEfferentArtery.AlphaBlockade_Effect)
        annotation (Line(
          points={{-90,90},{-92,90},{-92,16},{-55.8,16}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Kidney_NephronCount_Total_xNormal,
        NephronCountEffect_KidneyEfferentArtery.u) annotation (Line(
          points={{-90,90},{-92,90},{-92,44},{-54,44}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Anesthesia_VascularConductance,
        Anesthesia_KidneyEfferentArtery.u) annotation (Line(
          points={{-90,90},{-92,90},{-92,36},{-54,36}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(Efferent_BasicConductance.y,
        NephronCountEffect_KidneyEfferentArtery.yBase) annotation (Line(
          points={{-46.5,54},{-46,54},{-46,46}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(A2Effect2.y, AplhaReceptors_KidneyEfferentArtery.yBase)
        annotation (Line(
          points={{-46,24},{-46,23}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(NephronCountEffect_KidneyEfferentArtery.y,
        Anesthesia_KidneyEfferentArtery.yBase) annotation (Line(
          points={{-46,40},{-46,38}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Anesthesia_KidneyEfferentArtery.y, A2Effect2.yBase) annotation (
         Line(
          points={{-46,32},{-46,30}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AplhaReceptors_KidneyEfferentArtery.y, EfferentArtery.cond)
        annotation (Line(
          points={{-46,9},{-46,7.2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(AplhaReceptors_KidneyAfferentArtery.y, AfferentArtery.cond)
        annotation (Line(
          points={{30,17},{30,4.8},{32,4.8}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(pressureMeasure.q_in, AfferentArtery.q_out) annotation (Line(
          points={{-24,2},{-24,0},{20,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(pressureMeasure.pressure, busConnector.GlomerulusBloodPressure)
      annotation (Line(
        points={{-14,4},{-14,-16},{-90,-16},{-90,90}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,-3},{6,-3}}));
      connect(busConnector.BloodVol_PVCrit, KidneyPlasmaFlow.u2)
        annotation (Line(
          points={{-90,90},{96,90},{96,56},{86,56},{86,61}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{6,-3},{6,-3}}));
      connect(KidneyPlasmaFlow.y, busConnector.KidneyPlasmaFlow)
        annotation (Line(
          points={{83,72.5},{83,90},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{3,3},{3,3}}));
      connect(ArcuateArtery.q_out, AfferentArtery.q_in) annotation (Line(
          points={{62,0},{44,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(EfferentArtery.q_in, AfferentArtery.q_out) annotation (Line(
          points={{-34,0},{20,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(EfferentArtery.q_out, q_out) annotation (Line(
          points={{-58,0},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(AfferentArtery.q_in, pressureMeasure1.q_in) annotation (Line(
          points={{44,0},{58,0},{58,-26},{56,-26}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
    connect(IFP.u, pressureMeasure1.pressure) annotation (Line(
        points={{42.8,-80},{46,-80},{46,-24}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(ANP_Effect.y,A2Effect3. yBase) annotation (Line(
          points={{0,-50},{0,-48}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(FurosemideEffect.y,ANP_Effect. yBase) annotation (Line(
          points={{0,-46},{0,-44}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(NaEffect_MaculaDensa.y,FurosemideEffect. yBase) annotation (
          Line(
          points={{0,-42},{0,-40}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(MedulaDensa_BaseTGFSignal.y,NaEffect_MaculaDensa. yBase)
        annotation (Line(
          points={{-1,-30},{0,-30},{0,-36}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(A2Effect3.y,TGFEffect. u) annotation (Line(
          points={{0,-54},{-26,-54},{-26,36},{22,36}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(NephronCountEffect_AfferentArtery.y, TGFEffect.yBase) annotation (
          Line(
          points={{30,40},{30,38}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(TGFEffect.y, AplhaReceptors_KidneyAfferentArtery.yBase) annotation (
          Line(
          points={{30,32},{30,31}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.FurosemidePool_Loss, FurosemideEffect.u)
        annotation (Line(
          points={{-90,90},{-90,-42},{-8,-42}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(flowMeasure.volumeFlow, KidneyPlasmaFlow.u1) annotation (Line(
          points={{88,12},{88,50},{80,50},{80,61}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(flowMeasure.q_out,ArcuateArtery. q_in) annotation (Line(
          points={{78,0},{78,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(busConnector, vasaRecta.busConnector) annotation (Line(
          points={{-90,90},{-90,-72},{72,-72}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
    connect(pressureMeasure1.pressure, vasaRecta.ArcuateArtery_Pressure)
      annotation (Line(
        points={{46,-24},{46,-80},{72,-80}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(busConnector.NephronIFP_Pressure, IFP.y) annotation (
          Line(
          points={{-90,90},{-90,-80},{33.6,-80}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.MD_Na, NaEffect_MaculaDensa.u)
        annotation (Line(
          points={{-90,90},{-90,-38},{-8,-38}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
    connect(busConnector.Angiotensin2, A2Effect2.u) annotation (Line(
        points={{-90,90},{-92,90},{-92,28},{-54,28}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(busConnector.Angiotensin2, A2Effect3.u) annotation (Line(
        points={{-90,90},{-90,-50},{-8,-50}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(busConnector.ANP, ANP_Effect.u) annotation (Line(
        points={{-90,90},{-90,-46},{-8,-46}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      annotation (
        Documentation(info="<HTML>
<PRE>
Blood resistance in kidneys.

QHP 2008 / Kidney-Flow

</PRE>
</HTML>
",   revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),
        Diagram(coordinateSystem(preserveAspectRatio=false,extent={{-100,-100},
              {100,100}}),   graphics={Rectangle(extent={{-18,-24},{18,-62}},
                lineColor={127,0,0}), Text(
              extent={{-18,-62},{18,-56}},
              lineColor={0,0,255},
              textString="Macula Densa")}),         Icon(coordinateSystem(
              preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
            graphics={Text(
              extent={{-100,-100},{100,-80}},
              lineColor={0,0,255},
              textString="%name")}));
    end Kidney;

    model LeftHeart
      extends Interfaces.Heart(
                    Vasculature(stateName="LeftHeart-Vasculature.Effect"));
      extends Physiolibrary.Icons.LeftHeart;
    equation
      connect(busConnector.LeftHeart_Function_Failed, Vasculature.Failed)
        annotation (Line(
          points={{-90,90},{6,90},{6,44},{60,44}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.LeftHeart_PO2, PO2Effect.u) annotation (
          Line(
          points={{-90,90},{6,90},{6,30},{62,30}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.LeftHeart_O2Need, MetabolismEffect.u)
        annotation (Line(
          points={{-90,90},{6,90},{6,20},{62,20}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.LeftHeart_PO2, Vasculature.u) annotation (
         Line(
          points={{-90,90},{6,90},{6,38},{60,38}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
    end LeftHeart;

    model RightHeart
      extends Interfaces.Heart(
                    Vasculature(stateName="RightHeart-Vasculature.Effect"));
      extends Physiolibrary.Icons.RightHeart;
    equation
      connect(busConnector.RightHeart_PO2, Vasculature.u)
        annotation (Line(
          points={{-90,90},{6,90},{6,38},{60,38}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.RightHeart_PO2, PO2Effect.u) annotation (
          Line(
          points={{-90,90},{6,90},{6,30},{62,30}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.RightHeart_O2Need, MetabolismEffect.u)
        annotation (Line(
          points={{-90,90},{6,90},{6,20},{62,20}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.RightHeart_Function_Failed, Vasculature.Failed)
        annotation (Line(
          points={{-90,90},{6,90},{6,44},{60,44}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
    end RightHeart;

    model Skin
      extends Physiomodel.CardioVascular2.Microcirculation.Interfaces.BaseDO;
      extends Physiolibrary.Icons.Skin;

    Physiolibrary.Hydraulic.Components.Conductor skin(useConductanceInput=
          true)
      annotation (Placement(transformation(extent={{80,-26},{56,-2}})));
    Physiolibrary.Blocks.Factors.Spline A2Effect_Skin(
      data={{0.0,1.05,0},{1.3,1.00,-0.08},{3.5,0.50,0}},
      Xscale=1e-9/Substances.AngiotensinII.mw,
      UsePositiveLog10=true)
      annotation (Placement(transformation(extent={{58,30},{78,50}})));
    Physiolibrary.Blocks.Factors.Spline ADHEffect_Skin(
      data={{0.8,1.0,0},{3.0,0.1,0}},
      Xscale=1e-9/Substances.Vasopressin.mw,
      UsePositiveLog10=true)
      annotation (Placement(transformation(extent={{58,16},{78,36}})));
    Physiolibrary.Types.Constants.HydraulicConductanceConst BasicConductance(k=
          2.0001642022551e-10)
      annotation (Placement(transformation(extent={{54,72},{66,84}})));
    Physiolibrary.Blocks.Factors.Normalization Viscosity_Skin
      annotation (Placement(transformation(extent={{58,58},{78,78}})));
    Physiolibrary.Blocks.Factors.Normalization Anesthesia_Skin
      annotation (Placement(transformation(extent={{58,50},{78,70}})));
      Physiolibrary.Blocks.Factors.SplineLagOrZero
        Vasculature_Skin(HalfTime=30*86400*Modelica.Math.log(2), data={{41,1.2,0},{51,1.0,-0.03},{61,0.8,0}},
        stateName="Skin-Vasculature.Effect")
        annotation (Placement(transformation(extent={{58,40},{78,60}})));
    Physiolibrary.Blocks.Factors.Normalization TermoregulationEffect
      annotation (Placement(transformation(extent={{58,-2},{78,18}})));
    equation
      connect(Anesthesia_Skin.yBase,Viscosity_Skin. y) annotation (Line(
          points={{68,62},{68,64}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Anesthesia_Skin.y,Vasculature_Skin. yBase) annotation (Line(
          points={{68,56},{68,56}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Vasculature_Skin.y,A2Effect_Skin. yBase) annotation (Line(
          points={{68,44},{68,42}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(BasicConductance.y, Viscosity_Skin.yBase)      annotation (Line(
          points={{67.5,78},{68,78},{68,70}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.Viscosity_ConductanceEffect, Viscosity_Skin.u)
        annotation (Line(
          points={{-90,90},{-12,90},{-12,68},{60,68}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Anesthesia_VascularConductance, Anesthesia_Skin.u)
        annotation (Line(
          points={{-90,90},{-12,90},{-12,60},{60,60}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Skin_Function_Failed, Vasculature_Skin.Failed)
        annotation (Line(
          points={{-90,90},{-12,90},{-12,54},{58,54}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.Skin_PO2, Vasculature_Skin.u) annotation (Line(
          points={{-90,90},{-12,90},{-12,48},{58,48}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(skin.q_out, q_out) annotation (Line(
          points={{56,-14},{-24,-14},{-24,0},{-100,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(skin.q_in, flowMeasure.q_out) annotation (Line(
          points={{80,-14},{80,0},{78,0}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(ADHEffect_Skin.y, busConnector.skin_conductanceWithoutTermoregulationEffect)
        annotation (Line(
          points={{68,22},{-90,22},{-90,90}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(busConnector.skinFlow_termoregulationEffect,
        TermoregulationEffect.u) annotation (Line(
          points={{-90,90},{-88,90},{-88,8},{60,8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(ADHEffect_Skin.y, TermoregulationEffect.yBase) annotation (Line(
          points={{68,22},{68,10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(TermoregulationEffect.y, skin.cond) annotation (Line(
          points={{68,4},{68,-6.8}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(A2Effect_Skin.y, ADHEffect_Skin.yBase) annotation (Line(
          points={{68,36},{68,28}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(busConnector.Angiotensin2, A2Effect_Skin.u) annotation (Line(
        points={{-90,90},{-12,90},{-12,40},{60,40}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(busConnector.Vasopressin, ADHEffect_Skin.u) annotation (Line(
        points={{-90,90},{-12,90},{-12,26},{60,26}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
       annotation (
        Documentation(info="<HTML>
<PRE>
Blood resistance in skin.

QHP 2008 / Skin-Flow

</PRE>
</HTML>
",   revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"),
         Icon(graphics={Text(
              extent={{-100,-100},{100,-80}},
              lineColor={0,0,255},
              textString="%name")}));
    end Skin;

    model MetabolicVasodilation
      extends Physiolibrary.Icons.BaseFactorIcon5;
      Physiolibrary.Types.RealIO.MolarFlowRateInput O2Need
                   annotation (Placement(transformation(extent={{-110,60},{-82,88}}),
            iconTransformation(extent={{-108,-10},{-88,10}})));

     parameter Boolean enabled=true "disabled => y=yBase";

     parameter Real[:,3] data = {{   50,  1.0,  0}, { 1000,  3.5,  0.003}, { 3000,  5.5,  0}};
     parameter Physiolibrary.Types.Time OnTau = 0.2;
     parameter Physiolibrary.Types.Time OffTau = 1;
     parameter Physiolibrary.Types.Fraction initialEffectValue = 1;
      parameter String stateName=getInstanceName();
      parameter Physiolibrary.Types.MolarFlowRate Xscale = 1
      "conversion scale to SI unit of x values";

    Physiolibrary.Blocks.Interpolation.Curve SteadyState(
      x=data[:, 1],
      y=data[:, 2],
      slope=data[:, 3],
        Xscale=Xscale)
      annotation (Placement(transformation(extent={{-72,64},{-52,84}})));
    Physiolibrary.Blocks.Math.Integrator effect(
      y_start=initialEffectValue,
      stateName=stateName,
        k=1)  annotation (Placement(transformation(
          extent={{-10,-10},{10,10}},
          rotation=270,
          origin={-28,-14})));
      Modelica.Blocks.Math.Feedback feedback annotation (Placement(
            transformation(
            extent={{-8,-12},{12,-32}},
            rotation=270,
            origin={8,64})));
      Modelica.Blocks.Math.Product product1 annotation (Placement(transformation(
            extent={{-10,-10},{10,10}},
            rotation=270,
            origin={-22,16})));
      Modelica.Blocks.Logical.Switch switch1(u2(start=false))
        annotation (Placement(transformation(extent={{-54,24},{-34,44}})));
      Modelica.Blocks.Logical.GreaterThreshold greaterThreshold
        annotation (Placement(transformation(extent={{-72,30},{-64,38}})));
    Physiolibrary.Blocks.Math.Reciprocal OnK annotation (Placement(
          transformation(
          extent={{-10,-10},{10,10}},
          rotation=90,
          origin={-86,8})));
    Physiolibrary.Blocks.Math.Reciprocal OffK annotation (Placement(
          transformation(
          extent={{-10,-10},{10,10}},
          rotation=90,
          origin={-60,8})));
    Physiolibrary.Types.Constants.TimeConst                 Constant0(k=
          OnTau) annotation (Placement(transformation(
          extent={{-10,-10},{10,10}},
          rotation=90,
          origin={-86,-22})));
    Physiolibrary.Types.Constants.TimeConst                 Constant1(k=
          OffTau) annotation (Placement(transformation(
          extent={{-10,-10},{10,10}},
          rotation=90,
          origin={-60,-22})));

      Physiolibrary.Blocks.Factors.Normalization normalization(enabled=enabled)
        annotation (Placement(transformation(extent={{-10,-20},{10,0}})));
    equation
      connect(SteadyState.val, feedback.u1)
                                      annotation (Line(
          points={{-52,74},{-14,74},{-14,70}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(effect.y, feedback.u2)     annotation (Line(
          points={{-28,-25},{-28,-68},{86,-68},{86,62},{-6,62}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(SteadyState.u, O2Need)  annotation (Line(
          points={{-72,74},{-96,74}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(product1.y, effect.u)     annotation (Line(
          points={{-22,5},{-22,-2},{-28,-2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(product1.u1, feedback.y) annotation (Line(
          points={{-16,28},{-16,40},{-14,40},{-14,53}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(switch1.y, product1.u2) annotation (Line(
          points={{-33,34},{-28,34},{-28,28}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(greaterThreshold.u, feedback.y) annotation (Line(
          points={{-72.8,34},{-76,34},{-76,50},{-14,50},{-14,53}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(greaterThreshold.y, switch1.u2) annotation (Line(
          points={{-63.6,34},{-56,34}},
          color={255,0,255},
          smooth=Smooth.None));
      connect(OnK.y, switch1.u1)  annotation (Line(
          points={{-86,19},{-86,42},{-56,42}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(OffK.y, switch1.u3)  annotation (Line(
          points={{-60,19},{-60,26},{-56,26}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Constant1.y, OffK.u)  annotation (Line(
          points={{-60,-9.5},{-60,-4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Constant0.y, OnK.u)  annotation (Line(
          points={{-86,-9.5},{-86,-4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(effect.y, normalization.u) annotation (Line(
          points={{-28,-25},{-28,-40},{-12,-40},{-12,-10},{-8,-10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(yBase, normalization.yBase) annotation (Line(
          points={{0,20},{0,-8}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(normalization.y, y) annotation (Line(
          points={{0,-14},{0,-40}},
          color={0,0,127},
          smooth=Smooth.None));
    end MetabolicVasodilation;

    model VasaRecta

    Physiolibrary.Hydraulic.Components.Conductor resistorWithCond(
        useConductanceInput=true)
      annotation (Placement(transformation(extent={{2,0},{22,20}})));
    Physiolibrary.Blocks.Factors.Spline OsmOnConductance(data={{600,1.4,0},{
          1100,1.0,-0.0006},{2000,0.8,0}})
      annotation (Placement(transformation(extent={{2,38},{22,58}})));
    Physiolibrary.Blocks.Factors.Spline A2OnConductance(
      data={{0.0,1.3,0},{1.3,1.0,-0.6},{2.0,0.5,0}},
      Xscale=1e-9/Substances.AngiotensinII.mw,
      UsePositiveLog10=true)
      annotation (Placement(transformation(extent={{2,26},{22,46}})));
    Physiolibrary.Blocks.Factors.Spline SympsOnConductance(data={{0.0,1.1,0},
          {1.0,1.0,-0.13},{1.4,0.6,0}})
      annotation (Placement(transformation(extent={{2,18},{22,38}})));
    Physiolibrary.Types.Constants.HydraulicConductanceConst condConstant(k(displayUnit="ml/(mmHg.min)")=
        3.3752770913055e-11)
      annotation (Placement(transformation(extent={{-4,62},{8,74}})));
    Physiolibrary.Types.BusConnector busConnector
      "signals of organ bood flow resistence" annotation (Placement(
          transformation(extent={{-96,64},{-74,86}}), iconTransformation(
            extent={{-100,60},{-60,100}})));
    Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure
      annotation (Placement(transformation(extent={{32,20},{52,0}})));
    Physiolibrary.Hydraulic.Sources.UnlimitedPump inputPump(
        useSolutionFlowInput=true)
      annotation (Placement(transformation(extent={{-54,-48},{-34,-28}})));
      Modelica.Blocks.Math.Add Osm
        annotation (Placement(transformation(extent={{-14,44},{-6,52}})));
      Modelica.Blocks.Interfaces.RealInput ArcuateArtery_Pressure
                                                           annotation (
          Placement(transformation(extent={{-80,20},{-68,32}}),
            iconTransformation(extent={{-100,-20},{-60,20}})));
    Physiolibrary.Blocks.Factors.LagSpline
                                        NephroneADHOnConductance(data={{0.0,
          1.4,0},{0.3,1.0,-0.4},{1.0,0.9,0}}, Xscale=1e-9/Substances.Vasopressin.mw,
      HalfTime=Modelica.Math.log(2)*20*60,
      initialValue=2e-9/Substances.Vasopressin.mw)
      "initial 2pg/ml = 2e-9 kg/m3, NephronADH.Tau = 20 min"
      annotation (Placement(transformation(extent={{2,46},{22,66}})));
    Physiolibrary.Hydraulic.Sources.UnlimitedVolume arcuateArtery(
        usePressureInput=true)
      annotation (Placement(transformation(extent={{-62,0},{-42,20}})));
    Physiolibrary.Hydraulic.Sources.UnlimitedVolume veins(usePressureInput=
          true)
      annotation (Placement(transformation(extent={{96,0},{76,20}})));
    equation
      connect(SympsOnConductance.y, resistorWithCond.cond) annotation (Line(
          points={{12,24},{12,16}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(A2OnConductance.y, SympsOnConductance.yBase) annotation (Line(
          points={{12,32},{12,30}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(OsmOnConductance.y, A2OnConductance.yBase) annotation (Line(
          points={{12,44},{12,38}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.Kidney_Alpha_NA, SympsOnConductance.u) annotation (Line(
          points={{-85,75},{-60,75},{-60,28},{4,28}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(resistorWithCond.q_out, flowMeasure.q_in) annotation (Line(
          points={{22,10},{32,10}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(flowMeasure.volumeFlow, busConnector.VasaRecta_Outflow) annotation (
          Line(
          points={{42,-2},{42,75},{-85,75}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,-12},{6,-12}}));
      connect(inputPump.q_out, flowMeasure.q_in) annotation (Line(
          points={{-34,-38},{26,-38},{26,10},{32,10}},
          color={0,0,0},
          thickness=1,
          smooth=Smooth.None));
      connect(Osm.y, OsmOnConductance.u) annotation (Line(
          points={{-5.6,48},{4,48}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.MedullaNa_Osmolarity, Osm.u1) annotation (Line(
          points={{-85,75},{-60,75},{-60,50.4},{-14.8,50.4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.MedullaUrea_Osmolarity, Osm.u2) annotation (Line(
          points={{-85,75},{-60,75},{-60,45.6},{-14.8,45.6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
    connect(busConnector.CD_H2O_Reab, inputPump.solutionFlow) annotation (
        Line(
        points={{-85,75},{-76,75},{-76,-22},{-44,-22},{-44,-31}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      connect(NephroneADHOnConductance.y, OsmOnConductance.yBase) annotation (
         Line(
          points={{12,52},{12,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(condConstant.y, NephroneADHOnConductance.yBase) annotation (
          Line(
          points={{9.5,68},{12,68},{12,58}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(ArcuateArtery_Pressure, arcuateArtery.pressure) annotation (Line(
        points={{-74,26},{-68,26},{-68,10},{-62,10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(arcuateArtery.y, resistorWithCond.q_in) annotation (Line(
        points={{-42,10},{2,10}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(busConnector.SystemicVeins_Pressure, veins.pressure) annotation (
        Line(
        points={{-85,75},{96,75},{96,10}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(flowMeasure.q_out, veins.y) annotation (Line(
        points={{52,10},{76,10}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(busConnector.Angiotensin2, A2OnConductance.u) annotation (Line(
        points={{-85,75},{-60,75},{-60,36},{4,36}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(busConnector.Vasopressin, NephroneADHOnConductance.u) annotation (
       Line(
        points={{-85,75},{-60,75},{-60,56},{4,56}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
      annotation (          Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2010</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
    end VasaRecta;

  model VariableResistorWithMyogenicResponse
    extends Physiolibrary.Icons.Resistor;

    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                    iconTransformation(extent={{90,-10},{110,
              10}})));
    Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out "Blood outflow"
      annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
              -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-110,-10},{
              -90,10}})));

    //(q_in(pressure(start=95.5)),q_out(pressure(start=61.5)));
    extends Physiolibrary.SteadyStates.Interfaces.SteadyState(
                                                  stateName="Kidney-MyogenicDelay.PressureChange", state_start=InitialPressureChange);

    Physiolibrary.Types.RealIO.HydraulicConductanceInput cond(displayUnit="ml/(min.mmHg)")
        annotation (Placement(transformation(extent={{-100,92},             {-80,112}}), iconTransformation(
                 extent={{-10,-10},{10,10}},         rotation=270,         origin={0,40})));

    Physiolibrary.Types.Fraction myogenicEffect;
    Physiolibrary.Types.Pressure pressureChange(start=InitialPressureChange); //(start=0.161874);
  //  Real pressureChangeSteadyState;
   // Real adaptedPressure; //(start=77.9546);
  //  Real interlobarPressure;
    parameter Physiolibrary.Types.Pressure InitialPressureChange=0;

    parameter Physiolibrary.Types.Frequency K_PressureChange(displayUnit="1/min") =  2.0/60;
    parameter Physiolibrary.Types.Time Tau_PressureAdoption(displayUnit="hod") =  4.0*60*60;
    parameter Real[:,3] PressureChangeOnMyogenicCondEffect;
    Physiolibrary.Blocks.Interpolation.Curve PressureChangeOnCondEffect(
      x=PressureChangeOnMyogenicCondEffect[:, 1],
      y=PressureChangeOnMyogenicCondEffect[:, 2],
      slope=PressureChangeOnMyogenicCondEffect[:, 3],
      Xscale=101325/760)
      annotation (Placement(transformation(extent={{14,26},{34,46}})));

    AfferentArteryMyogenicReceptors kidneyMyogenic(initialPressure(
          displayUnit="mmHg") = 9999.179056125)
      annotation (Placement(transformation(extent={{-46,50},{-26,70}})));
  //initial equation
   // adaptedPressure = interlobarPressure;
    //der(adaptedPressure) = 0;
   // der(pressureChange) = 0;
  equation
    q_in.q + q_out.q = 0;

    q_in.q = myogenicEffect * cond * (q_in.pressure - q_out.pressure);
    kidneyMyogenic.InterlobarPressure = (q_in.pressure + q_out.pressure)/2;  //stredny tlak v arteriole
   // der(adaptedPressure) = (1/(60*Tau_PressureAdoption)) * (interlobarPressure-adaptedPressure); //receptory sa adaptuju na tlak (polcas adaptacie nastane za 2hod a 45min)
   // pressureChangeSteadyState = interlobarPressure-adaptedPressure;  //zmena tlaku sa taktiez adaptuje - neviem preco? => potom to vizera, ze stimulacia receptorov je postupny proces (polcas nabudenia stimulacie je 20 sekund)

    state = pressureChange;
    change = K_PressureChange * (kidneyMyogenic.PressureChange_SteadyState - pressureChange);

    PressureChangeOnCondEffect.u = pressureChange; //zmena tlaku aktivuje receptory
    myogenicEffect = PressureChangeOnCondEffect.val; //stimulacia receptorov ma vplyv na vodivost (odpor) krvi aferentnej arterie
    annotation ( Icon(graphics={
            Text(
              extent={{-110,-68},{106,-32}},
              textString="%name",
              lineColor={0,0,255}),
            Text(
              extent={{-68,-20},{66,12}},
              lineColor={0,0,0},
              textString="blood flow"),
            Rectangle(
              extent={{-70,30},{70,-30}},
              lineColor={0,0,255},
              fillColor={215,215,215},
              fillPattern=FillPattern.Sphere),
            Text(
              extent={{-54,20},{52,-18}},
              lineColor={0,0,0},
              fillPattern=FillPattern.Sphere,
              fillColor={215,215,215},
              textString="Myogenic")}),
          Documentation(info="<html> <pre>Receptory sa adaptuju na priemerny tlak v arteriole - polcas adaptacie nastane za 2hod a 45min.
        Zmena tlaku sa taktiez adaptuje - neviem preco? =&GT; potom to vizera, ze stimulacia receptorov je postupny proces (polcas nabudenia stimulacie je 20 sekund).
        Zmena tlaku aktivuje receptory, ktorych stimulacia ma vplyv na vasokonstrikciu danej arterioly.</pre> </html>"));
  end VariableResistorWithMyogenicResponse;

    model AfferentArteryMyogenicReceptors
      extends Physiolibrary.SteadyStates.Interfaces.SteadyState(
                                                    stateName="Kidney-Myogenic.AdaptedPressure",
                                                    state_start=initialPressure,
                                                    state(nominal=1e5));
      parameter Physiolibrary.Types.Time Tau = 4*60*60;
      parameter Physiolibrary.Types.Frequency K =   1 / ( Tau);
      parameter Physiolibrary.Types.Pressure initialPressure;
      Physiolibrary.Types.Pressure AdaptedPressure(displayUnit="mmHg");
      Physiolibrary.Types.RealIO.PressureInput
                                         InterlobarPressure(
                                                      displayUnit="mmHg") annotation (
          Placement(transformation(extent={{-100,20},{-60,60}}), iconTransformation(
              extent={{-100,20},{-60,60}})));
      Physiolibrary.Types.RealIO.PressureOutput
                                          PressureChange_SteadyState(
                                                               displayUnit="mmHg")
        annotation (Placement(transformation(extent={{80,-60},{120,-20}}),
            iconTransformation(extent={{80,-60},{120,-20}})));
    equation
    state = AdaptedPressure;
      change = K  * ( InterlobarPressure  -  AdaptedPressure);

      PressureChange_SteadyState = InterlobarPressure - AdaptedPressure;
    end AfferentArteryMyogenicReceptors;

    package Interfaces
      partial model BaseOD
      extends Physiolibrary.Icons.PerfusionOD;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{-110,-10},{-90,10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
        "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{90,-10},{110,10}})));

      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{-100,80},{-80,100}}), iconTransformation(
              extent={{60,10},{78,28}})));

        Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                                 annotation (Placement(transformation(
                extent={{-76,-18},{-66,-8}}),iconTransformation(extent={{60,-30},{80,-10}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
          Placement(transformation(
            extent={{-10,-10},{10,10}},
            origin={-82,0})));
      equation

        connect(q_in, flowMeasure.q_in) annotation (Line(
            points={{-100,0},{-92,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(flowMeasure.volumeFlow, BloodFlow) annotation (Line(
            points={{-82,12},{-82,-13},{-71,-13}},
            color={0,0,127},
            smooth=Smooth.None));
        annotation (Documentation(info="<HTML>
<PRE>
Blood flow variable resistor abstract model.
</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end BaseOD;

      partial model BaseDO
      extends Physiolibrary.Icons.PerfusionDO;

      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_a q_in "Blood inflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                      iconTransformation(extent={{90,-10},{110,
                10}})));
      Physiolibrary.Hydraulic.Interfaces.HydraulicPort_b q_out
        "Blood outflow"
        annotation (extent=[-10,-110; 10,-90], Placement(transformation(extent={{-10,
                -110},{10,-90}}, rotation=0),
                                        iconTransformation(extent={{-110,-10},{
                -90,10}})));

      Physiolibrary.Types.BusConnector busConnector
        "signals of organ bood flow resistence" annotation (Placement(
            transformation(extent={{-100,80},{-80,100}}), iconTransformation(
              extent={{60,10},{78,28}})));

        Modelica.Blocks.Interfaces.RealOutput BloodFlow
                                                 annotation (Placement(transformation(
                extent={{90,-22},{102,-10}}),iconTransformation(extent={{60,-60},{80,
                  -40}})));
      Physiolibrary.Hydraulic.Sensors.FlowMeasure flowMeasure annotation (
          Placement(transformation(
            extent={{10,-10},{-10,10}},
            origin={88,0})));
      equation

        connect(flowMeasure.volumeFlow, BloodFlow) annotation (Line(
            points={{88,12},{88,-16},{96,-16}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(flowMeasure.q_in, q_in) annotation (Line(
            points={{98,0},{100,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        annotation (Documentation(info="<HTML>
<PRE>
Blood flow variable resistor abstract model.
</PRE>
</HTML>
",     revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
      end BaseDO;

      partial model Heart
        extends Physiomodel.CardioVascular2.Microcirculation.Interfaces.BaseDO;

      //parameter Real BasicLargeVeselsConductance( final quantity="Conductance", final displayUnit="ml/(min.mmHg)");
      //parameter Real BasicSmallVeselsConductance( final quantity="Conductance", final displayUnit="ml/(min.mmHg)");
      parameter Physiolibrary.Types.HydraulicConductance BasicLargeVeselsConductance( displayUnit="ml/(min.mmHg)");
      parameter Physiolibrary.Types.HydraulicConductance BasicSmallVeselsConductance( displayUnit="ml/(min.mmHg)");

      Physiolibrary.Blocks.Factors.Spline PO2Effect(data={{12,2.0,0},{17,1.0,-0.04},
            {30,0.8,0}}, Xscale=101325/760)
        annotation (Placement(transformation(extent={{60,20},{80,40}})));
      Physiolibrary.Blocks.Factors.Spline ADHEffect2(
        data={{0.8,1.0,0},{3.0,0.1,0}},
        UsePositiveLog10=true,
        Xscale=1e-9/Substances.Vasopressin.mw)
        annotation (Placement(transformation(extent={{60,58},{80,78}})));
      Physiolibrary.Blocks.Factors.Spline MetabolismEffect(data={{30,1.0,0},{
            100,3.0,0}}, Xscale=1/1362657.193569)
        "O2Need 1 ml_STP/min = 1/1362657.193569 mol/s"
        annotation (Placement(transformation(extent={{60,10},{80,30}})));
      Physiolibrary.Blocks.Factors.Normalization Anesthesia
        annotation (Placement(transformation(extent={{60,66},{80,86}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst
        LargeVesselBasicConductance(k=BasicLargeVeselsConductance)
        annotation (Placement(transformation(extent={{-6,18},{-18,30}})));
      Physiolibrary.Blocks.Factors.Normalization Viscosity1
        annotation (Placement(transformation(extent={{-30,4},{-10,24}})));
      Physiolibrary.Types.Constants.HydraulicConductanceConst
        SmallVesselBasicConductance(k=BasicSmallVeselsConductance)
        annotation (Placement(transformation(extent={{90,86},{78,98}})));
        Physiomodel.Nerves.AplhaReceptorsActivityFactor aplhaReceptorsActivityFactor(
            data={{0.0,1.3,0},{1.0,1.0,-0.16},{4.0,0.8,0}})
          annotation (Placement(transformation(extent={{60,46},{80,66}})));
      Physiolibrary.Blocks.Factors.DamagedFraction Infraction
        annotation (Placement(transformation(extent={{60,2},{80,22}})));
        Physiolibrary.Blocks.Factors.SplineLagOrZero              Vasculature(
            data={{41,1.2,0},{51,1.0,-0.03},{61,0.8,0}}, HalfTime=30*86400*Modelica.Math.log(2),
          integrator(y_start=1.2),
        Xscale=101325/760)
          annotation (Placement(transformation(extent={{60,30},{80,50}})));
      Physiolibrary.Blocks.Factors.Normalization Viscosity
        annotation (Placement(transformation(extent={{60,74},{80,94}})));
      Physiolibrary.Hydraulic.Components.Conductor resistor2_1(
          useConductanceInput=true)
        annotation (Placement(transformation(extent={{60,-10},{80,10}})));
      Physiolibrary.Hydraulic.Components.Conductor resistor2_2(
          useConductanceInput=true)
        annotation (Placement(transformation(extent={{-30,-10},{-10,10}})));
      equation
        connect(LargeVesselBasicConductance.y, Viscosity1.yBase) annotation (Line(
            points={{-19.5,24},{-20,24},{-20,16}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Viscosity.y, Anesthesia.yBase) annotation (Line(
            points={{70,80},{70,78}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(busConnector.Anesthesia_VascularConductance, Anesthesia.u)
          annotation (Line(
            points={{-90,90},{6,90},{6,76},{62,76}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Viscosity_ConductanceEffect, Viscosity.u) annotation (
            Line(
            points={{-90,90},{6,90},{6,84},{62,84}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaPool_Effect, aplhaReceptorsActivityFactor.AlphaPool_Effect)
          annotation (Line(
            points={{-90,90},{6,90},{6,62},{60.2,62}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.AlphaBlocade_Effect, aplhaReceptorsActivityFactor.AlphaBlockade_Effect)
          annotation (Line(
            points={{-90,90},{6,90},{6,56},{60.2,56}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.GangliaGeneral_NA, aplhaReceptorsActivityFactor.GangliaGeneral_NA)
          annotation (Line(
            points={{-90,90},{6,90},{6,50},{60.2,50}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(busConnector.Viscosity_ConductanceEffect, Viscosity1.u) annotation (
            Line(
            points={{-90,90},{-74,90},{-74,14},{-28,14}},
            color={0,0,255},
            thickness=0.5,
            smooth=Smooth.None), Text(
            string="%first",
            index=-1,
            extent={{-6,3},{-6,3}}));
        connect(Viscosity.yBase, SmallVesselBasicConductance.y) annotation (
            Line(
            points={{70,86},{70,92},{76.5,92}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Anesthesia.y, ADHEffect2.yBase) annotation (Line(
            points={{70,72},{70,70}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(ADHEffect2.y, aplhaReceptorsActivityFactor.yBase) annotation (
            Line(
            points={{70,64},{70,63}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(aplhaReceptorsActivityFactor.y, Vasculature.yBase) annotation (
            Line(
            points={{70,49},{70,46}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(Vasculature.y, PO2Effect.yBase) annotation (Line(
            points={{70,34},{70,32}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(PO2Effect.y, MetabolismEffect.yBase) annotation (Line(
            points={{70,26},{70,22}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(MetabolismEffect.y, Infraction.yBase) annotation (Line(
            points={{70,16},{70,14}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(q_out, resistor2_2.q_in) annotation (Line(
            points={{-100,0},{-30,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(resistor2_2.q_out, resistor2_1.q_in) annotation (Line(
            points={{-10,0},{60,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(resistor2_1.q_out, flowMeasure.q_out) annotation (Line(
            points={{80,0},{78,0}},
            color={0,0,0},
            thickness=1,
            smooth=Smooth.None));
        connect(resistor2_1.cond, Infraction.y) annotation (Line(
            points={{70,6},{70,8}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(resistor2_2.cond, Viscosity1.y) annotation (Line(
            points={{-20,6},{-20,10}},
            color={0,0,127},
            smooth=Smooth.None));
      connect(busConnector.Vasopressin, ADHEffect2.u) annotation (Line(
          points={{-90,90},{6,90},{6,68},{62,68}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
        annotation (
          Documentation(info="<HTML>
<PRE>
Blood resistance in left heart.

QHP 2008 / LeftHeart-Flow

</PRE>
</HTML>
",     revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> january 2009 </i><br>
       by Marek Matejak in Modelica initially implemented (consulted with Jiri Kofranek), Charles University, Prague<br>
       orginaly described by Tom Coleman in QHP 2008 beta 3, University of Mississippi Medical Center
       </li>
</ul>
</html>"),
         Icon(graphics={Text(
                extent={{-100,-100},{100,-80}},
                lineColor={0,0,255},
                textString="%name")}));
      end Heart;
    end Interfaces;
  end Microcirculation;

  package Blood "Red Cells and Blood Properties"
    class References "References"
      extends Modelica.Icons.References;

      annotation (Documentation(info="<html>
<table>

	<tr>
		<td>[Begg1966]</td>
		<td>T. Begg and J. Hearns, \"Components in blood viscosity. The relative contribution of haematocrit, plasma fibrinogen and other proteins,\" Clinical science, vol. 31, pp. 87-93, 1966. </td>
	</tr>
	<tr>
		<td>[Brezis1995]</td>
		<td>M. Brezis and S. Rosen, \"Hypoxia of the Renal Medulla — Its Implications for Disease,\" New England Journal of Medicine, vol. 332, pp. 647-655, 1995. </td>
	</tr>
	<tr>
		<td>[Fan1980]</td>
		<td>F. C. Fan, R. Y. Chen, G. B. Schuessler, and S. Chien, Effects of hematocrit variations on regional hemodynamics and oxygen transport in the dog vol. 238, 1980. </td>
	</tr>
	<tr>
		<td>[Jan1977]</td>
		<td>K. M. Jan and S. Chien, Effect of hematocrit variations on coronary hemodynamics and oxygen utilization vol. 233, 1977. </td>
	</tr>
	<tr>
		<td>[Schrier1970]</td>
		<td>R. W. Schrier, K. M. McDonald, R. Wells, and D. P. Lauler, \"Influence of hematocrit and colloid on whole blood viscosity during volume expansion,\" Am. J. Physiol, vol. 218, p. 77, 1970. </td>
	</tr>
	<tr>
		<td>[Stone1968]</td>
		<td>H. Stone, Thompson HK, and K. Schmidt-Nielsen, Influence of erythrocytes on blood viscosity vol. 214, 1968. </td>
	</tr>
	<tr>
		<td>[Whittaker1933]</td>
		<td>S. R. F. Whittaker and F. R. Winton, \"The apparent viscosity of blood flowing in the isolated hindlimb of the dog, and its variation with corpuscular concentration,\" The Journal of Physiology, vol. 78, pp. 339-369, July 10, 1933 1933.  </td>
	</tr>


</table>
</html>"));
    end References;

    model RedCells2
      extends Physiolibrary.Icons.RedCells;
      Physiolibrary.Blocks.Factors.SplineLag      EPOEffect(
        HalfTime=3*86400*Modelica.Math.log(2),
        data={{0.0,0.0,0},{1.3,1.0,1.0},{4.0,4.0,0}},
        stateName="[EPO]Delay.Effect",
      UsePositiveLog10=true,
      Xscale=1e3) "20 miu/ml = 20e3 iu/m3"
        annotation (Placement(transformation(extent={{-46,-16},{-26,4}})));
    Physiolibrary.Types.BusConnector busConnector
      annotation (Placement(transformation(extent={{-88,58},{-68,78}})));
      Physiolibrary.Blocks.Math.FractionGain
                                H2O(f=0.66)
        annotation (Placement(transformation(extent={{-4,-4},{4,4}},
          origin={54,-84})));
    Hormones.EPO EPO
      annotation (Placement(transformation(extent={{-74,-16},{-54,4}})));
    Physiolibrary.Population.Sources.Growth transfusion(useChangeInput=true)
      annotation (Placement(transformation(extent={{-46,-52},{-26,-32}})));
    Physiolibrary.Population.Sources.Growth erythropoiesis(useChangeInput=
          true)
      annotation (Placement(transformation(extent={{-46,-30},{-26,-10}})));
    Physiolibrary.Population.Sources.Loss hemorrhage(useChangeInput=true)
      annotation (Placement(transformation(extent={{58,-32},{78,-12}})));
    Physiolibrary.Population.Components.Mortality mortality(LifeTime(
          displayUnit="d") = 10368000)
      annotation (Placement(transformation(extent={{58,-52},{78,-32}})));
    Physiolibrary.Population.Components.Population erythrocytes(
      population_start=12e12,
      NominalPopulation=1e12,
      NominalPopulationChange=1e6)
      "red cell count (with density of 5e6 per one uL)"
      annotation (Placement(transformation(extent={{4,-42},{24,-22}})));
      Modelica.Blocks.Math.Gain RBCVol(k=2.4e-3/12e12) "12e12 cells == 2.4 L"
      annotation (Placement(transformation(
          extent={{-4,-4},{4,4}},
          origin={30,-76})));
    Physiolibrary.Types.Constants.PopulationChangeConst RBCBaseSecretionRate(
        k=1.16e6) "13.7 ml/day (12e12 cells == 2.4 L)"
      annotation (Placement(transformation(extent={{-50,8},{-42,16}})));
      Modelica.Blocks.Math.Gain RBCVolToCells(k=12e12/2.4e-3)
      "12e12 cells == 2.4 L" annotation (Placement(transformation(
          extent={{-4,-4},{4,4}},
          origin={-58,-36})));
      Modelica.Blocks.Math.Gain RBCVol2(k=12e12/2.4e-3)
      "12e12 cells == 2.4 L" annotation (Placement(transformation(
          extent={{-4,-4},{4,4}},
          rotation=270,
          origin={68,0})));
    equation

      connect(H2O.y, busConnector.RBCH2O_Vol) annotation (Line(
          points={{58.4,-84},{98,-84},{98,68},{-78,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(EPOEffect.u, EPO.Erythropoetin) annotation (Line(
        points={{-44,-6},{-54,-6}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(busConnector, EPO.busConnector) annotation (Line(
        points={{-78,68},{-78,-12},{-72,-12}},
        color={255,204,51},
        thickness=0.5,
        smooth=Smooth.None));
    connect(EPOEffect.y, erythropoiesis.populationChange) annotation (Line(
        points={{-36,-10},{-36,-16}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(erythropoiesis.port_b, erythrocytes.port) annotation (Line(
        points={{-26,-20},{-6,-20},{-6,-32},{14,-32}},
        color={0,127,127},
        thickness=1,
        smooth=Smooth.None));
    connect(transfusion.port_b, erythrocytes.port) annotation (Line(
        points={{-26,-42},{-6,-42},{-6,-32},{14,-32}},
        color={0,127,127},
        thickness=1,
        smooth=Smooth.None));
    connect(erythrocytes.port, hemorrhage.port_a) annotation (Line(
        points={{14,-32},{34,-32},{34,-22},{58,-22}},
        color={0,127,127},
        thickness=1,
        smooth=Smooth.None));
    connect(erythrocytes.port, mortality.port_a) annotation (Line(
        points={{14,-32},{34,-32},{34,-42},{58.2,-42}},
        color={0,127,127},
        thickness=1,
        smooth=Smooth.None));
    connect(RBCVol.y, H2O.u) annotation (Line(
        points={{34.4,-76},{42,-76},{42,-84},{49.2,-84}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(erythrocytes.population, RBCVol.u) annotation (Line(
        points={{20,-42},{20,-76},{25.2,-76}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(RBCVol.y, busConnector.RBCVol_Vol) annotation (Line(
        points={{34.4,-76},{98,-76},{98,68},{-78,68}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(RBCBaseSecretionRate.y, EPOEffect.yBase) annotation (Line(
        points={{-41,12},{-36,12},{-36,-4}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(transfusion.populationChange, RBCVolToCells.y) annotation (Line(
        points={{-36,-38},{-36,-36},{-53.6,-36}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(busConnector.Transfusion_RBCRate, RBCVolToCells.u) annotation (
        Line(
        points={{-78,68},{-78,-36},{-62.8,-36}},
        color={255,204,51},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(busConnector.Hemorrhage_RBCRate, RBCVol2.u) annotation (Line(
        points={{-78,68},{68,68},{68,4.8}},
        color={255,204,51},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(RBCVol2.y, hemorrhage.populationChange) annotation (Line(
        points={{68,-4.4},{68,-18}},
        color={0,0,127},
        smooth=Smooth.None));
      annotation ( Icon(coordinateSystem(
              preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
            graphics={                  Text(
              extent={{-136,-46},{148,-68}},
              lineColor={0,0,255},
              textString="%name")}),
        Documentation(revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
    end RedCells2;

    model BloodPropertiesBase
        extends Physiolibrary.Icons.Blood;

      Modelica.Blocks.Math.Add BloodVolume
        annotation (Placement(transformation(extent={{10,-70},{18,-62}})));
      Modelica.Blocks.Math.Min CollapsedEffect
        annotation (Placement(transformation(extent={{50,-84},{58,-76}})));
      Modelica.Blocks.Math.Division division
        annotation (Placement(transformation(extent={{38,-78},{46,-70}})));
    Physiolibrary.Types.Constants.OneConst one
      annotation (Placement(transformation(extent={{38,-94},{46,-86}})));
      Modelica.Blocks.Math.Division HtcFract
        annotation (Placement(transformation(extent={{32,-46},{40,-38}})));
    Physiolibrary.Blocks.Interpolation.Curve HtcOnVisc(
      x={0,0.44,0.8},
      y={0.5,1,5},
      slope={0.8,3,30})
      annotation (Placement(transformation(extent={{46,-52},{66,-32}})));
      Modelica.Blocks.Math.Division division1
        annotation (Placement(transformation(extent={{78,-40},{86,-32}})));
    Physiolibrary.Types.Constants.OneConst one1
      annotation (Placement(transformation(extent={{64,-30},{72,-22}})));
    Physiolibrary.Types.Constants.OneConst one2
      annotation (Placement(transformation(extent={{28,-14},{36,-6}})));
      Modelica.Blocks.Math.Feedback PVCrit
        annotation (Placement(transformation(extent={{38,-14},{46,-6}})));
    Physiolibrary.Types.Constants.ConcentrationConst Hb(k=9.3)
      annotation (Placement(transformation(extent={{-20,8},{-28,16}})));
    Physiolibrary.Blocks.Factors.Normalization hematocritEffect(NormalValue=
          0.44)
      annotation (Placement(transformation(extent={{-44,-10},{-24,10}})));
    Physiolibrary.Types.Constants.ConcentrationConst DPG(k=5.4)
      annotation (Placement(transformation(extent={{26,90},{18,98}})));
    Physiolibrary.Types.Constants.FractionConst FMetHb(k=0.005)
      annotation (Placement(transformation(extent={{26,82},{18,90}})));
    Physiolibrary.Types.Constants.FractionConst FHbF(k=0.005)
      annotation (Placement(transformation(extent={{26,74},{18,82}})));
    Physiolibrary.Types.BusConnector busConnector
      annotation (Placement(transformation(extent={{-104,58},{-84,78}})));
      Modelica.Blocks.Math.Division division3(y(displayUnit="mmol/l"))
        annotation (Placement(transformation(extent={{-4,-4},{4,4}},
            origin={-4,2})));
      Modelica.Blocks.Math.Feedback feedback
        annotation (Placement(transformation(extent={{-20,32},{-40,52}})));
      Modelica.Blocks.Math.Add BloodVolume1
        annotation (Placement(transformation(extent={{-46,24},{-38,32}})));
      Modelica.Blocks.Math.Product product
        annotation (Placement(transformation(extent={{66,2},{74,10}})));
      Modelica.Blocks.Math.Sum V0(nin=5)
        annotation (Placement(transformation(extent={{-30,-90},{-22,-82}})));
      Modelica.Blocks.Math.Sum VeinsVol(nin=5) "volume of deoxygenated blood"
        annotation (Placement(transformation(extent={{-26,-54},{-18,-46}})));
      Modelica.Blocks.Math.Sum ArtysVol(nin=4) "volume of oxygenated blood"
        annotation (Placement(transformation(extent={{-26,-34},{-18,-26}})));
    equation
      connect(busConnector.PlasmaVol_Vol, BloodVolume.u2)
                                                  annotation (Line(
          points={{-94,68},{-94,-68.4},{9.2,-68.4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.RBCVol_Vol, BloodVolume.u1)
                                                annotation (Line(
          points={{-94,68},{-94,-63.6},{9.2,-63.6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(division.y, CollapsedEffect.u1)
                                  annotation (Line(
          points={{46.4,-74},{47.8,-74},{47.8,-77.6},{49.2,-77.6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(BloodVolume.y, division.u1)
                                  annotation (Line(
          points={{18.4,-66},{28,-66},{28,-71.6},{37.2,-71.6}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(one.y, CollapsedEffect.u2) annotation (Line(
        points={{47,-90},{48,-90},{48,-82.4},{49.2,-82.4}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(CollapsedEffect.y, busConnector.BloodVol_CollapsedEffect)
                                                            annotation (Line(
          points={{58.4,-80},{90,-80},{90,68},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(HtcFract.u2, BloodVolume.y)
                                  annotation (Line(
          points={{31.2,-44.4},{26,-44.4},{26,-66},{18.4,-66}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(HtcFract.u1,busConnector. RBCVol_Vol) annotation (Line(
          points={{31.2,-39.6},{-94,-39.6},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(HtcFract.y,HtcOnVisc. u) annotation (Line(
          points={{40.4,-42},{46,-42}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(one1.y, division1.u1) annotation (Line(
        points={{73,-26},{74,-26},{74,-33.6},{77.2,-33.6}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(HtcOnVisc.val,division1. u2) annotation (Line(
          points={{66,-42},{75.5,-42},{75.5,-38.4},{77.2,-38.4}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(division1.y,busConnector. Viscosity_ConductanceEffect) annotation (Line(
          points={{86.4,-36},{90,-36},{90,68},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(HtcFract.y,busConnector. BloodVol_Hct) annotation (Line(
          points={{40.4,-42},{42,-42},{42,-20},{-94,-20},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None));
    connect(one2.y, PVCrit.u1) annotation (Line(
        points={{37,-10},{38.8,-10}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(HtcFract.y,PVCrit. u2) annotation (Line(
          points={{40.4,-42},{42,-42},{42,-13.2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(PVCrit.y,busConnector. BloodVol_PVCrit) annotation (Line(
          points={{45.6,-10},{90,-10},{90,68},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(Hb.y, hematocritEffect.yBase) annotation (Line(
        points={{-29,12},{-34,12},{-34,2}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(hematocritEffect.y,busConnector. ctHb) annotation (Line(
          points={{-34,-4},{-34,-10},{-94,-10},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(busConnector.cDPG, DPG.y) annotation (Line(
        points={{-94,68},{-4,68},{-4,94},{17,94}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(busConnector.FMetHb, FMetHb.y) annotation (Line(
        points={{-94,68},{-4,68},{-4,86},{17,86}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(busConnector.FHbF, FHbF.y) annotation (Line(
        points={{-94,68},{-4,68},{-4,78},{17,78}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None), Text(
        string="%first",
        index=-1,
        extent={{-6,3},{-6,3}}));
    connect(Hb.y, division3.u1) annotation (Line(
        points={{-29,12},{-34,12},{-34,4},{-8.8,4},{-8.8,4.4}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(HtcFract.y, division3.u2) annotation (Line(
          points={{40.4,-42},{42,-42},{42,-20},{-18,-20},{-18,-0.4},{-8.8,
            -0.4}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(division3.y, busConnector.ctHb_ery) annotation (Line(
          points={{0.4,2},{20,2},{20,68},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(BloodVolume.y, feedback.u1) annotation (Line(
          points={{18.4,-66},{26,-66},{26,42},{-22,42}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.ArtysVol, BloodVolume1.u1) annotation (Line(
          points={{-94,68},{-94,30},{-46.8,30},{-46.8,30.4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(busConnector.VeinsVol, BloodVolume1.u2) annotation (Line(
          points={{-94,68},{-94,26},{-46.8,26},{-46.8,25.6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,3},{-6,3}}));
      connect(BloodVolume1.y, feedback.u2) annotation (Line(
          points={{-37.6,28},{-30,28},{-30,34}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(PVCrit.y, product.u2) annotation (Line(
          points={{45.6,-10},{54,-10},{54,3.6},{65.2,3.6}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(busConnector.PortalVein_BloodFlow, product.u1) annotation (Line(
          points={{-94,68},{54,68},{54,8.4},{65.2,8.4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(product.y, busConnector.PortalVein_PlasmaFlow) annotation (Line(
          points={{74.4,6},{90,6},{90,68},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None));

      connect(busConnector.PulmonaryCirculation_V0,V0. u[1])
        annotation (Line(
          points={{-94,68},{-94,-82},{-32,-82},{-32,-86.64},{-30.8,-86.64}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,6},{-6,6}}));
      connect(busConnector.Heart_V0,V0. u[2]) annotation (
          Line(
          points={{-94,68},{-94,-86.32},{-30.8,-86.32}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,2},{-6,2}}));
      connect(busConnector.SystemicArtys_V0,V0. u[3])
        annotation (Line(
          points={{-94,68},{-94,-90},{-32,-90},{-32,-86},{-30.8,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-2},{-6,-2}}));
      connect(busConnector.PortalVein_V0,V0. u[4]) annotation (Line(
          points={{-94,68},{-94,-94},{-32,-94},{-32,-86},{-30.8,-85.68}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-6},{-6,-6}}));
      connect(busConnector.SystemicVeins_V0,V0. u[5]) annotation (Line(
          points={{-94,68},{-94,-98},{-32,-98},{-32,-86},{-30.8,-85.36}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-10},{-6,-10}}));
      connect(VeinsVol.y, busConnector.VeinsVol) annotation (Line(
          points={{-17.6,-50},{2,-50},{2,-42},{-94,-42},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(busConnector.PulmonaryCirculation_DeoxygenatedBloodVolume,VeinsVol. u[1])
        annotation (Line(
          points={{-94,68},{-94,-46},{-28,-46},{-28,-50.64},{-26.8,-50.64}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,6},{-6,6}}));
      connect(busConnector.Heart_DeoxygenatedBloodVolume,VeinsVol. u[2]) annotation (
          Line(
          points={{-94,68},{-94,-50.32},{-26.8,-50.32}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,2},{-6,2}}));
      connect(busConnector.SplanchnicCirculation_DeoxygenatedBloodVolume,VeinsVol. u[3])
        annotation (Line(
          points={{-94,68},{-94,-54},{-28,-54},{-28,-50},{-26.8,-50}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-2},{-6,-2}}));
      connect(busConnector.SystemicVeins_DeoxygenatedBloodVolume,VeinsVol. u[4])
        annotation (Line(
          points={{-94,68},{-94,-58},{-28,-58},{-28,-49.68},{-26.8,-49.68}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-6},{-6,-6}}));
      connect(ArtysVol.y, busConnector.ArtysVol) annotation (Line(
          points={{-17.6,-30},{2,-30},{2,-22},{-94,-22},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(busConnector.PulmonaryCirculation_OxygenatedBloodVolume,ArtysVol. u[1])
        annotation (Line(
          points={{-94,68},{-94,-26},{-28,-26},{-28,-30.6},{-26.8,-30.6}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,6},{-6,6}}));
      connect(busConnector.Heart_OxygenatedBloodVolume,ArtysVol. u[2]) annotation (
          Line(
          points={{-94,68},{-94,-30.2},{-26.8,-30.2}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,2},{-6,2}}));
      connect(busConnector.SystemicArtys_OxygenatedBloodVolume,ArtysVol. u[3])
        annotation (Line(
          points={{-94,68},{-94,-34},{-28,-34},{-28,-29.8},{-26.8,-29.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-2},{-6,-2}}));
      connect(feedback.y, busConnector.BloodVolume_change) annotation (Line(
          points={{-39,42},{-66,42},{-66,68},{-94,68}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(BloodVolume.y, busConnector.BloodVolume) annotation (Line(
        points={{18.4,-66},{90,-66},{90,68},{-94,68}},
        color={0,0,127},
        smooth=Smooth.None), Text(
        string="%second",
        index=1,
        extent={{6,3},{6,3}}));
    connect(HtcFract.y, hematocritEffect.u) annotation (Line(
        points={{40.4,-42},{42,-42},{42,-20},{-52,-20},{-52,0},{-42,0}},
        color={0,0,127},
        smooth=Smooth.None));
      connect(busConnector.LegArtys_OxygenatedBloodVolume, ArtysVol.u[4])
        annotation (Line(
          points={{-94,68},{-94,-38},{-26.8,-38},{-26.8,-29.4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-6},{-6,-6}}));
      connect(busConnector.LegVeins_DeoxygenatedBloodVolume, VeinsVol.u[5])
        annotation (Line(
          points={{-94,68},{-94,-62},{-28,-62},{-28,-49.36},{-26.8,-49.36}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None), Text(
          string="%first",
          index=-1,
          extent={{-6,-10},{-6,-10}}));
    connect(V0.y, division.u2) annotation (Line(
        points={{-21.6,-86},{8,-86},{8,-76.4},{37.2,-76.4}},
        color={0,0,127},
        smooth=Smooth.None));
      annotation ( Icon(coordinateSystem(
              preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
            graphics={                          Text(
              extent={{-142,-108},{142,-130}},
              lineColor={0,0,255},
              textString="%name")}),
        Documentation(info="<html>
<p>BloodVolume .. whole blood volume</p>
<p>BloodVol_Hct .. haematocrit</p>
<p>BloodVol_PVCrit .. 1-BloodVol_Hct, plamacrit</p>
<p>ctHb_ery .. concentration of heme group in erythrocytes = 4 * MCHC (mean corpuscular hemoglobin concentration)</p>
<p>ctHb .. concentration of heme group in whole blood</p>
<p>FHbF .. featal Hb fraction from all Hb</p>
<p>FMetHb .. metha-Hb fraction from all Hb</p>
<p>cDPG .. concentration of 2,3-diphosphoglycerate in erythrocytes</p>
<p>Viscosity_ConductanceEffect .. multiply coeficient of blood resistance through vesseles</p>
<p>BloodVol_CollapsedEffect .. effect of small blood volume on systemic veins collasping</p>
<p>Vesseles_V0 .. volume of no-pressure generating blood in all vessels.</p>
<p>ArtysVol .. volume of all oxigenated blood</p>
<p>VeinsVol .. volume of all deoxigenated blood</p>
</html>",
        revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"));
    end BloodPropertiesBase;

  end Blood;

  model CardioVascularSystem
    extends Physiolibrary.Icons.CardioVascular;
  //  extends Physiomodel.Library.Utilities.DynamicState(stateName="BloodVol.Vol", initType=Library.Utilities.Init.NoInit);

  Heart.Heart heart
    annotation (Placement(transformation(extent={{0,-6},{26,20}})));
  Circulation.PulmonaryCirculation pulmonaryCirculation
    annotation (Placement(transformation(extent={{2,50},{30,78}})));
  Circulation.SystemicCirculationFullDynamic systemicCirculation
    annotation (Placement(transformation(extent={{-2,-68},{32,-34}})));
  Physiolibrary.Types.BusConnector busConnector
    "signals of organ bood flow resistence" annotation (Placement(
        transformation(extent={{-38,-8},{-16,14}}), iconTransformation(extent=
           {{-100,60},{-60,100}})));
  Blood.RedCells2 redCells(RBCBaseSecretionRate(k(displayUnit="m3/s")))
    annotation (Placement(transformation(extent={{-34,26},{-54,46}})));
  Blood.BloodPropertiesBase bloodProperties
    annotation (Placement(transformation(extent={{-36,-34},{-56,-14}})));

  /*initial equation
  if STEADY then
     bloodProperties.feedback.y = 0;
  end if;
*/

  equation
    connect(busConnector, pulmonaryCirculation.busConnector) annotation (
        Line(
        points={{-27,3},{-26,3},{-26,71},{2,71}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None));
    connect(busConnector, systemicCirculation.busConnector) annotation (
        Line(
        points={{-27,3},{-26,3},{-26,-44.2},{-2.34,-44.2}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None));
    connect(busConnector, redCells.busConnector)    annotation (Line(
        points={{-27,3},{-26,3},{-26,42.8},{-36.2,42.8}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None));
    connect(busConnector, bloodProperties.busConnector) annotation (Line(
        points={{-27,3},{-26,3},{-26,-17.2},{-36.6,-17.2}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None));
    connect(busConnector, heart.busConnector) annotation (Line(
        points={{-27,3},{-25.5,3},{-25.5,3.1},{0,3.1}},
        color={0,0,255},
        thickness=0.5,
        smooth=Smooth.None));
    connect(heart.fromLeftVentricle, systemicCirculation.q_in) annotation (
        Line(
        points={{16.12,3.36},{16.12,18},{32,18},{32,-51}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(systemicCirculation.q_out, heart.rightAtrium) annotation (Line(
        points={{-2,-51},{-4,-51},{-4,12.2},{5.72,12.2}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pulmonaryCirculation.q_in, heart.fromRightVentricle) annotation (
        Line(
        points={{1.72,64},{-4,64},{-4,18},{8.06,18},{8.06,3.36}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));
    connect(pulmonaryCirculation.q_out, heart.leftAtrium) annotation (Line(
        points={{30,64},{36,64},{36,12.46},{18.72,12.46}},
        color={0,0,0},
        thickness=1,
        smooth=Smooth.None));

  //  stateValue = bloodProperties.BloodVolume1.y;

    annotation ( Documentation(info="<html>
<p><h4><font color=\"#008000\">Cardiovascular system</font></h4></p>
<p><font style=\"color: #008000; \">Connect heart with pulmonary and systemic part. This connection contains pressures and blood flows before and after heart.</font></p>
<p><font style=\"color: #008000; \">Output signal variables about blood volume between lungs capilaries and systemic tissue capilaries are used in gass transport submodels like O2 or CO2.</font></p>
<p><font style=\"color: #008000; \">Output signal Vesseles_V0 is used for systemic veins collapsing in massive blood lost.</font></p>
<p><font style=\"color: #008000; \">The blood properties convert known variables values to another meanings (haematocrit, viscosity, ..).</font></p>
<p><font style=\"color: #008000; \">Red cells contains volume, loss and gains all red blood cells.</font></p>
</html>",
        revisions="<html>

<table>
<tr>
<td>Author:</td>
<td>Marek Matejak</td>
</tr>
<tr>
<td>License:</td>
<td><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </td>
</tr>
<tr>
<td>By:</td>
<td>Charles University, Prague</td>
</tr>
<tr>
<td>Date of:</td>
<td>2009</td>
</tr>
<tr>
<td>References:</td>
<td>Tom Coleman: QHP 2008 beta 3, University of Mississippi Medical Center</td>
</tr>
</table>
<br/><p>Copyright &copy; 2014 Marek Matejak, Charles University in Prague.</p><br/>

</html>"),
      Icon(coordinateSystem(preserveAspectRatio=true,  extent={{-100,-100},{
              100,100}}), graphics={Text(
            extent={{-116,-96},{126,-130}},
            lineColor={0,0,255},
            textString="%name")}));
  end CardioVascularSystem;

  package IO_Bus
    extends Physiolibrary.Types.IO_Bus;

    redeclare model extends Variables

    T.Volume ArtysVol(varName="ArtysVol.Vol")
      "Volume of oxygenated blood in body."
    annotation (Placement(transformation(extent={{-36,10},{-30,16}})));
    T.Fraction BloodVol_Hct(varName="BloodVol.Hct")
      "Heamatocrit = red cells / blood."
    annotation (Placement(transformation(extent={{-36,20},{-30,26}})));
    T.Fraction BloodVol_PVCrit(varName="BloodVol.PVCrit")
      "Plasma volume fraction = plasma / blood."
    annotation (Placement(transformation(extent={{-36,30},{-30,36}})));
    T.VolumeFlowRate Bone_BloodFlow(varName="Bone-Flow.BloodFlow")
      "Bone blood flow."
    annotation (Placement(transformation(extent={{-36,40},{-30,46}})));
    T.VolumeFlowRate bone_BloodFlow(varName="Bone-Flow.BloodFlow")
      "Bone blood flow."
    annotation (Placement(transformation(extent={{-36,50},{-30,56}})));
    T.VolumeFlowRate Brain_BloodFlow(varName="Brain-Flow.BloodFlow")
      "Brain blood flow."
    annotation (Placement(transformation(extent={{-36,60},{-30,66}})));
    T.VolumeFlowRate brain_BloodFlow(varName="Brain-Flow.BloodFlow")
      "Brain blood flow."
    annotation (Placement(transformation(extent={{-36,70},{-30,76}})));
    T.VolumeFlowRate CardiacOutput(varName="CardiacOutput.Flow")
      "Cardiac output."
    annotation (Placement(transformation(extent={{-36,80},{-30,86}})));
    T.Pressure CarotidSinusArteryPressure(varName="CarotidSinus.Pressure")
      "Mean blood pressure in carotid sinus artery."
    annotation (Placement(transformation(extent={{-36,90},{-30,96}})));
    T.VolumeFlowRate Fat_BloodFlow(varName="Fat-Flow.BloodFlow")
      "Fat blood flow."
    annotation (Placement(transformation(extent={{-36,100},{-30,106}})));
    T.VolumeFlowRate fat_BloodFlow(varName="Fat-Flow.BloodFlow")
      "Fat blood flow."
    annotation (Placement(transformation(extent={{-36,110},{-30,116}})));
    T.VolumeFlowRate GITract_BloodFlow(varName="GITract-Flow.BloodFlow")
      "GITract blood flow."
    annotation (Placement(transformation(extent={{-36,120},{-30,126}})));
    T.Pressure GlomerulusBloodPressure(varName="GlomerulusFiltrate.Pressure")
      "Blood pressure in glomerulus capilaries."
    annotation (Placement(transformation(extent={{-36,130},{-30,136}})));
    T.VolumeFlowRate HepaticArty_BloodFlow(varName="HepaticArty.Flow")
      "Hepatic artery blood flow."
    annotation (Placement(transformation(extent={{-36,140},{-30,146}})));
    T.VolumeFlowRate Kidney_BloodFlow(varName="Kidney-Flow.BloodFlow")
      "Kidney blood flow."
    annotation (Placement(transformation(extent={{-36,150},{-30,156}})));
    T.VolumeFlowRate kidney_BloodFlow(varName="Kidney-Flow.BloodFlow")
      "Kidney blood flow."
    annotation (Placement(transformation(extent={{-36,160},{-30,166}})));
    T.VolumeFlowRate KidneyPlasmaFlow(varName="Kidney-Flow.PlasmaFlow")
      "Kidney plasma flow."
    annotation (Placement(transformation(extent={{-36,170},{-30,176}})));
    //Variable LeftAtrium_TMP(varName="LeftAtrium.TMP")
    //    "Left atrium pressure gradient between inside and pericardium."
    //annotation (Placement(transformation(extent={{-36,180},{-30,186}})));
    T.VolumeFlowRate LeftHeart_BloodFlow(varName="LeftHeart-Flow.BloodFlow")
      "LeftHeart blood flow."
    annotation (Placement(transformation(extent={{-36,200},{-30,206}})));
    T.VolumeFlowRate leftHeart_BloodFlow(varName="LeftHeart-Flow.BloodFlow")
      "LeftHeart blood flow."
    annotation (Placement(transformation(extent={{-36,210},{-30,216}})));
    T.VolumeFlowRate AlveolarVentilated_BloodFlow(varName="LungBloodFlow.AlveolarVentilated")
      "Blood flow through ventilated alveoli."
    annotation (Placement(transformation(extent={{-36,220},{-30,226}})));
    T.VolumeFlowRate OtherTissue_BloodFlow(varName="OtherTissue-Flow.BloodFlow")
      "OtherTissue blood flow."
    annotation (Placement(transformation(extent={{-36,230},{-30,236}})));
    T.VolumeFlowRate otherTissue_BloodFlow(varName="OtherTissue-Flow.BloodFlow")
      "OtherTissue blood flow."
    annotation (Placement(transformation(extent={{-36,240},{-30,246}})));
    T.VolumeFlowRate PortalVein_BloodFlow(varName="PortalVein.BloodFlow")
      "Portal vein blood flow."
    annotation (Placement(transformation(extent={{-36,250},{-30,256}})));
    T.VolumeFlowRate PortalVein_PlasmaFlow(varName="PortalVein.PlasmaFlow")
      "Portal vein plasma flow."
    annotation (Placement(transformation(extent={{-36,260},{-30,266}})));
    T.Pressure PulmCapys_Pressure(varName="PulmCapys.Pressure")
      "Blood pressure in pulmonary capylaries."
    annotation (Placement(transformation(extent={{-36,270},{-30,276}})));
    T.Volume RBCH2O_Vol(varName="RBCH2O.Vol")
      "Intracellular water in erythrocytes."
    annotation (Placement(transformation(extent={{-36,280},{-30,286}})));
    T.VolumeFlowRate RespiratoryMuscle_BloodFlow(varName="RespiratoryMuscle-Flow.BloodFlow")
      "RespiratoryMuscle blood flow."
    annotation (Placement(transformation(extent={{-36,290},{-30,296}})));
    T.VolumeFlowRate respiratoryMuscle_BloodFlow(varName="RespiratoryMuscle-Flow.BloodFlow")
      "RespiratoryMuscle blood flow."
    annotation (Placement(transformation(extent={{-36,300},{-30,306}})));
    T.Pressure RightAtrium_Pressure(varName="RightAtrium.Pressure")
      "Blood pressure in right atrium."
    annotation (Placement(transformation(extent={{-36,310},{-30,316}})));
    //Variable RightAtrium_TMP(varName="RightAtrium.TMP")
    //    "Right atrium pressure gradient between inside and pericardium."
    //annotation (Placement(transformation(extent={{-36,320},{-30,326}})));
    T.VolumeFlowRate RightHeart_BloodFlow(varName="RightHeart-Flow.BloodFlow")
      "RightHeart blood flow."
    annotation (Placement(transformation(extent={{-36,340},{-30,346}})));
    T.VolumeFlowRate rightHeart_BloodFlow(varName="RightHeart-Flow.BloodFlow")
      "RightHeart blood flow."
    annotation (Placement(transformation(extent={{-36,350},{-30,356}})));
    T.VolumeFlowRate SkeletalMuscle_BloodFlow(varName="SkeletalMuscle-Flow.BloodFlow")
      "SkeletalMuscle blood flow."
    annotation (Placement(transformation(extent={{-36,360},{-30,366}})));
    T.VolumeFlowRate skeletalMuscle_BloodFlow(varName="SkeletalMuscle-Flow.BloodFlow")
      "SkeletalMuscle blood flow."
    annotation (Placement(transformation(extent={{-36,370},{-30,376}})));
    T.VolumeFlowRate Skin_BloodFlow(varName="Skin-Flow.BloodFlow")
      "Skin blood flow."
    annotation (Placement(transformation(extent={{-36,380},{-30,386}})));
    T.VolumeFlowRate skin_BloodFlow(varName="Skin-Flow.BloodFlow")
      "Skin blood flow."
    annotation (Placement(transformation(extent={{-36,390},{-30,396}})));
    T.Pressure SplanchnicVeins_Pressure(varName="SplanchnicVeins.Pressure")
      "Splanchnic (=portal vein) veins blood pressure."
    annotation (Placement(transformation(extent={{-36,400},{-30,406}})));
    T.Volume SplanchnicCirculation_DeoxygenatedBloodVolume(                          varName="SplanchnicVeins.Vol")
      "Splanchnic (=portal vein and venules) veins blood volume."
    annotation (Placement(transformation(extent={{-36,410},{-30,416}})));
    T.Pressure SystemicArtys_Pressure(varName="SystemicArtys.Pressure")
      "Mean systemic arteries blood pressure."
    annotation (Placement(transformation(extent={{-36,420},{-30,426}})));
    T.VolumeFlowRate VasaRecta_Outflow(varName="VasaRecta.Outflow")
      "Kidney vasa recta blood outflow to kidney veins."
    annotation (Placement(transformation(extent={{-36,430},{-30,436}})));
    T.Volume VeinsVol(varName="VeinsVol.Vol")
      "Volume of deoxygenated blood in body."
    annotation (Placement(transformation(extent={{-36,440},{-30,446}})));
    T.Concentration ctHb(varName="ctHb") "Hemoglobin concentration in blood."
    annotation (Placement(transformation(extent={{-36,450},{-30,456}})));
    T.Concentration ctHb_ery(varName="ctHb_ery")
      "Hemoglobin concentration in erythrocytes."
    annotation (Placement(transformation(extent={{-36,460},{-30,466}})));
    T.Pressure NephronIFP_Pressure(varName=
            "NephronIFP.Pressure") "Renal interstitial pressure."
    annotation (Placement(transformation(extent={{-34,-10},{-28,-4}})));
    T.VolumeFlowRate Liver_BloodFlow(varName=
            "Liver-O2.BloodFlow") "Liver blood flow."
    annotation (Placement(transformation(extent={{-30,-26},{-24,-20}})));
    T.Concentration cDPG(varName="cDPG") "2,3-DPG concentration"
    annotation (Placement(transformation(extent={{18,-84},{24,-78}})));
    T.Fraction FMetHb(varName="FMetHb")
      "Fraction of methemoglobin with Fe^3+ instead of Fe^2+"
    annotation (Placement(transformation(extent={{18,-74},{24,-68}})));
    T.Fraction FHbF(varName="FHbF") "Fraction of foetal hemoglobin"
    annotation (Placement(transformation(extent={{18,-64},{24,-58}})));
    T.Pressure SystemicVeins_Pressure(varName="SystemicVeins.Pressure")
      "Systemic veins pressure."
    annotation (Placement(transformation(extent={{-36,-40},{-30,-34}})));
    T.HydraulicConductance
               skin_conductanceWithoutTermoregulationEffect(varName=
            "skin_conductanceWithoutTermoregulationEffect")
      "Skin conductance without termoregulation effect."
    annotation (Placement(transformation(extent={{-34,-54},{-28,-48}})));
    T.Concentration ANPPool_ANP(varName="ANPPool.[ANP]", storeUnit="pmol/l",
      y(nominal=1e-8)) "Atrial natriuretic peptide concentration."
        annotation (Placement(transformation(extent={{-82,-78},{-76,-72}})));
    T.Volume BloodVol_Vol(varName="BloodVol.Vol") "Blood volume"
    annotation (Placement(transformation(extent={{-84,4},{-78,10}})));
    T.Fraction AtrialLowPressureReceptors_NA(varName="LowPressureReceptors.NA")
      "Atrial Low Pressure Receptors neural activity."
        annotation (Placement(transformation(extent={{-84,-90},{-78,-84}})));
    equation

    connect(ArtysVol.y, busConnector.ArtysVol) annotation (Line(
     points={{-29.7,13},{90,13},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(BloodVol_Hct.y, busConnector.BloodVol_Hct) annotation (Line(
     points={{-29.7,23},{90,23},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(BloodVol_PVCrit.y, busConnector.BloodVol_PVCrit) annotation (Line(
     points={{-29.7,33},{90,33},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(Bone_BloodFlow.y, busConnector.Bone_BloodFlow) annotation (Line(
     points={{-29.7,43},{90,43},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(bone_BloodFlow.y, busConnector.bone_BloodFlow) annotation (Line(
     points={{-29.7,53},{90,53},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(Brain_BloodFlow.y, busConnector.Brain_BloodFlow) annotation (Line(
     points={{-29.7,63},{90,63},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(brain_BloodFlow.y, busConnector.brain_BloodFlow) annotation (Line(
     points={{-29.7,73},{90,73},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(CardiacOutput.y, busConnector.CardiacOutput) annotation (Line(
     points={{-29.7,83},{90,83},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(CarotidSinusArteryPressure.y, busConnector.CarotidSinusArteryPressure) annotation (Line(
     points={{-29.7,93},{90,93},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(Fat_BloodFlow.y, busConnector.Fat_BloodFlow) annotation (Line(
     points={{-29.7,103},{90,103},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(fat_BloodFlow.y, busConnector.fat_BloodFlow) annotation (Line(
     points={{-29.7,113},{90,113},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(GITract_BloodFlow.y, busConnector.GITract_BloodFlow) annotation (Line(
     points={{-29.7,123},{90,123},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(GlomerulusBloodPressure.y, busConnector.GlomerulusBloodPressure) annotation (Line(
     points={{-29.7,133},{90,133},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(HepaticArty_BloodFlow.y, busConnector.HepaticArty_BloodFlow) annotation (Line(
     points={{-29.7,143},{90,143},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(Kidney_BloodFlow.y, busConnector.Kidney_BloodFlow) annotation (Line(
     points={{-29.7,153},{90,153},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(kidney_BloodFlow.y, busConnector.kidney_BloodFlow) annotation (Line(
     points={{-29.7,163},{90,163},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(KidneyPlasmaFlow.y, busConnector.KidneyPlasmaFlow) annotation (Line(
     points={{-29.7,173},{90,173},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(LeftHeart_BloodFlow.y, busConnector.LeftHeart_BloodFlow) annotation (Line(
     points={{-29.7,203},{90,203},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(leftHeart_BloodFlow.y, busConnector.leftHeart_BloodFlow) annotation (Line(
     points={{-29.7,213},{90,213},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(AlveolarVentilated_BloodFlow.y, busConnector.AlveolarVentilated_BloodFlow) annotation (Line(
     points={{-29.7,223},{90,223},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(OtherTissue_BloodFlow.y, busConnector.OtherTissue_BloodFlow) annotation (Line(
     points={{-29.7,233},{90,233},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(otherTissue_BloodFlow.y, busConnector.otherTissue_BloodFlow) annotation (Line(
     points={{-29.7,243},{90,243},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(PortalVein_BloodFlow.y, busConnector.PortalVein_BloodFlow) annotation (Line(
     points={{-29.7,253},{90,253},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(PortalVein_PlasmaFlow.y, busConnector.PortalVein_PlasmaFlow) annotation (Line(
     points={{-29.7,263},{90,263},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(PulmCapys_Pressure.y, busConnector.PulmCapys_Pressure) annotation (Line(
     points={{-29.7,273},{90,273},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(RBCH2O_Vol.y, busConnector.RBCH2O_Vol) annotation (Line(
     points={{-29.7,283},{90,283},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(RespiratoryMuscle_BloodFlow.y, busConnector.RespiratoryMuscle_BloodFlow) annotation (Line(
     points={{-29.7,293},{90,293},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(respiratoryMuscle_BloodFlow.y, busConnector.respiratoryMuscle_BloodFlow) annotation (Line(
     points={{-29.7,303},{90,303},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(RightAtrium_Pressure.y, busConnector.RightAtrium_Pressure) annotation (Line(
     points={{-29.7,313},{90,313},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(RightHeart_BloodFlow.y, busConnector.RightHeart_BloodFlow) annotation (Line(
     points={{-29.7,343},{90,343},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(rightHeart_BloodFlow.y, busConnector.rightHeart_BloodFlow) annotation (Line(
     points={{-29.7,353},{90,353},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(SkeletalMuscle_BloodFlow.y, busConnector.SkeletalMuscle_BloodFlow) annotation (Line(
     points={{-29.7,363},{90,363},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(skeletalMuscle_BloodFlow.y, busConnector.skeletalMuscle_BloodFlow) annotation (Line(
     points={{-29.7,373},{90,373},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(Skin_BloodFlow.y, busConnector.Skin_BloodFlow) annotation (Line(
     points={{-29.7,383},{90,383},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(skin_BloodFlow.y, busConnector.skin_BloodFlow) annotation (Line(
     points={{-29.7,393},{90,393},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(SplanchnicVeins_Pressure.y, busConnector.SplanchnicVeins_Pressure) annotation (Line(
     points={{-29.7,403},{90,403},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(SplanchnicCirculation_DeoxygenatedBloodVolume.y, busConnector.SplanchnicCirculation_DeoxygenatedBloodVolume) annotation (Line(
     points={{-29.7,413},{90,413},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(SystemicArtys_Pressure.y, busConnector.SystemicArtys_Pressure) annotation (Line(
     points={{-29.7,423},{90,423},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(VasaRecta_Outflow.y, busConnector.VasaRecta_Outflow) annotation (Line(
     points={{-29.7,433},{90,433},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(VeinsVol.y, busConnector.VeinsVol) annotation (Line(
     points={{-29.7,443},{90,443},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(ctHb.y, busConnector.ctHb) annotation (Line(
     points={{-29.7,453},{90,453},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(ctHb_ery.y, busConnector.ctHb_ery) annotation (Line(
     points={{-29.7,463},{90,463},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(NephronIFP_Pressure.y, busConnector.NephronIFP_Pressure)
        annotation (Line(
          points={{-27.7,-7},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));

      connect(Liver_BloodFlow.y, busConnector.Liver_BloodFlow) annotation (Line(
          points={{-23.7,-23},{90,-23},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(FHbF.y,busConnector. FHbF) annotation (Line(
     points={{24.3,-61},{78,-61},{78,-2},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(FMetHb.y,busConnector. FMetHb) annotation (Line(
     points={{24.3,-71},{90,-71},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
    connect(cDPG.y,busConnector. cDPG) annotation (Line(
     points={{24.3,-81},{90,-81},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(SystemicVeins_Pressure.y, busConnector.SystemicVeins_Pressure)
        annotation (Line(
          points={{-29.7,-37},{90,-37},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(skin_conductanceWithoutTermoregulationEffect.y, busConnector.skin_conductanceWithoutTermoregulationEffect)
        annotation (Line(
          points={{-27.7,-51},{90,-51},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(BloodVol_Vol.y, busConnector.BloodVolume) annotation (Line(
          points={{-77.7,7},{0.15,7},{0.15,-2},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(ANPPool_ANP.y, busConnector.ANP) annotation (Line(
          points={{-75.7,-75},{90,-75},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      connect(AtrialLowPressureReceptors_NA.y, busConnector.AtrialLowPressureReceptors_NA)
        annotation (Line(
          points={{-77.7,-87},{90,-87},{90,-2}},
          color={0,0,127},
          smooth=Smooth.None), Text(
          string="%second",
          index=1,
          extent={{6,3},{6,3}}));
      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}},
              lineColor={0,0,0},
              textString="const"), graphics={Text(
              extent={{6,126},{100,90}},
              lineColor={0,0,0},
              textString="vars"), Text(
              extent={{-126,-98},{116,-132}},
              lineColor={0,0,255},
              textString="%name")}));
    end Variables;

    model CardioVascular_test
      import Physiomodel;
    Physiomodel.CardioVascular.CardioVascularSystem cardioVascularSystem
      annotation (Placement(transformation(extent={{40,72},{60,94}})));
      Physiomodel.Metabolism.IO_Bus.InputFromFile
                                              nutrientsAndMetabolism
        annotation (Placement(transformation(extent={{-88,60},{-68,80}})));
      Physiomodel.Electrolytes.IO_Bus.InputFromFile electrolytes
        annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
      Physiomodel.Hormones.IO_Bus.InputFromFile hormones
        annotation (Placement(transformation(extent={{40,6},{60,26}})));
      Physiomodel.Nerves.IO_Bus.InputFromFile nerves
        annotation (Placement(transformation(extent={{74,38},{94,58}})));
      Physiomodel.Setup.IO_Bus.InputFromFile     setup
        annotation (Placement(transformation(extent={{-14,-96},{6,-76}})));
      Physiomodel.Water.IO_Bus.InputFromFile water
        annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
      Physiomodel.Proteins.IO_Bus.InputFromFile proteins
        annotation (Placement(transformation(extent={{-48,-30},{-28,-10}})));
      Physiomodel.Status.IO_Bus.InputFromFile status
        annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
      Physiomodel.Gases.IO_Bus.InputFromFile gases
        annotation (Placement(transformation(extent={{-76,-64},{-56,-44}})));
      Physiomodel.Heat.IO_Bus.InputFromFile heat
        annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
      Physiomodel.CardioVascular.IO_Bus.OutputComparison
                                         cVS_dif
        annotation (Placement(transformation(extent={{76,72},{96,92}})));
      Physiomodel.CardioVascular.IO_Bus.OutputToFile
                                                cVS_varsToFile
        annotation (Placement(transformation(extent={{14,60},{34,80}})));
    equation
      connect(setup.busConnector,hormones. busConnector) annotation (Line(
          points={{-4,-86},{-4,16},{50,16}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,proteins. busConnector) annotation (Line(
          points={{-4,-86},{-4,-20},{-38,-20}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                    annotation (Line(
          points={{-4,-86},{-4,91.8},{42,91.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
        annotation (Line(
          points={{-4,-86},{-4,70},{-78,70}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,water. busConnector) annotation (Line(
          points={{-4,-86},{-4,4},{-76,4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,nerves. busConnector) annotation (Line(
          points={{-4,-86},{-4,48},{84,48}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(status.busConnector,setup. busConnector)         annotation (Line(
          points={{52,-70},{-4,-70},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
          points={{84,-24},{-4,-24},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(gases.busConnector,setup. busConnector) annotation (Line(
          points={{-66,-54},{-4,-54},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(heat.busConnector,setup. busConnector) annotation (Line(
          points={{-38,40},{-4,40},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(cardioVascularSystem.busConnector, cVS_dif.busConnector)
        annotation (Line(
          points={{42,91.8},{64,91.8},{64,82},{86,82}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(cardioVascularSystem.busConnector, cVS_varsToFile.busConnector)
        annotation (Line(
          points={{42,91.8},{24,91.8},{24,70}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      annotation (        experiment(StopTime=3.1536e+007));
    end CardioVascular_test;

    model CardioVascular_test_SI
      import Physiomodel;
    Physiomodel.CardioVascular.CardioVascularSystem cardioVascularSystem
      annotation (Placement(transformation(extent={{40,72},{60,94}})));
      Physiomodel.Metabolism.IO_Bus.InputFromFile_SI
                                              nutrientsAndMetabolism
        annotation (Placement(transformation(extent={{-88,60},{-68,80}})));
      Physiomodel.Electrolytes.IO_Bus.InputFromFile_SI electrolytes
        annotation (Placement(transformation(extent={{74,-34},{94,-14}})));
      Physiomodel.Hormones.IO_Bus.InputFromFile_SI hormones
        annotation (Placement(transformation(extent={{40,6},{60,26}})));
      Physiomodel.Nerves.IO_Bus.InputFromFile_SI nerves
        annotation (Placement(transformation(extent={{74,38},{94,58}})));
      Physiomodel.Setup.IO_Bus.InputFromFile_SI     setup
        annotation (Placement(transformation(extent={{-14,-96},{6,-76}})));
      Physiomodel.Water.IO_Bus.InputFromFile_SI water
        annotation (Placement(transformation(extent={{-86,-6},{-66,14}})));
      Physiomodel.Proteins.IO_Bus.InputFromFile_SI proteins
        annotation (Placement(transformation(extent={{-48,-30},{-28,-10}})));
      Physiomodel.Status.IO_Bus.InputFromFile_SI status
        annotation (Placement(transformation(extent={{42,-80},{62,-60}})));
      Physiomodel.Gases.IO_Bus.InputFromFile_SI gases
        annotation (Placement(transformation(extent={{-76,-64},{-56,-44}})));
      Physiomodel.Heat.IO_Bus.InputFromFile_SI heat
        annotation (Placement(transformation(extent={{-28,30},{-48,50}})));
      Physiomodel.CardioVascular.IO_Bus.OutputComparison_SI
                                         cVS_dif
        annotation (Placement(transformation(extent={{76,72},{96,92}})));
      Physiomodel.CardioVascular.IO_Bus.OutputToFile_SI
                                                cVS_varsToFile
        annotation (Placement(transformation(extent={{14,60},{34,80}})));
    equation
      connect(setup.busConnector,hormones. busConnector) annotation (Line(
          points={{-4,-86},{-4,16},{50,16}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,proteins. busConnector) annotation (Line(
          points={{-4,-86},{-4,-20},{-38,-20}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,cardioVascularSystem. busConnector)
                                                    annotation (Line(
          points={{-4,-86},{-4,91.8},{42,91.8}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,nutrientsAndMetabolism. busConnector)
        annotation (Line(
          points={{-4,-86},{-4,70},{-78,70}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,water. busConnector) annotation (Line(
          points={{-4,-86},{-4,4},{-76,4}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(setup.busConnector,nerves. busConnector) annotation (Line(
          points={{-4,-86},{-4,48},{84,48}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(status.busConnector,setup. busConnector)         annotation (Line(
          points={{52,-70},{-4,-70},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(electrolytes.busConnector,setup. busConnector) annotation (Line(
          points={{84,-24},{-4,-24},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(gases.busConnector,setup. busConnector) annotation (Line(
          points={{-66,-54},{-4,-54},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(heat.busConnector,setup. busConnector) annotation (Line(
          points={{-38,40},{-4,40},{-4,-86}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(cardioVascularSystem.busConnector, cVS_dif.busConnector)
        annotation (Line(
          points={{42,91.8},{64,91.8},{64,82},{86,82}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      connect(cardioVascularSystem.busConnector, cVS_varsToFile.busConnector)
        annotation (Line(
          points={{42,91.8},{24,91.8},{24,70}},
          color={0,0,255},
          thickness=0.5,
          smooth=Smooth.None));
      annotation (        experiment(StopTime=864000));
    end CardioVascular_test_SI;
  end IO_Bus;
annotation (Documentation(revisions="<html>
<table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr>
<td><p>Author:</p></td>
<td>Marek Matejak</td>
</tr>
<tr>
<td><p>License:</p></td>
<td><p><a href=\"http://www.physiomodel.org/license.html\">Physiomodel License 1.0</a> </p></td>
</tr>

<tr>
<td><p>Date of:</p></td>
<td><p>2008-2015</p></td>
</tr>
<tr>
<td><p>References:</p></td>
<td><p><br><a href=\"modelica://Physiomodel.UsersGuide.References\">User&apos;s Guide</a></p><p><br><a href=\"https://www.zotero.org/search/type/group/q/physiomodel\">zotero: Physiomodel</a></p><p><br><a href=\"http://www.hummod.org\">HumMod</a></p><p><br><a href=\"https://www.zotero.org/groups/hummod_references\">zotero: HumMod References</a></p></td>
</tr>
</table>
<p><br>Copyright &copy; 2008-2015 Marek Matejak, Charles University in Prague.</p>
</html>",
        info="<html>
<p>Heart pump</p>
<p>Cardiac output (CO) as a mean blood flow from heart ventricle is heart rate (HR) multiplied by stroke volume (SV), where stroke volume is difference of end diastolic volume (EDV) [Gaasch1975,Carter1998] and end systolic volume (ESV) [Noda1993]. The HR and heart contractility (in the meaning of ESV) [Suga1976] can be influenced by nervus vagus (main parasympathicus autonomic neural pathway) [Xenopoulos1994], epinephrine [Collins-Nakai1994] or angiotensin II [Kumagai1994]. The most comon descriptions are pressure-volume relations [Sawaga1988] as in famous A-V fistula experiments [Guyton1961] or filling pressure experiments [Suga1974] or less invasive exercise experiments [Little1993].</p>
<p>There is some evidence of non-steady state behaviour of end diastolic volume, because the stroke volume is dependent on heart rate [Ross1965,Sugimoto1966].</p>
<p><br><br>Blood viscosity[Begg1966,Schrier1970]</p>
<p><br>Vasoconstriction [Mellander1992, Shigemi1994]</p>
<p><br>The compliance of systemic arteries is constant around normal working conditions [Roach1957].</p>
<p><br>Systemic veins [Shigemi1994,Echt1974,Gauer1956]</p>
<p><br>Muscle pump effect [Armstrong1985,Laughlin1987,Laughlin1983]</p>
<p><br>Sequestered volume [Ochsner1951,Mayerson1939,Bevegard1962,Pollack1949,Block1930,Henry1950,Thomson1928]</p>
<p><br>Kidney blood flow [Skarlatos1993,Manning1987] - effect to renal arteries [Skov1996]</p>
<p>-myogenic [Auckland1989,Drummond2008,Heyeraas1987]</p>
<p>-tubuloglomerular feedback [Moore1990,Drummond2008,Ito1990]</p>
<p><br>Splanchnic circulation [Maass-Moreno1992,Bradley1953,Bradley1952,Mitzner1974,Laine1979]</p>
<p>- effect of norepinephrine [Greenway1985,Laut1987]</p>
<p>- effect of histamine [Greenway1973]</p>
<p><br><br>Brain blood flow [Kety1948]</p>
<p><br>Blood Volume regulations </p>
<p>- hypoproteinemia [Manning1990,Manning1983]</p>
<p><br>Autoregulation of circulation</p>
<p>- CO on CO2 [Davidson1986]</p>
<p>-  ,Hogan1990,Lash1987,Malo1984,Marshall1995,Metting1989,Metting1988,Weber2000,Borgstr&ouml;m1975,Whalen1974,Frisbee2000,Berg1997,Burattini1994,POHOST1976,Archer1996,Goodman1978,Granger1976,Granger1969,Harder1996,Harder1996,Marshall1988,Frisbee2000,Kunert1996,Prewitt1976,Kuwahira1993]</p>
<p><br>RAAS and other regulations .. see hormones, nerves and drugs</p>
</html>"));
end CardioVascular2;
