﻿within IDEAS.UsersGuide;
class References "References"
  extends Modelica.Icons.References;

  annotation (Documentation(info="<html>
<h4>Citing IDEAS</h4>
<p>
Please cite IDEAS using the reference provided below.
</p>
<p>
F. Jorissen, G. Reynders, R. Baetens, D. Picard, D. Saelens, and L. Helsen,
\"<a href=\"https://doi.org/10.1080/19401493.2018.1428361\">Implementation and verification of the IDEAS building energy simulation library</a>\",
<i>Journal of Building Performance Simulation</i>, vol. 11, no. 6, pp. 669&ndash;688, 2018.
</p>
<p>
<b>BibTeX entry</b>
<p style=\"margin-left: 30px;\">
@article{Jorissen2018ideas,<br/>
author = {Jorissen, Filip and Reynders, Glenn and Baetens, Ruben and Picard, Damien and Saelens, Dirk and Helsen, Lieve},<br/>
journal = {Journal of Building Performance Simulation},<br/>
title = {{Implementation and Verification of the IDEAS Building Energy Simulation Library}},<br/>
volume = {11},<br/>
issue = {6},<br/>
pages = {669-688},<br/>
doi={10.1080/19401493.2018.1428361},<br/>
year = {2018}<br/>
}
</p>

<h4>References on the development of IDEAS</h4>
<ul>
<li>
K. De Jonge, F. Jorissen, L. Helsen, and J. Laverge,
\"<a href=\"https://doi.org/10.26868/25222708.2021.30165\">Wind-Driven Air Flow Modelling in Modelica: Validation and Implementation in the IDEAS Library.</a>\",
<i>In Proceedings of Buildings Simulation 2021: 17th Conference of IBPSA</i>, Bruges, Belgium, pp. 1099&ndash;1106, 2021.
</li>
<li>
F. Jorissen, and L. Helsen,
\"<a href=\"https://doi.org/10.3384/ecp19157139 \">Integrated Modelica Model and Model Predictive Control of a Terraced House Using IDEAS</a>\",
<i>In Proceedings of the 13th International Modelica Conference</i>, Regensburg, Germany, 157:14, pp.10, 2019.
</li>
<li>
F. Jorissen, G. Reynders, R. Baetens, D. Picard, D. Saelens, and L. Helsen,
\"<a href=\"https://doi.org/10.1080/19401493.2018.1428361\">Implementation and verification of the IDEAS building energy simulation library</a>\",
<i>Journal of Building Performance Simulation</i>, vol. 11, no. 6, pp. 669&ndash;688, 2018.
</li>
<li>
F. Jorissen, M. Wetter, and L. Helsen,
\"<a href=\"https://doi.org/10.1080/19401493.2017.1421263\">Simplifications for hydronic system models in Modelica</a>\",
<i>Journal of Building Performance Simulation</i>, vol. 11, no. 6, pp. 639&ndash;654, 2018.
</li>
<li>
F. Jorissen, \"Toolchain for Optimal Control and Design of Energy Systems in Buildings\", <i>PhD thesis</i>, KU Leuven, Belgium, 2018.
</li>
<li>
B. van der Heijde, M. Fuchs,  C. Ribas Tugores, G. Schweiger, K. Sartor, D. Basciotti, D. Müller, C. Nytsch-Geusen, M. Wetter, and L. Helsen,
\"<a href=\"https://doi.org/10.1016/j.enconman.2017.08.072\">Dynamic equation-based thermo-hydraulic pipe model for district heating and cooling systems</a>\",
<i>Energy Conversion and Management</i>, vol. 151, pp. 158&ndash;169; 2017.
</li>
<li>
F. Jorissen, W. Boydens, and L. Helsen,
\"<a href=\"https://doi.org/10.1080/19401493.2016.1273391\">Validated air handling unit model using indirect evaporative cooling</a>\",
<i>Journal of Building Performance Simulation</i>, vol. 11, no. 1, pp. 48&ndash;64, 2017.
</li>
<li>
R. Baetens, R. De Coninck, F. Jorissen, D. Picard, L. Helsen, and D. Saelens,
\"<a href=\"https://doi.org/10.26868/25222708.2015.2243\">OpenIDEAS - An Open Framework for Integrated District Energy Simulations</a>\",
<i>In Proceedings of Building Simulation 2015: 14th Conference of IBPSA</i>, Hyderabad, India, pp. 347&ndash;354, 2015.
</li>
<li>
M. Wetter, M. Fuchs, P. Grozman, L. Helsen, F. Jorissen, M. Lauster, M. Dirk, C. Nytsch-Geusen, D. Picard, P. Sahlin, and M. Thorade,
\"<a href=\"https://doi.org/10.26868/25222708.2015.2414\">IEA EBC Annex 60 Modelica Library &ndash; An International Collaboration to Develop a Free Open-Source Model Library for Buildings and Community Energy Systems</a>\",
<i>In Proceedings of Building Simulation 2015: 14th Conference of IBPSA</i>, Hyderabad, India, pp. 395&ndash;402, 2015.
</li>
<li>
F. Jorissen, L. Helsen, and M. Wetter,
\"<a href=\"https://doi.org/10.3384/ecp1511859\">Simulation Speed Analysis and Improvements of Modelica Models for Building Energy Simulation</a>\",
<i>In Proceedings of the 11th International Modelica Conference</i>, Paris France, 118:6, pp. 59&ndash;69, 2015.

<li>
D. Picard, F. Jorissen, and L. Helsen,
\"<a href=\"https://doi.org/10.3384/ecp1511851\">Methodology for Obtaining Linear State Space Building Energy Simulation Models</a>\",
<i>In Proceedings of the 11th International Modelica Conference</i>, Paris France, 118:5, pp. 51&ndash;58, 2015.
</li>
<li>
D. Picard, and L. Helsen,
\"<a href=\"https://doi.org/10.3384/ecp14096857\">Advanced Hybrid Model for Borefield Heat Exchanger Performance Evaluation, an Implementation in Modelica</a>\",
<i>In Proceedings of the 10th International Modelica Conference</i>, Lund, Sweden, 96:89, pp. 857&ndash;866, 2014.
</li>
<li>
D. Picard, and L. Helsen,
\"A New Hybrid Model For Borefield Heat Exchangers Performance Evaluation\",
<i>In Proceedings of the ASHRAE Annual Conference</i>, vol. 120, no. 2, Seattle, United States, 2014.
</li>
</ul>
</html>"));
end References;
