within IDEAS.Fluid.CHPs.OrganicRankine.Data.WorkingFluids;
record Heptane "Data record for n-heptane"
  extends Generic(
    T = {
         263.15       ,292.814444444,322.478888889,352.143333333,
         381.807777778,411.472222222,441.136666667,470.801111111,
         500.465555556,530.13       },
    p = {
         7.989173434e+02,4.640431854e+03,1.836462559e+04,5.521023193e+04,
         1.357341530e+05,2.872627666e+05,5.428996069e+05,9.414295237e+05,
         1.530128640e+06,2.375428955e+06},
    rhoLiq = {
         708.744161335,684.005361466,658.664692095,632.281562559,
         604.301119943,573.933259524,539.893343103,499.714554172,
         447.233450033,353.248453405},
    dTRef = 30,
    sSatLiq = {
         -796.989852616,-565.365137693,-345.670277761,-134.519732505,
           70.367270161, 270.657778517, 467.830116908, 663.725205376,
          861.998498724,1078.641393707},
    sSatVap = {
          672.954567605, 692.831668803, 739.301918155, 803.885808983,
          880.494448383, 964.465721538,1051.759799165,1137.935524319,
         1215.655239687,1260.938470215},
    sRef = {
          841.855369762, 858.118161463, 902.502690963, 966.060882441,
         1042.44988716 ,1127.000908946,1216.047379616,1306.364617459,
         1394.627619853,1477.085968924},
    hSatLiq = {
         -251949.774148952,-187591.55369971 ,-120007.324894362,
          -48744.573432347,  26561.273589323, 106252.748227298,
          190762.393341302, 280852.494718802, 378399.475308805,
          492237.654496714},
    hSatVap = {
         134866.100032261,180826.645196058,229873.303319793,
         281708.681968285,335874.131225473,391735.444337536,
         448355.186941404,504111.239777487,555392.492651129,
         588878.803666001},
    hRef = {
         181833.569133815,231695.382441082,284942.600720626,
         341242.380998298,400129.988352552,461040.039711463,
         523275.529594887,585905.759075288,647581.728725064,
         706410.769546266});
  annotation (
  defaultComponentPrefixes = "parameter",
  defaultComponentName = "pro",
  Documentation(info="<html>
<p>
Record containing properties of n-heptane.
Its name in CoolProp is \"n-Heptane\".
A figure in the documentation of
<a href=\"Modelica://IDEAS.Fluid.CHPs.OrganicRankine.ConstantEvaporation\">
IDEAS.Fluid.CHPs.OrganicRankine.ConstantEvaporation</a>
shows which lines these arrays represent.
</p>
</html>"));
end Heptane;