within IDEAS.Examples.IBPSA;
package Data
  "Data package that stores the parameters of the air to water heat pump calibrated with manufacturer data."
  extends Modelica.Icons.MaterialPropertiesPackage;
  package Heating "Parameters calibrated in heating mode."
    extends Modelica.Icons.MaterialPropertiesPackage;
    record Carrier_30AW015_15kW_4_9COP_R410A =
      IDEAS.Fluid.HeatPumps.Data.ScrollWaterToWater.Generic (
        volRat = 3.3462310104583497,
        V_flow_nominal = 0.002053683987444995,
        leaCoe = 0.005198105847571281,
        etaEle = 0.9999999999999999,
        PLos = 1094.80443337558,
        dTSup = 6.119909663822337,
        UACon = 55857.41506195485,
        UAEva = 194869.32437840427)
      annotation (
        defaultComponentPrefixes = "parameter",
        defaultComponentName="datHeaPum",
        preferredView="info",
      Documentation(info="<html>
<p>
Calibrated parameters for Carrier 30AW015.
</p>

<p>
Generated by Javier Arroyo on 2020-07-13.
</p>

</html>", revisions="<html>
<ul>
<li>
July 13, 2020, by Javier Arroyo:<br/>
Calibrated parameters.
</li>
</ul>
</html>"));
  end Heating;
end Data;
