within IDEAS.Fluid.CHPs.OrganicRankine.Data.WorkingFluids;
record R134a "Data record for R134a"
  extends Generic(
    T = {
         263.15       ,274.378888889,285.607777778,296.836666667,
         308.065555556,319.294444444,330.523333333,341.752222222,
         352.981111111,364.21       },
    p = {
          200603.307472702, 306065.144055732, 449719.915074148,
          639730.094514731, 884904.588817354,1194757.011967908,
         1579685.738808544,2051381.787343061,2623740.847778454,
         3315235.242079038},
    rhoLiq = {
         1327.126163441,1290.706177259,1252.384215745,1211.660788636,
         1167.846607299,1119.946901702,1066.43367865 ,1004.714189346,
          929.529223158, 825.767527903},
    dTRef = 30,
    sSatLiq = {
          950.647690901,1006.000704972,1060.270839535,1113.712093542,
         1166.611338723,1219.319709948,1272.312300214,1326.324896806,
         1382.758644761,1445.49325885 },
    sSatVap = {
         1733.350797261,1726.412875563,1721.041565618,1716.692460392,
         1712.816408039,1708.79575006 ,1703.835616881,1696.731056518,
         1685.221329816,1663.254186971},
    sRef = {
         1825.651782765,1819.26336679 ,1814.857399221,1811.970391363,
         1810.194406344,1809.157628299,1808.50662669 ,1807.888965926,
         1806.93261727 ,1805.200478092},
    hSatLiq = {
         186696.59112921 ,201653.015599322,216960.445937552,
         232677.402848669,248882.679090854,265687.289291076,
         283257.907432927,301870.718852068,322069.176904733,
         345362.177321903},
    hSatVap = {
         392664.913567861,399318.906508085,405681.704634567,
         411664.085009797,417149.647216853,421974.269587487,
         425886.432468616,428457.847058395,428832.791544889,
         424672.884952779},
    hRef = {
         418317.035128306,426163.587402212,433855.473474184,
         441342.371701698,448569.586759484,455475.412466164,
         461988.043511396,468022.071596944,473474.189346821,
         478212.639980691});
  annotation (
  defaultComponentPrefixes = "parameter",
  defaultComponentName = "pro",
  Documentation(info="<html>
<p>
Record containing properties of R134a.
Its name in CoolProp is \"R134a\".
A figure in the documentation of
<a href=\"Modelica://IDEAS.Fluid.CHPs.OrganicRankine.ConstantEvaporation\">
IDEAS.Fluid.CHPs.OrganicRankine.ConstantEvaporation</a>
shows which lines these arrays represent.
</p>
</html>"));
end R134a;