within IDEAS.Controls.OBC.CDL.Reals.Validation;
model Log
  "Validation model for the Log block"
  IDEAS.Controls.OBC.CDL.Reals.Log log1
    "Block that outputs the natural (base e) logarithm of the input (input > 0 required)"
    annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
  IDEAS.Controls.OBC.CDL.Reals.Sources.Ramp ramp1(
    duration=1,
    offset=1,
    height=5)
    "Block that generates ramp signal"
    annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));

equation
  connect(ramp1.y,log1.u)
    annotation (Line(points={{-39,0},{-12,0}},color={0,0,127}));
  annotation (
    experiment(
      StopTime=1.0,
      Tolerance=1e-06),
    __Dymola_Commands(
      file="modelica://IDEAS/Resources/Scripts/Dymola/Controls/OBC/CDL/Reals/Validation/Log.mos" "Simulate and plot"),
    Documentation(
      info="<html>
<p>
Validation test for the block
<a href=\"modelica://IDEAS.Controls.OBC.CDL.Reals.Log\">
IDEAS.Controls.OBC.CDL.Reals.Log</a>.
</p>
<p>
The input <code>u</code> varies from <i>+1</i> to <i>+6</i>.
</p>
</html>",
      revisions="<html>
<ul>
<li>
March 22, 2017, by Jianjun Hu:<br/>
First implementation.
</li>
</ul>
</html>"),
    Icon(
      graphics={
        Ellipse(
          lineColor={75,138,73},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          extent={{-100,-100},{100,100}}),
        Polygon(
          lineColor={0,0,255},
          fillColor={75,138,73},
          pattern=LinePattern.None,
          fillPattern=FillPattern.Solid,
          points={{-36,60},{64,0},{-36,-60},{-36,60}})}));
end Log;
