within IndustrialControlSystems.LinearSystems.Continuous;
model Integrator "Integrator: mu/s"
  extends Interfaces.BaseBlock;
  parameter Real mu = 1 "Gain"
    annotation(Dialog(group = "Block parameters"));
  parameter Real y_start = 0 "output initial value"
    annotation(Dialog(group = "Initial conditions"));
initial equation
  y = y_start;
equation
  der(y) = mu*u;
  annotation (Icon(graphics={
        Text(
          extent={{-30,40},{36,6}},
          lineColor={0,0,0},
          fillColor={213,255,170},
          fillPattern=FillPattern.Solid,
          textString="mu"),
        Text(
          extent={{-30,-4},{36,-38}},
          lineColor={0,0,0},
          fillColor={213,255,170},
          fillPattern=FillPattern.Solid,
          textString="s"),
        Line(
          points={{-44,0},{50,0}},
          color={0,0,0},
          smooth=Smooth.None)}),Documentation(info="
  <HTML>
  <h4>Description</h4>
  <p>
  Continuous time transfer function of an integrating process.
  <pre>
   Y(s)      mu
   ----  = ------
   U(s)      s
  </pre>
  </p>
  </HTML>", revisions="<html>
<dl><dt>Industrial Control Systems (v 1.0.0) : April-May 2012</dt>
<dl><dt>List of revisions:</dt>
<p><ul>
<li>11 May 2012 (author: Marco Bonvini)</li>
</ul></p>
<dl><dt><b>Main Authors:</b> <br/></dt>
<dd>Marco Bonvini; &lt;<a href=\"mailto:bonvini@elet.polimi.it\">bonvini@elet.polimi.it</a>&gt;</dd>
<dd>Alberto Leva &lt;<a href=\"mailto:leva@elet.polimi.it\">leva@elet.polimi.it</a>&gt;<br/></dd>
<dd>Politecnico di Milano</dd>
<dd>Dipartimento di Elettronica e Informazione</dd>
<dd>Via Ponzio 34/5</dd>
<dd>20133 Milano - ITALIA -<br/></dd>
<dt><b>Copyright:</b> </dt>
<dd>Copyright &copy; 2010-2012, Marco Bonvini and Alberto Leva.<br/></dd>
<dd><i>The IndustrialControlSystems package is <b>free</b> software; it can be redistributed and/or modified under the terms of the <b>Modelica license</b>.</i><br/></dd>
</dl></html>"));
end Integrator;
