within Buildings.Examples.DualFanDualDuct.Controls;
block CoolingCoilTemperatureSetpoint "Set point scheduler for cooling coil"
  extends Modelica.Blocks.Icons.Block;
  import Buildings.Examples.VAVReheat.BaseClasses.Controls.OperationModes;
  parameter Modelica.Units.SI.Temperature TOn(displayUnit="degC")
    "Setpoint during on";
  parameter Modelica.Units.SI.Temperature TOff(displayUnit="degC")
    "Setpoint during off";
  Modelica.Blocks.Sources.RealExpression TSetPoi(
     y(final unit="K", displayUnit="degC")=if (mode.y == Integer(OperationModes.occupied) or
           mode.y == Integer(OperationModes.unoccupiedPreCool) or
           mode.y == Integer(OperationModes.safety)) then TOn else TOff)
    "Air temperature setpoint"
    annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
  VAVReheat.BaseClasses.Controls.ControlBus controlBus
    annotation (Placement(transformation(extent={{-10,-90},{10,-70}})));
  Modelica.Blocks.Routing.IntegerPassThrough mode
    annotation (Placement(transformation(extent={{40,-90},{60,-70}})));
  Modelica.Blocks.Interfaces.RealOutput TSet(
    final unit="K",
    displayUnit="degC")
    "Temperature set point"
    annotation (Placement(transformation(extent={{100,-10},{120,10}})));
equation
  connect(controlBus.controlMode, mode.u) annotation (Line(
      points={{0,-80},{38,-80}},
      color={255,204,51},
      thickness=0.5,
      smooth=Smooth.None), Text(
      textString="%first",
      index=-1,
      extent={{-6,3},{-6,3}}));
  connect(TSetPoi.y, TSet) annotation (Line(
      points={{1,6.10623e-16},{54.5,6.10623e-16},{54.5,5.55112e-16},{110,
          5.55112e-16}},
      color={0,0,127},
      smooth=Smooth.None));

  annotation ( Icon(graphics={
        Text(
          extent={{44,16},{90,-18}},
          textColor={0,0,255},
          textString="TSetCoo")}));
end CoolingCoilTemperatureSetpoint;
