within Buildings.Fluid.CHPs.OrganicRankine.Data.WorkingFluids;
record Pentane "Data record for n-pentane (R601)"
  extends Generic(
    T = {
         263.15       ,284.988888889,306.827777778,328.666666667,
         350.505555556,372.344444444,394.183333333,416.022222222,
         437.861111111,459.7        },
    p = {
           15196.961880746,  40847.01461526 ,  93347.760875795,
          188229.761547615, 344161.604577882, 582381.684493329,
          926479.361144566,1402869.463375476,2042636.912945348,
         2888164.842888385},
    rhoLiq = {
         654.994012423,634.140752869,612.406165595,589.474257693,
         564.920053506,538.129125681,508.125336463,473.116841092,
         428.954697374,359.39054261 },
    dTRef = 30,
    sSatLiq = {
         -364.770358607,-188.383459065, -18.245572622, 147.200487718,
          309.214016986, 468.928951023, 627.576629898, 786.91058507 ,
          950.457609042,1131.212144756},
    sSatVap = {
         1124.757616955,1132.064676189,1153.78271919 ,1185.735649416,
         1224.628540081,1267.744136879,1312.410414419,1355.214297416,
         1390.117806445,1397.022012012},
    sRef = {
         1296.158077524,1301.28713228 ,1321.950521732,1353.859341364,
         1393.796088528,1439.208143314,1487.913190685,1537.898827489,
         1587.138246557,1633.295767519},
    hSatLiq = {
         -104421.898943934, -56052.79734228 ,  -5633.016486273,
           47087.837000979, 102370.736056908, 160525.092863763,
          221987.014134065, 287509.248703003, 358766.967642045,
          442086.536306975},
    hSatVap = {
         287547.387825234,320260.24955903 ,353977.819783112,
         388419.726812333,423228.612037831,457959.489455307,
         491937.078095822,523936.222010323,551277.070188378,
         564279.332284564},
    hRef = {
         335209.266682762,371013.610228284,408087.525730008,
         446185.930365794,485045.348695265,524354.800753776,
         563719.721538978,602626.895309489,640395.197254024,
         676083.07721731 });
  annotation (
  defaultComponentPrefixes = "parameter",
  defaultComponentName = "pro",
  Documentation(info="<html>
<p>
Record containing properties of n-pentane (R601).
Its name in CoolProp is \"n-Pentane\".
A figure in the documentation of
<a href=\"Modelica://Buildings.Fluid.CHPs.OrganicRankine.ConstantEvaporation\">
Buildings.Fluid.CHPs.OrganicRankine.ConstantEvaporation</a>
shows which lines these arrays represent.
</p>
</html>"));
end Pentane;