within Buildings.DHC.ETS.Combined.Validation;
model HeatRecoveryHeatPumpWSE
  "Validation of the ETS model with heat recovery chiller and waterside economizer"
  extends Buildings.DHC.ETS.Combined.Validation.HeatRecoveryHeatPump(
    ets(have_WSE=true),
    TChiWatSupSet(k=12 + 273.15),
    TDisWatSup(
      tableName="tab1",
      table=[
      0,11;
      49,11;
      50,20;
      100,20],
    extrapolation=Modelica.Blocks.Types.Extrapolation.Periodic,
    timeScale=3600,
    offset={273.15},
    columns={2},
    smoothness=Modelica.Blocks.Types.Smoothness.MonotoneContinuousDerivative1));

  annotation (
    __Dymola_Commands(
      file="modelica://Buildings/Resources/Scripts/Dymola/DHC/ETS/Combined/Validation/HeatRecoveryHeatPumpWSE.mos"
      "Simulate and plot"),
    experiment(
      StopTime=360000,
      Tolerance=1e-06),
    Documentation(
      revisions="<html>
<ul>
<li>
November 3, 2025, by Michael Wetter:<br/>
Moved to <code>Buildings.Obsolete</code>.<br/>
This is for
<a href=\"https://github.com/lbl-srg/modelica-buildings/issues/4354\">#4354</a>.
</li>
<li>
August 22, 2025, by Hongxiang Fu:<br/>
Updated the ETS component with modular heat pump model.
</li>
<li>
November 22, 2024, by Michael Wetter:<br/>
Removed duplicate connection.
</li>
<li>
July 31, 2020, by Antoine Gautier:<br/>
First implementation.
</li>
</ul>
</html>",
      info="<html>
<p>
This model validates
<a href=\"modelica://Buildings.DHC.ETS.Combined.HeatRecoveryHeatPump\">
Buildings.DHC.ETS.Combined.HeatRecoveryHeatPump</a>
in a system configuration with no geothermal borefield.
</p>
<ul>
<li>
A fictitious load profile is used, consisting in the succession of five load
patterns.
</li>
<li>
Each load pattern is simulated with two values of the district water supply
temperature, corresponding to typical extreme values over a whole year
 of operation.
</li>
<li>
The other modeling assumptions are described in
<a href=\"modelica://Buildings.Obsolete.DHC.ETS.Combined.Validation.BaseClasses.PartialChillerBorefield\">
Buildings.Obsolete.DHC.ETS.Combined.Validation.BaseClasses.PartialChillerBorefield</a>.
</li>
</ul>
</html>"));
end HeatRecoveryHeatPumpWSE;
