within Buildings.Controls.OBC;
package CDL "Package with blocks, examples and validation tests for control description language"
  annotation (
    Documentation(
      info="<html>
<p>
Package that has elementary input-output blocks
that form the Control Description Language (CDL).
The implementation is structured into sub-packages.
The packages <code>Validation</code> and <code>Examples</code>
contain validation and example models.
These are not part of the CDL specification, but rather
implemented to provide reference responses computed by the CDL blocks.
For a specification of CDL, see
<a href=\"http://obc.lbl.gov/specification/cdl.html\">
http://obc.lbl.gov/specification/cdl.html</a>.
</p>
</html>",
      revisions="<html>
<ul>
<li>
December 22, 2016, by Michael Wetter:<br/>
Firt implementation, based on the blocks from the Modelica Standard Library.
</li>
</ul>
</html>"),
    Icon(
      graphics={
        Rectangle(
          lineColor={200,200,200},
          fillColor={248,248,248},
          fillPattern=FillPattern.HorizontalCylinder,
          extent={{-100.0,-100.0},{100.0,100.0}},
          radius=25.0),
        Rectangle(
          lineColor={128,128,128},
          extent={{-100.0,-100.0},{100.0,100.0}},
          radius=25.0),
        Ellipse(
          origin={10.0,10.0},
          fillColor={76,76,76},
          pattern=LinePattern.None,
          fillPattern=FillPattern.Solid,
          extent={{-80.0,-80.0},{-20.0,-20.0}}),
        Ellipse(
          origin={10.0,10.0},
          pattern=LinePattern.None,
          fillPattern=FillPattern.Solid,
          extent={{0.0,-80.0},{60.0,-20.0}}),
        Ellipse(
          origin={10.0,10.0},
          fillColor={128,128,128},
          pattern=LinePattern.None,
          fillPattern=FillPattern.Solid,
          extent={{0.0,0.0},{60.0,60.0}}),
        Ellipse(
          origin={10.0,10.0},
          lineColor={128,128,128},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          extent={{-80.0,0.0},{-20.0,60.0}})}));
end CDL;
