within Buildings.Controls.OBC.ASHRAE.G36.TerminalUnits.Reheat.Subsequences.Validation;
model DamperValves
  "Validate model for controlling damper and valve position"

  Buildings.Controls.OBC.ASHRAE.G36.TerminalUnits.Reheat.Subsequences.DamperValves damValFan(
    final VMin_flow=0.01,
    final VCooMax_flow=0.09,
    final VHeaMax_flow=0.08,
    final kDam=1) "Output signal for controlling damper position"
    annotation (Placement(transformation(extent={{80,-10},{100,30}})));
  Buildings.Controls.OBC.ASHRAE.G36.TerminalUnits.Reheat.Subsequences.DamperValves damValFan1(
    final VMin_flow=0.01,
    final VCooMax_flow=0.09,
    final VHeaMax_flow=0.08,
    final have_preIndDam=false,
    final kDam=1) "Output signal for controlling damper position"
    annotation (Placement(transformation(extent={{80,-110},{100,-70}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Ramp uCoo(
    final height=-1,
    final duration=3600,
    final offset=1,
    final startTime=900) "Cooling control signal"
    annotation (Placement(transformation(extent={{-100,100},{-80,120}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant TZon(
    final k=273.15 + 22)
    "Zone temperature"
    annotation (Placement(transformation(extent={{-100,20},{-80,40}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant VActMin_flow(
    final k=0.01) "Active minimum airflow setpoint"
    annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant VActCooMax_flow(
    final k=0.075) "Active cooling maximum airflow setpoint"
    annotation (Placement(transformation(extent={{-60,80},{-40,100}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant TSupSet(
    final k=273.15 + 13)
    "AHU supply air temperature setpoint"
    annotation (Placement(transformation(extent={{-60,0},{-40,20}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Ramp uHea(
    final height=1,
    final duration=3600,
    final offset=0,
    final startTime=5500) "Heating control signal"
    annotation (Placement(transformation(extent={{-60,-40},{-40,-20}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Ramp disAir(
    final duration=7200,
    final offset=0.01,
    final height=0.06)
    "Discharge airflow rate"
    annotation (Placement(transformation(extent={{-60,-80},{-40,-60}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Sine TSup(
    final offset=273.15 + 13,
    final amplitude=1,
    final freqHz=1/3600)
    "Supply air temperature"
    annotation (Placement(transformation(extent={{-100,60},{-80,80}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant THeaSet(
    final k=273.15 + 20)
    "Zone heating setpoint"
    annotation (Placement(transformation(extent={{-100,-20},{-80,0}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Sine TDis(
    final offset=273.15 + 13,
    final amplitude=1.2,
    final freqHz=1/3600) "Measured discharge air temperature"
    annotation (Placement(transformation(extent={{-100,-60},{-80,-40}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Ramp opeMod(
    final offset=1,
    final height=3,
    final duration=90000) "Operation mode"
    annotation (Placement(transformation(extent={{-100,-160},{-80,-140}})));
  Buildings.Controls.OBC.CDL.Conversions.RealToInteger reaToInt2
    "Convert real to integer"
    annotation (Placement(transformation(extent={{-20,-160},{0,-140}})));
  Buildings.Controls.OBC.CDL.Continuous.Round round2(
    final n=0)
    "Round real number to given digits"
    annotation (Placement(transformation(extent={{-60,-160},{-40,-140}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant VActCooMin_flow(
    final k=0.015) "Active cooling minimum flow"
    annotation (Placement(transformation(extent={{-60,120},{-40,140}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant VActHeaMin_flow(
    final k=0.015)
    "Active heating minimum flow"
    annotation (Placement(transformation(extent={{-100,-100},{-80,-80}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Constant VActHeaMax_flow(
    final k=0.06)
    "Active heating maximum airflow setpoint"
    annotation (Placement(transformation(extent={{-60,-120},{-40,-100}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Ramp oveFlo(
    final height=3,
    final duration=2000,
    final startTime=1000) "Override flow setpoint"
    annotation (Placement(transformation(extent={{-100,150},{-80,170}})));
  Buildings.Controls.OBC.CDL.Conversions.RealToInteger reaToInt1
    "Convert real to integer"
    annotation (Placement(transformation(extent={{-20,150},{0,170}})));
  Buildings.Controls.OBC.CDL.Continuous.Round round1(final n=0)
    "Round real number to given digits"
    annotation (Placement(transformation(extent={{-60,150},{-40,170}})));
equation
  connect(uCoo.y, damValFan.uCoo) annotation (Line(points={{-78,110},{60,110},{60,
          20},{78,20}}, color={0,0,127}));
  connect(TZon.y, damValFan.TZon) annotation (Line(points={{-78,30},{48,30},{48,
          -1},{78,-1}}, color={0,0,127}));
  connect(VActCooMax_flow.y, damValFan.VActCooMax_flow) annotation (Line(points={{-38,90},
          {56,90},{56,17},{78,17}},  color={0,0,127}));
  connect(VActMin_flow.y, damValFan.VActMin_flow) annotation (Line(points={{-38,50},
          {44,50},{44,11},{78,11}}, color={0,0,127}));
  connect(VActMin_flow.y, damValFan1.VActMin_flow) annotation (Line(points={{-38,50},
          {44,50},{44,-89},{78,-89}}, color={0,0,127}));
  connect(TZon.y, damValFan1.TZon) annotation (Line(points={{-78,30},{48,30},{48,
          -101},{78,-101}}, color={0,0,127}));
  connect(VActCooMax_flow.y, damValFan1.VActCooMax_flow) annotation (Line(
        points={{-38,90},{56,90},{56,-83},{78,-83}},   color={0,0,127}));
  connect(uCoo.y, damValFan1.uCoo) annotation (Line(points={{-78,110},{60,110},{
          60,-80},{78,-80}}, color={0,0,127}));
  connect(uHea.y, damValFan.uHea) annotation (Line(points={{-38,-30},{32,-30},{32,
          1},{78,1}},   color={0,0,127}));
  connect(uHea.y, damValFan1.uHea) annotation (Line(points={{-38,-30},{32,-30},{
          32,-99},{78,-99}}, color={0,0,127}));
  connect(disAir.y, damValFan1.VDis_flow) annotation (Line(points={{-38,-70},{68,
          -70},{68,-74},{78,-74}}, color={0,0,127}));
  connect(TSupSet.y, damValFan.TSupSet) annotation (Line(points={{-38,10},{40,10},
          {40,6},{78,6}},   color={0,0,127}));
  connect(TSupSet.y, damValFan1.TSupSet) annotation (Line(points={{-38,10},{40,10},
          {40,-94},{78,-94}},      color={0,0,127}));
  connect(TSup.y, damValFan.TSup) annotation (Line(points={{-78,70},{52,70},{52,
          14},{78,14}}, color={0,0,127}));
  connect(TSup.y, damValFan1.TSup) annotation (Line(points={{-78,70},{52,70},{52,
          -86},{78,-86}}, color={0,0,127}));
  connect(THeaSet.y, damValFan.THeaSet) annotation (Line(points={{-78,-10},{36,-10},
          {36,4},{78,4}},            color={0,0,127}));
  connect(THeaSet.y, damValFan1.THeaSet) annotation (Line(points={{-78,-10},{36,
          -10},{36,-96},{78,-96}},     color={0,0,127}));
  connect(TDis.y, damValFan.TDis) annotation (Line(points={{-78,-50},{28,-50},{28,
          8},{78,8}},   color={0,0,127}));
  connect(TDis.y, damValFan1.TDis) annotation (Line(points={{-78,-50},{28,-50},{
          28,-92},{78,-92}}, color={0,0,127}));
  connect(opeMod.y,round2. u)
    annotation (Line(points={{-78,-150},{-62,-150}}, color={0,0,127}));
  connect(round2.y,reaToInt2. u)
    annotation (Line(points={{-38,-150},{-22,-150}},
      color={0,0,127}));
  connect(reaToInt2.y, damValFan.uOpeMod) annotation (Line(points={{2,-150},{16,
          -150},{16,-9},{78,-9}}, color={255,127,0}));
  connect(reaToInt2.y, damValFan1.uOpeMod) annotation (Line(points={{2,-150},{16,
          -150},{16,-109},{78,-109}}, color={255,127,0}));
  connect(VActCooMin_flow.y, damValFan.VActCooMin_flow) annotation (Line(points={{-38,130},
          {64,130},{64,23},{78,23}}, color={0,0,127}));
  connect(VActCooMin_flow.y, damValFan1.VActCooMin_flow) annotation (Line(
        points={{-38,130},{64,130},{64,-77},{78,-77}}, color={0,0,127}));
  connect(VActHeaMin_flow.y, damValFan.VActHeaMin_flow) annotation (Line(points={{-78,-90},
          {24,-90},{24,-4},{78,-4}}, color={0,0,127}));
  connect(VActHeaMin_flow.y, damValFan1.VActHeaMin_flow) annotation (Line(
        points={{-78,-90},{24,-90},{24,-104},{78,-104}}, color={0,0,127}));
  connect(VActHeaMax_flow.y, damValFan.VActHeaMax_flow) annotation (Line(points={{-38,
          -110},{20,-110},{20,-6},{78,-6}}, color={0,0,127}));
  connect(VActHeaMax_flow.y, damValFan1.VActHeaMax_flow) annotation (Line(
        points={{-38,-110},{20,-110},{20,-106},{78,-106}}, color={0,0,127}));
  connect(oveFlo.y,round1. u)
    annotation (Line(points={{-78,160},{-62,160}}, color={0,0,127}));
  connect(round1.y,reaToInt1. u)
    annotation (Line(points={{-38,160},{-22,160}}, color={0,0,127}));
  connect(reaToInt1.y, damValFan.oveFloSet) annotation (Line(points={{2,160},{72,
          160},{72,29},{78,29}}, color={255,127,0}));
  connect(reaToInt1.y, damValFan1.oveFloSet) annotation (Line(points={{2,160},{72,
          160},{72,-71},{78,-71}}, color={255,127,0}));
annotation (
  experiment(StopTime=7200, Tolerance=1e-6),
  __Dymola_Commands(file="modelica://Buildings/Resources/Scripts/Dymola/Controls/OBC/ASHRAE/G36/TerminalUnits/Reheat/Subsequences/Validation/DamperValves.mos"
        "Simulate and plot"),
  Documentation(info="<html>
<p>
This example validates
<a href=\"modelica://Buildings.Controls.OBC.ASHRAE.G36.TerminalUnits.Reheat.Subsequences.DamperValves\">
BBuildings.Controls.OBC.ASHRAE.G36.TerminalUnits.Reheat.Subsequences.DamperValves</a>
for damper and valve control of terminal unit with reheat.
</p>
</html>", revisions="<html>
<ul>
<li>
February 10, 2022, by Jianjun Hu:<br/>
First implementation.
</li>
</ul>
</html>"),
    Icon(coordinateSystem(extent={{-100,-100},{100,100}}),
         graphics={
        Ellipse(lineColor = {75,138,73},
                fillColor={255,255,255},
                fillPattern = FillPattern.Solid,
                extent = {{-100,-100},{100,100}}),
        Polygon(lineColor = {0,0,255},
                fillColor = {75,138,73},
                pattern = LinePattern.None,
                fillPattern = FillPattern.Solid,
                points = {{-36,60},{64,0},{-36,-60},{-36,60}}),
                   Ellipse(
          lineColor={75,138,73},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          extent={{-100,-100},{100,100}}), Polygon(
          lineColor={0,0,255},
          fillColor={75,138,73},
          pattern=LinePattern.None,
          fillPattern=FillPattern.Solid,
          points={{-36,58},{64,-2},{-36,-62},{-36,58}})}),
    Diagram(coordinateSystem(extent={{-120,-180},{120,180}})));
end DamperValves;
