within Buildings.UsersGuide;
class Acknowledgements "Acknowledgements"
  extends Modelica.Icons.Information;
  annotation (preferredView="info",
  Documentation(info="<html>
<h4><font color=\"#008000\" size=\"5\">Acknowledgements</font></h4>
<p>
 The development of this library was supported by:
</p>
 <ul>
 <li>The U.S. Department of Energy, Assistant Secretary for
  Energy Efficiency and Renewable Energy,
  <ul>
  <li>
  Office of Building
  Technologies, under Contracts Number DE-AC02-05CH11231 and DE-EE0007688,
  </li>
  <li>
  Advanced Manufacturing Office, under Award Number DE-EE0009139, and
 </li>
  <li>
  Geothermal Technologies Office, under Award Number DE-AC02-05CH11231.
  </li>
  </ul>
  </li>
 <li>
  The California Energy Commission, Public Interest Energy Research Program, Buildings End Use Energy Efficiency Program, Award Number 500-10-052.
 </li>
 </ul>
<p>
The core of this library is the Modelica IBPSA library,
a free open-source library with basic models that codify best practices for
the implementation of models for building and community energy and control systems.
The development of the IBPSA library is organized through the
<a href=\"https://ibpsa.github.io/project1\">IBPSA Project 1</a>
of the International Building Performance Simulation Association (IBPSA).
From 2012 to 2017, the development was organized through the
<a href=\"http://www.iea-annex60.org\">Annex 60 project</a>
of the Energy in Buildings and Communities Programme of the International Energy Agency (IEA EBC).
</p>
 <p>
  The <a href=\"modelica://Buildings.Airflow.Multizone\">package for multizone airflow modeling</a>
  and the <a href=\"modelica://Buildings.Utilities.Comfort.Fanger\">model for thermal comfort</a>
  was contributed by the United Technologies Research Center, which also contributed to the
  validation of the <a href=\"modelica://Buildings.ThermalZones.Detailed.MixedAir\">room heat transfer model</a>.
</p>
<p>
We thank Dietmar Winkler from Telemark University College for the various feedback that
helped improve the organization and structure of the library.
</p>
<p>
The following people have directly contributed to the implementation of the Buildings library
(many others have contributed by other means than model implementation):
</p>
<ul>
<li>Saranya Anbarasu, Pennsylvania State University, USA
</li>
<li>David Blum, Lawrence Berkeley National Laboratory, USA
</li>
<li>Marco Bonvini, Lawrence Berkeley National Laboratory, USA
</li>
<li>Felix B&uuml;nning, RWTH Aachen, Germany
</li>
<li>Guokai Chen, University College London, UK
</li>
<li>Massimo Cimmino, Polytechnique Montr&eacute;al, Canada
</li>
<li>Rainer Czetina, University of Applied Sciences Technikum Wien, Austria
</li>
<li>Karthikeya Devaprasad, Pacific Northwest National Laboratory, USA
</li>
<li>Hagar Elarga, Lawrence Berkeley National Laboratory, USA
</li>
<li>Hongxiang \"Casper\" Fu, Lawrence Berkeley National Laboratory, USA
</li>
<li>Yangyang Fu, University of Colorado Boulder, Colorado, USA
</li>
<li>Antoine Gautier, Lawrence Berkeley National Laboratory, USA
</li>
<li>Sebastian Giglmayr, University of Applied Sciences Technikum Wien, Austria
</li>
<li>Milica Grahovac, Lawrence Berkeley National Laboratory, USA
</li>
<li>Peter Grant, Lawrence Berkeley National Laboratory, USA
</li>
<li>Brandon M. Hencey, Cornell University, USA
</li>
<li>Sen Huang, Pacific Northwest National Laboratory, USA
</li>
<li>Kathryn Hinkelman, University of Colorado Boulder, Colorado, USA
</li>
<li>Jianjun Hu, Lawrence Berkeley National Laboratory, USA
</li>
<li>Roman Ilk, University of Applied Sciences Technikum Wien, Austria
</li>
<li>Dan Li, University of Miami, Florida, USA
</li>
<li>Filip Jorissen, KU Leuven, Belgium
</li>
<li>Thierry S. Nouidui, Lawrence Berkeley National Laboratory, USA
</li>
<li>Markus Nurschinger, University of Applied Sciences Technikum Wien, Austria
</li>
<li>Xiufeng Pang, Lawrence Berkeley National Laboratory, USA
</li>
<li>Remi Patureau, Lawrence Berkeley National Laboratory, USA
</li>
<li>Damien Picard, KU Leuven, Belgium
</li>
<li>Kaustubh Phalak, Lawrence Berkeley National Laboratory, USA
</li>
<li>Thomas Sevilla, University of Miami, Florida, USA
</li>
<li>Chengnan Shi, University of Colorado Boulder, Colorado, USA
</li>
<li>Martin Sj&ouml;lund, Link&ouml;ping University, Sweden
</li>
<li>Matthis Thorade, Berlin University of the Arts, Germany
</li>
<li>Wei Tian, University of Miami, Florida, USA
</li>
<li>Armin Teskeredzic, Mechanical Engineering Faculty Sarajevo and GIZ, Bosnia and Herzegovina
</li>
<li>Rafael Velazquez, University of Seville, Spain
</li>
<li>Pierre Vigouroux, Institut National des Sciences Appliquees, France
</li>
<li>Sebastian Vock, University of Applied Sciences Technikum Wien, Austria
</li>
<li>Vladimir Vukovic, Austrian Institute of Technology, Austria
</li>
<li>Jing Wang, University of Colorado Boulder, Colorado, USA
</li>
<li>Michael Wetter, Lawrence Berkeley National Laboratory, USA
</li>
<li>Tea Zakula, University of Zagreb, Croatia
</li>
<li>Ettore Zanetti, Politecnico di Milano, Italy
</li>
<li>Rebecca Zarin Pass, Lawrence Berkeley National Laboratory, USA
</li>
<li>Kun Zhang, Lawrence Berkeley National Laboratory, USA
</li>
<li>Wangda Zuo, University of Colorado Boulder, Colorado, USA
</li>
</ul>
</html>"));
end Acknowledgements;
