within Buildings.Fluid.Geothermal.ZonedBorefields.Data.Configuration;
record Validation "Configuration data record for validation models"
  extends
    Buildings.Fluid.Geothermal.ZonedBorefields.Data.Configuration.Template(
    borCon=Borefields.Types.BoreholeConfiguration.SingleUTube,
    cooBor={{4.50,0.00},{7.50,0.00},{10.50,0.00},{13.50,0.00},{3.00,3.00},{6.00,3.00},{9.00,3.00},{12.00,3.00},{15.00,3.00},{4.50,6.00},{7.50,6.00},{10.50,6.00},{13.50,6.00},{3.00,9.00},{6.00,9.00},{9.00,9.00},{12.00,9.00},{4.50,12.00},{7.50,12.00},{10.50,12.00},{16.50,0.00},{19.50,0.00},{22.50,0.00},{25.50,0.00},{18.00,3.00},{21.00,3.00},{24.00,3.00},{16.50,6.00},{19.50,6.00},{22.50,6.00},{15.00,9.00},{18.00,9.00},{21.00,9.00},{24.00,9.00},{13.50,12.00},{16.50,12.00},{19.50,12.00},{22.50,12.00},{3.00,15.00},{6.00,15.00},{9.00,15.00},{12.00,15.00},{15.00,15.00},{18.00,15.00},{21.00,15.00},{4.50,18.00},{7.50,18.00},{10.50,18.00},{13.50,18.00},{16.50,18.00},{3.00,21.00},{6.00,21.00},{9.00,21.00},{12.00,21.00},{15.00,21.00},{4.50,24.00},{7.50,24.00},{0.00,4.50},{0.00,7.50},{0.00,10.50},{0.00,13.50},{-3.00,3.00},{-3.00,6.00},{-3.00,9.00},{-3.00,12.00},{-3.00,15.00},{-6.00,4.50},{-6.00,7.50},{-6.00,10.50},{-6.00,13.50},{-9.00,3.00},{-9.00,6.00},{-9.00,9.00},{-9.00,12.00},{-12.00,4.50},{-12.00,7.50},{-12.00,10.50},{0.00,16.50},{0.00,19.50},{0.00,22.50},{0.00,25.50},{-3.00,18.00},{-3.00,21.00},{-3.00,24.00},{-6.00,16.50},{-6.00,19.50},{-6.00,22.50},{-9.00,15.00},{-9.00,18.00},{-9.00,21.00},{-9.00,24.00},{-12.00,13.50},{-12.00,16.50},{-12.00,19.50},{-12.00,22.50},{-15.00,3.00},{-15.00,6.00},{-15.00,9.00},{-15.00,12.00},{-15.00,15.00},{-15.00,18.00},{-15.00,21.00},{-18.00,4.50},{-18.00,7.50},{-18.00,10.50},{-18.00,13.50},{-18.00,16.50},{-21.00,3.00},{-21.00,6.00},{-21.00,9.00},{-21.00,12.00},{-21.00,15.00},{-24.00,4.50},{-24.00,7.50},{-4.50,0.00},{-7.50,0.00},{-10.50,0.00},{-13.50,0.00},{-3.00,-3.00},{-6.00,-3.00},{-9.00,-3.00},{-12.00,-3.00},{-15.00,-3.00},{-4.50,-6.00},{-7.50,-6.00},{-10.50,-6.00},{-13.50,-6.00},{-3.00,-9.00},{-6.00,-9.00},{-9.00,-9.00},{-12.00,-9.00},{-4.50,-12.00},{-7.50,-12.00},{-10.50,-12.00},{-16.50,0.00},{-19.50,0.00},{-22.50,0.00},{-25.50,0.00},{-18.00,-3.00},{-21.00,-3.00},{-24.00,-3.00},{-16.50,-6.00},{-19.50,-6.00},{-22.50,-6.00},{-15.00,-9.00},{-18.00,-9.00},{-21.00,-9.00},{-24.00,-9.00},{-13.50,-12.00},{-16.50,-12.00},{-19.50,-12.00},{-22.50,-12.00},{-3.00,-15.00},{-6.00,-15.00},{-9.00,-15.00},{-12.00,-15.00},{-15.00,-15.00},{-18.00,-15.00},{-21.00,-15.00},{-4.50,-18.00},{-7.50,-18.00},{-10.50,-18.00},{-13.50,-18.00},{-16.50,-18.00},{-3.00,-21.00},{-6.00,-21.00},{-9.00,-21.00},{-12.00,-21.00},{-15.00,-21.00},{-4.50,-24.00},{-7.50,-24.00},{-0.00,-4.50},{-0.00,-7.50},{-0.00,-10.50},{-0.00,-13.50},{3.00,-3.00},{3.00,-6.00},{3.00,-9.00},{3.00,-12.00},{3.00,-15.00},{6.00,-4.50},{6.00,-7.50},{6.00,-10.50},{6.00,-13.50},{9.00,-3.00},{9.00,-6.00},{9.00,-9.00},{9.00,-12.00},{12.00,-4.50},{12.00,-7.50},{12.00,-10.50},{-0.00,-16.50},{-0.00,-19.50},{-0.00,-22.50},{-0.00,-25.50},{3.00,-18.00},{3.00,-21.00},{3.00,-24.00},{6.00,-16.50},{6.00,-19.50},{6.00,-22.50},{9.00,-15.00},{9.00,-18.00},{9.00,-21.00},{9.00,-24.00},{12.00,-13.50},{12.00,-16.50},{12.00,-19.50},{12.00,-22.50},{15.00,-3.00},{15.00,-6.00},{15.00,-9.00},{15.00,-12.00},{15.00,-15.00},{15.00,-18.00},{15.00,-21.00},{18.00,-4.50},{18.00,-7.50},{18.00,-10.50},{18.00,-13.50},{18.00,-16.50},{21.00,-3.00},{21.00,-6.00},{21.00,-9.00},{21.00,-12.00},{21.00,-15.00},{24.00,-4.50},{24.00,-7.50}},
    mBor_flow_nominal={0.5,0.3},
    dp_nominal={5e4,2e4},
    hBor=100.0,
    rBor=0.075,
    dBor=1.0,
    nZon=2,
    iZon={1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
    rTub=0.02,
    kTub=0.5,
    eTub=0.002,
    xC=0.05);
  annotation (
  defaultComponentPrefixes="parameter",
  defaultComponentName="conDat",
    Documentation(
info="<html>
<p>
This record presents an example for how to define configuration data records
using the template in
<a href=\"modelica://Buildings.Fluid.Geothermal.ZonedBorefields.Data.Configuration.Template\">
Buildings.Fluid.Geothermal.ZonedBorefields.Data.Configuration.Template</a>.
</p>
<p>
The configuration consists in 228 boreholes divided into 2 zones of 80 and 148.
The borefield is configured in a cylindrical arrangement
with the 2 zones distributed in annular regions. The borefield configuration
is shown in the figure below.
</p>
<p align=\"center\">
<img alt=\"image\" src=\"modelica://Buildings/Resources/Images/Fluid/Geothermal/ZonedBorefields/ValidationConfiguration.png\" />
</p>
</html>",
revisions="<html>
<ul>
<li>
May 2024, by Massimo Cimmino:<br/>
First implementation.
</li>
</ul>
</html>"));
end Validation;
