within Buildings.DHC.Loads.HotWater.Examples;
model HeaterAndFixtureDirectHeatExchangerWithElectricHeat
  "Example model for direct heat exchanger with auxiliary electric heater"
  extends Modelica.Icons.Example;
  package Medium = Buildings.Media.Water "Medium model";
  Buildings.Fluid.Sources.Boundary_pT           souCol(
    nPorts=3,
    redeclare package Medium = Medium,
    T(displayUnit="degC") = 283.15)
              "Source of domestic cold water"
    annotation (Placement(transformation(extent={{-10,-10},{10,10}},
        rotation=90,
        origin={0,-50})));
  Buildings.DHC.Loads.HotWater.ThermostaticMixingValve theMixVal(redeclare
      package                                                                                   Medium = Medium,
      mMix_flow_nominal=1) "Ideal thermostatic mixing valve"
    annotation (Placement(transformation(extent={{-10,-12},{10,8}})));
  Buildings.Fluid.Sources.MassFlowSource_T souDisAmb(
    redeclare package Medium = Medium,
    m_flow=1,
    T(displayUnit="degC") = 298.15,
    nPorts=1) "Source of district water from ambient network" annotation (
      Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={-30,-50})));
  Modelica.Blocks.Sources.Constant conTHotSet(k(
      final unit="K",
      displayUnit="degC") = 313.15)
    "Temperature setpoint for hot water supply to fixture"
    annotation (Placement(transformation(extent={{-100,-10},{-80,10}})));
  Buildings.Fluid.Sources.Boundary_pT sinDis(
    redeclare package Medium = Medium,
    T(displayUnit="degC"),
    nPorts=3)              "Sink of district network water" annotation (
      Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={-70,-50})));
  Modelica.Blocks.Sources.Constant conTSetMix(k(
      final unit="K",
      displayUnit="degC") = 308.15)
    "Temperature setpoint for mixed water supply to fixture"
    annotation (Placement(transformation(extent={{-100,20},{-80,40}})));
  Buildings.DHC.Loads.HotWater.DirectHeatExchangerWithElectricHeat gen(
    redeclare package MediumDom = Medium,
    redeclare package MediumHea = Medium,
    mDom_flow_nominal=1,
    mHea_flow_nominal=1)
    "Hot water generated by heat exchanger and auxiliary heat"
    annotation (Placement(transformation(extent={{-64,-10},{-44,10}})));
  Modelica.Blocks.Sources.CombiTimeTable sch(
    tableOnFile=true,
    tableName="tab1",
    fileName=Modelica.Utilities.Files.loadResource("modelica://Buildings/Resources/Data/DHC/Loads/HotWater/DHW_ApartmentMidRise.mos"),
    smoothness=Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
    extrapolation=Modelica.Blocks.Types.Extrapolation.Periodic)
    "Domestic hot water fixture draw fraction schedule"
    annotation (Placement(transformation(extent={{-100,50},{-80,70}})));

  Buildings.DHC.Loads.HotWater.DirectHeatExchangerWithElectricHeat genNoEle(
    redeclare package MediumDom = Medium,
    redeclare package MediumHea = Medium,
    have_eleHea=false,
    mDom_flow_nominal=1,
    mHea_flow_nominal=1)
    "Hot water generated by heat exchanger without auxiliary heat"
    annotation (Placement(transformation(extent={{32,-12},{52,8}})));
  Buildings.DHC.Loads.HotWater.ThermostaticMixingValve theMixValNoEle(redeclare
      package                                                                                        Medium = Medium,
      mMix_flow_nominal=1) "Ideal thermostatic mixing valve"
    annotation (Placement(transformation(extent={{70,-12},{90,8}})));
  Buildings.Fluid.Sources.MassFlowSource_T souDisHot(
    redeclare package Medium = Medium,
    m_flow=1,
    T(displayUnit="degC") = 323.15,
    nPorts=1) "Source of district water from hot network" annotation (Placement(
        transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={60,-50})));
equation

  connect(conTSetMix.y,theMixVal. TMixSet) annotation (Line(points={{-79,30},{-16,
          30},{-16,0},{-11,0}},color={0,0,127}));
  connect(conTHotSet.y, gen.TDomSet)
    annotation (Line(points={{-79,0},{-65,0}}, color={0,0,127}));
  connect(sch.y[1], theMixVal.yMixSet) annotation (Line(points={{-79,60},{-14,60},
          {-14,6},{-11,6}},
                          color={0,0,127}));
  connect(gen.port_bDom, theMixVal.port_hot) annotation (Line(points={{-44,6},{-22,
          6},{-22,-6},{-10,-6}}, color={0,127,255}));
  connect(theMixVal.port_col, souCol.ports[1]) annotation (Line(points={{-10,-10},
          {-22,-10},{-22,-24},{1.33333,-24},{1.33333,-40}}, color={0,127,255}));
  connect(gen.port_aDom, souCol.ports[2]) annotation (Line(points={{-64,6},{-68,
          6},{-68,-26},{4.44089e-16,-26},{4.44089e-16,-40}}, color={0,127,255}));
  connect(gen.port_bHea, sinDis.ports[1]) annotation (Line(points={{-64,-6},{
          -68.6667,-6},{-68.6667,-40}},
                               color={0,127,255}));
  connect(gen.port_aHea, souDisAmb.ports[1])
    annotation (Line(points={{-44,-6},{-30,-6},{-30,-40}}, color={0,127,255}));
  connect(sch.y[1], theMixValNoEle.yMixSet) annotation (Line(points={{-79,60},{66,
          60},{66,6},{69,6}}, color={0,0,127}));
  connect(conTSetMix.y, theMixValNoEle.TMixSet) annotation (Line(points={{-79,30},
          {64,30},{64,0},{69,0}}, color={0,0,127}));
  connect(conTHotSet.y, genNoEle.TDomSet) annotation (Line(points={{-79,0},{-74,
          0},{-74,20},{28,20},{28,-2},{31,-2}}, color={0,0,127}));
  connect(genNoEle.port_bDom, theMixValNoEle.port_hot) annotation (Line(points={
          {52,4},{60,4},{60,-6},{70,-6}}, color={0,127,255}));
  connect(souDisHot.ports[1], genNoEle.port_aHea)
    annotation (Line(points={{60,-40},{60,-8},{52,-8}}, color={0,127,255}));
  connect(genNoEle.port_bHea, sinDis.ports[2]) annotation (Line(points={{32,-8},
          {26,-8},{26,-30},{-70,-30},{-70,-40}}, color={0,127,255}));
  connect(theMixValNoEle.port_col, souCol.ports[3]) annotation (Line(points={{70,
          -10},{62,-10},{62,-32},{-1.33333,-32},{-1.33333,-40}}, color={0,127,255}));
  connect(genNoEle.port_aDom, sinDis.ports[3]) annotation (Line(points={{32,4},{
          24,4},{24,-28},{-71.3333,-28},{-71.3333,-40}}, color={0,127,255}));
  annotation (__Dymola_Commands(
      file="modelica://Buildings/Resources/Scripts/Dymola/DHC/Loads/HotWater/Examples/HeaterAndFixtureDirectHeatExchangerWithElectricHeat.mos" "Simulate and plot"),
      Documentation(info="<html>
<p>
Example model of a fresh water station that heats up domestic hot water.
Input is a load profile which is sent to a model that computes the hot and cold water draw.
The domestic hot water is produced by a heat exchanger with a district water source
and optionally an electric heater.  Examples with and without the electric
heater are shown.
</p>
</html>", revisions="<html>
<ul>
<li>
Nov 15, 2023, by David Blum:<br/>
First implementation.
</li>
</ul>
</html>"),
experiment(
      StopTime=172800,
      Tolerance=1e-06));
end HeaterAndFixtureDirectHeatExchangerWithElectricHeat;
