within Buildings.Controls.OBC.ASHRAE.G36.Types;
type Title24ClimateZone = enumeration(
    Not_Specified "Not specified",
    Zone_1  "Zone 1, Reference city: Eureka",
    Zone_2  "Zone 2, Reference city: Napa",
    Zone_3  "Zone 3, Reference city: San Francisco",
    Zone_4  "Zone 4, Reference city: San Jose",
    Zone_5  "Zone 5, Reference city: Santa Maria",
    Zone_6  "Zone 6, Reference city: Los Angeles",
    Zone_7  "Zone 7, Reference city: San Diego",
    Zone_8  "Zone 8, Reference city: Long Beach",
    Zone_9  "Zone 9, Reference city: Los Angeles (Civic Center)",
    Zone_10 "Zone 10, Reference city: Riverside",
    Zone_11 "Zone 11, Reference city: Red Bluff",
    Zone_12 "Zone 12, Reference city: Stockton",
    Zone_13 "Zone 13, Reference city: Fresno",
    Zone_14 "Zone 14, Reference city: Barstow",
    Zone_15 "Zone 15, Reference city: Brawley",
    Zone_16 "Zone 16, Reference city: Bishop")
  "Enumeration of California Title 24 climate zone"
annotation (
 Evaluate=true, Documentation(info="<html>
<p>
Enumeration of different Title 24 climate zones. Possible values are:
</p>
<table border=\"1\" summary=\"Explanation of the enumeration\">
<tr>
<th>Enumeration</th>
<th>Description</th></tr>
<tr><td><code>Not_Specified</code></td>
<td>
Not specified.
</td></tr>
<tr><td><code>Zone_1</code></td>
<td>
Zone 1, Reference city: Eureka.
</td></tr>
<tr><td><code>Zone_2</code></td>
<td>
Zone 2, Reference city: Napa.
</td></tr>
<tr><td><code>Zone_3</code></td>
<td>
Reference city: San Francisco.
</td></tr>
<tr><td><code>Zone_4</code></td>
<td>
Zone 4, Reference city: San Jose.
</td></tr>
<tr><td><code>Zone_5</code></td>
<td>
Zone 5, Reference city: Santa Maria.
</td></tr>
<tr><td><code>Zone_6</code></td>
<td>
Zone 6, Reference city: Los Angeles.
</td></tr>
<tr><td><code>Zone_7</code></td>
<td>
Zone 7, Reference city: San Diego.
</td></tr>
<tr><td><code>Zone_8</code></td>
<td>
Zone 8, Reference city: Long Beach.
</td></tr>
<tr><td><code>Zone_9</code></td>
<td>
Zone 9, Reference city: Los Angeles (Civic Center).
</td></tr>
<tr><td><code>Zone_10</code></td>
<td>
Zone 10, Reference city: Riverside.
</td></tr>
<tr><td><code>Zone_11</code></td>
<td>
Zone 11, Reference city: Red Bluff.
</td></tr>
<tr><td><code>Zone_12</code></td>
<td>
Zone 12, Reference city: Stockton.
</td></tr>
<tr><td><code>Zone_13</code></td>
<td>
Zone 13, Reference city: Fresno.
</td></tr>
<tr><td><code>Zone_14</code></td>
<td>
Zone 14, Reference city: Barstow.
</td></tr>
<tr><td><code>Zone_15</code></td>
<td>
Zone 15, Reference city: Brawley.
</td></tr>
<tr><td><code>Zone_16</code></td>
<td>
Zone 16, Reference city: Bishop.
</td></tr>
</table>
</html>", revisions="<html>
<ul>
<li>
March 22, 2022, by Jianjun Hu:<br/>
First implementation.
</li>
</ul>
</html>"));
