# Modelica IBPSA library

[![Build Status](https://app.travis-ci.com/ibpsa/modelica-ibpsa.svg?branch=master)](https://app.travis-ci.com/ibpsa/modelica-ibpsa)

This is the development site for the _Modelica IBPSA Library_ and its user guide.

Instructions for developers are available on the [wiki](https://github.com/ibpsa/modelica-ibpsa/wiki).

## Library description

The Modelica _IBPSA_ library is a free open-source library with basic models that codify
best practices for the implementation of models for building and community energy and control systems.

The development of the IBPSA library is organized through 
the IBPSA Modelica Working Group (https://github.com/ibpsa/modelica-working-group).
The development was organized from 2017 to 2022 through
the IBPSA Project 1 (https://ibpsa.github.io/project1)
of the International Building Performance Simulation Association (IBPSA),
and from 2012 to 2017 through the
Annex 60 project (http://www.iea-annex60.org) of the
Energy in Buildings and Communities Programme
of the International Energy Agency (IEA EBC).

This library is typically not used directly by end-users. Rather, it
is integrated by developers of other Modelica libraries for building and
community energy systems, who then distribute it to end-users as part of their
respective library.
Currently, the _IBPSA_ library is used as the core of these libraries:

 * _AixLib_, from RWTH Aachen University, Germany: https://github.com/RWTH-EBC/AixLib
 * _Buildings_, from LBNL, Berkeley, CA, USA: http://simulationresearch.lbl.gov/modelica
 * _BuildingSystems_, from UdK Berlin, Germany: http://www.modelica-buildingsystems.de
 * _IDEAS_ from KU Leuven, Belgium: https://github.com/open-ideas/IDEAS

## License

The Modelica _IBPSA_ library is available under a 3-clause BSD-license.
See [Modelica IBPSA Library license ](https://htmlpreview.github.io/?https://github.com/ibpsa/modelica-ibpsa/blob/master/IBPSA/legal.html).

## Development and contribution
You may report any issues by using the [Issues](https://github.com/ibpsa/modelica-ibpsa/issues) button.

Contributions in the form of [Pull Requests](https://github.com/ibpsa/modelica-ibpsa/pulls) are always welcome.
Prior to issuing a pull request, make sure your code follows
the [style guide and coding conventions](https://github.com/ibpsa/modelica-ibpsa/wiki/Style-Guide).
