within IBPSA.Fluid.CHPs.OrganicRankine.Data.WorkingFluids;
record Acetone "Data record for acetone"
  extends Generic(
    T = {
         263.15       ,289.255555556,315.361111111,341.466666667,
         367.572222222,393.677777778,419.783333333,445.888888889,
         471.994444444,498.1        },
    p = {
            5344.990110825,  20650.833566074,  61555.897854858,
          151351.563616118, 321797.046994737, 612178.548912226,
         1068684.448400072,1745219.888869215,2707418.650799205,
         4046245.515470347},
    rhoLiq = {
         822.882971808,794.503127301,765.124111199,734.248636529,
         701.245557689,665.234774298,624.858127478,577.729019236,
         518.607501298,426.621585717},
    dTRef = 30,
    sSatLiq = {
         -479.028530758,-280.940806531, -94.928726727,  81.991049561,
          252.145020847, 417.505066333, 580.003385303, 742.022980174,
          907.767378748,1092.563132257},
    sSatVap = {
         1681.191059012,1596.661258221,1542.5487283  ,1510.043720587,
         1492.612391749,1484.868192175,1481.705802931,1477.167997198,
         1461.519799448,1404.254266854},
    sRef = {
         1817.036318829,1731.286422698,1677.739234558,1647.046003462,
         1632.468103167,1628.870285847,1632.074409953,1638.412725056,
         1644.396794592,1646.431943962},
    hSatLiq = {
         -141608.840175549, -86907.602970965, -30644.702178538,
           27561.220566805,  88109.595870881, 151467.211307906,
          218265.291981649, 289522.609167944, 367363.173547648,
          459910.837559632},
    hSatVap = {
         426852.944874144,456199.225381078,485752.007459114,
         515193.605967011,544070.943987246,571664.354771464,
         596784.938528286,617315.603980879,628731.239715757,
         615164.191702174},
    hRef = {
         464617.330003106,497136.67139577 ,530386.531973482,
         563997.6626978  ,597536.243125905,630465.696202391,
         662097.963586358,691534.659141209,717607.015924844,
         738837.945805182});
  annotation (
  defaultComponentPrefixes = "parameter",
  defaultComponentName = "pro",
  Documentation(info="<html>
<p>
Record containing properties of acetone.
Its name in CoolProp is \"Acetone\".
A figure in the documentation of
<a href=\"Modelica://IBPSA.Fluid.CHPs.OrganicRankine.ConstantEvaporation\">
IBPSA.Fluid.CHPs.OrganicRankine.ConstantEvaporation</a>
shows which lines these arrays represent.
</p>
</html>"));
end Acetone;