# HanserModelica

HanserModelica is a Modelica open source educational library on object oriented modeling applied to electrical engineering and a particular focus on polyphase electric machines. This library is based on a book published in German by [Hanser Fachbuchverlag](https://www.hanser-fachbuch.de/buch/Modelica+Objektorientierte+Modellbildung+von+Drehfeldmaschinen/9783446455511). 

![Modelica - Objektorientierte Modellerung von Drehfeldmaschinen](https://github.com/christiankral/HanserModelica/blob/master/HanserModelica/Resources/Images/45551_Kral_165x240_3D_Soft.png?raw=true)

Watch the YouTube video on creating the model [`FirstSteps.Example4`](https://www.youtube.com/watch?v=esGAcZ_ViRU).

Contact the author by creating a [New GitHub Issue](https://github.com/christiankral/HanserModelica/issues/new). Get more information about the [author](https://christiankral.net).

## Content of the book (translated to English)

- Fundemantals
- Modelica
  - [First steps](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/FirstSteps) (see YouTube video  [FirstSteps.Electrical4](https://youtu.be/esGAcZ_ViRU))
  - [Variables and types](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/VariablesTypes)
  - [Modelica classes and concepts](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Classes)
- Modeling concepts
  - [General concepts and electrical systems](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Electrical)
  - [Magnetic systems](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Magnetic)
  - [Thermal systems](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Thermal)
  - [Rotational systems](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Rotational)
- [Polyphase electrical machines](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Machines)
- [Induction machines](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/InductionMachines)
- [Synchronous machines](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/SynchronousMachines)
- GitHub tutorial
  - Tutorial based on the Modelica library [FirstSteps](https://github.com/christiankral/FirstSteps)

## Inhaltsverzeichnis des Buchs (German)

- Grundlagen
- Modelica
  - [Erste Schritte](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/FirstSteps)  (siehe YouTube-Video [FirstSteps.Electrical4](https://youtu.be/esGAcZ_ViRU))
  - [Variablen und Datentypen](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/VariablesTypes)
  - [Klassen und Konzepte](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Classes)
- Modellierungskonzepte
  - [Allgemeine Konzepte und elektrische Systeme](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Electrical)
  - [Magnetische Systeme](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Magnetic)
  - [Thermische systems](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Thermal)
  - [Rotierende mechanische Systeme](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Rotational)
- [Drehfeldmaschinen](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/Machines)
- [Asynchronmaschinen](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/InductionMachines)
- [Synchronmaschinen](https://github.com/christiankral/HanserModelica/tree/master/HanserModelica/SynchronousMachines)
- GitHub Tutorial
  - Tutorial basierend auf der Modelica-Library [FirstSteps](https://github.com/christiankral/FirstSteps)
