within ;
package HanserModelica "Educational open source library on <html><a href=\"https://www.hanser-fachbuch.de/buch/Modelica+Objektorientierte+Modellbildung+von+Drehfeldmaschinen/9783446455511\">Modelica, electrical engineering and polyphase electrical machines</a></html>"

  extends Modelica.Icons.ExamplesPackage;

  annotation (
    preferredView="info",
    version="2.0.1",
    versionDate="2025-03-13",
    uses(Complex(version="4.0.0"), Modelica(version="4.0.0")),
  Documentation(info="<html>
<p><a href=\"https://github.com/christiankral/HanserModelica\">HanserModelica</a>
is a Modelica open source educational library on object oriented modeling applied to electrical engineering and
a particular focus on polyphase electric machines. This library is
based on a book published in German by
<a href=\"https://www.hanser-fachbuch.de/buch/Modelica+Objektorientierte+Modellbildung+von+Drehfeldmaschinen/9783446455511\">Hanser Fachbuchverlag</a>.
The <a href=\"modelica://HanserModelica.UsersGuide\">User's Guide</a> gives an overview of the contents of the book.</p>
<p><img src=\"modelica://HanserModelica/Resources/Images/45551_Kral_165x240_3D_Soft.png\"></p>
</html>"));
end HanserModelica;
