# Greenhouses Library

[![Documentation](https://readthedocs.org/projects/greenhouses-library/badge/?branch=master)](https://greenhouses-library.readthedocs.io)


The Greenhouses Library is an open-source library for dynamic modelling of greenhouse climate developed in the Modelica language. The library aims at providing a modeling framework capable of simulating not only the energy flows of a greenhouse climate but also the complex interactions and energy flows relative to systems coupling the greenhouse e.g. generation and storage units. In the current literature, a small number of models are openly available for grenhouse climate simulation and crop growth. Although researchers openly present model structures and simulation scenarios, an open-source simulation platform is still lacking. In fact, the most common climate simulation softwares are not open-access and are not able to handle the integration of greenhouses with other thermal systems. The goal of the Greenhouses library is to fill this gap.

For greenhouse-scale simulation, the proposed library includes the modeling of greenhouse construction elements, indoor climate, heating systems, ventilation systems and crop yield. To the end of performing system-scale simulations, the library includes performance-based models of several generation units e.g., combined heat and power (CHP) and heat pumps. The library also includes control systems for climate control (heating circuit, window's aperture, artificial illumination, etc.) and operation control of the HVAC units.

Explore the Examples package to get a feeling of the modeling possibility that the Greenhouse library offers!


### Documentation

The documentation is available on the main website: https://greenhouses-library.readthedocs.io


### License

The Greenhouses package is free software licensed under the 3-clause BSD License. It can be redistributed and/or modified under the terms of this license.


### Main developers

- Queralt Altes-Buch (qaltes@uliege.be - University of Liege, Energy Systems Research Unit, Belgium)

