﻿within Greenhouses.UsersGuide;
class Overview
  extends Modelica.Icons.Information;

  annotation (Documentation(info="<html>
  <p><big>The Greenhouse library aims at providing a fully open-source modelling framework for greenhouse climate simulation. The proposed library includes the modelling of greenhouse indoor climate, heating and ventilation systems, climate control systems and crop yield. The goal is to propose a modelling framework capable of simulating the complex interactions and energy flows relative to systems coupling the greenhouse, generation units and storage units. To that end, the library includes robust performance-based models of several generation units, e.g. CHP and heat pumps. </p>
<p><big>For greenhouse-scale simulation, the proposed library includes the modeling of greenhouse construction elements, indoor climate, heating systems, ventilation systems and crop yield. To the end of performing system-scale simulations, the library includes robust performance-based models of several generation units (e.g. CHP and heat pumps) as well as a model of thermal energy storage. The library also includes several pre-programmed control systems for climate control (heating circuit, window’s aperture, supplementary lighting, etc.) and operation control of the HVAC units.</p>
<p><big><br>The connectors used in the library are compatible with the interfaces of the Modelica Standard Library. </p>
</html>"));
end Overview;
