﻿within ;
package TILMedia "TILMedia-Library with thermophysical properties of Fluids and Solids"
  import Modelica.Units.SI;


// access=Access.nonPackageDuplicate

annotation (
preferredView="info",
   version="1.9.0 ClaRa",
   versionDate="2025-04-23",
   uses(Modelica(version="4.0.0")),
Documentation(info="<html>
<p><img src=\"modelica://TILMedia/Resources/Images/infoTILMedia.png\"></p>
</html>"),                 Icon(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={
                         Bitmap(
        extent={{-100,-100},{100,100}},
          imageSource="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",
          fileName="modelica://TILMedia/Resources/Images/TILMedia.png")}),
   Protection(access=Access.documentation,
      __Dymola_showVariables=true,
      __Dymola_showDiagnostics=true,
      __Dymola_showStatistics=true,
      __Dymola_showFlat=true),
	conversion(
    from(version={"1.8.2 ClaRa","1.8.1 ClaRa", "1.8.0 ClaRa", "1.7.0 ClaRa", "1.6.0 ClaRa"}, to="1.8.2 ClaRa_1",
     script="modelica://TILMedia/Resources/Scripts/Conversion/ConvertTILMedia_from_182_ClaRa.mos"),
    from(version={"1.8.2 ClaRa_1"}, to="1.8.2 ClaRa_2",
     script="modelica://TILMedia/Resources/Scripts/Conversion/ConvertTILMedia_from_182_ClaRa_1.mos"),
    from(version={"1.8.2 ClaRa_2"}, to="1.8.2 ClaRa_3",
     script="modelica://TILMedia/Resources/Scripts/Conversion/ConvertTILMedia_from_182_ClaRa_2.mos"),
    from(version={"1.8.2 ClaRa_3"},
     script="modelica://TILMedia/Resources/Scripts/Conversion/ConvertTILMedia_from_182_ClaRa_3.mos")));
end TILMedia;
