﻿within TILMedia.Solid;
model Solid "Solid model with T as independent variable"

  replaceable model SolidType = TILMedia.Solid.Types.BaseSolid      constrainedby TILMedia.Solid.Types.BaseSolid
                                  "type record of the solid"
    annotation(choicesAllMatching=true);

  constant SI.Density d = solid.d "Density";
  input SI.Temperature T "Temperature" annotation(Dialog);
  SI.SpecificHeatCapacity cp "Heat capacity";
  SI.ThermalConductivity lambda "Thermal conductivity";
  constant SI.SpecificHeatCapacity cp_nominal=solid.cp_nominal
    "Specific heat capacity at standard reference point";
  constant SI.ThermalConductivity lambda_nominal=solid.lambda_nominal
    "Thermal conductivity at standard reference point";
protected
  SolidType solid(final T=T);
equation
   cp = solid.cp;
   lambda = solid.lambda;

  annotation (defaultComponentName="solid", Icon(graphics={Text(
          extent={{-120,-60},{120,-100}},
          lineColor={165,165,165},
          textString=
               "%name"), Bitmap(
          extent={{-100,-100},{100,100}},
          imageSource=
              "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",
          fileName="modelica://TILMedia/Resources/Images/Icon_Solid_T.png")}),
    Protection(access=Access.packageDuplicate),
          Documentation(info="<html>
                   <p>
                   The solid model calculates the thermopyhsical property data with given input: temperature (T) and the model SolidType.<br>
                   The interface and the way of using, is demonstrated in the Testers -&gt; <a href=\"modelica://TILMedia.Testers.TestSolid\">TestSolid</a>.
                   </p>
                   </html>"));
end Solid;
