﻿within TILMedia.Internals;
package ClassTypes "Icon definitions"
  partial class ComponentPackage
    annotation (Icon(graphics={
          Rectangle(
            extent={{-100,-100},{80,50}},
            lineColor={0,0,0},
            fillColor={153,204,0},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-100,50},{-80,70},{100,70},{80,50},{-100,50}},
            lineColor={0,0,0},
            fillColor={153,204,0},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{100,70},{100,-80},{80,-100},{80,50},{100,70}},
            lineColor={0,0,0},
            fillColor={153,204,0},
            fillPattern=FillPattern.Solid)}));
  end ComponentPackage;

  partial class GasComponentPackage
    annotation (Icon(graphics={Bitmap(extent={{
                -100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_Gas.png")}));

  end GasComponentPackage;

  partial class LiquidComponentPackage
    annotation (Icon(graphics={Bitmap(extent={{
                -100,-100},{100,100}},
            imageSource="iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAYAAACtWK6eAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAC/9JREFUeNrsnc9rHOcZgGfLOmApJLIcLB+CsxUUkoOwIC3YJ8tYtwWrvrqU4j/ABx11aguiV6tX+xD14mslwx4KElmTg3Up2SBIcgj2yqfasZ21iRqwLp13NCPPbnd2v29+7ffN9zwwzHotrVYz++h93++n5wEAAKShxiXIRrPZXBp4qtdqtTpcGQRxVYiGfxIpVsLzzIgv74aH8DASyD8igTq+TD2uKoLYLsWif/p9KMViQT+mHZPqYOA5ohKCGCXETCjElfA8Y9Db64RRKB6V4pGKqIQghUUJSZn+VGCUKJN4KkdUQpBUUSJeSzQc/hwQlRCkL0pEUkD6qCTn14P1ky9SF0HskiJeSzT4jJceleT4ZjAq+SK1EWQyQjQGCmwgKrktSNhZt0KUICohiKfdWQfu0dfAEEalvlY91ahUs0iKuBBGNcNeunTJm5+fDx7v7+8H58PDQ+/x48d8VM2nHUv1pAVvKy5PzWAhjO2sm5ubC6RYWFgIzuMQUUSYuEDPnz/3nj171vccGMMtX5JN4wQpaUhHKiIZ5BxFi7yJR51xUkHh3PAl2apNWIh4Z51xUSIuxfT0tFF3LxIoLhVRKVdkpMGZ2gSkMLazTiLDtWvXCo0SZUNUysTVWglCGDukQ6LC5cuXTyKFaVHChKg0TCqXapFaQVI0PEM76yQyiAzxlifQIx51xqV6RJB3Uhg5pEOigkSIKFKcO3eOT3iJDGv2tigqpRdkoLPOuCgRL7CBqFSKIKZ31hEl3IhI6+vrJxGoaEHqGlFCztZ21oHd7O7uevfv3y89itSHSGFsZ10khEQKokT1kSixt7c3ETH+T5BQjH+aVGCb3lkHxYmxvb0dHCWlUkn0ajE5vjQhhSpjSAeYW6hLtHj06NGkxQhotVq1KIJ8MUk5onri5s2bRAkHkZaqBw8eeDs7O4Wn6E+ePNFK12ph9PjapAsmkUNEEXGk1ojO8hxRpTpIi5REjKL7QpaXl4M/vvIZWltbU/55UQRZNPEvSnQBR6Vi8fOgVGAu0iIl9UWR82XksyBirKysZPo8iCBWLucSyZMkURRt4lFnUCYoX4yiW6TkvooUcuRxj60VRKUlJJJHmgqTap+kFI4e+PzuQxktUnIPJY2S0dh5Unf55slfMjlUUrnBFI56aDTSIiVSSOFdpBhyfySVUhVDo97pOi9Inqkc9dA7MSSNKrpFSq61RIwCIz2C5J3KJUk0KoWrSipXZovU9evXS4veIggLGJeUyo2qh5JSONNTOfl9JJUqUoxoYlvUVFsmdVmUuNlsKn3xy/Ofed/+7g/eqbf/9U7//MKbOnzh1d8eeh+8ehr8/9n/fIcNKdFp2o6LM6lUzsYWqVKK9Dezn4z9mkgUEefUkcj0YyCUiPXBqwNsKLEeyrNpO2qREjmKFCNqkTJhGnQhNYhEmvh5kLgoZ599H8p04Eej4+fl/6GcekilaVsKbym6bW2qjV8fIwQZx9F7U2MlClI4P/KINB/+dJzCzYaRiVSunHpIzvKhqkCLVF8aq0gnLkjXUxjmXuYH85f3PwqO4KZe+Pz4yYs3+r4mijaD9RCpXPH1UB5E/ReGtuS91hbENNLUQ1EqNxXWRVA+8cGDplP5fpA09dDsiVTUQ3lhQosUguRVDw2kclE9RNN2usJb0ijbxECQlPVQElG0oWn7nRhFtkiVLYjyiF652Sq5v2tE1yQplYtHm8Gm7SrVQ1JwS7QwcaUZaa5OK4hsZ6W0+Bs5eXH10KimbdPrIRFCxDB5bJlm52abFMvgVE63aXtS9ZBNLVLUIA6lcqNIGuqTZyonkWJ1dbXyw/kRxMFULmmoj8ij2qDgyhKvKYr0pyMLUTCfpKE+Enku/etvXKAYvwrPynNCJGQDuCYIQOXRHKzYQxBwCp3h7q1Wq4MgAHmnWNJkCOCUIH44aasLwhBxIIIAAIIAIAhAgO6yo6kEmaJIh+ozVBCl3nSKdHA1xepxOQCoQSCBaGSvCq5s/YAgkApXduhKJQjTbsHFFEt5yDurFoJtaK4S2RkmyGsuI0C/C9QgABTpAAgCUKggXdVv0mkvB3BOEADbSLszFikWOIHmgg1tBAEgggBMoAaZZdMYcE2QVqtFkQ5AigWAIAB9aO4u1UMQcAqd3aWiZUeHCaI07Zbh7tVEp/HF1RmFSnNCmDAFzCgEAAQBQBCAsgWhUAeb0Bis2BslyEPVV6FQB5vQGO7eIcUCoAYBQBAAMwVhlXdwUZC26jdOHSIIEEEArEdz2dEuggAkc4AgAEWnWPW3h1w9cE4QjS0QnnL1wC1BWq0W+xQ6DMOHckyxoHqoDkBdWFiw6vdKu+wogoATaC47ms9gRcIxVJTeOEGUCnXmg4CrNQiFOgA1CACCACAIwCg0lx0dK0hX9ZvPsg0CWIDmsqPtcYLQPAVAigWAIAAIAlCmIModhQx5BxcFUZ4TcuqI8VhgPmmXHSXFAidIu+woggBQpINSusz0hSKKdPoUq4LOvbRtRmGugsR3+BxHnb86QIoFgCAAlSTLsqMIAtDPQa6CTP38I5cUnEyx2irfzB4hQA0CgCAAgCDgHFmWHc1FEOoQMJksy46OEuSh6ivSkgUVguHuANQgAAgCYIEgjOgFFwVRHvL+4U8s3ADmkmXZ0VGCsAWCY1S1uT7LsqPUIHDC1KG6IE7PKAQABAHIJEhX9QVm2QIBDEWGmWgONVETxC9WulxesJm9vT1vbW0t82DFOpcSqsbu7q53584d3W/rUYMAciTTQRBAjhwFUapD2KcQKiCHpFd/161BRJAGlx5MZ2Njw9vZ2ckix42khimKdHBdjqujltulBgHkGAGCAHKMoD7mRZSQpfPfzH7CXYPCkY4/KcalI7BoOcZFkG9UfyKbr0BZckjveAY5RIpf62zxQYoFVsmRYWxVJ4wcWnOdEASQA0FgHKc11jebnp4u7X3JlNlJyTFOEI0inXnp9guiPqNwfn6+lPckUty+fTuLHFtZ5BDqY8xTK9KPKNIhfzkyDlff9MW4lfV9kGIBciAIIEf+KRZAqciI3Lt37xojR26CnGaFd8hBjgzD1YVbvhybeb+vxBRr2CJayYKwRwhUTw5qEEAOahAwle3tbe/evXvGypGbILLL1NzTfwcjen95/yPuPIwlh+HqIsdW0e8zpyL9hffbLzeCx0fvTQWivDr/mff6zAWkgSLkuKozIrdIQeRNLOq8oAx9l4Uc4os5IA3YKIeKILlsgzBMGhFERJHj5dynwVlEAuQwRY6JFumSlskhtctvkKbSSMff+vq6t7+/n/Ylut7xyiOdst+7Ua1YSdK89FOzN2dEnAvBY7BLjkkOVy9aENkvfWnS0nz8w1f+o69OnjuOMheQBjkmLsimf/zZtAsvi0TIkSTNy/OfsogEchQviKw212w2ZfDXF6bfkGHSBKlZLNIgzejrp4LKbEKZBSg1h+1yKNUg0lPpS9ILJZmx6aYPtpwhTTKqK9OMm02Yx3B1/1g1QQ7lIj3ssdzyRZF6RPpFLoa1ScO2DwJ9NMVh2lyO0gSJidL2T+3o374wM6EwS6E0i7ZJQ8cmcuQmyBBheqEwTklDH40bcmQWREOaRiiKHFfC84yt0tCx+Y4cZgFu+J+ZVVN/v1I6CsO9F+TYqpI0KqMBqtxHY/pcDmsESSHNlVia5tkuTRU7Nl2QQ6iZ/gZ9aaIoc9FWaYZhmjTNf/xR6esWFha85eVlJ+SwQhAFaZY8zSH5JksTjAKYQB+NqiDSUZhx73Fr5LBWkARplgYiTSWkKatjU1WQDER7AbZtuv6VEcRVaeRxHn00BQsykbkcCJJemiXP0j6aYeTRsVmgINbK4aQgQ4SxvmMzD2kKEsRqORBEXRo5z9j+e43q2CxAkK43oVmACDIZaRqe5R2bo6SRfpscMWa4OoIgjWlURg4EKUaaSnZsuigHgiANciCI8dJc8ezvo9n0DJoFiCDVlWbJs69j09i5HAjinjTyuIEcCALJwpjSsVl5ORAEadLyV1+Ov7hwbRGk2tIsefn30Vg1XB1BQEeahpetY9MpORAEVKc5d73jZtwt164PgsAwafoii22TnAAAACbP/wQYAKA1XoSOwbdVAAAAAElFTkSuQmCC",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_Liquid.png")}));

  end LiquidComponentPackage;

  partial class VLEFluidComponentPackage
    annotation (Icon(graphics={Bitmap(extent={{
                -100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_VLEFluid.png")}));

  end VLEFluidComponentPackage;

  partial class HeatExchangerComponentPackage
    annotation (Icon(graphics={Bitmap(extent={{
                -100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_HeatExchangers.png")}));

  end HeatExchangerComponentPackage;

  partial class OtherComponentPackage
    annotation (Icon(graphics={
          Bitmap(extent={{-100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_OtherComponents.png")}));

  end OtherComponentPackage;

  partial class ExamplePackage
    annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_Examples.png")}));

  end ExamplePackage;

  partial class InternalPackage
    annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_Internals.png")}));

  end InternalPackage;

  partial class ModelPackage
    annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Resources/Images/Icon_Package_Empty.png")}));

  end ModelPackage;

  partial record Record "Partial Record"
    annotation (Icon(graphics={        Text(
            extent={{-100,110},{100,70}},
            lineColor={0,0,0},
            textString=
                 "%name"), Bitmap(
            extent={{-100,-100},{100,100}},
            imageSource="iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAYAAACtWK6eAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA8NJREFUeNrs3cFt2lAcwOHXKFIi5VArl+SYDWADfMwWMEI3cLJBRigjZAPYwGxANvAGqY2aqFKgwQ4E+73vk1BPRNTmJ/v9MfjH6+trALY7swlAICAQEAgIBAQCAgGBgEBAIIBAQCAgEBAICAQEAgIBgYBAQCCAQEAgIBAQCAgEBAICAYGAQACBgEBAICAQEAgIBAQCAgGBgECAbc5P/QIeHx8f6n8Ku+IkVvUjL4qisikcQfhoVD+ebAaBsNv071EcgbBDUUcysxkEwm5PdSRjm0EgbPezfizqSDKbQiCIRCB0YrIlED5hsiUQPmGyFXrwSfq+JpNJyPPc27aF9Xod5vP5V/5EM9kqi6IoHUHAol0giEQgHFqyky2BsK8kJ1sCoY3kJlsCoa2krtkSCOHsrNXbIKlFu0AI19fXbZ+STCQCIVxdXW0+iG0picmWQNhorlIYjUZtnxb9ZEsgvLu/vw83Nzdtnxb1ZEsgvLu8vAyz2SxcXFy0fWq0ky2BcIhIol20C4QPbm9vN6dbLUUZiUDYajwem2wJhP8x2RIIn0h9siUQjrFob0Qx2RIIx4okikW7QNhLqpMtgbC3FCdbAqGV1CZbAqG1lCZbAuG7Fu2NwU22BMJ3RjK4Rft5aju2qqpQlmUy/9djeptsPT8/d4lkEPdGTDKQ5XLpEHAgzWSrwzZ9m2z1fk3iFIsvi3myJRAOItbJlkA45aK90evJlkA4dSS9nmwJhIOK7ZotgXBwMV2zJRCOIpbJ1rldycvLS6jfmH15Oc1ka10UxW9HENiuN5MtgdBHvVm0J3eKlWVZlwXkIDWXgKxWqyFH8qt+PAjkmwNJ5XbSzW2gBxxILzjFAoGAQEAgIBDoCZ+kR+zu7i4URdG717VYLAbzrU5HEBAICAQEAgIBgYBAQCAgEBAIIBAQCAgEBAICAYGAQEAgkILkvnLb/JjafD635zuYTqebr/E6ggACAYGAQEAgIBAQCAgEBAICAYEAHyR3LVZfbwmAIwgIBAQCAgEEAgIBgYBAQCAgEBAICAQEAgIBBAICAYGAQEAgIBAQCAgEBAICAXZJ7ofjqqoKZVna8x2Mx+OQZZlAYg9kuVx6t3fQ/CplaoE4xQKBgEBAICAQEAgIBAQCAgGBAP9K7lKT5lKJyWRiz3fcdgJJYCfnee7djlMsEAgIBAQCAgGBgEBAICAQQCAgEBAICAQEAgIBgYBAQCCAQEAgIBAQCAgEBAICgRgM5pcVmzvTujstjiAgEBAICAQEAgIBBAICAYHA0f0RYABzbuCi+dNNSwAAAABJRU5ErkJggg==",
            fileName="modelica://TILMedia/Resources/Images/Icon_Record.png")}));

  end Record;

  partial class Information
    annotation (Icon(graphics={Bitmap(
            extent={{-100,-100},{100,100}},
            imageSource=
                "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",
            fileName="modelica://TILMedia/Resources/Images/Icon_UserGuide.png")}));

  end Information;

  partial class ExampleModel
    annotation (Icon(graphics={Bitmap(
            extent={{-100,-100},{100,100}},
            imageSource=
                "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",
            fileName="modelica://TILMedia/Resources/Images/ModelIcon_Example.png")}));

  end ExampleModel;
  annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
          imageSource=
              "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",
          fileName="modelica://TILMedia/Resources/Images/Icon_Package_Internals.png")}));

end ClassTypes;
