within AixLib.DataBase.ThermalZones.SwimmingFacility;
record Supervisory "Swimming facility - Supervisory and control rooms"
    extends AixLib.DataBase.ThermalZones.ZoneBaseRecord(
    T_start = 297.15,
    withAirCap = true,
    VAir = 68.89999999999999,
    AZone = 21.2,
    hRad = 4.999999999999999,
    lat = 0.88645272708792,
    nOrientations = 4,
    AWin = {0.001, 0.001, 0.001, 0.001},
    ATransparent = {0.001, 0.001, 0.001, 0.001},
    hConWin = 2.7,
    RWin = 270.27027027027026,
    gWin = 0.67,
    UWin= 0.7993916878977319,
    ratioWinConRad = 0.03,
    AExt = {0.001, 0.001, 0.001, 0.001},
    hConExt = 2.7,
    nExt = 1,
    RExt = {10.664752311364285},
    RExtRem = 1024.4504550619076,
    CExt = {1626.642854262106},
    AInt = 137.79999999999998,
    hConInt = 2.7,
    nInt = 1,
    RInt = {0.0014456968398831363},
    CInt = {17697707.833017103},
    AFloor = 0.001,
    hConFloor = 1.7000000000000002,
    nFloor = 1,
    RFloor = {65.54024148262194},
    RFloorRem =  2559.567098070036,
    CFloor = {517.4457860142643},
    ARoof = 0.001,
    hConRoof = 1.7000000000000002,
    nRoof = 1,
    RRoof = {28.798350233124722},
    RRoofRem = 6416.042125957352,
    CRoof = {29.96939310148077},
    nOrientationsRoof = 1,
    tiltRoof = {0.0},
    aziRoof = {0.0},
    wfRoof = {1.0},
    aRoof = 0.5,
    aExt = 0.5,
    TSoil = 286.15,
    hConWallOut = 20.0,
    hRadWall = 5.0,
    hConWinOut = 20.0,
    hConRoofOut = 20.000000000000007,
    hRadRoof = 5.0,
    tiltExtWalls = {1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966},
    aziExtWalls = {0.0, 1.5707963267948966, -1.5707963267948966, 3.141592653589793},
    wfWall = {0.25, 0.25, 0.25, 0.25},
    wfWin = {0.25, 0.25, 0.25, 0.25},
    wfGro = 0.0,
    specificPeople = 0.3333333333333333,
    internalGainsMoistureNoPeople = 0.5,
    fixedHeatFlowRatePersons = 70,
    activityDegree = 1.2,
    ratioConvectiveHeatPeople = 0.5,
    internalGainsMachinesSpecific = 2.0,
    ratioConvectiveHeatMachines = 0.75,
    lightingPowerSpecific = 15.9,
    ratioConvectiveHeatLighting = 0.9,
    useConstantACHrate = false,
    baseACH = 0.5,
    maxUserACH = 1.0,
    maxOverheatingACH = {3.0, 2.0},
    maxSummerACH = {1.0, 283.15, 290.15},
    winterReduction = {0.2, 273.15, 283.15},
    maxIrr = {100.0, 100.0, 100.0, 100.0},
    shadingFactor = {1.0, 1.0, 1.0, 1.0},
    withAHU = true,
    minAHU = 0.0,
    maxAHU = 12.0,
    hHeat = 100000.0,
    lHeat = 0,
    KRHeat = 10000,
    TNHeat = 300,
    HeaterOn = false,
    hCool = 0,
    lCool = -100000.0,
    KRCool = 10000,
    TNCool = 1,
    heaLoadFacOut=0,
    heaLoadFacGrd=0,
    CoolerOn = false,
    withIdealThresholds = false,
    TThresholdHeater = 288.15,
    TThresholdCooler = 295.15);
                                                                       annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)));
end Supervisory;
