within AixLib.DataBase.ThermalZones.MultizoneInterzonalsFixedHeater;
record MorschenichSfhFixedHeater_basement
  "Record for basement of MorschenichSfhFixedHeater"
  extends AixLib.DataBase.ThermalZones.ZoneBaseRecord(
    T_start = 293.15,
    withAirCap = true,
    VAir = 176.72156159931643,
    AZone = 79.60430702671911,
    hRad = 6.654164349463362,
    lat = 0.88645272708792,
    nOrientations = 4,
    AWin = {0.0, 0.0001, 0.0, 0.0},
    ATransparent = {0.0, 0.0001, 0.0, 0.0},
    hConWin = 2.7,
    RWin = 1871.4285714285713,
    gWin = 0.75,
    UWin= 2.8010185522008,
    ratioWinConRad = 0.020000000000000004,
    AExt = {6.418846336889531, 7.081167133233686, 6.419032155135023, 7.167126477220699},
    hConExt = 2.6999999999999993,
    nExt = 1,
    RExt = {0.004229837490597628},
    RExtRem = 0.02060924234483541,
    CExt = {5576900.6389134005},
    AInt = 81.6764,
    hConInt = 2.7000000000000006,
    nInt = 1,
    RInt = {0.00022719717562130076},
    CInt = {6212483.036120574},
    AFloor = 131.85521768744456,
    hConFloor = 0.8999999999999999,
    nFloor = 1,
    RFloor = {0.0008556017690475546},
    RFloorRem =  0.0036349634514251787,
    CFloor = {16730172.436092455},
    ARoof = 0.0,
    hConRoof = 0.0,
    nRoof = 1,
    RRoof = {0.0},
    RRoofRem = 0.0,
    CRoof = {0.0},
    nOrientationsRoof = 1,
    tiltRoof = {0},
    aziRoof = {0},
    wfRoof = {0},
    aRoof = 0.0,
    aExt = 0.5,
    nIze = 1,
    AIze = {79.60430702671911},
    hConIze = {0.8999999999999999},
    nIzeRC = 1,
    RIze = {{0.0060208915205140715}},
    RIzeRem = {0.0014172041906433724},
    CIze = {{10100425.349640682}},
    othZoneInd = {3},
    zoneInd = 2,
    TSoil = 286.15,
    TSoiDatSou = AixLib.BoundaryConditions.GroundTemperature.DataSourceGroTem.File,
    TSoiOffTim = 6004800,
    TSoiAmp = 0,
    TSoiFil = Modelica.Utilities.Files.loadResource("modelica://AixLib/Resources/LowOrder_ExampleData/t_soil_MorschenichSfhFixedHeater.txt"),
    hConWallOut = 19.999999999999996,
    hRadWall = 4.999999999999999,
    hConWinOut = 20.0,
    hConRoofOut = 0.0,
    hRadRoof = 0.0,
    tiltExtWalls = {1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966},
    aziExtWalls = {-0.47123889803846897, 1.0995574287564276, 2.670353755551324, -2.0420352248333655},
    wfWall = {0.23697871787139957, 0.2614310765818997, 0.23698557813370572, 0.26460462741299495},
    wfWin = {0.0, 1.0, 0.0, 0.0},
    wfGro = 0.0,
    specificPeople = 0.02,
    internalGainsMoistureNoPeople = 0.5,
    fixedHeatFlowRatePersons = 70,
    activityDegree = 1.2,
    ratioConvectiveHeatPeople = 0.5,
    internalGainsMachinesSpecific = 2.0,
    ratioConvectiveHeatMachines = 0.75,
    lightingPowerSpecific = 7.0,
    ratioConvectiveHeatLighting = 0.5,
    useConstantACHrate = true,
    baseACH = 1.0,
    maxUserACH = 1.0,
    maxOverheatingACH = {3.0, 2.0},
    maxSummerACH = {1.0, 283.15, 290.15},
    winterReduction = {0.2, 273.15, 283.15},
    maxIrr = {9999.9, 10000.0, 9999.9, 9999.9},
    shadingFactor = {1.0, 0.0, 1.0, 1.0},
    withAHU = false,
    minAHU = 0.3,
    maxAHU = 0.6,
    hHeat = 4206.03587151335,
    lHeat = 0,
    KRHeat = 10000,
    TNHeat = 1,
    HeaterOn = false,
    hCool = 0,
    lCool = -4206.03587151335,
    heaLoadFacOut = 93.56640313904289,
    heaLoadFacGrd = 173.13013872342532,
    KRCool = 10000,
    TNCool = 1,
    CoolerOn = false,
    withIdealThresholds = false,
    TThresholdHeater = 288.15,
    TThresholdCooler = 295.15);
end MorschenichSfhFixedHeater_basement;
