within AixLib.DataBase.ThermalZones.SwimmingFacility;
record Entrance "Swimming facility - Entrance hall"
   extends AixLib.DataBase.ThermalZones.ZoneBaseRecord(
    T_start = 294.15,
    withAirCap = true,
    VAir = 1528.3,
    AZone = 246.5,
    hRad = 5.0,
    lat = 0.88645272708792,
    nOrientations = 4,
    AWin = {0.001, 0.001, 172.25, 0.001},
    ATransparent = {0.001, 0.001, 172.25, 0.001},
    hConWin = 2.6999999999999997,
    RWin = 0.006276123382937199,
    gWin = 0.67,
    UWin= 0.7993916878977319,
    ratioWinConRad = 0.029999999999999992,
    AExt = {0.001, 0.001, 188.5, 0.001},
    hConExt = 2.7,
    nExt = 1,
    RExt = {0.00022630413969781447},
    RExtRem = 0.021738655725625746,
    CExt = {76656764.48924243},
    AInt = 135.25300000000001,
    hConInt = 2.7,
    nInt = 1,
    RInt = {0.0014729212996081136},
    CInt = {17370595.62800481},
    AFloor = 246.5,
    hConFloor = 1.7000000000000002,
    nFloor = 1,
    RFloor = {0.0002658833325867016},
    RFloorRem =  0.010383639343083312,
    CFloor = {127550386.25251614},
    ARoof = 246.5,
    hConRoof = 1.7000000000000002,
    nRoof = 1,
    RRoof = {0.00011682900703093194},
    RRoofRem = 0.026028568462301633,
    CRoof = {7387455.399515009},
    nOrientationsRoof = 1,
    tiltRoof = {0.0},
    aziRoof = {0.0},
    wfRoof = {1.0},
    aRoof = 0.5,
    aExt = 0.5,
    TSoil=286.15,
    hConWallOut = 20.0,
    hRadWall = 5.0,
    hConWinOut = 19.999999999999996,
    hConRoofOut = 20.000000000000007,
    hRadRoof = 5.0,
    tiltExtWalls = {1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966},
    aziExtWalls = {0.0, 1.5707963267948966, -1.5707963267948966, 3.141592653589793},
    wfWall = {5.304955358800656e-06, 5.304955358800656e-06, 0.9999840851339238, 5.304955358800656e-06},
    wfWin = {5.805414129216908e-06, 5.805414129216908e-06, 0.9999825837576122, 5.805414129216908e-06},
    wfGro = 0.0,
    specificPeople = 0.08333333333333333,
    internalGainsMoistureNoPeople = 0.5,
    fixedHeatFlowRatePersons = 70,
    activityDegree = 1.2,
    ratioConvectiveHeatPeople = 0.5,
    internalGainsMachinesSpecific = 0.0,
    ratioConvectiveHeatMachines = 0.75,
    lightingPowerSpecific = 4.4,
    ratioConvectiveHeatLighting = 0.9,
    useConstantACHrate = false,
    baseACH = 0.5,
    maxUserACH = 1.0,
    maxOverheatingACH = {3.0, 2.0},
    maxSummerACH = {1.0, 283.15, 290.15},
    winterReduction = {0.2, 273.15, 283.15},
    maxIrr = {100.0, 100.0, 100.0, 100.0},
    shadingFactor = {1.0, 1.0, 1.0, 1.0},
    withAHU = true,
    minAHU = 0.0,
    maxAHU = 0.0,
    hHeat = 100000.0,
    lHeat = 0,
    KRHeat = 10000,
    TNHeat = 300,
    HeaterOn = false,
    hCool = 0,
    lCool = -100000.0,
    KRCool = 10000,
    TNCool = 1,
    heaLoadFacOut=0,
    heaLoadFacGrd=0,
    CoolerOn = false,
    withIdealThresholds = false,
    TThresholdHeater = 288.15,
    TThresholdCooler = 295.15);
  annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)));
end Entrance;
