# This is an overview of AixLib related Publications

## Table of contents
1. [Building Physics](#buildingphysics)
1. [Building Systems](#buildingsystems)
1. [Heat Transfer](#heattransfer)
1. [District Heating and Cooling](#dhc)
1. [Fast HVAC](#fasthvac)
1. [Building Automation Systems](#bas)
1. [Photovoltaic System Model](#pv)


## Building Physics <a name="buildingphysics"></a>

### HOM (High Order Model)

#### The Modelica HouseModels Library: Presentation and Evaluation of a Room Model with the ASHRAE Standard 140
Constantin, Ana; Streblow, Rita; Müller, Dirk (2014)
In: Proceedings of the 10th International Modelica Conference, March 10 - 12, 2014, Lund, Sweden / ed.: Hubertus Tummescheit and Karl-Erik Arzen, Pages: 293-299  
[Info](http://www.ebc.eonerc.rwth-aachen.de/go/id/dncb/lidx/1/file/225819)  
ISBN: 978-91-7519-380-9     
DOI: 10.3384/ECP14096293   
URL: http://dx.doi.org/10.3384/ecp14096

#### Validation of a building model as part of the AixLib Modelica library for dynamic plant and building performance simulations
Xanthopoulou, Konstantina; Mehrfeld, Philipp; Kangowski, Paul; Lanzerath, Franz; Müller, Dirk (2021)
In: Energy and Buildings, Volume 250, Pages: 111248  
[Info](http://www.ebc.eonerc.rwth-aachen.de/go/id/dncb/lidx/1/file/225819)  
ISS: ISSN 0378-7788     
DOI: 10.1016/j.enbuild.2021.111248   
URL: https://doi.org/10.1016/j.enbuild.2021.111248

### ROM (Reduced Order Model)

#### Verification of a Low Order Building Model for the Modelica Library AixLib using ASHRAE Standard 140
Lauster, Moritz Robert; Constantin, Ana; Remmen, Peter; Fuchs, Marcus; Müller, Dirk
In: Proceedings of Building Simulation 2017: 15th Conference of IBPSA, BS2017, 2017-08-07 - 2017-08-09, San Francisco, USA / Editors: Charles S. Barnaby and Michael Wetter, Pages: 1149-1158  
ISBN: 978-1-7750520-0-5  
DOI: 10.26868/25222708.2017.303  

#### Comparison of Two Standard Simplified Thermal Building Models
Lauster, Moritz Robert; Constantin, Ana; Remmen, Peter; Fuchs, Marcus; Müller, Dirk (2013). Lausanne / Ecole Polytechnique Fédérale de Lausanne (2013). CISBAT 2013 - Cleantech for Smart Cities & Buildings. Page(s): 885-890.  
[Info](http://www.ebc.eonerc.rwth-aachen.de/go/id/dncb/lidx/1/file/225169)    
ISBN: 2839912805, 978-2-8399-1280-8, 978-2-8399-1281-5, 2839912813  
DOI: URL: http://dx.doi.org/10.5075/epfl-infoscience-190601

*Compariston between to approches according to ISO 13790 and VDI 6007*

#### Moisture in thermal zones: a dynamic modeling approach
Kremer, Martin Theodor; Mathis, Paul; Müller, Dirk (2021). In: 1st International Conference on Moisture in Buildings 2021, ICMB21, 2021-06-28 - 2021-06-29.
DOI: URL: https://doi.org/10.14293/ICMB210033

#### Effect of Reduced Air Change Rates on Indoor Air Quality and Air Conditioning Energy Consumption in Retail Buildings
Finkbeiner, Konstantin; Kremer, Martin Theodor; Ying, Xuchao; Rätz, Martin; Mathis, Paul; Müller, Dirk (2021). In: Building Simulation Conference 2021: 17th Conference of IBPSA, BS21, 2021-08-31 - 2021-09-03, Brügge, Belgium.
DOI: URL: https://doi.org/10.18154/RWTH-2021-09080


#### Analyzing the Energy-Saving Potential of Demand-Controlled Ventilation in Hospitals via Dynamic Building Simulations
Rätz, Martin; Kalliomäki, Petri; Mathis, Paul; Koskela, Hannu; Müller, Dirk (2020). In: 16th International Conference on Indoor Air Quality and Climate (Indoor air 2020) : online, 1 November 2020 / International Society of Indoor Air Quality and Climate (ISIAQ), Pages: 1026-1031.
ISBN: 978-1-71382-360-5 

### HOM and ROM

#### Comparison of Thermal Simulation Models with Different Levels of Detail for Non-Residential Buildings
Jansen, David; Richarz, Jan; Vaeßen, Dominik; Hering, Dominik; Müller, Dirk (2022). In: Proceedings of BauSim Conference 2022:  9th Conference of IBPSA-Germany and Austria, 2022, Weimar, Germany. [PDF](https://publications.ibpsa.org/proceedings/bausim/2022/papers/bausim2022_Jansen_David.pdf), [DOI:10.26868/29761662.2022.42](https://doi.org/10.26868/29761662.2022.42)
#### Not published yet
Currently only an internal report with the title "*Verification and Comparison of High and Low Order Building Models from the Modelica Library AixLib using ASHRAE Standard 140*".


## Building Systems <a name="buildingsystems"></a>

#### Structuring the building performance modelica library AixLib for open collaborative development
Fuchs, Marcus; Constantin, Ana; Lauster, Moritz; Remmen, Peter; Streblow, Rita; Müller, Dirk (2015). 14th International Conference of the International Building Performance Simulation Association , 14th IBPSA, 07.12.2015-09.12.2015, Hyderabad, India. [PDF](http://www.ibpsa.org/proceedings/BS2015/p2202.pdf), [Info](http://www.ebc.eonerc.rwth-aachen.de/cms/E-ON-ERC-EBC/Forschung/Publikationen/~dncb/Details/?file=540827&lidx=1)


#### Moisture Recovery - A Dynamic Modelling Approach
Kremer, Martin; Mathis, Paul; Müller, Dirk; Clima 2019, May 2019,[pdf](https://www.e3s-conferences.org/articles/e3sconf/pdf/2019/37/e3sconf_clima2019_01099.pdf), [DOI:10.1051/e3sconf/2019111101099](https://doi.org/10.1051/e3sconf/201911101099)

#### Modular hydronic subsystem models for testing and improving control algorithms of air-handling units
Kümpel, Alexander; Teichmann, Jens; Mathis, Paul; Müller, Dirk (2022).
In: Journal of building engineering, 2022,
[DOI:10.1016/j.jobe.2022.104439 ](https://doi.org/10.1016/j.jobe.2022.104439 )

## Heat Transfer <a name="heattransfer"></a>
### Underfloor Heating
#### Underfloor heating system model for building performance simulations
Göbel, Stephan; Schmitt, Elaine; Mehrfeld, Philipp; Müller, Dirk (2021)
In: Proceedings of 14th Modelica Conference 2021,
[DOI:10.3384/ecp21181343](https://doi.org/10.3384/ecp21181343)

## District Heating and Cooling <a name="dhc"></a>

#### Automated model generation and simplification for district heating and cooling networks
Mans, Michael; Blacha, Tobias; Remmen, Peter; Müller, Dirk; Modelica Conference 2019, p. 179-186, March 2019, [pdf](http://www.ep.liu.se/ecp/157/ecp19157.pdf), [DOI: 10.3384/ecp19157179](http://dx.doi.org/10.3384/ecp19157179)


## Fast HVAC <a name="fasthvac"></a>

#### FastHVAC : A Library for Fast Composition and Simulation of Building Energy Systems
Stinner, S., Schumacher, M., Finkbeiner, K., Streblow, R., & Müller, D. (2015). In: Proceedings of the International Modelica Conference, Versailles, France, September 21-23, pp. 921-927, DOI: [DOI: 10.3384/ecp15118921](http://dx.doi.org/10.3384/ecp15118921)


## Building Automation Systems <a name="bas"></a>

#### Hardware-in-the-Loop-Simulation of a Building Energy and Control System to Investigate Circulating Pump Control Using Modelica
Schneider, G. F., Oppermann, J., Constantin, A., Streblow, R., & Müller, D. (2015). In: Proceedings of the International Modelica Conference, Versailles, France, September 21-23, pp. 225-233, DOI: [DOI: 10.3384/ecp15118225](http://dx.doi.org/10.3384/ecp15118225)

## Photovoltaic System Model <a name="pv"></a>

#### Open-source photovoltaic model for early building planning processes: Modeling, application and validation
Maier, L.; Kratz, M.; Vering, C.; Mehrfeld, P.; Müller, D. (2022). In: Proceedings of the 17th International Building Performance Simulation Association (BS 2021),
Bruges, Belgium, September 1-3 2021. DOI: [DOI: 10.18154/RWTH-2021-09356](http://dx.doi.org/10.18154/RWTH-2021-09356)
