within AixLib.Utilities.IO.Files.Examples;
model CSVReader "Reader for csv files generated by CSVWriter"
  extends AixLib.Utilities.IO.Files.Examples.BaseClasses.PartialCSV;
  Modelica.Blocks.Sources.CombiTimeTable combiTimeTable(
    tableOnFile=true,
    fileName=Modelica.Utilities.Files.loadResource("modelica://AixLib//Resources/Data/Utilities/IO/Files/Examples/CSVReader/Data.txt"),
    columns={2,3},
    tableName="tab") "Reader for test.csv"
    annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
  annotation (
    Icon(coordinateSystem(preserveAspectRatio=false)),
    Diagram(coordinateSystem(preserveAspectRatio=false)),
    experiment(
      StartTime=-1.21,
      StopTime=10,
      Tolerance=1e-06),
    __Dymola_Commands(file="modelica://AixLib/Resources/Scripts/Dymola/Utilities/IO/Files/Examples/CSVReader.mos"
        "Simulate and plot"),
    Documentation(info="<html>
<p>
This model demonstrates how a <code>CombiTimeTable</code> can be used
to read a text file that contains a table. The text file is stored in
<code>AixLib//Resources/Data/Utilities/IO/Files/Examples/CSVReader/Data.txt</code>.
It has the format of a file that can be generated by
<a href=\"modelica://AixLib.Utilities.IO.Files.Examples.CSVWriter\">
AixLib.Utilities.IO.Files.Examples.CSVWriter</a>.
</p>
</html>", revisions="<html>
<ul>
<li>
January 8, 2022, by Michael Wetter:<br/>
Corrected documentation and changed file name of text file as it is not a csv file.<br/>
This is for
<a href=\"https://github.com/ibpsa/modelica-ibpsa/issues/1572\">#1572</a>.
</li>
<li>
July 10, 2018 by Michael Wetter:<br/>
Refactored implementation for
<a href=\"https://github.com/ibpsa/modelica-ibpsa/issues/983\">#983</a>.
</li>
<li>
May 14, 2018 by Filip Jorissen:<br/>
First implementation.
See <a href=\"https://github.com/ibpsa/modelica-ibpsa/issues/924\">#924</a>.
</li>
</ul>
</html>"),  
   __Dymola_LockedEditing="Model from IBPSA");
end CSVReader;
